/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.TlsEncryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

final class BcTlsRSAEncryptor
implements TlsEncryptor {
    private final BcTlsCrypto crypto;
    private final RSAKeyParameters pubKeyRSA;

    private static RSAKeyParameters checkPublicKey(RSAKeyParameters rSAKeyParameters) {
        if (null == rSAKeyParameters || rSAKeyParameters.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return rSAKeyParameters;
    }

    BcTlsRSAEncryptor(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters) {
        this.crypto = bcTlsCrypto;
        this.pubKeyRSA = BcTlsRSAEncryptor.checkPublicKey(rSAKeyParameters);
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
            pKCS1Encoding.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)this.pubKeyRSA, this.crypto.getSecureRandom()));
            return pKCS1Encoding.processBlock(byArray, n, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
        }
    }
}

