/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.exportimport.util.MultipleStepsExportProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.platform.Platform;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class DirExportProvider
extends MultipleStepsExportProvider<DirExportProvider> {
    private String dir;
    private File rootDirectory;

    public DirExportProvider(KeycloakSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    private File getRootDirectory() {
        if (this.rootDirectory == null) {
            this.rootDirectory = this.dir == null ? new File(Platform.getPlatform().getTmpDirectory(), "keycloak-export") : new File(this.dir);
            this.rootDirectory.mkdirs();
            this.logger.infof("Exporting into directory %s", (Object)this.rootDirectory.getAbsolutePath());
        }
        return this.rootDirectory;
    }

    public static boolean recursiveDeleteDir(File dirPath) {
        if (dirPath.exists()) {
            File[] files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    DirExportProvider.recursiveDeleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        if (dirPath.exists()) {
            return dirPath.delete();
        }
        return true;
    }

    @Override
    public void writeRealm(String fileName, RealmRepresentation rep) throws IOException {
        File file = new File(this.getRootDirectory(), fileName);
        try (FileOutputStream is = new FileOutputStream(file);){
            JsonSerialization.prettyMapper.writeValue((OutputStream)is, (Object)rep);
        }
    }

    @Override
    protected void writeUsers(String fileName, KeycloakSession session, RealmModel realm, List<UserModel> users) throws IOException {
        File file = new File(this.getRootDirectory(), fileName);
        FileOutputStream os = new FileOutputStream(file);
        ExportUtils.exportUsersToStream((KeycloakSession)session, (RealmModel)realm, users, (ObjectMapper)JsonSerialization.prettyMapper, (OutputStream)os);
    }

    @Override
    protected void writeFederatedUsers(String fileName, KeycloakSession session, RealmModel realm, List<String> users) throws IOException {
        File file = new File(this.getRootDirectory(), fileName);
        FileOutputStream os = new FileOutputStream(file);
        ExportUtils.exportFederatedUsersToStream((KeycloakSession)session, (RealmModel)realm, users, (ObjectMapper)JsonSerialization.prettyMapper, (OutputStream)os);
    }

    public void close() {
    }

    public DirExportProvider withDir(String dir) {
        this.dir = dir;
        return this;
    }
}

