/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"checkWasmInteropSignature", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isTypeSupportedInWasmInterop", "", "unexpandedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInFunctionReturnPosition", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
public final class FirWasmImportAnnotationCheckerKt {
    public static final void checkWasmInteropSignature(@NotNull FirFunction declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        for (FirValueParameter parameter : declaration.getValueParameters()) {
            ConeKotlinType type = FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
            if (parameter.getDefaultValue() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_PARAMETER_DEFAULT_VALUE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (parameter.isVararg()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_VARARG_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
            if (FirWasmImportAnnotationCheckerKt.isTypeSupportedInWasmInterop(type, false, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_UNSUPPORTED_PARAMETER_TYPE(), (Object)type, (DiagnosticContext)context2, null, 16, null);
        }
        ConeKotlinType returnType = FirTypeUtilsKt.getConeType(declaration.getReturnTypeRef());
        if (!FirWasmImportAnnotationCheckerKt.isTypeSupportedInWasmInterop(returnType, true, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_UNSUPPORTED_RETURN_TYPE(), (Object)returnType, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private static final boolean isTypeSupportedInWasmInterop(ConeKotlinType unexpandedType, boolean isInFunctionReturnPosition, FirSession session2) {
        ConeKotlinType type = TypeExpansionUtilsKt.fullyExpandedType$default(unexpandedType, session2, null, 2, null);
        if (ConeBuiltinTypeUtilsKt.isUnit(type)) {
            return isInFunctionReturnPosition;
        }
        return ConeBuiltinTypeUtilsKt.isPrimitive(type) && !ConeBuiltinTypeUtilsKt.isChar(type) || ConeBuiltinTypeUtilsKt.isUnsignedType(type);
    }
}

