/* flatpak_plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from flatpak_plugin.vala, do not modify */

/*
 *  pamac-vala
 *
 *  Copyright (C) 2019-2023 Guillaume Benoit <guillaume@manjaro.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a get of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pamac-flatpak.h"
#include <glib-object.h>
#include <flatpak.h>
#include <appstream.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PAMAC_TYPE_FLATPAK_PACKAGE_LINKED (pamac_flatpak_package_linked_get_type ())
#define PAMAC_FLATPAK_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinked))
#define PAMAC_FLATPAK_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinkedClass))
#define PAMAC_IS_FLATPAK_PACKAGE_LINKED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PACKAGE_LINKED))
#define PAMAC_IS_FLATPAK_PACKAGE_LINKED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_FLATPAK_PACKAGE_LINKED))
#define PAMAC_FLATPAK_PACKAGE_LINKED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinkedClass))

typedef struct _PamacFlatpakPackageLinked PamacFlatpakPackageLinked;
typedef struct _PamacFlatpakPackageLinkedClass PamacFlatpakPackageLinkedClass;
typedef struct _PamacFlatpakPackageLinkedPrivate PamacFlatpakPackageLinkedPrivate;
enum  {
	PAMAC_FLATPAK_PACKAGE_LINKED_0_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_LICENSE_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_URL_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_INSTALL_DATE_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_APP_NAME_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_APP_ID_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_LONG_DESC_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_LAUNCHABLE_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_ICON_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_SCREENSHOTS_PROPERTY,
	PAMAC_FLATPAK_PACKAGE_LINKED_NUM_PROPERTIES
};
static GParamSpec* pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PAMAC_TYPE_FLATPAK_PLUGIN (pamac_flatpak_plugin_get_type ())
#define PAMAC_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPlugin))
#define PAMAC_IS_FLATPAK_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN))
#define PAMAC_FLATPAK_PLUGIN_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PAMAC_TYPE_FLATPAK_PLUGIN, PamacFlatpakPluginIface))

typedef struct _PamacFlatpakPlugin PamacFlatpakPlugin;
typedef struct _PamacFlatpakPluginIface PamacFlatpakPluginIface;

#define PAMAC_TYPE_FLAT_PAK (pamac_flat_pak_get_type ())
#define PAMAC_FLAT_PAK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAMAC_TYPE_FLAT_PAK, PamacFlatPak))
#define PAMAC_FLAT_PAK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAMAC_TYPE_FLAT_PAK, PamacFlatPakClass))
#define PAMAC_IS_FLAT_PAK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAMAC_TYPE_FLAT_PAK))
#define PAMAC_IS_FLAT_PAK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAMAC_TYPE_FLAT_PAK))
#define PAMAC_FLAT_PAK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAMAC_TYPE_FLAT_PAK, PamacFlatPakClass))

typedef struct _PamacFlatPak PamacFlatPak;
typedef struct _PamacFlatPakClass PamacFlatPakClass;
typedef struct _PamacFlatPakPrivate PamacFlatPakPrivate;
enum  {
	PAMAC_FLAT_PAK_0_PROPERTY,
	PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY,
	PAMAC_FLAT_PAK_NUM_PROPERTIES
};
static GParamSpec* pamac_flat_pak_properties[PAMAC_FLAT_PAK_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _PamacFlatpakPackageLinked {
	PamacFlatpakPackage parent_instance;
	PamacFlatpakPackageLinkedPrivate * priv;
};

struct _PamacFlatpakPackageLinkedClass {
	PamacFlatpakPackageClass parent_class;
};

struct _PamacFlatpakPackageLinkedPrivate {
	FlatpakInstalledRef* installed_ref;
	FlatpakRemoteRef* remote_ref;
	AsComponent* as_app;
	FlatpakInstallation* installation;
	gchar* _name;
	gchar* _id;
	const gchar* _version;
	const gchar* _installed_version;
	const gchar* _app_name;
	gchar* _long_desc;
	const gchar* _launchable;
	gchar* _icon;
	GPtrArray* _screenshots;
};

struct _PamacFlatpakPluginIface {
	GTypeInterface parent_iface;
	gboolean (*refresh_appstream_data) (PamacFlatpakPlugin* self);
	void (*load_appstream_data) (PamacFlatpakPlugin* self);
	void (*get_remotes_names) (PamacFlatpakPlugin* self, GPtrArray** remotes_names);
	void (*search_flatpaks) (PamacFlatpakPlugin* self, const gchar* search_string, GPtrArray** pkgs);
	void (*search_uninstalled_flatpaks_sync) (PamacFlatpakPlugin* self, gchar** search_terms, gint search_terms_length1, GPtrArray** pkgs);
	gboolean (*is_installed_flatpak) (PamacFlatpakPlugin* self, const gchar* name);
	PamacFlatpakPackage* (*get_flatpak_by_app_id) (PamacFlatpakPlugin* self, const gchar* app_id);
	PamacFlatpakPackage* (*get_flatpak) (PamacFlatpakPlugin* self, const gchar* id);
	void (*get_installed_flatpaks) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	void (*get_category_flatpaks) (PamacFlatpakPlugin* self, const gchar* category, GPtrArray** pkgs);
	void (*get_flatpak_updates) (PamacFlatpakPlugin* self, GPtrArray** pkgs);
	gboolean (*trans_run) (PamacFlatpakPlugin* self, const gchar* sender, gchar** to_install, gint to_install_length1, gchar** to_remove, gint to_remove_length1, gchar** to_upgrade, gint to_upgrade_length1);
	void (*trans_cancel) (PamacFlatpakPlugin* self, const gchar* sender);
	void (*refresh) (PamacFlatpakPlugin* self);
	guint64 (*get_refresh_period) (PamacFlatpakPlugin* self);
	void (*set_refresh_period) (PamacFlatpakPlugin* self, guint64 value);
};

struct _PamacFlatPak {
	GObject parent_instance;
	PamacFlatPakPrivate * priv;
};

struct _PamacFlatPakClass {
	GObjectClass parent_class;
};

struct _PamacFlatPakPrivate {
	gchar* sender;
	FlatpakInstallation* installation;
	GPtrArray* stores_table;
	GRecMutex __lock_stores_table;
	GHashTable* remote_refs_table;
	GHashTable* pkgs_cache;
	GRecMutex __lock_pkgs_cache;
	GHashTable* categories_cache;
	GCancellable* cancellable;
	guint64 _refresh_period;
};

struct _Block1Data {
	int _ref_count_;
	PamacFlatPak* self;
	gchar* action;
	FlatpakTransactionOperation* operation;
	FlatpakTransactionProgress* progress;
};

static gint PamacFlatpakPackageLinked_private_offset;
static gpointer pamac_flatpak_package_linked_parent_class = NULL;
static gint PamacFlatPak_private_offset;
static gpointer pamac_flat_pak_parent_class = NULL;
static PamacFlatpakPluginIface * pamac_flat_pak_pamac_flatpak_plugin_parent_iface = NULL;

VALA_EXTERN GType pamac_flatpak_package_linked_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void pamac_package_set_name (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN void pamac_package_set_id (PamacPackage* self,
                           const gchar* value);
VALA_EXTERN void pamac_package_set_version (PamacPackage* self,
                                const gchar* value);
VALA_EXTERN void pamac_package_set_installed_version (PamacPackage* self,
                                          const gchar* value);
VALA_EXTERN void pamac_package_set_repo (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN void pamac_package_set_desc (PamacPackage* self,
                             const gchar* value);
VALA_EXTERN PamacFlatpakPackageLinked* pamac_flatpak_package_linked_new (FlatpakInstalledRef* installed_ref,
                                                             FlatpakRemoteRef* remote_ref,
                                                             AsComponent* as_app,
                                                             FlatpakInstallation* installation,
                                                             gboolean is_update);
VALA_EXTERN PamacFlatpakPackageLinked* pamac_flatpak_package_linked_construct (GType object_type,
                                                                   FlatpakInstalledRef* installed_ref,
                                                                   FlatpakRemoteRef* remote_ref,
                                                                   AsComponent* as_app,
                                                                   FlatpakInstallation* installation,
                                                                   gboolean is_update);
VALA_EXTERN PamacFlatpakPackage* pamac_flatpak_package_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void pamac_flatpak_package_linked_finalize (GObject * obj);
static GType pamac_flatpak_package_linked_get_type_once (void);
static void _vala_pamac_flatpak_package_linked_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_pamac_flatpak_package_linked_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType pamac_flatpak_plugin_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType pamac_flat_pak_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PamacFlatPak* pamac_flat_pak_new (guint64 refresh_period);
VALA_EXTERN PamacFlatPak* pamac_flat_pak_construct (GType object_type,
                                        guint64 refresh_period);
static void pamac_flat_pak_real_load_appstream_data (PamacFlatpakPlugin* base);
static void _g_object_unref0_ (gpointer var);
static gboolean pamac_flat_pak_refresh_remote_appstream_data (PamacFlatPak* self,
                                                       FlatpakRemote* remote);
static gint64 pamac_flat_pak_get_file_age (PamacFlatPak* self,
                                    GFile* file);
VALA_EXTERN guint64 pamac_flatpak_plugin_get_refresh_period (PamacFlatpakPlugin* self);
static gboolean pamac_flat_pak_real_refresh_appstream_data (PamacFlatpakPlugin* base);
static AsComponent* pamac_flat_pak_get_installed_ref_matching_app (PamacFlatPak* self,
                                                            FlatpakInstalledRef* installed_ref);
static AsComponent* pamac_flat_pak_get_remote_ref_matching_app (PamacFlatPak* self,
                                                         FlatpakRemoteRef* remote_ref);
static void pamac_flat_pak_real_get_remotes_names (PamacFlatpakPlugin* base,
                                            GPtrArray** remotes_names);
static void pamac_flat_pak_real_get_installed_flatpaks (PamacFlatpakPlugin* base,
                                                 GPtrArray** pkgs);
static gboolean pamac_flat_pak_real_is_installed_flatpak (PamacFlatpakPlugin* base,
                                                   const gchar* id);
static PamacFlatpakPackage* pamac_flat_pak_real_get_flatpak_by_app_id (PamacFlatpakPlugin* base,
                                                                const gchar* app_id);
static PamacFlatpakPackageLinked* pamac_flat_pak_get_flatpak_from_app (PamacFlatPak* self,
                                                                AsComponent* app);
static PamacFlatpakPackage* pamac_flat_pak_real_get_flatpak (PamacFlatpakPlugin* base,
                                                      const gchar* id);
static void pamac_flat_pak_real_search_flatpaks (PamacFlatpakPlugin* base,
                                          const gchar* search_string,
                                          GPtrArray** pkgs);
static void pamac_flat_pak_real_search_uninstalled_flatpaks_sync (PamacFlatpakPlugin* base,
                                                           gchar** search_terms,
                                                           gint search_terms_length1,
                                                           GPtrArray** pkgs);
static void pamac_flat_pak_real_get_category_flatpaks (PamacFlatpakPlugin* base,
                                                const gchar* category,
                                                GPtrArray** pkgs);
VALA_EXTERN PamacFlatpakPackage* pamac_flatpak_plugin_get_flatpak_by_app_id (PamacFlatpakPlugin* self,
                                                                 const gchar* app_id);
static void pamac_flat_pak_real_get_flatpak_updates (PamacFlatpakPlugin* base,
                                              GPtrArray** pkgs);
static gboolean pamac_flat_pak_on_add_new_remote (PamacFlatPak* self,
                                           FlatpakTransactionRemoteReason reason,
                                           const gchar* from_id,
                                           const gchar* remote_name,
                                           const gchar* url);
static void pamac_flat_pak_do_emit_script_output (PamacFlatPak* self,
                                           const gchar* message);
static gint pamac_flat_pak_on_choose_remote_for_ref (PamacFlatPak* self,
                                              const gchar* for_ref,
                                              const gchar* runtime_ref,
                                              gchar** remotes);
static void pamac_flat_pak_on_new_operation (PamacFlatPak* self,
                                      FlatpakTransactionOperation* operation,
                                      FlatpakTransactionProgress* progress);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void pamac_flat_pak_do_emit_action_progress (PamacFlatPak* self,
                                             const gchar* action,
                                             const gchar* status,
                                             gdouble progress);
static void __lambda4_ (Block1Data* _data1_);
static void ___lambda4__flatpak_transaction_progress_changed (FlatpakTransactionProgress* _sender,
                                                       gpointer self);
static gboolean pamac_flat_pak_on_operation_error (PamacFlatPak* self,
                                            FlatpakTransactionOperation* operation,
                                            GError* _error_,
                                            FlatpakTransactionErrorDetails detail);
static void pamac_flat_pak_do_emit_error (PamacFlatPak* self,
                                   const gchar* message,
                                   gchar** details,
                                   gint details_length1);
static gboolean pamac_flat_pak_real_trans_run (PamacFlatpakPlugin* base,
                                        const gchar* sender,
                                        gchar** to_install,
                                        gint to_install_length1,
                                        gchar** to_remove,
                                        gint to_remove_length1,
                                        gchar** to_upgrade,
                                        gint to_upgrade_length1);
static gboolean ___lambda5_ (PamacFlatPak* self);
static gboolean ____lambda5__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                                 gpointer self);
static gboolean _pamac_flat_pak_on_add_new_remote_flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                                               FlatpakTransactionRemoteReason reason,
                                                                               const gchar* from_id,
                                                                               const gchar* remote_name,
                                                                               const gchar* url,
                                                                               gpointer self);
static gint _pamac_flat_pak_on_choose_remote_for_ref_flatpak_transaction_choose_remote_for_ref (FlatpakTransaction* _sender,
                                                                                         const gchar* for_ref,
                                                                                         const gchar* runtime_ref,
                                                                                         gchar** remotes,
                                                                                         gpointer self);
static void _pamac_flat_pak_on_new_operation_flatpak_transaction_new_operation (FlatpakTransaction* _sender,
                                                                         FlatpakTransactionOperation* operation,
                                                                         FlatpakTransactionProgress* progress,
                                                                         gpointer self);
static gboolean _pamac_flat_pak_on_operation_error_flatpak_transaction_operation_error (FlatpakTransaction* _sender,
                                                                                 FlatpakTransactionOperation* operation,
                                                                                 GError* _error_,
                                                                                 FlatpakTransactionErrorDetails detail,
                                                                                 gpointer self);
VALA_EXTERN void pamac_flatpak_plugin_refresh (PamacFlatpakPlugin* self);
static void pamac_flat_pak_real_trans_cancel (PamacFlatpakPlugin* base,
                                       const gchar* sender);
static void pamac_flat_pak_real_refresh (PamacFlatpakPlugin* base);
static GObject * pamac_flat_pak_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _g_hash_table_unref0_ (gpointer var);
VALA_EXTERN void pamac_flatpak_plugin_load_appstream_data (PamacFlatpakPlugin* self);
VALA_EXTERN gboolean pamac_flatpak_plugin_refresh_appstream_data (PamacFlatpakPlugin* self);
VALA_EXTERN void pamac_flatpak_plugin_get_remotes_names (PamacFlatpakPlugin* self,
                                             GPtrArray** remotes_names);
VALA_EXTERN void pamac_flatpak_plugin_get_installed_flatpaks (PamacFlatpakPlugin* self,
                                                  GPtrArray** pkgs);
VALA_EXTERN gboolean pamac_flatpak_plugin_is_installed_flatpak (PamacFlatpakPlugin* self,
                                                    const gchar* name);
VALA_EXTERN PamacFlatpakPackage* pamac_flatpak_plugin_get_flatpak (PamacFlatpakPlugin* self,
                                                       const gchar* id);
VALA_EXTERN void pamac_flatpak_plugin_search_flatpaks (PamacFlatpakPlugin* self,
                                           const gchar* search_string,
                                           GPtrArray** pkgs);
VALA_EXTERN void pamac_flatpak_plugin_search_uninstalled_flatpaks_sync (PamacFlatpakPlugin* self,
                                                            gchar** search_terms,
                                                            gint search_terms_length1,
                                                            GPtrArray** pkgs);
VALA_EXTERN void pamac_flatpak_plugin_get_category_flatpaks (PamacFlatpakPlugin* self,
                                                 const gchar* category,
                                                 GPtrArray** pkgs);
VALA_EXTERN void pamac_flatpak_plugin_get_flatpak_updates (PamacFlatpakPlugin* self,
                                               GPtrArray** pkgs);
VALA_EXTERN gboolean pamac_flatpak_plugin_trans_run (PamacFlatpakPlugin* self,
                                         const gchar* sender,
                                         gchar** to_install,
                                         gint to_install_length1,
                                         gchar** to_remove,
                                         gint to_remove_length1,
                                         gchar** to_upgrade,
                                         gint to_upgrade_length1);
VALA_EXTERN void pamac_flatpak_plugin_trans_cancel (PamacFlatpakPlugin* self,
                                        const gchar* sender);
VALA_EXTERN void pamac_flatpak_plugin_set_refresh_period (PamacFlatpakPlugin* self,
                                              guint64 value);
static void pamac_flat_pak_finalize (GObject * obj);
static GType pamac_flat_pak_get_type_once (void);
static void _vala_pamac_flat_pak_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_pamac_flat_pak_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
pamac_flatpak_package_linked_get_instance_private (PamacFlatpakPackageLinked* self)
{
	return G_STRUCT_MEMBER_P (self, PamacFlatpakPackageLinked_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

PamacFlatpakPackageLinked*
pamac_flatpak_package_linked_construct (GType object_type,
                                        FlatpakInstalledRef* installed_ref,
                                        FlatpakRemoteRef* remote_ref,
                                        AsComponent* as_app,
                                        FlatpakInstallation* installation,
                                        gboolean is_update)
{
	PamacFlatpakPackageLinked * self = NULL;
	FlatpakInstalledRef* _tmp0_;
	FlatpakRemoteRef* _tmp1_;
	AsComponent* _tmp2_;
	FlatpakInstallation* _tmp3_;
	FlatpakInstalledRef* _tmp4_;
	g_return_val_if_fail (installation != NULL, NULL);
	self = (PamacFlatpakPackageLinked*) pamac_flatpak_package_construct (object_type);
	_tmp0_ = _g_object_ref0 (installed_ref);
	_g_object_unref0 (self->priv->installed_ref);
	self->priv->installed_ref = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote_ref);
	_g_object_unref0 (self->priv->remote_ref);
	self->priv->remote_ref = _tmp1_;
	_tmp2_ = _g_object_ref0 (as_app);
	_g_object_unref0 (self->priv->as_app);
	self->priv->as_app = _tmp2_;
	_tmp3_ = _g_object_ref0 (installation);
	_g_object_unref0 (self->priv->installation);
	self->priv->installation = _tmp3_;
	_tmp4_ = self->priv->installed_ref;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gboolean _tmp17_ = FALSE;
		_tmp5_ = flatpak_installed_ref_get_origin (installed_ref);
		_tmp6_ = flatpak_ref_format_ref ((FlatpakRef*) installed_ref);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s/%s", _tmp5_, _tmp7_);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp8_;
		_g_free0 (_tmp7_);
		_tmp9_ = flatpak_ref_get_name ((FlatpakRef*) installed_ref);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp11_;
		_tmp12_ = flatpak_installed_ref_get_appdata_version (installed_ref);
		_tmp13_ = _tmp12_;
		self->priv->_installed_version = _tmp13_;
		_tmp14_ = self->priv->_installed_version;
		if (_tmp14_ == NULL) {
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = flatpak_ref_get_commit ((FlatpakRef*) installed_ref);
			_tmp16_ = _tmp15_;
			self->priv->_installed_version = _tmp16_;
		}
		if (is_update) {
			AsComponent* _tmp18_;
			_tmp18_ = self->priv->as_app;
			_tmp17_ = _tmp18_ != NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			GPtrArray* as_releases = NULL;
			AsReleaseList* _tmp19_;
			GPtrArray* _tmp20_;
			GPtrArray* _tmp21_;
			_tmp19_ = as_component_get_releases_plain (as_app);
			_tmp20_ = as_release_list_get_entries (_tmp19_);
			as_releases = _tmp20_;
			_tmp21_ = as_releases;
			{
				GPtrArray* as_release_collection = NULL;
				guint as_release_index = 0U;
				as_release_collection = _tmp21_;
				for (as_release_index = 0; as_release_index < as_release_collection->len; as_release_index = as_release_index + 1) {
					AsRelease* as_release = NULL;
					as_release = (AsRelease*) g_ptr_array_index (as_release_collection, as_release_index);
					{
						AsRelease* _tmp22_;
						_tmp22_ = as_release;
						if (as_release_get_kind (_tmp22_) == AS_RELEASE_KIND_STABLE) {
							AsRelease* _tmp23_;
							const gchar* _tmp24_;
							_tmp23_ = as_release;
							_tmp24_ = as_release_get_version (_tmp23_);
							self->priv->_version = _tmp24_;
							break;
						}
					}
				}
			}
		} else {
			const gchar* _tmp25_;
			_tmp25_ = self->priv->_installed_version;
			self->priv->_version = _tmp25_;
		}
	} else {
		FlatpakRemoteRef* _tmp26_;
		_tmp26_ = self->priv->remote_ref;
		if (_tmp26_ != NULL) {
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			AsComponent* _tmp34_;
			_tmp27_ = flatpak_remote_ref_get_remote_name (remote_ref);
			_tmp28_ = _tmp27_;
			_tmp29_ = flatpak_ref_format_ref ((FlatpakRef*) remote_ref);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("%s/%s", _tmp28_, _tmp30_);
			_g_free0 (self->priv->_id);
			self->priv->_id = _tmp31_;
			_g_free0 (_tmp30_);
			_tmp32_ = flatpak_ref_get_name ((FlatpakRef*) remote_ref);
			_tmp33_ = g_strdup (_tmp32_);
			_g_free0 (self->priv->_name);
			self->priv->_name = _tmp33_;
			_tmp34_ = self->priv->as_app;
			if (_tmp34_ != NULL) {
				GPtrArray* as_releases = NULL;
				AsReleaseList* _tmp35_;
				GPtrArray* _tmp36_;
				GPtrArray* _tmp37_;
				_tmp35_ = as_component_get_releases_plain (as_app);
				_tmp36_ = as_release_list_get_entries (_tmp35_);
				as_releases = _tmp36_;
				_tmp37_ = as_releases;
				{
					GPtrArray* as_release_collection = NULL;
					guint as_release_index = 0U;
					as_release_collection = _tmp37_;
					for (as_release_index = 0; as_release_index < as_release_collection->len; as_release_index = as_release_index + 1) {
						AsRelease* as_release = NULL;
						as_release = (AsRelease*) g_ptr_array_index (as_release_collection, as_release_index);
						{
							AsRelease* _tmp38_;
							_tmp38_ = as_release;
							if (as_release_get_kind (_tmp38_) == AS_RELEASE_KIND_STABLE) {
								AsRelease* _tmp39_;
								const gchar* _tmp40_;
								_tmp39_ = as_release;
								_tmp40_ = as_release_get_version (_tmp39_);
								self->priv->_version = _tmp40_;
								break;
							}
						}
					}
				}
			}
		}
	}
	return self;
}

PamacFlatpakPackageLinked*
pamac_flatpak_package_linked_new (FlatpakInstalledRef* installed_ref,
                                  FlatpakRemoteRef* remote_ref,
                                  AsComponent* as_app,
                                  FlatpakInstallation* installation,
                                  gboolean is_update)
{
	return pamac_flatpak_package_linked_construct (PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, installed_ref, remote_ref, as_app, installation, is_update);
}

static const gchar*
pamac_flatpak_package_linked_real_get_name (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_name (PamacPackage* base,
                                            const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_id (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_id (PamacPackage* base,
                                          const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_version (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_version;
	result = _tmp0_;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_version (PamacPackage* base,
                                               const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	self->priv->_version = value;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_installed_version (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_installed_version;
	result = _tmp0_;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_installed_version (PamacPackage* base,
                                                         const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	self->priv->_installed_version = value;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_repo (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	FlatpakInstalledRef* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->installed_ref;
	if (_tmp0_ != NULL) {
		FlatpakInstalledRef* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->installed_ref;
		_tmp2_ = flatpak_installed_ref_get_origin (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		FlatpakRemoteRef* _tmp3_;
		_tmp3_ = self->priv->remote_ref;
		if (_tmp3_ != NULL) {
			FlatpakRemoteRef* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp4_ = self->priv->remote_ref;
			_tmp5_ = flatpak_remote_ref_get_remote_name (_tmp4_);
			_tmp6_ = _tmp5_;
			result = _tmp6_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_repo (PamacPackage* base,
                                            const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_license (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	AsComponent* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->as_app;
	if (_tmp0_ != NULL) {
		AsComponent* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->as_app;
		_tmp2_ = as_component_get_project_license (_tmp1_);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_url (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	AsComponent* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->as_app;
	if (_tmp0_ != NULL) {
		AsComponent* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->as_app;
		_tmp2_ = as_component_get_url (_tmp1_, AS_URL_KIND_HOMEPAGE);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static guint64
pamac_flatpak_package_linked_real_get_installed_size (PamacPackage* base)
{
	guint64 result;
	PamacFlatpakPackageLinked* self;
	FlatpakInstalledRef* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->installed_ref;
	if (_tmp0_ != NULL) {
		FlatpakInstalledRef* _tmp1_;
		_tmp1_ = self->priv->installed_ref;
		result = flatpak_installed_ref_get_installed_size (_tmp1_);
		return result;
	} else {
		FlatpakRemoteRef* _tmp2_;
		_tmp2_ = self->priv->remote_ref;
		if (_tmp2_ != NULL) {
			FlatpakRemoteRef* _tmp3_;
			_tmp3_ = self->priv->remote_ref;
			result = flatpak_remote_ref_get_installed_size (_tmp3_);
			return result;
		}
	}
	result = (guint64) 0;
	return result;
}

static guint64
pamac_flatpak_package_linked_real_get_download_size (PamacPackage* base)
{
	guint64 result;
	PamacFlatpakPackageLinked* self;
	FlatpakRemoteRef* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->remote_ref;
	if (_tmp0_ != NULL) {
		FlatpakRemoteRef* _tmp1_;
		guint64 _tmp2_;
		guint64 _tmp3_;
		_tmp1_ = self->priv->remote_ref;
		_tmp2_ = flatpak_remote_ref_get_download_size (_tmp1_);
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	}
	result = (guint64) 0;
	return result;
}

static GDateTime*
pamac_flatpak_package_linked_real_get_install_date (PamacPackage* base)
{
	GDateTime* result;
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	result = NULL;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_app_name (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	const gchar* _tmp4_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_app_name;
	if (_tmp0_ == NULL) {
		AsComponent* _tmp1_;
		_tmp1_ = self->priv->as_app;
		if (_tmp1_ != NULL) {
			AsComponent* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = self->priv->as_app;
			_tmp3_ = as_component_get_name (_tmp2_);
			self->priv->_app_name = _tmp3_;
		}
	}
	_tmp4_ = self->priv->_app_name;
	result = _tmp4_;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_app_id (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	AsComponent* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->as_app;
	if (_tmp0_ != NULL) {
		AsComponent* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->as_app;
		_tmp2_ = as_component_get_id (_tmp1_);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_desc (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	AsComponent* _tmp0_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->as_app;
	if (_tmp0_ != NULL) {
		AsComponent* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->as_app;
		_tmp2_ = as_component_get_summary (_tmp1_);
		result = _tmp2_;
		return result;
	}
	result = NULL;
	return result;
}

static void
pamac_flatpak_package_linked_real_set_desc (PamacPackage* base,
                                            const gchar* value)
{
	PamacFlatpakPackageLinked* self;
	self = (PamacFlatpakPackageLinked*) base;
	g_object_notify_by_pspec ((GObject *) self, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY]);
}

static const gchar*
pamac_flatpak_package_linked_real_get_long_desc (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	const gchar* _tmp0_;
	const gchar* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_long_desc;
	if (_tmp0_ == NULL) {
		AsComponent* _tmp1_;
		_tmp1_ = self->priv->as_app;
		if (_tmp1_ != NULL) {
			{
				gchar* _tmp2_ = NULL;
				AsComponent* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp3_ = self->priv->as_app;
				_tmp4_ = as_component_get_description (_tmp3_);
				_tmp5_ = as_markup_convert (_tmp4_, AS_MARKUP_KIND_MARKDOWN, &_inner_error0_);
				_tmp2_ = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp6_ = _tmp2_;
				_tmp2_ = NULL;
				_g_free0 (self->priv->_long_desc);
				self->priv->_long_desc = _tmp6_;
				_g_free0 (_tmp2_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp7_;
				const gchar* _tmp8_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->message;
				g_warning ("flatpak_plugin.vala:138: %s", _tmp8_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp9_ = self->priv->_long_desc;
	result = _tmp9_;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_launchable (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp10_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp1_ = self->priv->_launchable;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AsLaunchable* as_launchable = NULL;
		AsComponent* _tmp3_;
		AsLaunchable* _tmp4_;
		AsLaunchable* _tmp5_;
		_tmp3_ = self->priv->as_app;
		_tmp4_ = as_component_get_launchable (_tmp3_, AS_LAUNCHABLE_KIND_DESKTOP_ID);
		as_launchable = _tmp4_;
		_tmp5_ = as_launchable;
		if (_tmp5_ != NULL) {
			GPtrArray* entries = NULL;
			AsLaunchable* _tmp6_;
			GPtrArray* _tmp7_;
			GPtrArray* _tmp8_;
			_tmp6_ = as_launchable;
			_tmp7_ = as_launchable_get_entries (_tmp6_);
			entries = _tmp7_;
			_tmp8_ = entries;
			{
				GPtrArray* entry_collection = NULL;
				guint entry_index = 0U;
				entry_collection = _tmp8_;
				for (entry_index = 0; entry_index < entry_collection->len; entry_index = entry_index + 1) {
					const gchar* entry = NULL;
					entry = (const gchar*) g_ptr_array_index (entry_collection, entry_index);
					{
						const gchar* _tmp9_;
						_tmp9_ = entry;
						self->priv->_launchable = _tmp9_;
						break;
					}
				}
			}
		}
	}
	_tmp10_ = self->priv->_launchable;
	result = _tmp10_;
	return result;
}

static const gchar*
pamac_flatpak_package_linked_real_get_icon (PamacPackage* base)
{
	const gchar* result;
	PamacFlatpakPackageLinked* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp26_;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp1_ = self->priv->_icon;
	if (_tmp1_ == NULL) {
		AsComponent* _tmp2_;
		_tmp2_ = self->priv->as_app;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GPtrArray* icons = NULL;
		AsComponent* _tmp3_;
		GPtrArray* _tmp4_;
		GPtrArray* _tmp5_;
		_tmp3_ = self->priv->as_app;
		_tmp4_ = as_component_get_icons (_tmp3_);
		icons = _tmp4_;
		_tmp5_ = icons;
		{
			GPtrArray* as_icon_collection = NULL;
			guint as_icon_index = 0U;
			as_icon_collection = _tmp5_;
			for (as_icon_index = 0; as_icon_index < as_icon_collection->len; as_icon_index = as_icon_index + 1) {
				AsIcon* as_icon = NULL;
				as_icon = (AsIcon*) g_ptr_array_index (as_icon_collection, as_icon_index);
				{
					AsIcon* _tmp6_;
					_tmp6_ = as_icon;
					if (as_icon_get_kind (_tmp6_) == AS_ICON_KIND_CACHED) {
						AsIcon* _tmp7_;
						_tmp7_ = as_icon;
						if (as_icon_get_height (_tmp7_) == ((guint) 64)) {
							{
								GPtrArray* remotes = NULL;
								FlatpakInstallation* _tmp8_;
								GPtrArray* _tmp9_;
								GPtrArray* _tmp10_;
								_tmp8_ = self->priv->installation;
								_tmp9_ = flatpak_installation_list_remotes (_tmp8_, NULL, &_inner_error0_);
								remotes = _tmp9_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch0_g_error;
								}
								_tmp10_ = remotes;
								{
									GPtrArray* remote_collection = NULL;
									guint remote_index = 0U;
									remote_collection = _tmp10_;
									for (remote_index = 0; remote_index < remote_collection->len; remote_index = remote_index + 1) {
										FlatpakRemote* remote = NULL;
										remote = (FlatpakRemote*) g_ptr_array_index (remote_collection, remote_index);
										{
											FlatpakRemote* _tmp11_;
											FlatpakRemote* _tmp12_;
											const gchar* _tmp13_;
											const gchar* _tmp14_;
											const gchar* _tmp15_;
											_tmp11_ = remote;
											if (flatpak_remote_get_disabled (_tmp11_)) {
												continue;
											}
											_tmp12_ = remote;
											_tmp13_ = flatpak_remote_get_name (_tmp12_);
											_tmp14_ = pamac_package_get_repo ((PamacPackage*) self);
											_tmp15_ = _tmp14_;
											if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
												GFile* appstream_dir = NULL;
												FlatpakRemote* _tmp16_;
												GFile* _tmp17_;
												GFile* _tmp18_;
												gchar* _tmp19_;
												gchar* _tmp20_;
												AsIcon* _tmp21_;
												const gchar* _tmp22_;
												gchar* _tmp23_;
												_tmp16_ = remote;
												_tmp17_ = flatpak_remote_get_appstream_dir (_tmp16_, NULL);
												appstream_dir = _tmp17_;
												_tmp18_ = appstream_dir;
												_tmp19_ = g_file_get_path (_tmp18_);
												_tmp20_ = _tmp19_;
												_tmp21_ = as_icon;
												_tmp22_ = as_icon_get_name (_tmp21_);
												_tmp23_ = g_build_filename (_tmp20_, "icons", "64x64", _tmp22_, NULL);
												_g_free0 (self->priv->_icon);
												self->priv->_icon = _tmp23_;
												_g_free0 (_tmp20_);
												_g_object_unref0 (appstream_dir);
												break;
											}
										}
									}
								}
								_g_ptr_array_unref0 (remotes);
							}
							goto __finally0;
							__catch0_g_error:
							{
								GError* e = NULL;
								GError* _tmp24_;
								const gchar* _tmp25_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp24_ = e;
								_tmp25_ = _tmp24_->message;
								g_warning ("flatpak_plugin.vala:181: %s", _tmp25_);
								_g_error_free0 (e);
							}
							__finally0:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
					}
				}
			}
		}
	}
	_tmp26_ = self->priv->_icon;
	result = _tmp26_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GPtrArray*
pamac_flatpak_package_linked_real_get_screenshots (PamacPackage* base)
{
	GPtrArray* result;
	PamacFlatpakPackageLinked* self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp14_;
	self = (PamacFlatpakPackageLinked*) base;
	_tmp0_ = self->priv->_screenshots;
	if (_tmp0_ == NULL) {
		GPtrArray* _tmp1_;
		AsComponent* _tmp2_;
		_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_free0_);
		_g_ptr_array_unref0 (self->priv->_screenshots);
		self->priv->_screenshots = _tmp1_;
		_tmp2_ = self->priv->as_app;
		if (_tmp2_ != NULL) {
			GPtrArray* as_screenshots = NULL;
			AsComponent* _tmp3_;
			GPtrArray* _tmp4_;
			GPtrArray* _tmp5_;
			_tmp3_ = self->priv->as_app;
			_tmp4_ = as_component_get_screenshots_all (_tmp3_);
			as_screenshots = _tmp4_;
			_tmp5_ = as_screenshots;
			{
				GPtrArray* as_screenshot_collection = NULL;
				guint as_screenshot_index = 0U;
				as_screenshot_collection = _tmp5_;
				for (as_screenshot_index = 0; as_screenshot_index < as_screenshot_collection->len; as_screenshot_index = as_screenshot_index + 1) {
					AsScreenshot* as_screenshot = NULL;
					as_screenshot = (AsScreenshot*) g_ptr_array_index (as_screenshot_collection, as_screenshot_index);
					{
						AsImage* as_image = NULL;
						AsScreenshot* _tmp6_;
						AsImage* _tmp7_;
						const gchar* url = NULL;
						AsImage* _tmp8_;
						const gchar* _tmp9_;
						const gchar* _tmp10_;
						_tmp6_ = as_screenshot;
						_tmp7_ = as_screenshot_get_image (_tmp6_, (guint) 500, (guint) 300, (guint) 1);
						as_image = _tmp7_;
						_tmp8_ = as_image;
						_tmp9_ = as_image_get_url (_tmp8_);
						url = _tmp9_;
						_tmp10_ = url;
						if (_tmp10_ != NULL) {
							GPtrArray* _tmp11_;
							const gchar* _tmp12_;
							gchar* _tmp13_;
							_tmp11_ = self->priv->_screenshots;
							_tmp12_ = url;
							_tmp13_ = g_strdup (_tmp12_);
							g_ptr_array_add (_tmp11_, _tmp13_);
						}
					}
				}
			}
		}
	}
	_tmp14_ = self->priv->_screenshots;
	result = _tmp14_;
	return result;
}

static void
pamac_flatpak_package_linked_class_init (PamacFlatpakPackageLinkedClass * klass,
                                         gpointer klass_data)
{
	pamac_flatpak_package_linked_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacFlatpakPackageLinked_private_offset);
	PAMAC_PACKAGE_CLASS (klass)->get_name = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_name;
	PAMAC_PACKAGE_CLASS (klass)->set_name = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_name;
	PAMAC_PACKAGE_CLASS (klass)->get_id = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_id;
	PAMAC_PACKAGE_CLASS (klass)->set_id = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_id;
	PAMAC_PACKAGE_CLASS (klass)->get_version = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_version;
	PAMAC_PACKAGE_CLASS (klass)->set_version = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_version;
	PAMAC_PACKAGE_CLASS (klass)->get_installed_version = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_installed_version;
	PAMAC_PACKAGE_CLASS (klass)->set_installed_version = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_installed_version;
	PAMAC_PACKAGE_CLASS (klass)->get_repo = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_repo;
	PAMAC_PACKAGE_CLASS (klass)->set_repo = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_repo;
	PAMAC_PACKAGE_CLASS (klass)->get_license = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_license;
	PAMAC_PACKAGE_CLASS (klass)->get_url = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_url;
	PAMAC_PACKAGE_CLASS (klass)->get_installed_size = (guint64 (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_installed_size;
	PAMAC_PACKAGE_CLASS (klass)->get_download_size = (guint64 (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_download_size;
	PAMAC_PACKAGE_CLASS (klass)->get_install_date = (GDateTime* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_install_date;
	PAMAC_PACKAGE_CLASS (klass)->get_app_name = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_app_name;
	PAMAC_PACKAGE_CLASS (klass)->get_app_id = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_app_id;
	PAMAC_PACKAGE_CLASS (klass)->get_desc = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_desc;
	PAMAC_PACKAGE_CLASS (klass)->set_desc = (void (*) (PamacPackage*, const gchar*)) pamac_flatpak_package_linked_real_set_desc;
	PAMAC_PACKAGE_CLASS (klass)->get_long_desc = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_long_desc;
	PAMAC_PACKAGE_CLASS (klass)->get_launchable = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_launchable;
	PAMAC_PACKAGE_CLASS (klass)->get_icon = (const gchar* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_icon;
	PAMAC_PACKAGE_CLASS (klass)->get_screenshots = (GPtrArray* (*) (PamacPackage*)) pamac_flatpak_package_linked_real_get_screenshots;
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_flatpak_package_linked_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_flatpak_package_linked_set_property;
	G_OBJECT_CLASS (klass)->finalize = pamac_flatpak_package_linked_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY] = g_param_spec_string ("installed-version", "installed-version", "installed-version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY] = g_param_spec_string ("repo", "repo", "repo", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_LICENSE_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_LICENSE_PROPERTY] = g_param_spec_string ("license", "license", "license", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_URL_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY] = g_param_spec_uint64 ("installed-size", "installed-size", "installed-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY] = g_param_spec_uint64 ("download-size", "download-size", "download-size", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_INSTALL_DATE_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_INSTALL_DATE_PROPERTY] = g_param_spec_boxed ("install-date", "install-date", "install-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_APP_NAME_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_APP_NAME_PROPERTY] = g_param_spec_string ("app-name", "app-name", "app-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_APP_ID_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY] = g_param_spec_string ("desc", "desc", "desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_LONG_DESC_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_LONG_DESC_PROPERTY] = g_param_spec_string ("long-desc", "long-desc", "long-desc", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_LAUNCHABLE_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_LAUNCHABLE_PROPERTY] = g_param_spec_string ("launchable", "launchable", "launchable", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_ICON_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_ICON_PROPERTY] = g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLATPAK_PACKAGE_LINKED_SCREENSHOTS_PROPERTY, pamac_flatpak_package_linked_properties[PAMAC_FLATPAK_PACKAGE_LINKED_SCREENSHOTS_PROPERTY] = g_param_spec_boxed ("screenshots", "screenshots", "screenshots", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pamac_flatpak_package_linked_instance_init (PamacFlatpakPackageLinked * self,
                                            gpointer klass)
{
	self->priv = pamac_flatpak_package_linked_get_instance_private (self);
}

static void
pamac_flatpak_package_linked_finalize (GObject * obj)
{
	PamacFlatpakPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinked);
	_g_object_unref0 (self->priv->installed_ref);
	_g_object_unref0 (self->priv->remote_ref);
	_g_object_unref0 (self->priv->as_app);
	_g_object_unref0 (self->priv->installation);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_long_desc);
	_g_free0 (self->priv->_icon);
	_g_ptr_array_unref0 (self->priv->_screenshots);
	G_OBJECT_CLASS (pamac_flatpak_package_linked_parent_class)->finalize (obj);
}

static GType
pamac_flatpak_package_linked_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacFlatpakPackageLinkedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_flatpak_package_linked_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacFlatpakPackageLinked), 0, (GInstanceInitFunc) pamac_flatpak_package_linked_instance_init, NULL };
	GType pamac_flatpak_package_linked_type_id;
	pamac_flatpak_package_linked_type_id = g_type_register_static (PAMAC_TYPE_FLATPAK_PACKAGE, "PamacFlatpakPackageLinked", &g_define_type_info, 0);
	PamacFlatpakPackageLinked_private_offset = g_type_add_instance_private (pamac_flatpak_package_linked_type_id, sizeof (PamacFlatpakPackageLinkedPrivate));
	return pamac_flatpak_package_linked_type_id;
}

GType
pamac_flatpak_package_linked_get_type (void)
{
	static volatile gsize pamac_flatpak_package_linked_type_id__once = 0;
	if (g_once_init_enter (&pamac_flatpak_package_linked_type_id__once)) {
		GType pamac_flatpak_package_linked_type_id;
		pamac_flatpak_package_linked_type_id = pamac_flatpak_package_linked_get_type_once ();
		g_once_init_leave (&pamac_flatpak_package_linked_type_id__once, pamac_flatpak_package_linked_type_id);
	}
	return pamac_flatpak_package_linked_type_id__once;
}

static void
_vala_pamac_flatpak_package_linked_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	PamacFlatpakPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinked);
	switch (property_id) {
		case PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY:
		g_value_set_string (value, pamac_package_get_name ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY:
		g_value_set_string (value, pamac_package_get_id ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY:
		g_value_set_string (value, pamac_package_get_version ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY:
		g_value_set_string (value, pamac_package_get_installed_version ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY:
		g_value_set_string (value, pamac_package_get_repo ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_LICENSE_PROPERTY:
		g_value_set_string (value, pamac_package_get_license ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_URL_PROPERTY:
		g_value_set_string (value, pamac_package_get_url ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_SIZE_PROPERTY:
		g_value_set_uint64 (value, pamac_package_get_installed_size ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_DOWNLOAD_SIZE_PROPERTY:
		g_value_set_uint64 (value, pamac_package_get_download_size ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_INSTALL_DATE_PROPERTY:
		g_value_set_boxed (value, pamac_package_get_install_date ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_APP_NAME_PROPERTY:
		g_value_set_string (value, pamac_package_get_app_name ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_APP_ID_PROPERTY:
		g_value_set_string (value, pamac_package_get_app_id ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY:
		g_value_set_string (value, pamac_package_get_desc ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_LONG_DESC_PROPERTY:
		g_value_set_string (value, pamac_package_get_long_desc ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_LAUNCHABLE_PROPERTY:
		g_value_set_string (value, pamac_package_get_launchable ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_ICON_PROPERTY:
		g_value_set_string (value, pamac_package_get_icon ((PamacPackage*) self));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_SCREENSHOTS_PROPERTY:
		g_value_set_boxed (value, pamac_package_get_screenshots ((PamacPackage*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_flatpak_package_linked_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	PamacFlatpakPackageLinked * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_FLATPAK_PACKAGE_LINKED, PamacFlatpakPackageLinked);
	switch (property_id) {
		case PAMAC_FLATPAK_PACKAGE_LINKED_NAME_PROPERTY:
		pamac_package_set_name ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_ID_PROPERTY:
		pamac_package_set_id ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_VERSION_PROPERTY:
		pamac_package_set_version ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_INSTALLED_VERSION_PROPERTY:
		pamac_package_set_installed_version ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_REPO_PROPERTY:
		pamac_package_set_repo ((PamacPackage*) self, g_value_get_string (value));
		break;
		case PAMAC_FLATPAK_PACKAGE_LINKED_DESC_PROPERTY:
		pamac_package_set_desc ((PamacPackage*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
pamac_flat_pak_get_instance_private (PamacFlatPak* self)
{
	return G_STRUCT_MEMBER_P (self, PamacFlatPak_private_offset);
}

PamacFlatPak*
pamac_flat_pak_construct (GType object_type,
                          guint64 refresh_period)
{
	PamacFlatPak * self = NULL;
	self = (PamacFlatPak*) g_object_new (object_type, "refresh-period", refresh_period, NULL);
	return self;
}

PamacFlatPak*
pamac_flat_pak_new (guint64 refresh_period)
{
	return pamac_flat_pak_construct (PAMAC_TYPE_FLAT_PAK, refresh_period);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
pamac_flat_pak_real_load_appstream_data (PamacFlatpakPlugin* base)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	{
		GHashTable* _tmp0_;
		gchar* _tmp1_;
		GHashFunc _tmp2_;
		GEqualFunc _tmp3_;
		GHashTable* _tmp4_;
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		GHashFunc _tmp7_;
		GEqualFunc _tmp8_;
		GHashTable* _tmp9_;
		GHashTable* _tmp10_;
		gchar* _tmp11_;
		GHashFunc _tmp12_;
		GEqualFunc _tmp13_;
		GHashTable* _tmp14_;
		GHashTable* _tmp15_;
		gchar* _tmp16_;
		GHashFunc _tmp17_;
		GEqualFunc _tmp18_;
		GHashTable* _tmp19_;
		GHashTable* _tmp20_;
		gchar* _tmp21_;
		GHashFunc _tmp22_;
		GEqualFunc _tmp23_;
		GHashTable* _tmp24_;
		GHashTable* _tmp25_;
		gchar* _tmp26_;
		GHashFunc _tmp27_;
		GEqualFunc _tmp28_;
		GHashTable* _tmp29_;
		GHashTable* _tmp30_;
		gchar* _tmp31_;
		GHashFunc _tmp32_;
		GEqualFunc _tmp33_;
		GHashTable* _tmp34_;
		GHashTable* _tmp35_;
		gchar* _tmp36_;
		GHashFunc _tmp37_;
		GEqualFunc _tmp38_;
		GHashTable* _tmp39_;
		GPtrArray* remotes = NULL;
		FlatpakInstallation* _tmp40_;
		GPtrArray* _tmp41_;
		GPtrArray* _tmp42_;
		_tmp0_ = self->priv->categories_cache;
		_tmp1_ = g_strdup ("Photo & Video");
		_tmp2_ = g_str_hash;
		_tmp3_ = g_str_equal;
		_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp0_, _tmp1_, _tmp4_);
		_tmp5_ = self->priv->categories_cache;
		_tmp6_ = g_strdup ("Music & Audio");
		_tmp7_ = g_str_hash;
		_tmp8_ = g_str_equal;
		_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp9_);
		_tmp10_ = self->priv->categories_cache;
		_tmp11_ = g_strdup ("Productivity");
		_tmp12_ = g_str_hash;
		_tmp13_ = g_str_equal;
		_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp10_, _tmp11_, _tmp14_);
		_tmp15_ = self->priv->categories_cache;
		_tmp16_ = g_strdup ("Communication & News");
		_tmp17_ = g_str_hash;
		_tmp18_ = g_str_equal;
		_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp15_, _tmp16_, _tmp19_);
		_tmp20_ = self->priv->categories_cache;
		_tmp21_ = g_strdup ("Education & Science");
		_tmp22_ = g_str_hash;
		_tmp23_ = g_str_equal;
		_tmp24_ = g_hash_table_new_full (_tmp22_, _tmp23_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp20_, _tmp21_, _tmp24_);
		_tmp25_ = self->priv->categories_cache;
		_tmp26_ = g_strdup ("Games");
		_tmp27_ = g_str_hash;
		_tmp28_ = g_str_equal;
		_tmp29_ = g_hash_table_new_full (_tmp27_, _tmp28_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp25_, _tmp26_, _tmp29_);
		_tmp30_ = self->priv->categories_cache;
		_tmp31_ = g_strdup ("Utilities");
		_tmp32_ = g_str_hash;
		_tmp33_ = g_str_equal;
		_tmp34_ = g_hash_table_new_full (_tmp32_, _tmp33_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp30_, _tmp31_, _tmp34_);
		_tmp35_ = self->priv->categories_cache;
		_tmp36_ = g_strdup ("Development");
		_tmp37_ = g_str_hash;
		_tmp38_ = g_str_equal;
		_tmp39_ = g_hash_table_new_full (_tmp37_, _tmp38_, NULL, _g_object_unref0_);
		g_hash_table_insert (_tmp35_, _tmp36_, _tmp39_);
		_tmp40_ = self->priv->installation;
		_tmp41_ = flatpak_installation_list_remotes (_tmp40_, NULL, &_inner_error0_);
		remotes = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp42_ = remotes;
		{
			GPtrArray* remote_collection = NULL;
			guint remote_index = 0U;
			remote_collection = _tmp42_;
			for (remote_index = 0; remote_index < remote_collection->len; remote_index = remote_index + 1) {
				FlatpakRemote* remote = NULL;
				remote = (FlatpakRemote*) g_ptr_array_index (remote_collection, remote_index);
				{
					FlatpakRemote* _tmp43_;
					FlatpakRemote* _tmp44_;
					GFile* appstream_dir = NULL;
					FlatpakRemote* _tmp45_;
					GFile* _tmp46_;
					GFile* appstream_file = NULL;
					GFile* _tmp47_;
					GFile* _tmp48_;
					GFile* _tmp49_;
					GPtrArray* remote_refs = NULL;
					FlatpakInstallation* _tmp128_;
					FlatpakRemote* _tmp129_;
					const gchar* _tmp130_;
					GPtrArray* _tmp131_;
					GPtrArray* _tmp132_;
					_tmp43_ = remote;
					if (flatpak_remote_get_disabled (_tmp43_)) {
						continue;
					}
					_tmp44_ = remote;
					pamac_flat_pak_refresh_remote_appstream_data (self, _tmp44_);
					_tmp45_ = remote;
					_tmp46_ = flatpak_remote_get_appstream_dir (_tmp45_, NULL);
					appstream_dir = _tmp46_;
					_tmp47_ = appstream_dir;
					_tmp48_ = g_file_get_child (_tmp47_, "appstream.xml");
					appstream_file = _tmp48_;
					_tmp49_ = appstream_file;
					if (g_file_query_exists (_tmp49_, NULL)) {
						const gchar* remote_name = NULL;
						FlatpakRemote* _tmp50_;
						const gchar* _tmp51_;
						AsMetadata* mdata = NULL;
						AsMetadata* _tmp52_;
						AsMetadata* _tmp53_;
						AsMetadata* _tmp54_;
						GFile* _tmp55_;
						GHashTable* desktop_apps = NULL;
						GHashFunc _tmp56_;
						GEqualFunc _tmp57_;
						GHashTable* _tmp58_;
						GPtrArray* apps = NULL;
						AsMetadata* _tmp59_;
						AsComponentBox* _tmp60_;
						GPtrArray* _tmp61_;
						GPtrArray* _tmp62_;
						GPtrArray* _tmp125_;
						GHashTable* _tmp126_;
						GHashTable* _tmp127_;
						_tmp50_ = remote;
						_tmp51_ = flatpak_remote_get_name (_tmp50_);
						remote_name = _tmp51_;
						_tmp52_ = as_metadata_new ();
						mdata = _tmp52_;
						_tmp53_ = mdata;
						as_metadata_set_format_style (_tmp53_, AS_FORMAT_STYLE_CATALOG);
						_tmp54_ = mdata;
						_tmp55_ = appstream_file;
						as_metadata_parse_file (_tmp54_, _tmp55_, AS_FORMAT_KIND_XML, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (mdata);
							_g_object_unref0 (appstream_file);
							_g_object_unref0 (appstream_dir);
							_g_ptr_array_unref0 (remotes);
							goto __catch0_g_error;
						}
						_tmp56_ = g_str_hash;
						_tmp57_ = g_str_equal;
						_tmp58_ = g_hash_table_new_full (_tmp56_, _tmp57_, _g_free0_, _g_object_unref0_);
						desktop_apps = _tmp58_;
						_tmp59_ = mdata;
						_tmp60_ = as_metadata_get_components (_tmp59_);
						_tmp61_ = as_component_box_as_array (_tmp60_);
						apps = _tmp61_;
						_tmp62_ = apps;
						{
							GPtrArray* app_collection = NULL;
							guint app_index = 0U;
							app_collection = _tmp62_;
							for (app_index = 0; app_index < app_collection->len; app_index = app_index + 1) {
								AsComponent* app = NULL;
								app = (AsComponent*) g_ptr_array_index (app_collection, app_index);
								{
									AsComponent* _tmp63_;
									_tmp63_ = app;
									if (as_component_get_kind (_tmp63_) == AS_COMPONENT_KIND_DESKTOP_APP) {
										AsBundle* bundle = NULL;
										AsComponent* _tmp64_;
										AsBundle* _tmp65_;
										AsBundle* _tmp66_;
										gchar* id = NULL;
										const gchar* _tmp67_;
										AsBundle* _tmp68_;
										const gchar* _tmp69_;
										gchar* _tmp70_;
										AsComponent* _tmp71_;
										const gchar* _tmp72_;
										GHashTable* _tmp73_;
										const gchar* _tmp74_;
										gchar* _tmp75_;
										AsComponent* _tmp76_;
										AsComponent* _tmp77_;
										GPtrArray* app_categories = NULL;
										AsComponent* _tmp78_;
										GPtrArray* _tmp79_;
										GPtrArray* _tmp80_;
										_tmp64_ = app;
										_tmp65_ = as_component_get_bundle (_tmp64_, AS_BUNDLE_KIND_FLATPAK);
										bundle = _tmp65_;
										_tmp66_ = bundle;
										if (_tmp66_ == NULL) {
											continue;
										}
										_tmp67_ = remote_name;
										_tmp68_ = bundle;
										_tmp69_ = as_bundle_get_id (_tmp68_);
										_tmp70_ = g_strdup_printf ("%s/%s", _tmp67_, _tmp69_);
										id = _tmp70_;
										_tmp71_ = app;
										_tmp72_ = remote_name;
										as_component_set_origin (_tmp71_, _tmp72_);
										_tmp73_ = desktop_apps;
										_tmp74_ = id;
										_tmp75_ = g_strdup (_tmp74_);
										_tmp76_ = app;
										_tmp77_ = _g_object_ref0 (_tmp76_);
										g_hash_table_insert (_tmp73_, _tmp75_, _tmp77_);
										_tmp78_ = app;
										_tmp79_ = as_component_get_categories (_tmp78_);
										app_categories = _tmp79_;
										_tmp80_ = app_categories;
										{
											GPtrArray* cat_collection = NULL;
											guint cat_index = 0U;
											cat_collection = _tmp80_;
											for (cat_index = 0; cat_index < cat_collection->len; cat_index = cat_index + 1) {
												const gchar* cat = NULL;
												cat = (const gchar*) g_ptr_array_index (cat_collection, cat_index);
												{
													const gchar* _tmp81_;
													const gchar* _tmp82_;
													GQuark _tmp84_ = 0U;
													static GQuark _tmp83_label0 = 0;
													static GQuark _tmp83_label1 = 0;
													static GQuark _tmp83_label2 = 0;
													static GQuark _tmp83_label3 = 0;
													static GQuark _tmp83_label4 = 0;
													static GQuark _tmp83_label5 = 0;
													static GQuark _tmp83_label6 = 0;
													static GQuark _tmp83_label7 = 0;
													static GQuark _tmp83_label8 = 0;
													static GQuark _tmp83_label9 = 0;
													static GQuark _tmp83_label10 = 0;
													static GQuark _tmp83_label11 = 0;
													static GQuark _tmp83_label12 = 0;
													static GQuark _tmp83_label13 = 0;
													_tmp81_ = cat;
													_tmp82_ = _tmp81_;
													_tmp84_ = (NULL == _tmp82_) ? 0 : g_quark_from_string (_tmp82_);
													if (((_tmp84_ == ((0 != _tmp83_label0) ? _tmp83_label0 : (_tmp83_label0 = g_quark_from_static_string ("Photography")))) || (_tmp84_ == ((0 != _tmp83_label1) ? _tmp83_label1 : (_tmp83_label1 = g_quark_from_static_string ("Graphics"))))) || (_tmp84_ == ((0 != _tmp83_label2) ? _tmp83_label2 : (_tmp83_label2 = g_quark_from_static_string ("Video"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp85_;
																gconstpointer _tmp86_;
																const gchar* _tmp87_;
																AsComponent* _tmp88_;
																AsComponent* _tmp89_;
																_tmp85_ = self->priv->categories_cache;
																_tmp86_ = g_hash_table_lookup (_tmp85_, "Photo & Video");
																_tmp87_ = id;
																_tmp88_ = app;
																_tmp89_ = _g_object_ref0 (_tmp88_);
																g_hash_table_insert ((GHashTable*) _tmp86_, _tmp87_, _tmp89_);
																break;
															}
														}
													} else if ((_tmp84_ == ((0 != _tmp83_label3) ? _tmp83_label3 : (_tmp83_label3 = g_quark_from_static_string ("Audio")))) || (_tmp84_ == ((0 != _tmp83_label4) ? _tmp83_label4 : (_tmp83_label4 = g_quark_from_static_string ("Music"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp90_;
																gconstpointer _tmp91_;
																const gchar* _tmp92_;
																AsComponent* _tmp93_;
																AsComponent* _tmp94_;
																_tmp90_ = self->priv->categories_cache;
																_tmp91_ = g_hash_table_lookup (_tmp90_, "Music & Audio");
																_tmp92_ = id;
																_tmp93_ = app;
																_tmp94_ = _g_object_ref0 (_tmp93_);
																g_hash_table_insert ((GHashTable*) _tmp91_, _tmp92_, _tmp94_);
																break;
															}
														}
													} else if (((_tmp84_ == ((0 != _tmp83_label5) ? _tmp83_label5 : (_tmp83_label5 = g_quark_from_static_string ("WebBrowser")))) || (_tmp84_ == ((0 != _tmp83_label6) ? _tmp83_label6 : (_tmp83_label6 = g_quark_from_static_string ("Email"))))) || (_tmp84_ == ((0 != _tmp83_label7) ? _tmp83_label7 : (_tmp83_label7 = g_quark_from_static_string ("Office"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp95_;
																gconstpointer _tmp96_;
																const gchar* _tmp97_;
																AsComponent* _tmp98_;
																AsComponent* _tmp99_;
																_tmp95_ = self->priv->categories_cache;
																_tmp96_ = g_hash_table_lookup (_tmp95_, "Productivity");
																_tmp97_ = id;
																_tmp98_ = app;
																_tmp99_ = _g_object_ref0 (_tmp98_);
																g_hash_table_insert ((GHashTable*) _tmp96_, _tmp97_, _tmp99_);
																break;
															}
														}
													} else if (_tmp84_ == ((0 != _tmp83_label8) ? _tmp83_label8 : (_tmp83_label8 = g_quark_from_static_string ("Network")))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp100_;
																gconstpointer _tmp101_;
																const gchar* _tmp102_;
																AsComponent* _tmp103_;
																AsComponent* _tmp104_;
																_tmp100_ = self->priv->categories_cache;
																_tmp101_ = g_hash_table_lookup (_tmp100_, "Communication & News");
																_tmp102_ = id;
																_tmp103_ = app;
																_tmp104_ = _g_object_ref0 (_tmp103_);
																g_hash_table_insert ((GHashTable*) _tmp101_, _tmp102_, _tmp104_);
																break;
															}
														}
													} else if ((_tmp84_ == ((0 != _tmp83_label9) ? _tmp83_label9 : (_tmp83_label9 = g_quark_from_static_string ("Education")))) || (_tmp84_ == ((0 != _tmp83_label10) ? _tmp83_label10 : (_tmp83_label10 = g_quark_from_static_string ("Science"))))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp105_;
																gconstpointer _tmp106_;
																const gchar* _tmp107_;
																AsComponent* _tmp108_;
																AsComponent* _tmp109_;
																_tmp105_ = self->priv->categories_cache;
																_tmp106_ = g_hash_table_lookup (_tmp105_, "Education & Science");
																_tmp107_ = id;
																_tmp108_ = app;
																_tmp109_ = _g_object_ref0 (_tmp108_);
																g_hash_table_insert ((GHashTable*) _tmp106_, _tmp107_, _tmp109_);
																break;
															}
														}
													} else if (_tmp84_ == ((0 != _tmp83_label11) ? _tmp83_label11 : (_tmp83_label11 = g_quark_from_static_string ("Games")))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp110_;
																gconstpointer _tmp111_;
																const gchar* _tmp112_;
																AsComponent* _tmp113_;
																AsComponent* _tmp114_;
																_tmp110_ = self->priv->categories_cache;
																_tmp111_ = g_hash_table_lookup (_tmp110_, "Games");
																_tmp112_ = id;
																_tmp113_ = app;
																_tmp114_ = _g_object_ref0 (_tmp113_);
																g_hash_table_insert ((GHashTable*) _tmp111_, _tmp112_, _tmp114_);
																break;
															}
														}
													} else if (_tmp84_ == ((0 != _tmp83_label12) ? _tmp83_label12 : (_tmp83_label12 = g_quark_from_static_string ("Utility")))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp115_;
																gconstpointer _tmp116_;
																const gchar* _tmp117_;
																AsComponent* _tmp118_;
																AsComponent* _tmp119_;
																_tmp115_ = self->priv->categories_cache;
																_tmp116_ = g_hash_table_lookup (_tmp115_, "Utilities");
																_tmp117_ = id;
																_tmp118_ = app;
																_tmp119_ = _g_object_ref0 (_tmp118_);
																g_hash_table_insert ((GHashTable*) _tmp116_, _tmp117_, _tmp119_);
																break;
															}
														}
													} else if (_tmp84_ == ((0 != _tmp83_label13) ? _tmp83_label13 : (_tmp83_label13 = g_quark_from_static_string ("Development")))) {
														switch (0) {
															default:
															{
																GHashTable* _tmp120_;
																gconstpointer _tmp121_;
																const gchar* _tmp122_;
																AsComponent* _tmp123_;
																AsComponent* _tmp124_;
																_tmp120_ = self->priv->categories_cache;
																_tmp121_ = g_hash_table_lookup (_tmp120_, "Development");
																_tmp122_ = id;
																_tmp123_ = app;
																_tmp124_ = _g_object_ref0 (_tmp123_);
																g_hash_table_insert ((GHashTable*) _tmp121_, _tmp122_, _tmp124_);
																break;
															}
														}
													}
												}
											}
										}
										_g_free0 (id);
									}
								}
							}
						}
						_tmp125_ = self->priv->stores_table;
						_tmp126_ = desktop_apps;
						_tmp127_ = _g_hash_table_ref0 (_tmp126_);
						g_ptr_array_add (_tmp125_, _tmp127_);
						_g_hash_table_unref0 (desktop_apps);
						_g_object_unref0 (mdata);
					}
					_tmp128_ = self->priv->installation;
					_tmp129_ = remote;
					_tmp130_ = flatpak_remote_get_name (_tmp129_);
					_tmp131_ = flatpak_installation_list_remote_refs_sync_full (_tmp128_, _tmp130_, FLATPAK_QUERY_FLAGS_ONLY_CACHED, NULL, &_inner_error0_);
					remote_refs = _tmp131_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (appstream_file);
						_g_object_unref0 (appstream_dir);
						_g_ptr_array_unref0 (remotes);
						goto __catch0_g_error;
					}
					_tmp132_ = remote_refs;
					{
						GPtrArray* remote_ref_collection = NULL;
						guint remote_ref_index = 0U;
						remote_ref_collection = _tmp132_;
						for (remote_ref_index = 0; remote_ref_index < remote_ref_collection->len; remote_ref_index = remote_ref_index + 1) {
							FlatpakRemoteRef* remote_ref = NULL;
							remote_ref = (FlatpakRemoteRef*) g_ptr_array_index (remote_ref_collection, remote_ref_index);
							{
								FlatpakRemoteRef* _tmp133_;
								_tmp133_ = remote_ref;
								if (flatpak_ref_get_kind ((FlatpakRef*) _tmp133_) == FLATPAK_REF_KIND_APP) {
									GHashTable* _tmp134_;
									FlatpakRemoteRef* _tmp135_;
									const gchar* _tmp136_;
									const gchar* _tmp137_;
									FlatpakRemoteRef* _tmp138_;
									gchar* _tmp139_;
									gchar* _tmp140_;
									gchar* _tmp141_;
									FlatpakRemoteRef* _tmp142_;
									FlatpakRemoteRef* _tmp143_;
									_tmp134_ = self->priv->remote_refs_table;
									_tmp135_ = remote_ref;
									_tmp136_ = flatpak_remote_ref_get_remote_name (_tmp135_);
									_tmp137_ = _tmp136_;
									_tmp138_ = remote_ref;
									_tmp139_ = flatpak_ref_format_ref ((FlatpakRef*) _tmp138_);
									_tmp140_ = _tmp139_;
									_tmp141_ = g_strdup_printf ("%s/%s", _tmp137_, _tmp140_);
									_tmp142_ = remote_ref;
									_tmp143_ = _g_object_ref0 (_tmp142_);
									g_hash_table_insert (_tmp134_, _tmp141_, _tmp143_);
									_g_free0 (_tmp140_);
								}
							}
						}
					}
					_g_ptr_array_unref0 (remote_refs);
					_g_object_unref0 (appstream_file);
					_g_object_unref0 (appstream_dir);
				}
			}
		}
		_g_ptr_array_unref0 (remotes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp144_;
		const gchar* _tmp145_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp144_ = e;
		_tmp145_ = _tmp144_->message;
		g_warning ("flatpak_plugin.vala:367: %s", _tmp145_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint64
pamac_flat_pak_get_file_age (PamacFlatPak* self,
                             GFile* file)
{
	gint64 _tmp7_ = -1LL;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (file != NULL, 0LL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		GDateTime* last_modifed = NULL;
		GDateTime* _tmp1_;
		GDateTime* now = NULL;
		GDateTime* _tmp2_;
		GTimeSpan elapsed_time = 0LL;
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		_tmp0_ = g_file_query_info (file, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_file_info_get_modification_date_time (info);
		last_modifed = _tmp1_;
		_tmp2_ = g_date_time_new_now_utc ();
		now = _tmp2_;
		_tmp3_ = now;
		_tmp4_ = last_modifed;
		elapsed_time = g_date_time_difference (_tmp3_, _tmp4_);
		result = (gint64) elapsed_time;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (last_modifed);
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("flatpak_plugin.vala:379: %s", _tmp6_);
		result = G_MAXINT64;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp7_;
}

static gboolean
pamac_flat_pak_refresh_remote_appstream_data (PamacFlatPak* self,
                                              FlatpakRemote* remote)
{
	gboolean modified = FALSE;
	gint64 elapsed_time = 0LL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gint64 _tmp2_;
	gint64 elapsed_hours = 0LL;
	guint64 _tmp3_;
	guint64 _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (remote != NULL, FALSE);
	modified = FALSE;
	_tmp0_ = flatpak_remote_get_appstream_timestamp (remote, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = pamac_flat_pak_get_file_age (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	elapsed_time = _tmp2_;
	if (elapsed_time < ((gint64) G_TIME_SPAN_HOUR)) {
		result = modified;
		return result;
	}
	elapsed_hours = elapsed_time / G_TIME_SPAN_HOUR;
	_tmp3_ = pamac_flatpak_plugin_get_refresh_period ((PamacFlatpakPlugin*) self);
	_tmp4_ = _tmp3_;
	if (((guint64) elapsed_hours) > _tmp4_) {
		const gchar* remote_name = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = flatpak_remote_get_name (remote);
		remote_name = _tmp5_;
		_tmp6_ = remote_name;
		g_message ("flatpak_plugin.vala:393: refreshing %s appstream data", _tmp6_);
		{
			FlatpakInstallation* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->installation;
			_tmp8_ = remote_name;
			flatpak_installation_update_appstream_sync (_tmp7_, _tmp8_, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			modified = TRUE;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("flatpak_plugin.vala:398: %s", _tmp10_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp11_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp11_;
		}
	}
	result = modified;
	return result;
}

static gboolean
pamac_flat_pak_real_refresh_appstream_data (PamacFlatpakPlugin* base)
{
	PamacFlatPak * self;
	gboolean modified = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PamacFlatPak*) base;
	modified = FALSE;
	{
		GPtrArray* remotes = NULL;
		FlatpakInstallation* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		_tmp0_ = self->priv->installation;
		_tmp1_ = flatpak_installation_list_remotes (_tmp0_, NULL, &_inner_error0_);
		remotes = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = remotes;
		{
			GPtrArray* remote_collection = NULL;
			guint remote_index = 0U;
			remote_collection = _tmp2_;
			for (remote_index = 0; remote_index < remote_collection->len; remote_index = remote_index + 1) {
				FlatpakRemote* remote = NULL;
				remote = (FlatpakRemote*) g_ptr_array_index (remote_collection, remote_index);
				{
					FlatpakRemote* _tmp3_;
					gboolean remote_modified = FALSE;
					FlatpakRemote* _tmp4_;
					_tmp3_ = remote;
					if (flatpak_remote_get_disabled (_tmp3_)) {
						continue;
					}
					_tmp4_ = remote;
					remote_modified = pamac_flat_pak_refresh_remote_appstream_data (self, _tmp4_);
					if (remote_modified) {
						modified = TRUE;
					}
				}
			}
		}
		_g_ptr_array_unref0 (remotes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("flatpak_plugin.vala:418: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = modified;
	return result;
}

static AsComponent*
pamac_flat_pak_get_installed_ref_matching_app (PamacFlatPak* self,
                                               FlatpakInstalledRef* installed_ref)
{
	AsComponent* matching_app = NULL;
	gchar* id = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	AsComponent* _tmp15_;
	AsComponent* _tmp16_;
	GError* _inner_error0_ = NULL;
	AsComponent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (installed_ref != NULL, NULL);
	matching_app = NULL;
	_tmp0_ = flatpak_installed_ref_get_origin (installed_ref);
	_tmp1_ = flatpak_ref_format_ref ((FlatpakRef*) installed_ref);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	id = _tmp4_;
	{
		GPtrArray* _tmp5_;
		_tmp5_ = self->priv->stores_table;
		g_rec_mutex_lock (&self->priv->__lock_stores_table);
		{
			GPtrArray* _tmp6_;
			_tmp6_ = self->priv->stores_table;
			{
				GPtrArray* apps_collection = NULL;
				guint apps_index = 0U;
				apps_collection = _tmp6_;
				for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
					GHashTable* apps = NULL;
					apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
					{
						GHashTable* _tmp7_;
						const gchar* _tmp8_;
						gconstpointer _tmp9_;
						AsComponent* _tmp10_;
						_tmp7_ = apps;
						_tmp8_ = id;
						_tmp9_ = g_hash_table_lookup (_tmp7_, _tmp8_);
						matching_app = (AsComponent*) _tmp9_;
						_tmp10_ = matching_app;
						if (_tmp10_ != NULL) {
							AsComponent* _tmp11_;
							AsComponent* _tmp12_;
							_tmp11_ = matching_app;
							_tmp12_ = _g_object_ref0 (_tmp11_);
							result = _tmp12_;
							{
								GPtrArray* _tmp13_;
								_tmp13_ = self->priv->stores_table;
								g_rec_mutex_unlock (&self->priv->__lock_stores_table);
							}
							_g_free0 (id);
							return result;
						}
					}
				}
			}
		}
		__finally0:
		{
			GPtrArray* _tmp14_;
			_tmp14_ = self->priv->stores_table;
			g_rec_mutex_unlock (&self->priv->__lock_stores_table);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = matching_app;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	result = _tmp16_;
	_g_free0 (id);
	return result;
}

static AsComponent*
pamac_flat_pak_get_remote_ref_matching_app (PamacFlatPak* self,
                                            FlatpakRemoteRef* remote_ref)
{
	AsComponent* matching_app = NULL;
	gchar* id = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	AsComponent* _tmp15_;
	GError* _inner_error0_ = NULL;
	AsComponent* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (remote_ref != NULL, NULL);
	matching_app = NULL;
	_tmp0_ = flatpak_remote_ref_get_remote_name (remote_ref);
	_tmp1_ = _tmp0_;
	_tmp2_ = flatpak_ref_format_ref ((FlatpakRef*) remote_ref);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s/%s", _tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	id = _tmp5_;
	{
		GPtrArray* _tmp6_;
		_tmp6_ = self->priv->stores_table;
		g_rec_mutex_lock (&self->priv->__lock_stores_table);
		{
			GPtrArray* _tmp7_;
			_tmp7_ = self->priv->stores_table;
			{
				GPtrArray* apps_collection = NULL;
				guint apps_index = 0U;
				apps_collection = _tmp7_;
				for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
					GHashTable* apps = NULL;
					apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
					{
						GHashTable* _tmp8_;
						const gchar* _tmp9_;
						gconstpointer _tmp10_;
						AsComponent* _tmp11_;
						_tmp8_ = apps;
						_tmp9_ = id;
						_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
						matching_app = (AsComponent*) _tmp10_;
						_tmp11_ = matching_app;
						if (_tmp11_ != NULL) {
							AsComponent* _tmp12_;
							_tmp12_ = matching_app;
							result = _tmp12_;
							{
								GPtrArray* _tmp13_;
								_tmp13_ = self->priv->stores_table;
								g_rec_mutex_unlock (&self->priv->__lock_stores_table);
							}
							_g_free0 (id);
							return result;
						}
					}
				}
			}
		}
		__finally0:
		{
			GPtrArray* _tmp14_;
			_tmp14_ = self->priv->stores_table;
			g_rec_mutex_unlock (&self->priv->__lock_stores_table);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp15_ = matching_app;
	result = _tmp15_;
	_g_free0 (id);
	return result;
}

static void
pamac_flat_pak_real_get_remotes_names (PamacFlatpakPlugin* base,
                                       GPtrArray** remotes_names)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	g_return_if_fail (*remotes_names != NULL);
	{
		GPtrArray* remotes = NULL;
		FlatpakInstallation* _tmp0_;
		GPtrArray* _tmp1_;
		GPtrArray* _tmp2_;
		_tmp0_ = self->priv->installation;
		_tmp1_ = flatpak_installation_list_remotes (_tmp0_, NULL, &_inner_error0_);
		remotes = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = remotes;
		{
			GPtrArray* remote_collection = NULL;
			guint remote_index = 0U;
			remote_collection = _tmp2_;
			for (remote_index = 0; remote_index < remote_collection->len; remote_index = remote_index + 1) {
				FlatpakRemote* remote = NULL;
				remote = (FlatpakRemote*) g_ptr_array_index (remote_collection, remote_index);
				{
					FlatpakRemote* _tmp3_;
					FlatpakRemote* _tmp4_;
					const gchar* _tmp5_;
					_tmp3_ = remote;
					if (flatpak_remote_get_disabled (_tmp3_)) {
						continue;
					}
					_tmp4_ = remote;
					_tmp5_ = flatpak_remote_get_name (_tmp4_);
					g_ptr_array_add (*remotes_names, _tmp5_);
				}
			}
		}
		_g_ptr_array_unref0 (remotes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("flatpak_plugin.vala:461: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
pamac_flat_pak_real_get_installed_flatpaks (PamacFlatpakPlugin* base,
                                            GPtrArray** pkgs)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	g_return_if_fail (*pkgs != NULL);
	{
		{
			GHashTable* _tmp0_;
			_tmp0_ = self->priv->pkgs_cache;
			g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
			{
				GPtrArray* installed_apps = NULL;
				FlatpakInstallation* _tmp1_;
				GPtrArray* _tmp2_;
				_tmp1_ = self->priv->installation;
				_tmp2_ = flatpak_installation_list_installed_refs_by_kind (_tmp1_, FLATPAK_REF_KIND_APP, NULL, &_inner_error0_);
				installed_apps = _tmp2_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				{
					GPtrArray* installed_ref_collection = NULL;
					guint installed_ref_index = 0U;
					installed_ref_collection = installed_apps;
					for (installed_ref_index = 0; installed_ref_index < installed_ref_collection->len; installed_ref_index = installed_ref_index + 1) {
						FlatpakInstalledRef* installed_ref = NULL;
						installed_ref = (FlatpakInstalledRef*) g_ptr_array_index (installed_ref_collection, installed_ref_index);
						{
							gchar* id = NULL;
							FlatpakInstalledRef* _tmp3_;
							const gchar* _tmp4_;
							FlatpakInstalledRef* _tmp5_;
							gchar* _tmp6_;
							gchar* _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							PamacFlatpakPackageLinked* pkg = NULL;
							GHashTable* _tmp10_;
							const gchar* _tmp11_;
							gconstpointer _tmp12_;
							PamacFlatpakPackageLinked* _tmp13_;
							PamacFlatpakPackageLinked* _tmp14_;
							PamacFlatpakPackageLinked* _tmp25_;
							_tmp3_ = installed_ref;
							_tmp4_ = flatpak_installed_ref_get_origin (_tmp3_);
							_tmp5_ = installed_ref;
							_tmp6_ = flatpak_ref_format_ref ((FlatpakRef*) _tmp5_);
							_tmp7_ = _tmp6_;
							_tmp8_ = g_strdup_printf ("%s/%s", _tmp4_, _tmp7_);
							_tmp9_ = _tmp8_;
							_g_free0 (_tmp7_);
							id = _tmp9_;
							_tmp10_ = self->priv->pkgs_cache;
							_tmp11_ = id;
							_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
							_tmp13_ = _g_object_ref0 ((PamacFlatpakPackageLinked*) _tmp12_);
							pkg = _tmp13_;
							_tmp14_ = pkg;
							if (_tmp14_ == NULL) {
								AsComponent* app = NULL;
								FlatpakInstalledRef* _tmp15_;
								AsComponent* _tmp16_;
								FlatpakInstalledRef* _tmp17_;
								AsComponent* _tmp18_;
								FlatpakInstallation* _tmp19_;
								PamacFlatpakPackageLinked* _tmp20_;
								GHashTable* _tmp21_;
								gchar* _tmp22_;
								PamacFlatpakPackageLinked* _tmp23_;
								PamacFlatpakPackageLinked* _tmp24_;
								_tmp15_ = installed_ref;
								_tmp16_ = pamac_flat_pak_get_installed_ref_matching_app (self, _tmp15_);
								app = _tmp16_;
								_tmp17_ = installed_ref;
								_tmp18_ = app;
								_tmp19_ = self->priv->installation;
								_tmp20_ = pamac_flatpak_package_linked_new (_tmp17_, NULL, _tmp18_, _tmp19_, FALSE);
								_g_object_unref0 (pkg);
								pkg = _tmp20_;
								_tmp21_ = self->priv->pkgs_cache;
								_tmp22_ = id;
								id = NULL;
								_tmp23_ = pkg;
								_tmp24_ = _g_object_ref0 (_tmp23_);
								g_hash_table_insert (_tmp21_, _tmp22_, _tmp24_);
								_g_object_unref0 (app);
							}
							_tmp25_ = pkg;
							g_ptr_array_add (*pkgs, (PamacFlatpakPackage*) _tmp25_);
							_g_object_unref0 (pkg);
							_g_free0 (id);
						}
					}
				}
				_g_ptr_array_unref0 (installed_apps);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp26_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp26_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				GHashTable* _tmp27_;
				_tmp27_ = self->priv->pkgs_cache;
				g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("flatpak_plugin.vala:481: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
pamac_flat_pak_real_is_installed_flatpak (PamacFlatpakPlugin* base,
                                          const gchar* id)
{
	PamacFlatPak * self;
	gchar** splitted = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint splitted_length1;
	gint _splitted_size_;
	const gchar* name = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	const gchar* arch = NULL;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	const gchar* branch = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PamacFlatPak*) base;
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (id, "/", 5);
	splitted = _tmp1_;
	splitted_length1 = _vala_array_length (_tmp0_);
	_splitted_size_ = splitted_length1;
	_tmp2_ = splitted;
	_tmp2__length1 = splitted_length1;
	_tmp3_ = _tmp2_[2];
	name = _tmp3_;
	_tmp4_ = splitted;
	_tmp4__length1 = splitted_length1;
	_tmp5_ = _tmp4_[3];
	arch = _tmp5_;
	_tmp6_ = splitted;
	_tmp6__length1 = splitted_length1;
	_tmp7_ = _tmp6_[4];
	branch = _tmp7_;
	{
		FlatpakInstalledRef* installed_ref = NULL;
		FlatpakInstallation* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		FlatpakInstalledRef* _tmp12_;
		FlatpakInstalledRef* _tmp13_;
		_tmp8_ = self->priv->installation;
		_tmp9_ = name;
		_tmp10_ = arch;
		_tmp11_ = branch;
		_tmp12_ = flatpak_installation_get_installed_ref (_tmp8_, FLATPAK_REF_KIND_APP, _tmp9_, _tmp10_, _tmp11_, NULL, &_inner_error0_);
		installed_ref = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = installed_ref;
		if (_tmp13_ != NULL) {
			result = TRUE;
			_g_object_unref0 (installed_ref);
			splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_object_unref0 (installed_ref);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		if (g_error_matches (_tmp14_, FLATPAK_ERROR, FLATPAK_ERROR_NOT_INSTALLED)) {
			result = FALSE;
			_g_error_free0 (e);
			splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_warning ("flatpak_plugin.vala:501: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp17_;
	}
	result = FALSE;
	splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static PamacFlatpakPackage*
pamac_flat_pak_real_get_flatpak_by_app_id (PamacFlatpakPlugin* base,
                                           const gchar* app_id)
{
	PamacFlatPak * self;
	PamacFlatpakPackage* pkg = NULL;
	gchar* other_app_id = NULL;
	PamacFlatpakPackage* _tmp19_;
	GError* _inner_error0_ = NULL;
	PamacFlatpakPackage* result;
	self = (PamacFlatPak*) base;
	g_return_val_if_fail (app_id != NULL, NULL);
	pkg = NULL;
	if (g_str_has_suffix (app_id, ".desktop")) {
		gchar* _tmp0_;
		_tmp0_ = string_replace (app_id, ".desktop", "");
		_g_free0 (other_app_id);
		other_app_id = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strconcat (app_id, ".desktop", NULL);
		_g_free0 (other_app_id);
		other_app_id = _tmp1_;
	}
	{
		GPtrArray* _tmp2_;
		_tmp2_ = self->priv->stores_table;
		g_rec_mutex_lock (&self->priv->__lock_stores_table);
		{
			GPtrArray* _tmp3_;
			_tmp3_ = self->priv->stores_table;
			{
				GPtrArray* apps_collection = NULL;
				guint apps_index = 0U;
				apps_collection = _tmp3_;
				for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
					GHashTable* apps = NULL;
					apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
					{
						GHashTableIter iter = {0};
						GHashTable* _tmp4_;
						AsComponent* app = NULL;
						_tmp4_ = apps;
						g_hash_table_iter_init (&iter, _tmp4_);
						while (TRUE) {
							gconstpointer _tmp5_ = NULL;
							gboolean _tmp6_;
							const gchar* current_app_id = NULL;
							AsComponent* _tmp7_;
							const gchar* _tmp8_;
							const gchar* _tmp9_;
							gboolean _tmp10_ = FALSE;
							const gchar* _tmp11_;
							_tmp6_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp5_));
							app = (AsComponent*) _tmp5_;
							if (!_tmp6_) {
								break;
							}
							_tmp7_ = app;
							_tmp8_ = as_component_get_id (_tmp7_);
							_tmp9_ = _tmp8_;
							current_app_id = _tmp9_;
							_tmp11_ = current_app_id;
							if (g_strcmp0 (_tmp11_, app_id) == 0) {
								_tmp10_ = TRUE;
							} else {
								const gchar* _tmp12_;
								const gchar* _tmp13_;
								_tmp12_ = current_app_id;
								_tmp13_ = other_app_id;
								_tmp10_ = g_strcmp0 (_tmp12_, _tmp13_) == 0;
							}
							if (_tmp10_) {
								AsComponent* _tmp14_;
								PamacFlatpakPackageLinked* _tmp15_;
								PamacFlatpakPackage* _tmp16_;
								_tmp14_ = app;
								_tmp15_ = pamac_flat_pak_get_flatpak_from_app (self, _tmp14_);
								pkg = (PamacFlatpakPackage*) _tmp15_;
								_tmp16_ = pkg;
								result = _tmp16_;
								{
									GPtrArray* _tmp17_;
									_tmp17_ = self->priv->stores_table;
									g_rec_mutex_unlock (&self->priv->__lock_stores_table);
								}
								_g_free0 (other_app_id);
								return result;
							}
						}
					}
				}
			}
		}
		__finally0:
		{
			GPtrArray* _tmp18_;
			_tmp18_ = self->priv->stores_table;
			g_rec_mutex_unlock (&self->priv->__lock_stores_table);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (other_app_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp19_ = pkg;
	result = _tmp19_;
	_g_free0 (other_app_id);
	return result;
}

static PamacFlatpakPackageLinked*
pamac_flat_pak_get_flatpak_from_app (PamacFlatPak* self,
                                     AsComponent* app)
{
	PamacFlatpakPackageLinked* pkg = NULL;
	AsBundle* bundle = NULL;
	AsBundle* _tmp0_;
	const gchar* bundle_id = NULL;
	AsBundle* _tmp1_;
	const gchar* _tmp2_;
	const gchar* remote = NULL;
	const gchar* _tmp3_;
	gchar* id = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	PamacFlatpakPackageLinked* _tmp69_;
	GError* _inner_error0_ = NULL;
	PamacFlatpakPackageLinked* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (app != NULL, NULL);
	pkg = NULL;
	_tmp0_ = as_component_get_bundle (app, AS_BUNDLE_KIND_FLATPAK);
	bundle = _tmp0_;
	_tmp1_ = bundle;
	_tmp2_ = as_bundle_get_id (_tmp1_);
	bundle_id = _tmp2_;
	_tmp3_ = as_component_get_origin (app);
	remote = _tmp3_;
	_tmp4_ = remote;
	_tmp5_ = bundle_id;
	_tmp6_ = g_strdup_printf ("%s/%s", _tmp4_, _tmp5_);
	id = _tmp6_;
	{
		GHashTable* _tmp7_;
		_tmp7_ = self->priv->pkgs_cache;
		g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
		{
			GHashTable* _tmp8_;
			const gchar* _tmp9_;
			gconstpointer _tmp10_;
			PamacFlatpakPackageLinked* _tmp11_;
			_tmp8_ = self->priv->pkgs_cache;
			_tmp9_ = id;
			_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
			pkg = (PamacFlatpakPackageLinked*) _tmp10_;
			_tmp11_ = pkg;
			if (_tmp11_ == NULL) {
				gchar** splitted = NULL;
				const gchar* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gint splitted_length1;
				gint _splitted_size_;
				const gchar* name = NULL;
				gchar** _tmp15_;
				gint _tmp15__length1;
				const gchar* _tmp16_;
				const gchar* arch = NULL;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				const gchar* branch = NULL;
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				PamacFlatpakPackageLinked* new_pkg = NULL;
				PamacFlatpakPackageLinked* _tmp67_;
				_tmp12_ = bundle_id;
				_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "/", 4);
				splitted = _tmp14_;
				splitted_length1 = _vala_array_length (_tmp13_);
				_splitted_size_ = splitted_length1;
				_tmp15_ = splitted;
				_tmp15__length1 = splitted_length1;
				_tmp16_ = _tmp15_[1];
				name = _tmp16_;
				_tmp17_ = splitted;
				_tmp17__length1 = splitted_length1;
				_tmp18_ = _tmp17_[2];
				arch = _tmp18_;
				_tmp19_ = splitted;
				_tmp19__length1 = splitted_length1;
				_tmp20_ = _tmp19_[3];
				branch = _tmp20_;
				new_pkg = NULL;
				{
					FlatpakInstalledRef* installed_ref = NULL;
					FlatpakInstallation* _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					FlatpakInstalledRef* _tmp25_;
					FlatpakInstalledRef* _tmp26_;
					FlatpakInstallation* _tmp27_;
					PamacFlatpakPackageLinked* _tmp28_;
					GHashTable* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					PamacFlatpakPackageLinked* _tmp32_;
					PamacFlatpakPackageLinked* _tmp33_;
					_tmp21_ = self->priv->installation;
					_tmp22_ = name;
					_tmp23_ = arch;
					_tmp24_ = branch;
					_tmp25_ = flatpak_installation_get_installed_ref (_tmp21_, FLATPAK_REF_KIND_APP, _tmp22_, _tmp23_, _tmp24_, NULL, &_inner_error0_);
					installed_ref = _tmp25_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					_tmp26_ = installed_ref;
					_tmp27_ = self->priv->installation;
					_tmp28_ = pamac_flatpak_package_linked_new (_tmp26_, NULL, app, _tmp27_, FALSE);
					_g_object_unref0 (new_pkg);
					new_pkg = _tmp28_;
					_tmp29_ = self->priv->pkgs_cache;
					_tmp30_ = id;
					_tmp31_ = g_strdup (_tmp30_);
					_tmp32_ = new_pkg;
					_tmp33_ = _g_object_ref0 (_tmp32_);
					g_hash_table_insert (_tmp29_, _tmp31_, _tmp33_);
					_g_object_unref0 (installed_ref);
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp34_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp34_ = e;
					if (g_error_matches (_tmp34_, FLATPAK_ERROR, FLATPAK_ERROR_NOT_INSTALLED)) {
						FlatpakRemoteRef* remote_ref = NULL;
						GHashTable* _tmp35_;
						const gchar* _tmp36_;
						gconstpointer _tmp37_;
						FlatpakRemoteRef* _tmp38_;
						FlatpakRemoteRef* _tmp39_;
						FlatpakRemoteRef* _tmp56_;
						_tmp35_ = self->priv->remote_refs_table;
						_tmp36_ = id;
						_tmp37_ = g_hash_table_lookup (_tmp35_, _tmp36_);
						_tmp38_ = _g_object_ref0 ((FlatpakRemoteRef*) _tmp37_);
						remote_ref = _tmp38_;
						_tmp39_ = remote_ref;
						if (_tmp39_ == NULL) {
							{
								FlatpakRemoteRef* _tmp40_ = NULL;
								FlatpakInstallation* _tmp41_;
								const gchar* _tmp42_;
								const gchar* _tmp43_;
								const gchar* _tmp44_;
								const gchar* _tmp45_;
								FlatpakRemoteRef* _tmp46_;
								FlatpakRemoteRef* _tmp47_;
								GHashTable* _tmp48_;
								const gchar* _tmp49_;
								gchar* _tmp50_;
								FlatpakRemoteRef* _tmp51_;
								FlatpakRemoteRef* _tmp52_;
								_tmp41_ = self->priv->installation;
								_tmp42_ = remote;
								_tmp43_ = name;
								_tmp44_ = arch;
								_tmp45_ = branch;
								_tmp46_ = flatpak_installation_fetch_remote_ref_sync (_tmp41_, _tmp42_, FLATPAK_REF_KIND_APP, _tmp43_, _tmp44_, _tmp45_, NULL, &_inner_error0_);
								_tmp40_ = _tmp46_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch2_g_error;
								}
								_tmp47_ = _tmp40_;
								_tmp40_ = NULL;
								_g_object_unref0 (remote_ref);
								remote_ref = _tmp47_;
								_tmp48_ = self->priv->remote_refs_table;
								_tmp49_ = id;
								_tmp50_ = g_strdup (_tmp49_);
								_tmp51_ = remote_ref;
								_tmp52_ = _g_object_ref0 (_tmp51_);
								g_hash_table_insert (_tmp48_, _tmp50_, _tmp52_);
								_g_object_unref0 (_tmp40_);
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								GError* _tmp53_;
								const gchar* _tmp54_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp53_ = e;
								_tmp54_ = _tmp53_->message;
								g_warning ("flatpak_plugin.vala:561: %s", _tmp54_);
								_g_error_free0 (e);
							}
							__finally2:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (remote_ref);
								_g_error_free0 (e);
								_g_object_unref0 (new_pkg);
								splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
								{
									GHashTable* _tmp55_;
									_tmp55_ = self->priv->pkgs_cache;
									g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
								}
								_g_free0 (id);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
						_tmp56_ = remote_ref;
						if (_tmp56_ != NULL) {
							FlatpakRemoteRef* _tmp57_;
							FlatpakInstallation* _tmp58_;
							PamacFlatpakPackageLinked* _tmp59_;
							GHashTable* _tmp60_;
							const gchar* _tmp61_;
							gchar* _tmp62_;
							PamacFlatpakPackageLinked* _tmp63_;
							PamacFlatpakPackageLinked* _tmp64_;
							_tmp57_ = remote_ref;
							_tmp58_ = self->priv->installation;
							_tmp59_ = pamac_flatpak_package_linked_new (NULL, _tmp57_, app, _tmp58_, FALSE);
							_g_object_unref0 (new_pkg);
							new_pkg = _tmp59_;
							_tmp60_ = self->priv->pkgs_cache;
							_tmp61_ = id;
							_tmp62_ = g_strdup (_tmp61_);
							_tmp63_ = new_pkg;
							_tmp64_ = _g_object_ref0 (_tmp63_);
							g_hash_table_insert (_tmp60_, _tmp62_, _tmp64_);
						}
						_g_object_unref0 (remote_ref);
					} else {
						GError* _tmp65_;
						const gchar* _tmp66_;
						_tmp65_ = e;
						_tmp66_ = _tmp65_->message;
						g_warning ("flatpak_plugin.vala:569: %s", _tmp66_);
					}
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (new_pkg);
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (id);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp67_ = new_pkg;
				pkg = _tmp67_;
				_g_object_unref0 (new_pkg);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		__finally0:
		{
			GHashTable* _tmp68_;
			_tmp68_ = self->priv->pkgs_cache;
			g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp69_ = pkg;
	result = _tmp69_;
	_g_free0 (id);
	return result;
}

static PamacFlatpakPackage*
pamac_flat_pak_real_get_flatpak (PamacFlatpakPlugin* base,
                                 const gchar* id)
{
	PamacFlatPak * self;
	PamacFlatpakPackageLinked* pkg = NULL;
	PamacFlatpakPackageLinked* _tmp67_;
	GError* _inner_error0_ = NULL;
	PamacFlatpakPackage* result;
	self = (PamacFlatPak*) base;
	g_return_val_if_fail (id != NULL, NULL);
	pkg = NULL;
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->pkgs_cache;
		g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
		{
			GHashTable* _tmp1_;
			gconstpointer _tmp2_;
			PamacFlatpakPackageLinked* _tmp3_;
			gchar** splitted = NULL;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint splitted_length1;
			gint _splitted_size_;
			const gchar* remote = NULL;
			gchar** _tmp8_;
			gint _tmp8__length1;
			const gchar* _tmp9_;
			const gchar* name = NULL;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			const gchar* arch = NULL;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			const gchar* branch = NULL;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			PamacFlatpakPackageLinked* new_pkg = NULL;
			PamacFlatpakPackageLinked* _tmp65_;
			_tmp1_ = self->priv->pkgs_cache;
			_tmp2_ = g_hash_table_lookup (_tmp1_, id);
			pkg = (PamacFlatpakPackageLinked*) _tmp2_;
			_tmp3_ = pkg;
			if (_tmp3_ != NULL) {
				PamacFlatpakPackageLinked* _tmp4_;
				_tmp4_ = pkg;
				result = (PamacFlatpakPackage*) _tmp4_;
				{
					GHashTable* _tmp5_;
					_tmp5_ = self->priv->pkgs_cache;
					g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
				}
				return result;
			}
			_tmp7_ = _tmp6_ = g_strsplit (id, "/", 5);
			splitted = _tmp7_;
			splitted_length1 = _vala_array_length (_tmp6_);
			_splitted_size_ = splitted_length1;
			_tmp8_ = splitted;
			_tmp8__length1 = splitted_length1;
			_tmp9_ = _tmp8_[0];
			remote = _tmp9_;
			_tmp10_ = splitted;
			_tmp10__length1 = splitted_length1;
			_tmp11_ = _tmp10_[2];
			name = _tmp11_;
			_tmp12_ = splitted;
			_tmp12__length1 = splitted_length1;
			_tmp13_ = _tmp12_[3];
			arch = _tmp13_;
			_tmp14_ = splitted;
			_tmp14__length1 = splitted_length1;
			_tmp15_ = _tmp14_[4];
			branch = _tmp15_;
			new_pkg = NULL;
			{
				FlatpakInstalledRef* installed_ref = NULL;
				FlatpakInstallation* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				FlatpakInstalledRef* _tmp20_;
				AsComponent* app = NULL;
				FlatpakInstalledRef* _tmp21_;
				AsComponent* _tmp22_;
				FlatpakInstalledRef* _tmp23_;
				AsComponent* _tmp24_;
				FlatpakInstallation* _tmp25_;
				PamacFlatpakPackageLinked* _tmp26_;
				GHashTable* _tmp27_;
				gchar* _tmp28_;
				PamacFlatpakPackageLinked* _tmp29_;
				PamacFlatpakPackageLinked* _tmp30_;
				_tmp16_ = self->priv->installation;
				_tmp17_ = name;
				_tmp18_ = arch;
				_tmp19_ = branch;
				_tmp20_ = flatpak_installation_get_installed_ref (_tmp16_, FLATPAK_REF_KIND_APP, _tmp17_, _tmp18_, _tmp19_, NULL, &_inner_error0_);
				installed_ref = _tmp20_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp21_ = installed_ref;
				_tmp22_ = pamac_flat_pak_get_installed_ref_matching_app (self, _tmp21_);
				app = _tmp22_;
				_tmp23_ = installed_ref;
				_tmp24_ = app;
				_tmp25_ = self->priv->installation;
				_tmp26_ = pamac_flatpak_package_linked_new (_tmp23_, NULL, _tmp24_, _tmp25_, FALSE);
				_g_object_unref0 (new_pkg);
				new_pkg = _tmp26_;
				_tmp27_ = self->priv->pkgs_cache;
				_tmp28_ = g_strdup (id);
				_tmp29_ = new_pkg;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				g_hash_table_insert (_tmp27_, _tmp28_, _tmp30_);
				_g_object_unref0 (app);
				_g_object_unref0 (installed_ref);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp31_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp31_ = e;
				if (g_error_matches (_tmp31_, FLATPAK_ERROR, FLATPAK_ERROR_NOT_INSTALLED)) {
					FlatpakRemoteRef* remote_ref = NULL;
					GHashTable* _tmp32_;
					gconstpointer _tmp33_;
					FlatpakRemoteRef* _tmp34_;
					FlatpakRemoteRef* _tmp35_;
					_tmp32_ = self->priv->remote_refs_table;
					_tmp33_ = g_hash_table_lookup (_tmp32_, id);
					_tmp34_ = _g_object_ref0 ((FlatpakRemoteRef*) _tmp33_);
					remote_ref = _tmp34_;
					_tmp35_ = remote_ref;
					if (_tmp35_ == NULL) {
						{
							FlatpakRemoteRef* _tmp36_ = NULL;
							FlatpakInstallation* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							FlatpakRemoteRef* _tmp42_;
							FlatpakRemoteRef* _tmp43_;
							GHashTable* _tmp44_;
							gchar* _tmp45_;
							FlatpakRemoteRef* _tmp46_;
							FlatpakRemoteRef* _tmp47_;
							AsComponent* app = NULL;
							FlatpakRemoteRef* _tmp48_;
							AsComponent* _tmp49_;
							AsComponent* _tmp50_;
							FlatpakRemoteRef* _tmp51_;
							AsComponent* _tmp52_;
							FlatpakInstallation* _tmp53_;
							PamacFlatpakPackageLinked* _tmp54_;
							GHashTable* _tmp55_;
							gchar* _tmp56_;
							PamacFlatpakPackageLinked* _tmp57_;
							PamacFlatpakPackageLinked* _tmp58_;
							_tmp37_ = self->priv->installation;
							_tmp38_ = remote;
							_tmp39_ = name;
							_tmp40_ = arch;
							_tmp41_ = branch;
							_tmp42_ = flatpak_installation_fetch_remote_ref_sync_full (_tmp37_, _tmp38_, FLATPAK_REF_KIND_APP, _tmp39_, _tmp40_, _tmp41_, FLATPAK_QUERY_FLAGS_ONLY_CACHED, NULL, &_inner_error0_);
							_tmp36_ = _tmp42_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_tmp43_ = _tmp36_;
							_tmp36_ = NULL;
							_g_object_unref0 (remote_ref);
							remote_ref = _tmp43_;
							_tmp44_ = self->priv->remote_refs_table;
							_tmp45_ = g_strdup (id);
							_tmp46_ = remote_ref;
							_tmp47_ = _g_object_ref0 (_tmp46_);
							g_hash_table_insert (_tmp44_, _tmp45_, _tmp47_);
							_tmp48_ = remote_ref;
							_tmp49_ = pamac_flat_pak_get_remote_ref_matching_app (self, _tmp48_);
							_tmp50_ = _g_object_ref0 (_tmp49_);
							app = _tmp50_;
							_tmp51_ = remote_ref;
							_tmp52_ = app;
							_tmp53_ = self->priv->installation;
							_tmp54_ = pamac_flatpak_package_linked_new (NULL, _tmp51_, _tmp52_, _tmp53_, FALSE);
							_g_object_unref0 (new_pkg);
							new_pkg = _tmp54_;
							_tmp55_ = self->priv->pkgs_cache;
							_tmp56_ = g_strdup (id);
							_tmp57_ = new_pkg;
							_tmp58_ = _g_object_ref0 (_tmp57_);
							g_hash_table_insert (_tmp55_, _tmp56_, _tmp58_);
							_g_object_unref0 (app);
							_g_object_unref0 (_tmp36_);
						}
						goto __finally2;
						__catch2_g_error:
						{
							GError* e = NULL;
							GError* _tmp59_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp59_ = e;
							if (!g_error_matches (_tmp59_, FLATPAK_ERROR, FLATPAK_ERROR_REF_NOT_FOUND)) {
								GError* _tmp60_;
								const gchar* _tmp61_;
								_tmp60_ = e;
								_tmp61_ = _tmp60_->message;
								g_warning ("flatpak_plugin.vala:610: %s", _tmp61_);
							}
							_g_error_free0 (e);
						}
						__finally2:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (remote_ref);
							_g_error_free0 (e);
							_g_object_unref0 (new_pkg);
							splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
							{
								GHashTable* _tmp62_;
								_tmp62_ = self->priv->pkgs_cache;
								g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
							}
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_g_object_unref0 (remote_ref);
				} else {
					GError* _tmp63_;
					const gchar* _tmp64_;
					_tmp63_ = e;
					_tmp64_ = _tmp63_->message;
					g_warning ("flatpak_plugin.vala:615: %s", _tmp64_);
				}
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (new_pkg);
				splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp65_ = new_pkg;
			pkg = _tmp65_;
			_g_object_unref0 (new_pkg);
			splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
		}
		__finally0:
		{
			GHashTable* _tmp66_;
			_tmp66_ = self->priv->pkgs_cache;
			g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp67_ = pkg;
	result = (PamacFlatpakPackage*) _tmp67_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
pamac_flat_pak_real_search_flatpaks (PamacFlatpakPlugin* base,
                                     const gchar* search_string,
                                     GPtrArray** pkgs)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	g_return_if_fail (search_string != NULL);
	g_return_if_fail (*pkgs != NULL);
	{
		GPtrArray* _tmp0_;
		_tmp0_ = self->priv->stores_table;
		g_rec_mutex_lock (&self->priv->__lock_stores_table);
		{
			GPtrArray* _tmp1_;
			_tmp1_ = self->priv->stores_table;
			{
				GPtrArray* apps_collection = NULL;
				guint apps_index = 0U;
				apps_collection = _tmp1_;
				for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
					GHashTable* apps = NULL;
					apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
					{
						GHashTableIter iter = {0};
						GHashTable* _tmp2_;
						AsComponent* app = NULL;
						_tmp2_ = apps;
						g_hash_table_iter_init (&iter, _tmp2_);
						while (TRUE) {
							gconstpointer _tmp3_ = NULL;
							gboolean _tmp4_;
							gchar** search_tokens = NULL;
							gchar** _tmp5_;
							gchar** _tmp6_;
							gint search_tokens_length1;
							gint _search_tokens_size_;
							guint match_score = 0U;
							AsComponent* _tmp7_;
							gchar** _tmp8_;
							gint _tmp8__length1;
							gboolean _tmp9_ = FALSE;
							_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp3_));
							app = (AsComponent*) _tmp3_;
							if (!_tmp4_) {
								break;
							}
							_tmp6_ = _tmp5_ = g_strsplit (search_string, " ", 0);
							search_tokens = _tmp6_;
							search_tokens_length1 = _vala_array_length (_tmp5_);
							_search_tokens_size_ = search_tokens_length1;
							_tmp7_ = app;
							_tmp8_ = search_tokens;
							_tmp8__length1 = search_tokens_length1;
							match_score = as_component_search_matches_all (_tmp7_, _tmp8_);
							if (match_score > ((guint) 0)) {
								_tmp9_ = TRUE;
							} else {
								AsComponent* _tmp10_;
								const gchar* _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								_tmp10_ = app;
								_tmp11_ = as_component_get_id (_tmp10_);
								_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
								_tmp13_ = _tmp12_;
								_tmp9_ = string_contains (_tmp13_, search_string);
								_g_free0 (_tmp13_);
							}
							if (_tmp9_) {
								PamacFlatpakPackage* pkg = NULL;
								AsComponent* _tmp14_;
								PamacFlatpakPackageLinked* _tmp15_;
								PamacFlatpakPackage* _tmp16_;
								_tmp14_ = app;
								_tmp15_ = pamac_flat_pak_get_flatpak_from_app (self, _tmp14_);
								pkg = (PamacFlatpakPackage*) _tmp15_;
								_tmp16_ = pkg;
								if (_tmp16_ != NULL) {
									PamacFlatpakPackage* _tmp17_;
									_tmp17_ = pkg;
									g_ptr_array_add (*pkgs, _tmp17_);
								}
							}
							search_tokens = (_vala_array_free (search_tokens, search_tokens_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
		}
		__finally0:
		{
			GPtrArray* _tmp18_;
			_tmp18_ = self->priv->stores_table;
			g_rec_mutex_unlock (&self->priv->__lock_stores_table);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
pamac_flat_pak_real_search_uninstalled_flatpaks_sync (PamacFlatpakPlugin* base,
                                                      gchar** search_terms,
                                                      gint search_terms_length1,
                                                      GPtrArray** pkgs)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	g_return_if_fail (*pkgs != NULL);
	{
		GPtrArray* _tmp0_;
		_tmp0_ = self->priv->stores_table;
		g_rec_mutex_lock (&self->priv->__lock_stores_table);
		{
			GPtrArray* _tmp1_;
			_tmp1_ = self->priv->stores_table;
			{
				GPtrArray* apps_collection = NULL;
				guint apps_index = 0U;
				apps_collection = _tmp1_;
				for (apps_index = 0; apps_index < apps_collection->len; apps_index = apps_index + 1) {
					GHashTable* apps = NULL;
					apps = (GHashTable*) g_ptr_array_index (apps_collection, apps_index);
					{
						GHashTableIter iter = {0};
						GHashTable* _tmp2_;
						AsComponent* app = NULL;
						_tmp2_ = apps;
						g_hash_table_iter_init (&iter, _tmp2_);
						while (TRUE) {
							gconstpointer _tmp3_ = NULL;
							gboolean _tmp4_;
							guint match_score = 0U;
							AsComponent* _tmp5_;
							_tmp4_ = g_hash_table_iter_next (&iter, (gpointer*) NULL, (gpointer*) (&_tmp3_));
							app = (AsComponent*) _tmp3_;
							if (!_tmp4_) {
								break;
							}
							_tmp5_ = app;
							match_score = as_component_search_matches_all (_tmp5_, search_terms);
							if (match_score > ((guint) 0)) {
								PamacFlatpakPackage* pkg = NULL;
								AsComponent* _tmp6_;
								PamacFlatpakPackageLinked* _tmp7_;
								gboolean _tmp8_ = FALSE;
								PamacFlatpakPackage* _tmp9_;
								_tmp6_ = app;
								_tmp7_ = pamac_flat_pak_get_flatpak_from_app (self, _tmp6_);
								pkg = (PamacFlatpakPackage*) _tmp7_;
								_tmp9_ = pkg;
								if (_tmp9_ != NULL) {
									PamacFlatpakPackage* _tmp10_;
									const gchar* _tmp11_;
									const gchar* _tmp12_;
									_tmp10_ = pkg;
									_tmp11_ = pamac_package_get_installed_version ((PamacPackage*) _tmp10_);
									_tmp12_ = _tmp11_;
									_tmp8_ = _tmp12_ == NULL;
								} else {
									_tmp8_ = FALSE;
								}
								if (_tmp8_) {
									PamacFlatpakPackage* _tmp13_;
									_tmp13_ = pkg;
									g_ptr_array_add (*pkgs, _tmp13_);
								}
							}
						}
					}
				}
			}
		}
		__finally0:
		{
			GPtrArray* _tmp14_;
			_tmp14_ = self->priv->stores_table;
			g_rec_mutex_unlock (&self->priv->__lock_stores_table);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gconstpointer
_vala_hash_set_next_value (GHashTableIter *self)
{
	void* vi = NULL;
	GHashTableIter* htp = NULL;
	void* _tmp0_;
	gconstpointer value = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gboolean _tmp3_;
	gconstpointer result;
	vi = &(*self);
	_tmp0_ = vi;
	htp = _tmp0_;
	_tmp3_ = g_hash_table_iter_next (htp, (gpointer*) (&_tmp2_), (gpointer*) NULL);
	value = _tmp2_;
	if (_tmp3_) {
		gconstpointer _tmp4_;
		_tmp4_ = value;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	return result;
}

static void
pamac_flat_pak_real_get_category_flatpaks (PamacFlatpakPlugin* base,
                                           const gchar* category,
                                           GPtrArray** pkgs)
{
	PamacFlatPak * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	static GQuark _tmp1_label6 = 0;
	static GQuark _tmp1_label7 = 0;
	static GQuark _tmp1_label8 = 0;
	self = (PamacFlatPak*) base;
	g_return_if_fail (category != NULL);
	g_return_if_fail (*pkgs != NULL);
	_tmp0_ = category;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Featured")))) {
		switch (0) {
			default:
			{
				GHashTable* names = NULL;
				GHashFunc _tmp3_;
				GEqualFunc _tmp4_;
				GHashTable* _tmp5_;
				GHashTable* _tmp6_;
				gchar* _tmp7_;
				GHashTable* _tmp8_;
				gchar* _tmp9_;
				GHashTable* _tmp10_;
				gchar* _tmp11_;
				GHashTable* _tmp12_;
				gchar* _tmp13_;
				GHashTable* _tmp14_;
				gchar* _tmp15_;
				GHashTable* _tmp16_;
				gchar* _tmp17_;
				_tmp3_ = g_str_hash;
				_tmp4_ = g_str_equal;
				_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, _g_free0_);
				names = _tmp5_;
				_tmp6_ = names;
				_tmp7_ = g_strdup ("com.spotify.Client");
				g_hash_table_add (_tmp6_, _tmp7_);
				_tmp8_ = names;
				_tmp9_ = g_strdup ("com.valvesoftware.Steam.desktop");
				g_hash_table_add (_tmp8_, _tmp9_);
				_tmp10_ = names;
				_tmp11_ = g_strdup ("com.discordapp.Discord.desktop");
				g_hash_table_add (_tmp10_, _tmp11_);
				_tmp12_ = names;
				_tmp13_ = g_strdup ("com.skype.Client.desktop");
				g_hash_table_add (_tmp12_, _tmp13_);
				_tmp14_ = names;
				_tmp15_ = g_strdup ("com.mojang.Minecraft");
				g_hash_table_add (_tmp14_, _tmp15_);
				_tmp16_ = names;
				_tmp17_ = g_strdup ("com.slack.Slack.desktop");
				g_hash_table_add (_tmp16_, _tmp17_);
				{
					GHashTableIter _id_it = {0};
					GHashTable* _tmp18_;
					GHashTableIter _tmp19_ = {0};
					const gchar* id = NULL;
					_tmp18_ = names;
					g_hash_table_iter_init (&_tmp19_, _tmp18_);
					_id_it = _tmp19_;
					while (TRUE) {
						gconstpointer _tmp20_;
						const gchar* _tmp21_;
						PamacFlatpakPackage* pkg = NULL;
						const gchar* _tmp22_;
						PamacFlatpakPackage* _tmp23_;
						PamacFlatpakPackage* _tmp24_;
						_tmp20_ = _vala_hash_set_next_value (&_id_it);
						id = (const gchar*) _tmp20_;
						_tmp21_ = id;
						if (!(_tmp21_ != NULL)) {
							break;
						}
						_tmp22_ = id;
						_tmp23_ = pamac_flatpak_plugin_get_flatpak_by_app_id ((PamacFlatpakPlugin*) self, _tmp22_);
						pkg = _tmp23_;
						_tmp24_ = pkg;
						if (_tmp24_ != NULL) {
							PamacFlatpakPackage* _tmp25_;
							_tmp25_ = pkg;
							g_ptr_array_add (*pkgs, _tmp25_);
						}
					}
				}
				_g_hash_table_unref0 (names);
				break;
			}
		}
	} else if ((((((((_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Photo & Video")))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Music & Audio"))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Productivity"))))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("Communication & News"))))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Education & Science"))))) || (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("Games"))))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("Utilities"))))) || (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("Development"))))) {
		switch (0) {
			default:
			{
				GHashTable* category_table = NULL;
				GHashTable* _tmp26_;
				gconstpointer _tmp27_;
				GHashTableIter iter = {0};
				GHashTable* _tmp28_;
				const gchar* id = NULL;
				AsComponent* app = NULL;
				_tmp26_ = self->priv->categories_cache;
				_tmp27_ = g_hash_table_lookup (_tmp26_, category);
				category_table = (GHashTable*) _tmp27_;
				_tmp28_ = category_table;
				g_hash_table_iter_init (&iter, _tmp28_);
				while (TRUE) {
					gconstpointer _tmp29_ = NULL;
					gconstpointer _tmp30_ = NULL;
					gboolean _tmp31_;
					PamacFlatpakPackage* pkg = NULL;
					AsComponent* _tmp32_;
					PamacFlatpakPackageLinked* _tmp33_;
					PamacFlatpakPackage* _tmp34_;
					_tmp31_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp29_), (gpointer*) (&_tmp30_));
					id = (const gchar*) _tmp29_;
					app = (AsComponent*) _tmp30_;
					if (!_tmp31_) {
						break;
					}
					_tmp32_ = app;
					_tmp33_ = pamac_flat_pak_get_flatpak_from_app (self, _tmp32_);
					pkg = (PamacFlatpakPackage*) _tmp33_;
					_tmp34_ = pkg;
					if (_tmp34_ != NULL) {
						PamacFlatpakPackage* _tmp35_;
						_tmp35_ = pkg;
						g_ptr_array_add (*pkgs, _tmp35_);
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
pamac_flat_pak_real_get_flatpak_updates (PamacFlatpakPlugin* base,
                                         GPtrArray** pkgs)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	g_return_if_fail (*pkgs != NULL);
	{
		{
			GHashTable* _tmp0_;
			_tmp0_ = self->priv->pkgs_cache;
			g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
			{
				GPtrArray* update_apps = NULL;
				FlatpakInstallation* _tmp1_;
				GPtrArray* _tmp2_;
				_tmp1_ = self->priv->installation;
				_tmp2_ = flatpak_installation_list_installed_refs_for_update (_tmp1_, NULL, &_inner_error0_);
				update_apps = _tmp2_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				{
					GPtrArray* installed_ref_collection = NULL;
					guint installed_ref_index = 0U;
					installed_ref_collection = update_apps;
					for (installed_ref_index = 0; installed_ref_index < installed_ref_collection->len; installed_ref_index = installed_ref_index + 1) {
						FlatpakInstalledRef* installed_ref = NULL;
						installed_ref = (FlatpakInstalledRef*) g_ptr_array_index (installed_ref_collection, installed_ref_index);
						{
							gboolean _tmp3_ = FALSE;
							FlatpakInstalledRef* _tmp4_;
							FlatpakRefKind _tmp5_;
							FlatpakRefKind _tmp6_;
							_tmp4_ = installed_ref;
							_tmp5_ = flatpak_ref_get_kind ((FlatpakRef*) _tmp4_);
							_tmp6_ = _tmp5_;
							if (_tmp6_ == FLATPAK_REF_KIND_APP) {
								_tmp3_ = TRUE;
							} else {
								FlatpakInstalledRef* _tmp7_;
								FlatpakRefKind _tmp8_;
								FlatpakRefKind _tmp9_;
								_tmp7_ = installed_ref;
								_tmp8_ = flatpak_ref_get_kind ((FlatpakRef*) _tmp7_);
								_tmp9_ = _tmp8_;
								_tmp3_ = _tmp9_ == FLATPAK_REF_KIND_RUNTIME;
							}
							if (_tmp3_) {
								gchar* id = NULL;
								FlatpakInstalledRef* _tmp10_;
								const gchar* _tmp11_;
								FlatpakInstalledRef* _tmp12_;
								gchar* _tmp13_;
								gchar* _tmp14_;
								gchar* _tmp15_;
								gchar* _tmp16_;
								PamacFlatpakPackageLinked* pkg = NULL;
								GHashTable* _tmp17_;
								const gchar* _tmp18_;
								gconstpointer _tmp19_;
								PamacFlatpakPackageLinked* _tmp20_;
								PamacFlatpakPackageLinked* _tmp21_;
								PamacFlatpakPackageLinked* _tmp32_;
								PamacFlatpakPackage* _tmp33_;
								_tmp10_ = installed_ref;
								_tmp11_ = flatpak_installed_ref_get_origin (_tmp10_);
								_tmp12_ = installed_ref;
								_tmp13_ = flatpak_ref_format_ref ((FlatpakRef*) _tmp12_);
								_tmp14_ = _tmp13_;
								_tmp15_ = g_strdup_printf ("%s/%s", _tmp11_, _tmp14_);
								_tmp16_ = _tmp15_;
								_g_free0 (_tmp14_);
								id = _tmp16_;
								_tmp17_ = self->priv->pkgs_cache;
								_tmp18_ = id;
								_tmp19_ = g_hash_table_lookup (_tmp17_, _tmp18_);
								_tmp20_ = _g_object_ref0 ((PamacFlatpakPackageLinked*) _tmp19_);
								pkg = _tmp20_;
								_tmp21_ = pkg;
								if (_tmp21_ == NULL) {
									AsComponent* app = NULL;
									FlatpakInstalledRef* _tmp22_;
									AsComponent* _tmp23_;
									FlatpakInstalledRef* _tmp24_;
									AsComponent* _tmp25_;
									FlatpakInstallation* _tmp26_;
									PamacFlatpakPackageLinked* _tmp27_;
									GHashTable* _tmp28_;
									gchar* _tmp29_;
									PamacFlatpakPackageLinked* _tmp30_;
									PamacFlatpakPackageLinked* _tmp31_;
									_tmp22_ = installed_ref;
									_tmp23_ = pamac_flat_pak_get_installed_ref_matching_app (self, _tmp22_);
									app = _tmp23_;
									_tmp24_ = installed_ref;
									_tmp25_ = app;
									_tmp26_ = self->priv->installation;
									_tmp27_ = pamac_flatpak_package_linked_new (_tmp24_, NULL, _tmp25_, _tmp26_, TRUE);
									_g_object_unref0 (pkg);
									pkg = _tmp27_;
									_tmp28_ = self->priv->pkgs_cache;
									_tmp29_ = id;
									id = NULL;
									_tmp30_ = pkg;
									_tmp31_ = _g_object_ref0 (_tmp30_);
									g_hash_table_insert (_tmp28_, _tmp29_, _tmp31_);
									_g_object_unref0 (app);
								}
								_tmp32_ = pkg;
								_tmp33_ = _g_object_ref0 ((PamacFlatpakPackage*) _tmp32_);
								g_ptr_array_add (*pkgs, _tmp33_);
								_g_object_unref0 (pkg);
								_g_free0 (id);
							}
						}
					}
				}
				_g_ptr_array_unref0 (update_apps);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp34_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp34_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp34_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				GHashTable* _tmp35_;
				_tmp35_ = self->priv->pkgs_cache;
				g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp36_;
		const gchar* _tmp37_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp36_ = e;
		_tmp37_ = _tmp36_->message;
		g_warning ("flatpak_plugin.vala:719: %s", _tmp37_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
pamac_flat_pak_on_add_new_remote (PamacFlatPak* self,
                                  FlatpakTransactionRemoteReason reason,
                                  const gchar* from_id,
                                  const gchar* remote_name,
                                  const gchar* url)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (from_id != NULL, FALSE);
	g_return_val_if_fail (remote_name != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	if (reason == FLATPAK_TRANSACTION_REMOTE_GENERIC_REPO) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_strdup_printf ("Configuring %s as new generic remote", url);
		_tmp1_ = _tmp0_;
		pamac_flat_pak_do_emit_script_output (self, _tmp1_);
		_g_free0 (_tmp1_);
		result = TRUE;
		return result;
	}
	if (reason == FLATPAK_TRANSACTION_REMOTE_RUNTIME_DEPS) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup_printf ("Configuring %s as new remote for deps", url);
		_tmp3_ = _tmp2_;
		pamac_flat_pak_do_emit_script_output (self, _tmp3_);
		_g_free0 (_tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
pamac_flat_pak_on_choose_remote_for_ref (PamacFlatPak* self,
                                         const gchar* for_ref,
                                         const gchar* runtime_ref,
                                         gchar** remotes)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (for_ref != NULL, 0);
	g_return_val_if_fail (runtime_ref != NULL, 0);
	g_print ("choose a provider for %s\n", runtime_ref);
	result = 0;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PamacFlatPak* self;
		self = _data1_->self;
		_g_free0 (_data1_->action);
		_g_object_unref0 (_data1_->operation);
		_g_object_unref0 (_data1_->progress);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda4_ (Block1Data* _data1_)
{
	PamacFlatPak* self;
	const gchar* _tmp6_;
	self = _data1_->self;
	if (flatpak_transaction_progress_get_is_estimating (_data1_->progress)) {
		return;
	}
	switch (flatpak_transaction_operation_get_operation_type (_data1_->operation)) {
		case FLATPAK_TRANSACTION_OPERATION_INSTALL:
		{
			const gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp1_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), _tmp0_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp1_;
			break;
		}
		case FLATPAK_TRANSACTION_OPERATION_UNINSTALL:
		{
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp3_ = g_strdup_printf (g_dgettext (NULL, "Removing %s"), _tmp2_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp3_;
			break;
		}
		case FLATPAK_TRANSACTION_OPERATION_UPDATE:
		{
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp5_ = g_strdup_printf (g_dgettext (NULL, "Upgrading %s"), _tmp4_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp5_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp6_ = _data1_->action;
	if (_tmp6_ != NULL) {
		if (flatpak_transaction_progress_get_progress (_data1_->progress) == 100) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = flatpak_transaction_progress_get_status (_data1_->progress);
			_tmp8_ = _tmp7_;
			pamac_flat_pak_do_emit_script_output (self, _tmp8_);
			_g_free0 (_tmp8_);
			_tmp9_ = _data1_->action;
			pamac_flat_pak_do_emit_action_progress (self, _tmp9_, "", (gdouble) 1);
		} else {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp10_ = _data1_->action;
			_tmp11_ = flatpak_transaction_progress_get_status (_data1_->progress);
			_tmp12_ = _tmp11_;
			pamac_flat_pak_do_emit_action_progress (self, _tmp10_, _tmp12_, ((gdouble) flatpak_transaction_progress_get_progress (_data1_->progress)) / 100);
			_g_free0 (_tmp12_);
		}
	}
}

static void
___lambda4__flatpak_transaction_progress_changed (FlatpakTransactionProgress* _sender,
                                                  gpointer self)
{
	__lambda4_ (self);
}

static void
pamac_flat_pak_on_new_operation (PamacFlatPak* self,
                                 FlatpakTransactionOperation* operation,
                                 FlatpakTransactionProgress* progress)
{
	Block1Data* _data1_;
	FlatpakTransactionOperation* _tmp0_;
	FlatpakTransactionProgress* _tmp1_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (operation != NULL);
	g_return_if_fail (progress != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (operation);
	_g_object_unref0 (_data1_->operation);
	_data1_->operation = _tmp0_;
	_tmp1_ = _g_object_ref0 (progress);
	_g_object_unref0 (_data1_->progress);
	_data1_->progress = _tmp1_;
	_data1_->action = NULL;
	switch (flatpak_transaction_operation_get_operation_type (_data1_->operation)) {
		case FLATPAK_TRANSACTION_OPERATION_INSTALL:
		{
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp3_ = g_strdup_printf (g_dgettext (NULL, "Installing %s"), _tmp2_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp3_;
			break;
		}
		case FLATPAK_TRANSACTION_OPERATION_UNINSTALL:
		{
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp5_ = g_strdup_printf (g_dgettext (NULL, "Removing %s"), _tmp4_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp5_;
			break;
		}
		case FLATPAK_TRANSACTION_OPERATION_UPDATE:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = flatpak_transaction_operation_get_ref (_data1_->operation);
			_tmp7_ = g_strdup_printf (g_dgettext (NULL, "Upgrading %s"), _tmp6_);
			_g_free0 (_data1_->action);
			_data1_->action = _tmp7_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp8_ = _data1_->action;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = _data1_->action;
		_tmp10_ = flatpak_transaction_progress_get_status (_data1_->progress);
		_tmp11_ = _tmp10_;
		pamac_flat_pak_do_emit_action_progress (self, _tmp9_, _tmp11_, (gdouble) 0);
		_g_free0 (_tmp11_);
	}
	g_signal_connect_data (_data1_->progress, "changed", (GCallback) ___lambda4__flatpak_transaction_progress_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	flatpak_transaction_progress_set_update_frequency (_data1_->progress, (guint) 100);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static gboolean
pamac_flat_pak_on_operation_error (PamacFlatPak* self,
                                   FlatpakTransactionOperation* operation,
                                   GError* _error_,
                                   FlatpakTransactionErrorDetails detail)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (operation != NULL, FALSE);
	g_return_val_if_fail (_error_ != NULL, FALSE);
	_tmp0_ = _error_->message;
	pamac_flat_pak_do_emit_script_output (self, _tmp0_);
	result = TRUE;
	return result;
}

static void
pamac_flat_pak_do_emit_action_progress (PamacFlatPak* self,
                                        const gchar* action,
                                        const gchar* status,
                                        gdouble progress)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (status != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacFlatpakPlugin*) self, "emit-action-progress", _tmp0_, action, status, progress);
}

static void
pamac_flat_pak_do_emit_script_output (PamacFlatPak* self,
                                      const gchar* message)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacFlatpakPlugin*) self, "emit-script-output", _tmp0_, message);
}

static void
pamac_flat_pak_do_emit_error (PamacFlatPak* self,
                              const gchar* message,
                              gchar** details,
                              gint details_length1)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->sender;
	g_signal_emit_by_name ((PamacFlatpakPlugin*) self, "emit-error", _tmp0_, message, details, (gint) details_length1);
}

static gboolean
___lambda5_ (PamacFlatPak* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
____lambda5__flatpak_transaction_ready (FlatpakTransaction* _sender,
                                        gpointer self)
{
	gboolean result;
	result = ___lambda5_ ((PamacFlatPak*) self);
	return result;
}

static gboolean
_pamac_flat_pak_on_add_new_remote_flatpak_transaction_add_new_remote (FlatpakTransaction* _sender,
                                                                      FlatpakTransactionRemoteReason reason,
                                                                      const gchar* from_id,
                                                                      const gchar* remote_name,
                                                                      const gchar* url,
                                                                      gpointer self)
{
	gboolean result;
	result = pamac_flat_pak_on_add_new_remote ((PamacFlatPak*) self, reason, from_id, remote_name, url);
	return result;
}

static gint
_pamac_flat_pak_on_choose_remote_for_ref_flatpak_transaction_choose_remote_for_ref (FlatpakTransaction* _sender,
                                                                                    const gchar* for_ref,
                                                                                    const gchar* runtime_ref,
                                                                                    gchar** remotes,
                                                                                    gpointer self)
{
	gint result;
	result = pamac_flat_pak_on_choose_remote_for_ref ((PamacFlatPak*) self, for_ref, runtime_ref, remotes);
	return result;
}

static void
_pamac_flat_pak_on_new_operation_flatpak_transaction_new_operation (FlatpakTransaction* _sender,
                                                                    FlatpakTransactionOperation* operation,
                                                                    FlatpakTransactionProgress* progress,
                                                                    gpointer self)
{
	pamac_flat_pak_on_new_operation ((PamacFlatPak*) self, operation, progress);
}

static gboolean
_pamac_flat_pak_on_operation_error_flatpak_transaction_operation_error (FlatpakTransaction* _sender,
                                                                        FlatpakTransactionOperation* operation,
                                                                        GError* _error_,
                                                                        FlatpakTransactionErrorDetails detail,
                                                                        gpointer self)
{
	gboolean result;
	result = pamac_flat_pak_on_operation_error ((PamacFlatPak*) self, operation, _error_, detail);
	return result;
}

static gboolean
pamac_flat_pak_real_trans_run (PamacFlatpakPlugin* base,
                               const gchar* sender,
                               gchar** to_install,
                               gint to_install_length1,
                               gchar** to_remove,
                               gint to_remove_length1,
                               gchar** to_upgrade,
                               gint to_upgrade_length1)
{
	PamacFlatPak * self;
	gchar* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp57_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PamacFlatPak*) base;
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = g_strdup (sender);
	_g_free0 (self->priv->sender);
	self->priv->sender = _tmp0_;
	_tmp1_ = self->priv->cancellable;
	g_cancellable_reset (_tmp1_);
	{
		FlatpakTransaction* transaction = NULL;
		FlatpakInstallation* _tmp2_;
		GCancellable* _tmp3_;
		FlatpakTransaction* _tmp4_;
		FlatpakTransaction* _tmp45_;
		FlatpakTransaction* _tmp46_;
		FlatpakTransaction* _tmp47_;
		FlatpakTransaction* _tmp48_;
		FlatpakTransaction* _tmp49_;
		gboolean success = FALSE;
		FlatpakTransaction* _tmp50_;
		GCancellable* _tmp51_;
		_tmp2_ = self->priv->installation;
		_tmp3_ = self->priv->cancellable;
		_tmp4_ = flatpak_transaction_new_for_installation (_tmp2_, _tmp3_, &_inner_error0_);
		transaction = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			gchar** id_collection = NULL;
			gint id_collection_length1 = 0;
			gint _id_collection_size_ = 0;
			gint id_it = 0;
			id_collection = to_install;
			id_collection_length1 = to_install_length1;
			for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
				const gchar* id = NULL;
				id = id_collection[id_it];
				{
					gchar** splitted = NULL;
					const gchar* _tmp5_;
					gchar** _tmp6_;
					gchar** _tmp7_;
					gint splitted_length1;
					gint _splitted_size_;
					gchar* remote = NULL;
					gchar** _tmp8_;
					gint _tmp8__length1;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* name = NULL;
					gchar** _tmp11_;
					gint _tmp11__length1;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					FlatpakTransaction* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp5_ = id;
					_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, "/", 2);
					splitted = _tmp7_;
					splitted_length1 = _vala_array_length (_tmp6_);
					_splitted_size_ = splitted_length1;
					_tmp8_ = splitted;
					_tmp8__length1 = splitted_length1;
					_tmp9_ = _tmp8_[0];
					_tmp10_ = g_strdup (_tmp9_);
					remote = _tmp10_;
					_tmp11_ = splitted;
					_tmp11__length1 = splitted_length1;
					_tmp12_ = _tmp11_[1];
					_tmp13_ = g_strdup (_tmp12_);
					name = _tmp13_;
					_tmp14_ = transaction;
					_tmp15_ = remote;
					_tmp16_ = name;
					flatpak_transaction_add_install (_tmp14_, _tmp15_, _tmp16_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (name);
						_g_free0 (remote);
						splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (transaction);
						goto __catch0_g_error;
					}
					_g_free0 (name);
					_g_free0 (remote);
					splitted = (_vala_array_free (splitted, splitted_length1, (GDestroyNotify) g_free), NULL);
				}
			}
		}
		{
			gchar** id_collection = NULL;
			gint id_collection_length1 = 0;
			gint _id_collection_size_ = 0;
			gint id_it = 0;
			id_collection = to_remove;
			id_collection_length1 = to_remove_length1;
			for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
				const gchar* id = NULL;
				id = id_collection[id_it];
				{
					gchar* name = NULL;
					const gchar* _tmp17_;
					gchar** _tmp18_;
					gchar** _tmp19_;
					gchar** _tmp20_;
					gint _tmp20__length1;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					FlatpakTransaction* _tmp24_;
					const gchar* _tmp25_;
					_tmp17_ = id;
					_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, "/", 2);
					_tmp20_ = _tmp19_;
					_tmp20__length1 = _vala_array_length (_tmp18_);
					_tmp21_ = _tmp20_[1];
					_tmp22_ = g_strdup (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
					name = _tmp23_;
					_tmp24_ = transaction;
					_tmp25_ = name;
					flatpak_transaction_add_uninstall (_tmp24_, _tmp25_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (name);
						_g_object_unref0 (transaction);
						goto __catch0_g_error;
					}
					_g_free0 (name);
				}
			}
		}
		{
			gchar** id_collection = NULL;
			gint id_collection_length1 = 0;
			gint _id_collection_size_ = 0;
			gint id_it = 0;
			id_collection = to_upgrade;
			id_collection_length1 = to_upgrade_length1;
			for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
				const gchar* id = NULL;
				id = id_collection[id_it];
				{
					gchar* name = NULL;
					const gchar* _tmp26_;
					gchar** _tmp27_;
					gchar** _tmp28_;
					gchar** _tmp29_;
					gint _tmp29__length1;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					FlatpakTransaction* _tmp33_;
					const gchar* _tmp34_;
					_tmp26_ = id;
					_tmp28_ = _tmp27_ = g_strsplit (_tmp26_, "/", 2);
					_tmp29_ = _tmp28_;
					_tmp29__length1 = _vala_array_length (_tmp27_);
					_tmp30_ = _tmp29_[1];
					_tmp31_ = g_strdup (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
					name = _tmp32_;
					_tmp33_ = transaction;
					_tmp34_ = name;
					flatpak_transaction_add_update (_tmp33_, _tmp34_, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (name);
						_g_object_unref0 (transaction);
						goto __catch0_g_error;
					}
					_g_free0 (name);
				}
			}
		}
		if (to_upgrade_length1 > 0) {
			GPtrArray* update_apps = NULL;
			FlatpakInstallation* _tmp35_;
			GPtrArray* _tmp36_;
			GPtrArray* _tmp37_;
			_tmp35_ = self->priv->installation;
			_tmp36_ = flatpak_installation_list_installed_refs_for_update (_tmp35_, NULL, &_inner_error0_);
			update_apps = _tmp36_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (transaction);
				goto __catch0_g_error;
			}
			_tmp37_ = update_apps;
			{
				GPtrArray* installed_ref_collection = NULL;
				guint installed_ref_index = 0U;
				installed_ref_collection = _tmp37_;
				for (installed_ref_index = 0; installed_ref_index < installed_ref_collection->len; installed_ref_index = installed_ref_index + 1) {
					FlatpakInstalledRef* installed_ref = NULL;
					installed_ref = (FlatpakInstalledRef*) g_ptr_array_index (installed_ref_collection, installed_ref_index);
					{
						FlatpakInstalledRef* _tmp38_;
						FlatpakRefKind _tmp39_;
						FlatpakRefKind _tmp40_;
						_tmp38_ = installed_ref;
						_tmp39_ = flatpak_ref_get_kind ((FlatpakRef*) _tmp38_);
						_tmp40_ = _tmp39_;
						if (_tmp40_ == FLATPAK_REF_KIND_RUNTIME) {
							FlatpakTransaction* _tmp41_;
							FlatpakInstalledRef* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp44_;
							_tmp41_ = transaction;
							_tmp42_ = installed_ref;
							_tmp43_ = flatpak_ref_format_ref ((FlatpakRef*) _tmp42_);
							_tmp44_ = _tmp43_;
							flatpak_transaction_add_update (_tmp41_, _tmp44_, NULL, NULL, &_inner_error0_);
							_g_free0 (_tmp44_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_ptr_array_unref0 (update_apps);
								_g_object_unref0 (transaction);
								goto __catch0_g_error;
							}
						}
					}
				}
			}
			_g_ptr_array_unref0 (update_apps);
		}
		_tmp45_ = transaction;
		g_signal_connect_object (_tmp45_, "ready", (GCallback) ____lambda5__flatpak_transaction_ready, self, 0);
		_tmp46_ = transaction;
		g_signal_connect_object (_tmp46_, "add-new-remote", (GCallback) _pamac_flat_pak_on_add_new_remote_flatpak_transaction_add_new_remote, self, 0);
		_tmp47_ = transaction;
		g_signal_connect_object (_tmp47_, "choose-remote-for-ref", (GCallback) _pamac_flat_pak_on_choose_remote_for_ref_flatpak_transaction_choose_remote_for_ref, self, 0);
		_tmp48_ = transaction;
		g_signal_connect_object (_tmp48_, "new-operation", (GCallback) _pamac_flat_pak_on_new_operation_flatpak_transaction_new_operation, self, 0);
		_tmp49_ = transaction;
		g_signal_connect_object (_tmp49_, "operation-error", (GCallback) _pamac_flat_pak_on_operation_error_flatpak_transaction_operation_error, self, 0);
		_tmp50_ = transaction;
		_tmp51_ = self->priv->cancellable;
		success = flatpak_transaction_run (_tmp50_, _tmp51_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (transaction);
			goto __catch0_g_error;
		}
		pamac_flatpak_plugin_refresh ((PamacFlatpakPlugin*) self);
		result = success;
		_g_object_unref0 (transaction);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar** _tmp55_;
		gchar** _tmp56_;
		gint _tmp56__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		_tmp54_ = g_strdup (_tmp53_);
		_tmp55_ = g_new0 (gchar*, 1 + 1);
		_tmp55_[0] = _tmp54_;
		_tmp56_ = _tmp55_;
		_tmp56__length1 = 1;
		pamac_flat_pak_do_emit_error (self, g_dgettext (NULL, "Flatpak transaction failed"), _tmp56_, (gint) 1);
		_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp57_;
}

static void
pamac_flat_pak_real_trans_cancel (PamacFlatpakPlugin* base,
                                  const gchar* sender)
{
	PamacFlatPak * self;
	const gchar* _tmp0_;
	self = (PamacFlatPak*) base;
	g_return_if_fail (sender != NULL);
	_tmp0_ = self->priv->sender;
	if (g_strcmp0 (sender, _tmp0_) == 0) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
pamac_flat_pak_real_refresh (PamacFlatpakPlugin* base)
{
	PamacFlatPak * self;
	GError* _inner_error0_ = NULL;
	self = (PamacFlatPak*) base;
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->pkgs_cache;
		g_rec_mutex_lock (&self->priv->__lock_pkgs_cache);
		{
			GHashTable* _tmp1_;
			_tmp1_ = self->priv->pkgs_cache;
			g_hash_table_remove_all (_tmp1_);
		}
		__finally0:
		{
			GHashTable* _tmp2_;
			_tmp2_ = self->priv->pkgs_cache;
			g_rec_mutex_unlock (&self->priv->__lock_pkgs_cache);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static guint64
pamac_flat_pak_real_get_refresh_period (PamacFlatpakPlugin* base)
{
	guint64 result;
	PamacFlatPak* self;
	self = (PamacFlatPak*) base;
	result = self->priv->_refresh_period;
	return result;
}

static void
pamac_flat_pak_real_set_refresh_period (PamacFlatpakPlugin* base,
                                        guint64 value)
{
	PamacFlatPak* self;
	guint64 old_value;
	self = (PamacFlatPak*) base;
	old_value = pamac_flat_pak_real_get_refresh_period (base);
	if (old_value != value) {
		self->priv->_refresh_period = value;
		g_object_notify_by_pspec ((GObject *) self, pamac_flat_pak_properties[PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY]);
	}
}

static void
_g_hash_table_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}

static GObject *
pamac_flat_pak_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PamacFlatPak * self;
	GCancellable* _tmp0_;
	GPtrArray* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pamac_flat_pak_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_FLAT_PAK, PamacFlatPak);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_hash_table_unref0_);
	_g_ptr_array_unref0 (self->priv->stores_table);
	self->priv->stores_table = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->remote_refs_table);
	self->priv->remote_refs_table = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->pkgs_cache);
	self->priv->pkgs_cache = _tmp7_;
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->categories_cache);
	self->priv->categories_cache = _tmp10_;
	{
		FlatpakInstallation* _tmp11_ = NULL;
		FlatpakInstallation* _tmp12_;
		FlatpakInstallation* _tmp13_;
		_tmp12_ = flatpak_installation_new_system (NULL, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (self->priv->installation);
		self->priv->installation = _tmp13_;
		_g_object_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("flatpak_plugin.vala:274: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
pamac_flat_pak_class_init (PamacFlatPakClass * klass,
                           gpointer klass_data)
{
	pamac_flat_pak_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PamacFlatPak_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pamac_flat_pak_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pamac_flat_pak_set_property;
	G_OBJECT_CLASS (klass)->constructor = pamac_flat_pak_constructor;
	G_OBJECT_CLASS (klass)->finalize = pamac_flat_pak_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY, pamac_flat_pak_properties[PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY] = g_param_spec_uint64 ("refresh-period", "refresh-period", "refresh-period", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
pamac_flat_pak_pamac_flatpak_plugin_interface_init (PamacFlatpakPluginIface * iface,
                                                    gpointer iface_data)
{
	pamac_flat_pak_pamac_flatpak_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->load_appstream_data = (void (*) (PamacFlatpakPlugin*)) pamac_flat_pak_real_load_appstream_data;
	iface->refresh_appstream_data = (gboolean (*) (PamacFlatpakPlugin*)) pamac_flat_pak_real_refresh_appstream_data;
	iface->get_remotes_names = (void (*) (PamacFlatpakPlugin*, GPtrArray**)) pamac_flat_pak_real_get_remotes_names;
	iface->get_installed_flatpaks = (void (*) (PamacFlatpakPlugin*, GPtrArray**)) pamac_flat_pak_real_get_installed_flatpaks;
	iface->is_installed_flatpak = (gboolean (*) (PamacFlatpakPlugin*, const gchar*)) pamac_flat_pak_real_is_installed_flatpak;
	iface->get_flatpak_by_app_id = (PamacFlatpakPackage* (*) (PamacFlatpakPlugin*, const gchar*)) pamac_flat_pak_real_get_flatpak_by_app_id;
	iface->get_flatpak = (PamacFlatpakPackage* (*) (PamacFlatpakPlugin*, const gchar*)) pamac_flat_pak_real_get_flatpak;
	iface->search_flatpaks = (void (*) (PamacFlatpakPlugin*, const gchar*, GPtrArray**)) pamac_flat_pak_real_search_flatpaks;
	iface->search_uninstalled_flatpaks_sync = (void (*) (PamacFlatpakPlugin*, gchar**, gint, GPtrArray**)) pamac_flat_pak_real_search_uninstalled_flatpaks_sync;
	iface->get_category_flatpaks = (void (*) (PamacFlatpakPlugin*, const gchar*, GPtrArray**)) pamac_flat_pak_real_get_category_flatpaks;
	iface->get_flatpak_updates = (void (*) (PamacFlatpakPlugin*, GPtrArray**)) pamac_flat_pak_real_get_flatpak_updates;
	iface->trans_run = (gboolean (*) (PamacFlatpakPlugin*, const gchar*, gchar**, gint, gchar**, gint, gchar**, gint)) pamac_flat_pak_real_trans_run;
	iface->trans_cancel = (void (*) (PamacFlatpakPlugin*, const gchar*)) pamac_flat_pak_real_trans_cancel;
	iface->refresh = (void (*) (PamacFlatpakPlugin*)) pamac_flat_pak_real_refresh;
	iface->get_refresh_period = pamac_flat_pak_real_get_refresh_period;
	iface->set_refresh_period = pamac_flat_pak_real_set_refresh_period;
}

static void
pamac_flat_pak_instance_init (PamacFlatPak * self,
                              gpointer klass)
{
	self->priv = pamac_flat_pak_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_stores_table);
	g_rec_mutex_init (&self->priv->__lock_pkgs_cache);
}

static void
pamac_flat_pak_finalize (GObject * obj)
{
	PamacFlatPak * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAMAC_TYPE_FLAT_PAK, PamacFlatPak);
	_g_free0 (self->priv->sender);
	_g_object_unref0 (self->priv->installation);
	g_rec_mutex_clear (&self->priv->__lock_stores_table);
	_g_ptr_array_unref0 (self->priv->stores_table);
	_g_hash_table_unref0 (self->priv->remote_refs_table);
	g_rec_mutex_clear (&self->priv->__lock_pkgs_cache);
	_g_hash_table_unref0 (self->priv->pkgs_cache);
	_g_hash_table_unref0 (self->priv->categories_cache);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (pamac_flat_pak_parent_class)->finalize (obj);
}

static GType
pamac_flat_pak_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PamacFlatPakClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pamac_flat_pak_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PamacFlatPak), 0, (GInstanceInitFunc) pamac_flat_pak_instance_init, NULL };
	static const GInterfaceInfo pamac_flatpak_plugin_info = { (GInterfaceInitFunc) pamac_flat_pak_pamac_flatpak_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType pamac_flat_pak_type_id;
	pamac_flat_pak_type_id = g_type_register_static (G_TYPE_OBJECT, "PamacFlatPak", &g_define_type_info, 0);
	g_type_add_interface_static (pamac_flat_pak_type_id, PAMAC_TYPE_FLATPAK_PLUGIN, &pamac_flatpak_plugin_info);
	PamacFlatPak_private_offset = g_type_add_instance_private (pamac_flat_pak_type_id, sizeof (PamacFlatPakPrivate));
	return pamac_flat_pak_type_id;
}

GType
pamac_flat_pak_get_type (void)
{
	static volatile gsize pamac_flat_pak_type_id__once = 0;
	if (g_once_init_enter (&pamac_flat_pak_type_id__once)) {
		GType pamac_flat_pak_type_id;
		pamac_flat_pak_type_id = pamac_flat_pak_get_type_once ();
		g_once_init_leave (&pamac_flat_pak_type_id__once, pamac_flat_pak_type_id);
	}
	return pamac_flat_pak_type_id__once;
}

static void
_vala_pamac_flat_pak_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PamacFlatPak * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_FLAT_PAK, PamacFlatPak);
	switch (property_id) {
		case PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY:
		g_value_set_uint64 (value, pamac_flatpak_plugin_get_refresh_period ((PamacFlatpakPlugin*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pamac_flat_pak_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	PamacFlatPak * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAMAC_TYPE_FLAT_PAK, PamacFlatPak);
	switch (property_id) {
		case PAMAC_FLAT_PAK_REFRESH_PERIOD_PROPERTY:
		pamac_flatpak_plugin_set_refresh_period ((PamacFlatpakPlugin*) self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GType
register_plugin (GModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	result = PAMAC_TYPE_FLAT_PAK;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

