/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.calculation;

import ca.odell.glazedlists.calculation.Calculation;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractCalculation<N>
implements Calculation<N> {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private N value;
    private String name;

    public AbstractCalculation(N initialValue) {
        this.value = initialValue;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!GlazedListsImpl.equal(this.name, name)) {
            String oldName = this.name;
            this.name = name;
            this.support.firePropertyChange("name", oldName, name);
        }
    }

    @Override
    public N getValue() {
        return this.value;
    }

    protected void setValue(N value) {
        this.value = value;
    }

    protected void fireValueChange(N oldValue, N newValue) {
        this.support.firePropertyChange("value", oldValue, newValue);
    }
}

