/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpnConnectionOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpnConnectionOptionsRequest> {
    private static final SdkField<String> VPN_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpnConnectionId").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::vpnConnectionId)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::vpnConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnConnectionId").unmarshallLocationName("VpnConnectionId").build()}).build();
    private static final SdkField<String> LOCAL_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv4NetworkCidr").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::localIpv4NetworkCidr)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::localIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv4NetworkCidr").unmarshallLocationName("LocalIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV4_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv4NetworkCidr").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::remoteIpv4NetworkCidr)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::remoteIpv4NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv4NetworkCidr").unmarshallLocationName("RemoteIpv4NetworkCidr").build()}).build();
    private static final SdkField<String> LOCAL_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalIpv6NetworkCidr").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::localIpv6NetworkCidr)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::localIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalIpv6NetworkCidr").unmarshallLocationName("LocalIpv6NetworkCidr").build()}).build();
    private static final SdkField<String> REMOTE_IPV6_NETWORK_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteIpv6NetworkCidr").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::remoteIpv6NetworkCidr)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::remoteIpv6NetworkCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteIpv6NetworkCidr").unmarshallLocationName("RemoteIpv6NetworkCidr").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyVpnConnectionOptionsRequest.getter(ModifyVpnConnectionOptionsRequest::dryRun)).setter(ModifyVpnConnectionOptionsRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPN_CONNECTION_ID_FIELD, LOCAL_IPV4_NETWORK_CIDR_FIELD, REMOTE_IPV4_NETWORK_CIDR_FIELD, LOCAL_IPV6_NETWORK_CIDR_FIELD, REMOTE_IPV6_NETWORK_CIDR_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVpnConnectionOptionsRequest.memberNameToFieldInitializer();
    private final String vpnConnectionId;
    private final String localIpv4NetworkCidr;
    private final String remoteIpv4NetworkCidr;
    private final String localIpv6NetworkCidr;
    private final String remoteIpv6NetworkCidr;
    private final Boolean dryRun;

    private ModifyVpnConnectionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.vpnConnectionId = builder.vpnConnectionId;
        this.localIpv4NetworkCidr = builder.localIpv4NetworkCidr;
        this.remoteIpv4NetworkCidr = builder.remoteIpv4NetworkCidr;
        this.localIpv6NetworkCidr = builder.localIpv6NetworkCidr;
        this.remoteIpv6NetworkCidr = builder.remoteIpv6NetworkCidr;
        this.dryRun = builder.dryRun;
    }

    public final String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public final String localIpv4NetworkCidr() {
        return this.localIpv4NetworkCidr;
    }

    public final String remoteIpv4NetworkCidr() {
        return this.remoteIpv4NetworkCidr;
    }

    public final String localIpv6NetworkCidr() {
        return this.localIpv6NetworkCidr;
    }

    public final String remoteIpv6NetworkCidr() {
        return this.remoteIpv6NetworkCidr;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vpnConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv4NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.localIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpv6NetworkCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpnConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpnConnectionOptionsRequest other = (ModifyVpnConnectionOptionsRequest)((Object)obj);
        return Objects.equals(this.vpnConnectionId(), other.vpnConnectionId()) && Objects.equals(this.localIpv4NetworkCidr(), other.localIpv4NetworkCidr()) && Objects.equals(this.remoteIpv4NetworkCidr(), other.remoteIpv4NetworkCidr()) && Objects.equals(this.localIpv6NetworkCidr(), other.localIpv6NetworkCidr()) && Objects.equals(this.remoteIpv6NetworkCidr(), other.remoteIpv6NetworkCidr()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpnConnectionOptionsRequest").add("VpnConnectionId", (Object)this.vpnConnectionId()).add("LocalIpv4NetworkCidr", (Object)this.localIpv4NetworkCidr()).add("RemoteIpv4NetworkCidr", (Object)this.remoteIpv4NetworkCidr()).add("LocalIpv6NetworkCidr", (Object)this.localIpv6NetworkCidr()).add("RemoteIpv6NetworkCidr", (Object)this.remoteIpv6NetworkCidr()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpnConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpnConnectionId()));
            }
            case "LocalIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv4NetworkCidr()));
            }
            case "RemoteIpv4NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv4NetworkCidr()));
            }
            case "LocalIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.localIpv6NetworkCidr()));
            }
            case "RemoteIpv6NetworkCidr": {
                return Optional.ofNullable(clazz.cast(this.remoteIpv6NetworkCidr()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpnConnectionId", VPN_CONNECTION_ID_FIELD);
        map.put("LocalIpv4NetworkCidr", LOCAL_IPV4_NETWORK_CIDR_FIELD);
        map.put("RemoteIpv4NetworkCidr", REMOTE_IPV4_NETWORK_CIDR_FIELD);
        map.put("LocalIpv6NetworkCidr", LOCAL_IPV6_NETWORK_CIDR_FIELD);
        map.put("RemoteIpv6NetworkCidr", REMOTE_IPV6_NETWORK_CIDR_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpnConnectionOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpnConnectionOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String vpnConnectionId;
        private String localIpv4NetworkCidr;
        private String remoteIpv4NetworkCidr;
        private String localIpv6NetworkCidr;
        private String remoteIpv6NetworkCidr;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpnConnectionOptionsRequest model) {
            super(model);
            this.vpnConnectionId(model.vpnConnectionId);
            this.localIpv4NetworkCidr(model.localIpv4NetworkCidr);
            this.remoteIpv4NetworkCidr(model.remoteIpv4NetworkCidr);
            this.localIpv6NetworkCidr(model.localIpv6NetworkCidr);
            this.remoteIpv6NetworkCidr(model.remoteIpv6NetworkCidr);
            this.dryRun(model.dryRun);
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final String getLocalIpv4NetworkCidr() {
            return this.localIpv4NetworkCidr;
        }

        public final void setLocalIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
        }

        @Override
        public final Builder localIpv4NetworkCidr(String localIpv4NetworkCidr) {
            this.localIpv4NetworkCidr = localIpv4NetworkCidr;
            return this;
        }

        public final String getRemoteIpv4NetworkCidr() {
            return this.remoteIpv4NetworkCidr;
        }

        public final void setRemoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
        }

        @Override
        public final Builder remoteIpv4NetworkCidr(String remoteIpv4NetworkCidr) {
            this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr;
            return this;
        }

        public final String getLocalIpv6NetworkCidr() {
            return this.localIpv6NetworkCidr;
        }

        public final void setLocalIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
        }

        @Override
        public final Builder localIpv6NetworkCidr(String localIpv6NetworkCidr) {
            this.localIpv6NetworkCidr = localIpv6NetworkCidr;
            return this;
        }

        public final String getRemoteIpv6NetworkCidr() {
            return this.remoteIpv6NetworkCidr;
        }

        public final void setRemoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
        }

        @Override
        public final Builder remoteIpv6NetworkCidr(String remoteIpv6NetworkCidr) {
            this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpnConnectionOptionsRequest build() {
            return new ModifyVpnConnectionOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpnConnectionOptionsRequest> {
        public Builder vpnConnectionId(String var1);

        public Builder localIpv4NetworkCidr(String var1);

        public Builder remoteIpv4NetworkCidr(String var1);

        public Builder localIpv6NetworkCidr(String var1);

        public Builder remoteIpv6NetworkCidr(String var1);

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

