/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.stats.info;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.opensearch.Version;
import org.opensearch.neuralsearch.stats.common.StatName;
import org.opensearch.neuralsearch.stats.info.InfoStatType;

public enum InfoStatName implements StatName
{
    CLUSTER_VERSION("cluster_version", "", InfoStatType.INFO_STRING, Version.V_3_0_0),
    TEXT_EMBEDDING_PROCESSORS("text_embedding_processors_in_pipelines", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_0_0),
    SKIP_EXISTING_PROCESSORS("skip_existing_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_PROCESSORS("text_chunking_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_DELIMITER_PROCESSORS("text_chunking_delimiter_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_FIXED_TOKEN_LENGTH_PROCESSORS("text_chunking_fixed_token_length_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    TEXT_CHUNKING_FIXED_CHAR_LENGTH_PROCESSORS("text_chunking_fixed_char_length_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NORMALIZATION_PROCESSORS("normalization_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NORM_TECHNIQUE_L2_PROCESSORS("norm_l2_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NORM_TECHNIQUE_MINMAX_PROCESSORS("norm_minmax_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NORM_TECHNIQUE_ZSCORE_PROCESSORS("norm_zscore_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_ARITHMETIC_PROCESSORS("comb_arithmetic_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_GEOMETRIC_PROCESSORS("comb_geometric_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_HARMONIC_PROCESSORS("comb_harmonic_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    RRF_PROCESSORS("rank_based_normalization_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    COMB_TECHNIQUE_RRF_PROCESSORS("comb_rrf_processors", "processors.search.hybrid", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    TEXT_IMAGE_EMBEDDING_PROCESSORS("text_image_embedding_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    SPARSE_ENCODING_PROCESSORS("sparse_encoding_processors", "processors.ingest", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NEURAL_QUERY_ENRICHER_PROCESSORS("neural_query_enricher_processors", "processors.search", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    NEURAL_SPARSE_TWO_PHASE_PROCESSORS("neural_sparse_two_phase_processors", "processors.search", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    RERANK_BY_FIELD_PROCESSORS("rerank_by_field_processors", "processors.search", InfoStatType.INFO_COUNTER, Version.V_3_1_0),
    RERANK_ML_PROCESSORS("rerank_ml_processors", "processors.search", InfoStatType.INFO_COUNTER, Version.V_3_1_0);

    private final String nameString;
    private final String path;
    private final InfoStatType statType;
    private final Version version;
    private static final Map<String, InfoStatName> BY_NAME;

    private InfoStatName(String nameString, String path, InfoStatType statType, Version version) {
        this.nameString = nameString;
        this.path = path;
        this.statType = statType;
        this.version = version;
    }

    public static InfoStatName from(String name) {
        if (!InfoStatName.isValidName(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Info stat not found: %s", name));
        }
        return BY_NAME.get(name);
    }

    public static boolean isValidName(String name) {
        return BY_NAME.containsKey(name);
    }

    @Override
    public String getFullPath() {
        if (StringUtils.isBlank((String)this.path)) {
            return this.nameString;
        }
        return String.join((CharSequence)".", this.path, this.nameString);
    }

    @Override
    public Version version() {
        return this.version;
    }

    public String toString() {
        return this.getNameString();
    }

    @Override
    @Generated
    public String getNameString() {
        return this.nameString;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public InfoStatType getStatType() {
        return this.statType;
    }

    @Generated
    public Version getVersion() {
        return this.version;
    }

    static {
        BY_NAME = Arrays.stream(InfoStatName.values()).collect(Collectors.toMap(stat -> stat.nameString, stat -> stat));
    }
}

