/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.search.RescoreQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Rescore
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Rescore> {
    @Nonnull
    private final RescoreQuery query;
    @Nullable
    private final Integer windowSize;
    public static final JsonpDeserializer<Rescore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Rescore::setupRescoreDeserializer);

    private Rescore(Builder builder) {
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.windowSize = builder.windowSize;
    }

    public static Rescore of(Function<Builder, ObjectBuilder<Rescore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final RescoreQuery query() {
        return this.query;
    }

    @Nullable
    public final Integer windowSize() {
        return this.windowSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.windowSize != null) {
            generator.writeKey("window_size");
            generator.write(this.windowSize.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRescoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::query, RescoreQuery._DESERIALIZER, "query");
        op.add(Builder::windowSize, JsonpDeserializer.integerDeserializer(), "window_size");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.query.hashCode();
        result = 31 * result + Objects.hashCode(this.windowSize);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rescore other = (Rescore)o;
        return this.query.equals(other.query) && Objects.equals(this.windowSize, other.windowSize);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Rescore> {
        private RescoreQuery query;
        @Nullable
        private Integer windowSize;

        public Builder() {
        }

        private Builder(Rescore o) {
            this.query = o.query;
            this.windowSize = o.windowSize;
        }

        private Builder(Builder o) {
            this.query = o.query;
            this.windowSize = o.windowSize;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder query(RescoreQuery value) {
            this.query = value;
            return this;
        }

        @Nonnull
        public final Builder query(Function<RescoreQuery.Builder, ObjectBuilder<RescoreQuery>> fn) {
            return this.query(fn.apply(new RescoreQuery.Builder()).build());
        }

        @Nonnull
        public final Builder windowSize(@Nullable Integer value) {
            this.windowSize = value;
            return this;
        }

        @Override
        @Nonnull
        public Rescore build() {
            this._checkSingleUse();
            return new Rescore(this);
        }
    }
}

