/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.node.Node;
import org.opensearch.node.NodeService;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.search.backpressure.SearchBackpressureService;

public class SearchBackPressureStatsCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(SearchBackPressureStatsCollector.class)).samplingInterval;
    private static final int KEYS_PATH_LENGTH = 0;
    private static final Logger LOG = LogManager.getLogger(SearchBackPressureStatsCollector.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final String BOOTSTRAP_CLASS_NAME = "org.opensearch.bootstrap.Bootstrap";
    public static final String NODE_CLASS_NAME = "org.opensearch.node.Node";
    public static final String BOOTSTRAP_INSTANCE_FIELD_NAME = "INSTANCE";
    public static final String BOOTSTRAP_NODE_FIELD_NAME = "node";
    public static final String NODE_SERVICE_FIELD_NAME = "nodeService";
    public static final String HEAP_USAGE_TRACKER_FIELD_NAME = "HEAP_USAGE_TRACKER";
    public static final String CPU_USAGE_TRACKER_FIELD_NAME = "CPU_USAGE_TRACKER";
    public static final String ELAPSED_TIME_USAGE_TRACKER_FIELD_NAME = "ELAPSED_TIME_TRACKER";
    public static final String PATH_TO_STORE_METRICS = "search_back_pressure";
    private String nodeId;
    private final StringBuilder value;
    private final PerformanceAnalyzerController controller;
    private final ConfigOverridesWrapper configOverridesWrapper;

    public SearchBackPressureStatsCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, SearchBackPressureStatsCollector.class.getSimpleName(), (MeasurementSet)StatMetrics.CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.CLUSTER_APPLIER_SERVICE_STATS_COLLECTOR_ERROR);
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
        this.value = new StringBuilder();
        LOG.info("SearchBackPressureStatsCollector started");
    }

    private void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    private String getNodeId() {
        return this.nodeId;
    }

    public void collectMetrics(long startTime) {
        SearchBackPressureStats currentSearchBackPressureStats = null;
        try {
            String jsonString = mapper.writeValueAsString(this.getSearchBackPressureStats());
            currentSearchBackPressureStats = (SearchBackPressureStats)mapper.readValue(jsonString, SearchBackPressureStats.class);
        }
        catch (JsonProcessingException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
            ex.printStackTrace();
            LOG.warn("No method found to get Search BackPressure Stats. Skipping SearchBackPressureStatsCollector. Error: " + ex.getMessage());
            return;
        }
        SearchBackPressureMetrics searchBackPressureMetrics = new SearchBackPressureMetrics(currentSearchBackPressureStats.getMode(), this.getNodeId(), currentSearchBackPressureStats.getSearchShardTaskStats(), currentSearchBackPressureStats.getSearchTaskStats());
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        this.value.append(searchBackPressureMetrics.serialize());
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    Field getField(String className, String fieldName) throws NoSuchFieldException, ClassNotFoundException {
        Class<?> BootStrapClass = Class.forName(className);
        Field bootStrapField = BootStrapClass.getDeclaredField(fieldName);
        bootStrapField.setAccessible(true);
        return bootStrapField;
    }

    @VisibleForTesting
    public Object getSearchBackPressureStats() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, NoSuchFieldException, NoSuchFieldError, ClassNotFoundException {
        Object bootStrapSInstance = this.getField(BOOTSTRAP_CLASS_NAME, BOOTSTRAP_INSTANCE_FIELD_NAME).get(null);
        Node node = (Node)this.getField(BOOTSTRAP_CLASS_NAME, BOOTSTRAP_NODE_FIELD_NAME).get(bootStrapSInstance);
        NodeEnvironment nodeEnvironment = node.getNodeEnvironment();
        this.setNodeId(nodeEnvironment.nodeId());
        NodeService nodeService = (NodeService)this.getField(NODE_CLASS_NAME, NODE_SERVICE_FIELD_NAME).get(node);
        String GET_STATS_METHOD_NAME = "nodeStats";
        Method method = SearchBackpressureService.class.getMethod(GET_STATS_METHOD_NAME, new Class[0]);
        return method.invoke((Object)nodeService.getSearchBackpressureService(), new Object[0]);
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{PATH_TO_STORE_METRICS});
    }

    static {
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static class SearchBackPressureStats {
        private SearchShardTaskStats searchShardTaskStats;
        private String mode;
        private SearchTaskStats searchTaskStats;

        @JsonCreator
        @VisibleForTesting
        public SearchBackPressureStats(@JsonProperty(value="searchShardTaskStats") SearchShardTaskStats searchShardTaskStats, @JsonProperty(value="mode") String mode, @JsonProperty(value="searchTaskStats") SearchTaskStats searchTaskStats) {
            this.searchShardTaskStats = searchShardTaskStats;
            this.mode = mode;
            this.searchTaskStats = searchTaskStats;
        }

        public SearchBackPressureStats() {
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public SearchShardTaskStats getSearchShardTaskStats() {
            return this.searchShardTaskStats;
        }

        public void setSearchShardTaskStats(SearchShardTaskStats searchShardTaskStats) {
            this.searchShardTaskStats = searchShardTaskStats;
        }

        public SearchTaskStats getSearchTaskStats() {
            return this.searchTaskStats;
        }

        public void setSearchTaskStats(SearchTaskStats searchTaskStats) {
            this.searchTaskStats = searchTaskStats;
        }
    }

    public static class SearchBackPressureMetrics
    extends MetricStatus {
        private SearchShardTaskStats searchShardTaskStats;
        private SearchTaskStats searchTaskStats;
        private String mode;
        private String nodeId;
        private long searchbp_shard_task_stats_cancellationCount;
        private long searchbp_shard_task_stats_limitReachedCount;
        private long searchbp_shard_task_stats_completionCount;
        private long searchbp_shard_task_stats_resource_heap_usage_cancellationCount;
        private long searchbp_shard_task_stats_resource_heap_usage_currentMax;
        private long searchbp_shard_task_stats_resource_heap_usage_rollingAvg;
        private long searchbp_shard_task_stats_resource_cpu_usage_cancellationCount;
        private long searchbp_shard_task_stats_resource_cpu_usage_currentMax;
        private long searchbp_shard_stats_resource_cpu_usage_currentAvg;
        private long searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount;
        private long searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax;
        private long searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg;
        private long searchbp_search_task_stats_cancellationCount;
        private long searchbp_search_task_stats_limitReachedCount;
        private long searchbp_search_task_stats_completionCount;
        private long searchbp_search_task_stats_resource_heap_usage_cancellationCount;
        private long searchbp_search_task_stats_resource_heap_usage_currentMax;
        private long searchbp_search_task_stats_resource_heap_usage_rollingAvg;
        private long searchbp_search_task_stats_resource_cpu_usage_cancellationCount;
        private long searchbp_search_task_stats_resource_cpu_usage_currentMax;
        private long searchbp_search_task_stats_resource_cpu_usage_currentAvg;
        private long searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount;
        private long searchbp_search_task_stats_resource_elaspedtime_usage_currentMax;
        private long searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg;

        public SearchBackPressureMetrics(String mode, String nodeId, SearchShardTaskStats searchShardTaskStats, SearchTaskStats searchTaskStats) {
            this.mode = mode;
            this.nodeId = nodeId;
            this.searchShardTaskStats = searchShardTaskStats;
            this.searchTaskStats = searchTaskStats;
            this.populate_shard_task_stats(searchShardTaskStats);
            this.populate_task_stats(searchTaskStats);
        }

        public void populate_shard_task_stats(SearchShardTaskStats searchShardTaskStats) {
            ResourceUsageTrackerStats shard_heap_stats = searchShardTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.HEAP_USAGE_TRACKER_FIELD_NAME);
            ResourceUsageTrackerStats shard_cpu_stats = searchShardTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.CPU_USAGE_TRACKER_FIELD_NAME);
            ResourceUsageTrackerStats shard_time_stats = searchShardTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.ELAPSED_TIME_USAGE_TRACKER_FIELD_NAME);
            this.searchbp_shard_task_stats_cancellationCount = searchShardTaskStats.getCancellationCount();
            this.searchbp_shard_task_stats_limitReachedCount = searchShardTaskStats.getLimitReachedCount();
            this.searchbp_shard_task_stats_completionCount = searchShardTaskStats.getCompletionCount();
            this.searchbp_shard_task_stats_resource_heap_usage_cancellationCount = shard_heap_stats.getCancellationCount();
            this.searchbp_shard_task_stats_resource_heap_usage_currentMax = shard_heap_stats.getCurrentMax();
            this.searchbp_shard_task_stats_resource_heap_usage_rollingAvg = shard_heap_stats.getRollingAvg();
            this.searchbp_shard_task_stats_resource_cpu_usage_cancellationCount = shard_cpu_stats.getCancellationCount();
            this.searchbp_shard_task_stats_resource_cpu_usage_currentMax = shard_cpu_stats.getCurrentMax();
            this.searchbp_shard_stats_resource_cpu_usage_currentAvg = shard_cpu_stats.getCurrentAvg();
            this.searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount = shard_time_stats.getCancellationCount();
            this.searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax = shard_time_stats.getCurrentMax();
            this.searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg = shard_time_stats.getCurrentAvg();
        }

        public void populate_task_stats(SearchTaskStats searchTaskStats) {
            ResourceUsageTrackerStats task_heap_stats = searchTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.HEAP_USAGE_TRACKER_FIELD_NAME);
            ResourceUsageTrackerStats task_cpu_stats = searchTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.CPU_USAGE_TRACKER_FIELD_NAME);
            ResourceUsageTrackerStats task_time_stats = searchTaskStats.getResourceUsageTrackerStats().get(SearchBackPressureStatsCollector.ELAPSED_TIME_USAGE_TRACKER_FIELD_NAME);
            this.searchbp_search_task_stats_cancellationCount = searchTaskStats.getCancellationCount();
            this.searchbp_search_task_stats_limitReachedCount = searchTaskStats.getLimitReachedCount();
            this.searchbp_search_task_stats_completionCount = searchTaskStats.getCompletionCount();
            this.searchbp_search_task_stats_resource_heap_usage_cancellationCount = task_heap_stats.getCancellationCount();
            this.searchbp_search_task_stats_resource_heap_usage_currentMax = task_heap_stats.getCurrentMax();
            this.searchbp_search_task_stats_resource_heap_usage_rollingAvg = task_heap_stats.getRollingAvg();
            this.searchbp_search_task_stats_resource_cpu_usage_cancellationCount = task_cpu_stats.getCancellationCount();
            this.searchbp_search_task_stats_resource_cpu_usage_currentMax = task_cpu_stats.getCurrentMax();
            this.searchbp_search_task_stats_resource_cpu_usage_currentAvg = task_cpu_stats.getCurrentAvg();
            this.searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount = task_time_stats.getCancellationCount();
            this.searchbp_search_task_stats_resource_elaspedtime_usage_currentMax = task_time_stats.getCurrentMax();
            this.searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg = task_time_stats.getCurrentAvg();
        }

        @JsonProperty(value="searchbp_mode")
        public String getSearchBackPressureStats_Mode() {
            return this.mode;
        }

        @JsonProperty(value="searchbp_nodeid")
        public String getSearchBackPressureStats_NodeId() {
            return this.nodeId;
        }

        @JsonProperty(value="searchbp_shard_task_stats_cancellationCount")
        public long getSearchbp_shard_task_stats_cancellationCount() {
            return this.searchbp_shard_task_stats_cancellationCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_limitReachedCount")
        public long getSearchbp_shard_task_stats_limitReachedCount() {
            return this.searchbp_shard_task_stats_limitReachedCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_completionCount")
        public long getSearchbp_shard_task_stats_completionCount() {
            return this.searchbp_shard_task_stats_completionCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_heap_usage_cancellationCount")
        public long getSearchbp_shard_task_stats_resource_heap_usage_cancellationCount() {
            return this.searchbp_shard_task_stats_resource_heap_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_heap_usage_currentMax")
        public long getSearchbp_shard_task_stats_resource_heap_usage_currentMax() {
            return this.searchbp_shard_task_stats_resource_heap_usage_currentMax;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_heap_usage_rollingAvg")
        public long getsearchbp_shard_stats_resource_heap_usage_rollingAvg() {
            return this.searchbp_shard_task_stats_resource_heap_usage_rollingAvg;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_cpu_usage_cancellationCount")
        public long getSearchbp_shard_task_stats_resource_cpu_usage_cancellationCount() {
            return this.searchbp_shard_task_stats_resource_cpu_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_cpu_usage_currentMax")
        public long getSearchbp_shard_task_stats_resource_cpu_usage_currentMax() {
            return this.searchbp_shard_task_stats_resource_cpu_usage_currentMax;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_cpu_usage_currentAvg")
        public long getSearchbp_shard_stats_resource_cpu_usage_currentAvg() {
            return this.searchbp_shard_stats_resource_cpu_usage_currentAvg;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount")
        public long getSearchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount() {
            return this.searchbp_shard_task_stats_resource_elaspedtime_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax")
        public long getSearchbp_shard_task_stats_resource_elaspedtime_usage_currentMax() {
            return this.searchbp_shard_task_stats_resource_elaspedtime_usage_currentMax;
        }

        @JsonProperty(value="searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg")
        public long getSearchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg() {
            return this.searchbp_shard_task_stats_resource_elaspedtime_usage_currentAvg;
        }

        @JsonProperty(value="searchbp_search_task_stats_cancellationCount")
        public long getSearchbp_search_task_stats_cancellationCount() {
            return this.searchbp_search_task_stats_cancellationCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_limitReachedCount")
        public long getSearchbp_search_task_stats_limitReachedCount() {
            return this.searchbp_search_task_stats_limitReachedCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_completionCount")
        public long getSearchbp_search_task_stats_completionCount() {
            return this.searchbp_search_task_stats_completionCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_heap_usage_cancellationCount")
        public long getSearchbp_search_task_stats_resource_heap_usage_cancellationCount() {
            return this.searchbp_search_task_stats_resource_heap_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_heap_usage_currentMax")
        public long getSearchbp_search_task_stats_resource_heap_usage_currentMax() {
            return this.searchbp_search_task_stats_resource_heap_usage_currentMax;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_heap_usage_rollingAvg")
        public long getsearchbp_task_stats_resource_heap_usage_rollingAvg() {
            return this.searchbp_search_task_stats_resource_heap_usage_rollingAvg;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_cpu_usage_cancellationCount")
        public long getSearchbp_search_task_stats_resource_cpu_usage_cancellationCount() {
            return this.searchbp_search_task_stats_resource_cpu_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_cpu_usage_currentMax")
        public long getSearchbp_search_task_stats_resource_cpu_usage_currentMax() {
            return this.searchbp_search_task_stats_resource_cpu_usage_currentMax;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_cpu_usage_currentAvg")
        public long getSearchbp_search_task_stats_resource_cpu_usage_currentAvg() {
            return this.searchbp_search_task_stats_resource_cpu_usage_currentAvg;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount")
        public long getSearchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount() {
            return this.searchbp_search_task_stats_resource_elaspedtime_usage_cancellationCount;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_elaspedtime_usage_currentMax")
        public long getSearchbp_search_task_stats_resource_elaspedtime_usage_currentMax() {
            return this.searchbp_search_task_stats_resource_elaspedtime_usage_currentMax;
        }

        @JsonProperty(value="searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg")
        public long getSearchbp_search_task_stats_resource_elaspedtime_usage_currentAvg() {
            return this.searchbp_search_task_stats_resource_elaspedtime_usage_currentAvg;
        }
    }

    public static class SearchShardTaskStats {
        private long cancellationCount;
        private long limitReachedCount;
        private long completionCount;
        private Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats;

        @JsonCreator
        public SearchShardTaskStats(@JsonProperty(value="cancellationCount") long cancellationCount, @JsonProperty(value="limitReachedCount") long limitReachedCount, @JsonProperty(value="completionCount") long completionCount, @JsonProperty(value="resourceUsageTrackerStats") Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats) {
            this.cancellationCount = cancellationCount;
            this.limitReachedCount = limitReachedCount;
            this.completionCount = completionCount;
            this.resourceUsageTrackerStats = resourceUsageTrackerStats;
        }

        public long getCancellationCount() {
            return this.cancellationCount;
        }

        public void setCancellationCount(long cancellationCount) {
            this.cancellationCount = cancellationCount;
        }

        public long getLimitReachedCount() {
            return this.limitReachedCount;
        }

        public void setLimitReachedCount(long limitReachedCount) {
            this.limitReachedCount = limitReachedCount;
        }

        public Map<String, ResourceUsageTrackerStats> getResourceUsageTrackerStats() {
            return this.resourceUsageTrackerStats;
        }

        public void setResourceUsageTrackerStats(Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats) {
            this.resourceUsageTrackerStats = resourceUsageTrackerStats;
        }

        public long getCompletionCount() {
            return this.completionCount;
        }

        public void setCompletionCount(long completionCount) {
            this.completionCount = completionCount;
        }
    }

    public static class SearchTaskStats {
        private long cancellationCount;
        private long limitReachedCount;
        private long completionCount;
        private Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats;

        @JsonCreator
        public SearchTaskStats(@JsonProperty(value="cancellationCount") long cancellationCount, @JsonProperty(value="limitReachedCount") long limitReachedCount, @JsonProperty(value="completionCount") long completionCount, @JsonProperty(value="resourceUsageTrackerStats") Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats) {
            this.cancellationCount = cancellationCount;
            this.limitReachedCount = limitReachedCount;
            this.completionCount = completionCount;
            this.resourceUsageTrackerStats = resourceUsageTrackerStats;
        }

        public long getCancellationCount() {
            return this.cancellationCount;
        }

        public void setCancellationCount(long cancellationCount) {
            this.cancellationCount = cancellationCount;
        }

        public long getLimitReachedCount() {
            return this.limitReachedCount;
        }

        public void setLimitReachedCount(long limitReachedCount) {
            this.limitReachedCount = limitReachedCount;
        }

        public long getCompletionCount() {
            return this.completionCount;
        }

        public void setCompletionCount(long completionCount) {
            this.completionCount = completionCount;
        }

        public Map<String, ResourceUsageTrackerStats> getResourceUsageTrackerStats() {
            return this.resourceUsageTrackerStats;
        }

        public void setResourceUsageTrackerStats(Map<String, ResourceUsageTrackerStats> resourceUsageTrackerStats) {
            this.resourceUsageTrackerStats = resourceUsageTrackerStats;
        }
    }

    public static class ResourceUsageTrackerStats {
        private long cancellationCount;
        private long currentMax;
        private long currentAvg;
        private long rollingAvg;
        private boolean fragment;

        @JsonCreator
        public ResourceUsageTrackerStats(@JsonProperty(value="cancellationCount") long cancellationCount, @JsonProperty(value="currentMax") long currentMax, @JsonProperty(value="currentAvg") long currentAvg, @JsonProperty(value="rollingAvg") long rollingAvg, @JsonProperty(value="fragment") boolean fragment) {
            this.cancellationCount = cancellationCount;
            this.currentMax = currentMax;
            this.currentAvg = currentAvg;
            this.rollingAvg = rollingAvg;
            this.fragment = fragment;
        }

        public long getCancellationCount() {
            return this.cancellationCount;
        }

        public void setCancellationCount(long cancellationCount) {
            this.cancellationCount = cancellationCount;
        }

        public long getCurrentMax() {
            return this.currentMax;
        }

        public void setCurrentMax(long currentMax) {
            this.currentMax = currentMax;
        }

        public long getCurrentAvg() {
            return this.currentAvg;
        }

        public void setCurrentAvg(long currentAvg) {
            this.currentAvg = currentAvg;
        }

        public long getRollingAvg() {
            return this.rollingAvg;
        }

        public void setRollingAvg(long rollingAvg) {
            this.rollingAvg = rollingAvg;
        }

        public boolean isFragment() {
            return this.fragment;
        }

        public void setFragment(boolean fragment) {
            this.fragment = fragment;
        }
    }
}

