/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;

public class EntityImagePseudoState
extends AbstractEntityImage {
    private static final int SIZE = 22;
    private final TextBlock desc;

    public EntityImagePseudoState(Entity entity) {
        this(entity, "H");
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, this.getStyleName(), SName.diamond);
    }

    public EntityImagePseudoState(Entity entity, String historyText) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fontConfiguration = FontConfiguration.create(this.getSkinParam(), FontParam.STATE, stereotype);
        this.desc = Display.create(historyText).create(fontConfiguration, HorizontalAlignment.CENTER, this.getSkinParam());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(22.0, 22.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        UEllipse circle = UEllipse.build(22.0, 22.0);
        Style style = this.getStyle();
        HColor borderColor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        HColor backgroundColor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        double shadow = style.getShadowing();
        UStroke stroke = style.getStroke();
        circle.setDeltaShadow(shadow);
        ug = ug.apply(stroke);
        ug = ug.apply(backgroundColor.bg()).apply(borderColor);
        ug.draw(circle);
        XDimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double widthDesc = dimDesc.getWidth();
        double heightDesc = dimDesc.getHeight();
        double x = (22.0 - widthDesc) / 2.0;
        double y = (22.0 - heightDesc) / 2.0;
        this.desc.drawU(ug.apply(new UTranslate(x, y)));
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

