/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.util;

import net.sf.json.JSONException;
import org.apache.commons.lang.StringUtils;

public abstract class JavaIdentifierTransformer {
    public static final JavaIdentifierTransformer CAMEL_CASE = new CamelCaseJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer NOOP = new NoopJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer STRICT = new StrictJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer UNDERSCORE = new UnderscoreJavaIdentifierTransformer();
    public static final JavaIdentifierTransformer WHITESPACE = new WhiteSpaceJavaIdentifierTransformer();

    public abstract String transformToJavaIdentifier(String var1);

    protected final String shaveOffNonJavaIdentifierStartChars(String str) {
        String str2 = str;
        boolean ready = false;
        while (!ready) {
            if (!Character.isJavaIdentifierStart(str2.charAt(0))) {
                if ((str2 = str2.substring(1)).length() != 0) continue;
                throw new JSONException("Can't convert '" + str + "' to a valid Java identifier");
            }
            ready = true;
        }
        return str2;
    }

    private static final class WhiteSpaceJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private WhiteSpaceJavaIdentifierTransformer() {
        }

        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            str2 = StringUtils.deleteWhitespace((String)str2);
            char[] chars = str2.toCharArray();
            StringBuffer buf = new StringBuffer();
            for (int pos = 0; pos < chars.length; ++pos) {
                if (!Character.isJavaIdentifierPart(chars[pos])) continue;
                buf.append(chars[pos]);
            }
            return buf.toString();
        }
    }

    private static final class UnderscoreJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private UnderscoreJavaIdentifierTransformer() {
        }

        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            char[] chars = str2.toCharArray();
            StringBuffer buf = new StringBuffer();
            boolean toUnderScorePreviousChar = false;
            for (int pos = 0; pos < chars.length; ++pos) {
                if (!Character.isJavaIdentifierPart(chars[pos]) || Character.isWhitespace(chars[pos])) {
                    toUnderScorePreviousChar = true;
                    continue;
                }
                if (toUnderScorePreviousChar) {
                    buf.append("_");
                    toUnderScorePreviousChar = false;
                }
                buf.append(chars[pos]);
            }
            if (buf.charAt(buf.length() - 1) == '_') {
                buf.deleteCharAt(buf.length() - 1);
            }
            return buf.toString();
        }
    }

    private static final class StrictJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private StrictJavaIdentifierTransformer() {
        }

        public String transformToJavaIdentifier(String str) {
            throw new JSONException("'" + str + "' is not a valid Java identifier.");
        }
    }

    private static final class NoopJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private NoopJavaIdentifierTransformer() {
        }

        public String transformToJavaIdentifier(String str) {
            return str;
        }
    }

    private static final class CamelCaseJavaIdentifierTransformer
    extends JavaIdentifierTransformer {
        private CamelCaseJavaIdentifierTransformer() {
        }

        public String transformToJavaIdentifier(String str) {
            if (str == null) {
                return null;
            }
            String str2 = this.shaveOffNonJavaIdentifierStartChars(str);
            char[] chars = str2.toCharArray();
            StringBuffer buf = new StringBuffer();
            boolean toUpperCaseNextChar = false;
            for (int pos = 0; pos < chars.length; ++pos) {
                if (!Character.isJavaIdentifierPart(chars[pos]) || Character.isWhitespace(chars[pos])) {
                    toUpperCaseNextChar = true;
                    continue;
                }
                if (toUpperCaseNextChar) {
                    buf.append(Character.toUpperCase(chars[pos]));
                    toUpperCaseNextChar = false;
                    continue;
                }
                buf.append(chars[pos]);
            }
            return buf.toString();
        }
    }
}

