/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.util.TriangleData;

public class Triangulator
extends TriangleData {
    public static final int[][] edgeC = new int[][]{{0, 3, 0, 1}};
    public static final int[][] edgeB = new int[][]{{0, 4, 0, 1}};
    public static final int[][] edgeA = new int[][]{{0, 1, 0, 1}};
    public static final int[][] abFace = new int[][]{{0, 4, 5, 3}, {5, 1, 0, 3}};
    public static final int[][] fullCubePolygon = new int[][]{{0, 4, 5, 3}, {5, 1, 0, 3}, {1, 5, 6, 2}, {6, 2, 1, 3}, {2, 6, 7, 2}, {7, 3, 2, 3}, {3, 7, 4, 2}, {4, 0, 3, 2}, {6, 5, 4, 0}, {4, 7, 6, 0}, {0, 1, 2, 0}, {2, 3, 0, 0}};
    public static final int[][] fullCubeCorners = new int[][]{{1, 4, 3, 3267}, {0, 2, 5, 3087}, {1, 3, 6, 3132}, {2, 0, 7, 3312}, {0, 5, 7, 963}, {1, 6, 4, 783}, {2, 7, 5, 828}, {3, 4, 6, 1008}};

    public P3[] intersectLine(P3[] points, int nPoints, P3 ptA, V3 unitVector) {
        P3[] p3Array;
        if (nPoints < 0) {
            nPoints = points.length;
        }
        V3 v1 = new V3();
        V3 v2 = new V3();
        V3 v3 = new V3();
        V3 vAB = new V3();
        T3 pmin = null;
        T3 pmax = null;
        P3 p = new P3();
        P4 plane = new P4();
        float dmin = Float.MAX_VALUE;
        float dmax = -3.4028235E38f;
        for (int i = 0; i < 12; ++i) {
            int[] c = fullCubePolygon[i];
            if (i % 2 == 0) {
                Measure.getPlaneThroughPoints(points[c[0]], points[c[1]], points[c[2]], v1, v2, plane);
                P3 ret = Measure.getIntersection(ptA, unitVector, plane, p, v1, v3);
                if (ret == null) {
                    ++i;
                    continue;
                }
                vAB.sub2(p, ptA);
            }
            if (!Measure.isInTriangle(p, points[c[0]], points[c[1]], points[c[2]], v1, v2, v3)) continue;
            float d = unitVector.dot(vAB);
            if (d < dmin) {
                dmin = d;
                pmin = p;
            }
            if (d > dmax) {
                dmax = d;
                pmax = p;
            }
            if (i % 2 == 0) {
                ++i;
            }
            if (dmax - dmin > 0.01f) break;
            p = new P3();
        }
        if (pmin == null || (pmax == null || pmin.distance(pmax) < 0.001f) && (pmax = pmin) == null) {
            p3Array = null;
        } else {
            P3[] p3Array2 = new P3[2];
            p3Array2[0] = pmin;
            p3Array = p3Array2;
            p3Array2[1] = pmax;
        }
        return p3Array;
    }

    private Lst<Object> getCellProjection(P4 plane, T3[] pts) {
        V3 vTemp = new V3();
        float d = 0.0f;
        float dmax = -3.4028235E38f;
        int imax = 0;
        P3[] newPts = new P3[8];
        for (int i = 0; i < 8; ++i) {
            d = pts[i].dot(plane);
            if (d > dmax) {
                dmax = d;
                imax = i;
            }
            newPts[i] = new P3();
            Measure.getPlaneProjection(pts[i], plane, newPts[i], vTemp);
        }
        int t = fullCubeCorners[imax][3];
        int[][] polygons = AU.newInt2(6);
        int p = 0;
        for (int i = 0; i < 12; ++i) {
            if ((t & Pwr2[i]) == 0) continue;
            int[] t1 = new int[4];
            int[] t0 = fullCubePolygon[i];
            t1[0] = t0[0];
            t1[1] = t0[1];
            t1[2] = t0[2];
            t1[3] = t0[0] == imax ? 2 : (t0[1] == imax ? 0 : (t0[2] == imax ? 1 : 3));
            polygons[p++] = t1;
        }
        Lst<Object> poly = new Lst<Object>();
        poly.addLast(newPts);
        poly.addLast(polygons);
        return poly;
    }

    public Lst<Object> intersectPlane(P4 plane, T3[] vertices, int flags) {
        int i;
        if (flags == -1 && vertices.length == 8) {
            return this.getCellProjection(plane, vertices);
        }
        Lst<Object> v = new Lst<Object>();
        P3[] edgePoints = new P3[12];
        int insideMask = 0;
        float[] values = new float[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            values[i2] = plane.x * vertices[i2].x + plane.y * vertices[i2].y + plane.z * vertices[i2].z + plane.w;
            if (!(values[i2] < 0.0f)) continue;
            insideMask |= Pwr2[i2];
        }
        byte[] triangles = triangleTable2[insideMask];
        if (triangles == null) {
            return null;
        }
        for (i = 0; i < 24; i += 2) {
            byte v1 = edgeVertexes[i];
            byte v2 = edgeVertexes[i + 1];
            P3 result = P3.newP(vertices[v2]);
            result.sub(vertices[v1]);
            result.scale(values[v1] / (values[v1] - values[v2]));
            result.add(vertices[v1]);
            edgePoints[i >> 1] = result;
        }
        if (flags == 0) {
            BS bsPoints = new BS();
            for (int i3 = 0; i3 < triangles.length; ++i3) {
                bsPoints.set(triangles[i3]);
                if (i3 % 4 != 2) continue;
                ++i3;
            }
            int nPoints = bsPoints.cardinality();
            P3[] pts = new P3[nPoints];
            v.addLast(pts);
            int[] list = new int[12];
            int ptList = 0;
            for (int i4 = 0; i4 < triangles.length; ++i4) {
                byte pt = triangles[i4];
                if (bsPoints.get(pt)) {
                    bsPoints.clear(pt);
                    pts[ptList] = edgePoints[pt];
                    list[pt] = (byte)ptList++;
                }
                if (i4 % 4 != 2) continue;
                ++i4;
            }
            int[][] polygons = AU.newInt2(triangles.length >> 2);
            v.addLast(polygons);
            for (int i5 = 0; i5 < triangles.length; ++i5) {
                polygons[i5 >> 2] = new int[]{list[triangles[i5++]], list[triangles[i5++]], list[triangles[i5++]], triangles[i5]};
            }
            return v;
        }
        for (i = 0; i < triangles.length; ++i) {
            P3 pt1 = edgePoints[triangles[i++]];
            P3 pt2 = edgePoints[triangles[i++]];
            P3 pt3 = edgePoints[triangles[i++]];
            if ((flags & 1) == 1) {
                v.addLast(new P3[]{pt1, pt2, pt3});
            }
            if ((flags & 2) != 2) continue;
            byte b = triangles[i];
            if ((b & 1) == 1) {
                v.addLast(new P3[]{pt1, pt2});
            }
            if ((b & 2) == 2) {
                v.addLast(new P3[]{pt2, pt3});
            }
            if ((b & 4) != 4) continue;
            v.addLast(new P3[]{pt1, pt3});
        }
        return v;
    }
}

