/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.api.Convert;
import org.jruby.exceptions.ReadPartialBufferOverflowException;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.util.ByteList;

public abstract class IOChannel
implements Channel {
    protected final IRubyObject io;
    private final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");
    private final RespondToCallSite respondToClosed = new RespondToCallSite("closed?");
    private final CallSite isClosedAdapter = MethodIndex.getFunctionalCallSite("closed?");
    protected final Ruby runtime;

    protected IOChannel(IRubyObject io2) {
        this.io = io2;
        this.runtime = io2.getRuntime();
    }

    @Override
    public void close() throws IOException {
        ThreadContext context = this.runtime.getCurrentContext();
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(context, this.io, this.io);
        }
    }

    @Override
    public boolean isOpen() {
        ThreadContext context = this.runtime.getCurrentContext();
        if (this.respondToClosed.respondsTo(context, this.io, this.io)) {
            return !this.isClosedAdapter.call(context, this.io, this.io).isTrue();
        }
        return true;
    }

    protected static int read(Ruby runtime2, IRubyObject io2, FunctionalCachingCallSite read2, ByteBuffer dst) throws IOException {
        RubyString readString;
        IRubyObject retValue;
        IRubyObject readValue;
        ThreadContext context = runtime2.getCurrentContext();
        int remaining = dst.remaining();
        CacheEntry readMethodEntry = read2.retrieveCache(io2);
        RubyFixnum remainingFixnum = Convert.asFixnum(context, remaining);
        if (readMethodEntry.method.getSignature().isTwoArguments()) {
            readValue = dst.hasArray() ? RubyString.newStringNoCopy(runtime2, dst.array(), dst.position(), remaining) : RubyString.newStringLight(runtime2, remaining);
            retValue = read2.call(context, io2, io2, (IRubyObject)remainingFixnum, readValue);
        } else {
            retValue = readValue = read2.call(context, io2, io2, (IRubyObject)remainingFixnum);
        }
        int returnValue = -1;
        if (!retValue.isNil() && (readString = readValue.convertToString()).size() > 0) {
            ByteList str = readString.getByteList();
            int realSize = str.getRealSize();
            if (realSize > remaining) {
                throw new ReadPartialBufferOverflowException("error calling " + String.valueOf(io2.getType()) + "#readpartial: requested " + remaining + " bytes but received " + realSize);
            }
            dst.put(str.getUnsafeBytes(), str.getBegin(), realSize);
            returnValue = realSize;
        }
        return returnValue;
    }

    protected static int write(Ruby runtime2, IRubyObject io2, FunctionalCachingCallSite write2, ByteBuffer src) {
        ByteList buffer;
        int position = src.position();
        int remaining = src.remaining();
        if (src.hasArray()) {
            buffer = new ByteList(src.array(), src.position(), remaining, true);
        } else {
            buffer = new ByteList(remaining);
            buffer.append(src, remaining);
        }
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject written = write2.call(context, io2, io2, (IRubyObject)RubyString.newStringLight(runtime2, buffer));
        int wrote = Convert.toInt(context, written);
        if (wrote > 0) {
            src.position(position + wrote);
        }
        return wrote;
    }

    protected FunctionalCachingCallSite initReadSite(String readMethod) {
        if (this.io.respondsTo(readMethod)) {
            return new FunctionalCachingCallSite(readMethod);
        }
        throw new IllegalArgumentException(String.valueOf(this.io.getMetaClass()) + "not coercible to " + this.getClass().getSimpleName() + ": no '" + readMethod + "' method");
    }

    protected FunctionalCachingCallSite initWriteSite() {
        if (this.io.respondsTo("write")) {
            return new FunctionalCachingCallSite("write");
        }
        if (this.io.respondsTo("<<")) {
            return new FunctionalCachingCallSite("<<");
        }
        throw new IllegalArgumentException(String.valueOf(this.io.getMetaClass()) + "not coercible to " + this.getClass().getSimpleName() + ": no 'write' method");
    }

    public static class IOReadableWritableByteChannel
    extends IOChannel
    implements ReadableByteChannel,
    WritableByteChannel {
        private final FunctionalCachingCallSite write;
        private final FunctionalCachingCallSite read = this.initReadSite("read");

        public IOReadableWritableByteChannel(IRubyObject io2) {
            super(io2);
            this.write = this.initWriteSite();
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return IOReadableWritableByteChannel.read(this.runtime, this.io, this.read, dst);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return IOReadableWritableByteChannel.write(this.runtime, this.io, this.write, src);
        }
    }

    public static class IOWritableByteChannel
    extends IOChannel
    implements WritableByteChannel {
        private final FunctionalCachingCallSite write = this.initWriteSite();

        public IOWritableByteChannel(IRubyObject io2) {
            super(io2);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return IOWritableByteChannel.write(this.runtime, this.io, this.write, src);
        }
    }

    public static class IOReadableByteChannel
    extends IOChannel
    implements ReadableByteChannel {
        private final FunctionalCachingCallSite read;

        public IOReadableByteChannel(IRubyObject io2) {
            this(io2, "read");
        }

        public IOReadableByteChannel(IRubyObject io2, String readMethod) {
            super(io2);
            this.read = this.initReadSite(readMethod);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            return IOReadableByteChannel.read(this.runtime, this.io, this.read, dst);
        }
    }
}

