/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.jca;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.jta.xa.XID;
import com.arjuna.ats.jta.logging.jtaLogger;
import com.arjuna.ats.jta.xa.XATxConverter;
import com.arjuna.ats.jta.xa.XidImple;
import java.io.IOException;
import javax.transaction.xa.Xid;

public class SubordinateAtomicAction
extends com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.SubordinateAtomicAction {
    private Xid _theXid;
    private String _parentNodeName;
    private boolean _activated;

    public SubordinateAtomicAction() {
        this._activated = true;
        this._theXid = new XidImple(Uid.nullUid());
    }

    public SubordinateAtomicAction(Uid actId) {
        super(actId);
        this._activated = this.activate();
    }

    public SubordinateAtomicAction(Uid actId, boolean peekXidOnly) throws ObjectStoreException, IOException {
        super(actId);
        if (peekXidOnly) {
            InputObjectState os = StoreManager.getParticipantStore().read_committed(this.objectUid, this.type());
            if (os == null) {
                return;
            }
            this.unpackHeader(os, new Header());
            boolean haveXid = os.unpackBoolean();
            if (haveXid) {
                this._theXid = new XidImple();
                ((XidImple)this._theXid).unpackFrom(os);
                this._parentNodeName = os.unpackString();
            }
        } else {
            this._activated = this.activate();
        }
    }

    public SubordinateAtomicAction(int timeout, Xid xid) {
        super(timeout);
        if (xid != null && xid.getFormatId() == 131077) {
            XidImple toImport = new XidImple(xid);
            XID toCheck = toImport.getXID();
            this._parentNodeName = XATxConverter.getSubordinateNodeName(toCheck);
            if (this._parentNodeName == null) {
                this._parentNodeName = XATxConverter.getNodeName(toCheck);
            }
            XATxConverter.setSubordinateNodeName(toImport.getXID(), TxControl.getXANodeName());
            this._theXid = new XidImple(toImport);
        } else {
            this._theXid = new XidImple(xid);
        }
        this._activated = true;
    }

    @Override
    public String type() {
        return SubordinateAtomicAction.getType();
    }

    public static final String getType() {
        return "/StateManager/BasicAction/TwoPhaseCoordinator/AtomicAction/SubordinateAtomicAction/JCA";
    }

    public final Xid getXid() {
        return this._theXid;
    }

    public String getParentNodeName() {
        return this._parentNodeName;
    }

    @Override
    public boolean save_state(OutputObjectState os, int t) {
        try {
            this.packHeader(os, new Header(this.get_uid(), Utility.getProcessUid()));
            if (this._theXid != null) {
                os.packBoolean(true);
                ((XidImple)this._theXid).packInto(os);
                os.packString(this._parentNodeName);
            } else {
                os.packBoolean(false);
            }
        }
        catch (IOException ex) {
            return false;
        }
        return super.save_state(os, t);
    }

    @Override
    public boolean restore_state(InputObjectState os, int t) {
        this._theXid = null;
        try {
            this.unpackHeader(os, new Header());
            boolean haveXid = os.unpackBoolean();
            if (haveXid) {
                this._theXid = new XidImple();
                ((XidImple)this._theXid).unpackFrom(os);
                this._parentNodeName = os.unpackString();
            }
        }
        catch (IOException ex) {
            if (jtaLogger.logger.isDebugEnabled()) {
                jtaLogger.logger.debugf((Throwable)ex, "Cannot restrote state for type %s and action %s", (Object)SubordinateAtomicAction.getType(), (Object)this.toString());
            }
            return false;
        }
        return super.restore_state(os, t);
    }

    @Override
    public boolean activated() {
        return this._activated;
    }
}

