---@meta

--- Returns a shallow copy of the given Lua table.
---
--- This API can be JIT compiled.
---
--- Usage:
---
--- ```lua
--- local clone = require "table.clone"
---
--- local x = {x=12, y={5, 6, 7}}
--- local y = clone(x)
--- ```
---
--- **Note:** We observe 7% over-all speedup in the edgelang-fan compiler's
--- compiling speed whose Lua is generated by the fanlang compiler.
---
--- **Note bis:** Deep cloning is planned to be supported by adding `true` as a second argument.
---
---@param t table
---@return table
local function clone(t) end

return clone
