/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.asn1;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.ldaptive.asn1.AbstractDERType;
import org.ldaptive.asn1.DEREncoder;
import org.ldaptive.asn1.DERTag;
import org.ldaptive.asn1.UniversalDERTag;

public class IntegerType
extends AbstractDERType
implements DEREncoder {
    private final byte[] derItem;

    public IntegerType(BigInteger item) {
        super(UniversalDERTag.INT);
        this.derItem = item.toByteArray();
    }

    public IntegerType(int item) {
        super(UniversalDERTag.INT);
        this.derItem = BigInteger.valueOf(item).toByteArray();
    }

    public IntegerType(DERTag tag, BigInteger item) {
        super(tag);
        if (tag.isConstructed()) {
            throw new IllegalArgumentException("DER tag must not be constructed");
        }
        this.derItem = item.toByteArray();
    }

    public IntegerType(DERTag tag, int item) {
        super(tag);
        if (tag.isConstructed()) {
            throw new IllegalArgumentException("DER tag must not be constructed");
        }
        this.derItem = BigInteger.valueOf(item).toByteArray();
    }

    @Override
    public byte[] encode() {
        return this.encode(new byte[][]{this.derItem});
    }

    public static BigInteger decode(ByteBuffer encoded) {
        return new BigInteger(IntegerType.readBuffer(encoded));
    }

    public static BigInteger decodeUnsigned(ByteBuffer encoded) {
        return new BigInteger(1, IntegerType.readBuffer(encoded));
    }

    public static byte[] toBytes(BigInteger i) {
        return i.toByteArray();
    }
}

