
# 13 "vernac/g_proofs.mlg"
 

open Vernacexpr
open Hints

open Procq
open Procq.Prim
open Procq.Constr
open Pvernac.Vernac_

let thm_token = G_vernac.thm_token

let hint = Entry.make "hint"

let warn_deprecated_focus =
  CWarnings.create ~name:"deprecated-focus" ~category:Deprecation.Version.v8_8
    Pp.(function
      | None ->
        strbrk "The Focus command is deprecated; use bullets or focusing brackets instead."
      | Some n ->
        str "The Focus command is deprecated;" ++ spc ()
        ++ str "use '" ++ int n ++ str ": {' instead.")

let warn_deprecated_focus_n ?loc n = warn_deprecated_focus ?loc (Some n)

let warn_deprecated_focus ?loc () = warn_deprecated_focus ?loc None

let warn_deprecated_unfocus =
  CWarnings.create ~name:"deprecated-unfocus" ~category:Deprecation.Version.v8_8
         (fun () -> Pp.strbrk "The Unfocus command is deprecated")


# 36 "vernac/g_proofs.ml"

let _ =
  let opt_hintbases = Procq.Entry.make "opt_hintbases"
  and reference_or_constr = Procq.Entry.make "reference_or_constr"
  and mode = Procq.Entry.make "mode"
  in
  let () = assert (Procq.Entry.is_empty opt_hintbases) in
  let () =
  Procq.grammar_extend opt_hintbases
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PKEYWORD (":")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.stop)
                                                ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                               (fun id loc -> 
# 52 "vernac/g_proofs.mlg"
                                      id 
# 59 "vernac/g_proofs.ml"
)])))))
                            (fun l _ loc -> 
# 52 "vernac/g_proofs.mlg"
                                                  l 
# 64 "vernac/g_proofs.ml"
);
                           Procq.Production.make (Procq.Rule.stop)
                           (fun loc -> 
# 51 "vernac/g_proofs.mlg"
           [] 
# 70 "vernac/g_proofs.ml"
)])]))
  in let () =
  Procq.grammar_extend command
  (Procq.Reuse (None, [Procq.Production.make
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some ("Hint"))))))
                         ((Procq.Symbol.nterm hint)))
                        ((Procq.Symbol.nterm opt_hintbases)))
                       (fun dbnames h _ loc -> 
# 110 "vernac/g_proofs.mlg"
            VernacSynPure (VernacHints (dbnames, h)) 
# 84 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Remove"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Hints"))))))
                        ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                       ((Procq.Symbol.nterm opt_hintbases)))
                      (fun dbnames ids _ _ loc -> 
# 108 "vernac/g_proofs.mlg"
            VernacSynPure (VernacRemoveHints (dbnames, ids)) 
# 99 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Create"))))))
                         ((Procq.Symbol.token (Tok.PIDENT (Some
                         ("HintDb"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (None)))))
                       ((Procq.Symbol.rules [Procq.Rules.make (Procq.Rule.stop)
                                                              (fun loc -> 
                                                              
# 105 "vernac/g_proofs.mlg"
                                                                      false 
# 116 "vernac/g_proofs.ml"
);
                                            Procq.Rules.make (Procq.Rule.next_norec
                                                              (Procq.Rule.stop)
                                                              ((Procq.Symbol.token (Tok.PIDENT (Some
                                                              ("discriminated"))))))
                                                             (fun _ loc -> 
                                                             
# 105 "vernac/g_proofs.mlg"
                                                        true 
# 126 "vernac/g_proofs.ml"
)])))
                      (fun b id _ _ loc -> 
# 106 "vernac/g_proofs.mlg"
              VernacSynPure (VernacCreateHintDb (id, b)) 
# 131 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some
                        ("Validate"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                      (fun _ _ loc -> 
# 102 "vernac/g_proofs.mlg"
                                             VernacSynPure VernacValidateProof 
# 142 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Guarded"))))))
                      (fun _ loc -> 
# 101 "vernac/g_proofs.mlg"
                             VernacSynPure VernacCheckGuard 
# 150 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Match"))))))
                       ((Procq.Symbol.nterm reference)))
                      (fun id _ _ loc -> 
# 100 "vernac/g_proofs.mlg"
                                                         VernacSynPure (VernacShow (ShowMatch id)) 
# 162 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Intros"))))))
                      (fun _ _ loc -> 
# 99 "vernac/g_proofs.mlg"
                                          VernacSynPure (VernacShow (ShowIntros true)) 
# 172 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Intro"))))))
                      (fun _ _ loc -> 
# 98 "vernac/g_proofs.mlg"
                                         VernacSynPure (VernacShow (ShowIntros false)) 
# 182 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                      (fun _ _ loc -> 
# 97 "vernac/g_proofs.mlg"
                                         VernacSynPure (VernacShow ShowProof) 
# 192 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some
                       ("Conjectures"))))))
                      (fun _ _ loc -> 
# 96 "vernac/g_proofs.mlg"
                                               VernacSynPure (VernacShow ShowProofNames) 
# 203 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some
                       ("Universes"))))))
                      (fun _ _ loc -> 
# 95 "vernac/g_proofs.mlg"
                                             VernacSynPure (VernacShow ShowUniverses) 
# 214 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some
                       ("Existentials"))))))
                      (fun _ _ loc -> 
# 94 "vernac/g_proofs.mlg"
                                                VernacSynPure (VernacShow ShowExistentials) 
# 225 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.nterm ident)))
                      (fun id _ loc -> 
# 93 "vernac/g_proofs.mlg"
                                      VernacSynPure (VernacShow (ShowGoal (GoalId id))) 
# 235 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                       ((Procq.Symbol.nterm natural)))
                      (fun n _ loc -> 
# 92 "vernac/g_proofs.mlg"
                                       VernacSynPure (VernacShow (ShowGoal (NthGoal n))) 
# 245 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Show"))))))
                      (fun _ loc -> 
# 91 "vernac/g_proofs.mlg"
                          VernacSynPure (VernacShow (ShowGoal OpenSubgoals)) 
# 253 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some
                       ("Unfocused"))))))
                      (fun _ loc -> 
# 90 "vernac/g_proofs.mlg"
                               VernacSynPure VernacUnfocused 
# 262 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Unfocus"))))))
                      (fun _ loc -> 
# 88 "vernac/g_proofs.mlg"
           warn_deprecated_unfocus ~loc ();
         VernacSynPure VernacUnfocus 
# 271 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Focus"))))))
                       ((Procq.Symbol.nterm natural)))
                      (fun n _ loc -> 
# 85 "vernac/g_proofs.mlg"
           warn_deprecated_focus_n n ~loc;
         VernacSynPure (VernacFocus (Some n)) 
# 282 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Focus"))))))
                      (fun _ loc -> 
# 82 "vernac/g_proofs.mlg"
           warn_deprecated_focus ~loc ();
         VernacSynPure (VernacFocus None) 
# 291 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Undo"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("To"))))))
                       ((Procq.Symbol.nterm natural)))
                      (fun n _ _ loc -> 
# 80 "vernac/g_proofs.mlg"
                                                   VernacSynPure (VernacUndoTo n) 
# 303 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Undo"))))))
                       ((Procq.Symbol.nterm natural)))
                      (fun n _ loc -> 
# 79 "vernac/g_proofs.mlg"
                                       VernacSynPure (VernacUndo n) 
# 313 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Undo"))))))
                      (fun _ loc -> 
# 78 "vernac/g_proofs.mlg"
                          VernacSynPure (VernacUndo 1) 
# 321 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Restart"))))))
                      (fun _ loc -> 
# 77 "vernac/g_proofs.mlg"
                             VernacSynPure VernacRestart 
# 329 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some
                        ("Defined"))))))
                       ((Procq.Symbol.nterm identref)))
                      (fun id _ loc -> 
# 76 "vernac/g_proofs.mlg"
            VernacSynPure (VernacEndProof (Proved (Transparent,Some id))) 
# 340 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Defined"))))))
                      (fun _ loc -> 
# 74 "vernac/g_proofs.mlg"
                             VernacSynPure (VernacEndProof (Proved (Transparent,None))) 
# 348 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Save"))))))
                       ((Procq.Symbol.nterm identref)))
                      (fun id _ loc -> 
# 73 "vernac/g_proofs.mlg"
            VernacSynPure (VernacEndProof (Proved (Opaque, Some id))) 
# 358 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Qed"))))))
                      (fun _ loc -> 
# 71 "vernac/g_proofs.mlg"
                         VernacSynPure (VernacEndProof (Proved (Opaque,None))) 
# 366 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some
                       ("Admitted"))))))
                      (fun _ loc -> 
# 70 "vernac/g_proofs.mlg"
                              VernacSynPure (VernacEndProof Admitted) 
# 375 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Abort"))))))
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("All"))))))
                      (fun _ _ loc -> 
# 69 "vernac/g_proofs.mlg"
                                        VernacSynPure VernacAbortAll 
# 385 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Abort"))))))
                      (fun _ loc -> 
# 68 "vernac/g_proofs.mlg"
                           VernacSynPure VernacAbort 
# 393 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                       ((Procq.Symbol.nterm lconstr)))
                      (fun c _ loc -> 
# 67 "vernac/g_proofs.mlg"
                                        VernacSynPure (VernacExactProof c) 
# 403 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Mode"))))))
                       ((Procq.Symbol.nterm string)))
                      (fun mn _ _ loc -> 
# 66 "vernac/g_proofs.mlg"
                                                        VernacSynterp (VernacProofMode mn) 
# 415 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next
                          (Procq.Rule.next (Procq.Rule.stop)
                           ((Procq.Symbol.token (Tok.PIDENT (Some
                           ("Proof"))))))
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("using"))))))
                         ((Procq.Symbol.nterm G_vernac.section_subset_expr)))
                        ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                       ((Procq.Symbol.nterm generic_tactic)))
                      (fun ta _ l _ _ loc -> 
# 65 "vernac/g_proofs.mlg"
            Vernacexpr.VernacSynPure (Vernacexpr.VernacProof (Some ta,Some l)) 
# 433 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next
                         (Procq.Rule.next (Procq.Rule.stop)
                          ((Procq.Symbol.token (Tok.PIDENT (Some
                          ("Proof"))))))
                         ((Procq.Symbol.token (Tok.PKEYWORD ("with")))))
                        ((Procq.Symbol.nterm generic_tactic)))
                       ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                              (Procq.Rule.next_norec
                                                               (Procq.Rule.next_norec
                                                                (Procq.Rule.stop)
                                                                ((Procq.Symbol.token (Tok.PIDENT (Some
                                                                ("using"))))))
                                                               ((Procq.Symbol.nterm G_vernac.section_subset_expr)))
                                                              (fun l _ loc ->
                                                              
# 61 "vernac/g_proofs.mlg"
                                                                       l 
# 455 "vernac/g_proofs.ml"
)]))))
                      (fun l ta _ _ loc -> 
# 62 "vernac/g_proofs.mlg"
            Vernacexpr.VernacSynPure (Vernacexpr.VernacProof (Some ta, l)) 
# 460 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next
                        (Procq.Rule.next (Procq.Rule.stop)
                         ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("using"))))))
                       ((Procq.Symbol.nterm G_vernac.section_subset_expr)))
                      (fun l _ _ loc -> 
# 59 "vernac/g_proofs.mlg"
          VernacSynPure (VernacProof (None,Some l)) 
# 472 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next (Procq.Rule.stop)
                       ((Procq.Symbol.token (Tok.PIDENT (Some ("Proof"))))))
                      (fun _ loc -> 
# 57 "vernac/g_proofs.mlg"
                           VernacSynPure (VernacProof (None,None)) 
# 480 "vernac/g_proofs.ml"
);
                      Procq.Production.make
                      (Procq.Rule.next
                       (Procq.Rule.next (Procq.Rule.stop)
                        ((Procq.Symbol.token (Tok.PIDENT (Some ("Goal"))))))
                       ((Procq.Symbol.nterm lconstr)))
                      (fun c _ loc -> 
# 56 "vernac/g_proofs.mlg"
          VernacSynPure (VernacDefinition (Decls.(NoDischarge, Definition), ((CAst.make ~loc Names.Anonymous), None), ProveBody ([], c))) 
# 490 "vernac/g_proofs.ml"
)]))
  in let () = assert (Procq.Entry.is_empty reference_or_constr) in
  let () =
  Procq.grammar_extend reference_or_constr
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm constr)))
                            (fun c loc -> 
# 114 "vernac/g_proofs.mlg"
                       HintsConstr c 
# 503 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm global)))
                           (fun r loc -> 
# 113 "vernac/g_proofs.mlg"
                       HintsReference r 
# 511 "vernac/g_proofs.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hint) in
  let () =
  Procq.grammar_extend hint
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next
                               (Procq.Rule.next
                                (Procq.Rule.next (Procq.Rule.stop)
                                 ((Procq.Symbol.token (Tok.PIDENT (Some
                                 ("Extern"))))))
                                ((Procq.Symbol.nterm natural)))
                               ((Procq.Symbol.opt (Procq.Symbol.nterm Constr.constr_pattern))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("=>")))))
                             ((Procq.Symbol.nterm generic_tactic)))
                            (fun tac _ c n _ loc -> 
# 137 "vernac/g_proofs.mlg"
          Vernacexpr.HintsExtern (n,c, tac) 
# 533 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Constructors"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun lc _ loc -> 
# 134 "vernac/g_proofs.mlg"
                                                     HintsConstructors lc 
# 544 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Unfold"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun lqid _ loc -> 
# 133 "vernac/g_proofs.mlg"
                                                 HintsUnfold lqid 
# 555 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Mode"))))))
                             ((Procq.Symbol.nterm global)))
                            ((Procq.Symbol.nterm mode)))
                           (fun m l _ loc -> 
# 132 "vernac/g_proofs.mlg"
                                                HintsMode (l, m) 
# 568 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Opaque"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun lc _ loc -> 
# 131 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsReferences lc, false) 
# 579 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Transparent"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                           (fun lc _ loc -> 
# 130 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsReferences lc, true) 
# 590 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Projections"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Opaque"))))))
                           (fun _ _ loc -> 
# 129 "vernac/g_proofs.mlg"
                                                 HintsTransparency (HintsProjections, false) 
# 602 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Projections"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Transparent"))))))
                           (fun _ _ loc -> 
# 128 "vernac/g_proofs.mlg"
                                                      HintsTransparency (HintsProjections, true) 
# 614 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Constants"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Opaque"))))))
                           (fun _ _ loc -> 
# 127 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsConstants, false) 
# 626 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Constants"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Transparent"))))))
                           (fun _ _ loc -> 
# 126 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsConstants, true) 
# 638 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Variables"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Opaque"))))))
                           (fun _ _ loc -> 
# 125 "vernac/g_proofs.mlg"
                                               HintsTransparency (HintsVariables, false) 
# 650 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Variables"))))))
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("Transparent"))))))
                           (fun _ _ loc -> 
# 124 "vernac/g_proofs.mlg"
                                                    HintsTransparency (HintsVariables, true) 
# 662 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("Immediate"))))))
                            ((Procq.Symbol.list1 ((Procq.Symbol.nterm reference_or_constr)))))
                           (fun lc _ loc -> 
# 123 "vernac/g_proofs.mlg"
                                                               HintsImmediate lc 
# 673 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Resolve"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("<-")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm natural))))
                           (fun n lc _ _ loc -> 
# 122 "vernac/g_proofs.mlg"
            HintsResolveIFF (false, lc, n) 
# 688 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.token (Tok.PIDENT (Some
                               ("Resolve"))))))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("->")))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm global)))))
                            ((Procq.Symbol.opt (Procq.Symbol.nterm natural))))
                           (fun n lc _ _ loc -> 
# 120 "vernac/g_proofs.mlg"
            HintsResolveIFF (true, lc, n) 
# 703 "vernac/g_proofs.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PIDENT (Some
                              ("Resolve"))))))
                             ((Procq.Symbol.list1 ((Procq.Symbol.nterm reference_or_constr)))))
                            ((Procq.Symbol.nterm hint_info)))
                           (fun info lc _ loc -> 
# 118 "vernac/g_proofs.mlg"
            HintsResolve (List.map (fun x -> (info, true, x)) lc) 
# 716 "vernac/g_proofs.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty mode) in
  let () =
  Procq.grammar_extend mode
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.list1 ((Procq.Symbol.rules 
                             [Procq.Rules.make (Procq.Rule.next_norec
                                                (Procq.Rule.stop)
                                                ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                                               (fun _ loc -> 
# 143 "vernac/g_proofs.mlg"
                             ModeOutput 
# 732 "vernac/g_proofs.ml"
);
                             Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.stop)
                                               ((Procq.Symbol.token (Tok.PKEYWORD ("!")))))
                                              (fun _ loc -> 
# 142 "vernac/g_proofs.mlg"
                             ModeNoHeadEvar 
# 740 "vernac/g_proofs.ml"
);
                             Procq.Rules.make (Procq.Rule.next_norec
                                               (Procq.Rule.stop)
                                               ((Procq.Symbol.token (Tok.PKEYWORD ("+")))))
                                              (fun _ loc -> 
# 141 "vernac/g_proofs.mlg"
                             ModeInput 
# 748 "vernac/g_proofs.ml"
)])))))
                            (fun l loc -> 
# 143 "vernac/g_proofs.mlg"
                                                 l 
# 753 "vernac/g_proofs.ml"
)])]))
  in ()

