﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chatbot/ChatbotRequest.h>
#include <aws/chatbot/Chatbot_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace chatbot {
namespace Model {

/**
 */
class DeleteMicrosoftTeamsUserIdentityRequest : public ChatbotRequest {
 public:
  AWS_CHATBOT_API DeleteMicrosoftTeamsUserIdentityRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteMicrosoftTeamsUserIdentity"; }

  AWS_CHATBOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the MicrosoftTeamsChannelConfiguration associated with the user
   * identity to delete.</p>
   */
  inline const Aws::String& GetChatConfigurationArn() const { return m_chatConfigurationArn; }
  inline bool ChatConfigurationArnHasBeenSet() const { return m_chatConfigurationArnHasBeenSet; }
  template <typename ChatConfigurationArnT = Aws::String>
  void SetChatConfigurationArn(ChatConfigurationArnT&& value) {
    m_chatConfigurationArnHasBeenSet = true;
    m_chatConfigurationArn = std::forward<ChatConfigurationArnT>(value);
  }
  template <typename ChatConfigurationArnT = Aws::String>
  DeleteMicrosoftTeamsUserIdentityRequest& WithChatConfigurationArn(ChatConfigurationArnT&& value) {
    SetChatConfigurationArn(std::forward<ChatConfigurationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Microsoft Teams user ID.</p>
   */
  inline const Aws::String& GetUserId() const { return m_userId; }
  inline bool UserIdHasBeenSet() const { return m_userIdHasBeenSet; }
  template <typename UserIdT = Aws::String>
  void SetUserId(UserIdT&& value) {
    m_userIdHasBeenSet = true;
    m_userId = std::forward<UserIdT>(value);
  }
  template <typename UserIdT = Aws::String>
  DeleteMicrosoftTeamsUserIdentityRequest& WithUserId(UserIdT&& value) {
    SetUserId(std::forward<UserIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_chatConfigurationArn;
  bool m_chatConfigurationArnHasBeenSet = false;

  Aws::String m_userId;
  bool m_userIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace chatbot
}  // namespace Aws
