/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.CompositeChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.InternalTextEditChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPreviewChangeFilter;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.TextEditChangeNode;

public abstract class AbstractChangeNode
extends PreviewNode {
    private final Change fChange;
    private PreviewNode[] fChildren;

    public static PreviewNode createNode(PreviewNode parent, RefactoringPreviewChangeFilter filter, Change change) {
        if (change instanceof CompositeChange) {
            return new CompositeChangeNode(parent, filter, (CompositeChange)change);
        }
        if (change instanceof TextEditBasedChange) {
            InternalTextEditChangeNode result = (InternalTextEditChangeNode)change.getAdapter(TextEditChangeNode.class);
            if (result == null) {
                result = new TextEditChangeNode((TextEditBasedChange)change);
            }
            result.initialize(parent);
            return result;
        }
        return new DefaultChangeNode(parent, change);
    }

    public static PreviewNode createNode(PreviewNode parent, Change change) {
        return AbstractChangeNode.createNode(parent, null, change);
    }

    AbstractChangeNode(PreviewNode parent, Change change) {
        super(parent);
        Assert.isNotNull((Object)change);
        this.fChange = change;
    }

    Change getChange() {
        return this.fChange;
    }

    @Override
    PreviewNode[] getChildren() {
        if (this.fChildren == null) {
            this.fChildren = this.doCreateChildren();
        }
        return this.fChildren;
    }

    abstract PreviewNode[] doCreateChildren();

    @Override
    public String getText() {
        return this.fChange.getName();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return RefactoringPluginImages.DESC_OBJS_DEFAULT_CHANGE;
    }

    @Override
    ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        return ChangePreviewViewerDescriptor.get(this.fChange);
    }

    @Override
    void feedInput(IChangePreviewViewer viewer, List<GroupCategory> categories) throws CoreException {
        viewer.setInput(new ChangePreviewViewerInput(this.fChange));
    }

    @Override
    void setEnabled(boolean enabled) {
        this.fChange.setEnabled(enabled);
    }

    @Override
    void setEnabledShallow(boolean enabled) {
        this.fChange.setEnabledShallow(enabled);
    }

    @Override
    boolean hasOneGroupCategory(List<GroupCategory> categories) {
        PreviewNode[] previewNodeArray = this.getChildren();
        int n = previewNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreviewNode child = previewNodeArray[n2];
            if (child.hasOneGroupCategory(categories)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    boolean hasDerived() {
        if (AbstractChangeNode.hasDerivedResourceChange(this.fChange)) {
            return true;
        }
        PreviewNode[] previewNodeArray = this.getChildren();
        int n = previewNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreviewNode child = previewNodeArray[n2];
            if (child.hasDerived()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    int getDefaultChangeActive() {
        int result;
        int n = result = this.fChange.isEnabled() ? 2 : 0;
        if (this.fChildren != null) {
            PreviewNode[] previewNodeArray = this.fChildren;
            int n2 = this.fChildren.length;
            int n3 = 0;
            while (n3 < n2) {
                PreviewNode child = previewNodeArray[n3];
                result = ACTIVATION_TABLE[child.getActive()][result];
                if (result == 1) break;
                ++n3;
            }
        }
        return result;
    }

    int getCompositeChangeActive() {
        if (this.fChildren != null && this.fChildren.length > 0) {
            int result = this.fChildren[0].getActive();
            int i = 1;
            while (i < this.fChildren.length) {
                result = ACTIVATION_TABLE[this.fChildren[i].getActive()][result];
                if (result == 1) break;
                ++i;
            }
            return result;
        }
        return this.fChange.isEnabled() ? 2 : 0;
    }

    static boolean hasDerivedResourceChange(Change change) {
        IAdaptable adaptable;
        IResource resource;
        Object modifiedElement = change.getModifiedElement();
        if (modifiedElement instanceof IResource) {
            return ((IResource)modifiedElement).isDerived(512);
        }
        if (modifiedElement instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)modifiedElement).getAdapter(IResource.class)) != null) {
            return resource.isDerived(512);
        }
        return false;
    }
}

