/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import tim.prune.function.filesleuth.TrackListListener;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.data.TrackFile;
import tim.prune.function.filesleuth.data.TrackFileStatus;

public class TrackFileList {
    private final ArrayList<TrackFile> _tracks = new ArrayList();
    private final ArrayList<TrackListListener> _listeners = new ArrayList();
    private boolean _listComplete = false;

    public synchronized void clear() {
        this._tracks.clear();
        this._listComplete = false;
    }

    public void addListener(TrackListListener trackListListener) {
        this._listeners.add(trackListListener);
    }

    public int getCurrentSize() {
        return this._tracks.size();
    }

    public boolean isListComplete() {
        return this._listComplete;
    }

    public void setListComplete() {
        this._listComplete = true;
    }

    public synchronized void foundFile(Path path) {
        int n = this._tracks.size();
        TrackFile trackFile = new TrackFile(path.toFile());
        this._tracks.add(trackFile);
        trackFile.setIndex(n);
        this.triggerListeners(n);
    }

    public synchronized boolean claimTrackFileForScanning(TrackFile trackFile) {
        if (trackFile.getStatus() == TrackFileStatus.FOUND) {
            trackFile.setStatus(TrackFileStatus.SCANNING);
            return true;
        }
        return false;
    }

    public synchronized void scanComplete(TrackFile trackFile, TrackContents trackContents) {
        trackFile.setContents(trackContents);
        trackFile.setStatus(TrackFileStatus.COMPLETE);
        this.triggerListeners(trackFile.getIndex());
    }

    private void triggerListeners(int n) {
        for (TrackListListener trackListListener : this._listeners) {
            trackListListener.reactToTrackListChange(n);
        }
    }

    public synchronized List<TrackFile> getCurrentContents() {
        return List.copyOf(this._tracks);
    }
}

