/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia.basic;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.Trackable;

public class FantasiaFaderUI
extends BasicSliderUI
implements Trackable {
    private ButtonModel knobModel = new DefaultButtonModel();
    private RolloverControlListener rolloverListener = new RolloverControlListener(this, this.knobModel);
    Color c1 = new Color(0x888888);
    Color c2 = new Color(0x555555);
    Color c3 = new Color(0xF5F5F5);
    Color c4 = new Color(0.0f, 0.0f, 0.0f, 0.1f);
    Color c6 = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    Color c8 = new Color(0.0f, 0.0f, 0.0f, 0.78f);
    Color c12 = new Color(1.0f, 1.0f, 1.0f, 0.02f);
    Color c14 = new Color(1.0f, 1.0f, 1.0f, 0.22f);
    Color c16 = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    Color c18 = new Color(1.0f, 1.0f, 1.0f, 0.78f);
    private final Handler handler = new Handler();

    public FantasiaFaderUI(JSlider jSlider) {
        super(jSlider);
        jSlider.setOpaque(false);
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        this.rolloverListener = new RolloverControlListener(this, this.knobModel);
        jSlider.addMouseListener(this.rolloverListener);
        jSlider.addMouseMotionListener(this.rolloverListener);
        this.knobModel.addChangeListener(this.getHandler());
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        super.uninstallListeners(jSlider);
        jSlider.removeMouseListener(this.rolloverListener);
        jSlider.removeMouseMotionListener(this.rolloverListener);
        this.rolloverListener = null;
        this.knobModel.removeChangeListener(this.getHandler());
    }

    @Override
    public void paintTrack(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.slider.getOrientation() == 0) {
            int n = this.trackRect.height / 2 - 3;
            int n2 = this.trackRect.width;
            graphics.translate(this.trackRect.x, this.trackRect.y + n);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2 - 1, 3.0);
            graphics2D.setPaint(new Color(0x4B4B4B));
            graphics2D.fill(double_);
            FantasiaPainter.paintBoldInnerBorder(graphics2D, 0.0, 0.0, n2 - 1, 3.0);
            graphics.translate(-this.trackRect.x, -(this.trackRect.y + n));
        } else {
            int n = this.trackRect.width / 2 - 2;
            int n3 = this.trackRect.height;
            graphics.translate(this.trackRect.x + n, this.trackRect.y);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 3.0, n3 - 1);
            graphics2D.setPaint(new Color(0x4B4B4B));
            graphics2D.fill(double_);
            FantasiaPainter.paintBoldInnerBorder(graphics2D, 0.0, 0.0, 3.0, n3 - 1);
            graphics.translate(-(this.trackRect.x + n), -this.trackRect.y);
        }
    }

    public void paintHorizontalLine(Graphics2D graphics2D, double d, double d2, double d3, Color color) {
        float f = color.getRed();
        float f2 = color.getGreen();
        float f3 = color.getBlue();
        GradientPaint gradientPaint = new GradientPaint((float)d2, (float)d, new Color(f /= 255.0f, f2 /= 255.0f, f3 /= 255.0f, 0.4f), (float)d2 + 3.0f, (float)d, color);
        Line2D.Double double_ = new Line2D.Double(d2, d, d2 + 3.0, d);
        graphics2D.setPaint(gradientPaint);
        graphics2D.draw(double_);
        graphics2D.setPaint(color);
        double_ = new Line2D.Double(d2 + 4.0, d, d3 - 5.0, d);
        graphics2D.draw(double_);
        gradientPaint = new GradientPaint((float)d3 - 4.0f, (float)d, color, (float)d3, (float)d, new Color(f, f2, f3, 0.1f));
        double_ = new Line2D.Double(d3 - 4.0, d, d3, d);
        graphics2D.setPaint(gradientPaint);
        graphics2D.draw(double_);
    }

    public void paintVerticalLine(Graphics2D graphics2D, double d, double d2, double d3, Color color) {
        float f = color.getRed();
        float f2 = color.getGreen();
        float f3 = color.getBlue();
        GradientPaint gradientPaint = new GradientPaint((float)d, (float)d2, new Color(f /= 255.0f, f2 /= 255.0f, f3 /= 255.0f, 0.4f), (float)d, (float)d2 + 3.0f, color);
        Line2D.Double double_ = new Line2D.Double(d, d2, d, d2 + 3.0);
        graphics2D.setPaint(gradientPaint);
        graphics2D.draw(double_);
        graphics2D.setPaint(color);
        double_ = new Line2D.Double(d, d2 + 4.0, d, d3 - 7.0);
        graphics2D.draw(double_);
        gradientPaint = new GradientPaint((float)d, (float)d3 - 6.0f, color, (float)d, (float)d3, new Color(f, f2, f3, 0.0f));
        double_ = new Line2D.Double(d, d3 - 6.0, d, d3);
        graphics2D.setPaint(gradientPaint);
        graphics2D.draw(double_);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Color color;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d = this.thumbRect.getHeight();
        double d2 = this.thumbRect.getWidth();
        double d3 = this.thumbRect.x + 2;
        double d4 = this.thumbRect.y + 1;
        double d5 = (double)this.thumbRect.x + d2 - 3.0;
        double d6 = (double)this.thumbRect.y + d - 5.0;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d3, d4, d5 - d3 + 1.0, d6 - d4 + 1.0, 8.0, 8.0);
        Color color2 = color = this.knobModel.isRollover() ? new Color(0x999999) : this.c1;
        if (this.knobModel.isPressed()) {
            color = new Color(0x777777);
        }
        GradientPaint gradientPaint = new GradientPaint((float)d3, (float)d4, color, (float)d3, (float)d6, this.c2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(double_);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setPaint(Color.BLACK);
        double_ = new RoundRectangle2D.Double(d3 - 1.0, d4 - 1.0, d5 - d3 + 2.0, d6 - d4 + 1.0, 6.0, 6.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(1.0f));
        gradientPaint = new GradientPaint((float)d3, (float)d4 + 1.0f, this.c14, (float)d3, (float)d4 + 3.0f, this.c12);
        graphics2D.setPaint(gradientPaint);
        Arc2D.Double double_2 = new Arc2D.Double(d3, d4, d5 - d3, 4.0, 0.0, 180.0, 0);
        graphics2D.draw(double_2);
        gradientPaint = new GradientPaint((float)d3, (float)d6 - 4.0f, this.c6, (float)d3, (float)d6 + 4.0f, this.c4);
        graphics2D.setPaint(gradientPaint);
        graphics2D.setComposite(alphaComposite.derive(0.7f));
        double_2 = new Arc2D.Double(d3 - 1.0, d6 - 4.0, d5 - d3 + 3.0, 7.0, 180.0, 180.0, 2);
        graphics2D.fill(double_2);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.07f));
        double_2 = new Arc2D.Double(d3 - 1.0, d6 - 3.0, d5 - d3 + 2.0, 5.0, 180.0, 180.0, 0);
        graphics2D.draw(double_2);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        Line2D.Double double_3 = new Line2D.Double(d3 + 3.0, d6 + 1.0, d5 - 3.0, d6 + 1.0);
        graphics2D.draw(double_3);
        graphics2D.setPaint(this.c3);
        graphics2D.setComposite(alphaComposite.derive(0.06f));
        double_3 = new Line2D.Double(d3 + 6.0, d4 - 1.0, d3 + 8.0, d4 - 1.0);
        graphics2D.draw(double_3);
        if (this.slider.getOrientation() == 0) {
            double d7 = (double)this.thumbRect.x + d2 / 2.0;
            graphics2D.setComposite(alphaComposite.derive(1.0f));
            this.paintVerticalLine(graphics2D, d7, d4, d6, this.c3);
            graphics2D.setComposite(alphaComposite.derive(0.3f));
            this.paintVerticalLine(graphics2D, d7 - 1.0, d4, d6, Color.BLACK);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setComposite(alphaComposite.derive(0.1f));
            this.paintVerticalLine(graphics2D, d7 + 1.0, d4, d6, Color.WHITE);
        } else {
            double d8 = (double)this.thumbRect.y + d / 2.0 - 2.0;
            graphics2D.setComposite(alphaComposite.derive(1.0f));
            this.paintHorizontalLine(graphics2D, d8, d3, d5, this.c3);
            graphics2D.setComposite(alphaComposite.derive(0.3f));
            this.paintHorizontalLine(graphics2D, d8 - 1.0, d3, d5, Color.BLACK);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.setComposite(alphaComposite.derive(0.1f));
            this.paintHorizontalLine(graphics2D, d8 + 1.0, d3, d5, Color.WHITE);
        }
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.1f));
        double_3 = new Line2D.Double(d5, d4 + 1.0, d5, d6 - 2.0);
        graphics2D.draw(double_3);
        graphics2D.setComposite(alphaComposite.derive(0.06f));
        double_3 = new Line2D.Double(d3 - 2.0, d4 + 2.0, d3 - 2.0, d6 - 2.0);
        graphics2D.draw(double_3);
        double_3 = new Line2D.Double(d5 + 2.0, d4 + 2.0, d5 + 2.0, d6 - 2.0);
        graphics2D.draw(double_3);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (this.thumbRect == null) {
            return false;
        }
        return this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY());
    }

    private Handler getHandler() {
        return this.handler;
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = (Dimension)this.slider.getClientProperty("Fader.knobSize");
        if (dimension != null) {
            return dimension;
        }
        return this.slider.getOrientation() == 1 ? new Dimension(27, 20) : new Dimension(17, 27);
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            FantasiaFaderUI.this.slider.repaint(FantasiaFaderUI.this.thumbRect);
        }
    }
}

