/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.metrics;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxIoMetricsCollector {
    private static final Logger LOG = LoggerFactory.getLogger(LinuxIoMetricsCollector.class);
    private static final String READ_BYTES_PREFIX = "read_bytes: ";
    private static final String WRITE_BYTES_PREFIX = "write_bytes: ";
    private final Time time;
    private final Path path;
    private long lastUpdateMs = -1L;
    private long cachedReadBytes = 0L;
    private long cachedWriteBytes = 0L;

    public LinuxIoMetricsCollector(String procRoot, Time time) {
        this.time = time;
        this.path = Paths.get(procRoot, "self", "io");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBytes() {
        LinuxIoMetricsCollector linuxIoMetricsCollector = this;
        synchronized (linuxIoMetricsCollector) {
            long curMs = this.time.milliseconds();
            if (curMs != this.lastUpdateMs) {
                this.updateValues(curMs);
            }
            return this.cachedReadBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeBytes() {
        LinuxIoMetricsCollector linuxIoMetricsCollector = this;
        synchronized (linuxIoMetricsCollector) {
            long curMs = this.time.milliseconds();
            if (curMs != this.lastUpdateMs) {
                this.updateValues(curMs);
            }
            return this.cachedWriteBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateValues(long now) {
        LinuxIoMetricsCollector linuxIoMetricsCollector = this;
        synchronized (linuxIoMetricsCollector) {
            try {
                this.cachedReadBytes = -1L;
                this.cachedWriteBytes = -1L;
                List<String> lines = Files.readAllLines(this.path, StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (line.startsWith(READ_BYTES_PREFIX)) {
                        this.cachedReadBytes = Long.parseLong(line.substring(READ_BYTES_PREFIX.length()));
                        continue;
                    }
                    if (!line.startsWith(WRITE_BYTES_PREFIX)) continue;
                    this.cachedWriteBytes = Long.parseLong(line.substring(WRITE_BYTES_PREFIX.length()));
                }
                this.lastUpdateMs = now;
                return true;
            }
            catch (Throwable t) {
                LOG.warn("Unable to update IO metrics", t);
                return false;
            }
        }
    }

    public boolean usable() {
        if (this.path.toFile().exists()) {
            return this.updateValues(this.time.milliseconds());
        }
        LOG.debug("Disabling IO metrics collection because {} does not exist.", (Object)this.path);
        return false;
    }
}

