/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "<init>", "()V", "functionsStack", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "functionalScopes", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitVars", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visitFunction", "varWithNameExistsInScopeOf", "", "function", "variableName", "", "Scope", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n1915#2,2:413\n1915#2,2:415\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector\n*L\n357#1:413,2\n365#1:415,2\n*E\n"})
public final class JsScopesCollector
extends RecursiveJsVisitor {
    @NotNull
    private final List<Scope> functionsStack;
    @NotNull
    private final Map<JsFunction, Scope> functionalScopes;

    public JsScopesCollector() {
        Object[] objectArray = new Scope[]{new Scope(null)};
        this.functionsStack = CollectionsKt.mutableListOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to(null, CollectionsKt.first(this.functionsStack))};
        this.functionalScopes = MapsKt.mutableMapOf(objectArray);
    }

    @Override
    public void visitVars(@NotNull JsVars x2) {
        Intrinsics.checkNotNullParameter(x2, "x");
        super.visitVars(x2);
        Scope currentScope = CollectionsKt.last(this.functionsStack);
        List<JsVars.JsVar> list = x2.getVars();
        Intrinsics.checkNotNullExpressionValue(list, "getVars(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            String string = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue(string, "getIdent(...)");
            currentScope.add(string);
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x2) {
        String name2;
        Scope scope2;
        Intrinsics.checkNotNullParameter(x2, "x");
        Scope parentScope = CollectionsKt.last(this.functionsStack);
        Scope $this$visitFunction_u24lambda_u240 = scope2 = new Scope(parentScope);
        boolean bl = false;
        JsName jsName = x2.getName();
        String string = name2 = jsName != null ? jsName.getIdent() : null;
        if (name2 != null) {
            $this$visitFunction_u24lambda_u240.add(name2);
        }
        List<JsParameter> list = x2.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsParameter it = (JsParameter)element$iv;
            boolean bl2 = false;
            String string2 = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue(string2, "getIdent(...)");
            $this$visitFunction_u24lambda_u240.add(string2);
        }
        Scope newScope = scope2;
        UtilsKt.push(this.functionsStack, newScope);
        this.functionalScopes.put(x2, newScope);
        super.visitFunction(x2);
        UtilsKt.pop(this.functionsStack);
    }

    public final boolean varWithNameExistsInScopeOf(@Nullable JsFunction function2, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter(variableName, "variableName");
        Scope scope2 = this.functionalScopes.get(function2);
        Intrinsics.checkNotNull(scope2);
        return scope2.variableWithNameExists(variableName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "", "parent", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;)V", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "variables", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "add", "", "variableName", "variableWithNameExists", "", "backend.js"})
    private static final class Scope {
        @Nullable
        private final Scope parent;
        @NotNull
        private final HashSet<String> variables;

        public Scope(@Nullable Scope parent2) {
            this.parent = parent2;
            this.variables = new HashSet();
        }

        @Nullable
        public final Scope getParent() {
            return this.parent;
        }

        public final void add(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter(variableName, "variableName");
            this.variables.add(variableName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean variableWithNameExists(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter(variableName, "variableName");
            if (this.variables.contains(variableName)) return true;
            Scope scope2 = this.parent;
            if (scope2 == null) return false;
            if (!scope2.variableWithNameExists(variableName)) return false;
            return true;
        }
    }
}

