/*
 * Copyright (C) 2009 Pierre-Luc Beaudoin <pierre-luc@pierlux.com>
 * File inspired by shumate-version.h.in which is
 * Authored By Matthew Allum  <mallum@openedhand.com>
 * Copyright (C) 2006 OpenedHand
 * Copyright (C) 2019 Marcus Lundblad <ml@update.uu.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __SHUMATE_VERSION_H__
#define __SHUMATE_VERSION_H__

/**
 * SECTION:shumate-version
 * @short_description: Versioning utility macros
 *
 * Shumate offers a set of macros for checking the version of the library
 * an application was linked to.
 */

/**
 * SHUMATE_MAJOR_VERSION:
 *
 * The major version of libshumate (1, if %SHUMATE_VERSION is 1.2.3)
 */
#define SHUMATE_MAJOR_VERSION   (1)

/**
 * SHUMATE_MINOR_VERSION:
 *
 * The minor version of libshumate (2, if %SHUMATE_VERSION is 1.2.3)
 */
#define SHUMATE_MINOR_VERSION   (5)

/**
 * SHUMATE_MICRO_VERSION:
 *
 * The micro version of libshumate (3, if %SHUMATE_VERSION is 1.2.3)
 */
#define SHUMATE_MICRO_VERSION   (3)

/**
 * SHUMATE_CHECK_VERSION:
 * @major: major version (e.g. 1 for version 1.2.5)
 * @minor: minor version (e.g. 2 for version 1.2.5)
 * @micro: micro version (e.g. 5 for version 1.2.5)
 *
 * Returns %TRUE if the version of the Shumate header files
 * is the same as or newer than the passed-in version.
 *
 * Returns: %TRUE if Shumate headers are new enough
 */
#define SHUMATE_CHECK_VERSION(major,minor,micro)                              \
    (SHUMATE_MAJOR_VERSION > (major) ||                                       \
     (SHUMATE_MAJOR_VERSION == (major) && SHUMATE_MINOR_VERSION > (minor)) || \
     (SHUMATE_MAJOR_VERSION == (major) && SHUMATE_MINOR_VERSION == (minor) && \
      SHUMATE_MICRO_VERSION >= (micro)))

#endif /* __SHUMATE_VERSION_H__ */
