/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.messagelocation;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTableModel;
import org.zaproxy.zap.view.messagelocation.HighlightChangedEvent;
import org.zaproxy.zap.view.messagelocation.HighlightChangedListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationTableEntry;

public class MessageLocationsTableModel<T extends MessageLocationTableEntry>
extends AbstractMultipleOptionsBaseTableModel<T> {
    private static final long serialVersionUID = 4506544561803715504L;
    private static final String[] COLUMNS = new String[]{"", Constant.messages.getString("messagelocations.table.header.location"), Constant.messages.getString("messagelocations.table.header.value")};
    protected static final int BASE_NUMBER_OF_COLUMNS = COLUMNS.length;
    private final List<T> messageLocations;

    public MessageLocationsTableModel() {
        this.messageLocations = new ArrayList<T>();
    }

    public MessageLocationsTableModel(List<T> messageLocations) {
        this.messageLocations = messageLocations;
    }

    @Override
    public int getRowCount() {
        return this.messageLocations.size();
    }

    @Override
    public int getColumnCount() {
        return BASE_NUMBER_OF_COLUMNS;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MessageLocationTableEntry messageLocation = (MessageLocationTableEntry)this.getElement(rowIndex);
        if (columnIndex == 0) {
            return messageLocation.getHighlight();
        }
        if (columnIndex == 1) {
            return messageLocation.getLocationUI();
        }
        return messageLocation.getLocation().getValue();
    }

    public Class<?> getColumnClass(int row, int columnIndex) {
        MessageLocationHighlight highlight;
        if (columnIndex == 0 && this.getRowCount() != 0 && (highlight = ((MessageLocationTableEntry)this.getElement(row)).getHighlight()) != null) {
            return highlight.getClass();
        }
        return this.getColumnClass(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return MessageLocationHighlight.class;
        }
        if (columnIndex == 1) {
            return MessageLocationTableEntry.LocationUI.class;
        }
        return String.class;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0 || !(aValue instanceof MessageLocationHighlight)) {
            return;
        }
        MessageLocationTableEntry messageLocation = (MessageLocationTableEntry)this.getElement(rowIndex);
        messageLocation.setHighlight((MessageLocationHighlight)aValue);
        this.fireHighlightChanged(messageLocation, messageLocation.getHighlightReference());
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public List<T> getElements() {
        return this.messageLocations;
    }

    public int getRow(MessageLocationTableEntry entry) {
        return this.messageLocations.indexOf(entry);
    }

    public void addMessageLocationHighlightChangedListener(HighlightChangedListener<T> listener) {
        this.listenerList.add(HighlightChangedListener.class, listener);
    }

    public void removeMessageLocationHighlightChangedListener(HighlightChangedListener<T> listener) {
        this.listenerList.remove(HighlightChangedListener.class, listener);
    }

    protected void fireHighlightChanged(T entry, MessageLocationHighlight highlightReference) {
        HighlightChangedEvent<T> event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HighlightChangedListener.class) continue;
            if (event == null) {
                event = new HighlightChangedEvent<T>(this, entry, highlightReference);
            }
            HighlightChangedListener listener = (HighlightChangedListener)listeners[i + 1];
            listener.highlightChanged(event);
        }
    }
}

