r"""

Listed below are weights needed to computed the following integral

I_{lm} = \int_{0}^{2pi}\int_{0}^{pi} f(\phi,theta) Y_{lm}(\phi,\theta) sin(phi) d phi d \theta

via

Re[ I_{lm} ] = \sum f(\phi_i,theta_i) * Y_L_M_real(phi_i,\theta_i)

Im[ I_{lm} ] = \sum f(\phi_i,theta_i) * Y_L_M_imag(phi_i,\theta_i)

The coordinates {theta_i,\phi_i} correspond to the fliege_mayer_900 set.

The above coefficients have the weights per node included.




"""
from __future__ import absolute_import, division, print_function
from scitbx.array_family import flex
Y_0_0_real = flex.double( [ 0.00295465916392 , 0.00503647726424 , 0.00405234809142 , 0.00476963069734 , 0.00439797209708 , 0.0044307253938 , 0.00409384951371 , 0.0038690020422 , 0.00483665779468 , 0.0047820882849 , 0.00375116569851 , 0.0038737774551 , 0.00395844814327 , 0.00335154238392 , 0.00409127721387 , 0.00245888069409 , 0.00577452443474 , 0.0071200137636 , 0.00362283914084 , 0.00424234563013 , 0.00455880761884 , 0.00309293137206 , 0.0033273411612 , 0.00422173832463 , 0.0055613997397 , 0.00615929954592 , 0.00374434106886 , 0.00298168575179 , 0.00424862389317 , 0.00411878686659 , 0.00765763470601 , 0.00426815089196 , 0.00472078788826 , 0.00413799781622 , 0.00298347986753 , 0.00401761500428 , 0.00418981859968 , 0.000439249455833 , 0.00613152234782 , 0.00259392503874 , 0.00347575225979 , 0.0040600178545 , 0.00279359950186 , 0.00346705872286 , 0.00310778124634 , 0.00411196531234 , 0.00371041993649 , 0.00400311091506 , 0.00410636163948 , 0.00213957098429 , 0.00267205577992 , 0.00359062938192 , 0.00532582842807 , 0.00470811364357 , 0.00469341051531 , 0.00243758327388 , 0.00307035614079 , 0.00463699320693 , 0.00477223619869 , 0.00457842969032 , 0.00455851125208 , 0.00435861638993 , 0.00395983468546 , 0.0024859004829 , 0.00518741045173 , 0.00273804891724 , 0.00329343229208 , 0.00591328304017 , 0.00143535187593 , 0.00319941943606 , 0.00389424297943 , 0.00299807948838 , 0.00418846628695 , 0.00423667895935 , 0.00356589435957 , 0.00377939229974 , 0.00220022707031 , 0.00527245231109 , -0.000256836877105 , 0.00289526078847 , 0.00442323588983 , 0.00526668795954 , 0.00456468864809 , 0.00342288891206 , 0.00454748152463 , 0.00419932013522 , 0.00500833039171 , 0.0026567990003 , 0.00334967667591 , 0.00383938578681 , 0.00383380649591 , 0.00518881313979 , 0.00532912769696 , 0.00307822441349 , 0.00305451915292 , 0.00323983920699 , 0.00627503587135 , 0.00344290276773 , 0.00263306989165 , 0.00383198970841 , 0.00304249051006 , 0.00286562680586 , 0.00294134019957 , 0.00313811724514 , 0.0036883735892 , 0.0053204148058 , 0.00301490208229 , 0.00368195742804 , 0.00501901869787 , 0.00387569893656 , 0.0043160847391 , 0.00270270842397 , 0.00381203901611 , 0.0071928286372 , 0.00400249213762 , 0.00264574041912 , 0.00416280389886 , 0.00331575508183 , 0.0025655941331 , 0.00391103177711 , 0.00276936030975 , 0.00316634476632 , 0.00651853688986 , 0.00236900419036 , 0.00382279932464 , 0.00394374915808 , 0.00473504445575 , 0.00307685594506 , 0.00464783502337 , 0.00116840225043 , 0.00502240840031 , 0.0048863154203 , 0.00288474732966 , 0.00280942652227 , 0.00370509619184 , 0.00434255993053 , 0.0038227446993 , 0.00342172234857 , 0.00452418104914 , 0.00289066247896 , 0.00514455012817 , 0.00421378610317 , 0.00316715873388 , 0.00446653348927 , 0.00510224851309 , 0.00398552120225 , 0.00334528171056 , 0.00370232789017 , 0.00171093569939 , 0.00318891303966 , 0.00558489682081 , 0.00279413547655 , 0.00513731821948 , 0.00295057995847 , 0.00335372197872 , 0.00272605355088 , 0.00308661874906 , 0.00377009154838 , 0.00413140116052 , 0.0029195042592 , 0.0036451110575 , 0.00395159141225 , 0.00446603890463 , 0.00486017258999 , 0.00379095191991 , 0.00430869078176 , 0.00530692198067 , 0.00403657347656 , 0.00494901862763 , 0.00417434962127 , 0.00382914253329 , -4.29441837527e-05 , 0.00327105116762 , 0.00256318566018 , 0.00312168943012 , 0.00363708300185 , 0.00593494132624 , 0.00439850471216 , 0.00235655542465 , 0.00351820222144 , 0.0028457500216 , 0.00379368385719 , 0.00533727754224 , 0.00427247727538 , 0.00310583818619 , 0.0036843484018 , 0.00412132325049 , 0.00470117107266 , 0.00541848039228 , 0.00547226961339 , 0.00323706327565 , 0.00246255449642 , -0.000880568218001 , 0.00408603674626 , 0.00455410361007 , 0.00355647236264 , 0.000988658795968 , 0.0031673410891 , 0.00332073956577 , 0.00475767809836 , 0.00450740159484 , 0.00400598765492 , 0.00408693936183 , 0.00421101933215 , 0.00454422519511 , 0.00253015562031 , 0.00268539618143 , 0.00308172266751 , 0.00561414498192 , 0.00512953183597 , 0.00380540885288 , 0.00358464779853 , 0.000857145007041 , 0.00376190576084 , 0.00364894234975 , 0.0048521302922 , 0.00377847659951 , 0.00337181436261 , 0.00253731051391 , 0.00506477674023 , 0.00423102869165 , 0.00380072754566 , 0.00555444253608 , 0.0040085792325 , 0.00416626755764 , 0.00300557591758 , 0.00329920351225 , 0.00481569899749 , 0.00519043607914 , 0.002734175906 , 0.00462616237684 , 0.00598253495843 , 0.00460955585153 , 0.00402753430599 , 0.00421489268538 , 0.00428483859189 , 0.00275796231707 , 0.00390942974945 , 0.00105342048618 , 0.00431445119688 , 0.00317213180077 , 0.00373218700745 , 0.005272465391 , 0.00268024422946 , 0.00232895161613 , 0.00370646451367 , 0.00518819608787 , 0.00487745791956 , 0.00480267140434 , 0.00374980687449 , 0.0026878152514 , 0.00193314241384 , 0.00476289530658 , 0.00401033532696 , 0.00275537949822 , 0.00435184476296 , 0.00424872807521 , 0.00289541759103 , 0.00292014384166 , 0.00348506390947 , 0.00324409708189 , 0.00305287727801 , 0.00284397570844 , 0.00421692386591 , 0.0034115479178 , 0.0050968259747 , 0.0052096445827 , 0.00209037775673 , 0.00472820408857 , 0.00485355952275 , 0.00297784473317 , 0.00260551557618 , 0.00293830608585 , 0.00389670831346 , 0.0057370681235 , 0.00265120969997 , 0.00492915836953 , 0.00474567098983 , 0.00403535558652 , 0.00284308819419 , 0.00512126257976 , 0.00441418033928 , 0.00503414325171 , 0.00397766683541 , 0.00449081167441 , 0.00513940689271 , 0.00538474244975 , 0.00299243077846 , 0.00617728118981 , 0.00258028096154 , 0.00368486573155 , 0.00316215446988 , 0.00410415014571 , 0.00502293213933 , 0.00514671263082 , 0.00400372530984 , 0.00563871909282 , 0.00419361378693 , 0.00442045335132 , 0.00293489126314 , 0.00255587148056 , 0.00236631942707 , 0.00267367009926 , 0.00572903274856 , 0.00363548607117 , 0.00477955209047 , 0.0033489593007 , 0.00471657023543 , 0.00419726969754 , 0.004226265372 , 0.00550463965982 , 0.00324462422492 , 0.00431527871648 , 0.00330425862372 , 0.0053835809849 , 0.00326052899129 , 0.00457821353885 , 0.00272063506217 , 0.00348891899845 , 0.00434011005055 , 0.00483836079177 , 0.00442994957961 , 0.00616609615292 , 0.00320086801617 , 0.00436672562087 , 0.00329988841101 , 0.00380560408357 , 0.00196785908603 , 0.00675560802657 , 0.00551158798375 , 0.00430301702564 , 0.00268957349596 , 0.00382881960881 , 0.00420319766983 , 0.00291329433678 , 0.00582173664941 , 0.00386817337382 , 0.00380143514964 , 0.00528650593747 , 0.00416065085852 , 0.00360293907911 , 0.0046655476288 , 0.00434281148622 , 0.00358245166155 , 0.0016705193114 , 0.000306674513654 , 0.00425294007077 , 0.00642452114984 , 0.00530644745856 , 0.00692829974108 , 0.00419613004846 , 0.00469550361173 , 0.00265312309715 , 0.00365703442436 , 0.00469193590064 , 0.00406342475874 , 0.00411256185284 , 0.00495653104656 , 0.00432961777825 , 0.00708992098569 , 0.00566941974355 , 0.00796185273574 , 0.00236873906214 , 0.00332871284247 , 0.0036109041705 , 0.00511367514095 , 0.00340678618048 , 0.000513202646092 , 0.00320094213545 , 0.00512843613765 , 0.00247060394058 , 0.00520305830995 , 0.00291581696384 , 0.00472666504365 , 0.00358371800569 , 0.00512371267388 , 0.00297186843212 , 0.0050839327038 , 0.00304435646451 , 0.00433639893593 , 0.00258735214443 , 0.00382688979329 , 0.00330096252253 , 0.00467237722997 , 0.00552255359845 , 0.00328689504383 , 0.00486902205174 , 0.00450165940988 , 0.0037935626761 , 0.00518821067496 , 0.00388520211002 , 0.00451983796507 , 0.00462841667974 , 0.00494732400238 , 0.00683002322284 , 0.00475132051085 , 0.00560873441414 , 0.0043268428137 , 0.0029097122568 , 0.00413758951702 , 0.00183083938548 , 0.00510915034994 , 0.00337378998065 , 0.00404931795084 , 0.00490621452996 , 0.00429625166597 , 0.00327500948986 , 0.00304736141138 , 0.00259269641959 , 0.00306811309861 , 0.00328138756368 , 0.0041816687324 , 0.00418677094784 , 0.00539374464174 , 0.0047328480488 , 0.00468132794874 , 0.00437567365818 , 0.00448067928846 , 0.00319688521022 , 0.00338608622018 , 0.00431610124585 , 0.00562164325771 , 0.00483361322743 , 0.00335718265695 , 0.00585523903691 , 0.00369814654771 , 0.00498935171524 , 0.00326700116115 , 0.00486407754202 , 0.00476480798173 , 0.00283045259522 , 0.00314139144977 , 0.00379772002307 , 0.00440688902947 , 0.00484199994627 , 0.00419929365154 , 0.00395198452015 , 0.00352350927846 , 0.00478091959414 , 0.00370325103091 , 0.00484804494312 , 0.003733124407 , 0.00280678410555 , 0.00444763534798 , 0.00515586457068 , 0.00339056808474 , 0.0025225146878 , 0.0030126402511 , 0.00409238832424 , 0.00348160973618 , 0.002700823859 , 0.00449401721993 , 0.00433082843609 , 0.00564754552757 , 0.00268235725699 , 0.00404338139816 , 0.00578953378942 , 0.00440647074896 , 0.00303436473029 , 0.00422826222199 , 0.00389290134952 , 0.00338015102652 , 0.00519443637274 , 0.00461276506524 , 0.00333638113457 , 0.00418634591671 , 0.00447085788064 , 0.0042248375509 , 0.00415307610466 , 0.00571365923941 , 0.00526704377092 , 0.00399202291802 , 0.00458126142545 , 0.00472155542635 , 0.00473369472001 , 0.00419534292749 , 0.00328727238386 , 0.00503959351889 , 0.00516139832068 , 0.00352523067143 , 0.00396427684022 , 0.003677083089 , 0.00338568913503 , 0.00402808391601 , 0.00111288303022 , 0.00337991998871 , 0.00492996155064 , 0.0042363592255 , 0.00378084185483 , 0.0047328585853 , 0.00464672148603 , 0.00441044323363 , 0.00472149972507 , 0.00486446655054 , 0.00236163638047 , 0.00541707640924 , 0.0026942326182 , 0.00328311395099 , 0.00247598723959 , 0.00342576355582 , 0.00407624405163 , 0.00373319760733 , 0.00365689564441 , 0.00418492330114 , 0.00300012003369 , 0.003200446097 , 0.00346122395128 , 0.00250101524289 , 0.00322425409055 , 0.0039292134974 , 0.00476358206643 , 0.0049124578733 , 0.00479900861301 , 0.00389769122633 , 0.00386749182826 , 0.00520623590577 , 0.00394307653594 , 0.00334807670587 , 0.00468770860618 , 0.00510144029439 , 0.00409305022748 , 0.00579032119085 , 0.00362470778462 , 0.00328245121143 , 0.00336694783303 , 0.00148804046362 , 0.00436551587126 , 0.00322662693312 , 0.00492346856816 , 0.00259017370586 , 0.00141721300935 , 0.00181200350862 , 0.00340218590443 , 0.00300022026959 , 0.00328566917507 , 0.0039591851237 , 0.00195396140875 , 0.00352142554646 , 0.00312950855246 , 0.00380086050292 , 0.00342736464797 , 0.00233506613042 , 0.00407775957803 , 0.00429216309596 , 0.00226849193554 , 0.0039000659296 , 0.00370609631046 , 0.00414439545058 , 0.00406249789842 , 0.00488736914415 , 0.00406458054184 , 0.00423282346351 , 0.00211151930256 , 0.00393857844253 , 0.00400569116726 , 0.00459716898919 , 0.00125361264357 , 0.00435929575165 , 0.00287411073419 , 0.00430610163145 , 0.000969811926179 , 0.00464896897964 , 0.00310683763419 , 0.00574316169101 , 0.0047099272502 , 0.00430901589844 , 0.00436385946122 , 0.003244682603 , 0.003841860263 , 0.00309394516308 , 0.0046177474575 , 0.00386717921355 , 0.00342662552413 , 0.00347610164897 , 0.00463317548392 , 0.00373075786928 , 0.00474667435065 , 0.00231230697496 , 0.00275535369028 , 0.0046751160186 , 0.0039131244587 , 0.00592149623136 , 0.0051284775583 , 0.00494225919345 , 0.00316931358694 , 0.00482131248153 , 0.00594323940946 , 0.0025080315617 , 0.00371544657083 , 0.00290849363817 , 0.00337713388176 , 0.00496236674408 , 0.003433072277 , 0.00364341322309 , 0.0046086688367 , 0.00450939557872 , 0.00483539358769 , 0.00258501373978 , 0.00327666235326 , 0.00388534324721 , 0.00446475339432 , 0.0058369424971 , 0.00434369664331 , 0.00368297656893 , 0.00434738805618 , 0.00516986385635 , 0.00544918544613 , 0.00307337328527 , 0.00307179146699 , 0.00452440061142 , 0.00484954021774 , 0.00339196483473 , 0.00457411698618 , 0.00398533021088 , 0.0028258518837 , 0.00408934166303 , 0.00295773082415 , 0.00310909196752 , 0.0043760760919 , 0.00528133859994 , 0.0050262518784 , 0.00287538438659 , 0.00635727894196 , 0.00516986742982 , 0.00293213097334 , 0.00448498037192 , 0.00286922002937 , 0.00182497079136 , 0.00422640532507 , 0.00321620098201 , 0.00236274539565 , 0.00397272358852 , 0.00401848571781 , 0.0016937159907 , 0.00492372411326 , 0.00377214086792 , 0.00406575318199 , 0.00572106014028 , 0.00441065926019 , 0.00467629584105 , 0.00602440838555 , 0.00414465892576 , 0.0030831625068 , 0.0041545754521 , 0.00416298924292 , 0.00388305769757 , 0.00364460134361 , 0.00559128921497 , 0.00353991758197 , 0.00457667386579 , 0.00395865132904 , 0.00359494000941 , 0.0050605734458 , 0.0033824819858 , 0.00381873859042 , 0.00509540852135 , 0.00333902548192 , 0.00277714138455 , 0.00324411685648 , 0.00520084264224 , 0.00372545580159 , 0.00101995187252 , 0.00254386261207 , 0.00422629118105 , 0.00211141142784 , 0.00118945299248 , 0.00454309893346 , 0.00364341533141 , 0.00457463854219 , 0.0033358428843 , 0.00330154723138 , 0.00457106862224 , 0.00211753035307 , 0.00358377823993 , 0.00474969182653 , 0.00393924111634 , 0.00441337541353 , 0.0060163355073 , 0.00347497542723 , 0.00375117992156 , 0.00439047868647 , 0.00491243513914 , 0.0026258116751 , 0.00249637181329 , 0.0048511249726 , 0.00397450848368 , 0.00246785033139 , 0.00509284361477 , 0.00414198790045 , 0.00292544218548 , 0.00441658555028 , 0.00276041932172 , 0.00100385596857 , 0.00664610177325 , 0.00309575887595 , 0.00341993712877 , 0.00418629947155 , 0.00560323757833 , 0.00398239183463 , 0.00378817102934 , 0.00347829209928 , 0.00441472370598 , 0.00400765286364 , 0.00374095103851 , 0.00414414562994 , 0.0029224260043 , 0.00143711514571 , 0.0068399097943 , 0.0036867125396 , 0.0055957655876 , 0.00315876125702 , 0.00359499517022 , 0.00493264970605 , 0.00331292076152 , 0.00425301162634 , 0.00492699459331 , 0.00475384843687 , 0.00552155979192 , 0.00445825670181 , 0.00438315819886 , 0.00360551760453 , 0.00350075970764 , 0.00374295464949 , 0.00284223350468 , 0.00261800652851 , 0.00433804239234 , 0.00413590105737 , 0.00394662926057 , 0.00300914564626 , 0.00397304402834 , 0.00435752637134 , 0.00373184980465 , 0.00268333812708 , 0.00322867198769 , 0.00403002044716 , 0.00329067334177 , 0.00451551503048 , 0.00394952912448 , 0.0068766935671 , 0.00626151936031 , 0.00467962023009 , 0.00284869811091 , 0.00368613956635 , 0.00306010293959 , 0.0051160027699 , 0.00275134407098 , 0.000998916262043 , 0.00729228774346 , 0.00259213642628 , 0.00220394464341 , 0.00290780574906 , 0.00314999855342 , 0.00342823945038 , 0.00461194779973 , 0.00294647032056 , 0.00341163931005 , 0.00630327922555 , 0.00340765097225 , 0.00302746400337 , 0.00276668404562 , 0.00806511571325 , 0.00505005271882 , 0.00419626671913 , 0.00314261372357 , 0.00347921769802 , 0.00550163874965 , 0.00251806802431 , 0.00521676388995 , 0.0056654091857 , 0.00187112545012 , 0.00534899325139 , 0.00482758593084 , 0.00187158061862 , 0.00591036420356 , 0.00389601996995 , 0.00387817795456 , 0.00376413630422 , 0.00538689840005 , 0.00353188669149 , 0.00446719739595 , 0.00359594508395 , 0.00452033342617 , 0.00477536750408 , 0.00413499155045 , 0.00187573887988 , 0.00519274493065 , 0.00415026723257 , 0.00452406138939 , 0.00488723865091 , 0.00408212746899 , 0.00272132682025 , 0.00431075006339 , 0.00434875763054 , 0.00360131621892 , 0.00377304503157 , 0.00218868694521 , 0.0032651266198 , 0.00355643275309 , 0.00334931324726 , 0.00526677451829 , 0.00294542344523 , 0.00311452530785 , 0.00538720100367 , 0.00294837585468 , 0.00304633824403 , 0.00405310014186 , 0.00226434915835 , 0.00425469399863 , 0.00149441495066 , 0.00333553866535 , 0.00416007356899 , 0.00472501533858 , 0.00610151341383 , 0.00504566225091 , 0.00444397567334 , 0.00329747946256 , 0.00369798180771 , 0.00339724869484 , 0.00329307622118 , 0.00421371346353 , 0.00311731653632 , 0.00523935743591 , 0.0023822202691 , 0.0050711372121 , 0.00139511675292 , 0.0038566548792 , 0.00521984584274 , 0.00499780732583 , 0.00490960924046 , 0.00232534738799 , 0.00590006721885 , 0.00207402115733 , 0.00477370465594 , 0.00583476081629 , 0.00283796666349 , 0.00448213637912 , 0.00402100181579 , 0.0041981094051 , 0.0052862655935 , 0.00333928997589 , 0.0040640193386 , 0.00353164608323 , 0.00287714191427 , 0.00518505712671 , 0.0030208705915 , 0.00304588622959 , 0.00387596680649 , 0.00489951317024 , 0.00557057202327 , 0.00432174962383 , 0.00442641378298 , 0.00284406612591 , 0.00316744055516 , 0.000539094356215 , 0.00469204228068 , 0.00427175869015 , 0.00403896548426 , 0.00349395215968 , 0.00451186180871 , 0.00555925373276 , 0.00367627716303 , 0.0072941562892 , 0.00189306394879 , 0.00423503062535 , 0.00457490220677 , 0.00400252080788 , 0.00445697071738 , 0.00230140656678 , 0.00273144287931 , 0.00506876634526 , 0.00580947092949 , 0.00371913354124 , 0.00516168545637 , 0.00469782591366 , 0.00397198005144 , 0.0047660696848 , 0.00365220790792 , 0.0045590747179 , 0.00417047007053 , 0.00267329199583 , 0.00312478888752 , 0.00504988968518 , 0.00501437994451 , 0.00374206854382 , 0.00241403827113 , 0.00383676283801 , 0.00400463634868 , 0.00185468949536 , 0.00508403873232 , 0.00389851007817 , 0.00354086287327 , 0.00302706546893 , 0.00264243899471 , 0.00434750302574 , 0.00453924704112 , 0.00401936647321 , 0.00464891839051 , 0.0035821100739 , 0.00393626111768 , 0.0048046715796 , ])
Y_0_0_imag = flex.double( [ 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , ])
Y_1_m1_real = flex.double( [ 0.0 , 0.00614972728298 , -0.00487664073352 , 0.00457435690992 , 0.00266823117392 , -0.00145737937967 , -0.00260121142056 , -0.00454908133328 , -0.0040056302631 , -0.00131529336318 , -0.00390963346538 , -0.00055525625271 , -0.00117727378407 , 0.000485125452809 , 0.0019435225972 , 0.0022955559448 , -0.00145306478006 , -0.0034958506944 , -0.000717173533451 , -0.00153957438514 , -0.00549112561124 , 0.00355808770621 , 0.00166519176547 , -0.00437656549507 , 0.00628225521513 , -0.00424564678204 , 0.00315860880305 , -0.000253333682055 , -0.000346222746097 , 0.000861922238275 , -0.00160436288564 , 0.000409029370958 , -0.000216223225472 , 0.0036598196829 , -0.00124663709501 , 0.00449555061857 , 0.00503697360153 , -9.44483965829e-05 , 0.000270023606735 , 0.00283767090901 , -0.00363590395777 , -0.00449220101214 , 0.00257554506425 , 0.00350810327844 , -0.0034536508985 , 0.00422365373356 , -0.00404075758934 , -0.00467988489609 , -0.00408591924204 , -0.00161069440172 , 1.00451707031e-05 , -0.00347389981319 , -0.00340311351746 , 0.000519599291505 , 0.00314972838438 , -2.51452820603e-05 , -0.00136357606146 , -0.00403025720822 , -0.00332841876444 , 0.00259805424041 , 0.00551629203689 , -0.00487135174172 , 0.00136663248981 , 0.0012628480703 , -0.00251610565114 , 0.00252551914353 , -0.00344604144368 , 0.00508646172819 , -0.000579067329372 , 0.00362687729434 , 0.00411063382522 , -0.002731448238 , -0.00505808796286 , 0.00178196735565 , -0.000148880841533 , 0.00306475444693 , -0.00166302649322 , -0.00566519547692 , 4.3319203773e-05 , -0.00147549898342 , 0.0020236749848 , -0.00523559036974 , 0.00326442413692 , -0.00381719535055 , -0.00446147524378 , -0.00424589485875 , -0.000269450177183 , 0.00194737457855 , 0.00190030998916 , -0.00304266087264 , -0.00337109978859 , -0.00130342328094 , -0.00120040371429 , -0.000189432934745 , -0.00154260604812 , 0.00111635144598 , -0.000832809559944 , 0.00214552227695 , 0.00109455986432 , 0.00285823513721 , 0.00305058788487 , -0.00221695517973 , 0.000845799967908 , -0.00383292074925 , -0.0037491389622 , -0.00427628055463 , -0.000701049912145 , 0.000693090267646 , 0.00218062746155 , -0.000646510452231 , 0.00157791007322 , 0.0016370441126 , -0.0027788487844 , 0.000509361930798 , 0.00140131276331 , -0.00158250378868 , -0.00461101672484 , -0.00342254087634 , 0.00105758573051 , 0.00312392528105 , -0.00262398301506 , 0.000107328585878 , -0.0010522884843 , -0.00192333357955 , -0.00298535362461 , -0.00407023689871 , 0.00534867208396 , 0.000779585402542 , -0.00308779832179 , -0.000922554731467 , -0.00422214130948 , -0.00549430713648 , -0.00012679322357 , 0.00129237162592 , 5.5380761857e-05 , 0.00462793852501 , 0.00261054305799 , -0.00346710551469 , 0.00487610015085 , 0.000846251440639 , -0.00114909548942 , 0.00131510841595 , -0.00283976580834 , -0.00223843515015 , 0.00608547625543 , 0.00416174647446 , -0.00354573181646 , -0.00385941824889 , -0.000912042417016 , -0.00336858587033 , 0.000470964781793 , -0.00108173700271 , 0.000454892279721 , -0.000439800487447 , -0.00338559603487 , -0.00149856323382 , 0.00363073595983 , -0.00219370164579 , -0.00314624729238 , 0.000558213679537 , -0.000965331340717 , 0.00042411520626 , 0.00167620471032 , -0.00240491177785 , 0.00158649481617 , 0.0017447644334 , 0.0032085525773 , 0.00339652321729 , 0.00276029341062 , 0.00228179602125 , -0.00371976562188 , 2.62722627606e-05 , -0.00165480400482 , 0.00207268123603 , 0.000754484919587 , -0.00235900746706 , -0.00163390185161 , -0.00396285368512 , -0.00212246084284 , -0.00024514109273 , -0.00255518471353 , -0.0029430579465 , -0.00262258822555 , 0.00325031160077 , 0.00378374205145 , 0.00169782622346 , 0.00295583871447 , -0.00279370346224 , -0.00265709375809 , 0.000642191679826 , -0.00116553546012 , 0.00193585293919 , 0.000356617534033 , -0.00474318834127 , 0.00338171144081 , -0.0013132024158 , -0.000333069034647 , 0.00142954594678 , -0.000709092271711 , 0.00562286071796 , -0.000574541301669 , 0.00238224521876 , -0.0038370543331 , -0.00115327631859 , -0.00250530229145 , 0.000527031202865 , -0.000260211540519 , -0.00222518574568 , -0.00475849821303 , -0.00458033507147 , -0.00283080441619 , 0.00021341962301 , -0.00037748190552 , -0.00403763475047 , 0.0034315151942 , 0.00296922961045 , -0.00409933716426 , 0.00047610993102 , 0.000498009999378 , 0.00410003457142 , 0.00481231854612 , -0.00254952024436 , 0.00392804585376 , 0.00407661274345 , 0.00202111685957 , 0.000158232907121 , 0.00372300562231 , 0.00263283799278 , 0.000547858394561 , 0.00175148548391 , 0.00511660744783 , 0.00114740388159 , -0.00406141183995 , -0.00368221766497 , -0.00512909655217 , -0.000530440155466 , -0.000299526938109 , 0.00208777702586 , -0.000488826095426 , -0.00331048268604 , 0.00157805431503 , -0.00314695262924 , 0.00181212827132 , 0.000504660643389 , 0.00056866580439 , -8.26407712635e-05 , -0.00433071841648 , -0.00321135697298 , 0.000535206474087 , 0.00174512390206 , 0.00186517440838 , 4.36619970959e-05 , 0.0020172525479 , 0.00429416311653 , 0.00134918803248 , 0.00513386943211 , -0.0051770554539 , -0.000555734534971 , -0.00331559874 , -0.00101971474101 , -0.000945356561546 , -0.0018202523395 , 0.000441426252559 , 0.00196717990939 , -0.0035674754943 , 0.00441643939938 , 0.00378750533782 , -0.000539689485707 , -0.00208460940868 , 0.00416969834658 , -0.00338766663096 , 0.00248051238692 , 0.000306065748116 , 0.00451034475711 , 0.00316344705663 , -0.00248263558495 , -0.00377787248251 , 0.00481523336322 , 0.00360549931521 , -0.00165853560504 , -0.00214916483495 , 0.00173264285395 , 0.00592199082796 , 0.00188142786147 , 0.0015120614665 , 0.00284749462098 , 0.00413088071915 , -0.00183586202842 , -0.00158416550848 , -0.00273691148438 , -0.00341727101533 , 0.00183775485903 , -0.00395686750344 , 0.00173851116527 , 0.000341523352641 , -0.0047011212982 , -0.00271165703908 , -0.00288531922554 , 0.00445666592257 , 0.00353570780468 , 6.00292443681e-05 , 6.87470013169e-05 , -0.00235378083777 , -0.00215252886695 , -0.00195795552757 , 0.00396998658851 , 0.00228201257671 , 0.0027166246385 , -0.00444918990779 , -0.00051494377987 , -0.00101452708263 , -0.0016660050424 , -0.00484965311777 , -0.00115902366019 , -0.00147017421803 , -0.000129467099292 , -0.000474069342195 , 0.000875428616099 , 0.00122286350815 , 0.00383519372279 , 0.000571683372061 , -0.000302698799473 , -0.00281942539235 , -0.000781759567867 , -0.00251192725072 , 0.00295022755477 , 0.00417105092617 , -0.00039605503506 , -0.00461067935685 , -0.0044845873589 , -0.000291559148961 , 0.00159134875899 , 0.00118016386495 , -0.00159102759961 , 0.000732777256278 , -0.00055915649482 , -0.00193161405548 , 5.5815391057e-05 , 0.00492800612198 , -0.00303144022751 , 0.000198017303931 , 0.00100401389039 , 0.00140716302579 , 0.00362987903156 , -0.00116200365034 , -0.000109875181067 , -0.00168646742853 , -0.000507987870845 , -0.00222646654853 , -0.00375618045374 , 0.00490481325873 , -0.00161534326667 , -0.00166171500478 , -0.00296236668096 , -0.00326671339744 , -0.00468445037887 , -0.0022492201952 , 0.0016875402156 , 0.00299448917409 , -0.00148736782145 , 0.00375099869564 , -0.00247183617875 , 0.000122283804161 , -0.00389456371076 , -0.00408106150086 , 0.00409588955766 , -0.00189579150058 , -3.50996332054e-05 , -0.00166138026305 , -0.00107247980342 , -0.0016300865354 , -0.00296175584773 , 0.0033013952448 , 0.00272502509023 , -0.00388960535874 , 0.0023782446048 , -0.000978689784818 , -0.00225051074909 , -0.000179327577126 , 0.00407354186334 , 0.00305118642151 , -0.000163231622555 , -0.00292096540986 , -0.00466816099176 , -0.00426066044076 , -0.000688638007815 , -0.00106054628419 , 0.000831436322876 , 0.000164863838927 , 0.00383245407184 , 0.000140429510393 , 0.000851713793798 , -0.00320966440013 , -0.0058334939174 , -0.00241887670234 , -0.00472056812091 , 0.000286616049317 , -0.0015760760559 , -0.00166978370104 , 0.00214870932502 , -0.00065712937843 , 0.00517111841491 , 0.00170405949076 , -0.0035074426179 , 0.000277511573099 , -0.00274345590521 , 0.000953095337196 , 0.00153137981547 , 0.00207129948006 , -0.00352475471704 , 0.00290864268395 , 0.00155923659731 , 0.00112841214092 , -0.000276170756321 , 0.00163089216417 , -0.0041145884388 , -0.00318232638168 , 0.00517402261541 , -0.00297818595386 , 0.00409128952752 , 0.00372690205976 , -0.00444247722209 , 0.00400744130546 , -0.00117280590793 , -0.000300233933976 , -0.0040377836407 , 0.00304163951679 , -0.00294842486457 , -0.00211019762655 , 0.000799690414374 , -0.00231253757735 , 0.0036440648229 , -0.00361530793015 , 0.00185662708922 , 0.00337679981542 , -0.000257574956525 , -0.00446399319137 , -0.00076522040673 , 0.00533792728053 , -0.00162591690606 , 0.0046752644037 , 0.00340213483196 , 0.00232349187201 , 0.00372066141175 , -0.000916917913792 , -0.000328137323589 , 0.000235860782108 , 0.00187173209645 , 0.00430336197296 , 0.00224288796286 , 0.00164781111889 , 0.00505252132971 , -0.00450966643289 , 0.00241073210704 , 0.00193346852713 , -0.000564330068935 , -0.00411617536234 , 0.00233956889609 , 0.00124995734802 , 0.00340913557477 , 0.0032657092526 , -0.00233924429119 , 0.003210939146 , 0.00272189441131 , 4.93995504363e-05 , 0.00390333697792 , -0.00467110618588 , -0.00506221464363 , -0.00190854553978 , 0.00121817800418 , 0.00313170970426 , 0.00327684279296 , -0.00463966239102 , 0.00238578021913 , -0.00544355343343 , 0.00274070384834 , 0.00162031866521 , 0.00455570499219 , 0.00616623026697 , 0.00230741243576 , 0.0030026557312 , -0.00369439835977 , -0.00192315193726 , -0.00326711742658 , -0.000217899376371 , -0.00328075369556 , -0.00385936172949 , 0.00454287235272 , 0.00264323912958 , -0.00442829196854 , 0.00489970243983 , 0.00111787446567 , 0.0037850548289 , -0.00409853443834 , 0.00130957147142 , -0.00334283358875 , 0.00169566528606 , 0.00156000981434 , 0.000649161322078 , 0.00132939772465 , 0.0022386204742 , -0.00115531958978 , -0.00206644517897 , 0.000930540473192 , 0.000333174802351 , 0.00361664264914 , 0.000438757844101 , 0.000661261847556 , -0.000453835987616 , 0.000350260708015 , -0.00324676850885 , 0.00542537690859 , 0.00470200474964 , 0.00412217786868 , 0.000713350459215 , -0.00343963887946 , -0.00184331031163 , -0.00215848314319 , -0.0037856569701 , -0.00268569022862 , -0.00126715669152 , -0.00194892954843 , -0.00250185023409 , 0.00270072030762 , 0.00105945258381 , -0.000323684933595 , -0.00311807231592 , -0.00305137452523 , -0.00534041647735 , 0.000768338871865 , 5.829592905e-05 , 0.00129017024438 , 0.000365617427237 , -0.00362434075108 , -0.00154488046689 , -0.00232531718067 , 0.0018758311752 , -0.00126449212383 , -0.00196584154687 , 0.00454152477643 , -0.00110976238772 , -0.00135428258388 , -0.00228507003194 , 0.0014778900748 , 0.000115718893981 , -0.00442004221372 , 0.000658357537144 , 0.00012221540998 , -0.00471593242139 , 0.00167275029471 , 0.00399624343067 , -0.00331694377088 , 0.000141229132924 , -0.000485077383275 , -0.00367572263405 , 5.69163203027e-05 , -0.000702550043148 , 0.00134000570153 , 0.00160280950339 , -0.00365350530873 , -0.000584407821 , -0.00554818334685 , -0.00375595178624 , -0.001517394476 , 0.00259792932229 , -0.00417093008528 , 0.00303271986195 , 0.00128004805312 , -0.000576647744135 , -0.00331003764678 , -0.00326364054608 , -0.00368202903961 , -0.00163267071653 , -0.0037813999646 , -0.00446230041837 , 0.00433588496117 , -0.0031650190622 , 0.00142389398519 , 0.00270100969052 , 0.00156782296187 , -0.000214897810616 , 0.00120531218275 , -0.00434723975418 , 0.00535150058408 , -0.000896806264508 , -0.00300915897825 , -0.0020901130941 , -0.002512371648 , -0.00127654055435 , -0.000357236257836 , -0.00403609338577 , 0.001613528282 , -0.00395579914223 , -0.00127188746687 , 0.000857188536291 , -0.00225963846964 , -0.00534271633687 , 0.000534160408455 , 0.00392770437894 , 0.00128713627476 , 0.00340801833634 , -0.000795464887974 , 0.003025683604 , -0.00290553313593 , 0.00475907327718 , 0.00489061066865 , 0.0041499847263 , 0.00146918384596 , 0.00251790558433 , -0.00128757950336 , 0.00447324368695 , 0.0021438071449 , -0.00389153782083 , -0.00367720336586 , 0.00179129336755 , 0.00197853315898 , 0.000943608813629 , 0.000194891709289 , 0.0043631235546 , -0.00514155589667 , 0.00261374463754 , -0.00334924807716 , -0.00237043765788 , 0.00401980368886 , 0.000783808661195 , -0.00338696188582 , -0.00226327402596 , -0.000540127201277 , -0.00049900937884 , -3.73261379867e-05 , -0.000823671764588 , 0.00394550342373 , 0.00299646562712 , -0.00131721399409 , 0.00201365800719 , -0.00160702960803 , 0.00377321185576 , 0.00369534264583 , 0.000450591256971 , -0.00383049281415 , 0.00493320514792 , 0.0035501869881 , -0.00248949878841 , -0.00112866736173 , 0.00120073799251 , 0.0018596325034 , 0.00376591253338 , 0.00137767024437 , 0.00348494055139 , 0.00187819680202 , 0.00105950506434 , -0.0035199711919 , -0.00326583398777 , 0.0036532824298 , -0.00348688216185 , 0.000892240981898 , 0.00311446583262 , 0.00131761673913 , -0.000449300242082 , -0.000456458046655 , -0.000548921950067 , -0.000163502980758 , 0.00173265731063 , 0.0032953283496 , 0.000939487244496 , -0.000103561693001 , 0.00475092751498 , -0.000821510362281 , 0.0015473345206 , -0.00182426787206 , 0.00197420439483 , -0.00558896375925 , -9.52640924227e-05 , -0.000233433504678 , 0.00466544404121 , -0.00137090336087 , -0.00287428476938 , 6.6995903318e-05 , -0.0033160787947 , 0.00418687195219 , -0.00489327233954 , 0.00322561092715 , 0.00202748982388 , 0.00270312276916 , -0.00475167287308 , 0.000937534469263 , 0.00239065248525 , 0.00132745578947 , -0.00244618843291 , 0.00165745668238 , 0.00280922450076 , -0.000549279932995 , -0.000198959880745 , -6.68288645044e-05 , 0.00266811784488 , 0.00394726931404 , 0.000184032553363 , 0.000887407586309 , 0.00158289202678 , 0.00100290322274 , 0.00409619354509 , -0.00188183716942 , 0.0045712395401 , 0.00412723898839 , 0.00378319119914 , 0.00293015187461 , -0.00102272104251 , -0.00277100382149 , 0.0018083742621 , 0.00259775514648 , 0.00221645408758 , -0.00349598132691 , -0.0055261346523 , -0.000660121059665 , -0.00499996531574 , -0.0058122487467 , -0.00480683912857 , -0.00269039685481 , -0.00401600292746 , 0.00321639652382 , -0.00211543489205 , -0.00095693247775 , -0.00013789178815 , 0.000368081351229 , 0.00179716989192 , -0.000864996958476 , 0.00422304034574 , -0.00173666257605 , 0.000267129765486 , 0.00360908544843 , -0.00129812181391 , -0.00273688077902 , -0.00241219613325 , -0.00224169450116 , 0.00310478915475 , 0.00223032215832 , -0.0024041866542 , -0.00390467910636 , -0.000694391655 , -0.00377947284786 , 0.00213428068894 , -0.00120978263876 , 0.00268548986391 , 0.000807139107781 , 9.56367972163e-05 , 0.00120810045269 , -0.000453838486869 , -0.00336564590286 , 0.000984724023781 , 0.00111671056668 , 0.00299727897997 , 0.00222897743742 , -0.0029147265597 , 0.000684766154441 , 0.00316770312498 , 0.00087774341429 , -0.00456952679577 , -0.00190965883046 , -0.00102459685948 , -8.93579320295e-05 , -0.000554470493385 , -0.00305750076286 , 0.000701923321584 , 0.000623640229532 , 0.00123031232583 , 0.0050530128618 , 0.000849936746376 , 0.000626822568707 , -0.00167615416361 , 0.00152794614814 , 0.0017729856414 , 0.00276169339412 , 0.00202298959071 , -0.000294051937893 , -0.000838593578029 , 0.0037955209632 , -0.00288184245365 , -0.00302044686923 , 0.000733577126636 , -0.0053387630736 , 0.000912949219876 , 0.000914650081919 , 0.00193647724469 , 0.000915506002345 , -0.000787570358993 , 0.0043247416489 , 0.00312690517817 , 0.00418560095555 , 0.00243115332325 , 0.00433794746271 , -0.00171781014691 , 0.00375555356083 , 0.0028705830987 , -0.00161409086329 , 0.00236401061023 , -0.00179134586397 , 0.00254975401373 , -0.00417374191016 , 0.00182164998 , -0.00186604692465 , 0.000704199786142 , -0.00129128999116 , 0.00551000971454 , 0.00246496113276 , -0.00264028974807 , -0.000294677886366 , 0.00228574358742 , 0.00405759715182 , -0.00033250330416 , -0.00297462060622 , -0.00429198908226 , -0.00160178349525 , 0.00670901617939 , 0.00151312631527 , -0.00140606771602 , 0.00249965169573 , -0.00397364644378 , 0.00353098938061 , -0.000955214226546 , -0.00450747207082 , 0.00358709762747 , -0.0033536136637 , 0.00157166434012 , 0.00202287608297 , -0.000931744139791 , 0.00340264473945 , 0.000918846100251 , 0.00138936532778 , 0.00293371048561 , 0.00113335392199 , 0.00582559068762 , 0.00183029420355 , 0.00517272423523 , -0.0011094506563 , 0.00239124833332 , -0.00475516147087 , 0.00196048201871 , 0.00489031590647 , 0.00538312812945 , 0.000314921393366 , -0.000784703047011 , 0.00365901032333 , 0.000559332121006 , 0.00314199486993 , 0.000517464076129 , -0.00363203446466 , 3.96605170726e-05 , 0.000151385144778 , -0.00508975890167 , 0.00296380520067 , -0.00301180945706 , -0.000588229958076 , -0.00223437619293 , -0.000257464826077 , -0.00409540434732 , 0.00485408651503 , 0.00494036695338 , -0.00139465641393 , 0.00183475646553 , -0.00493595849114 , 0.00332402460573 , -0.00387039304175 , 0.000134167929257 , 0.00306536365232 , -0.000536294011947 , 0.00383735359342 , 0.00323014965299 , -0.00179698345646 , 0.00332118376677 , -0.00561440219014 , -0.00252368096771 , -0.00169183555506 , 0.000724457365693 , 0.00428900852198 , -0.0045747965202 , -0.00471094107487 , -0.00262594758463 , -0.00343537311228 , 0.00156590107178 , 0.00235776724383 , 0.00226950197738 , 0.00284803173991 , 0.000864781317683 , -0.00420448657823 , 0.00204228952511 , 0.003449213695 , 0.00310801895224 , 0.00197809047465 , -0.00301074541113 , -0.00340765126901 , 0.00342716347497 , -0.00214469866035 , -0.00212948329729 , 0.00154540595741 , -0.00228574071761 , 0.00477226860835 , -0.000502582622491 , 0.000336826909346 , 0.000672497337004 , 0.00580994009035 , ])
Y_1_m1_imag = flex.double( [ -0.0 , -0.0 , 0.000884564522452 , -0.00363308584867 , -0.00433398055058 , 0.00398442987606 , -0.00428635447108 , 0.000515774811416 , 0.00227825215456 , -0.00567455309773 , 0.000588315670384 , 0.00181529214046 , 0.00180252408612 , -0.00220234640427 , 0.000893394719706 , 0.00183042969677 , 0.00626722908574 , -0.00113082233474 , -0.00427360219726 , 0.000235706308755 , -0.00058755398208 , -0.00128812081955 , 0.00371435986776 , -0.000385751342159 , -0.00239547155966 , 0.00139114353179 , 0.000151999771847 , 0.00350037968214 , 0.00383073062791 , -0.000651170218941 , 0.0025118537058 , -0.00470781480752 , -0.00577771556415 , 0.00263117527347 , -0.00340719099128 , -0.00086847243902 , -0.000501606661772 , 0.000207150945046 , -0.00466135087142 , 0.00120089964061 , -0.00221355888301 , -0.00105129397692 , 0.00104287494105 , 0.000376576371338 , 0.000174489764966 , -0.00193177958667 , -0.000370770746874 , -0.000696195565079 , 0.00223186337395 , -0.00119683952213 , 0.0032299337826 , 0.000204028689843 , -0.00497832076112 , -0.00574277718067 , -0.00421411474521 , -0.00156868193179 , 0.000578302735908 , -0.00390928460982 , 0.000737652808204 , -0.00496816079058 , -0.000702480815075 , -0.00218286429147 , 0.00116940462007 , 0.00222302511952 , 0.00298022161882 , 0.00220488817248 , 0.00161141969751 , 0.00476470204248 , -0.00136602512132 , 0.000997275452131 , 0.00082571717705 , -0.00238798423178 , -0.000810762451891 , -0.0023670963106 , -0.00094522688891 , -0.0018158512341 , 0.00189831426912 , 0.0021808268237 , -4.34472771083e-06 , 0.00154507081986 , -0.00184845239003 , 0.00161571195831 , 0.00399387312259 , -0.000732825186984 , -0.00329597901769 , -0.002173077391 , -0.0015739704385 , 0.00245824986778 , -0.000113346625462 , -0.00194472298808 , -0.00147472208694 , -0.00244766900319 , 0.00389819986139 , -0.00240954801897 , -0.00222862901043 , -0.00332040526229 , -0.00236359002144 , 0.00360688710407 , -0.00271542899329 , 0.00130974947009 , 0.000352961197168 , -0.00239874505228 , 0.00276717257621 , -0.000260577191913 , 0.00251304696162 , -0.00388917772918 , 0.00349881413256 , -0.00442864385276 , -0.00471891597821 , -0.000778665065247 , -0.00134948474463 , 0.000703357564162 , -0.00373835111261 , 0.00226246244065 , -0.000724715589903 , -0.00205403471783 , -0.000477319200833 , 0.00101539961175 , -0.00226274422512 , -0.000790111280716 , -0.000107350206199 , -0.00385321841708 , -0.00403649381381 , 0.000284510378114 , 0.00231971708217 , 0.00245678997067 , 0.00194132691806 , 0.000993016493601 , 0.00471491733471 , -0.000162548892065 , -0.00299169869764 , 0.000759103979618 , 0.00352490993325 , 0.000212663744664 , 0.00173264934915 , -0.00112937625712 , -0.00379458127314 , 0.00224633529245 , 0.000683277241055 , -0.00275458731136 , 0.00311467091104 , 0.00495827178578 , 0.00168491087891 , -0.00165821601915 , -0.00141988482602 , -0.000145947692071 , -0.00156358952883 , -0.00212926289757 , 0.00163215961636 , 0.00054908732046 , -0.00299449484552 , 0.00322392257145 , -0.00391759633716 , 0.00352385325934 , -0.00218901412771 , -0.00250903260591 , 0.000652956890142 , -0.00274885706743 , -0.00384795611748 , -0.00333746542384 , -0.00371453931433 , -0.00104758128416 , 0.000123199229578 , -0.00544487831493 , -0.00436331373927 , 0.00422798587517 , 0.00564881053372 , 0.00347282828073 , -0.00480737593303 , -0.000557331011728 , -0.000779390736711 , 4.11945628725e-06 , 0.00300446561863 , 0.00194897353492 , -0.00170486970036 , 0.000294279965383 , -0.00664105645396 , 0.000765955697534 , 0.00154426929592 , -0.0018078750479 , -0.00236625932529 , 0.00299172124257 , 0.00555035490771 , -0.000299316593286 , 0.000389507397061 , 0.000560966033942 , 0.000631349388283 , -0.0038678025066 , -0.00588894167276 , -0.00156162101472 , 0.00311194926693 , 0.00224139770593 , 3.94791634611e-05 , 0.00040297599796 , -0.00287394448048 , 0.00278730932477 , 0.000231660542544 , -0.00206660825489 , -0.00270545707729 , -0.00086283909858 , -0.00516945559832 , -0.00254624262565 , 0.00160577088492 , -0.00475339421665 , -0.000484699669458 , 0.000978864156874 , 0.00301186528156 , 0.00228006267534 , -0.00462536794594 , 0.000621124609384 , 0.00153714644006 , 0.00212979407503 , -0.000272843056121 , 0.00111657958297 , -0.00200250416499 , 0.00473178626037 , 0.00132609531198 , -0.00322279831257 , -0.00259828636523 , 0.000204661996084 , -0.00161848376373 , -0.00192014359763 , 0.00319333463141 , 0.00265524001275 , 0.00419549626548 , 0.00342660620131 , 0.000589535186629 , -0.00256184282837 , 0.00631307563246 , 0.00225150844889 , -0.00050401983973 , -0.00617395375159 , 0.00387606158495 , -0.00250277559632 , 0.000123091330694 , -0.0051865047046 , -0.00205008158709 , -0.00329763329931 , 0.000869769324626 , 0.00405791134732 , 0.00336869414799 , 0.00330907769203 , -0.00520328714466 , -0.00227669542141 , -0.00254035180699 , -0.00247390784499 , 0.00438933838755 , 0.00331669896816 , -0.00571449786848 , 0.00423496082813 , 6.9585285404e-06 , -0.00223683051554 , -0.00145593147058 , -0.00198713362314 , -0.00116223433347 , 0.000304974249627 , -0.000186147972972 , 0.00350005434442 , 0.000807101808107 , 0.00310801282364 , 0.00224710493551 , -0.000762898640154 , 0.00309387561725 , 0.0043385390349 , -0.000811891927865 , -0.00344538025355 , -0.0031888887168 , -0.00149218658293 , 0.00314153578736 , -0.00374647269704 , 0.00127492046485 , -0.00168780162194 , 0.00289007255821 , 0.000153195620394 , 0.00449742592778 , 0.00198632240467 , 0.004702515914 , 0.00272910985459 , -0.00161058692334 , -0.00289502619986 , -0.00498643069431 , 0.0033615426941 , 0.000834605439789 , -0.00304075873441 , -0.00525405794816 , -0.00424750934254 , -0.00201466425182 , 0.00316920895877 , -0.00615971747465 , 0.00134811300969 , 0.00272636718328 , 0.00209704101038 , -0.00309238964825 , -0.00554388067389 , 0.00601764894232 , 0.00115358705485 , 0.00397344816376 , -0.00421456482552 , 0.0011649644795 , -0.000116937911296 , -0.00102886513855 , -0.00287995752186 , -0.000856565313209 , 0.00647242498433 , -0.00181414638698 , 0.00161227502687 , 0.00235460086018 , -0.00138542218849 , -0.00148313581066 , -0.00511984017202 , 0.0061720438995 , 0.00351141813122 , -0.00141275041068 , -0.00378409185061 , -0.0063802600714 , -0.00360771676012 , -0.00405996279413 , 0.00291376372837 , -0.00266439979213 , -0.00303421920886 , -0.00533130828115 , 0.00153472322342 , -0.00522378904583 , 0.00382607252768 , 0.000767727877541 , 0.00269528778391 , -0.00197000420987 , -0.00231287074522 , -0.00141425938812 , 0.00222334872321 , 0.000370676154014 , 0.00245888194389 , 0.00314052183394 , 0.00134711150724 , 0.00164979693535 , 0.00709330365768 , -0.00390828392263 , 0.00267467808403 , 0.0041479483864 , -0.00107374217032 , 0.00440444172979 , -0.00172926105185 , 0.00290137059922 , 0.00246310996351 , 0.00126901728465 , 0.000202171219206 , 0.00437239447484 , 0.00348460120716 , 0.00539506614758 , -0.00293851411196 , -0.000426646514223 , -0.00489719563146 , -0.00243921861557 , -0.00225885227539 , -0.00438590156473 , -0.0016103563342 , -0.0036585070253 , -0.00549884297302 , -0.00327128607112 , -0.00588723637643 , 0.00562843892489 , 0.000536151313446 , -0.000355348661593 , -0.000954139462155 , -0.00163777233017 , 0.00229514672735 , -0.00368529598247 , 0.000137261190729 , 0.00236765878904 , 0.00505991137049 , 0.000749793118873 , 0.00443871323959 , -0.00063721276747 , -0.00496916751063 , -0.0014378150462 , -0.00522253675209 , 0.00326295825036 , 0.00435745349839 , -0.00260041548759 , -0.000815393079726 , -0.000754199741099 , -0.0045716873173 , -0.00239244879595 , 0.00209258802408 , -0.00235600151914 , -0.00111379472147 , 0.00392416466837 , 0.00402403791862 , -0.00331799369299 , 0.00498638351868 , -0.00449677358497 , 0.00469238517326 , -0.00287421550161 , 0.00123757640706 , 0.00360370808478 , 0.00294163977734 , 0.00403908078735 , 0.00245641565235 , -0.00312814744116 , 0.00437883921297 , -0.00144758092986 , 0.00314439745305 , 3.77317221336e-06 , -0.00187362875242 , 0.00461667390416 , -0.00163571333729 , -0.000284521057999 , -0.000816632589723 , 0.00158948205541 , 0.000761760695296 , -0.00275422801897 , 0.0046294053564 , -0.00450110133475 , -0.00643439541926 , 0.00207503421836 , 1.62001076137e-05 , -0.00302787079634 , 0.00156972801801 , 0.00254174002477 , 0.000471246240247 , -0.00232689097647 , 0.00429913181564 , 0.00396322987879 , -0.00355765621927 , -0.00644005626338 , 0.000107282157842 , 0.00309435655294 , -0.00201018899818 , -0.00300299529318 , 0.00327957172206 , -0.00239557233779 , 0.00122450820845 , 0.00220890187031 , 0.00496500094116 , 0.00419649365045 , 0.00247946948045 , 0.00154083166644 , 0.000243629687945 , 0.00230605565212 , 0.000467958846022 , 0.00122908783457 , 0.000553938331614 , 0.000536754275526 , -0.00380624009426 , -0.00360263140476 , -0.00151855348131 , -0.00218072474976 , -0.00298744331832 , -0.00134233868036 , -9.24189320081e-05 , -0.00190918010138 , 0.00145827366977 , -0.00102056324195 , -0.000339041071172 , 0.00118060168881 , 0.00284667568548 , 0.0037172194371 , 0.00328121539791 , -0.00341311347401 , -0.00150343697071 , -0.00347237715045 , 0.00340896971404 , 0.0019589033179 , -0.00163405983368 , 0.00402018112691 , -0.00239801897702 , 6.40359850714e-05 , -0.00101662305037 , -0.000972156310957 , 0.00647968517291 , 0.000605968231894 , 0.00190788032554 , 0.000226114585497 , 0.0051680949393 , -0.000280003926955 , -0.00243149504392 , -0.00365574622811 , 0.00258682805539 , 0.00137550442111 , -0.00362115918576 , -0.00280180359744 , -0.000410939382268 , -0.000930699608312 , 0.00264063685659 , -0.000257142463801 , 0.000600760768875 , 0.00129967470608 , 0.00202235596561 , -0.00365644216361 , 0.00367597181696 , 0.00203101500091 , 0.00525384359153 , 0.000913839987346 , 0.00322835703139 , -0.00220202948319 , 0.00240247477167 , -0.0023430054698 , 0.00162320370817 , -0.00288499064331 , 0.00394416679211 , 0.00209841186878 , -0.00218281215806 , -0.0022671769299 , 0.00479693505635 , 0.00334740696926 , 0.000122340397277 , 0.00349903942228 , 0.00291128765268 , 0.00292490713319 , 0.00316887612938 , -0.00386979036136 , -0.00259903746376 , -0.000171825297649 , -0.00071237386302 , 0.00300194561208 , -0.00524664314398 , -0.0033738710822 , 0.00341087007986 , 0.00116927671885 , 0.00557943256839 , -0.00368412065426 , 0.00681805621784 , -0.00302959130885 , -0.00266858557495 , 0.000572007108486 , 0.00126369129141 , 0.00223699685794 , -0.00159206831534 , 0.00275450495825 , -4.78174404087e-05 , -0.00146750265018 , -0.000478293984748 , 0.00401664056289 , 0.00054459165634 , 0.00347489082356 , 0.00240917636878 , 0.00137843308989 , -0.00126014388224 , -0.00318142761214 , 0.000932157354346 , -0.00246057985955 , 0.00241964798686 , -0.00412452496229 , 0.00489263426135 , 0.00189919946433 , 0.00181055391153 , -0.00156835986591 , -0.000157912853117 , -0.000531244850958 , -0.00571403738319 , -0.00118404607859 , -0.00120988058313 , 0.000969095155525 , -0.000231533937031 , -0.000489278571387 , 0.00416782910688 , 0.000235839816921 , 0.00379061550077 , -0.00144297399306 , -0.00111634516556 , 0.000595282283287 , 0.000654461605843 , 0.000324456712299 , -0.00053127523438 , -0.00502306099232 , 0.00104977741881 , 0.00350705301065 , -0.00278210721117 , 0.00404038363883 , 0.00183546980571 , 0.00438486158226 , -0.000983832169097 , 0.00386577408658 , -0.00189058968925 , -0.00163510535562 , -0.000905760433673 , 0.00410828265233 , 0.00225234070184 , 0.00159296604476 , -0.00200531913152 , 0.00388765546138 , 0.00309978185708 , -0.004514704782 , -0.00183150266998 , 0.00373931650794 , 0.0046242510913 , 0.00465580868661 , 0.00107583695433 , 0.00144072369763 , 0.00309832405165 , -0.000528085136531 , 0.00347657077847 , 4.07444855259e-05 , -0.00427703326704 , -0.00554326764922 , 0.000185223543895 , 0.000991153995592 , 0.00312015895656 , 7.3194054176e-05 , 0.00169502507776 , -0.00352526620744 , 0.00701367631505 , -0.00389868054851 , -0.00344396056529 , 0.000304715635626 , 0.00259355050445 , 0.00404181618656 , 0.00125070727634 , -0.00205717474085 , -0.00154430008947 , 0.00330946687369 , -0.00354289018352 , -4.23772490468e-05 , -0.0030057550234 , -0.00206689632616 , -0.00432913464482 , -0.00137166649092 , -0.00126658308119 , 0.00177958959016 , 0.00343454579338 , -0.00320644635397 , 0.00103750501945 , -0.00282611106662 , 0.00352444413281 , -0.000892484350612 , -0.00374619405172 , -0.0026187797534 , 0.00182714600259 , -0.00487520856924 , -0.000570312792195 , 0.00260842558474 , -0.00277314441194 , 0.00360019960292 , 0.000188780681342 , 0.0042764669493 , -0.00430596885282 , -0.00295824755786 , -0.000859632591282 , -0.00525557701553 , 0.00385763596207 , 0.00546607038036 , -0.00348187478108 , -0.000400382783365 , -0.000315811165385 , 0.00400317896854 , 0.00139228653879 , 0.00162631931999 , -0.00484352902492 , -0.00213606559778 , -0.00069540207545 , -0.00366689988078 , -0.00134112925529 , 0.00435031938478 , -0.00188562921924 , 0.00161397269216 , 0.00232559062358 , -0.00247184166803 , 0.0017894883047 , -0.00187057116192 , 0.00411010451731 , 0.000796039435347 , -0.000952868524129 , 0.0012351553204 , -0.0039531418576 , 0.0015800684942 , 0.000796858498631 , 0.00270315108936 , 0.00122882996112 , 0.000655286089958 , -0.00199355985139 , 0.00176732786967 , 0.00031810181685 , 0.00212574130031 , 0.00290864481806 , -0.00142043994057 , -0.00449005461398 , -0.0022168373058 , 0.00647567636292 , -0.00244797793732 , -0.000273394034135 , -0.00192416283868 , -0.00403710563927 , -0.0020805905981 , 0.00134640579567 , -0.00291816158186 , -0.00290425510964 , 0.00134736559714 , 0.00520980455831 , 0.00139353471554 , 0.00312885543153 , -0.0017868329073 , -0.00333585758704 , -0.00108430727869 , -0.0063267219934 , 0.000931305727169 , -0.00136251222517 , -0.00437224338436 , 0.00674126664705 , -0.00216795568238 , -0.00441891085841 , 0.000962808785413 , -0.0047913297649 , -0.00130261283896 , -0.00133952948389 , 0.0003252556502 , 0.00103914579673 , 0.000528826115259 , -0.00457740397594 , -0.00411564795033 , 0.00349445854738 , 0.00314357255616 , -0.00229608315494 , 0.00193503300628 , 0.00380752321194 , -0.00128061809958 , 0.00160903262165 , -0.0031878680097 , -0.00545891677419 , -0.0022295042019 , 0.00257994933406 , 0.00290493833479 , 0.00367545949235 , 0.0042192645893 , -0.00182081891083 , -0.00133781683854 , -0.00410186838506 , -0.00257996651251 , 0.00436959354645 , 0.00026891428373 , 0.00161076748652 , 0.00086319315134 , 0.00347009283572 , 0.00077794883144 , 0.00291011127776 , -0.000456363347925 , 0.00076230462743 , 0.0014462576978 , -0.00193266660419 , -0.00081288044289 , 0.00298712621669 , 0.00439356631173 , 0.00324904144331 , 0.000311127216152 , -0.00365989878222 , -0.00277254078791 , 0.00236100147541 , -0.000534197036394 , 0.00213970741554 , -0.00178859880811 , -0.00039455585702 , -0.000432776408674 , -0.00095534519662 , 0.00291235449058 , -0.000523952254594 , 0.000871307737195 , -0.000779116871677 , -0.000175454980232 , 0.0032937248879 , -0.00281102229204 , -0.00269037849976 , 0.00101022400155 , 0.00505554311834 , 0.00376676908265 , -0.00241108797732 , 0.00354549824704 , -0.0024474656756 , 0.00144433003755 , -0.0049939532578 , 0.00657285137345 , 0.0014593396569 , -0.00434625152608 , 0.00403112826826 , -0.000896553450779 , 0.00694845638459 , 0.00228003206555 , -0.000555185658858 , -0.00145173716206 , 0.00583864907096 , 0.000865034636281 , -5.25531964789e-05 , 0.00391400436343 , 0.000450960380271 , 0.00259475774167 , 0.000176569013029 , -0.00201376346881 , -0.0011780475409 , -0.00378894231989 , 0.00103352684396 , -0.00367586784208 , 1.14127036175e-05 , 6.41588535214e-05 , 0.00279721555803 , -0.000804055446864 , 0.00156131209589 , 0.00383727868945 , 0.00117208815837 , -0.00162530958593 , -0.00124335102446 , 0.000893054833255 , -0.00107644327399 , 0.00230899162984 , -0.000282905823772 , -0.00328330667718 , 0.0026297713093 , 0.00100169830229 , 0.00165125983424 , -0.000923838604101 , 1.93870578496e-05 , -0.000723091096349 , 0.00236023155386 , -0.0015879872113 , -0.00394390727239 , 0.00328013768177 , -0.00332776268389 , -0.00097427783347 , -0.00291378993328 , 0.00195440096395 , -0.00219702365693 , -0.00197023174931 , -0.0024551050454 , 0.00127538336649 , -0.00339950224399 , 0.00170860542587 , 0.00148752965938 , -0.000507199993625 , -0.000384140789811 , -0.00599496927844 , -0.00301101435872 , 0.000582471614807 , -0.00247228601476 , 0.0042036731145 , -0.000699660020339 , 0.00150813584542 , 0.00559860865202 , -0.00165411938882 , -0.00239044513284 , -0.0037607788889 , -0.000305855762389 , -0.0027344360316 , 0.00113858102638 , -0.00444860385439 , -0.00227546108129 , 0.00188003302937 , 0.00207733349562 , 0.00358907769696 , -4.6788537645e-05 , 0.000854954002099 , 0.0052053931872 , 0.00303042674279 , -0.0019242737989 , -0.000556851957893 , 0.000504203086878 , 0.00170312860859 , 0.00023624118946 , -0.00347466125845 , 0.000779933314689 , -6.0478613917e-05 , -0.00171484832078 , -0.00507857664271 , -0.000937898325063 , -0.00299697615727 , 0.00011700993512 , 0.000301209306685 , -0.00418409869288 , -0.0047440754371 , -0.00296582192677 , 0.00133407646232 , 0.0021286583028 , -0.000380936724943 , 0.00251238572929 , 0.00542607930478 , -0.0027582719642 , -0.000133047837869 , 0.0033014646753 , -0.0010793490323 , 0.003406351203 , -0.00340080671421 , -7.59525769267e-06 , 0.00453131558561 , -0.000199563961393 , 0.00308080703366 , 0.00475234443287 , 0.00103603381943 , -0.00153746879426 , 0.00132602962007 , -0.000957099181125 , -0.00374602042133 , 0.00110750265308 , 0.00375958905958 , 0.00294852947002 , -0.00154531272716 , -0.00219644146198 , -0.00190695732282 , 0.00509526612154 , -0.00494090837954 , -0.00104595066556 , -0.0047635069272 , 0.00208503654076 , -0.00200573711378 , 0.000491523709115 , ])
Y_1_0_real = flex.double( [ 0.00511761979096 , -0.000678246555101 , 0.000369346295232 , -4.80840197174e-06 , 0.00249415029209 , 0.00478484172767 , 2.32488778207e-05 , 0.00172835214633 , -0.00526391133093 , -0.000862557889908 , -0.00330923465014 , -0.00614908653316 , -0.00614311010983 , 0.00485048000459 , 0.00640818065446 , -0.000947725098421 , 0.00415406812725 , 0.0111841104037 , -0.00134865232221 , -0.00701004963133 , -0.00116310807587 , 0.000245329727527 , -0.000273736959641 , 0.00385525150719 , 0.00154190532513 , 0.00859588964805 , -0.00469685459825 , -0.00142747259869 , 0.00495617597447 , 0.00696845395762 , 0.0125758232039 , 0.003160646379 , 3.95105443042e-06 , -0.00327633193055 , 0.000614286060727 , -0.00254857832625 , -0.00119093034368 , 0.000689315766575 , 0.0083177214137 , 0.00109374085163 , -5.72737006148e-05 , 0.0026231768941 , 0.00282321686893 , -0.00334130091611 , -0.00224913548099 , -0.0027536756753 , -0.00289331343449 , -0.00181732473262 , 0.00268974299844 , 0.00238322667732 , 0.000744647555582 , -0.00380245221378 , -0.00351619494755 , 7.47671623479e-06 , 0.00327493554644 , 0.00359202534438 , -0.00488811958062 , 0.00120588529863 , -0.00671399350122 , 0.000145052863419 , 0.000702965320989 , -5.17869730701e-05 , 0.00636949677394 , 0.00233791611726 , 0.00709243713361 , 0.000105726177578 , -0.00189640149796 , 0.0027842040169 , 0.00133342334433 , -0.0015528231426 , -0.00321514331646 , -0.00079930314633 , 0.000382845039243 , -0.00602422116238 , 0.0060262400382 , 0.00417987409108 , 0.00133584771576 , 0.00311373879197 , -0.000440573131472 , -0.0040023646664 , -0.0066084017619 , 0.00481353746071 , -0.00304863451925 , -0.0022209185746 , 0.000708721792142 , 0.0027208623259 , -0.00837556847379 , -0.00122687507949 , 0.00513935311829 , -0.00425948169235 , -0.00412504287341 , -0.00808649205787 , 0.00720589644377 , -0.0040917946716 , 0.00364656281928 , 0.0026357182983 , 0.0102746273147 , -0.000578737902113 , -0.00191205108052 , -0.00492773090054 , 0.00298477962526 , -0.00181596111794 , 0.0030346669017 , -0.000158036853119 , -0.000263444912773 , -0.00425392566169 , -0.00134259490178 , -0.00069563677188 , 0.00463950835731 , -0.00655854683929 , -0.00687487773527 , 0.00394520568484 , -0.000447644016542 , 0.0120189009343 , 0.00656369176923 , 0.00274828553276 , 0.0030013648876 , -0.00273734368404 , -0.00269626069881 , -0.00501219898744 , 0.0030355308787 , -0.000599661860894 , 0.00962667039152 , -0.00304568976339 , -0.00390570567489 , 0.00120589449061 , -0.00158361973486 , -0.00502130035022 , 0.00113014305073 , 0.00152984728214 , 0.0047032203594 , 0.00317819691592 , -0.000288389233273 , 0.00449974794588 , -0.00593067717723 , 0.0033446776837 , -0.00118851458376 , -0.000995422372614 , 0.00359418997242 , 0.00290860846255 , 0.00757337424191 , 0.000800025921415 , -0.00287859241725 , -0.00665801919921 , 2.51260608685e-05 , -0.00360142594923 , -0.00188113702618 , -0.00150464481034 , 0.00133804713479 , 0.00268510033724 , 0.00867153983363 , 0.000542140022955 , -0.00693304690382 , 0.000946484944326 , 0.00111097552016 , -0.00228303112556 , 0.00116809814884 , -0.00423127482844 , 0.00133945885852 , -0.00163400104766 , -0.00322508450037 , -0.00665512010094 , -0.00736117041854 , 5.68486268988e-05 , 5.48105756626e-05 , 0.0037221383345 , 0.00028726738863 , -0.00129921662127 , -0.00346672611862 , -0.00642192824652 , 0.00388571553468 , -6.41732446837e-05 , -0.00292727643512 , -0.001876366567 , 0.00472050615043 , 0.00532748387438 , 0.00348196115245 , -0.00504566508879 , 0.00169730522681 , 0.00552052786646 , 0.000196406025135 , -0.00281995380911 , 0.00317659841405 , -0.00578393934578 , 4.30426278923e-05 , -0.00585906783413 , 0.00571705753801 , -0.00455781502842 , 0.002144813921 , 0.00917251674681 , -0.00305783152809 , 0.00080606661444 , -0.00143830866639 , -0.00218326321913 , -0.00477792013142 , -0.00435411291597 , 0.00161342352373 , 0.00417937867844 , -0.00417580101265 , 0.00178448724721 , 0.00261596437874 , 0.00488128299654 , -0.00393779733631 , -0.00231267069756 , -0.00699478385579 , 0.00409062202314 , 0.00183193147073 , -0.00286195195378 , -0.002545820865 , 0.00601712225851 , -0.00476349283309 , 0.00542088166663 , 0.00133049646552 , 0.00271243731242 , 0.00289373493911 , -0.00286657526164 , -0.00238840287922 , 0.00358903566824 , -0.00230556325906 , 0.00657659108097 , -0.00146595102343 , -0.00479192861019 , 0.00642663481652 , -0.000931654667172 , -0.0029494324095 , 0.00188868323588 , -0.00205853983336 , 0.00652557440815 , -0.00071535624103 , 0.00248055845794 , 0.00336700452371 , 0.00533888493959 , 0.000840342999528 , 0.00300297727634 , -0.000806470838555 , 0.000846835082411 , 0.00377279294772 , 0.00392231134979 , 0.00115679942206 , -0.000995784693681 , -0.00158447124192 , -0.000284688479777 , -0.00476242185604 , -0.0032672738751 , 0.00164879067504 , -0.00538140674249 , 0.00217009423116 , -0.00536117300267 , -0.00182019068685 , 0.000471649752906 , 0.0038360402093 , 0.0010956662476 , 0.00746173079963 , -0.00186314102766 , 0.00405390608573 , 0.00197899197696 , 0.000694235039478 , -0.000178567927857 , 0.00151410154919 , -0.00387787153339 , -0.0044369063987 , -0.0044910481176 , 0.0021750279418 , 0.00282168480984 , 0.00285374802258 , 0.00389637535785 , 0.00569146502842 , 0.00284134940107 , -0.00621595163507 , 0.00279754109538 , -0.000631872594874 , 0.00153717345143 , -0.00300142244521 , -0.00219537003451 , 0.00618654810449 , 0.000932108541811 , 0.000343298506714 , 0.00250901445786 , -0.00420298144532 , -0.00140911934827 , -0.00444017906382 , -0.00546359983124 , -0.00212007349472 , -0.00467905240439 , 0.000848091317503 , -0.00519050933565 , 0.00668881593585 , 0.000188085800141 , 0.0057942220567 , 0.00116505931221 , -0.00158526589506 , 0.00380102812828 , -0.000304625840539 , 0.00285927855111 , -0.00260930617712 , -0.00110762807973 , 0.00700733263147 , 0.000764161225274 , 0.00402283441444 , 0.000900528660909 , 0.00418008410303 , 0.000447928495328 , 0.00298287758094 , -0.00232682558447 , -0.00503992490006 , 0.00564020442945 , 0.00348469969599 , 0.00693824302136 , -0.00297678575058 , -0.00079252508905 , -0.0035575822065 , -0.00117111011255 , -0.00219883901899 , -0.00119540838204 , 0.00110025953429 , -0.0024142046324 , -0.00542807869877 , 0.0019216599 , 0.00439645590328 , -0.0029460603448 , -0.00356789373735 , -0.00734706444522 , 0.00660211801049 , 0.00048652867628 , -0.00658836161197 , 0.000854957805556 , -0.000943770359543 , 0.000777783258823 , 0.00950777218536 , 0.00640493557021 , -0.00742314296452 , -0.00213176785721 , 0.00463338434788 , -0.00665645968091 , -0.00435250121284 , 0.0006500979263 , -0.00262233933565 , -0.00538875599453 , -0.000927359030661 , -0.00558998591204 , 0.000258600881505 , -0.007570021709 , -0.00598196594307 , -0.000126549476105 , 0.00156543591534 , 0.000419828842976 , 0.00321535162532 , 0.00995100103077 , -0.00404318807804 , 0.0099255477598 , -0.00208424601443 , 0.00359993675768 , 0.00192224298219 , -0.00351648154181 , 0.00249553392569 , -0.00067795026329 , 0.00372184963412 , -0.00274435201899 , -0.00411098703127 , 0.00877822922766 , 0.00221998396249 , 0.0133183494588 , 0.0040682087254 , -0.00104161909643 , 0.000664202097971 , -0.00586182572277 , 0.000683895060849 , 0.000866017107454 , -0.00374247332975 , -0.00503951779855 , -0.00344570861008 , 0.00492616498712 , 0.00170160640368 , 0.00166952457969 , 0.00203381914764 , 0.00359101930362 , -0.00181288318889 , -0.00542537703441 , 0.00377036877148 , 0.00467930003536 , 0.000571018127013 , -0.00144267719546 , -0.00204385919078 , -0.00362657187582 , 0.00663986849598 , -0.00538344825485 , -0.00617045166014 , 0.00519869957477 , -0.00459356385264 , -0.00128418861823 , -0.00219157479072 , -0.00397479756588 , -0.00520966431371 , 0.00151840411565 , 0.0101129767502 , -0.00241890964343 , 0.00784736009446 , -0.0062552952785 , -0.000502302905015 , 0.00194334037187 , 0.00223635851985 , -0.00224829933221 , -0.00532350547392 , 0.00419113955404 , 0.00542507528251 , -0.00591346922548 , -0.00549530486575 , -0.00467281594577 , 0.00255592540801 , -0.00149385528522 , -0.000458873122248 , 0.002175737742 , -0.00308556292075 , 0.00207894549828 , 0.00729852035978 , -0.00564661785165 , 0.00434156128266 , 0.00132678125831 , 1.25412632196e-05 , -0.0006894154317 , -0.00415665114418 , 0.00428629703553 , -0.00256083906555 , -0.00239734086686 , 0.00444100690801 , 0.00289800815802 , -0.00608503613476 , -0.0025596389941 , -0.00663595671296 , -0.00673201265822 , 0.00136425508495 , 0.000218547820723 , -0.00271452285237 , 0.00143715544253 , 0.00350830707546 , -0.00636191590561 , 0.00150058324278 , -0.00599629198044 , 0.000974092321583 , 0.00595122021604 , -0.0048757677357 , -0.00424804841479 , 0.00350152420845 , 0.00163792874499 , -0.00721868654363 , -0.00544614526562 , 0.00307682621626 , -0.00154000214461 , -0.00309860158505 , -0.00512705019669 , -0.0030270197003 , 0.00229771724823 , -0.00367572353351 , 0.00915593551627 , 0.00336465147919 , -0.00567474559985 , 0.00624778877542 , -0.00507651841032 , -0.00109482146151 , -0.00508621156359 , 0.000139723857277 , -0.000299976925793 , -0.00725614518012 , -0.00660871267256 , -0.00103233909533 , -0.00325628734119 , -0.00403968357082 , -0.000478202828453 , -0.00652448124011 , 0.00331619518914 , 0.00792941636658 , 0.00436501189933 , 0.00445069420744 , -0.00144116335687 , -0.00279324985338 , -0.00509464968098 , 0.000662308881655 , 0.00461521979744 , -0.000302128513327 , 0.000638640638968 , 0.00366256507385 , -0.00359554158607 , 0.00502585738832 , 0.00365818828497 , 0.00186770478048 , 0.00346742855236 , -0.00630443558703 , -0.00209403742393 , 0.00147367927642 , -0.000977125401297 , 0.00291750747056 , -0.000806843814294 , -0.00604600626869 , -0.00406799178159 , 0.00189846164396 , -0.00735807771156 , -0.00224649892393 , 0.00471165256014 , 0.000949934504949 , -0.000748376798497 , -0.00556936160689 , 0.00544163840973 , -0.00461498466347 , -0.00218809645473 , -0.00209042649146 , 0.00213035753119 , 0.00332695702918 , 0.000969281011933 , -0.00369666682816 , -0.00509776805579 , 0.00412814436872 , -0.000131553770277 , 0.00498143611883 , -0.00325212805466 , 0.00508245870164 , -0.00161180554562 , -0.00413303275289 , -0.00102111925009 , 0.00587596991555 , 0.00117816792219 , 0.00446120144604 , -0.000122574592563 , -0.00292235579399 , -0.00186895146127 , -0.0055776114343 , 0.00179983833486 , 0.00526499065974 , 0.002746311721 , -0.000711994938042 , 0.00435221061305 , 0.00130826344992 , 0.00246240966435 , 0.00148001748492 , -0.000372978677572 , -0.00186113459983 , -0.00496013900995 , 0.000785018979589 , -0.00555225249493 , 0.00118719925131 , 0.000592361740377 , -0.00454625490768 , 0.000989972780325 , 0.00232763122035 , -0.00173894621821 , 0.00286312208077 , 4.22550622652e-05 , 0.00595139269043 , -0.00717274667063 , 0.00211357236318 , -0.000873211270976 , -0.00384949238168 , 0.0053682892443 , 0.00338487209778 , -0.00677933509869 , -0.00454268911292 , -0.00535292539478 , 0.00190164140038 , -0.00496805958514 , -0.00393436056299 , -0.00514187501227 , 0.00119575019147 , -0.00155480572207 , 0.000729676844998 , 0.00968412308298 , -0.0016091883402 , -0.0043249824541 , -0.00375981210045 , 0.00358142548116 , 0.00331137821789 , 0.000258636337291 , 0.00205281594995 , -0.0039767697995 , 7.51101434276e-05 , -0.000709378524549 , 0.00438492372784 , -0.0015858947374 , 0.00371511616807 , 0.00135619511974 , -0.00176350036563 , 0.00725337039204 , -0.00395190295644 , 0.00911424724349 , -0.000584585922028 , 0.00304825470433 , -0.000748429683985 , 0.00297618721019 , 0.00734002925672 , 0.00198287519615 , 0.00583122187388 , -0.00243383368039 , 0.00103790765766 , 0.00667047339544 , 0.00201443338031 , 4.42396994233e-05 , 0.000891239868736 , -0.00712203607872 , -0.00333002781448 , 7.3821352962e-05 , -0.00115978895317 , -0.00601897141028 , -0.0034231399311 , -0.00160026668486 , -0.00280965460611 , 0.000294915010427 , -0.00334904293502 , -0.00434664502999 , 0.00468653000099 , -0.00457070348231 , -0.0026765790775 , 0.00730240749275 , 0.00293754333222 , -0.000469378808811 , 0.00569876422792 , 0.00159241796022 , 0.00299912185521 , -0.00220366631832 , -0.00454981117997 , -0.00507098882149 , 0.00361144754387 , 0.00268592787148 , -0.00644699196006 , 0.000464486185534 , 0.00969707325619 , -0.0047980758061 , 0.0047927452955 , 0.00305518991738 , -0.000858159253245 , 0.0016526207524 , -0.00235672824223 , -0.00551167365026 , 0.00133531232308 , 0.00091265751517 , 0.00213639779117 , 0.00225047547593 , 0.0052955831741 , -0.000662809427497 , -0.001901140228 , 0.00833081847491 , 0.00164727072284 , -0.00254856185897 , 0.000672021070202 , -0.0014422321413 , -0.00397515433017 , -0.00700244515511 , -0.00413001345621 , 0.00586864733482 , -0.00248904266383 , 0.00656292981994 , -0.00204398524749 , -0.00740374340952 , -0.00422792497576 , -0.00322383797226 , -0.00420075112694 , 0.000720703145649 , 0.0037711779516 , -0.00809201041532 , 0.00135184177993 , -0.00364153515452 , -0.00491640805637 , 0.00685154481741 , -0.00630611406565 , 0.00111871451622 , -0.00321842988492 , -0.000782031000082 , 0.00257209432077 , 0.00171842319636 , 0.00147056711121 , -0.00595429434392 , 0.00755874760912 , 0.00433348300402 , 0.0043195810885 , 9.27130606627e-05 , 0.00209668827969 , -0.0046369157488 , 0.00448449349295 , 0.0015725548624 , 0.00566408743492 , 0.00497102938962 , -0.00149947109045 , -0.00264665266474 , -0.00159244329624 , 0.00435780694811 , 0.00195077328606 , -0.000675465874008 , -0.00290036485255 , -0.0053630975951 , 0.00179154376426 , 0.00447244490583 , 0.005967967627 , 0.000775137414268 , 0.00602906754816 , 2.08787805042e-05 , 0.000769782956003 , 0.00724211652649 , -0.0035747451197 , -0.000461693287418 , -0.00377816746732 , 0.00131319367033 , 0.00575909508127 , -0.00140909302217 , -0.000940182509774 , -0.00233945551445 , 0.00173141044927 , -0.00208020725085 , 0.00476289567721 , -0.00250808557698 , 0.00188272914784 , 0.00911542205864 , -0.000598328507709 , 0.00748455962988 , 0.000586416030038 , 0.00194530312209 , -0.00210429691495 , 0.00174938454049 , 0.000992497823723 , -0.000288763268687 , -0.00112286026368 , 0.00416975448192 , -0.00417495167138 , -0.00486143364237 , -0.00362929863289 , -0.00281362952396 , -0.00252719466698 , -0.00416330915392 , 0.00324387538635 , -0.00461613988309 , -0.0015285413747 , 0.00158396913884 , -0.00518435397654 , -0.00401436137063 , -0.00721828670185 , -0.00164802533937 , 0.00295856745293 , -0.00207004459889 , 0.00538769227147 , -0.00462327833653 , -0.0067398871191 , -0.00297201996329 , 0.0118144333117 , 0.00843831725016 , -0.00424020972408 , -0.000552769494962 , -0.00511327319827 , 4.97311316369e-06 , -0.00794532537972 , -0.00293973013207 , 0.00141803716595 , 0.0113013513026 , -0.00343801971469 , 0.0034302598073 , 0.00265029232641 , -0.00424327973826 , -0.00114175215969 , -0.00789451241176 , 0.00211140273941 , -0.00567123753193 , 0.00879609389507 , -0.00241772919784 , -0.00309730927959 , -0.00291056338205 , 0.013873798841 , -0.00258755543244 , -0.00484391079515 , 0.00415012268568 , -0.00285419251156 , 0.00526858921965 , 0.00366128888027 , -0.00556587145943 , 0.00206563496508 , 0.00125488964401 , -0.00646284964897 , -0.00470774539694 , 0.000846080426189 , 0.00283939953415 , -0.00580804132223 , -0.00396135983544 , -0.00465629175628 , -0.000793837886521 , 0.00590337447222 , 0.00169034071539 , -0.00254689031379 , 0.00769547547443 , -0.00688817687656 , -0.00703958874178 , 0.00109734601611 , 0.00638055068686 , -0.0018457828994 , 0.0049220451209 , 0.00572802611252 , 0.00351503302134 , -0.00403817816215 , 0.0034482609348 , -0.00624192068286 , -0.00536865588154 , -0.00144260133758 , 0.0022815850459 , -0.00370100013086 , 0.000112049883847 , -0.00504200223276 , 0.00859854749277 , -0.00379102604109 , -0.00506022455895 , 0.00218750642976 , -0.000308706156359 , -0.00344840125363 , 0.00660725919622 , 0.00179600342567 , -0.00462366976081 , 0.00233087746835 , -0.00213057107055 , 0.00316747359376 , -0.00554410317109 , -0.000380782358019 , 0.00704620544679 , -0.00730713842199 , 0.00177292178832 , -0.00134391591044 , 0.000185197660802 , -0.00479004783549 , 0.000759244988095 , -0.000406500826467 , 0.00606184120537 , -0.00249919939839 , -0.00803366377206 , 0.0018942688066 , -0.00460111397742 , 0.00285875886624 , -0.00727606674196 , -0.00737705414724 , 0.00119513301433 , 0.00110255636334 , 0.00228597665166 , -0.00320962130825 , 0.00608134049002 , 0.00269328893012 , 0.0019018576363 , -0.00353998186634 , 0.0022033821518 , 0.00330505582964 , -0.00553728165745 , -0.00295585677983 , -0.000534240408504 , 0.00413993762735 , 0.00723046055188 , -0.00103849979399 , -0.00120189089824 , -0.0066033565291 , -0.00421635109132 , 0.00478701933967 , -0.0055730258919 , -0.0063259194049 , 0.00480267278844 , -0.00378310334956 , 0.000792257598373 , 0.00289042679081 , 0.00253038795033 , 0.000343452988795 , -0.00518184933494 , 0.00165956227218 , 0.00649840189639 , 0.000695003600478 , 0.0113853801284 , 0.00324555344792 , 1.34464637816e-05 , -0.0041474648358 , -0.00100883787001 , 0.00593013577844 , 0.000607243881041 , -0.000177740841261 , 0.00118742948325 , 0.00544309222269 , -0.00453377539639 , 0.00887940931862 , -0.00276010484174 , 0.00177267073019 , 0.000744225814348 , -0.0017588899223 , -0.00622509394572 , -0.00249173185185 , 0.00320026342405 , -9.43099503205e-05 , 0.00388741979946 , -0.00847287395627 , 0.00138787449008 , -0.00237152697816 , -0.0043053477575 , 0.000852311707375 , 0.000202017988372 , 0.00558069474528 , 0.00223233422123 , -0.0030571633656 , -0.00293959200916 , 0.00214594520743 , -4.8112694716e-05 , -0.00159371221205 , -0.000853697609145 , 0.00435317717638 , -0.00543809509463 , -0.00612633550207 , 0.00112276807192 , ])
Y_1_0_imag = flex.double( [ 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , ])
Y_1_1_real = flex.double( [ -0.0 , -0.00614972728298 , 0.00487664073352 , -0.00457435690992 , -0.00266823117392 , 0.00145737937967 , 0.00260121142056 , 0.00454908133328 , 0.0040056302631 , 0.00131529336318 , 0.00390963346538 , 0.00055525625271 , 0.00117727378407 , -0.000485125452809 , -0.0019435225972 , -0.0022955559448 , 0.00145306478006 , 0.0034958506944 , 0.000717173533451 , 0.00153957438514 , 0.00549112561124 , -0.00355808770621 , -0.00166519176547 , 0.00437656549507 , -0.00628225521513 , 0.00424564678204 , -0.00315860880305 , 0.000253333682055 , 0.000346222746097 , -0.000861922238275 , 0.00160436288564 , -0.000409029370958 , 0.000216223225472 , -0.0036598196829 , 0.00124663709501 , -0.00449555061857 , -0.00503697360153 , 9.44483965829e-05 , -0.000270023606735 , -0.00283767090901 , 0.00363590395777 , 0.00449220101214 , -0.00257554506425 , -0.00350810327844 , 0.0034536508985 , -0.00422365373356 , 0.00404075758934 , 0.00467988489609 , 0.00408591924204 , 0.00161069440172 , -1.00451707031e-05 , 0.00347389981319 , 0.00340311351746 , -0.000519599291505 , -0.00314972838438 , 2.51452820603e-05 , 0.00136357606146 , 0.00403025720822 , 0.00332841876444 , -0.00259805424041 , -0.00551629203689 , 0.00487135174172 , -0.00136663248981 , -0.0012628480703 , 0.00251610565114 , -0.00252551914353 , 0.00344604144368 , -0.00508646172819 , 0.000579067329372 , -0.00362687729434 , -0.00411063382522 , 0.002731448238 , 0.00505808796286 , -0.00178196735565 , 0.000148880841533 , -0.00306475444693 , 0.00166302649322 , 0.00566519547692 , -4.3319203773e-05 , 0.00147549898342 , -0.0020236749848 , 0.00523559036974 , -0.00326442413692 , 0.00381719535055 , 0.00446147524378 , 0.00424589485875 , 0.000269450177183 , -0.00194737457855 , -0.00190030998916 , 0.00304266087264 , 0.00337109978859 , 0.00130342328094 , 0.00120040371429 , 0.000189432934745 , 0.00154260604812 , -0.00111635144598 , 0.000832809559944 , -0.00214552227695 , -0.00109455986432 , -0.00285823513721 , -0.00305058788487 , 0.00221695517973 , -0.000845799967908 , 0.00383292074925 , 0.0037491389622 , 0.00427628055463 , 0.000701049912145 , -0.000693090267646 , -0.00218062746155 , 0.000646510452231 , -0.00157791007322 , -0.0016370441126 , 0.0027788487844 , -0.000509361930798 , -0.00140131276331 , 0.00158250378868 , 0.00461101672484 , 0.00342254087634 , -0.00105758573051 , -0.00312392528105 , 0.00262398301506 , -0.000107328585878 , 0.0010522884843 , 0.00192333357955 , 0.00298535362461 , 0.00407023689871 , -0.00534867208396 , -0.000779585402542 , 0.00308779832179 , 0.000922554731467 , 0.00422214130948 , 0.00549430713648 , 0.00012679322357 , -0.00129237162592 , -5.5380761857e-05 , -0.00462793852501 , -0.00261054305799 , 0.00346710551469 , -0.00487610015085 , -0.000846251440639 , 0.00114909548942 , -0.00131510841595 , 0.00283976580834 , 0.00223843515015 , -0.00608547625543 , -0.00416174647446 , 0.00354573181646 , 0.00385941824889 , 0.000912042417016 , 0.00336858587033 , -0.000470964781793 , 0.00108173700271 , -0.000454892279721 , 0.000439800487447 , 0.00338559603487 , 0.00149856323382 , -0.00363073595983 , 0.00219370164579 , 0.00314624729238 , -0.000558213679537 , 0.000965331340717 , -0.00042411520626 , -0.00167620471032 , 0.00240491177785 , -0.00158649481617 , -0.0017447644334 , -0.0032085525773 , -0.00339652321729 , -0.00276029341062 , -0.00228179602125 , 0.00371976562188 , -2.62722627606e-05 , 0.00165480400482 , -0.00207268123603 , -0.000754484919587 , 0.00235900746706 , 0.00163390185161 , 0.00396285368512 , 0.00212246084284 , 0.00024514109273 , 0.00255518471353 , 0.0029430579465 , 0.00262258822555 , -0.00325031160077 , -0.00378374205145 , -0.00169782622346 , -0.00295583871447 , 0.00279370346224 , 0.00265709375809 , -0.000642191679826 , 0.00116553546012 , -0.00193585293919 , -0.000356617534033 , 0.00474318834127 , -0.00338171144081 , 0.0013132024158 , 0.000333069034647 , -0.00142954594678 , 0.000709092271711 , -0.00562286071796 , 0.000574541301669 , -0.00238224521876 , 0.0038370543331 , 0.00115327631859 , 0.00250530229145 , -0.000527031202865 , 0.000260211540519 , 0.00222518574568 , 0.00475849821303 , 0.00458033507147 , 0.00283080441619 , -0.00021341962301 , 0.00037748190552 , 0.00403763475047 , -0.0034315151942 , -0.00296922961045 , 0.00409933716426 , -0.00047610993102 , -0.000498009999378 , -0.00410003457142 , -0.00481231854612 , 0.00254952024436 , -0.00392804585376 , -0.00407661274345 , -0.00202111685957 , -0.000158232907121 , -0.00372300562231 , -0.00263283799278 , -0.000547858394561 , -0.00175148548391 , -0.00511660744783 , -0.00114740388159 , 0.00406141183995 , 0.00368221766497 , 0.00512909655217 , 0.000530440155466 , 0.000299526938109 , -0.00208777702586 , 0.000488826095426 , 0.00331048268604 , -0.00157805431503 , 0.00314695262924 , -0.00181212827132 , -0.000504660643389 , -0.00056866580439 , 8.26407712635e-05 , 0.00433071841648 , 0.00321135697298 , -0.000535206474087 , -0.00174512390206 , -0.00186517440838 , -4.36619970959e-05 , -0.0020172525479 , -0.00429416311653 , -0.00134918803248 , -0.00513386943211 , 0.0051770554539 , 0.000555734534971 , 0.00331559874 , 0.00101971474101 , 0.000945356561546 , 0.0018202523395 , -0.000441426252559 , -0.00196717990939 , 0.0035674754943 , -0.00441643939938 , -0.00378750533782 , 0.000539689485707 , 0.00208460940868 , -0.00416969834658 , 0.00338766663096 , -0.00248051238692 , -0.000306065748116 , -0.00451034475711 , -0.00316344705663 , 0.00248263558495 , 0.00377787248251 , -0.00481523336322 , -0.00360549931521 , 0.00165853560504 , 0.00214916483495 , -0.00173264285395 , -0.00592199082796 , -0.00188142786147 , -0.0015120614665 , -0.00284749462098 , -0.00413088071915 , 0.00183586202842 , 0.00158416550848 , 0.00273691148438 , 0.00341727101533 , -0.00183775485903 , 0.00395686750344 , -0.00173851116527 , -0.000341523352641 , 0.0047011212982 , 0.00271165703908 , 0.00288531922554 , -0.00445666592257 , -0.00353570780468 , -6.00292443681e-05 , -6.87470013169e-05 , 0.00235378083777 , 0.00215252886695 , 0.00195795552757 , -0.00396998658851 , -0.00228201257671 , -0.0027166246385 , 0.00444918990779 , 0.00051494377987 , 0.00101452708263 , 0.0016660050424 , 0.00484965311777 , 0.00115902366019 , 0.00147017421803 , 0.000129467099292 , 0.000474069342195 , -0.000875428616099 , -0.00122286350815 , -0.00383519372279 , -0.000571683372061 , 0.000302698799473 , 0.00281942539235 , 0.000781759567867 , 0.00251192725072 , -0.00295022755477 , -0.00417105092617 , 0.00039605503506 , 0.00461067935685 , 0.0044845873589 , 0.000291559148961 , -0.00159134875899 , -0.00118016386495 , 0.00159102759961 , -0.000732777256278 , 0.00055915649482 , 0.00193161405548 , -5.5815391057e-05 , -0.00492800612198 , 0.00303144022751 , -0.000198017303931 , -0.00100401389039 , -0.00140716302579 , -0.00362987903156 , 0.00116200365034 , 0.000109875181067 , 0.00168646742853 , 0.000507987870845 , 0.00222646654853 , 0.00375618045374 , -0.00490481325873 , 0.00161534326667 , 0.00166171500478 , 0.00296236668096 , 0.00326671339744 , 0.00468445037887 , 0.0022492201952 , -0.0016875402156 , -0.00299448917409 , 0.00148736782145 , -0.00375099869564 , 0.00247183617875 , -0.000122283804161 , 0.00389456371076 , 0.00408106150086 , -0.00409588955766 , 0.00189579150058 , 3.50996332054e-05 , 0.00166138026305 , 0.00107247980342 , 0.0016300865354 , 0.00296175584773 , -0.0033013952448 , -0.00272502509023 , 0.00388960535874 , -0.0023782446048 , 0.000978689784818 , 0.00225051074909 , 0.000179327577126 , -0.00407354186334 , -0.00305118642151 , 0.000163231622555 , 0.00292096540986 , 0.00466816099176 , 0.00426066044076 , 0.000688638007815 , 0.00106054628419 , -0.000831436322876 , -0.000164863838927 , -0.00383245407184 , -0.000140429510393 , -0.000851713793798 , 0.00320966440013 , 0.0058334939174 , 0.00241887670234 , 0.00472056812091 , -0.000286616049317 , 0.0015760760559 , 0.00166978370104 , -0.00214870932502 , 0.00065712937843 , -0.00517111841491 , -0.00170405949076 , 0.0035074426179 , -0.000277511573099 , 0.00274345590521 , -0.000953095337196 , -0.00153137981547 , -0.00207129948006 , 0.00352475471704 , -0.00290864268395 , -0.00155923659731 , -0.00112841214092 , 0.000276170756321 , -0.00163089216417 , 0.0041145884388 , 0.00318232638168 , -0.00517402261541 , 0.00297818595386 , -0.00409128952752 , -0.00372690205976 , 0.00444247722209 , -0.00400744130546 , 0.00117280590793 , 0.000300233933976 , 0.0040377836407 , -0.00304163951679 , 0.00294842486457 , 0.00211019762655 , -0.000799690414374 , 0.00231253757735 , -0.0036440648229 , 0.00361530793015 , -0.00185662708922 , -0.00337679981542 , 0.000257574956525 , 0.00446399319137 , 0.00076522040673 , -0.00533792728053 , 0.00162591690606 , -0.0046752644037 , -0.00340213483196 , -0.00232349187201 , -0.00372066141175 , 0.000916917913792 , 0.000328137323589 , -0.000235860782108 , -0.00187173209645 , -0.00430336197296 , -0.00224288796286 , -0.00164781111889 , -0.00505252132971 , 0.00450966643289 , -0.00241073210704 , -0.00193346852713 , 0.000564330068935 , 0.00411617536234 , -0.00233956889609 , -0.00124995734802 , -0.00340913557477 , -0.0032657092526 , 0.00233924429119 , -0.003210939146 , -0.00272189441131 , -4.93995504363e-05 , -0.00390333697792 , 0.00467110618588 , 0.00506221464363 , 0.00190854553978 , -0.00121817800418 , -0.00313170970426 , -0.00327684279296 , 0.00463966239102 , -0.00238578021913 , 0.00544355343343 , -0.00274070384834 , -0.00162031866521 , -0.00455570499219 , -0.00616623026697 , -0.00230741243576 , -0.0030026557312 , 0.00369439835977 , 0.00192315193726 , 0.00326711742658 , 0.000217899376371 , 0.00328075369556 , 0.00385936172949 , -0.00454287235272 , -0.00264323912958 , 0.00442829196854 , -0.00489970243983 , -0.00111787446567 , -0.0037850548289 , 0.00409853443834 , -0.00130957147142 , 0.00334283358875 , -0.00169566528606 , -0.00156000981434 , -0.000649161322078 , -0.00132939772465 , -0.0022386204742 , 0.00115531958978 , 0.00206644517897 , -0.000930540473192 , -0.000333174802351 , -0.00361664264914 , -0.000438757844101 , -0.000661261847556 , 0.000453835987616 , -0.000350260708015 , 0.00324676850885 , -0.00542537690859 , -0.00470200474964 , -0.00412217786868 , -0.000713350459215 , 0.00343963887946 , 0.00184331031163 , 0.00215848314319 , 0.0037856569701 , 0.00268569022862 , 0.00126715669152 , 0.00194892954843 , 0.00250185023409 , -0.00270072030762 , -0.00105945258381 , 0.000323684933595 , 0.00311807231592 , 0.00305137452523 , 0.00534041647735 , -0.000768338871865 , -5.829592905e-05 , -0.00129017024438 , -0.000365617427237 , 0.00362434075108 , 0.00154488046689 , 0.00232531718067 , -0.0018758311752 , 0.00126449212383 , 0.00196584154687 , -0.00454152477643 , 0.00110976238772 , 0.00135428258388 , 0.00228507003194 , -0.0014778900748 , -0.000115718893981 , 0.00442004221372 , -0.000658357537144 , -0.00012221540998 , 0.00471593242139 , -0.00167275029471 , -0.00399624343067 , 0.00331694377088 , -0.000141229132924 , 0.000485077383275 , 0.00367572263405 , -5.69163203027e-05 , 0.000702550043148 , -0.00134000570153 , -0.00160280950339 , 0.00365350530873 , 0.000584407821 , 0.00554818334685 , 0.00375595178624 , 0.001517394476 , -0.00259792932229 , 0.00417093008528 , -0.00303271986195 , -0.00128004805312 , 0.000576647744135 , 0.00331003764678 , 0.00326364054608 , 0.00368202903961 , 0.00163267071653 , 0.0037813999646 , 0.00446230041837 , -0.00433588496117 , 0.0031650190622 , -0.00142389398519 , -0.00270100969052 , -0.00156782296187 , 0.000214897810616 , -0.00120531218275 , 0.00434723975418 , -0.00535150058408 , 0.000896806264508 , 0.00300915897825 , 0.0020901130941 , 0.002512371648 , 0.00127654055435 , 0.000357236257836 , 0.00403609338577 , -0.001613528282 , 0.00395579914223 , 0.00127188746687 , -0.000857188536291 , 0.00225963846964 , 0.00534271633687 , -0.000534160408455 , -0.00392770437894 , -0.00128713627476 , -0.00340801833634 , 0.000795464887974 , -0.003025683604 , 0.00290553313593 , -0.00475907327718 , -0.00489061066865 , -0.0041499847263 , -0.00146918384596 , -0.00251790558433 , 0.00128757950336 , -0.00447324368695 , -0.0021438071449 , 0.00389153782083 , 0.00367720336586 , -0.00179129336755 , -0.00197853315898 , -0.000943608813629 , -0.000194891709289 , -0.0043631235546 , 0.00514155589667 , -0.00261374463754 , 0.00334924807716 , 0.00237043765788 , -0.00401980368886 , -0.000783808661195 , 0.00338696188582 , 0.00226327402596 , 0.000540127201277 , 0.00049900937884 , 3.73261379867e-05 , 0.000823671764588 , -0.00394550342373 , -0.00299646562712 , 0.00131721399409 , -0.00201365800719 , 0.00160702960803 , -0.00377321185576 , -0.00369534264583 , -0.000450591256971 , 0.00383049281415 , -0.00493320514792 , -0.0035501869881 , 0.00248949878841 , 0.00112866736173 , -0.00120073799251 , -0.0018596325034 , -0.00376591253338 , -0.00137767024437 , -0.00348494055139 , -0.00187819680202 , -0.00105950506434 , 0.0035199711919 , 0.00326583398777 , -0.0036532824298 , 0.00348688216185 , -0.000892240981898 , -0.00311446583262 , -0.00131761673913 , 0.000449300242082 , 0.000456458046655 , 0.000548921950067 , 0.000163502980758 , -0.00173265731063 , -0.0032953283496 , -0.000939487244496 , 0.000103561693001 , -0.00475092751498 , 0.000821510362281 , -0.0015473345206 , 0.00182426787206 , -0.00197420439483 , 0.00558896375925 , 9.52640924227e-05 , 0.000233433504678 , -0.00466544404121 , 0.00137090336087 , 0.00287428476938 , -6.6995903318e-05 , 0.0033160787947 , -0.00418687195219 , 0.00489327233954 , -0.00322561092715 , -0.00202748982388 , -0.00270312276916 , 0.00475167287308 , -0.000937534469263 , -0.00239065248525 , -0.00132745578947 , 0.00244618843291 , -0.00165745668238 , -0.00280922450076 , 0.000549279932995 , 0.000198959880745 , 6.68288645044e-05 , -0.00266811784488 , -0.00394726931404 , -0.000184032553363 , -0.000887407586309 , -0.00158289202678 , -0.00100290322274 , -0.00409619354509 , 0.00188183716942 , -0.0045712395401 , -0.00412723898839 , -0.00378319119914 , -0.00293015187461 , 0.00102272104251 , 0.00277100382149 , -0.0018083742621 , -0.00259775514648 , -0.00221645408758 , 0.00349598132691 , 0.0055261346523 , 0.000660121059665 , 0.00499996531574 , 0.0058122487467 , 0.00480683912857 , 0.00269039685481 , 0.00401600292746 , -0.00321639652382 , 0.00211543489205 , 0.00095693247775 , 0.00013789178815 , -0.000368081351229 , -0.00179716989192 , 0.000864996958476 , -0.00422304034574 , 0.00173666257605 , -0.000267129765486 , -0.00360908544843 , 0.00129812181391 , 0.00273688077902 , 0.00241219613325 , 0.00224169450116 , -0.00310478915475 , -0.00223032215832 , 0.0024041866542 , 0.00390467910636 , 0.000694391655 , 0.00377947284786 , -0.00213428068894 , 0.00120978263876 , -0.00268548986391 , -0.000807139107781 , -9.56367972163e-05 , -0.00120810045269 , 0.000453838486869 , 0.00336564590286 , -0.000984724023781 , -0.00111671056668 , -0.00299727897997 , -0.00222897743742 , 0.0029147265597 , -0.000684766154441 , -0.00316770312498 , -0.00087774341429 , 0.00456952679577 , 0.00190965883046 , 0.00102459685948 , 8.93579320295e-05 , 0.000554470493385 , 0.00305750076286 , -0.000701923321584 , -0.000623640229532 , -0.00123031232583 , -0.0050530128618 , -0.000849936746376 , -0.000626822568707 , 0.00167615416361 , -0.00152794614814 , -0.0017729856414 , -0.00276169339412 , -0.00202298959071 , 0.000294051937893 , 0.000838593578029 , -0.0037955209632 , 0.00288184245365 , 0.00302044686923 , -0.000733577126636 , 0.0053387630736 , -0.000912949219876 , -0.000914650081919 , -0.00193647724469 , -0.000915506002345 , 0.000787570358993 , -0.0043247416489 , -0.00312690517817 , -0.00418560095555 , -0.00243115332325 , -0.00433794746271 , 0.00171781014691 , -0.00375555356083 , -0.0028705830987 , 0.00161409086329 , -0.00236401061023 , 0.00179134586397 , -0.00254975401373 , 0.00417374191016 , -0.00182164998 , 0.00186604692465 , -0.000704199786142 , 0.00129128999116 , -0.00551000971454 , -0.00246496113276 , 0.00264028974807 , 0.000294677886366 , -0.00228574358742 , -0.00405759715182 , 0.00033250330416 , 0.00297462060622 , 0.00429198908226 , 0.00160178349525 , -0.00670901617939 , -0.00151312631527 , 0.00140606771602 , -0.00249965169573 , 0.00397364644378 , -0.00353098938061 , 0.000955214226546 , 0.00450747207082 , -0.00358709762747 , 0.0033536136637 , -0.00157166434012 , -0.00202287608297 , 0.000931744139791 , -0.00340264473945 , -0.000918846100251 , -0.00138936532778 , -0.00293371048561 , -0.00113335392199 , -0.00582559068762 , -0.00183029420355 , -0.00517272423523 , 0.0011094506563 , -0.00239124833332 , 0.00475516147087 , -0.00196048201871 , -0.00489031590647 , -0.00538312812945 , -0.000314921393366 , 0.000784703047011 , -0.00365901032333 , -0.000559332121006 , -0.00314199486993 , -0.000517464076129 , 0.00363203446466 , -3.96605170726e-05 , -0.000151385144778 , 0.00508975890167 , -0.00296380520067 , 0.00301180945706 , 0.000588229958076 , 0.00223437619293 , 0.000257464826077 , 0.00409540434732 , -0.00485408651503 , -0.00494036695338 , 0.00139465641393 , -0.00183475646553 , 0.00493595849114 , -0.00332402460573 , 0.00387039304175 , -0.000134167929257 , -0.00306536365232 , 0.000536294011947 , -0.00383735359342 , -0.00323014965299 , 0.00179698345646 , -0.00332118376677 , 0.00561440219014 , 0.00252368096771 , 0.00169183555506 , -0.000724457365693 , -0.00428900852198 , 0.0045747965202 , 0.00471094107487 , 0.00262594758463 , 0.00343537311228 , -0.00156590107178 , -0.00235776724383 , -0.00226950197738 , -0.00284803173991 , -0.000864781317683 , 0.00420448657823 , -0.00204228952511 , -0.003449213695 , -0.00310801895224 , -0.00197809047465 , 0.00301074541113 , 0.00340765126901 , -0.00342716347497 , 0.00214469866035 , 0.00212948329729 , -0.00154540595741 , 0.00228574071761 , -0.00477226860835 , 0.000502582622491 , -0.000336826909346 , -0.000672497337004 , -0.00580994009035 , ])
Y_1_1_imag = flex.double( [ -0.0 , -0.0 , 0.000884564522452 , -0.00363308584867 , -0.00433398055058 , 0.00398442987606 , -0.00428635447108 , 0.000515774811416 , 0.00227825215456 , -0.00567455309773 , 0.000588315670384 , 0.00181529214046 , 0.00180252408612 , -0.00220234640427 , 0.000893394719706 , 0.00183042969677 , 0.00626722908574 , -0.00113082233474 , -0.00427360219726 , 0.000235706308755 , -0.00058755398208 , -0.00128812081955 , 0.00371435986776 , -0.000385751342159 , -0.00239547155966 , 0.00139114353179 , 0.000151999771847 , 0.00350037968214 , 0.00383073062791 , -0.000651170218941 , 0.0025118537058 , -0.00470781480752 , -0.00577771556415 , 0.00263117527347 , -0.00340719099128 , -0.00086847243902 , -0.000501606661772 , 0.000207150945046 , -0.00466135087142 , 0.00120089964061 , -0.00221355888301 , -0.00105129397692 , 0.00104287494105 , 0.000376576371338 , 0.000174489764966 , -0.00193177958667 , -0.000370770746874 , -0.000696195565079 , 0.00223186337395 , -0.00119683952213 , 0.0032299337826 , 0.000204028689843 , -0.00497832076112 , -0.00574277718067 , -0.00421411474521 , -0.00156868193179 , 0.000578302735908 , -0.00390928460982 , 0.000737652808204 , -0.00496816079058 , -0.000702480815075 , -0.00218286429147 , 0.00116940462007 , 0.00222302511952 , 0.00298022161882 , 0.00220488817248 , 0.00161141969751 , 0.00476470204248 , -0.00136602512132 , 0.000997275452131 , 0.00082571717705 , -0.00238798423178 , -0.000810762451891 , -0.0023670963106 , -0.00094522688891 , -0.0018158512341 , 0.00189831426912 , 0.0021808268237 , -4.34472771083e-06 , 0.00154507081986 , -0.00184845239003 , 0.00161571195831 , 0.00399387312259 , -0.000732825186984 , -0.00329597901769 , -0.002173077391 , -0.0015739704385 , 0.00245824986778 , -0.000113346625462 , -0.00194472298808 , -0.00147472208694 , -0.00244766900319 , 0.00389819986139 , -0.00240954801897 , -0.00222862901043 , -0.00332040526229 , -0.00236359002144 , 0.00360688710407 , -0.00271542899329 , 0.00130974947009 , 0.000352961197168 , -0.00239874505228 , 0.00276717257621 , -0.000260577191913 , 0.00251304696162 , -0.00388917772918 , 0.00349881413256 , -0.00442864385276 , -0.00471891597821 , -0.000778665065247 , -0.00134948474463 , 0.000703357564162 , -0.00373835111261 , 0.00226246244065 , -0.000724715589903 , -0.00205403471783 , -0.000477319200833 , 0.00101539961175 , -0.00226274422512 , -0.000790111280716 , -0.000107350206199 , -0.00385321841708 , -0.00403649381381 , 0.000284510378114 , 0.00231971708217 , 0.00245678997067 , 0.00194132691806 , 0.000993016493601 , 0.00471491733471 , -0.000162548892065 , -0.00299169869764 , 0.000759103979618 , 0.00352490993325 , 0.000212663744664 , 0.00173264934915 , -0.00112937625712 , -0.00379458127314 , 0.00224633529245 , 0.000683277241055 , -0.00275458731136 , 0.00311467091104 , 0.00495827178578 , 0.00168491087891 , -0.00165821601915 , -0.00141988482602 , -0.000145947692071 , -0.00156358952883 , -0.00212926289757 , 0.00163215961636 , 0.00054908732046 , -0.00299449484552 , 0.00322392257145 , -0.00391759633716 , 0.00352385325934 , -0.00218901412771 , -0.00250903260591 , 0.000652956890142 , -0.00274885706743 , -0.00384795611748 , -0.00333746542384 , -0.00371453931433 , -0.00104758128416 , 0.000123199229578 , -0.00544487831493 , -0.00436331373927 , 0.00422798587517 , 0.00564881053372 , 0.00347282828073 , -0.00480737593303 , -0.000557331011728 , -0.000779390736711 , 4.11945628725e-06 , 0.00300446561863 , 0.00194897353492 , -0.00170486970036 , 0.000294279965383 , -0.00664105645396 , 0.000765955697534 , 0.00154426929592 , -0.0018078750479 , -0.00236625932529 , 0.00299172124257 , 0.00555035490771 , -0.000299316593286 , 0.000389507397061 , 0.000560966033942 , 0.000631349388283 , -0.0038678025066 , -0.00588894167276 , -0.00156162101472 , 0.00311194926693 , 0.00224139770593 , 3.94791634611e-05 , 0.00040297599796 , -0.00287394448048 , 0.00278730932477 , 0.000231660542544 , -0.00206660825489 , -0.00270545707729 , -0.00086283909858 , -0.00516945559832 , -0.00254624262565 , 0.00160577088492 , -0.00475339421665 , -0.000484699669458 , 0.000978864156874 , 0.00301186528156 , 0.00228006267534 , -0.00462536794594 , 0.000621124609384 , 0.00153714644006 , 0.00212979407503 , -0.000272843056121 , 0.00111657958297 , -0.00200250416499 , 0.00473178626037 , 0.00132609531198 , -0.00322279831257 , -0.00259828636523 , 0.000204661996084 , -0.00161848376373 , -0.00192014359763 , 0.00319333463141 , 0.00265524001275 , 0.00419549626548 , 0.00342660620131 , 0.000589535186629 , -0.00256184282837 , 0.00631307563246 , 0.00225150844889 , -0.00050401983973 , -0.00617395375159 , 0.00387606158495 , -0.00250277559632 , 0.000123091330694 , -0.0051865047046 , -0.00205008158709 , -0.00329763329931 , 0.000869769324626 , 0.00405791134732 , 0.00336869414799 , 0.00330907769203 , -0.00520328714466 , -0.00227669542141 , -0.00254035180699 , -0.00247390784499 , 0.00438933838755 , 0.00331669896816 , -0.00571449786848 , 0.00423496082813 , 6.9585285404e-06 , -0.00223683051554 , -0.00145593147058 , -0.00198713362314 , -0.00116223433347 , 0.000304974249627 , -0.000186147972972 , 0.00350005434442 , 0.000807101808107 , 0.00310801282364 , 0.00224710493551 , -0.000762898640154 , 0.00309387561725 , 0.0043385390349 , -0.000811891927865 , -0.00344538025355 , -0.0031888887168 , -0.00149218658293 , 0.00314153578736 , -0.00374647269704 , 0.00127492046485 , -0.00168780162194 , 0.00289007255821 , 0.000153195620394 , 0.00449742592778 , 0.00198632240467 , 0.004702515914 , 0.00272910985459 , -0.00161058692334 , -0.00289502619986 , -0.00498643069431 , 0.0033615426941 , 0.000834605439789 , -0.00304075873441 , -0.00525405794816 , -0.00424750934254 , -0.00201466425182 , 0.00316920895877 , -0.00615971747465 , 0.00134811300969 , 0.00272636718328 , 0.00209704101038 , -0.00309238964825 , -0.00554388067389 , 0.00601764894232 , 0.00115358705485 , 0.00397344816376 , -0.00421456482552 , 0.0011649644795 , -0.000116937911296 , -0.00102886513855 , -0.00287995752186 , -0.000856565313209 , 0.00647242498433 , -0.00181414638698 , 0.00161227502687 , 0.00235460086018 , -0.00138542218849 , -0.00148313581066 , -0.00511984017202 , 0.0061720438995 , 0.00351141813122 , -0.00141275041068 , -0.00378409185061 , -0.0063802600714 , -0.00360771676012 , -0.00405996279413 , 0.00291376372837 , -0.00266439979213 , -0.00303421920886 , -0.00533130828115 , 0.00153472322342 , -0.00522378904583 , 0.00382607252768 , 0.000767727877541 , 0.00269528778391 , -0.00197000420987 , -0.00231287074522 , -0.00141425938812 , 0.00222334872321 , 0.000370676154014 , 0.00245888194389 , 0.00314052183394 , 0.00134711150724 , 0.00164979693535 , 0.00709330365768 , -0.00390828392263 , 0.00267467808403 , 0.0041479483864 , -0.00107374217032 , 0.00440444172979 , -0.00172926105185 , 0.00290137059922 , 0.00246310996351 , 0.00126901728465 , 0.000202171219206 , 0.00437239447484 , 0.00348460120716 , 0.00539506614758 , -0.00293851411196 , -0.000426646514223 , -0.00489719563146 , -0.00243921861557 , -0.00225885227539 , -0.00438590156473 , -0.0016103563342 , -0.0036585070253 , -0.00549884297302 , -0.00327128607112 , -0.00588723637643 , 0.00562843892489 , 0.000536151313446 , -0.000355348661593 , -0.000954139462155 , -0.00163777233017 , 0.00229514672735 , -0.00368529598247 , 0.000137261190729 , 0.00236765878904 , 0.00505991137049 , 0.000749793118873 , 0.00443871323959 , -0.00063721276747 , -0.00496916751063 , -0.0014378150462 , -0.00522253675209 , 0.00326295825036 , 0.00435745349839 , -0.00260041548759 , -0.000815393079726 , -0.000754199741099 , -0.0045716873173 , -0.00239244879595 , 0.00209258802408 , -0.00235600151914 , -0.00111379472147 , 0.00392416466837 , 0.00402403791862 , -0.00331799369299 , 0.00498638351868 , -0.00449677358497 , 0.00469238517326 , -0.00287421550161 , 0.00123757640706 , 0.00360370808478 , 0.00294163977734 , 0.00403908078735 , 0.00245641565235 , -0.00312814744116 , 0.00437883921297 , -0.00144758092986 , 0.00314439745305 , 3.77317221336e-06 , -0.00187362875242 , 0.00461667390416 , -0.00163571333729 , -0.000284521057999 , -0.000816632589723 , 0.00158948205541 , 0.000761760695296 , -0.00275422801897 , 0.0046294053564 , -0.00450110133475 , -0.00643439541926 , 0.00207503421836 , 1.62001076137e-05 , -0.00302787079634 , 0.00156972801801 , 0.00254174002477 , 0.000471246240247 , -0.00232689097647 , 0.00429913181564 , 0.00396322987879 , -0.00355765621927 , -0.00644005626338 , 0.000107282157842 , 0.00309435655294 , -0.00201018899818 , -0.00300299529318 , 0.00327957172206 , -0.00239557233779 , 0.00122450820845 , 0.00220890187031 , 0.00496500094116 , 0.00419649365045 , 0.00247946948045 , 0.00154083166644 , 0.000243629687945 , 0.00230605565212 , 0.000467958846022 , 0.00122908783457 , 0.000553938331614 , 0.000536754275526 , -0.00380624009426 , -0.00360263140476 , -0.00151855348131 , -0.00218072474976 , -0.00298744331832 , -0.00134233868036 , -9.24189320081e-05 , -0.00190918010138 , 0.00145827366977 , -0.00102056324195 , -0.000339041071172 , 0.00118060168881 , 0.00284667568548 , 0.0037172194371 , 0.00328121539791 , -0.00341311347401 , -0.00150343697071 , -0.00347237715045 , 0.00340896971404 , 0.0019589033179 , -0.00163405983368 , 0.00402018112691 , -0.00239801897702 , 6.40359850714e-05 , -0.00101662305037 , -0.000972156310957 , 0.00647968517291 , 0.000605968231894 , 0.00190788032554 , 0.000226114585497 , 0.0051680949393 , -0.000280003926955 , -0.00243149504392 , -0.00365574622811 , 0.00258682805539 , 0.00137550442111 , -0.00362115918576 , -0.00280180359744 , -0.000410939382268 , -0.000930699608312 , 0.00264063685659 , -0.000257142463801 , 0.000600760768875 , 0.00129967470608 , 0.00202235596561 , -0.00365644216361 , 0.00367597181696 , 0.00203101500091 , 0.00525384359153 , 0.000913839987346 , 0.00322835703139 , -0.00220202948319 , 0.00240247477167 , -0.0023430054698 , 0.00162320370817 , -0.00288499064331 , 0.00394416679211 , 0.00209841186878 , -0.00218281215806 , -0.0022671769299 , 0.00479693505635 , 0.00334740696926 , 0.000122340397277 , 0.00349903942228 , 0.00291128765268 , 0.00292490713319 , 0.00316887612938 , -0.00386979036136 , -0.00259903746376 , -0.000171825297649 , -0.00071237386302 , 0.00300194561208 , -0.00524664314398 , -0.0033738710822 , 0.00341087007986 , 0.00116927671885 , 0.00557943256839 , -0.00368412065426 , 0.00681805621784 , -0.00302959130885 , -0.00266858557495 , 0.000572007108486 , 0.00126369129141 , 0.00223699685794 , -0.00159206831534 , 0.00275450495825 , -4.78174404087e-05 , -0.00146750265018 , -0.000478293984748 , 0.00401664056289 , 0.00054459165634 , 0.00347489082356 , 0.00240917636878 , 0.00137843308989 , -0.00126014388224 , -0.00318142761214 , 0.000932157354346 , -0.00246057985955 , 0.00241964798686 , -0.00412452496229 , 0.00489263426135 , 0.00189919946433 , 0.00181055391153 , -0.00156835986591 , -0.000157912853117 , -0.000531244850958 , -0.00571403738319 , -0.00118404607859 , -0.00120988058313 , 0.000969095155525 , -0.000231533937031 , -0.000489278571387 , 0.00416782910688 , 0.000235839816921 , 0.00379061550077 , -0.00144297399306 , -0.00111634516556 , 0.000595282283287 , 0.000654461605843 , 0.000324456712299 , -0.00053127523438 , -0.00502306099232 , 0.00104977741881 , 0.00350705301065 , -0.00278210721117 , 0.00404038363883 , 0.00183546980571 , 0.00438486158226 , -0.000983832169097 , 0.00386577408658 , -0.00189058968925 , -0.00163510535562 , -0.000905760433673 , 0.00410828265233 , 0.00225234070184 , 0.00159296604476 , -0.00200531913152 , 0.00388765546138 , 0.00309978185708 , -0.004514704782 , -0.00183150266998 , 0.00373931650794 , 0.0046242510913 , 0.00465580868661 , 0.00107583695433 , 0.00144072369763 , 0.00309832405165 , -0.000528085136531 , 0.00347657077847 , 4.07444855259e-05 , -0.00427703326704 , -0.00554326764922 , 0.000185223543895 , 0.000991153995592 , 0.00312015895656 , 7.3194054176e-05 , 0.00169502507776 , -0.00352526620744 , 0.00701367631505 , -0.00389868054851 , -0.00344396056529 , 0.000304715635626 , 0.00259355050445 , 0.00404181618656 , 0.00125070727634 , -0.00205717474085 , -0.00154430008947 , 0.00330946687369 , -0.00354289018352 , -4.23772490468e-05 , -0.0030057550234 , -0.00206689632616 , -0.00432913464482 , -0.00137166649092 , -0.00126658308119 , 0.00177958959016 , 0.00343454579338 , -0.00320644635397 , 0.00103750501945 , -0.00282611106662 , 0.00352444413281 , -0.000892484350612 , -0.00374619405172 , -0.0026187797534 , 0.00182714600259 , -0.00487520856924 , -0.000570312792195 , 0.00260842558474 , -0.00277314441194 , 0.00360019960292 , 0.000188780681342 , 0.0042764669493 , -0.00430596885282 , -0.00295824755786 , -0.000859632591282 , -0.00525557701553 , 0.00385763596207 , 0.00546607038036 , -0.00348187478108 , -0.000400382783365 , -0.000315811165385 , 0.00400317896854 , 0.00139228653879 , 0.00162631931999 , -0.00484352902492 , -0.00213606559778 , -0.00069540207545 , -0.00366689988078 , -0.00134112925529 , 0.00435031938478 , -0.00188562921924 , 0.00161397269216 , 0.00232559062358 , -0.00247184166803 , 0.0017894883047 , -0.00187057116192 , 0.00411010451731 , 0.000796039435347 , -0.000952868524129 , 0.0012351553204 , -0.0039531418576 , 0.0015800684942 , 0.000796858498631 , 0.00270315108936 , 0.00122882996112 , 0.000655286089958 , -0.00199355985139 , 0.00176732786967 , 0.00031810181685 , 0.00212574130031 , 0.00290864481806 , -0.00142043994057 , -0.00449005461398 , -0.0022168373058 , 0.00647567636292 , -0.00244797793732 , -0.000273394034135 , -0.00192416283868 , -0.00403710563927 , -0.0020805905981 , 0.00134640579567 , -0.00291816158186 , -0.00290425510964 , 0.00134736559714 , 0.00520980455831 , 0.00139353471554 , 0.00312885543153 , -0.0017868329073 , -0.00333585758704 , -0.00108430727869 , -0.0063267219934 , 0.000931305727169 , -0.00136251222517 , -0.00437224338436 , 0.00674126664705 , -0.00216795568238 , -0.00441891085841 , 0.000962808785413 , -0.0047913297649 , -0.00130261283896 , -0.00133952948389 , 0.0003252556502 , 0.00103914579673 , 0.000528826115259 , -0.00457740397594 , -0.00411564795033 , 0.00349445854738 , 0.00314357255616 , -0.00229608315494 , 0.00193503300628 , 0.00380752321194 , -0.00128061809958 , 0.00160903262165 , -0.0031878680097 , -0.00545891677419 , -0.0022295042019 , 0.00257994933406 , 0.00290493833479 , 0.00367545949235 , 0.0042192645893 , -0.00182081891083 , -0.00133781683854 , -0.00410186838506 , -0.00257996651251 , 0.00436959354645 , 0.00026891428373 , 0.00161076748652 , 0.00086319315134 , 0.00347009283572 , 0.00077794883144 , 0.00291011127776 , -0.000456363347925 , 0.00076230462743 , 0.0014462576978 , -0.00193266660419 , -0.00081288044289 , 0.00298712621669 , 0.00439356631173 , 0.00324904144331 , 0.000311127216152 , -0.00365989878222 , -0.00277254078791 , 0.00236100147541 , -0.000534197036394 , 0.00213970741554 , -0.00178859880811 , -0.00039455585702 , -0.000432776408674 , -0.00095534519662 , 0.00291235449058 , -0.000523952254594 , 0.000871307737195 , -0.000779116871677 , -0.000175454980232 , 0.0032937248879 , -0.00281102229204 , -0.00269037849976 , 0.00101022400155 , 0.00505554311834 , 0.00376676908265 , -0.00241108797732 , 0.00354549824704 , -0.0024474656756 , 0.00144433003755 , -0.0049939532578 , 0.00657285137345 , 0.0014593396569 , -0.00434625152608 , 0.00403112826826 , -0.000896553450779 , 0.00694845638459 , 0.00228003206555 , -0.000555185658858 , -0.00145173716206 , 0.00583864907096 , 0.000865034636281 , -5.25531964789e-05 , 0.00391400436343 , 0.000450960380271 , 0.00259475774167 , 0.000176569013029 , -0.00201376346881 , -0.0011780475409 , -0.00378894231989 , 0.00103352684396 , -0.00367586784208 , 1.14127036175e-05 , 6.41588535214e-05 , 0.00279721555803 , -0.000804055446864 , 0.00156131209589 , 0.00383727868945 , 0.00117208815837 , -0.00162530958593 , -0.00124335102446 , 0.000893054833255 , -0.00107644327399 , 0.00230899162984 , -0.000282905823772 , -0.00328330667718 , 0.0026297713093 , 0.00100169830229 , 0.00165125983424 , -0.000923838604101 , 1.93870578496e-05 , -0.000723091096349 , 0.00236023155386 , -0.0015879872113 , -0.00394390727239 , 0.00328013768177 , -0.00332776268389 , -0.00097427783347 , -0.00291378993328 , 0.00195440096395 , -0.00219702365693 , -0.00197023174931 , -0.0024551050454 , 0.00127538336649 , -0.00339950224399 , 0.00170860542587 , 0.00148752965938 , -0.000507199993625 , -0.000384140789811 , -0.00599496927844 , -0.00301101435872 , 0.000582471614807 , -0.00247228601476 , 0.0042036731145 , -0.000699660020339 , 0.00150813584542 , 0.00559860865202 , -0.00165411938882 , -0.00239044513284 , -0.0037607788889 , -0.000305855762389 , -0.0027344360316 , 0.00113858102638 , -0.00444860385439 , -0.00227546108129 , 0.00188003302937 , 0.00207733349562 , 0.00358907769696 , -4.6788537645e-05 , 0.000854954002099 , 0.0052053931872 , 0.00303042674279 , -0.0019242737989 , -0.000556851957893 , 0.000504203086878 , 0.00170312860859 , 0.00023624118946 , -0.00347466125845 , 0.000779933314689 , -6.0478613917e-05 , -0.00171484832078 , -0.00507857664271 , -0.000937898325063 , -0.00299697615727 , 0.00011700993512 , 0.000301209306685 , -0.00418409869288 , -0.0047440754371 , -0.00296582192677 , 0.00133407646232 , 0.0021286583028 , -0.000380936724943 , 0.00251238572929 , 0.00542607930478 , -0.0027582719642 , -0.000133047837869 , 0.0033014646753 , -0.0010793490323 , 0.003406351203 , -0.00340080671421 , -7.59525769267e-06 , 0.00453131558561 , -0.000199563961393 , 0.00308080703366 , 0.00475234443287 , 0.00103603381943 , -0.00153746879426 , 0.00132602962007 , -0.000957099181125 , -0.00374602042133 , 0.00110750265308 , 0.00375958905958 , 0.00294852947002 , -0.00154531272716 , -0.00219644146198 , -0.00190695732282 , 0.00509526612154 , -0.00494090837954 , -0.00104595066556 , -0.0047635069272 , 0.00208503654076 , -0.00200573711378 , 0.000491523709115 , ])
Y_2_m2_real = flex.double( [ 0.0 , 0.00685479092299 , 0.00518101446982 , 0.00147858805192 , -0.00242103910923 , -0.00283329488707 , -0.00258809398258 , 0.00481990814078 , 0.00204870523564 , -0.00581663978558 , 0.00363553308154 , -0.000703892681732 , -0.000429660206315 , -0.0012569985153 , 0.000664720902947 , 0.000712476395264 , -0.00587554144103 , 0.00140292258014 , -0.00447241898348 , 0.000498085628716 , 0.00596870187934 , 0.00324683869027 , -0.0030243755028 , 0.00410958393852 , 0.00553632535403 , 0.002384736905 , 0.0024267149678 , -0.00373161692976 , -0.00312724688395 , 7.0676863572e-05 , -0.000445302559282 , -0.00470454441485 , -0.00644612223311 , 0.00142759075533 , -0.00307653390921 , 0.00442067525255 , 0.00547299486069 , -7.06418835626e-05 , -0.00322407286835 , 0.00232631018702 , 0.00218515134996 , 0.00428882209924 , 0.00181222826565 , 0.00320301916775 , 0.00349466708492 , 0.00313191041724 , 0.00398327134945 , 0.00488385741422 , 0.0026039921929 , 0.000495742063466 , -0.00356407549021 , 0.00305754399716 , -0.00226296715012 , -0.00634214882871 , -0.00152449029522 , -0.000921314909903 , 0.00045338128456 , 0.000189084255063 , 0.0020150723643 , -0.00357552136959 , 0.00599487448696 , 0.00397207553417 , 0.000115307142503 , -0.00122910374911 , -0.000448908531042 , 0.000505675813849 , 0.00257181502427 , 0.000489327786633 , -0.000973515081344 , 0.00346944785831 , 0.00380116497107 , 0.000535388802394 , 0.00543279026647 , -0.000523100951077 , -0.000223050303947 , 0.0014722782864 , -0.000347660034062 , 0.00473336889903 , -6.60270879344e-06 , -6.62588710873e-05 , 0.000140026108236 , 0.0042987174882 , -0.00105883403325 , 0.00374279829269 , 0.00181496614692 , 0.00289239066103 , -0.000438320391119 , -0.000773344582877 , 0.000980635360888 , 0.00130196164532 , 0.00218812170581 , -0.000755124206086 , -0.00235620800057 , -0.00171114842998 , -0.000773194541424 , -0.00275533068834 , -0.000711815006616 , -0.0022289126824 , -0.00214100975593 , 0.00153751138105 , 0.00275482497766 , -0.000267298810915 , -0.00215446962085 , 0.00425390715376 , 0.00191580466718 , 0.000542338941613 , -0.00355780801381 , -0.00474354051654 , -0.00318531144242 , -4.43618882686e-05 , 0.000141431117289 , 0.000738077020827 , -0.00149747339381 , -0.00061671170076 , 0.000328078764433 , -0.000591644075679 , 0.00461251609099 , 0.00294110131316 , -0.00142379293311 , 0.00213210776258 , 0.00226581503638 , -0.0042772176278 , -0.00212667841327 , 0.00139426083343 , 0.000843249726554 , 0.00243764342599 , 0.00478882443067 , -0.000112246060488 , -0.00249358268392 , 0.000644325226463 , 0.00161333747263 , 0.00553201662715 , -0.00392676900847 , 0.000528013075117 , -0.000738902831683 , 0.00423421727233 , -0.00181103717912 , 0.00186078531544 , 0.00470329345834 , -0.00217005369107 , -0.00148711683286 , -0.00495127611581 , 0.00150610250612 , 0.000462085516027 , 0.00626507197416 , 0.00396224256322 , 0.00276359708452 , 0.00255476400954 , -0.000977530840457 , 0.00316203578687 , -0.00142943216249 , -0.00301341326855 , -0.0026904007316 , -0.00378198235516 , 0.00181567976659 , -0.0013560698664 , 0.0037725689286 , -0.00066439124865 , -0.0010844441914 , -0.0033854104192 , -0.00322210773174 , -0.000211967084922 , 0.000571200436246 , -0.00448213085873 , -0.00397842937329 , -0.00314234495385 , -0.00371797838507 , -0.000118540188049 , -0.00285751018458 , 0.00107068019194 , 0.00315385436772 , -1.43116281544e-05 , -0.00175495012489 , 0.000177186584052 , -0.00068350282084 , 0.00137500161176 , -0.00637308575616 , 0.00313750843229 , 0.000821263279039 , -0.000832465014795 , 0.000298260336626 , -6.94951228253e-05 , -0.00409264929885 , 0.00223810756673 , 0.00416338678657 , 0.00063625621053 , 0.00184694687894 , -0.00138937689808 , -0.00465315452677 , -0.000338014185594 , -0.00234791209131 , -0.000473139178185 , -0.000130225604571 , 0.00499001369708 , 0.000636713065544 , -0.00155151857799 , 5.28783386055e-05 , -0.00064192905375 , -0.00187390624705 , 0.00592352317041 , -0.00534533262406 , -0.000184183381115 , 0.00271262846684 , -0.00460979499971 , 0.0012136736331 , -0.000245490585006 , -0.00306068252761 , -7.32359588659e-05 , 0.000203134814232 , 0.00366492821242 , 0.00135551793079 , -0.0011435499927 , 7.24733700715e-05 , 0.00365345446312 , 0.00194267046299 , -0.0025536891164 , 0.00363508648953 , -0.00275060779472 , -0.00233967064474 , 0.00302232119863 , 0.00443140059749 , 0.000675659868559 , 0.000859903590884 , 0.0021790213837 , -0.00296177039132 , -0.00355863132048 , 0.0037390312102 , 6.99097389822e-05 , -0.00695671881267 , -0.000668278990556 , 0.00511585138885 , -0.00561546531861 , 0.000291357208599 , 0.00165343061066 , 0.00569448439338 , -0.00567097726336 , -0.00136142032951 , -0.00152141797481 , -0.00044849543005 , -0.00116526957135 , -0.00254909617849 , -0.000256012811503 , -0.00411905099528 , -0.00167866423865 , -0.00240275697288 , -0.00150567649346 , -8.99410408016e-05 , -0.000128706728904 , -0.00615256657382 , -0.00362475549604 , 0.00118152472479 , -0.00236181665807 , 0.000373660753863 , 0.00329861133022 , 0.000155554211701 , 0.00550922281631 , 0.00575114384068 , -0.00376494372691 , 0.00323296123748 , -0.00225788670129 , -0.00116941388647 , 0.000816714206402 , -0.003009934877 , -0.00323702129358 , 0.00322911023189 , 0.00136734570766 , 0.000731780876561 , -0.000845172733308 , -0.00106644723188 , 0.000630138720063 , 0.00301982382416 , 0.00115768628177 , -0.00256585175253 , 0.00476024872562 , -0.00162609750285 , 0.000763708066344 , -0.00145220068435 , 0.00302742369636 , 0.00235394417055 , -0.0018078446065 , -0.00360879813952 , -0.00171604410227 , 0.00623313329779 , -0.00130962346331 , -0.0051466847495 , -0.00176433731424 , 0.00220477832916 , -0.00203581669188 , -0.00523617653374 , 0.00200713357028 , 0.00105155245756 , -0.00029452883802 , 0.00135544956554 , -0.00503643163515 , -0.00640224139441 , 0.00473562130506 , -0.00136560353315 , -0.00205436417613 , 0.00382142457545 , 0.0038841391728 , -0.000376796051413 , -0.00319786873618 , 0.00164111018784 , -0.00593687842346 , 0.000136212448851 , 0.00251375551852 , -9.17417295427e-05 , 0.00105688514316 , 0.00382689509335 , -0.00560466611789 , -0.00614671184932 , -0.00268814214851 , 0.00455311702248 , -0.00358489709274 , -0.0065361332151 , -0.00363937264811 , -0.00324186784483 , -0.00259156032832 , -0.00146618248365 , 0.00115730267233 , -0.00530097827873 , -0.000466486230112 , -0.00286304969216 , -0.00400062230552 , 0.00119585294308 , 0.000398154204106 , 0.00324233608353 , -0.00240875620885 , 0.00260232422702 , 0.00251227944637 , -1.11152306762e-05 , -0.00119259179888 , -0.00201944732422 , 0.00015564757899 , -0.000684620818142 , -0.0078405550673 , -0.00272422420747 , -0.00171717937259 , 0.00122253052309 , 0.00176330025952 , -0.00490518600288 , -0.000387860995006 , -0.00135325244094 , 0.00181152502831 , -0.000142162708392 , -8.57302179511e-05 , -0.00349305464976 , -0.0016886733572 , -0.00415446580345 , 0.000721256262926 , 0.00519405847446 , -0.00415524435898 , -0.00109707705185 , 0.000916906875548 , -0.00166636555211 , 0.00434727089325 , -0.00184806295646 , -0.0050444679364 , -0.00036567548712 , -0.00417778802106 , -0.00283539575064 , 0.000667583996215 , -4.29005428585e-05 , 0.00390992691295 , 0.00353244787315 , 0.00205446723578 , -0.00267618492902 , -3.13217888075e-05 , -0.000811538321712 , -0.00435258757316 , 0.000774085080941 , -0.00191768777438 , 0.00328515485667 , -0.00333478637557 , 0.00332717652189 , -0.00385174077934 , -0.00297619629117 , -0.00249994240528 , -0.00201803683317 , 0.0033532452531 , 0.00308397640921 , -0.0049792330114 , 0.00077660664065 , 0.00340204575316 , 0.0020831742575 , -0.000212829412763 , -0.00267622582622 , -0.0031434975352 , -0.00264265019318 , -0.00179053318645 , -0.00474650619681 , -0.00430055627017 , 0.000402516724036 , 0.00599648021652 , -0.000953732688881 , 0.002618830773 , -0.00264190501999 , -0.000748965784387 , -0.00219522581973 , -0.00321175376627 , -0.000829519719815 , 0.00301122945432 , 0.000785703537413 , 0.0019819779926 , -0.00395138333921 , 0.00103074262985 , 0.000230638886678 , 0.000502734024266 , 0.000621032063702 , 0.00352389003068 , 0.000243263549011 , -0.00414779569781 , -0.00413978092657 , -0.00699412979429 , -0.00031747205294 , 0.00330131055909 , 0.000200112150769 , 0.00495207599668 , 0.000687932829745 , 0.00445278176434 , 0.00179257277641 , 0.000203479777505 , 6.65528876231e-05 , -0.00306760262674 , -0.00645207112822 , 0.00402165353307 , -5.91835913612e-05 , 0.00129996724398 , -0.000856749999121 , -0.00193810134427 , -0.00012608401258 , 0.00342314107073 , 0.00196894766386 , -0.00439236622954 , -0.00117036426131 , -0.00132202119702 , 0.00405459332319 , 0.00013632969137 , 0.00442515466974 , 0.000597681704858 , 0.00383135614188 , 0.00275531449662 , 0.00166212833708 , -0.000132209308296 , -0.00214912999913 , -0.000591874878242 , -0.00170085415226 , -0.0016427689331 , 0.00372899852016 , 0.00131675944735 , -0.000314231671704 , 0.00475353465805 , 0.00406719860164 , 0.000920813111594 , 0.000797883209251 , -0.00175763434673 , 0.000492765982158 , -0.00109648653212 , -0.00303460013328 , 0.00202120636275 , -0.00032654690834 , -0.00166065155914 , 0.00113753563967 , 0.000937765409756 , -0.00442139566297 , 0.00206840954821 , 0.00445426822073 , 0.00531376016027 , 0.00059291741765 , -0.00647105953442 , 0.00163618806984 , 0.00162305583752 , 0.00427921725431 , -0.00406350072172 , 0.00569932621166 , 0.000347991775259 , -0.00298221853775 , 0.00254732699758 , 0.00639020174743 , -0.00201689626816 , 0.000268462496217 , 0.00334646602436 , 0.000763665779889 , 0.000838766153697 , -1.52916689496e-05 , 0.00280955678444 , 0.00244523895911 , 0.00356579159599 , -0.00154111811431 , 0.00117598589326 , 0.00390592733515 , -0.00545457576908 , 0.00260849988566 , 0.00119646973452 , -0.00121140482086 , 0.000910440061543 , -0.000885819637263 , -5.59325098312e-05 , -0.00291329753905 , -0.0036744267512 , 0.000136181003283 , -0.000838707565862 , -0.000217152043623 , -0.00483049114265 , -0.00337570056985 , 0.00372660038033 , -0.00317829655967 , -0.00293399110125 , -0.00236385341223 , -0.00230449477431 , -0.000849667587699 , 0.00421452082953 , 0.00419994530323 , 0.00386089129292 , -0.00200697690232 , -0.00275219142395 , -0.00184867549581 , -0.00190176683516 , 0.00252457035723 , -0.00427982230583 , -0.00266900711778 , -0.00672989202422 , -0.000735183244812 , 4.79848271278e-05 , 0.0002156132179 , -0.000915388176012 , 0.000986624725502 , 0.00191711054849 , 0.00388118644683 , 0.000207252956084 , -0.00138498847245 , 0.000723329978165 , -0.00429302939907 , 0.00390657733591 , -0.00269171524027 , -9.15435501033e-05 , 0.000756223765049 , 2.84579297947e-06 , -0.00182513849854 , 0.00474502072612 , -0.00128456351372 , -0.00157181955615 , -0.00263941390487 , -0.00462664858647 , -0.00144609882588 , 0.00380559338291 , -0.000499114610325 , -2.20263343657e-06 , 0.00493406655662 , -0.00557583037911 , 0.00327185064002 , 0.00205707641269 , -0.000397396666524 , 4.21120061491e-05 , 0.0030244982987 , -0.00344871825877 , 0.000318916241036 , -0.002632916948 , 0.000154624454842 , 0.00256553383462 , -1.20752904104e-05 , 0.00596031101824 , 0.00411412841152 , 0.000321114349417 , -0.00358213468397 , 0.00345203869035 , -0.000648910442643 , -0.00171664587126 , -0.00379992836221 , 0.00223866822275 , -0.00169530103952 , 0.00297180650221 , -0.00327108197657 , 0.00281643863379 , 0.00339649906016 , 0.00439936339754 , -0.00131942471219 , -0.00120235218607 , 0.00157633484447 , -0.00030524005724 , -0.00351505574722 , -0.00125732693711 , -0.00026416426703 , 0.0046701661139 , -0.00379578085696 , -0.00233431782674 , -0.00265847500349 , 0.0018761613354 , -0.000109612175611 , -0.00297291629573 , 0.00432797085913 , -0.00174449414052 , 0.00416053153296 , -0.00417806329729 , -0.00594092979027 , 0.00102669399931 , 0.00520345645637 , -0.0033371927948 , 0.00429639720516 , -0.000285793867817 , -0.000166209518309 , -0.00759438696332 , -0.00127040593148 , -0.000847377043109 , 0.00473632664622 , 0.00303560858476 , 0.000148442460644 , 0.000176502334003 , 0.000626417176516 , -0.000146684357893 , 0.00170494114311 , -0.0021412217251 , 0.00302199065705 , 0.0010278421626 , -0.000343500548054 , -0.00330981560358 , -0.000305883224482 , -0.000459871897537 , 0.00331054062982 , 0.0025304128155 , -0.000626525208788 , 0.00321955775495 , -0.000340021828675 , 0.000659882273305 , -5.67163599161e-05 , -0.000521561787679 , -0.000552197815417 , -0.00152400619534 , -0.00507984649235 , -9.19238323055e-05 , -0.00236663002221 , 0.00180993730642 , -0.00090472587177 , 0.000915942317056 , -0.00263889934781 , -0.00386208962992 , 0.00123173187842 , 0.00206101288649 , -0.00567469531282 , -4.07369266421e-05 , -0.000839683158383 , 0.00010580387492 , 0.00178753915197 , 0.000257992771035 , -0.00319794448729 , 0.000357284154268 , 0.00288974230068 , -0.00352032204405 , 0.00195524857159 , 0.000607169083209 , -0.00284184149472 , 0.00268954026407 , -0.00148994087359 , 0.00264238070127 , 0.00228375335428 , -0.000826315355057 , 0.000981457580664 , -0.000481937955238 , -0.000927798506659 , -0.00292854294869 , -8.14410291617e-05 , -0.000788708652248 , 0.000529842786303 , -0.00102990960151 , -0.000697806004247 , -0.000479100383224 , 0.0030671406347 , -0.000209248308398 , 0.00039208544846 , -0.000176870946331 , 0.000214019117978 , 0.00621791912613 , -0.00194413968125 , -0.00214113153401 , 0.00379562119911 , -0.00423644775569 , 0.000692329872117 , -0.00636210912601 , 0.00131448632053 , 0.00424781043981 , 0.00420866865748 , -0.00109520984157 , -7.58377766467e-05 , 0.00200906427817 , 0.00264628425717 , -0.00173541041071 , 0.00144256604905 , -0.00454924540431 , 0.000890811862268 , -0.00219760308043 , 0.000971237504282 , -0.00358023772462 , -0.00103316281505 , -0.00549732524632 , 0.00184343592661 , 0.00366342785376 , -0.00416119087728 , -0.0072754803422 , -0.000503034694994 , -0.00446316818379 , 0.00416027398325 , -0.00401471845003 , 0.00437328350577 , 0.00371882335424 , 0.00312945661889 , 0.00234461990355 , 0.000486762772638 , -0.00177160221172 , -0.00338443277875 , -0.00089119719149 , -0.00143613330957 , 0.00176477297904 , 0.00495865164185 , -0.00387462032029 , 0.00501394445509 , 0.00577946862543 , 0.00248545386575 , -0.00373006398961 , 0.00228462394901 , 0.000768314263255 , -0.00100353330328 , -0.00328387054572 , -0.00433714782593 , -0.00102132217313 , 0.00050213554623 , -0.00338316687696 , 0.00246715948443 , -0.00371875472651 , -2.90193472845e-07 , 0.00239667341486 , 0.000196927080702 , -0.00111325516194 , 0.00177362650621 , -0.000973626251062 , 0.00213638987337 , 0.00121873253399 , 0.000745669255735 , 0.00266065849507 , -2.37082021332e-05 , 0.000781655358345 , -0.00287700007194 , -0.00291377245572 , 0.00176204057354 , -0.00380152774064 , -0.001369990131 , -0.00136526025568 , -7.25579396394e-05 , 0.000844888610398 , -0.000785127799663 , 0.000452043237211 , 0.00276152041432 , 0.0011753308367 , 3.68058308308e-06 , 3.84745646558e-05 , 0.00287361772087 , 4.37246120077e-05 , 0.00301956602534 , -0.00192928746684 , -0.00206609725306 , -0.00238559775149 , -8.07157616349e-05 , -0.00293023182217 , -0.00297944503194 , -0.00157569272757 , -0.00290108690431 , 0.00324268843032 , -0.000494378681902 , -0.00429537068885 , -0.00650853043045 , 9.99881320223e-05 , -0.00268731932434 , -0.00163057208123 , 0.00160406622968 , -0.00744377658179 , -0.00105328903286 , 0.00331842032777 , 0.00150299947512 , -0.00423089402384 , -5.43164052187e-05 , 0.00582389377283 , -0.0036774216148 , 0.000127877221864 , -0.000570203856788 , 0.00017815361067 , -0.00167170920413 , 0.00304403603263 , -0.0010070732921 , 0.00331951961348 , -0.00141985832022 , 0.00420812260729 , 0.000988491079934 , 0.00132984220003 , 0.00159404295547 , 4.24821226715e-05 , -0.00221045236314 , 0.000765406967689 , 0.00107907903266 , 0.00407461535005 , 0.000687072604352 , 0.00040270667084 , -0.00149867363606 , 0.000465267036482 , 0.00331788400133 , -0.000259975209518 , 0.00178830031934 , -0.000594561813997 , 0.00176222473399 , 0.00353239275796 , -0.000251856936434 , 0.000897034724128 , 0.00348891933779 , -0.00250941012894 , 0.00512451307188 , -0.00158930019243 , 0.000211130109648 , -0.000620649009869 , 0.00295491773188 , 0.00205319739613 , -0.000823139070725 , 0.0030957752505 , 0.00329170223703 , -5.39933376758e-05 , -0.000172135636377 , 0.000338295512872 , 0.000399728959412 , 0.00270558422079 , -0.00613764309144 , -0.00130339750622 , 0.00153720065546 , -0.00189523226578 , 0.00251680896095 , 0.00125901518891 , 0.00468178438086 , -0.00471137966973 , 0.000959187602803 , 0.00344145792994 , -0.00233835792316 , 0.0051799708615 , 0.00371293719874 , -0.000327279485942 , -0.00430698662232 , 0.00212231021369 , -0.00102218472002 , 0.00097832229379 , -0.00381171205284 , 0.00395297023225 , -0.000171782627833 , -0.00504424359831 , 0.00274032418148 , 0.00107331105655 , 0.00180678589117 , 2.94633895914e-05 , 0.000602863469508 , 1.77432352973e-05 , 0.000914237426738 , 0.00490521889302 , 0.00551559746078 , -0.000260132129229 , -0.00453730361964 , 0.0038562533782 , 0.000513332860946 , 0.00187304122506 , -3.50698471019e-05 , -0.00174817884807 , -0.0044334829617 , 0.00135229245835 , 0.00177252286191 , -0.000516463020018 , 0.00363790727483 , 0.00454014924524 , -0.00362563301806 , -0.00116485822973 , 8.96897724326e-05 , 0.001456591248 , 0.00454226099241 , 0.00202830926979 , -0.00116723990126 , 0.0023630796963 , -0.00395768663608 , 0.00188470032603 , -0.0012680948648 , -0.00261638009145 , -5.92609958927e-05 , 0.00373579780944 , 0.000912324001836 , 0.00261268918811 , -0.000996815002493 , 0.00132217643037 , -0.000910336175599 , 0.000683336890519 , 0.00241244909481 , -6.7739394018e-05 , 0.00031030136558 , -0.0049498582796 , -0.00385881959449 , 0.0049240421715 , -0.00440605093693 , -0.00107898053876 , -0.000828099135184 , 0.00636750729228 , ])
Y_2_m2_imag = flex.double( [ -0.0 , -0.0 , -0.00194349267403 , -0.00636151163846 , -0.00480061983165 , -0.00239278317714 , 0.00497245926125 , -0.0011071953274 , -0.00344482100621 , 0.002849548649 , -0.00111948836452 , -0.000475055871853 , -0.000978752676014 , -0.0005820152276 , 0.000774842513641 , 0.00311991563177 , -0.00287927863907 , 0.00101369147228 , 0.00154457382003 , -0.000156172732108 , 0.00129210337143 , -0.0027054676029 , 0.00339383147443 , 0.000730111080402 , -0.00494039706457 , -0.00175074884221 , 0.000234100719635 , -0.000542982199395 , -0.000569938895233 , -0.000248789856383 , -0.000960819206569 , -0.000823708358265 , 0.000483151558314 , 0.00424872461887 , 0.00259927832617 , -0.00177423028481 , -0.00110097415123 , -8.13222992158e-05 , -0.000374787058026 , 0.00239856059246 , 0.00422760147586 , 0.00212370792064 , 0.00175540209859 , 0.000695670539199 , -0.000354027766176 , -0.00362272867877 , 0.000737198710555 , 0.00148596360715 , -0.0040545210757 , 0.00164498425074 , 2.21689331079e-05 , -0.000360393809392 , 0.00580779813152 , -0.00115713212703 , -0.0051633348613 , 2.95441375997e-05 , -0.000468905400003 , 0.00620344542893 , -0.000939306664716 , -0.00514714828557 , -0.0015520226663 , 0.00445417166613 , 0.000736849619801 , 0.00206182171369 , -0.00263916287804 , 0.00371308937072 , -0.00307836276576 , 0.00748276720508 , 0.00100616392141 , 0.00206403085658 , 0.00159131603044 , 0.00397210444073 , 0.00178757533481 , -0.00181773047769 , 7.20519571627e-05 , -0.00268839666603 , -0.00261962513683 , -0.00427821683503 , 1.33790421315e-06 , -0.00143760306232 , -0.00154400358442 , -0.0029324551872 , 0.00521469673668 , 0.00149207736363 , 0.00590379617228 , 0.004011481717 , 0.000154604256543 , 0.00328969923837 , -0.000117400387286 , 0.00281377208927 , 0.00236750539217 , 0.00112255984597 , -0.00160315191425 , 0.000270726125262 , 0.0020548935514 , -0.00208885333866 , 0.000572718233021 , 0.00410374335089 , -0.0020608906816 , 0.00178361544277 , 0.000646131100053 , 0.00338813531346 , 0.00145277388183 , 0.000581080693943 , -0.00466376448961 , 0.00570713124179 , -0.00148537452827 , -0.00152202282922 , -0.00374321076129 , 0.000237145877834 , -0.000900740391331 , 0.000777815730464 , 0.00497538896853 , 0.000292514581609 , -0.000463245881226 , 0.00224307956495 , 0.000965292700943 , -0.00191356212077 , -0.0017029522334 , -0.00115222402966 , 0.000185705091713 , -0.000238462562332 , 0.00118967505098 , -0.000421722012727 , -0.0033074148705 , -0.00462932643925 , 0.00400368555622 , 0.000459359147977 , -0.00571888914212 , 0.000234327436844 , 0.00459174714627 , -0.00155837537161 , -0.000282862685749 , 0.000178608682087 , 4.72834863321e-05 , -0.0021974539696 , -0.00473106372425 , -0.00415562399712 , 0.00134452526889 , -0.00147230555605 , -0.00127016533549 , 0.00282526228417 , -0.00275822063159 , 0.00151724041055 , -0.00309190011249 , -0.000278244828237 , 0.00302576583101 , 0.00405243097827 , -0.00158848584613 , -0.00105897506457 , -0.000461037467232 , -0.002278757976 , -0.000633331597395 , -0.000958971070718 , 0.00403455850424 , 0.00251817766831 , 0.0014022826425 , 0.00292023092552 , 0.00535013783602 , -0.00116505790151 , 0.00179601505788 , -0.000205276348838 , 8.44212774184e-05 , 0.00491897945288 , -0.00333385107112 , 0.00312582292868 , 0.00623537874689 , 0.00533512264467 , -0.00489534853524 , -0.000556212289056 , 0.00138232020567 , -4.60121363427e-06 , -0.00277501820652 , 0.00287738361044 , -0.000752300646048 , -0.000348478647328 , 0.00333799805933 , -0.00125992878989 , -0.00253936095394 , 0.00022998690165 , 0.00387906684874 , -0.00423738743359 , -0.00497932469431 , -0.000415733864827 , 0.000866358775262 , 0.000471963577136 , 0.000826709999243 , 0.00419641000698 , 0.00527237143644 , -0.000334589420999 , -0.00204571996245 , 0.00321695368037 , -2.91908674109e-05 , -0.000854056601571 , -0.00389629101072 , -0.00187904324486 , -0.000142488319841 , -0.00170294576211 , 0.00105474616786 , -0.00186179328835 , 0.00120303754719 , -0.00276449630769 , -0.00275247071299 , 0.00237678197485 , 0.000487879293844 , 0.000372263874725 , -0.000532835438531 , -0.00300579165439 , 0.00715767451756 , -0.00101259931533 , -0.00208767627852 , 0.00023150738217 , 0.000219378527489 , -0.00218800430767 , -0.00343820466287 , 0.00528659231267 , -0.00262670327335 , -0.000830837488669 , -0.000931088217322 , 0.000302484963522 , -0.00336090406925 , 0.00235160734289 , 0.00412306208346 , 0.0049300592897 , 0.0037159253386 , 0.000329361380338 , 0.00121460115565 , -0.00255715266711 , 0.00121659166983 , 0.00263325576726 , -0.00101776668523 , -0.00216189110293 , -0.00623516557215 , 0.00417764462035 , -0.0002734772425 , 0.00117223875571 , 0.000406497685024 , -0.00321523287194 , -0.000736878833133 , -0.0056847017932 , 0.0030596494973 , -0.00509416661558 , -0.00326506900403 , -0.000782653216066 , -0.00113247829 , 0.000100706477525 , -0.00668932044354 , -0.00398694717331 , -0.00116266856972 , 0.00359837264184 , 8.8161063304e-06 , -9.22384929211e-05 , -0.00112582151387 , -0.00388476089979 , -0.00103902053512 , 0.000656861742824 , 0.000414115574752 , -0.00122650786524 , -0.00167311354126 , -0.00166031360083 , -0.00119554114429 , 0.000830478636097 , 0.000876747422676 , 0.00369514259228 , 0.00155005503814 , -0.00545065887868 , -0.00423276243844 , 0.000703366508319 , -0.00252877310247 , -0.0058763306126 , -0.00264801890743 , -0.00293365135028 , 0.000549624159672 , 0.000323740895433 , 0.00452766155431 , -0.00339592437265 , -0.00658027690324 , 0.0050556861271 , -0.00262728477372 , 0.00308337494014 , 0.00382051440984 , 0.00240900101936 , 0.00179251477634 , -0.00262591402211 , -0.00322982382647 , -0.00429658714899 , -0.00282175804404 , -0.00354981870808 , 0.00288405373691 , -0.00261071477123 , -0.00461616659079 , 0.00222510646144 , 0.00544329474113 , -0.00350326846708 , 0.000729048979166 , -0.00247301602205 , -0.00348868072168 , 0.00529416593236 , 0.0021443482831 , -0.000257204792641 , -4.41185966172e-05 , -0.000152758661709 , 0.00137675943036 , -0.00443990909115 , 0.0017838241487 , 0.00244500831366 , 0.00292930663233 , -0.00145688355381 , 0.00287034672903 , 0.00113893471209 , -0.00207684042765 , -0.00329180291193 , 0.00289872248569 , 0.00242336768074 , 0.00318108523786 , 0.000261543034501 , 0.000767551017266 , 0.00171176504412 , -0.00170500580663 , -0.00489522761386 , -0.00115008643009 , -0.000191461454048 , 0.00436089185703 , -0.00170607456867 , -0.000806302184906 , 0.00439947421299 , -0.0039421070611 , 0.000849869567367 , 0.00176225568734 , -0.00330287928941 , -4.58550984691e-05 , 0.00265618918356 , 0.00176733385666 , -0.00093098099919 , 0.000757630556077 , -0.00124385209643 , 0.00356319757786 , 7.16996899415e-05 , 0.00705952093966 , 0.00142832526608 , 0.000441953386084 , -0.000679417965529 , 0.00171639015923 , 0.00455653789615 , -0.00161162094127 , -0.000132245414248 , -0.00316553707489 , -0.000503042913114 , -0.00413283867052 , 0.00290861964686 , -0.000910502435612 , 0.00307588059922 , 0.00278926154563 , 0.00334069608696 , 0.00557515846861 , 0.00338943866223 , 0.00365311040266 , -0.00341811752552 , -0.0041307706843 , 0.00225490283341 , 0.00679885269573 , -0.000303901113135 , -3.34923619223e-05 , 0.00203813859038 , 0.0033794815427 , 0.00335633212972 , 0.00374418622658 , -1.71396056657e-05 , -0.00224362210972 , -0.00193190805424 , -0.000903209201677 , -0.00461303790131 , -0.00131722845753 , -0.00523044558209 , 0.00284914208493 , -0.00442580861891 , -0.00196185256289 , -0.0035217087162 , 0.00027966215165 , -0.00139845774522 , -0.00162382399054 , 0.000356019867011 , 0.00386516327787 , -0.00381707799962 , 0.00331857718495 , 0.000426039317579 , -0.00156053847662 , 0.00135693110186 , -0.000263264968566 , 0.0067248779558 , -0.000296746195401 , 0.00161437283687 , 0.00363903200579 , -0.00266421819553 , -0.00233013202062 , -0.00533591378197 , 0.000376840474655 , -0.00163360585584 , 0.00327745518127 , 0.00415172555203 , 0.000948599438011 , 0.00581048799564 , 3.47946689216e-06 , 0.00296299972353 , 0.000476763651241 , 0.00190701820172 , -0.000151174161941 , -0.000749247038291 , 0.00231838858674 , -0.00159777443789 , -0.00445730251011 , 0.00315157013723 , -0.00221486220044 , 0.000601498331288 , 0.00130547127489 , -2.59964835825e-05 , 0.00402046704453 , 0.00330939225075 , -0.0043230998753 , 0.00103955979011 , -0.00366835843852 , -0.00620271834758 , 0.0059990697285 , 0.00226910465175 , 0.000602898469642 , -0.000213858147184 , 0.00344408094001 , 0.00331220371989 , 0.00237857398514 , 0.00100492347727 , 0.00357339952234 , 0.00259337374578 , -0.00383917708716 , 0.00381901422424 , 0.00534326210234 , -0.000277667806461 , -0.00317762655859 , -9.66007960531e-05 , 0.00470078480016 , -0.000375113097578 , 0.00216402280098 , 0.000921679333518 , 0.000811235662321 , -0.00581335078034 , 0.00116973681754 , 0.000268319741091 , -0.000372273614377 , -0.00338871823839 , -0.0025771074025 , -0.000108699566012 , -0.00212665694834 , 0.00299331092249 , 0.0019402278521 , -0.000264229252092 , 0.00155368602636 , -0.000725380450679 , -0.00482511699196 , 0.00318067328316 , -0.00256695060714 , -0.00221313016707 , -0.00531826998472 , -0.00430726893281 , 0.00221078250128 , -0.00176042393824 , 0.000108675671622 , -0.00408218725993 , -0.000122149682532 , 0.00222397482248 , 0.00081565801855 , 0.00252225909001 , 0.000657815041708 , 0.00285925627427 , -0.000418089494318 , 0.0047677689067 , 0.000587876011017 , -0.00290006281706 , -0.00328988075508 , 0.00426940170915 , 0.00300022431025 , -0.00432737645993 , -0.00387452642367 , 0.000753802226104 , 0.000965195793848 , -0.00391033790585 , 9.19220371652e-05 , -0.00106465315211 , -0.00185757344218 , 0.00395944876663 , -0.00466708836455 , -0.00627948843264 , 0.00390998928369 , 0.0024312370852 , 0.00133752447126 , -0.00496608670941 , -0.00222935215982 , -0.00270674912044 , -0.00269226443839 , 0.00140816573642 , -0.00138098199238 , 0.00279442328241 , 0.00210402259818 , 0.00123332318359 , 0.00233903169865 , 0.00194738121213 , 0.000678705559036 , 0.000252408712425 , 0.000809810496585 , 0.00140534068265 , -0.000751659456719 , 0.000515739541312 , 0.00481553434453 , -0.0052406238359 , -0.000307367547333 , -0.00137551916349 , 0.00101091754188 , 0.00632863290676 , 0.00287959295386 , -0.00401474357842 , -0.00172400025764 , -0.0053628113111 , 0.00208236312558 , -0.00418980138328 , 0.0038177872806 , -0.00400868413339 , 0.000328613904409 , -0.000501866386919 , -0.00291712714529 , 0.00274882969319 , -0.00545490119538 , -2.58970093289e-05 , -0.000110210091894 , -0.000621759283965 , 0.00078808160361 , -0.00120111955388 , -0.00298298854432 , -0.00258335659672 , 0.00241603282191 , 0.000826146611764 , 0.00364866327463 , 0.00203351958811 , 0.00145460985712 , -0.0025621330018 , 0.00421979358154 , 0.00307572881378 , 0.000176879289941 , -0.00374632371976 , -0.000508663064781 , -8.5020104341e-06 , 0.00112592258332 , -0.00357057715868 , -0.00212541713763 , 0.00173097116394 , 0.000118340944752 , 5.20625643921e-05 , 0.000819711141551 , 9.42097003081e-05 , -0.000241307268045 , 0.00212735230817 , -0.0014691843332 , 0.00172927210392 , -0.000654923884152 , -0.00142599401378 , -0.000716139431745 , 0.000256275092811 , -0.00505849071222 , -0.00185520289332 , 0.00444982819083 , -0.00200385959184 , -0.00110721257424 , -0.0035851467599 , -0.00565805810661 , 0.00171022520321 , -0.00336285236147 , 0.00375488642896 , 0.00287518086371 , -0.00192191158864 , -0.00500134231528 , 0.00253224442642 , 0.00285098333487 , -0.0012277996285 , -0.000389794288827 , 0.00115196316848 , 0.00698705018659 , -0.00362073706609 , -0.00193181271522 , -0.00526939351949 , -0.00298937955379 , -0.00196759956054 , -0.000903740340345 , -0.000694790104107 , 0.00115227527987 , 0.00206385020372 , -8.57155263254e-05 , 0.0027259774475 , -0.00188237468259 , -0.000169455702071 , -0.00199945113636 , 0.00117713136538 , 0.000160185159234 , 0.00102520481771 , -0.00491287525853 , -0.00174510149832 , -0.00495816583594 , 0.00496048818322 , 0.000609015149469 , 0.0044793816497 , 0.00561992916646 , 0.00109158078374 , -0.00307863545916 , 0.000802387346812 , 0.00557338960617 , -0.00408819343508 , 6.58242805702e-05 , 0.00506344727193 , -0.00239207828807 , -0.00382411022755 , -0.000798953020802 , -0.000144954883415 , 0.00323945443574 , -0.00610462840925 , -0.00304426361697 , -0.00220638342185 , 0.00192391494664 , 0.00500328729301 , -0.000435578740594 , 0.0051651079818 , 0.00377147846894 , -0.000987308227362 , 0.00105092115933 , 1.20843240488e-05 , -0.00166017961563 , -0.00502835503655 , 0.00490131735346 , -0.000268048061038 , 0.00319312923085 , 0.00334923971349 , -0.00501238090794 , -0.00101374901689 , -0.000980254917704 , -0.00576916935215 , 0.00817201892314 , -0.00544521399272 , 0.000590242218443 , 0.000156641260303 , 0.00210808123626 , 0.0012173663179 , 0.00306807090279 , -0.00217888646188 , -0.00383933653396 , -0.00052103450651 , -0.00179181930102 , 0.00239749367765 , -0.00512572010313 , -0.0037182914481 , -0.00269062328146 , 0.000743491141673 , -0.00420943549604 , 0.00155009869359 , 0.00047299197279 , -0.000658596460031 , -0.000214143618937 , 0.000278880628674 , 0.00153596022354 , -0.00562757187966 , 0.0012836106342 , -0.000126669611849 , 0.00516102429433 , -0.000505866044147 , 0.000404666964541 , 0.00199045183756 , 0.00192943920325 , -0.000710099283858 , -0.000174602063904 , -0.00034590124611 , -0.00254735692397 , 0.0028528916178 , 0.00263591933824 , 0.000131656015845 , 0.00426500923189 , -0.000557121847812 , 0.00391533304481 , -0.00483976905973 , -0.00293306111588 , 0.00266177808745 , 0.00521858521525 , -0.00125077142353 , 0.00238299131407 , 0.00247925118461 , -0.00150258222585 , 0.00323649944543 , -0.00207502395592 , 0.00121189654902 , 0.000392361017574 , 0.000116148931393 , 0.00146544501217 , -0.0028711667542 , -0.00035091995167 , 0.00194923849015 , -0.00157324759094 , -0.00213591547286 , 0.00207011196564 , 0.0037288417173 , -0.00271268027849 , -0.00269816958913 , 0.000542110107196 , 0.0019022275417 , -0.000687096746093 , 0.00338567577148 , -0.00368575643306 , 0.00296181526039 , 0.00402721483726 , 0.00407659697683 , -0.00395793755385 , -0.00138514255435 , 0.00274871321253 , -0.0034655033944 , 0.00588510154255 , 0.0048562430319 , 0.00366671045995 , 0.00345647156328 , -0.0031117760458 , -0.00183429847965 , -0.000283791884377 , -0.000430516883531 , -0.00167669642977 , 0.00149328218013 , -0.0048095952668 , -0.0035105044524 , 4.35845250597e-05 , 0.00267144362678 , -0.000469486147289 , -0.00464635286981 , -0.00127681395555 , -0.00368893896242 , -0.000641911259037 , 0.000943301999324 , -0.00140587253272 , 0.00348848084576 , 0.000149861773711 , -0.00329188343141 , 0.00365845302755 , -0.00251915879387 , 0.000413836810839 , -0.00176246621925 , -9.46262368631e-05 , 0.00189275226007 , 0.000443111566153 , -0.0018030110556 , -0.00124053490306 , -0.000364995752714 , -0.00081445056407 , -0.00123422692108 , -0.00452074779124 , -0.000142032911487 , 0.00171022537313 , -0.000365970813555 , 0.000232225418885 , -0.00336998038916 , 0.00173691151599 , 0.000158644967526 , -0.000126801646311 , -0.00558827608061 , 0.00115036313936 , -0.00087356565319 , 0.00228902438262 , -0.00410406580691 , 0.000890071640644 , -0.00109553760493 , -0.00355038837192 , 0.00217570945535 , -0.00263019166595 , 0.00421028445108 , -0.00176929670235 , -0.000631157156453 , -0.00089600552037 , -0.000992021930172 , 0.00202923460706 , -0.00597701246809 , 0.000328028734727 , 0.000114668468906 , 0.00181423795852 , 0.000166595117108 , 0.00192106379519 , 7.13740649378e-05 , 0.00154370678501 , -0.00179128779976 , -0.00521189930856 , 0.00174578382653 , -0.00333847450262 , 2.21424482139e-05 , -7.39418699156e-05 , 0.00444924606133 , -0.000969014533284 , -0.00127760269487 , 0.00438955148558 , -0.00175144074481 , -0.00231725445568 , 0.00266406071412 , 0.000886802000304 , 0.000696319176896 , 0.00100788244451 , 0.000214147584945 , -0.00613112269325 , 0.00401406670634 , -0.00158507485689 , -0.000219187105563 , -0.00170262730392 , 3.37560697169e-05 , 0.000293735980861 , -0.00384290446121 , 0.002991189797 , 0.00244099370696 , 0.00658495353488 , -0.00182200149188 , 0.000562803459289 , -0.00403269159101 , -0.00383422410803 , -0.00416910830066 , 0.0010434116584 , 0.00479487727676 , 0.00267942999416 , 0.00397273601629 , 0.00205806476674 , 0.00108335034113 , 0.000618450191206 , -0.000618779089015 , -0.00192668818313 , -0.00152823149791 , 0.000635454506703 , -0.00219996511631 , 0.00757794270878 , -0.00112728610258 , 0.00298362072414 , -0.00194358893197 , -0.00254462398017 , 0.00463018511647 , -0.00334769410124 , -0.00065048786955 , -0.00508385176066 , 0.000196043002576 , 0.00156824055121 , -0.00430422776022 , 0.000667288020828 , 0.00229825134266 , 0.00112245856094 , 0.000101862686935 , 1.59720420585e-05 , 0.000293645427811 , -0.00505522603957 , -0.00240933002066 , 0.000691758663256 , -0.000190393589683 , -0.00219348484975 , -0.000205990937286 , 0.00553715543225 , 0.00161807126396 , -0.000135061095498 , 0.00124972759475 , -0.0037705440681 , 0.00152037295438 , -0.0049474184471 , -0.000113355374705 , 3.89754547535e-05 , -0.00552925654604 , 0.00101534139311 , -0.00519137815265 , 0.00176523673795 , -0.00303456229013 , -0.00084565456961 , -0.00508073962257 , -0.00430351557622 , 0.00229082984701 , -3.40932568524e-05 , 0.00550308242139 , 0.00226968716927 , -0.00614718211402 , 0.00446428469613 , 1.04491048789e-05 , 0.00310629712745 , -0.000321348310246 , 0.00408520404968 , 0.00489339434542 , 0.000326213827574 , 0.00315389270474 , 0.00204816884981 , -0.00157091057804 , -0.00530798988568 , 0.00215654779304 , -0.00406485382178 , -0.0047054517869 , -0.00273074700862 , 0.00284121090231 , 0.00280575415521 , 0.00330680764931 , 0.00454244124956 , -0.00226734625379 , 0.000940203188125 , 0.000357948788109 , -0.000625633581661 , 0.0010851550379 , ])
Y_2_m1_real = flex.double( [ 0.0 , -0.00106915568735 , -0.00057381532154 , -5.95347363338e-06 , 0.00195352052517 , -0.00203184108506 , -1.90708542801e-05 , -0.00262350170526 , 0.00562805636682 , 0.000306279314197 , 0.00445268254267 , 0.00113787294143 , 0.00235865916205 , 0.000906396956608 , 0.00392997519062 , -0.00114223951762 , -0.0013494809011 , -0.0070892103539 , 0.000344666903256 , 0.00328427939951 , 0.00180865010966 , 0.000364351797778 , -0.000176858010866 , -0.00515963774894 , 0.0022486069386 , -0.00764940650209 , -0.00511507411323 , 0.000156575288501 , -0.000521408855004 , 0.00188260659804 , -0.00340148656167 , 0.000391034443505 , -2.33628188527e-07 , -0.00374094825081 , -0.000331369070347 , -0.00368160282865 , -0.00184835416289 , -0.000191348888678 , 0.000472892214036 , 0.00154469739762 , 7.73469528302e-05 , -0.00374699566781 , 0.00336026573673 , -0.0043646672263 , 0.00322676981827 , -0.00365153970261 , 0.00406779998974 , 0.00274280201644 , -0.00345515667111 , -0.00231620063348 , 3.61398998276e-06 , 0.00474935735799 , 0.00290059159997 , 1.06526310564e-06 , 0.00283734204781 , -4.78366565028e-05 , 0.00280257220929 , -0.00135308998346 , 0.00604534822821 , 0.000106263066811 , 0.00109820266788 , 7.47215279533e-05 , 0.00283794636005 , 0.00153327715857 , -0.00444117749267 , 0.000125897285938 , 0.00256168910516 , 0.00309180819922 , -0.00069448538487 , -0.00227252177703 , -0.0043813753178 , 0.000940125275674 , -0.000596868627791 , -0.00327114254872 , -0.000324818789363 , 0.00437583849635 , -0.00130350586987 , -0.0043192544719 , 9.5932434905e-05 , 0.00263325099348 , -0.00390320602633 , -0.00617755759236 , -0.002814654922 , 0.00319748556638 , -0.000897651386159 , -0.00355157665996 , 0.000581733629855 , -0.00116095534954 , 0.00376404143346 , 0.00435785652372 , 0.00468267763365 , 0.00262241839059 , -0.00209548036107 , 0.000325082369427 , -0.00237749849927 , 0.00117246759653 , -0.00176043478682 , -0.000465601714472 , -0.00102612672147 , -0.00474509572373 , 0.00386358930453 , 0.0018137114817 , 0.00112656903133 , 0.000249197351525 , 0.000345709111313 , 0.00441402682352 , 0.000403037165659 , -0.000169051077674 , 0.00260230981424 , 0.001412399373 , -0.00324475297803 , 0.00308500031037 , 0.000421274077494 , 0.00109879303963 , 0.00296672398915 , -0.00212218750335 , -0.00429194271874 , 0.0036477066322 , -0.00143487439201 , -0.0051684696738 , -0.003713133687 , -2.62414608981e-05 , -0.0020062505422 , 0.00319226417111 , 0.00393765959242 , -0.00160673438896 , -0.00230938952849 , -0.00164246872743 , -0.000969295097836 , -0.00155945271156 , -0.00510434995126 , -0.00461356466171 , 1.63640832636e-05 , 0.00267228207559 , -0.000114442700675 , 0.00460172231253 , -0.00104781462526 , 0.00130212916029 , 0.00500101369489 , 0.00109928847261 , -0.00218384851421 , 0.000322342451098 , 0.00333209402253 , 0.00430767907204 , 3.86884870683e-05 , -0.00485500141392 , 0.0025740560221 , 0.00202490817508 , -0.000920825072575 , -0.00366175969602 , 0.00094404756512 , -0.00027096304922 , -0.000792538943057 , -0.000182132061408 , -0.00144789458774 , 0.00162023085204 , 0.00177384385245 , 0.0031784931079 , -0.00131688921598 , -0.000403337003384 , 0.00110263332605 , -0.000922129855311 , -0.00356677572117 , -3.63154819079e-05 , 2.96127758444e-05 , 0.00194584551061 , 0.000224221451002 , -0.00141132705885 , -0.00249620395825 , -0.00453187394827 , -0.00487314599065 , 5.06840720644e-05 , 0.00191182148136 , -0.00195881992025 , 0.00147290186606 , -0.00446090137895 , -0.0012375359714 , 0.00586875218655 , -0.0019735419015 , -0.00049659266497 , -0.000227669437264 , 0.00282425590831 , -0.00201510188646 , -0.00568058864391 , 6.76964429579e-05 , -0.00348566340208 , 0.00529347652918 , 0.00349667542847 , -0.00135782364649 , 0.00138966486143 , 0.00142138664706 , 0.000818053714115 , 0.00075199708664 , 0.00327188910098 , -0.00458033138678 , 0.00207556480175 , -0.000701714714039 , 0.00243522661326 , 0.00115115049734 , 0.00272270190191 , -0.000430478237315 , 0.00374744458219 , 0.00477284675567 , 0.000817681762986 , 0.00497850518947 , 0.00110002567418 , -0.000229166844653 , 0.00266783784992 , 0.0027857266765 , -0.00693637765795 , 0.0045746558861 , 0.00041666033514 , -0.000756449498001 , -0.00375840175656 , 0.0035131933103 , -0.00226463936434 , 0.00334525219069 , 0.000654253016016 , -0.000584205795983 , 0.00687309626363 , -0.00215254496698 , 0.00414979306479 , 0.0058673779994 , -0.00122317423447 , -0.00184717095414 , 0.000128366767562 , -0.00299894317087 , 0.00460583020427 , -9.74790344486e-05 , 0.0020514169116 , 0.00480761078817 , 0.001321922534 , -0.000955870173782 , -0.00354443184209 , 0.00126697310502 , -0.000135339679329 , -0.000528974705471 , 0.00270418961247 , -0.000693002912757 , 0.000986405718295 , -0.00101760553211 , 0.000309899643776 , -0.00211313593603 , -0.000794209325857 , 0.000519740481921 , 0.000154901173735 , -0.00233854931232 , 0.00455700232105 , -0.00026186638169 , 0.000283374881809 , 0.00343658871515 , 3.19479065169e-05 , 0.00407993448077 , -0.00257553795066 , 0.00256264894044 , 0.00301397629705 , -0.00109208083292 , 4.42470184209e-05 , -0.00221940775862 , 0.00146482499961 , 0.00166919256781 , 0.00345695984029 , 0.000435834385013 , 0.00169934358035 , -0.00385256097658 , 0.00435870656982 , 0.00534187356408 , -0.00094703972981 , 0.00353802160693 , 0.00310273816073 , 0.000928009690721 , 0.00188927412345 , -0.000403616764306 , -0.0032805295046 , 0.00440395966479 , -0.00112683352314 , -0.000339680653235 , 0.00328660303651 , -0.00484803174761 , 0.00106122291776 , 0.00240556746704 , -0.00276861289543 , -0.00321971515677 , -0.00285720532447 , 0.000368647756156 , -0.00371265215261 , 0.00662447306605 , -0.000148969139832 , -0.00191832723332 , -0.00159538742385 , 0.00189794772488 , 0.00285187152392 , 0.000379157265826 , 0.00127761797881 , -0.00022353210222 , 0.00167901863169 , -0.00435042222889 , -0.000678757763675 , 0.00523600195153 , 0.00140057466508 , 0.000126745707294 , 1.68001614866e-05 , -0.00339014292934 , 0.00112864116115 , 0.00350419913411 , 0.00604812920789 , 0.00306547582966 , 0.00515913879281 , 0.00407367164809 , 0.000124663824874 , 0.00084647486972 , 0.000776307909574 , 0.0031902126617 , 0.000541326067623 , -0.000387897577482 , 0.000123757009199 , 0.000725631848116 , 0.000798272834813 , 0.0019893637269 , -0.0033608766788 , -0.000544243933116 , 0.000648112114547 , -0.00389724736204 , -0.000153404555301 , 0.00489274921548 , 0.000986791312502 , -0.00133540376498 , -0.000202089853179 , -0.00837729134856 , -0.00672798297703 , 0.000649330509403 , -0.0016283442983 , 0.00184374183295 , 0.00325286155246 , -0.00141335380479 , -8.06090816414e-05 , 0.00169054871537 , -0.000102145509633 , -0.00111602723916 , 0.00525802714883 , 1.83485014298e-05 , -0.00210309356083 , -0.00250231366941 , -0.000165537556147 , -0.00140577449668 , -0.000194186290433 , -0.00164604439113 , -0.00101578951491 , 0.00219008325586 , -0.00694702142427 , -0.00314519004234 , -0.00159882854313 , -0.00155428909448 , 0.00367741364212 , -0.00224309060532 , 0.0010089941053 , -0.00262786305717 , -0.00120625879519 , -0.00367065587051 , -0.00237743295594 , 0.00189619288735 , -0.00533802157611 , 0.000271131090408 , 0.00157331538474 , -0.000969129457556 , -0.00606139211879 , -0.000491314449672 , -7.64653247211e-05 , 0.00250769268079 , 0.00136055946787 , 0.00293501586593 , -0.00362012769175 , 0.00248725750061 , 0.00124260435252 , -0.00284976086187 , 0.00215185927892 , 0.000770743148999 , 0.00310052757346 , -0.000286721184784 , 0.0056747694547 , 0.000869335614178 , 7.94423136189e-05 , 0.00233486173402 , 0.00467765934259 , -0.00661333979283 , 0.0014560962058 , 0.00173511879597 , 0.00123958255477 , -0.000257722465325 , -0.00122465158038 , -0.000102264626553 , -0.000966963776157 , 0.0046640295186 , -0.00231137357038 , -0.00462375628718 , 0.00310258695534 , 0.000517706462434 , 0.00294156360039 , 0.000372134760575 , 0.00130287728826 , -0.00103625452588 , -0.00293774642275 , -0.00347127314185 , -0.00468667882558 , 0.000396154605262 , 0.00487500411446 , -0.00206461913413 , -0.00303153093829 , 0.00263611151544 , 0.00221559531622 , -0.000525109457694 , 0.00104735356289 , -0.00107361193328 , -0.000137421532209 , 0.00324684744398 , 0.0064072269378 , -0.00407633722719 , 0.00197791746789 , -1.50830936102e-05 , -0.0010753939205 , -0.00463366153911 , -0.00437289013307 , -0.00274095518597 , 0.00108119825897 , -0.000293982156134 , -0.00408491388533 , -0.00478906970687 , 0.00298224877377 , 0.00371664053971 , -0.00145863216256 , -0.00143897374104 , 0.000327291624388 , 0.00333610895828 , 0.000781665036951 , 0.0031586572984 , 0.000503778569347 , -0.00218822893217 , 0.00168119569999 , 0.00140406013274 , -0.00337322717359 , -0.00607025483621 , -0.00499796132112 , 0.00374208507789 , 0.00176892881481 , 0.00165733962946 , 0.000680450845028 , 0.000371406391145 , -0.00123521373977 , -0.00420650252978 , -0.00426402199518 , -0.0023842445014 , 0.00333498882181 , 0.00494129353299 , 0.00504564058774 , 0.00313101355037 , 0.00102249043496 , -0.00573457172756 , -0.0034796477966 , -0.000582230683791 , -0.00529420989569 , 0.000151320950164 , 0.000268010431534 , -0.00579060554934 , -0.00503444016065 , -1.97330442268e-05 , -0.0039196566918 , 0.00544879662306 , 0.000739719481485 , 0.0038708202027 , 0.000912768990885 , 0.00608667577295 , 0.00462564593827 , -0.00581906804963 , -0.000940119210553 , 0.00414683163748 , -0.00429668331012 , 0.000421453531649 , 0.00538613020942 , -0.000465981259566 , 0.000539657993702 , 0.00358138730906 , 0.00466368243483 , -0.00368553935252 , -0.00383051056097 , -0.000472105513472 , -0.00434509326733 , 0.00637151251423 , -0.00289898900667 , 0.00133007243757 , 0.00118028638439 , 0.00397154433455 , -0.000264012596374 , -0.00625727401997 , 0.00442484241937 , 0.00135907172473 , 0.00586190182921 , -0.00182530578123 , 0.00289027393711 , 0.00032153057101 , -0.000374923131585 , -0.0039486631321 , -0.00217407846104 , 0.00336671193086 , -0.000628114185265 , -0.000299704175078 , 0.00310793518375 , 0.000544460979222 , 0.000330850052146 , 0.000671744867202 , -0.000586665082443 , -0.00363242725105 , -0.000187568000852 , 0.00630101443111 , -0.00444028972639 , 0.0012102407546 , 0.00137475727552 , 0.00249434468757 , 0.000849873133585 , -0.00612610716167 , -0.000800745819119 , -0.001783033309 , 5.32621040218e-05 , 0.00260402873574 , -0.00198519753645 , -0.00226578014876 , -0.000505435353967 , -0.00485481395625 , -0.00335290282539 , 0.000997023140757 , 0.00166670291029 , 6.94740602205e-05 , 0.00226345919164 , 0.000205333622174 , 0.000581680173162 , 0.00112972621498 , 0.00376092449198 , 0.000972931577243 , 0.00257389721987 , -0.000962765136957 , 0.00091375787409 , 0.00190041236025 , -0.000741238105498 , -0.00168390058083 , -0.000772994567187 , 0.000188552057364 , -6.18240695823e-05 , 0.0013648599583 , -0.000273070413553 , -0.00316749486942 , -0.000385833275589 , -0.00488611901131 , -0.00543085535421 , 0.000292277830189 , 0.00107791124551 , 0.00538149152527 , -8.55582536785e-05 , -0.00137583673106 , -0.00197152134211 , -0.00283254582796 , 0.00563211297177 , -0.000930236407214 , 0.00239549164899 , -0.00113882342348 , -0.003303179166 , -0.00114589383956 , 0.00540459976955 , -0.00337327739488 , 0.00182403995505 , -0.000641655905008 , -0.000357218742559 , -0.00187303774969 , 0.00488818616506 , -4.62013774611e-05 , 0.000996236752923 , -0.00545213340718 , -0.00237946554274 , -0.00319803833599 , 0.0010781488359 , -0.00223176630477 , 0.00314028350394 , 0.000280181190384 , 0.00239504274834 , 0.000639731683838 , 0.00426113885731 , 0.000273406477542 , -0.00239808445269 , -0.00333248901621 , -0.002564310681 , -0.00258647054613 , 0.000385924797293 , -0.00160138596995 , 0.00280006914287 , -0.00299659857946 , -1.99377800227e-05 , 0.00021400298584 , 0.004607328405 , 0.00475009748044 , 1.96931511761e-05 , -0.00179477678807 , -0.00257419707843 , -0.00337328840906 , 0.000281547929867 , -0.00252662817258 , -0.00030036417286 , -0.00473302800362 , -0.00530838647625 , 0.0046077688731 , -0.00282077376261 , -0.00283238421252 , -0.00268289354809 , 0.00349808734108 , -0.000382985406892 , -0.00625920321891 , -0.001896857821 , 0.00245434612732 , -0.0013764490632 , -0.00187392018677 , -0.000410371152382 , 0.00464855883951 , -0.00337574217924 , -0.00432813112637 , -0.000698471328251 , -0.00466790836179 , -0.00481633756297 , 0.00165399966385 , -0.00297860112818 , 0.000873907667894 , -0.000631448168792 , 0.000359229045592 , 8.25805453626e-05 , -0.000600958503674 , 0.00117016279205 , 0.0020566167386 , -0.00225951072806 , 0.00279595496132 , 0.000364543221645 , -0.00227776390313 , 0.00694688720097 , 0.00021725441306 , 0.00269508351437 , 0.000710431216835 , -0.00159485783204 , 0.00414375311519 , 0.00245591542396 , -0.00153786709673 , 0.00362840428927 , -0.00332029685129 , 0.00208763926324 , -0.00259779188041 , -0.00392253533915 , -0.0014608560799 , 0.00407516354721 , 0.00349981992669 , 0.00100491319385 , -0.00444548082825 , -0.001829295921 , 0.001627848849 , -0.00223048853329 , 0.000879047735529 , -0.00077631867078 , 0.00119954730412 , -0.000231520602064 , -0.0028300066106 , -0.00078720459939 , 0.00147750610993 , -0.000193155180031 , 0.00198534247322 , 0.00173324133969 , 0.00330066652791 , -0.00305945799256 , 0.00333457588953 , -0.000146345322337 , -0.000121774914226 , 0.00038992011688 , 0.0056867655711 , -0.000706519995442 , -0.00476226157383 , 7.14639316483e-05 , 0.00184729211045 , -0.00381366998496 , 0.0022912678746 , 0.00369409035846 , 0.00194458209527 , -0.000944244116962 , 0.0036675925316 , -0.0016332169951 , 0.00224052311643 , 0.00150497435509 , -0.00455021497919 , 0.000566961726053 , 0.00495078794371 , -5.36349867821e-06 , -0.00019696396228 , -9.40127978901e-05 , -0.00397747389035 , -0.000687949519135 , -0.000214422293932 , 0.000268495651057 , 0.00295519352273 , -0.000481607772855 , -0.00142939072957 , 0.00128741237649 , 0.00254957793541 , -0.00296284255628 , 0.00561330610824 , -0.00324648449477 , -0.00172972812225 , -0.00476746932408 , -0.000378889972399 , 0.00448569073897 , 0.000531217220647 , -0.00244220688709 , 0.00304349492032 , -0.000450010035288 , -0.00150634468599 , 0.000439772866984 , 0.00146576498998 , -0.00262294646214 , 0.00485517375584 , -0.00460544049452 , 0.00274902774376 , 0.00099291090389 , 0.000120195140532 , -0.000696060671403 , 0.00287479543287 , 0.00118829460196 , -0.00201491469152 , -0.000899829454003 , -0.000594152728193 , -0.00470776337985 , 0.00277609245901 , 0.00156034266203 , -0.00343354754504 , 0.00185548128369 , 0.00535860839428 , -0.00404536060814 , 0.00463273957626 , 0.00379329068831 , -0.00154014670425 , -0.00657554457257 , -0.0024966211057 , 0.000303060519351 , -0.00480922521023 , 1.69342150602e-06 , -0.000191747766853 , -0.00166644114915 , -0.000831733564321 , -0.00673378700598 , -0.00168612363373 , 0.00224383714399 , 0.00352679268261 , -0.00387633548122 , 0.00125320721549 , -0.00151323922481 , 0.00293047389963 , -0.00188367807165 , -0.00823225687966 , 0.00174917277706 , 0.00135326540868 , 0.000121359835701 , -0.00123136726808 , 0.00202248215949 , -0.00104603712653 , 0.00106323295785 , -0.00130299097709 , 0.00624707970707 , 0.00159542913725 , -0.000863378025528 , -0.000788970252768 , 0.00132292447784 , -0.00276555051725 , -0.00347682466876 , 0.00118064989184 , -0.000182373059535 , 0.00161392901861 , -0.00500509505515 , 0.00460224201611 , 0.000574630419937 , 0.00158293735089 , -0.00260797925068 , -0.000834772603893 , 0.00201022347676 , -0.00360607091928 , -0.00201214017522 , -0.000594819158571 , 0.00686034120318 , -0.00179532733378 , 0.00587894364911 , 0.00367856272759 , 0.004822269857 , 0.00329082139747 , 0.00387833762777 , -0.00531921494601 , 0.00310639490074 , -0.00116688521781 , -0.00241077586147 , -0.00373114160456 , -0.000169764459282 , -0.00354027154662 , -0.00393303040701 , -0.00117011700772 , 0.0027084828219 , 0.00288843698723 , -0.00033319378737 , 0.00385847451249 , -0.000620163112695 , 0.00234053775177 , -0.00569261455359 , -0.000669527747176 , 0.00245293479278 , -0.00421885865471 , 0.00242636576734 , -0.000540533310449 , 0.00272795175117 , 0.00298473840042 , 0.00173504742693 , 0.00186432199373 , 0.000248501458862 , 0.00179375541183 , -0.00104851428851 , -0.000603876460838 , -0.0050091488029 , -0.00212864464428 , -0.00413715644947 , -0.00163324786282 , -0.00524074703815 , 0.000649661302642 , -0.00261130738084 , -0.00569085698197 , 0.000752000844008 , 0.00140542664437 , 0.00260437721453 , -0.00448995459751 , -0.00149282406812 , 0.00292971052688 , -0.00260484917217 , -0.00222819916063 , 0.00331357926839 , 0.00434499131473 , -0.000674169374731 , 0.000736813094204 , -0.000714574589088 , 0.00103902656033 , 0.00565642797934 , -0.000229656569581 , 0.00185022994113 , -8.72303156613e-05 , -0.000168186631664 , -0.00564659934925 , -0.00493407206669 , 0.00555678396111 , -0.00128237435016 , 0.00344524731525 , -0.000488476762274 , -0.00325702595012 , 0.00371203691571 , 0.000542351369361 , 0.00267029615598 , 0.000871245534915 , -0.00744879366477 , 0.000811273729188 , -0.0077992333717 , 0.000296959054879 , 1.25648673902e-05 , 0.000627665445252 , -0.00124865934599 , 0.0055484525327 , -0.00061212237274 , -0.000279005259283 , -0.00169798344285 , -0.00305258620408 , 0.00266256826398 , 0.00160890257804 , -0.00325319385814 , -0.00263582863689 , -0.000949678025311 , 0.00163265189216 , 0.00605574371549 , -0.00120782771613 , 0.00364388476699 , -8.84284015862e-05 , 0.00283040609662 , -0.00188644514724 , -0.00201314844639 , -0.00259015410134 , -0.00499675157775 , 0.000853971549508 , 0.000278156591862 , -0.00426655968482 , -0.00251906906229 , -0.00382004724397 , 0.00268878390349 , -0.00223260694857 , -2.20793734756e-05 , 0.00103604214156 , -0.00130856624833 , -0.000607555929921 , -0.000660144525044 , -0.00135123790705 , 0.001752759687 , ])
Y_2_m1_imag = flex.double( [ -0.0 , 0.0 , 0.000104083262149 , 4.72842002358e-06 , -0.00317308336849 , 0.00555499030358 , -3.14255276847e-05 , 0.000297452605953 , -0.00320102722955 , 0.00132137687287 , -0.000670032865817 , -0.0037200334032 , -0.00361134343437 , -0.00411481208967 , 0.00180652341729 , -0.000910798597006 , 0.00582046036081 , -0.00229318643863 , 0.00205385330938 , -0.000502817779803 , 0.00019352672828 , -0.000131904881248 , -0.000394497685779 , -0.000454771484386 , -0.000857410879663 , 0.00250643139284 , -0.000246149538189 , -0.00216344291114 , 0.00576905155147 , -0.00142228300441 , 0.00532550129504 , -0.00450069817498 , -6.24279476975e-06 , -0.00268950150273 , -0.000905666705886 , 0.000711230027061 , 0.000184068219285 , 0.000419680000479 , -0.00816342156391 , 0.000653714475404 , 4.70892621202e-05 , -0.00087689619553 , 0.00136061953671 , -0.000468523990237 , -0.000163026989043 , 0.00167011083351 , 0.000373252096169 , 0.000408028539619 , 0.00188732012766 , -0.00172107164238 , 0.00116204579098 , -0.00027893871771 , 0.0042431953291 , -1.1773627783e-05 , -0.00379616382803 , -0.00298427747015 , -0.00118859169064 , -0.00131247550088 , -0.00133978576997 , -0.000203202840728 , -0.000139852331981 , 3.34828942398e-05 , 0.00242838335082 , 0.00269906865193 , 0.00526038847799 , 0.000109913812146 , -0.00119788352822 , 0.00289622642005 , -0.00163829736889 , -0.000624870928554 , -0.000880101953332 , 0.000821909894898 , -9.56722531672e-05 , 0.0043452588702 , -0.00206223615186 , -0.00259266178463 , 0.00148792806533 , 0.00166270449962 , -9.6216059391e-06 , -0.00275741245309 , 0.00356524173217 , 0.00190640462111 , -0.00344360112866 , 0.000613853298789 , -0.000663152874849 , -0.00181772069233 , 0.00339814783589 , -0.00146552099732 , -0.000224511472872 , 0.0027853330079 , 0.00204848523195 , 0.00492457999017 , 0.00680487835535 , 0.00413498096467 , -0.00343481223491 , -0.00348731359771 , -0.00499627561409 , -0.000782733806871 , 0.00254565724644 , -0.00217437905257 , 0.00044702764115 , 0.00196243545326 , 0.00368575437099 , 1.6941426745e-05 , -0.000231728735731 , 0.00401445475776 , -0.00201148606786 , 0.00108018688314 , -0.00563144396702 , 0.00170111101241 , 0.00277502800587 , 0.0013254733254 , 0.000566734838237 , 0.0048805727949 , -0.0015342978257 , -0.00275452535456 , -0.000444289576633 , -0.00108220180034 , 0.00306996742736 , 0.00130722274892 , -0.000151908630755 , 0.000942098319813 , -0.00769581538084 , -0.000472217766081 , -0.0030596898622 , 0.000969822894974 , -0.000838204321663 , -0.00209213580865 , 0.00148006630711 , -0.000274766690632 , -0.00361680862438 , 0.00063741891524 , -0.00045492904132 , 0.000439732273283 , -0.00358046845492 , -0.00112297859912 , 0.00152306154942 , -0.000843648592668 , 0.000700781102563 , -0.00357823447353 , 0.00591941183651 , 0.0012153077733 , -0.00197702270083 , 0.0031910964417 , -9.02693452807e-06 , 0.000170259350422 , 0.00113510193413 , 0.00111715330398 , 0.00164787675348 , 0.000596875334949 , -0.00600245639792 , 0.000807556631804 , 0.00682545692418 , 0.00145931320346 , -0.000936160627361 , 0.00271273973972 , 0.000319010684971 , 0.00398286761568 , -0.00161059555838 , 0.00241148390355 , 0.00424286943367 , 0.00227769710618 , -0.000262154149921 , -8.22206376788e-05 , -8.14435889626e-05 , 0.00471525392005 , 0.000394752606913 , -0.00144303342264 , 0.00434743306152 , 0.0011069148465 , -0.00102105488083 , 7.94719591653e-06 , -0.00347110708759 , -0.00184190801648 , -0.00332823850795 , 0.000556485692268 , -0.00503001220163 , -0.00113433513621 , 0.00143591820456 , -0.00366228883935 , -0.000210836001857 , -0.00287095481942 , 0.00426469185519 , 0.000523117365226 , 6.96883268686e-06 , -0.00115167191277 , 0.00113065477904 , 0.00484104707955 , -0.00300935720906 , -0.00337925563222 , -0.00379506526032 , 0.000947170976176 , 8.32494565536e-05 , -0.000277976053409 , 0.00389259058267 , -0.00440544508332 , 0.000488065819562 , -0.00352046006834 , 0.00439207756776 , -0.000417803992057 , -0.00387324310259 , -0.0040054244027 , -0.00199739114777 , 0.00337019298894 , 0.000963189084193 , 0.0020430966862 , 0.00265253286506 , -0.00273363134618 , 0.00270778936942 , 0.000940620019302 , -0.00248406988827 , 0.0041580089992 , -0.000546759963372 , 0.00103935965617 , -0.00205016846441 , -0.00360894603475 , -0.00108215622909 , -0.00442865266744 , 0.00304799894799 , 0.000343085302353 , 0.000723946065989 , 0.00312537176453 , 0.00476992938947 , -0.000796696025431 , -0.00383441402862 , 0.0027798412465 , -0.000474880432985 , -0.00448163278936 , -0.00112326930309 , 0.00263706582275 , -0.000473581615093 , -0.00711300416447 , 0.00091224722013 , -0.00240912361092 , -3.0405628723e-05 , -0.0013233158846 , -0.00362051343552 , -0.00427125387591 , 0.00123306157554 , -0.00120911279017 , -0.00217229645922 , -0.000325865088803 , 0.00606759092329 , 0.0035829477878 , -0.00232179192457 , 0.00463707227126 , 0.00237020357377 , -0.00470648545873 , 0.00279599547549 , 0.00068767697395 , 1.2821106996e-05 , -0.00163671057116 , -0.00294465113684 , 0.00119183596909 , -0.00220754891944 , 0.000179043345714 , -3.92672311856e-05 , -0.000278670766897 , 0.000540260796127 , -0.00446467497242 , -0.00396765729462 , 0.00144887052416 , 0.00305468324354 , 0.00374783639354 , -0.000876772149799 , -0.00340034135843 , -0.00449758846937 , -0.00261846861158 , -0.00533184847404 , -0.00278780929435 , -0.000349248811989 , -0.00128550856938 , -0.00381121292315 , -0.000111424465255 , 0.00626104436925 , 0.000901563921391 , 0.000422818315046 , 0.00186273438035 , 0.0021656297378 , 0.0018523980682 , 0.00558132873747 , -0.0053714534592 , -0.000453764935218 , 0.00461780768973 , -0.00128096424399 , 0.00553803494047 , -0.00323080959744 , 0.00025716220785 , -0.00745903992851 , 0.000785835623056 , -0.00151422066599 , 0.00325423791569 , 0.000296320764564 , -0.00407415365678 , -0.00393864052954 , -0.000412006845924 , 0.00637476530692 , -0.000991456532959 , 0.00136868151979 , -4.63217791165e-05 , -0.00217234518055 , -0.000703794354883 , -0.00123370825078 , -0.00339370373236 , 0.00324682052728 , 0.00245624197053 , 0.00316298520834 , -0.00263105371857 , 0.00135795693764 , 0.00123947289693 , -0.00514967036874 , -0.001636214537 , 0.000929339509144 , 0.00176737337759 , -0.00168339737906 , 0.00344859998185 , 0.00621436157831 , 0.00265695956089 , -0.00433446600142 , 0.00265896257517 , 0.00507541819369 , -0.0032860147292 , -0.00722076141256 , 0.000750789601793 , -0.00149538565238 , 0.000901519127074 , 0.000630716595277 , -0.0011801584829 , -0.00256961328684 , 0.00333556939906 , -0.000825531754936 , -0.00251604582019 , 0.00490636228957 , -0.00275417423924 , -0.0031820676143 , 0.00102258437297 , 0.0034205302793 , -0.00489482113847 , -0.000939370461658 , 0.0018624036955 , 0.00040812042065 , 0.00362225843484 , -0.00515941591513 , -0.000112328041881 , 0.00153523797802 , 0.000357304340331 , 0.00426759229343 , 0.00696792497029 , -0.00530690391097 , -0.00543475499719 , 0.000273585210558 , -0.00484712835867 , -0.00228152895191 , 0.00280408709241 , -0.00301158179454 , 0.000346858204746 , -0.0042743949555 , 0.00393058940951 , 0.00400995452746 , -0.00941025453074 , 0.00284527047922 , 0.00115783857516 , -0.000787889048379 , 0.00038545069653 , -0.00038892170814 , -0.00339652329214 , -0.000955083492541 , 0.000299026529972 , -0.00357375174602 , -0.00641905824214 , -0.00135002323635 , 0.00542539950641 , -0.000480073459205 , -0.00226592745853 , -0.00105343053276 , -0.00472540299126 , -0.0025696627838 , -0.00600326158286 , -0.00415772198276 , -0.00113590774261 , -0.000214884508701 , 0.0022249697206 , 0.00191239414388 , -0.0020968458325 , -0.00365695384908 , 0.00235507225795 , -0.00642017418388 , 0.00599940977607 , 0.00518683490605 , -0.00159338698966 , 0.0032746740345 , -0.005327337093 , 0.00417658180768 , 0.000490358169409 , 0.00688859746265 , -0.00193338872922 , 0.00729567737357 , -0.00458461559856 , 0.000697151612111 , 0.00265512421484 , -0.00228275030669 , -0.00178635289858 , -7.6861819877e-06 , -0.00250356090108 , 0.00659041569944 , 0.00290659282484 , 0.000616336684779 , 0.00161661198349 , 0.0020229097676 , -0.00047882861761 , 0.000497232330869 , 0.00310961415506 , 0.0042825098478 , -0.00320173102009 , 0.00413106377974 , -2.52267674986e-05 , -0.00387849043936 , 0.00060007323072 , 1.28727028199e-05 , -0.000123866897811 , 0.00289302617844 , 0.00423179009312 , -0.00271071605581 , 0.00327976836091 , -0.00630595482947 , 0.000108534387974 , -0.00487207282393 , 0.00203324959943 , 0.00528910368715 , -0.00598192588937 , -0.00149064202139 , 0.000109979185359 , -0.0020383152583 , 0.00209033233797 , 0.00392539860851 , -0.00484947606884 , 0.000755308596488 , -0.000535256483177 , 0.00060657267041 , 0.000970856191753 , -0.00159581912972 , -0.000813772085011 , 0.000864466189505 , -0.00180961582733 , 0.00651179752041 , 0.00314898953974 , -0.00343395414086 , 0.00197150598666 , 0.00131212551726 , 0.000175700420788 , 0.00276242350032 , 0.000962554350684 , 0.00111824291719 , -0.000709609908385 , 0.00191183866373 , -0.00515779473761 , 0.00517875445351 , -0.00488016144709 , 0.00158982976098 , 0.00233475927059 , -0.00016089718009 , -0.000390570342561 , -0.00353268495836 , 0.00302237163109 , -0.00160589339936 , 0.00240804500957 , -7.46973083734e-05 , 0.000148554719353 , 0.00197168063858 , 0.00485516539966 , 0.00117773756336 , 0.00269319568748 , 0.000283593082671 , -0.00203649325929 , 0.000213303526293 , 0.00381192742887 , -0.000950879102814 , 0.0030583614961 , -0.000103946699188 , -0.000846917296093 , -0.00334182295429 , 0.000518755854738 , -0.00178359804306 , 0.00309599749447 , -0.00055713043759 , 0.000795659112006 , -0.00214566403324 , -0.00129054643333 , -0.00183991409895 , -0.000979768162483 , 0.00164627673196 , -0.00124081990433 , -0.00151071714142 , -0.00348538516688 , -0.00228526359419 , -0.00421291424918 , 0.00252213775008 , 0.00300735503663 , -0.00142894016842 , -0.00111235286308 , -0.00370135164835 , -0.00410761224799 , 0.00369374987392 , -0.00323792789405 , -0.00301112760416 , 0.000105132318003 , 0.00434200882287 , 0.00145660856628 , -0.00432929826497 , -0.00530767206584 , -0.00432945309348 , 8.98548192005e-05 , -0.000230257887382 , 0.000767348340144 , 0.00509297621651 , 0.00209698200509 , 0.00456548056901 , -0.00134298331315 , 0.00189217209533 , 0.00166352293894 , -0.00518397597147 , -0.000186329988066 , 0.00315332337575 , 0.00196157650766 , -0.00122331321964 , 0.00197325914459 , 0.00348298643062 , -0.00174939205548 , -0.000514249253097 , -0.00010372697518 , -0.0017488934331 , -0.000839113226182 , 0.00225577692504 , -8.74029763529e-05 , -0.0025410867324 , -0.00389655677348 , 0.000714947644543 , 0.0025650462933 , -0.00155809485032 , 0.000187550693733 , 0.00421361944703 , 0.00132434346502 , -0.00303942106044 , -0.00255903992303 , 0.00309455054421 , 2.53246022541e-05 , -0.00325141197667 , 0.000352830531871 , -0.000356814981526 , 0.00131798856492 , 0.00144770711675 , -0.00198094598423 , 0.00200557082975 , 0.000514501485839 , 0.000716334921745 , -0.00626520087944 , 0.000461856185093 , -0.00557705041924 , 0.00255007844365 , 0.00172091773697 , 0.000947545930401 , -0.00028257128746 , 9.83769028194e-05 , -0.00115652014909 , 0.00221557014559 , -0.00136027856612 , -0.00390087551174 , -0.00396444078799 , 0.00449587472893 , 0.000198083612928 , 0.00251651833428 , 0.00130611539072 , 0.000109393820778 , 0.000498089318973 , -0.00199780644462 , 0.000497067094999 , 0.00415114258683 , 0.00170543490666 , -0.00131622183949 , -0.00401656994572 , -0.00506867860519 , 0.00615949142844 , 0.000664375524595 , -0.00145833623144 , -0.00113999354745 , 0.00368519733506 , 0.00742324965739 , 0.00109807806309 , 0.0029191312382 , -0.00334714087766 , -0.000209526402823 , 0.00603313785594 , 3.08647792919e-05 , -6.70456708234e-05 , -0.00138391471423 , -0.000377664704568 , -0.000881214311286 , 0.000115032415455 , -3.34462517505e-05 , -0.00338995076792 , 0.00348934144797 , -0.0024824301828 , 0.00325563323829 , -0.000356024976541 , -0.000303047999591 , -0.0028151021122 , 0.00448766827917 , -0.00240130755556 , 0.00231410951016 , -0.00321781508293 , 0.0025880110691 , 0.000632927846023 , -6.81601530948e-05 , -0.00155049622142 , -0.00283196437031 , 0.00301174296689 , 0.0027240033049 , 0.00266696392839 , 0.00189601023591 , 0.00225498688223 , 0.00530959301469 , 0.000216367224018 , -0.0055652286131 , -0.00422282130654 , -0.00188332802249 , -0.00329452122728 , 0.00101117747156 , 0.0021360671981 , 0.00350958638385 , 0.00126176304185 , 0.00190313132457 , -0.000822462955754 , 0.00247098805294 , 0.000323828912126 , 0.00593785485972 , 0.000976778368029 , 0.00178579675921 , -0.00161602623038 , -0.00253399790195 , -0.00271418107023 , 0.00078716917606 , 0.0015641697982 , 0.000666434309413 , 0.000687186976806 , -0.0051271445198 , 0.00271654665102 , -0.00143387900529 , -0.00733959480241 , 0.00159229512932 , 0.00145231810262 , 0.00505595788595 , 0.00155266073365 , -0.00466200502761 , -0.000518682504713 , 0.00205767913204 , -0.0047679870438 , -0.0012919662088 , -0.00302928235924 , 0.00365973838876 , 0.00699023907899 , -0.00173956781748 , -0.00134926405239 , -0.00201742012134 , 0.000944346396534 , 0.00248493086836 , 0.00148623822479 , 0.00112960693514 , -0.00259261353947 , 0.00139781077364 , -0.00334337556145 , 0.00298514627895 , 8.32939967554e-06 , 0.00271730888238 , -0.00485851047382 , -0.00173139124132 , -0.00231403135769 , -0.00367296909106 , 0.00690754613427 , 0.00136369809348 , 0.000249024721547 , 0.000900986536586 , -0.00462344447453 , -0.00199551148272 , -0.000470321128626 , 0.00225239150705 , 0.00505931137325 , 0.00126275307069 , 0.00590650349146 , 0.0025921480338 , 0.00107027911793 , -0.00314899389938 , -3.257331405e-05 , -0.00107342976454 , -0.00890023854936 , -0.00138833605902 , 0.000237465335033 , 0.00509424250748 , 0.00203964988048 , -0.0040474830132 , 0.00212202111701 , -0.000335977764984 , 0.00327786980693 , -0.000726523500563 , 0.000961615009796 , 0.000482597741404 , -0.00115132964476 , 0.000894403620661 , -0.00787535292083 , 0.000862309186202 , 0.00603407921833 , 0.000753419565757 , -0.00160398742727 , -0.0010657111156 , 0.00259562034854 , -0.000385813130146 , -0.000121744426285 , 0.000972086894595 , -0.00532205738138 , 0.00269537410334 , -0.0036941350511 , -0.00377499496972 , -0.00381364818482 , -0.00367777593614 , 0.00344326173914 , -0.00214000343248 , 0.00563496554772 , 0.0012309644247 , 0.00226404888856 , -0.000598121871734 , -0.0021011173869 , -0.00184597775988 , -0.00197835942811 , 0.00110734125785 , -0.0024087390171 , -0.00078764526193 , -0.00138266891162 , -0.00278686152025 , 0.00187753360356 , -0.00180295244917 , 0.00519701619047 , -0.00513946944279 , -0.000813911652932 , -0.000557172407021 , -7.67866560787e-06 , 0.00555882798321 , -0.003256740781 , -0.000979003804183 , 0.00428100115318 , 0.00306258266152 , -0.000792791895927 , -0.00050923276796 , 0.00166140689462 , -0.00125218732766 , 0.00115786257606 , 0.000806055517724 , 0.00167202093749 , -0.000316091913374 , -0.00301692313683 , 0.00371273754711 , 0.00365388819199 , 0.00224350399845 , -0.00334415150033 , -0.00561340560481 , -0.00411062032302 , -0.00375494265009 , -0.00302582114354 , 0.00271117378503 , 0.0068786124153 , 0.00309385874051 , 0.00126352368894 , 0.00677939960447 , -0.00507497546102 , -0.000523243292773 , 0.00430948103585 , -0.00438807309089 , 0.000732114780233 , 0.00231839383001 , -0.00111078443448 , 0.00186660077838 , -2.56721723898e-05 , -0.00357884485026 , 0.000991123448658 , -0.00483190828111 , -0.000388071300357 , -0.00152091185048 , -0.00186873777447 , 0.00217543907647 , 0.00145165440757 , -0.00556193239896 , 1.26869071408e-05 , -0.00012290958252 , 0.00288866772261 , 0.00148992159548 , -0.00300481964396 , -0.00189409631241 , 0.00157738485714 , 0.00237837069133 , -5.05725602852e-05 , -0.00173560049979 , -0.00226879832019 , -0.00383668162064 , 0.000593395417875 , -0.00172116292677 , -0.00035547151264 , -0.00146386485476 , 0.0034751519746 , -0.000945984992077 , -2.71991140412e-05 , -0.00145601426116 , -0.00194629664213 , -0.00156092978373 , 0.00597419165803 , -0.000264274765845 , -0.00599948328795 , 0.00206815392253 , -0.00202250726971 , -0.000916949394772 , -0.000154620568076 , 0.00369981284268 , -0.000571098983965 , -0.000214706727709 , -0.00507769060589 , -0.00231411612271 , -0.00304227380802 , -0.000889067363275 , 0.00059165292312 , -0.00423868540081 , 0.0056591911872 , -0.00112988744874 , -0.00164040652585 , 0.00101413822497 , -0.000995565964945 , -0.00130907064921 , 0.00753322168615 , -0.00202659461112 , -0.00130947162647 , 0.0042743388022 , -0.000207241685968 , -0.00220709976101 , -0.00243742240067 , 0.0041771082492 , 0.000444378813795 , 0.00349238704242 , 0.00373975381675 , -0.00159287438465 , 2.38350032454e-05 , -0.00188040683742 , -0.00578311397678 , 0.00336196782684 , 0.00320348503256 , 0.00102739103268 , 0.00109919105107 , -0.00262610176605 , 0.000448210084078 , -0.0027633564178 , 0.000596433797988 , -6.63931634723e-06 , 0.00328335555146 , -0.00241159374926 , -0.00141537071563 , -0.000731453076251 , 0.000235786851869 , 0.000666678181061 , -1.71505410733e-05 , 0.00555235030636 , 0.000965066465013 , 0.00229155324718 , 0.000725103709985 , 3.20016467552e-05 , 0.000759829671247 , 0.00656326019016 , 0.00434089907458 , -0.000295477718202 , -0.00250414624954 , -0.000621881011748 , 0.000686685915313 , 0.00211441140307 , 1.33886284071e-05 , -0.00349514324593 , -0.000308422335099 , -0.000120039922546 , 0.00472293355005 , -0.00226001756869 , -0.000736154785359 , -0.0016817503183 , 0.00138651509191 , -0.00102927135029 , 0.000155735628581 , 0.00532775406841 , 0.00217966827613 , 0.00172246455927 , 0.0027536532554 , -0.00199930479614 , -7.27965898639e-05 , 0.00223953192037 , 0.000286801907163 , -0.00575844995694 , -0.00408644742658 , 0.00403009479828 , 0.000148284307436 , ])
Y_2_0_real = flex.double( [ 0.00660681874086 , -0.00552883452481 , -0.00449302583475 , -0.00533260381376 , -0.00333566028686 , 0.000823470789351 , -0.0045769152873 , -0.0034624577333 , 0.000997564892508 , -0.00517259145012 , -0.000929977840348 , 0.00658191964226 , 0.00623307951497 , 0.00410123637678 , 0.00664769229824 , -0.00234071540614 , -0.00311504121887 , 0.0116811917486 , -0.00348914317882 , 0.00820755079232 , -0.00476512669366 , -0.00343624609698 , -0.00369490231772 , -0.000783919719575 , -0.00573987970249 , 0.00652605814642 , 0.00240079305185 , -0.00256956384469 , 0.00171387633684 , 0.00857636577715 , 0.0145289972426 , -0.00215515868666 , -0.00527799761561 , -0.00172613812746 , -0.0031942241454 , -0.00268431200694 , -0.00430588868829 , 0.00071833267928 , 0.00575998713175 , -0.0023844802784 , -0.00388495400689 , -0.00264435574143 , 6.65775080307e-05 , -0.000276103080431 , -0.00165475420223 , -0.00253559006433 , -0.0016259236124 , -0.00355320734574 , -0.00262126435341 , 0.000575853524164 , -0.0027554368745 , 0.000487621330799 , -0.00335900087036 , -0.00526381780155 , -0.00269250381893 , 0.0031926904513 , 0.00526785136836 , -0.00483370096589 , 0.00522523130334 , -0.00511370204472 , -0.00497537131133 , -0.00487239333285 , 0.00702758827766 , -0.000321053856237 , 0.00504194882166 , -0.0030566674031 , -0.00246130648274 , -0.0051456075711 , -0.000219826523914 , -0.00273444732869 , -0.00138610965465 , -0.00311370367232 , -0.00464372341909 , 0.00484028813064 , 0.0073994240782 , 0.000942950397512 , -0.00155314974493 , -0.00383885857092 , -0.000557802761708 , 0.0029488677655 , 0.00609311399373 , -0.000969683766246 , -0.0028270456333 , -0.00221578768041 , -0.00496074781405 , -0.00272397114757 , 0.0100604754668 , -0.00233696396207 , 0.0050708959182 , 0.000990754366623 , 0.000675959573632 , 0.0082886108643 , 0.00493554160138 , 0.00263954395311 , 0.00145214780871 , -0.00122491089611 , 0.0117935236921 , -0.00374051607814 , -0.00139150464918 , 0.00280045704385 , -0.000127821574679 , -0.00191725359428 , 0.000211995563489 , -0.00349962353205 , -0.00410268926431 , -0.00214572874563 , -0.00270230860708 , -0.00396961311985 , -0.000816527295488 , 0.00807536362118 , 0.00741767218909 , 0.00341693447755 , -0.00420321816522 , 0.0144117122132 , 0.0075593789178 , 0.000233741473084 , -0.0022347619712 , -0.00118055755562 , 0.000299619718563 , 0.00280891797452 , 0.000623777433517 , -0.00341310857145 , 0.00860692797072 , 0.00172921904362 , 0.000187394480431 , -0.00399699210833 , -0.00470178924554 , 0.00572175855822 , -0.00488920221092 , 0.000933226347703 , -0.000691046514597 , -0.00315187958001 , -0.00319301222336 , 0.00491671407091 , 0.00647121006703 , -0.00197496219812 , -0.00386082659303 , -0.00350184051125 , -0.00186578976815 , 4.02530031103e-05 , 0.00671305039097 , -0.00454133538051 , -0.000615858698055 , 0.00610246942661 , -0.00570434891845 , -0.000817477637918 , -0.00255746976213 , -0.00345565591913 , -0.000742942773402 , -0.00103756753477 , 0.00880921571766 , -0.0030063321591 , 0.0047171497775 , -0.00295939928551 , -0.00333810634343 , -0.000910132676678 , -0.00295671286891 , 0.00109431114165 , -0.00413351655238 , -0.00224163503852 , -0.00088509541617 , 0.00811324728101 , 0.00857201819996 , -0.00543309471134 , -0.00423752709264 , -0.00122229747601 , -0.00591593373926 , -0.00404550086974 , -0.00281813884672 , 0.00637873290822 , 0.000127435560891 , -5.92027084544e-05 , -0.000728309790474 , -0.00133001479172 , 0.00449057199126 , 0.0046582287766 , -0.0043515170312 , 0.00155355148654 , -0.00126793337258 , 0.00575143658294 , -0.00316648983129 , -0.0018978978769 , -0.00385347738543 , 0.00397755098667 , -0.00347176573572 , 0.00629798201551 , 0.00425894990499 , -0.00031566642519 , -0.00510884740881 , 0.0110713681249 , -0.000389679208021 , -0.00245822709234 , -0.00164210843809 , -0.00326406567897 , 0.000512767009837 , 0.00198358772088 , 0.00183842580106 , 0.0026245224355 , 0.00215813402227 , -0.00457092668888 , -0.00334199610909 , 0.00217104299038 , -0.000327406759166 , -0.00328803977948 , 0.0069571085277 , 0.00456531972258 , -0.00160514326198 , -0.000473899552726 , -0.00498609968967 , 0.00215642525048 , 0.00241202842157 , 0.00515757746868 , 0.00135070520801 , -0.0020193527481 , -0.00151394377705 , -0.00353141660392 , -0.00253653911322 , 0.000501367348469 , -0.000494537393359 , 0.00388505501023 , -0.0041625651501 , 0.00250540223942 , 0.00210340372652 , -0.00423963915981 , -0.00232357782526 , -0.00203341354086 , -0.00225258856081 , 0.00450217072582 , -0.00569285494457 , -0.000540803972969 , -0.00243238991414 , -0.00136182231376 , -0.00498235915123 , -0.00199958018126 , -0.00453987075 , -0.00460347603777 , 0.00268672771176 , 2.88515889536e-05 , 0.000242505051978 , -0.00456674614877 , -0.00266169536363 , -0.00414843289308 , -0.00108532801398 , 0.00145638582644 , -0.00129880176938 , 0.00459152716591 , -0.00478574369581 , 0.00113525387513 , -0.0045982808083 , -0.00412608530457 , 0.00311592435313 , -0.00146701803132 , 0.00774454609753 , -0.00351593541405 , 0.0035877814424 , -0.00385934426412 , -0.00462339615351 , -0.0032248626516 , -0.00238709041645 , 0.000927844421223 , 0.0031575493631 , 0.00397331981933 , -0.00131989335856 , -0.00260372247291 , -0.0011453113085 , -0.00236817513258 , 0.00112720483408 , 0.00198085557311 , 0.003850084834 , -0.00362364431795 , -0.00317942804772 , -0.00189912705043 , 0.000142648269849 , -0.00297381030376 , 0.00104443963163 , -0.0025977523109 , -0.00548423492478 , -0.00382274443688 , 0.000382607754327 , -0.00239783250992 , -0.0014216795317 , 0.0026255084338 , -0.00463011176068 , 0.00170661972402 , -0.00484181315507 , 0.000114836636948 , 0.00326909410323 , -0.00333242201431 , -0.000829988633324 , -0.00229669726213 , -0.00335730912852 , 0.00157287674434 , -0.00456330004601 , -0.00379606346209 , -0.00427517582156 , -0.00413370785006 , 0.00343170804234 , -0.00453292140649 , -0.000849115650539 , -0.00297237961825 , 0.00478583906753 , -0.00255082758154 , 0.000731389351859 , -0.0053486758247 , 0.00374701478555 , 0.0020977471105 , 0.000309676000845 , 0.00613781953395 , -0.00233230278631 , -0.00455894917355 , -0.00358376537429 , -0.00315500849419 , -0.00357196880798 , -0.00321075442294 , -0.0057676214491 , -0.00164683186434 , 0.00207674019841 , -0.00152423077337 , 0.00229324661256 , -0.00261656692409 , -0.00246787239158 , 0.00867051603885 , 0.00100944609683 , -0.00349599853927 , 0.0062314317793 , -0.00344173353437 , -0.00399311860667 , -0.00185643440362 , 0.00740756913554 , 0.00215947562357 , 0.00950626422734 , -0.00111794997623 , 0.00198808333461 , 0.00708655640207 , 0.00401307281973 , -0.00642773608864 , -0.00233715907152 , 0.00429038913537 , -0.00572861451436 , 0.00374507704123 , -0.00400745643916 , 0.00851616499063 , 0.0043569703646 , -0.00400030473081 , -0.000227583152909 , 0.00029969957104 , -0.00203709903276 , 0.0100496470985 , -0.00248850404847 , 0.00815173550355 , -0.00353396125269 , -0.00216396961168 , -0.00140919015484 , -0.00030824623743 , -0.00376175750604 , -0.00441658545527 , -0.000832158272927 , -0.00384271322685 , -0.000476530007669 , 0.00422465895142 , -0.00536671630784 , 0.0160065398305 , 0.00516334551345 , -0.00335719884772 , -0.00390051710591 , 0.00179529258797 , -0.00365540956911 , 0.00106009788024 , 0.00131332984728 , -0.000197103786162 , 0.0026106834858 , -0.000602677449551 , -0.00214975243894 , -0.00462526801493 , -0.0027162546919 , -0.00291460397398 , -0.00208623262286 , 0.000789131376205 , 0.00181698706914 , 0.000797065583916 , -0.00275185144632 , -0.0036705315306 , -0.0022757188844 , -0.00207678275974 , 0.00275112756153 , 0.00618317235941 , 0.0032990000162 , 0.00167929882153 , 0.0019774775573 , -0.0054452141951 , -0.00296164181573 , -0.00114526393462 , 0.00138131951724 , -0.00501025038591 , 0.00910516606992 , -0.00393530893125 , 0.00600469068685 , 0.00527310295671 , -0.00315620976121 , -0.00360548370937 , 0.00100719002593 , -0.00460605231168 , 0.00561943211111 , 0.000322676132051 , 0.00122155728459 , 0.00429682445234 , 0.0066476532544 , 0.00460397701349 , -8.16394198119e-05 , -0.00261704849466 , -0.0035969593001 , -0.00340958364296 , -0.00213854789864 , -0.00513450779068 , 0.00729203354379 , 0.00238099045031 , -7.59802637795e-05 , -0.00457030372664 , -0.00357417131709 , -0.00362882477822 , -0.00034995539893 , -0.00263129164673 , -0.0038872762495 , -0.0018394545429 , -0.00278041731423 , -0.00159561029685 , 0.00271904316558 , -0.00141047613788 , 0.00468368580463 , 0.00530685115857 , -0.00242936796168 , -0.00349518331356 , -0.00207668281195 , -0.00440305281428 , -0.00257151167071 , 0.00608097319255 , -0.00378142291231 , 0.00746953252961 , -0.00512333749908 , 0.00655225364722 , 6.21672889722e-05 , 0.00123081391974 , 0.00174574689243 , -0.00429821015787 , 0.00553534517592 , 0.005989727876 , 0.00137566321124 , -0.00248809698412 , -0.00195236065187 , 0.00454875601382 , 0.000773442999087 , -0.00371101430581 , -0.00135406777729 , 0.010281748603 , 0.00171969202042 , 0.00438372998429 , 0.0010652425634 , 0.00161218570043 , -0.00295087738295 , 0.00211306600759 , -0.00434678912451 , -0.00374935950821 , 0.00552501598797 , 0.00542866271821 , -0.00337305934558 , -0.00184865902855 , -0.000917643959037 , -0.00466299611001 , 0.00681652113296 , -0.00423617139791 , 0.00745786235456 , 0.000872991860299 , -0.000287796744982 , -0.00478705059968 , -0.00344964802859 , 0.00222643881081 , -0.00352609199458 , -0.000908974838717 , -0.00575084582069 , -0.00381197349883 , -0.000648975083933 , -0.000180310679496 , 0.00455587898338 , -0.000789135278755 , 0.00226022572368 , 0.000198208181535 , 0.00350185199692 , -0.0035791331687 , -0.0035849065267 , -0.00506595234342 , -0.00314718140446 , -0.0047659996898 , 0.00337710270128 , -0.00163516960858 , -0.000934128089251 , 0.00511778479926 , -0.000917975207846 , 0.00388925856772 , -0.00236076949284 , -0.00364733606159 , 0.00395019316143 , 0.0046943154874 , 0.00242299514301 , -0.00339979847923 , -0.00172574211699 , -0.00199276872018 , -0.000294406742601 , -0.00237623089114 , 0.00113373416113 , 0.00300151783393 , -0.00132611266737 , -0.00548835608121 , 0.000415673559881 , -0.001323979883 , 0.00314347979641 , -0.00526284857609 , 0.000434986219693 , -0.00339507656839 , 0.00299379136533 , -0.00539937146895 , 0.000860233196767 , -0.00647087486014 , -0.00141834989874 , -0.00248015007988 , 0.00656599013128 , 0.000770245573293 , 0.00221849043228 , -0.000994078423772 , -0.00538948868266 , 0.00528019265688 , -0.000234254417736 , 0.00171536725224 , -0.00308392829149 , -0.00330250765234 , -0.00249483471492 , 0.00252112984931 , -0.00183198144064 , 0.00585049724216 , -0.00299536607036 , -0.00414627521637 , 0.00291029958416 , -0.0021414354089 , -0.00307361115295 , -0.0040111019181 , 0.00150389900434 , -0.0043598944202 , 0.00654148279834 , 0.00924563682568 , -0.00331260254453 , -0.00528981588366 , -0.000468226322672 , 0.00287952245145 , 0.00370583729804 , 0.00864290599348 , 0.00128125036394 , 0.00182883100226 , 0.00182356082305 , 0.00145628386419 , 0.00280807906505 , 0.00205020872143 , 0.000564063401045 , -0.0046163380075 , -0.00328194915741 , 0.0118357460868 , -0.00465117099537 , 3.57684491974e-05 , -0.00125720933963 , 0.000792053224545 , -0.00110429939776 , -0.00343496335676 , -0.00414250573013 , 0.000248524219651 , -0.00382924309196 , -0.00372454758997 , -0.000540236091886 , -0.00341739996892 , -0.00205599269326 , -0.00169592636536 , -0.00181866797901 , 0.00735484825597 , 8.71410055222e-05 , 0.00906386666421 , -0.00565931102347 , -0.00342361723319 , -0.00334579809911 , -0.00333634497353 , 0.00349034058953 , -0.00105134361435 , 0.00607806540736 , -0.000974765114131 , -0.00341911530137 , 0.00447679175157 , -0.00251675889925 , -0.00407285923841 , -0.00495995416976 , 0.00753441434347 , -0.0028421291996 , -0.00288777624108 , -0.00320445310238 , 0.00608091284444 , -0.00205743035805 , -0.00603538281284 , -0.00282450488782 , -0.00409129019479 , -0.00197604430741 , -0.00169421628268 , -0.00158601103021 , 0.00416372768059 , -0.000826872565726 , 0.0081188556802 , -0.0034325467121 , -0.00371971291399 , 0.00282394560815 , -0.00374434942596 , 0.000399321678139 , -0.00324434338751 , 0.00451813406669 , 0.00577105484254 , -0.00156038873578 , -0.00437750280102 , 0.00362586486992 , -0.00313088853618 , 0.00942966460788 , -0.000801457979304 , 0.00548049180256 , -0.00268749711871 , -0.00292092183473 , -0.000367188478474 , -0.00325599053054 , 0.00696454023603 , -0.00179789906933 , -0.00420722665817 , -0.00322294076614 , 0.0014495728041 , 0.000862901298258 , -0.00408717166506 , -0.00355175114328 , 0.00716660018055 , -0.00424343642101 , -0.00367535806152 , -0.00665168130287 , -0.0040727743563 , 0.0022830772846 , 0.00855060228322 , -7.34440622478e-05 , 0.00557508145129 , -0.0021742803744 , 0.00236143373781 , -0.00263822394324 , 0.00827396115216 , 0.00062259255207 , -0.000786979188228 , -0.00175928861858 , -0.0036100448278 , -0.000105686558558 , 0.00867091342806 , -0.00312123475067 , 0.00223364491929 , 0.00470314660103 , 0.00427684096359 , 0.00776917656728 , 0.000231532029015 , 0.00170836993901 , -0.00456335022141 , 0.00114249756129 , 0.0014458220507 , -0.00454714191431 , 0.00680598741947 , 0.00884901504584 , 0.00256436899427 , 0.00262735639412 , -0.0051085076664 , -4.63749383982e-05 , 0.00270089338654 , -0.000576446426292 , -0.00370233970178 , 0.00319295402438 , -0.0021343222871 , -0.00316173904149 , -0.00210618453973 , -0.00426294447731 , -0.00117017601813 , -0.0013154108879 , -0.00258668892539 , -0.00348499045963 , 0.00364737890682 , -0.00130505140417 , -0.00130275763059 , 0.00498300562176 , -0.00304111788752 , 0.00426381970962 , -0.00308606606574 , -0.000462381188494 , 0.00139248832741 , 0.00115390370883 , -0.0037539201951 , -0.00086812463279 , -0.00592051888726 , 0.0048590477309 , -0.00364929433096 , -0.00360472127564 , -0.00354975424963 , -0.00364438656782 , -0.00288924937279 , 0.00148685531423 , -0.000860814426301 , 0.00115090634387 , 0.0059345754314 , -0.00401330360493 , 0.00493626696781 , -0.00340988583131 , -0.00284244928172 , -0.00451120505166 , -0.00267116206263 , -0.00449606057046 , -0.00548962586293 , -0.00501843927539 , -0.00265271169714 , -0.000613361404484 , 0.00112780414205 , 5.33513633082e-05 , -0.00138568041949 , -0.00227701645333 , 0.00364053089728 , 0.00156676798665 , 0.000641777099156 , -0.00399248211263 , -0.00370170708152 , 0.00662189200578 , 9.28687786816e-05 , 0.00849665457033 , -0.00335864559457 , 0.000646993809206 , -0.00212591336535 , 0.00354721898789 , 0.00358315062068 , 0.00619892194572 , -0.0019152868431 , 0.0150051041986 , 0.00571354818196 , -0.000936421568691 , -0.00306501990472 , 0.00380891747189 , -0.00342129005955 , 0.00807595790198 , 0.000435665445593 , 0.00113379236295 , 0.0114287451094 , 0.00220006825201 , 0.00350500809451 , -0.000550320502066 , 0.00286888790839 , -0.00340775256017 , 0.00995218206545 , -0.00160266401228 , 0.0067258402276 , 0.00667632345396 , -0.00189201707235 , 0.000157980351215 , 0.000330089484325 , 0.0176659593251 , -0.00416382269792 , 0.00155993060121 , 0.00261398709029 , -0.00127206276039 , -0.000510077378832 , 0.0031366132074 , 0.000806748207732 , -0.00549208360861 , -0.00115103916356 , 0.00274998181719 , -0.000264645502007 , -0.00166485917083 , -0.00508290402426 , 0.00532451556638 , 0.000187995073033 , 0.00223133289909 , -0.00589194390113 , 0.00708309491091 , -0.00427937590508 , -0.00200359065254 , 0.00959334196989 , 0.00576951182376 , 0.0087760181655 , -0.0013793954285 , 0.00295978720302 , -0.00372235646473 , 0.00092906195238 , 0.00204177798589 , -0.00117998134338 , 0.00365700831439 , -0.00173565003079 , 0.00515467869236 , 0.00492158359126 , -0.0036017185285 , 0.000212134909088 , 0.00103969708902 , -0.0039722657321 , 0.00474139848582 , 0.00980653634138 , 0.00216224365883 , 0.00570970048449 , -0.0050299794948 , -0.00326024653132 , 0.000958368960292 , 0.00751082174321 , -0.00093894883296 , 0.000860830109549 , 0.0023938389403 , -0.00220771364046 , -0.00195473044842 , 0.00199028570713 , -0.00679513063243 , 0.00536016489645 , 0.00846463842582 , -0.00262095216424 , -0.00358841681627 , -0.00378695198577 , 0.00410814754584 , -0.004558123324 , -0.0034260010214 , 0.00198348455937 , 0.000267995574266 , 0.0085593803904 , 0.00131580670907 , 0.00182532786482 , -0.00408550431328 , 0.00625547559572 , 0.00690382069781 , -0.00191306586055 , -0.00636611962372 , 0.000498164498005 , -0.00292444336192 , 0.000563019464139 , -0.000315263098952 , -0.0041089327704 , -0.00101125836347 , -0.00340068145062 , -0.00359994987914 , 0.00653239111379 , -0.00214009060958 , -0.00385814554272 , 0.00344336627021 , 0.00547577093717 , -0.00297828638198 , -0.00287516563087 , 0.0082443305772 , -0.00142109685492 , -0.00162885411 , 0.00320298243577 , 0.00515877152359 , 0.00588760691119 , 0.00151045653911 , 0.000699010581984 , -0.00325511131126 , -0.00310017013228 , -0.00448304796323 , 0.00468590678773 , -0.00436194052054 , 0.00227737998715 , -0.00396330313381 , 0.0117138397147 , 0.00410459116792 , -0.00473486044999 , -0.000911129356043 , -0.00419066261652 , 0.00383849713032 , -0.00239391266793 , -0.00304091482154 , -0.00535604732507 , -0.000793414454171 , 0.0020210962988 , 0.0113068484277 , -0.00343928128233 , -0.00355629595432 , -0.00519869950389 , -0.00313623401203 , 0.00440600491839 , -0.00299827019067 , 0.00129448418298 , -0.00349043782355 , -0.00230017894459 , 0.0104003589879 , -0.00360826203743 , -9.42211524208e-05 , 0.00111177103778 , -0.00427450980053 , -0.0020490042646 , 0.00116480133637 , -0.00292952675858 , -0.00100771003168 , -0.0001927705135 , -0.00100589545212 , -0.0048600608509 , -0.00444944076057 , -0.0042910641602 , -0.000640263220369 , 0.00522524865471 , 0.00625950564271 , -0.00507844604969 , ])
Y_2_0_imag = flex.double( [ 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , ])
Y_2_1_real = flex.double( [ -0.0 , 0.00106915568735 , 0.00057381532154 , 5.95347363338e-06 , -0.00195352052517 , 0.00203184108506 , 1.90708542801e-05 , 0.00262350170526 , -0.00562805636682 , -0.000306279314197 , -0.00445268254267 , -0.00113787294143 , -0.00235865916205 , -0.000906396956608 , -0.00392997519062 , 0.00114223951762 , 0.0013494809011 , 0.0070892103539 , -0.000344666903256 , -0.00328427939951 , -0.00180865010966 , -0.000364351797778 , 0.000176858010866 , 0.00515963774894 , -0.0022486069386 , 0.00764940650209 , 0.00511507411323 , -0.000156575288501 , 0.000521408855004 , -0.00188260659804 , 0.00340148656167 , -0.000391034443505 , 2.33628188527e-07 , 0.00374094825081 , 0.000331369070347 , 0.00368160282865 , 0.00184835416289 , 0.000191348888678 , -0.000472892214036 , -0.00154469739762 , -7.73469528302e-05 , 0.00374699566781 , -0.00336026573673 , 0.0043646672263 , -0.00322676981827 , 0.00365153970261 , -0.00406779998974 , -0.00274280201644 , 0.00345515667111 , 0.00231620063348 , -3.61398998276e-06 , -0.00474935735799 , -0.00290059159997 , -1.06526310564e-06 , -0.00283734204781 , 4.78366565028e-05 , -0.00280257220929 , 0.00135308998346 , -0.00604534822821 , -0.000106263066811 , -0.00109820266788 , -7.47215279533e-05 , -0.00283794636005 , -0.00153327715857 , 0.00444117749267 , -0.000125897285938 , -0.00256168910516 , -0.00309180819922 , 0.00069448538487 , 0.00227252177703 , 0.0043813753178 , -0.000940125275674 , 0.000596868627791 , 0.00327114254872 , 0.000324818789363 , -0.00437583849635 , 0.00130350586987 , 0.0043192544719 , -9.5932434905e-05 , -0.00263325099348 , 0.00390320602633 , 0.00617755759236 , 0.002814654922 , -0.00319748556638 , 0.000897651386159 , 0.00355157665996 , -0.000581733629855 , 0.00116095534954 , -0.00376404143346 , -0.00435785652372 , -0.00468267763365 , -0.00262241839059 , 0.00209548036107 , -0.000325082369427 , 0.00237749849927 , -0.00117246759653 , 0.00176043478682 , 0.000465601714472 , 0.00102612672147 , 0.00474509572373 , -0.00386358930453 , -0.0018137114817 , -0.00112656903133 , -0.000249197351525 , -0.000345709111313 , -0.00441402682352 , -0.000403037165659 , 0.000169051077674 , -0.00260230981424 , -0.001412399373 , 0.00324475297803 , -0.00308500031037 , -0.000421274077494 , -0.00109879303963 , -0.00296672398915 , 0.00212218750335 , 0.00429194271874 , -0.0036477066322 , 0.00143487439201 , 0.0051684696738 , 0.003713133687 , 2.62414608981e-05 , 0.0020062505422 , -0.00319226417111 , -0.00393765959242 , 0.00160673438896 , 0.00230938952849 , 0.00164246872743 , 0.000969295097836 , 0.00155945271156 , 0.00510434995126 , 0.00461356466171 , -1.63640832636e-05 , -0.00267228207559 , 0.000114442700675 , -0.00460172231253 , 0.00104781462526 , -0.00130212916029 , -0.00500101369489 , -0.00109928847261 , 0.00218384851421 , -0.000322342451098 , -0.00333209402253 , -0.00430767907204 , -3.86884870683e-05 , 0.00485500141392 , -0.0025740560221 , -0.00202490817508 , 0.000920825072575 , 0.00366175969602 , -0.00094404756512 , 0.00027096304922 , 0.000792538943057 , 0.000182132061408 , 0.00144789458774 , -0.00162023085204 , -0.00177384385245 , -0.0031784931079 , 0.00131688921598 , 0.000403337003384 , -0.00110263332605 , 0.000922129855311 , 0.00356677572117 , 3.63154819079e-05 , -2.96127758444e-05 , -0.00194584551061 , -0.000224221451002 , 0.00141132705885 , 0.00249620395825 , 0.00453187394827 , 0.00487314599065 , -5.06840720644e-05 , -0.00191182148136 , 0.00195881992025 , -0.00147290186606 , 0.00446090137895 , 0.0012375359714 , -0.00586875218655 , 0.0019735419015 , 0.00049659266497 , 0.000227669437264 , -0.00282425590831 , 0.00201510188646 , 0.00568058864391 , -6.76964429579e-05 , 0.00348566340208 , -0.00529347652918 , -0.00349667542847 , 0.00135782364649 , -0.00138966486143 , -0.00142138664706 , -0.000818053714115 , -0.00075199708664 , -0.00327188910098 , 0.00458033138678 , -0.00207556480175 , 0.000701714714039 , -0.00243522661326 , -0.00115115049734 , -0.00272270190191 , 0.000430478237315 , -0.00374744458219 , -0.00477284675567 , -0.000817681762986 , -0.00497850518947 , -0.00110002567418 , 0.000229166844653 , -0.00266783784992 , -0.0027857266765 , 0.00693637765795 , -0.0045746558861 , -0.00041666033514 , 0.000756449498001 , 0.00375840175656 , -0.0035131933103 , 0.00226463936434 , -0.00334525219069 , -0.000654253016016 , 0.000584205795983 , -0.00687309626363 , 0.00215254496698 , -0.00414979306479 , -0.0058673779994 , 0.00122317423447 , 0.00184717095414 , -0.000128366767562 , 0.00299894317087 , -0.00460583020427 , 9.74790344486e-05 , -0.0020514169116 , -0.00480761078817 , -0.001321922534 , 0.000955870173782 , 0.00354443184209 , -0.00126697310502 , 0.000135339679329 , 0.000528974705471 , -0.00270418961247 , 0.000693002912757 , -0.000986405718295 , 0.00101760553211 , -0.000309899643776 , 0.00211313593603 , 0.000794209325857 , -0.000519740481921 , -0.000154901173735 , 0.00233854931232 , -0.00455700232105 , 0.00026186638169 , -0.000283374881809 , -0.00343658871515 , -3.19479065169e-05 , -0.00407993448077 , 0.00257553795066 , -0.00256264894044 , -0.00301397629705 , 0.00109208083292 , -4.42470184209e-05 , 0.00221940775862 , -0.00146482499961 , -0.00166919256781 , -0.00345695984029 , -0.000435834385013 , -0.00169934358035 , 0.00385256097658 , -0.00435870656982 , -0.00534187356408 , 0.00094703972981 , -0.00353802160693 , -0.00310273816073 , -0.000928009690721 , -0.00188927412345 , 0.000403616764306 , 0.0032805295046 , -0.00440395966479 , 0.00112683352314 , 0.000339680653235 , -0.00328660303651 , 0.00484803174761 , -0.00106122291776 , -0.00240556746704 , 0.00276861289543 , 0.00321971515677 , 0.00285720532447 , -0.000368647756156 , 0.00371265215261 , -0.00662447306605 , 0.000148969139832 , 0.00191832723332 , 0.00159538742385 , -0.00189794772488 , -0.00285187152392 , -0.000379157265826 , -0.00127761797881 , 0.00022353210222 , -0.00167901863169 , 0.00435042222889 , 0.000678757763675 , -0.00523600195153 , -0.00140057466508 , -0.000126745707294 , -1.68001614866e-05 , 0.00339014292934 , -0.00112864116115 , -0.00350419913411 , -0.00604812920789 , -0.00306547582966 , -0.00515913879281 , -0.00407367164809 , -0.000124663824874 , -0.00084647486972 , -0.000776307909574 , -0.0031902126617 , -0.000541326067623 , 0.000387897577482 , -0.000123757009199 , -0.000725631848116 , -0.000798272834813 , -0.0019893637269 , 0.0033608766788 , 0.000544243933116 , -0.000648112114547 , 0.00389724736204 , 0.000153404555301 , -0.00489274921548 , -0.000986791312502 , 0.00133540376498 , 0.000202089853179 , 0.00837729134856 , 0.00672798297703 , -0.000649330509403 , 0.0016283442983 , -0.00184374183295 , -0.00325286155246 , 0.00141335380479 , 8.06090816414e-05 , -0.00169054871537 , 0.000102145509633 , 0.00111602723916 , -0.00525802714883 , -1.83485014298e-05 , 0.00210309356083 , 0.00250231366941 , 0.000165537556147 , 0.00140577449668 , 0.000194186290433 , 0.00164604439113 , 0.00101578951491 , -0.00219008325586 , 0.00694702142427 , 0.00314519004234 , 0.00159882854313 , 0.00155428909448 , -0.00367741364212 , 0.00224309060532 , -0.0010089941053 , 0.00262786305717 , 0.00120625879519 , 0.00367065587051 , 0.00237743295594 , -0.00189619288735 , 0.00533802157611 , -0.000271131090408 , -0.00157331538474 , 0.000969129457556 , 0.00606139211879 , 0.000491314449672 , 7.64653247211e-05 , -0.00250769268079 , -0.00136055946787 , -0.00293501586593 , 0.00362012769175 , -0.00248725750061 , -0.00124260435252 , 0.00284976086187 , -0.00215185927892 , -0.000770743148999 , -0.00310052757346 , 0.000286721184784 , -0.0056747694547 , -0.000869335614178 , -7.94423136189e-05 , -0.00233486173402 , -0.00467765934259 , 0.00661333979283 , -0.0014560962058 , -0.00173511879597 , -0.00123958255477 , 0.000257722465325 , 0.00122465158038 , 0.000102264626553 , 0.000966963776157 , -0.0046640295186 , 0.00231137357038 , 0.00462375628718 , -0.00310258695534 , -0.000517706462434 , -0.00294156360039 , -0.000372134760575 , -0.00130287728826 , 0.00103625452588 , 0.00293774642275 , 0.00347127314185 , 0.00468667882558 , -0.000396154605262 , -0.00487500411446 , 0.00206461913413 , 0.00303153093829 , -0.00263611151544 , -0.00221559531622 , 0.000525109457694 , -0.00104735356289 , 0.00107361193328 , 0.000137421532209 , -0.00324684744398 , -0.0064072269378 , 0.00407633722719 , -0.00197791746789 , 1.50830936102e-05 , 0.0010753939205 , 0.00463366153911 , 0.00437289013307 , 0.00274095518597 , -0.00108119825897 , 0.000293982156134 , 0.00408491388533 , 0.00478906970687 , -0.00298224877377 , -0.00371664053971 , 0.00145863216256 , 0.00143897374104 , -0.000327291624388 , -0.00333610895828 , -0.000781665036951 , -0.0031586572984 , -0.000503778569347 , 0.00218822893217 , -0.00168119569999 , -0.00140406013274 , 0.00337322717359 , 0.00607025483621 , 0.00499796132112 , -0.00374208507789 , -0.00176892881481 , -0.00165733962946 , -0.000680450845028 , -0.000371406391145 , 0.00123521373977 , 0.00420650252978 , 0.00426402199518 , 0.0023842445014 , -0.00333498882181 , -0.00494129353299 , -0.00504564058774 , -0.00313101355037 , -0.00102249043496 , 0.00573457172756 , 0.0034796477966 , 0.000582230683791 , 0.00529420989569 , -0.000151320950164 , -0.000268010431534 , 0.00579060554934 , 0.00503444016065 , 1.97330442268e-05 , 0.0039196566918 , -0.00544879662306 , -0.000739719481485 , -0.0038708202027 , -0.000912768990885 , -0.00608667577295 , -0.00462564593827 , 0.00581906804963 , 0.000940119210553 , -0.00414683163748 , 0.00429668331012 , -0.000421453531649 , -0.00538613020942 , 0.000465981259566 , -0.000539657993702 , -0.00358138730906 , -0.00466368243483 , 0.00368553935252 , 0.00383051056097 , 0.000472105513472 , 0.00434509326733 , -0.00637151251423 , 0.00289898900667 , -0.00133007243757 , -0.00118028638439 , -0.00397154433455 , 0.000264012596374 , 0.00625727401997 , -0.00442484241937 , -0.00135907172473 , -0.00586190182921 , 0.00182530578123 , -0.00289027393711 , -0.00032153057101 , 0.000374923131585 , 0.0039486631321 , 0.00217407846104 , -0.00336671193086 , 0.000628114185265 , 0.000299704175078 , -0.00310793518375 , -0.000544460979222 , -0.000330850052146 , -0.000671744867202 , 0.000586665082443 , 0.00363242725105 , 0.000187568000852 , -0.00630101443111 , 0.00444028972639 , -0.0012102407546 , -0.00137475727552 , -0.00249434468757 , -0.000849873133585 , 0.00612610716167 , 0.000800745819119 , 0.001783033309 , -5.32621040218e-05 , -0.00260402873574 , 0.00198519753645 , 0.00226578014876 , 0.000505435353967 , 0.00485481395625 , 0.00335290282539 , -0.000997023140757 , -0.00166670291029 , -6.94740602205e-05 , -0.00226345919164 , -0.000205333622174 , -0.000581680173162 , -0.00112972621498 , -0.00376092449198 , -0.000972931577243 , -0.00257389721987 , 0.000962765136957 , -0.00091375787409 , -0.00190041236025 , 0.000741238105498 , 0.00168390058083 , 0.000772994567187 , -0.000188552057364 , 6.18240695823e-05 , -0.0013648599583 , 0.000273070413553 , 0.00316749486942 , 0.000385833275589 , 0.00488611901131 , 0.00543085535421 , -0.000292277830189 , -0.00107791124551 , -0.00538149152527 , 8.55582536785e-05 , 0.00137583673106 , 0.00197152134211 , 0.00283254582796 , -0.00563211297177 , 0.000930236407214 , -0.00239549164899 , 0.00113882342348 , 0.003303179166 , 0.00114589383956 , -0.00540459976955 , 0.00337327739488 , -0.00182403995505 , 0.000641655905008 , 0.000357218742559 , 0.00187303774969 , -0.00488818616506 , 4.62013774611e-05 , -0.000996236752923 , 0.00545213340718 , 0.00237946554274 , 0.00319803833599 , -0.0010781488359 , 0.00223176630477 , -0.00314028350394 , -0.000280181190384 , -0.00239504274834 , -0.000639731683838 , -0.00426113885731 , -0.000273406477542 , 0.00239808445269 , 0.00333248901621 , 0.002564310681 , 0.00258647054613 , -0.000385924797293 , 0.00160138596995 , -0.00280006914287 , 0.00299659857946 , 1.99377800227e-05 , -0.00021400298584 , -0.004607328405 , -0.00475009748044 , -1.96931511761e-05 , 0.00179477678807 , 0.00257419707843 , 0.00337328840906 , -0.000281547929867 , 0.00252662817258 , 0.00030036417286 , 0.00473302800362 , 0.00530838647625 , -0.0046077688731 , 0.00282077376261 , 0.00283238421252 , 0.00268289354809 , -0.00349808734108 , 0.000382985406892 , 0.00625920321891 , 0.001896857821 , -0.00245434612732 , 0.0013764490632 , 0.00187392018677 , 0.000410371152382 , -0.00464855883951 , 0.00337574217924 , 0.00432813112637 , 0.000698471328251 , 0.00466790836179 , 0.00481633756297 , -0.00165399966385 , 0.00297860112818 , -0.000873907667894 , 0.000631448168792 , -0.000359229045592 , -8.25805453626e-05 , 0.000600958503674 , -0.00117016279205 , -0.0020566167386 , 0.00225951072806 , -0.00279595496132 , -0.000364543221645 , 0.00227776390313 , -0.00694688720097 , -0.00021725441306 , -0.00269508351437 , -0.000710431216835 , 0.00159485783204 , -0.00414375311519 , -0.00245591542396 , 0.00153786709673 , -0.00362840428927 , 0.00332029685129 , -0.00208763926324 , 0.00259779188041 , 0.00392253533915 , 0.0014608560799 , -0.00407516354721 , -0.00349981992669 , -0.00100491319385 , 0.00444548082825 , 0.001829295921 , -0.001627848849 , 0.00223048853329 , -0.000879047735529 , 0.00077631867078 , -0.00119954730412 , 0.000231520602064 , 0.0028300066106 , 0.00078720459939 , -0.00147750610993 , 0.000193155180031 , -0.00198534247322 , -0.00173324133969 , -0.00330066652791 , 0.00305945799256 , -0.00333457588953 , 0.000146345322337 , 0.000121774914226 , -0.00038992011688 , -0.0056867655711 , 0.000706519995442 , 0.00476226157383 , -7.14639316483e-05 , -0.00184729211045 , 0.00381366998496 , -0.0022912678746 , -0.00369409035846 , -0.00194458209527 , 0.000944244116962 , -0.0036675925316 , 0.0016332169951 , -0.00224052311643 , -0.00150497435509 , 0.00455021497919 , -0.000566961726053 , -0.00495078794371 , 5.36349867821e-06 , 0.00019696396228 , 9.40127978901e-05 , 0.00397747389035 , 0.000687949519135 , 0.000214422293932 , -0.000268495651057 , -0.00295519352273 , 0.000481607772855 , 0.00142939072957 , -0.00128741237649 , -0.00254957793541 , 0.00296284255628 , -0.00561330610824 , 0.00324648449477 , 0.00172972812225 , 0.00476746932408 , 0.000378889972399 , -0.00448569073897 , -0.000531217220647 , 0.00244220688709 , -0.00304349492032 , 0.000450010035288 , 0.00150634468599 , -0.000439772866984 , -0.00146576498998 , 0.00262294646214 , -0.00485517375584 , 0.00460544049452 , -0.00274902774376 , -0.00099291090389 , -0.000120195140532 , 0.000696060671403 , -0.00287479543287 , -0.00118829460196 , 0.00201491469152 , 0.000899829454003 , 0.000594152728193 , 0.00470776337985 , -0.00277609245901 , -0.00156034266203 , 0.00343354754504 , -0.00185548128369 , -0.00535860839428 , 0.00404536060814 , -0.00463273957626 , -0.00379329068831 , 0.00154014670425 , 0.00657554457257 , 0.0024966211057 , -0.000303060519351 , 0.00480922521023 , -1.69342150602e-06 , 0.000191747766853 , 0.00166644114915 , 0.000831733564321 , 0.00673378700598 , 0.00168612363373 , -0.00224383714399 , -0.00352679268261 , 0.00387633548122 , -0.00125320721549 , 0.00151323922481 , -0.00293047389963 , 0.00188367807165 , 0.00823225687966 , -0.00174917277706 , -0.00135326540868 , -0.000121359835701 , 0.00123136726808 , -0.00202248215949 , 0.00104603712653 , -0.00106323295785 , 0.00130299097709 , -0.00624707970707 , -0.00159542913725 , 0.000863378025528 , 0.000788970252768 , -0.00132292447784 , 0.00276555051725 , 0.00347682466876 , -0.00118064989184 , 0.000182373059535 , -0.00161392901861 , 0.00500509505515 , -0.00460224201611 , -0.000574630419937 , -0.00158293735089 , 0.00260797925068 , 0.000834772603893 , -0.00201022347676 , 0.00360607091928 , 0.00201214017522 , 0.000594819158571 , -0.00686034120318 , 0.00179532733378 , -0.00587894364911 , -0.00367856272759 , -0.004822269857 , -0.00329082139747 , -0.00387833762777 , 0.00531921494601 , -0.00310639490074 , 0.00116688521781 , 0.00241077586147 , 0.00373114160456 , 0.000169764459282 , 0.00354027154662 , 0.00393303040701 , 0.00117011700772 , -0.0027084828219 , -0.00288843698723 , 0.00033319378737 , -0.00385847451249 , 0.000620163112695 , -0.00234053775177 , 0.00569261455359 , 0.000669527747176 , -0.00245293479278 , 0.00421885865471 , -0.00242636576734 , 0.000540533310449 , -0.00272795175117 , -0.00298473840042 , -0.00173504742693 , -0.00186432199373 , -0.000248501458862 , -0.00179375541183 , 0.00104851428851 , 0.000603876460838 , 0.0050091488029 , 0.00212864464428 , 0.00413715644947 , 0.00163324786282 , 0.00524074703815 , -0.000649661302642 , 0.00261130738084 , 0.00569085698197 , -0.000752000844008 , -0.00140542664437 , -0.00260437721453 , 0.00448995459751 , 0.00149282406812 , -0.00292971052688 , 0.00260484917217 , 0.00222819916063 , -0.00331357926839 , -0.00434499131473 , 0.000674169374731 , -0.000736813094204 , 0.000714574589088 , -0.00103902656033 , -0.00565642797934 , 0.000229656569581 , -0.00185022994113 , 8.72303156613e-05 , 0.000168186631664 , 0.00564659934925 , 0.00493407206669 , -0.00555678396111 , 0.00128237435016 , -0.00344524731525 , 0.000488476762274 , 0.00325702595012 , -0.00371203691571 , -0.000542351369361 , -0.00267029615598 , -0.000871245534915 , 0.00744879366477 , -0.000811273729188 , 0.0077992333717 , -0.000296959054879 , -1.25648673902e-05 , -0.000627665445252 , 0.00124865934599 , -0.0055484525327 , 0.00061212237274 , 0.000279005259283 , 0.00169798344285 , 0.00305258620408 , -0.00266256826398 , -0.00160890257804 , 0.00325319385814 , 0.00263582863689 , 0.000949678025311 , -0.00163265189216 , -0.00605574371549 , 0.00120782771613 , -0.00364388476699 , 8.84284015862e-05 , -0.00283040609662 , 0.00188644514724 , 0.00201314844639 , 0.00259015410134 , 0.00499675157775 , -0.000853971549508 , -0.000278156591862 , 0.00426655968482 , 0.00251906906229 , 0.00382004724397 , -0.00268878390349 , 0.00223260694857 , 2.20793734756e-05 , -0.00103604214156 , 0.00130856624833 , 0.000607555929921 , 0.000660144525044 , 0.00135123790705 , -0.001752759687 , ])
Y_2_1_imag = flex.double( [ -0.0 , 0.0 , 0.000104083262149 , 4.72842002358e-06 , -0.00317308336849 , 0.00555499030358 , -3.14255276847e-05 , 0.000297452605953 , -0.00320102722955 , 0.00132137687287 , -0.000670032865817 , -0.0037200334032 , -0.00361134343437 , -0.00411481208967 , 0.00180652341729 , -0.000910798597006 , 0.00582046036081 , -0.00229318643863 , 0.00205385330938 , -0.000502817779803 , 0.00019352672828 , -0.000131904881248 , -0.000394497685779 , -0.000454771484386 , -0.000857410879663 , 0.00250643139284 , -0.000246149538189 , -0.00216344291114 , 0.00576905155147 , -0.00142228300441 , 0.00532550129504 , -0.00450069817498 , -6.24279476975e-06 , -0.00268950150273 , -0.000905666705886 , 0.000711230027061 , 0.000184068219285 , 0.000419680000479 , -0.00816342156391 , 0.000653714475404 , 4.70892621202e-05 , -0.00087689619553 , 0.00136061953671 , -0.000468523990237 , -0.000163026989043 , 0.00167011083351 , 0.000373252096169 , 0.000408028539619 , 0.00188732012766 , -0.00172107164238 , 0.00116204579098 , -0.00027893871771 , 0.0042431953291 , -1.1773627783e-05 , -0.00379616382803 , -0.00298427747015 , -0.00118859169064 , -0.00131247550088 , -0.00133978576997 , -0.000203202840728 , -0.000139852331981 , 3.34828942398e-05 , 0.00242838335082 , 0.00269906865193 , 0.00526038847799 , 0.000109913812146 , -0.00119788352822 , 0.00289622642005 , -0.00163829736889 , -0.000624870928554 , -0.000880101953332 , 0.000821909894898 , -9.56722531672e-05 , 0.0043452588702 , -0.00206223615186 , -0.00259266178463 , 0.00148792806533 , 0.00166270449962 , -9.6216059391e-06 , -0.00275741245309 , 0.00356524173217 , 0.00190640462111 , -0.00344360112866 , 0.000613853298789 , -0.000663152874849 , -0.00181772069233 , 0.00339814783589 , -0.00146552099732 , -0.000224511472872 , 0.0027853330079 , 0.00204848523195 , 0.00492457999017 , 0.00680487835535 , 0.00413498096467 , -0.00343481223491 , -0.00348731359771 , -0.00499627561409 , -0.000782733806871 , 0.00254565724644 , -0.00217437905257 , 0.00044702764115 , 0.00196243545326 , 0.00368575437099 , 1.6941426745e-05 , -0.000231728735731 , 0.00401445475776 , -0.00201148606786 , 0.00108018688314 , -0.00563144396702 , 0.00170111101241 , 0.00277502800587 , 0.0013254733254 , 0.000566734838237 , 0.0048805727949 , -0.0015342978257 , -0.00275452535456 , -0.000444289576633 , -0.00108220180034 , 0.00306996742736 , 0.00130722274892 , -0.000151908630755 , 0.000942098319813 , -0.00769581538084 , -0.000472217766081 , -0.0030596898622 , 0.000969822894974 , -0.000838204321663 , -0.00209213580865 , 0.00148006630711 , -0.000274766690632 , -0.00361680862438 , 0.00063741891524 , -0.00045492904132 , 0.000439732273283 , -0.00358046845492 , -0.00112297859912 , 0.00152306154942 , -0.000843648592668 , 0.000700781102563 , -0.00357823447353 , 0.00591941183651 , 0.0012153077733 , -0.00197702270083 , 0.0031910964417 , -9.02693452807e-06 , 0.000170259350422 , 0.00113510193413 , 0.00111715330398 , 0.00164787675348 , 0.000596875334949 , -0.00600245639792 , 0.000807556631804 , 0.00682545692418 , 0.00145931320346 , -0.000936160627361 , 0.00271273973972 , 0.000319010684971 , 0.00398286761568 , -0.00161059555838 , 0.00241148390355 , 0.00424286943367 , 0.00227769710618 , -0.000262154149921 , -8.22206376788e-05 , -8.14435889626e-05 , 0.00471525392005 , 0.000394752606913 , -0.00144303342264 , 0.00434743306152 , 0.0011069148465 , -0.00102105488083 , 7.94719591653e-06 , -0.00347110708759 , -0.00184190801648 , -0.00332823850795 , 0.000556485692268 , -0.00503001220163 , -0.00113433513621 , 0.00143591820456 , -0.00366228883935 , -0.000210836001857 , -0.00287095481942 , 0.00426469185519 , 0.000523117365226 , 6.96883268686e-06 , -0.00115167191277 , 0.00113065477904 , 0.00484104707955 , -0.00300935720906 , -0.00337925563222 , -0.00379506526032 , 0.000947170976176 , 8.32494565536e-05 , -0.000277976053409 , 0.00389259058267 , -0.00440544508332 , 0.000488065819562 , -0.00352046006834 , 0.00439207756776 , -0.000417803992057 , -0.00387324310259 , -0.0040054244027 , -0.00199739114777 , 0.00337019298894 , 0.000963189084193 , 0.0020430966862 , 0.00265253286506 , -0.00273363134618 , 0.00270778936942 , 0.000940620019302 , -0.00248406988827 , 0.0041580089992 , -0.000546759963372 , 0.00103935965617 , -0.00205016846441 , -0.00360894603475 , -0.00108215622909 , -0.00442865266744 , 0.00304799894799 , 0.000343085302353 , 0.000723946065989 , 0.00312537176453 , 0.00476992938947 , -0.000796696025431 , -0.00383441402862 , 0.0027798412465 , -0.000474880432985 , -0.00448163278936 , -0.00112326930309 , 0.00263706582275 , -0.000473581615093 , -0.00711300416447 , 0.00091224722013 , -0.00240912361092 , -3.0405628723e-05 , -0.0013233158846 , -0.00362051343552 , -0.00427125387591 , 0.00123306157554 , -0.00120911279017 , -0.00217229645922 , -0.000325865088803 , 0.00606759092329 , 0.0035829477878 , -0.00232179192457 , 0.00463707227126 , 0.00237020357377 , -0.00470648545873 , 0.00279599547549 , 0.00068767697395 , 1.2821106996e-05 , -0.00163671057116 , -0.00294465113684 , 0.00119183596909 , -0.00220754891944 , 0.000179043345714 , -3.92672311856e-05 , -0.000278670766897 , 0.000540260796127 , -0.00446467497242 , -0.00396765729462 , 0.00144887052416 , 0.00305468324354 , 0.00374783639354 , -0.000876772149799 , -0.00340034135843 , -0.00449758846937 , -0.00261846861158 , -0.00533184847404 , -0.00278780929435 , -0.000349248811989 , -0.00128550856938 , -0.00381121292315 , -0.000111424465255 , 0.00626104436925 , 0.000901563921391 , 0.000422818315046 , 0.00186273438035 , 0.0021656297378 , 0.0018523980682 , 0.00558132873747 , -0.0053714534592 , -0.000453764935218 , 0.00461780768973 , -0.00128096424399 , 0.00553803494047 , -0.00323080959744 , 0.00025716220785 , -0.00745903992851 , 0.000785835623056 , -0.00151422066599 , 0.00325423791569 , 0.000296320764564 , -0.00407415365678 , -0.00393864052954 , -0.000412006845924 , 0.00637476530692 , -0.000991456532959 , 0.00136868151979 , -4.63217791165e-05 , -0.00217234518055 , -0.000703794354883 , -0.00123370825078 , -0.00339370373236 , 0.00324682052728 , 0.00245624197053 , 0.00316298520834 , -0.00263105371857 , 0.00135795693764 , 0.00123947289693 , -0.00514967036874 , -0.001636214537 , 0.000929339509144 , 0.00176737337759 , -0.00168339737906 , 0.00344859998185 , 0.00621436157831 , 0.00265695956089 , -0.00433446600142 , 0.00265896257517 , 0.00507541819369 , -0.0032860147292 , -0.00722076141256 , 0.000750789601793 , -0.00149538565238 , 0.000901519127074 , 0.000630716595277 , -0.0011801584829 , -0.00256961328684 , 0.00333556939906 , -0.000825531754936 , -0.00251604582019 , 0.00490636228957 , -0.00275417423924 , -0.0031820676143 , 0.00102258437297 , 0.0034205302793 , -0.00489482113847 , -0.000939370461658 , 0.0018624036955 , 0.00040812042065 , 0.00362225843484 , -0.00515941591513 , -0.000112328041881 , 0.00153523797802 , 0.000357304340331 , 0.00426759229343 , 0.00696792497029 , -0.00530690391097 , -0.00543475499719 , 0.000273585210558 , -0.00484712835867 , -0.00228152895191 , 0.00280408709241 , -0.00301158179454 , 0.000346858204746 , -0.0042743949555 , 0.00393058940951 , 0.00400995452746 , -0.00941025453074 , 0.00284527047922 , 0.00115783857516 , -0.000787889048379 , 0.00038545069653 , -0.00038892170814 , -0.00339652329214 , -0.000955083492541 , 0.000299026529972 , -0.00357375174602 , -0.00641905824214 , -0.00135002323635 , 0.00542539950641 , -0.000480073459205 , -0.00226592745853 , -0.00105343053276 , -0.00472540299126 , -0.0025696627838 , -0.00600326158286 , -0.00415772198276 , -0.00113590774261 , -0.000214884508701 , 0.0022249697206 , 0.00191239414388 , -0.0020968458325 , -0.00365695384908 , 0.00235507225795 , -0.00642017418388 , 0.00599940977607 , 0.00518683490605 , -0.00159338698966 , 0.0032746740345 , -0.005327337093 , 0.00417658180768 , 0.000490358169409 , 0.00688859746265 , -0.00193338872922 , 0.00729567737357 , -0.00458461559856 , 0.000697151612111 , 0.00265512421484 , -0.00228275030669 , -0.00178635289858 , -7.6861819877e-06 , -0.00250356090108 , 0.00659041569944 , 0.00290659282484 , 0.000616336684779 , 0.00161661198349 , 0.0020229097676 , -0.00047882861761 , 0.000497232330869 , 0.00310961415506 , 0.0042825098478 , -0.00320173102009 , 0.00413106377974 , -2.52267674986e-05 , -0.00387849043936 , 0.00060007323072 , 1.28727028199e-05 , -0.000123866897811 , 0.00289302617844 , 0.00423179009312 , -0.00271071605581 , 0.00327976836091 , -0.00630595482947 , 0.000108534387974 , -0.00487207282393 , 0.00203324959943 , 0.00528910368715 , -0.00598192588937 , -0.00149064202139 , 0.000109979185359 , -0.0020383152583 , 0.00209033233797 , 0.00392539860851 , -0.00484947606884 , 0.000755308596488 , -0.000535256483177 , 0.00060657267041 , 0.000970856191753 , -0.00159581912972 , -0.000813772085011 , 0.000864466189505 , -0.00180961582733 , 0.00651179752041 , 0.00314898953974 , -0.00343395414086 , 0.00197150598666 , 0.00131212551726 , 0.000175700420788 , 0.00276242350032 , 0.000962554350684 , 0.00111824291719 , -0.000709609908385 , 0.00191183866373 , -0.00515779473761 , 0.00517875445351 , -0.00488016144709 , 0.00158982976098 , 0.00233475927059 , -0.00016089718009 , -0.000390570342561 , -0.00353268495836 , 0.00302237163109 , -0.00160589339936 , 0.00240804500957 , -7.46973083734e-05 , 0.000148554719353 , 0.00197168063858 , 0.00485516539966 , 0.00117773756336 , 0.00269319568748 , 0.000283593082671 , -0.00203649325929 , 0.000213303526293 , 0.00381192742887 , -0.000950879102814 , 0.0030583614961 , -0.000103946699188 , -0.000846917296093 , -0.00334182295429 , 0.000518755854738 , -0.00178359804306 , 0.00309599749447 , -0.00055713043759 , 0.000795659112006 , -0.00214566403324 , -0.00129054643333 , -0.00183991409895 , -0.000979768162483 , 0.00164627673196 , -0.00124081990433 , -0.00151071714142 , -0.00348538516688 , -0.00228526359419 , -0.00421291424918 , 0.00252213775008 , 0.00300735503663 , -0.00142894016842 , -0.00111235286308 , -0.00370135164835 , -0.00410761224799 , 0.00369374987392 , -0.00323792789405 , -0.00301112760416 , 0.000105132318003 , 0.00434200882287 , 0.00145660856628 , -0.00432929826497 , -0.00530767206584 , -0.00432945309348 , 8.98548192005e-05 , -0.000230257887382 , 0.000767348340144 , 0.00509297621651 , 0.00209698200509 , 0.00456548056901 , -0.00134298331315 , 0.00189217209533 , 0.00166352293894 , -0.00518397597147 , -0.000186329988066 , 0.00315332337575 , 0.00196157650766 , -0.00122331321964 , 0.00197325914459 , 0.00348298643062 , -0.00174939205548 , -0.000514249253097 , -0.00010372697518 , -0.0017488934331 , -0.000839113226182 , 0.00225577692504 , -8.74029763529e-05 , -0.0025410867324 , -0.00389655677348 , 0.000714947644543 , 0.0025650462933 , -0.00155809485032 , 0.000187550693733 , 0.00421361944703 , 0.00132434346502 , -0.00303942106044 , -0.00255903992303 , 0.00309455054421 , 2.53246022541e-05 , -0.00325141197667 , 0.000352830531871 , -0.000356814981526 , 0.00131798856492 , 0.00144770711675 , -0.00198094598423 , 0.00200557082975 , 0.000514501485839 , 0.000716334921745 , -0.00626520087944 , 0.000461856185093 , -0.00557705041924 , 0.00255007844365 , 0.00172091773697 , 0.000947545930401 , -0.00028257128746 , 9.83769028194e-05 , -0.00115652014909 , 0.00221557014559 , -0.00136027856612 , -0.00390087551174 , -0.00396444078799 , 0.00449587472893 , 0.000198083612928 , 0.00251651833428 , 0.00130611539072 , 0.000109393820778 , 0.000498089318973 , -0.00199780644462 , 0.000497067094999 , 0.00415114258683 , 0.00170543490666 , -0.00131622183949 , -0.00401656994572 , -0.00506867860519 , 0.00615949142844 , 0.000664375524595 , -0.00145833623144 , -0.00113999354745 , 0.00368519733506 , 0.00742324965739 , 0.00109807806309 , 0.0029191312382 , -0.00334714087766 , -0.000209526402823 , 0.00603313785594 , 3.08647792919e-05 , -6.70456708234e-05 , -0.00138391471423 , -0.000377664704568 , -0.000881214311286 , 0.000115032415455 , -3.34462517505e-05 , -0.00338995076792 , 0.00348934144797 , -0.0024824301828 , 0.00325563323829 , -0.000356024976541 , -0.000303047999591 , -0.0028151021122 , 0.00448766827917 , -0.00240130755556 , 0.00231410951016 , -0.00321781508293 , 0.0025880110691 , 0.000632927846023 , -6.81601530948e-05 , -0.00155049622142 , -0.00283196437031 , 0.00301174296689 , 0.0027240033049 , 0.00266696392839 , 0.00189601023591 , 0.00225498688223 , 0.00530959301469 , 0.000216367224018 , -0.0055652286131 , -0.00422282130654 , -0.00188332802249 , -0.00329452122728 , 0.00101117747156 , 0.0021360671981 , 0.00350958638385 , 0.00126176304185 , 0.00190313132457 , -0.000822462955754 , 0.00247098805294 , 0.000323828912126 , 0.00593785485972 , 0.000976778368029 , 0.00178579675921 , -0.00161602623038 , -0.00253399790195 , -0.00271418107023 , 0.00078716917606 , 0.0015641697982 , 0.000666434309413 , 0.000687186976806 , -0.0051271445198 , 0.00271654665102 , -0.00143387900529 , -0.00733959480241 , 0.00159229512932 , 0.00145231810262 , 0.00505595788595 , 0.00155266073365 , -0.00466200502761 , -0.000518682504713 , 0.00205767913204 , -0.0047679870438 , -0.0012919662088 , -0.00302928235924 , 0.00365973838876 , 0.00699023907899 , -0.00173956781748 , -0.00134926405239 , -0.00201742012134 , 0.000944346396534 , 0.00248493086836 , 0.00148623822479 , 0.00112960693514 , -0.00259261353947 , 0.00139781077364 , -0.00334337556145 , 0.00298514627895 , 8.32939967554e-06 , 0.00271730888238 , -0.00485851047382 , -0.00173139124132 , -0.00231403135769 , -0.00367296909106 , 0.00690754613427 , 0.00136369809348 , 0.000249024721547 , 0.000900986536586 , -0.00462344447453 , -0.00199551148272 , -0.000470321128626 , 0.00225239150705 , 0.00505931137325 , 0.00126275307069 , 0.00590650349146 , 0.0025921480338 , 0.00107027911793 , -0.00314899389938 , -3.257331405e-05 , -0.00107342976454 , -0.00890023854936 , -0.00138833605902 , 0.000237465335033 , 0.00509424250748 , 0.00203964988048 , -0.0040474830132 , 0.00212202111701 , -0.000335977764984 , 0.00327786980693 , -0.000726523500563 , 0.000961615009796 , 0.000482597741404 , -0.00115132964476 , 0.000894403620661 , -0.00787535292083 , 0.000862309186202 , 0.00603407921833 , 0.000753419565757 , -0.00160398742727 , -0.0010657111156 , 0.00259562034854 , -0.000385813130146 , -0.000121744426285 , 0.000972086894595 , -0.00532205738138 , 0.00269537410334 , -0.0036941350511 , -0.00377499496972 , -0.00381364818482 , -0.00367777593614 , 0.00344326173914 , -0.00214000343248 , 0.00563496554772 , 0.0012309644247 , 0.00226404888856 , -0.000598121871734 , -0.0021011173869 , -0.00184597775988 , -0.00197835942811 , 0.00110734125785 , -0.0024087390171 , -0.00078764526193 , -0.00138266891162 , -0.00278686152025 , 0.00187753360356 , -0.00180295244917 , 0.00519701619047 , -0.00513946944279 , -0.000813911652932 , -0.000557172407021 , -7.67866560787e-06 , 0.00555882798321 , -0.003256740781 , -0.000979003804183 , 0.00428100115318 , 0.00306258266152 , -0.000792791895927 , -0.00050923276796 , 0.00166140689462 , -0.00125218732766 , 0.00115786257606 , 0.000806055517724 , 0.00167202093749 , -0.000316091913374 , -0.00301692313683 , 0.00371273754711 , 0.00365388819199 , 0.00224350399845 , -0.00334415150033 , -0.00561340560481 , -0.00411062032302 , -0.00375494265009 , -0.00302582114354 , 0.00271117378503 , 0.0068786124153 , 0.00309385874051 , 0.00126352368894 , 0.00677939960447 , -0.00507497546102 , -0.000523243292773 , 0.00430948103585 , -0.00438807309089 , 0.000732114780233 , 0.00231839383001 , -0.00111078443448 , 0.00186660077838 , -2.56721723898e-05 , -0.00357884485026 , 0.000991123448658 , -0.00483190828111 , -0.000388071300357 , -0.00152091185048 , -0.00186873777447 , 0.00217543907647 , 0.00145165440757 , -0.00556193239896 , 1.26869071408e-05 , -0.00012290958252 , 0.00288866772261 , 0.00148992159548 , -0.00300481964396 , -0.00189409631241 , 0.00157738485714 , 0.00237837069133 , -5.05725602852e-05 , -0.00173560049979 , -0.00226879832019 , -0.00383668162064 , 0.000593395417875 , -0.00172116292677 , -0.00035547151264 , -0.00146386485476 , 0.0034751519746 , -0.000945984992077 , -2.71991140412e-05 , -0.00145601426116 , -0.00194629664213 , -0.00156092978373 , 0.00597419165803 , -0.000264274765845 , -0.00599948328795 , 0.00206815392253 , -0.00202250726971 , -0.000916949394772 , -0.000154620568076 , 0.00369981284268 , -0.000571098983965 , -0.000214706727709 , -0.00507769060589 , -0.00231411612271 , -0.00304227380802 , -0.000889067363275 , 0.00059165292312 , -0.00423868540081 , 0.0056591911872 , -0.00112988744874 , -0.00164040652585 , 0.00101413822497 , -0.000995565964945 , -0.00130907064921 , 0.00753322168615 , -0.00202659461112 , -0.00130947162647 , 0.0042743388022 , -0.000207241685968 , -0.00220709976101 , -0.00243742240067 , 0.0041771082492 , 0.000444378813795 , 0.00349238704242 , 0.00373975381675 , -0.00159287438465 , 2.38350032454e-05 , -0.00188040683742 , -0.00578311397678 , 0.00336196782684 , 0.00320348503256 , 0.00102739103268 , 0.00109919105107 , -0.00262610176605 , 0.000448210084078 , -0.0027633564178 , 0.000596433797988 , -6.63931634723e-06 , 0.00328335555146 , -0.00241159374926 , -0.00141537071563 , -0.000731453076251 , 0.000235786851869 , 0.000666678181061 , -1.71505410733e-05 , 0.00555235030636 , 0.000965066465013 , 0.00229155324718 , 0.000725103709985 , 3.20016467552e-05 , 0.000759829671247 , 0.00656326019016 , 0.00434089907458 , -0.000295477718202 , -0.00250414624954 , -0.000621881011748 , 0.000686685915313 , 0.00211441140307 , 1.33886284071e-05 , -0.00349514324593 , -0.000308422335099 , -0.000120039922546 , 0.00472293355005 , -0.00226001756869 , -0.000736154785359 , -0.0016817503183 , 0.00138651509191 , -0.00102927135029 , 0.000155735628581 , 0.00532775406841 , 0.00217966827613 , 0.00172246455927 , 0.0027536532554 , -0.00199930479614 , -7.27965898639e-05 , 0.00223953192037 , 0.000286801907163 , -0.00575844995694 , -0.00408644742658 , 0.00403009479828 , 0.000148284307436 , ])
Y_2_2_real = flex.double( [ 0.0 , 0.00685479092299 , 0.00518101446982 , 0.00147858805192 , -0.00242103910923 , -0.00283329488707 , -0.00258809398258 , 0.00481990814078 , 0.00204870523564 , -0.00581663978558 , 0.00363553308154 , -0.000703892681732 , -0.000429660206315 , -0.0012569985153 , 0.000664720902947 , 0.000712476395264 , -0.00587554144103 , 0.00140292258014 , -0.00447241898348 , 0.000498085628716 , 0.00596870187934 , 0.00324683869027 , -0.0030243755028 , 0.00410958393852 , 0.00553632535403 , 0.002384736905 , 0.0024267149678 , -0.00373161692976 , -0.00312724688395 , 7.0676863572e-05 , -0.000445302559282 , -0.00470454441485 , -0.00644612223311 , 0.00142759075533 , -0.00307653390921 , 0.00442067525255 , 0.00547299486069 , -7.06418835626e-05 , -0.00322407286835 , 0.00232631018702 , 0.00218515134996 , 0.00428882209924 , 0.00181222826565 , 0.00320301916775 , 0.00349466708492 , 0.00313191041724 , 0.00398327134945 , 0.00488385741422 , 0.0026039921929 , 0.000495742063466 , -0.00356407549021 , 0.00305754399716 , -0.00226296715012 , -0.00634214882871 , -0.00152449029522 , -0.000921314909903 , 0.00045338128456 , 0.000189084255063 , 0.0020150723643 , -0.00357552136959 , 0.00599487448696 , 0.00397207553417 , 0.000115307142503 , -0.00122910374911 , -0.000448908531042 , 0.000505675813849 , 0.00257181502427 , 0.000489327786633 , -0.000973515081344 , 0.00346944785831 , 0.00380116497107 , 0.000535388802394 , 0.00543279026647 , -0.000523100951077 , -0.000223050303947 , 0.0014722782864 , -0.000347660034062 , 0.00473336889903 , -6.60270879344e-06 , -6.62588710873e-05 , 0.000140026108236 , 0.0042987174882 , -0.00105883403325 , 0.00374279829269 , 0.00181496614692 , 0.00289239066103 , -0.000438320391119 , -0.000773344582877 , 0.000980635360888 , 0.00130196164532 , 0.00218812170581 , -0.000755124206086 , -0.00235620800057 , -0.00171114842998 , -0.000773194541424 , -0.00275533068834 , -0.000711815006616 , -0.0022289126824 , -0.00214100975593 , 0.00153751138105 , 0.00275482497766 , -0.000267298810915 , -0.00215446962085 , 0.00425390715376 , 0.00191580466718 , 0.000542338941613 , -0.00355780801381 , -0.00474354051654 , -0.00318531144242 , -4.43618882686e-05 , 0.000141431117289 , 0.000738077020827 , -0.00149747339381 , -0.00061671170076 , 0.000328078764433 , -0.000591644075679 , 0.00461251609099 , 0.00294110131316 , -0.00142379293311 , 0.00213210776258 , 0.00226581503638 , -0.0042772176278 , -0.00212667841327 , 0.00139426083343 , 0.000843249726554 , 0.00243764342599 , 0.00478882443067 , -0.000112246060488 , -0.00249358268392 , 0.000644325226463 , 0.00161333747263 , 0.00553201662715 , -0.00392676900847 , 0.000528013075117 , -0.000738902831683 , 0.00423421727233 , -0.00181103717912 , 0.00186078531544 , 0.00470329345834 , -0.00217005369107 , -0.00148711683286 , -0.00495127611581 , 0.00150610250612 , 0.000462085516027 , 0.00626507197416 , 0.00396224256322 , 0.00276359708452 , 0.00255476400954 , -0.000977530840457 , 0.00316203578687 , -0.00142943216249 , -0.00301341326855 , -0.0026904007316 , -0.00378198235516 , 0.00181567976659 , -0.0013560698664 , 0.0037725689286 , -0.00066439124865 , -0.0010844441914 , -0.0033854104192 , -0.00322210773174 , -0.000211967084922 , 0.000571200436246 , -0.00448213085873 , -0.00397842937329 , -0.00314234495385 , -0.00371797838507 , -0.000118540188049 , -0.00285751018458 , 0.00107068019194 , 0.00315385436772 , -1.43116281544e-05 , -0.00175495012489 , 0.000177186584052 , -0.00068350282084 , 0.00137500161176 , -0.00637308575616 , 0.00313750843229 , 0.000821263279039 , -0.000832465014795 , 0.000298260336626 , -6.94951228253e-05 , -0.00409264929885 , 0.00223810756673 , 0.00416338678657 , 0.00063625621053 , 0.00184694687894 , -0.00138937689808 , -0.00465315452677 , -0.000338014185594 , -0.00234791209131 , -0.000473139178185 , -0.000130225604571 , 0.00499001369708 , 0.000636713065544 , -0.00155151857799 , 5.28783386055e-05 , -0.00064192905375 , -0.00187390624705 , 0.00592352317041 , -0.00534533262406 , -0.000184183381115 , 0.00271262846684 , -0.00460979499971 , 0.0012136736331 , -0.000245490585006 , -0.00306068252761 , -7.32359588659e-05 , 0.000203134814232 , 0.00366492821242 , 0.00135551793079 , -0.0011435499927 , 7.24733700715e-05 , 0.00365345446312 , 0.00194267046299 , -0.0025536891164 , 0.00363508648953 , -0.00275060779472 , -0.00233967064474 , 0.00302232119863 , 0.00443140059749 , 0.000675659868559 , 0.000859903590884 , 0.0021790213837 , -0.00296177039132 , -0.00355863132048 , 0.0037390312102 , 6.99097389822e-05 , -0.00695671881267 , -0.000668278990556 , 0.00511585138885 , -0.00561546531861 , 0.000291357208599 , 0.00165343061066 , 0.00569448439338 , -0.00567097726336 , -0.00136142032951 , -0.00152141797481 , -0.00044849543005 , -0.00116526957135 , -0.00254909617849 , -0.000256012811503 , -0.00411905099528 , -0.00167866423865 , -0.00240275697288 , -0.00150567649346 , -8.99410408016e-05 , -0.000128706728904 , -0.00615256657382 , -0.00362475549604 , 0.00118152472479 , -0.00236181665807 , 0.000373660753863 , 0.00329861133022 , 0.000155554211701 , 0.00550922281631 , 0.00575114384068 , -0.00376494372691 , 0.00323296123748 , -0.00225788670129 , -0.00116941388647 , 0.000816714206402 , -0.003009934877 , -0.00323702129358 , 0.00322911023189 , 0.00136734570766 , 0.000731780876561 , -0.000845172733308 , -0.00106644723188 , 0.000630138720063 , 0.00301982382416 , 0.00115768628177 , -0.00256585175253 , 0.00476024872562 , -0.00162609750285 , 0.000763708066344 , -0.00145220068435 , 0.00302742369636 , 0.00235394417055 , -0.0018078446065 , -0.00360879813952 , -0.00171604410227 , 0.00623313329779 , -0.00130962346331 , -0.0051466847495 , -0.00176433731424 , 0.00220477832916 , -0.00203581669188 , -0.00523617653374 , 0.00200713357028 , 0.00105155245756 , -0.00029452883802 , 0.00135544956554 , -0.00503643163515 , -0.00640224139441 , 0.00473562130506 , -0.00136560353315 , -0.00205436417613 , 0.00382142457545 , 0.0038841391728 , -0.000376796051413 , -0.00319786873618 , 0.00164111018784 , -0.00593687842346 , 0.000136212448851 , 0.00251375551852 , -9.17417295427e-05 , 0.00105688514316 , 0.00382689509335 , -0.00560466611789 , -0.00614671184932 , -0.00268814214851 , 0.00455311702248 , -0.00358489709274 , -0.0065361332151 , -0.00363937264811 , -0.00324186784483 , -0.00259156032832 , -0.00146618248365 , 0.00115730267233 , -0.00530097827873 , -0.000466486230112 , -0.00286304969216 , -0.00400062230552 , 0.00119585294308 , 0.000398154204106 , 0.00324233608353 , -0.00240875620885 , 0.00260232422702 , 0.00251227944637 , -1.11152306762e-05 , -0.00119259179888 , -0.00201944732422 , 0.00015564757899 , -0.000684620818142 , -0.0078405550673 , -0.00272422420747 , -0.00171717937259 , 0.00122253052309 , 0.00176330025952 , -0.00490518600288 , -0.000387860995006 , -0.00135325244094 , 0.00181152502831 , -0.000142162708392 , -8.57302179511e-05 , -0.00349305464976 , -0.0016886733572 , -0.00415446580345 , 0.000721256262926 , 0.00519405847446 , -0.00415524435898 , -0.00109707705185 , 0.000916906875548 , -0.00166636555211 , 0.00434727089325 , -0.00184806295646 , -0.0050444679364 , -0.00036567548712 , -0.00417778802106 , -0.00283539575064 , 0.000667583996215 , -4.29005428585e-05 , 0.00390992691295 , 0.00353244787315 , 0.00205446723578 , -0.00267618492902 , -3.13217888075e-05 , -0.000811538321712 , -0.00435258757316 , 0.000774085080941 , -0.00191768777438 , 0.00328515485667 , -0.00333478637557 , 0.00332717652189 , -0.00385174077934 , -0.00297619629117 , -0.00249994240528 , -0.00201803683317 , 0.0033532452531 , 0.00308397640921 , -0.0049792330114 , 0.00077660664065 , 0.00340204575316 , 0.0020831742575 , -0.000212829412763 , -0.00267622582622 , -0.0031434975352 , -0.00264265019318 , -0.00179053318645 , -0.00474650619681 , -0.00430055627017 , 0.000402516724036 , 0.00599648021652 , -0.000953732688881 , 0.002618830773 , -0.00264190501999 , -0.000748965784387 , -0.00219522581973 , -0.00321175376627 , -0.000829519719815 , 0.00301122945432 , 0.000785703537413 , 0.0019819779926 , -0.00395138333921 , 0.00103074262985 , 0.000230638886678 , 0.000502734024266 , 0.000621032063702 , 0.00352389003068 , 0.000243263549011 , -0.00414779569781 , -0.00413978092657 , -0.00699412979429 , -0.00031747205294 , 0.00330131055909 , 0.000200112150769 , 0.00495207599668 , 0.000687932829745 , 0.00445278176434 , 0.00179257277641 , 0.000203479777505 , 6.65528876231e-05 , -0.00306760262674 , -0.00645207112822 , 0.00402165353307 , -5.91835913612e-05 , 0.00129996724398 , -0.000856749999121 , -0.00193810134427 , -0.00012608401258 , 0.00342314107073 , 0.00196894766386 , -0.00439236622954 , -0.00117036426131 , -0.00132202119702 , 0.00405459332319 , 0.00013632969137 , 0.00442515466974 , 0.000597681704858 , 0.00383135614188 , 0.00275531449662 , 0.00166212833708 , -0.000132209308296 , -0.00214912999913 , -0.000591874878242 , -0.00170085415226 , -0.0016427689331 , 0.00372899852016 , 0.00131675944735 , -0.000314231671704 , 0.00475353465805 , 0.00406719860164 , 0.000920813111594 , 0.000797883209251 , -0.00175763434673 , 0.000492765982158 , -0.00109648653212 , -0.00303460013328 , 0.00202120636275 , -0.00032654690834 , -0.00166065155914 , 0.00113753563967 , 0.000937765409756 , -0.00442139566297 , 0.00206840954821 , 0.00445426822073 , 0.00531376016027 , 0.00059291741765 , -0.00647105953442 , 0.00163618806984 , 0.00162305583752 , 0.00427921725431 , -0.00406350072172 , 0.00569932621166 , 0.000347991775259 , -0.00298221853775 , 0.00254732699758 , 0.00639020174743 , -0.00201689626816 , 0.000268462496217 , 0.00334646602436 , 0.000763665779889 , 0.000838766153697 , -1.52916689496e-05 , 0.00280955678444 , 0.00244523895911 , 0.00356579159599 , -0.00154111811431 , 0.00117598589326 , 0.00390592733515 , -0.00545457576908 , 0.00260849988566 , 0.00119646973452 , -0.00121140482086 , 0.000910440061543 , -0.000885819637263 , -5.59325098312e-05 , -0.00291329753905 , -0.0036744267512 , 0.000136181003283 , -0.000838707565862 , -0.000217152043623 , -0.00483049114265 , -0.00337570056985 , 0.00372660038033 , -0.00317829655967 , -0.00293399110125 , -0.00236385341223 , -0.00230449477431 , -0.000849667587699 , 0.00421452082953 , 0.00419994530323 , 0.00386089129292 , -0.00200697690232 , -0.00275219142395 , -0.00184867549581 , -0.00190176683516 , 0.00252457035723 , -0.00427982230583 , -0.00266900711778 , -0.00672989202422 , -0.000735183244812 , 4.79848271278e-05 , 0.0002156132179 , -0.000915388176012 , 0.000986624725502 , 0.00191711054849 , 0.00388118644683 , 0.000207252956084 , -0.00138498847245 , 0.000723329978165 , -0.00429302939907 , 0.00390657733591 , -0.00269171524027 , -9.15435501033e-05 , 0.000756223765049 , 2.84579297947e-06 , -0.00182513849854 , 0.00474502072612 , -0.00128456351372 , -0.00157181955615 , -0.00263941390487 , -0.00462664858647 , -0.00144609882588 , 0.00380559338291 , -0.000499114610325 , -2.20263343657e-06 , 0.00493406655662 , -0.00557583037911 , 0.00327185064002 , 0.00205707641269 , -0.000397396666524 , 4.21120061491e-05 , 0.0030244982987 , -0.00344871825877 , 0.000318916241036 , -0.002632916948 , 0.000154624454842 , 0.00256553383462 , -1.20752904104e-05 , 0.00596031101824 , 0.00411412841152 , 0.000321114349417 , -0.00358213468397 , 0.00345203869035 , -0.000648910442643 , -0.00171664587126 , -0.00379992836221 , 0.00223866822275 , -0.00169530103952 , 0.00297180650221 , -0.00327108197657 , 0.00281643863379 , 0.00339649906016 , 0.00439936339754 , -0.00131942471219 , -0.00120235218607 , 0.00157633484447 , -0.00030524005724 , -0.00351505574722 , -0.00125732693711 , -0.00026416426703 , 0.0046701661139 , -0.00379578085696 , -0.00233431782674 , -0.00265847500349 , 0.0018761613354 , -0.000109612175611 , -0.00297291629573 , 0.00432797085913 , -0.00174449414052 , 0.00416053153296 , -0.00417806329729 , -0.00594092979027 , 0.00102669399931 , 0.00520345645637 , -0.0033371927948 , 0.00429639720516 , -0.000285793867817 , -0.000166209518309 , -0.00759438696332 , -0.00127040593148 , -0.000847377043109 , 0.00473632664622 , 0.00303560858476 , 0.000148442460644 , 0.000176502334003 , 0.000626417176516 , -0.000146684357893 , 0.00170494114311 , -0.0021412217251 , 0.00302199065705 , 0.0010278421626 , -0.000343500548054 , -0.00330981560358 , -0.000305883224482 , -0.000459871897537 , 0.00331054062982 , 0.0025304128155 , -0.000626525208788 , 0.00321955775495 , -0.000340021828675 , 0.000659882273305 , -5.67163599161e-05 , -0.000521561787679 , -0.000552197815417 , -0.00152400619534 , -0.00507984649235 , -9.19238323055e-05 , -0.00236663002221 , 0.00180993730642 , -0.00090472587177 , 0.000915942317056 , -0.00263889934781 , -0.00386208962992 , 0.00123173187842 , 0.00206101288649 , -0.00567469531282 , -4.07369266421e-05 , -0.000839683158383 , 0.00010580387492 , 0.00178753915197 , 0.000257992771035 , -0.00319794448729 , 0.000357284154268 , 0.00288974230068 , -0.00352032204405 , 0.00195524857159 , 0.000607169083209 , -0.00284184149472 , 0.00268954026407 , -0.00148994087359 , 0.00264238070127 , 0.00228375335428 , -0.000826315355057 , 0.000981457580664 , -0.000481937955238 , -0.000927798506659 , -0.00292854294869 , -8.14410291617e-05 , -0.000788708652248 , 0.000529842786303 , -0.00102990960151 , -0.000697806004247 , -0.000479100383224 , 0.0030671406347 , -0.000209248308398 , 0.00039208544846 , -0.000176870946331 , 0.000214019117978 , 0.00621791912613 , -0.00194413968125 , -0.00214113153401 , 0.00379562119911 , -0.00423644775569 , 0.000692329872117 , -0.00636210912601 , 0.00131448632053 , 0.00424781043981 , 0.00420866865748 , -0.00109520984157 , -7.58377766467e-05 , 0.00200906427817 , 0.00264628425717 , -0.00173541041071 , 0.00144256604905 , -0.00454924540431 , 0.000890811862268 , -0.00219760308043 , 0.000971237504282 , -0.00358023772462 , -0.00103316281505 , -0.00549732524632 , 0.00184343592661 , 0.00366342785376 , -0.00416119087728 , -0.0072754803422 , -0.000503034694994 , -0.00446316818379 , 0.00416027398325 , -0.00401471845003 , 0.00437328350577 , 0.00371882335424 , 0.00312945661889 , 0.00234461990355 , 0.000486762772638 , -0.00177160221172 , -0.00338443277875 , -0.00089119719149 , -0.00143613330957 , 0.00176477297904 , 0.00495865164185 , -0.00387462032029 , 0.00501394445509 , 0.00577946862543 , 0.00248545386575 , -0.00373006398961 , 0.00228462394901 , 0.000768314263255 , -0.00100353330328 , -0.00328387054572 , -0.00433714782593 , -0.00102132217313 , 0.00050213554623 , -0.00338316687696 , 0.00246715948443 , -0.00371875472651 , -2.90193472845e-07 , 0.00239667341486 , 0.000196927080702 , -0.00111325516194 , 0.00177362650621 , -0.000973626251062 , 0.00213638987337 , 0.00121873253399 , 0.000745669255735 , 0.00266065849507 , -2.37082021332e-05 , 0.000781655358345 , -0.00287700007194 , -0.00291377245572 , 0.00176204057354 , -0.00380152774064 , -0.001369990131 , -0.00136526025568 , -7.25579396394e-05 , 0.000844888610398 , -0.000785127799663 , 0.000452043237211 , 0.00276152041432 , 0.0011753308367 , 3.68058308308e-06 , 3.84745646558e-05 , 0.00287361772087 , 4.37246120077e-05 , 0.00301956602534 , -0.00192928746684 , -0.00206609725306 , -0.00238559775149 , -8.07157616349e-05 , -0.00293023182217 , -0.00297944503194 , -0.00157569272757 , -0.00290108690431 , 0.00324268843032 , -0.000494378681902 , -0.00429537068885 , -0.00650853043045 , 9.99881320223e-05 , -0.00268731932434 , -0.00163057208123 , 0.00160406622968 , -0.00744377658179 , -0.00105328903286 , 0.00331842032777 , 0.00150299947512 , -0.00423089402384 , -5.43164052187e-05 , 0.00582389377283 , -0.0036774216148 , 0.000127877221864 , -0.000570203856788 , 0.00017815361067 , -0.00167170920413 , 0.00304403603263 , -0.0010070732921 , 0.00331951961348 , -0.00141985832022 , 0.00420812260729 , 0.000988491079934 , 0.00132984220003 , 0.00159404295547 , 4.24821226715e-05 , -0.00221045236314 , 0.000765406967689 , 0.00107907903266 , 0.00407461535005 , 0.000687072604352 , 0.00040270667084 , -0.00149867363606 , 0.000465267036482 , 0.00331788400133 , -0.000259975209518 , 0.00178830031934 , -0.000594561813997 , 0.00176222473399 , 0.00353239275796 , -0.000251856936434 , 0.000897034724128 , 0.00348891933779 , -0.00250941012894 , 0.00512451307188 , -0.00158930019243 , 0.000211130109648 , -0.000620649009869 , 0.00295491773188 , 0.00205319739613 , -0.000823139070725 , 0.0030957752505 , 0.00329170223703 , -5.39933376758e-05 , -0.000172135636377 , 0.000338295512872 , 0.000399728959412 , 0.00270558422079 , -0.00613764309144 , -0.00130339750622 , 0.00153720065546 , -0.00189523226578 , 0.00251680896095 , 0.00125901518891 , 0.00468178438086 , -0.00471137966973 , 0.000959187602803 , 0.00344145792994 , -0.00233835792316 , 0.0051799708615 , 0.00371293719874 , -0.000327279485942 , -0.00430698662232 , 0.00212231021369 , -0.00102218472002 , 0.00097832229379 , -0.00381171205284 , 0.00395297023225 , -0.000171782627833 , -0.00504424359831 , 0.00274032418148 , 0.00107331105655 , 0.00180678589117 , 2.94633895914e-05 , 0.000602863469508 , 1.77432352973e-05 , 0.000914237426738 , 0.00490521889302 , 0.00551559746078 , -0.000260132129229 , -0.00453730361964 , 0.0038562533782 , 0.000513332860946 , 0.00187304122506 , -3.50698471019e-05 , -0.00174817884807 , -0.0044334829617 , 0.00135229245835 , 0.00177252286191 , -0.000516463020018 , 0.00363790727483 , 0.00454014924524 , -0.00362563301806 , -0.00116485822973 , 8.96897724326e-05 , 0.001456591248 , 0.00454226099241 , 0.00202830926979 , -0.00116723990126 , 0.0023630796963 , -0.00395768663608 , 0.00188470032603 , -0.0012680948648 , -0.00261638009145 , -5.92609958927e-05 , 0.00373579780944 , 0.000912324001836 , 0.00261268918811 , -0.000996815002493 , 0.00132217643037 , -0.000910336175599 , 0.000683336890519 , 0.00241244909481 , -6.7739394018e-05 , 0.00031030136558 , -0.0049498582796 , -0.00385881959449 , 0.0049240421715 , -0.00440605093693 , -0.00107898053876 , -0.000828099135184 , 0.00636750729228 , ])
Y_2_2_imag = flex.double( [ 0.0 , 0.0 , 0.00194349267403 , 0.00636151163846 , 0.00480061983165 , 0.00239278317714 , -0.00497245926125 , 0.0011071953274 , 0.00344482100621 , -0.002849548649 , 0.00111948836452 , 0.000475055871853 , 0.000978752676014 , 0.0005820152276 , -0.000774842513641 , -0.00311991563177 , 0.00287927863907 , -0.00101369147228 , -0.00154457382003 , 0.000156172732108 , -0.00129210337143 , 0.0027054676029 , -0.00339383147443 , -0.000730111080402 , 0.00494039706457 , 0.00175074884221 , -0.000234100719635 , 0.000542982199395 , 0.000569938895233 , 0.000248789856383 , 0.000960819206569 , 0.000823708358265 , -0.000483151558314 , -0.00424872461887 , -0.00259927832617 , 0.00177423028481 , 0.00110097415123 , 8.13222992158e-05 , 0.000374787058026 , -0.00239856059246 , -0.00422760147586 , -0.00212370792064 , -0.00175540209859 , -0.000695670539199 , 0.000354027766176 , 0.00362272867877 , -0.000737198710555 , -0.00148596360715 , 0.0040545210757 , -0.00164498425074 , -2.21689331079e-05 , 0.000360393809392 , -0.00580779813152 , 0.00115713212703 , 0.0051633348613 , -2.95441375997e-05 , 0.000468905400003 , -0.00620344542893 , 0.000939306664716 , 0.00514714828557 , 0.0015520226663 , -0.00445417166613 , -0.000736849619801 , -0.00206182171369 , 0.00263916287804 , -0.00371308937072 , 0.00307836276576 , -0.00748276720508 , -0.00100616392141 , -0.00206403085658 , -0.00159131603044 , -0.00397210444073 , -0.00178757533481 , 0.00181773047769 , -7.20519571627e-05 , 0.00268839666603 , 0.00261962513683 , 0.00427821683503 , -1.33790421315e-06 , 0.00143760306232 , 0.00154400358442 , 0.0029324551872 , -0.00521469673668 , -0.00149207736363 , -0.00590379617228 , -0.004011481717 , -0.000154604256543 , -0.00328969923837 , 0.000117400387286 , -0.00281377208927 , -0.00236750539217 , -0.00112255984597 , 0.00160315191425 , -0.000270726125262 , -0.0020548935514 , 0.00208885333866 , -0.000572718233021 , -0.00410374335089 , 0.0020608906816 , -0.00178361544277 , -0.000646131100053 , -0.00338813531346 , -0.00145277388183 , -0.000581080693943 , 0.00466376448961 , -0.00570713124179 , 0.00148537452827 , 0.00152202282922 , 0.00374321076129 , -0.000237145877834 , 0.000900740391331 , -0.000777815730464 , -0.00497538896853 , -0.000292514581609 , 0.000463245881226 , -0.00224307956495 , -0.000965292700943 , 0.00191356212077 , 0.0017029522334 , 0.00115222402966 , -0.000185705091713 , 0.000238462562332 , -0.00118967505098 , 0.000421722012727 , 0.0033074148705 , 0.00462932643925 , -0.00400368555622 , -0.000459359147977 , 0.00571888914212 , -0.000234327436844 , -0.00459174714627 , 0.00155837537161 , 0.000282862685749 , -0.000178608682087 , -4.72834863321e-05 , 0.0021974539696 , 0.00473106372425 , 0.00415562399712 , -0.00134452526889 , 0.00147230555605 , 0.00127016533549 , -0.00282526228417 , 0.00275822063159 , -0.00151724041055 , 0.00309190011249 , 0.000278244828237 , -0.00302576583101 , -0.00405243097827 , 0.00158848584613 , 0.00105897506457 , 0.000461037467232 , 0.002278757976 , 0.000633331597395 , 0.000958971070718 , -0.00403455850424 , -0.00251817766831 , -0.0014022826425 , -0.00292023092552 , -0.00535013783602 , 0.00116505790151 , -0.00179601505788 , 0.000205276348838 , -8.44212774184e-05 , -0.00491897945288 , 0.00333385107112 , -0.00312582292868 , -0.00623537874689 , -0.00533512264467 , 0.00489534853524 , 0.000556212289056 , -0.00138232020567 , 4.60121363427e-06 , 0.00277501820652 , -0.00287738361044 , 0.000752300646048 , 0.000348478647328 , -0.00333799805933 , 0.00125992878989 , 0.00253936095394 , -0.00022998690165 , -0.00387906684874 , 0.00423738743359 , 0.00497932469431 , 0.000415733864827 , -0.000866358775262 , -0.000471963577136 , -0.000826709999243 , -0.00419641000698 , -0.00527237143644 , 0.000334589420999 , 0.00204571996245 , -0.00321695368037 , 2.91908674109e-05 , 0.000854056601571 , 0.00389629101072 , 0.00187904324486 , 0.000142488319841 , 0.00170294576211 , -0.00105474616786 , 0.00186179328835 , -0.00120303754719 , 0.00276449630769 , 0.00275247071299 , -0.00237678197485 , -0.000487879293844 , -0.000372263874725 , 0.000532835438531 , 0.00300579165439 , -0.00715767451756 , 0.00101259931533 , 0.00208767627852 , -0.00023150738217 , -0.000219378527489 , 0.00218800430767 , 0.00343820466287 , -0.00528659231267 , 0.00262670327335 , 0.000830837488669 , 0.000931088217322 , -0.000302484963522 , 0.00336090406925 , -0.00235160734289 , -0.00412306208346 , -0.0049300592897 , -0.0037159253386 , -0.000329361380338 , -0.00121460115565 , 0.00255715266711 , -0.00121659166983 , -0.00263325576726 , 0.00101776668523 , 0.00216189110293 , 0.00623516557215 , -0.00417764462035 , 0.0002734772425 , -0.00117223875571 , -0.000406497685024 , 0.00321523287194 , 0.000736878833133 , 0.0056847017932 , -0.0030596494973 , 0.00509416661558 , 0.00326506900403 , 0.000782653216066 , 0.00113247829 , -0.000100706477525 , 0.00668932044354 , 0.00398694717331 , 0.00116266856972 , -0.00359837264184 , -8.8161063304e-06 , 9.22384929211e-05 , 0.00112582151387 , 0.00388476089979 , 0.00103902053512 , -0.000656861742824 , -0.000414115574752 , 0.00122650786524 , 0.00167311354126 , 0.00166031360083 , 0.00119554114429 , -0.000830478636097 , -0.000876747422676 , -0.00369514259228 , -0.00155005503814 , 0.00545065887868 , 0.00423276243844 , -0.000703366508319 , 0.00252877310247 , 0.0058763306126 , 0.00264801890743 , 0.00293365135028 , -0.000549624159672 , -0.000323740895433 , -0.00452766155431 , 0.00339592437265 , 0.00658027690324 , -0.0050556861271 , 0.00262728477372 , -0.00308337494014 , -0.00382051440984 , -0.00240900101936 , -0.00179251477634 , 0.00262591402211 , 0.00322982382647 , 0.00429658714899 , 0.00282175804404 , 0.00354981870808 , -0.00288405373691 , 0.00261071477123 , 0.00461616659079 , -0.00222510646144 , -0.00544329474113 , 0.00350326846708 , -0.000729048979166 , 0.00247301602205 , 0.00348868072168 , -0.00529416593236 , -0.0021443482831 , 0.000257204792641 , 4.41185966172e-05 , 0.000152758661709 , -0.00137675943036 , 0.00443990909115 , -0.0017838241487 , -0.00244500831366 , -0.00292930663233 , 0.00145688355381 , -0.00287034672903 , -0.00113893471209 , 0.00207684042765 , 0.00329180291193 , -0.00289872248569 , -0.00242336768074 , -0.00318108523786 , -0.000261543034501 , -0.000767551017266 , -0.00171176504412 , 0.00170500580663 , 0.00489522761386 , 0.00115008643009 , 0.000191461454048 , -0.00436089185703 , 0.00170607456867 , 0.000806302184906 , -0.00439947421299 , 0.0039421070611 , -0.000849869567367 , -0.00176225568734 , 0.00330287928941 , 4.58550984691e-05 , -0.00265618918356 , -0.00176733385666 , 0.00093098099919 , -0.000757630556077 , 0.00124385209643 , -0.00356319757786 , -7.16996899415e-05 , -0.00705952093966 , -0.00142832526608 , -0.000441953386084 , 0.000679417965529 , -0.00171639015923 , -0.00455653789615 , 0.00161162094127 , 0.000132245414248 , 0.00316553707489 , 0.000503042913114 , 0.00413283867052 , -0.00290861964686 , 0.000910502435612 , -0.00307588059922 , -0.00278926154563 , -0.00334069608696 , -0.00557515846861 , -0.00338943866223 , -0.00365311040266 , 0.00341811752552 , 0.0041307706843 , -0.00225490283341 , -0.00679885269573 , 0.000303901113135 , 3.34923619223e-05 , -0.00203813859038 , -0.0033794815427 , -0.00335633212972 , -0.00374418622658 , 1.71396056657e-05 , 0.00224362210972 , 0.00193190805424 , 0.000903209201677 , 0.00461303790131 , 0.00131722845753 , 0.00523044558209 , -0.00284914208493 , 0.00442580861891 , 0.00196185256289 , 0.0035217087162 , -0.00027966215165 , 0.00139845774522 , 0.00162382399054 , -0.000356019867011 , -0.00386516327787 , 0.00381707799962 , -0.00331857718495 , -0.000426039317579 , 0.00156053847662 , -0.00135693110186 , 0.000263264968566 , -0.0067248779558 , 0.000296746195401 , -0.00161437283687 , -0.00363903200579 , 0.00266421819553 , 0.00233013202062 , 0.00533591378197 , -0.000376840474655 , 0.00163360585584 , -0.00327745518127 , -0.00415172555203 , -0.000948599438011 , -0.00581048799564 , -3.47946689216e-06 , -0.00296299972353 , -0.000476763651241 , -0.00190701820172 , 0.000151174161941 , 0.000749247038291 , -0.00231838858674 , 0.00159777443789 , 0.00445730251011 , -0.00315157013723 , 0.00221486220044 , -0.000601498331288 , -0.00130547127489 , 2.59964835825e-05 , -0.00402046704453 , -0.00330939225075 , 0.0043230998753 , -0.00103955979011 , 0.00366835843852 , 0.00620271834758 , -0.0059990697285 , -0.00226910465175 , -0.000602898469642 , 0.000213858147184 , -0.00344408094001 , -0.00331220371989 , -0.00237857398514 , -0.00100492347727 , -0.00357339952234 , -0.00259337374578 , 0.00383917708716 , -0.00381901422424 , -0.00534326210234 , 0.000277667806461 , 0.00317762655859 , 9.66007960531e-05 , -0.00470078480016 , 0.000375113097578 , -0.00216402280098 , -0.000921679333518 , -0.000811235662321 , 0.00581335078034 , -0.00116973681754 , -0.000268319741091 , 0.000372273614377 , 0.00338871823839 , 0.0025771074025 , 0.000108699566012 , 0.00212665694834 , -0.00299331092249 , -0.0019402278521 , 0.000264229252092 , -0.00155368602636 , 0.000725380450679 , 0.00482511699196 , -0.00318067328316 , 0.00256695060714 , 0.00221313016707 , 0.00531826998472 , 0.00430726893281 , -0.00221078250128 , 0.00176042393824 , -0.000108675671622 , 0.00408218725993 , 0.000122149682532 , -0.00222397482248 , -0.00081565801855 , -0.00252225909001 , -0.000657815041708 , -0.00285925627427 , 0.000418089494318 , -0.0047677689067 , -0.000587876011017 , 0.00290006281706 , 0.00328988075508 , -0.00426940170915 , -0.00300022431025 , 0.00432737645993 , 0.00387452642367 , -0.000753802226104 , -0.000965195793848 , 0.00391033790585 , -9.19220371652e-05 , 0.00106465315211 , 0.00185757344218 , -0.00395944876663 , 0.00466708836455 , 0.00627948843264 , -0.00390998928369 , -0.0024312370852 , -0.00133752447126 , 0.00496608670941 , 0.00222935215982 , 0.00270674912044 , 0.00269226443839 , -0.00140816573642 , 0.00138098199238 , -0.00279442328241 , -0.00210402259818 , -0.00123332318359 , -0.00233903169865 , -0.00194738121213 , -0.000678705559036 , -0.000252408712425 , -0.000809810496585 , -0.00140534068265 , 0.000751659456719 , -0.000515739541312 , -0.00481553434453 , 0.0052406238359 , 0.000307367547333 , 0.00137551916349 , -0.00101091754188 , -0.00632863290676 , -0.00287959295386 , 0.00401474357842 , 0.00172400025764 , 0.0053628113111 , -0.00208236312558 , 0.00418980138328 , -0.0038177872806 , 0.00400868413339 , -0.000328613904409 , 0.000501866386919 , 0.00291712714529 , -0.00274882969319 , 0.00545490119538 , 2.58970093289e-05 , 0.000110210091894 , 0.000621759283965 , -0.00078808160361 , 0.00120111955388 , 0.00298298854432 , 0.00258335659672 , -0.00241603282191 , -0.000826146611764 , -0.00364866327463 , -0.00203351958811 , -0.00145460985712 , 0.0025621330018 , -0.00421979358154 , -0.00307572881378 , -0.000176879289941 , 0.00374632371976 , 0.000508663064781 , 8.5020104341e-06 , -0.00112592258332 , 0.00357057715868 , 0.00212541713763 , -0.00173097116394 , -0.000118340944752 , -5.20625643921e-05 , -0.000819711141551 , -9.42097003081e-05 , 0.000241307268045 , -0.00212735230817 , 0.0014691843332 , -0.00172927210392 , 0.000654923884152 , 0.00142599401378 , 0.000716139431745 , -0.000256275092811 , 0.00505849071222 , 0.00185520289332 , -0.00444982819083 , 0.00200385959184 , 0.00110721257424 , 0.0035851467599 , 0.00565805810661 , -0.00171022520321 , 0.00336285236147 , -0.00375488642896 , -0.00287518086371 , 0.00192191158864 , 0.00500134231528 , -0.00253224442642 , -0.00285098333487 , 0.0012277996285 , 0.000389794288827 , -0.00115196316848 , -0.00698705018659 , 0.00362073706609 , 0.00193181271522 , 0.00526939351949 , 0.00298937955379 , 0.00196759956054 , 0.000903740340345 , 0.000694790104107 , -0.00115227527987 , -0.00206385020372 , 8.57155263254e-05 , -0.0027259774475 , 0.00188237468259 , 0.000169455702071 , 0.00199945113636 , -0.00117713136538 , -0.000160185159234 , -0.00102520481771 , 0.00491287525853 , 0.00174510149832 , 0.00495816583594 , -0.00496048818322 , -0.000609015149469 , -0.0044793816497 , -0.00561992916646 , -0.00109158078374 , 0.00307863545916 , -0.000802387346812 , -0.00557338960617 , 0.00408819343508 , -6.58242805702e-05 , -0.00506344727193 , 0.00239207828807 , 0.00382411022755 , 0.000798953020802 , 0.000144954883415 , -0.00323945443574 , 0.00610462840925 , 0.00304426361697 , 0.00220638342185 , -0.00192391494664 , -0.00500328729301 , 0.000435578740594 , -0.0051651079818 , -0.00377147846894 , 0.000987308227362 , -0.00105092115933 , -1.20843240488e-05 , 0.00166017961563 , 0.00502835503655 , -0.00490131735346 , 0.000268048061038 , -0.00319312923085 , -0.00334923971349 , 0.00501238090794 , 0.00101374901689 , 0.000980254917704 , 0.00576916935215 , -0.00817201892314 , 0.00544521399272 , -0.000590242218443 , -0.000156641260303 , -0.00210808123626 , -0.0012173663179 , -0.00306807090279 , 0.00217888646188 , 0.00383933653396 , 0.00052103450651 , 0.00179181930102 , -0.00239749367765 , 0.00512572010313 , 0.0037182914481 , 0.00269062328146 , -0.000743491141673 , 0.00420943549604 , -0.00155009869359 , -0.00047299197279 , 0.000658596460031 , 0.000214143618937 , -0.000278880628674 , -0.00153596022354 , 0.00562757187966 , -0.0012836106342 , 0.000126669611849 , -0.00516102429433 , 0.000505866044147 , -0.000404666964541 , -0.00199045183756 , -0.00192943920325 , 0.000710099283858 , 0.000174602063904 , 0.00034590124611 , 0.00254735692397 , -0.0028528916178 , -0.00263591933824 , -0.000131656015845 , -0.00426500923189 , 0.000557121847812 , -0.00391533304481 , 0.00483976905973 , 0.00293306111588 , -0.00266177808745 , -0.00521858521525 , 0.00125077142353 , -0.00238299131407 , -0.00247925118461 , 0.00150258222585 , -0.00323649944543 , 0.00207502395592 , -0.00121189654902 , -0.000392361017574 , -0.000116148931393 , -0.00146544501217 , 0.0028711667542 , 0.00035091995167 , -0.00194923849015 , 0.00157324759094 , 0.00213591547286 , -0.00207011196564 , -0.0037288417173 , 0.00271268027849 , 0.00269816958913 , -0.000542110107196 , -0.0019022275417 , 0.000687096746093 , -0.00338567577148 , 0.00368575643306 , -0.00296181526039 , -0.00402721483726 , -0.00407659697683 , 0.00395793755385 , 0.00138514255435 , -0.00274871321253 , 0.0034655033944 , -0.00588510154255 , -0.0048562430319 , -0.00366671045995 , -0.00345647156328 , 0.0031117760458 , 0.00183429847965 , 0.000283791884377 , 0.000430516883531 , 0.00167669642977 , -0.00149328218013 , 0.0048095952668 , 0.0035105044524 , -4.35845250597e-05 , -0.00267144362678 , 0.000469486147289 , 0.00464635286981 , 0.00127681395555 , 0.00368893896242 , 0.000641911259037 , -0.000943301999324 , 0.00140587253272 , -0.00348848084576 , -0.000149861773711 , 0.00329188343141 , -0.00365845302755 , 0.00251915879387 , -0.000413836810839 , 0.00176246621925 , 9.46262368631e-05 , -0.00189275226007 , -0.000443111566153 , 0.0018030110556 , 0.00124053490306 , 0.000364995752714 , 0.00081445056407 , 0.00123422692108 , 0.00452074779124 , 0.000142032911487 , -0.00171022537313 , 0.000365970813555 , -0.000232225418885 , 0.00336998038916 , -0.00173691151599 , -0.000158644967526 , 0.000126801646311 , 0.00558827608061 , -0.00115036313936 , 0.00087356565319 , -0.00228902438262 , 0.00410406580691 , -0.000890071640644 , 0.00109553760493 , 0.00355038837192 , -0.00217570945535 , 0.00263019166595 , -0.00421028445108 , 0.00176929670235 , 0.000631157156453 , 0.00089600552037 , 0.000992021930172 , -0.00202923460706 , 0.00597701246809 , -0.000328028734727 , -0.000114668468906 , -0.00181423795852 , -0.000166595117108 , -0.00192106379519 , -7.13740649378e-05 , -0.00154370678501 , 0.00179128779976 , 0.00521189930856 , -0.00174578382653 , 0.00333847450262 , -2.21424482139e-05 , 7.39418699156e-05 , -0.00444924606133 , 0.000969014533284 , 0.00127760269487 , -0.00438955148558 , 0.00175144074481 , 0.00231725445568 , -0.00266406071412 , -0.000886802000304 , -0.000696319176896 , -0.00100788244451 , -0.000214147584945 , 0.00613112269325 , -0.00401406670634 , 0.00158507485689 , 0.000219187105563 , 0.00170262730392 , -3.37560697169e-05 , -0.000293735980861 , 0.00384290446121 , -0.002991189797 , -0.00244099370696 , -0.00658495353488 , 0.00182200149188 , -0.000562803459289 , 0.00403269159101 , 0.00383422410803 , 0.00416910830066 , -0.0010434116584 , -0.00479487727676 , -0.00267942999416 , -0.00397273601629 , -0.00205806476674 , -0.00108335034113 , -0.000618450191206 , 0.000618779089015 , 0.00192668818313 , 0.00152823149791 , -0.000635454506703 , 0.00219996511631 , -0.00757794270878 , 0.00112728610258 , -0.00298362072414 , 0.00194358893197 , 0.00254462398017 , -0.00463018511647 , 0.00334769410124 , 0.00065048786955 , 0.00508385176066 , -0.000196043002576 , -0.00156824055121 , 0.00430422776022 , -0.000667288020828 , -0.00229825134266 , -0.00112245856094 , -0.000101862686935 , -1.59720420585e-05 , -0.000293645427811 , 0.00505522603957 , 0.00240933002066 , -0.000691758663256 , 0.000190393589683 , 0.00219348484975 , 0.000205990937286 , -0.00553715543225 , -0.00161807126396 , 0.000135061095498 , -0.00124972759475 , 0.0037705440681 , -0.00152037295438 , 0.0049474184471 , 0.000113355374705 , -3.89754547535e-05 , 0.00552925654604 , -0.00101534139311 , 0.00519137815265 , -0.00176523673795 , 0.00303456229013 , 0.00084565456961 , 0.00508073962257 , 0.00430351557622 , -0.00229082984701 , 3.40932568524e-05 , -0.00550308242139 , -0.00226968716927 , 0.00614718211402 , -0.00446428469613 , -1.04491048789e-05 , -0.00310629712745 , 0.000321348310246 , -0.00408520404968 , -0.00489339434542 , -0.000326213827574 , -0.00315389270474 , -0.00204816884981 , 0.00157091057804 , 0.00530798988568 , -0.00215654779304 , 0.00406485382178 , 0.0047054517869 , 0.00273074700862 , -0.00284121090231 , -0.00280575415521 , -0.00330680764931 , -0.00454244124956 , 0.00226734625379 , -0.000940203188125 , -0.000357948788109 , 0.000625633581661 , -0.0010851550379 , ])
Y_3_m3_real = flex.double( [ 0.0 , 0.00738160764446 , -0.00512451708064 , -0.00302284838821 , -0.00546753672362 , 0.00271957462499 , 0.00604178563935 , -0.00486777197972 , -6.53114869624e-05 , 0.00439299895845 , -0.00318684319031 , 0.000285309061115 , 0.00050575338312 , -0.00049775153882 , 0.000129262888262 , -0.00146165638769 , 0.00405984703487 , -0.000465495622813 , 0.00238768286919 , -0.000151761571889 , -0.00619355009475 , 0.00230038273341 , -0.00467606066006 , -0.00369839505236 , 0.00363874126098 , -0.0011009764471 , 0.00179699208633 , 0.000841780725661 , 0.000677948193319 , -2.16447199096e-05 , 0.000360230936503 , -0.00119888615398 , 0.000781882124884 , -0.00126904366523 , 0.00375162677294 , 0.00402421452438 , 0.00568641716543 , 4.72190221157e-05 , -0.000376496578207 , 0.00126507157131 , 0.000358537633125 , -0.00370004078999 , 0.000895558536154 , 0.00279160037462 , -0.0034074777265 , 0.00133613966528 , -0.00376070170014 , -0.00480742082777 , -0.000341603188822 , 0.000482387168008 , -3.54495328163e-05 , -0.00259077813347 , 0.00606303861718 , -0.00186204546816 , -0.00499088272697 , 2.51494548977e-05 , -9.96854559187e-05 , 0.00446740557321 , -0.00111141973054 , -0.0067151277684 , 0.00618689143965 , -0.0019478192401 , -0.000156812490241 , -0.00217673118772 , 0.00152921396747 , -0.00222564228419 , -0.00104489221998 , -0.00494616663197 , 0.00119086515823 , 0.00290116668209 , 0.00324101758566 , 0.00236003230789 , -0.00548088615749 , -0.00108970747365 , 2.50568243945e-05 , -8.62357210384e-05 , 0.00222502343234 , -0.00292476465877 , 9.62179201091e-07 , 0.00070637281722 , -0.000512543320778 , -0.0029753397748 , -0.00469163996646 , -0.00339935850854 , 0.00220336887945 , -0.000748391356771 , 6.36473995457e-05 , -0.00318433481612 , 0.000487129629936 , 0.000346984121868 , -0.000893685248475 , 0.000634292967118 , 0.00150228594061 , 0.000279762064295 , 0.00166661797265 , -0.00272530183944 , 0.00027356524874 , -0.00501652119216 , -0.00265930158652 , 0.000473750862768 , 0.00236988648057 , 0.00268359986412 , -0.00175173465547 , -0.00453967225385 , 0.0010849832154 , 0.00329480658429 , 0.00224983932482 , -0.00240199410907 , -0.00432432527215 , 4.85450784862e-05 , -0.00020277357402 , 0.000215749418531 , 0.00526576925458 , -0.000119659705309 , 2.73266926008e-05 , 0.00184788837152 , -0.00440823315451 , -0.00216053978586 , -0.00184218811324 , 0.00129663087988 , -0.00188701396303 , -0.000383788825069 , 0.000952467136558 , -0.000953631914435 , 0.00118922443961 , 0.000324589516423 , 0.00332301549957 , -0.000155827917599 , 0.00657737881579 , -0.000419925500319 , 0.00121607307541 , -0.00527232351077 , 0.000457033021671 , 0.000202287637677 , -2.92409706538e-05 , 0.00347561828945 , -0.00523238004255 , 0.000743165870996 , 0.00429148298227 , -0.00179760184956 , 0.000971134143324 , -0.00429467359804 , 0.000103134172216 , 0.000292534812489 , 0.00583119051947 , 0.00363989180103 , -0.00133605604885 , -0.00029328219341 , 0.0017959682481 , -0.00278496476065 , -0.00032431565389 , 0.00334766946698 , -0.000636029373981 , 0.00150721123539 , 0.000705946478431 , 0.00270145582441 , 0.00365198538734 , 0.00221872173383 , 0.00512299580405 , -0.00174544201131 , 0.00236665227356 , -6.80570554171e-05 , 0.000187015394595 , 0.00681599250583 , -0.00485244243803 , -0.00382728871493 , -0.00783580030933 , -0.00413598577746 , -0.00559929668067 , 0.000450656848622 , -0.00245385197755 , 7.33239050485e-06 , 0.00303086394951 , -0.00180316901688 , -0.000508033419137 , -0.000761648805475 , 0.00484142804488 , -0.00229946574959 , 0.000815228514868 , 0.000155381694404 , 0.00260841306146 , 0.00299458593837 , 0.00634021191896 , 0.00147591308933 , 0.00437736733957 , 0.000195204313937 , 0.00105653433248 , 0.00377298813381 , 0.00706586951099 , -0.000119190215098 , 0.0024799862059 , -0.0029103159238 , 4.53576771759e-05 , -0.00503426616368 , -0.00175150565204 , 0.00180400321571 , 1.37344526346e-05 , -0.00123543888787 , 0.00111074044911 , 0.00587627085409 , 0.00181771114816 , -0.00164624629352 , -0.001292288935 , 0.00347951436433 , -0.000544212226028 , -0.000172112080717 , 0.000788601146955 , 0.00200791761216 , 0.00504886256771 , -0.00277797416039 , -0.000145574150289 , -0.000181350565608 , 3.34377523149e-05 , -0.00288546352862 , -5.28617104621e-05 , -0.00592488321374 , -0.00266506711832 , -0.00104287818542 , -0.00124586852382 , 0.00214694278057 , 0.00331122975906 , 0.000648042124782 , -0.00155419967328 , -0.000925673301782 , -0.00456726563404 , -0.000496385845316 , 0.0035296919808 , -0.00116600578017 , -0.00195258257107 , -0.00228989479847 , 0.00489228127562 , -0.00291744026549 , 0.0043974909694 , 0.000956341579505 , -0.00610429759121 , 0.00187050361881 , 0.00039687946526 , -0.00310837443025 , 0.000720112982695 , 0.00550386695733 , -0.00398392989373 , 0.00417369119189 , -0.00409027228898 , -0.000865061695566 , -0.0016068185612 , 8.88870574739e-05 , 0.00505726691571 , 0.0024657415845 , -0.00182472934514 , -0.00507178185987 , 0.000723066970672 , -0.000141170935026 , -0.000163935173865 , 0.00141737872214 , -0.000319339156005 , 0.00569118341461 , -0.00616424655439 , 0.00194485798528 , -0.00282949443497 , 0.00188847666868 , 0.00103087138493 , -0.000246431041357 , -0.00125318009872 , -0.00468453954813 , -0.0026526407652 , -0.00220457267504 , -0.00181578711056 , 0.000635238901511 , 0.00189644228271 , -0.00352290514481 , -0.00202991975737 , -0.000703961061763 , -0.000712475481037 , 0.00484802542134 , -0.00392098667934 , 0.00161313592423 , 0.00651801248826 , 0.00014499468806 , 0.00093006706603 , 0.00369904385206 , 0.00461628889737 , -0.00221194540199 , 0.00620451769655 , -0.00231666370966 , -0.0048608190077 , -0.00399374975594 , 0.000560585643278 , 0.0044170836585 , 0.00372051945858 , -0.000674630161671 , 0.00215208188245 , -0.00145233420436 , 0.00246460467289 , -0.00494736983601 , -0.00112643497045 , -0.00427549680552 , 0.00274725474498 , 0.00593889428188 , 0.00289939878244 , 0.00411770007164 , -2.34675132998e-05 , -0.000245898050102 , -0.000885169200187 , 0.00639094235479 , 0.000720339021065 , 0.00111404131118 , -0.00187148393824 , 0.000159451644474 , -0.00268308065283 , 0.00181907491574 , 0.00305276338411 , 0.00435909261554 , -0.00367578656709 , 0.00355654518837 , 0.00489898616235 , 0.00038266617901 , 0.000896342496864 , -0.00235222567784 , -0.00160153144842 , -0.00211628600356 , -0.00167000304895 , 8.66090600182e-05 , 0.00441273973886 , 0.00266021241461 , -0.000481656548629 , -0.00285515714523 , 0.00133436431741 , 0.00130846722421 , -0.00124099514957 , -0.000627738332771 , 4.14787127132e-06 , -0.00276391566588 , -0.00182740481662 , 0.00021118343092 , -0.000530250513586 , 0.00200070595431 , 0.00437476428302 , -6.6726322286e-05 , -0.00387997890254 , -0.000807948426489 , -0.00071422777037 , -0.000295697491914 , -0.00139799589889 , -0.00114414124857 , 0.0011669195914 , 0.000103974905462 , 0.00409173408327 , 0.000358384223198 , 0.00524297840147 , 0.000743111732455 , 0.00527272229838 , 0.00408987874136 , 0.00286755955696 , 0.00116476702216 , 0.00561931627466 , -0.0032352471403 , 0.00375742086322 , -0.00485899812452 , -0.00297555032017 , 0.00242424839573 , -0.00760711798907 , -0.000164736266671 , -6.3842744218e-06 , -0.00351917426629 , -0.00216914761848 , 0.000122723645379 , 0.00488538783488 , 5.93209232518e-06 , 0.00183506141441 , 0.002483765684 , -0.000208683265538 , 0.00443338054436 , 0.00302648422737 , -0.00654503437503 , -0.00217663249943 , -0.00555520681162 , 0.00276404104337 , 0.00363801331826 , 0.000315508428193 , 0.00254611672847 , 0.00278994843941 , 0.000562392124231 , 0.00186451417633 , -0.00148995067129 , -0.000168816260781 , 0.000166644662127 , 0.00162328366726 , -0.00158176418527 , -0.000304356678751 , -0.00686652981943 , -0.000454203403981 , -0.00219279422688 , 0.00174679676042 , -0.00564790308626 , 0.00138214887637 , 0.000618834840171 , -0.000358397247827 , 0.00105851059772 , 0.00421844034608 , -0.00534592490913 , 0.000924035518434 , -0.000465898757552 , 0.000349984590725 , -0.000304936107063 , -0.00059276347165 , 5.98457685844e-05 , 4.7612241157e-05 , 4.57307296511e-05 , -0.000815926212602 , -0.00322046726428 , -0.00310928713583 , -0.0044409985246 , -0.0030839714832 , 0.000948645708699 , -0.000601254642638 , -0.00255892770327 , 0.00232520850085 , 0.00402063854 , 0.00246609210163 , 0.00461724479196 , -0.000379061592113 , 0.00404156856399 , -0.00428933295183 , 0.00306576184898 , 0.000876583903382 , -0.00386702789808 , -0.00191558716743 , 0.000762681135976 , 0.00162288260508 , -0.000896870819788 , 0.00275809309839 , 0.00261048075523 , 0.000316290526207 , -0.00542659746713 , -0.00480392588108 , 0.000216103599424 , -0.00294646475414 , -2.02207003135e-05 , 0.00235763823935 , -0.000189622733017 , 0.00277467119946 , 0.00209389812958 , 0.00107663982378 , -0.00448508170094 , 0.00105790178764 , 0.000156500822264 , -0.000424083784714 , -0.0038636934852 , 0.00271271085054 , 0.000745558824458 , -0.00149487206413 , 0.003856610041 , -0.00333182456762 , 0.000332658349315 , -9.58742656433e-05 , 0.000666732049549 , 0.00242321399473 , -0.00260219408205 , -0.00364885364974 , 0.000743214116824 , -0.00442520345577 , 0.00484459227657 , -0.000115137298815 , -6.19724331556e-05 , -0.000173220569395 , -0.000361388243504 , -0.00410269947375 , -0.00514317309934 , -7.19159751633e-05 , -0.00373939520625 , 0.000791232477803 , -3.018206273e-05 , -0.00380382526063 , -0.00641325465734 , -0.00574940824548 , -0.00128182762578 , -0.00452300230455 , 9.81145762071e-05 , 0.00602764301853 , -0.00508449620347 , -0.00223568651582 , -0.00289090824556 , -0.000148563792039 , 0.00166077095155 , 2.13719803936e-05 , -0.00223820776775 , -0.00125630705214 , 0.00170529511014 , -0.00493075084152 , 0.00333092762095 , 0.00212504747018 , -0.003773440093 , 0.00161590454358 , 0.00201757778625 , -0.00242565306248 , 0.000563208845854 , -0.00255650208587 , -0.00063743903049 , -0.00209271893603 , -0.00409490223852 , -0.000889274127685 , 0.000864882219358 , 0.0013871192613 , -0.00291584391455 , -0.000998467208869 , 0.00370543748748 , -0.00107730667397 , -0.00212684503739 , 0.000894795187061 , -0.000547995327304 , 0.00396078881627 , 0.00165968551258 , 0.00361942783642 , 0.00337938052845 , -0.00101848753943 , 0.0072282457033 , 0.00293513179296 , 0.004688356836 , -0.00141877902042 , 0.00715978834093 , 0.00238171304076 , 0.00634859598057 , 0.00326169055365 , -0.00283935129361 , 1.05984901208e-05 , 0.0005514804512 , 0.000696811375401 , -0.000402743419014 , -0.0010212999619 , 5.37974805129e-05 , -0.000150888328522 , 0.000309466200057 , -0.00122742229998 , -0.00396970180803 , 0.00389841718409 , 0.00143377322073 , -0.000862883776577 , 0.000259826089766 , 0.00428230698575 , 0.00456035141345 , 0.00128780266409 , 0.00314540813203 , 0.00506859501254 , -0.00449696816617 , -0.000195655281878 , -0.00226987205605 , -0.000268033628963 , -3.42981196767e-07 , -0.00492149809411 , -0.00536461454379 , 0.00229094714809 , -0.000985283625985 , -7.13411257443e-05 , -1.87493638748e-06 , -0.00235933210067 , -0.000112981434232 , -0.000117586417727 , -0.00234516545585 , -0.000574470216866 , -0.0015243179889 , 0.000360948171456 , -0.00609618405268 , -0.00432043074599 , -5.39154401047e-05 , -0.00650030507562 , -0.00254825045026 , -0.00355157817097 , -0.00211255203606 , 0.00152993246087 , -0.000236487802614 , 0.00579496962842 , -0.00211169181408 , 0.00472036199122 , -0.000900952797285 , -0.0019900868825 , 0.00409768023886 , 0.00459344273124 , -0.0028282817455 , -9.08446717083e-05 , -0.000554734248887 , 0.000511771437121 , -0.000757528179508 , 0.0056220168737 , 0.00327641379238 , 0.00295735487863 , 0.00574211957069 , 0.00288981934307 , -0.00091313076227 , 0.000342271956285 , 0.000974770956377 , -0.00440277638057 , -0.00177541779178 , -0.00422703361297 , 0.0041084791053 , -0.00297125493776 , -0.000447583063851 , -0.00470904083645 , -0.00186120476172 , 0.00453876234274 , -0.000477941754112 , -0.00353292754611 , 0.00276206484731 , -0.00470513525579 , 0.00468039420037 , 0.00453495564234 , 0.000550739697354 , -0.0035765363442 , -0.000317352209405 , -0.00136546566772 , 0.000278351320138 , -0.00196737644731 , -0.00495937570134 , -0.00226689730393 , 0.00253154460472 , -0.00173505471143 , -0.00498259173247 , -0.000412830582737 , -7.75016329159e-05 , 0.00174917203121 , 0.00132861317471 , -0.00200006615368 , -0.0026052071298 , 0.000866091142574 , -0.00255561384067 , -0.000130297125926 , 0.00415220712704 , 0.00341995500777 , 0.00126955254519 , 0.00159805558423 , 2.83067999001e-06 , 0.00234398786935 , -0.00151027231476 , -0.00446758402076 , -0.000601871234153 , -0.00339767614493 , 0.00482282492124 , -0.00220824066537 , 0.00103971355 , -0.00154137933321 , 0.00422663483953 , -0.00714549777823 , -0.00395436290029 , -0.00120531482778 , -5.13111601134e-05 , -0.00260125329517 , -0.000234047625954 , 0.00142594704718 , -0.00242957767049 , -0.000345587425778 , 0.000149929760817 , -0.00213455824144 , -0.00153369178531 , 0.00473400219292 , 0.000688862140884 , -0.000836154907153 , -0.000426873966163 , -0.00194087421333 , -0.00108253798614 , 0.000353848400216 , 0.000685690908461 , 5.09369768982e-05 , 0.000341277201784 , -0.000339443217969 , -0.00535050168592 , -0.00112098707702 , 0.000111628057569 , 0.00012049842709 , 0.000192078433729 , 6.58385721329e-05 , 0.00113437035433 , -0.000798010486206 , -0.00666122782675 , 0.00023171723033 , 0.000370584541803 , 0.00261619408778 , 0.00416806249786 , 0.000770028409124 , -0.000187455128307 , 0.00154348215455 , 0.00414552267123 , -0.00262345219302 , -0.00414194668666 , -0.00210125596151 , 0.000652476924323 , 0.000482559984422 , -0.00116706293725 , 8.50213914233e-05 , -0.00328245603623 , -1.81394352732e-05 , -0.00415085654101 , -0.000195548953205 , 0.00191988055485 , 0.000554350245973 , 0.000146261443095 , 0.001012382654 , 0.00272020638113 , -0.000484556665102 , -0.00308439952794 , -0.000931653226298 , -0.00323941972608 , 0.00381544565824 , 0.00507831393165 , 0.00362166472983 , 0.00276629851096 , 0.002482008953 , 0.0014767093241 , -8.2519119706e-05 , 0.00263118051433 , -0.00509279189978 , -0.00199606764408 , -0.00442331065414 , 0.000782709783448 , -0.0035299637503 , 0.00208483505426 , -0.00446856749788 , -0.00501470774034 , 0.00126406274552 , 0.00583708582494 , -0.00019783835986 , -0.0012970369772 , 0.00273035282936 , 0.00249007709696 , 0.000423044978066 , -0.000359881648077 , -0.000451632675578 , 0.00184019130749 , -0.000424268714981 , 0.00487093237617 , -3.45775094537e-06 , 0.000964864912483 , 3.02818825808e-05 , 0.00453031599953 , -0.00107967464766 , 0.00352851724443 , 0.00138744668689 , 0.000535764276366 , 4.69766800034e-05 , -0.000814351537828 , 1.77343494292e-05 , 0.000968891162446 , -0.00418642740499 , 0.00362521593811 , 0.00110132255513 , -0.00274330675399 , -6.78118329043e-05 , -0.00196111861501 , 0.000238056770516 , 0.000122670195721 , -0.0010179460073 , 0.000144371634344 , 0.00240346717694 , 0.000403350755719 , 0.00338420854087 , -9.1926144791e-06 , 0.00227856129096 , -6.37867825295e-05 , -0.00192483106869 , 0.0038261909836 , 0.00203896815716 , 0.00020400434339 , 1.89013583288e-05 , 0.00649834387841 , -0.00135021716923 , -0.000866845859663 , -0.00296192423875 , 0.00101643310531 , -0.000597413635249 , -0.00138007574045 , 0.00533088953472 , -0.00142451058077 , -0.00267032983324 , -0.00392317549902 , 0.000781623488382 , 0.000981005157853 , 0.000662385783887 , 0.00273895182393 , -0.000324613497171 , 0.00780542772717 , -8.0803749802e-05 , -0.00613709058193 , -0.00256491566118 , 8.16203124278e-06 , -0.00112449756547 , 3.20984893525e-05 , 0.00208062154994 , 0.00187744751735 , -0.00486544831075 , 0.00235679011231 , -0.00283738674178 , 0.00394373626478 , -0.000548756833137 , -0.00152440910061 , 0.000769959451898 , 0.000471693988718 , -0.00515854930874 , 0.000274700402388 , -0.00027411831938 , -0.00339581831632 , 0.000121029888453 , -3.21745259969e-07 , -0.00101280363175 , -0.00015296757413 , -0.000302656861351 , -0.00334921448704 , -0.00090725593251 , 0.000116876496294 , 0.000956187647745 , 0.00297082806128 , 0.000174765337305 , 0.00169263891649 , -0.00216753425218 , 0.0025471147643 , 0.00184735851297 , -0.00148009797725 , 4.99035453279e-05 , -0.00355759752765 , -0.00101313338161 , -0.000495782162851 , 0.000761124495023 , -0.000456726215913 , 0.00237370800038 , 0.00230376882143 , -0.00140196307571 , -0.00016124609447 , -3.71494236494e-05 , 0.00205085082196 , -0.00290432764147 , -0.00113154119845 , 0.000743593873515 , -0.00287743130919 , -0.00256998107444 , 0.000644486532132 , 0.00364277468555 , 0.00243477095622 , -0.000595240783924 , -0.00104215044575 , -0.00376678796791 , 0.00527975565908 , 0.00101529638491 , -8.61710984596e-05 , 0.00224735593771 , -0.000506565758229 , -0.00055979640237 , -0.00028920964137 , -0.00175194456212 , -0.00415569247481 , -4.65726051784e-06 , -0.000412591636508 , 0.000217195743206 , -0.000296939987297 , -0.00100745279984 , 2.43934916241e-05 , 0.00066510828665 , 7.21365112278e-05 , 0.00291254963596 , 0.00465517691846 , 0.00594811270332 , 0.000632517439034 , -0.00537021170409 , -0.00279337964725 , -0.00314764151692 , -0.000874902752089 , -7.66120081025e-06 , -0.00593363675986 , 0.00138690579004 , -0.00224912014168 , 0.00066694371907 , 0.00283099476726 , 0.00379702641098 , -0.00221410651865 , 0.00493389627817 , 0.00196568216395 , 1.03267444767e-05 , -0.00223789594272 , -0.00406992469161 , 0.0021065438055 , 0.00440626297346 , -0.00157035951618 , -0.00428706318313 , 0.00144481208958 , -0.00436435062357 , -0.00536263224127 , -6.84544387508e-05 , -0.00255899754649 , -0.000311516681765 , 0.00172583390156 , -0.0050611792055 , 0.000107941045465 , 0.00312640534621 , 0.00261183185275 , 0.00100822877365 , 0.00186047388057 , 0.0015651834649 , -0.0049696892776 , 0.00607420076952 , 0.00463569186773 , 0.00126970008112 , -0.000273224881801 , -0.000405921789566 , 0.00669264934098 , ])
Y_3_m3_imag = flex.double( [ -0.0 , -0.0 , 0.00306003673231 , -0.00637389984302 , -0.000464508781289 , -0.00155292952897 , -0.000396582067748 , 0.00171475886855 , 0.00336712065074 , 0.00539594187971 , 0.00153185602184 , -0.000230849055419 , 8.41685431034e-05 , 0.000654159168787 , 0.00045262973711 , 0.0030364953198 , -0.00498489690835 , -0.000635446084279 , 0.00438315273825 , 7.43896264339e-05 , -0.00205100063013 , -0.00393738147517 , -0.00147958132572 , -0.000998674572932 , -0.00702484972049 , 0.00153931688157 , 0.000261039868838 , -0.00382278903577 , -0.00244573891143 , -5.57698889934e-05 , 4.87124998244e-05 , 0.0045067930863 , 0.00693822004873 , 0.00411457970165 , 0.00214073093544 , -0.00259362401907 , -0.0017451492202 , -1.39596500702e-05 , 0.00214704766583 , 0.00326393240099 , -0.00512748899897 , -0.00305170990293 , 0.00202391571567 , 0.000927603734303 , 0.000520013549069 , -0.00457934002732 , -0.0010590653652 , -0.00228112532299 , 0.00480613240805 , -0.00133669820835 , -0.00379939421454 , 0.000460726732184 , -0.00140734062414 , 0.0067098077612 , -0.00184874945977 , 0.000522622378399 , 0.000258966264315 , -0.00489565793081 , 0.000852458523459 , 0.00084585107229 , -0.00247108259629 , -0.00614469248001 , 0.000254306365663 , -4.56092628781e-05 , 0.000901494772339 , 0.0033795815373 , 0.00395041621399 , 0.00602417792367 , 0.000459104671754 , 0.00301725009351 , 0.00219220058001 , -0.00356760947559 , -0.00283125686693 , -0.000416513329798 , 4.94902193741e-05 , -0.00254646999938 , 0.00148168347343 , 0.00578074374989 , -2.97514723283e-07 , 0.000614943086827 , -0.000674590334152 , 0.00373394769282 , 0.00247188049044 , -0.00217416952014 , -0.00626832392026 , -0.00489705332514 , 0.000114149522728 , 0.00149548953276 , -8.80024537703e-05 , -0.00254816251108 , -0.00257824670683 , 6.54575469869e-05 , -0.00120154647038 , 0.0011665812107 , -0.000417706881295 , 0.00185563480832 , 0.000169421790028 , 0.00019601919857 , 0.00119170925976 , 0.00163674013621 , 0.000853201595508 , -0.00211434152629 , -0.00141912958133 , -0.000937446629697 , 0.00533199944401 , -0.00439507693446 , -0.00333670564524 , 0.00477911478167 , 0.00120692847152 , -2.70271329143e-05 , -0.00032941418746 , 0.000584892151703 , -0.00190349916411 , -0.000152808532014 , -0.000195424876606 , -0.000778144682712 , -0.00140940154762 , 0.00253626754173 , 0.000488349050814 , -0.00119152868978 , -0.000232638735096 , 0.0045833137561 , 0.000992033475791 , 0.000449629427102 , 0.00272915044214 , 0.00555286058924 , 0.00572003547505 , 7.06964024203e-05 , 0.00111984299922 , -0.000242228012277 , -0.00425182666588 , 0.00230329906965 , -0.00422062330811 , 0.000107709405255 , -0.000304114472845 , -0.00303649592855 , -0.00126390824616 , 0.00479086722381 , 0.00190444623603 , 0.00144359065826 , -0.000543825858549 , -0.00436046772355 , 0.00288769494843 , -0.000821882107172 , -0.00478987391635 , -0.00038420105205 , -0.00396755081302 , -0.00502133472458 , -7.56280796555e-05 , 0.00146671658977 , 0.00064163928628 , -0.00228832637765 , 0.00175991500221 , -0.00385737334912 , -0.00463713690077 , -0.000120096555252 , 0.00215853311338 , -0.00107132753897 , -0.00270248215694 , 0.00321662563993 , 0.00247628395656 , 3.01275307848e-05 , 4.18401045239e-05 , 0.00228182421624 , 0.00280793267584 , -0.00160307262677 , -0.000165453689948 , 0.00386913427606 , 4.00108700683e-05 , -0.000394206800568 , -0.00175040832931 , 3.69326713533e-06 , -0.000183491986723 , 0.00217082156784 , 0.0001688532891 , 0.000297449073297 , 0.0054787967893 , 0.0014829476669 , 0.00249166909661 , 0.000363127794081 , -0.0032904328028 , 0.00285076999103 , -0.00159568591922 , -0.000417205739928 , 0.00139130610685 , 0.000277243888359 , 0.000772433351159 , -0.00119117127999 , 0.00217985279671 , 5.04401291002e-05 , -0.00134102836419 , 0.00185048299139 , 1.55749949216e-05 , 0.00130836105049 , -0.00290596304158 , -0.000460489550809 , 5.3261799016e-05 , -0.000308463255251 , 0.00114779333757 , -0.00288795522814 , 0.00527132136118 , -0.00134659702083 , 0.00321897818417 , 0.00401501578824 , -0.000351381586738 , -1.53741310952e-05 , -0.00298188948754 , 0.00186629026916 , -0.00549799294315 , 0.00118879199269 , 0.0018525066209 , -0.000587047375503 , -0.000105550067488 , 0.0030274133362 , -0.00379176140361 , 0.00065680255082 , 0.00363837428653 , 0.00221513683365 , 0.00195181286689 , 0.000323660100323 , -0.00486622568355 , -0.00169222218671 , 0.00300747828414 , 0.00569462040279 , -0.00104057360411 , -0.00356276482769 , 0.00179801016132 , -0.00126575952279 , -0.00734899283262 , 0.00100232541226 , -0.00148429925954 , 0.00474515963233 , 0.00506106449356 , -0.00427458734656 , 0.000440160621582 , 0.00592578981044 , 0.000853554487805 , -0.000382507990866 , -2.50169955122e-05 , 0.0028802489974 , -0.00104503176173 , 0.00358796912451 , 0.00259531737646 , 0.00112757730141 , 0.00206751047874 , 0.000884324562833 , 0.0048572930126 , 0.00223787905434 , 0.00634196702851 , -0.00213343005394 , 8.09308055144e-06 , 0.00240830772659 , -0.00052125367809 , -0.00510998066273 , -0.000506552230354 , 0.00102388989918 , -0.000667232617451 , -0.0038061326441 , 0.00246341803761 , -0.00134739647548 , -0.000407122251023 , -0.000616688161511 , -0.00276775016353 , -0.00141689284697 , -0.00210723186586 , -0.00498048942633 , -0.00310895770915 , 0.00037192283877 , 0.000358351408018 , -0.0048812061311 , 0.00379695489076 , -0.00312448391207 , -0.00217523192266 , 0.000495520229819 , 0.00107755932363 , 0.0033091107608 , 0.0032259792112 , 0.00605946193478 , -0.00289879406271 , 3.71834183161e-05 , 0.00168489133546 , -0.000318591448022 , 0.00277101593625 , -0.00021245358141 , 0.00435130494584 , -0.000813459856426 , -0.0026365806758 , 1.91709416959e-05 , 0.00395246340352 , 0.0033670314693 , 0.00446158863136 , 0.000968209868319 , -0.00552896545878 , 0.00383302972781 , -0.0065590491844 , 0.00376424249554 , 0.000630925239229 , -0.00139157795644 , 0.00279480550455 , -0.000409754803047 , 0.000132854558259 , 0.00342851149533 , -0.00153259690474 , -0.00444403750919 , -0.000907211908357 , 0.00253888895719 , 0.00170347148039 , -0.00101382735963 , -0.00387592534717 , 0.00586555061011 , -0.00574056904968 , -0.00107501180185 , -0.00418760260055 , 0.00287103454179 , 0.00606536883449 , 0.00354223351359 , 0.0024653211466 , -0.00196202352841 , 0.000460434338033 , -0.00452847995883 , 0.00503148577549 , -0.000130989492536 , 0.000380559801522 , -0.00384988283083 , 0.000594470495998 , 0.00375564810551 , -0.00529069628647 , 0.00234591808447 , -0.00154116741797 , 0.0032638690941 , 1.89567823822e-06 , 0.00042446315955 , -0.000980398705503 , 0.000354783644925 , -0.000173856306971 , -0.00831965244751 , 0.000858239049649 , -0.00106460568585 , 0.00664967183623 , -0.00131911033763 , -0.00526689200223 , -2.1609938444e-06 , -0.000306855911826 , 0.00517012672582 , 0.000893417091185 , -8.05695164018e-06 , -0.00206006911925 , -0.000772687458183 , -0.00219579685321 , -0.0016604886985 , -0.00140435510099 , 0.00288877946847 , -0.00065116799971 , -0.00288604449551 , -0.00204955101637 , -0.00496546047893 , -0.000312123918083 , 0.00390922254299 , -0.00227593787878 , 0.00264226748058 , 0.00148457796551 , 0.00012285478725 , 4.1509687187e-06 , -0.00309142085762 , -0.00478148465136 , 0.0031840832977 , 0.000715605875165 , -6.35429365467e-06 , 0.000497603004545 , -0.00343102870612 , 0.000732744945462 , 0.000873029817419 , -0.00194845574193 , 0.000432503367036 , -0.00390443974948 , 0.00165070994086 , -0.00231206619527 , -0.00051481802384 , 0.00150568354484 , -0.0017146359098 , -0.00248161758069 , 0.00523251685761 , -0.00351274692672 , 0.00470704404558 , -0.00304173287085 , -1.51163836411e-05 , -0.00160242788752 , -0.00225714031127 , 0.00202833951285 , 0.00286330957451 , 0.00483548987215 , -0.00366923503897 , -0.00244601187835 , 0.00409338235675 , 0.000283985103697 , 0.00610529110994 , -0.00166090343654 , 0.000149793935259 , 0.000422619123909 , -0.00109619698912 , 0.000278155510988 , 0.00682092897071 , 2.32486495684e-06 , -0.00307221123717 , -0.00325535431514 , -0.00142006197225 , -5.6470808605e-05 , -0.000450870643568 , 0.00196922064578 , 0.00239043727331 , -0.003664510239 , -0.00301330449609 , 0.00339858851265 , 0.00733116125828 , 0.000273978403137 , 3.02265598639e-05 , -0.00270084120019 , 0.00490025199203 , 0.00403416160519 , 0.0016542678631 , -0.00364583948078 , 0.00446010131365 , 0.00443451217593 , 0.00216783137824 , 0.00623126046859 , 0.000308817244598 , 0.0018193039472 , -0.00334166387942 , -0.00044357057174 , -0.00102771353923 , -0.0024806814311 , 0.00382989178534 , 0.00423319360647 , -0.00294532452442 , 0.00239179496374 , -0.000673392061475 , 0.0045596428974 , 2.68153305436e-05 , 0.00651111484039 , 0.000211853699243 , 0.00269710816504 , 0.00110134420253 , 0.000872575621166 , -0.00418911053516 , 0.00114090683719 , 0.00021088279395 , 0.00126606897617 , -0.000420107780321 , -0.00346867514939 , -9.25824061837e-05 , -0.00094839345139 , 0.00432826962171 , -0.00262704287013 , -0.000148223249898 , 0.00129737823533 , -0.00100202789107 , 0.00330444648469 , 0.000769262536663 , 0.00207776545948 , -0.00220749624743 , -0.00367773723743 , 0.00115182708781 , 0.00158355005652 , -0.00120909916514 , -0.00469705796719 , -0.00440168731362 , 0.00016881577811 , -0.00347777373696 , -0.000452975769923 , -0.00599780577439 , 0.000510955741709 , 0.00275397129897 , 0.000559687509444 , -0.00179794081224 , -0.000893519044455 , -0.00184869055755 , 0.00149475620533 , 0.00455687475916 , 0.00466295404242 , -0.000670848532423 , -0.00275547550264 , -0.000997750304218 , -0.000668651861382 , 0.00328203165304 , -1.27567439723e-05 , 0.00135180120543 , 0.00185097831041 , 0.00524578981631 , -0.00156312322416 , 0.00598713439135 , 0.00514165164106 , -0.00518692510159 , 0.00139088598598 , 0.00439036362362 , -9.408571274e-05 , 0.00182917823693 , -0.000814966086802 , 0.000565708161975 , 0.0026743868107 , -0.00277456266262 , 0.00108088348507 , 9.58785769063e-05 , -0.00104693774619 , -0.00450121780772 , -0.00325523627473 , 0.000377183569736 , -0.00274308521718 , -0.00268431005792 , -0.00179786450241 , -0.00159854561412 , -0.00228587083405 , -0.00707084687053 , -0.000398212794361 , -0.00190528478988 , -0.00120941977799 , -0.00124141156438 , 0.00020782900473 , 0.000573990746706 , 0.00178320781249 , -0.00163819640388 , 0.0015501261924 , -0.00574496065826 , -0.00178203641554 , -0.0029431848286 , 0.000123497324255 , -0.000589304618791 , 0.00228339837348 , -0.0031268026713 , 0.00713315650082 , -1.01491925312e-05 , 0.00126078977168 , -0.000558809096308 , -0.00439519620997 , 0.00190502330477 , -0.00127363580802 , 0.00128897304936 , 0.00251602899867 , -0.000262525085262 , -0.000384989887892 , 0.00316916756722 , 0.000397939748546 , -0.000125919059262 , 0.000269003751198 , -0.00371716611428 , -0.00105976676961 , 0.00530252535828 , 0.000106586207341 , -1.4709683556e-07 , -0.0017217141439 , 0.00467141111841 , -0.00268349747615 , -0.00171480980213 , -0.000153870258408 , -7.83817600731e-06 , -0.000989173588869 , -0.00275640401323 , 0.000172177227044 , -0.00144239228972 , -0.000791038017965 , -0.00188051708253 , 0.000341517638036 , 0.00224084527609 , 0.00114244798698 , -8.59120184272e-05 , 0.000908459736185 , 0.00232539413678 , 0.00226737579867 , 0.000600919169271 , -0.00337782788836 , 0.0045538909375 , 0.00210697803017 , -0.00210283301264 , -0.00184145301979 , -0.00495327024683 , -0.00349927846727 , -0.00291185255424 , 0.00193391735696 , 0.000342323328029 , 0.00326846183487 , -0.000247660459691 , -0.00306093249783 , -0.000373672154173 , -0.00501823236659 , -0.00498390832982 , -0.00346753756096 , 0.000925938502112 , -0.000909513224007 , 0.00244802234521 , 0.00023635393929 , -0.00271772783024 , -0.00181135189587 , -0.00048602742442 , 0.000130651514242 , 0.00348625866024 , 0.00599314514735 , 0.000112078432624 , 0.00288901042046 , -0.00333789180002 , 0.000253979186001 , 0.000189567174841 , -0.00319151847045 , -0.00783812567517 , -0.00204027298788 , -0.00275245365314 , 0.000880738976453 , 0.00508009840765 , 0.00387172504419 , 0.000523543648397 , -0.00259550521105 , -0.000157228706272 , 0.00555998269479 , -0.00030633023471 , -7.40801693181e-05 , -0.00480395148902 , -0.00111569732808 , 0.00145841859376 , -9.96881674975e-05 , 0.000157207344894 , 0.00403577749482 , 0.00669253964255 , -0.00104365048155 , 0.00329103804766 , -0.000499353900888 , 0.00382764412428 , -8.74634780518e-05 , -0.00305578283204 , -0.00217920551591 , -0.00108794542139 , 0.00505830730781 , 1.42519088511e-05 , -0.00179378620287 , -0.00551843903521 , 0.00250836139355 , 0.000273882153153 , -0.000869660471303 , 0.00262968653906 , -0.00489282061236 , -0.000850593834292 , 0.0058749902218 , 0.00413803679196 , 0.00522972990265 , -0.00419182856077 , -0.000625034651554 , -5.4825160624e-05 , -0.00217581584466 , 0.000627143417636 , 0.00393306194192 , 0.00221595565214 , -0.00437391210684 , -0.000269937889991 , 0.00189861832766 , -0.00295517807931 , 0.00178768951725 , -0.00484086265554 , 0.0030179384389 , -0.000217787151224 , -0.0041034718555 , 0.000374728570762 , 0.000414028778861 , -0.00199009588793 , 1.24797572896e-05 , 0.000610400027617 , 0.00114951166427 , -0.0030202053045 , 4.31702373468e-05 , -0.00027333992804 , 0.00636927062091 , 3.83525109956e-05 , 0.000170244329169 , -0.000866760854976 , 0.00111853464866 , 0.00114731439167 , -0.00171429095989 , -0.00151270107102 , -0.0032077876212 , 0.00338301479257 , -0.00182066829405 , -0.00603794257869 , -0.00440604844712 , -0.000821435197778 , -0.00547511473759 , -0.00200886477705 , -0.00194430795978 , 0.00349751299882 , -0.00591189105546 , 0.000858157814188 , 0.0027304522855 , -0.00353428492638 , 0.00104692862259 , -0.000455701256024 , -0.00151053154861 , 0.00360300829655 , 0.000915605100602 , 0.00461417462321 , 0.00160295289688 , -0.00420974459085 , 0.00381922390985 , -0.00744729298412 , -0.000309974686794 , 0.00409281992129 , 0.00316559025767 , 0.00244090918891 , -0.00398239572683 , -0.0037996400507 , 0.000653068084046 , 0.00241728886217 , 0.000589199328213 , -0.000164056988347 , 0.00173763577754 , 0.000721799513284 , 0.00123169144569 , -0.00449024524177 , 0.00562608497297 , -0.00368384095265 , -0.00418135367114 , 0.00526997890862 , -0.00671792836064 , 0.00116547687381 , -0.00392054635596 , 0.00263571524259 , 0.00089709213257 , -0.00259842890464 , -0.00430253565375 , 0.000527858644603 , -0.00124137564816 , 0.00255863662935 , -0.00568831028064 , -0.00226877223485 , 3.38936571246e-06 , 0.00299709800779 , 0.000157749640548 , 0.00209225413979 , 0.00146574898289 , 0.00148488339807 , -0.000649501110805 , 0.000812835974796 , 0.000870763999997 , -0.00418984328904 , -1.08741917257e-05 , 0.00208122599288 , -0.000910658008176 , -0.00198733570607 , 0.000397056618811 , 0.0035997870881 , 0.000653215401458 , -0.000300265194372 , -0.000143326497411 , 0.000952523737351 , 6.2157636541e-05 , -0.000234470561884 , -0.00110285109374 , -0.00108459352725 , 0.00339248444663 , -2.24532221382e-05 , 0.00237094618191 , -9.18446403046e-05 , -0.00022259734537 , 2.09556123318e-05 , 0.00117344037258 , 0.00204135476167 , -1.22834892056e-06 , 0.000396814031473 , -0.00218897724884 , 0.000913271913038 , -0.00189340079442 , -0.00459650782559 , 1.48705188304e-05 , 0.00351027561874 , -0.00573299748093 , 0.00163564789193 , 0.00115684350952 , 0.000923364846616 , -0.00236427475583 , -0.00769013630637 , -0.000373533507342 , -0.00127519166168 , -0.00188136157782 , -0.00108861710469 , 4.83543805385e-05 , -0.000181281929413 , -0.00312382386654 , 4.09795474387e-05 , 0.000413786828824 , 2.06456025883e-05 , 0.00101117183769 , -0.00192473487792 , -0.00265224746023 , 0.00209325117708 , -0.0005227962671 , 3.11272953136e-05 , 6.1716590658e-05 , 0.00417952639787 , -0.000824034246849 , 0.000521241611944 , 0.000442899078971 , 0.00162569982282 , -0.00206959316728 , -0.00401359322383 , 0.000586933840516 , -0.000290165182887 , -0.000823605413276 , -0.000115573776935 , -0.00731375791928 , 0.00275514399849 , 0.0017301704273 , -0.000199571288328 , -0.00214984026311 , 4.25861315184e-05 , 4.98359170279e-05 , 0.00358219773047 , -0.00389616310845 , 0.00111745298916 , 0.00881520109545 , 0.000442542883127 , -0.000197864694413 , -0.00221233085865 , 0.00501081745998 , -0.00499257829018 , 0.000167405864206 , -0.00611423780835 , 0.00390684948415 , -0.00221170718488 , 0.00108858753997 , 0.000468634364761 , -0.000492428799787 , -0.00071913676645 , 0.00591757696478 , 0.000317854745298 , 0.000495711941882 , 0.000831425787921 , 0.00818018639307 , -0.00125191312634 , 0.00415568904144 , -0.00366095319634 , -0.00238395082425 , -0.0059508692608 , 0.0004893098084 , -0.00100109375156 , -0.00625949750472 , -8.21086429109e-05 , 0.00389080577514 , -0.00513881768476 , -0.00047465625557 , 0.00157389352642 , -0.00382434401494 , -0.000160674298005 , -3.32730390317e-05 , -0.00471833250921 , 0.00538820294166 , -0.001878647191 , -0.000615562343545 , 3.93351760848e-05 , 0.00165049654152 , 9.3619161657e-05 , -0.00485943895735 , 0.00241137055495 , -0.000218532816747 , -0.000327341988585 , 0.00315189744586 , -0.00176427267305 , -0.00431420391861 , 7.95442543312e-05 , -2.48498806585e-06 , -0.00200634777819 , 0.00394958026897 , -0.00527314548602 , 0.00159617950311 , 0.00166836632246 , -0.00135426642404 , 0.00694777436017 , -0.00133776266954 , -0.000157148614905 , -6.2589075357e-06 , 0.00533368461559 , -0.00339403060612 , 0.00663706867761 , -0.00187225759489 , -1.04158473723e-05 , -0.00276374209816 , -0.000374034123332 , 0.00151407119909 , 0.000262415896638 , 3.88174572338e-05 , -0.0044788341582 , 0.00197011547399 , -0.00182026091853 , -0.00281077282235 , 0.00272472918531 , 0.00152924892455 , 0.00408311241897 , -0.00325948479691 , -0.00173196836895 , -0.00219158975802 , -0.00407953267478 , 0.00168703972166 , -0.00350424009277 , 0.00389190919299 , -0.000524196960761 , 0.000277868861922 , 0.00173173489312 , ])
Y_3_m2_real = flex.double( [ 0.0 , -0.00141007860924 , 0.000721323699436 , -2.27694005899e-06 , -0.00209729898958 , -0.004673830013 , -2.24511481904e-05 , 0.00328897390974 , -0.0034058935803 , 0.00160262245904 , -0.00489911696358 , 0.00170675341305 , 0.00101853712904 , -0.00277883755825 , 0.00159038974972 , -0.000419472793406 , -0.00645644829985 , 0.00336622166134 , 0.00254320769051 , -0.00125720890465 , -0.00232614662337 , 0.000393395146878 , 0.000380067042206 , 0.00573254737659 , 0.00234468007698 , 0.00508379899712 , -0.00464984928013 , 0.00272892347823 , -0.0055724860768 , 0.000182655509642 , -0.00111708279196 , -0.00532159855495 , -8.24110512954e-06 , -0.0017265921293 , -0.000967603983797 , -0.00428357793809 , -0.00237631808582 , -0.000169339254381 , -0.00668081270277 , 0.00149834915499 , -5.50017296071e-05 , 0.00423278353801 , 0.00279757274495 , -0.0047152239292 , -0.00386330839067 , -0.00320376807821 , -0.00474461201138 , -0.00338677451005 , 0.00260544351313 , 0.000843495587064 , -0.00151719196886 , -0.00494600205295 , 0.00228219324909 , -1.53846911718e-05 , -0.00162490236875 , -0.00207384561757 , -0.00110256715108 , 7.511268738e-05 , -0.0043304998258 , -0.000173036422613 , 0.00141214520945 , -7.2090455733e-05 , 0.000283317022484 , -0.00176572116298 , -0.000937542866357 , 2.98264731456e-05 , -0.00226208891726 , 0.000351933541073 , -0.00138146774506 , -0.00257216943842 , -0.00479382749571 , -0.000218034920439 , 0.000758541475159 , 0.00113618552938 , -0.000575796692204 , 0.0024872504932 , -0.000322427896164 , 0.00427000381018 , -1.73009983021e-05 , 0.000139914070638 , -0.000319560983251 , 0.00600142060181 , 0.00108021570545 , -0.00370957919428 , 0.000432077613098 , 0.00286268080652 , 0.00111969925757 , 0.000545510464794 , 0.00229827245178 , -0.00220638647298 , -0.00359631848058 , 0.00179762424968 , -0.00486669252441 , 0.00347447851096 , -0.00140999644892 , -0.00342403075484 , -0.00178035003489 , 0.000572319595479 , 0.00237489351783 , -0.00302015603505 , 0.00412824481256 , 0.000258745219049 , -0.00339542808666 , -0.000327239414648 , -0.00020902321944 , -0.000662374469619 , 0.00242015222578 , 0.00136897266171 , -0.00449773063222 , 0.000114671635595 , -0.000344118785225 , 0.00164573737402 , 0.000268610480891 , -0.00157411197468 , 0.000821834188911 , -0.000938779359444 , 0.00507994642095 , -0.00370890117863 , 0.00228564697561 , -0.00417382757359 , 0.00379374414882 , 0.00123736539966 , -0.00479751332928 , -0.00273811859752 , -0.00131602037683 , 0.00113856701506 , -0.00244649398413 , 0.000279813417739 , -0.000926178895691 , 0.00128869226626 , 0.00230779334296 , 0.00549630941387 , 0.000599646094903 , 0.00129182468491 , 0.00180667702075 , 0.00498161297429 , 0.000860092140533 , -0.000826889151033 , 0.00570757361539 , -0.0033353909797 , -0.00334407105703 , -0.00143594270267 , -0.00209099633053 , -0.00105216826112 , 4.71278097999e-05 , -0.00546913718599 , -0.00237383677751 , -0.00158598214937 , -0.00116776803944 , 0.0040669891728 , -0.00339026004622 , -0.000893122641288 , 0.00554616818767 , -0.00185316552731 , 0.000918766346673 , 0.00173479398512 , 0.00218083054814 , 0.00113902074544 , -0.00053706594035 , 0.0028942959481 , 0.00435470543124 , 0.000545306512303 , -0.00143814042232 , -8.00831619304e-05 , -8.78650443055e-05 , -0.00414657412466 , -0.000307424784197 , 5.82804250191e-05 , 0.00305757151424 , -0.00251608199013 , 0.00488876880185 , -3.26683411637e-05 , 0.00239899625553 , -0.000198133015588 , -0.00157880167264 , 0.00307652558786 , -0.00571144036691 , -0.00549777108925 , 0.000903551866713 , -0.00199532751546 , 3.14443017305e-05 , 7.89084617959e-05 , -0.00372079250517 , -0.00462821277459 , 8.81363590103e-05 , -0.00154556851403 , 0.00391362023831 , 0.00205759126178 , -0.00281350688054 , -0.000865454711164 , 0.00338791566113 , -0.000236571480404 , -0.000324918070567 , -0.00407280822207 , -0.00102039455669 , 0.00290152035903 , 0.000131816004723 , -0.00129387497425 , 0.00359949214555 , 0.00339380494605 , -0.00473880349202 , -0.000342817682116 , -0.00399239841425 , 0.00386719941775 , -0.00285367666151 , -0.000606268985438 , -0.0031893893036 , 0.000103891866909 , -0.000140707410838 , 0.00656696907412 , -0.00259189767074 , -0.00264159956086 , 0.000171840795697 , 0.00402386951727 , 0.00235331073438 , 0.00230455624802 , -0.00350989391452 , -0.00447230259546 , 0.00324748042848 , 0.00599472883537 , -0.00234532425606 , -0.00130124812864 , 0.00151978201077 , -0.000773596286974 , 0.00320280922757 , -0.00341588162949 , -0.00356367140383 , 0.000144705649075 , 0.00146457415444 , -0.000926124162249 , 0.00568760124131 , -0.00765489888269 , 8.11356398357e-05 , 0.0018831597529 , -0.00166435109582 , -0.0017120272516 , -0.0028448231128 , -0.00233166195616 , -0.000752320191197 , 0.000410822938002 , 0.00194494691349 , 2.98302290648e-05 , 0.0056832882866 , 0.00312581594157 , -0.00259838377248 , 0.00333930459434 , -5.74656749743e-05 , 0.00021610058184 , 0.00356187544647 , -0.000696430559848 , 0.00257581663557 , -0.00204479138991 , 0.000894199493793 , -0.0023409092647 , 0.000349592758282 , 0.00382691986796 , 0.00143545709286 , 0.000354681986664 , 0.00256058766687 , 0.0038377193268 , 0.00244311023949 , -0.0018352568947 , -0.00351628809191 , -0.0033086184635 , 0.00412605878615 , 0.00159671610953 , 0.00122119614542 , -0.00175482469292 , 0.00214160403486 , 0.000554805393033 , -0.000978807909154 , 0.00104329825517 , 0.00400359413579 , -0.00409664066867 , -0.00267851055984 , 0.00041014571456 , -0.000154494908747 , 0.0024449339803 , -0.00374507236516 , 0.0013686958068 , 0.00477941149549 , 0.00324448408748 , -0.00400977638678 , 0.00235322982954 , -0.00148468299359 , 0.00272186753562 , 0.00418347938581 , -0.000195460479347 , -0.00750240382513 , 0.00138434936219 , -0.000691034585785 , -0.000540796931722 , -0.000153679258113 , -0.00437935842822 , 0.00495810317822 , -0.00200122095612 , -0.00259230022931 , -0.000571824016443 , 0.00531225641655 , 0.00182049168456 , -0.000941327493816 , -0.000924664848158 , 0.00279675063286 , 0.00368323198806 , -0.000288447496182 , 0.00453126097483 , -0.000145817888024 , 0.00237486751607 , -0.00414586973196 , 0.00160544116569 , 0.00606816381643 , 0.00148208785279 , -0.00354390269469 , 0.00198110434582 , -0.00204048392569 , 0.00411624230869 , 0.0058712934848 , -0.00279612094501 , -0.00282220303296 , -0.00119998618182 , 0.00597115133817 , 0.00118179537859 , -0.00468263458792 , -0.000928873602024 , -0.0027560538131 , 0.000157574205509 , -0.00122825672684 , -0.00145427264294 , 0.00559453662904 , 0.00445958410297 , 2.92901525203e-05 , 0.00144389863009 , -0.00373296865992 , -0.00037652537836 , 0.00156240287703 , -0.0013374003325 , 0.00282107218371 , 0.00371830481063 , -0.000327587472204 , -0.00361879601997 , -0.00053779524134 , 0.00096130012219 , 0.00284734551309 , -9.77490946825e-05 , -0.000203496935934 , -0.000179273834332 , -0.00403397296704 , -0.00399539803898 , 0.0048353025854 , 0.00157835905078 , -0.00394089866172 , -0.00486628626928 , -0.00121416135844 , -0.0013467683936 , -0.0013538485361 , -0.00110792588042 , -0.002554768396 , 0.00426644101202 , 0.000530372246103 , -0.00790133208725 , -0.00169595100682 , 0.00170580968232 , -0.000112547845412 , -0.00186891536196 , 0.000992540951983 , -0.00359738881223 , -0.000820633238904 , -8.07369862182e-05 , 0.00144936682337 , 0.00653341043791 , -0.00164912094773 , -0.00277342580664 , 0.00292848559376 , -0.00179926197372 , 0.00288431533145 , -0.0041236179024 , 0.00277325756717 , 0.00407519624567 , -0.00381773525338 , 0.005527202484 , 0.00103966588591 , 0.00286730607092 , -0.000734513650258 , -0.00403354524738 , 0.00382589926917 , 0.000532469511701 , 0.00518067517283 , -0.00554528158292 , 0.00488799289606 , 0.000676989574915 , 0.0040898287648 , 0.00577703736636 , -0.000692069344447 , 0.00281126520042 , -0.00215710799911 , -0.0020365784613 , -0.00564630454134 , 0.00165396786512 , 0.000578872930218 , -0.00230426331044 , -0.00154776951765 , -0.00202412668698 , -0.00189376794828 , 0.00313355602398 , -0.00667416273583 , -0.00216716140756 , -0.000591153348427 , -0.0011775554931 , 0.000935187995105 , -0.00262088462318 , -5.19637546588e-05 , -0.00329657278819 , 0.00466037599885 , -0.00411789058107 , -0.000747835634462 , -0.00608266787598 , 0.00030329333285 , 0.00223991306044 , 4.12238613451e-06 , -0.00138485017741 , -0.00263704258071 , 0.000236989239995 , -5.38599177857e-05 , 0.00334612616161 , -0.00747522653193 , 0.00481402711918 , 0.000110257654549 , -0.00155578733148 , 0.00178544123225 , 0.00418277396115 , -9.28299485638e-05 , 0.000363778989887 , -0.00214977556788 , -0.00218805666936 , -0.00129533548584 , 0.00305941569264 , 0.00235169259165 , -0.000354393866329 , 0.00137722699841 , 0.00146717265284 , -0.00588595975209 , -0.00478934987352 , 0.00316738657123 , -7.43731639097e-05 , 0.00459629359128 , 0.00145222881951 , -0.00316901818176 , 0.00128274084921 , -0.00431290116017 , -0.00296198133105 , 0.000537969103896 , 0.00371250382281 , -0.00527297401763 , 0.00228035715192 , 0.00152880179432 , 0.00376806695686 , 0.000812291403553 , 0.00192959768021 , 0.00167249714721 , -0.00371391155831 , -1.79032195319e-05 , 0.000225122371532 , -0.00242728592422 , -0.00205228720028 , 0.00208975075772 , -0.00245760757136 , -0.0061478213833 , -0.000918739665633 , -0.00142284862411 , -0.00573706192104 , 0.00376266808483 , 0.00271090475735 , 0.00635031706802 , 0.00189459703288 , -0.0051371405282 , -0.000645511870008 , -0.000917809916868 , 0.00356344427131 , -0.000571382980059 , -0.000558137195422 , 0.000378872768157 , -0.00499845383559 , 0.00173162881501 , 0.00116358157322 , -3.92014372808e-05 , 0.00440278327727 , -0.00477652856133 , -0.00269237785227 , -0.000917569104653 , -0.00037086622174 , 0.00374608723291 , 0.00152425142128 , -0.00510232172092 , -0.00152839270251 , -0.00148753258214 , -0.00188903133033 , 0.00112824864744 , -0.000122613983354 , -0.00170733402574 , 0.00122614241761 , -0.000284217071738 , -0.0018674442897 , 0.000418610394835 , 0.00385796818888 , 0.00359292853615 , 0.00378916219267 , -0.00466659704499 , -0.00173692294134 , 0.00413990127978 , 0.00456707942729 , -0.0011247569089 , -0.000172401506868 , 0.00665939940776 , -0.00492080519896 , -0.00402879547512 , 0.00130153494353 , 0.00295993870274 , 0.000885985728671 , 0.00483386844962 , -0.00150983162002 , -0.00444368110534 , 0.000217617738368 , 0.000905407489371 , -4.17341977852e-05 , -0.000545601608574 , -0.00169126806209 , 0.00181761718941 , 0.00249250836949 , -0.000857350953357 , 0.00053194917499 , -0.00195296576078 , 0.00150150274334 , -0.00285273256963 , -0.00074184928555 , 0.00232901054968 , 0.000175187930441 , 0.000464090724878 , -6.85397306957e-06 , -0.00105762495586 , 0.00112961792742 , 0.00260277990469 , -0.0010179235209 , -0.00230138061268 , 0.00286328673426 , -0.00278797575547 , 6.29821632373e-05 , -0.00122430770216 , 5.82310906728e-06 , 0.00392118532232 , 0.00152174588654 , -0.00473336062011 , 0.00398514904579 , -0.000973105258554 , -0.000110724040505 , -0.00523934854354 , 0.00613404321199 , 0.000738975924227 , 0.00458348711099 , -0.000323323473313 , -0.00467954231963 , -2.27425372933e-05 , -0.00304492638211 , 0.00147597242289 , 0.000827098746857 , 0.00186948928998 , -0.00529261496878 , 0.000854020983274 , -0.00289436171492 , -0.00500300601441 , 0.000285861097387 , -0.00115121133353 , -0.00466815292287 , -0.000109524622897 , -0.000877959039348 , 0.00491024526285 , -0.00285664007222 , -0.00157745132512 , -0.00107720107466 , -0.00154111507064 , -0.000723398129202 , 0.00542254569158 , -0.00295614655523 , 4.5996242694e-05 , 0.00439993697584 , 0.00136922656157 , -0.00220111810085 , -0.00501528410233 , 0.00226579678907 , -0.000262782074259 , 0.00380008974053 , 0.00203181030559 , -0.00358200102993 , 0.00372912699184 , -7.74938334946e-05 , -0.00175493855895 , -0.00247693865662 , -0.0054738935574 , -0.000145575682399 , -0.00232295124352 , 0.000676291901681 , 0.000194657642798 , 0.00318044627765 , 0.00125523301389 , -0.000103648496907 , -0.00557342737517 , -0.00389860498128 , 0.000195014251717 , -0.000400965107518 , -0.000833758739957 , -0.000361640622669 , 0.00157754406886 , 0.000452607942785 , 0.00575115313545 , 0.000627346641188 , -0.000556878619212 , 0.00272448629906 , 0.000718751523881 , 0.00114573544288 , 0.00417333993445 , 0.00196575824014 , 0.00122755178667 , 0.000794440735263 , -0.000792254291221 , -0.000935497331613 , -0.000141611240261 , -0.000542714997661 , 0.000252282492236 , -0.00210810582934 , 0.00432690482594 , 0.000240633910659 , -0.00204307680648 , 0.00063514284448 , -0.000734725466822 , 0.00185904633223 , -0.00433542124572 , 0.00103660074197 , -0.000879787354065 , 0.00458437629504 , -0.00323737055546 , 3.39132845897e-05 , -0.000143077822098 , -5.62388380065e-05 , -0.00352047718087 , -0.000664230777734 , 0.00484624639814 , 0.000824833548291 , -0.00301460085342 , -0.00631184885865 , -0.00172454676674 , -0.0015003736744 , 0.0046362651397 , -0.00368424075023 , 0.0018892291905 , 0.000860012387373 , 0.00344504331668 , 0.00200452575133 , 0.000606968366772 , 0.000965308299004 , 0.00214779829813 , -0.00589324883797 , 0.000210578511993 , -0.00132143130643 , -0.00102396666468 , 0.000291106600772 , -0.00129848553894 , -0.00105729883594 , 0.00151654302819 , 0.000522362469809 , 0.000989605674166 , -0.000350975177394 , 0.000427725437381 , 0.000192644510877 , -0.00294049253016 , 0.00423174819025 , 0.00547418187177 , -0.00258335142465 , 0.00135725215789 , -0.00802978265695 , -0.000866424696131 , -0.00457807154622 , -0.00233176743132 , -0.00148407855001 , -8.60631444354e-05 , -0.000830379017437 , -0.00241676852665 , 0.00357703230918 , 0.00159967848507 , -0.00610256503648 , 0.0019606136277 , -0.000889456735061 , 0.00202524393069 , -4.13647426805e-05 , -0.00121019135186 , -0.00915036348473 , -0.00325157963587 , -0.000755459999383 , 0.0057366313456 , -0.00260459263386 , -0.00111121115513 , 0.00253595609893 , -0.00171773610045 , 0.00324978589406 , 0.00288606403211 , -0.00315877377667 , 0.00549405988462 , -0.00307368718989 , 0.000974096602757 , -0.003606459124 , 0.000839024619833 , -0.0018208280767 , -0.000407260395627 , 0.00145870076506 , -0.00323131082268 , -0.00312530049096 , 0.00178731419407 , -0.000517411606615 , -0.000896756391406 , -0.00430282199159 , -0.00326805607019 , -0.00130168081718 , 0.00154303318739 , 0.00403161480797 , 0.00447318385457 , 0.00228523075381 , 0.000950392052779 , 0.00549916792761 , -0.0013928125624 , -0.00227985019941 , 7.63708229513e-07 , -0.00369905116228 , -0.000498296617499 , 0.000750970433515 , 0.00298714728771 , 0.00095353457299 , 0.00436279127484 , -0.00261554420656 , -0.00170012150444 , -0.00305832707218 , -6.22186003359e-05 , 0.00160908810189 , 0.00398203426985 , 0.000863657734567 , -0.00373363208331 , -9.43710663311e-06 , 0.00325002534379 , 0.00222826274584 , -0.000157337362207 , 0.00200011251113 , 0.00159066694167 , 0.00107471844252 , 0.00384472285156 , -0.00241846514441 , -1.87243052201e-06 , -0.000100601170981 , 0.00314547614337 , -0.000111027122604 , 0.00643659573935 , 0.00209092225493 , 0.00322882672003 , 0.00383356741473 , -0.000212095538121 , 0.00229342278869 , 0.00525359780904 , -0.00317855591767 , 0.00363538817147 , 0.00474346699791 , -0.00109803116414 , 0.00700037061552 , -0.00362487993556 , 0.000102432902063 , 0.00495974867953 , 0.00242890958744 , 0.00110767868102 , -0.00546253189346 , 0.00239852626263 , -0.00517769362051 , -0.00284002435822 , 0.000952387260216 , -0.00013867972857 , 0.00336620799068 , 0.00397858836329 , 0.000332542052922 , 0.00125636559203 , -0.000463292940869 , -0.001493895906 , 0.0057134621438 , 0.000684154247699 , 0.00551671734302 , -0.00254199589987 , 0.00553502548536 , -0.00224060820098 , 0.00162493420913 , -0.003494953927 , -9.67384026427e-05 , 0.00129099302123 , 0.00121880385232 , -0.00186836068216 , 0.000196097392552 , -0.0015799316216 , 0.00100428640819 , 0.00294648672215 , -0.00115469850357 , 0.0020579544083 , 4.15798361918e-05 , -0.00309220671088 , -0.00148053751224 , 0.00213507655107 , -0.0058637555269 , -0.000600054295472 , -0.000875241081182 , 0.0040578063135 , 0.00449767551613 , -0.000488517635625 , -0.00339024788951 , -0.000530290964589 , -0.000509732045635 , -0.00164036733319 , 0.000170972890447 , 0.00182894091837 , 0.000852068971313 , -0.000655676268065 , -9.5423445851e-05 , 0.000275853293961 , -0.000818639922356 , 0.000829058276969 , -0.00493062149655 , -0.0051346384693 , 0.0028985609912 , -0.00352821463533 , -0.00148791881498 , 0.000718426733837 , 0.00211971742599 , -0.004808371889 , -0.00750088933984 , 0.0013904891553 , 0.00223061077339 , 0.00314460534605 , 0.00415290297 , 0.00354597620543 , 0.000828990699044 , 0.00478508367982 , -0.000490407174817 , -0.00224672693294 , 0.00208392823197 , 0.00200162525266 , -0.00238266675615 , 0.000447046122099 , 0.0066308359242 , 0.00359712660904 , -0.00211419700734 , -0.00394427083423 , 7.60001431013e-05 , -0.00109988453092 , 3.98311488002e-05 , 0.000860295093451 , 0.00443840761162 , 0.000716437176813 , 0.000589318691222 , -0.00254931791568 , 0.00688563543748 , 0.00014824029384 , 0.00446589182771 , -9.18429332571e-05 , -8.4786319833e-06 , 0.00613951880551 , -0.00052065110784 , 0.00360250916644 , -0.000208160068636 , -0.000361605582459 , 0.00162466594794 , -0.00518897222096 , 0.00216910059587 , 0.000235680610876 , -0.00130723825492 , 0.00309657420984 , 0.000483801165428 , 0.0008586806689 , -0.0049287405964 , 0.0036119862807 , 0.00344643449345 , 5.84624445628e-05 , -0.0030765840183 , 0.000152957524509 , 0.00211646071063 , -0.00136905662704 , -0.00447836433406 , -0.000324069625546 , 0.000219986805723 , -0.00152640440782 , 0.000597700770167 , -0.0031816770054 , 0.000100483544024 , 0.000384933526774 , 8.36760067304e-05 , 0.0020695167659 , -0.00159755793224 , -0.00630220211786 , 0.0025021300276 , 0.00196873653237 , 0.00227292021237 , ])
Y_3_m2_imag = flex.double( [ -0.0 , 0.0 , -0.000270581627136 , 9.79635988975e-06 , -0.00415868338677 , -0.00394715773461 , 4.31349945158e-05 , -0.000755519905864 , 0.00572688229923 , -0.000785118355504 , 0.00150858328453 , 0.00115188472862 , 0.00232019611316 , -0.00128665686891 , 0.00185386315652 , -0.00183686046857 , -0.00316394903527 , 0.00243228688467 , -0.00087831038017 , 0.000394192761545 , -0.000503563748913 , -0.000327801263489 , -0.000426495813445 , 0.00101844771179 , -0.0020922994638 , -0.00373225876179 , -0.000448562388708 , 0.000397081720895 , -0.00101558229208 , -0.000642966251115 , -0.00241030413921 , -0.000931747013634 , 6.17689618902e-07 , -0.00513859764016 , 0.00081750181783 , 0.00171920651731 , 0.000478031654368 , -0.000194941822319 , -0.000776620827238 , 0.00154488479523 , -0.000106411573398 , 0.00209595915102 , 0.00270984906292 , -0.00102410950465 , 0.000391373028207 , 0.0037058475342 , -0.000878102833079 , -0.00103046081012 , -0.00405678083995 , 0.00279890906691 , 9.43709732354e-06 , 0.000582987038871 , -0.00585714100494 , -2.80695406242e-06 , -0.00550342306087 , 6.65027556022e-05 , 0.0011403198778 , 0.00246428480799 , 0.00201862097857 , -0.000249094896641 , -0.000365592537081 , -8.08401709792e-05 , 0.00181048663394 , 0.00296199750168 , -0.00551187638095 , 0.00021901059408 , 0.00270763263688 , 0.00538174375429 , 0.00142779812075 , -0.00153022535748 , -0.00200688331055 , -0.00161762343896 , 0.000249586301866 , 0.0039481462628 , 0.000185999650603 , -0.00454174730096 , -0.00242950048569 , -0.0038594080825 , 3.50569429067e-06 , 0.0030356825148 , 0.00352365219456 , -0.00409398780513 , -0.00532000024295 , -0.00147883447397 , 0.00140547974554 , 0.00397027686186 , -0.000394940036504 , -0.00232052489962 , -0.000275146182453 , -0.00476839598012 , -0.00389114708389 , -0.00267232964401 , -0.0033112727886 , -0.000549708072132 , 0.00374730091221 , -0.00259580387363 , 0.00143244932555 , -0.00105372128441 , 0.00228602224119 , -0.00350358183365 , 0.000968260192084 , -0.00327971460423 , 0.00228956082472 , -4.47006714712e-05 , 0.000508838445292 , -0.00697028691704 , 0.00101040653592 , 0.000439251575156 , -0.00528549688414 , -0.000613001536841 , 0.00219160885674 , 0.00173434530761 , -0.000892464352944 , 0.000746622295496 , -0.0011604265327 , 0.0035591614684 , 0.00106311503409 , 0.00241311401731 , 0.00273378770983 , 0.00225560101153 , 0.00031093341415 , 6.89853426738e-05 , 0.00268375410169 , 0.000828198611298 , 0.00516172757269 , -0.00216225159491 , -0.00204538562009 , -0.00114511683178 , -0.00212413827879 , 0.000468670080313 , 0.00656824977818 , -0.00154831660904 , 4.31951827412e-05 , 0.000436979906999 , -0.000115611937801 , -0.00258533384125 , 0.00224686205921 , 0.00184666139101 , 0.0016316177202 , -0.00226294616175 , -0.00285621347442 , 0.000819367505506 , 0.00382937362896 , -0.00345475490814 , -2.32582292785e-05 , 0.000384065112784 , -0.00259903089709 , -0.00251572480631 , -0.00189762095008 , -0.00136204660926 , -0.00109346700458 , -0.000675383746273 , 0.00130559121415 , -0.000469894347212 , 0.00204155856422 , -0.00322145604788 , 0.00081062556623 , -0.00500639286325 , 0.00264963087144 , 0.000996045367063 , -0.00242732930686 , 0.000528093924979 , -0.00021255174866 , 8.78884263922e-05 , -7.36293005574e-05 , 0.00412477199819 , 0.000515578566391 , -0.00262301941965 , 0.00523808394959 , 0.00130709032792 , 0.00214272541079 , -1.05029291671e-05 , 0.00379341736957 , -0.00321753870243 , -0.00173771560569 , -0.000779710704452 , 0.00299145148679 , 0.00220773911053 , -0.00279379875948 , 0.000551253427954 , 0.000408953298331 , 0.00481135525523 , -0.00452690486053 , 0.000859701657162 , 1.83402868776e-05 , -0.00114647532317 , 0.00175177154316 , -0.00621465390216 , 0.00318791332372 , -0.000856685911569 , 0.00295186805533 , 0.00160848969954 , -7.28323769244e-05 , 0.000697073988199 , 0.00624418494571 , 0.00351402961446 , -0.000355197261041 , -0.00343246483582 , -0.00202600879993 , -0.00106669005738 , 0.00106653017326 , -0.00514551427325 , 0.00405103752472 , -0.00199390425601 , -0.001147136855 , 0.000919351109286 , -0.000555242052352 , 0.00426398877476 , -0.00495797755195 , -0.00181441709165 , 0.00399186404006 , 0.000534781866102 , 0.000520165968344 , -0.00240984085779 , -0.00416496986713 , -0.00477084280411 , 0.00253623947076 , -0.0013508856712 , 0.00129235743917 , 0.000599974395148 , 0.0017787626423 , -0.00452894244074 , 0.00728704432699 , -0.00175026990997 , -0.00401833984102 , 0.00031614949323 , -0.00115763660748 , -0.00529303129816 , -0.000256124872101 , 0.00364925701078 , -0.00113151274778 , -0.00294705012841 , -0.00173633647374 , 0.00475809033669 , 7.99303530913e-05 , 0.000353890449909 , 0.00084941732145 , -0.00492753227042 , -0.0012360634858 , 0.0020041765011 , -0.00233449639772 , 0.000593564658521 , 0.00450500089627 , 0.00145736702026 , -0.00122468199849 , -0.000223347846991 , -0.00427398116568 , 0.00669414576267 , 0.000673098060978 , 0.000691361576315 , 1.9219803759e-05 , -7.9857373983e-05 , -0.00269417919167 , 0.0027568791443 , -0.00233509623953 , 0.000456281645874 , 0.00010336120179 , 0.000115544953087 , -0.00132514855092 , 0.00282202715965 , 0.00249769465297 , -0.0018661872548 , 0.00102424027361 , 0.00377687259282 , 0.00198061315652 , -0.00636499956843 , -0.0070636352218 , 0.00146039367851 , 0.00507819844959 , -0.00517381302134 , 0.000858295715614 , -0.00264378474829 , -0.000857599064474 , -0.000278609416186 , 0.00745797177802 , -0.00182376472083 , -0.000700054262922 , 0.00408294974394 , 0.00417995113246 , -0.00233438335142 , -0.00505980378595 , -0.00455464137763 , -0.00115312525495 , 0.00471843959717 , -0.000931719104796 , 0.00662840431954 , -0.00535417391076 , -0.000340821091134 , 0.00413227775043 , -0.00180064813917 , 0.00303354411381 , 0.00408561265237 , -0.00061715427765 , -0.00304621791757 , -0.000564599151766 , 0.00104506909851 , -0.00662249885513 , 0.00147360982163 , 0.00298091135945 , -0.00012055159854 , -0.000110218904441 , -4.41702197267e-05 , 0.00234624879954 , 0.00275451407662 , -0.0037774785907 , 0.00440733821296 , 0.00465595436918 , -0.00327368158123 , -0.00310959232846 , -0.000326244709919 , 0.0020503007534 , 0.00181491187594 , -0.00225621049876 , -0.00133921396337 , 0.000993087668274 , -0.000295813209652 , -0.00139009901163 , 0.00184688044515 , -0.00328190563749 , 0.00507577285869 , 0.00129548543023 , 0.000485048104245 , 0.0071324165626 , -0.000396120280522 , 0.0018582654532 , 0.0017411436238 , 0.00149334288334 , 0.000513103840624 , 0.00378853791167 , -0.00586298948325 , 0.000120834453833 , -0.0032159100264 , 0.0032669343832 , 0.00225212608664 , -0.00172902156811 , -0.000212169698838 , -0.00368987161351 , -0.000155255360206 , -0.0018916587978 , -0.0029313316097 , 4.8454926641e-05 , 0.00168391403542 , -0.00361141474478 , -0.000245868783083 , -0.00230693356327 , -0.000276543592815 , -0.00365573753252 , -0.00119019860176 , 0.0048101311827 , 0.00636506936701 , 0.000690827384335 , 0.00360222269325 , 0.00308694232696 , -0.00490687115838 , 0.00452957043052 , -0.000863817071953 , 0.00505007200711 , 0.00289092863284 , 0.00599123048478 , 0.00426463382571 , 0.0040666355206 , -0.000776527694181 , -8.78658618506e-05 , -0.000974214763132 , 0.000949560743161 , -0.0058769648127 , 0.0011481283064 , -4.41801110058e-05 , 0.00400699678993 , 0.00289987232525 , 0.00192420865786 , -0.00667153356947 , -0.00117421696384 , -0.00282205238405 , 0.00246990928884 , -0.00473820661854 , 0.00182807917672 , 0.0057407939112 , 0.000529066683938 , -0.00230509805868 , -0.000547421310569 , -0.000205015094435 , -0.00365566689682 , 0.00452561721429 , 0.00609480555016 , -0.00106589096146 , 0.00302091208555 , 0.00239369204658 , 0.000486949540069 , -0.00254263495539 , 0.00025569146557 , -0.00216862461876 , -0.00625678970408 , -0.00124903670636 , -0.00527018364712 , 0.00414956445133 , 0.00080538704734 , 0.0036075500993 , -0.000864252810526 , 0.00297864330853 , 0.00176995586668 , -0.00390576805745 , -8.38650020485e-06 , 0.00468457554392 , 0.000805287141679 , -0.004009552075 , 0.000387476341542 , 0.00175496370455 , 0.00349117106996 , 0.00118834084467 , 0.000952128565981 , 0.00250479558575 , 0.00249339054959 , 0.000354140455752 , 0.00307516182949 , 4.78985459699e-05 , 0.00609348730131 , 0.00149689765051 , -2.59058533238e-05 , -0.0003233112773 , 0.00539649911623 , -0.00722419458644 , -0.00485492686955 , -0.00247512841868 , 0.000698504797416 , -0.000255993936756 , -0.00641624270828 , -0.00396401110145 , -0.00495687665175 , -0.00216880699562 , 0.00263093224167 , 0.000275599182782 , 0.00419176662449 , 0.00190244144205 , 0.00591381439105 , 0.000642577627609 , -0.00184304571167 , 0.000251117194351 , 0.00146301049877 , -0.000920817341429 , -0.00332450198767 , -0.0016020838292 , 0.00154590766888 , -0.00327024848722 , -0.00250168851587 , -0.000658351410374 , -0.000693617292808 , 0.00264604913282 , 0.00298064197291 , 0.000244513973959 , 0.00364086702842 , 0.00233777158304 , -0.00251543434548 , -0.00065435326362 , 0.0029769745213 , 0.00155509142868 , -0.00795387911426 , -0.00559735081909 , 0.00141475561158 , 0.00406656631356 , -0.000291578798129 , 0.000583904908675 , -0.00471739175436 , 0.0038526645128 , -5.13650178427e-05 , 0.00485030361923 , 0.000168592099313 , -0.000384521284957 , -0.00195736852197 , 0.00223616495929 , 0.00151274765339 , 0.0047756652958 , -0.000620440770809 , -0.00222296031001 , -0.000529887493644 , 0.00537950924497 , -0.00101249628225 , 0.00597244683423 , -0.00026826650785 , -0.00119751808708 , -0.00546799859243 , -0.00112591778937 , 0.00218860251797 , -0.00542463130189 , 0.000235649619838 , -0.00166839023157 , 0.0036285830341 , -0.00298961166952 , -0.00277874619228 , 0.00198033850815 , 0.00374998295657 , -0.000679395930953 , -0.00261624706196 , 0.00634377157041 , -0.00273751096058 , 0.00561611258976 , 0.00342907696261 , 0.00308694908713 , -0.000809322601937 , -0.000932488562525 , -0.00439120822515 , 0.00274608508412 , -0.00450902034614 , -0.00155531488334 , -0.000722380590413 , 0.000256646125854 , 0.00118902034452 , 0.000831961784431 , 0.00131640817097 , -0.00102209971367 , 0.00637461708844 , 0.000214375840761 , -0.000487359504683 , 0.00175313453228 , 0.00202931085741 , -0.00299286481356 , -0.0046105542328 , 0.00187036888486 , -0.00330099354478 , -0.00189188744558 , 0.00346696627894 , 0.000135481386322 , -0.00470175731163 , 0.00348650243203 , -0.000831545842094 , -0.000927246619386 , -0.00537410051252 , 0.00357385807615 , 0.00120498327107 , -6.64689807446e-05 , -0.0001554067346 , -0.00129066027782 , 0.00052368289363 , 0.000228089605372 , 0.00258103520215 , 0.00494379882865 , 0.00148270720317 , -0.00198973947486 , 0.00211431479739 , 0.000484107512925 , -0.00294732745001 , -0.00165925880997 , 0.00367935893653 , -0.00190347145371 , 0.000341010699391 , -6.20012566548e-05 , -0.00124772966997 , 2.24767922011e-05 , 0.000894789532553 , 0.000974475680634 , 0.00307482427758 , 0.00335338932462 , 0.000289781483694 , -0.000136886793474 , -0.00141998835888 , -0.000167565550247 , -0.000559144497773 , -0.00370337996891 , 0.00307209996006 , -0.00315419811786 , -0.00123348013616 , 0.000728493325265 , -0.000256920043925 , 0.000660091361535 , 0.00263998845501 , 0.00284436980118 , -0.00585634996327 , -0.00337862023951 , -0.00145776199974 , -0.00045779628114 , -0.00384216163751 , -0.00268644434797 , -0.00011259734222 , -0.00117049824643 , 0.00415658681654 , 0.00124795547975 , -0.00597940450087 , 0.00226866674262 , -0.00278728431268 , -0.00290980142751 , 0.000601321143527 , 0.0027084220116 , -0.00121658413423 , -0.00341123088738 , 0.000696849839688 , -0.00496871391006 , -0.00563954437497 , -0.00237622462542 , -0.00216660931966 , 0.000888105982072 , 0.000540947447364 , 0.00423774054817 , -7.68277034575e-05 , 5.05608525758e-05 , -0.000556049647021 , 0.000408818381452 , 0.00210336778743 , 5.13490566249e-05 , -8.66079873596e-05 , -0.00242600627186 , 0.00575375421889 , 0.000730829439067 , 0.00489894866784 , 0.000606751325514 , -0.000716652790122 , -0.00575282982802 , 0.0073831050519 , -0.00247977347604 , 0.0040976514014 , 0.0019782331524 , 0.00515693327725 , 0.000864155635384 , 0.000125270247513 , 0.00309049069444 , -0.00387800619724 , 0.0031478297189 , 0.00187734617413 , 0.000361143936902 , 0.00408372712323 , -0.00474239757441 , 0.00596463029687 , -0.000544435292465 , 0.00448274123566 , -0.00709302568239 , -0.0010875670755 , 0.00537459152968 , -0.00172307452329 , -0.0013657098218 , -0.000895152214314 , -3.16337785381e-05 , -0.00143320858582 , -0.00176454936292 , 0.00398034674693 , -0.000544044920137 , 0.00524595995645 , -0.00089894971498 , 0.00358018608905 , -0.00225491407289 , -0.000559227981853 , 0.00480280419298 , 0.0013924712649 , 0.00289434113712 , -0.00116245524409 , -0.000403290160956 , -0.00319463991286 , 0.00281043692413 , -0.00320063458936 , -0.00390668860845 , 0.00338632923827 , 0.00128752678396 , 0.00292322755417 , -0.00328418355494 , 0.00649935860731 , -0.00121018773097 , -0.004058806848 , -0.00180360576655 , -0.0026032650197 , -0.00310480450219 , -0.0010949482532 , -0.00132532555977 , 0.000553701802306 , 0.000467246799482 , -0.0029683749743 , 0.00159064768216 , 0.00238855761629 , -0.000279539816385 , 0.00255186062333 , 0.00126283188732 , 0.00102136084323 , 0.00394976790295 , 0.00385605844424 , -2.20004034208e-05 , -0.000264083938829 , 0.000683641779583 , -0.00367389008613 , 0.00173967013173 , 0.00516748930523 , 0.000166166466462 , -0.00281121931055 , 0.000600437264182 , -0.00216924800208 , -0.00655819293797 , -0.00332853194826 , -0.00110015627519 , -0.0047659704235 , 0.00257809320824 , 0.00264252713957 , 0.00332578048691 , -0.00330707673923 , 0.00130993911293 , -0.00432688158585 , 1.40018045619e-05 , 0.000459590592459 , 0.000193331282576 , -0.00258485314855 , 0.000592082530609 , 0.000483779392466 , 0.000697819521777 , -0.00347532742816 , 0.00121361948444 , -0.00085472881586 , -0.00301837784266 , -0.00179018098691 , 0.00229182903604 , 0.000951726052061 , -0.00249373146509 , -0.0013749995763 , 0.00689223641524 , 0.000913724866826 , 0.00605136151191 , 0.0011420423835 , 0.00336957512359 , 0.00257919438125 , -0.00111726733133 , 0.000979830188426 , 0.000310251996375 , -0.00212335561528 , 0.00560192784156 , -0.0052450712431 , -0.00585596668476 , 0.00478466802715 , 0.00225197211944 , 0.000292693107591 , 0.000963290965541 , -0.00317348368133 , -0.00242725522284 , 0.00271521348737 , -0.00215217858247 , -0.000114702305814 , -0.00412313442096 , 0.0011879694673 , 0.00313429818086 , -0.00215041404201 , 0.00361281429551 , -0.00131086786876 , -0.00202443769289 , 0.00320538108148 , -0.00400987779197 , 0.000393289619845 , -0.00677655491739 , -0.00506363745778 , 0.000746692135365 , -0.000876889225713 , -4.37523616375e-06 , 0.000224481666716 , -0.00308919074636 , 0.000960859767087 , -0.00426828451185 , 0.00251332058442 , -0.000867765812188 , -0.00113391763425 , 0.00253965495987 , 0.00229984922376 , 0.000371379828237 , 0.00187202113625 , 0.000929286379467 , 0.000495018532206 , 0.00365231574634 , -0.00271438641373 , -0.000254936599281 , -0.000333194692885 , 0.00437381084179 , -0.0020284130782 , -0.00176219463849 , -0.00286840499415 , -0.00600350639005 , 0.001976878121 , 0.00178544992116 , -0.00197736366302 , 0.00222890686173 , 0.00485431319009 , -0.00627166402934 , -0.00122177763071 , -0.000463167594974 , 0.00204036376059 , 0.0015478405723 , -0.00383438305069 , 0.00134544389358 , 0.000837517426125 , 6.6278323638e-05 , -0.00196281710015 , 0.000433227133356 , -0.00423279924126 , -0.000185610049229 , 0.0013795086134 , -0.0033621333397 , 0.00354069865471 , 0.00290132218947 , -0.00597692627259 , 2.91243926591e-05 , 0.000167603697688 , 0.0054365338457 , 0.00212457332896 , 0.00290930010417 , -0.00256367448976 , -0.00278892513003 , 0.00401218723051 , 0.000128212190541 , -0.00203921174197 , 0.00173650931498 , -0.00198156034028 , -0.000531470911307 , -0.00380289695762 , -0.00064200058314 , 0.00274080312838 , -0.000545804867291 , -0.00206286948633 , -5.60349185188e-05 , 0.00069983197424 , 0.00374954030768 , 0.00347891930652 , -0.0043750511342 , -0.00062774079926 , -0.00388663937871 , -0.00141358136837 , -0.00331200421078 , 0.00212849782824 , -0.000347168030747 , -0.00231836677984 , 0.00131972311237 , -0.000533717369496 , 0.00702109142441 , -0.00329811976787 , -0.00262159504163 , 0.00128269728234 , 0.0011276549643 , -0.00161183162919 , 0.00339855814073 , -0.00145850828431 , -0.0017271600679 , 0.00216313463355 , -0.00189793420823 , -0.00306429276753 , -0.00309434741473 , -0.00368882170536 , 0.00300109459823 , 0.00450195270084 , -0.000521511235803 , -0.00485524435517 , -0.000496571990391 , -0.00174232309632 , 0.000994587955166 , 0.00146667616827 , 0.00489551437962 , -0.000589431040302 , -6.13980939885e-05 , -4.15655503372e-05 , -0.000386007260307 , -0.00663581638425 , 0.00474587333123 , -0.00151013107482 , -0.00049111593276 , 0.00400186804654 , -0.000462421623626 , 0.00521044917953 , 0.00146408549154 , -1.75434829397e-05 , -0.00283120671294 , -0.00211850833677 , 0.00271474222934 , -0.00142871579076 , -0.000270273197807 , 0.000102071163276 , -2.68167821885e-05 , -0.00140605199815 , 0.00199875165295 , 0.00358770070956 , -0.00122307826526 , 8.4057506171e-05 , -0.00181811306397 , -0.00615915142715 , -0.00426578982692 , -8.95879138033e-05 , -0.00493881854028 , 0.00154730315244 , -0.00146625266431 , -0.00328415346742 , -2.17939866748e-05 , -0.00283496487717 , -0.000587629707252 , -0.000188338445262 , 0.00575410999631 , -0.000841984829563 , 0.00178679102446 , -0.00307353432715 , 0.00269267004154 , -0.00172565449994 , 0.000358811463796 , -0.00681573572163 , -0.00411576221925 , 0.00360146665212 , -0.00421460724475 , 0.00348058037129 , -5.59006831086e-05 , -0.00243614869622 , 0.000735618596821 , 0.00134482115805 , -0.000830074666685 , 0.00148739158847 , 0.000387352649315 , ])
Y_3_m1_real = flex.double( [ -0.0 , -0.00557867096023 , 0.00449852182561 , -0.00427891183249 , -0.00115802366625 , -0.00128653291041 , 0.00243307969334 , 0.00283999380242 , -0.00364998103069 , 0.00116363032057 , -0.00108650977643 , -0.00166181849267 , -0.00331911397076 , 0.00113032218881 , 0.00561551312465 , -0.00161564022384 , 0.000186880471311 , -0.0101775959554 , 0.000515908923305 , -0.00511351453064 , 0.00457922550907 , -0.00329338598311 , -0.00154007356011 , -0.00159605527977 , -0.0051236493687 , -0.00892042308254 , 0.0047937922593 , 0.000146449253767 , -0.000410660997725 , 0.00304015130649 , -0.00524514102532 , -3.29248845506e-05 , 0.000202258071064 , 0.000153459908214 , 0.00108372967846 , -0.00138490451221 , -0.00407719666253 , -0.000274279607178 , 0.000522103671652 , -0.00186784356452 , 0.0033995375856 , 0.00127851455377 , 0.00169172597198 , 0.00179812152136 , 0.000410513728788 , -0.000997836874597 , -5.07609887687e-05 , 0.00287394332995 , 0.00108896388113 , -0.00160894435508 , -8.18015311767e-06 , -0.00282420759622 , 0.000870719935006 , -0.000486038588895 , -0.000555440214067 , -6.16060994164e-05 , -0.00411262405819 , 0.00334502334123 , -0.0071574542741 , -0.00242619164876 , -0.00495550531351 , 0.00455566018051 , 0.00423428528963 , 0.000560096609367 , -0.00497922524966 , -0.00235653619095 , 0.00144217945674 , -0.0029999716846 , -0.000237446429011 , -0.00206068505141 , 0.000523191291795 , 0.00225235671628 , 0.00466552477621 , 0.00395010663651 , -0.000523633930049 , 0.00297746333666 , 0.000599898474111 , 0.00221890799727 , 0.000158204506183 , -0.00301571551428 , 0.00514919067784 , -0.00192078875667 , -0.000783474676708 , 0.00106526072166 , 0.00400438465914 , 0.0011927437151 , -0.000922779373511 , -0.00117418293483 , 0.00519652591471 , -0.0029922847885 , -0.00293106947942 , -0.00371616097776 , -0.00229884055544 , -0.000344639319805 , -0.00198461916381 , 0.000107622336651 , -0.00270193138048 , -0.00191243744929 , -0.00012402449928 , 0.00469515327857 , 0.00172366274243 , 0.000685790690833 , 0.000612454434263 , 0.00357021388094 , 0.00347717929986 , -0.000261850144596 , 0.000439029046231 , -0.000609756537774 , 0.000865172409473 , -0.00228155839721 , 0.00476544397768 , 0.00390687158684 , 0.00253963455718 , 0.0017407583777 , 0.00456439978906 , -0.00118181801467 , 0.000576279471424 , -0.000435103264885 , 0.00083174541681 , 0.0050766814377 , -0.00246049607016 , -9.43951323349e-05 , -0.00259366771994 , -0.00315706604822 , -0.00206576022513 , 0.00321406049072 , -0.00407050213605 , 0.00250770386467 , 0.00260374972398 , -0.00160282031038 , -0.00182289165712 , 0.00151565291622 , 0.000116628635295 , 0.00395979565426 , 0.000169414466093 , -4.89071252328e-05 , -0.0020485324341 , 0.00278572869653 , 0.000236685143928 , 0.000544162782373 , -0.00280745386627 , -0.00115626565756 , -0.00100090366569 , -0.00566049976573 , -0.00569221171892 , 0.00140498376424 , 0.00156875777919 , 0.0026163692602 , -1.65099557191e-05 , -0.000572345497623 , 0.00132957538691 , 0.000948382727533 , 0.000866112951159 , 0.000340841769225 , 0.00258771613105 , -0.000236859420041 , -0.00258557991141 , -0.00225591373569 , 0.00242744871931 , -0.000249552400421 , -0.000275136083753 , 0.00147872162266 , 0.00553156730361 , 0.00224907601363 , -0.00148351297264 , 0.000397865770828 , -0.0029866689747 , -0.00262859573945 , -0.000470431381814 , 0.00628500838354 , -0.00249230592515 , 6.6888412965e-05 , -0.000518176397202 , -0.000207164100023 , 0.00198392691738 , -0.00568413093164 , 0.000651588995363 , -0.00442303338653 , 0.000268828011078 , -0.000711689091756 , 0.00237118102837 , 0.00021777232668 , 0.00100487527736 , 0.00624640373813 , -0.00353823364009 , 0.00510576694523 , 0.00610264936438 , -0.00148060268259 , 0.00183642506078 , 0.00221221844314 , -0.000531189306831 , -0.00148745790407 , 0.00114973073557 , 0.00232563947403 , 0.00263981498279 , -0.00184024459675 , -0.00107134294966 , 0.00254325525306 , -0.00108480174627 , -0.00402646660828 , 0.000235727323981 , 0.00328588331246 , -0.00196419121423 , 0.000536491624836 , -0.00691076689973 , 0.00165470608728 , 5.46147142599e-05 , -0.000910495073814 , 0.00292567132545 , -0.00554138656041 , -0.00426732492113 , 0.000561275456356 , -0.0010648703714 , 0.000504333241139 , 0.000154624331138 , -0.00116176882043 , 0.00128100675673 , 0.000395624946025 , 0.000175212836182 , 0.00694235146618 , -0.00360086580871 , -0.00393341599842 , 0.00452379490136 , -0.00347001618551 , -0.000311419348246 , -5.06013382286e-05 , -0.00122287357524 , 0.00507415735575 , -0.000496250594539 , 0.000609164572701 , -0.000560624429441 , 0.000351324199086 , 0.00358866458737 , 0.000252950822281 , 0.00450507979938 , 0.000463880186352 , -0.000593670337333 , 0.00132344286271 , -0.000461754056902 , 0.00282174189997 , -0.000862314698224 , 0.00291515793355 , 0.000609904080794 , 0.000697094824391 , -8.75934538665e-05 , -0.00019428995565 , 0.00286977886049 , -0.00304491631048 , -0.000380788675995 , -0.00158937113985 , 0.00417826134842 , -1.8975258124e-05 , 0.00583183912864 , -0.00257184324917 , 0.00329107730235 , -0.00314713935069 , 0.00462720013007 , 0.000516546683329 , 0.00171177397946 , -0.00101446923362 , -0.00187260152738 , -0.0044386209376 , -1.03951650049e-05 , -0.000466964538986 , -0.000554656580301 , -0.000107302278404 , 0.00350466018842 , -0.00104968725948 , -0.00366697304596 , -0.0017407144768 , 0.00293107386697 , -0.000974283570023 , 0.000211585156836 , -0.00198710290125 , 0.00277582264919 , 0.00184387157654 , 0.00350530690194 , -0.00240587260888 , 0.00272511287359 , 0.000916244357418 , -0.000508299446361 , 0.00251753699041 , -0.00390205329495 , 0.00229890132327 , -0.00133033075161 , 0.00186444623108 , 0.00607311533248 , 0.00170598444001 , -0.000691094475221 , 0.00169023370458 , 0.00221052759578 , 0.00242070914385 , 0.0036673253169 , -0.000747957227811 , -0.000182609974903 , 0.00383655993701 , -0.00399225785518 , 0.00254960711637 , 0.00158548461578 , -0.00278838426995 , 0.000194174768498 , -6.04665249689e-05 , -0.00236569193753 , 0.00145994369299 , -0.0040349960449 , 0.00490542209937 , 0.00171733284452 , 0.00662375320912 , 0.000672883031427 , 0.000453454874636 , 0.000288357629028 , 0.00122003199079 , 0.00257337941669 , 0.000847668197467 , 0.00127948736052 , 1.04470246664e-05 , -0.000595499166415 , -0.000137984325086 , 0.00188340875257 , -0.000832493507045 , -5.0102523146e-05 , -0.0010149077317 , -0.00240184313924 , 0.000703110756981 , -0.00656492814879 , -0.00245094074005 , -0.00350173111318 , 0.000274017728105 , -0.00992501771859 , -0.00524677675415 , -0.00107999468976 , 7.00168374654e-05 , 0.00159045693838 , -0.00473269085766 , 0.00186451235403 , 0.00051217278065 , 0.000422850068233 , 0.000122648733455 , -0.00437330862647 , -0.00569536153119 , -0.000183637842677 , 0.00318163058276 , 0.00284611276168 , -0.00338837929297 , -0.000503890067503 , -0.000218248174323 , 7.47182532523e-05 , -0.00142484069405 , 6.751075801e-05 , -0.00850504184757 , -0.0027014522237 , 3.07382824189e-05 , 0.000194479182915 , -0.00149917899414 , 0.00161498722184 , 0.00417860898928 , -0.000768001371203 , -0.000772000097917 , 0.00140781199248 , -0.00216338864606 , -0.00261208967294 , -0.0084709427185 , 0.000447947177951 , 0.00304849663684 , 0.00360220804237 , 0.00455939164533 , 0.00165424487269 , -0.00012298992688 , -0.00198657601051 , -0.000611331290573 , -0.00341846299422 , -0.00136859898953 , -0.00133530935658 , -0.00201899901612 , 0.00168533384046 , -0.000403370320719 , 0.000347702783908 , -0.00189055152444 , -0.000261075871309 , 0.00358438208333 , -0.00262243198598 , 0.000116522950212 , 0.000986491008261 , -1.77878654412e-05 , -0.00561667353559 , -0.00223584270518 , -0.00166336738545 , 0.000950987660615 , 0.000222646714598 , -0.00321887261732 , -6.16976857826e-05 , 0.000230200850506 , -0.00333730868864 , 0.00460005994739 , -0.0060049615089 , 0.0025082172965 , 0.000606618532567 , -0.00366122302866 , 0.00148436061031 , -0.00127095233787 , -0.000913884186385 , -0.00327597569176 , 0.00502049570674 , -0.00257701326205 , 0.000269407640726 , -0.00553692185978 , 0.00329203612465 , 0.00418117258188 , 0.00120073505573 , 0.00199437136621 , -0.00263210861777 , -0.000800452368598 , -0.000100032366479 , 0.000194370044066 , 0.00452091904837 , -0.00548408128308 , -0.00190747460594 , -0.00413257391273 , 0.00278576641329 , -0.00356264025687 , 0.00190275865417 , 0.000129165907983 , -0.00199497694716 , 0.000164688901776 , 1.15742322835e-05 , -8.86872028229e-05 , 0.00420820818748 , -6.36417021765e-05 , -0.00414934121155 , 0.00174066475679 , 0.00132561111207 , -0.00338121336354 , 0.000502164355036 , -0.00142887868697 , -0.000394925339472 , -0.000680739852424 , 0.00317230194733 , -0.00273924936882 , -0.00464770976592 , -0.00502540841087 , 0.00299913824349 , 0.00368572078775 , 0.00346411946752 , -0.00269366832561 , -0.00194448550691 , -0.0010129583193 , 0.000326447653159 , -0.000988336771784 , -0.000179168130394 , 0.00548487024888 , 0.00168560798026 , -0.00266706681342 , -0.000846143913678 , 0.00762339138771 , 0.00293422767046 , -0.00120508076893 , -0.00362296568901 , 0.00265257471404 , -0.000915540569787 , 0.00450167827799 , -0.00304823248337 , 0.00215943953508 , 0.00676476230799 , 0.00616424114617 , -3.88356241951e-05 , 3.05952143241e-05 , -0.00157604054831 , 0.00463415739502 , -0.00555829349273 , -0.00049974420894 , 0.0081363550428 , 0.00304271219567 , -0.00248690859637 , -0.00188516415499 , 0.00213699936048 , 0.00373729363561 , -0.00141312704167 , 0.00169517883692 , -0.00573504043916 , -0.00204032309482 , 0.00118704812517 , -0.00205124694037 , -0.0048078770075 , -0.00114489079942 , -0.000752984850922 , -0.002314188306 , -0.0062294110676 , -0.00251898779423 , -0.00184646062841 , 0.00384802015308 , -0.00157195801493 , -0.000987350069093 , 0.00613554666831 , -0.000634767707831 , 9.43567022235e-05 , -0.00648844326212 , 0.000251806556927 , 0.00354978685479 , -0.00045826580316 , -0.00114462921514 , 0.00442110187576 , -0.00274624332061 , -0.00319789985661 , -0.000473847070526 , -5.9472527952e-05 , -0.000884772392283 , 0.000221573177369 , -0.000463710320599 , -0.000505541392976 , 0.000591525276965 , -0.000764352253409 , -0.00506890954729 , 0.00350012799593 , 0.000618096234675 , 0.00125335581655 , 0.00270351109311 , -0.00143306042112 , 0.00170606224081 , -0.00573209170193 , 0.00228890810668 , -0.00116157282126 , 0.00182169507604 , -0.000195062040993 , -0.00116129497291 , 0.00354168392793 , -0.000435486310457 , -0.00415402044314 , -0.000591979573504 , 0.00482138591179 , 0.00266323811254 , 2.29173215569e-05 , 0.00250767318092 , -0.000234134632268 , 0.0033029343442 , 0.000672323915356 , -0.00351484907029 , -0.00128264366102 , -0.00371801339127 , 0.0013978178538 , -0.00407623271472 , -0.00200608806128 , 0.000887316732444 , 0.000976740730976 , -0.00100424545459 , 0.000179138699899 , 0.00413376200352 , 0.00203094630242 , 0.00045640355249 , 0.00242128111631 , -0.00148146691876 , 0.001850162486 , -0.00521496667424 , 0.000433703368625 , -0.0017868241807 , -0.0039316615066 , 6.70666955965e-05 , -0.00186317290375 , 0.00145985525473 , 0.00318318982346 , -0.00470397274704 , -0.000838415947872 , 0.00422236907885 , 0.0031903754421 , -0.00530680763047 , -0.00195735342773 , -0.00264931027449 , 0.000672897586102 , 0.00123396889882 , -0.000128474475657 , 0.00306019555325 , 0.00204732680301 , -0.00262610708538 , 0.00152600064317 , 0.00329166162606 , -0.00205719312095 , -0.00283437249916 , -6.20956324342e-05 , -0.000568299409729 , -0.000801617958123 , 0.0044170573429 , -0.000140685445961 , 0.00332428627214 , 0.00397840891915 , -0.00183206847127 , 0.000760916261404 , 0.00102713846835 , -0.00301505337773 , -9.81734359301e-05 , -0.00370803181643 , -5.58264325947e-05 , 0.00318107979608 , 0.0030360076429 , 0.00157693512927 , 0.00118944942996 , -0.00075184978207 , -0.00667376265208 , 0.00104720001044 , -0.000498982164108 , -0.00290687072284 , 0.00361173482988 , -6.46426820786e-05 , 0.000650873863916 , -0.000856649461267 , 0.00268883217473 , -4.85929115465e-05 , 0.000814970133361 , 0.000903672360239 , 0.00369169510593 , 0.000625076293004 , -0.00402479894315 , -0.0016254984687 , -0.00194134754862 , -0.00577697976841 , 0.00252442464483 , 0.00147003782748 , -0.000955010335928 , 0.00259841648576 , 0.000625980108759 , 0.000551467662357 , 0.00273625266427 , 0.00425918440915 , 0.00299667925386 , -0.0063811078461 , 0.00163781966607 , 0.00253167593103 , 0.000717917499616 , 0.00180145466822 , -0.000185288606121 , 0.000224879229386 , -0.000135986326415 , 0.00036032806705 , -0.00336604638176 , -0.00148254927165 , -0.00239343089594 , 0.00174783359394 , 0.00142588536547 , -0.00224331134011 , 0.00875934549084 , -0.000323504778315 , 0.00180934212917 , -0.00451888933123 , -0.00265070768441 , -0.00412307160128 , -0.00394301813753 , 0.000719252585372 , 0.0048827637821 , -0.0007843470085 , 0.00167047575189 , -0.00144845087969 , 0.00590606954902 , 0.000893075409512 , -0.00112058260769 , -0.000453429174798 , -0.00315876295249 , -0.0020398872139 , 0.00267362898658 , -0.00211743415651 , 0.00229943537509 , -0.00118848193579 , -0.000808068845136 , -0.00193857412658 , -0.000153717324037 , 0.00270305400454 , -0.00290659144584 , 0.00129475053489 , -0.000240117364734 , -0.00366802363098 , -0.00265220072016 , 0.00513862207143 , -0.00309314660176 , 0.00342187536156 , 0.00522441236837 , -5.64983514464e-05 , -0.000390888156207 , 0.00211985709952 , 0.00094176152927 , -0.00469210669253 , 8.63764810674e-06 , 0.00213929775268 , -0.000667079627999 , 0.00357364704294 , 0.000940091053421 , -0.000151934871828 , -0.00222000311846 , 0.00179677278806 , 0.00178438255759 , -0.000272047340006 , 0.00035431288676 , -0.00562911571281 , -0.00136899537619 , 0.0055336405032 , 0.000513755339764 , 3.71529212216e-06 , -6.11999116094e-05 , 0.00305063630294 , -0.0035801768892 , 6.15482177818e-05 , -0.000754103970243 , 0.00368022990889 , -0.00072179247918 , -0.00336505889528 , 0.0009364300379 , -0.00294583463397 , -0.00187109787341 , 0.00425196898969 , 0.000623749065945 , -0.00177987664432 , -0.005080566078 , -0.00161732145396 , 0.0048154576434 , -0.00195420903586 , 0.00167431258295 , 0.00360129182198 , 0.000330524415557 , 0.00425253141135 , 0.00540573533849 , 0.00407829306074 , 0.000124606311512 , -0.00173397013481 , 0.00315979711747 , -0.00136285453578 , -6.85748114337e-05 , 3.09829406867e-05 , 0.000886964559361 , 0.0026204892304 , -0.000717864715253 , -0.00305101834855 , 0.00118837608943 , 0.000986292231182 , 0.00236829648679 , -0.00433908594922 , 0.00172799342193 , -0.00231529520204 , 0.000660297008903 , 0.00574692774731 , 0.00477730796926 , -0.0061015727612 , 0.000205416306784 , -0.00254584493216 , -0.00716591971946 , 0.000735418993925 , 0.0010606321678 , 0.00554416352416 , -0.000755006177771 , 0.000270156486437 , 0.00102013582221 , -0.00100131416702 , -0.00945415830516 , 0.00177952514995 , 0.0031728252782 , 0.00107813410521 , 0.00422079522851 , 0.00222245215289 , 0.00248753320737 , -0.000427196584276 , 0.00296032176118 , -0.00959860672085 , 0.000287625880021 , -0.000713503075526 , -7.05907648439e-05 , -0.00203934185823 , 0.00160859924523 , 0.000801582175684 , 0.00111225108687 , 0.000139985386311 , 0.00249783797409 , 0.0020063397815 , 0.000526062209457 , 0.00122051344201 , -0.00035782712177 , 0.00237669531739 , 0.00151110893528 , -0.00124778937984 , 0.000169256581225 , -0.00212107071481 , 0.00262348255524 , -0.00417928314703 , 0.002723108331 , 0.00250891058031 , 0.00380224266813 , -0.000139993084076 , 0.00327715982766 , 0.00447004499748 , 0.00328037273971 , 0.000316477024888 , 0.00613428189899 , -0.00196073093094 , 0.00380877389792 , 0.0029323899226 , 0.000956665398463 , -0.00429022210247 , 0.000233462991451 , 0.00653477425166 , -0.004082442284 , -0.00167255016562 , -0.00135920650166 , 0.00272219807869 , 0.0038977189625 , 0.00473194626434 , -0.00600865643167 , 0.00116000509727 , -0.00410624173246 , -0.00373776973129 , -0.00226363036832 , -0.00280476438511 , -0.000945221041221 , 0.000103739192834 , 0.00367512000123 , -0.000950059140454 , 0.000890401199108 , 0.000135648923411 , -0.00193972320177 , -0.00623497288609 , 0.00318507002907 , -0.00461140848734 , -0.00121166846767 , 0.00289881121549 , -0.00328657879512 , -0.00225734316213 , 0.00398820445462 , -0.00326032772622 , -0.00386170558881 , 0.0012266539318 , 0.00602254882513 , -0.00180643921358 , 0.00436758429143 , -0.000429831611472 , 0.00329132830544 , 0.00758200278379 , -0.000593415401544 , -0.00513217963532 , 0.0017544140835 , -0.00119304395659 , -0.000841145582533 , 0.00112079055737 , 0.00311328399416 , 0.000535050345058 , -0.00247426592168 , -0.00175490170616 , 0.00105543707779 , 8.68599671112e-05 , -0.00329215317985 , 0.00128225143678 , 0.006586329774 , -0.000388701911205 , 0.00251578834128 , 0.000142366305388 , 3.31769837558e-05 , -0.00109873911189 , 0.00491122470655 , -0.00677281956462 , -0.0020648506139 , -0.00287915602992 , -0.000626073558037 , 0.0014079208313 , -0.00188523636164 , -0.0045655963967 , -0.00347792587532 , -0.00132926129393 , -0.0058977159248 , -0.00292412595908 , -0.0110807788786 , 0.000489318056124 , -0.00286733696142 , -0.000185502330268 , -0.00320944861445 , 0.00589354937523 , 0.00148587837298 , -0.00308475813035 , 0.00477143172381 , -0.00109317833064 , -0.00233708358179 , 0.00266467267036 , -0.00170383428887 , 0.0028587473789 , 0.00422760102394 , 0.00150682675179 , -0.00677189400998 , -0.00059330185387 , 0.00306234814796 , -0.00211970173394 , -3.28725242065e-05 , 0.00304040953833 , 0.00303127737111 , 0.00116243875433 , 0.00354465935321 , -0.00268779934151 , -0.00181374638449 , -0.00283939616351 , 0.00144564257406 , 0.000777148802634 , -0.00114700378031 , -0.000197598078207 , -0.00144529982732 , 0.00169884429645 , -0.00412841094704 , -0.000216896540032 , 0.000895177851946 , 0.00191060522711 , -0.00494007510543 , ])
Y_3_m1_imag = flex.double( [ 0.0 , 0.0 , -0.000815978257955 , 0.00339843486909 , 0.00188096597314 , 0.00351734094518 , 0.00400930195047 , -0.000321998478495 , 0.00207597221937 , 0.00502023520002 , 0.000163496331091 , 0.00543296186919 , 0.00508189595134 , -0.00513137579937 , 0.00258132824451 , -0.00128827870726 , -0.000806036139219 , -0.00329220376568 , 0.00307427617638 , 0.000782870672841 , 0.000489980082989 , 0.0011922918719 , -0.00343527246753 , -0.000140676625775 , 0.00195368636327 , 0.00292289714835 , 0.000230688690853 , -0.00202352876331 , 0.00454369818103 , -0.0022967918728 , 0.00821199931752 , 0.000378956304923 , 0.00540455172016 , 0.000110327816927 , 0.00296194779717 , 0.000267542621933 , 0.00040602734282 , 0.00060156955427 , -0.00901294680955 , -0.000790469627124 , 0.00206965769947 , 0.000299206256831 , 0.000685003981406 , 0.000193018854918 , -2.07404993025e-05 , 0.00045638232364 , -4.65771313962e-06 , 0.000427537566633 , -0.000594827860728 , -0.00119553913581 , -0.00263025424678 , 0.000165871040239 , 0.00127375214119 , 0.00537185358577 , 0.00074313988717 , -0.00384328061268 , 0.00174419441044 , 0.00324461879025 , 0.00158625359924 , 0.00463951446136 , 0.000631066554937 , 0.0020414021527 , 0.00362320727577 , 0.000985952990914 , 0.00589768348053 , -0.00205735869742 , -0.000674384339808 , -0.00281019930491 , -0.000560138295746 , -0.000566622592815 , 0.000105095237106 , 0.001969135731 , 0.000747838379778 , -0.00524716842659 , -0.00332449001183 , -0.0017641317006 , -0.000684773115807 , -0.000854172481685 , -1.58672238205e-05 , 0.00315791070986 , -0.00470334114256 , 0.000592758627845 , -0.000958545312216 , 0.000204508759927 , 0.00295829677273 , 0.000610454212072 , -0.00539033772533 , -0.00148221871441 , -0.000309953996935 , -0.00191252500974 , -0.00128222632693 , -0.00697849437642 , 0.00746527174806 , -0.00438374135633 , -0.00286721282372 , -0.000320105083612 , -0.00766832941969 , -0.0032150428114 , 0.000307685063376 , 0.00215149356977 , 0.000199432400587 , 0.000742025387602 , 0.00200374459562 , 0.000242717334505 , -0.00233075246413 , -0.000238146617776 , -0.00219111507604 , 0.00389616572147 , -0.00187224823082 , -0.00274793673033 , -0.00407557696626 , 0.00167859110312 , 0.0034165391531 , 0.00773202748316 , -0.00236056630061 , -0.00153395855962 , 5.9654794847e-05 , 0.000129086460089 , -0.00177955042733 , -0.00128400743029 , -0.000100661764564 , 0.0033888927113 , -0.00994910033023 , 0.000467011060723 , 0.00160516303408 , -0.00194000294706 , -0.0014774088302 , 0.00319425080377 , -0.00397579875027 , -0.000282407814675 , -0.00129165326236 , -0.000209405504979 , -0.00324232970407 , 0.00065159661126 , 0.00530032189102 , 1.1935021553e-05 , 0.00297766504485 , -0.00180487171783 , 3.31661711488e-05 , -0.00177127485243 , 0.00760971996835 , -0.00435939677462 , 0.000593863574987 , -0.00419325589455 , 0.00132812695456 , -4.92711747453e-05 , 0.000691787581177 , 0.00144346573313 , 2.95456466605e-05 , 9.32936453946e-05 , -0.00845372477254 , -0.00282648413985 , -0.00745908663719 , -0.0027309573629 , 0.00167313144009 , -0.000396571859291 , -0.000464994490607 , -0.00282681303895 , 0.0029688436036 , 0.00149203170465 , -0.00105870777917 , -0.00365250072033 , 0.000406564201837 , 0.00509205590326 , 0.00408008426496 , 0.000964124913986 , -0.00525817382092 , -0.00268764882162 , 0.000819311633457 , -0.00153511972521 , -0.00052220498509 , 1.04880152823e-05 , 0.000940802152547 , -0.000194799538545 , -0.00448297481018 , 0.000709080355681 , 0.00264840834761 , 0.000854901011237 , -0.000195595054106 , -0.00524858944098 , 0.00219586051475 , -0.000221373179739 , -0.002126683241 , -0.00057522247613 , -0.00036423417786 , 0.00168695817859 , 0.00130348923446 , -0.00204985204922 , 0.00407008598639 , -0.00537946366867 , 0.00141826158925 , -0.00172223037524 , 0.000127280358688 , -0.000197583739146 , -0.00224344443104 , 0.00390597128263 , 0.000745154496975 , -0.00367663054979 , -0.00413893181323 , 0.000617869264955 , 0.00212096490033 , -0.00351208854874 , 0.000821995413779 , 0.00221122739249 , -0.00133702285885 , 0.00307331419885 , -0.00063214783408 , 0.000932949457326 , 0.00284381873509 , 0.000751449732186 , 0.00231718704181 , 0.00560117727014 , -0.000769685863765 , -0.00013946982203 , -9.02329873509e-05 , -0.00185140338184 , -0.000414393104701 , -0.00267799372664 , -0.000914144542947 , 0.000346542323933 , 0.00121104677317 , -0.00296240971724 , 0.00367765333239 , -0.0022601425253 , -0.000646453819024 , -0.00109579519534 , -0.000193641126159 , -0.00493733137683 , -0.00571838921714 , 0.00078307196651 , 5.52252323354e-05 , -0.00189040615233 , -0.00342488905251 , 0.000171928767573 , -0.000108115778626 , 0.00453569878542 , -0.00406331609121 , -0.00209037133744 , 0.000821599988161 , -0.00345882445584 , -0.00184079499037 , -0.00306534137089 , -0.00175125906555 , -0.0031448313154 , 0.000391298697922 , -0.00581620231922 , -0.00290862376741 , 0.00314479856025 , 0.00406575066385 , -0.00385698947258 , 1.55881137505e-05 , 0.00097211394886 , -0.00420907046448 , 0.00119012623768 , -0.00283504073772 , -0.000186953812254 , 0.000166377187268 , -0.00325324655804 , -0.000416689708928 , 0.00309202491684 , 0.00445115875383 , -0.00186030134612 , -7.28578043546e-05 , -0.00102987218944 , -0.000126229654837 , 8.37093227696e-05 , -0.00295074734798 , -0.00290227859972 , 0.00552618011183 , 0.00156403142833 , -0.0011030855347 , 0.000662926497924 , 0.00199792514929 , -6.74927257531e-05 , 0.00394634603643 , -0.00147525615359 , -0.00436323924805 , -0.00136356644643 , -0.00121731576548 , 0.00159933341928 , -0.00117934181688 , 0.0048843349672 , -0.000549929069619 , -0.00371547823939 , 0.00462258645831 , -0.00278113002455 , -0.00296190792941 , -0.00294500408369 , -0.00268718558311 , -0.000832553796335 , -0.00176360314059 , 0.00276224346459 , 0.00286610528072 , 0.00238513603075 , -0.00321759175128 , -0.000941436222927 , 0.00584993950759 , 0.00372419258723 , 0.00041444283513 , 9.22213741722e-05 , -0.0033280387284 , 0.00253307082592 , -0.000860899886222 , -0.00438989515046 , -0.00373863113502 , 0.00199217034383 , 0.00177195929338 , -0.00337797667627 , 0.000224305309726 , 0.00450848534174 , -0.0017542714981 , -0.00257144627065 , 0.00074965007589 , 0.00276754860857 , 0.00555271750657 , 0.000291115705753 , -0.00509989624807 , -0.000459264997883 , -0.00410360915624 , 0.000658628474312 , 0.000467237652185 , 0.00514571735399 , -0.00445009891539 , -0.00344115104154 , 0.00200645872703 , -0.00223914613808 , 0.00165388175712 , 0.00160020080772 , -0.00304435602639 , 0.00260122358285 , 0.00137306024998 , 0.000108186930388 , 0.0042323484808 , 0.00400713495863 , 0.00419781965289 , -0.00649728133716 , 0.000855563314354 , 0.00587733729344 , -0.00368105436791 , -0.00201730840535 , -0.00408460352403 , -0.00547987423363 , 0.00586828088677 , -0.00229923662031 , 0.000550295349793 , 0.000401578400726 , -0.000193717158222 , 0.00977385856523 , -0.000163588806388 , -0.00665361683223 , 0.000234986555815 , 9.31884791835e-05 , 0.000285474489875 , -0.00114314811326 , 0.00216828785434 , 0.00143646509404 , -0.0012492055771 , 0.00251555919934 , -0.00153794370059 , -0.00856303340017 , -0.0039194860845 , 0.00183738190407 , -0.0013017049252 , 0.000746859252402 , 0.00144560346814 , 0.00255487182117 , 0.00321574497063 , 0.000480966388238 , 0.00283110029414 , 0.00288423347315 , 0.00157239506892 , 0.00205108684403 , 0.000257732294209 , 0.00368170713395 , 0.000622993370843 , 0.000885786230906 , -0.00115924339359 , 0.00366049811465 , -0.00378584125246 , -0.00071747890261 , 0.000648219168431 , 0.0032635005725 , 0.000807996293611 , 7.97373403826e-06 , -0.00310583102463 , -0.00361622474335 , 0.00615468426204 , 0.004602650018 , -0.00448091224618 , -0.00418805628636 , 0.00197565684666 , 0.00126825591607 , -0.00298851941224 , -0.00097590324813 , 0.00894635444523 , -0.00156300504105 , 0.00854865338484 , 0.00570625099005 , 0.00278077863739 , -0.00259006458904 , -0.00201318243217 , -0.00199201967445 , 1.11165103101e-05 , -0.0013766058833 , 0.0044818571371 , -0.00330124384954 , -0.000982749117114 , -0.00222967663484 , 0.000921424855627 , -0.000431018280863 , 0.00249237465434 , -0.00237655945808 , 0.000399017169303 , 0.00452855232698 , 0.00575210423467 , 2.15921247701e-05 , -0.00181489450213 , -0.00125376666078 , -0.00237751910123 , -0.000410354929689 , -0.00118798720004 , -0.000124998111807 , -0.00197296769729 , 0.000499576691837 , 0.000248268762042 , 2.35638046474e-06 , 0.00428114393872 , -4.33898964418e-05 , -0.00590487448725 , 0.00713855613539 , 0.00137320895533 , -0.00113618272983 , -0.000306815298855 , -0.00382111414123 , -0.000490790621324 , 0.00655294175716 , -0.001094980007 , 0.000872117971578 , -0.00200787249654 , 0.00144637423473 , 0.000788448312432 , 0.000600112025186 , 0.000800252825296 , 0.00275562520931 , -0.00764001275136 , -0.00468776719871 , -0.00301827404446 , 0.00157746938823 , 5.58875393764e-05 , -0.000226005872339 , -0.00195297214454 , -0.000769776722498 , -0.000191487195018 , -0.00107214019115 , 0.00179167857894 , 0.00607884341591 , 0.00327181358753 , 0.00372020204678 , 0.00249996038641 , -0.00198525092503 , 0.00324113753118 , -0.00314694108782 , 0.00412699049326 , -0.00370063541782 , -0.00316047903396 , -1.87962005254e-05 , 2.16058691469e-05 , 0.000930658132555 , -0.00283122932332 , -0.00265822000545 , 0.00157433898571 , 0.00177156217163 , 0.000121199832886 , -0.00408365668013 , 0.000109922354975 , -0.00331564862733 , 0.00318828262818 , 0.000962559292531 , -0.00127931866599 , 0.00320200004223 , -0.00110764470028 , -0.000228166556085 , -0.00232674764848 , 0.0009253542028 , -0.000888595382857 , 0.0004237665107 , 0.00209781009551 , -0.00112138083517 , 0.002554243549 , -0.00319428206955 , -0.000651604938937 , -0.00464039835637 , 0.00148132805024 , 0.000499997456092 , -0.000158659717906 , 0.00466320587932 , -0.000347936674213 , 0.00369358393321 , 0.00203661633757 , -0.00339598034203 , 0.00414420075046 , -0.00518863642774 , -0.0035085396181 , -0.0024426810971 , -0.000597520440144 , -2.99292510963e-05 , 0.00176701862533 , -0.00204154244763 , 0.00325814097337 , 0.00535164318236 , -0.00091102367627 , 0.00242827107421 , -0.000127905131264 , -0.000106816255009 , 0.00527441448345 , 0.00412379276965 , -0.00262297730521 , -0.00269594723031 , 0.00177047245176 , -0.00475513084136 , -0.00337714700234 , -0.00637294429148 , -0.000236208489232 , 0.00114747721348 , 0.00191218409748 , 0.00170017260903 , 0.00298021653689 , -0.000308867991953 , -0.00248679694851 , -0.000165746175814 , -0.00057690529455 , -0.000929648628445 , -0.00257218226236 , -0.000496297287927 , -0.00151225434848 , 0.00364160699897 , -0.0009425360279 , -0.003705228163 , 0.00226216417285 , -0.00083665519624 , -0.00444792501052 , -0.00158533689418 , 0.00176300571549 , -0.00332460837359 , 0.00294005681513 , -0.00169328676128 , -0.00483818364768 , -0.000589712763376 , 0.000272754783322 , 0.00506062224739 , -0.000548184232092 , -0.00190219893874 , 0.00297601369326 , -0.000852875132099 , -0.000523346812762 , 0.00491111379869 , 0.000625450614939 , 0.00412964657623 , -0.00286575548778 , -0.00143732026953 , 0.000854016907131 , -0.000498069057032 , -0.000275599577911 , -0.00185803725549 , 0.00378451621708 , 0.000666802378539 , 0.000778142265892 , -0.0026819569495 , 0.000900178964939 , -0.00169692829417 , -0.00275068424911 , -0.000701691540805 , -0.00361320484451 , 0.00164573480431 , -0.0007538101818 , 0.000592096535545 , 8.0601855629e-05 , -0.000898946062473 , -0.000472767718178 , -0.00564962359283 , 0.00254510057947 , 0.00854928907349 , 0.00413166578972 , 0.000627008863028 , -0.00317271059541 , -0.00157842979301 , 0.00671614935395 , 4.20394054324e-05 , 0.00418494288434 , 0.000484184835756 , 0.000416214591157 , 0.00654150012256 , -1.62423339102e-05 , 0.00399981516754 , 0.00486206289232 , 0.000547051214673 , -0.000194271304911 , -0.00291467440092 , -5.41704855159e-05 , 0.00475628045834 , 6.68666187211e-05 , -0.00573880591394 , 0.00110381752643 , 0.00318710251896 , -3.11132421511e-06 , 0.000432188604592 , 0.000880118317018 , 0.00314271760047 , -0.000510698720825 , -0.00482727268633 , -0.00120260234225 , 0.00320830219694 , -6.29089377145e-05 , 0.00206347087785 , -0.00169621338413 , 0.00208961285923 , -0.00377715931803 , -0.00406818647037 , 0.000224927417013 , -0.00182780957098 , -0.00522501170293 , -0.000928288886321 , -0.00760775945371 , 0.00143599149597 , -0.00288269479674 , 0.000794062158759 , 0.00208441972015 , 0.000626795568152 , 0.00219701911956 , -0.00207775959961 , -0.00114109647726 , 0.00236586607877 , -0.00178125630769 , 0.000343022103704 , 0.00371192753223 , 0.00382060040508 , 0.00175878549817 , -0.00203765106078 , 0.00377327400615 , -0.00182216325779 , -0.00500700181422 , 0.00259970313375 , -0.000663108129002 , -0.00110329154131 , 0.00239793930132 , 0.00365567189942 , -0.000338722336802 , -0.00587295677087 , 0.0008878160326 , -0.00218672133704 , -0.00309089425139 , -0.000426948414122 , 0.000603999387641 , 0.001630384684 , 0.000944202329045 , 0.00696870758939 , 0.00168053279717 , 0.00312292079246 , -0.00494800542562 , 0.00727612851834 , 0.00281129485332 , -0.0008958393236 , 0.00192691971723 , 0.00348680528569 , 0.0021775649856 , 0.00184759013891 , -0.00208700765117 , 0.003967209493 , 0.00217617297367 , -0.00338019047212 , 0.00306329765493 , -0.000297352986697 , 0.00126071509227 , 0.00487057250654 , -0.00064541116898 , 0.00308450677158 , -0.00361886103618 , 0.000834896029546 , 0.00157926093563 , 4.35589128758e-05 , 0.00140525161108 , -0.00117659785352 , 0.000155914107251 , -0.00110576741064 , 0.00110345839486 , -0.00552758573721 , -0.000153325181715 , 0.0013905554574 , 0.00320677183247 , -0.00258431406628 , -0.00351972259447 , 0.00312011152253 , 2.02478925673e-05 , -0.00579382621034 , 0.00106482367932 , 0.00123579983825 , -0.00146226188301 , -0.00572861447371 , -0.00504050510614 , 0.00318030349436 , -0.000790955855028 , 0.00238423663123 , 0.00083944015228 , 0.000607280260658 , 0.000365558298688 , 0.000221205673914 , 0.000920334296782 , -0.00839255550106 , 0.00368083414286 , 0.00647767636773 , -0.00277163327161 , 0.001099651445 , -0.00126102944992 , -0.00190643726014 , 0.00108918129437 , -0.00149649557042 , 0.00270470045591 , 0.000252830909636 , -0.000962622231945 , 0.00253454958324 , 0.00187148675697 , 0.000263387383625 , -0.000948027625615 , -0.00438762202304 , -0.00195069739005 , -0.00340415830529 , 0.00186394742268 , -0.00299005722973 , 0.000992881000792 , 0.0010569921477 , 0.00288529877112 , -0.00219092393048 , 0.00074669765532 , -0.000857180927771 , -0.000844723121708 , 0.00163284212464 , 0.00367044986262 , 0.00010167320419 , -0.00298025983044 , 0.00566362228872 , 0.00151391151757 , -0.00284847687417 , 0.000642318627355 , 0.00342350675857 , -0.00783192138973 , 0.00199366052383 , -0.00117861106098 , 0.00601047561659 , -0.00323223206232 , -0.00112102171697 , -0.000155671530491 , -0.00180904318715 , -0.00222064347204 , -0.00190334849923 , -0.000117504600178 , -0.00262768890336 , -0.000368555307308 , -0.000496088884738 , -0.0019575241054 , -0.00212533875509 , 0.00371560275456 , -0.00265980075726 , 0.00430157378125 , -0.00430013186502 , 0.000403408087003 , -0.00120984705007 , 0.00340944996707 , -0.00419118617592 , -0.00478610716594 , -0.000341760283731 , -0.00582616994126 , 0.00220570247167 , 0.000552998334484 , -0.00399953824782 , 0.00576692854532 , -0.00038374702842 , -0.00210532697498 , -0.00526388134448 , 0.0029585090272 , 3.74281464159e-05 , -0.000600179648544 , 0.00161577555319 , 0.00598957921897 , 0.000632668901716 , 0.000809210077756 , -0.00167096124878 , 0.00237586238751 , 0.000940479063309 , -0.00443373016167 , 2.51689047587e-06 , 0.000160236410259 , 0.000173888163578 , -0.00183040192546 , 0.00394895148951 , -0.00271489522077 , 0.000889336826251 , -0.00173523195111 , 0.00116112423083 , 0.00231981309717 , -0.00346613888224 , 0.00380352580742 , -0.000899627278057 , 0.00222726364422 , -0.00241497933511 , 0.00106409825851 , 0.00529664970487 , -4.19287061006e-05 , 1.75595953472e-05 , -0.002066082643 , -0.000706494469023 , 5.01885609386e-05 , -0.00477598156341 , -0.00304837087311 , -0.0070048065924 , -0.00319528925889 , 0.0014124157336 , -0.00142575327574 , 0.002044948479 , -0.00465601227821 , 0.00217227322206 , -0.00115920116572 , -0.00391454655522 , 0.00133353382783 , 0.00442870429774 , -0.000983345017674 , -0.000493077417053 , 0.00280441665364 , -0.00713292363701 , 0.00150536374554 , 0.00129446995304 , -0.0037033164032 , -0.000670653598186 , -0.00034783844533 , 0.00424466370744 , -0.000775294379061 , 0.00156506453389 , -0.00102638331951 , 0.000154748385238 , 0.000891427129702 , 0.00381587487109 , 0.00049242268901 , 0.00204732038787 , 0.00430991706459 , 0.00435455945001 , -0.00269599654281 , 3.24088492712e-05 , 0.00306896257385 , 0.00114079387028 , 0.00065418587645 , -0.00318865120459 , -0.00125222325276 , 0.00176989294608 , 0.00219460492762 , 0.000574464342542 , 0.00119452135921 , -0.000302911503524 , 5.58907758032e-05 , -0.00427640477433 , 0.00367937406749 , -0.00112064513863 , 0.00263642325785 , 0.000334994715958 , 0.0010985274443 , 0.00391380018592 , -0.00164096004979 , 0.00248052540425 , 0.00243408087726 , -0.00176013158285 , 0.000353818921788 , -0.00213516534178 , 0.00235040498074 , -0.00381024745719 , -0.000489371706616 , -0.00131152658906 , 0.000674475073014 , -0.00305686137968 , 0.00195145804304 , -1.49719632751e-05 , -0.00171686320794 , -0.000259200448718 , -0.00287745596888 , -5.48524636217e-05 , 0.00364250133787 , 0.00110845742473 , 0.000754754994729 , -0.000983583756855 , 0.00323953984079 , -0.00101548890639 , 0.00354562119822 , -0.00125086735591 , -0.000350417464582 , -0.00117467628749 , -0.000176949545785 , -0.00476521215042 , 0.00367225991784 , 0.000904834688098 , -0.00205575784895 , 0.00554135812786 , -0.00569841931399 , -0.000417932715547 , ])
Y_3_0_real = flex.double( [ 0.00781729335669 , 0.00153840081425 , -0.000842373013577 , 1.10174267829e-05 , -0.00469371204585 , -0.0038601488609 , -5.32689167764e-05 , -0.00352111041006 , 0.00412439667915 , 0.00194064633214 , 0.00430404387913 , -0.00563352068221 , -0.00475748005446 , 0.00181833797653 , 0.00532915536482 , 0.00199229392832 , -0.0067816652406 , 0.00950169198084 , 0.00285224266991 , -0.00830250476174 , 0.00256864030228 , -0.000560156228922 , 0.000624851794373 , -0.0047410476235 , -0.00338207575241 , 0.00161598831614 , 0.00135427081961 , 0.00285427771721 , -0.00277081965873 , 0.00942414962747 , 0.0143596501425 , -0.00503569748663 , -9.0529994781e-06 , 0.00489250948698 , -0.00137435699704 , 0.00453406384504 , 0.00260628123125 , 0.000581502294052 , 0.000425953022962 , -0.00225854069728 , 0.000131210738299 , -0.0046165457121 , -0.00279841786624 , 0.00370556906663 , 0.00365389385632 , 0.00473748502149 , 0.00438993247016 , 0.00368724342613 , -0.00469396421702 , -0.00169665669804 , -0.00163258653965 , 0.00328429455181 , 0.00610564004054 , -1.71312850459e-05 , -0.00547408972357 , 0.00169865633553 , -0.00457076113171 , -0.00265921721369 , -0.00153263385143 , -0.000332172530103 , -0.00158941633019 , 0.000118649555873 , 0.00638385814815 , -0.00272459297226 , 0.000626074452833 , -0.000242048440519 , 0.0035448137651 , -0.00559371965567 , -0.0015904020128 , 0.00309234570994 , 0.00457708950074 , 0.00175911408348 , -0.000873136575903 , -0.00170131065806 , 0.00810048984745 , -0.00306921597362 , -0.00243399141975 , -0.00575208893851 , -0.000640757476332 , -0.000565456748239 , -0.00363481932288 , -0.00591090812748 , 0.00525428389323 , 0.00389856510914 , -0.00160197309469 , -0.00478026380574 , -0.0106261713579 , 0.00247808826539 , 0.00362447622724 , 0.00308619488901 , 0.00337266024815 , -0.00647218497828 , 0.000260216408573 , 0.000172083863348 , -0.00173967478248 , -0.00381865642729 , 0.0115227995621 , 0.00130523882823 , 0.00309760382207 , 0.000917968141296 , -0.0031823215758 , 0.00323259141402 , -0.00284132751422 , 0.000361597716915 , 0.000601917297384 , 0.00628529670402 , 0.00273735254802 , 0.00156229606728 , -0.00558400575402 , -0.00887974946847 , -0.00645121295603 , 0.00166123412497 , 0.00101782367868 , 0.0151783604076 , 0.00743005304083 , -0.00252227594511 , -0.00489093423492 , 0.00389722480266 , 0.00238723147346 , 0.00100564324693 , -0.0023127721045 , 0.00134661941061 , 0.00466860305379 , 0.000570404735791 , 0.00375939080795 , -0.00261953004134 , 0.00340304672496 , -0.0055179640221 , -0.00250442683437 , -0.00016670337491 , -0.00552631348381 , -0.00557062592966 , 0.000657113906036 , 0.00438365760906 , -0.00575398648478 , -0.00513793934563 , 0.00257698770096 , 0.00217356338292 , -0.00534776871486 , -0.00291586729199 , 0.00353924741484 , -0.00179638051963 , 0.00356871451614 , -0.00357676278301 , -5.75702622884e-05 , 0.00450855409628 , 0.00355303958139 , 0.00313123054192 , -0.00202412393071 , -0.00372905914882 , 0.00674227048097 , -0.00121621839814 , -0.000187752174815 , -0.00204469462676 , -0.00239037371905 , 0.0031927543753 , -0.00246349834316 , 0.002910580926 , -0.00288985999604 , 0.00309241949909 , 0.00417587044216 , -0.00877993171347 , -0.00859017805226 , -0.000130246667309 , -0.000125572221021 , -0.00499263880151 , -0.000657140804808 , 0.00280555213097 , 0.00577792010416 , -0.00463305825714 , -0.00380978361299 , -3.537557779e-05 , 0.00372306208967 , 0.00301932507331 , 0.00292417453148 , 0.00234334032523 , -0.00645255640525 , 0.0031092112944 , -0.00276820566997 , 0.00465332226767 , -0.000448831830952 , 0.00447792338854 , -0.00584613364999 , -0.000240649872336 , -9.86125270614e-05 , -0.00543647687739 , 0.000904555400945 , 0.00498989417979 , -0.0044866055625 , 0.011787947964 , 0.0035330471448 , -0.0017369925326 , -0.00158911553504 , 0.00420903203126 , 0.0042530927395 , 0.0016690837255 , 0.00177283095868 , -0.000313138646201 , 0.00116259088694 , -0.00376921028589 , -0.00487229609997 , -0.00195892481114 , 0.00436922230214 , 0.00441107379217 , -0.00506943399147 , 0.00423791605467 , -0.00311226158175 , 0.00341554939401 , 0.00516682615516 , -0.00324750311597 , 0.00141327665268 , 0.00335981545801 , 0.0010321971133 , -0.00441994985325 , -0.00431378858234 , 0.00529455130867 , 0.00425774185486 , -0.00304728867502 , 0.00285949916618 , -0.000953597702441 , 0.00313490257585 , 0.00128341806848 , -0.00377368324649 , 0.00207062840336 , 0.0048763948553 , -0.00337816090438 , 0.00369655089982 , 0.000300660032975 , 0.00162179022982 , -0.00308469522034 , -0.00544440726834 , -0.00682054143521 , -0.0018899161359 , -0.00475555883654 , 0.00181027308195 , -0.00189823782982 , 0.000342541877843 , -0.00396132915211 , -0.000874826844546 , 0.00221410626865 , 0.00312725982971 , 0.000650194674272 , 0.00596597514891 , 0.00130588706765 , -0.00272593386824 , -0.00210990468408 , -0.00448901792329 , 0.00403882177139 , 0.00383777409892 , -0.00107118699688 , 0.00115674104428 , -0.00206244932807 , 0.00621525619229 , 0.00375709495336 , 0.00188164748534 , -0.00401349456758 , -0.00156709791334 , 0.000408285963112 , -0.00295108273636 , 0.00277356534528 , -0.000398545543112 , -0.00208147863251 , -0.00336423087068 , -0.00485708815516 , -0.00399690144685 , -0.00602910674675 , -0.00439383021628 , 0.000172036090055 , 0.000567211272961 , -0.00522688717825 , 0.00141158673783 , -0.00284104206509 , 0.0028905981114 , 0.00414320236373 , -0.00501775973363 , -0.00198906668834 , -0.000784475982112 , -0.00485614175262 , 0.00382639344075 , 0.00278807234563 , 0.00592504352694 , 0.00186392039642 , 0.00437905889113 , 0.00247921806838 , -0.00190471915007 , 0.00515370866717 , -0.00218813116153 , -0.000430012847954 , -0.00678693121391 , -0.00236713117246 , 0.00325881806358 , -0.00171817015819 , 0.000695849193113 , -0.00537202802202 , 0.00512493781618 , 0.00242998506214 , -0.00228040945709 , -0.00171861461169 , -0.00497645480293 , -0.0019554469483 , 0.00465482207054 , -0.00100590226568 , -0.002108586742 , 0.00484284679893 , -0.000781834187625 , -0.00292523628857 , -0.00318177195785 , 0.00321435256093 , 0.00491470271384 , 0.00178042726609 , 0.00625991071159 , 0.00248914039622 , 0.00431144871089 , 0.00253986201356 , -0.00246251208107 , 0.00384681873708 , 0.00272428910103 , -0.00318269297915 , -0.00118698883993 , 0.00502232462824 , 0.0057053591732 , -0.00889050845845 , -0.00549269239819 , -0.00110046865005 , -0.00399512070631 , -0.00188590065147 , 0.00208856410295 , -0.00162745930284 , 0.00218752528085 , -0.00366528143348 , -0.0111120368676 , 0.0031797463617 , -0.00197923034907 , -0.00599904005705 , -0.0023939037208 , -0.00147924246004 , 0.00447440499318 , -0.00143688082768 , 0.0020885208255 , -3.62195109165e-05 , -0.000590833223242 , -0.0080233123467 , -0.000741237053838 , 0.000289760262141 , -0.00183697720298 , 3.95919504993e-05 , -0.00502784463063 , 0.00758905875573 , 0.00627617204679 , 0.003188593318 , 0.00412103739899 , -0.00555492670154 , -0.00311996200052 , 0.00391847489494 , -0.00481933063446 , 0.00152935681005 , -0.00464758756327 , 0.00521714613244 , 0.0047015804918 , -0.00298393329409 , -0.00465333150841 , 0.0169222333266 , 0.00595360374942 , 0.00225681731593 , -0.00149327095598 , 0.00362631097698 , -0.00153191832472 , 0.00115483180351 , 0.00206288497581 , 0.00535251533023 , -0.000636608504434 , -0.00566622269168 , -0.0031611969449 , -0.00356022095757 , -0.00382623707837 , -0.0059826738202 , 0.00329510560072 , 0.00456612568634 , -0.00127747787826 , -0.00378590626084 , -0.00127296343171 , 0.00304459940561 , 0.00368564787936 , 0.00552839693866 , -0.00299569297776 , -0.00604800071662 , 0.00152365061137 , -0.00308608054327 , 0.00195160320242 , 0.00284229405993 , 0.00413386428368 , 0.00519443587781 , 0.00353505739533 , -0.00329703502115 , 0.00505104069537 , 0.00474435480607 , 0.00157400332198 , -0.00230942668955 , 0.00113186575366 , -0.0039070458873 , -0.00087666505044 , 0.00459729372309 , -0.00467422361578 , -0.00388779760952 , -0.0039867364647 , -0.000711696221115 , -0.00710373863649 , -0.00327928902799 , -0.00269445932752 , 0.00297204613579 , 0.00103998767747 , -0.00423547235813 , 0.00493661267411 , -0.00437031489556 , 0.00537058942628 , 0.00248037442254 , -0.00450706253472 , -0.00289195061092 , -2.8735398323e-05 , 0.00154326991857 , 0.00461664841583 , -0.00664918270793 , 0.00495264235527 , 0.00393686550177 , -0.00692353757323 , -0.00437480828878 , 0.00242108612848 , 0.00386480190273 , -0.000517439146311 , -0.00168112532888 , -0.00272245815806 , -0.000499409477762 , 0.00445435874338 , -0.00309837653542 , -0.00569404057398 , -0.00401041011868 , -0.00316287257577 , -0.00836648696484 , -0.00218045228885 , 0.00592809777745 , 0.00489405350677 , 0.002731364871 , -0.00108617820482 , -0.00347019591432 , -0.00147260626821 , -0.00540799902562 , -0.00122284590516 , 0.00301634455903 , 0.00483852717522 , -0.0024054903824 , 0.00209560623602 , -0.00450014368227 , 0.00505164553454 , 0.00965456132799 , -0.000970405121706 , -0.0012259523322 , -0.0050536061951 , 0.0030550048911 , 0.0023271242894 , 0.00228554976203 , -0.000319918451408 , 0.000684326034103 , -0.00139795807554 , -0.00212526047188 , 0.00223957376559 , 0.00495322122725 , 0.0050578359487 , 0.00108790160567 , -0.00554824462918 , -0.0061763605733 , 0.00470831338991 , -0.00335829775214 , -0.00485069742759 , 0.00313120649617 , 0.00516209564979 , 0.00210984563789 , -0.00148331733721 , -0.00564767526345 , 0.000690945596935 , -0.00143662855857 , -0.00441242912083 , 0.00386226058043 , 0.00258185841247 , -0.00454128087948 , 0.00241681828201 , -0.00329954370244 , 0.0013215034048 , 0.00414675175954 , -0.00309162722894 , 0.00218585906396 , -0.00522082003402 , 0.00181433892856 , 0.00123332568607 , 0.00569953673798 , -0.00278826180303 , -0.000421584224583 , 0.0031591960903 , 0.00155675185531 , -0.00199858513773 , 0.00166928416297 , -0.000473352365179 , 0.00224914629993 , 0.00121820257814 , 0.00425212610815 , 0.00349785189659 , -0.00367970747424 , -0.00371020115617 , -0.00203558125169 , 0.00228456016095 , 0.000757600547643 , -0.0055123363851 , 0.000301307461664 , -0.00458159056986 , 0.00456955338883 , -0.00047237293749 , 0.00349645889843 , 0.00368976229047 , 0.00221877271729 , -0.00171119102017 , -0.00261953047653 , -0.00347555236351 , 0.00028078375406 , 0.00427793538752 , 0.00351103893988 , -0.00670413236717 , -0.000772147233248 , -0.00231531062198 , -0.00376003425526 , 0.00161243158254 , 0.00566935712912 , -0.00157847706608 , 0.000146463460271 , -0.00303461975167 , 0.000847263930781 , 0.00350425641709 , 0.00145502824139 , -0.00163741139838 , -0.00484843357958 , -0.00250273202268 , -0.00133895636822 , 0.000234432172465 , -0.00204180721224 , -0.00436787503962 , 0.00362108637593 , -0.000754567903152 , -9.68121967367e-05 , 0.00589937272965 , -0.0109141599015 , -0.00411456655605 , 0.00196529582052 , 0.0044250199139 , -0.0013088568139 , 0.0033167361361 , -0.0100341617601 , 0.00297171987479 , 0.00302662868185 , 0.001212934475 , 0.00316962964509 , -0.000369995720319 , 0.00244890519711 , -0.0004258604804 , 0.00334113568454 , -0.00162066527902 , 0.0128607201486 , 0.00344800278504 , 0.00436347148052 , 0.00506206659262 , -0.00265176222342 , -0.00445583534602 , -0.000590309646592 , -0.00418717963802 , 0.00375876824478 , -0.000172053021117 , 0.00158778446361 , -0.00504751647916 , 0.00326895707727 , -0.00561542073318 , -0.00251357527558 , 0.00312112901614 , 0.00560544859108 , 0.0039242233864 , 0.00660232636446 , 0.00132978575865 , -0.00550834905179 , 0.00166173907301 , -0.00537566684674 , -0.00256683339305 , -0.00296562742569 , 0.00492268031387 , 0.00340719373017 , -0.00225335320448 , 5.86408353311e-05 , -0.0037327701753 , -0.000101357582822 , -0.00199966031137 , -0.00629565675352 , 0.00561963099857 , -0.000169069333878 , 0.00247244912002 , -0.00459598717119 , 0.00528194733571 , 0.00351355813428 , 0.00494132994466 , -0.000673328047646 , 0.00514366824097 , 0.00604820202079 , -0.00632555251352 , -0.00239563568567 , 0.00354600673116 , 0.00748301334149 , -0.00535874233375 , 0.00106404067297 , -0.00179760543614 , -0.00332505721087 , -0.00257163128752 , 0.00423464614487 , -0.00327978679788 , -0.00555278983285 , -0.00514387825165 , -0.00526992872955 , 0.00127016516032 , -0.001048842696 , 0.00650135972362 , 0.00573299874031 , 0.00531866087616 , -0.00519563751769 , 0.001868569947 , -0.00206152729826 , 0.00446713238924 , -0.00797610517848 , -0.00251668236733 , -0.00202984787788 , -0.00412645226504 , -9.88364913624e-05 , -0.00433610261917 , 0.00149263780756 , 0.00382692317148 , 0.00339795204477 , -0.00348189213273 , 0.00487590670789 , -0.00152914916872 , 0.00308227123115 , 0.000696667648822 , -0.00927767339194 , 0.00428875721724 , 0.00361695102454 , 0.00422535252658 , -0.00352752982178 , 0.00381588925376 , -0.00769976666589 , 0.00354843797397 , 0.00408651636958 , 0.00594054534719 , -0.00160968927905 , -0.00395921044163 , -0.00743763547084 , -0.00281539619228 , 0.000373688431687 , -0.00310844169781 , -0.000562369661789 , -0.00855119237784 , -0.000850106672236 , 0.000816642431935 , 0.00175777336823 , -0.00103468610708 , 0.000628251426605 , -0.00317335655514 , -0.0066002684314 , 0.00894970742035 , -0.000620166187599 , -0.000485076569732 , -0.000212383758619 , -0.00218744333061 , 0.000743244645954 , -0.00518645262338 , -0.0032841694168 , -0.00110246319822 , -0.00707007616185 , 0.00308031944651 , 0.00438713054565 , 0.00338207525407 , -0.00561965639297 , -0.00309921572921 , 0.00148473629788 , 0.00532585583521 , -0.00014206509115 , -0.0029030882789 , -0.00585708301999 , 0.00209701833857 , -0.00170679054183 , 0.000487260054728 , -4.78377755884e-05 , -0.00118759969933 , -0.00564741434564 , 0.00212329304923 , 0.00104716118015 , 0.00473953907055 , -0.00291708932271 , 0.00213565897267 , 0.00298045760201 , 0.00206678847712 , 0.00452409994491 , -0.00355579498855 , 0.0039475817199 , -0.00290468052956 , 0.00339523426209 , -0.000200601248303 , -0.000278013155151 , 0.00135088206471 , -0.000104677976266 , -0.00131792081092 , -0.00373219202642 , 0.00433405777023 , -0.00338741602698 , -0.0022052959434 , 0.000660377159509 , 0.00249305288323 , -0.0065270895151 , 0.00490552837287 , 0.00352646773709 , 0.00363475297819 , 0.00413326174605 , 0.00432398977789 , -0.00183179024704 , -0.00109310587246 , 0.00392330893845 , 0.00323656286272 , -0.00330454523498 , -0.00770981006619 , 0.00398119017563 , -0.00867411522636 , 0.00336698064164 , -0.00220066631162 , 0.00365989359564 , -8.72794556465e-05 , -0.00102357086725 , -0.00367092790803 , 0.00466749572417 , 0.0173198697885 , 0.000173498167886 , 0.00528406972091 , 0.00124006008947 , -0.000808524805763 , -1.13948170367e-05 , -0.00618884035247 , 0.00246368446362 , 0.000388442537519 , 0.00865715118173 , 0.000178808247267 , 0.00271787975626 , -0.0032700046402 , -7.88995243442e-05 , 0.00245487715513 , -0.0113565865985 , -0.00345771335274 , -0.00695425502055 , 0.0016499910344 , 0.00399046925161 , 0.0029701271737 , 0.0025686048435 , 0.0204714600898 , 0.00506409678323 , 0.0028826244946 , -0.000295979798123 , 0.00409469294102 , -0.00592141676416 , 0.0014640634476 , 0.00468801493984 , -0.0043834175088 , -0.00215682800236 , 0.00279846463641 , 0.00508796560406 , -0.00171851128 , -0.00567170470688 , -0.00312272319686 , 0.003815418675 , 0.00159911917644 , 0.00179696663491 , 0.00746764216378 , -0.00356497989766 , 0.00420931722693 , 0.0107579205157 , -0.00246063083978 , -0.00984193880127 , -0.00203626375508 , -0.00235693444856 , 0.0037644940258 , -0.00386152814427 , -0.00310854037177 , -0.00473636597993 , -0.00206621795276 , -0.00509228119094 , -0.00206731455935 , -0.00288619072822 , 0.00303696568451 , -0.00207167476379 , 0.00242714416769 , -0.000256596953823 , -0.00299201972588 , 0.00947205107677 , 0.000692003754948 , -0.00540885216682 , -0.00455308416113 , 0.000703026648324 , 0.00227651616031 , 0.00721184423767 , -0.00267688613151 , 0.00364342050127 , 0.00187739170506 , 0.00377522141793 , -0.00492013404383 , 0.00298697725132 , 0.000870594161293 , 0.00134700356411 , -0.00840537875056 , -0.0034098775619 , 0.00285335779401 , -0.000423640567608 , -0.00192561438462 , -0.00170827098142 , 0.000922611478213 , -0.0035602689585 , 0.00222495045235 , -0.00725733390718 , 0.000105085075208 , 0.00220615288451 , -0.00545873787631 , -0.00295924356118 , -0.00429833149092 , -0.00233652874314 , -0.00247726276355 , -0.00170277570319 , 0.00550720651948 , -0.00552481812096 , -0.00308335534926 , -0.00392181918994 , 0.00461857476545 , -0.00427595709523 , -0.00592828991409 , -0.00669405353064 , 0.00478229390599 , 0.00120853664211 , 0.00142524683083 , 0.00133066304043 , 0.00222327277943 , 0.00251565981357 , -0.0092670825223 , 0.00568610781067 , -0.00646853672439 , 0.00097269052597 , -0.00195202052984 , 0.00642888017807 , 0.00179852545368 , 0.000362804779852 , -0.0052265303339 , -0.00466764780315 , -0.000783788337191 , -0.00263556092014 , -0.00351672565122 , -0.00358670598291 , -0.00156083403532 , 0.00922297179338 , 0.00470697475623 , -3.08095465029e-05 , 0.00516401575315 , 0.00222995412354 , -0.000224108693123 , -0.0013375547137 , 0.000406297387481 , -0.0026377908927 , -0.00638934594302 , 0.00181181256698 , 0.0131031909365 , 0.0051113922892 , -0.00361225317995 , -0.00168213617157 , 0.00351083049266 , -0.000510292083663 , 0.00457702827164 , -0.00149462462863 , 0.000215981888144 , -0.00597476749153 , -0.0113801220009 , -0.00293700429893 , 0.00252043124047 , 0.00296395117961 , -0.00190374679695 , -0.000459830413425 , -0.00422736268873 , -0.00418319585978 , 0.00410386036073 , 0.00320667055443 , -0.00311540007482 , 0.000110232531933 , 0.00340157903866 , 0.00190704347795 , -0.00511565681394 , -0.00349376239332 , -0.00485322463235 , -0.00249453897436 , ])
Y_3_0_imag = flex.double( [ 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , ])
Y_3_1_real = flex.double( [ 0.0 , 0.00557867096023 , -0.00449852182561 , 0.00427891183249 , 0.00115802366625 , 0.00128653291041 , -0.00243307969334 , -0.00283999380242 , 0.00364998103069 , -0.00116363032057 , 0.00108650977643 , 0.00166181849267 , 0.00331911397076 , -0.00113032218881 , -0.00561551312465 , 0.00161564022384 , -0.000186880471311 , 0.0101775959554 , -0.000515908923305 , 0.00511351453064 , -0.00457922550907 , 0.00329338598311 , 0.00154007356011 , 0.00159605527977 , 0.0051236493687 , 0.00892042308254 , -0.0047937922593 , -0.000146449253767 , 0.000410660997725 , -0.00304015130649 , 0.00524514102532 , 3.29248845506e-05 , -0.000202258071064 , -0.000153459908214 , -0.00108372967846 , 0.00138490451221 , 0.00407719666253 , 0.000274279607178 , -0.000522103671652 , 0.00186784356452 , -0.0033995375856 , -0.00127851455377 , -0.00169172597198 , -0.00179812152136 , -0.000410513728788 , 0.000997836874597 , 5.07609887687e-05 , -0.00287394332995 , -0.00108896388113 , 0.00160894435508 , 8.18015311767e-06 , 0.00282420759622 , -0.000870719935006 , 0.000486038588895 , 0.000555440214067 , 6.16060994164e-05 , 0.00411262405819 , -0.00334502334123 , 0.0071574542741 , 0.00242619164876 , 0.00495550531351 , -0.00455566018051 , -0.00423428528963 , -0.000560096609367 , 0.00497922524966 , 0.00235653619095 , -0.00144217945674 , 0.0029999716846 , 0.000237446429011 , 0.00206068505141 , -0.000523191291795 , -0.00225235671628 , -0.00466552477621 , -0.00395010663651 , 0.000523633930049 , -0.00297746333666 , -0.000599898474111 , -0.00221890799727 , -0.000158204506183 , 0.00301571551428 , -0.00514919067784 , 0.00192078875667 , 0.000783474676708 , -0.00106526072166 , -0.00400438465914 , -0.0011927437151 , 0.000922779373511 , 0.00117418293483 , -0.00519652591471 , 0.0029922847885 , 0.00293106947942 , 0.00371616097776 , 0.00229884055544 , 0.000344639319805 , 0.00198461916381 , -0.000107622336651 , 0.00270193138048 , 0.00191243744929 , 0.00012402449928 , -0.00469515327857 , -0.00172366274243 , -0.000685790690833 , -0.000612454434263 , -0.00357021388094 , -0.00347717929986 , 0.000261850144596 , -0.000439029046231 , 0.000609756537774 , -0.000865172409473 , 0.00228155839721 , -0.00476544397768 , -0.00390687158684 , -0.00253963455718 , -0.0017407583777 , -0.00456439978906 , 0.00118181801467 , -0.000576279471424 , 0.000435103264885 , -0.00083174541681 , -0.0050766814377 , 0.00246049607016 , 9.43951323349e-05 , 0.00259366771994 , 0.00315706604822 , 0.00206576022513 , -0.00321406049072 , 0.00407050213605 , -0.00250770386467 , -0.00260374972398 , 0.00160282031038 , 0.00182289165712 , -0.00151565291622 , -0.000116628635295 , -0.00395979565426 , -0.000169414466093 , 4.89071252328e-05 , 0.0020485324341 , -0.00278572869653 , -0.000236685143928 , -0.000544162782373 , 0.00280745386627 , 0.00115626565756 , 0.00100090366569 , 0.00566049976573 , 0.00569221171892 , -0.00140498376424 , -0.00156875777919 , -0.0026163692602 , 1.65099557191e-05 , 0.000572345497623 , -0.00132957538691 , -0.000948382727533 , -0.000866112951159 , -0.000340841769225 , -0.00258771613105 , 0.000236859420041 , 0.00258557991141 , 0.00225591373569 , -0.00242744871931 , 0.000249552400421 , 0.000275136083753 , -0.00147872162266 , -0.00553156730361 , -0.00224907601363 , 0.00148351297264 , -0.000397865770828 , 0.0029866689747 , 0.00262859573945 , 0.000470431381814 , -0.00628500838354 , 0.00249230592515 , -6.6888412965e-05 , 0.000518176397202 , 0.000207164100023 , -0.00198392691738 , 0.00568413093164 , -0.000651588995363 , 0.00442303338653 , -0.000268828011078 , 0.000711689091756 , -0.00237118102837 , -0.00021777232668 , -0.00100487527736 , -0.00624640373813 , 0.00353823364009 , -0.00510576694523 , -0.00610264936438 , 0.00148060268259 , -0.00183642506078 , -0.00221221844314 , 0.000531189306831 , 0.00148745790407 , -0.00114973073557 , -0.00232563947403 , -0.00263981498279 , 0.00184024459675 , 0.00107134294966 , -0.00254325525306 , 0.00108480174627 , 0.00402646660828 , -0.000235727323981 , -0.00328588331246 , 0.00196419121423 , -0.000536491624836 , 0.00691076689973 , -0.00165470608728 , -5.46147142599e-05 , 0.000910495073814 , -0.00292567132545 , 0.00554138656041 , 0.00426732492113 , -0.000561275456356 , 0.0010648703714 , -0.000504333241139 , -0.000154624331138 , 0.00116176882043 , -0.00128100675673 , -0.000395624946025 , -0.000175212836182 , -0.00694235146618 , 0.00360086580871 , 0.00393341599842 , -0.00452379490136 , 0.00347001618551 , 0.000311419348246 , 5.06013382286e-05 , 0.00122287357524 , -0.00507415735575 , 0.000496250594539 , -0.000609164572701 , 0.000560624429441 , -0.000351324199086 , -0.00358866458737 , -0.000252950822281 , -0.00450507979938 , -0.000463880186352 , 0.000593670337333 , -0.00132344286271 , 0.000461754056902 , -0.00282174189997 , 0.000862314698224 , -0.00291515793355 , -0.000609904080794 , -0.000697094824391 , 8.75934538665e-05 , 0.00019428995565 , -0.00286977886049 , 0.00304491631048 , 0.000380788675995 , 0.00158937113985 , -0.00417826134842 , 1.8975258124e-05 , -0.00583183912864 , 0.00257184324917 , -0.00329107730235 , 0.00314713935069 , -0.00462720013007 , -0.000516546683329 , -0.00171177397946 , 0.00101446923362 , 0.00187260152738 , 0.0044386209376 , 1.03951650049e-05 , 0.000466964538986 , 0.000554656580301 , 0.000107302278404 , -0.00350466018842 , 0.00104968725948 , 0.00366697304596 , 0.0017407144768 , -0.00293107386697 , 0.000974283570023 , -0.000211585156836 , 0.00198710290125 , -0.00277582264919 , -0.00184387157654 , -0.00350530690194 , 0.00240587260888 , -0.00272511287359 , -0.000916244357418 , 0.000508299446361 , -0.00251753699041 , 0.00390205329495 , -0.00229890132327 , 0.00133033075161 , -0.00186444623108 , -0.00607311533248 , -0.00170598444001 , 0.000691094475221 , -0.00169023370458 , -0.00221052759578 , -0.00242070914385 , -0.0036673253169 , 0.000747957227811 , 0.000182609974903 , -0.00383655993701 , 0.00399225785518 , -0.00254960711637 , -0.00158548461578 , 0.00278838426995 , -0.000194174768498 , 6.04665249689e-05 , 0.00236569193753 , -0.00145994369299 , 0.0040349960449 , -0.00490542209937 , -0.00171733284452 , -0.00662375320912 , -0.000672883031427 , -0.000453454874636 , -0.000288357629028 , -0.00122003199079 , -0.00257337941669 , -0.000847668197467 , -0.00127948736052 , -1.04470246664e-05 , 0.000595499166415 , 0.000137984325086 , -0.00188340875257 , 0.000832493507045 , 5.0102523146e-05 , 0.0010149077317 , 0.00240184313924 , -0.000703110756981 , 0.00656492814879 , 0.00245094074005 , 0.00350173111318 , -0.000274017728105 , 0.00992501771859 , 0.00524677675415 , 0.00107999468976 , -7.00168374654e-05 , -0.00159045693838 , 0.00473269085766 , -0.00186451235403 , -0.00051217278065 , -0.000422850068233 , -0.000122648733455 , 0.00437330862647 , 0.00569536153119 , 0.000183637842677 , -0.00318163058276 , -0.00284611276168 , 0.00338837929297 , 0.000503890067503 , 0.000218248174323 , -7.47182532523e-05 , 0.00142484069405 , -6.751075801e-05 , 0.00850504184757 , 0.0027014522237 , -3.07382824189e-05 , -0.000194479182915 , 0.00149917899414 , -0.00161498722184 , -0.00417860898928 , 0.000768001371203 , 0.000772000097917 , -0.00140781199248 , 0.00216338864606 , 0.00261208967294 , 0.0084709427185 , -0.000447947177951 , -0.00304849663684 , -0.00360220804237 , -0.00455939164533 , -0.00165424487269 , 0.00012298992688 , 0.00198657601051 , 0.000611331290573 , 0.00341846299422 , 0.00136859898953 , 0.00133530935658 , 0.00201899901612 , -0.00168533384046 , 0.000403370320719 , -0.000347702783908 , 0.00189055152444 , 0.000261075871309 , -0.00358438208333 , 0.00262243198598 , -0.000116522950212 , -0.000986491008261 , 1.77878654412e-05 , 0.00561667353559 , 0.00223584270518 , 0.00166336738545 , -0.000950987660615 , -0.000222646714598 , 0.00321887261732 , 6.16976857826e-05 , -0.000230200850506 , 0.00333730868864 , -0.00460005994739 , 0.0060049615089 , -0.0025082172965 , -0.000606618532567 , 0.00366122302866 , -0.00148436061031 , 0.00127095233787 , 0.000913884186385 , 0.00327597569176 , -0.00502049570674 , 0.00257701326205 , -0.000269407640726 , 0.00553692185978 , -0.00329203612465 , -0.00418117258188 , -0.00120073505573 , -0.00199437136621 , 0.00263210861777 , 0.000800452368598 , 0.000100032366479 , -0.000194370044066 , -0.00452091904837 , 0.00548408128308 , 0.00190747460594 , 0.00413257391273 , -0.00278576641329 , 0.00356264025687 , -0.00190275865417 , -0.000129165907983 , 0.00199497694716 , -0.000164688901776 , -1.15742322835e-05 , 8.86872028229e-05 , -0.00420820818748 , 6.36417021765e-05 , 0.00414934121155 , -0.00174066475679 , -0.00132561111207 , 0.00338121336354 , -0.000502164355036 , 0.00142887868697 , 0.000394925339472 , 0.000680739852424 , -0.00317230194733 , 0.00273924936882 , 0.00464770976592 , 0.00502540841087 , -0.00299913824349 , -0.00368572078775 , -0.00346411946752 , 0.00269366832561 , 0.00194448550691 , 0.0010129583193 , -0.000326447653159 , 0.000988336771784 , 0.000179168130394 , -0.00548487024888 , -0.00168560798026 , 0.00266706681342 , 0.000846143913678 , -0.00762339138771 , -0.00293422767046 , 0.00120508076893 , 0.00362296568901 , -0.00265257471404 , 0.000915540569787 , -0.00450167827799 , 0.00304823248337 , -0.00215943953508 , -0.00676476230799 , -0.00616424114617 , 3.88356241951e-05 , -3.05952143241e-05 , 0.00157604054831 , -0.00463415739502 , 0.00555829349273 , 0.00049974420894 , -0.0081363550428 , -0.00304271219567 , 0.00248690859637 , 0.00188516415499 , -0.00213699936048 , -0.00373729363561 , 0.00141312704167 , -0.00169517883692 , 0.00573504043916 , 0.00204032309482 , -0.00118704812517 , 0.00205124694037 , 0.0048078770075 , 0.00114489079942 , 0.000752984850922 , 0.002314188306 , 0.0062294110676 , 0.00251898779423 , 0.00184646062841 , -0.00384802015308 , 0.00157195801493 , 0.000987350069093 , -0.00613554666831 , 0.000634767707831 , -9.43567022235e-05 , 0.00648844326212 , -0.000251806556927 , -0.00354978685479 , 0.00045826580316 , 0.00114462921514 , -0.00442110187576 , 0.00274624332061 , 0.00319789985661 , 0.000473847070526 , 5.9472527952e-05 , 0.000884772392283 , -0.000221573177369 , 0.000463710320599 , 0.000505541392976 , -0.000591525276965 , 0.000764352253409 , 0.00506890954729 , -0.00350012799593 , -0.000618096234675 , -0.00125335581655 , -0.00270351109311 , 0.00143306042112 , -0.00170606224081 , 0.00573209170193 , -0.00228890810668 , 0.00116157282126 , -0.00182169507604 , 0.000195062040993 , 0.00116129497291 , -0.00354168392793 , 0.000435486310457 , 0.00415402044314 , 0.000591979573504 , -0.00482138591179 , -0.00266323811254 , -2.29173215569e-05 , -0.00250767318092 , 0.000234134632268 , -0.0033029343442 , -0.000672323915356 , 0.00351484907029 , 0.00128264366102 , 0.00371801339127 , -0.0013978178538 , 0.00407623271472 , 0.00200608806128 , -0.000887316732444 , -0.000976740730976 , 0.00100424545459 , -0.000179138699899 , -0.00413376200352 , -0.00203094630242 , -0.00045640355249 , -0.00242128111631 , 0.00148146691876 , -0.001850162486 , 0.00521496667424 , -0.000433703368625 , 0.0017868241807 , 0.0039316615066 , -6.70666955965e-05 , 0.00186317290375 , -0.00145985525473 , -0.00318318982346 , 0.00470397274704 , 0.000838415947872 , -0.00422236907885 , -0.0031903754421 , 0.00530680763047 , 0.00195735342773 , 0.00264931027449 , -0.000672897586102 , -0.00123396889882 , 0.000128474475657 , -0.00306019555325 , -0.00204732680301 , 0.00262610708538 , -0.00152600064317 , -0.00329166162606 , 0.00205719312095 , 0.00283437249916 , 6.20956324342e-05 , 0.000568299409729 , 0.000801617958123 , -0.0044170573429 , 0.000140685445961 , -0.00332428627214 , -0.00397840891915 , 0.00183206847127 , -0.000760916261404 , -0.00102713846835 , 0.00301505337773 , 9.81734359301e-05 , 0.00370803181643 , 5.58264325947e-05 , -0.00318107979608 , -0.0030360076429 , -0.00157693512927 , -0.00118944942996 , 0.00075184978207 , 0.00667376265208 , -0.00104720001044 , 0.000498982164108 , 0.00290687072284 , -0.00361173482988 , 6.46426820786e-05 , -0.000650873863916 , 0.000856649461267 , -0.00268883217473 , 4.85929115465e-05 , -0.000814970133361 , -0.000903672360239 , -0.00369169510593 , -0.000625076293004 , 0.00402479894315 , 0.0016254984687 , 0.00194134754862 , 0.00577697976841 , -0.00252442464483 , -0.00147003782748 , 0.000955010335928 , -0.00259841648576 , -0.000625980108759 , -0.000551467662357 , -0.00273625266427 , -0.00425918440915 , -0.00299667925386 , 0.0063811078461 , -0.00163781966607 , -0.00253167593103 , -0.000717917499616 , -0.00180145466822 , 0.000185288606121 , -0.000224879229386 , 0.000135986326415 , -0.00036032806705 , 0.00336604638176 , 0.00148254927165 , 0.00239343089594 , -0.00174783359394 , -0.00142588536547 , 0.00224331134011 , -0.00875934549084 , 0.000323504778315 , -0.00180934212917 , 0.00451888933123 , 0.00265070768441 , 0.00412307160128 , 0.00394301813753 , -0.000719252585372 , -0.0048827637821 , 0.0007843470085 , -0.00167047575189 , 0.00144845087969 , -0.00590606954902 , -0.000893075409512 , 0.00112058260769 , 0.000453429174798 , 0.00315876295249 , 0.0020398872139 , -0.00267362898658 , 0.00211743415651 , -0.00229943537509 , 0.00118848193579 , 0.000808068845136 , 0.00193857412658 , 0.000153717324037 , -0.00270305400454 , 0.00290659144584 , -0.00129475053489 , 0.000240117364734 , 0.00366802363098 , 0.00265220072016 , -0.00513862207143 , 0.00309314660176 , -0.00342187536156 , -0.00522441236837 , 5.64983514464e-05 , 0.000390888156207 , -0.00211985709952 , -0.00094176152927 , 0.00469210669253 , -8.63764810674e-06 , -0.00213929775268 , 0.000667079627999 , -0.00357364704294 , -0.000940091053421 , 0.000151934871828 , 0.00222000311846 , -0.00179677278806 , -0.00178438255759 , 0.000272047340006 , -0.00035431288676 , 0.00562911571281 , 0.00136899537619 , -0.0055336405032 , -0.000513755339764 , -3.71529212216e-06 , 6.11999116094e-05 , -0.00305063630294 , 0.0035801768892 , -6.15482177818e-05 , 0.000754103970243 , -0.00368022990889 , 0.00072179247918 , 0.00336505889528 , -0.0009364300379 , 0.00294583463397 , 0.00187109787341 , -0.00425196898969 , -0.000623749065945 , 0.00177987664432 , 0.005080566078 , 0.00161732145396 , -0.0048154576434 , 0.00195420903586 , -0.00167431258295 , -0.00360129182198 , -0.000330524415557 , -0.00425253141135 , -0.00540573533849 , -0.00407829306074 , -0.000124606311512 , 0.00173397013481 , -0.00315979711747 , 0.00136285453578 , 6.85748114337e-05 , -3.09829406867e-05 , -0.000886964559361 , -0.0026204892304 , 0.000717864715253 , 0.00305101834855 , -0.00118837608943 , -0.000986292231182 , -0.00236829648679 , 0.00433908594922 , -0.00172799342193 , 0.00231529520204 , -0.000660297008903 , -0.00574692774731 , -0.00477730796926 , 0.0061015727612 , -0.000205416306784 , 0.00254584493216 , 0.00716591971946 , -0.000735418993925 , -0.0010606321678 , -0.00554416352416 , 0.000755006177771 , -0.000270156486437 , -0.00102013582221 , 0.00100131416702 , 0.00945415830516 , -0.00177952514995 , -0.0031728252782 , -0.00107813410521 , -0.00422079522851 , -0.00222245215289 , -0.00248753320737 , 0.000427196584276 , -0.00296032176118 , 0.00959860672085 , -0.000287625880021 , 0.000713503075526 , 7.05907648439e-05 , 0.00203934185823 , -0.00160859924523 , -0.000801582175684 , -0.00111225108687 , -0.000139985386311 , -0.00249783797409 , -0.0020063397815 , -0.000526062209457 , -0.00122051344201 , 0.00035782712177 , -0.00237669531739 , -0.00151110893528 , 0.00124778937984 , -0.000169256581225 , 0.00212107071481 , -0.00262348255524 , 0.00417928314703 , -0.002723108331 , -0.00250891058031 , -0.00380224266813 , 0.000139993084076 , -0.00327715982766 , -0.00447004499748 , -0.00328037273971 , -0.000316477024888 , -0.00613428189899 , 0.00196073093094 , -0.00380877389792 , -0.0029323899226 , -0.000956665398463 , 0.00429022210247 , -0.000233462991451 , -0.00653477425166 , 0.004082442284 , 0.00167255016562 , 0.00135920650166 , -0.00272219807869 , -0.0038977189625 , -0.00473194626434 , 0.00600865643167 , -0.00116000509727 , 0.00410624173246 , 0.00373776973129 , 0.00226363036832 , 0.00280476438511 , 0.000945221041221 , -0.000103739192834 , -0.00367512000123 , 0.000950059140454 , -0.000890401199108 , -0.000135648923411 , 0.00193972320177 , 0.00623497288609 , -0.00318507002907 , 0.00461140848734 , 0.00121166846767 , -0.00289881121549 , 0.00328657879512 , 0.00225734316213 , -0.00398820445462 , 0.00326032772622 , 0.00386170558881 , -0.0012266539318 , -0.00602254882513 , 0.00180643921358 , -0.00436758429143 , 0.000429831611472 , -0.00329132830544 , -0.00758200278379 , 0.000593415401544 , 0.00513217963532 , -0.0017544140835 , 0.00119304395659 , 0.000841145582533 , -0.00112079055737 , -0.00311328399416 , -0.000535050345058 , 0.00247426592168 , 0.00175490170616 , -0.00105543707779 , -8.68599671112e-05 , 0.00329215317985 , -0.00128225143678 , -0.006586329774 , 0.000388701911205 , -0.00251578834128 , -0.000142366305388 , -3.31769837558e-05 , 0.00109873911189 , -0.00491122470655 , 0.00677281956462 , 0.0020648506139 , 0.00287915602992 , 0.000626073558037 , -0.0014079208313 , 0.00188523636164 , 0.0045655963967 , 0.00347792587532 , 0.00132926129393 , 0.0058977159248 , 0.00292412595908 , 0.0110807788786 , -0.000489318056124 , 0.00286733696142 , 0.000185502330268 , 0.00320944861445 , -0.00589354937523 , -0.00148587837298 , 0.00308475813035 , -0.00477143172381 , 0.00109317833064 , 0.00233708358179 , -0.00266467267036 , 0.00170383428887 , -0.0028587473789 , -0.00422760102394 , -0.00150682675179 , 0.00677189400998 , 0.00059330185387 , -0.00306234814796 , 0.00211970173394 , 3.28725242065e-05 , -0.00304040953833 , -0.00303127737111 , -0.00116243875433 , -0.00354465935321 , 0.00268779934151 , 0.00181374638449 , 0.00283939616351 , -0.00144564257406 , -0.000777148802634 , 0.00114700378031 , 0.000197598078207 , 0.00144529982732 , -0.00169884429645 , 0.00412841094704 , 0.000216896540032 , -0.000895177851946 , -0.00191060522711 , 0.00494007510543 , ])
Y_3_1_imag = flex.double( [ 0.0 , 0.0 , -0.000815978257955 , 0.00339843486909 , 0.00188096597314 , 0.00351734094518 , 0.00400930195047 , -0.000321998478495 , 0.00207597221937 , 0.00502023520002 , 0.000163496331091 , 0.00543296186919 , 0.00508189595134 , -0.00513137579937 , 0.00258132824451 , -0.00128827870726 , -0.000806036139219 , -0.00329220376568 , 0.00307427617638 , 0.000782870672841 , 0.000489980082989 , 0.0011922918719 , -0.00343527246753 , -0.000140676625775 , 0.00195368636327 , 0.00292289714835 , 0.000230688690853 , -0.00202352876331 , 0.00454369818103 , -0.0022967918728 , 0.00821199931752 , 0.000378956304923 , 0.00540455172016 , 0.000110327816927 , 0.00296194779717 , 0.000267542621933 , 0.00040602734282 , 0.00060156955427 , -0.00901294680955 , -0.000790469627124 , 0.00206965769947 , 0.000299206256831 , 0.000685003981406 , 0.000193018854918 , -2.07404993025e-05 , 0.00045638232364 , -4.65771313962e-06 , 0.000427537566633 , -0.000594827860728 , -0.00119553913581 , -0.00263025424678 , 0.000165871040239 , 0.00127375214119 , 0.00537185358577 , 0.00074313988717 , -0.00384328061268 , 0.00174419441044 , 0.00324461879025 , 0.00158625359924 , 0.00463951446136 , 0.000631066554937 , 0.0020414021527 , 0.00362320727577 , 0.000985952990914 , 0.00589768348053 , -0.00205735869742 , -0.000674384339808 , -0.00281019930491 , -0.000560138295746 , -0.000566622592815 , 0.000105095237106 , 0.001969135731 , 0.000747838379778 , -0.00524716842659 , -0.00332449001183 , -0.0017641317006 , -0.000684773115807 , -0.000854172481685 , -1.58672238205e-05 , 0.00315791070986 , -0.00470334114256 , 0.000592758627845 , -0.000958545312216 , 0.000204508759927 , 0.00295829677273 , 0.000610454212072 , -0.00539033772533 , -0.00148221871441 , -0.000309953996935 , -0.00191252500974 , -0.00128222632693 , -0.00697849437642 , 0.00746527174806 , -0.00438374135633 , -0.00286721282372 , -0.000320105083612 , -0.00766832941969 , -0.0032150428114 , 0.000307685063376 , 0.00215149356977 , 0.000199432400587 , 0.000742025387602 , 0.00200374459562 , 0.000242717334505 , -0.00233075246413 , -0.000238146617776 , -0.00219111507604 , 0.00389616572147 , -0.00187224823082 , -0.00274793673033 , -0.00407557696626 , 0.00167859110312 , 0.0034165391531 , 0.00773202748316 , -0.00236056630061 , -0.00153395855962 , 5.9654794847e-05 , 0.000129086460089 , -0.00177955042733 , -0.00128400743029 , -0.000100661764564 , 0.0033888927113 , -0.00994910033023 , 0.000467011060723 , 0.00160516303408 , -0.00194000294706 , -0.0014774088302 , 0.00319425080377 , -0.00397579875027 , -0.000282407814675 , -0.00129165326236 , -0.000209405504979 , -0.00324232970407 , 0.00065159661126 , 0.00530032189102 , 1.1935021553e-05 , 0.00297766504485 , -0.00180487171783 , 3.31661711488e-05 , -0.00177127485243 , 0.00760971996835 , -0.00435939677462 , 0.000593863574987 , -0.00419325589455 , 0.00132812695456 , -4.92711747453e-05 , 0.000691787581177 , 0.00144346573313 , 2.95456466605e-05 , 9.32936453946e-05 , -0.00845372477254 , -0.00282648413985 , -0.00745908663719 , -0.0027309573629 , 0.00167313144009 , -0.000396571859291 , -0.000464994490607 , -0.00282681303895 , 0.0029688436036 , 0.00149203170465 , -0.00105870777917 , -0.00365250072033 , 0.000406564201837 , 0.00509205590326 , 0.00408008426496 , 0.000964124913986 , -0.00525817382092 , -0.00268764882162 , 0.000819311633457 , -0.00153511972521 , -0.00052220498509 , 1.04880152823e-05 , 0.000940802152547 , -0.000194799538545 , -0.00448297481018 , 0.000709080355681 , 0.00264840834761 , 0.000854901011237 , -0.000195595054106 , -0.00524858944098 , 0.00219586051475 , -0.000221373179739 , -0.002126683241 , -0.00057522247613 , -0.00036423417786 , 0.00168695817859 , 0.00130348923446 , -0.00204985204922 , 0.00407008598639 , -0.00537946366867 , 0.00141826158925 , -0.00172223037524 , 0.000127280358688 , -0.000197583739146 , -0.00224344443104 , 0.00390597128263 , 0.000745154496975 , -0.00367663054979 , -0.00413893181323 , 0.000617869264955 , 0.00212096490033 , -0.00351208854874 , 0.000821995413779 , 0.00221122739249 , -0.00133702285885 , 0.00307331419885 , -0.00063214783408 , 0.000932949457326 , 0.00284381873509 , 0.000751449732186 , 0.00231718704181 , 0.00560117727014 , -0.000769685863765 , -0.00013946982203 , -9.02329873509e-05 , -0.00185140338184 , -0.000414393104701 , -0.00267799372664 , -0.000914144542947 , 0.000346542323933 , 0.00121104677317 , -0.00296240971724 , 0.00367765333239 , -0.0022601425253 , -0.000646453819024 , -0.00109579519534 , -0.000193641126159 , -0.00493733137683 , -0.00571838921714 , 0.00078307196651 , 5.52252323354e-05 , -0.00189040615233 , -0.00342488905251 , 0.000171928767573 , -0.000108115778626 , 0.00453569878542 , -0.00406331609121 , -0.00209037133744 , 0.000821599988161 , -0.00345882445584 , -0.00184079499037 , -0.00306534137089 , -0.00175125906555 , -0.0031448313154 , 0.000391298697922 , -0.00581620231922 , -0.00290862376741 , 0.00314479856025 , 0.00406575066385 , -0.00385698947258 , 1.55881137505e-05 , 0.00097211394886 , -0.00420907046448 , 0.00119012623768 , -0.00283504073772 , -0.000186953812254 , 0.000166377187268 , -0.00325324655804 , -0.000416689708928 , 0.00309202491684 , 0.00445115875383 , -0.00186030134612 , -7.28578043546e-05 , -0.00102987218944 , -0.000126229654837 , 8.37093227696e-05 , -0.00295074734798 , -0.00290227859972 , 0.00552618011183 , 0.00156403142833 , -0.0011030855347 , 0.000662926497924 , 0.00199792514929 , -6.74927257531e-05 , 0.00394634603643 , -0.00147525615359 , -0.00436323924805 , -0.00136356644643 , -0.00121731576548 , 0.00159933341928 , -0.00117934181688 , 0.0048843349672 , -0.000549929069619 , -0.00371547823939 , 0.00462258645831 , -0.00278113002455 , -0.00296190792941 , -0.00294500408369 , -0.00268718558311 , -0.000832553796335 , -0.00176360314059 , 0.00276224346459 , 0.00286610528072 , 0.00238513603075 , -0.00321759175128 , -0.000941436222927 , 0.00584993950759 , 0.00372419258723 , 0.00041444283513 , 9.22213741722e-05 , -0.0033280387284 , 0.00253307082592 , -0.000860899886222 , -0.00438989515046 , -0.00373863113502 , 0.00199217034383 , 0.00177195929338 , -0.00337797667627 , 0.000224305309726 , 0.00450848534174 , -0.0017542714981 , -0.00257144627065 , 0.00074965007589 , 0.00276754860857 , 0.00555271750657 , 0.000291115705753 , -0.00509989624807 , -0.000459264997883 , -0.00410360915624 , 0.000658628474312 , 0.000467237652185 , 0.00514571735399 , -0.00445009891539 , -0.00344115104154 , 0.00200645872703 , -0.00223914613808 , 0.00165388175712 , 0.00160020080772 , -0.00304435602639 , 0.00260122358285 , 0.00137306024998 , 0.000108186930388 , 0.0042323484808 , 0.00400713495863 , 0.00419781965289 , -0.00649728133716 , 0.000855563314354 , 0.00587733729344 , -0.00368105436791 , -0.00201730840535 , -0.00408460352403 , -0.00547987423363 , 0.00586828088677 , -0.00229923662031 , 0.000550295349793 , 0.000401578400726 , -0.000193717158222 , 0.00977385856523 , -0.000163588806388 , -0.00665361683223 , 0.000234986555815 , 9.31884791835e-05 , 0.000285474489875 , -0.00114314811326 , 0.00216828785434 , 0.00143646509404 , -0.0012492055771 , 0.00251555919934 , -0.00153794370059 , -0.00856303340017 , -0.0039194860845 , 0.00183738190407 , -0.0013017049252 , 0.000746859252402 , 0.00144560346814 , 0.00255487182117 , 0.00321574497063 , 0.000480966388238 , 0.00283110029414 , 0.00288423347315 , 0.00157239506892 , 0.00205108684403 , 0.000257732294209 , 0.00368170713395 , 0.000622993370843 , 0.000885786230906 , -0.00115924339359 , 0.00366049811465 , -0.00378584125246 , -0.00071747890261 , 0.000648219168431 , 0.0032635005725 , 0.000807996293611 , 7.97373403826e-06 , -0.00310583102463 , -0.00361622474335 , 0.00615468426204 , 0.004602650018 , -0.00448091224618 , -0.00418805628636 , 0.00197565684666 , 0.00126825591607 , -0.00298851941224 , -0.00097590324813 , 0.00894635444523 , -0.00156300504105 , 0.00854865338484 , 0.00570625099005 , 0.00278077863739 , -0.00259006458904 , -0.00201318243217 , -0.00199201967445 , 1.11165103101e-05 , -0.0013766058833 , 0.0044818571371 , -0.00330124384954 , -0.000982749117114 , -0.00222967663484 , 0.000921424855627 , -0.000431018280863 , 0.00249237465434 , -0.00237655945808 , 0.000399017169303 , 0.00452855232698 , 0.00575210423467 , 2.15921247701e-05 , -0.00181489450213 , -0.00125376666078 , -0.00237751910123 , -0.000410354929689 , -0.00118798720004 , -0.000124998111807 , -0.00197296769729 , 0.000499576691837 , 0.000248268762042 , 2.35638046474e-06 , 0.00428114393872 , -4.33898964418e-05 , -0.00590487448725 , 0.00713855613539 , 0.00137320895533 , -0.00113618272983 , -0.000306815298855 , -0.00382111414123 , -0.000490790621324 , 0.00655294175716 , -0.001094980007 , 0.000872117971578 , -0.00200787249654 , 0.00144637423473 , 0.000788448312432 , 0.000600112025186 , 0.000800252825296 , 0.00275562520931 , -0.00764001275136 , -0.00468776719871 , -0.00301827404446 , 0.00157746938823 , 5.58875393764e-05 , -0.000226005872339 , -0.00195297214454 , -0.000769776722498 , -0.000191487195018 , -0.00107214019115 , 0.00179167857894 , 0.00607884341591 , 0.00327181358753 , 0.00372020204678 , 0.00249996038641 , -0.00198525092503 , 0.00324113753118 , -0.00314694108782 , 0.00412699049326 , -0.00370063541782 , -0.00316047903396 , -1.87962005254e-05 , 2.16058691469e-05 , 0.000930658132555 , -0.00283122932332 , -0.00265822000545 , 0.00157433898571 , 0.00177156217163 , 0.000121199832886 , -0.00408365668013 , 0.000109922354975 , -0.00331564862733 , 0.00318828262818 , 0.000962559292531 , -0.00127931866599 , 0.00320200004223 , -0.00110764470028 , -0.000228166556085 , -0.00232674764848 , 0.0009253542028 , -0.000888595382857 , 0.0004237665107 , 0.00209781009551 , -0.00112138083517 , 0.002554243549 , -0.00319428206955 , -0.000651604938937 , -0.00464039835637 , 0.00148132805024 , 0.000499997456092 , -0.000158659717906 , 0.00466320587932 , -0.000347936674213 , 0.00369358393321 , 0.00203661633757 , -0.00339598034203 , 0.00414420075046 , -0.00518863642774 , -0.0035085396181 , -0.0024426810971 , -0.000597520440144 , -2.99292510963e-05 , 0.00176701862533 , -0.00204154244763 , 0.00325814097337 , 0.00535164318236 , -0.00091102367627 , 0.00242827107421 , -0.000127905131264 , -0.000106816255009 , 0.00527441448345 , 0.00412379276965 , -0.00262297730521 , -0.00269594723031 , 0.00177047245176 , -0.00475513084136 , -0.00337714700234 , -0.00637294429148 , -0.000236208489232 , 0.00114747721348 , 0.00191218409748 , 0.00170017260903 , 0.00298021653689 , -0.000308867991953 , -0.00248679694851 , -0.000165746175814 , -0.00057690529455 , -0.000929648628445 , -0.00257218226236 , -0.000496297287927 , -0.00151225434848 , 0.00364160699897 , -0.0009425360279 , -0.003705228163 , 0.00226216417285 , -0.00083665519624 , -0.00444792501052 , -0.00158533689418 , 0.00176300571549 , -0.00332460837359 , 0.00294005681513 , -0.00169328676128 , -0.00483818364768 , -0.000589712763376 , 0.000272754783322 , 0.00506062224739 , -0.000548184232092 , -0.00190219893874 , 0.00297601369326 , -0.000852875132099 , -0.000523346812762 , 0.00491111379869 , 0.000625450614939 , 0.00412964657623 , -0.00286575548778 , -0.00143732026953 , 0.000854016907131 , -0.000498069057032 , -0.000275599577911 , -0.00185803725549 , 0.00378451621708 , 0.000666802378539 , 0.000778142265892 , -0.0026819569495 , 0.000900178964939 , -0.00169692829417 , -0.00275068424911 , -0.000701691540805 , -0.00361320484451 , 0.00164573480431 , -0.0007538101818 , 0.000592096535545 , 8.0601855629e-05 , -0.000898946062473 , -0.000472767718178 , -0.00564962359283 , 0.00254510057947 , 0.00854928907349 , 0.00413166578972 , 0.000627008863028 , -0.00317271059541 , -0.00157842979301 , 0.00671614935395 , 4.20394054324e-05 , 0.00418494288434 , 0.000484184835756 , 0.000416214591157 , 0.00654150012256 , -1.62423339102e-05 , 0.00399981516754 , 0.00486206289232 , 0.000547051214673 , -0.000194271304911 , -0.00291467440092 , -5.41704855159e-05 , 0.00475628045834 , 6.68666187211e-05 , -0.00573880591394 , 0.00110381752643 , 0.00318710251896 , -3.11132421511e-06 , 0.000432188604592 , 0.000880118317018 , 0.00314271760047 , -0.000510698720825 , -0.00482727268633 , -0.00120260234225 , 0.00320830219694 , -6.29089377145e-05 , 0.00206347087785 , -0.00169621338413 , 0.00208961285923 , -0.00377715931803 , -0.00406818647037 , 0.000224927417013 , -0.00182780957098 , -0.00522501170293 , -0.000928288886321 , -0.00760775945371 , 0.00143599149597 , -0.00288269479674 , 0.000794062158759 , 0.00208441972015 , 0.000626795568152 , 0.00219701911956 , -0.00207775959961 , -0.00114109647726 , 0.00236586607877 , -0.00178125630769 , 0.000343022103704 , 0.00371192753223 , 0.00382060040508 , 0.00175878549817 , -0.00203765106078 , 0.00377327400615 , -0.00182216325779 , -0.00500700181422 , 0.00259970313375 , -0.000663108129002 , -0.00110329154131 , 0.00239793930132 , 0.00365567189942 , -0.000338722336802 , -0.00587295677087 , 0.0008878160326 , -0.00218672133704 , -0.00309089425139 , -0.000426948414122 , 0.000603999387641 , 0.001630384684 , 0.000944202329045 , 0.00696870758939 , 0.00168053279717 , 0.00312292079246 , -0.00494800542562 , 0.00727612851834 , 0.00281129485332 , -0.0008958393236 , 0.00192691971723 , 0.00348680528569 , 0.0021775649856 , 0.00184759013891 , -0.00208700765117 , 0.003967209493 , 0.00217617297367 , -0.00338019047212 , 0.00306329765493 , -0.000297352986697 , 0.00126071509227 , 0.00487057250654 , -0.00064541116898 , 0.00308450677158 , -0.00361886103618 , 0.000834896029546 , 0.00157926093563 , 4.35589128758e-05 , 0.00140525161108 , -0.00117659785352 , 0.000155914107251 , -0.00110576741064 , 0.00110345839486 , -0.00552758573721 , -0.000153325181715 , 0.0013905554574 , 0.00320677183247 , -0.00258431406628 , -0.00351972259447 , 0.00312011152253 , 2.02478925673e-05 , -0.00579382621034 , 0.00106482367932 , 0.00123579983825 , -0.00146226188301 , -0.00572861447371 , -0.00504050510614 , 0.00318030349436 , -0.000790955855028 , 0.00238423663123 , 0.00083944015228 , 0.000607280260658 , 0.000365558298688 , 0.000221205673914 , 0.000920334296782 , -0.00839255550106 , 0.00368083414286 , 0.00647767636773 , -0.00277163327161 , 0.001099651445 , -0.00126102944992 , -0.00190643726014 , 0.00108918129437 , -0.00149649557042 , 0.00270470045591 , 0.000252830909636 , -0.000962622231945 , 0.00253454958324 , 0.00187148675697 , 0.000263387383625 , -0.000948027625615 , -0.00438762202304 , -0.00195069739005 , -0.00340415830529 , 0.00186394742268 , -0.00299005722973 , 0.000992881000792 , 0.0010569921477 , 0.00288529877112 , -0.00219092393048 , 0.00074669765532 , -0.000857180927771 , -0.000844723121708 , 0.00163284212464 , 0.00367044986262 , 0.00010167320419 , -0.00298025983044 , 0.00566362228872 , 0.00151391151757 , -0.00284847687417 , 0.000642318627355 , 0.00342350675857 , -0.00783192138973 , 0.00199366052383 , -0.00117861106098 , 0.00601047561659 , -0.00323223206232 , -0.00112102171697 , -0.000155671530491 , -0.00180904318715 , -0.00222064347204 , -0.00190334849923 , -0.000117504600178 , -0.00262768890336 , -0.000368555307308 , -0.000496088884738 , -0.0019575241054 , -0.00212533875509 , 0.00371560275456 , -0.00265980075726 , 0.00430157378125 , -0.00430013186502 , 0.000403408087003 , -0.00120984705007 , 0.00340944996707 , -0.00419118617592 , -0.00478610716594 , -0.000341760283731 , -0.00582616994126 , 0.00220570247167 , 0.000552998334484 , -0.00399953824782 , 0.00576692854532 , -0.00038374702842 , -0.00210532697498 , -0.00526388134448 , 0.0029585090272 , 3.74281464159e-05 , -0.000600179648544 , 0.00161577555319 , 0.00598957921897 , 0.000632668901716 , 0.000809210077756 , -0.00167096124878 , 0.00237586238751 , 0.000940479063309 , -0.00443373016167 , 2.51689047587e-06 , 0.000160236410259 , 0.000173888163578 , -0.00183040192546 , 0.00394895148951 , -0.00271489522077 , 0.000889336826251 , -0.00173523195111 , 0.00116112423083 , 0.00231981309717 , -0.00346613888224 , 0.00380352580742 , -0.000899627278057 , 0.00222726364422 , -0.00241497933511 , 0.00106409825851 , 0.00529664970487 , -4.19287061006e-05 , 1.75595953472e-05 , -0.002066082643 , -0.000706494469023 , 5.01885609386e-05 , -0.00477598156341 , -0.00304837087311 , -0.0070048065924 , -0.00319528925889 , 0.0014124157336 , -0.00142575327574 , 0.002044948479 , -0.00465601227821 , 0.00217227322206 , -0.00115920116572 , -0.00391454655522 , 0.00133353382783 , 0.00442870429774 , -0.000983345017674 , -0.000493077417053 , 0.00280441665364 , -0.00713292363701 , 0.00150536374554 , 0.00129446995304 , -0.0037033164032 , -0.000670653598186 , -0.00034783844533 , 0.00424466370744 , -0.000775294379061 , 0.00156506453389 , -0.00102638331951 , 0.000154748385238 , 0.000891427129702 , 0.00381587487109 , 0.00049242268901 , 0.00204732038787 , 0.00430991706459 , 0.00435455945001 , -0.00269599654281 , 3.24088492712e-05 , 0.00306896257385 , 0.00114079387028 , 0.00065418587645 , -0.00318865120459 , -0.00125222325276 , 0.00176989294608 , 0.00219460492762 , 0.000574464342542 , 0.00119452135921 , -0.000302911503524 , 5.58907758032e-05 , -0.00427640477433 , 0.00367937406749 , -0.00112064513863 , 0.00263642325785 , 0.000334994715958 , 0.0010985274443 , 0.00391380018592 , -0.00164096004979 , 0.00248052540425 , 0.00243408087726 , -0.00176013158285 , 0.000353818921788 , -0.00213516534178 , 0.00235040498074 , -0.00381024745719 , -0.000489371706616 , -0.00131152658906 , 0.000674475073014 , -0.00305686137968 , 0.00195145804304 , -1.49719632751e-05 , -0.00171686320794 , -0.000259200448718 , -0.00287745596888 , -5.48524636217e-05 , 0.00364250133787 , 0.00110845742473 , 0.000754754994729 , -0.000983583756855 , 0.00323953984079 , -0.00101548890639 , 0.00354562119822 , -0.00125086735591 , -0.000350417464582 , -0.00117467628749 , -0.000176949545785 , -0.00476521215042 , 0.00367225991784 , 0.000904834688098 , -0.00205575784895 , 0.00554135812786 , -0.00569841931399 , -0.000417932715547 , ])
Y_3_2_real = flex.double( [ 0.0 , -0.00141007860924 , 0.000721323699436 , -2.27694005899e-06 , -0.00209729898958 , -0.004673830013 , -2.24511481904e-05 , 0.00328897390974 , -0.0034058935803 , 0.00160262245904 , -0.00489911696358 , 0.00170675341305 , 0.00101853712904 , -0.00277883755825 , 0.00159038974972 , -0.000419472793406 , -0.00645644829985 , 0.00336622166134 , 0.00254320769051 , -0.00125720890465 , -0.00232614662337 , 0.000393395146878 , 0.000380067042206 , 0.00573254737659 , 0.00234468007698 , 0.00508379899712 , -0.00464984928013 , 0.00272892347823 , -0.0055724860768 , 0.000182655509642 , -0.00111708279196 , -0.00532159855495 , -8.24110512954e-06 , -0.0017265921293 , -0.000967603983797 , -0.00428357793809 , -0.00237631808582 , -0.000169339254381 , -0.00668081270277 , 0.00149834915499 , -5.50017296071e-05 , 0.00423278353801 , 0.00279757274495 , -0.0047152239292 , -0.00386330839067 , -0.00320376807821 , -0.00474461201138 , -0.00338677451005 , 0.00260544351313 , 0.000843495587064 , -0.00151719196886 , -0.00494600205295 , 0.00228219324909 , -1.53846911718e-05 , -0.00162490236875 , -0.00207384561757 , -0.00110256715108 , 7.511268738e-05 , -0.0043304998258 , -0.000173036422613 , 0.00141214520945 , -7.2090455733e-05 , 0.000283317022484 , -0.00176572116298 , -0.000937542866357 , 2.98264731456e-05 , -0.00226208891726 , 0.000351933541073 , -0.00138146774506 , -0.00257216943842 , -0.00479382749571 , -0.000218034920439 , 0.000758541475159 , 0.00113618552938 , -0.000575796692204 , 0.0024872504932 , -0.000322427896164 , 0.00427000381018 , -1.73009983021e-05 , 0.000139914070638 , -0.000319560983251 , 0.00600142060181 , 0.00108021570545 , -0.00370957919428 , 0.000432077613098 , 0.00286268080652 , 0.00111969925757 , 0.000545510464794 , 0.00229827245178 , -0.00220638647298 , -0.00359631848058 , 0.00179762424968 , -0.00486669252441 , 0.00347447851096 , -0.00140999644892 , -0.00342403075484 , -0.00178035003489 , 0.000572319595479 , 0.00237489351783 , -0.00302015603505 , 0.00412824481256 , 0.000258745219049 , -0.00339542808666 , -0.000327239414648 , -0.00020902321944 , -0.000662374469619 , 0.00242015222578 , 0.00136897266171 , -0.00449773063222 , 0.000114671635595 , -0.000344118785225 , 0.00164573737402 , 0.000268610480891 , -0.00157411197468 , 0.000821834188911 , -0.000938779359444 , 0.00507994642095 , -0.00370890117863 , 0.00228564697561 , -0.00417382757359 , 0.00379374414882 , 0.00123736539966 , -0.00479751332928 , -0.00273811859752 , -0.00131602037683 , 0.00113856701506 , -0.00244649398413 , 0.000279813417739 , -0.000926178895691 , 0.00128869226626 , 0.00230779334296 , 0.00549630941387 , 0.000599646094903 , 0.00129182468491 , 0.00180667702075 , 0.00498161297429 , 0.000860092140533 , -0.000826889151033 , 0.00570757361539 , -0.0033353909797 , -0.00334407105703 , -0.00143594270267 , -0.00209099633053 , -0.00105216826112 , 4.71278097999e-05 , -0.00546913718599 , -0.00237383677751 , -0.00158598214937 , -0.00116776803944 , 0.0040669891728 , -0.00339026004622 , -0.000893122641288 , 0.00554616818767 , -0.00185316552731 , 0.000918766346673 , 0.00173479398512 , 0.00218083054814 , 0.00113902074544 , -0.00053706594035 , 0.0028942959481 , 0.00435470543124 , 0.000545306512303 , -0.00143814042232 , -8.00831619304e-05 , -8.78650443055e-05 , -0.00414657412466 , -0.000307424784197 , 5.82804250191e-05 , 0.00305757151424 , -0.00251608199013 , 0.00488876880185 , -3.26683411637e-05 , 0.00239899625553 , -0.000198133015588 , -0.00157880167264 , 0.00307652558786 , -0.00571144036691 , -0.00549777108925 , 0.000903551866713 , -0.00199532751546 , 3.14443017305e-05 , 7.89084617959e-05 , -0.00372079250517 , -0.00462821277459 , 8.81363590103e-05 , -0.00154556851403 , 0.00391362023831 , 0.00205759126178 , -0.00281350688054 , -0.000865454711164 , 0.00338791566113 , -0.000236571480404 , -0.000324918070567 , -0.00407280822207 , -0.00102039455669 , 0.00290152035903 , 0.000131816004723 , -0.00129387497425 , 0.00359949214555 , 0.00339380494605 , -0.00473880349202 , -0.000342817682116 , -0.00399239841425 , 0.00386719941775 , -0.00285367666151 , -0.000606268985438 , -0.0031893893036 , 0.000103891866909 , -0.000140707410838 , 0.00656696907412 , -0.00259189767074 , -0.00264159956086 , 0.000171840795697 , 0.00402386951727 , 0.00235331073438 , 0.00230455624802 , -0.00350989391452 , -0.00447230259546 , 0.00324748042848 , 0.00599472883537 , -0.00234532425606 , -0.00130124812864 , 0.00151978201077 , -0.000773596286974 , 0.00320280922757 , -0.00341588162949 , -0.00356367140383 , 0.000144705649075 , 0.00146457415444 , -0.000926124162249 , 0.00568760124131 , -0.00765489888269 , 8.11356398357e-05 , 0.0018831597529 , -0.00166435109582 , -0.0017120272516 , -0.0028448231128 , -0.00233166195616 , -0.000752320191197 , 0.000410822938002 , 0.00194494691349 , 2.98302290648e-05 , 0.0056832882866 , 0.00312581594157 , -0.00259838377248 , 0.00333930459434 , -5.74656749743e-05 , 0.00021610058184 , 0.00356187544647 , -0.000696430559848 , 0.00257581663557 , -0.00204479138991 , 0.000894199493793 , -0.0023409092647 , 0.000349592758282 , 0.00382691986796 , 0.00143545709286 , 0.000354681986664 , 0.00256058766687 , 0.0038377193268 , 0.00244311023949 , -0.0018352568947 , -0.00351628809191 , -0.0033086184635 , 0.00412605878615 , 0.00159671610953 , 0.00122119614542 , -0.00175482469292 , 0.00214160403486 , 0.000554805393033 , -0.000978807909154 , 0.00104329825517 , 0.00400359413579 , -0.00409664066867 , -0.00267851055984 , 0.00041014571456 , -0.000154494908747 , 0.0024449339803 , -0.00374507236516 , 0.0013686958068 , 0.00477941149549 , 0.00324448408748 , -0.00400977638678 , 0.00235322982954 , -0.00148468299359 , 0.00272186753562 , 0.00418347938581 , -0.000195460479347 , -0.00750240382513 , 0.00138434936219 , -0.000691034585785 , -0.000540796931722 , -0.000153679258113 , -0.00437935842822 , 0.00495810317822 , -0.00200122095612 , -0.00259230022931 , -0.000571824016443 , 0.00531225641655 , 0.00182049168456 , -0.000941327493816 , -0.000924664848158 , 0.00279675063286 , 0.00368323198806 , -0.000288447496182 , 0.00453126097483 , -0.000145817888024 , 0.00237486751607 , -0.00414586973196 , 0.00160544116569 , 0.00606816381643 , 0.00148208785279 , -0.00354390269469 , 0.00198110434582 , -0.00204048392569 , 0.00411624230869 , 0.0058712934848 , -0.00279612094501 , -0.00282220303296 , -0.00119998618182 , 0.00597115133817 , 0.00118179537859 , -0.00468263458792 , -0.000928873602024 , -0.0027560538131 , 0.000157574205509 , -0.00122825672684 , -0.00145427264294 , 0.00559453662904 , 0.00445958410297 , 2.92901525203e-05 , 0.00144389863009 , -0.00373296865992 , -0.00037652537836 , 0.00156240287703 , -0.0013374003325 , 0.00282107218371 , 0.00371830481063 , -0.000327587472204 , -0.00361879601997 , -0.00053779524134 , 0.00096130012219 , 0.00284734551309 , -9.77490946825e-05 , -0.000203496935934 , -0.000179273834332 , -0.00403397296704 , -0.00399539803898 , 0.0048353025854 , 0.00157835905078 , -0.00394089866172 , -0.00486628626928 , -0.00121416135844 , -0.0013467683936 , -0.0013538485361 , -0.00110792588042 , -0.002554768396 , 0.00426644101202 , 0.000530372246103 , -0.00790133208725 , -0.00169595100682 , 0.00170580968232 , -0.000112547845412 , -0.00186891536196 , 0.000992540951983 , -0.00359738881223 , -0.000820633238904 , -8.07369862182e-05 , 0.00144936682337 , 0.00653341043791 , -0.00164912094773 , -0.00277342580664 , 0.00292848559376 , -0.00179926197372 , 0.00288431533145 , -0.0041236179024 , 0.00277325756717 , 0.00407519624567 , -0.00381773525338 , 0.005527202484 , 0.00103966588591 , 0.00286730607092 , -0.000734513650258 , -0.00403354524738 , 0.00382589926917 , 0.000532469511701 , 0.00518067517283 , -0.00554528158292 , 0.00488799289606 , 0.000676989574915 , 0.0040898287648 , 0.00577703736636 , -0.000692069344447 , 0.00281126520042 , -0.00215710799911 , -0.0020365784613 , -0.00564630454134 , 0.00165396786512 , 0.000578872930218 , -0.00230426331044 , -0.00154776951765 , -0.00202412668698 , -0.00189376794828 , 0.00313355602398 , -0.00667416273583 , -0.00216716140756 , -0.000591153348427 , -0.0011775554931 , 0.000935187995105 , -0.00262088462318 , -5.19637546588e-05 , -0.00329657278819 , 0.00466037599885 , -0.00411789058107 , -0.000747835634462 , -0.00608266787598 , 0.00030329333285 , 0.00223991306044 , 4.12238613451e-06 , -0.00138485017741 , -0.00263704258071 , 0.000236989239995 , -5.38599177857e-05 , 0.00334612616161 , -0.00747522653193 , 0.00481402711918 , 0.000110257654549 , -0.00155578733148 , 0.00178544123225 , 0.00418277396115 , -9.28299485638e-05 , 0.000363778989887 , -0.00214977556788 , -0.00218805666936 , -0.00129533548584 , 0.00305941569264 , 0.00235169259165 , -0.000354393866329 , 0.00137722699841 , 0.00146717265284 , -0.00588595975209 , -0.00478934987352 , 0.00316738657123 , -7.43731639097e-05 , 0.00459629359128 , 0.00145222881951 , -0.00316901818176 , 0.00128274084921 , -0.00431290116017 , -0.00296198133105 , 0.000537969103896 , 0.00371250382281 , -0.00527297401763 , 0.00228035715192 , 0.00152880179432 , 0.00376806695686 , 0.000812291403553 , 0.00192959768021 , 0.00167249714721 , -0.00371391155831 , -1.79032195319e-05 , 0.000225122371532 , -0.00242728592422 , -0.00205228720028 , 0.00208975075772 , -0.00245760757136 , -0.0061478213833 , -0.000918739665633 , -0.00142284862411 , -0.00573706192104 , 0.00376266808483 , 0.00271090475735 , 0.00635031706802 , 0.00189459703288 , -0.0051371405282 , -0.000645511870008 , -0.000917809916868 , 0.00356344427131 , -0.000571382980059 , -0.000558137195422 , 0.000378872768157 , -0.00499845383559 , 0.00173162881501 , 0.00116358157322 , -3.92014372808e-05 , 0.00440278327727 , -0.00477652856133 , -0.00269237785227 , -0.000917569104653 , -0.00037086622174 , 0.00374608723291 , 0.00152425142128 , -0.00510232172092 , -0.00152839270251 , -0.00148753258214 , -0.00188903133033 , 0.00112824864744 , -0.000122613983354 , -0.00170733402574 , 0.00122614241761 , -0.000284217071738 , -0.0018674442897 , 0.000418610394835 , 0.00385796818888 , 0.00359292853615 , 0.00378916219267 , -0.00466659704499 , -0.00173692294134 , 0.00413990127978 , 0.00456707942729 , -0.0011247569089 , -0.000172401506868 , 0.00665939940776 , -0.00492080519896 , -0.00402879547512 , 0.00130153494353 , 0.00295993870274 , 0.000885985728671 , 0.00483386844962 , -0.00150983162002 , -0.00444368110534 , 0.000217617738368 , 0.000905407489371 , -4.17341977852e-05 , -0.000545601608574 , -0.00169126806209 , 0.00181761718941 , 0.00249250836949 , -0.000857350953357 , 0.00053194917499 , -0.00195296576078 , 0.00150150274334 , -0.00285273256963 , -0.00074184928555 , 0.00232901054968 , 0.000175187930441 , 0.000464090724878 , -6.85397306957e-06 , -0.00105762495586 , 0.00112961792742 , 0.00260277990469 , -0.0010179235209 , -0.00230138061268 , 0.00286328673426 , -0.00278797575547 , 6.29821632373e-05 , -0.00122430770216 , 5.82310906728e-06 , 0.00392118532232 , 0.00152174588654 , -0.00473336062011 , 0.00398514904579 , -0.000973105258554 , -0.000110724040505 , -0.00523934854354 , 0.00613404321199 , 0.000738975924227 , 0.00458348711099 , -0.000323323473313 , -0.00467954231963 , -2.27425372933e-05 , -0.00304492638211 , 0.00147597242289 , 0.000827098746857 , 0.00186948928998 , -0.00529261496878 , 0.000854020983274 , -0.00289436171492 , -0.00500300601441 , 0.000285861097387 , -0.00115121133353 , -0.00466815292287 , -0.000109524622897 , -0.000877959039348 , 0.00491024526285 , -0.00285664007222 , -0.00157745132512 , -0.00107720107466 , -0.00154111507064 , -0.000723398129202 , 0.00542254569158 , -0.00295614655523 , 4.5996242694e-05 , 0.00439993697584 , 0.00136922656157 , -0.00220111810085 , -0.00501528410233 , 0.00226579678907 , -0.000262782074259 , 0.00380008974053 , 0.00203181030559 , -0.00358200102993 , 0.00372912699184 , -7.74938334946e-05 , -0.00175493855895 , -0.00247693865662 , -0.0054738935574 , -0.000145575682399 , -0.00232295124352 , 0.000676291901681 , 0.000194657642798 , 0.00318044627765 , 0.00125523301389 , -0.000103648496907 , -0.00557342737517 , -0.00389860498128 , 0.000195014251717 , -0.000400965107518 , -0.000833758739957 , -0.000361640622669 , 0.00157754406886 , 0.000452607942785 , 0.00575115313545 , 0.000627346641188 , -0.000556878619212 , 0.00272448629906 , 0.000718751523881 , 0.00114573544288 , 0.00417333993445 , 0.00196575824014 , 0.00122755178667 , 0.000794440735263 , -0.000792254291221 , -0.000935497331613 , -0.000141611240261 , -0.000542714997661 , 0.000252282492236 , -0.00210810582934 , 0.00432690482594 , 0.000240633910659 , -0.00204307680648 , 0.00063514284448 , -0.000734725466822 , 0.00185904633223 , -0.00433542124572 , 0.00103660074197 , -0.000879787354065 , 0.00458437629504 , -0.00323737055546 , 3.39132845897e-05 , -0.000143077822098 , -5.62388380065e-05 , -0.00352047718087 , -0.000664230777734 , 0.00484624639814 , 0.000824833548291 , -0.00301460085342 , -0.00631184885865 , -0.00172454676674 , -0.0015003736744 , 0.0046362651397 , -0.00368424075023 , 0.0018892291905 , 0.000860012387373 , 0.00344504331668 , 0.00200452575133 , 0.000606968366772 , 0.000965308299004 , 0.00214779829813 , -0.00589324883797 , 0.000210578511993 , -0.00132143130643 , -0.00102396666468 , 0.000291106600772 , -0.00129848553894 , -0.00105729883594 , 0.00151654302819 , 0.000522362469809 , 0.000989605674166 , -0.000350975177394 , 0.000427725437381 , 0.000192644510877 , -0.00294049253016 , 0.00423174819025 , 0.00547418187177 , -0.00258335142465 , 0.00135725215789 , -0.00802978265695 , -0.000866424696131 , -0.00457807154622 , -0.00233176743132 , -0.00148407855001 , -8.60631444354e-05 , -0.000830379017437 , -0.00241676852665 , 0.00357703230918 , 0.00159967848507 , -0.00610256503648 , 0.0019606136277 , -0.000889456735061 , 0.00202524393069 , -4.13647426805e-05 , -0.00121019135186 , -0.00915036348473 , -0.00325157963587 , -0.000755459999383 , 0.0057366313456 , -0.00260459263386 , -0.00111121115513 , 0.00253595609893 , -0.00171773610045 , 0.00324978589406 , 0.00288606403211 , -0.00315877377667 , 0.00549405988462 , -0.00307368718989 , 0.000974096602757 , -0.003606459124 , 0.000839024619833 , -0.0018208280767 , -0.000407260395627 , 0.00145870076506 , -0.00323131082268 , -0.00312530049096 , 0.00178731419407 , -0.000517411606615 , -0.000896756391406 , -0.00430282199159 , -0.00326805607019 , -0.00130168081718 , 0.00154303318739 , 0.00403161480797 , 0.00447318385457 , 0.00228523075381 , 0.000950392052779 , 0.00549916792761 , -0.0013928125624 , -0.00227985019941 , 7.63708229513e-07 , -0.00369905116228 , -0.000498296617499 , 0.000750970433515 , 0.00298714728771 , 0.00095353457299 , 0.00436279127484 , -0.00261554420656 , -0.00170012150444 , -0.00305832707218 , -6.22186003359e-05 , 0.00160908810189 , 0.00398203426985 , 0.000863657734567 , -0.00373363208331 , -9.43710663311e-06 , 0.00325002534379 , 0.00222826274584 , -0.000157337362207 , 0.00200011251113 , 0.00159066694167 , 0.00107471844252 , 0.00384472285156 , -0.00241846514441 , -1.87243052201e-06 , -0.000100601170981 , 0.00314547614337 , -0.000111027122604 , 0.00643659573935 , 0.00209092225493 , 0.00322882672003 , 0.00383356741473 , -0.000212095538121 , 0.00229342278869 , 0.00525359780904 , -0.00317855591767 , 0.00363538817147 , 0.00474346699791 , -0.00109803116414 , 0.00700037061552 , -0.00362487993556 , 0.000102432902063 , 0.00495974867953 , 0.00242890958744 , 0.00110767868102 , -0.00546253189346 , 0.00239852626263 , -0.00517769362051 , -0.00284002435822 , 0.000952387260216 , -0.00013867972857 , 0.00336620799068 , 0.00397858836329 , 0.000332542052922 , 0.00125636559203 , -0.000463292940869 , -0.001493895906 , 0.0057134621438 , 0.000684154247699 , 0.00551671734302 , -0.00254199589987 , 0.00553502548536 , -0.00224060820098 , 0.00162493420913 , -0.003494953927 , -9.67384026427e-05 , 0.00129099302123 , 0.00121880385232 , -0.00186836068216 , 0.000196097392552 , -0.0015799316216 , 0.00100428640819 , 0.00294648672215 , -0.00115469850357 , 0.0020579544083 , 4.15798361918e-05 , -0.00309220671088 , -0.00148053751224 , 0.00213507655107 , -0.0058637555269 , -0.000600054295472 , -0.000875241081182 , 0.0040578063135 , 0.00449767551613 , -0.000488517635625 , -0.00339024788951 , -0.000530290964589 , -0.000509732045635 , -0.00164036733319 , 0.000170972890447 , 0.00182894091837 , 0.000852068971313 , -0.000655676268065 , -9.5423445851e-05 , 0.000275853293961 , -0.000818639922356 , 0.000829058276969 , -0.00493062149655 , -0.0051346384693 , 0.0028985609912 , -0.00352821463533 , -0.00148791881498 , 0.000718426733837 , 0.00211971742599 , -0.004808371889 , -0.00750088933984 , 0.0013904891553 , 0.00223061077339 , 0.00314460534605 , 0.00415290297 , 0.00354597620543 , 0.000828990699044 , 0.00478508367982 , -0.000490407174817 , -0.00224672693294 , 0.00208392823197 , 0.00200162525266 , -0.00238266675615 , 0.000447046122099 , 0.0066308359242 , 0.00359712660904 , -0.00211419700734 , -0.00394427083423 , 7.60001431013e-05 , -0.00109988453092 , 3.98311488002e-05 , 0.000860295093451 , 0.00443840761162 , 0.000716437176813 , 0.000589318691222 , -0.00254931791568 , 0.00688563543748 , 0.00014824029384 , 0.00446589182771 , -9.18429332571e-05 , -8.4786319833e-06 , 0.00613951880551 , -0.00052065110784 , 0.00360250916644 , -0.000208160068636 , -0.000361605582459 , 0.00162466594794 , -0.00518897222096 , 0.00216910059587 , 0.000235680610876 , -0.00130723825492 , 0.00309657420984 , 0.000483801165428 , 0.0008586806689 , -0.0049287405964 , 0.0036119862807 , 0.00344643449345 , 5.84624445628e-05 , -0.0030765840183 , 0.000152957524509 , 0.00211646071063 , -0.00136905662704 , -0.00447836433406 , -0.000324069625546 , 0.000219986805723 , -0.00152640440782 , 0.000597700770167 , -0.0031816770054 , 0.000100483544024 , 0.000384933526774 , 8.36760067304e-05 , 0.0020695167659 , -0.00159755793224 , -0.00630220211786 , 0.0025021300276 , 0.00196873653237 , 0.00227292021237 , ])
Y_3_2_imag = flex.double( [ 0.0 , -0.0 , 0.000270581627136 , -9.79635988975e-06 , 0.00415868338677 , 0.00394715773461 , -4.31349945158e-05 , 0.000755519905864 , -0.00572688229923 , 0.000785118355504 , -0.00150858328453 , -0.00115188472862 , -0.00232019611316 , 0.00128665686891 , -0.00185386315652 , 0.00183686046857 , 0.00316394903527 , -0.00243228688467 , 0.00087831038017 , -0.000394192761545 , 0.000503563748913 , 0.000327801263489 , 0.000426495813445 , -0.00101844771179 , 0.0020922994638 , 0.00373225876179 , 0.000448562388708 , -0.000397081720895 , 0.00101558229208 , 0.000642966251115 , 0.00241030413921 , 0.000931747013634 , -6.17689618902e-07 , 0.00513859764016 , -0.00081750181783 , -0.00171920651731 , -0.000478031654368 , 0.000194941822319 , 0.000776620827238 , -0.00154488479523 , 0.000106411573398 , -0.00209595915102 , -0.00270984906292 , 0.00102410950465 , -0.000391373028207 , -0.0037058475342 , 0.000878102833079 , 0.00103046081012 , 0.00405678083995 , -0.00279890906691 , -9.43709732354e-06 , -0.000582987038871 , 0.00585714100494 , 2.80695406242e-06 , 0.00550342306087 , -6.65027556022e-05 , -0.0011403198778 , -0.00246428480799 , -0.00201862097857 , 0.000249094896641 , 0.000365592537081 , 8.08401709792e-05 , -0.00181048663394 , -0.00296199750168 , 0.00551187638095 , -0.00021901059408 , -0.00270763263688 , -0.00538174375429 , -0.00142779812075 , 0.00153022535748 , 0.00200688331055 , 0.00161762343896 , -0.000249586301866 , -0.0039481462628 , -0.000185999650603 , 0.00454174730096 , 0.00242950048569 , 0.0038594080825 , -3.50569429067e-06 , -0.0030356825148 , -0.00352365219456 , 0.00409398780513 , 0.00532000024295 , 0.00147883447397 , -0.00140547974554 , -0.00397027686186 , 0.000394940036504 , 0.00232052489962 , 0.000275146182453 , 0.00476839598012 , 0.00389114708389 , 0.00267232964401 , 0.0033112727886 , 0.000549708072132 , -0.00374730091221 , 0.00259580387363 , -0.00143244932555 , 0.00105372128441 , -0.00228602224119 , 0.00350358183365 , -0.000968260192084 , 0.00327971460423 , -0.00228956082472 , 4.47006714712e-05 , -0.000508838445292 , 0.00697028691704 , -0.00101040653592 , -0.000439251575156 , 0.00528549688414 , 0.000613001536841 , -0.00219160885674 , -0.00173434530761 , 0.000892464352944 , -0.000746622295496 , 0.0011604265327 , -0.0035591614684 , -0.00106311503409 , -0.00241311401731 , -0.00273378770983 , -0.00225560101153 , -0.00031093341415 , -6.89853426738e-05 , -0.00268375410169 , -0.000828198611298 , -0.00516172757269 , 0.00216225159491 , 0.00204538562009 , 0.00114511683178 , 0.00212413827879 , -0.000468670080313 , -0.00656824977818 , 0.00154831660904 , -4.31951827412e-05 , -0.000436979906999 , 0.000115611937801 , 0.00258533384125 , -0.00224686205921 , -0.00184666139101 , -0.0016316177202 , 0.00226294616175 , 0.00285621347442 , -0.000819367505506 , -0.00382937362896 , 0.00345475490814 , 2.32582292785e-05 , -0.000384065112784 , 0.00259903089709 , 0.00251572480631 , 0.00189762095008 , 0.00136204660926 , 0.00109346700458 , 0.000675383746273 , -0.00130559121415 , 0.000469894347212 , -0.00204155856422 , 0.00322145604788 , -0.00081062556623 , 0.00500639286325 , -0.00264963087144 , -0.000996045367063 , 0.00242732930686 , -0.000528093924979 , 0.00021255174866 , -8.78884263922e-05 , 7.36293005574e-05 , -0.00412477199819 , -0.000515578566391 , 0.00262301941965 , -0.00523808394959 , -0.00130709032792 , -0.00214272541079 , 1.05029291671e-05 , -0.00379341736957 , 0.00321753870243 , 0.00173771560569 , 0.000779710704452 , -0.00299145148679 , -0.00220773911053 , 0.00279379875948 , -0.000551253427954 , -0.000408953298331 , -0.00481135525523 , 0.00452690486053 , -0.000859701657162 , -1.83402868776e-05 , 0.00114647532317 , -0.00175177154316 , 0.00621465390216 , -0.00318791332372 , 0.000856685911569 , -0.00295186805533 , -0.00160848969954 , 7.28323769244e-05 , -0.000697073988199 , -0.00624418494571 , -0.00351402961446 , 0.000355197261041 , 0.00343246483582 , 0.00202600879993 , 0.00106669005738 , -0.00106653017326 , 0.00514551427325 , -0.00405103752472 , 0.00199390425601 , 0.001147136855 , -0.000919351109286 , 0.000555242052352 , -0.00426398877476 , 0.00495797755195 , 0.00181441709165 , -0.00399186404006 , -0.000534781866102 , -0.000520165968344 , 0.00240984085779 , 0.00416496986713 , 0.00477084280411 , -0.00253623947076 , 0.0013508856712 , -0.00129235743917 , -0.000599974395148 , -0.0017787626423 , 0.00452894244074 , -0.00728704432699 , 0.00175026990997 , 0.00401833984102 , -0.00031614949323 , 0.00115763660748 , 0.00529303129816 , 0.000256124872101 , -0.00364925701078 , 0.00113151274778 , 0.00294705012841 , 0.00173633647374 , -0.00475809033669 , -7.99303530913e-05 , -0.000353890449909 , -0.00084941732145 , 0.00492753227042 , 0.0012360634858 , -0.0020041765011 , 0.00233449639772 , -0.000593564658521 , -0.00450500089627 , -0.00145736702026 , 0.00122468199849 , 0.000223347846991 , 0.00427398116568 , -0.00669414576267 , -0.000673098060978 , -0.000691361576315 , -1.9219803759e-05 , 7.9857373983e-05 , 0.00269417919167 , -0.0027568791443 , 0.00233509623953 , -0.000456281645874 , -0.00010336120179 , -0.000115544953087 , 0.00132514855092 , -0.00282202715965 , -0.00249769465297 , 0.0018661872548 , -0.00102424027361 , -0.00377687259282 , -0.00198061315652 , 0.00636499956843 , 0.0070636352218 , -0.00146039367851 , -0.00507819844959 , 0.00517381302134 , -0.000858295715614 , 0.00264378474829 , 0.000857599064474 , 0.000278609416186 , -0.00745797177802 , 0.00182376472083 , 0.000700054262922 , -0.00408294974394 , -0.00417995113246 , 0.00233438335142 , 0.00505980378595 , 0.00455464137763 , 0.00115312525495 , -0.00471843959717 , 0.000931719104796 , -0.00662840431954 , 0.00535417391076 , 0.000340821091134 , -0.00413227775043 , 0.00180064813917 , -0.00303354411381 , -0.00408561265237 , 0.00061715427765 , 0.00304621791757 , 0.000564599151766 , -0.00104506909851 , 0.00662249885513 , -0.00147360982163 , -0.00298091135945 , 0.00012055159854 , 0.000110218904441 , 4.41702197267e-05 , -0.00234624879954 , -0.00275451407662 , 0.0037774785907 , -0.00440733821296 , -0.00465595436918 , 0.00327368158123 , 0.00310959232846 , 0.000326244709919 , -0.0020503007534 , -0.00181491187594 , 0.00225621049876 , 0.00133921396337 , -0.000993087668274 , 0.000295813209652 , 0.00139009901163 , -0.00184688044515 , 0.00328190563749 , -0.00507577285869 , -0.00129548543023 , -0.000485048104245 , -0.0071324165626 , 0.000396120280522 , -0.0018582654532 , -0.0017411436238 , -0.00149334288334 , -0.000513103840624 , -0.00378853791167 , 0.00586298948325 , -0.000120834453833 , 0.0032159100264 , -0.0032669343832 , -0.00225212608664 , 0.00172902156811 , 0.000212169698838 , 0.00368987161351 , 0.000155255360206 , 0.0018916587978 , 0.0029313316097 , -4.8454926641e-05 , -0.00168391403542 , 0.00361141474478 , 0.000245868783083 , 0.00230693356327 , 0.000276543592815 , 0.00365573753252 , 0.00119019860176 , -0.0048101311827 , -0.00636506936701 , -0.000690827384335 , -0.00360222269325 , -0.00308694232696 , 0.00490687115838 , -0.00452957043052 , 0.000863817071953 , -0.00505007200711 , -0.00289092863284 , -0.00599123048478 , -0.00426463382571 , -0.0040666355206 , 0.000776527694181 , 8.78658618506e-05 , 0.000974214763132 , -0.000949560743161 , 0.0058769648127 , -0.0011481283064 , 4.41801110058e-05 , -0.00400699678993 , -0.00289987232525 , -0.00192420865786 , 0.00667153356947 , 0.00117421696384 , 0.00282205238405 , -0.00246990928884 , 0.00473820661854 , -0.00182807917672 , -0.0057407939112 , -0.000529066683938 , 0.00230509805868 , 0.000547421310569 , 0.000205015094435 , 0.00365566689682 , -0.00452561721429 , -0.00609480555016 , 0.00106589096146 , -0.00302091208555 , -0.00239369204658 , -0.000486949540069 , 0.00254263495539 , -0.00025569146557 , 0.00216862461876 , 0.00625678970408 , 0.00124903670636 , 0.00527018364712 , -0.00414956445133 , -0.00080538704734 , -0.0036075500993 , 0.000864252810526 , -0.00297864330853 , -0.00176995586668 , 0.00390576805745 , 8.38650020485e-06 , -0.00468457554392 , -0.000805287141679 , 0.004009552075 , -0.000387476341542 , -0.00175496370455 , -0.00349117106996 , -0.00118834084467 , -0.000952128565981 , -0.00250479558575 , -0.00249339054959 , -0.000354140455752 , -0.00307516182949 , -4.78985459699e-05 , -0.00609348730131 , -0.00149689765051 , 2.59058533238e-05 , 0.0003233112773 , -0.00539649911623 , 0.00722419458644 , 0.00485492686955 , 0.00247512841868 , -0.000698504797416 , 0.000255993936756 , 0.00641624270828 , 0.00396401110145 , 0.00495687665175 , 0.00216880699562 , -0.00263093224167 , -0.000275599182782 , -0.00419176662449 , -0.00190244144205 , -0.00591381439105 , -0.000642577627609 , 0.00184304571167 , -0.000251117194351 , -0.00146301049877 , 0.000920817341429 , 0.00332450198767 , 0.0016020838292 , -0.00154590766888 , 0.00327024848722 , 0.00250168851587 , 0.000658351410374 , 0.000693617292808 , -0.00264604913282 , -0.00298064197291 , -0.000244513973959 , -0.00364086702842 , -0.00233777158304 , 0.00251543434548 , 0.00065435326362 , -0.0029769745213 , -0.00155509142868 , 0.00795387911426 , 0.00559735081909 , -0.00141475561158 , -0.00406656631356 , 0.000291578798129 , -0.000583904908675 , 0.00471739175436 , -0.0038526645128 , 5.13650178427e-05 , -0.00485030361923 , -0.000168592099313 , 0.000384521284957 , 0.00195736852197 , -0.00223616495929 , -0.00151274765339 , -0.0047756652958 , 0.000620440770809 , 0.00222296031001 , 0.000529887493644 , -0.00537950924497 , 0.00101249628225 , -0.00597244683423 , 0.00026826650785 , 0.00119751808708 , 0.00546799859243 , 0.00112591778937 , -0.00218860251797 , 0.00542463130189 , -0.000235649619838 , 0.00166839023157 , -0.0036285830341 , 0.00298961166952 , 0.00277874619228 , -0.00198033850815 , -0.00374998295657 , 0.000679395930953 , 0.00261624706196 , -0.00634377157041 , 0.00273751096058 , -0.00561611258976 , -0.00342907696261 , -0.00308694908713 , 0.000809322601937 , 0.000932488562525 , 0.00439120822515 , -0.00274608508412 , 0.00450902034614 , 0.00155531488334 , 0.000722380590413 , -0.000256646125854 , -0.00118902034452 , -0.000831961784431 , -0.00131640817097 , 0.00102209971367 , -0.00637461708844 , -0.000214375840761 , 0.000487359504683 , -0.00175313453228 , -0.00202931085741 , 0.00299286481356 , 0.0046105542328 , -0.00187036888486 , 0.00330099354478 , 0.00189188744558 , -0.00346696627894 , -0.000135481386322 , 0.00470175731163 , -0.00348650243203 , 0.000831545842094 , 0.000927246619386 , 0.00537410051252 , -0.00357385807615 , -0.00120498327107 , 6.64689807446e-05 , 0.0001554067346 , 0.00129066027782 , -0.00052368289363 , -0.000228089605372 , -0.00258103520215 , -0.00494379882865 , -0.00148270720317 , 0.00198973947486 , -0.00211431479739 , -0.000484107512925 , 0.00294732745001 , 0.00165925880997 , -0.00367935893653 , 0.00190347145371 , -0.000341010699391 , 6.20012566548e-05 , 0.00124772966997 , -2.24767922011e-05 , -0.000894789532553 , -0.000974475680634 , -0.00307482427758 , -0.00335338932462 , -0.000289781483694 , 0.000136886793474 , 0.00141998835888 , 0.000167565550247 , 0.000559144497773 , 0.00370337996891 , -0.00307209996006 , 0.00315419811786 , 0.00123348013616 , -0.000728493325265 , 0.000256920043925 , -0.000660091361535 , -0.00263998845501 , -0.00284436980118 , 0.00585634996327 , 0.00337862023951 , 0.00145776199974 , 0.00045779628114 , 0.00384216163751 , 0.00268644434797 , 0.00011259734222 , 0.00117049824643 , -0.00415658681654 , -0.00124795547975 , 0.00597940450087 , -0.00226866674262 , 0.00278728431268 , 0.00290980142751 , -0.000601321143527 , -0.0027084220116 , 0.00121658413423 , 0.00341123088738 , -0.000696849839688 , 0.00496871391006 , 0.00563954437497 , 0.00237622462542 , 0.00216660931966 , -0.000888105982072 , -0.000540947447364 , -0.00423774054817 , 7.68277034575e-05 , -5.05608525758e-05 , 0.000556049647021 , -0.000408818381452 , -0.00210336778743 , -5.13490566249e-05 , 8.66079873596e-05 , 0.00242600627186 , -0.00575375421889 , -0.000730829439067 , -0.00489894866784 , -0.000606751325514 , 0.000716652790122 , 0.00575282982802 , -0.0073831050519 , 0.00247977347604 , -0.0040976514014 , -0.0019782331524 , -0.00515693327725 , -0.000864155635384 , -0.000125270247513 , -0.00309049069444 , 0.00387800619724 , -0.0031478297189 , -0.00187734617413 , -0.000361143936902 , -0.00408372712323 , 0.00474239757441 , -0.00596463029687 , 0.000544435292465 , -0.00448274123566 , 0.00709302568239 , 0.0010875670755 , -0.00537459152968 , 0.00172307452329 , 0.0013657098218 , 0.000895152214314 , 3.16337785381e-05 , 0.00143320858582 , 0.00176454936292 , -0.00398034674693 , 0.000544044920137 , -0.00524595995645 , 0.00089894971498 , -0.00358018608905 , 0.00225491407289 , 0.000559227981853 , -0.00480280419298 , -0.0013924712649 , -0.00289434113712 , 0.00116245524409 , 0.000403290160956 , 0.00319463991286 , -0.00281043692413 , 0.00320063458936 , 0.00390668860845 , -0.00338632923827 , -0.00128752678396 , -0.00292322755417 , 0.00328418355494 , -0.00649935860731 , 0.00121018773097 , 0.004058806848 , 0.00180360576655 , 0.0026032650197 , 0.00310480450219 , 0.0010949482532 , 0.00132532555977 , -0.000553701802306 , -0.000467246799482 , 0.0029683749743 , -0.00159064768216 , -0.00238855761629 , 0.000279539816385 , -0.00255186062333 , -0.00126283188732 , -0.00102136084323 , -0.00394976790295 , -0.00385605844424 , 2.20004034208e-05 , 0.000264083938829 , -0.000683641779583 , 0.00367389008613 , -0.00173967013173 , -0.00516748930523 , -0.000166166466462 , 0.00281121931055 , -0.000600437264182 , 0.00216924800208 , 0.00655819293797 , 0.00332853194826 , 0.00110015627519 , 0.0047659704235 , -0.00257809320824 , -0.00264252713957 , -0.00332578048691 , 0.00330707673923 , -0.00130993911293 , 0.00432688158585 , -1.40018045619e-05 , -0.000459590592459 , -0.000193331282576 , 0.00258485314855 , -0.000592082530609 , -0.000483779392466 , -0.000697819521777 , 0.00347532742816 , -0.00121361948444 , 0.00085472881586 , 0.00301837784266 , 0.00179018098691 , -0.00229182903604 , -0.000951726052061 , 0.00249373146509 , 0.0013749995763 , -0.00689223641524 , -0.000913724866826 , -0.00605136151191 , -0.0011420423835 , -0.00336957512359 , -0.00257919438125 , 0.00111726733133 , -0.000979830188426 , -0.000310251996375 , 0.00212335561528 , -0.00560192784156 , 0.0052450712431 , 0.00585596668476 , -0.00478466802715 , -0.00225197211944 , -0.000292693107591 , -0.000963290965541 , 0.00317348368133 , 0.00242725522284 , -0.00271521348737 , 0.00215217858247 , 0.000114702305814 , 0.00412313442096 , -0.0011879694673 , -0.00313429818086 , 0.00215041404201 , -0.00361281429551 , 0.00131086786876 , 0.00202443769289 , -0.00320538108148 , 0.00400987779197 , -0.000393289619845 , 0.00677655491739 , 0.00506363745778 , -0.000746692135365 , 0.000876889225713 , 4.37523616375e-06 , -0.000224481666716 , 0.00308919074636 , -0.000960859767087 , 0.00426828451185 , -0.00251332058442 , 0.000867765812188 , 0.00113391763425 , -0.00253965495987 , -0.00229984922376 , -0.000371379828237 , -0.00187202113625 , -0.000929286379467 , -0.000495018532206 , -0.00365231574634 , 0.00271438641373 , 0.000254936599281 , 0.000333194692885 , -0.00437381084179 , 0.0020284130782 , 0.00176219463849 , 0.00286840499415 , 0.00600350639005 , -0.001976878121 , -0.00178544992116 , 0.00197736366302 , -0.00222890686173 , -0.00485431319009 , 0.00627166402934 , 0.00122177763071 , 0.000463167594974 , -0.00204036376059 , -0.0015478405723 , 0.00383438305069 , -0.00134544389358 , -0.000837517426125 , -6.6278323638e-05 , 0.00196281710015 , -0.000433227133356 , 0.00423279924126 , 0.000185610049229 , -0.0013795086134 , 0.0033621333397 , -0.00354069865471 , -0.00290132218947 , 0.00597692627259 , -2.91243926591e-05 , -0.000167603697688 , -0.0054365338457 , -0.00212457332896 , -0.00290930010417 , 0.00256367448976 , 0.00278892513003 , -0.00401218723051 , -0.000128212190541 , 0.00203921174197 , -0.00173650931498 , 0.00198156034028 , 0.000531470911307 , 0.00380289695762 , 0.00064200058314 , -0.00274080312838 , 0.000545804867291 , 0.00206286948633 , 5.60349185188e-05 , -0.00069983197424 , -0.00374954030768 , -0.00347891930652 , 0.0043750511342 , 0.00062774079926 , 0.00388663937871 , 0.00141358136837 , 0.00331200421078 , -0.00212849782824 , 0.000347168030747 , 0.00231836677984 , -0.00131972311237 , 0.000533717369496 , -0.00702109142441 , 0.00329811976787 , 0.00262159504163 , -0.00128269728234 , -0.0011276549643 , 0.00161183162919 , -0.00339855814073 , 0.00145850828431 , 0.0017271600679 , -0.00216313463355 , 0.00189793420823 , 0.00306429276753 , 0.00309434741473 , 0.00368882170536 , -0.00300109459823 , -0.00450195270084 , 0.000521511235803 , 0.00485524435517 , 0.000496571990391 , 0.00174232309632 , -0.000994587955166 , -0.00146667616827 , -0.00489551437962 , 0.000589431040302 , 6.13980939885e-05 , 4.15655503372e-05 , 0.000386007260307 , 0.00663581638425 , -0.00474587333123 , 0.00151013107482 , 0.00049111593276 , -0.00400186804654 , 0.000462421623626 , -0.00521044917953 , -0.00146408549154 , 1.75434829397e-05 , 0.00283120671294 , 0.00211850833677 , -0.00271474222934 , 0.00142871579076 , 0.000270273197807 , -0.000102071163276 , 2.68167821885e-05 , 0.00140605199815 , -0.00199875165295 , -0.00358770070956 , 0.00122307826526 , -8.4057506171e-05 , 0.00181811306397 , 0.00615915142715 , 0.00426578982692 , 8.95879138033e-05 , 0.00493881854028 , -0.00154730315244 , 0.00146625266431 , 0.00328415346742 , 2.17939866748e-05 , 0.00283496487717 , 0.000587629707252 , 0.000188338445262 , -0.00575410999631 , 0.000841984829563 , -0.00178679102446 , 0.00307353432715 , -0.00269267004154 , 0.00172565449994 , -0.000358811463796 , 0.00681573572163 , 0.00411576221925 , -0.00360146665212 , 0.00421460724475 , -0.00348058037129 , 5.59006831086e-05 , 0.00243614869622 , -0.000735618596821 , -0.00134482115805 , 0.000830074666685 , -0.00148739158847 , -0.000387352649315 , ])
Y_3_3_real = flex.double( [ -0.0 , -0.00738160764446 , 0.00512451708064 , 0.00302284838821 , 0.00546753672362 , -0.00271957462499 , -0.00604178563935 , 0.00486777197972 , 6.53114869624e-05 , -0.00439299895845 , 0.00318684319031 , -0.000285309061115 , -0.00050575338312 , 0.00049775153882 , -0.000129262888262 , 0.00146165638769 , -0.00405984703487 , 0.000465495622813 , -0.00238768286919 , 0.000151761571889 , 0.00619355009475 , -0.00230038273341 , 0.00467606066006 , 0.00369839505236 , -0.00363874126098 , 0.0011009764471 , -0.00179699208633 , -0.000841780725661 , -0.000677948193319 , 2.16447199096e-05 , -0.000360230936503 , 0.00119888615398 , -0.000781882124884 , 0.00126904366523 , -0.00375162677294 , -0.00402421452438 , -0.00568641716543 , -4.72190221157e-05 , 0.000376496578207 , -0.00126507157131 , -0.000358537633125 , 0.00370004078999 , -0.000895558536154 , -0.00279160037462 , 0.0034074777265 , -0.00133613966528 , 0.00376070170014 , 0.00480742082777 , 0.000341603188822 , -0.000482387168008 , 3.54495328163e-05 , 0.00259077813347 , -0.00606303861718 , 0.00186204546816 , 0.00499088272697 , -2.51494548977e-05 , 9.96854559187e-05 , -0.00446740557321 , 0.00111141973054 , 0.0067151277684 , -0.00618689143965 , 0.0019478192401 , 0.000156812490241 , 0.00217673118772 , -0.00152921396747 , 0.00222564228419 , 0.00104489221998 , 0.00494616663197 , -0.00119086515823 , -0.00290116668209 , -0.00324101758566 , -0.00236003230789 , 0.00548088615749 , 0.00108970747365 , -2.50568243945e-05 , 8.62357210384e-05 , -0.00222502343234 , 0.00292476465877 , -9.62179201091e-07 , -0.00070637281722 , 0.000512543320778 , 0.0029753397748 , 0.00469163996646 , 0.00339935850854 , -0.00220336887945 , 0.000748391356771 , -6.36473995457e-05 , 0.00318433481612 , -0.000487129629936 , -0.000346984121868 , 0.000893685248475 , -0.000634292967118 , -0.00150228594061 , -0.000279762064295 , -0.00166661797265 , 0.00272530183944 , -0.00027356524874 , 0.00501652119216 , 0.00265930158652 , -0.000473750862768 , -0.00236988648057 , -0.00268359986412 , 0.00175173465547 , 0.00453967225385 , -0.0010849832154 , -0.00329480658429 , -0.00224983932482 , 0.00240199410907 , 0.00432432527215 , -4.85450784862e-05 , 0.00020277357402 , -0.000215749418531 , -0.00526576925458 , 0.000119659705309 , -2.73266926008e-05 , -0.00184788837152 , 0.00440823315451 , 0.00216053978586 , 0.00184218811324 , -0.00129663087988 , 0.00188701396303 , 0.000383788825069 , -0.000952467136558 , 0.000953631914435 , -0.00118922443961 , -0.000324589516423 , -0.00332301549957 , 0.000155827917599 , -0.00657737881579 , 0.000419925500319 , -0.00121607307541 , 0.00527232351077 , -0.000457033021671 , -0.000202287637677 , 2.92409706538e-05 , -0.00347561828945 , 0.00523238004255 , -0.000743165870996 , -0.00429148298227 , 0.00179760184956 , -0.000971134143324 , 0.00429467359804 , -0.000103134172216 , -0.000292534812489 , -0.00583119051947 , -0.00363989180103 , 0.00133605604885 , 0.00029328219341 , -0.0017959682481 , 0.00278496476065 , 0.00032431565389 , -0.00334766946698 , 0.000636029373981 , -0.00150721123539 , -0.000705946478431 , -0.00270145582441 , -0.00365198538734 , -0.00221872173383 , -0.00512299580405 , 0.00174544201131 , -0.00236665227356 , 6.80570554171e-05 , -0.000187015394595 , -0.00681599250583 , 0.00485244243803 , 0.00382728871493 , 0.00783580030933 , 0.00413598577746 , 0.00559929668067 , -0.000450656848622 , 0.00245385197755 , -7.33239050485e-06 , -0.00303086394951 , 0.00180316901688 , 0.000508033419137 , 0.000761648805475 , -0.00484142804488 , 0.00229946574959 , -0.000815228514868 , -0.000155381694404 , -0.00260841306146 , -0.00299458593837 , -0.00634021191896 , -0.00147591308933 , -0.00437736733957 , -0.000195204313937 , -0.00105653433248 , -0.00377298813381 , -0.00706586951099 , 0.000119190215098 , -0.0024799862059 , 0.0029103159238 , -4.53576771759e-05 , 0.00503426616368 , 0.00175150565204 , -0.00180400321571 , -1.37344526346e-05 , 0.00123543888787 , -0.00111074044911 , -0.00587627085409 , -0.00181771114816 , 0.00164624629352 , 0.001292288935 , -0.00347951436433 , 0.000544212226028 , 0.000172112080717 , -0.000788601146955 , -0.00200791761216 , -0.00504886256771 , 0.00277797416039 , 0.000145574150289 , 0.000181350565608 , -3.34377523149e-05 , 0.00288546352862 , 5.28617104621e-05 , 0.00592488321374 , 0.00266506711832 , 0.00104287818542 , 0.00124586852382 , -0.00214694278057 , -0.00331122975906 , -0.000648042124782 , 0.00155419967328 , 0.000925673301782 , 0.00456726563404 , 0.000496385845316 , -0.0035296919808 , 0.00116600578017 , 0.00195258257107 , 0.00228989479847 , -0.00489228127562 , 0.00291744026549 , -0.0043974909694 , -0.000956341579505 , 0.00610429759121 , -0.00187050361881 , -0.00039687946526 , 0.00310837443025 , -0.000720112982695 , -0.00550386695733 , 0.00398392989373 , -0.00417369119189 , 0.00409027228898 , 0.000865061695566 , 0.0016068185612 , -8.88870574739e-05 , -0.00505726691571 , -0.0024657415845 , 0.00182472934514 , 0.00507178185987 , -0.000723066970672 , 0.000141170935026 , 0.000163935173865 , -0.00141737872214 , 0.000319339156005 , -0.00569118341461 , 0.00616424655439 , -0.00194485798528 , 0.00282949443497 , -0.00188847666868 , -0.00103087138493 , 0.000246431041357 , 0.00125318009872 , 0.00468453954813 , 0.0026526407652 , 0.00220457267504 , 0.00181578711056 , -0.000635238901511 , -0.00189644228271 , 0.00352290514481 , 0.00202991975737 , 0.000703961061763 , 0.000712475481037 , -0.00484802542134 , 0.00392098667934 , -0.00161313592423 , -0.00651801248826 , -0.00014499468806 , -0.00093006706603 , -0.00369904385206 , -0.00461628889737 , 0.00221194540199 , -0.00620451769655 , 0.00231666370966 , 0.0048608190077 , 0.00399374975594 , -0.000560585643278 , -0.0044170836585 , -0.00372051945858 , 0.000674630161671 , -0.00215208188245 , 0.00145233420436 , -0.00246460467289 , 0.00494736983601 , 0.00112643497045 , 0.00427549680552 , -0.00274725474498 , -0.00593889428188 , -0.00289939878244 , -0.00411770007164 , 2.34675132998e-05 , 0.000245898050102 , 0.000885169200187 , -0.00639094235479 , -0.000720339021065 , -0.00111404131118 , 0.00187148393824 , -0.000159451644474 , 0.00268308065283 , -0.00181907491574 , -0.00305276338411 , -0.00435909261554 , 0.00367578656709 , -0.00355654518837 , -0.00489898616235 , -0.00038266617901 , -0.000896342496864 , 0.00235222567784 , 0.00160153144842 , 0.00211628600356 , 0.00167000304895 , -8.66090600182e-05 , -0.00441273973886 , -0.00266021241461 , 0.000481656548629 , 0.00285515714523 , -0.00133436431741 , -0.00130846722421 , 0.00124099514957 , 0.000627738332771 , -4.14787127132e-06 , 0.00276391566588 , 0.00182740481662 , -0.00021118343092 , 0.000530250513586 , -0.00200070595431 , -0.00437476428302 , 6.6726322286e-05 , 0.00387997890254 , 0.000807948426489 , 0.00071422777037 , 0.000295697491914 , 0.00139799589889 , 0.00114414124857 , -0.0011669195914 , -0.000103974905462 , -0.00409173408327 , -0.000358384223198 , -0.00524297840147 , -0.000743111732455 , -0.00527272229838 , -0.00408987874136 , -0.00286755955696 , -0.00116476702216 , -0.00561931627466 , 0.0032352471403 , -0.00375742086322 , 0.00485899812452 , 0.00297555032017 , -0.00242424839573 , 0.00760711798907 , 0.000164736266671 , 6.3842744218e-06 , 0.00351917426629 , 0.00216914761848 , -0.000122723645379 , -0.00488538783488 , -5.93209232518e-06 , -0.00183506141441 , -0.002483765684 , 0.000208683265538 , -0.00443338054436 , -0.00302648422737 , 0.00654503437503 , 0.00217663249943 , 0.00555520681162 , -0.00276404104337 , -0.00363801331826 , -0.000315508428193 , -0.00254611672847 , -0.00278994843941 , -0.000562392124231 , -0.00186451417633 , 0.00148995067129 , 0.000168816260781 , -0.000166644662127 , -0.00162328366726 , 0.00158176418527 , 0.000304356678751 , 0.00686652981943 , 0.000454203403981 , 0.00219279422688 , -0.00174679676042 , 0.00564790308626 , -0.00138214887637 , -0.000618834840171 , 0.000358397247827 , -0.00105851059772 , -0.00421844034608 , 0.00534592490913 , -0.000924035518434 , 0.000465898757552 , -0.000349984590725 , 0.000304936107063 , 0.00059276347165 , -5.98457685844e-05 , -4.7612241157e-05 , -4.57307296511e-05 , 0.000815926212602 , 0.00322046726428 , 0.00310928713583 , 0.0044409985246 , 0.0030839714832 , -0.000948645708699 , 0.000601254642638 , 0.00255892770327 , -0.00232520850085 , -0.00402063854 , -0.00246609210163 , -0.00461724479196 , 0.000379061592113 , -0.00404156856399 , 0.00428933295183 , -0.00306576184898 , -0.000876583903382 , 0.00386702789808 , 0.00191558716743 , -0.000762681135976 , -0.00162288260508 , 0.000896870819788 , -0.00275809309839 , -0.00261048075523 , -0.000316290526207 , 0.00542659746713 , 0.00480392588108 , -0.000216103599424 , 0.00294646475414 , 2.02207003135e-05 , -0.00235763823935 , 0.000189622733017 , -0.00277467119946 , -0.00209389812958 , -0.00107663982378 , 0.00448508170094 , -0.00105790178764 , -0.000156500822264 , 0.000424083784714 , 0.0038636934852 , -0.00271271085054 , -0.000745558824458 , 0.00149487206413 , -0.003856610041 , 0.00333182456762 , -0.000332658349315 , 9.58742656433e-05 , -0.000666732049549 , -0.00242321399473 , 0.00260219408205 , 0.00364885364974 , -0.000743214116824 , 0.00442520345577 , -0.00484459227657 , 0.000115137298815 , 6.19724331556e-05 , 0.000173220569395 , 0.000361388243504 , 0.00410269947375 , 0.00514317309934 , 7.19159751633e-05 , 0.00373939520625 , -0.000791232477803 , 3.018206273e-05 , 0.00380382526063 , 0.00641325465734 , 0.00574940824548 , 0.00128182762578 , 0.00452300230455 , -9.81145762071e-05 , -0.00602764301853 , 0.00508449620347 , 0.00223568651582 , 0.00289090824556 , 0.000148563792039 , -0.00166077095155 , -2.13719803936e-05 , 0.00223820776775 , 0.00125630705214 , -0.00170529511014 , 0.00493075084152 , -0.00333092762095 , -0.00212504747018 , 0.003773440093 , -0.00161590454358 , -0.00201757778625 , 0.00242565306248 , -0.000563208845854 , 0.00255650208587 , 0.00063743903049 , 0.00209271893603 , 0.00409490223852 , 0.000889274127685 , -0.000864882219358 , -0.0013871192613 , 0.00291584391455 , 0.000998467208869 , -0.00370543748748 , 0.00107730667397 , 0.00212684503739 , -0.000894795187061 , 0.000547995327304 , -0.00396078881627 , -0.00165968551258 , -0.00361942783642 , -0.00337938052845 , 0.00101848753943 , -0.0072282457033 , -0.00293513179296 , -0.004688356836 , 0.00141877902042 , -0.00715978834093 , -0.00238171304076 , -0.00634859598057 , -0.00326169055365 , 0.00283935129361 , -1.05984901208e-05 , -0.0005514804512 , -0.000696811375401 , 0.000402743419014 , 0.0010212999619 , -5.37974805129e-05 , 0.000150888328522 , -0.000309466200057 , 0.00122742229998 , 0.00396970180803 , -0.00389841718409 , -0.00143377322073 , 0.000862883776577 , -0.000259826089766 , -0.00428230698575 , -0.00456035141345 , -0.00128780266409 , -0.00314540813203 , -0.00506859501254 , 0.00449696816617 , 0.000195655281878 , 0.00226987205605 , 0.000268033628963 , 3.42981196767e-07 , 0.00492149809411 , 0.00536461454379 , -0.00229094714809 , 0.000985283625985 , 7.13411257443e-05 , 1.87493638748e-06 , 0.00235933210067 , 0.000112981434232 , 0.000117586417727 , 0.00234516545585 , 0.000574470216866 , 0.0015243179889 , -0.000360948171456 , 0.00609618405268 , 0.00432043074599 , 5.39154401047e-05 , 0.00650030507562 , 0.00254825045026 , 0.00355157817097 , 0.00211255203606 , -0.00152993246087 , 0.000236487802614 , -0.00579496962842 , 0.00211169181408 , -0.00472036199122 , 0.000900952797285 , 0.0019900868825 , -0.00409768023886 , -0.00459344273124 , 0.0028282817455 , 9.08446717083e-05 , 0.000554734248887 , -0.000511771437121 , 0.000757528179508 , -0.0056220168737 , -0.00327641379238 , -0.00295735487863 , -0.00574211957069 , -0.00288981934307 , 0.00091313076227 , -0.000342271956285 , -0.000974770956377 , 0.00440277638057 , 0.00177541779178 , 0.00422703361297 , -0.0041084791053 , 0.00297125493776 , 0.000447583063851 , 0.00470904083645 , 0.00186120476172 , -0.00453876234274 , 0.000477941754112 , 0.00353292754611 , -0.00276206484731 , 0.00470513525579 , -0.00468039420037 , -0.00453495564234 , -0.000550739697354 , 0.0035765363442 , 0.000317352209405 , 0.00136546566772 , -0.000278351320138 , 0.00196737644731 , 0.00495937570134 , 0.00226689730393 , -0.00253154460472 , 0.00173505471143 , 0.00498259173247 , 0.000412830582737 , 7.75016329159e-05 , -0.00174917203121 , -0.00132861317471 , 0.00200006615368 , 0.0026052071298 , -0.000866091142574 , 0.00255561384067 , 0.000130297125926 , -0.00415220712704 , -0.00341995500777 , -0.00126955254519 , -0.00159805558423 , -2.83067999001e-06 , -0.00234398786935 , 0.00151027231476 , 0.00446758402076 , 0.000601871234153 , 0.00339767614493 , -0.00482282492124 , 0.00220824066537 , -0.00103971355 , 0.00154137933321 , -0.00422663483953 , 0.00714549777823 , 0.00395436290029 , 0.00120531482778 , 5.13111601134e-05 , 0.00260125329517 , 0.000234047625954 , -0.00142594704718 , 0.00242957767049 , 0.000345587425778 , -0.000149929760817 , 0.00213455824144 , 0.00153369178531 , -0.00473400219292 , -0.000688862140884 , 0.000836154907153 , 0.000426873966163 , 0.00194087421333 , 0.00108253798614 , -0.000353848400216 , -0.000685690908461 , -5.09369768982e-05 , -0.000341277201784 , 0.000339443217969 , 0.00535050168592 , 0.00112098707702 , -0.000111628057569 , -0.00012049842709 , -0.000192078433729 , -6.58385721329e-05 , -0.00113437035433 , 0.000798010486206 , 0.00666122782675 , -0.00023171723033 , -0.000370584541803 , -0.00261619408778 , -0.00416806249786 , -0.000770028409124 , 0.000187455128307 , -0.00154348215455 , -0.00414552267123 , 0.00262345219302 , 0.00414194668666 , 0.00210125596151 , -0.000652476924323 , -0.000482559984422 , 0.00116706293725 , -8.50213914233e-05 , 0.00328245603623 , 1.81394352732e-05 , 0.00415085654101 , 0.000195548953205 , -0.00191988055485 , -0.000554350245973 , -0.000146261443095 , -0.001012382654 , -0.00272020638113 , 0.000484556665102 , 0.00308439952794 , 0.000931653226298 , 0.00323941972608 , -0.00381544565824 , -0.00507831393165 , -0.00362166472983 , -0.00276629851096 , -0.002482008953 , -0.0014767093241 , 8.2519119706e-05 , -0.00263118051433 , 0.00509279189978 , 0.00199606764408 , 0.00442331065414 , -0.000782709783448 , 0.0035299637503 , -0.00208483505426 , 0.00446856749788 , 0.00501470774034 , -0.00126406274552 , -0.00583708582494 , 0.00019783835986 , 0.0012970369772 , -0.00273035282936 , -0.00249007709696 , -0.000423044978066 , 0.000359881648077 , 0.000451632675578 , -0.00184019130749 , 0.000424268714981 , -0.00487093237617 , 3.45775094537e-06 , -0.000964864912483 , -3.02818825808e-05 , -0.00453031599953 , 0.00107967464766 , -0.00352851724443 , -0.00138744668689 , -0.000535764276366 , -4.69766800034e-05 , 0.000814351537828 , -1.77343494292e-05 , -0.000968891162446 , 0.00418642740499 , -0.00362521593811 , -0.00110132255513 , 0.00274330675399 , 6.78118329043e-05 , 0.00196111861501 , -0.000238056770516 , -0.000122670195721 , 0.0010179460073 , -0.000144371634344 , -0.00240346717694 , -0.000403350755719 , -0.00338420854087 , 9.1926144791e-06 , -0.00227856129096 , 6.37867825295e-05 , 0.00192483106869 , -0.0038261909836 , -0.00203896815716 , -0.00020400434339 , -1.89013583288e-05 , -0.00649834387841 , 0.00135021716923 , 0.000866845859663 , 0.00296192423875 , -0.00101643310531 , 0.000597413635249 , 0.00138007574045 , -0.00533088953472 , 0.00142451058077 , 0.00267032983324 , 0.00392317549902 , -0.000781623488382 , -0.000981005157853 , -0.000662385783887 , -0.00273895182393 , 0.000324613497171 , -0.00780542772717 , 8.0803749802e-05 , 0.00613709058193 , 0.00256491566118 , -8.16203124278e-06 , 0.00112449756547 , -3.20984893525e-05 , -0.00208062154994 , -0.00187744751735 , 0.00486544831075 , -0.00235679011231 , 0.00283738674178 , -0.00394373626478 , 0.000548756833137 , 0.00152440910061 , -0.000769959451898 , -0.000471693988718 , 0.00515854930874 , -0.000274700402388 , 0.00027411831938 , 0.00339581831632 , -0.000121029888453 , 3.21745259969e-07 , 0.00101280363175 , 0.00015296757413 , 0.000302656861351 , 0.00334921448704 , 0.00090725593251 , -0.000116876496294 , -0.000956187647745 , -0.00297082806128 , -0.000174765337305 , -0.00169263891649 , 0.00216753425218 , -0.0025471147643 , -0.00184735851297 , 0.00148009797725 , -4.99035453279e-05 , 0.00355759752765 , 0.00101313338161 , 0.000495782162851 , -0.000761124495023 , 0.000456726215913 , -0.00237370800038 , -0.00230376882143 , 0.00140196307571 , 0.00016124609447 , 3.71494236494e-05 , -0.00205085082196 , 0.00290432764147 , 0.00113154119845 , -0.000743593873515 , 0.00287743130919 , 0.00256998107444 , -0.000644486532132 , -0.00364277468555 , -0.00243477095622 , 0.000595240783924 , 0.00104215044575 , 0.00376678796791 , -0.00527975565908 , -0.00101529638491 , 8.61710984596e-05 , -0.00224735593771 , 0.000506565758229 , 0.00055979640237 , 0.00028920964137 , 0.00175194456212 , 0.00415569247481 , 4.65726051784e-06 , 0.000412591636508 , -0.000217195743206 , 0.000296939987297 , 0.00100745279984 , -2.43934916241e-05 , -0.00066510828665 , -7.21365112278e-05 , -0.00291254963596 , -0.00465517691846 , -0.00594811270332 , -0.000632517439034 , 0.00537021170409 , 0.00279337964725 , 0.00314764151692 , 0.000874902752089 , 7.66120081025e-06 , 0.00593363675986 , -0.00138690579004 , 0.00224912014168 , -0.00066694371907 , -0.00283099476726 , -0.00379702641098 , 0.00221410651865 , -0.00493389627817 , -0.00196568216395 , -1.03267444767e-05 , 0.00223789594272 , 0.00406992469161 , -0.0021065438055 , -0.00440626297346 , 0.00157035951618 , 0.00428706318313 , -0.00144481208958 , 0.00436435062357 , 0.00536263224127 , 6.84544387508e-05 , 0.00255899754649 , 0.000311516681765 , -0.00172583390156 , 0.0050611792055 , -0.000107941045465 , -0.00312640534621 , -0.00261183185275 , -0.00100822877365 , -0.00186047388057 , -0.0015651834649 , 0.0049696892776 , -0.00607420076952 , -0.00463569186773 , -0.00126970008112 , 0.000273224881801 , 0.000405921789566 , -0.00669264934098 , ])
Y_3_3_imag = flex.double( [ -0.0 , -0.0 , 0.00306003673231 , -0.00637389984302 , -0.000464508781289 , -0.00155292952897 , -0.000396582067748 , 0.00171475886855 , 0.00336712065074 , 0.00539594187971 , 0.00153185602184 , -0.000230849055419 , 8.41685431034e-05 , 0.000654159168787 , 0.00045262973711 , 0.0030364953198 , -0.00498489690835 , -0.000635446084279 , 0.00438315273825 , 7.43896264339e-05 , -0.00205100063013 , -0.00393738147517 , -0.00147958132572 , -0.000998674572932 , -0.00702484972049 , 0.00153931688157 , 0.000261039868838 , -0.00382278903577 , -0.00244573891143 , -5.57698889934e-05 , 4.87124998244e-05 , 0.0045067930863 , 0.00693822004873 , 0.00411457970165 , 0.00214073093544 , -0.00259362401907 , -0.0017451492202 , -1.39596500702e-05 , 0.00214704766583 , 0.00326393240099 , -0.00512748899897 , -0.00305170990293 , 0.00202391571567 , 0.000927603734303 , 0.000520013549069 , -0.00457934002732 , -0.0010590653652 , -0.00228112532299 , 0.00480613240805 , -0.00133669820835 , -0.00379939421454 , 0.000460726732184 , -0.00140734062414 , 0.0067098077612 , -0.00184874945977 , 0.000522622378399 , 0.000258966264315 , -0.00489565793081 , 0.000852458523459 , 0.00084585107229 , -0.00247108259629 , -0.00614469248001 , 0.000254306365663 , -4.56092628781e-05 , 0.000901494772339 , 0.0033795815373 , 0.00395041621399 , 0.00602417792367 , 0.000459104671754 , 0.00301725009351 , 0.00219220058001 , -0.00356760947559 , -0.00283125686693 , -0.000416513329798 , 4.94902193741e-05 , -0.00254646999938 , 0.00148168347343 , 0.00578074374989 , -2.97514723283e-07 , 0.000614943086827 , -0.000674590334152 , 0.00373394769282 , 0.00247188049044 , -0.00217416952014 , -0.00626832392026 , -0.00489705332514 , 0.000114149522728 , 0.00149548953276 , -8.80024537703e-05 , -0.00254816251108 , -0.00257824670683 , 6.54575469869e-05 , -0.00120154647038 , 0.0011665812107 , -0.000417706881295 , 0.00185563480832 , 0.000169421790028 , 0.00019601919857 , 0.00119170925976 , 0.00163674013621 , 0.000853201595508 , -0.00211434152629 , -0.00141912958133 , -0.000937446629697 , 0.00533199944401 , -0.00439507693446 , -0.00333670564524 , 0.00477911478167 , 0.00120692847152 , -2.70271329143e-05 , -0.00032941418746 , 0.000584892151703 , -0.00190349916411 , -0.000152808532014 , -0.000195424876606 , -0.000778144682712 , -0.00140940154762 , 0.00253626754173 , 0.000488349050814 , -0.00119152868978 , -0.000232638735096 , 0.0045833137561 , 0.000992033475791 , 0.000449629427102 , 0.00272915044214 , 0.00555286058924 , 0.00572003547505 , 7.06964024203e-05 , 0.00111984299922 , -0.000242228012277 , -0.00425182666588 , 0.00230329906965 , -0.00422062330811 , 0.000107709405255 , -0.000304114472845 , -0.00303649592855 , -0.00126390824616 , 0.00479086722381 , 0.00190444623603 , 0.00144359065826 , -0.000543825858549 , -0.00436046772355 , 0.00288769494843 , -0.000821882107172 , -0.00478987391635 , -0.00038420105205 , -0.00396755081302 , -0.00502133472458 , -7.56280796555e-05 , 0.00146671658977 , 0.00064163928628 , -0.00228832637765 , 0.00175991500221 , -0.00385737334912 , -0.00463713690077 , -0.000120096555252 , 0.00215853311338 , -0.00107132753897 , -0.00270248215694 , 0.00321662563993 , 0.00247628395656 , 3.01275307848e-05 , 4.18401045239e-05 , 0.00228182421624 , 0.00280793267584 , -0.00160307262677 , -0.000165453689948 , 0.00386913427606 , 4.00108700683e-05 , -0.000394206800568 , -0.00175040832931 , 3.69326713533e-06 , -0.000183491986723 , 0.00217082156784 , 0.0001688532891 , 0.000297449073297 , 0.0054787967893 , 0.0014829476669 , 0.00249166909661 , 0.000363127794081 , -0.0032904328028 , 0.00285076999103 , -0.00159568591922 , -0.000417205739928 , 0.00139130610685 , 0.000277243888359 , 0.000772433351159 , -0.00119117127999 , 0.00217985279671 , 5.04401291002e-05 , -0.00134102836419 , 0.00185048299139 , 1.55749949216e-05 , 0.00130836105049 , -0.00290596304158 , -0.000460489550809 , 5.3261799016e-05 , -0.000308463255251 , 0.00114779333757 , -0.00288795522814 , 0.00527132136118 , -0.00134659702083 , 0.00321897818417 , 0.00401501578824 , -0.000351381586738 , -1.53741310952e-05 , -0.00298188948754 , 0.00186629026916 , -0.00549799294315 , 0.00118879199269 , 0.0018525066209 , -0.000587047375503 , -0.000105550067488 , 0.0030274133362 , -0.00379176140361 , 0.00065680255082 , 0.00363837428653 , 0.00221513683365 , 0.00195181286689 , 0.000323660100323 , -0.00486622568355 , -0.00169222218671 , 0.00300747828414 , 0.00569462040279 , -0.00104057360411 , -0.00356276482769 , 0.00179801016132 , -0.00126575952279 , -0.00734899283262 , 0.00100232541226 , -0.00148429925954 , 0.00474515963233 , 0.00506106449356 , -0.00427458734656 , 0.000440160621582 , 0.00592578981044 , 0.000853554487805 , -0.000382507990866 , -2.50169955122e-05 , 0.0028802489974 , -0.00104503176173 , 0.00358796912451 , 0.00259531737646 , 0.00112757730141 , 0.00206751047874 , 0.000884324562833 , 0.0048572930126 , 0.00223787905434 , 0.00634196702851 , -0.00213343005394 , 8.09308055144e-06 , 0.00240830772659 , -0.00052125367809 , -0.00510998066273 , -0.000506552230354 , 0.00102388989918 , -0.000667232617451 , -0.0038061326441 , 0.00246341803761 , -0.00134739647548 , -0.000407122251023 , -0.000616688161511 , -0.00276775016353 , -0.00141689284697 , -0.00210723186586 , -0.00498048942633 , -0.00310895770915 , 0.00037192283877 , 0.000358351408018 , -0.0048812061311 , 0.00379695489076 , -0.00312448391207 , -0.00217523192266 , 0.000495520229819 , 0.00107755932363 , 0.0033091107608 , 0.0032259792112 , 0.00605946193478 , -0.00289879406271 , 3.71834183161e-05 , 0.00168489133546 , -0.000318591448022 , 0.00277101593625 , -0.00021245358141 , 0.00435130494584 , -0.000813459856426 , -0.0026365806758 , 1.91709416959e-05 , 0.00395246340352 , 0.0033670314693 , 0.00446158863136 , 0.000968209868319 , -0.00552896545878 , 0.00383302972781 , -0.0065590491844 , 0.00376424249554 , 0.000630925239229 , -0.00139157795644 , 0.00279480550455 , -0.000409754803047 , 0.000132854558259 , 0.00342851149533 , -0.00153259690474 , -0.00444403750919 , -0.000907211908357 , 0.00253888895719 , 0.00170347148039 , -0.00101382735963 , -0.00387592534717 , 0.00586555061011 , -0.00574056904968 , -0.00107501180185 , -0.00418760260055 , 0.00287103454179 , 0.00606536883449 , 0.00354223351359 , 0.0024653211466 , -0.00196202352841 , 0.000460434338033 , -0.00452847995883 , 0.00503148577549 , -0.000130989492536 , 0.000380559801522 , -0.00384988283083 , 0.000594470495998 , 0.00375564810551 , -0.00529069628647 , 0.00234591808447 , -0.00154116741797 , 0.0032638690941 , 1.89567823822e-06 , 0.00042446315955 , -0.000980398705503 , 0.000354783644925 , -0.000173856306971 , -0.00831965244751 , 0.000858239049649 , -0.00106460568585 , 0.00664967183623 , -0.00131911033763 , -0.00526689200223 , -2.1609938444e-06 , -0.000306855911826 , 0.00517012672582 , 0.000893417091185 , -8.05695164018e-06 , -0.00206006911925 , -0.000772687458183 , -0.00219579685321 , -0.0016604886985 , -0.00140435510099 , 0.00288877946847 , -0.00065116799971 , -0.00288604449551 , -0.00204955101637 , -0.00496546047893 , -0.000312123918083 , 0.00390922254299 , -0.00227593787878 , 0.00264226748058 , 0.00148457796551 , 0.00012285478725 , 4.1509687187e-06 , -0.00309142085762 , -0.00478148465136 , 0.0031840832977 , 0.000715605875165 , -6.35429365467e-06 , 0.000497603004545 , -0.00343102870612 , 0.000732744945462 , 0.000873029817419 , -0.00194845574193 , 0.000432503367036 , -0.00390443974948 , 0.00165070994086 , -0.00231206619527 , -0.00051481802384 , 0.00150568354484 , -0.0017146359098 , -0.00248161758069 , 0.00523251685761 , -0.00351274692672 , 0.00470704404558 , -0.00304173287085 , -1.51163836411e-05 , -0.00160242788752 , -0.00225714031127 , 0.00202833951285 , 0.00286330957451 , 0.00483548987215 , -0.00366923503897 , -0.00244601187835 , 0.00409338235675 , 0.000283985103697 , 0.00610529110994 , -0.00166090343654 , 0.000149793935259 , 0.000422619123909 , -0.00109619698912 , 0.000278155510988 , 0.00682092897071 , 2.32486495684e-06 , -0.00307221123717 , -0.00325535431514 , -0.00142006197225 , -5.6470808605e-05 , -0.000450870643568 , 0.00196922064578 , 0.00239043727331 , -0.003664510239 , -0.00301330449609 , 0.00339858851265 , 0.00733116125828 , 0.000273978403137 , 3.02265598639e-05 , -0.00270084120019 , 0.00490025199203 , 0.00403416160519 , 0.0016542678631 , -0.00364583948078 , 0.00446010131365 , 0.00443451217593 , 0.00216783137824 , 0.00623126046859 , 0.000308817244598 , 0.0018193039472 , -0.00334166387942 , -0.00044357057174 , -0.00102771353923 , -0.0024806814311 , 0.00382989178534 , 0.00423319360647 , -0.00294532452442 , 0.00239179496374 , -0.000673392061475 , 0.0045596428974 , 2.68153305436e-05 , 0.00651111484039 , 0.000211853699243 , 0.00269710816504 , 0.00110134420253 , 0.000872575621166 , -0.00418911053516 , 0.00114090683719 , 0.00021088279395 , 0.00126606897617 , -0.000420107780321 , -0.00346867514939 , -9.25824061837e-05 , -0.00094839345139 , 0.00432826962171 , -0.00262704287013 , -0.000148223249898 , 0.00129737823533 , -0.00100202789107 , 0.00330444648469 , 0.000769262536663 , 0.00207776545948 , -0.00220749624743 , -0.00367773723743 , 0.00115182708781 , 0.00158355005652 , -0.00120909916514 , -0.00469705796719 , -0.00440168731362 , 0.00016881577811 , -0.00347777373696 , -0.000452975769923 , -0.00599780577439 , 0.000510955741709 , 0.00275397129897 , 0.000559687509444 , -0.00179794081224 , -0.000893519044455 , -0.00184869055755 , 0.00149475620533 , 0.00455687475916 , 0.00466295404242 , -0.000670848532423 , -0.00275547550264 , -0.000997750304218 , -0.000668651861382 , 0.00328203165304 , -1.27567439723e-05 , 0.00135180120543 , 0.00185097831041 , 0.00524578981631 , -0.00156312322416 , 0.00598713439135 , 0.00514165164106 , -0.00518692510159 , 0.00139088598598 , 0.00439036362362 , -9.408571274e-05 , 0.00182917823693 , -0.000814966086802 , 0.000565708161975 , 0.0026743868107 , -0.00277456266262 , 0.00108088348507 , 9.58785769063e-05 , -0.00104693774619 , -0.00450121780772 , -0.00325523627473 , 0.000377183569736 , -0.00274308521718 , -0.00268431005792 , -0.00179786450241 , -0.00159854561412 , -0.00228587083405 , -0.00707084687053 , -0.000398212794361 , -0.00190528478988 , -0.00120941977799 , -0.00124141156438 , 0.00020782900473 , 0.000573990746706 , 0.00178320781249 , -0.00163819640388 , 0.0015501261924 , -0.00574496065826 , -0.00178203641554 , -0.0029431848286 , 0.000123497324255 , -0.000589304618791 , 0.00228339837348 , -0.0031268026713 , 0.00713315650082 , -1.01491925312e-05 , 0.00126078977168 , -0.000558809096308 , -0.00439519620997 , 0.00190502330477 , -0.00127363580802 , 0.00128897304936 , 0.00251602899867 , -0.000262525085262 , -0.000384989887892 , 0.00316916756722 , 0.000397939748546 , -0.000125919059262 , 0.000269003751198 , -0.00371716611428 , -0.00105976676961 , 0.00530252535828 , 0.000106586207341 , -1.4709683556e-07 , -0.0017217141439 , 0.00467141111841 , -0.00268349747615 , -0.00171480980213 , -0.000153870258408 , -7.83817600731e-06 , -0.000989173588869 , -0.00275640401323 , 0.000172177227044 , -0.00144239228972 , -0.000791038017965 , -0.00188051708253 , 0.000341517638036 , 0.00224084527609 , 0.00114244798698 , -8.59120184272e-05 , 0.000908459736185 , 0.00232539413678 , 0.00226737579867 , 0.000600919169271 , -0.00337782788836 , 0.0045538909375 , 0.00210697803017 , -0.00210283301264 , -0.00184145301979 , -0.00495327024683 , -0.00349927846727 , -0.00291185255424 , 0.00193391735696 , 0.000342323328029 , 0.00326846183487 , -0.000247660459691 , -0.00306093249783 , -0.000373672154173 , -0.00501823236659 , -0.00498390832982 , -0.00346753756096 , 0.000925938502112 , -0.000909513224007 , 0.00244802234521 , 0.00023635393929 , -0.00271772783024 , -0.00181135189587 , -0.00048602742442 , 0.000130651514242 , 0.00348625866024 , 0.00599314514735 , 0.000112078432624 , 0.00288901042046 , -0.00333789180002 , 0.000253979186001 , 0.000189567174841 , -0.00319151847045 , -0.00783812567517 , -0.00204027298788 , -0.00275245365314 , 0.000880738976453 , 0.00508009840765 , 0.00387172504419 , 0.000523543648397 , -0.00259550521105 , -0.000157228706272 , 0.00555998269479 , -0.00030633023471 , -7.40801693181e-05 , -0.00480395148902 , -0.00111569732808 , 0.00145841859376 , -9.96881674975e-05 , 0.000157207344894 , 0.00403577749482 , 0.00669253964255 , -0.00104365048155 , 0.00329103804766 , -0.000499353900888 , 0.00382764412428 , -8.74634780518e-05 , -0.00305578283204 , -0.00217920551591 , -0.00108794542139 , 0.00505830730781 , 1.42519088511e-05 , -0.00179378620287 , -0.00551843903521 , 0.00250836139355 , 0.000273882153153 , -0.000869660471303 , 0.00262968653906 , -0.00489282061236 , -0.000850593834292 , 0.0058749902218 , 0.00413803679196 , 0.00522972990265 , -0.00419182856077 , -0.000625034651554 , -5.4825160624e-05 , -0.00217581584466 , 0.000627143417636 , 0.00393306194192 , 0.00221595565214 , -0.00437391210684 , -0.000269937889991 , 0.00189861832766 , -0.00295517807931 , 0.00178768951725 , -0.00484086265554 , 0.0030179384389 , -0.000217787151224 , -0.0041034718555 , 0.000374728570762 , 0.000414028778861 , -0.00199009588793 , 1.24797572896e-05 , 0.000610400027617 , 0.00114951166427 , -0.0030202053045 , 4.31702373468e-05 , -0.00027333992804 , 0.00636927062091 , 3.83525109956e-05 , 0.000170244329169 , -0.000866760854976 , 0.00111853464866 , 0.00114731439167 , -0.00171429095989 , -0.00151270107102 , -0.0032077876212 , 0.00338301479257 , -0.00182066829405 , -0.00603794257869 , -0.00440604844712 , -0.000821435197778 , -0.00547511473759 , -0.00200886477705 , -0.00194430795978 , 0.00349751299882 , -0.00591189105546 , 0.000858157814188 , 0.0027304522855 , -0.00353428492638 , 0.00104692862259 , -0.000455701256024 , -0.00151053154861 , 0.00360300829655 , 0.000915605100602 , 0.00461417462321 , 0.00160295289688 , -0.00420974459085 , 0.00381922390985 , -0.00744729298412 , -0.000309974686794 , 0.00409281992129 , 0.00316559025767 , 0.00244090918891 , -0.00398239572683 , -0.0037996400507 , 0.000653068084046 , 0.00241728886217 , 0.000589199328213 , -0.000164056988347 , 0.00173763577754 , 0.000721799513284 , 0.00123169144569 , -0.00449024524177 , 0.00562608497297 , -0.00368384095265 , -0.00418135367114 , 0.00526997890862 , -0.00671792836064 , 0.00116547687381 , -0.00392054635596 , 0.00263571524259 , 0.00089709213257 , -0.00259842890464 , -0.00430253565375 , 0.000527858644603 , -0.00124137564816 , 0.00255863662935 , -0.00568831028064 , -0.00226877223485 , 3.38936571246e-06 , 0.00299709800779 , 0.000157749640548 , 0.00209225413979 , 0.00146574898289 , 0.00148488339807 , -0.000649501110805 , 0.000812835974796 , 0.000870763999997 , -0.00418984328904 , -1.08741917257e-05 , 0.00208122599288 , -0.000910658008176 , -0.00198733570607 , 0.000397056618811 , 0.0035997870881 , 0.000653215401458 , -0.000300265194372 , -0.000143326497411 , 0.000952523737351 , 6.2157636541e-05 , -0.000234470561884 , -0.00110285109374 , -0.00108459352725 , 0.00339248444663 , -2.24532221382e-05 , 0.00237094618191 , -9.18446403046e-05 , -0.00022259734537 , 2.09556123318e-05 , 0.00117344037258 , 0.00204135476167 , -1.22834892056e-06 , 0.000396814031473 , -0.00218897724884 , 0.000913271913038 , -0.00189340079442 , -0.00459650782559 , 1.48705188304e-05 , 0.00351027561874 , -0.00573299748093 , 0.00163564789193 , 0.00115684350952 , 0.000923364846616 , -0.00236427475583 , -0.00769013630637 , -0.000373533507342 , -0.00127519166168 , -0.00188136157782 , -0.00108861710469 , 4.83543805385e-05 , -0.000181281929413 , -0.00312382386654 , 4.09795474387e-05 , 0.000413786828824 , 2.06456025883e-05 , 0.00101117183769 , -0.00192473487792 , -0.00265224746023 , 0.00209325117708 , -0.0005227962671 , 3.11272953136e-05 , 6.1716590658e-05 , 0.00417952639787 , -0.000824034246849 , 0.000521241611944 , 0.000442899078971 , 0.00162569982282 , -0.00206959316728 , -0.00401359322383 , 0.000586933840516 , -0.000290165182887 , -0.000823605413276 , -0.000115573776935 , -0.00731375791928 , 0.00275514399849 , 0.0017301704273 , -0.000199571288328 , -0.00214984026311 , 4.25861315184e-05 , 4.98359170279e-05 , 0.00358219773047 , -0.00389616310845 , 0.00111745298916 , 0.00881520109545 , 0.000442542883127 , -0.000197864694413 , -0.00221233085865 , 0.00501081745998 , -0.00499257829018 , 0.000167405864206 , -0.00611423780835 , 0.00390684948415 , -0.00221170718488 , 0.00108858753997 , 0.000468634364761 , -0.000492428799787 , -0.00071913676645 , 0.00591757696478 , 0.000317854745298 , 0.000495711941882 , 0.000831425787921 , 0.00818018639307 , -0.00125191312634 , 0.00415568904144 , -0.00366095319634 , -0.00238395082425 , -0.0059508692608 , 0.0004893098084 , -0.00100109375156 , -0.00625949750472 , -8.21086429109e-05 , 0.00389080577514 , -0.00513881768476 , -0.00047465625557 , 0.00157389352642 , -0.00382434401494 , -0.000160674298005 , -3.32730390317e-05 , -0.00471833250921 , 0.00538820294166 , -0.001878647191 , -0.000615562343545 , 3.93351760848e-05 , 0.00165049654152 , 9.3619161657e-05 , -0.00485943895735 , 0.00241137055495 , -0.000218532816747 , -0.000327341988585 , 0.00315189744586 , -0.00176427267305 , -0.00431420391861 , 7.95442543312e-05 , -2.48498806585e-06 , -0.00200634777819 , 0.00394958026897 , -0.00527314548602 , 0.00159617950311 , 0.00166836632246 , -0.00135426642404 , 0.00694777436017 , -0.00133776266954 , -0.000157148614905 , -6.2589075357e-06 , 0.00533368461559 , -0.00339403060612 , 0.00663706867761 , -0.00187225759489 , -1.04158473723e-05 , -0.00276374209816 , -0.000374034123332 , 0.00151407119909 , 0.000262415896638 , 3.88174572338e-05 , -0.0044788341582 , 0.00197011547399 , -0.00182026091853 , -0.00281077282235 , 0.00272472918531 , 0.00152924892455 , 0.00408311241897 , -0.00325948479691 , -0.00173196836895 , -0.00219158975802 , -0.00407953267478 , 0.00168703972166 , -0.00350424009277 , 0.00389190919299 , -0.000524196960761 , 0.000277868861922 , 0.00173173489312 , ])
Y_4_m4_real = flex.double( [ 0.0 , 0.0078056768564 , 0.00476222382619 , -0.00671530556674 , -0.00326914336338 , 0.000434717912849 , -0.00368420265187 , 0.00475865178738 , -0.00132671089401 , 0.00449873534138 , 0.00266841643607 , 5.82686681481e-05 , -0.000163455499326 , 0.000309871974061 , -3.24185412874e-05 , -0.00313932895204 , 0.00380066791499 , 0.0001105307268 , 0.00406843673108 , 4.41171790862e-05 , 0.00623178741216 , 0.000871683981583 , -0.000596249594058 , 0.00324134058117 , 0.000939256799282 , 0.000356143730443 , 0.00130361888391 , 0.00382461139846 , 0.00186189438447 , -1.15584852899e-05 , -7.9199055051e-05 , 0.00420554655029 , 0.00732293075978 , -0.00323779220835 , 0.000759634963886 , 0.00341411588715 , 0.00573936259102 , -3.09148526865e-06 , 0.00139920601453 , -0.000110108747537 , -0.00315279815229 , 0.00286108850097 , 6.07173894402e-05 , 0.00235896348073 , 0.00325409419902 , -0.000674562881239 , 0.00345517013048 , 0.00452364409013 , -0.0019678657913 , -0.00096204420513 , 0.00397722797431 , 0.00214806651858 , -0.00449440389604 , 0.00690990166418 , -0.00433819324315 , 0.000291044191497 , -3.90151309199e-06 , -0.00693704989946 , 0.000557199854198 , -0.00250513626507 , 0.00615398239118 , -0.000779773039064 , -0.000111908293628 , -0.000922319224923 , -0.00109088832217 , -0.00413473929055 , -0.000727080969378 , -0.00788830392414 , -3.76749922834e-05 , 0.00203367377367 , 0.00256021940857 , -0.00432299327902 , 0.00525746421029 , -0.000598465489135 , 1.04550298378e-05 , -0.00112012550645 , -0.00256355393386 , 0.000650869761135 , -1.36184576855e-07 , -0.000595958157871 , -0.000447217515344 , 0.00156947444741 , -0.0047787144879 , 0.00287994527396 , -0.0058066386683 , -0.00153931752936 , 2.81021525896e-05 , -0.00321968717615 , 0.000236750899386 , -0.00135591316962 , -0.000178340484953 , -0.00011124609765 , 0.000468107067156 , 0.000775916060634 , -0.000992853450549 , 0.000833741829658 , 2.38229319716e-05 , -0.00288517533415 , 0.00010697155615 , -0.000178455085075 , 0.00197212458896 , -0.00333072953206 , 0.000719992646123 , 0.00473451666855 , -0.00410130390178 , -0.00507574257807 , 0.00290042137591 , 0.00458660037804 , -0.000644357148086 , -1.17154865618e-05 , -0.0001533970323 , -1.86479914726e-05 , -0.00494091167987 , 3.42870751006e-05 , -2.23585829173e-05 , -0.00148038312813 , 0.00408873585084 , 0.00125870540807 , -0.000284646373087 , 0.000688460848361 , 0.00154060502483 , 0.00481905087653 , 0.000398841971252 , 0.000623737534043 , -0.00223848902916 , -0.00328587257147 , 0.00121978787072 , -5.3952183092e-05 , -0.00476807627992 , 0.000257961789109 , -0.00307871251701 , 0.00482421243949 , 0.00444889897725 , 7.35269766166e-05 , 0.000122784104283 , 0.0025238735826 , -0.00418097685128 , -0.00337593277706 , 0.00375653846901 , 0.000735585394103 , 9.7284909855e-05 , 0.00328268295407 , -0.00141050489932 , -0.000391211809749 , 0.00486873728263 , 0.0032794349963 , -0.000379601584279 , -0.00223617875175 , -0.000766626867281 , 0.00232902754378 , 0.000274255895782 , 0.0011641771231 , 0.0011134929744 , 0.00379507125873 , -0.00323838952533 , -0.00138181028008 , 0.00332479391829 , -0.0017945218132 , -0.00555855178876 , 0.00289546242549 , 0.00164258286498 , 5.91072014677e-07 , 5.97876966765e-05 , -0.000706980474101 , 0.0010402297379 , 2.01097926099e-05 , -0.00395028286036 , -0.00589672017219 , -0.00267092401237 , 0.000167755719611 , 0.00175584744114 , -3.57799085889e-06 , -0.00118191435324 , -0.00269224463175 , -2.64745772273e-05 , 0.000406977866341 , 0.00415500486795 , 0.00157051458669 , -0.00204993063737 , 0.00015222247546 , -0.00439776095547 , -0.00395883500621 , -0.001260943673 , 0.000947069102209 , 0.00446723549849 , 4.13458876052e-05 , 0.00055375674722 , -0.00279045397358 , -0.000949003581024 , 3.52185482928e-07 , 0.000343166324653 , -0.00343997441093 , -1.53034702296e-05 , 0.0049492365146 , -0.00271452342181 , -0.000264325368104 , -1.48152648673e-05 , -0.000657197753944 , 0.000604436682728 , 0.00556085119806 , 0.00503497154187 , -0.00158905668522 , -4.457513714e-05 , 0.00309968448359 , 0.000227377880445 , -2.58967602307e-05 , 0.00283016185452 , -0.00245140642481 , -0.00762885490974 , 0.00202355503015 , -0.000554260888288 , 0.000292710618376 , -4.18498865075e-05 , 0.00190385327419 , -0.001845148313 , -0.00369464288035 , 0.00139815839242 , 0.0017060547105 , 0.00151916936441 , 0.00149381838493 , 0.00164950728218 , -0.00111684638282 , -0.00244925839625 , -0.00408195831075 , -0.00101132111306 , 0.00349503161527 , 0.0031712247941 , -0.00113521541719 , 0.00756248771167 , -0.00198516159106 , 0.00454596207555 , 0.00375633719362 , -0.00704103649794 , -0.00305762759374 , 0.00642197338323 , 0.0060112605585 , 0.000512142721856 , -0.00171701040676 , -0.000271501989351 , -0.00600338357697 , -0.00075527419657 , -0.00580274706756 , 0.00100065124609 , 0.000688423416395 , 0.0016132656411 , 0.000509454404174 , -0.00721469740035 , -0.00272385274002 , 0.00635896018589 , 4.25194086465e-05 , 0.000434521283812 , 0.00241054161636 , -0.000198120762898 , -0.000878425943634 , -0.000320457858656 , 0.00575225607256 , 0.00647949175448 , 0.00366126251852 , 0.00219260870847 , 0.000562103056432 , -1.59357275344e-05 , -6.21358640385e-06 , 0.00243910895564 , -0.000630089967276 , 0.00196795229303 , -0.00457003149673 , -0.00279132273127 , 8.78904636818e-05 , -0.000930298842452 , -0.00588407526156 , 0.00059207931688 , -0.0023332167532 , 0.0017886111637 , 0.00484280552898 , -0.00260394413782 , -0.00345526587978 , -0.00699165905666 , -0.00289037385341 , -0.000282298039185 , -0.0018359744626 , -0.00025696551251 , -0.000541793618735 , 0.00592307222327 , -0.00108962343523 , 0.00299142293118 , -0.00249851200384 , -0.000481863242909 , -0.00236441629868 , 0.00258690205162 , -0.00090376890025 , -0.00458720544244 , -0.0012870365814 , -0.00566563935837 , 0.00218083448538 , 0.00657680149973 , 0.00340836988739 , -0.00152918330659 , -0.00474984571472 , 0.00189365884961 , 0.00428191464426 , 4.58381855091e-05 , 0.00360748706252 , 0.000249644632505 , 0.00226852485653 , -0.000728032738047 , 5.96747064004e-05 , -0.00214162107421 , -0.000178363626369 , 0.00127698283072 , 0.00596179049968 , 0.00508698282873 , -0.000930839397219 , 0.00239024681856 , 0.00176707206879 , 0.00506662160488 , 0.00338115636779 , 0.00181296622148 , 0.00116429905023 , -0.000181617168002 , -0.00436129863766 , 0.00463045412672 , 3.41753852645e-05 , -0.00146817898208 , 0.00342265523689 , 0.000149435882773 , -0.00486720524121 , -0.00110528545345 , 0.00215975280963 , 0.000454089800899 , -0.000697895781633 , -3.84815755915e-07 , -0.00175230792992 , 0.000208617324063 , -0.00016770222798 , -3.02403216635e-05 , 0.00861231656216 , -0.00114094276988 , 0.000647850710233 , -0.007650806193 , 0.000214986932749 , 0.00554195670643 , -5.58017436719e-05 , -0.000214751999419 , -0.00408244565008 , -0.00129071626484 , -2.76613988479e-05 , 0.000429019224257 , 0.000338409020481 , 2.82590394756e-05 , -0.000958815548281 , 0.00521385518749 , 0.00139072268839 , -0.00207386253744 , -0.00236091297519 , -0.00504742166955 , 0.00152581731078 , -0.0020201356382 , 0.00232320952966 , -0.0032714841604 , 0.00145966656151 , -0.00563510995565 , 3.71273446001e-05 , 2.53857783159e-07 , 0.00279837018204 , 0.000244978629117 , -0.00115250609678 , -0.00168397662336 , 1.12046715211e-06 , -0.00114359868074 , 0.00248182864195 , -7.33436525205e-05 , -0.00283052475023 , 0.00259884513027 , -0.00287404514814 , 0.000689293314236 , -0.000775941984454 , 0.00141013266117 , -0.00101254980922 , 0.00109771610951 , 0.00179212638295 , 0.00222284772412 , 0.00539264696138 , -0.00363368775894 , -0.000536509540225 , -0.00101100267142 , -3.46722632757e-05 , 0.000812239473362 , 0.00149434004886 , 0.00152492838192 , -0.00677589284683 , 0.00483262053672 , 0.00294111065398 , -0.00236451488055 , 0.00488057201674 , -0.000553677084378 , -0.0038059566467 , 0.00101997899087 , -0.000407558990068 , -0.00170301480355 , -0.00139958573213 , -9.67603505033e-05 , -0.00404386354656 , 0.000153087551006 , -0.00100232856607 , 0.00262380642069 , -0.000501321635219 , 7.75106907315e-06 , -8.47349675928e-05 , -0.0016100233208 , 0.00269011673233 , -0.00505056772586 , 0.00145493035683 , 0.00244440622706 , 0.00753185586234 , -0.000283456497172 , 0.00194771668348 , -0.0030830449606 , 0.00253405687566 , -0.00476731213022 , 0.00463204828219 , -0.00198567109773 , -0.00571981834603 , -0.0062286150347 , 0.00106199201257 , 0.00589649559237 , 0.00364875236852 , -0.00198848965068 , -0.00237675351973 , -0.00084689726909 , 0.00048223860141 , -0.00376977358006 , 0.0013296222749 , -0.00239307823427 , 0.000893828947795 , -0.00469661364148 , 0.000332855559452 , 0.00134272953387 , 2.19738636557e-06 , -0.000440191705297 , 4.89160091263e-05 , 0.00172512852247 , 0.00151106235705 , 0.000627339786193 , -0.00635401482431 , 0.000527465938373 , 6.86786218176e-05 , 0.000913543582332 , -0.00243966246787 , 0.00148506298581 , 0.00041382062117 , -0.00137044254107 , 0.00253867472895 , 0.00246847094878 , 0.000115269220924 , -0.000554368667357 , 0.000530359252311 , -0.00332941429009 , -0.00169258402337 , 0.000722287354 , -0.000160805656704 , -0.00605586192584 , -0.00390955297732 , -0.000578811207986 , -0.000402605507785 , 0.00489925072988 , -0.00247538467107 , 0.00371008758919 , 0.00461220048936 , -6.3206046736e-05 , 0.00520019766046 , 0.00035651726538 , -0.00116130683144 , 0.00331227997443 , -0.00110211050504 , 0.00568002617136 , -0.00165309432092 , -0.000491134473954 , -0.00194886389883 , 0.00516016690181 , -0.00347892906574 , -0.00315306002176 , 0.00241882278234 , -8.60997512567e-05 , -0.0030298620893 , -6.17661769135e-06 , 0.00167339010973 , 0.000429129239901 , -0.000585052424717 , -0.00429448906443 , -0.0067261896121 , -5.71632235225e-06 , 0.00452272363339 , 0.000888722064406 , -0.0039955073427 , -0.00124083861607 , -0.00100354382258 , -0.0020071931537 , -0.000504527550937 , 0.00222351025458 , 0.00139028264739 , -0.000904828912086 , -0.000183247689172 , -0.00124093567451 , 0.00390675435325 , 0.00304942377333 , 0.00361382575697 , 0.00228326837384 , 0.00221903278307 , 0.00130336663291 , 0.00107418603668 , -0.00394610722547 , -0.00165237767612 , 0.00305880992349 , 0.00279361590004 , 0.000650292704702 , -0.00521917158412 , -0.0010342840639 , -0.00312402118934 , 0.000607058604322 , -0.00171267881197 , 0.00056976457929 , 0.00400779984674 , -0.00323957919321 , -0.00409536091984 , -1.52817783413e-05 , 0.00032951906078 , -0.00144432857727 , -0.00100627373226 , -0.00249671393525 , 1.3658005584e-05 , 0.0011252459295 , 6.30825894474e-05 , 0.00437956741139 , 0.00385355673251 , -0.000420890443928 , -0.00140853045281 , -0.00225454794715 , -0.000162158458912 , -0.0026685393522 , 0.00404588061617 , -0.000113703943086 , -0.00146685774855 , -0.00222414337532 , 0.00232855730906 , 0.000759733352285 , 9.60211149219e-05 , -2.17235167531e-06 , -1.36131194543e-08 , 0.00475270737809 , 0.00313973972793 , 0.00127366765736 , 0.000244169873385 , 5.70261038013e-05 , -1.99063032137e-07 , 0.00177029347473 , 0.00216296642158 , 2.90174284507e-05 , 0.000461892483812 , -0.000621385026483 , 0.000697831407789 , -0.000369909507809 , 0.00602742048465 , 0.00442001397287 , 5.45387075517e-06 , -0.00226605840914 , 0.00164550816042 , -0.00371560455084 , -0.000275539540129 , 0.00287757401821 , -0.00212052507601 , -0.00527961275264 , 0.00127792190422 , -0.000148646982071 , -0.00148429293919 , 0.000590414534855 , 0.00351205941929 , -0.00410207343633 , -0.00179706456916 , -0.0017135738886 , -0.000253107167422 , 0.00260925229873 , 3.58672397574e-05 , -0.00795292802189 , 0.00147291751565 , 0.00281834714695 , -0.00387283208274 , -0.000263094663047 , -0.000117246577531 , -0.00018121291595 , 0.00240355044868 , 0.00431161199303 , -0.000205055554544 , 0.00421676439137 , 0.00230216384385 , 0.00576414898869 , 0.000190246986577 , 0.00399317424615 , 0.00315605823108 , 0.00470676007642 , -0.000208741001014 , -0.00451778600311 , 0.00783050032582 , -0.00442426002628 , -0.00542671530936 , 0.00424583721902 , -0.00175588985422 , -0.00484591745748 , -0.000315892821262 , -0.00247463299107 , -0.000115078490517 , -0.00485754751496 , -0.00299160737666 , 0.00166963634143 , -0.00516062863466 , -0.00165920982151 , -0.000750647767296 , -0.000154097887799 , 5.12557495871e-05 , 8.90205740988e-05 , -0.00488933920863 , -0.00147731627512 , 0.00159960359038 , -0.000471919494938 , -0.00398070053975 , -5.32197281587e-05 , -0.0049260209284 , -0.00405879555859 , 0.000617908463609 , 0.00488969703546 , 2.16018572264e-06 , 0.00100733720224 , -0.00463501075654 , -0.00483121777033 , 0.000378931522588 , -0.000549243456281 , 0.000820288714655 , -0.00485786129862 , 0.000470912392078 , 0.00592617064569 , -0.0059545913548 , -0.00917664192334 , -0.00598309816198 , 0.000772549639594 , 8.46286747654e-06 , 0.00116221129368 , -0.00029180940524 , -0.000243897234989 , 0.0011439878997 , -0.00258035458694 , 1.77649526931e-05 , 0.00102831100916 , 0.000345759516493 , -0.00397667439928 , -0.00169274985137 , -0.00044342823804 , 2.13487992275e-05 , -0.00419857508862 , -0.000653911803922 , 0.000164305615663 , 0.00130990313235 , -8.80908655683e-06 , 0.000446475105485 , -0.000683585668955 , -0.00605949788807 , -0.000459943787933 , 0.000150170046513 , -0.00317287060833 , -4.87094188904e-05 , -1.83336358006e-06 , -0.000985834381258 , -0.000931787841907 , 0.0069842542102 , 0.00148134835185 , 0.00104234039326 , 0.00139470816243 , 0.00208323857171 , -0.00122630506769 , 0.00562643339785 , -0.00396361268108 , 0.00395526693896 , 0.000454121375483 , -0.00378505394284 , -0.00273928505755 , -0.00102178085586 , -0.00348915173227 , 0.00030464930329 , -0.00121968928709 , 0.00239012299711 , -0.000295762318734 , -0.00161457251452 , -0.000636963589798 , 0.00343991099209 , 0.000761335039748 , 0.00380269053532 , 0.000338021554624 , 0.00126653699615 , 0.00343600939391 , 0.00733641691708 , -0.000466833066078 , 0.00339192796441 , 0.00313240473365 , 0.000419531889933 , 0.00245653937326 , 0.0014647955081 , 0.0019178738273 , 0.000537873040554 , -0.000136907797724 , -0.0010182220794 , -0.00048347498223 , -0.00119286121727 , -0.00374948976061 , -0.00314282492632 , 0.00151348289545 , 0.00330683395715 , 0.00345919804794 , 0.00363269858278 , -0.00500831775812 , -0.0014652141198 , -0.00154359559818 , -0.00216781017348 , -0.00201328148868 , 0.0017731323515 , 0.00418677381886 , 0.000252494612352 , -0.000817857364052 , 0.00177743704857 , -0.0034481353991 , 0.000319155303294 , -5.28142593541e-07 , -0.000293252637389 , -3.48749214577e-05 , -0.00456219075667 , 0.000472529286001 , -0.00328072528763 , 0.000862006997032 , 0.000151404561148 , -0.000263189881814 , -0.00107833867483 , -2.66405693035e-06 , -0.00136632599364 , -0.000913097073176 , 0.00062966407921 , 0.000665835886316 , 0.00310191550097 , 0.000305475405663 , -0.000522604018279 , -0.000160045126724 , -0.000291076914101 , -0.000297754337769 , 2.69989792592e-05 , 0.00200336068447 , -3.76931496592e-05 , -0.00498767493831 , -3.39113391077e-06 , 0.00151426852458 , -3.23768677931e-05 , 0.00120308191839 , -0.00187448171603 , 0.000345969941893 , 0.00171340095194 , -9.92112405353e-07 , -0.00375127451661 , 0.00150608320312 , 0.000457834314806 , 0.000763905916294 , -0.00096237852437 , -0.000182019224968 , 0.00276654097767 , 0.00439428343983 , -0.00211217408572 , 4.75151154973e-05 , -0.00261136050898 , -0.000249168819434 , 0.00778731732978 , 6.58398017258e-05 , 0.00216335209483 , -0.000413154981873 , -0.0027683475881 , -2.4790894248e-05 , 0.00634998020095 , 0.00238064831232 , -2.1102543113e-06 , -0.000589620984316 , 5.39114712063e-06 , 0.00018358279773 , 0.000975981068219 , -0.00527156580968 , 0.00147420479187 , -0.00156288992664 , 0.00362933622414 , 0.000298728685808 , -0.00349886438315 , 0.00030820659697 , -0.000378790392074 , -0.00318917393551 , -0.000948667675959 , -0.0010775600928 , 0.00223613959278 , -7.85245342615e-05 , -5.12609618333e-05 , 0.000349442292598 , 4.58323788256e-05 , -0.00412836966855 , -0.00455312742074 , 0.000188284106843 , 6.3054649893e-05 , 7.6298825204e-05 , 0.00245346009779 , -1.27921429436e-05 , -0.00350242907279 , 0.000648669900736 , 5.99717585385e-05 , -0.00234494369405 , -0.00013162845417 , -5.12413413137e-05 , -0.00402852631513 , -0.00135063921239 , -0.00324242844059 , -0.00010445939074 , -0.00266205115741 , 0.000981226744154 , -0.0025198238362 , -0.0014771900144 , -0.000174752466698 , -0.000133552987977 , 0.00150497269203 , 0.00544302455545 , -0.000106578065677 , 0.000333869840982 , -0.000449009253076 , -0.00724495203502 , 0.000126806873096 , 0.00228143514529 , 0.00264122393787 , -0.0016376884762 , -0.00179105159277 , -0.00119415697554 , 0.00526316065218 , -0.00190868650715 , 1.72075432014e-05 , 0.00331260524784 , -0.00332190537829 , 0.000174357601116 , -0.000697856284457 , 0.00367504619392 , 0.00428937437563 , 6.31475752217e-06 , 0.0043302595521 , -0.00271037001193 , -0.000900763455043 , 0.000526586330652 , -1.0408475834e-05 , -0.00117489384813 , -6.53651467111e-05 , -0.00531810347066 , 0.00419979617773 , 0.00629801244975 , -0.000357788487935 , 0.00118124763247 , 0.00189013570196 , -0.00551057913677 , 0.000400936006677 , -1.27811477675e-07 , -0.00543608733314 , 0.00340612090129 , -0.00525127374238 , 4.83876035054e-06 , -0.00325074038715 , 0.00383472992114 , -0.000858480148372 , -0.000774093558558 , -0.000875324783736 , 1.11549124134e-06 , -0.00501556167035 , 0.00326085355907 , -0.0059112711669 , -0.00425347966183 , 0.00102475620339 , 0.00120654075917 , 0.00107938028885 , -0.00403788096576 , -0.00283308608478 , -1.71696851921e-05 , 0.000896373817416 , -0.00116543457539 , 0.000950407010835 , -0.00567875623478 , -0.00130935436068 , -0.00258275256366 , -0.00465153169223 , -0.00038681810028 , -0.00222990938635 , -0.00246205979123 , 0.00261074699306 , -0.00105858437948 , 0.00397691226024 , 0.00333469544742 , 0.000241991376997 , 6.25605890713e-05 , 0.00685526292304 , ])
Y_4_m4_imag = flex.double( [ -0.0 , -0.0 , -0.00415786117878 , -0.00329990760694 , 0.00442207053881 , 0.00256034981417 , -0.00526015350311 , -0.00230803857166 , -0.00244162966409 , -0.00579975531358 , -0.00181551755288 , 0.000144442663717 , 0.000177767412411 , 0.000365261091016 , 0.000210655540355 , 0.0015127072527 , 0.00490223787836 , 0.000334224037112 , -0.0031906643223 , -3.06818955129e-05 , 0.00283077204106 , -0.0047523868142 , -0.00516187719101 , 0.00118925366784 , -0.00822959310387 , -0.00113425841634 , 0.000253878037117 , 0.00113710296699 , 0.000701974268894 , -7.1436412172e-06 , 9.34934610951e-05 , 0.00151925367958 , -0.00110394248996 , 0.00245273748637 , -0.00448508208454 , -0.00326670034792 , -0.00240650051144 , 2.18846549193e-05 , 0.000329761640276 , 0.00359948121079 , 0.00444739563587 , 0.00375391030134 , 0.00190547995367 , 0.00107542707887 , -0.000666149503236 , -0.00461715775877 , 0.00132428179958 , 0.00303355966788 , -0.00430230367548 , 0.000637778435063 , -4.94794863918e-05 , -0.000513521312602 , -0.00412934915996 , 0.00260826347259 , 0.00280637323179 , -1.86852525153e-05 , -0.000115861483467 , 0.000423283060879 , -0.000663674506829 , 0.0067261806078 , -0.00341534152854 , 0.0067922680659 , 3.59035203821e-05 , -0.00170582678466 , 0.000382166359796 , 0.00114748072027 , -0.0040224421115 , 0.00103612573518 , -0.00114191048011 , 0.00374528082772 , 0.0025991367281 , 0.0011869319362 , 0.00387981738266 , 0.000375550598488 , -7.54152446477e-06 , -0.00175242845722 , 0.000692636588577 , -0.00642686978357 , 5.7553110438e-08 , 5.50521581032e-05 , -8.17892522447e-05 , -0.00400508480042 , -0.00202406662775 , 0.0027300712123 , 0.00394282912904 , 0.00462340351783 , -2.26411856835e-05 , -0.00160232112514 , -5.75113027676e-05 , 0.00159663031439 , 0.00226105578723 , -0.000273362463827 , 0.00118607238088 , -0.000251823692702 , -0.000870390759358 , 0.00297260522539 , -0.000108710364523 , -0.00444557053462 , 0.00280407890607 , 0.00119749647791 , 0.000978958858752 , -0.000528831307512 , -0.00178062372362 , 0.00131805733826 , -0.0040535165485 , 0.000973469101494 , 0.00293308254344 , 0.00328113450462 , 0.00397517620858 , -4.54207797422e-06 , -4.93893900989e-05 , 0.000355433392436 , -0.00327045239925 , -4.19671048958e-05 , -6.35386839957e-05 , -0.000839338187155 , 0.00178974014432 , -0.00284020130277 , 0.00158139500019 , -0.00105107510692 , 0.000254242305474 , 0.000539016883652 , -0.000649469954623 , -0.000415320611701 , -0.0012207940356 , -0.00478803940871 , 0.00677553871633 , -2.80411182737e-05 , 0.00513409337383 , 0.000216229482061 , 0.0024681421958 , -0.00295224958662 , 0.000644291276267 , 5.61705376169e-05 , -1.57788864056e-05 , -0.00358530511694 , 0.00375050617425 , -0.00378152316307 , 0.00233889155192 , 0.00184948179407 , 0.000614379842019 , -0.00555497932877 , -0.00219478871922 , 0.000262654701001 , -0.00635285477494 , -0.000462873216404 , 0.00418269656399 , 0.00467918862926 , 0.00151865507228 , -0.00175706915202 , 0.000197452952414 , 0.00411233469802 , 0.000554997051635 , 0.00205682163477 , 0.00365499872701 , -0.00209610515702 , 0.00286793145753 , -0.000861129006995 , -0.00234992405163 , 0.00226062610625 , -0.00265655175627 , 1.84252896774e-05 , 1.80674542435e-05 , -0.00759078803261 , 0.00585448351203 , -0.00381462560019 , -0.00730980870398 , -0.000262165882251 , 0.00472967535712 , -0.000238720955092 , 0.00190514385765 , -2.56587860254e-06 , 0.00249127857615 , 0.000332833898554 , 0.000275626561877 , -0.000220447502522 , -0.00599788905345 , -0.00150385116172 , -0.00148084021275 , -9.105992968e-05 , 0.000680307150128 , 0.000129888403937 , 0.0063890194004 , -0.000364414469174 , 0.00194332182701 , 0.000136382561442 , 0.0006199403893 , -0.00207525251015 , -0.00757626197293 , 3.45826812228e-05 , 0.00248288064147 , -0.00103425322636 , -7.22369484804e-06 , -0.00174528011039 , -0.000911530609518 , 0.00137168166312 , -1.27523330947e-05 , 0.00057752664968 , -0.000995955683174 , -0.00387878326362 , -0.00238729824571 , 0.000212684511699 , -0.00305698876937 , -0.0043537424881 , 0.000218038644776 , -6.04390342393e-05 , 0.00101620665497 , 0.000119527740323 , 0.000433362870098 , -0.00121061036443 , -0.0012443602079 , -0.00012358123294 , 3.10382545068e-05 , -0.00355568250693 , -0.0030629709353 , -0.00465575809519 , -0.0042285166259 , 0.00113412288278 , 0.00143664992168 , 0.000302039065399 , -0.00589020179475 , 0.000699528171633 , 0.00106809080025 , 0.00448437763459 , -0.00442028452991 , -0.000652539768145 , 0.00230336461091 , -6.21175072834e-05 , -0.0027285031333 , -0.00107696952868 , -0.00188332076301 , 0.0033955750531 , -0.000659467947785 , 0.00286983702319 , -0.000618255649164 , -0.00259608274416 , -0.00033576930814 , 0.00209375845657 , 0.000524966220829 , 0.00256913868286 , -0.00411420276639 , 0.000584723385479 , 0.00426829876494 , 0.000820234172303 , 0.00195505185505 , -6.84554839561e-05 , 0.000194045038806 , 0.000176046428408 , 0.00249234636225 , -0.00582042862569 , 6.4848395556e-06 , 0.000188570410281 , -0.000147793389544 , -0.00534679788972 , -9.8152981965e-05 , 0.00139145743712 , 0.000937984957072 , 0.00266868081778 , -0.00309956453261 , 0.00179995041029 , 0.000721137279023 , 0.000371764780396 , -0.0015526899081 , -0.00474635277108 , 0.00245503410576 , -0.00244684548538 , -0.000994891844518 , -0.000475862413232 , 0.000954403528349 , -0.00127661823655 , -0.00449344732372 , -0.00218114595356 , -0.000803117993431 , 0.000661771906596 , -0.00214738318126 , -0.0016368931197 , 0.00324397165145 , 0.00539677981368 , -0.0025644870661 , -0.00328077253062 , -0.00450491295819 , -0.00156709156272 , 0.0037138350011 , 0.00144669693363 , 0.00619384843528 , 0.00246814833637 , -0.00193329791696 , 0.00404110139482 , -0.00409071546767 , -0.00339819047979 , -0.00220429524656 , -0.000346796378287 , 0.00300816039252 , 0.00587784416922 , -0.00151753196249 , -0.0048946161404 , 0.00141378839713 , -0.0043397585413 , 0.00310193591004 , -0.000569588011443 , 1.08834863293e-05 , 0.000345439601955 , 0.00141405726679 , 0.00769892243435 , 0.000111836964377 , 0.00215176675677 , -0.000134276775684 , -0.00054626747526 , 0.0043791826374 , -0.00252738164741 , 0.00388057520476 , 0.00456352742463 , 0.0051178271783 , -0.00439947636168 , -0.00646255074932 , -0.000488495575602 , -0.000909464033524 , -0.0027284387037 , 0.00119895261193 , -0.00218422875274 , 0.00210846923928 , 3.37365302386e-05 , -0.00338823033035 , 0.00356809829607 , -0.000369486627279 , 0.000888243102872 , -0.00562007169133 , -0.00174072491118 , 0.00113591255154 , -0.00251920156899 , 1.98203838847e-07 , -0.00197081755278 , -0.00155978678627 , -5.76875889766e-05 , -0.000297921766308 , 0.00280312207547 , -0.00419909631999 , -5.41956426048e-05 , 0.00273177693039 , 0.00101291063796 , -0.00100682512061 , 9.45125589855e-05 , -0.000894958449903 , 0.00385547598059 , 0.000229496520762 , 6.18608495003e-05 , 0.00435053370242 , 0.000221252883269 , 0.00541425602188 , 0.000506674302005 , -0.00188589722967 , -0.00455473252379 , -0.00192995856664 , 0.00140156151857 , -0.00331325178598 , 0.00606780025142 , -0.00274692076421 , 0.00582107964997 , 0.00058378965153 , -0.00222337057194 , -0.0056897046096 , -4.2638614366e-05 , 1.01501008434e-06 , 0.00400594549062 , 0.00553208562587 , 0.00225636851365 , -0.00492161571789 , 1.75040083351e-06 , 0.000951831199016 , 0.0027436457418 , -0.000473535929485 , 0.00284501948447 , -0.0024833372806 , 0.0061749137409 , 0.00442624182347 , 0.00556729109821 , 0.00328758790624 , 0.00289776163366 , -0.000310203216231 , -0.00180952444141 , -0.0032387205369 , -0.000775121429746 , 0.00152162405964 , -0.00465063548983 , 0.00209467475884 , -4.61609253563e-05 , 0.0014352729922 , -0.00158554036569 , 0.000306877116566 , -0.00388354368365 , 0.000606631016318 , -0.00257030479271 , 0.000529561459433 , -0.00540349628819 , 0.000544457558725 , -0.00492131231631 , -0.000297022180637 , 0.000473169951122 , -0.00413756601306 , -0.00539265319977 , -0.000719181234628 , 0.00573042444342 , 1.35591476027e-06 , 0.00242676417891 , -0.000642517236548 , 0.000765586697081 , -1.78146196989e-05 , -0.0002068323019 , 0.000929239368748 , -0.0030707571142 , -0.00055293061423 , -0.00523086755245 , 0.00366457727758 , -0.00130513894289 , -0.000146530919501 , -3.06768623168e-05 , 0.000307669224966 , 0.00612027170134 , -0.00155665825022 , 0.00228750412797 , -0.00254938809195 , -0.00037568084199 , 0.000138215876663 , -0.00346942634428 , -0.00111167467976 , -0.000389157452446 , -6.83611815689e-05 , 0.00220535839262 , -0.000701050499703 , -0.000683979503031 , -0.000266357375291 , 0.00472875556526 , -0.00333064533168 , -0.00636937356131 , -0.00216113434383 , 0.000146273858726 , -0.00545524096151 , -6.25424302726e-06 , 0.00728058708044 , -0.000101304340561 , 0.002861717335 , 0.00113830221076 , 0.00080386217733 , 0.000289160125684 , -0.00081588389484 , -7.83770799479e-05 , 0.00042002451829 , 0.00309202988387 , -0.00392940603803 , -6.87912467642e-05 , 0.000414028416321 , 0.00529801005971 , 0.00304899105441 , -7.20894422013e-05 , 0.000773330219031 , 0.000527629032838 , -0.000687201327123 , -0.00132437351406 , 0.00429566315358 , -0.00177025046678 , 0.000746485840571 , 0.00354097953454 , 0.000810124218319 , -0.000598865306995 , -0.000240987808652 , -0.00337499676921 , -0.000203637078938 , 0.00468059232114 , 0.000194854950744 , -0.00478002063336 , 0.000341939372032 , 0.00194523705351 , -0.000653472824197 , -0.00686608952374 , 0.00118437170438 , -0.000402520436019 , 0.00499416568983 , 0.00361106432726 , 0.006215555302 , 0.00414285483815 , -0.000439053346251 , 0.00114794057832 , 0.00036429288293 , -0.00136249742868 , -2.11350862017e-06 , -0.0014808755218 , -0.00154171033389 , 0.00557669536499 , 0.00318326249522 , -0.00261084965803 , 0.00549961261745 , -0.00503135625583 , 0.00123649283902 , -0.00204390078188 , 0.00191352420496 , -0.000761225657542 , 0.00148117694808 , -4.01431214705e-05 , 0.00271896408529 , -0.0050153750609 , 0.000117621243658 , -0.000463644906309 , -0.000232416243115 , -0.00376126366514 , -0.00127786715622 , 0.000491796760854 , -0.00124430582684 , -0.00275869119041 , 0.000922128454449 , -0.000506150354962 , -0.00143727178552 , -0.00752335177583 , -0.000450120852222 , -0.00227995252191 , -0.000877824540766 , -0.00559813948068 , -0.00225910072873 , 0.00381591505092 , -0.00155361431099 , 0.00752843078787 , -0.00227215596197 , 0.00814850418641 , -0.00129572650475 , -9.80587849591e-05 , 3.52130744409e-05 , 0.000516603902284 , -0.00110319122261 , 0.00273290950653 , -0.00719547122474 , -3.46737227505e-06 , 0.000180223495433 , -0.000415316059532 , -0.00166401036482 , -0.00261702901818 , 0.00408917673512 , 9.99505793817e-05 , 0.00156464632676 , 1.11717429587e-06 , -0.0035606762209 , 0.00424799071595 , -0.000912264576442 , 0.00288591934548 , -0.00457041994941 , -0.0055477560402 , -0.000188676032655 , -0.00611694748827 , 0.000114628550599 , 7.56104266435e-09 , 0.00228822855006 , 0.0068163494836 , -0.00286286540063 , 0.00140763195476 , -3.72686114049e-05 , 9.31474570585e-07 , 0.00103565650061 , -0.000118261092262 , -0.000102721816662 , -0.00215000396239 , -0.000132260447863 , 0.00172399428635 , 1.36452000856e-05 , -0.0030592079006 , -0.00158685004543 , 2.39769581214e-05 , 0.00643765478669 , -0.00248695534219 , -0.00110722597673 , 0.00177400482413 , 0.00183249952015 , -0.00434073303659 , 0.00347586635192 , 0.0021991687106 , 0.00537169813453 , 0.00509077200005 , 0.00352693076213 , -0.00379232190506 , 0.00232627349629 , -0.00220328586207 , 0.00272925940229 , 0.000134139179878 , 0.000585899386689 , -0.000409293051881 , -0.000602224597545 , -0.00572509653513 , 0.00387150616065 , 0.0042690806086 , 0.00223753290891 , -0.00246293480898 , 4.4613927937e-05 , 0.00118835775104 , 0.00247099183621 , -0.00121405355674 , -0.000173821856067 , -0.00523079691851 , 0.0040603550038 , -6.45591630973e-05 , -0.00360039297104 , -0.00254285964145 , 0.000351458480405 , -0.000126186579406 , 0.000306036458536 , 0.00379932997958 , 0.00242651561146 , -0.00190977046778 , 0.00111024889641 , 0.00440112545155 , 0.00025617480494 , 0.000104898683605 , -0.00105053181859 , -4.35297165137e-05 , 0.00327874200679 , 0.0043183789687 , 7.27697673337e-05 , 0.00218518104582 , 0.000486555565323 , 0.00517916586301 , 0.000138260228757 , 3.58769213749e-05 , 0.0041007656291 , -0.00489424398159 , 0.000634973461475 , -0.00413390328057 , -0.000172187022186 , 0.00106861560532 , 1.40984274818e-05 , -0.00100508696228 , -0.0012145670044 , 0.00137962986256 , -0.0021136282046 , -5.7794474589e-07 , 0.00278257921514 , -0.00383336464192 , -0.00184648770247 , -0.000242560021274 , -0.00286368092331 , -0.00573798876533 , -0.00254096248852 , -0.000611101930679 , 0.00211036261826 , 8.40966286697e-05 , -0.00190594084617 , -0.000232598411138 , 0.000572622531529 , 1.62766892034e-05 , -0.0027097672541 , 0.000187430476358 , 0.00407055373229 , 0.00229553571532 , -0.0035484935796 , -0.000115665858493 , 0.00215241408715 , 0.00300139316424 , 0.00252524316889 , -0.00486051558368 , -0.00269253389818 , -0.000201753755828 , -0.00207040198324 , -0.000450123312611 , -0.000226354934042 , 0.00062054930195 , 7.83335829167e-06 , -0.000360856298464 , 0.000535318630394 , 0.00229477314011 , -0.000709862372522 , 8.53749948307e-05 , 0.00583037400213 , 4.86147233483e-05 , 5.80364323333e-05 , -0.000176596300436 , 0.000209288405595 , -0.00161631282254 , 0.000268241648244 , 0.000345806666782 , -0.00340632629865 , -0.00513397298873 , 0.000691915932882 , -0.000232963987361 , 0.00269962427238 , -0.00105566576653 , 0.00628030286542 , 0.0018055277303 , 0.000141749698984 , 0.00358455643855 , 0.00476349622633 , 0.000913851725338 , 0.00233087167597 , -0.0037057709248 , -0.000540747385827 , -0.00406829360549 , -0.000763556058948 , -0.00263015516456 , -0.000675712929863 , -0.000160760252357 , 0.00146019031354 , -0.00514644046559 , 0.000583679474617 , -0.00423512885838 , 0.000332529395045 , 0.00421091768184 , 0.00414313165506 , -0.00567419856594 , -0.00495330603492 , -0.00448819568864 , 0.000685015576761 , 0.0025537031066 , -0.000389423985609 , -0.00146737197692 , 0.00566177054091 , -0.000789316675739 , -0.00306380955741 , 0.00334863126691 , -0.00665780816763 , 0.0027107632595 , 0.00542239803674 , -0.00680222775384 , 0.00514864977865 , -0.00548951443567 , 0.00314416469704 , 0.00101382676849 , 0.00144927739419 , 0.00287920606404 , 0.00055026089097 , 0.000258864328889 , -0.000538125653562 , -0.00194872486518 , -0.00480081124498 , 0.00553502704779 , -7.03324530175e-09 , 0.00269656262246 , -3.55031769397e-05 , 0.00231932583827 , -0.00141219089002 , 0.00186143910899 , -0.000569412858237 , 0.000584592719566 , -0.000388475743658 , 0.00393241344749 , -8.64547448269e-07 , -0.000687636696685 , -0.0037636199501 , 0.00431165264033 , 0.000331018498256 , 0.00366371721636 , 4.24011126019e-05 , -0.00157160474713 , -5.38577195436e-05 , -0.000349553024345 , 0.000628739149859 , -0.000125269724045 , -0.00129427514541 , -0.000770590777615 , -8.12147238368e-06 , -1.98270150668e-06 , 0.0027909964455 , -7.84852998326e-06 , 0.000186151592 , 0.00319262732545 , -0.00198348299968 , -0.00022889851064 , 2.123497012e-06 , 0.00542578946441 , -0.00136674113578 , 0.000732917503599 , -0.00319380627082 , -0.0040476829124 , -0.000292412717319 , 0.00150940496216 , 0.00682506097219 , 0.000194547414688 , 0.00221112674741 , -0.00237958072801 , -0.00253742631972 , 0.00133013466787 , 0.0004053368508 , -0.0014203780442 , 0.00135582851489 , 0.00785518721284 , -8.44141325238e-06 , 0.000250150474383 , -0.00310458559891 , 7.88613134878e-06 , -0.000383834629078 , 5.14564060213e-06 , -0.00230214239065 , -0.00175710284589 , 0.00211621627189 , 0.00214346418336 , 0.00162296271718 , 3.81949966489e-05 , -4.49429419348e-05 , 0.00229674461831 , -0.000594352539823 , -2.52185310962e-05 , -0.00430316832359 , -0.00102490409488 , -0.00128146269512 , 0.00510734446192 , 0.000304405534903 , 8.90905150555e-05 , -0.000858120395713 , 5.35306623344e-05 , -0.00631854439337 , -0.000592260395063 , -0.00155700900437 , 5.38026536184e-05 , -0.00221725941033 , 4.68955405126e-05 , -8.28359536559e-05 , -0.00172934594051 , 0.00419771456596 , -0.00216927244357 , 0.00925436800355 , 0.00096031896076 , 4.4741884688e-05 , 0.00127010022472 , -0.00512669089329 , -0.00421624225996 , -0.000436421496165 , 0.00589468952698 , 0.0047343577225 , -6.85063565483e-05 , -0.000248843858847 , 0.000120931326266 , 0.000296509630033 , -0.0007263817513 , 0.00379083081692 , 0.000666907403488 , 0.000332925540186 , 0.00300033266021 , 0.00540908274733 , -0.00114506715026 , 0.00489641808147 , 0.00262608318405 , -0.00143912626232 , 0.0059488739717 , 0.00325762808975 , -0.00134304876618 , -0.00597503589316 , -3.21510389631e-05 , -0.00278105419531 , -0.00432818632785 , -0.000396698396424 , 0.000725612812724 , -0.00236993970173 , 0.000221209620111 , -1.18450978781e-06 , -0.000505877520012 , -0.00416123022646 , -0.00100124718493 , 0.000472485302428 , -3.30045910955e-06 , -0.000698592872485 , -1.13447559058e-05 , 0.00180535581726 , 0.00310905454636 , -0.000308625427729 , -0.000155693835167 , 0.00634490448707 , 0.00176472978835 , -0.00115597510109 , -4.8707226904e-05 , -1.20819989677e-06 , 0.00381922339881 , -0.0016464719495 , -0.00293493649382 , 0.00117471912054 , 0.0011395173835 , -0.00188465351192 , -0.00761506845577 , 0.00449417164453 , -0.00120061329497 , -9.91285816475e-07 , 0.00285512949181 , 0.00434320215528 , -0.00437752749771 , -0.00238745684963 , 9.06274505164e-06 , -0.00493262848242 , -0.000379097520475 , -0.00277411098314 , -0.00424236641732 , -6.45108983147e-06 , 0.00526862823668 , 0.00129523843172 , -0.00179000099707 , 0.0022108566439 , 0.00257250543989 , 0.00121791477432 , -0.00138011904638 , -0.00311321799511 , -0.000106390287246 , 0.000551324570258 , -0.00630000393978 , -0.00646158394289 , -0.00464794544093 , -0.0014910710092 , -0.000180415811671 , 0.000220240659295 , 0.00240644838215 , ])
Y_4_m3_real = flex.double( [ 0.0 , -0.00172175876896 , -0.000808985198943 , 5.27828706019e-06 , -0.00537059602424 , 0.00508691347016 , 5.94286768152e-05 , -0.0037663799405 , 0.000123115689861 , -0.00137243691236 , 0.00486948055974 , -0.000784426269765 , -0.0013594485121 , -0.0012477088094 , 0.000350679454568 , 0.00097577759331 , 0.00505856913042 , -0.00126647564148 , -0.00153953024119 , 0.000434347661943 , 0.002736964017 , 0.000316038956585 , 0.000666310827422 , -0.00584972340219 , 0.0017473721071 , -0.00266132651855 , -0.00390425797743 , -0.000698016221028 , 0.00136979496653 , -6.34278095148e-05 , 0.00102466856373 , -0.00153771098145 , 1.13344496388e-06 , 0.00174034291747 , 0.00133791278164 , -0.00442151822737 , -0.00279956454574 , 0.000128346667317 , -0.000884621959123 , 0.000923916527077 , -1.02329724703e-05 , -0.00414063333334 , 0.00156759800053 , -0.00465981062765 , 0.0042712877306 , -0.00154980061918 , 0.005079277406 , 0.00378013823528 , -0.000387557490366 , 0.000930668524112 , -1.71110394159e-05 , 0.00475208318964 , -0.00693324801199 , -5.12170864921e-06 , -0.00603187325939 , 6.41902600036e-05 , 0.000274881489156 , 0.00201226674441 , 0.00270830589853 , -0.000368489116194 , 0.0016525096054 , 4.00849326758e-05 , -0.000436887224818 , -0.00354577042571 , 0.00362137722276 , -0.000148852906555 , 0.00104211026342 , -0.00403368294881 , 0.00191616493835 , -0.00243884457918 , -0.00463467521919 , -0.00108980038008 , -0.000867719602779 , 0.0026837737966 , 7.33440031568e-05 , -0.000165192015608 , 0.00233983193907 , -0.0029917208675 , 2.85875685793e-06 , -0.00169131138738 , 0.00132631763235 , -0.00471003314497 , 0.00542724599953 , 0.00382029964716 , 0.000594774967684 , -0.000839879485372 , -0.000184358265842 , 0.00254695339707 , 0.00129452589793 , -0.000666753389652 , 0.0016654956186 , -0.0017121533372 , 0.00351839925301 , -0.000644114395483 , 0.00344617664736 , -0.00384017283922 , 0.000775838666265 , 0.00146056351077 , 0.003344762791 , -0.00105519637495 , 0.0040269033852 , -0.00294554256546 , -0.00313036312284 , 0.000395980987915 , -0.000134226590912 , -0.00456283700906 , -0.00173533734429 , 0.000786024953628 , -0.00692360254514 , -0.000142286411224 , 0.000559431606819 , 0.000545482366863 , -0.00107102078385 , -0.000346316830454 , 7.76185257528e-05 , 0.00332468863988 , -0.00550500894268 , 0.00308936896757 , 0.00335327005488 , -0.00287815346778 , -0.00358253904662 , 0.000125892883081 , 0.00243633274265 , 0.00212354387714 , -0.00210446867299 , 0.000171907626202 , -0.00192495170839 , 0.000440468576092 , 0.00277010478363 , -0.00095233242228 , 0.00197243909904 , -0.00593966542084 , -7.91369794295e-05 , 0.000561177796458 , 8.10694468027e-05 , 0.00463661625067 , 0.00281766351331 , -0.000374463088973 , 0.00590512471151 , -0.00313286738629 , 0.00247617802822 , -0.0014122850501 , -0.000162357950853 , -0.000755288081786 , 4.97371227653e-05 , -0.00569689830592 , 0.00130128684815 , 0.000206445507195 , 0.00243274733736 , -0.0040616095761 , -0.000872186997922 , 0.00112503804466 , 0.0014867072902 , 0.00083741564844 , 0.000405051118722 , -0.00391864523113 , 0.0023937897568 , -0.0043130332194 , 0.00287684616422 , 0.00169203471735 , -0.00362681508546 , 0.000198526116236 , -0.000533902993061 , 0.000138088661236 , -0.000121517018886 , -0.00572662881826 , -0.000734662057337 , 0.00230572957292 , 0.00679351518906 , -0.00120083470579 , -0.00431299008651 , 1.89782367295e-05 , -0.00469789675788 , 0.00228630773259 , -0.00133061306385 , -0.00193234347186 , 0.0049197337579 , 0.00456878720967 , 0.00101700310615 , 0.000422299228825 , 0.000311813599205 , -0.00385547832891 , 0.00653592303324 , -0.00346071137371 , 0.000105073590729 , -0.000537672560296 , 0.00253851728828 , -0.00633573067475 , 0.00484438168849 , -0.000346036776525 , -0.00405762827332 , -0.00165000722791 , 0.000128321823869 , 0.00465908496945 , 0.00318279120424 , -0.00382541171971 , 3.88216449553e-05 , -0.00282357145562 , -0.00241923576053 , 0.00381751565628 , 0.00182722096718 , -0.0034744000123 , 0.00215662889601 , -0.00330983103317 , 0.00145091969294 , -0.000481963445777 , 0.00093179180847 , -0.00322979756085 , -0.00396550401782 , -0.00564416804145 , 0.000315623319516 , -0.000475010245908 , 8.98994695816e-05 , -0.00360352894413 , -7.26095232252e-05 , 0.00606277311406 , 0.00291782759635 , -0.00192268584348 , 0.00196081339359 , 0.00482860445155 , -0.00198711698046 , -0.00141516625965 , -0.00311465956693 , 0.000372634324949 , 0.00560025999325 , -0.000540270729866 , -0.00381458770651 , -0.00273665936093 , 0.000466110148937 , -0.00359831494266 , 0.00616729714042 , -0.00450949506774 , 0.00138855500667 , 0.00123505546912 , 0.00202301205988 , 0.000640300078062 , 0.000940359464251 , -0.00540160230926 , 0.00136967513328 , -0.00220023181535 , 0.00344671561888 , -0.000551426250605 , 0.00639921898511 , 0.0018264966501 , -0.00197030075428 , -0.000223529645282 , 0.00366385867711 , -0.00469433931195 , 0.00119782424181 , -0.00110492271964 , 0.00178740466827 , -0.000138586316676 , -0.000444837421144 , -0.00114054277463 , -0.000813776344522 , 0.00448263985488 , -0.00174456928333 , -0.000207749875463 , -0.00254109107388 , -0.00363961060678 , -0.00244203304575 , 0.00062790566493 , -0.00166001906066 , -0.00542925546465 , -0.00384329052077 , -0.00291908022072 , -0.00343590804611 , 0.0014955384398 , -0.00431828865737 , -0.00351704311321 , 0.000746048339756 , -0.000719347049065 , 0.0012605516404 , -0.00473080829674 , -0.00732342741717 , 0.000982322288535 , 0.000786275888487 , 0.000132775595303 , -0.00167784004872 , -0.00317546663145 , -0.00693229520462 , 0.00474202502102 , -0.00452578586563 , 0.00472012095545 , -0.00158996605297 , 0.00698615875132 , 0.00120610997061 , 0.0004808705143 , 0.00604452212755 , -0.00052760319739 , -0.00160361410451 , -0.00302374522328 , -0.000316848309888 , -0.00487791423141 , 0.000989149360728 , 0.00204869306483 , 0.00591332615275 , 0.00187440220975 , 0.0045701865143 , 0.00218837054919 , -6.64773513994e-05 , -8.06215297461e-05 , -0.00171046634029 , -0.00449581107974 , -0.00172965365416 , 0.00227703428216 , -0.00337289032286 , 0.000406268201462 , 0.00329590782304 , -0.000590836706685 , -0.00341727414568 , -0.00272514771846 , 0.00324410944541 , -0.00222859536546 , 0.00173416625167 , -0.000490757245308 , -0.00184070717454 , -0.00287770221368 , -0.00349548894811 , 0.00248814613222 , 0.00213300342379 , -0.000248793493601 , 0.00818355360002 , 0.0007003540094 , 0.00125869243055 , -0.00128125646981 , -0.000573162510661 , 0.000895752585809 , -0.00302513691698 , -0.00126350596831 , -1.23936908088e-05 , 0.00379438948425 , -0.00383026493287 , -0.00057927389797 , 0.00137213316457 , 0.000386963601855 , -0.00513686607734 , 0.000163832006053 , 0.00117887884042 , 0.00188015522849 , -8.87913055548e-05 , 0.00083100333339 , 0.00333533517071 , 7.00035852202e-05 , 0.00189402344955 , 0.000246537931797 , 0.00535805589215 , 0.000961469513976 , -0.00691924600298 , 0.00184392206176 , -0.0045362352196 , 0.0054310493835 , 0.00359852030496 , -0.00193989840996 , 0.00517672996905 , 0.000934918385956 , 0.00588974985748 , 0.0046598221955 , 0.00489355501296 , 0.00519880187078 , -0.00515931453218 , -0.000477294151222 , -1.89914523784e-05 , 0.00190736584906 , -0.000691089056471 , -0.000243662469728 , 0.00169865141156 , 1.73382840353e-05 , -0.00371614046685 , -0.00422741886839 , 0.000504108093065 , 0.00727019230439 , 0.00305912973385 , -0.00400415194808 , -0.0021395588657 , -0.00674363150945 , -0.00292042029514 , -0.00672442328787 , 0.000676799328855 , 0.00475872492487 , 0.0010664761769 , -0.000367217245678 , -0.00199957038445 , 0.00200304593091 , -0.000351555941803 , -0.000472744778758 , -0.00356311844395 , -0.00316391241378 , 0.000638331031539 , 0.00294380576376 , 0.000443765660186 , 0.00334003221715 , -0.0034054953802 , -0.0030023746333 , 0.00354464119828 , -0.000545683348998 , -0.000868528350691 , -0.00265052884373 , -0.00126132843309 , -0.00434895537832 , 0.00195497169701 , 0.000355105687376 , -0.000956509332338 , -0.000546663052646 , -0.00113527557718 , -0.000142674613166 , -0.000138375269663 , -0.00012145725723 , -0.00139318253103 , 0.00271591816289 , 0.000753106766974 , -0.00400219436531 , 0.00393664439601 , 0.000633311532039 , -0.00160594745936 , 0.0053461110249 , 0.00399598215929 , 0.00206210667052 , 1.675653277e-05 , -0.00162827035275 , 0.000632298807861 , 0.00533739764564 , 0.00393605153625 , -0.00379187367624 , 0.00115157157925 , -0.00524872016709 , 0.00404651903915 , -0.0010349826296 , -0.00383487124611 , 0.00219477518837 , 0.00230255092635 , 0.000314561484807 , -0.000391577175021 , -0.00306520739347 , -0.0060287842824 , -0.000567066911272 , -0.00193779011103 , 5.96024582996e-05 , 0.000832006031099 , -0.000527805483224 , -0.00483335312201 , -0.00412698766609 , 0.00232637216023 , -0.00286086139617 , -0.00256544472062 , -0.000435405592021 , -0.000895945429012 , 0.00342087609596 , -0.00355756655522 , -0.00190164752944 , 0.00290190799645 , 0.00341529488089 , 0.00489795299245 , 0.000934118644017 , -0.000208298500287 , -0.00162074110724 , 0.00452934228132 , 0.00519248662097 , 0.00228030317844 , -0.00154848529528 , -0.000275100283748 , -0.000744679853719 , 0.000278576319552 , 0.000153785259414 , 9.28339451572e-05 , 0.000486880361362 , 0.00642076561108 , 0.00100830958258 , 0.000195687055411 , -0.00375913345051 , 0.00206318906904 , -5.716128073e-05 , -0.00640064686135 , 0.00339052719012 , 0.0058761559472 , 0.00269610694456 , -0.00157838274361 , 0.000155629183815 , -0.000611128431117 , -0.00159542930688 , -0.00357760928663 , 0.00489616232621 , -0.00038197653488 , 0.00261238939741 , 6.21246714145e-05 , -0.00397705985769 , 0.00278265333313 , -0.00145999656408 , -0.00332880342109 , -0.00119111199527 , 0.00231097154181 , 0.00119565345742 , -0.00358397485369 , -0.00292237376506 , -0.00337736585702 , -0.00132504157008 , 0.0036921378199 , -0.00158447933889 , -0.00139064664483 , 0.00154941264215 , 0.00210446410798 , 0.00218356586948 , -0.0030320204391 , 0.00264060754197 , 0.00120501014529 , 0.00427210675859 , -0.00179356643935 , -0.0014276766021 , -0.00177690953457 , 0.00123143623055 , 0.00594515989925 , -7.6982301458e-05 , 0.00650734130138 , -0.00488380068167 , -0.00231825284302 , -0.00387598722281 , -0.00532870740397 , -0.00247663696402 , -0.00308030940081 , 0.00286401439892 , 0.00449629525675 , -0.000232774884944 , -0.0045547387563 , 0.00280013840561 , -3.04100052339e-05 , 0.00115533919293 , 0.00145558607709 , -0.000593731588967 , 0.000255811273288 , 0.000156568206819 , -0.000241255016749 , 0.000728408696673 , -0.000924833264183 , 0.000854770206971 , -0.00382474855959 , -0.00311120860217 , -0.000600450355042 , -0.000709568099218 , 0.00281375251379 , 0.00123101687716 , -0.00295871692869 , 0.00230973258745 , 0.00501118892814 , 0.0031556612349 , -0.00042771534396 , -4.25959984942e-05 , -0.000745507161697 , 1.02814707192e-06 , -0.00443488048744 , 0.00166013474919 , -0.00375805756526 , -0.00216435075805 , -0.00019808326801 , 5.58978066179e-06 , 0.00463431187737 , 0.000227860178362 , -0.000308946334779 , 0.00462918542963 , 0.00136206805262 , 0.00315263318171 , 0.000770829650909 , 0.00353132899058 , -0.00175751760097 , -0.000157464638022 , 0.00384668873005 , 0.00443005369787 , 0.00530001856708 , -0.00403879436412 , 0.0022840210899 , -3.42409891959e-05 , 0.00446202117635 , 0.00376120770466 , 0.000179212326527 , 0.000318455119011 , -0.00326224037451 , -0.00301700470158 , 0.00622704342291 , -0.00287316115305 , 0.000100706681751 , -0.00149070967251 , -0.000895198366862 , -0.00201952283724 , -0.00110997364005 , 0.00350013751625 , -0.00120962251348 , 0.00613942679088 , 0.00618167099309 , -0.00125042020884 , 0.000930423113128 , -0.00141281724295 , -0.00234367665187 , -0.00413360518928 , -0.00429601996706 , 8.64063077071e-05 , -0.000995221266019 , 0.00122439093879 , 0.00561706067068 , -9.20606266996e-05 , -0.00278256518327 , 0.00128241470356 , 0.00469161682175 , -0.00131160011819 , 0.00527140261143 , 0.000649143901818 , -0.00605098363272 , -0.000802014236169 , -0.00532774074709 , 0.000817466359663 , 0.00206077112997 , 0.000778142120903 , -0.00206410512225 , 0.00118866581927 , -0.00489176848758 , 0.00175201962688 , -0.00318946997577 , 0.00465059335783 , 0.00109993549281 , 0.000218942748018 , 0.00250028547539 , 0.00117033317439 , 0.00444342514227 , -0.000728919850184 , 0.00228819816689 , 0.00410812412774 , -0.000368889630646 , 0.00489911125775 , -0.00177167907481 , 0.00199126285221 , -0.00154344397514 , -8.40217488597e-06 , 0.00229446754267 , -0.000600945896365 , -0.0041138935274 , -0.00138515352434 , -0.006329402168 , -0.00146778653048 , 0.00178846387231 , 0.00262231880668 , -0.000997083732002 , -0.00398977639582 , -0.00138058007572 , 0.0023833263965 , 0.00269165072938 , 0.000149794382348 , 0.00446981397182 , -0.000612673415276 , -0.00168673297531 , -0.00493943435299 , 0.000345623422045 , -0.000420097279318 , 0.0039486501502 , 0.00238221128507 , -0.00680638172886 , 0.000254222432381 , -0.00143022533304 , 0.00117418822433 , -0.00136101887615 , 0.00245861365079 , -0.000928815161359 , 0.00156460173531 , -0.000149340018278 , 0.000648346989215 , 0.00074383766092 , 0.00171482452507 , -0.00236524022331 , 0.000279329522015 , 6.75576695388e-05 , -0.000543701900725 , 0.000188423076507 , 0.00255238983038 , -0.00180839518532 , -0.000234011980526 , 0.000397395714522 , -0.000830493052668 , 0.0042783720967 , 0.00288196094548 , 0.00171169527984 , -0.000268270078982 , -0.00115358234068 , -0.00506604422701 , 0.00164810882757 , -0.00636408966133 , -0.00270385134391 , -0.000305787639464 , -0.000499714675515 , 0.0027276407901 , 0.000106904857722 , -0.00499280039844 , -4.526911689e-05 , -0.00190495855476 , -0.000462359329445 , 2.51515588671e-05 , 0.000736277887273 , 0.000276050795123 , -0.00202480534194 , -0.000636059759398 , 0.000757453733059 , -0.00125204805834 , -0.00233359335531 , 0.00208707442216 , -0.00178629020692 , -0.00466113235115 , 0.00271005939157 , -0.00266430691505 , 0.00494083136926 , -0.00219510081756 , -0.000187245544979 , 0.00607348103033 , 0.00143158446622 , -0.00462426401903 , -0.00142231928841 , 0.000733584864372 , 0.00260830045086 , 0.00190680623673 , -0.00180618380098 , 0.000509056653397 , -0.000517141798022 , 0.00763493617813 , 0.000320890981583 , 0.00249166815288 , -0.00476030176471 , -0.00346639485823 , -0.000494733481496 , 0.000913059826417 , -0.000969258057724 , -0.00339163236821 , 0.00027158682258 , 0.00338604801282 , 1.0318243535e-05 , -0.00168857450537 , -8.68835589123e-05 , -0.00346520435828 , -0.00206186204785 , -0.00391839892159 , 0.00321271694648 , -0.00130376598742 , -0.000121447415918 , 0.00106139967363 , 5.27726753682e-05 , 0.00226157889912 , 0.00657023525038 , -0.00121840633552 , -0.00264607642659 , -7.72195569952e-06 , 0.000182409321072 , 0.00362933493025 , 0.000585328533109 , 0.000329280690473 , 0.00233849194492 , 0.000389196416438 , 0.00379426108118 , -0.000941097915706 , -0.00195217361226 , 2.72546496165e-05 , 0.00282807128602 , 0.000183656393378 , -0.00465239475968 , -0.00470196964144 , -0.00361307233486 , -0.000371721376574 , 5.63168601364e-05 , -0.0057670944938 , 0.00269958685956 , -0.00198277045693 , 0.00420858624725 , 0.00168593838111 , -0.00150453500431 , 0.00255032507168 , 0.00336653089647 , -0.00165473684114 , 0.0055882720167 , 0.0066264559924 , 0.000612013973247 , 0.000816289446021 , -0.00171033094581 , -0.00484575643768 , 0.000695507862915 , -0.00199227998389 , -0.000233929888205 , -0.00402218710936 , 0.00314652297877 , 2.40671058721e-05 , 0.00280941979203 , -9.464940381e-05 , 0.00210826369703 , 0.00399566993119 , 0.00374790045145 , 0.00444118266472 , -0.00575997508415 , 0.00588181470437 , 0.00141040988287 , -0.00211207550098 , -0.00191417448922 , -0.00121793827722 , 0.00341619423525 , 0.000495990019052 , 0.000538167863753 , -0.000185311291698 , -0.000315573500199 , -9.09815127395e-07 , 0.00225784906075 , 0.000430465086001 , -0.000212861593805 , 0.000607387755998 , 0.00177881226672 , 0.000330005988667 , 0.00131361325509 , -0.00559186427517 , 0.000472132793587 , -0.00187264301747 , -0.00285850257943 , -0.00517651195633 , -0.000199687583826 , -0.00358004279495 , -0.000142124087534 , -0.00331302657822 , 0.000637726666969 , -4.68122678746e-05 , -0.00191758398434 , -0.000142538932488 , -0.000536127951919 , 0.00461664044118 , 0.00254751174544 , 0.000442443808158 , -8.73662633821e-05 , -0.00423786300324 , -0.00275502841769 , 0.002853304774 , -0.00193522949184 , -0.00256149783746 , -0.000831829643576 , 0.00123036248796 , -0.00424220044981 , 0.00439536557141 , -0.000978428205436 , -0.000765921011818 , 0.0057437902222 , 0.00479966058319 , 0.00109946975762 , 0.000247494035705 , -0.00283113194772 , 0.000132726002991 , -0.00139515752092 , -0.000698531201567 , 0.00104317045941 , 0.00284024234559 , 1.37428199536e-05 , 0.000614985512785 , 0.00032327887419 , 0.00066322482051 , 0.00249377335587 , 7.13473594984e-05 , -0.00137591852826 , 0.000183618903552 , 0.00310766373474 , 0.00477614185754 , 0.000876066299838 , -0.00162480392134 , -0.0034212892902 , -0.00565562574151 , -0.001030682021 , -0.00236533621187 , -2.27499765775e-05 , -3.26312052569e-05 , -0.00217775232541 , 0.000981885983246 , 0.00153700284291 , 0.00129380699044 , -0.00042795623082 , -0.000898389554785 , 0.00800681423393 , -0.00415042101183 , 3.07692279221e-05 , 0.00227734682584 , -0.0031460673512 , 0.000569738363949 , -0.00367548122379 , 0.00371388898823 , 0.004436462415 , 0.00299578970683 , 0.000228148225712 , -0.00715020006232 , 0.000200343727357 , -0.00164387560975 , 0.000530061003057 , -0.00335430774426 , -0.00186572534543 , 2.03641401608e-05 , 0.00594408935681 , 0.00259039740942 , -0.00150774970937 , -0.00312931620337 , 0.00220160568419 , 9.52597970964e-05 , -0.00369382104403 , -0.00170538189409 , 0.00205928376579 , 0.000718437089449 , 0.00109425834776 , 0.00270885055044 , ])
Y_4_m3_imag = flex.double( [ -0.0 , 0.0 , 0.000483074675273 , 1.11296594283e-05 , -0.000456272932422 , -0.00290472563853 , -3.90089105138e-06 , 0.00132677402151 , -0.00634720477274 , -0.00168577090109 , -0.00234066838975 , 0.000634694400217 , -0.000226242284297 , 0.0016397742528 , 0.00122794679482 , -0.0020271139785 , -0.0062111812101 , -0.00172886048283 , -0.00282616937087 , -0.000212906073073 , 0.000906348513796 , -0.000540938651214 , 0.000210831537281 , -0.00157959599711 , -0.00337342657193 , 0.00372090143086 , -0.000567151629709 , 0.00316990954436 , -0.00494161778633 , -0.000163428397803 , 0.000138561578623 , 0.00578048649317 , 1.0057897888e-05 , -0.0056426581987 , 0.000763431826762 , 0.00284968800887 , 0.000859180348848 , -3.79439150398e-05 , 0.00504473512488 , 0.00238373951081 , 0.000146342946794 , -0.00341510066104 , 0.00354268995386 , -0.00154837983927 , -0.000651839181402 , 0.00531161838408 , 0.0014303944343 , 0.00179367884814 , 0.00545267923538 , -0.00257888897394 , -0.00183391934948 , -0.000845078832009 , 0.00160933192094 , 1.84558760958e-05 , -0.00223435873768 , 0.00133391624151 , -0.000714096471948 , -0.00220516572421 , -0.00207726962541 , 4.64156341934e-05 , -0.000660022527619 , 0.000126454025766 , 0.000708509903623 , -7.42948768154e-05 , 0.00213485666782 , 0.000226029375134 , -0.00393989849159 , 0.00491281947807 , 0.000738723665709 , -0.00253642925103 , -0.00313486040577 , 0.00164742751592 , -0.000448237203502 , 0.00102580517018 , 0.000144863161782 , -0.00487798451521 , 0.00155813654109 , 0.00591308146942 , -8.83954106007e-07 , -0.0014723956245 , 0.00174564962322 , 0.00591092739852 , -0.00285944863608 , 0.0024433960201 , -0.0016920644527 , -0.00549570033024 , -0.000330640500746 , -0.00119615001741 , -0.000233862710223 , 0.00489646610484 , 0.00480488919473 , -0.000176690209932 , -0.00281405828915 , -0.00268589579221 , -0.00086372025466 , 0.00261474097558 , 0.000480484916183 , -5.70711211762e-05 , -0.00149888407165 , -0.00364554957933 , 0.00144975737082 , 0.00232071965976 , -0.00253599533129 , 8.17704498888e-05 , -0.000659637953802 , 0.00608655445508 , 0.00257365486025 , -0.00156391036117 , 0.0019323923413 , 7.92169642727e-05 , 0.000908820141337 , 0.00147879126369 , 0.000387158469776 , -0.000442255530688 , -0.000555083304048 , -0.0014000243882 , -0.00176006301199 , -0.00362662436867 , -0.000888924554805 , 0.00264485636094 , -0.000441669944455 , -0.00150344810773 , 0.00253754019022 , -0.00100123307793 , -0.00482954387587 , 0.00294088081786 , -0.00331349404214 , -0.000199832893802 , 0.000471628978036 , -0.000549339322096 , -0.00689635296403 , 0.00259483808417 , 0.000730816733312 , 0.000298802869978 , 0.000843145474553 , -0.0040508091496 , 0.000680621078822 , -0.002414000709 , 0.00262053760357 , 0.00251589532661 , -0.00138663608047 , -0.00143392116696 , -0.00454592521995 , 0.00212199619901 , -4.08552157938e-05 , 0.000601324006921 , 0.00386430022662 , 0.00353458892938 , -0.000102442796306 , 0.00213906841143 , 0.00172557024657 , -0.000769028800135 , -0.00411376985241 , -0.00214317988652 , -0.00266065140448 , 0.000174208213683 , 0.00141486723206 , 0.00208258259428 , -0.00151759355745 , -0.00311820285075 , -0.00379482195584 , -8.78836388353e-05 , -0.000119447690837 , 4.62286381518e-05 , 7.03174972932e-05 , -0.00239861755567 , -1.55124611976e-05 , -0.00215696518361 , -4.85443920975e-05 , 0.00105041609559 , -0.00307658890622 , 9.55918781919e-06 , 0.000284416068778 , -0.00275246862062 , 0.000442251206095 , 0.000754644096944 , 0.0055674113644 , -0.00294645499041 , 0.00310837411171 , 0.000986915402058 , -0.000393343259297 , -0.00367031774921 , -0.0016449419178 , 0.000978261294509 , 3.33966782108e-05 , -0.000763643119733 , 0.00185591263406 , 0.00200025554013 , 0.00149451372624 , 0.000146439367249 , 0.00219412293217 , 0.00104913363046 , 4.40633621368e-05 , -0.00121085479129 , 0.00528064159989 , 0.000976473938141 , 0.000150549185038 , -0.000704986746967 , -0.00249993838811 , -0.00187615829356 , 0.00529889962201 , -0.00284199073017 , -0.00537197307781 , -0.00381921798938 , 0.000936815528115 , -4.30519994158e-05 , -0.00352332761495 , -0.00300198560074 , 0.00431826234397 , 0.00241533627948 , -0.00401647056122 , -0.00153764901291 , -0.000283777898469 , 0.0037808038378 , -0.00520826861812 , -0.000672088326926 , -0.00398344522962 , 0.00408390192737 , -0.00307186572099 , 0.000727931184452 , 0.00292029257712 , 0.00369540134951 , 0.0060270705052 , -0.00229239735611 , 0.0012759237566 , -0.00387774464554 , -0.00194313483864 , -0.00297078514158 , 0.00175431256763 , 0.00157504288439 , -0.00187113415259 , 0.00733460568524 , 0.00159808547431 , -0.00552036280107 , -0.000145872679443 , 0.00202848240445 , 0.00202239750634 , -0.00066470629364 , -4.7583028616e-05 , -0.0011514114584 , 0.000904114126367 , -0.000474040907832 , -0.00406036641438 , -0.00238077373477 , 0.00253520687033 , -0.00222386432246 , 0.00351898277234 , -0.00426052903768 , -0.00416311704954 , -0.000464782477339 , 2.0005906154e-05 , 0.00236421539029 , -0.00141441971517 , 0.00411192254571 , -0.00129085398572 , 0.0008064631439 , -0.000188836302858 , 0.000406571373741 , 0.00221232793719 , 0.00259680121286 , 0.000964432620004 , 0.00157131986285 , -0.00366628709737 , -0.00164214073832 , -0.00305307238032 , -0.00659467856901 , -0.00588289934748 , 0.000875615301106 , -0.000815983083008 , -0.0048730839185 , -0.0013954797386 , -0.00319277358377 , 0.00384854249912 , -0.000483539381645 , 0.00201261267627 , 0.0020150894954 , 0.000389153852512 , 0.00554881476261 , 0.00522942156436 , -3.19203309904e-05 , -0.00253020648941 , 0.000683004479516 , -0.00202127310632 , 0.000432866711511 , 0.0014233048256 , 0.00142296339083 , -0.0056726501642 , 2.08706497446e-06 , 0.00642134862264 , 0.00263323027912 , -0.00332453263796 , 0.00201580321917 , 0.000710800957376 , 0.00377921822675 , 0.00575965721762 , -0.00180371494723 , 0.00135803449767 , -0.000439202429407 , 0.00440532102873 , -0.000217766065467 , 0.000376342352153 , 0.00112409122964 , -0.00296153031334 , 0.0031262295861 , 0.00217836650036 , 0.00518933825534 , 0.00307008911704 , -0.00258313935456 , 0.00476120338005 , -0.00190513462386 , 0.00642601332848 , 0.000672058663922 , 0.00369581881377 , -0.00179904202956 , 0.00214704789688 , -0.00454280220392 , -0.00506272361064 , -0.00240033067584 , 0.00100494007877 , 0.00532419525312 , -0.00642644119282 , 0.000376280881772 , 0.000705759169601 , -0.00101355848935 , -0.00155350428771 , 0.00168535327085 , 0.0022725643418 , 0.00160597235557 , -0.00375685791597 , 0.00656948582697 , -5.66421868489e-06 , -0.000582716241646 , -0.00205492879726 , -0.000973167752966 , 0.000449889247728 , -0.00160913335132 , -0.00100774779512 , 0.00261390826279 , -0.00202041238378 , 0.00306966647492 , -0.000654769019765 , 6.07307514348e-06 , 0.000732096078302 , -0.000316331053794 , 0.00145010241786 , -1.91040730946e-05 , -0.00269762532412 , -0.00207295797858 , 0.00289782971368 , -0.00412025757464 , 0.00120819658413 , 0.0038360804668 , -0.000817155222885 , 0.00480665491157 , -0.00188812511184 , 0.00143491365425 , -0.000489253631405 , -0.00374897900888 , 0.00374298063132 , 0.00566634390493 , 0.00100687338919 , 0.000355949983504 , 1.2347984992e-05 , 0.00167552673517 , -0.00152337797949 , -0.00632185914738 , 0.000248816464743 , -1.85722915607e-05 , -0.0010076843462 , 0.00583967947688 , -0.00177006362349 , 0.00143166024134 , -0.00196947297505 , 0.000264598946382 , -0.00383793712708 , 0.00200384611187 , 0.00244287437648 , 0.000951578239461 , 0.00322985226877 , -0.00320467657661 , -0.00094861467424 , -0.00341660266143 , 0.00376719298352 , -0.00632801179514 , -0.00633433805002 , 4.28828103391e-05 , 0.00351733986873 , -0.00451482864322 , -0.00425406157954 , -0.00122755270137 , -0.00472436872253 , 0.00558892535024 , 0.00476866132362 , 0.0021760053536 , 0.000728304537574 , -0.00538359426977 , -0.00402497991024 , -0.00037508660459 , -0.000126364597724 , -0.000891765573318 , 0.000588490529315 , -0.00519887772059 , -6.35386553171e-06 , -0.00550759432678 , -0.00623473683149 , 0.00338548233826 , 0.00016412088948 , 0.00119747732326 , 0.0033624165532 , -0.00201592858274 , 0.000887588485102 , -0.00271556727804 , -0.0043382484227 , 0.00489424969251 , 0.000731794632816 , -6.3149320212e-05 , -0.00464152494157 , 0.00251324316261 , 2.74112070235e-05 , -0.000583377195356 , 0.00608149178212 , 0.00589012257838 , -0.00406927339487 , -0.00268127243491 , 0.00818603037412 , 0.000419157901724 , -0.0038431287208 , 0.00453474447709 , 0.00104815716544 , 0.00251496662272 , -0.00207095813063 , 0.000461499838385 , -0.00524082087952 , -0.00166366320021 , 0.00300163163236 , 0.00176701525284 , 0.00299872275886 , -7.90407649455e-05 , 0.00229775998962 , 0.000589684276366 , -0.00469824178535 , -0.00217070442718 , 0.00188543613931 , -0.0026720727544 , -0.00276673454606 , -0.00058670329279 , 0.00267477501592 , 0.000371959284278 , 0.0045489708938 , 0.00023614381349 , 0.00184106092181 , 0.00383298205548 , 0.00386188775126 , -0.000416217123337 , 0.00281871197564 , 0.00243580280076 , 0.00617649502355 , -0.00153500673036 , -0.00129847224255 , 0.0045993145194 , -0.000228632777606 , -0.000177051520188 , -0.00383142171227 , 0.00300039258264 , 0.00251729008425 , 0.00593017384593 , -0.000264198377101 , 0.000681811114904 , 0.00123257029315 , -0.00602946494623 , 0.00133234963254 , 0.00521569807706 , 0.000941778829259 , 0.000950526298398 , 0.000913216982138 , 0.00388840695135 , 0.000521621976186 , 0.00722810745284 , -0.000472765852184 , -0.000210500975175 , -0.00440939043894 , 0.00168983137323 , -0.00171918956527 , 0.00516262925021 , -3.70816608011e-05 , 0.00240200860133 , -0.0040998185565 , -0.0044912080391 , -0.00105528145781 , -0.00214094942982 , 0.00559150361915 , 0.00164353077782 , -0.00308489781648 , -0.00635925095934 , -0.000131000545278 , -0.0043034430671 , 0.00117698597926 , 0.00140617824077 , 0.00177717465125 , 0.00104982786291 , -0.00255790698101 , 0.000242064391498 , 0.00228843815632 , 0.0040763326294 , 0.00392861448181 , 0.000434865918787 , -0.0045668570563 , -0.00180188335074 , 0.00357025006661 , 0.00359219666177 , -0.00343110129013 , 0.000327971812265 , -0.000715943701766 , 0.00275347244184 , -0.00275284746271 , 0.000665679552038 , -0.000377311832784 , -0.000303212138074 , 0.00387152030679 , -0.000655301227573 , 0.00292639160425 , 0.000210642252291 , 0.00248849797168 , 0.00290253794657 , -0.000354348047144 , -0.00123457997682 , 0.00476984589835 , -0.00460958871273 , -0.00178668551367 , -2.95374590059e-05 , 0.00201587399412 , -0.00131530165638 , -0.00331167492856 , -0.000410196343013 , 0.00124956783539 , -0.00279700023766 , 0.00175081574895 , 0.000716938879825 , -0.000252963243515 , 0.00085548204691 , -0.000914263577377 , -9.24647430002e-05 , 0.000265957058375 , 0.00260845008838 , -0.00231672001916 , 9.95062085436e-05 , 0.000296458251221 , 4.40948898061e-07 , -0.00155147808974 , -0.00144561587084 , 0.00440199504384 , -0.00376688478044 , -0.0004272307637 , 2.3368091292e-05 , 0.00194298162195 , 0.00555909662824 , 0.00045237812543 , 0.00284717709564 , 0.00187554999554 , 0.00388933319447 , 0.000729334410103 , -0.00129805166945 , 0.000464738949273 , -0.000250913372071 , -0.000537599664667 , -0.0040426249679 , -0.00338360392282 , 0.00114884221203 , -0.00504272595844 , 0.000659356333251 , 0.00162233474747 , 0.00374542898543 , -6.99122398834e-05 , 0.00175080678 , -0.00573617543936 , 0.00214391371077 , 0.00262169097618 , 0.000347755342776 , -0.00362328290288 , -0.00066552559807 , 0.00535422959232 , -0.000996186636228 , 0.000990766440528 , -0.00532422509126 , 0.0014182983349 , 0.000990005794304 , -0.00194555812915 , 0.00335226534756 , 0.000642498352425 , 0.00393903071803 , -0.000964215027001 , -0.00113159026175 , 0.000132783782979 , 7.33202557011e-05 , 0.00200740280653 , -0.00030659743056 , -0.00344608326272 , -0.000165101883084 , -0.000155706244759 , -0.000508647194425 , 0.00423823629198 , 0.0037220293984 , 0.00228582171854 , -0.000381749576527 , -0.00117516852457 , -0.00739788917279 , 0.00576746474642 , -0.00134859410994 , 0.00391715612707 , -0.000439539064893 , 0.00583334662546 , 7.34213944127e-05 , -0.000159858603739 , -0.00332469642434 , -0.00205093424807 , -0.00136124173709 , 0.000265606663432 , -0.000444112037448 , 0.00576878412882 , 0.00589524574468 , 0.00231861470229 , 0.000920810838113 , -0.00131928457003 , -0.00615290030485 , -0.000247621502656 , -0.00360546081051 , 0.0011289191827 , -0.00170641641502 , -0.00488544579783 , -4.23032737888e-05 , -0.00175588972741 , -0.00219581810522 , 0.00230977898868 , 0.000630315602686 , -0.00162005754454 , -0.000800323160068 , 0.00396271703359 , -0.00214532955592 , 0.00380039945367 , -0.00390614333729 , 0.00101043498005 , 0.00252644886431 , 0.00139579712866 , 0.000160052921326 , 0.00373877164542 , 0.00164169193336 , -0.00465236439495 , 0.00450513173785 , 0.00437436769203 , 0.000756355326335 , -0.00351219254604 , 0.00459013906012 , -0.00257027706604 , -0.00178650531953 , 0.00516212004732 , 0.000599059977062 , -0.00287751911727 , -0.000851067390903 , -0.00108678238141 , -0.00454097821814 , -3.65888848383e-05 , 0.00115961751343 , -0.00251897820397 , 0.000967969441167 , 9.10875637338e-05 , -0.000683984950647 , 0.00357094354011 , -0.000108561553325 , 0.000487221384376 , -0.00195025512009 , 0.00253474447793 , 4.03056793826e-05 , -0.00294001391236 , 0.00339001655097 , -0.00524582985443 , 0.00233914834895 , -0.00404716149191 , -0.00864099769958 , 0.00329303430285 , 0.00100383651752 , 0.00343958428325 , -0.00308661518986 , -0.00250189400356 , -0.00163913267126 , 0.0061220549068 , -0.00200567268791 , 0.00343323730903 , -0.00537584631565 , 0.0026127348221 , -0.000209135632008 , -0.00357152693726 , 4.72015173239e-05 , 0.00121608999715 , 0.00870869688293 , -0.00320596918137 , 0.000984355139431 , -0.00597016946882 , -0.00302307422763 , -0.000776420720713 , -0.00263689811587 , -0.00148204518761 , -0.0022403894166 , -0.00297999117686 , 0.00365954983589 , 0.0013000353089 , -0.00359325472591 , 0.00133696226651 , -0.000378688197632 , -0.000488449643344 , 0.00167218356959 , 0.000396051427888 , -0.00420842567237 , -0.00415713050037 , -0.00336926937662 , -0.00169009269091 , -0.000534969925588 , 0.00274837745493 , 0.00152444932549 , 0.00635906994679 , -0.00506333115051 , -0.00156405766166 , 0.00361722960527 , 0.00503163624107 , -0.00133923617664 , -0.00266414149088 , -0.00471578948082 , 0.00364125390447 , -0.00157714604188 , -1.01141757758e-05 , -0.00524511070986 , -0.000452608920577 , -0.00160034932764 , 0.00279915084239 , -0.0016489548166 , -0.00150395921167 , -0.00197801149505 , -0.0022511603133 , 0.0054609073514 , -3.23586829121e-05 , 0.00485798299359 , 0.00142919887712 , 0.000667927774899 , -0.000953982240865 , 1.01328064685e-05 , -0.00175710599155 , 0.000555684368059 , -0.000352407908009 , 0.00255683682645 , -0.00014279257576 , -0.000632084708742 , -0.00174102855386 , 0.00253057343618 , -0.00195694755117 , 6.65702563215e-05 , 0.00294273621006 , 0.000264441232502 , -0.000538026811788 , -2.57521523165e-05 , -0.00207934828795 , -0.00371960316861 , -3.6598827002e-06 , -0.000352161113475 , 0.00437658056164 , 0.00208896258559 , 0.00269032557946 , -0.00762414065595 , 3.74501263319e-05 , -0.00648684971166 , -0.00362046765803 , 0.00189999769918 , -0.00242095793991 , -0.00155961325782 , -0.0018512355484 , -0.00639892365 , 0.000964492192383 , 0.00225607042442 , 0.00403095306192 , 0.000277861783314 , 0.000139987746377 , -0.000118810343421 , 0.00383216638523 , 0.000120835007544 , -0.00103379584116 , -6.08780667158e-05 , 0.00102460578519 , -0.00409630906119 , 0.00204305108567 , 0.00394456459742 , -0.00106129116212 , 4.64242461946e-05 , -0.000158623426889 , 0.00579075217219 , 0.00204860831265 , -0.00134587280324 , -0.00029330518908 , 0.0029353101746 , 0.00406316708855 , -0.000219023538769 , -0.00153037211555 , -0.000820514567519 , 0.00183606836557 , 0.000325235437057 , -0.00514383900121 , -0.000499651705548 , -0.00339226040779 , -0.000563498414163 , -0.00295345654445 , -8.01580779981e-05 , 0.000134632937459 , -0.00396314742726 , -0.00513818514479 , -0.00227100436937 , -0.000952866590499 , 0.00107041728625 , 0.000563513853855 , -0.00206024174392 , -0.00315410781596 , -0.000471404438919 , -0.00042176385885 , -0.00190818240735 , -0.000882404749051 , -0.00443215340827 , -0.00197807602216 , -0.00128588772125 , -0.00115807083914 , 0.00148601890697 , 0.00561337931336 , -0.000801505471865 , -0.00129010795215 , 0.000740137688419 , 0.00264769324545 , -0.00238997538665 , -0.0048395158753 , -0.00660892869475 , -0.00391862384067 , -0.00437354877504 , -0.000746124527596 , -0.000910062989597 , -0.00677844253817 , 0.000235826161713 , -0.00490148638563 , 0.00134642881071 , -0.00118296623917 , 0.00380144220276 , 0.00227715122343 , 0.000109814176051 , 9.81833382461e-05 , 0.00703287677429 , 0.00801991860049 , 0.00419601771185 , 0.0015237170133 , 0.000115049579302 , -0.00341440456825 , 0.000238301624549 , -0.00518497677516 , 0.00247403010525 , -3.21865515517e-05 , 0.000840872541766 , 0.00200803126013 , -0.00357204075521 , -0.00141266798964 , 0.00021505122114 , -7.37918528619e-06 , -1.10336289221e-05 , -0.00620172449846 , 0.00230206805959 , 0.0036784699577 , 0.000762468385875 , 0.000152637008971 , 0.00281910913572 , -0.00217094494497 , 0.000331809956486 , -1.86488348719e-05 , -0.00542770979538 , -0.0026235986383 , 0.00179506955418 , 0.00156174238296 , 2.46334043004e-05 , 0.00286005533846 , -0.000775552464411 , -7.91486952966e-05 , 0.000349889023912 , -0.000113605986853 , -0.00287716033292 , -0.00335224867691 , 0.00353783483456 , -0.00103614787818 , 0.000514046966943 , 0.00290748999241 , 0.00404960366086 , 0.00487437710931 , 0.00291316999249 , -0.00308271622903 , 7.81971332893e-05 , -0.0010259165053 , 0.00128914254382 , 0.00631215634169 , 0.00137836106399 , -0.000749061345208 , 0.000700919886796 , ])
Y_4_m2_real = flex.double( [ 0.0 , -0.00568522109153 , -0.00439991879467 , -0.00128049177811 , 0.000523243780448 , -0.00422334544399 , 0.00224118647023 , -0.00223053677271 , 0.00312934964227 , 0.00465495515295 , 0.00256893033057 , -0.00297439241191 , -0.00171892836569 , -0.00423153664907 , 0.00271966116679 , -0.000403143853581 , -0.0010558990447 , 0.00577994688539 , 0.00262080323177 , 0.00231680204877 , -0.00438394756578 , -0.00277056590684 , 0.00257782270055 , 0.00336612832011 , -0.00393464243447 , 0.0073204622886 , 0.00561435692105 , 0.00150338634999 , -0.00589109102897 , 0.000347599599095 , -0.0020412247211 , -0.00113885969296 , 0.0055824964854 , 0.000572119775532 , 0.00240080579248 , -0.000233777377469 , -0.00384621106302 , -0.000290369537753 , -0.00919691006807 , -0.00117886932043 , -0.00189119762816 , -9.64275223896e-05 , 0.00217064098178 , 0.00323750558364 , 0.000672182426103 , 0.000125888919963 , 0.00144470341119 , -0.00219559483287 , 2.51446089918e-06 , 0.000813587094586 , 0.00252725417311 , 0.00428102444692 , -3.34420405888e-05 , 0.00549242968021 , -0.000179646481078 , -0.00324485385375 , 0.00192944009669 , -0.000137911211643 , 0.00631454341855 , 0.00308924019567 , -0.00490363615689 , -0.0034387852172 , 0.000503005653185 , -0.00113234375 , -0.00130695731368 , -0.000436404531424 , -0.000504158080579 , -0.000204564478223 , -0.000854644427858 , -0.00135316482895 , 0.00194384235184 , -0.000386762584458 , -0.00461321389631 , -0.00168417372897 , -0.00109409238306 , 0.0023639505015 , 4.21174150125e-05 , -0.000763288672698 , -3.3541933452e-05 , -0.000198482251437 , 0.00051031491174 , 0.00353324460782 , -3.74080689576e-05 , -5.7281831495e-05 , -0.00148272567756 , -5.11946911444e-05 , -0.00209749312771 , 0.000336490966754 , 0.00381547050176 , 0.00211060808299 , 0.00322391688886 , -0.00305208302551 , -0.00666478566821 , -0.0046278346647 , -0.00155717684928 , -0.00129876886083 , -0.00323988097315 , 0.00180302829846 , -0.00042722502833 , 0.00380620345328 , 0.00297181730925 , 1.4578210778e-05 , -0.00276842321032 , -0.00366219078979 , -0.00163938544816 , 0.000230915664375 , 0.00165543459032 , 0.00376587578468 , -0.00274147641132 , -0.000218285469588 , 0.000602624600452 , 0.00253877814568 , 0.00125512297519 , -0.00294543481826 , 0.00149875055543 , -0.000777643377194 , 0.000850635995305 , 0.00150345518214 , -0.00194458021072 , 0.00522958391468 , 0.00353875433733 , 0.00339417660684 , -0.00753086634129 , 0.00344937252652 , 0.00104841180389 , -0.0016505102174 , -0.00306483803499 , -0.000506875035735 , 0.00186158803578 , 0.00167415089124 , 0.00146171059627 , -6.16471082862e-05 , 0.00332137950502 , 0.00227984269208 , -0.00318573351443 , 0.00140877798041 , 0.00121465683095 , -0.00129326627117 , 0.00192517555197 , -0.00256037865602 , -0.00522445109571 , 0.00392727942684 , 0.00120977751216 , 0.00167463381668 , -0.00542540447152 , 0.00310633069188 , -0.000627479813046 , -0.00135982946818 , -0.000361562526575 , 0.00179171852678 , -0.00572566402813 , 0.00238045047166 , -0.00757151585564 , 0.00248889994101 , -0.00116979906305 , -0.000747569208951 , -0.0021753551053 , -0.00111572305408 , 0.000708811294335 , 0.000788935272609 , -0.00230649664864 , -0.00103133962648 , 0.00264109942785 , 0.0038804000235 , 0.00344374035518 , -0.00201731043308 , 0.0031978496023 , 7.78440335825e-05 , -0.000358646620716 , 0.00419335891949 , 0.00383146424552 , -5.21854262141e-05 , -0.00132021211853 , 3.8424753233e-05 , -0.00256631171267 , 0.00477061675226 , 0.00108651514558 , 0.00562577638038 , 0.000149668495341 , -0.00342090134351 , -0.00025543012203 , -1.74086219389e-05 , 0.000614814642911 , 0.00635024901052 , -0.00360398289885 , 0.00270042129084 , 0.00558230176038 , -0.00143569979039 , 0.00255649097115 , -0.00162631276517 , -0.00220028901375 , 0.000307311272945 , -0.000589293848104 , -0.00144264335213 , 0.000864785569665 , -0.00335555595726 , 0.000238776018615 , -0.00170261541351 , -0.00436492128301 , -0.00344599052776 , 0.0009909374934 , -0.000393087090446 , 0.00273950910067 , 0.00118261471205 , 0.00475975875806 , -0.00108406005405 , -0.000227613893484 , -6.42106750982e-05 , -9.1512569615e-05 , 0.00701656987362 , 0.00311810042182 , -0.00429422408461 , 0.000290098085138 , 0.000674101711508 , 0.000786421548178 , 0.000410462115703 , -0.000213105911704 , -0.00391534789682 , -0.00187741887199 , 0.00768002904203 , -0.00276273780382 , 0.00158517624558 , 0.00158148245372 , -0.00164924075607 , -0.000434479942657 , 0.000242290673255 , -0.000296609607384 , 0.000198852776802 , 0.00575767206954 , -0.000532757989876 , 0.00104563796889 , -0.00417385432075 , -0.000232755566266 , 0.000425545015906 , -0.00451029272905 , 0.00446360625743 , -0.00396909865964 , -0.00177707566958 , -0.000704485572881 , 0.000883719535623 , 0.00092241401659 , 0.000218703490239 , -0.00322378320645 , -0.00358696599308 , -0.000352629151707 , -0.00510978119381 , 4.60939625859e-05 , -0.000202762076754 , 0.00354248327349 , 0.00302325059072 , 0.00383992001746 , 0.000512250926028 , 0.00152959898842 , -0.00141798650081 , 0.000545700840414 , -0.00246894821396 , -0.00467035448759 , 0.00323160011769 , -0.00104348316179 , -0.00369365607014 , -0.00340752496623 , 0.00286423432064 , -0.000950799646381 , -0.000125381375908 , 0.00176932637778 , 0.000430602882194 , 0.00113116048044 , -0.00242344591388 , -0.00280094362369 , -0.000122681614019 , -0.00234049018415 , -0.000188337717893 , -0.00318793080603 , -0.00106928594326 , -0.00241270315003 , -0.000470633970169 , 0.00124340850779 , -0.000911843199286 , 0.00312148632723 , 0.000668244847526 , -0.00235640964672 , -0.00382629543243 , -0.00316414768139 , -0.00252778672319 , 0.00408624803881 , -0.00210853397397 , 0.00496510359085 , 0.00174681685788 , -0.00477464237452 , -0.000911342417214 , -0.000517393499836 , -0.000604876672407 , -0.00115876415549 , 0.00106384465007 , 0.00221921230476 , -0.0033687760861 , -0.00307899104341 , 0.00164129070272 , 0.00308588571779 , -0.00262481626737 , -0.00171028521769 , 0.00253788881097 , 0.00270638327456 , 0.00316255666198 , 0.000411026456214 , 0.0048967093509 , -0.000121266867148 , 0.00370619631157 , 0.000575505107775 , 0.00445552049974 , 0.000135179906363 , 0.00162033670294 , -0.00155428416898 , 0.00215648031229 , 0.00510879156712 , -0.000880075714758 , -0.00640125719539 , -0.000368292799886 , -0.00343480982492 , 7.52933462667e-05 , -0.0012341488604 , -0.00218885501317 , -0.0041531029691 , 0.00327786659002 , 0.00446519119584 , -0.000290804714515 , -0.0024049956528 , 0.00132566622497 , 0.00816223713997 , 0.00467999584469 , -5.72168485294e-05 , -0.000481137609788 , -0.00422705504263 , 0.000654023164181 , -0.00249502489138 , 0.00659255638418 , -0.000170727349374 , -0.00548564270993 , -0.000982722905605 , 0.00490473772744 , 0.0041969523672 , -0.00172745070629 , -0.00401643350304 , -0.00156425884467 , -0.000129150627822 , -0.000250416749803 , -0.00100943985844 , -0.00672419450167 , -0.00127587155829 , 0.00236662329027 , -0.00190869602969 , -0.00133693253038 , -0.000213617552845 , 0.000919068955308 , 0.00049053697724 , -0.00352031523168 , -0.00145809007678 , 0.00124366087518 , -0.000349503059239 , -0.00932343674995 , 0.00157702113741 , 0.0031965850601 , -0.000218553803185 , -0.00261245185848 , -0.00281767035247 , 0.00367592258279 , 0.00209971629176 , -0.000153105390004 , -0.00153889101277 , -0.00472358523478 , 0.00237223729761 , -0.00181288190632 , -0.000584233679228 , 0.00204728964544 , -0.000716008753889 , -0.000487524527206 , 0.000339516260497 , -0.0035880302078 , -0.00450712497812 , 0.00498598734342 , -0.00236726803588 , 0.00288220730052 , -7.09313701975e-05 , 0.00119530567616 , 0.00428107946949 , -0.000969372590991 , -0.00636753597746 , -0.00574923711365 , -0.00554122331874 , 0.00132897452183 , 0.0010587193267 , -0.00299633750415 , 0.000681905381956 , -0.00405170422284 , -0.00339924784525 , -0.000896380254579 , -0.00816266247925 , -0.0025145484652 , 0.00176892544945 , 0.00134975845886 , -0.00178263099554 , -0.00142948414949 , 0.00327254833179 , 0.00257404510043 , -0.00634081645204 , 0.00305340366181 , 0.00111245594922 , 0.0019532838619 , 0.000681762141568 , -0.00136365527382 , -0.000201059508477 , 0.00132307493027 , -0.000958393240493 , 0.00395744580533 , -0.00125064976366 , 0.0068468062341 , 0.000224789288665 , -0.0034112074021 , -0.000595745913152 , -0.00348322558539 , 0.00180719067269 , 6.2819171571e-05 , -1.98883910685e-05 , -0.000504317478926 , -0.00191266955558 , 0.0015076341945 , -0.000126633573341 , 0.000486691483667 , -0.00248034510966 , -0.00613932592169 , 5.00021637421e-05 , -0.00293104746637 , 0.000327585384488 , 0.00285995024063 , -0.000228013098369 , -0.00498663079672 , -0.00233012371708 , 0.000679769085757 , -0.00346109185971 , 0.00260144805898 , 0.0045128663948 , 0.00482345111376 , 0.00378774384039 , 7.82638849846e-05 , -0.00665181520002 , -0.00257324300624 , -0.00364045538295 , 0.000555254496587 , 0.00109052973215 , 0.00462982571178 , -0.000525486121415 , -0.00160567556588 , 0.00239804086587 , 0.00409318328029 , 0.00184585635607 , -0.00547367523384 , 0.000732866614281 , -0.00199118350385 , 0.00182975220004 , 0.00415952418843 , 0.000281947862556 , 0.001411736908 , 0.00350033046642 , 0.00307754077784 , 0.0029736587152 , 0.000737532080873 , 0.00349095757586 , -0.00446428449405 , 0.00244353544334 , 0.00119921962048 , 0.00607659751809 , 0.00251565287236 , 0.00445534730378 , 0.00275409034221 , -0.000925709243742 , 0.000735609654843 , 0.00233805436816 , 0.00211098815093 , -0.00548983139022 , 0.00161292256089 , 0.000230560950352 , 0.00356757589251 , 0.00273910007653 , 0.000671530699051 , -7.37891787523e-05 , 0.00354198348998 , 0.00596278369835 , -0.00132752287785 , 0.000861526387612 , -0.000917144472449 , -0.00027118646442 , 0.00435492308473 , 0.00638419124835 , 0.000654652456219 , -0.00053277546636 , 0.00260589337962 , -0.000477357892011 , -0.000184341381128 , 0.00165646131801 , 0.00282780471589 , 0.000395769537699 , -0.00287459375575 , -0.000510795252125 , 0.00151489305538 , -0.000388355805268 , 0.000109269808253 , -0.00318136790327 , 0.00165041284096 , -0.00423183678196 , -0.00584273220754 , -0.000553599695409 , -0.00364377458815 , 0.00550718085792 , 0.00208781527746 , -0.00526578705169 , 0.00185042295248 , -0.00250326494051 , 0.00128951891483 , 0.00582919834017 , 0.00324515770653 , -0.00409574826214 , 0.00582216333604 , -0.000328970307574 , -1.01212694864e-05 , 0.0010089302662 , -0.00191339038614 , 0.00204546097648 , 0.00114617979102 , -0.00319719112493 , 0.00100292934711 , -0.0011854843381 , 0.00207284847987 , 0.00207619107207 , -0.00326119360217 , 0.000585896890381 , -0.000211063883559 , -0.000408256169803 , 1.18313911908e-05 , 0.00104985630497 , -0.00387641590053 , -0.00345473441171 , 0.000790338031867 , 0.00054799853687 , 0.00247220013633 , -0.00340254476892 , -0.00329483784617 , -0.00216858134971 , -1.14245539921e-05 , -0.00157429121516 , 0.0044691398147 , 0.00309678992004 , 0.00490456533256 , -0.00171944691726 , 0.000215650660442 , 0.00524087635615 , -0.00646190309515 , 0.0012067196823 , -0.00462994562355 , 0.000451591323696 , 0.0051701431272 , -2.66371076433e-05 , -0.00381463277909 , -0.00310436587985 , 0.00156686124878 , 0.0022572624888 , 0.00403786143136 , -0.000411408266148 , -0.00273959441838 , -0.00241366140735 , -0.00190713162164 , 0.000791165586803 , 0.00377672794689 , 0.00282966421943 , -0.00220209075919 , 0.00320614413814 , -0.00220356731602 , -0.000490614557693 , 0.000205486544406 , -6.03209542942e-05 , -0.00122037199451 , -0.00420031301171 , -0.00493026139285 , 0.000221837090754 , -0.000454509225222 , 0.00285950238714 , 0.000224126398339 , -0.00589156425271 , 0.000744945706061 , -0.000450659183265 , -0.0016320219532 , -0.00292207075486 , -0.00485882917194 , -0.000708475331153 , 0.00361706418179 , 0.00469604398228 , 0.00428597316704 , 0.000480583060079 , 0.00288459418954 , -0.00263309596996 , -0.00113844058065 , -5.34903874531e-05 , 0.00542344149526 , 2.61233268032e-05 , 0.000722870611864 , 0.00157802910524 , 0.00170722615251 , 9.33184326402e-05 , 0.000635992518601 , 0.000418560772728 , -0.000645116852563 , -0.000212414164221 , 0.00177149843717 , 0.00686154875703 , -0.000558533731886 , -0.000484371319889 , 0.000924174827015 , -0.00119772079645 , -0.00207381888876 , 0.00168915049102 , -0.000868890262733 , -0.00154032911515 , -0.00261845018379 , -0.00130418113849 , 0.000577073521161 , -0.000257091038889 , -3.73814149528e-05 , 0.000378399035229 , -0.00120556343776 , 0.00120748303297 , -0.000465918522775 , 0.000522102412378 , -0.00137442830526 , 0.00026678543054 , 0.00247447637884 , -0.00388301602277 , 0.00310371529932 , -0.000522496883493 , 0.0070461217912 , 0.00331497205 , 1.08290322891e-05 , 0.000706073465829 , -6.57406506046e-05 , 0.0044564634782 , 0.00125759225688 , -0.00359069767807 , 0.00133969240654 , 0.000220933413853 , -0.00675210922935 , -0.000376013390729 , 0.00268502493605 , -0.00408928535735 , 0.002041465523 , -0.0007842567215 , -0.0020459620931 , 0.00252281563615 , -0.00349561144358 , -0.000524886477443 , -0.00125707716316 , -0.00350240303064 , -0.00773423659863 , -0.000401006682203 , -0.00123431627055 , 0.00125492336697 , 0.000820669550018 , -0.00148820490759 , -0.00160577656839 , -0.00200683048188 , -0.000948094180961 , 0.00182353240313 , -0.000449977495612 , 0.000554954809063 , -0.00537970701345 , -0.00216794471534 , -0.00538886634403 , 0.00355022043839 , 0.00230461574717 , 0.00170472274195 , -0.003267069988 , -0.000643798938278 , 0.000594266229603 , -0.00252600392036 , -0.000793115057578 , -1.89048526548e-05 , -0.00144267283011 , -0.000380293629256 , -0.00488228541195 , 0.000286945624508 , -0.00314974595652 , 0.00296558227969 , 0.00159141245724 , 0.00281617758553 , 0.00310016293636 , -0.000332891715554 , -0.00842951368153 , 0.00337050579946 , -0.00303770481592 , -0.00324529843299 , 0.00549323956124 , -0.00169017617997 , 0.00261734272647 , -0.00298868630646 , 0.00119868389613 , -0.00213794068283 , -0.000896991419336 , 0.005642926323 , 0.00145911462946 , 0.0012666255615 , -0.00482383418782 , 0.0027508714044 , -0.00244997187019 , 0.00114370945304 , -0.000484161027836 , -0.00247073962314 , 0.001172362268 , -0.00379043982963 , -0.00496505088722 , -0.00187226247409 , -0.00106821117627 , 0.00206996471887 , 0.00124447686677 , -0.00118561918423 , -0.00144258309206 , -0.000239316482179 , -0.00354371683728 , 0.00112295062367 , -0.00481116475928 , -0.00145566724842 , 0.00201008922437 , -1.48928088654e-06 , 0.0028686930185 , 0.000921401907501 , 0.000525393152147 , 0.00282093595206 , 3.44407441284e-05 , 0.00586559711505 , 0.00380577875652 , 0.00271117717667 , 0.00074025572137 , -0.000120875607753 , 0.0021916994658 , -0.0022815471841 , 0.00230170472538 , 0.00532540354604 , 0.00329219930808 , -0.00549063541405 , -0.00196719613293 , -0.000232630278217 , 0.00336883533437 , -0.00211098837383 , 0.00182130835131 , 0.00224412252079 , 0.00329186466213 , -2.36253262423e-06 , 0.000194484911646 , 0.000493146036495 , 0.000206286809071 , 0.00926722590412 , -0.000291687109163 , -0.00258058565623 , -0.00326907563433 , -0.000412751474716 , 0.000983133104906 , -0.00544220963192 , -0.00418829678004 , -0.00143280728254 , 0.00320095660802 , -0.0016838862142 , -0.00616044348424 , 0.00388817625811 , 4.28623354369e-06 , -0.0056001118312 , -0.00172126503727 , -0.000726738300387 , 0.00297493484295 , -0.00381794349258 , 0.00412252023521 , 0.00334582718372 , 0.00347839858756 , -0.000259598333886 , -0.00335864315804 , -0.000542996109905 , 0.000638166726695 , -0.00190354507843 , 0.000889106126415 , 0.00029160225214 , 0.0066508752604 , 0.00046964018868 , 0.00506514506295 , -0.0027116286827 , 0.00266060673822 , 0.00354229094503 , 0.000567822494893 , 0.00525562746441 , 0.000153984747288 , 0.00126133183758 , 0.00101789871363 , 0.00186704297514 , -0.00352054728799 , 0.00255130992302 , 0.00182023293786 , -0.00371897701801 , 0.00207885991504 , -0.00176791717947 , 0.000219385908182 , 0.00308177930525 , -0.00267789976846 , 0.000714117348469 , 0.00537058215656 , -0.00101999145238 , -3.72891528389e-05 , 0.00106567372006 , -0.00480806979051 , -0.00439762754602 , -0.00488670054226 , 0.000970632892596 , 0.000174947366644 , -0.00177041441267 , -0.00176579134938 , -0.00280644453329 , -0.00247791964409 , -0.00273759088001 , -9.92900906714e-05 , -0.000233765181478 , 0.00142264406988 , 0.00114296322312 , 0.00543856702296 , 0.00159530513792 , -0.00445359483017 , 0.00568184572114 , 0.000629677731433 , -0.00200201952002 , 0.00200035196885 , 0.000222220150811 , -0.00626190913942 , 0.000914989725096 , -0.0017282993861 , -0.00163720597156 , -0.00160257314976 , -0.00028268298163 , -0.00153505868147 , -0.00087404937138 , -0.00173983696756 , -0.0033913935606 , 0.00299702083379 , 0.00239075718839 , -0.00217962090925 , -0.000858757396136 , -0.00318023913007 , 0.00171602644789 , 0.00267706839807 , 0.00589216169649 , 0.000144260130527 , 0.00121572916249 , 6.20700097409e-05 , -9.06745326964e-05 , -0.00077006795677 , -0.00469605507961 , -0.000930929889112 , 0.00268896585 , 0.00730802075069 , -0.000407485754543 , 0.00759935887906 , -0.000177928132589 , 0.00151393168079 , -0.00352348189428 , -0.000997518071924 , 0.00480582201175 , 0.000374611625856 , -0.00311939225698 , -0.00342839712337 , -0.00329156832369 , -0.00248918015802 , 0.00045866049068 , -0.000245424612767 , -0.00210552255623 , -0.00165662944119 , 0.00046380077072 , 0.00685626311402 , 0.000572619544886 , 0.00382573693171 , 0.00109586819546 , -0.000867198587605 , -0.000290581839894 , -0.00219688860785 , 0.000989102537063 , 0.0043852027018 , 0.000772025551119 , -0.00111334018525 , -0.00142812736707 , -0.000139031960237 , 0.00154475553218 , -7.04219845065e-05 , 0.000144811990532 , 0.00428547800491 , 0.00238063514968 , -0.00381547403953 , -0.00399091708268 , -0.00409058358577 , -0.00333628279949 , -0.00481178842528 , ])
Y_4_m2_imag = flex.double( [ -0.0 , 0.0 , 0.00165048949266 , 0.00550921762066 , 0.00103752742351 , -0.00356671307875 , -0.0043059519844 , 0.000512383186607 , -0.00526188404067 , -0.00228044397732 , -0.000791049771748 , -0.0020074119495 , -0.00391566571227 , -0.00195928534196 , 0.00317021638012 , -0.00176535646514 , -0.000517437855716 , 0.00417634084081 , -0.000905108415422 , -0.000726423901535 , -0.000949036079275 , 0.0023086075465 , -0.00289272803873 , 0.000598028321439 , 0.00351111878193 , -0.00537429971808 , 0.000541606662892 , 0.000218755580281 , -0.0010736478562 , -0.00122358647465 , -0.00440430416595 , -0.000199400444604 , -0.000418420839485 , 0.0017027144272 , -0.00202837434785 , 9.38261417797e-05 , 0.000773722444175 , -0.000334270792927 , -0.0010691082392 , -0.00121548257469 , -0.00365889066866 , -4.77482834045e-05 , 0.0021025760424 , 0.000703160717145 , -6.80955401455e-05 , -0.000145617639055 , 0.000267376585331 , -0.000668032200979 , -3.91511723328e-06 , 0.00269966592675 , -1.57197929349e-05 , -0.00050460588955 , 8.58274150535e-05 , 0.00100209992072 , -0.000608449224878 , 0.000104053899178 , -0.00199550557363 , -0.00452456855903 , -0.00294346387889 , 0.00444712133791 , 0.00126951022566 , -0.00385615518854 , 0.00321436743866 , 0.00189950680145 , -0.0076836882949 , -0.00320444241663 , 0.000603457654873 , -0.00312818607647 , 0.000883306694908 , -0.000805019725056 , 0.000813768283848 , -0.00286943128501 , -0.00151790644784 , -0.00585235777256 , 0.000353424748236 , -0.00431660013302 , 0.000317355543507 , 0.000689892235148 , 6.79658841342e-06 , -0.00430642248802 , -0.00562700815467 , -0.00241027271653 , 0.00018423258886 , -2.28355677856e-05 , -0.00482307077437 , -7.1002361576e-05 , 0.000739827240951 , -0.001431385312 , -0.000456783155543 , 0.00456140174072 , 0.00348821575968 , 0.00453719510433 , -0.00453468619896 , 0.000732184143218 , 0.00413845739272 , -0.000984614181733 , 0.00260677126626 , -0.00331962999255 , -0.000411237771052 , 0.00441544910903 , 0.000697025619686 , -0.000184785523642 , 0.00186676706642 , -0.000500252659159 , 0.00399085969928 , 0.00242996750049 , 0.000691139140768 , 0.00120832717594 , -0.00322163913644 , 0.00116689125112 , -0.00383796952779 , 0.00267546817222 , -0.00417017426201 , 0.00139705900254 , -0.00211622968951 , 0.00294825223459 , 0.0001780183963 , -0.000978189657716 , -0.00232584888987 , -0.00282614807628 , 0.000290034573967 , 0.000189231439947 , 0.00421280610299 , -0.0010433315558 , -0.00411210662917 , 0.00313448247031 , -0.00256235072939 , 0.00207435061449 , 0.00426944559472 , 0.00060885321748 , 0.00416019932157 , 1.73660604729e-05 , 0.000239253779674 , 0.000771192452965 , 0.000203859804874 , -0.00073112090529 , 0.00317310927494 , 0.0028882044084 , 0.000550347793434 , -0.00173712739752 , -0.00446226989844 , -0.00224095650991 , -0.00221554195689 , 0.00549859714578 , 0.00267751252738 , -0.00021813920678 , -0.000687005710275 , -0.00215699573089 , -0.00058753845115 , -0.000600051792731 , -0.00184670928151 , 0.00180010838718 , -0.00178236653567 , 0.000631093119217 , -0.00259936958319 , 0.0013882117243 , -0.000808590316883 , 0.00490399139581 , -0.00349694170938 , 0.00027150482787 , 0.00128564997101 , -0.000998785415264 , 0.00039034456793 , -0.00425860122923 , 0.00288579145048 , 0.00200670368741 , -0.00536307675321 , -0.00350351617587 , -0.000614416081127 , -0.00217842618272 , 0.00167931357202 , -1.67777063529e-05 , -0.00208758791116 , 0.000623990556504 , -0.00282462325032 , -0.0012090589993 , -0.000569078400348 , -0.00225914217606 , -0.000462777702113 , 0.000945099778203 , -0.00332203245575 , -0.00106147126361 , 0.000748014674684 , -0.00117957403076 , -0.000749952471478 , 0.00200312463927 , 0.00249868836875 , 0.00433632153793 , -0.00289669511216 , -0.00160983494082 , -0.00191709697107 , -0.00208946157093 , -0.000132093827805 , 0.000246912965253 , -0.00529195397994 , -0.00406391186265 , -0.00064341646519 , -0.00451679463018 , 0.00245683795735 , 0.00108309224962 , -0.000223023541345 , -0.0059000318246 , -0.00277974616123 , -0.000609748878415 , 0.00191335436349 , 0.00164387728411 , -3.96253932435e-05 , -0.00263537085227 , -0.00322454420255 , -0.00193863929611 , -0.00480228563329 , 0.000869349466684 , 0.00087813345346 , -0.000403710368769 , -0.00139183576702 , -0.000849729848314 , 0.000153989732419 , -0.00118265418287 , -0.000747131907058 , 0.000768645405948 , 0.00209534130866 , 0.00551714297733 , 0.00758288534868 , -0.00373142492829 , 0.000545111475474 , -2.24246861783e-05 , -9.63517958671e-05 , -0.00727362047069 , -0.00100690225752 , 0.00209925505548 , -0.000208023143881 , -0.00160688705369 , 0.00498106602712 , 0.00107520438714 , 0.000216606514866 , -0.000922665001499 , 0.00118510748062 , -0.00375551768373 , -0.00115747111815 , 0.00431117584494 , -0.00110716245467 , 0.00435178228833 , -0.00255541255381 , -0.00167237164274 , -0.000166202767586 , 0.000341765357424 , 0.00342821567887 , -0.00628095901166 , 0.000669433465113 , -0.00300124580181 , 2.86520818938e-05 , 2.00054704724e-05 , -0.00460860668654 , 0.00166995682829 , -0.0036449953558 , -0.000294371398805 , -0.000336292498762 , 0.00105276021347 , 0.000540020643563 , -0.00271609173593 , -0.00348365650901 , 0.00291250647219 , 0.000276953214442 , 0.000143126047182 , 0.000849321661092 , -0.00171651500412 , -0.006542851483 , 0.00201683114395 , -0.00664163278352 , 0.00114406193606 , 0.00205232577169 , 0.000477259866604 , 0.000682878030124 , -7.27213237586e-05 , 0.00671786487292 , 0.00209273338901 , 0.00563418842402 , -0.00152274457595 , -0.00348395412325 , -0.00113972705914 , 0.00249465241965 , 0.00537139435105 , -0.000909940667469 , -0.00506844202727 , 0.00256434227449 , -0.00513478908068 , -0.00635452590027 , 0.00304589464583 , 0.00262984356885 , 0.00118539948985 , 0.00227128430072 , 0.00456972227643 , -0.00465343380837 , 0.000739994838893 , -0.000252710631429 , 0.00175922792364 , -0.00786583838916 , -0.00422966162688 , 0.00173160914474 , 0.000173813371183 , -0.000200255239769 , 0.000121232148757 , 0.00227043785542 , 0.00236512575688 , 0.00538275997924 , 0.00476279215872 , 0.00387204209022 , -0.00510887724032 , 0.000431655209601 , -0.000905414676066 , 4.56743542603e-05 , 0.00198420648254 , -0.000989528370901 , -0.00145776700357 , -0.00248640915089 , 6.32465249603e-05 , 0.00151557426375 , 0.000243263000269 , -0.00399429863708 , -0.000318480270199 , -0.000267757719884 , -0.000898378851227 , 0.00632585350124 , 0.00139785373416 , -0.0030106489582 , -0.00321329733388 , 0.00292404923505 , -0.000467728272768 , 0.00552734692777 , -0.00615276352806 , -0.000236044064206 , 0.00107160934372 , 0.00369933763621 , -0.00391193453077 , 0.00276110081054 , 0.00104586537674 , 0.000223305877723 , 0.000229049386285 , -0.00567474823651 , 0.00397298235612 , -0.000378142094678 , -0.00302598368883 , 0.00509422095337 , -0.003934588037 , -0.00146411009421 , -0.000386286977962 , -0.000914792242656 , -0.00200308625469 , -0.001269229683 , 0.00954391296497 , 0.000334588528878 , 0.000989651745455 , 0.000543111556857 , 0.00334857349696 , -0.0016411893413 , -0.00274468576781 , 0.00288224165138 , 0.000842701170245 , -0.00394808249945 , 0.00503219498898 , -0.00378145957539 , -0.00145516633638 , -0.000170624486033 , -0.00136180012231 , -0.00269565618278 , 0.00600526348441 , -0.0029376627654 , -8.37808474506e-05 , -0.00425450013674 , -0.00209657639429 , -0.00276794710106 , -0.00436092520179 , 0.00023425660637 , 0.00321107137768 , -0.000613135690415 , -0.000560185738878 , 0.000223802726916 , -0.00505451534807 , 0.000624603202686 , -0.00207938641277 , 0.00124645137272 , -0.000206080546438 , -0.000353024701291 , -0.00134112687787 , 0.00681992521905 , 0.00194047820639 , -0.00371298445623 , 0.00248173207204 , -0.000552025382167 , -0.00499135762093 , 6.61899340631e-05 , 0.00112478609113 , 0.00616490039215 , 0.00180016004783 , -0.00830494366251 , 0.00182639054176 , 0.00116431952695 , -0.0054846044815 , -0.00264099202345 , -0.00174478714451 , 0.00203853232196 , -0.00275834193859 , 1.44923918899e-05 , 0.00384812291024 , 0.000765066444839 , 0.00564922434725 , -0.000729168434003 , -0.00291106644434 , 0.00254510138891 , 0.000618297824178 , 0.00368400056424 , -0.00100529624489 , -0.000512758766508 , -0.000340342132343 , 0.0051427750137 , -5.39158260549e-05 , 0.00451625712665 , -0.00227965470436 , 0.00374377987428 , -0.000813204295674 , -0.00369827280733 , -0.00191493048037 , -0.00179273731117 , 0.000373043472911 , 0.000178724866028 , -8.01709676916e-05 , 0.00736920937508 , 0.00124004766282 , 0.0068861212233 , 0.00318329728813 , -0.00141713215161 , -0.00222056333346 , -0.000638746435622 , -0.00248663023045 , 0.00104098680012 , -0.00104735600161 , 0.00182614196246 , -0.000481672291314 , -0.00367667329627 , -0.00163270388179 , 0.00254895275054 , 0.00161349102371 , 0.00184868569684 , 0.00344132665629 , 0.00362047579536 , 0.00116655043588 , -0.000796802877891 , 0.00114538387087 , -0.000753664081704 , -0.000382195887482 , -0.00355638470591 , -0.00101109733179 , 0.00114396815453 , -0.00117454752024 , 0.00359436217462 , -0.0022590005796 , -0.00717615923469 , 0.00577599814227 , 0.00154777674636 , -0.00455449212496 , 0.00459191257486 , 0.00366165345865 , 0.00680283682901 , -0.0057773259707 , -7.30910288703e-05 , -0.00145558410661 , -9.57327530571e-05 , -0.0018684426876 , 0.00336149557871 , -0.000467426172267 , 0.00244304265719 , 0.00443169981765 , -0.000435297810452 , -0.00323141724318 , -9.54853674562e-05 , -0.00613035812784 , 0.00257926103428 , 0.00353808381419 , -0.00257749696287 , 0.00346062573068 , -0.00332752062949 , 0.00080360793446 , 0.00346194361777 , -0.00313068420306 , 0.000443565163099 , -0.0013421988508 , -0.0045297448735 , -0.00147407908732 , 0.00260902765469 , 0.00489733604697 , -0.000271468483354 , -0.00194109513828 , 0.00327353360099 , -0.00271721111559 , -0.000980468391887 , -0.00774735197978 , -0.0014508299692 , 0.00464100784127 , 0.000785207559675 , -0.00215056221589 , 0.00611471520195 , 0.00422710282663 , 0.00550198039266 , -0.000610719321764 , 7.80813459207e-05 , 7.4010220558e-06 , 0.000810593056123 , -0.000790524656873 , -0.0013456418744 , 0.00130758726916 , 0.00313755448008 , 0.00453091887114 , -0.000403035885186 , -0.000743825636646 , 0.0026523855338 , -0.00425502655323 , 0.00389921546571 , 0.00272225158566 , -0.00398069295693 , 0.00406632967709 , 0.00319550858293 , 0.0036246804423 , 0.00170833416678 , 0.000845537534017 , 0.00153770031949 , -0.00104902635299 , -0.00604776019179 , 0.00164343837437 , 0.00449356451388 , -0.000125319663222 , -9.43346030962e-05 , -0.00178177709416 , -0.000381131326478 , 0.00100268932821 , 0.000649297401899 , -0.00595621729009 , -0.00130432333864 , 0.00343470653531 , -0.00209878436439 , -0.00166127149287 , 0.003912060926 , 0.0012882847437 , -0.000876119014267 , -0.00164348276093 , 0.000416181585899 , 0.00324352287118 , -0.00221006801395 , -4.40979763737e-05 , -0.000359243235073 , 0.00286188916382 , -0.00201169646535 , 0.00412705192181 , 0.000512034925754 , 0.000266606305948 , 0.00142040243252 , 0.000176521799792 , -0.000913061777244 , 0.00374091766034 , -0.00429085359401 , 0.00348488262462 , -0.00144470877365 , 0.000912644238046 , 0.000540371761585 , 0.00125048137115 , 0.00318758012805 , -0.00217003715261 , 0.0028211845277 , -0.00319795867333 , -0.000703285958432 , 0.00305420279993 , 0.00264051089318 , 0.00217344410399 , 0.00290905060485 , -0.00293583556475 , 0.00271404293333 , 0.000962653270104 , -0.00185969788591 , -0.000432770167347 , -0.000109097401507 , -0.00490883239585 , -0.000465784369009 , 0.00451710638491 , -0.00586751154414 , 0.000352376844529 , 0.00145530610929 , 0.000505933758215 , -0.00662489648905 , -0.000781252025726 , -0.00371563543368 , -0.000381414271367 , -0.000777969632061 , 0.00574831141211 , 1.45960523114e-05 , -0.00235995356799 , 0.00148793448376 , -0.000707399276285 , -0.000184666164433 , -0.00101748580489 , -9.81712995996e-05 , 0.00408383418749 , -0.00158108635271 , 0.00124624356451 , 0.000101954645572 , -0.0042316359138 , 0.000202909069239 , 0.00251920406927 , 0.00353297149001 , 0.00393330329501 , -0.00205708924506 , 0.00352889433575 , -0.000694374054997 , 0.00338228787621 , 0.000149456620415 , -0.00275149843419 , -0.00337307793026 , 0.00106777743274 , -0.00312839205229 , -0.000653682420808 , 0.00165287989566 , 0.00209620033139 , -0.00748440416701 , 0.0017944405773 , 0.00737933089547 , 0.0043754238178 , -0.00197444601703 , 0.000370194000605 , -0.00258444306404 , -0.000781009095862 , -0.000249804688152 , 6.12497354423e-05 , 0.000366252339472 , 0.00381842700662 , -0.00144529973239 , -0.000724148871692 , 0.00469853917559 , -0.00269157050611 , 0.00212623660162 , -0.00346577116793 , 0.000572632974096 , 0.00153360909488 , -0.006871694003 , 0.00338335350037 , 0.0014715162389 , 0.000763551766488 , 0.00236698367664 , 0.00456470401103 , 0.000234567413965 , -0.00417918565543 , 0.000738341901514 , -0.00230412035331 , -0.00257834944147 , 0.00181979082073 , -0.00269801340084 , 0.00287902623201 , -0.00297227652571 , 0.00314523520243 , 0.00225121881279 , 0.00404324591409 , 0.00178552617522 , -0.00173934305699 , -0.00105441965836 , 0.000436443668436 , 0.00363789490976 , 0.0044842546136 , 0.00273754544045 , -0.000424552143468 , -0.00337685880928 , -0.00229205510177 , 0.0018820472048 , 0.00506390988221 , 0.00500306502873 , 0.000614373718944 , -0.000194701864983 , -0.000870574999206 , -0.00238266100355 , -0.00155196507227 , 0.00649041999027 , 6.76079912474e-05 , -0.00208888321799 , -7.79410250575e-05 , -0.00234994660441 , -0.00350480206696 , -0.000731153927171 , -0.00191137484662 , -0.000749955227113 , -0.00351883510499 , 0.00047400875077 , 0.00171655092216 , -0.00500221361154 , -0.00234373785747 , -0.00601669100332 , -0.00104939309983 , 0.000126421247798 , 0.00017810097864 , 0.002679393865 , 0.00238076397973 , -0.00027368126165 , -0.0014717425496 , -0.00528604811927 , 0.00125256826475 , -0.00148714130595 , -0.00111332901009 , 0.00132613161695 , 0.000650806650067 , 0.000977513915801 , 0.0011838029825 , -0.00178792288718 , 0.00921873907544 , 0.00299578766609 , 0.00814226541772 , -0.00320719786116 , -0.00111840412666 , 0.0019721153746 , 0.000419109159679 , -0.00207797117306 , 0.00297715963494 , -0.00443317613985 , 0.00139072495695 , 0.0033221928229 , 0.0055986190897 , -0.00367639157052 , -0.00080579545865 , -1.56591562395e-05 , -0.00149377930788 , -0.00374967937571 , 0.00212358032044 , 0.0028377453311 , 0.00189752422271 , 0.000223676981719 , 0.00319757862457 , -0.00219667823296 , 0.0021928144272 , -0.00203076035383 , 0.000130491348987 , -0.00176240904156 , 0.002945682182 , -0.00511160879263 , 0.000970574731689 , 0.000764066076141 , -0.00923017936366 , 0.0029012627718 , 0.00198998370255 , 0.00125073625036 , 0.00152633111302 , -0.000379242270043 , 0.00272725651473 , 0.00142067384256 , -0.00718916940956 , -0.00333545030354 , -0.00147058900098 , -0.000661855274876 , -0.00345682071776 , 0.00290182666757 , -0.0007179615543 , 0.000293494454098 , -0.00172660082903 , 0.000712713482475 , -0.000509504080932 , 0.00216942786099 , 0.000217397252963 , -0.000648418170765 , 0.00187494353609 , 0.00210123606582 , -0.00232199600112 , 0.001130517945 , -0.00405124847691 , 0.00303164238305 , -0.00157122585894 , 0.00212099120105 , 9.32670574018e-05 , -0.00548106335315 , 0.00444446185853 , 0.000801597623938 , 0.000252244461596 , -0.00324782499304 , -0.00123240279318 , 0.00451727922919 , 0.00491395709976 , 0.00156777151689 , -6.61293772783e-05 , 0.000267884473717 , 0.000831387005582 , 0.00641320027766 , 0.000356204503319 , -0.000269274329554 , -0.00391376172422 , 0.00243052555743 , 0.00266383373486 , -0.00637577925125 , 1.39996745381e-05 , -0.000264973171309 , 0.00189976073769 , -0.00319488215613 , -0.00463092039032 , -0.00250477283917 , -0.0023292044055 , -0.00400935753744 , -0.00230180051769 , 0.00329296602542 , 0.00314736057986 , 0.00250107265371 , 0.00095683294826 , 0.00326693673875 , -0.00338736016987 , -0.0027315607107 , -0.000987216274942 , -0.000689966309206 , 5.1322080561e-05 , 0.00118959673685 , 0.000159747050972 , 0.000913644613065 , 0.00467698283589 , -0.00565091212532 , -0.00560219882985 , 0.00258738817766 , 0.00113672746289 , 0.00229724352358 , 0.00358551758628 , 0.0035574510418 , -0.0038379144588 , -0.00222838598009 , 0.00730559243512 , 0.00279491158145 , 0.00455584505196 , 0.00176836280493 , -0.00124382435489 , 0.0005007876007 , -0.00522183283758 , 0.00234878540876 , 0.00073092310039 , -0.00602794628432 , -0.00179105780027 , 0.000141617083006 , -0.00258322999833 , -0.0024273716521 , -0.00232527790757 , -0.00234389471314 , 0.000201247154059 , 0.000387057010919 , 0.000919512300567 , 0.000318254916523 , 0.00352853910127 , 0.00221392107764 , 0.00704052968941 , -0.000704021142213 , -5.61658776243e-05 , 7.98457295836e-05 , 0.000185134334155 , -0.00316564793414 , -0.00600938676581 , 0.00225591417266 , -0.000932214673195 , -0.00442336222743 , -0.00072060474145 , -0.000549177890341 , -0.000254020230151 , 0.000114992863072 , 0.00447237630605 , 0.0022345571478 , 0.00288127257462 , 0.00392728128732 , -0.000459908816596 , 0.0001977433737 , 0.00478836399691 , 0.000806936001798 , 0.00382941832849 , 0.00478606722286 , 0.00220109140288 , 0.000725122472136 , 0.00383661244724 , -0.00390699099458 , 0.00489526369393 , -0.000174347971822 , -0.00092722778209 , -0.00105209223743 , 0.00502073476769 , -0.00177387585923 , 3.03171376182e-05 , -0.000449435898028 , -0.00065230216256 , -0.00353037088492 , 0.00162191444539 , 0.00159956498853 , -0.0018546911013 , 0.00222053678474 , -0.0026366554975 , 0.00411099733308 , -0.00181592355169 , -0.00637690684128 , 0.000957372849045 , -0.00174857018025 , 0.00295372748815 , 0.00130939431542 , -0.002862961048 , -0.00280238426266 , 0.00175689006484 , 0.000851618153851 , 0.00135703970978 , -0.00252058053027 , -0.00082002834254 , ])
Y_4_m1_real = flex.double( [ -0.0 , 0.00193645963072 , 0.00104735493773 , 1.09372208036e-05 , -0.00269110611553 , 0.000346880984608 , 3.5034517633e-05 , 0.0040716136948 , -0.000814130399424 , -0.000548432949529 , -0.00322860018651 , 0.0020063307353 , 0.00378365599353 , 0.00104747435493 , 0.00655651627798 , 0.00185596834978 , 0.00148128476921 , -0.0119700438887 , -0.000564944907853 , 0.00677974097584 , -0.00315447972256 , -0.000666081527373 , 0.000323198545423 , 0.00333085158118 , -0.00388397963064 , -0.00723535418524 , -0.00210327198736 , -0.000236369599487 , -5.594671027e-05 , 0.0042413510823 , -0.00685932074235 , -0.000411982522158 , 4.29202154728e-07 , 0.00352159961515 , 0.00058869144569 , 0.00464669307175 , 0.00318226038628 , -0.000321806402613 , 0.000374686850581 , -0.00244537147557 , -0.000142065416904 , 0.00464868421684 , -0.00126947590507 , 0.00222608844185 , -0.00351310136458 , 0.0043684184204 , -0.00393877917319 , -0.00423113673526 , 0.00422932624976 , 0.000148877425849 , -6.23828154243e-06 , -0.00111461877509 , -0.00352217467415 , -1.95700944934e-06 , -0.00323859656451 , -6.05455150714e-05 , 0.00500109658719 , 0.0023550300643 , 0.00599145074922 , -0.000195065315875 , -0.00198021099309 , -0.000137257139832 , 0.00527822561594 , -0.000879034518286 , -0.00370364763675 , -0.000231019862737 , -0.00349250558119 , -0.00470063771308 , 0.000419454636308 , 0.00340999358852 , 0.00378175834441 , -0.0016316398659 , 0.00108939232027 , -0.00344076205823 , -0.000728799500847 , -0.000391135084551 , 0.00170812400832 , 0.00578249159348 , 0.000227108151765 , 0.00235263617305 , -0.00527812628924 , 0.00397558347908 , 0.00337691924896 , -0.00395070707385 , 0.00161793718442 , 0.00439422554598 , 0.0012559459701 , 0.00177906541768 , 0.00574572118775 , -0.000341896165963 , -0.000856525690321 , 0.00428309086817 , -0.00162479793531 , 0.000223539432185 , -0.000473917207443 , -0.00104518318321 , -0.00350978983741 , 0.000836566548853 , 0.00111195828284 , -0.00249469236698 , -0.00178474888502 , -0.00229127943586 , -0.000356148705934 , -0.000456901712251 , -0.000632588118904 , -0.00407712527592 , -0.000626222614552 , 0.000301944464409 , -0.00160345211809 , 0.00318442196756 , -0.00580217050472 , 0.00372515122558 , -0.000765629326254 , 0.00236506383277 , 0.0059497824564 , 0.000626766788036 , 0.00469684839781 , -0.00314899398404 , 0.000371627297112 , -0.00263400749641 , 0.000447002343172 , 4.68637825805e-05 , -0.00256643451538 , 0.00167473428584 , -0.00136085317705 , 0.00273710675164 , 0.00387352010469 , -0.00323298924165 , 0.00169882200653 , -0.000955213748499 , 0.00298142202474 , 0.00568679354476 , -2.98290578444e-05 , 0.00488595912403 , -0.00020873226523 , -0.00455331884377 , 0.00178023612936 , -0.00223470347292 , -0.00467749009047 , -0.000429218985005 , -0.00275038455447 , -0.000575578411833 , -0.00218838951198 , 0.00576309327594 , -7.10739485765e-05 , 0.00325472107976 , -0.00356582634431 , -0.00324211701867 , 0.000886943291356 , 0.00301756016513 , 0.00151765813488 , 0.000483215170731 , -0.000606486463338 , 0.000307819140344 , 0.00243292169379 , -0.0013527852518 , -0.00289576436266 , -0.000118522598168 , 0.00222148935391 , 0.000560448412372 , -0.000792322837924 , -0.00204318997669 , -0.00729317975707 , 6.67087009419e-05 , -5.43932978949e-05 , -0.00149985616466 , -0.000410982343396 , 0.00238386419805 , 0.00283567714072 , -0.00700022806808 , 0.00178218376338 , 6.86072196508e-05 , -0.00132451621553 , 0.0020986824304 , 0.00210653154745 , -0.00548060602194 , 0.00166485210415 , 0.000253225018073 , 0.0021627660094 , -0.000834779183875 , 0.000416705886103 , -0.00295872909602 , 0.00268203888014 , -0.00443966508211 , -0.00012434772902 , -0.0061918729923 , 0.00483002701863 , -0.00172757657914 , 0.00219049081924 , 0.00302587089142 , -0.000798956968761 , -0.00137762024746 , 0.00148522292122 , -0.00467609801131 , 0.00121081219992 , 0.000632122581684 , -0.00138114836655 , 0.00158470951737 , 0.000486166340298 , -0.00445461792943 , 0.000583655711716 , 0.00106567440201 , -0.00243716378248 , -0.0011497822226 , 0.00770857338686 , 0.0020875877161 , 0.000268620079059 , -0.00161345198899 , -0.00429920542013 , -0.000894956178717 , 0.00183816158018 , 0.000596058011239 , -0.00121461472404 , 0.00411272903506 , -0.00329712368836 , 0.0030309939287 , -0.00423575432746 , -0.000142767788904 , 0.000384023062879 , 0.00393200347345 , 0.00358525215918 , 0.00180187944957 , 0.000444295293085 , 0.00215270635364 , 0.00207070656422 , -0.000163396580532 , 0.00384116093951 , 0.00362278475642 , 0.000176434720731 , -0.00135605431525 , -0.00519326798974 , -0.000924245463359 , 0.00171065290572 , 0.0036959780079 , -0.0022613010256 , 0.000241081400658 , -0.000442625626827 , -0.00107847546058 , 7.90293307615e-05 , -0.00173706241049 , 0.00150668506451 , -0.000566745520738 , 0.00141860390937 , -0.000227302167535 , -0.0005826133434 , 0.000182000802112 , 0.00371158327494 , -0.000504836587733 , 0.000427333998574 , -0.000514187072969 , 0.00368859726642 , -4.40276724743e-05 , 0.00681280560514 , 0.00393725456601 , 0.00321833207829 , -0.00464644680669 , 0.00196461838058 , -8.10464933128e-05 , 0.00322474046001 , -9.96013576369e-05 , 0.00139490307164 , 0.00433880902546 , -0.000436435378784 , -0.00203471940983 , 0.00322574873139 , -0.0043677013963 , -0.000703656786062 , -0.000760294026585 , 0.00223750863716 , -0.0042272057974 , -0.00164515915304 , -0.00253121215375 , 0.000139733446257 , 0.00453887819789 , -0.000773262456083 , 0.0018711052431 , 0.000621678908494 , -0.00472521986642 , 0.001391745374 , -0.00157710157747 , -0.00183552182978 , -0.00097428667835 , 0.00509905004084 , -0.000400255775715 , -0.000658462946208 , 0.00140966356809 , 0.00243542957748 , 0.000272832869191 , 0.00111256237223 , 0.00246616249948 , -0.00298482907486 , 0.000648649742354 , -0.000693571688102 , -0.00175558371075 , 0.000328558586053 , -0.00290093954874 , -0.0016077008818 , 0.00121475433623 , -0.00342298573979 , -0.00238460744777 , 0.000251568391893 , -3.00037128223e-05 , 0.000198807522316 , -0.00180742678271 , 0.00318523932767 , 0.000923397127108 , -0.000889204751442 , 0.00647408962799 , -0.00455602322112 , -0.00022275816212 , -0.00104987916393 , -0.00128166030057 , -0.00467725957955 , -0.000893243274945 , 0.000689463018672 , -0.000130409171246 , 0.000124430421816 , -0.000897463220165 , 0.00085898045369 , 0.00396160304308 , 0.000576963656529 , 0.00135659858511 , 0.000775649233719 , 0.000276757949789 , 0.00692577805609 , -0.00171820401969 , 0.00233594137447 , 0.000326153463837 , -0.00831955818601 , -0.000622256963363 , 0.0015682393694 , 0.00152978171772 , 0.000470804642278 , 0.00568106300634 , -0.00191117606103 , 0.000146652092959 , -0.00199557515167 , -0.000105634223812 , 0.00200120188079 , 0.00390208701483 , -3.35732856677e-05 , -0.00404752750725 , -0.00218686635221 , 0.000303816755159 , 0.00081866573252 , -0.000163253191105 , 0.00167962654016 , -0.00161603099993 , -0.00220669811008 , -0.00761011745931 , 0.00466931835924 , 0.00159440972589 , 0.00168960620093 , -0.00189743777247 , 0.00321412383812 , -0.00181350839802 , 0.00175238971829 , 0.00168764611598 , 0.00201486234962 , -0.000839906312279 , -0.00306809922314 , -0.011535927446 , 0.000644630699246 , -0.00267023787343 , 0.00173355091995 , -0.000245090007206 , 0.000874311745249 , -0.000170647233614 , 0.000291184137629 , -0.000622275075883 , 0.00276546819302 , 0.00201381562293 , -0.00335903408077 , -0.0020612959155 , 0.0039238765637 , -0.00244288659613 , -0.00100613555349 , -0.000650717936473 , -0.000101648956479 , -0.000983652577026 , -0.00153656966022 , -0.000129812755948 , -0.00301040371113 , -0.00456681541244 , -0.00151057041351 , 0.00290623593541 , 0.000794115540781 , 8.49163278793e-05 , -6.64787976567e-05 , 0.00214262056429 , 0.000141377440333 , 0.00070789538849 , -0.000125145761059 , 0.00393516683292 , -0.00599003401665 , -0.00455079770142 , 0.000496995372024 , 0.0033806443621 , -0.00066780905236 , -0.00198286284116 , -0.000305510356874 , 0.00458412129865 , -0.00597211250482 , 0.00143603286664 , -3.56717269257e-05 , 0.00424096789908 , -0.00451303135624 , -0.00461578802849 , -0.0011822719087 , -0.00331979729025 , 0.000950014891537 , -0.00151897653469 , 0.00113914934081 , 0.000223288385643 , 0.00506778462502 , 0.00154907930843 , 0.00175461912219 , -0.00338586058086 , 2.77090806419e-05 , 0.00191192675755 , 0.00237184088267 , 0.00440106797402 , 0.00393615897914 , -0.00119850360481 , 0.000298429579747 , 0.00392014993896 , -0.00138036747215 , -0.00286299739201 , 0.00305646748638 , -0.00148074227826 , 0.0021658971797 , -0.00059900963026 , -0.0036934041062 , -0.00131722680022 , -0.0034334120835 , 0.000726672461266 , 0.00356924260308 , 0.00386850061075 , -0.00249614033749 , -0.00625053216844 , 0.00237869027739 , -6.55514241126e-05 , 0.00144686431066 , -0.00290693477237 , 0.00159740269599 , 0.00125848150257 , 0.000107234129657 , 0.00180803961494 , 0.00428202820225 , -0.00537904669314 , 0.00010075360516 , -0.00488107416899 , -0.00399173077265 , 0.0096799330467 , 0.00128717690014 , 0.000999328289592 , 0.00099265279812 , -0.000206474654062 , 0.00096132354908 , -0.00121999468759 , -0.000277715797598 , -0.000489350489261 , -0.00550747711794 , -0.00551686429964 , 3.35524381281e-05 , 0.00381230532928 , -0.00365375520002 , -0.00134541005681 , 0.00653931945461 , -0.00123751961388 , 0.00852963084643 , -0.000595625069483 , 0.00284281255334 , 0.00160195906197 , -0.00555507997351 , -0.00116005083196 , -0.000749814472965 , -0.0034404467454 , 0.000853780794134 , -0.000966107551239 , -0.00221139010216 , -0.00219621048213 , -0.004833550213 , 0.00252286214491 , -0.00103266627689 , 0.00144822645536 , 0.00318291980092 , 0.0043136854826 , -0.00215476594965 , -0.00209644035687 , -0.00505910774739 , 0.00047239710559 , -0.00316535816491 , -0.00370734983106 , -0.00124186473668 , 0.00468460264316 , 0.0015399981803 , 0.00319584875142 , -0.000523064698359 , 0.000663211907474 , -0.0032783793216 , -0.00260628349123 , 0.0014764545576 , 0.000908567814935 , 0.000342680591199 , -0.00374198934164 , -0.000281461704804 , -0.000536805123427 , 2.76339392283e-05 , -0.000333242155511 , 0.00277528508003 , 0.000344392217653 , -0.00187487106785 , 0.00374036624846 , 0.000763080993329 , -0.00233731391214 , -0.000666642885322 , -0.00144836081332 , -0.0024991759929 , 0.00141003786713 , 0.000248996970752 , -9.78146290298e-05 , -0.00236533788219 , 0.00272744780416 , -0.00472201512752 , -0.000128019331132 , -0.00117108874426 , 0.00268898810204 , -0.00180185581776 , 0.00366183799404 , -4.30388369677e-05 , 0.00181441775479 , -0.000321699312278 , -0.00105576958614 , -0.00155750665082 , 0.00152531371801 , -0.00156299966169 , 0.00441437087075 , 0.00157073869666 , -0.00164696767052 , 0.00128651119659 , 0.00117137144657 , 0.00230956276303 , 0.00123878548598 , 8.27773487279e-05 , 0.000113567698586 , 0.00252162328106 , -0.000667071609964 , 0.00459400268013 , 0.000691222292641 , 0.00271410188167 , -0.00250453618408 , 0.000536256389983 , 0.00258296238305 , 2.88323366553e-06 , -8.57030551214e-06 , -0.00199608531545 , -3.68516278639e-05 , -0.00238049692945 , 0.00112776631843 , -0.000311699080533 , -0.00401795146574 , 0.00200239429154 , -0.00735138032503 , 0.00191401435328 , -0.00214908320087 , 0.00261914821632 , -0.000175606635804 , 0.000497668655434 , 0.000652685919939 , 0.00291208391228 , -0.0015941176622 , 8.48456317477e-05 , -0.00177092133444 , 0.00303829675841 , 0.0037569923846 , 0.00307591951927 , -0.00145074855575 , 0.00279373272525 , 0.00503173772377 , -0.000106409509192 , 0.00370747750003 , -0.00116338505777 , -0.00551204651164 , -0.000480494007402 , 0.00309985216875 , -0.0011407303134 , 0.00242066351255 , -0.00435161231882 , -0.000322852797495 , 0.00272580673659 , 0.00208525325172 , 0.00403088781484 , 3.66238404796e-05 , -0.000381713212782 , 0.00795731363052 , -0.00550744162456 , -3.61556807995e-05 , 0.00297592534612 , -0.00409803746965 , 0.00336377638442 , -0.000486998185305 , 0.00313121262536 , 0.000549052296669 , 0.00468169382227 , 0.00439039682273 , -0.00359508178627 , -0.00373239040474 , 0.0021307141184 , -0.00505753914358 , -0.00459243408685 , 0.000693110141573 , -0.00238331000454 , 0.00305202461096 , -0.00055873468161 , 0.00195756515635 , -0.00289335658792 , -0.000805966484314 , -0.00401614531718 , 0.00495407175292 , -0.00222334456355 , 0.00125713053925 , -0.00694314118467 , 0.00292049732118 , 0.00327577535795 , 0.00349707151812 , -0.00149376759189 , 0.000420158554297 , -0.000500343067361 , 0.000194827795352 , 0.000829767292406 , -0.00206148384366 , -0.00294765913151 , -0.00154900540039 , -0.000515212208274 , -0.000653626552902 , 0.00347290069716 , 0.00828546967427 , -0.00035582223382 , -0.00380738205064 , -0.00129251408573 , 0.00265400570345 , 0.00222984933441 , 0.00545720354333 , 0.000662505906554 , 0.00517650574531 , 0.0038870166431 , 0.000274550362969 , 0.00353488921332 , -0.00746154420343 , 0.000302761260699 , -0.00280380771722 , -0.00298375998234 , -0.00178095614685 , 0.00197209739428 , -0.00323158183242 , -0.00260929147554 , -0.00138214023977 , 0.0012698332743 , -0.000498950251617 , 0.00270734378006 , 2.7350502917e-05 , -0.00127357419272 , 0.00140767403419 , 0.000418571162783 , -0.000221206958246 , -0.00335007666192 , 0.00343029690651 , 0.00681226525084 , -0.00175675905828 , 0.00203006880793 , 0.000268767500875 , 5.31227879171e-05 , 0.000216375811342 , -0.00320366852253 , 0.00113707962909 , -0.00245905581706 , -6.1575569576e-05 , -0.00290221812038 , 0.00429350991133 , -0.00377863022712 , -0.00263270921147 , -0.00203884995923 , 0.00163590812617 , -0.00486455591477 , -0.00124872696093 , -0.00242893296898 , -0.00110640852597 , -0.00513841600198 , -0.000984700315713 , 0.00408719941647 , 9.8529378178e-06 , 0.000196355444224 , 1.32067530723e-05 , -0.000270932477699 , 0.00124592884201 , 0.000144365111667 , -0.000472185842243 , 0.00340173876169 , 0.000789554819802 , 0.0024767355 , -0.00184855346197 , -0.00400391810166 , 0.00413405766045 , 0.000282266529776 , 0.00254749992631 , -0.00106420996274 , -0.00334014453299 , 0.000681805757744 , 0.00322587479666 , -0.000949748055533 , 0.00346485131946 , -0.00479981629675 , 0.000647428325209 , 0.00265011700821 , -0.00080575590216 , -0.00257593524188 , 0.00268129257836 , -0.00283579335137 , 0.000365712553183 , -0.0010702989151 , -0.000907637169324 , -0.000142518733381 , -0.000855269210428 , 0.00102513218604 , -0.000260445682794 , 0.00330838966165 , 0.00144598592397 , -0.00142843025175 , 0.00178129973979 , 0.00578464460578 , -0.002431730183 , 0.000343692326711 , -0.00231890228292 , 0.00384031481066 , -0.00397805484014 , 0.0062367009896 , -0.00389954712829 , -0.0036661950061 , -0.0049837782494 , 0.00165772651882 , -0.000540452865598 , -0.00438764500055 , -3.1110075663e-06 , -0.000308558970842 , 0.000343084449527 , -0.000866942743923 , -0.0107384454564 , -0.00114060678323 , 0.00364450592785 , -0.00229284364477 , -0.00292941894322 , -0.00210367153912 , -0.00355551620429 , -0.00323347660617 , -0.0039769894338 , -0.00778283714818 , -0.00195529193859 , -0.000462218856993 , -3.10401403257e-05 , -0.0029443786284 , -0.00295684652493 , -6.99231626421e-05 , 0.000696196755683 , 0.00114078745402 , -0.00329057558525 , 0.00188852095792 , 0.000181834807442 , 0.00129956679714 , -0.00158014468716 , -0.000688060162667 , 0.00166299506401 , -0.00182423005073 , 0.000274898736775 , 0.00216002337779 , 0.00173324526876 , 0.00160777280858 , -0.00103783284244 , 0.00341088465674 , 0.00425761425435 , 0.000935225620389 , 0.00463164809641 , -0.00409588819537 , -0.00463635871452 , 0.00080186860063 , 0.00219670636061 , 0.00279083309436 , -0.000857114989954 , 0.000462319276758 , -0.00375014927555 , 0.00430833020934 , -0.00357901131679 , -0.00588632985419 , 0.00415729358735 , 0.0018999636627 , 0.000685572476463 , 4.83305669682e-06 , 0.0003116364394 , -0.00495977193799 , -0.0077534803646 , -0.000620102669254 , 0.00524004577713 , -0.00462589835722 , 0.000606896750041 , -2.38732139635e-05 , -0.00121555453672 , -0.00219589150943 , 0.00085203235953 , -0.0010973263706 , -0.00307632080194 , 0.0042558263531 , 0.000315628908961 , 0.000990014992001 , 0.00259000360732 , 0.00604723521267 , -0.0024708164809 , -0.00307315215052 , -0.000455471123884 , 0.00212756316829 , 0.00187760295389 , 0.00109471948332 , -0.000378574447146 , 0.000562969834458 , -0.00723535737291 , -0.00130189087791 , -0.00103048459964 , -0.000915072044972 , -0.00311105131941 , -0.00790393881967 , -0.00109767771836 , -0.00251180612415 , -0.000263764902069 , 0.00534835381808 , 0.000425346009005 , -0.00161198671611 , 0.00411528069466 , 0.00162583369504 , -0.00478318055567 , -0.00555541969923 , -0.0014102549003 , -0.000796676464355 , 0.00128939270423 , 0.00116504641849 , 0.00532511125364 , 0.000383124980451 , -0.0029874463267 , -0.000201514935022 , 0.000131006618484 , 0.00441533271854 , -0.00265912625498 , 0.00600811424686 , -0.00286921890252 , 0.000693185259326 , -0.000610049317683 , 0.00421744499923 , -0.00495836528209 , -0.000990759482659 , 0.00348677840318 , -0.00143215449233 , -0.000858842949593 , -0.00144897476878 , -0.0128231088467 , 0.000701650951337 , -2.30829543543e-05 , -0.000416001802032 , 0.00218058619469 , 0.00384189321271 , 0.00106364719841 , 0.000510877302818 , 0.00298624605416 , 0.00177901881487 , 0.0007622089852 , 0.00384736338202 , 0.00437192499286 , 0.00409217034815 , 0.00171158292878 , -0.00245830442235 , 0.00500726333232 , 0.00160285128732 , 0.000767420654629 , 0.000162338251619 , -0.00280316199224 , -0.00423035341446 , 0.0033027089138 , 0.00118662740091 , 0.000189472884577 , -0.00151357373778 , -0.000506290879256 , 0.000492540126278 , 0.00344763082226 , 0.00294894479565 , -0.00131652407344 , 0.00199762736045 , 4.05585353052e-05 , -0.00172084812111 , 0.00231964048583 , 0.000354971239213 , -0.000961175229367 , -0.00219451646804 , -0.00308326251185 , ])
Y_4_m1_imag = flex.double( [ 0.0 , -0.0 , -0.000189977706162 , -8.68665539392e-06 , 0.00437113608381 , -0.000948361818336 , 5.77309326383e-05 , -0.000461639533729 , 0.000463046815295 , -0.00236609716111 , 0.000485834823123 , -0.00655927132234 , -0.00579315631948 , -0.00475526766488 , 0.00301388675946 , 0.00147991147478 , -0.00638894501967 , -0.00387201690246 , -0.00336647922284 , -0.00103796720389 , -0.000337531364897 , 0.00024113893579 , 0.000720923398333 , 0.000293581912442 , 0.0014809908902 , 0.00237076155689 , -0.00010121445299 , 0.00326598238658 , 0.000619014143287 , -0.00320428153518 , 0.0107392226411 , 0.00474180476017 , 1.14687400677e-05 , 0.00253180392295 , 0.00160895596515 , -0.000897670876785 , -0.000316905176705 , 0.000705808704383 , -0.00646812661524 , -0.001034878892 , -8.64902288978e-05 , 0.00108791519002 , -0.000514028905198 , 0.000238958845043 , 0.0001774933974 , -0.0019979908541 , -0.000361413438824 , -0.000629438265199 , -0.00231019699464 , 0.000110624577213 , -0.00200586300569 , 6.54636634865e-05 , -0.00515249203844 , 2.16294929416e-05 , 0.00433301411131 , -0.00377711633203 , -0.00212100220931 , 0.0022843412493 , -0.00132784087074 , 0.00037301602055 , 0.000252173058124 , -6.15052505287e-05 , 0.00451648959546 , -0.00154738789331 , 0.0043868152955 , -0.000201690398689 , 0.00163314701207 , -0.00440328450489 , 0.000989497319893 , 0.000937639357986 , 0.000759654826287 , -0.00142647047728 , 0.000174619025042 , 0.00457057484688 , -0.00462706200296 , 0.000231745524244 , -0.00194979225626 , -0.00222598016718 , -2.27779597589e-05 , -0.00246356625222 , 0.00482111269227 , -0.00122687172119 , 0.00413150572961 , -0.000758456768448 , 0.00119527437012 , 0.00224899402897 , 0.00733650224307 , 0.00224578639157 , -0.000342711510854 , -0.000218523641416 , -0.000374695924997 , 0.00804311915335 , 0.0052763807799 , 0.00284337566065 , -0.000684676193469 , 0.00310872687459 , -0.00996110591911 , 0.00140637136663 , -0.00275859170337 , -0.00114316067393 , -0.000206500231062 , -0.00247916388226 , -0.00116519859247 , -3.10619950027e-05 , 0.000424023666819 , -0.00370805063411 , 0.00312536453677 , -0.00192933670923 , 0.00346989843692 , 0.00383535661425 , 0.00496222231844 , 0.0016005147766 , -0.00102999172165 , 0.0105050412444 , -0.00307704333792 , 0.000813521428393 , 0.000486204248966 , 0.000934243704993 , -0.000795110501383 , 0.000666200004536 , 1.82873873175e-05 , -0.0016824631449 , -0.00984463595247 , -0.000247736164944 , 0.00105742727934 , -0.00165211425857 , 0.0014059132302 , -0.00411810127554 , -0.00259401829149 , -0.000168303224956 , 0.00211255752348 , -0.00078569826984 , 0.000829261527827 , 0.000803999672191 , -0.00653042340644 , 0.00111116648708 , -0.00258768023671 , 0.0014478628522 , -0.000655446448024 , 0.00139712751212 , 0.00745503123535 , -0.00217006762735 , 0.00129843147107 , 0.00426925639967 , 1.65832248575e-05 , -0.00011413934819 , -0.00157245077242 , -0.00178869431408 , -0.00158724308776 , -0.00049186931525 , -0.00964959512436 , -0.00144013590353 , 0.00522314678272 , -0.00246636716408 , 0.00157304649003 , -0.0022649576801 , -0.000520778518114 , -0.000148516860646 , 0.0027169490364 , -0.00335082651448 , -0.00304881257551 , 0.00504675981422 , -0.000536040807974 , 0.000151032883002 , 0.00014959710023 , -0.00363451395362 , -0.000723554105665 , 0.00243741922983 , -0.00493866557363 , 0.00170981286459 , 0.00037341533244 , 1.07575219126e-05 , 0.00240479441631 , 0.0019734228515 , -0.00476001801342 , 0.000683691159496 , 0.00676685493702 , -4.89443115399e-05 , -0.0015735947044 , -0.00615635852901 , 0.000385895463319 , 0.00300765151365 , -0.00567617421448 , 0.000408842471409 , -1.28006506792e-05 , -0.0020458103351 , 0.00103166474837 , -0.00239178034228 , 0.00485480522844 , -0.00735802677035 , 0.00213319425991 , -0.00159505652511 , 0.000164420851157 , 0.00039727607826 , -0.00102900767844 , -0.00134169808487 , 0.000960634423037 , -0.00229091885964 , 0.00185490974669 , 0.000683569932022 , 0.00525146282375 , -0.00113903705886 , 0.00101992995249 , -0.00473899279749 , 0.00149137410897 , 0.00387731272553 , -0.00310919142338 , 0.00165324250602 , -0.00417892495763 , 0.000121362148893 , -0.00099813449247 , 0.0059482853676 , -0.000877920738641 , -0.0011373463809 , 0.00192407829916 , 0.00483021433459 , 0.00137022492448 , 0.000966398218546 , -0.00200357801944 , 0.000196274364391 , -0.00120579557502 , 0.00135706601917 , 0.00036119322401 , 0.0014021327032 , 0.00429843609288 , -0.00353842791812 , 0.000608244993715 , -0.00352509541887 , 0.00203309057089 , -0.00174318758333 , 0.000511571412611 , 0.00497318236189 , -0.00163258400634 , 0.00251212839772 , 5.42681444012e-05 , 0.00235723069949 , -0.00302950597119 , 0.0017034465593 , -0.00014061705847 , 0.0021292500022 , 0.00321634123194 , 0.000595943180811 , -0.0040733338814 , 0.00102543721386 , 0.00260265844765 , 0.00544831812742 , -0.0037618227233 , 0.000521396719116 , -0.00456272362577 , -0.00124779799863 , 1.37612918326e-05 , 0.00225556428631 , -0.00491707302282 , -0.00182197339008 , -0.00277237564215 , -0.000276019218455 , 7.06404890704e-05 , 0.000510436392142 , -0.00078498457143 , 0.000303577347995 , -0.00331567337059 , 0.00181846848022 , -0.00305889549862 , -0.00448749478505 , 0.000734121190328 , 0.00340735845857 , 0.000592443570485 , -0.00210213571988 , -0.0033719570817 , 0.00379814312412 , 0.000619142111852 , 0.00172229898996 , 0.00131945440147 , 0.000154164769849 , -0.00109933580576 , -0.00149704543365 , -0.000773836325637 , -0.00267809327811 , -0.000621696665013 , -0.00275288053676 , -0.00425872517698 , -0.00189023736663 , 0.000718625716498 , 0.000646892326264 , 0.00228800386276 , -0.00210274643934 , -0.00118777888812 , -0.000470985487963 , 0.00432598099704 , -0.00121475092217 , 0.00238135635158 , 0.000740166787975 , -0.000542043398405 , 0.00559832274869 , 0.0057892094715 , 0.000711848535288 , 0.00235579795845 , 0.00177438283148 , -0.000894762333538 , 7.88670980771e-05 , -0.00431173090889 , 0.00125691909132 , 7.23481238727e-05 , 0.0054347397823 , 0.00295128787994 , 0.000375006336854 , -0.00091748936618 , -0.00330165135581 , -0.00151874865616 , -0.00221477806248 , 0.00638711415384 , 0.00270133949355 , -0.00136253052155 , -0.00291634650217 , 0.00299213067049 , -0.00363396843947 , 0.00106563078028 , -0.00298710338042 , -0.00187156401922 , -0.00313422813032 , -0.00538055026664 , -0.00687813548337 , 0.00143711125731 , -0.00135450339468 , -0.00211674636907 , -0.00156972783236 , -0.00110327455195 , 0.00190466157019 , -0.00255190447197 , 0.00030849978254 , -0.00199379419268 , 0.00236375126605 , 0.00125285335579 , -0.00481011476548 , -0.00430287973786 , -0.00186038763214 , -0.00403769803784 , -0.00506200060596 , 0.00168443015427 , 0.00138212699761 , -0.000746760901522 , 0.00697124984185 , -0.00450900828293 , 0.000206159508405 , -0.000894059983904 , 0.000300387188122 , -0.00435465854825 , 0.011085350451 , 0.00534716422281 , -0.00595350458352 , -0.000406161926394 , 0.00483373194137 , 0.00248015988688 , -0.00144682684196 , 0.00431529462666 , -0.000623423133915 , 0.00285037903763 , -0.00549918804899 , -0.00220110701904 , -0.00332448162662 , -0.00460373636307 , 0.00250218954847 , -0.00187325425284 , -0.000654188637699 , 0.000695691973531 , -0.000137337083929 , 0.00169960544775 , 0.000667335819252 , -0.000414971032231 , 0.00293586575895 , -0.00127203616284 , -0.00301805770872 , 0.000648337822017 , 0.00375883683781 , 0.0014504835947 , 0.00536448816228 , 0.00335446262561 , 0.00125992428603 , -0.00147400374757 , 0.000196895854043 , 0.000379813056243 , -0.00363571298688 , -0.00246570421879 , 0.00204715802585 , -0.00083529448978 , 0.00470051058391 , -0.00293833488852 , 0.000410983395715 , 0.00133792972903 , 0.00278775105149 , -0.00452712779117 , 0.00390003995399 , -0.000112066509627 , -0.000834846097248 , 0.0089241150626 , 0.00283584670197 , 0.00700381037046 , -0.0052689511366 , -0.00125106334253 , -0.00404086186145 , -0.000673004405226 , 0.00278746262982 , -1.32236046221e-05 , 0.000767109475896 , -0.000593433740349 , 0.00252856542814 , 0.0013472445055 , 0.00246144221913 , -0.000907256532227 , 0.000717465836655 , -0.000899580291228 , -0.00450987240684 , -0.00454393074342 , 0.00520230955983 , 0.00644789811322 , -6.09909153053e-06 , 0.00166945792529 , -0.00102722400227 , -2.36483820716e-05 , 0.000220221103899 , -0.00148085864855 , -0.00425905871972 , 0.00389273396283 , -0.0036356090762 , 0.00640135263451 , -0.000104156681471 , -0.00140429170168 , -0.00195194591131 , 0.00434961984596 , -0.00607260061665 , 0.00224366662017 , -0.000201284072825 , 0.00225661752626 , -0.00352253413774 , -0.00426684813887 , -0.0069950984921 , -0.00123199158069 , -0.00123164723304 , -0.00107836585836 , 0.00179897989231 , 0.00062533774129 , -1.06731356344e-05 , 0.000334242875652 , 0.00297379698326 , 0.00627630132649 , 0.00582399906844 , -0.000991466739286 , -0.00288578471094 , -0.00133568408197 , 0.000221645378117 , -0.000116734725182 , -0.00140879008249 , -0.000903351447154 , -0.00136136854835 , 0.00078596739527 , -0.00504095688036 , -0.000896440979951 , -0.00028957805659 , -0.0026249746549 , 0.000538020585327 , 0.000295290828212 , 0.000713128168666 , -0.00335995629598 , 0.00331198973863 , 0.00273052846298 , -0.00234209359262 , 5.00891660631e-05 , -0.000270192983161 , 0.00333093475878 , -0.00658256631277 , 0.00165043564405 , -0.00034679153785 , -0.000138544861236 , 0.00347017569127 , -0.000285740596864 , 0.0010291727982 , 0.00169172366534 , -0.00195356024574 , 0.000190453357424 , 0.00151616987903 , 0.00206346691004 , -0.000244291300225 , -0.00233917206583 , -0.00203909498622 , -0.00121864667603 , -0.000265194439926 , -0.00107187681453 , 0.00192032857016 , 0.00298072807066 , 0.0017402772271 , -0.0020970913749 , 0.00222019607934 , -0.000764224296907 , 0.00292022650413 , 0.00208818138146 , -0.00336679627229 , -0.00212791061395 , 0.00332530827457 , 0.00232459437937 , 0.00196767177579 , -0.00307304885222 , -0.00492420222276 , 0.00161987540009 , 0.00468366602861 , 0.00344291162211 , -0.00012658050769 , -0.00224462220838 , -0.00236335142199 , -0.000178096731358 , -0.00301490600498 , 0.00330783405823 , -0.000164981768269 , 6.85133887434e-05 , -0.000646391116155 , 0.00321122333349 , -0.00356521496651 , -0.00122017825146 , 0.00228872325391 , 0.000771921050399 , -0.00292930700448 , 0.000723931688116 , 0.000342190737571 , -0.00286428299853 , -0.00269499505227 , -0.00254945455851 , 0.000499797479257 , 0.000840173535397 , 0.00140299157714 , 0.000929369610988 , -0.000227893871413 , 0.00108343083883 , -0.000672643863645 , -0.003534160055 , 0.000158639418067 , 0.00350329082707 , -0.00158032194272 , -0.00114855242926 , 0.0043991910601 , 0.00254201131772 , -0.000338043521068 , 0.00285246965877 , -0.0020928472361 , 0.00416873405845 , 0.00410106571154 , 0.00135855685234 , -4.65200174469e-05 , -0.00600708965545 , 0.000861914067794 , 0.000517509593232 , -0.00236118327567 , -0.000804160643772 , -0.000913548708744 , 0.00367971861677 , 0.00123288256755 , 3.83789689618e-07 , -0.000627580429978 , 0.000670068132435 , -0.000104246087647 , 0.00214310880518 , 0.000344594128397 , 0.000317499071181 , 0.000473956032826 , -0.000172976200317 , -0.00257388989282 , -0.00370072070639 , 0.00054090070303 , 0.00302879661013 , 0.00038167042761 , -0.00348700279057 , -0.000361924976844 , -0.00391252795489 , -0.000425945645873 , -0.000200894179854 , -0.00088540901431 , 0.00111331260468 , -0.000784830566782 , -0.00399262897083 , -0.00229481973675 , 0.00164765101921 , -0.00643582864118 , 0.00192502430977 , 0.00953476755202 , -0.00120820115306 , 0.00188644806153 , 0.00200346412035 , -0.00476362162246 , 0.0025410214008 , -0.00103656609199 , 0.00491129793665 , 0.00280011495385 , 0.00035664636198 , 0.00449296774123 , -4.15178941911e-05 , 0.000123156637815 , 0.00246846337079 , -0.000652264444218 , 0.00102171300655 , -0.000211193996207 , 5.5457340979e-05 , -0.00539669063555 , -0.00347950217607 , 0.00429390120091 , -0.00403465773473 , 0.000650797760532 , 0.000299761156379 , 0.0023282809992 , -0.00350137668307 , -0.00317736126094 , -0.00174083225822 , -0.00606592302192 , -0.00339764822659 , -0.00114544497275 , -2.59532673889e-05 , 0.00249473238036 , 0.000644699903232 , -0.00428325555192 , 0.00420589572778 , 0.00523790117478 , -0.00163806738672 , -0.00330930687928 , 0.00272751781755 , -0.000389424496044 , -0.00827783345151 , 0.00256060505567 , -0.0037299641964 , 0.00386798226885 , -0.00172840242987 , -0.00142131524041 , -0.00488823840392 , 0.0029768090126 , -0.00262772906386 , 0.00144893864924 , -0.00354155947551 , 0.000222000598384 , -0.00109417188653 , -0.00175136510498 , -0.00272279967275 , -0.00192741524906 , 0.0041502162431 , 0.00383436143403 , -0.00143212632526 , -0.00260293769276 , 0.000358623706568 , 0.00152697408395 , 0.00220874972574 , 0.00387559329814 , 0.00167861845111 , -0.000965247422068 , -0.00216668121857 , 0.00276263558725 , -0.00104784325072 , -0.00106826685526 , 0.0039745770726 , 0.000919234418147 , -0.000912824464067 , -0.00842298948522 , 0.00207090260093 , -0.00187711928748 , 0.00528669535617 , 0.0044927188777 , -0.00392615455386 , 0.000159394239958 , -0.000907889823576 , -0.00168867395175 , 0.000703970288865 , 0.00170208345892 , -0.0019061043027 , -0.00513109974968 , 0.00288494995784 , -0.00191978622262 , 0.00181733826093 , -1.52971881768e-05 , -0.00118539211776 , -0.00269610132992 , 0.000975388127163 , 0.00372422285976 , -0.00189658544984 , -0.00595175884926 , -0.00214245992566 , -0.00028035727117 , -0.00148585636761 , 0.00329504253434 , 0.00209224825996 , 0.000814833942205 , -0.00298748684147 , 0.00386825420901 , -0.0013689403794 , -0.00434227055069 , 0.00292723200931 , -0.00185886301826 , -0.00259970052734 , 5.98383363378e-05 , 0.00107011341476 , 0.00125028991205 , -9.45688994367e-05 , -0.000430067761754 , -0.00342982473961 , -0.00358699961397 , -0.00465907892238 , -0.00347887242502 , 0.00058215576786 , -0.00470658639774 , 0.00114094986263 , -0.00134174254019 , 2.42675505517e-05 , 0.000903442536047 , 0.000550279105469 , -0.00551756397699 , -0.00155171002385 , 0.0043393950239 , -0.00134701726481 , 0.00227563765508 , 0.00168070514793 , -0.00373431257829 , 0.000678762269818 , 0.00022306126048 , -0.00170834540808 , 0.0054404438536 , -0.00157430492627 , 0.000293346871585 , 0.00146974617836 , 0.0034861222993 , 0.00436084159276 , 0.00423083198049 , -0.000763110436238 , -0.00123504932799 , -0.00202118233277 , -0.00363822589879 , -0.00143797265463 , 0.000795010189034 , -0.00384653085183 , 0.00308319220593 , -0.000110842995001 , 0.00301034047328 , -0.000564475987491 , -0.00135966438817 , -0.00375173732845 , -0.00193012647161 , -0.00429178288481 , 0.00393895531632 , 0.00341254616832 , 0.00145146219017 , -0.000508330265114 , 1.41065805059e-05 , 0.0089452214737 , 0.000670492995609 , -0.00102044726908 , 0.00682696042235 , 0.00207173571858 , -0.00128767578877 , 0.000331063155905 , 0.00125555614396 , 0.00210195952457 , 0.00272052104123 , -0.000889399376722 , 0.00353011998257 , -0.000298835656079 , 0.00337243156659 , -0.0012681158436 , -0.000934553030323 , 0.00536454508498 , 0.00488911246817 , -0.000375232449332 , -0.0026916025426 , 0.00328750662216 , 0.0015938156142 , 0.0032092359316 , -0.00144869469342 , -0.00509610607005 , -0.00150919442313 , 0.00168669303473 , 0.00242740429722 , 0.000808466714067 , -0.00649586564995 , -0.00587283601105 , -0.00025352854742 , 0.000809920587927 , 0.00200617392845 , 0.00402211745883 , 4.19106889284e-05 , 0.00400950795433 , 0.00228359438011 , -0.00548823263122 , -0.000894191059562 , 0.00205032309342 , -0.000598376674559 , -0.00338171611111 , -0.000211642571731 , -0.000699019903828 , -9.86626568692e-06 , -0.000160912733762 , -0.00266572316851 , 0.00164877149296 , -0.00402135524816 , 0.00308403441256 , -0.000448574112645 , -3.08077302218e-06 , 9.28359957391e-05 , -0.0024315034994 , -0.00447265375714 , -0.00203324667392 , 0.00114802985954 , 0.00275648206648 , 0.00064747457465 , 9.0572475672e-06 , 0.00681149307665 , 0.000887522711643 , 4.07098093425e-06 , -0.00238634298799 , 0.00244092621808 , 0.00157460741225 , 0.000777140701674 , 0.000484033037624 , -0.0056960990425 , 0.00419018739591 , 0.00288017734684 , 0.00151150123956 , 0.000283399559261 , 0.0043883271274 , 0.00102268242885 , 0.000389224706153 , -0.000383754603734 , 0.000612022102429 , -0.00532054769891 , -0.000708691385087 , 0.000116336320217 , 0.0059703456277 , 0.00674222971178 , -0.0015692823236 , 0.00239446232917 , -0.00181248776976 , 0.000100828465931 , 0.0015593416042 , -0.00214641888993 , 0.00111507384845 , 0.00206877364041 , -0.0031188253597 , 0.00029915518005 , 0.00282195397006 , -0.00509869924899 , -0.00451648302314 , -0.000801846034234 , 0.00391596631991 , 0.00352070338528 , 0.00265731552375 , -3.84848344032e-05 , -0.00434401800319 , 0.00450467554355 , -0.00262887547467 , 0.00172645860101 , 0.00111083726554 , 0.0024593596564 , -0.000528372818305 , 0.000559761030796 , 0.00357820412972 , -0.000796688369259 , 1.21286051829e-05 , 0.00428728970798 , 0.00396418080009 , -0.000163191681081 , 0.00130641115804 , 0.000387668931296 , 0.00157521844272 , 3.15073087882e-05 , -0.0036799663745 , -0.00168533605048 , 0.0015867312219 , -0.00125996788229 , -5.85971569927e-05 , -0.00133631359431 , -0.0038250069235 , 0.00124266195284 , -0.000706574884479 , 0.00336528963583 , 0.000965481215559 , -0.00123759827937 , -0.00318369575768 , 1.10705457897e-05 , 0.00463824002073 , -6.49553115531e-05 , 0.000220371179408 , -0.00467747290227 , -0.00506808960358 , 0.00120771271284 , 0.000770460339849 , -5.25755603189e-05 , 0.00182427398868 , -0.000283464532686 , -0.000615046514166 , -0.00298312247312 , -0.00132968326655 , -0.00134828641154 , 0.00178888001992 , 0.00013372313591 , -0.00371982387854 , -0.000508401707683 , 0.0033644377686 , -0.0059498971718 , 0.00654519041869 , -0.000260845482472 , ])
Y_4_0_real = flex.double( [ 0.00886397749175 , 0.00532593754064 , 0.00443306086963 , 0.00536581635643 , 0.000306889976242 , -0.00560440502011 , 0.00460508559721 , 0.00168199857675 , -0.0061462683294 , 0.00480379911666 , -0.00341421186262 , 0.00362191834334 , 0.00218651886155 , -0.00111194950404 , 0.0028736623298 , 0.0014755722996 , -0.00245466974 , 0.00534504737072 , 0.00229445271169 , 0.00745846262704 , 0.00404402058253 , 0.00340675348331 , 0.00365903085987 , -0.00417123827793 , 0.00470138951969 , -0.00398298784868 , -0.00436194882352 , 0.00102007835153 , -0.00542757726634 , 0.00963684995994 , 0.0123973647026 , -0.00210355297292 , 0.00531087397369 , -0.00270102191053 , 0.00288993817468 , -0.000594050674384 , 0.00348400153348 , 0.000322653242715 , -0.00513389136672 , 0.00130831228201 , 0.00390668256507 , -0.000756337151549 , -0.00330697223001 , -0.00381345435231 , -0.00136443431847 , -0.0010832471107 , -0.0022856960074 , 0.00165762070307 , -0.000884838901908 , -0.00274456298799 , 0.00225137281719 , -0.00447526142431 , -0.00123820560004 , 0.00529658332384 , -0.00166670487056 , -0.000344873591033 , 0.00303597068628 , 0.00407154814081 , -0.00278750260908 , 0.00513350687279 , 0.00472557010277 , 0.00490113616117 , 0.00469278646792 , -0.0026125430534 , -0.00409269848622 , 0.00306500461612 , 0.000138210496898 , 0.00216033822342 , -0.00147145024153 , 0.00103203866269 , -0.00293454080942 , 0.00259580982082 , 0.00458122421466 , -0.00209898588313 , 0.008237825208 , -0.00483764992409 , -0.000130177852417 , -2.89715652088e-05 , -0.000697948619597 , -0.00207171533189 , 9.03322942688e-05 , -0.00521341918535 , -0.00117563030987 , -0.000668379285428 , 0.0047056274299 , -0.00080742857708 , 0.0102354364081 , 0.00104050838113 , 0.00126840489993 , -0.00491947300363 , -0.00483755890897 , 0.00321535179345 , -0.00456318975691 , -0.00291805145056 , -0.00384054686154 , -0.00232652101442 , 0.00974810961007 , 0.0035124613288 , -0.00117681484766 , -0.00417028920162 , -0.00344803461571 , -0.000417661880121 , -0.00357174968162 , 0.00350056583776 , 0.00407899745133 , -0.00359821512455 , 0.00132260946456 , 0.00365619041103 , -0.0050919405375 , 0.00908935906577 , 0.00430853954273 , -0.000660104290604 , 0.00409247699492 , 0.0145547439943 , 0.00635268091662 , -0.00323682586002 , -0.00179124864534 , -0.0024980585883 , -0.00317569400595 , -0.00430290935201 , -0.00353193861025 , 0.00314219945258 , -0.000761727602248 , -0.00258013493782 , -0.00458889100499 , 0.00310425418376 , 0.00342718378385 , 0.00455921441909 , 0.00422200981168 , -0.00118910407433 , -0.00523347072616 , -0.000979484481215 , 0.00313764703007 , 0.00309636905857 , 0.00404019126568 , -0.00254637313832 , 0.00296699058626 , 0.00279924877729 , -0.00298983156753 , -0.00340178842371 , -0.000785862696639 , 0.00417889805272 , -0.00309627081171 , -3.22774320499e-05 , 0.00573956558107 , -0.00384484280144 , 0.000284448345512 , 0.00201929986175 , -0.00106595715057 , -0.00255318591436 , 0.00312914794601 , 0.00275471409066 , -0.00445625693527 , 0.00222641517602 , 0.0024517259123 , -0.00214751840871 , 0.0019070684766 , -0.00484351615012 , 0.00308587851042 , 0.000272745287078 , -0.00334218267484 , 0.00877664132508 , 0.00759551957337 , 0.00546520073807 , 0.00426184940527 , -0.0037112249185 , 0.00591204123457 , 0.00303619193473 , -0.00180113738262 , 0.0017472355789 , -0.00455736985053 , -9.90791198653e-07 , -0.00308418909613 , -0.00119389345504 , 0.000547293194541 , -0.000754886096414 , 4.16341909326e-05 , -0.00564937111413 , -0.00100834652514 , 0.00257785665254 , 0.00315073012673 , -0.00190363153676 , -0.000108730053196 , -0.00362910114196 , 0.00349183120887 , 0.00356733439028 , -0.00284794311606 , -0.00522468723763 , 0.00310607563725 , 0.0114961306422 , -0.00343139602683 , 0.0018221658899 , -0.00132134017602 , 0.000707869686065 , -0.00562795764055 , -0.00433698229576 , 0.00146462666615 , -0.00311424746458 , -0.0038464521878 , 0.0029797665428 , 0.000123237281825 , -0.00491915723688 , -0.00449346115951 , 0.000533158429885 , 0.0019392577025 , 0.00325577414964 , -0.000817208755544 , -0.00315709831391 , 0.0023329484104 , -0.00653411826804 , -0.00445381075182 , 0.000631166030078 , 0.000476452358813 , -0.0016191240314 , -0.00239584901982 , -3.00995896808e-05 , -0.000530985498446 , -0.00422050542242 , -0.00247913608752 , -0.00532784626597 , 0.00294413708242 , -0.00437480609134 , -0.00711867683389 , 0.00371471865861 , -0.00161688411691 , -0.000385904998684 , -0.00037576404226 , -0.00406347142959 , 0.00547225233742 , -0.00266198457521 , -0.00209211236715 , -0.00560292006499 , 0.00461868167695 , -0.0020501866117 , 0.0041713346814 , 0.00420236014707 , -0.00216663613171 , -0.00458225766691 , -0.00134461233123 , 0.00400975210726 , 0.000888717252765 , 0.0041174602954 , -0.00508160547506 , -0.00328921476782 , -0.000904010655165 , -0.00111060908694 , 0.00266444879544 , -0.0062282601858 , 0.00296059288823 , 0.00399743648829 , -0.00124399869973 , 0.000136952447914 , 0.00336239750472 , 0.00153813245522 , -0.000438522495943 , 0.00179244349948 , 0.00435884771531 , 0.00321610806951 , 0.000648963863439 , -0.00446928734504 , -0.00255274922371 , -0.000490072795687 , -0.00161952268502 , -0.00110344354828 , -0.00267789200288 , -0.0028974307052 , -0.00663354686829 , -0.00172529970929 , -0.00472836431261 , 0.000194713659502 , 0.00285608721276 , -9.28473044143e-06 , -0.00352626804145 , 0.000318128112183 , -0.00724989385321 , 0.00181277387369 , 0.00545581155671 , 0.000905213447064 , -0.00495077121632 , 0.000829662243103 , -0.00445470885508 , -0.00528491963041 , 0.00254617273476 , -0.00505838693638 , 0.00445988452676 , -0.00607857527713 , -0.00640338152223 , 0.00332222054674 , -0.00645808613673 , 0.0010865233129 , 0.0017720619165 , -0.00394878069609 , 0.00453256118223 , 0.000316336510106 , 0.00132512426325 , 0.00338929976868 , -0.00669973430459 , 0.00420238707534 , -0.00433401314452 , 0.00230351244897 , 0.00390599422579 , 0.00234857800171 , -0.0034310082011 , 0.0031286291332 , -0.00252863455931 , -0.00606556020772 , -0.00410452992844 , -0.000758967823274 , -0.00164642580498 , 0.00420485525284 , -0.00102884274731 , 0.00214538880794 , 0.00107737352286 , 0.00217806556952 , 0.00522698729953 , -0.00160606005956 , -0.00579011587173 , -0.00104170764039 , -0.0040211296564 , -0.00127279840888 , -0.00233674319463 , 0.00816786016751 , -0.00775337743649 , 0.0033261486835 , 0.000635337422127 , 0.00290340205459 , 0.00342460813018 , 0.00113107422223 , -0.00392662844336 , -0.00705265156503 , 0.0123958084374 , -0.00176242919574 , -0.0047444406496 , 0.0037534499601 , 5.93470398521e-05 , 0.00627854367132 , -0.00112338384114 , -0.00198360180326 , 0.0053445794466 , -0.00371266149036 , 0.00398384188557 , 0.00634490183639 , -0.00321440273158 , 0.00401350248663 , -0.00174313648107 , -0.000239472661205 , -0.00230503371784 , 0.00335451190391 , -0.00297452776011 , -0.00296921392066 , 0.00121090753409 , -0.00270165838655 , -0.00117173206943 , -0.00400647507105 , 0.000848575242806 , 0.00415177964643 , -0.00398128730374 , 0.000557290787973 , -0.00463484662686 , -0.00848355242536 , 0.00331266185294 , 0.0163234799695 , 0.00651876343999 , 0.00256906002733 , 0.00361013715538 , -0.00656875329467 , 0.00332587096233 , 0.00116587166661 , -0.00408466965322 , -0.00582742505106 , -0.00160977029119 , -0.0055395816555 , 4.9657320368e-05 , 0.00321341587734 , 0.000245466939412 , -0.0018709592929 , -0.000203584906511 , -0.00637653421512 , -0.00364086371183 , -0.00548230466722 , 0.00244714234296 , 0.00237846992111 , -0.000324513127087 , -0.00282622547698 , -0.00689462282933 , 0.00512674362955 , -0.00553168276455 , -0.00577275826934 , -0.00469714384592 , 0.00467315067678 , 0.000308635360565 , -0.00408095538695 , -0.00594844124171 , 0.00388218215173 , -0.000593740882085 , 0.0011926818416 , -0.00351912229685 , -0.00148096547861 , 0.00295202319979 , 0.00152562404861 , -0.00224026757109 , 0.00231705001118 , 0.00279520710946 , -0.00493471442983 , -0.00627957578451 , -0.00320132726364 , 0.0069666874149 , 0.00112815428072 , -0.00296096293116 , 0.000975515197176 , 0.00345275592155 , 0.000906135221696 , -0.00201618723421 , 0.00323668633083 , 0.0021507336696 , -0.00582339461722 , -0.00504678102651 , 0.00361771844945 , 0.00359631136667 , 0.0032914576781 , -0.00474150609304 , -0.00316045155661 , 0.000905440643163 , -0.00136982000761 , -0.00321835187092 , -0.00232202023346 , -0.00611880477946 , -0.00204975192558 , -0.0039041222154 , -0.00261878611235 , 0.00094118736865 , 0.00347715598775 , -0.00155796309371 , 0.00327289452767 , -0.00213900297464 , 0.000841793971628 , 0.00242911718407 , 0.00879566250277 , 0.00464629742235 , 0.00432102079616 , -0.00570145914991 , -0.00479927268659 , -0.00330900687759 , 0.00286089478678 , -0.00320776244674 , 0.00392478404104 , -0.00309303211439 , 0.000737135840668 , -0.00223259843067 , -0.000518829086538 , -0.00346904282975 , 0.00109818174126 , -0.00354945063831 , 0.00758604371388 , -0.00312493138534 , -0.00243986936188 , -0.0073197757403 , -0.00565438019685 , 0.00200733024081 , -0.00527595816316 , 0.00436071732837 , 0.00370314342756 , -0.0033222064832 , -0.00197415815702 , 0.00260018291044 , -0.00255374815968 , -0.00431229185311 , 0.00455097713915 , 0.00312677322403 , 0.000155722748275 , 0.000616293104865 , -0.00508532212643 , -0.00510920120501 , 0.00372193885954 , -1.85357141516e-05 , -0.00517557504523 , 0.00320568144709 , -0.00501074234112 , 0.00574034105637 , 0.00353755487995 , -0.00401732436822 , -0.00414521922092 , -0.000193449592367 , -0.00393087996981 , 0.00237247443661 , -0.00407741489849 , -0.00545973866865 , 0.00125315612379 , 0.00222669545851 , 0.0045805066378 , -0.000588588278226 , 0.00441543934759 , -0.00520746684733 , -0.00381516303379 , -0.00162791564329 , -0.00449362694003 , -0.00209415328344 , -0.00135398377983 , 0.0014970274209 , 0.00325228572117 , -0.00323387132813 , -0.000967646178755 , -0.00419936559342 , 0.000873947173686 , -0.00105571076159 , -0.000800926694912 , -0.00378944132909 , 0.00148723802656 , -0.00414157211694 , -0.0041462864465 , -0.00413838726673 , 0.00551330769049 , -0.00586666325029 , -0.00303578088389 , -0.00387424484791 , 0.00405551016253 , -0.00486849171747 , 0.00264097675204 , -0.00546979494481 , 0.00473992614593 , -0.00520547826459 , 0.0065043826615 , -0.00252414898875 , 0.000205341523601 , 0.00611652694447 , -0.00184500709731 , -0.00543136238988 , -0.00266615058372 , 0.00515592974997 , 0.00560041948183 , -0.00143363837965 , -0.00149803118096 , 0.00159075665992 , 0.00320241424378 , 0.000236331763061 , -0.00462521601562 , 0.00108974240479 , 0.0028709874485 , 0.001926323084 , 0.00393304112045 , -0.00328468695042 , 0.00116305921455 , 0.000236405011297 , 0.00235536142622 , -0.00260433414728 , 0.00438585746061 , 0.00427094971581 , 0.0123371070054 , 0.0008808058015 , 0.00492050073035 , -0.00433008751389 , -0.00479918783175 , 0.00236234224007 , 0.0110901708028 , -0.0051501735366 , -0.00587769767939 , 0.000272988249808 , -0.00560372089923 , -0.00224532255682 , -0.00541309120135 , -0.00116912535992 , 0.00336494347073 , 0.00286632885983 , 0.0129346635807 , 0.00333053539264 , -0.00505349904995 , -0.00373153808575 , -0.00415025363476 , -0.00328875265979 , 0.00339983162759 , 0.00203580594233 , -0.00467831479234 , 0.00384878093676 , 0.00337653764466 , -0.00492921200787 , 0.00184671766134 , -0.00296637630087 , 1.75373593617e-05 , -0.000458546278863 , 0.00256272500324 , -0.00462799898168 , 0.00252188522215 , 0.00552091529627 , -0.000447266804783 , 0.00291707340482 , -0.000444559968954 , -0.00714388728762 , -0.00162824579593 , 0.0027352173939 , -0.00228556073884 , 0.00264702357812 , -0.00441437859767 , 2.31497098202e-05 , 0.0040968255847 , 0.00454783592284 , 0.00381002687204 , -0.00157393598484 , 0.00290023740861 , 0.00222182659539 , 0.00203802837325 , -0.00256924764773 , 0.00496940699195 , -0.000819632170909 , 0.00405501181798 , -0.00255121581553 , -0.00412096661003 , -0.00463668823798 , -0.000107997561966 , -0.00270776604252 , 0.00566721643995 , -0.000264810199491 , 0.003574202538 , -0.00540730884589 , 0.00224558472132 , -0.00352863107557 , 0.000650234713426 , 0.00123374400236 , 0.00456874949323 , -0.0032932532049 , 0.00133430812227 , -0.00551493353282 , 0.00295629073662 , 0.00187275832946 , -0.0052891869301 , 0.00444521476414 , -0.00135052763795 , 0.00229885105089 , -0.00176925405926 , 0.000422521249886 , 0.00865167300282 , 0.000179639953239 , 0.00369920479768 , 0.000729710931384 , -0.00160905743566 , -0.00621108227843 , 0.00381216456023 , 0.00152379247323 , -0.00154262299393 , 0.0027800807802 , 0.000653882027403 , 0.00649770565749 , 0.0028693906628 , -0.00332634367484 , 0.00931091569567 , -0.00480056714886 , 0.000652808157754 , -0.00111811217419 , -0.00711972603003 , 0.000130425239405 , 0.00594463967729 , -0.00496824248476 , -0.00340652369757 , -0.00387916124231 , 0.00323960984852 , -0.00437300846182 , 0.00480706104704 , 0.00183482583232 , -0.00280892748383 , 0.00066444310253 , -0.00515225098983 , 0.00876525035976 , -0.00130119945523 , -0.00290268778988 , 0.00421915320864 , -0.00259363296307 , -0.000414991660623 , 0.00339867729413 , 0.00550917139087 , 0.00803733840611 , -0.00350332006475 , -0.00337080950793 , 0.00513540160324 , -0.00243470133451 , -0.00381943720457 , -0.00503002883114 , 0.00222341258964 , -0.00483381001416 , -0.00454487426384 , 0.0016586774446 , -0.0014268603795 , 0.00288415342573 , -0.0045337752662 , -0.00131421048093 , 0.00214255623643 , -0.000141248984721 , -0.00345048553615 , -0.00110126894869 , -0.00458184391765 , -0.00155251138912 , 0.00254196170446 , -0.00352835248971 , 0.00310487955275 , -0.000578055712627 , -0.0084513057875 , -0.003970001431 , 0.00361535274076 , -0.00402692448018 , 0.00517417754859 , -0.00135104553609 , 0.00240191762526 , 0.00298716338035 , 0.000825285898003 , 0.001907159547 , 0.000392440010526 , -0.00532070229909 , -0.0024720673514 , -0.00145915554688 , -0.00639601587255 , 0.00378713900086 , -0.00512742553727 , 0.00315082826567 , 0.000546483056959 , 0.00242109236823 , 0.000638566840302 , 0.00393448446872 , 0.00547948887046 , 0.00437508351401 , -0.00297776218887 , -0.00464567713924 , -0.00561574686973 , -0.00424528194119 , -0.00241149660869 , -0.00105350621611 , -0.000589210423821 , -0.00312822115951 , -0.00542863204961 , 0.00264697842312 , 0.00220533724557 , 0.00855440095512 , -0.00470190575548 , 0.00791188883629 , 0.00167611953184 , -0.00343080175614 , -0.000549117170406 , -0.00370299741682 , -0.00195794762759 , 3.9725595871e-05 , -0.00209661314534 , 0.0189914444397 , -0.00548127905885 , -0.00454297499101 , 0.00280844645626 , -0.00254774661666 , 0.00344258549945 , 0.00288505598979 , -0.0034541435329 , -0.000509121514499 , 0.0038706617637 , -0.00248547476844 , 0.0013194082513 , -0.00286074514302 , -0.00276499976938 , 0.00249232888058 , 0.0122567424749 , -0.00122597302467 , 0.00647612648161 , -0.00408004382824 , -0.00133978619858 , -0.00364017517839 , -0.00342788592224 , 0.0225683717512 , 0.00121710464443 , -0.00538180690991 , -0.00307807126541 , -0.002568344622 , -0.00598321627885 , -0.000717356685059 , -0.00654198599318 , 0.00369531752262 , -0.000498961992878 , -0.00664077567347 , -0.00541800280745 , 0.00078520118781 , 0.00199298588588 , -2.44437958184e-05 , -0.0046540322741 , -0.0045114724446 , 0.00562527714901 , 0.00717246663024 , 0.00276062135388 , -0.0013994589378 , 0.0113286970833 , -0.00173921365488 , 0.0103649589219 , 2.32342352976e-05 , -0.00629609053198 , 0.00182749496363 , -0.00574796248924 , -0.00622845300555 , -0.00348504237497 , -0.000167178559774 , -0.00292022970767 , -0.00178734065854 , -2.30189713496e-05 , 0.00229387684477 , -0.00268759649375 , -0.00419801602653 , 0.00398775343609 , 0.000389198501282 , 0.00784870517561 , -0.00319610792438 , 0.00432248099108 , 0.0029432434627 , 0.00319622944324 , -0.00391663730032 , 0.00591121552334 , -0.00148764758709 , -0.0054022393867 , 0.000945939094652 , -0.000541157229669 , -0.00232488160728 , -0.00601790919043 , 0.00677522327825 , -0.00323852093795 , 0.00731632892623 , 0.000536911697854 , 0.0024227835954 , 0.0037840890315 , -0.000924837360373 , 0.00423388979495 , 0.00330951535208 , -0.00671494078805 , -0.00294383522077 , 0.00455878401008 , -0.00116054110133 , -0.00485204897762 , 0.00068595020439 , -0.00135876479233 , 0.000452378716094 , 0.00054920477602 , 0.00587543064296 , -0.0026514032572 , -0.00129941966247 , -0.00716348821089 , -0.00303511905112 , 0.00222806303096 , -0.00364070816824 , 0.000850769101982 , -0.000623903073571 , 0.00614381004535 , -0.00183143970055 , 0.00367273952819 , -0.00111533775876 , -0.00338405022062 , 0.00212122079133 , 0.00175583748659 , 0.00979175404955 , -0.0041759906571 , -0.00472926165939 , -0.00465993570165 , -0.0019949217249 , 0.00651307243709 , -0.00398083563554 , -9.25303091416e-05 , -0.000413221239141 , -4.80979324657e-05 , 0.00443462356717 , -0.000237036210392 , 0.00290719405987 , -0.00709482286353 , 0.00364994354164 , 0.00470592354067 , 0.0051150070307 , 0.00476424935431 , -0.00444656813717 , 0.00357285076922 , -0.00420402530842 , 0.00200450276834 , 0.00302957224548 , 0.00468148008565 , -0.00605992142761 , -0.00456404215513 , 0.0144464506993 , 2.02419823573e-05 , 0.00173153050543 , 0.00493016763119 , 0.00121871632728 , -0.00363520920725 , -0.000115970554991 , -0.00335239504269 , 0.00350471731845 , -0.00295475672052 , 0.0115646166804 , 0.00238280654646 , -0.00274185926583 , -0.00492904025358 , 0.00383695419565 , 0.00200439002538 , -0.0064882253464 , 0.000203562689068 , -0.00304531714229 , -0.00337357164007 , -0.00188636283144 , 0.00488894430862 , 0.00310894223686 , 0.0038537586407 , -0.00484363859001 , 0.000818658449318 , 0.00235509611713 , 0.00444225719155 , ])
Y_4_0_imag = flex.double( [ 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , 0.0 , 0.0 , -0.0 , 0.0 , -0.0 , 0.0 , -0.0 , -0.0 , -0.0 , -0.0 , -0.0 , 0.0 , 0.0 , -0.0 , -0.0 , 0.0 , -0.0 , ])
Y_4_1_real = flex.double( [ 0.0 , -0.00193645963072 , -0.00104735493773 , -1.09372208036e-05 , 0.00269110611553 , -0.000346880984608 , -3.5034517633e-05 , -0.0040716136948 , 0.000814130399424 , 0.000548432949529 , 0.00322860018651 , -0.0020063307353 , -0.00378365599353 , -0.00104747435493 , -0.00655651627798 , -0.00185596834978 , -0.00148128476921 , 0.0119700438887 , 0.000564944907853 , -0.00677974097584 , 0.00315447972256 , 0.000666081527373 , -0.000323198545423 , -0.00333085158118 , 0.00388397963064 , 0.00723535418524 , 0.00210327198736 , 0.000236369599487 , 5.594671027e-05 , -0.0042413510823 , 0.00685932074235 , 0.000411982522158 , -4.29202154728e-07 , -0.00352159961515 , -0.00058869144569 , -0.00464669307175 , -0.00318226038628 , 0.000321806402613 , -0.000374686850581 , 0.00244537147557 , 0.000142065416904 , -0.00464868421684 , 0.00126947590507 , -0.00222608844185 , 0.00351310136458 , -0.0043684184204 , 0.00393877917319 , 0.00423113673526 , -0.00422932624976 , -0.000148877425849 , 6.23828154243e-06 , 0.00111461877509 , 0.00352217467415 , 1.95700944934e-06 , 0.00323859656451 , 6.05455150714e-05 , -0.00500109658719 , -0.0023550300643 , -0.00599145074922 , 0.000195065315875 , 0.00198021099309 , 0.000137257139832 , -0.00527822561594 , 0.000879034518286 , 0.00370364763675 , 0.000231019862737 , 0.00349250558119 , 0.00470063771308 , -0.000419454636308 , -0.00340999358852 , -0.00378175834441 , 0.0016316398659 , -0.00108939232027 , 0.00344076205823 , 0.000728799500847 , 0.000391135084551 , -0.00170812400832 , -0.00578249159348 , -0.000227108151765 , -0.00235263617305 , 0.00527812628924 , -0.00397558347908 , -0.00337691924896 , 0.00395070707385 , -0.00161793718442 , -0.00439422554598 , -0.0012559459701 , -0.00177906541768 , -0.00574572118775 , 0.000341896165963 , 0.000856525690321 , -0.00428309086817 , 0.00162479793531 , -0.000223539432185 , 0.000473917207443 , 0.00104518318321 , 0.00350978983741 , -0.000836566548853 , -0.00111195828284 , 0.00249469236698 , 0.00178474888502 , 0.00229127943586 , 0.000356148705934 , 0.000456901712251 , 0.000632588118904 , 0.00407712527592 , 0.000626222614552 , -0.000301944464409 , 0.00160345211809 , -0.00318442196756 , 0.00580217050472 , -0.00372515122558 , 0.000765629326254 , -0.00236506383277 , -0.0059497824564 , -0.000626766788036 , -0.00469684839781 , 0.00314899398404 , -0.000371627297112 , 0.00263400749641 , -0.000447002343172 , -4.68637825805e-05 , 0.00256643451538 , -0.00167473428584 , 0.00136085317705 , -0.00273710675164 , -0.00387352010469 , 0.00323298924165 , -0.00169882200653 , 0.000955213748499 , -0.00298142202474 , -0.00568679354476 , 2.98290578444e-05 , -0.00488595912403 , 0.00020873226523 , 0.00455331884377 , -0.00178023612936 , 0.00223470347292 , 0.00467749009047 , 0.000429218985005 , 0.00275038455447 , 0.000575578411833 , 0.00218838951198 , -0.00576309327594 , 7.10739485765e-05 , -0.00325472107976 , 0.00356582634431 , 0.00324211701867 , -0.000886943291356 , -0.00301756016513 , -0.00151765813488 , -0.000483215170731 , 0.000606486463338 , -0.000307819140344 , -0.00243292169379 , 0.0013527852518 , 0.00289576436266 , 0.000118522598168 , -0.00222148935391 , -0.000560448412372 , 0.000792322837924 , 0.00204318997669 , 0.00729317975707 , -6.67087009419e-05 , 5.43932978949e-05 , 0.00149985616466 , 0.000410982343396 , -0.00238386419805 , -0.00283567714072 , 0.00700022806808 , -0.00178218376338 , -6.86072196508e-05 , 0.00132451621553 , -0.0020986824304 , -0.00210653154745 , 0.00548060602194 , -0.00166485210415 , -0.000253225018073 , -0.0021627660094 , 0.000834779183875 , -0.000416705886103 , 0.00295872909602 , -0.00268203888014 , 0.00443966508211 , 0.00012434772902 , 0.0061918729923 , -0.00483002701863 , 0.00172757657914 , -0.00219049081924 , -0.00302587089142 , 0.000798956968761 , 0.00137762024746 , -0.00148522292122 , 0.00467609801131 , -0.00121081219992 , -0.000632122581684 , 0.00138114836655 , -0.00158470951737 , -0.000486166340298 , 0.00445461792943 , -0.000583655711716 , -0.00106567440201 , 0.00243716378248 , 0.0011497822226 , -0.00770857338686 , -0.0020875877161 , -0.000268620079059 , 0.00161345198899 , 0.00429920542013 , 0.000894956178717 , -0.00183816158018 , -0.000596058011239 , 0.00121461472404 , -0.00411272903506 , 0.00329712368836 , -0.0030309939287 , 0.00423575432746 , 0.000142767788904 , -0.000384023062879 , -0.00393200347345 , -0.00358525215918 , -0.00180187944957 , -0.000444295293085 , -0.00215270635364 , -0.00207070656422 , 0.000163396580532 , -0.00384116093951 , -0.00362278475642 , -0.000176434720731 , 0.00135605431525 , 0.00519326798974 , 0.000924245463359 , -0.00171065290572 , -0.0036959780079 , 0.0022613010256 , -0.000241081400658 , 0.000442625626827 , 0.00107847546058 , -7.90293307615e-05 , 0.00173706241049 , -0.00150668506451 , 0.000566745520738 , -0.00141860390937 , 0.000227302167535 , 0.0005826133434 , -0.000182000802112 , -0.00371158327494 , 0.000504836587733 , -0.000427333998574 , 0.000514187072969 , -0.00368859726642 , 4.40276724743e-05 , -0.00681280560514 , -0.00393725456601 , -0.00321833207829 , 0.00464644680669 , -0.00196461838058 , 8.10464933128e-05 , -0.00322474046001 , 9.96013576369e-05 , -0.00139490307164 , -0.00433880902546 , 0.000436435378784 , 0.00203471940983 , -0.00322574873139 , 0.0043677013963 , 0.000703656786062 , 0.000760294026585 , -0.00223750863716 , 0.0042272057974 , 0.00164515915304 , 0.00253121215375 , -0.000139733446257 , -0.00453887819789 , 0.000773262456083 , -0.0018711052431 , -0.000621678908494 , 0.00472521986642 , -0.001391745374 , 0.00157710157747 , 0.00183552182978 , 0.00097428667835 , -0.00509905004084 , 0.000400255775715 , 0.000658462946208 , -0.00140966356809 , -0.00243542957748 , -0.000272832869191 , -0.00111256237223 , -0.00246616249948 , 0.00298482907486 , -0.000648649742354 , 0.000693571688102 , 0.00175558371075 , -0.000328558586053 , 0.00290093954874 , 0.0016077008818 , -0.00121475433623 , 0.00342298573979 , 0.00238460744777 , -0.000251568391893 , 3.00037128223e-05 , -0.000198807522316 , 0.00180742678271 , -0.00318523932767 , -0.000923397127108 , 0.000889204751442 , -0.00647408962799 , 0.00455602322112 , 0.00022275816212 , 0.00104987916393 , 0.00128166030057 , 0.00467725957955 , 0.000893243274945 , -0.000689463018672 , 0.000130409171246 , -0.000124430421816 , 0.000897463220165 , -0.00085898045369 , -0.00396160304308 , -0.000576963656529 , -0.00135659858511 , -0.000775649233719 , -0.000276757949789 , -0.00692577805609 , 0.00171820401969 , -0.00233594137447 , -0.000326153463837 , 0.00831955818601 , 0.000622256963363 , -0.0015682393694 , -0.00152978171772 , -0.000470804642278 , -0.00568106300634 , 0.00191117606103 , -0.000146652092959 , 0.00199557515167 , 0.000105634223812 , -0.00200120188079 , -0.00390208701483 , 3.35732856677e-05 , 0.00404752750725 , 0.00218686635221 , -0.000303816755159 , -0.00081866573252 , 0.000163253191105 , -0.00167962654016 , 0.00161603099993 , 0.00220669811008 , 0.00761011745931 , -0.00466931835924 , -0.00159440972589 , -0.00168960620093 , 0.00189743777247 , -0.00321412383812 , 0.00181350839802 , -0.00175238971829 , -0.00168764611598 , -0.00201486234962 , 0.000839906312279 , 0.00306809922314 , 0.011535927446 , -0.000644630699246 , 0.00267023787343 , -0.00173355091995 , 0.000245090007206 , -0.000874311745249 , 0.000170647233614 , -0.000291184137629 , 0.000622275075883 , -0.00276546819302 , -0.00201381562293 , 0.00335903408077 , 0.0020612959155 , -0.0039238765637 , 0.00244288659613 , 0.00100613555349 , 0.000650717936473 , 0.000101648956479 , 0.000983652577026 , 0.00153656966022 , 0.000129812755948 , 0.00301040371113 , 0.00456681541244 , 0.00151057041351 , -0.00290623593541 , -0.000794115540781 , -8.49163278793e-05 , 6.64787976567e-05 , -0.00214262056429 , -0.000141377440333 , -0.00070789538849 , 0.000125145761059 , -0.00393516683292 , 0.00599003401665 , 0.00455079770142 , -0.000496995372024 , -0.0033806443621 , 0.00066780905236 , 0.00198286284116 , 0.000305510356874 , -0.00458412129865 , 0.00597211250482 , -0.00143603286664 , 3.56717269257e-05 , -0.00424096789908 , 0.00451303135624 , 0.00461578802849 , 0.0011822719087 , 0.00331979729025 , -0.000950014891537 , 0.00151897653469 , -0.00113914934081 , -0.000223288385643 , -0.00506778462502 , -0.00154907930843 , -0.00175461912219 , 0.00338586058086 , -2.77090806419e-05 , -0.00191192675755 , -0.00237184088267 , -0.00440106797402 , -0.00393615897914 , 0.00119850360481 , -0.000298429579747 , -0.00392014993896 , 0.00138036747215 , 0.00286299739201 , -0.00305646748638 , 0.00148074227826 , -0.0021658971797 , 0.00059900963026 , 0.0036934041062 , 0.00131722680022 , 0.0034334120835 , -0.000726672461266 , -0.00356924260308 , -0.00386850061075 , 0.00249614033749 , 0.00625053216844 , -0.00237869027739 , 6.55514241126e-05 , -0.00144686431066 , 0.00290693477237 , -0.00159740269599 , -0.00125848150257 , -0.000107234129657 , -0.00180803961494 , -0.00428202820225 , 0.00537904669314 , -0.00010075360516 , 0.00488107416899 , 0.00399173077265 , -0.0096799330467 , -0.00128717690014 , -0.000999328289592 , -0.00099265279812 , 0.000206474654062 , -0.00096132354908 , 0.00121999468759 , 0.000277715797598 , 0.000489350489261 , 0.00550747711794 , 0.00551686429964 , -3.35524381281e-05 , -0.00381230532928 , 0.00365375520002 , 0.00134541005681 , -0.00653931945461 , 0.00123751961388 , -0.00852963084643 , 0.000595625069483 , -0.00284281255334 , -0.00160195906197 , 0.00555507997351 , 0.00116005083196 , 0.000749814472965 , 0.0034404467454 , -0.000853780794134 , 0.000966107551239 , 0.00221139010216 , 0.00219621048213 , 0.004833550213 , -0.00252286214491 , 0.00103266627689 , -0.00144822645536 , -0.00318291980092 , -0.0043136854826 , 0.00215476594965 , 0.00209644035687 , 0.00505910774739 , -0.00047239710559 , 0.00316535816491 , 0.00370734983106 , 0.00124186473668 , -0.00468460264316 , -0.0015399981803 , -0.00319584875142 , 0.000523064698359 , -0.000663211907474 , 0.0032783793216 , 0.00260628349123 , -0.0014764545576 , -0.000908567814935 , -0.000342680591199 , 0.00374198934164 , 0.000281461704804 , 0.000536805123427 , -2.76339392283e-05 , 0.000333242155511 , -0.00277528508003 , -0.000344392217653 , 0.00187487106785 , -0.00374036624846 , -0.000763080993329 , 0.00233731391214 , 0.000666642885322 , 0.00144836081332 , 0.0024991759929 , -0.00141003786713 , -0.000248996970752 , 9.78146290298e-05 , 0.00236533788219 , -0.00272744780416 , 0.00472201512752 , 0.000128019331132 , 0.00117108874426 , -0.00268898810204 , 0.00180185581776 , -0.00366183799404 , 4.30388369677e-05 , -0.00181441775479 , 0.000321699312278 , 0.00105576958614 , 0.00155750665082 , -0.00152531371801 , 0.00156299966169 , -0.00441437087075 , -0.00157073869666 , 0.00164696767052 , -0.00128651119659 , -0.00117137144657 , -0.00230956276303 , -0.00123878548598 , -8.27773487279e-05 , -0.000113567698586 , -0.00252162328106 , 0.000667071609964 , -0.00459400268013 , -0.000691222292641 , -0.00271410188167 , 0.00250453618408 , -0.000536256389983 , -0.00258296238305 , -2.88323366553e-06 , 8.57030551214e-06 , 0.00199608531545 , 3.68516278639e-05 , 0.00238049692945 , -0.00112776631843 , 0.000311699080533 , 0.00401795146574 , -0.00200239429154 , 0.00735138032503 , -0.00191401435328 , 0.00214908320087 , -0.00261914821632 , 0.000175606635804 , -0.000497668655434 , -0.000652685919939 , -0.00291208391228 , 0.0015941176622 , -8.48456317477e-05 , 0.00177092133444 , -0.00303829675841 , -0.0037569923846 , -0.00307591951927 , 0.00145074855575 , -0.00279373272525 , -0.00503173772377 , 0.000106409509192 , -0.00370747750003 , 0.00116338505777 , 0.00551204651164 , 0.000480494007402 , -0.00309985216875 , 0.0011407303134 , -0.00242066351255 , 0.00435161231882 , 0.000322852797495 , -0.00272580673659 , -0.00208525325172 , -0.00403088781484 , -3.66238404796e-05 , 0.000381713212782 , -0.00795731363052 , 0.00550744162456 , 3.61556807995e-05 , -0.00297592534612 , 0.00409803746965 , -0.00336377638442 , 0.000486998185305 , -0.00313121262536 , -0.000549052296669 , -0.00468169382227 , -0.00439039682273 , 0.00359508178627 , 0.00373239040474 , -0.0021307141184 , 0.00505753914358 , 0.00459243408685 , -0.000693110141573 , 0.00238331000454 , -0.00305202461096 , 0.00055873468161 , -0.00195756515635 , 0.00289335658792 , 0.000805966484314 , 0.00401614531718 , -0.00495407175292 , 0.00222334456355 , -0.00125713053925 , 0.00694314118467 , -0.00292049732118 , -0.00327577535795 , -0.00349707151812 , 0.00149376759189 , -0.000420158554297 , 0.000500343067361 , -0.000194827795352 , -0.000829767292406 , 0.00206148384366 , 0.00294765913151 , 0.00154900540039 , 0.000515212208274 , 0.000653626552902 , -0.00347290069716 , -0.00828546967427 , 0.00035582223382 , 0.00380738205064 , 0.00129251408573 , -0.00265400570345 , -0.00222984933441 , -0.00545720354333 , -0.000662505906554 , -0.00517650574531 , -0.0038870166431 , -0.000274550362969 , -0.00353488921332 , 0.00746154420343 , -0.000302761260699 , 0.00280380771722 , 0.00298375998234 , 0.00178095614685 , -0.00197209739428 , 0.00323158183242 , 0.00260929147554 , 0.00138214023977 , -0.0012698332743 , 0.000498950251617 , -0.00270734378006 , -2.7350502917e-05 , 0.00127357419272 , -0.00140767403419 , -0.000418571162783 , 0.000221206958246 , 0.00335007666192 , -0.00343029690651 , -0.00681226525084 , 0.00175675905828 , -0.00203006880793 , -0.000268767500875 , -5.31227879171e-05 , -0.000216375811342 , 0.00320366852253 , -0.00113707962909 , 0.00245905581706 , 6.1575569576e-05 , 0.00290221812038 , -0.00429350991133 , 0.00377863022712 , 0.00263270921147 , 0.00203884995923 , -0.00163590812617 , 0.00486455591477 , 0.00124872696093 , 0.00242893296898 , 0.00110640852597 , 0.00513841600198 , 0.000984700315713 , -0.00408719941647 , -9.8529378178e-06 , -0.000196355444224 , -1.32067530723e-05 , 0.000270932477699 , -0.00124592884201 , -0.000144365111667 , 0.000472185842243 , -0.00340173876169 , -0.000789554819802 , -0.0024767355 , 0.00184855346197 , 0.00400391810166 , -0.00413405766045 , -0.000282266529776 , -0.00254749992631 , 0.00106420996274 , 0.00334014453299 , -0.000681805757744 , -0.00322587479666 , 0.000949748055533 , -0.00346485131946 , 0.00479981629675 , -0.000647428325209 , -0.00265011700821 , 0.00080575590216 , 0.00257593524188 , -0.00268129257836 , 0.00283579335137 , -0.000365712553183 , 0.0010702989151 , 0.000907637169324 , 0.000142518733381 , 0.000855269210428 , -0.00102513218604 , 0.000260445682794 , -0.00330838966165 , -0.00144598592397 , 0.00142843025175 , -0.00178129973979 , -0.00578464460578 , 0.002431730183 , -0.000343692326711 , 0.00231890228292 , -0.00384031481066 , 0.00397805484014 , -0.0062367009896 , 0.00389954712829 , 0.0036661950061 , 0.0049837782494 , -0.00165772651882 , 0.000540452865598 , 0.00438764500055 , 3.1110075663e-06 , 0.000308558970842 , -0.000343084449527 , 0.000866942743923 , 0.0107384454564 , 0.00114060678323 , -0.00364450592785 , 0.00229284364477 , 0.00292941894322 , 0.00210367153912 , 0.00355551620429 , 0.00323347660617 , 0.0039769894338 , 0.00778283714818 , 0.00195529193859 , 0.000462218856993 , 3.10401403257e-05 , 0.0029443786284 , 0.00295684652493 , 6.99231626421e-05 , -0.000696196755683 , -0.00114078745402 , 0.00329057558525 , -0.00188852095792 , -0.000181834807442 , -0.00129956679714 , 0.00158014468716 , 0.000688060162667 , -0.00166299506401 , 0.00182423005073 , -0.000274898736775 , -0.00216002337779 , -0.00173324526876 , -0.00160777280858 , 0.00103783284244 , -0.00341088465674 , -0.00425761425435 , -0.000935225620389 , -0.00463164809641 , 0.00409588819537 , 0.00463635871452 , -0.00080186860063 , -0.00219670636061 , -0.00279083309436 , 0.000857114989954 , -0.000462319276758 , 0.00375014927555 , -0.00430833020934 , 0.00357901131679 , 0.00588632985419 , -0.00415729358735 , -0.0018999636627 , -0.000685572476463 , -4.83305669682e-06 , -0.0003116364394 , 0.00495977193799 , 0.0077534803646 , 0.000620102669254 , -0.00524004577713 , 0.00462589835722 , -0.000606896750041 , 2.38732139635e-05 , 0.00121555453672 , 0.00219589150943 , -0.00085203235953 , 0.0010973263706 , 0.00307632080194 , -0.0042558263531 , -0.000315628908961 , -0.000990014992001 , -0.00259000360732 , -0.00604723521267 , 0.0024708164809 , 0.00307315215052 , 0.000455471123884 , -0.00212756316829 , -0.00187760295389 , -0.00109471948332 , 0.000378574447146 , -0.000562969834458 , 0.00723535737291 , 0.00130189087791 , 0.00103048459964 , 0.000915072044972 , 0.00311105131941 , 0.00790393881967 , 0.00109767771836 , 0.00251180612415 , 0.000263764902069 , -0.00534835381808 , -0.000425346009005 , 0.00161198671611 , -0.00411528069466 , -0.00162583369504 , 0.00478318055567 , 0.00555541969923 , 0.0014102549003 , 0.000796676464355 , -0.00128939270423 , -0.00116504641849 , -0.00532511125364 , -0.000383124980451 , 0.0029874463267 , 0.000201514935022 , -0.000131006618484 , -0.00441533271854 , 0.00265912625498 , -0.00600811424686 , 0.00286921890252 , -0.000693185259326 , 0.000610049317683 , -0.00421744499923 , 0.00495836528209 , 0.000990759482659 , -0.00348677840318 , 0.00143215449233 , 0.000858842949593 , 0.00144897476878 , 0.0128231088467 , -0.000701650951337 , 2.30829543543e-05 , 0.000416001802032 , -0.00218058619469 , -0.00384189321271 , -0.00106364719841 , -0.000510877302818 , -0.00298624605416 , -0.00177901881487 , -0.0007622089852 , -0.00384736338202 , -0.00437192499286 , -0.00409217034815 , -0.00171158292878 , 0.00245830442235 , -0.00500726333232 , -0.00160285128732 , -0.000767420654629 , -0.000162338251619 , 0.00280316199224 , 0.00423035341446 , -0.0033027089138 , -0.00118662740091 , -0.000189472884577 , 0.00151357373778 , 0.000506290879256 , -0.000492540126278 , -0.00344763082226 , -0.00294894479565 , 0.00131652407344 , -0.00199762736045 , -4.05585353052e-05 , 0.00172084812111 , -0.00231964048583 , -0.000354971239213 , 0.000961175229367 , 0.00219451646804 , 0.00308326251185 , ])
Y_4_1_imag = flex.double( [ 0.0 , -0.0 , -0.000189977706162 , -8.68665539392e-06 , 0.00437113608381 , -0.000948361818336 , 5.77309326383e-05 , -0.000461639533729 , 0.000463046815295 , -0.00236609716111 , 0.000485834823123 , -0.00655927132234 , -0.00579315631948 , -0.00475526766488 , 0.00301388675946 , 0.00147991147478 , -0.00638894501967 , -0.00387201690246 , -0.00336647922284 , -0.00103796720389 , -0.000337531364897 , 0.00024113893579 , 0.000720923398333 , 0.000293581912442 , 0.0014809908902 , 0.00237076155689 , -0.00010121445299 , 0.00326598238658 , 0.000619014143287 , -0.00320428153518 , 0.0107392226411 , 0.00474180476017 , 1.14687400677e-05 , 0.00253180392295 , 0.00160895596515 , -0.000897670876785 , -0.000316905176705 , 0.000705808704383 , -0.00646812661524 , -0.001034878892 , -8.64902288978e-05 , 0.00108791519002 , -0.000514028905198 , 0.000238958845043 , 0.0001774933974 , -0.0019979908541 , -0.000361413438824 , -0.000629438265199 , -0.00231019699464 , 0.000110624577213 , -0.00200586300569 , 6.54636634865e-05 , -0.00515249203844 , 2.16294929416e-05 , 0.00433301411131 , -0.00377711633203 , -0.00212100220931 , 0.0022843412493 , -0.00132784087074 , 0.00037301602055 , 0.000252173058124 , -6.15052505287e-05 , 0.00451648959546 , -0.00154738789331 , 0.0043868152955 , -0.000201690398689 , 0.00163314701207 , -0.00440328450489 , 0.000989497319893 , 0.000937639357986 , 0.000759654826287 , -0.00142647047728 , 0.000174619025042 , 0.00457057484688 , -0.00462706200296 , 0.000231745524244 , -0.00194979225626 , -0.00222598016718 , -2.27779597589e-05 , -0.00246356625222 , 0.00482111269227 , -0.00122687172119 , 0.00413150572961 , -0.000758456768448 , 0.00119527437012 , 0.00224899402897 , 0.00733650224307 , 0.00224578639157 , -0.000342711510854 , -0.000218523641416 , -0.000374695924997 , 0.00804311915335 , 0.0052763807799 , 0.00284337566065 , -0.000684676193469 , 0.00310872687459 , -0.00996110591911 , 0.00140637136663 , -0.00275859170337 , -0.00114316067393 , -0.000206500231062 , -0.00247916388226 , -0.00116519859247 , -3.10619950027e-05 , 0.000424023666819 , -0.00370805063411 , 0.00312536453677 , -0.00192933670923 , 0.00346989843692 , 0.00383535661425 , 0.00496222231844 , 0.0016005147766 , -0.00102999172165 , 0.0105050412444 , -0.00307704333792 , 0.000813521428393 , 0.000486204248966 , 0.000934243704993 , -0.000795110501383 , 0.000666200004536 , 1.82873873175e-05 , -0.0016824631449 , -0.00984463595247 , -0.000247736164944 , 0.00105742727934 , -0.00165211425857 , 0.0014059132302 , -0.00411810127554 , -0.00259401829149 , -0.000168303224956 , 0.00211255752348 , -0.00078569826984 , 0.000829261527827 , 0.000803999672191 , -0.00653042340644 , 0.00111116648708 , -0.00258768023671 , 0.0014478628522 , -0.000655446448024 , 0.00139712751212 , 0.00745503123535 , -0.00217006762735 , 0.00129843147107 , 0.00426925639967 , 1.65832248575e-05 , -0.00011413934819 , -0.00157245077242 , -0.00178869431408 , -0.00158724308776 , -0.00049186931525 , -0.00964959512436 , -0.00144013590353 , 0.00522314678272 , -0.00246636716408 , 0.00157304649003 , -0.0022649576801 , -0.000520778518114 , -0.000148516860646 , 0.0027169490364 , -0.00335082651448 , -0.00304881257551 , 0.00504675981422 , -0.000536040807974 , 0.000151032883002 , 0.00014959710023 , -0.00363451395362 , -0.000723554105665 , 0.00243741922983 , -0.00493866557363 , 0.00170981286459 , 0.00037341533244 , 1.07575219126e-05 , 0.00240479441631 , 0.0019734228515 , -0.00476001801342 , 0.000683691159496 , 0.00676685493702 , -4.89443115399e-05 , -0.0015735947044 , -0.00615635852901 , 0.000385895463319 , 0.00300765151365 , -0.00567617421448 , 0.000408842471409 , -1.28006506792e-05 , -0.0020458103351 , 0.00103166474837 , -0.00239178034228 , 0.00485480522844 , -0.00735802677035 , 0.00213319425991 , -0.00159505652511 , 0.000164420851157 , 0.00039727607826 , -0.00102900767844 , -0.00134169808487 , 0.000960634423037 , -0.00229091885964 , 0.00185490974669 , 0.000683569932022 , 0.00525146282375 , -0.00113903705886 , 0.00101992995249 , -0.00473899279749 , 0.00149137410897 , 0.00387731272553 , -0.00310919142338 , 0.00165324250602 , -0.00417892495763 , 0.000121362148893 , -0.00099813449247 , 0.0059482853676 , -0.000877920738641 , -0.0011373463809 , 0.00192407829916 , 0.00483021433459 , 0.00137022492448 , 0.000966398218546 , -0.00200357801944 , 0.000196274364391 , -0.00120579557502 , 0.00135706601917 , 0.00036119322401 , 0.0014021327032 , 0.00429843609288 , -0.00353842791812 , 0.000608244993715 , -0.00352509541887 , 0.00203309057089 , -0.00174318758333 , 0.000511571412611 , 0.00497318236189 , -0.00163258400634 , 0.00251212839772 , 5.42681444012e-05 , 0.00235723069949 , -0.00302950597119 , 0.0017034465593 , -0.00014061705847 , 0.0021292500022 , 0.00321634123194 , 0.000595943180811 , -0.0040733338814 , 0.00102543721386 , 0.00260265844765 , 0.00544831812742 , -0.0037618227233 , 0.000521396719116 , -0.00456272362577 , -0.00124779799863 , 1.37612918326e-05 , 0.00225556428631 , -0.00491707302282 , -0.00182197339008 , -0.00277237564215 , -0.000276019218455 , 7.06404890704e-05 , 0.000510436392142 , -0.00078498457143 , 0.000303577347995 , -0.00331567337059 , 0.00181846848022 , -0.00305889549862 , -0.00448749478505 , 0.000734121190328 , 0.00340735845857 , 0.000592443570485 , -0.00210213571988 , -0.0033719570817 , 0.00379814312412 , 0.000619142111852 , 0.00172229898996 , 0.00131945440147 , 0.000154164769849 , -0.00109933580576 , -0.00149704543365 , -0.000773836325637 , -0.00267809327811 , -0.000621696665013 , -0.00275288053676 , -0.00425872517698 , -0.00189023736663 , 0.000718625716498 , 0.000646892326264 , 0.00228800386276 , -0.00210274643934 , -0.00118777888812 , -0.000470985487963 , 0.00432598099704 , -0.00121475092217 , 0.00238135635158 , 0.000740166787975 , -0.000542043398405 , 0.00559832274869 , 0.0057892094715 , 0.000711848535288 , 0.00235579795845 , 0.00177438283148 , -0.000894762333538 , 7.88670980771e-05 , -0.00431173090889 , 0.00125691909132 , 7.23481238727e-05 , 0.0054347397823 , 0.00295128787994 , 0.000375006336854 , -0.00091748936618 , -0.00330165135581 , -0.00151874865616 , -0.00221477806248 , 0.00638711415384 , 0.00270133949355 , -0.00136253052155 , -0.00291634650217 , 0.00299213067049 , -0.00363396843947 , 0.00106563078028 , -0.00298710338042 , -0.00187156401922 , -0.00313422813032 , -0.00538055026664 , -0.00687813548337 , 0.00143711125731 , -0.00135450339468 , -0.00211674636907 , -0.00156972783236 , -0.00110327455195 , 0.00190466157019 , -0.00255190447197 , 0.00030849978254 , -0.00199379419268 , 0.00236375126605 , 0.00125285335579 , -0.00481011476548 , -0.00430287973786 , -0.00186038763214 , -0.00403769803784 , -0.00506200060596 , 0.00168443015427 , 0.00138212699761 , -0.000746760901522 , 0.00697124984185 , -0.00450900828293 , 0.000206159508405 , -0.000894059983904 , 0.000300387188122 , -0.00435465854825 , 0.011085350451 , 0.00534716422281 , -0.00595350458352 , -0.000406161926394 , 0.00483373194137 , 0.00248015988688 , -0.00144682684196 , 0.00431529462666 , -0.000623423133915 , 0.00285037903763 , -0.00549918804899 , -0.00220110701904 , -0.00332448162662 , -0.00460373636307 , 0.00250218954847 , -0.00187325425284 , -0.000654188637699 , 0.000695691973531 , -0.000137337083929 , 0.00169960544775 , 0.000667335819252 , -0.000414971032231 , 0.00293586575895 , -0.00127203616284 , -0.00301805770872 , 0.000648337822017 , 0.00375883683781 , 0.0014504835947 , 0.00536448816228 , 0.00335446262561 , 0.00125992428603 , -0.00147400374757 , 0.000196895854043 , 0.000379813056243 , -0.00363571298688 , -0.00246570421879 , 0.00204715802585 , -0.00083529448978 , 0.00470051058391 , -0.00293833488852 , 0.000410983395715 , 0.00133792972903 , 0.00278775105149 , -0.00452712779117 , 0.00390003995399 , -0.000112066509627 , -0.000834846097248 , 0.0089241150626 , 0.00283584670197 , 0.00700381037046 , -0.0052689511366 , -0.00125106334253 , -0.00404086186145 , -0.000673004405226 , 0.00278746262982 , -1.32236046221e-05 , 0.000767109475896 , -0.000593433740349 , 0.00252856542814 , 0.0013472445055 , 0.00246144221913 , -0.000907256532227 , 0.000717465836655 , -0.000899580291228 , -0.00450987240684 , -0.00454393074342 , 0.00520230955983 , 0.00644789811322 , -6.09909153053e-06 , 0.00166945792529 , -0.00102722400227 , -2.36483820716e-05 , 0.000220221103899 , -0.00148085864855 , -0.00425905871972 , 0.00389273396283 , -0.0036356090762 , 0.00640135263451 , -0.000104156681471 , -0.00140429170168 , -0.00195194591131 , 0.00434961984596 , -0.00607260061665 , 0.00224366662017 , -0.000201284072825 , 0.00225661752626 , -0.00352253413774 , -0.00426684813887 , -0.0069950984921 , -0.00123199158069 , -0.00123164723304 , -0.00107836585836 , 0.00179897989231 , 0.00062533774129 , -1.06731356344e-05 , 0.000334242875652 , 0.00297379698326 , 0.00627630132649 , 0.00582399906844 , -0.000991466739286 , -0.00288578471094 , -0.00133568408197 , 0.000221645378117 , -0.000116734725182 , -0.00140879008249 , -0.000903351447154 , -0.00136136854835 , 0.00078596739527 , -0.00504095688036 , -0.000896440979951 , -0.00028957805659 , -0.0026249746549 , 0.000538020585327 , 0.000295290828212 , 0.000713128168666 , -0.00335995629598 , 0.00331198973863 , 0.00273052846298 , -0.00234209359262 , 5.00891660631e-05 , -0.000270192983161 , 0.00333093475878 , -0.00658256631277 , 0.00165043564405 , -0.00034679153785 , -0.000138544861236 , 0.00347017569127 , -0.000285740596864 , 0.0010291727982 , 0.00169172366534 , -0.00195356024574 , 0.000190453357424 , 0.00151616987903 , 0.00206346691004 , -0.000244291300225 , -0.00233917206583 , -0.00203909498622 , -0.00121864667603 , -0.000265194439926 , -0.00107187681453 , 0.00192032857016 , 0.00298072807066 , 0.0017402772271 , -0.0020970913749 , 0.00222019607934 , -0.000764224296907 , 0.00292022650413 , 0.00208818138146 , -0.00336679627229 , -0.00212791061395 , 0.00332530827457 , 0.00232459437937 , 0.00196767177579 , -0.00307304885222 , -0.00492420222276 , 0.00161987540009 , 0.00468366602861 , 0.00344291162211 , -0.00012658050769 , -0.00224462220838 , -0.00236335142199 , -0.000178096731358 , -0.00301490600498 , 0.00330783405823 , -0.000164981768269 , 6.85133887434e-05 , -0.000646391116155 , 0.00321122333349 , -0.00356521496651 , -0.00122017825146 , 0.00228872325391 , 0.000771921050399 , -0.00292930700448 , 0.000723931688116 , 0.000342190737571 , -0.00286428299853 , -0.00269499505227 , -0.00254945455851 , 0.000499797479257 , 0.000840173535397 , 0.00140299157714 , 0.000929369610988 , -0.000227893871413 , 0.00108343083883 , -0.000672643863645 , -0.003534160055 , 0.000158639418067 , 0.00350329082707 , -0.00158032194272 , -0.00114855242926 , 0.0043991910601 , 0.00254201131772 , -0.000338043521068 , 0.00285246965877 , -0.0020928472361 , 0.00416873405845 , 0.00410106571154 , 0.00135855685234 , -4.65200174469e-05 , -0.00600708965545 , 0.000861914067794 , 0.000517509593232 , -0.00236118327567 , -0.000804160643772 , -0.000913548708744 , 0.00367971861677 , 0.00123288256755 , 3.83789689618e-07 , -0.000627580429978 , 0.000670068132435 , -0.000104246087647 , 0.00214310880518 , 0.000344594128397 , 0.000317499071181 , 0.000473956032826 , -0.000172976200317 , -0.00257388989282 , -0.00370072070639 , 0.00054090070303 , 0.00302879661013 , 0.00038167042761 , -0.00348700279057 , -0.000361924976844 , -0.00391252795489 , -0.000425945645873 , -0.000200894179854 , -0.00088540901431 , 0.00111331260468 , -0.000784830566782 , -0.00399262897083 , -0.00229481973675 , 0.00164765101921 , -0.00643582864118 , 0.00192502430977 , 0.00953476755202 , -0.00120820115306 , 0.00188644806153 , 0.00200346412035 , -0.00476362162246 , 0.0025410214008 , -0.00103656609199 , 0.00491129793665 , 0.00280011495385 , 0.00035664636198 , 0.00449296774123 , -4.15178941911e-05 , 0.000123156637815 , 0.00246846337079 , -0.000652264444218 , 0.00102171300655 , -0.000211193996207 , 5.5457340979e-05 , -0.00539669063555 , -0.00347950217607 , 0.00429390120091 , -0.00403465773473 , 0.000650797760532 , 0.000299761156379 , 0.0023282809992 , -0.00350137668307 , -0.00317736126094 , -0.00174083225822 , -0.00606592302192 , -0.00339764822659 , -0.00114544497275 , -2.59532673889e-05 , 0.00249473238036 , 0.000644699903232 , -0.00428325555192 , 0.00420589572778 , 0.00523790117478 , -0.00163806738672 , -0.00330930687928 , 0.00272751781755 , -0.000389424496044 , -0.00827783345151 , 0.00256060505567 , -0.0037299641964 , 0.00386798226885 , -0.00172840242987 , -0.00142131524041 , -0.00488823840392 , 0.0029768090126 , -0.00262772906386 , 0.00144893864924 , -0.00354155947551 , 0.000222000598384 , -0.00109417188653 , -0.00175136510498 , -0.00272279967275 , -0.00192741524906 , 0.0041502162431 , 0.00383436143403 , -0.00143212632526 , -0.00260293769276 , 0.000358623706568 , 0.00152697408395 , 0.00220874972574 , 0.00387559329814 , 0.00167861845111 , -0.000965247422068 , -0.00216668121857 , 0.00276263558725 , -0.00104784325072 , -0.00106826685526 , 0.0039745770726 , 0.000919234418147 , -0.000912824464067 , -0.00842298948522 , 0.00207090260093 , -0.00187711928748 , 0.00528669535617 , 0.0044927188777 , -0.00392615455386 , 0.000159394239958 , -0.000907889823576 , -0.00168867395175 , 0.000703970288865 , 0.00170208345892 , -0.0019061043027 , -0.00513109974968 , 0.00288494995784 , -0.00191978622262 , 0.00181733826093 , -1.52971881768e-05 , -0.00118539211776 , -0.00269610132992 , 0.000975388127163 , 0.00372422285976 , -0.00189658544984 , -0.00595175884926 , -0.00214245992566 , -0.00028035727117 , -0.00148585636761 , 0.00329504253434 , 0.00209224825996 , 0.000814833942205 , -0.00298748684147 , 0.00386825420901 , -0.0013689403794 , -0.00434227055069 , 0.00292723200931 , -0.00185886301826 , -0.00259970052734 , 5.98383363378e-05 , 0.00107011341476 , 0.00125028991205 , -9.45688994367e-05 , -0.000430067761754 , -0.00342982473961 , -0.00358699961397 , -0.00465907892238 , -0.00347887242502 , 0.00058215576786 , -0.00470658639774 , 0.00114094986263 , -0.00134174254019 , 2.42675505517e-05 , 0.000903442536047 , 0.000550279105469 , -0.00551756397699 , -0.00155171002385 , 0.0043393950239 , -0.00134701726481 , 0.00227563765508 , 0.00168070514793 , -0.00373431257829 , 0.000678762269818 , 0.00022306126048 , -0.00170834540808 , 0.0054404438536 , -0.00157430492627 , 0.000293346871585 , 0.00146974617836 , 0.0034861222993 , 0.00436084159276 , 0.00423083198049 , -0.000763110436238 , -0.00123504932799 , -0.00202118233277 , -0.00363822589879 , -0.00143797265463 , 0.000795010189034 , -0.00384653085183 , 0.00308319220593 , -0.000110842995001 , 0.00301034047328 , -0.000564475987491 , -0.00135966438817 , -0.00375173732845 , -0.00193012647161 , -0.00429178288481 , 0.00393895531632 , 0.00341254616832 , 0.00145146219017 , -0.000508330265114 , 1.41065805059e-05 , 0.0089452214737 , 0.000670492995609 , -0.00102044726908 , 0.00682696042235 , 0.00207173571858 , -0.00128767578877 , 0.000331063155905 , 0.00125555614396 , 0.00210195952457 , 0.00272052104123 , -0.000889399376722 , 0.00353011998257 , -0.000298835656079 , 0.00337243156659 , -0.0012681158436 , -0.000934553030323 , 0.00536454508498 , 0.00488911246817 , -0.000375232449332 , -0.0026916025426 , 0.00328750662216 , 0.0015938156142 , 0.0032092359316 , -0.00144869469342 , -0.00509610607005 , -0.00150919442313 , 0.00168669303473 , 0.00242740429722 , 0.000808466714067 , -0.00649586564995 , -0.00587283601105 , -0.00025352854742 , 0.000809920587927 , 0.00200617392845 , 0.00402211745883 , 4.19106889284e-05 , 0.00400950795433 , 0.00228359438011 , -0.00548823263122 , -0.000894191059562 , 0.00205032309342 , -0.000598376674559 , -0.00338171611111 , -0.000211642571731 , -0.000699019903828 , -9.86626568692e-06 , -0.000160912733762 , -0.00266572316851 , 0.00164877149296 , -0.00402135524816 , 0.00308403441256 , -0.000448574112645 , -3.08077302218e-06 , 9.28359957391e-05 , -0.0024315034994 , -0.00447265375714 , -0.00203324667392 , 0.00114802985954 , 0.00275648206648 , 0.00064747457465 , 9.0572475672e-06 , 0.00681149307665 , 0.000887522711643 , 4.07098093425e-06 , -0.00238634298799 , 0.00244092621808 , 0.00157460741225 , 0.000777140701674 , 0.000484033037624 , -0.0056960990425 , 0.00419018739591 , 0.00288017734684 , 0.00151150123956 , 0.000283399559261 , 0.0043883271274 , 0.00102268242885 , 0.000389224706153 , -0.000383754603734 , 0.000612022102429 , -0.00532054769891 , -0.000708691385087 , 0.000116336320217 , 0.0059703456277 , 0.00674222971178 , -0.0015692823236 , 0.00239446232917 , -0.00181248776976 , 0.000100828465931 , 0.0015593416042 , -0.00214641888993 , 0.00111507384845 , 0.00206877364041 , -0.0031188253597 , 0.00029915518005 , 0.00282195397006 , -0.00509869924899 , -0.00451648302314 , -0.000801846034234 , 0.00391596631991 , 0.00352070338528 , 0.00265731552375 , -3.84848344032e-05 , -0.00434401800319 , 0.00450467554355 , -0.00262887547467 , 0.00172645860101 , 0.00111083726554 , 0.0024593596564 , -0.000528372818305 , 0.000559761030796 , 0.00357820412972 , -0.000796688369259 , 1.21286051829e-05 , 0.00428728970798 , 0.00396418080009 , -0.000163191681081 , 0.00130641115804 , 0.000387668931296 , 0.00157521844272 , 3.15073087882e-05 , -0.0036799663745 , -0.00168533605048 , 0.0015867312219 , -0.00125996788229 , -5.85971569927e-05 , -0.00133631359431 , -0.0038250069235 , 0.00124266195284 , -0.000706574884479 , 0.00336528963583 , 0.000965481215559 , -0.00123759827937 , -0.00318369575768 , 1.10705457897e-05 , 0.00463824002073 , -6.49553115531e-05 , 0.000220371179408 , -0.00467747290227 , -0.00506808960358 , 0.00120771271284 , 0.000770460339849 , -5.25755603189e-05 , 0.00182427398868 , -0.000283464532686 , -0.000615046514166 , -0.00298312247312 , -0.00132968326655 , -0.00134828641154 , 0.00178888001992 , 0.00013372313591 , -0.00371982387854 , -0.000508401707683 , 0.0033644377686 , -0.0059498971718 , 0.00654519041869 , -0.000260845482472 , ])
Y_4_2_real = flex.double( [ 0.0 , -0.00568522109153 , -0.00439991879467 , -0.00128049177811 , 0.000523243780448 , -0.00422334544399 , 0.00224118647023 , -0.00223053677271 , 0.00312934964227 , 0.00465495515295 , 0.00256893033057 , -0.00297439241191 , -0.00171892836569 , -0.00423153664907 , 0.00271966116679 , -0.000403143853581 , -0.0010558990447 , 0.00577994688539 , 0.00262080323177 , 0.00231680204877 , -0.00438394756578 , -0.00277056590684 , 0.00257782270055 , 0.00336612832011 , -0.00393464243447 , 0.0073204622886 , 0.00561435692105 , 0.00150338634999 , -0.00589109102897 , 0.000347599599095 , -0.0020412247211 , -0.00113885969296 , 0.0055824964854 , 0.000572119775532 , 0.00240080579248 , -0.000233777377469 , -0.00384621106302 , -0.000290369537753 , -0.00919691006807 , -0.00117886932043 , -0.00189119762816 , -9.64275223896e-05 , 0.00217064098178 , 0.00323750558364 , 0.000672182426103 , 0.000125888919963 , 0.00144470341119 , -0.00219559483287 , 2.51446089918e-06 , 0.000813587094586 , 0.00252725417311 , 0.00428102444692 , -3.34420405888e-05 , 0.00549242968021 , -0.000179646481078 , -0.00324485385375 , 0.00192944009669 , -0.000137911211643 , 0.00631454341855 , 0.00308924019567 , -0.00490363615689 , -0.0034387852172 , 0.000503005653185 , -0.00113234375 , -0.00130695731368 , -0.000436404531424 , -0.000504158080579 , -0.000204564478223 , -0.000854644427858 , -0.00135316482895 , 0.00194384235184 , -0.000386762584458 , -0.00461321389631 , -0.00168417372897 , -0.00109409238306 , 0.0023639505015 , 4.21174150125e-05 , -0.000763288672698 , -3.3541933452e-05 , -0.000198482251437 , 0.00051031491174 , 0.00353324460782 , -3.74080689576e-05 , -5.7281831495e-05 , -0.00148272567756 , -5.11946911444e-05 , -0.00209749312771 , 0.000336490966754 , 0.00381547050176 , 0.00211060808299 , 0.00322391688886 , -0.00305208302551 , -0.00666478566821 , -0.0046278346647 , -0.00155717684928 , -0.00129876886083 , -0.00323988097315 , 0.00180302829846 , -0.00042722502833 , 0.00380620345328 , 0.00297181730925 , 1.4578210778e-05 , -0.00276842321032 , -0.00366219078979 , -0.00163938544816 , 0.000230915664375 , 0.00165543459032 , 0.00376587578468 , -0.00274147641132 , -0.000218285469588 , 0.000602624600452 , 0.00253877814568 , 0.00125512297519 , -0.00294543481826 , 0.00149875055543 , -0.000777643377194 , 0.000850635995305 , 0.00150345518214 , -0.00194458021072 , 0.00522958391468 , 0.00353875433733 , 0.00339417660684 , -0.00753086634129 , 0.00344937252652 , 0.00104841180389 , -0.0016505102174 , -0.00306483803499 , -0.000506875035735 , 0.00186158803578 , 0.00167415089124 , 0.00146171059627 , -6.16471082862e-05 , 0.00332137950502 , 0.00227984269208 , -0.00318573351443 , 0.00140877798041 , 0.00121465683095 , -0.00129326627117 , 0.00192517555197 , -0.00256037865602 , -0.00522445109571 , 0.00392727942684 , 0.00120977751216 , 0.00167463381668 , -0.00542540447152 , 0.00310633069188 , -0.000627479813046 , -0.00135982946818 , -0.000361562526575 , 0.00179171852678 , -0.00572566402813 , 0.00238045047166 , -0.00757151585564 , 0.00248889994101 , -0.00116979906305 , -0.000747569208951 , -0.0021753551053 , -0.00111572305408 , 0.000708811294335 , 0.000788935272609 , -0.00230649664864 , -0.00103133962648 , 0.00264109942785 , 0.0038804000235 , 0.00344374035518 , -0.00201731043308 , 0.0031978496023 , 7.78440335825e-05 , -0.000358646620716 , 0.00419335891949 , 0.00383146424552 , -5.21854262141e-05 , -0.00132021211853 , 3.8424753233e-05 , -0.00256631171267 , 0.00477061675226 , 0.00108651514558 , 0.00562577638038 , 0.000149668495341 , -0.00342090134351 , -0.00025543012203 , -1.74086219389e-05 , 0.000614814642911 , 0.00635024901052 , -0.00360398289885 , 0.00270042129084 , 0.00558230176038 , -0.00143569979039 , 0.00255649097115 , -0.00162631276517 , -0.00220028901375 , 0.000307311272945 , -0.000589293848104 , -0.00144264335213 , 0.000864785569665 , -0.00335555595726 , 0.000238776018615 , -0.00170261541351 , -0.00436492128301 , -0.00344599052776 , 0.0009909374934 , -0.000393087090446 , 0.00273950910067 , 0.00118261471205 , 0.00475975875806 , -0.00108406005405 , -0.000227613893484 , -6.42106750982e-05 , -9.1512569615e-05 , 0.00701656987362 , 0.00311810042182 , -0.00429422408461 , 0.000290098085138 , 0.000674101711508 , 0.000786421548178 , 0.000410462115703 , -0.000213105911704 , -0.00391534789682 , -0.00187741887199 , 0.00768002904203 , -0.00276273780382 , 0.00158517624558 , 0.00158148245372 , -0.00164924075607 , -0.000434479942657 , 0.000242290673255 , -0.000296609607384 , 0.000198852776802 , 0.00575767206954 , -0.000532757989876 , 0.00104563796889 , -0.00417385432075 , -0.000232755566266 , 0.000425545015906 , -0.00451029272905 , 0.00446360625743 , -0.00396909865964 , -0.00177707566958 , -0.000704485572881 , 0.000883719535623 , 0.00092241401659 , 0.000218703490239 , -0.00322378320645 , -0.00358696599308 , -0.000352629151707 , -0.00510978119381 , 4.60939625859e-05 , -0.000202762076754 , 0.00354248327349 , 0.00302325059072 , 0.00383992001746 , 0.000512250926028 , 0.00152959898842 , -0.00141798650081 , 0.000545700840414 , -0.00246894821396 , -0.00467035448759 , 0.00323160011769 , -0.00104348316179 , -0.00369365607014 , -0.00340752496623 , 0.00286423432064 , -0.000950799646381 , -0.000125381375908 , 0.00176932637778 , 0.000430602882194 , 0.00113116048044 , -0.00242344591388 , -0.00280094362369 , -0.000122681614019 , -0.00234049018415 , -0.000188337717893 , -0.00318793080603 , -0.00106928594326 , -0.00241270315003 , -0.000470633970169 , 0.00124340850779 , -0.000911843199286 , 0.00312148632723 , 0.000668244847526 , -0.00235640964672 , -0.00382629543243 , -0.00316414768139 , -0.00252778672319 , 0.00408624803881 , -0.00210853397397 , 0.00496510359085 , 0.00174681685788 , -0.00477464237452 , -0.000911342417214 , -0.000517393499836 , -0.000604876672407 , -0.00115876415549 , 0.00106384465007 , 0.00221921230476 , -0.0033687760861 , -0.00307899104341 , 0.00164129070272 , 0.00308588571779 , -0.00262481626737 , -0.00171028521769 , 0.00253788881097 , 0.00270638327456 , 0.00316255666198 , 0.000411026456214 , 0.0048967093509 , -0.000121266867148 , 0.00370619631157 , 0.000575505107775 , 0.00445552049974 , 0.000135179906363 , 0.00162033670294 , -0.00155428416898 , 0.00215648031229 , 0.00510879156712 , -0.000880075714758 , -0.00640125719539 , -0.000368292799886 , -0.00343480982492 , 7.52933462667e-05 , -0.0012341488604 , -0.00218885501317 , -0.0041531029691 , 0.00327786659002 , 0.00446519119584 , -0.000290804714515 , -0.0024049956528 , 0.00132566622497 , 0.00816223713997 , 0.00467999584469 , -5.72168485294e-05 , -0.000481137609788 , -0.00422705504263 , 0.000654023164181 , -0.00249502489138 , 0.00659255638418 , -0.000170727349374 , -0.00548564270993 , -0.000982722905605 , 0.00490473772744 , 0.0041969523672 , -0.00172745070629 , -0.00401643350304 , -0.00156425884467 , -0.000129150627822 , -0.000250416749803 , -0.00100943985844 , -0.00672419450167 , -0.00127587155829 , 0.00236662329027 , -0.00190869602969 , -0.00133693253038 , -0.000213617552845 , 0.000919068955308 , 0.00049053697724 , -0.00352031523168 , -0.00145809007678 , 0.00124366087518 , -0.000349503059239 , -0.00932343674995 , 0.00157702113741 , 0.0031965850601 , -0.000218553803185 , -0.00261245185848 , -0.00281767035247 , 0.00367592258279 , 0.00209971629176 , -0.000153105390004 , -0.00153889101277 , -0.00472358523478 , 0.00237223729761 , -0.00181288190632 , -0.000584233679228 , 0.00204728964544 , -0.000716008753889 , -0.000487524527206 , 0.000339516260497 , -0.0035880302078 , -0.00450712497812 , 0.00498598734342 , -0.00236726803588 , 0.00288220730052 , -7.09313701975e-05 , 0.00119530567616 , 0.00428107946949 , -0.000969372590991 , -0.00636753597746 , -0.00574923711365 , -0.00554122331874 , 0.00132897452183 , 0.0010587193267 , -0.00299633750415 , 0.000681905381956 , -0.00405170422284 , -0.00339924784525 , -0.000896380254579 , -0.00816266247925 , -0.0025145484652 , 0.00176892544945 , 0.00134975845886 , -0.00178263099554 , -0.00142948414949 , 0.00327254833179 , 0.00257404510043 , -0.00634081645204 , 0.00305340366181 , 0.00111245594922 , 0.0019532838619 , 0.000681762141568 , -0.00136365527382 , -0.000201059508477 , 0.00132307493027 , -0.000958393240493 , 0.00395744580533 , -0.00125064976366 , 0.0068468062341 , 0.000224789288665 , -0.0034112074021 , -0.000595745913152 , -0.00348322558539 , 0.00180719067269 , 6.2819171571e-05 , -1.98883910685e-05 , -0.000504317478926 , -0.00191266955558 , 0.0015076341945 , -0.000126633573341 , 0.000486691483667 , -0.00248034510966 , -0.00613932592169 , 5.00021637421e-05 , -0.00293104746637 , 0.000327585384488 , 0.00285995024063 , -0.000228013098369 , -0.00498663079672 , -0.00233012371708 , 0.000679769085757 , -0.00346109185971 , 0.00260144805898 , 0.0045128663948 , 0.00482345111376 , 0.00378774384039 , 7.82638849846e-05 , -0.00665181520002 , -0.00257324300624 , -0.00364045538295 , 0.000555254496587 , 0.00109052973215 , 0.00462982571178 , -0.000525486121415 , -0.00160567556588 , 0.00239804086587 , 0.00409318328029 , 0.00184585635607 , -0.00547367523384 , 0.000732866614281 , -0.00199118350385 , 0.00182975220004 , 0.00415952418843 , 0.000281947862556 , 0.001411736908 , 0.00350033046642 , 0.00307754077784 , 0.0029736587152 , 0.000737532080873 , 0.00349095757586 , -0.00446428449405 , 0.00244353544334 , 0.00119921962048 , 0.00607659751809 , 0.00251565287236 , 0.00445534730378 , 0.00275409034221 , -0.000925709243742 , 0.000735609654843 , 0.00233805436816 , 0.00211098815093 , -0.00548983139022 , 0.00161292256089 , 0.000230560950352 , 0.00356757589251 , 0.00273910007653 , 0.000671530699051 , -7.37891787523e-05 , 0.00354198348998 , 0.00596278369835 , -0.00132752287785 , 0.000861526387612 , -0.000917144472449 , -0.00027118646442 , 0.00435492308473 , 0.00638419124835 , 0.000654652456219 , -0.00053277546636 , 0.00260589337962 , -0.000477357892011 , -0.000184341381128 , 0.00165646131801 , 0.00282780471589 , 0.000395769537699 , -0.00287459375575 , -0.000510795252125 , 0.00151489305538 , -0.000388355805268 , 0.000109269808253 , -0.00318136790327 , 0.00165041284096 , -0.00423183678196 , -0.00584273220754 , -0.000553599695409 , -0.00364377458815 , 0.00550718085792 , 0.00208781527746 , -0.00526578705169 , 0.00185042295248 , -0.00250326494051 , 0.00128951891483 , 0.00582919834017 , 0.00324515770653 , -0.00409574826214 , 0.00582216333604 , -0.000328970307574 , -1.01212694864e-05 , 0.0010089302662 , -0.00191339038614 , 0.00204546097648 , 0.00114617979102 , -0.00319719112493 , 0.00100292934711 , -0.0011854843381 , 0.00207284847987 , 0.00207619107207 , -0.00326119360217 , 0.000585896890381 , -0.000211063883559 , -0.000408256169803 , 1.18313911908e-05 , 0.00104985630497 , -0.00387641590053 , -0.00345473441171 , 0.000790338031867 , 0.00054799853687 , 0.00247220013633 , -0.00340254476892 , -0.00329483784617 , -0.00216858134971 , -1.14245539921e-05 , -0.00157429121516 , 0.0044691398147 , 0.00309678992004 , 0.00490456533256 , -0.00171944691726 , 0.000215650660442 , 0.00524087635615 , -0.00646190309515 , 0.0012067196823 , -0.00462994562355 , 0.000451591323696 , 0.0051701431272 , -2.66371076433e-05 , -0.00381463277909 , -0.00310436587985 , 0.00156686124878 , 0.0022572624888 , 0.00403786143136 , -0.000411408266148 , -0.00273959441838 , -0.00241366140735 , -0.00190713162164 , 0.000791165586803 , 0.00377672794689 , 0.00282966421943 , -0.00220209075919 , 0.00320614413814 , -0.00220356731602 , -0.000490614557693 , 0.000205486544406 , -6.03209542942e-05 , -0.00122037199451 , -0.00420031301171 , -0.00493026139285 , 0.000221837090754 , -0.000454509225222 , 0.00285950238714 , 0.000224126398339 , -0.00589156425271 , 0.000744945706061 , -0.000450659183265 , -0.0016320219532 , -0.00292207075486 , -0.00485882917194 , -0.000708475331153 , 0.00361706418179 , 0.00469604398228 , 0.00428597316704 , 0.000480583060079 , 0.00288459418954 , -0.00263309596996 , -0.00113844058065 , -5.34903874531e-05 , 0.00542344149526 , 2.61233268032e-05 , 0.000722870611864 , 0.00157802910524 , 0.00170722615251 , 9.33184326402e-05 , 0.000635992518601 , 0.000418560772728 , -0.000645116852563 , -0.000212414164221 , 0.00177149843717 , 0.00686154875703 , -0.000558533731886 , -0.000484371319889 , 0.000924174827015 , -0.00119772079645 , -0.00207381888876 , 0.00168915049102 , -0.000868890262733 , -0.00154032911515 , -0.00261845018379 , -0.00130418113849 , 0.000577073521161 , -0.000257091038889 , -3.73814149528e-05 , 0.000378399035229 , -0.00120556343776 , 0.00120748303297 , -0.000465918522775 , 0.000522102412378 , -0.00137442830526 , 0.00026678543054 , 0.00247447637884 , -0.00388301602277 , 0.00310371529932 , -0.000522496883493 , 0.0070461217912 , 0.00331497205 , 1.08290322891e-05 , 0.000706073465829 , -6.57406506046e-05 , 0.0044564634782 , 0.00125759225688 , -0.00359069767807 , 0.00133969240654 , 0.000220933413853 , -0.00675210922935 , -0.000376013390729 , 0.00268502493605 , -0.00408928535735 , 0.002041465523 , -0.0007842567215 , -0.0020459620931 , 0.00252281563615 , -0.00349561144358 , -0.000524886477443 , -0.00125707716316 , -0.00350240303064 , -0.00773423659863 , -0.000401006682203 , -0.00123431627055 , 0.00125492336697 , 0.000820669550018 , -0.00148820490759 , -0.00160577656839 , -0.00200683048188 , -0.000948094180961 , 0.00182353240313 , -0.000449977495612 , 0.000554954809063 , -0.00537970701345 , -0.00216794471534 , -0.00538886634403 , 0.00355022043839 , 0.00230461574717 , 0.00170472274195 , -0.003267069988 , -0.000643798938278 , 0.000594266229603 , -0.00252600392036 , -0.000793115057578 , -1.89048526548e-05 , -0.00144267283011 , -0.000380293629256 , -0.00488228541195 , 0.000286945624508 , -0.00314974595652 , 0.00296558227969 , 0.00159141245724 , 0.00281617758553 , 0.00310016293636 , -0.000332891715554 , -0.00842951368153 , 0.00337050579946 , -0.00303770481592 , -0.00324529843299 , 0.00549323956124 , -0.00169017617997 , 0.00261734272647 , -0.00298868630646 , 0.00119868389613 , -0.00213794068283 , -0.000896991419336 , 0.005642926323 , 0.00145911462946 , 0.0012666255615 , -0.00482383418782 , 0.0027508714044 , -0.00244997187019 , 0.00114370945304 , -0.000484161027836 , -0.00247073962314 , 0.001172362268 , -0.00379043982963 , -0.00496505088722 , -0.00187226247409 , -0.00106821117627 , 0.00206996471887 , 0.00124447686677 , -0.00118561918423 , -0.00144258309206 , -0.000239316482179 , -0.00354371683728 , 0.00112295062367 , -0.00481116475928 , -0.00145566724842 , 0.00201008922437 , -1.48928088654e-06 , 0.0028686930185 , 0.000921401907501 , 0.000525393152147 , 0.00282093595206 , 3.44407441284e-05 , 0.00586559711505 , 0.00380577875652 , 0.00271117717667 , 0.00074025572137 , -0.000120875607753 , 0.0021916994658 , -0.0022815471841 , 0.00230170472538 , 0.00532540354604 , 0.00329219930808 , -0.00549063541405 , -0.00196719613293 , -0.000232630278217 , 0.00336883533437 , -0.00211098837383 , 0.00182130835131 , 0.00224412252079 , 0.00329186466213 , -2.36253262423e-06 , 0.000194484911646 , 0.000493146036495 , 0.000206286809071 , 0.00926722590412 , -0.000291687109163 , -0.00258058565623 , -0.00326907563433 , -0.000412751474716 , 0.000983133104906 , -0.00544220963192 , -0.00418829678004 , -0.00143280728254 , 0.00320095660802 , -0.0016838862142 , -0.00616044348424 , 0.00388817625811 , 4.28623354369e-06 , -0.0056001118312 , -0.00172126503727 , -0.000726738300387 , 0.00297493484295 , -0.00381794349258 , 0.00412252023521 , 0.00334582718372 , 0.00347839858756 , -0.000259598333886 , -0.00335864315804 , -0.000542996109905 , 0.000638166726695 , -0.00190354507843 , 0.000889106126415 , 0.00029160225214 , 0.0066508752604 , 0.00046964018868 , 0.00506514506295 , -0.0027116286827 , 0.00266060673822 , 0.00354229094503 , 0.000567822494893 , 0.00525562746441 , 0.000153984747288 , 0.00126133183758 , 0.00101789871363 , 0.00186704297514 , -0.00352054728799 , 0.00255130992302 , 0.00182023293786 , -0.00371897701801 , 0.00207885991504 , -0.00176791717947 , 0.000219385908182 , 0.00308177930525 , -0.00267789976846 , 0.000714117348469 , 0.00537058215656 , -0.00101999145238 , -3.72891528389e-05 , 0.00106567372006 , -0.00480806979051 , -0.00439762754602 , -0.00488670054226 , 0.000970632892596 , 0.000174947366644 , -0.00177041441267 , -0.00176579134938 , -0.00280644453329 , -0.00247791964409 , -0.00273759088001 , -9.92900906714e-05 , -0.000233765181478 , 0.00142264406988 , 0.00114296322312 , 0.00543856702296 , 0.00159530513792 , -0.00445359483017 , 0.00568184572114 , 0.000629677731433 , -0.00200201952002 , 0.00200035196885 , 0.000222220150811 , -0.00626190913942 , 0.000914989725096 , -0.0017282993861 , -0.00163720597156 , -0.00160257314976 , -0.00028268298163 , -0.00153505868147 , -0.00087404937138 , -0.00173983696756 , -0.0033913935606 , 0.00299702083379 , 0.00239075718839 , -0.00217962090925 , -0.000858757396136 , -0.00318023913007 , 0.00171602644789 , 0.00267706839807 , 0.00589216169649 , 0.000144260130527 , 0.00121572916249 , 6.20700097409e-05 , -9.06745326964e-05 , -0.00077006795677 , -0.00469605507961 , -0.000930929889112 , 0.00268896585 , 0.00730802075069 , -0.000407485754543 , 0.00759935887906 , -0.000177928132589 , 0.00151393168079 , -0.00352348189428 , -0.000997518071924 , 0.00480582201175 , 0.000374611625856 , -0.00311939225698 , -0.00342839712337 , -0.00329156832369 , -0.00248918015802 , 0.00045866049068 , -0.000245424612767 , -0.00210552255623 , -0.00165662944119 , 0.00046380077072 , 0.00685626311402 , 0.000572619544886 , 0.00382573693171 , 0.00109586819546 , -0.000867198587605 , -0.000290581839894 , -0.00219688860785 , 0.000989102537063 , 0.0043852027018 , 0.000772025551119 , -0.00111334018525 , -0.00142812736707 , -0.000139031960237 , 0.00154475553218 , -7.04219845065e-05 , 0.000144811990532 , 0.00428547800491 , 0.00238063514968 , -0.00381547403953 , -0.00399091708268 , -0.00409058358577 , -0.00333628279949 , -0.00481178842528 , ])
Y_4_2_imag = flex.double( [ 0.0 , -0.0 , -0.00165048949266 , -0.00550921762066 , -0.00103752742351 , 0.00356671307875 , 0.0043059519844 , -0.000512383186607 , 0.00526188404067 , 0.00228044397732 , 0.000791049771748 , 0.0020074119495 , 0.00391566571227 , 0.00195928534196 , -0.00317021638012 , 0.00176535646514 , 0.000517437855716 , -0.00417634084081 , 0.000905108415422 , 0.000726423901535 , 0.000949036079275 , -0.0023086075465 , 0.00289272803873 , -0.000598028321439 , -0.00351111878193 , 0.00537429971808 , -0.000541606662892 , -0.000218755580281 , 0.0010736478562 , 0.00122358647465 , 0.00440430416595 , 0.000199400444604 , 0.000418420839485 , -0.0017027144272 , 0.00202837434785 , -9.38261417797e-05 , -0.000773722444175 , 0.000334270792927 , 0.0010691082392 , 0.00121548257469 , 0.00365889066866 , 4.77482834045e-05 , -0.0021025760424 , -0.000703160717145 , 6.80955401455e-05 , 0.000145617639055 , -0.000267376585331 , 0.000668032200979 , 3.91511723328e-06 , -0.00269966592675 , 1.57197929349e-05 , 0.00050460588955 , -8.58274150535e-05 , -0.00100209992072 , 0.000608449224878 , -0.000104053899178 , 0.00199550557363 , 0.00452456855903 , 0.00294346387889 , -0.00444712133791 , -0.00126951022566 , 0.00385615518854 , -0.00321436743866 , -0.00189950680145 , 0.0076836882949 , 0.00320444241663 , -0.000603457654873 , 0.00312818607647 , -0.000883306694908 , 0.000805019725056 , -0.000813768283848 , 0.00286943128501 , 0.00151790644784 , 0.00585235777256 , -0.000353424748236 , 0.00431660013302 , -0.000317355543507 , -0.000689892235148 , -6.79658841342e-06 , 0.00430642248802 , 0.00562700815467 , 0.00241027271653 , -0.00018423258886 , 2.28355677856e-05 , 0.00482307077437 , 7.1002361576e-05 , -0.000739827240951 , 0.001431385312 , 0.000456783155543 , -0.00456140174072 , -0.00348821575968 , -0.00453719510433 , 0.00453468619896 , -0.000732184143218 , -0.00413845739272 , 0.000984614181733 , -0.00260677126626 , 0.00331962999255 , 0.000411237771052 , -0.00441544910903 , -0.000697025619686 , 0.000184785523642 , -0.00186676706642 , 0.000500252659159 , -0.00399085969928 , -0.00242996750049 , -0.000691139140768 , -0.00120832717594 , 0.00322163913644 , -0.00116689125112 , 0.00383796952779 , -0.00267546817222 , 0.00417017426201 , -0.00139705900254 , 0.00211622968951 , -0.00294825223459 , -0.0001780183963 , 0.000978189657716 , 0.00232584888987 , 0.00282614807628 , -0.000290034573967 , -0.000189231439947 , -0.00421280610299 , 0.0010433315558 , 0.00411210662917 , -0.00313448247031 , 0.00256235072939 , -0.00207435061449 , -0.00426944559472 , -0.00060885321748 , -0.00416019932157 , -1.73660604729e-05 , -0.000239253779674 , -0.000771192452965 , -0.000203859804874 , 0.00073112090529 , -0.00317310927494 , -0.0028882044084 , -0.000550347793434 , 0.00173712739752 , 0.00446226989844 , 0.00224095650991 , 0.00221554195689 , -0.00549859714578 , -0.00267751252738 , 0.00021813920678 , 0.000687005710275 , 0.00215699573089 , 0.00058753845115 , 0.000600051792731 , 0.00184670928151 , -0.00180010838718 , 0.00178236653567 , -0.000631093119217 , 0.00259936958319 , -0.0013882117243 , 0.000808590316883 , -0.00490399139581 , 0.00349694170938 , -0.00027150482787 , -0.00128564997101 , 0.000998785415264 , -0.00039034456793 , 0.00425860122923 , -0.00288579145048 , -0.00200670368741 , 0.00536307675321 , 0.00350351617587 , 0.000614416081127 , 0.00217842618272 , -0.00167931357202 , 1.67777063529e-05 , 0.00208758791116 , -0.000623990556504 , 0.00282462325032 , 0.0012090589993 , 0.000569078400348 , 0.00225914217606 , 0.000462777702113 , -0.000945099778203 , 0.00332203245575 , 0.00106147126361 , -0.000748014674684 , 0.00117957403076 , 0.000749952471478 , -0.00200312463927 , -0.00249868836875 , -0.00433632153793 , 0.00289669511216 , 0.00160983494082 , 0.00191709697107 , 0.00208946157093 , 0.000132093827805 , -0.000246912965253 , 0.00529195397994 , 0.00406391186265 , 0.00064341646519 , 0.00451679463018 , -0.00245683795735 , -0.00108309224962 , 0.000223023541345 , 0.0059000318246 , 0.00277974616123 , 0.000609748878415 , -0.00191335436349 , -0.00164387728411 , 3.96253932435e-05 , 0.00263537085227 , 0.00322454420255 , 0.00193863929611 , 0.00480228563329 , -0.000869349466684 , -0.00087813345346 , 0.000403710368769 , 0.00139183576702 , 0.000849729848314 , -0.000153989732419 , 0.00118265418287 , 0.000747131907058 , -0.000768645405948 , -0.00209534130866 , -0.00551714297733 , -0.00758288534868 , 0.00373142492829 , -0.000545111475474 , 2.24246861783e-05 , 9.63517958671e-05 , 0.00727362047069 , 0.00100690225752 , -0.00209925505548 , 0.000208023143881 , 0.00160688705369 , -0.00498106602712 , -0.00107520438714 , -0.000216606514866 , 0.000922665001499 , -0.00118510748062 , 0.00375551768373 , 0.00115747111815 , -0.00431117584494 , 0.00110716245467 , -0.00435178228833 , 0.00255541255381 , 0.00167237164274 , 0.000166202767586 , -0.000341765357424 , -0.00342821567887 , 0.00628095901166 , -0.000669433465113 , 0.00300124580181 , -2.86520818938e-05 , -2.00054704724e-05 , 0.00460860668654 , -0.00166995682829 , 0.0036449953558 , 0.000294371398805 , 0.000336292498762 , -0.00105276021347 , -0.000540020643563 , 0.00271609173593 , 0.00348365650901 , -0.00291250647219 , -0.000276953214442 , -0.000143126047182 , -0.000849321661092 , 0.00171651500412 , 0.006542851483 , -0.00201683114395 , 0.00664163278352 , -0.00114406193606 , -0.00205232577169 , -0.000477259866604 , -0.000682878030124 , 7.27213237586e-05 , -0.00671786487292 , -0.00209273338901 , -0.00563418842402 , 0.00152274457595 , 0.00348395412325 , 0.00113972705914 , -0.00249465241965 , -0.00537139435105 , 0.000909940667469 , 0.00506844202727 , -0.00256434227449 , 0.00513478908068 , 0.00635452590027 , -0.00304589464583 , -0.00262984356885 , -0.00118539948985 , -0.00227128430072 , -0.00456972227643 , 0.00465343380837 , -0.000739994838893 , 0.000252710631429 , -0.00175922792364 , 0.00786583838916 , 0.00422966162688 , -0.00173160914474 , -0.000173813371183 , 0.000200255239769 , -0.000121232148757 , -0.00227043785542 , -0.00236512575688 , -0.00538275997924 , -0.00476279215872 , -0.00387204209022 , 0.00510887724032 , -0.000431655209601 , 0.000905414676066 , -4.56743542603e-05 , -0.00198420648254 , 0.000989528370901 , 0.00145776700357 , 0.00248640915089 , -6.32465249603e-05 , -0.00151557426375 , -0.000243263000269 , 0.00399429863708 , 0.000318480270199 , 0.000267757719884 , 0.000898378851227 , -0.00632585350124 , -0.00139785373416 , 0.0030106489582 , 0.00321329733388 , -0.00292404923505 , 0.000467728272768 , -0.00552734692777 , 0.00615276352806 , 0.000236044064206 , -0.00107160934372 , -0.00369933763621 , 0.00391193453077 , -0.00276110081054 , -0.00104586537674 , -0.000223305877723 , -0.000229049386285 , 0.00567474823651 , -0.00397298235612 , 0.000378142094678 , 0.00302598368883 , -0.00509422095337 , 0.003934588037 , 0.00146411009421 , 0.000386286977962 , 0.000914792242656 , 0.00200308625469 , 0.001269229683 , -0.00954391296497 , -0.000334588528878 , -0.000989651745455 , -0.000543111556857 , -0.00334857349696 , 0.0016411893413 , 0.00274468576781 , -0.00288224165138 , -0.000842701170245 , 0.00394808249945 , -0.00503219498898 , 0.00378145957539 , 0.00145516633638 , 0.000170624486033 , 0.00136180012231 , 0.00269565618278 , -0.00600526348441 , 0.0029376627654 , 8.37808474506e-05 , 0.00425450013674 , 0.00209657639429 , 0.00276794710106 , 0.00436092520179 , -0.00023425660637 , -0.00321107137768 , 0.000613135690415 , 0.000560185738878 , -0.000223802726916 , 0.00505451534807 , -0.000624603202686 , 0.00207938641277 , -0.00124645137272 , 0.000206080546438 , 0.000353024701291 , 0.00134112687787 , -0.00681992521905 , -0.00194047820639 , 0.00371298445623 , -0.00248173207204 , 0.000552025382167 , 0.00499135762093 , -6.61899340631e-05 , -0.00112478609113 , -0.00616490039215 , -0.00180016004783 , 0.00830494366251 , -0.00182639054176 , -0.00116431952695 , 0.0054846044815 , 0.00264099202345 , 0.00174478714451 , -0.00203853232196 , 0.00275834193859 , -1.44923918899e-05 , -0.00384812291024 , -0.000765066444839 , -0.00564922434725 , 0.000729168434003 , 0.00291106644434 , -0.00254510138891 , -0.000618297824178 , -0.00368400056424 , 0.00100529624489 , 0.000512758766508 , 0.000340342132343 , -0.0051427750137 , 5.39158260549e-05 , -0.00451625712665 , 0.00227965470436 , -0.00374377987428 , 0.000813204295674 , 0.00369827280733 , 0.00191493048037 , 0.00179273731117 , -0.000373043472911 , -0.000178724866028 , 8.01709676916e-05 , -0.00736920937508 , -0.00124004766282 , -0.0068861212233 , -0.00318329728813 , 0.00141713215161 , 0.00222056333346 , 0.000638746435622 , 0.00248663023045 , -0.00104098680012 , 0.00104735600161 , -0.00182614196246 , 0.000481672291314 , 0.00367667329627 , 0.00163270388179 , -0.00254895275054 , -0.00161349102371 , -0.00184868569684 , -0.00344132665629 , -0.00362047579536 , -0.00116655043588 , 0.000796802877891 , -0.00114538387087 , 0.000753664081704 , 0.000382195887482 , 0.00355638470591 , 0.00101109733179 , -0.00114396815453 , 0.00117454752024 , -0.00359436217462 , 0.0022590005796 , 0.00717615923469 , -0.00577599814227 , -0.00154777674636 , 0.00455449212496 , -0.00459191257486 , -0.00366165345865 , -0.00680283682901 , 0.0057773259707 , 7.30910288703e-05 , 0.00145558410661 , 9.57327530571e-05 , 0.0018684426876 , -0.00336149557871 , 0.000467426172267 , -0.00244304265719 , -0.00443169981765 , 0.000435297810452 , 0.00323141724318 , 9.54853674562e-05 , 0.00613035812784 , -0.00257926103428 , -0.00353808381419 , 0.00257749696287 , -0.00346062573068 , 0.00332752062949 , -0.00080360793446 , -0.00346194361777 , 0.00313068420306 , -0.000443565163099 , 0.0013421988508 , 0.0045297448735 , 0.00147407908732 , -0.00260902765469 , -0.00489733604697 , 0.000271468483354 , 0.00194109513828 , -0.00327353360099 , 0.00271721111559 , 0.000980468391887 , 0.00774735197978 , 0.0014508299692 , -0.00464100784127 , -0.000785207559675 , 0.00215056221589 , -0.00611471520195 , -0.00422710282663 , -0.00550198039266 , 0.000610719321764 , -7.80813459207e-05 , -7.4010220558e-06 , -0.000810593056123 , 0.000790524656873 , 0.0013456418744 , -0.00130758726916 , -0.00313755448008 , -0.00453091887114 , 0.000403035885186 , 0.000743825636646 , -0.0026523855338 , 0.00425502655323 , -0.00389921546571 , -0.00272225158566 , 0.00398069295693 , -0.00406632967709 , -0.00319550858293 , -0.0036246804423 , -0.00170833416678 , -0.000845537534017 , -0.00153770031949 , 0.00104902635299 , 0.00604776019179 , -0.00164343837437 , -0.00449356451388 , 0.000125319663222 , 9.43346030962e-05 , 0.00178177709416 , 0.000381131326478 , -0.00100268932821 , -0.000649297401899 , 0.00595621729009 , 0.00130432333864 , -0.00343470653531 , 0.00209878436439 , 0.00166127149287 , -0.003912060926 , -0.0012882847437 , 0.000876119014267 , 0.00164348276093 , -0.000416181585899 , -0.00324352287118 , 0.00221006801395 , 4.40979763737e-05 , 0.000359243235073 , -0.00286188916382 , 0.00201169646535 , -0.00412705192181 , -0.000512034925754 , -0.000266606305948 , -0.00142040243252 , -0.000176521799792 , 0.000913061777244 , -0.00374091766034 , 0.00429085359401 , -0.00348488262462 , 0.00144470877365 , -0.000912644238046 , -0.000540371761585 , -0.00125048137115 , -0.00318758012805 , 0.00217003715261 , -0.0028211845277 , 0.00319795867333 , 0.000703285958432 , -0.00305420279993 , -0.00264051089318 , -0.00217344410399 , -0.00290905060485 , 0.00293583556475 , -0.00271404293333 , -0.000962653270104 , 0.00185969788591 , 0.000432770167347 , 0.000109097401507 , 0.00490883239585 , 0.000465784369009 , -0.00451710638491 , 0.00586751154414 , -0.000352376844529 , -0.00145530610929 , -0.000505933758215 , 0.00662489648905 , 0.000781252025726 , 0.00371563543368 , 0.000381414271367 , 0.000777969632061 , -0.00574831141211 , -1.45960523114e-05 , 0.00235995356799 , -0.00148793448376 , 0.000707399276285 , 0.000184666164433 , 0.00101748580489 , 9.81712995996e-05 , -0.00408383418749 , 0.00158108635271 , -0.00124624356451 , -0.000101954645572 , 0.0042316359138 , -0.000202909069239 , -0.00251920406927 , -0.00353297149001 , -0.00393330329501 , 0.00205708924506 , -0.00352889433575 , 0.000694374054997 , -0.00338228787621 , -0.000149456620415 , 0.00275149843419 , 0.00337307793026 , -0.00106777743274 , 0.00312839205229 , 0.000653682420808 , -0.00165287989566 , -0.00209620033139 , 0.00748440416701 , -0.0017944405773 , -0.00737933089547 , -0.0043754238178 , 0.00197444601703 , -0.000370194000605 , 0.00258444306404 , 0.000781009095862 , 0.000249804688152 , -6.12497354423e-05 , -0.000366252339472 , -0.00381842700662 , 0.00144529973239 , 0.000724148871692 , -0.00469853917559 , 0.00269157050611 , -0.00212623660162 , 0.00346577116793 , -0.000572632974096 , -0.00153360909488 , 0.006871694003 , -0.00338335350037 , -0.0014715162389 , -0.000763551766488 , -0.00236698367664 , -0.00456470401103 , -0.000234567413965 , 0.00417918565543 , -0.000738341901514 , 0.00230412035331 , 0.00257834944147 , -0.00181979082073 , 0.00269801340084 , -0.00287902623201 , 0.00297227652571 , -0.00314523520243 , -0.00225121881279 , -0.00404324591409 , -0.00178552617522 , 0.00173934305699 , 0.00105441965836 , -0.000436443668436 , -0.00363789490976 , -0.0044842546136 , -0.00273754544045 , 0.000424552143468 , 0.00337685880928 , 0.00229205510177 , -0.0018820472048 , -0.00506390988221 , -0.00500306502873 , -0.000614373718944 , 0.000194701864983 , 0.000870574999206 , 0.00238266100355 , 0.00155196507227 , -0.00649041999027 , -6.76079912474e-05 , 0.00208888321799 , 7.79410250575e-05 , 0.00234994660441 , 0.00350480206696 , 0.000731153927171 , 0.00191137484662 , 0.000749955227113 , 0.00351883510499 , -0.00047400875077 , -0.00171655092216 , 0.00500221361154 , 0.00234373785747 , 0.00601669100332 , 0.00104939309983 , -0.000126421247798 , -0.00017810097864 , -0.002679393865 , -0.00238076397973 , 0.00027368126165 , 0.0014717425496 , 0.00528604811927 , -0.00125256826475 , 0.00148714130595 , 0.00111332901009 , -0.00132613161695 , -0.000650806650067 , -0.000977513915801 , -0.0011838029825 , 0.00178792288718 , -0.00921873907544 , -0.00299578766609 , -0.00814226541772 , 0.00320719786116 , 0.00111840412666 , -0.0019721153746 , -0.000419109159679 , 0.00207797117306 , -0.00297715963494 , 0.00443317613985 , -0.00139072495695 , -0.0033221928229 , -0.0055986190897 , 0.00367639157052 , 0.00080579545865 , 1.56591562395e-05 , 0.00149377930788 , 0.00374967937571 , -0.00212358032044 , -0.0028377453311 , -0.00189752422271 , -0.000223676981719 , -0.00319757862457 , 0.00219667823296 , -0.0021928144272 , 0.00203076035383 , -0.000130491348987 , 0.00176240904156 , -0.002945682182 , 0.00511160879263 , -0.000970574731689 , -0.000764066076141 , 0.00923017936366 , -0.0029012627718 , -0.00198998370255 , -0.00125073625036 , -0.00152633111302 , 0.000379242270043 , -0.00272725651473 , -0.00142067384256 , 0.00718916940956 , 0.00333545030354 , 0.00147058900098 , 0.000661855274876 , 0.00345682071776 , -0.00290182666757 , 0.0007179615543 , -0.000293494454098 , 0.00172660082903 , -0.000712713482475 , 0.000509504080932 , -0.00216942786099 , -0.000217397252963 , 0.000648418170765 , -0.00187494353609 , -0.00210123606582 , 0.00232199600112 , -0.001130517945 , 0.00405124847691 , -0.00303164238305 , 0.00157122585894 , -0.00212099120105 , -9.32670574018e-05 , 0.00548106335315 , -0.00444446185853 , -0.000801597623938 , -0.000252244461596 , 0.00324782499304 , 0.00123240279318 , -0.00451727922919 , -0.00491395709976 , -0.00156777151689 , 6.61293772783e-05 , -0.000267884473717 , -0.000831387005582 , -0.00641320027766 , -0.000356204503319 , 0.000269274329554 , 0.00391376172422 , -0.00243052555743 , -0.00266383373486 , 0.00637577925125 , -1.39996745381e-05 , 0.000264973171309 , -0.00189976073769 , 0.00319488215613 , 0.00463092039032 , 0.00250477283917 , 0.0023292044055 , 0.00400935753744 , 0.00230180051769 , -0.00329296602542 , -0.00314736057986 , -0.00250107265371 , -0.00095683294826 , -0.00326693673875 , 0.00338736016987 , 0.0027315607107 , 0.000987216274942 , 0.000689966309206 , -5.1322080561e-05 , -0.00118959673685 , -0.000159747050972 , -0.000913644613065 , -0.00467698283589 , 0.00565091212532 , 0.00560219882985 , -0.00258738817766 , -0.00113672746289 , -0.00229724352358 , -0.00358551758628 , -0.0035574510418 , 0.0038379144588 , 0.00222838598009 , -0.00730559243512 , -0.00279491158145 , -0.00455584505196 , -0.00176836280493 , 0.00124382435489 , -0.0005007876007 , 0.00522183283758 , -0.00234878540876 , -0.00073092310039 , 0.00602794628432 , 0.00179105780027 , -0.000141617083006 , 0.00258322999833 , 0.0024273716521 , 0.00232527790757 , 0.00234389471314 , -0.000201247154059 , -0.000387057010919 , -0.000919512300567 , -0.000318254916523 , -0.00352853910127 , -0.00221392107764 , -0.00704052968941 , 0.000704021142213 , 5.61658776243e-05 , -7.98457295836e-05 , -0.000185134334155 , 0.00316564793414 , 0.00600938676581 , -0.00225591417266 , 0.000932214673195 , 0.00442336222743 , 0.00072060474145 , 0.000549177890341 , 0.000254020230151 , -0.000114992863072 , -0.00447237630605 , -0.0022345571478 , -0.00288127257462 , -0.00392728128732 , 0.000459908816596 , -0.0001977433737 , -0.00478836399691 , -0.000806936001798 , -0.00382941832849 , -0.00478606722286 , -0.00220109140288 , -0.000725122472136 , -0.00383661244724 , 0.00390699099458 , -0.00489526369393 , 0.000174347971822 , 0.00092722778209 , 0.00105209223743 , -0.00502073476769 , 0.00177387585923 , -3.03171376182e-05 , 0.000449435898028 , 0.00065230216256 , 0.00353037088492 , -0.00162191444539 , -0.00159956498853 , 0.0018546911013 , -0.00222053678474 , 0.0026366554975 , -0.00411099733308 , 0.00181592355169 , 0.00637690684128 , -0.000957372849045 , 0.00174857018025 , -0.00295372748815 , -0.00130939431542 , 0.002862961048 , 0.00280238426266 , -0.00175689006484 , -0.000851618153851 , -0.00135703970978 , 0.00252058053027 , 0.00082002834254 , ])
Y_4_3_real = flex.double( [ -0.0 , 0.00172175876896 , 0.000808985198943 , -5.27828706019e-06 , 0.00537059602424 , -0.00508691347016 , -5.94286768152e-05 , 0.0037663799405 , -0.000123115689861 , 0.00137243691236 , -0.00486948055974 , 0.000784426269765 , 0.0013594485121 , 0.0012477088094 , -0.000350679454568 , -0.00097577759331 , -0.00505856913042 , 0.00126647564148 , 0.00153953024119 , -0.000434347661943 , -0.002736964017 , -0.000316038956585 , -0.000666310827422 , 0.00584972340219 , -0.0017473721071 , 0.00266132651855 , 0.00390425797743 , 0.000698016221028 , -0.00136979496653 , 6.34278095148e-05 , -0.00102466856373 , 0.00153771098145 , -1.13344496388e-06 , -0.00174034291747 , -0.00133791278164 , 0.00442151822737 , 0.00279956454574 , -0.000128346667317 , 0.000884621959123 , -0.000923916527077 , 1.02329724703e-05 , 0.00414063333334 , -0.00156759800053 , 0.00465981062765 , -0.0042712877306 , 0.00154980061918 , -0.005079277406 , -0.00378013823528 , 0.000387557490366 , -0.000930668524112 , 1.71110394159e-05 , -0.00475208318964 , 0.00693324801199 , 5.12170864921e-06 , 0.00603187325939 , -6.41902600036e-05 , -0.000274881489156 , -0.00201226674441 , -0.00270830589853 , 0.000368489116194 , -0.0016525096054 , -4.00849326758e-05 , 0.000436887224818 , 0.00354577042571 , -0.00362137722276 , 0.000148852906555 , -0.00104211026342 , 0.00403368294881 , -0.00191616493835 , 0.00243884457918 , 0.00463467521919 , 0.00108980038008 , 0.000867719602779 , -0.0026837737966 , -7.33440031568e-05 , 0.000165192015608 , -0.00233983193907 , 0.0029917208675 , -2.85875685793e-06 , 0.00169131138738 , -0.00132631763235 , 0.00471003314497 , -0.00542724599953 , -0.00382029964716 , -0.000594774967684 , 0.000839879485372 , 0.000184358265842 , -0.00254695339707 , -0.00129452589793 , 0.000666753389652 , -0.0016654956186 , 0.0017121533372 , -0.00351839925301 , 0.000644114395483 , -0.00344617664736 , 0.00384017283922 , -0.000775838666265 , -0.00146056351077 , -0.003344762791 , 0.00105519637495 , -0.0040269033852 , 0.00294554256546 , 0.00313036312284 , -0.000395980987915 , 0.000134226590912 , 0.00456283700906 , 0.00173533734429 , -0.000786024953628 , 0.00692360254514 , 0.000142286411224 , -0.000559431606819 , -0.000545482366863 , 0.00107102078385 , 0.000346316830454 , -7.76185257528e-05 , -0.00332468863988 , 0.00550500894268 , -0.00308936896757 , -0.00335327005488 , 0.00287815346778 , 0.00358253904662 , -0.000125892883081 , -0.00243633274265 , -0.00212354387714 , 0.00210446867299 , -0.000171907626202 , 0.00192495170839 , -0.000440468576092 , -0.00277010478363 , 0.00095233242228 , -0.00197243909904 , 0.00593966542084 , 7.91369794295e-05 , -0.000561177796458 , -8.10694468027e-05 , -0.00463661625067 , -0.00281766351331 , 0.000374463088973 , -0.00590512471151 , 0.00313286738629 , -0.00247617802822 , 0.0014122850501 , 0.000162357950853 , 0.000755288081786 , -4.97371227653e-05 , 0.00569689830592 , -0.00130128684815 , -0.000206445507195 , -0.00243274733736 , 0.0040616095761 , 0.000872186997922 , -0.00112503804466 , -0.0014867072902 , -0.00083741564844 , -0.000405051118722 , 0.00391864523113 , -0.0023937897568 , 0.0043130332194 , -0.00287684616422 , -0.00169203471735 , 0.00362681508546 , -0.000198526116236 , 0.000533902993061 , -0.000138088661236 , 0.000121517018886 , 0.00572662881826 , 0.000734662057337 , -0.00230572957292 , -0.00679351518906 , 0.00120083470579 , 0.00431299008651 , -1.89782367295e-05 , 0.00469789675788 , -0.00228630773259 , 0.00133061306385 , 0.00193234347186 , -0.0049197337579 , -0.00456878720967 , -0.00101700310615 , -0.000422299228825 , -0.000311813599205 , 0.00385547832891 , -0.00653592303324 , 0.00346071137371 , -0.000105073590729 , 0.000537672560296 , -0.00253851728828 , 0.00633573067475 , -0.00484438168849 , 0.000346036776525 , 0.00405762827332 , 0.00165000722791 , -0.000128321823869 , -0.00465908496945 , -0.00318279120424 , 0.00382541171971 , -3.88216449553e-05 , 0.00282357145562 , 0.00241923576053 , -0.00381751565628 , -0.00182722096718 , 0.0034744000123 , -0.00215662889601 , 0.00330983103317 , -0.00145091969294 , 0.000481963445777 , -0.00093179180847 , 0.00322979756085 , 0.00396550401782 , 0.00564416804145 , -0.000315623319516 , 0.000475010245908 , -8.98994695816e-05 , 0.00360352894413 , 7.26095232252e-05 , -0.00606277311406 , -0.00291782759635 , 0.00192268584348 , -0.00196081339359 , -0.00482860445155 , 0.00198711698046 , 0.00141516625965 , 0.00311465956693 , -0.000372634324949 , -0.00560025999325 , 0.000540270729866 , 0.00381458770651 , 0.00273665936093 , -0.000466110148937 , 0.00359831494266 , -0.00616729714042 , 0.00450949506774 , -0.00138855500667 , -0.00123505546912 , -0.00202301205988 , -0.000640300078062 , -0.000940359464251 , 0.00540160230926 , -0.00136967513328 , 0.00220023181535 , -0.00344671561888 , 0.000551426250605 , -0.00639921898511 , -0.0018264966501 , 0.00197030075428 , 0.000223529645282 , -0.00366385867711 , 0.00469433931195 , -0.00119782424181 , 0.00110492271964 , -0.00178740466827 , 0.000138586316676 , 0.000444837421144 , 0.00114054277463 , 0.000813776344522 , -0.00448263985488 , 0.00174456928333 , 0.000207749875463 , 0.00254109107388 , 0.00363961060678 , 0.00244203304575 , -0.00062790566493 , 0.00166001906066 , 0.00542925546465 , 0.00384329052077 , 0.00291908022072 , 0.00343590804611 , -0.0014955384398 , 0.00431828865737 , 0.00351704311321 , -0.000746048339756 , 0.000719347049065 , -0.0012605516404 , 0.00473080829674 , 0.00732342741717 , -0.000982322288535 , -0.000786275888487 , -0.000132775595303 , 0.00167784004872 , 0.00317546663145 , 0.00693229520462 , -0.00474202502102 , 0.00452578586563 , -0.00472012095545 , 0.00158996605297 , -0.00698615875132 , -0.00120610997061 , -0.0004808705143 , -0.00604452212755 , 0.00052760319739 , 0.00160361410451 , 0.00302374522328 , 0.000316848309888 , 0.00487791423141 , -0.000989149360728 , -0.00204869306483 , -0.00591332615275 , -0.00187440220975 , -0.0045701865143 , -0.00218837054919 , 6.64773513994e-05 , 8.06215297461e-05 , 0.00171046634029 , 0.00449581107974 , 0.00172965365416 , -0.00227703428216 , 0.00337289032286 , -0.000406268201462 , -0.00329590782304 , 0.000590836706685 , 0.00341727414568 , 0.00272514771846 , -0.00324410944541 , 0.00222859536546 , -0.00173416625167 , 0.000490757245308 , 0.00184070717454 , 0.00287770221368 , 0.00349548894811 , -0.00248814613222 , -0.00213300342379 , 0.000248793493601 , -0.00818355360002 , -0.0007003540094 , -0.00125869243055 , 0.00128125646981 , 0.000573162510661 , -0.000895752585809 , 0.00302513691698 , 0.00126350596831 , 1.23936908088e-05 , -0.00379438948425 , 0.00383026493287 , 0.00057927389797 , -0.00137213316457 , -0.000386963601855 , 0.00513686607734 , -0.000163832006053 , -0.00117887884042 , -0.00188015522849 , 8.87913055548e-05 , -0.00083100333339 , -0.00333533517071 , -7.00035852202e-05 , -0.00189402344955 , -0.000246537931797 , -0.00535805589215 , -0.000961469513976 , 0.00691924600298 , -0.00184392206176 , 0.0045362352196 , -0.0054310493835 , -0.00359852030496 , 0.00193989840996 , -0.00517672996905 , -0.000934918385956 , -0.00588974985748 , -0.0046598221955 , -0.00489355501296 , -0.00519880187078 , 0.00515931453218 , 0.000477294151222 , 1.89914523784e-05 , -0.00190736584906 , 0.000691089056471 , 0.000243662469728 , -0.00169865141156 , -1.73382840353e-05 , 0.00371614046685 , 0.00422741886839 , -0.000504108093065 , -0.00727019230439 , -0.00305912973385 , 0.00400415194808 , 0.0021395588657 , 0.00674363150945 , 0.00292042029514 , 0.00672442328787 , -0.000676799328855 , -0.00475872492487 , -0.0010664761769 , 0.000367217245678 , 0.00199957038445 , -0.00200304593091 , 0.000351555941803 , 0.000472744778758 , 0.00356311844395 , 0.00316391241378 , -0.000638331031539 , -0.00294380576376 , -0.000443765660186 , -0.00334003221715 , 0.0034054953802 , 0.0030023746333 , -0.00354464119828 , 0.000545683348998 , 0.000868528350691 , 0.00265052884373 , 0.00126132843309 , 0.00434895537832 , -0.00195497169701 , -0.000355105687376 , 0.000956509332338 , 0.000546663052646 , 0.00113527557718 , 0.000142674613166 , 0.000138375269663 , 0.00012145725723 , 0.00139318253103 , -0.00271591816289 , -0.000753106766974 , 0.00400219436531 , -0.00393664439601 , -0.000633311532039 , 0.00160594745936 , -0.0053461110249 , -0.00399598215929 , -0.00206210667052 , -1.675653277e-05 , 0.00162827035275 , -0.000632298807861 , -0.00533739764564 , -0.00393605153625 , 0.00379187367624 , -0.00115157157925 , 0.00524872016709 , -0.00404651903915 , 0.0010349826296 , 0.00383487124611 , -0.00219477518837 , -0.00230255092635 , -0.000314561484807 , 0.000391577175021 , 0.00306520739347 , 0.0060287842824 , 0.000567066911272 , 0.00193779011103 , -5.96024582996e-05 , -0.000832006031099 , 0.000527805483224 , 0.00483335312201 , 0.00412698766609 , -0.00232637216023 , 0.00286086139617 , 0.00256544472062 , 0.000435405592021 , 0.000895945429012 , -0.00342087609596 , 0.00355756655522 , 0.00190164752944 , -0.00290190799645 , -0.00341529488089 , -0.00489795299245 , -0.000934118644017 , 0.000208298500287 , 0.00162074110724 , -0.00452934228132 , -0.00519248662097 , -0.00228030317844 , 0.00154848529528 , 0.000275100283748 , 0.000744679853719 , -0.000278576319552 , -0.000153785259414 , -9.28339451572e-05 , -0.000486880361362 , -0.00642076561108 , -0.00100830958258 , -0.000195687055411 , 0.00375913345051 , -0.00206318906904 , 5.716128073e-05 , 0.00640064686135 , -0.00339052719012 , -0.0058761559472 , -0.00269610694456 , 0.00157838274361 , -0.000155629183815 , 0.000611128431117 , 0.00159542930688 , 0.00357760928663 , -0.00489616232621 , 0.00038197653488 , -0.00261238939741 , -6.21246714145e-05 , 0.00397705985769 , -0.00278265333313 , 0.00145999656408 , 0.00332880342109 , 0.00119111199527 , -0.00231097154181 , -0.00119565345742 , 0.00358397485369 , 0.00292237376506 , 0.00337736585702 , 0.00132504157008 , -0.0036921378199 , 0.00158447933889 , 0.00139064664483 , -0.00154941264215 , -0.00210446410798 , -0.00218356586948 , 0.0030320204391 , -0.00264060754197 , -0.00120501014529 , -0.00427210675859 , 0.00179356643935 , 0.0014276766021 , 0.00177690953457 , -0.00123143623055 , -0.00594515989925 , 7.6982301458e-05 , -0.00650734130138 , 0.00488380068167 , 0.00231825284302 , 0.00387598722281 , 0.00532870740397 , 0.00247663696402 , 0.00308030940081 , -0.00286401439892 , -0.00449629525675 , 0.000232774884944 , 0.0045547387563 , -0.00280013840561 , 3.04100052339e-05 , -0.00115533919293 , -0.00145558607709 , 0.000593731588967 , -0.000255811273288 , -0.000156568206819 , 0.000241255016749 , -0.000728408696673 , 0.000924833264183 , -0.000854770206971 , 0.00382474855959 , 0.00311120860217 , 0.000600450355042 , 0.000709568099218 , -0.00281375251379 , -0.00123101687716 , 0.00295871692869 , -0.00230973258745 , -0.00501118892814 , -0.0031556612349 , 0.00042771534396 , 4.25959984942e-05 , 0.000745507161697 , -1.02814707192e-06 , 0.00443488048744 , -0.00166013474919 , 0.00375805756526 , 0.00216435075805 , 0.00019808326801 , -5.58978066179e-06 , -0.00463431187737 , -0.000227860178362 , 0.000308946334779 , -0.00462918542963 , -0.00136206805262 , -0.00315263318171 , -0.000770829650909 , -0.00353132899058 , 0.00175751760097 , 0.000157464638022 , -0.00384668873005 , -0.00443005369787 , -0.00530001856708 , 0.00403879436412 , -0.0022840210899 , 3.42409891959e-05 , -0.00446202117635 , -0.00376120770466 , -0.000179212326527 , -0.000318455119011 , 0.00326224037451 , 0.00301700470158 , -0.00622704342291 , 0.00287316115305 , -0.000100706681751 , 0.00149070967251 , 0.000895198366862 , 0.00201952283724 , 0.00110997364005 , -0.00350013751625 , 0.00120962251348 , -0.00613942679088 , -0.00618167099309 , 0.00125042020884 , -0.000930423113128 , 0.00141281724295 , 0.00234367665187 , 0.00413360518928 , 0.00429601996706 , -8.64063077071e-05 , 0.000995221266019 , -0.00122439093879 , -0.00561706067068 , 9.20606266996e-05 , 0.00278256518327 , -0.00128241470356 , -0.00469161682175 , 0.00131160011819 , -0.00527140261143 , -0.000649143901818 , 0.00605098363272 , 0.000802014236169 , 0.00532774074709 , -0.000817466359663 , -0.00206077112997 , -0.000778142120903 , 0.00206410512225 , -0.00118866581927 , 0.00489176848758 , -0.00175201962688 , 0.00318946997577 , -0.00465059335783 , -0.00109993549281 , -0.000218942748018 , -0.00250028547539 , -0.00117033317439 , -0.00444342514227 , 0.000728919850184 , -0.00228819816689 , -0.00410812412774 , 0.000368889630646 , -0.00489911125775 , 0.00177167907481 , -0.00199126285221 , 0.00154344397514 , 8.40217488597e-06 , -0.00229446754267 , 0.000600945896365 , 0.0041138935274 , 0.00138515352434 , 0.006329402168 , 0.00146778653048 , -0.00178846387231 , -0.00262231880668 , 0.000997083732002 , 0.00398977639582 , 0.00138058007572 , -0.0023833263965 , -0.00269165072938 , -0.000149794382348 , -0.00446981397182 , 0.000612673415276 , 0.00168673297531 , 0.00493943435299 , -0.000345623422045 , 0.000420097279318 , -0.0039486501502 , -0.00238221128507 , 0.00680638172886 , -0.000254222432381 , 0.00143022533304 , -0.00117418822433 , 0.00136101887615 , -0.00245861365079 , 0.000928815161359 , -0.00156460173531 , 0.000149340018278 , -0.000648346989215 , -0.00074383766092 , -0.00171482452507 , 0.00236524022331 , -0.000279329522015 , -6.75576695388e-05 , 0.000543701900725 , -0.000188423076507 , -0.00255238983038 , 0.00180839518532 , 0.000234011980526 , -0.000397395714522 , 0.000830493052668 , -0.0042783720967 , -0.00288196094548 , -0.00171169527984 , 0.000268270078982 , 0.00115358234068 , 0.00506604422701 , -0.00164810882757 , 0.00636408966133 , 0.00270385134391 , 0.000305787639464 , 0.000499714675515 , -0.0027276407901 , -0.000106904857722 , 0.00499280039844 , 4.526911689e-05 , 0.00190495855476 , 0.000462359329445 , -2.51515588671e-05 , -0.000736277887273 , -0.000276050795123 , 0.00202480534194 , 0.000636059759398 , -0.000757453733059 , 0.00125204805834 , 0.00233359335531 , -0.00208707442216 , 0.00178629020692 , 0.00466113235115 , -0.00271005939157 , 0.00266430691505 , -0.00494083136926 , 0.00219510081756 , 0.000187245544979 , -0.00607348103033 , -0.00143158446622 , 0.00462426401903 , 0.00142231928841 , -0.000733584864372 , -0.00260830045086 , -0.00190680623673 , 0.00180618380098 , -0.000509056653397 , 0.000517141798022 , -0.00763493617813 , -0.000320890981583 , -0.00249166815288 , 0.00476030176471 , 0.00346639485823 , 0.000494733481496 , -0.000913059826417 , 0.000969258057724 , 0.00339163236821 , -0.00027158682258 , -0.00338604801282 , -1.0318243535e-05 , 0.00168857450537 , 8.68835589123e-05 , 0.00346520435828 , 0.00206186204785 , 0.00391839892159 , -0.00321271694648 , 0.00130376598742 , 0.000121447415918 , -0.00106139967363 , -5.27726753682e-05 , -0.00226157889912 , -0.00657023525038 , 0.00121840633552 , 0.00264607642659 , 7.72195569952e-06 , -0.000182409321072 , -0.00362933493025 , -0.000585328533109 , -0.000329280690473 , -0.00233849194492 , -0.000389196416438 , -0.00379426108118 , 0.000941097915706 , 0.00195217361226 , -2.72546496165e-05 , -0.00282807128602 , -0.000183656393378 , 0.00465239475968 , 0.00470196964144 , 0.00361307233486 , 0.000371721376574 , -5.63168601364e-05 , 0.0057670944938 , -0.00269958685956 , 0.00198277045693 , -0.00420858624725 , -0.00168593838111 , 0.00150453500431 , -0.00255032507168 , -0.00336653089647 , 0.00165473684114 , -0.0055882720167 , -0.0066264559924 , -0.000612013973247 , -0.000816289446021 , 0.00171033094581 , 0.00484575643768 , -0.000695507862915 , 0.00199227998389 , 0.000233929888205 , 0.00402218710936 , -0.00314652297877 , -2.40671058721e-05 , -0.00280941979203 , 9.464940381e-05 , -0.00210826369703 , -0.00399566993119 , -0.00374790045145 , -0.00444118266472 , 0.00575997508415 , -0.00588181470437 , -0.00141040988287 , 0.00211207550098 , 0.00191417448922 , 0.00121793827722 , -0.00341619423525 , -0.000495990019052 , -0.000538167863753 , 0.000185311291698 , 0.000315573500199 , 9.09815127395e-07 , -0.00225784906075 , -0.000430465086001 , 0.000212861593805 , -0.000607387755998 , -0.00177881226672 , -0.000330005988667 , -0.00131361325509 , 0.00559186427517 , -0.000472132793587 , 0.00187264301747 , 0.00285850257943 , 0.00517651195633 , 0.000199687583826 , 0.00358004279495 , 0.000142124087534 , 0.00331302657822 , -0.000637726666969 , 4.68122678746e-05 , 0.00191758398434 , 0.000142538932488 , 0.000536127951919 , -0.00461664044118 , -0.00254751174544 , -0.000442443808158 , 8.73662633821e-05 , 0.00423786300324 , 0.00275502841769 , -0.002853304774 , 0.00193522949184 , 0.00256149783746 , 0.000831829643576 , -0.00123036248796 , 0.00424220044981 , -0.00439536557141 , 0.000978428205436 , 0.000765921011818 , -0.0057437902222 , -0.00479966058319 , -0.00109946975762 , -0.000247494035705 , 0.00283113194772 , -0.000132726002991 , 0.00139515752092 , 0.000698531201567 , -0.00104317045941 , -0.00284024234559 , -1.37428199536e-05 , -0.000614985512785 , -0.00032327887419 , -0.00066322482051 , -0.00249377335587 , -7.13473594984e-05 , 0.00137591852826 , -0.000183618903552 , -0.00310766373474 , -0.00477614185754 , -0.000876066299838 , 0.00162480392134 , 0.0034212892902 , 0.00565562574151 , 0.001030682021 , 0.00236533621187 , 2.27499765775e-05 , 3.26312052569e-05 , 0.00217775232541 , -0.000981885983246 , -0.00153700284291 , -0.00129380699044 , 0.00042795623082 , 0.000898389554785 , -0.00800681423393 , 0.00415042101183 , -3.07692279221e-05 , -0.00227734682584 , 0.0031460673512 , -0.000569738363949 , 0.00367548122379 , -0.00371388898823 , -0.004436462415 , -0.00299578970683 , -0.000228148225712 , 0.00715020006232 , -0.000200343727357 , 0.00164387560975 , -0.000530061003057 , 0.00335430774426 , 0.00186572534543 , -2.03641401608e-05 , -0.00594408935681 , -0.00259039740942 , 0.00150774970937 , 0.00312931620337 , -0.00220160568419 , -9.52597970964e-05 , 0.00369382104403 , 0.00170538189409 , -0.00205928376579 , -0.000718437089449 , -0.00109425834776 , -0.00270885055044 , ])
Y_4_3_imag = flex.double( [ -0.0 , 0.0 , 0.000483074675273 , 1.11296594283e-05 , -0.000456272932422 , -0.00290472563853 , -3.90089105138e-06 , 0.00132677402151 , -0.00634720477274 , -0.00168577090109 , -0.00234066838975 , 0.000634694400217 , -0.000226242284297 , 0.0016397742528 , 0.00122794679482 , -0.0020271139785 , -0.0062111812101 , -0.00172886048283 , -0.00282616937087 , -0.000212906073073 , 0.000906348513796 , -0.000540938651214 , 0.000210831537281 , -0.00157959599711 , -0.00337342657193 , 0.00372090143086 , -0.000567151629709 , 0.00316990954436 , -0.00494161778633 , -0.000163428397803 , 0.000138561578623 , 0.00578048649317 , 1.0057897888e-05 , -0.0056426581987 , 0.000763431826762 , 0.00284968800887 , 0.000859180348848 , -3.79439150398e-05 , 0.00504473512488 , 0.00238373951081 , 0.000146342946794 , -0.00341510066104 , 0.00354268995386 , -0.00154837983927 , -0.000651839181402 , 0.00531161838408 , 0.0014303944343 , 0.00179367884814 , 0.00545267923538 , -0.00257888897394 , -0.00183391934948 , -0.000845078832009 , 0.00160933192094 , 1.84558760958e-05 , -0.00223435873768 , 0.00133391624151 , -0.000714096471948 , -0.00220516572421 , -0.00207726962541 , 4.64156341934e-05 , -0.000660022527619 , 0.000126454025766 , 0.000708509903623 , -7.42948768154e-05 , 0.00213485666782 , 0.000226029375134 , -0.00393989849159 , 0.00491281947807 , 0.000738723665709 , -0.00253642925103 , -0.00313486040577 , 0.00164742751592 , -0.000448237203502 , 0.00102580517018 , 0.000144863161782 , -0.00487798451521 , 0.00155813654109 , 0.00591308146942 , -8.83954106007e-07 , -0.0014723956245 , 0.00174564962322 , 0.00591092739852 , -0.00285944863608 , 0.0024433960201 , -0.0016920644527 , -0.00549570033024 , -0.000330640500746 , -0.00119615001741 , -0.000233862710223 , 0.00489646610484 , 0.00480488919473 , -0.000176690209932 , -0.00281405828915 , -0.00268589579221 , -0.00086372025466 , 0.00261474097558 , 0.000480484916183 , -5.70711211762e-05 , -0.00149888407165 , -0.00364554957933 , 0.00144975737082 , 0.00232071965976 , -0.00253599533129 , 8.17704498888e-05 , -0.000659637953802 , 0.00608655445508 , 0.00257365486025 , -0.00156391036117 , 0.0019323923413 , 7.92169642727e-05 , 0.000908820141337 , 0.00147879126369 , 0.000387158469776 , -0.000442255530688 , -0.000555083304048 , -0.0014000243882 , -0.00176006301199 , -0.00362662436867 , -0.000888924554805 , 0.00264485636094 , -0.000441669944455 , -0.00150344810773 , 0.00253754019022 , -0.00100123307793 , -0.00482954387587 , 0.00294088081786 , -0.00331349404214 , -0.000199832893802 , 0.000471628978036 , -0.000549339322096 , -0.00689635296403 , 0.00259483808417 , 0.000730816733312 , 0.000298802869978 , 0.000843145474553 , -0.0040508091496 , 0.000680621078822 , -0.002414000709 , 0.00262053760357 , 0.00251589532661 , -0.00138663608047 , -0.00143392116696 , -0.00454592521995 , 0.00212199619901 , -4.08552157938e-05 , 0.000601324006921 , 0.00386430022662 , 0.00353458892938 , -0.000102442796306 , 0.00213906841143 , 0.00172557024657 , -0.000769028800135 , -0.00411376985241 , -0.00214317988652 , -0.00266065140448 , 0.000174208213683 , 0.00141486723206 , 0.00208258259428 , -0.00151759355745 , -0.00311820285075 , -0.00379482195584 , -8.78836388353e-05 , -0.000119447690837 , 4.62286381518e-05 , 7.03174972932e-05 , -0.00239861755567 , -1.55124611976e-05 , -0.00215696518361 , -4.85443920975e-05 , 0.00105041609559 , -0.00307658890622 , 9.55918781919e-06 , 0.000284416068778 , -0.00275246862062 , 0.000442251206095 , 0.000754644096944 , 0.0055674113644 , -0.00294645499041 , 0.00310837411171 , 0.000986915402058 , -0.000393343259297 , -0.00367031774921 , -0.0016449419178 , 0.000978261294509 , 3.33966782108e-05 , -0.000763643119733 , 0.00185591263406 , 0.00200025554013 , 0.00149451372624 , 0.000146439367249 , 0.00219412293217 , 0.00104913363046 , 4.40633621368e-05 , -0.00121085479129 , 0.00528064159989 , 0.000976473938141 , 0.000150549185038 , -0.000704986746967 , -0.00249993838811 , -0.00187615829356 , 0.00529889962201 , -0.00284199073017 , -0.00537197307781 , -0.00381921798938 , 0.000936815528115 , -4.30519994158e-05 , -0.00352332761495 , -0.00300198560074 , 0.00431826234397 , 0.00241533627948 , -0.00401647056122 , -0.00153764901291 , -0.000283777898469 , 0.0037808038378 , -0.00520826861812 , -0.000672088326926 , -0.00398344522962 , 0.00408390192737 , -0.00307186572099 , 0.000727931184452 , 0.00292029257712 , 0.00369540134951 , 0.0060270705052 , -0.00229239735611 , 0.0012759237566 , -0.00387774464554 , -0.00194313483864 , -0.00297078514158 , 0.00175431256763 , 0.00157504288439 , -0.00187113415259 , 0.00733460568524 , 0.00159808547431 , -0.00552036280107 , -0.000145872679443 , 0.00202848240445 , 0.00202239750634 , -0.00066470629364 , -4.7583028616e-05 , -0.0011514114584 , 0.000904114126367 , -0.000474040907832 , -0.00406036641438 , -0.00238077373477 , 0.00253520687033 , -0.00222386432246 , 0.00351898277234 , -0.00426052903768 , -0.00416311704954 , -0.000464782477339 , 2.0005906154e-05 , 0.00236421539029 , -0.00141441971517 , 0.00411192254571 , -0.00129085398572 , 0.0008064631439 , -0.000188836302858 , 0.000406571373741 , 0.00221232793719 , 0.00259680121286 , 0.000964432620004 , 0.00157131986285 , -0.00366628709737 , -0.00164214073832 , -0.00305307238032 , -0.00659467856901 , -0.00588289934748 , 0.000875615301106 , -0.000815983083008 , -0.0048730839185 , -0.0013954797386 , -0.00319277358377 , 0.00384854249912 , -0.000483539381645 , 0.00201261267627 , 0.0020150894954 , 0.000389153852512 , 0.00554881476261 , 0.00522942156436 , -3.19203309904e-05 , -0.00253020648941 , 0.000683004479516 , -0.00202127310632 , 0.000432866711511 , 0.0014233048256 , 0.00142296339083 , -0.0056726501642 , 2.08706497446e-06 , 0.00642134862264 , 0.00263323027912 , -0.00332453263796 , 0.00201580321917 , 0.000710800957376 , 0.00377921822675 , 0.00575965721762 , -0.00180371494723 , 0.00135803449767 , -0.000439202429407 , 0.00440532102873 , -0.000217766065467 , 0.000376342352153 , 0.00112409122964 , -0.00296153031334 , 0.0031262295861 , 0.00217836650036 , 0.00518933825534 , 0.00307008911704 , -0.00258313935456 , 0.00476120338005 , -0.00190513462386 , 0.00642601332848 , 0.000672058663922 , 0.00369581881377 , -0.00179904202956 , 0.00214704789688 , -0.00454280220392 , -0.00506272361064 , -0.00240033067584 , 0.00100494007877 , 0.00532419525312 , -0.00642644119282 , 0.000376280881772 , 0.000705759169601 , -0.00101355848935 , -0.00155350428771 , 0.00168535327085 , 0.0022725643418 , 0.00160597235557 , -0.00375685791597 , 0.00656948582697 , -5.66421868489e-06 , -0.000582716241646 , -0.00205492879726 , -0.000973167752966 , 0.000449889247728 , -0.00160913335132 , -0.00100774779512 , 0.00261390826279 , -0.00202041238378 , 0.00306966647492 , -0.000654769019765 , 6.07307514348e-06 , 0.000732096078302 , -0.000316331053794 , 0.00145010241786 , -1.91040730946e-05 , -0.00269762532412 , -0.00207295797858 , 0.00289782971368 , -0.00412025757464 , 0.00120819658413 , 0.0038360804668 , -0.000817155222885 , 0.00480665491157 , -0.00188812511184 , 0.00143491365425 , -0.000489253631405 , -0.00374897900888 , 0.00374298063132 , 0.00566634390493 , 0.00100687338919 , 0.000355949983504 , 1.2347984992e-05 , 0.00167552673517 , -0.00152337797949 , -0.00632185914738 , 0.000248816464743 , -1.85722915607e-05 , -0.0010076843462 , 0.00583967947688 , -0.00177006362349 , 0.00143166024134 , -0.00196947297505 , 0.000264598946382 , -0.00383793712708 , 0.00200384611187 , 0.00244287437648 , 0.000951578239461 , 0.00322985226877 , -0.00320467657661 , -0.00094861467424 , -0.00341660266143 , 0.00376719298352 , -0.00632801179514 , -0.00633433805002 , 4.28828103391e-05 , 0.00351733986873 , -0.00451482864322 , -0.00425406157954 , -0.00122755270137 , -0.00472436872253 , 0.00558892535024 , 0.00476866132362 , 0.0021760053536 , 0.000728304537574 , -0.00538359426977 , -0.00402497991024 , -0.00037508660459 , -0.000126364597724 , -0.000891765573318 , 0.000588490529315 , -0.00519887772059 , -6.35386553171e-06 , -0.00550759432678 , -0.00623473683149 , 0.00338548233826 , 0.00016412088948 , 0.00119747732326 , 0.0033624165532 , -0.00201592858274 , 0.000887588485102 , -0.00271556727804 , -0.0043382484227 , 0.00489424969251 , 0.000731794632816 , -6.3149320212e-05 , -0.00464152494157 , 0.00251324316261 , 2.74112070235e-05 , -0.000583377195356 , 0.00608149178212 , 0.00589012257838 , -0.00406927339487 , -0.00268127243491 , 0.00818603037412 , 0.000419157901724 , -0.0038431287208 , 0.00453474447709 , 0.00104815716544 , 0.00251496662272 , -0.00207095813063 , 0.000461499838385 , -0.00524082087952 , -0.00166366320021 , 0.00300163163236 , 0.00176701525284 , 0.00299872275886 , -7.90407649455e-05 , 0.00229775998962 , 0.000589684276366 , -0.00469824178535 , -0.00217070442718 , 0.00188543613931 , -0.0026720727544 , -0.00276673454606 , -0.00058670329279 , 0.00267477501592 , 0.000371959284278 , 0.0045489708938 , 0.00023614381349 , 0.00184106092181 , 0.00383298205548 , 0.00386188775126 , -0.000416217123337 , 0.00281871197564 , 0.00243580280076 , 0.00617649502355 , -0.00153500673036 , -0.00129847224255 , 0.0045993145194 , -0.000228632777606 , -0.000177051520188 , -0.00383142171227 , 0.00300039258264 , 0.00251729008425 , 0.00593017384593 , -0.000264198377101 , 0.000681811114904 , 0.00123257029315 , -0.00602946494623 , 0.00133234963254 , 0.00521569807706 , 0.000941778829259 , 0.000950526298398 , 0.000913216982138 , 0.00388840695135 , 0.000521621976186 , 0.00722810745284 , -0.000472765852184 , -0.000210500975175 , -0.00440939043894 , 0.00168983137323 , -0.00171918956527 , 0.00516262925021 , -3.70816608011e-05 , 0.00240200860133 , -0.0040998185565 , -0.0044912080391 , -0.00105528145781 , -0.00214094942982 , 0.00559150361915 , 0.00164353077782 , -0.00308489781648 , -0.00635925095934 , -0.000131000545278 , -0.0043034430671 , 0.00117698597926 , 0.00140617824077 , 0.00177717465125 , 0.00104982786291 , -0.00255790698101 , 0.000242064391498 , 0.00228843815632 , 0.0040763326294 , 0.00392861448181 , 0.000434865918787 , -0.0045668570563 , -0.00180188335074 , 0.00357025006661 , 0.00359219666177 , -0.00343110129013 , 0.000327971812265 , -0.000715943701766 , 0.00275347244184 , -0.00275284746271 , 0.000665679552038 , -0.000377311832784 , -0.000303212138074 , 0.00387152030679 , -0.000655301227573 , 0.00292639160425 , 0.000210642252291 , 0.00248849797168 , 0.00290253794657 , -0.000354348047144 , -0.00123457997682 , 0.00476984589835 , -0.00460958871273 , -0.00178668551367 , -2.95374590059e-05 , 0.00201587399412 , -0.00131530165638 , -0.00331167492856 , -0.000410196343013 , 0.00124956783539 , -0.00279700023766 , 0.00175081574895 , 0.000716938879825 , -0.000252963243515 , 0.00085548204691 , -0.000914263577377 , -9.24647430002e-05 , 0.000265957058375 , 0.00260845008838 , -0.00231672001916 , 9.95062085436e-05 , 0.000296458251221 , 4.40948898061e-07 , -0.00155147808974 , -0.00144561587084 , 0.00440199504384 , -0.00376688478044 , -0.0004272307637 , 2.3368091292e-05 , 0.00194298162195 , 0.00555909662824 , 0.00045237812543 , 0.00284717709564 , 0.00187554999554 , 0.00388933319447 , 0.000729334410103 , -0.00129805166945 , 0.000464738949273 , -0.000250913372071 , -0.000537599664667 , -0.0040426249679 , -0.00338360392282 , 0.00114884221203 , -0.00504272595844 , 0.000659356333251 , 0.00162233474747 , 0.00374542898543 , -6.99122398834e-05 , 0.00175080678 , -0.00573617543936 , 0.00214391371077 , 0.00262169097618 , 0.000347755342776 , -0.00362328290288 , -0.00066552559807 , 0.00535422959232 , -0.000996186636228 , 0.000990766440528 , -0.00532422509126 , 0.0014182983349 , 0.000990005794304 , -0.00194555812915 , 0.00335226534756 , 0.000642498352425 , 0.00393903071803 , -0.000964215027001 , -0.00113159026175 , 0.000132783782979 , 7.33202557011e-05 , 0.00200740280653 , -0.00030659743056 , -0.00344608326272 , -0.000165101883084 , -0.000155706244759 , -0.000508647194425 , 0.00423823629198 , 0.0037220293984 , 0.00228582171854 , -0.000381749576527 , -0.00117516852457 , -0.00739788917279 , 0.00576746474642 , -0.00134859410994 , 0.00391715612707 , -0.000439539064893 , 0.00583334662546 , 7.34213944127e-05 , -0.000159858603739 , -0.00332469642434 , -0.00205093424807 , -0.00136124173709 , 0.000265606663432 , -0.000444112037448 , 0.00576878412882 , 0.00589524574468 , 0.00231861470229 , 0.000920810838113 , -0.00131928457003 , -0.00615290030485 , -0.000247621502656 , -0.00360546081051 , 0.0011289191827 , -0.00170641641502 , -0.00488544579783 , -4.23032737888e-05 , -0.00175588972741 , -0.00219581810522 , 0.00230977898868 , 0.000630315602686 , -0.00162005754454 , -0.000800323160068 , 0.00396271703359 , -0.00214532955592 , 0.00380039945367 , -0.00390614333729 , 0.00101043498005 , 0.00252644886431 , 0.00139579712866 , 0.000160052921326 , 0.00373877164542 , 0.00164169193336 , -0.00465236439495 , 0.00450513173785 , 0.00437436769203 , 0.000756355326335 , -0.00351219254604 , 0.00459013906012 , -0.00257027706604 , -0.00178650531953 , 0.00516212004732 , 0.000599059977062 , -0.00287751911727 , -0.000851067390903 , -0.00108678238141 , -0.00454097821814 , -3.65888848383e-05 , 0.00115961751343 , -0.00251897820397 , 0.000967969441167 , 9.10875637338e-05 , -0.000683984950647 , 0.00357094354011 , -0.000108561553325 , 0.000487221384376 , -0.00195025512009 , 0.00253474447793 , 4.03056793826e-05 , -0.00294001391236 , 0.00339001655097 , -0.00524582985443 , 0.00233914834895 , -0.00404716149191 , -0.00864099769958 , 0.00329303430285 , 0.00100383651752 , 0.00343958428325 , -0.00308661518986 , -0.00250189400356 , -0.00163913267126 , 0.0061220549068 , -0.00200567268791 , 0.00343323730903 , -0.00537584631565 , 0.0026127348221 , -0.000209135632008 , -0.00357152693726 , 4.72015173239e-05 , 0.00121608999715 , 0.00870869688293 , -0.00320596918137 , 0.000984355139431 , -0.00597016946882 , -0.00302307422763 , -0.000776420720713 , -0.00263689811587 , -0.00148204518761 , -0.0022403894166 , -0.00297999117686 , 0.00365954983589 , 0.0013000353089 , -0.00359325472591 , 0.00133696226651 , -0.000378688197632 , -0.000488449643344 , 0.00167218356959 , 0.000396051427888 , -0.00420842567237 , -0.00415713050037 , -0.00336926937662 , -0.00169009269091 , -0.000534969925588 , 0.00274837745493 , 0.00152444932549 , 0.00635906994679 , -0.00506333115051 , -0.00156405766166 , 0.00361722960527 , 0.00503163624107 , -0.00133923617664 , -0.00266414149088 , -0.00471578948082 , 0.00364125390447 , -0.00157714604188 , -1.01141757758e-05 , -0.00524511070986 , -0.000452608920577 , -0.00160034932764 , 0.00279915084239 , -0.0016489548166 , -0.00150395921167 , -0.00197801149505 , -0.0022511603133 , 0.0054609073514 , -3.23586829121e-05 , 0.00485798299359 , 0.00142919887712 , 0.000667927774899 , -0.000953982240865 , 1.01328064685e-05 , -0.00175710599155 , 0.000555684368059 , -0.000352407908009 , 0.00255683682645 , -0.00014279257576 , -0.000632084708742 , -0.00174102855386 , 0.00253057343618 , -0.00195694755117 , 6.65702563215e-05 , 0.00294273621006 , 0.000264441232502 , -0.000538026811788 , -2.57521523165e-05 , -0.00207934828795 , -0.00371960316861 , -3.6598827002e-06 , -0.000352161113475 , 0.00437658056164 , 0.00208896258559 , 0.00269032557946 , -0.00762414065595 , 3.74501263319e-05 , -0.00648684971166 , -0.00362046765803 , 0.00189999769918 , -0.00242095793991 , -0.00155961325782 , -0.0018512355484 , -0.00639892365 , 0.000964492192383 , 0.00225607042442 , 0.00403095306192 , 0.000277861783314 , 0.000139987746377 , -0.000118810343421 , 0.00383216638523 , 0.000120835007544 , -0.00103379584116 , -6.08780667158e-05 , 0.00102460578519 , -0.00409630906119 , 0.00204305108567 , 0.00394456459742 , -0.00106129116212 , 4.64242461946e-05 , -0.000158623426889 , 0.00579075217219 , 0.00204860831265 , -0.00134587280324 , -0.00029330518908 , 0.0029353101746 , 0.00406316708855 , -0.000219023538769 , -0.00153037211555 , -0.000820514567519 , 0.00183606836557 , 0.000325235437057 , -0.00514383900121 , -0.000499651705548 , -0.00339226040779 , -0.000563498414163 , -0.00295345654445 , -8.01580779981e-05 , 0.000134632937459 , -0.00396314742726 , -0.00513818514479 , -0.00227100436937 , -0.000952866590499 , 0.00107041728625 , 0.000563513853855 , -0.00206024174392 , -0.00315410781596 , -0.000471404438919 , -0.00042176385885 , -0.00190818240735 , -0.000882404749051 , -0.00443215340827 , -0.00197807602216 , -0.00128588772125 , -0.00115807083914 , 0.00148601890697 , 0.00561337931336 , -0.000801505471865 , -0.00129010795215 , 0.000740137688419 , 0.00264769324545 , -0.00238997538665 , -0.0048395158753 , -0.00660892869475 , -0.00391862384067 , -0.00437354877504 , -0.000746124527596 , -0.000910062989597 , -0.00677844253817 , 0.000235826161713 , -0.00490148638563 , 0.00134642881071 , -0.00118296623917 , 0.00380144220276 , 0.00227715122343 , 0.000109814176051 , 9.81833382461e-05 , 0.00703287677429 , 0.00801991860049 , 0.00419601771185 , 0.0015237170133 , 0.000115049579302 , -0.00341440456825 , 0.000238301624549 , -0.00518497677516 , 0.00247403010525 , -3.21865515517e-05 , 0.000840872541766 , 0.00200803126013 , -0.00357204075521 , -0.00141266798964 , 0.00021505122114 , -7.37918528619e-06 , -1.10336289221e-05 , -0.00620172449846 , 0.00230206805959 , 0.0036784699577 , 0.000762468385875 , 0.000152637008971 , 0.00281910913572 , -0.00217094494497 , 0.000331809956486 , -1.86488348719e-05 , -0.00542770979538 , -0.0026235986383 , 0.00179506955418 , 0.00156174238296 , 2.46334043004e-05 , 0.00286005533846 , -0.000775552464411 , -7.91486952966e-05 , 0.000349889023912 , -0.000113605986853 , -0.00287716033292 , -0.00335224867691 , 0.00353783483456 , -0.00103614787818 , 0.000514046966943 , 0.00290748999241 , 0.00404960366086 , 0.00487437710931 , 0.00291316999249 , -0.00308271622903 , 7.81971332893e-05 , -0.0010259165053 , 0.00128914254382 , 0.00631215634169 , 0.00137836106399 , -0.000749061345208 , 0.000700919886796 , ])
Y_4_4_real = flex.double( [ 0.0 , 0.0078056768564 , 0.00476222382619 , -0.00671530556674 , -0.00326914336338 , 0.000434717912849 , -0.00368420265187 , 0.00475865178738 , -0.00132671089401 , 0.00449873534138 , 0.00266841643607 , 5.82686681481e-05 , -0.000163455499326 , 0.000309871974061 , -3.24185412874e-05 , -0.00313932895204 , 0.00380066791499 , 0.0001105307268 , 0.00406843673108 , 4.41171790862e-05 , 0.00623178741216 , 0.000871683981583 , -0.000596249594058 , 0.00324134058117 , 0.000939256799282 , 0.000356143730443 , 0.00130361888391 , 0.00382461139846 , 0.00186189438447 , -1.15584852899e-05 , -7.9199055051e-05 , 0.00420554655029 , 0.00732293075978 , -0.00323779220835 , 0.000759634963886 , 0.00341411588715 , 0.00573936259102 , -3.09148526865e-06 , 0.00139920601453 , -0.000110108747537 , -0.00315279815229 , 0.00286108850097 , 6.07173894402e-05 , 0.00235896348073 , 0.00325409419902 , -0.000674562881239 , 0.00345517013048 , 0.00452364409013 , -0.0019678657913 , -0.00096204420513 , 0.00397722797431 , 0.00214806651858 , -0.00449440389604 , 0.00690990166418 , -0.00433819324315 , 0.000291044191497 , -3.90151309199e-06 , -0.00693704989946 , 0.000557199854198 , -0.00250513626507 , 0.00615398239118 , -0.000779773039064 , -0.000111908293628 , -0.000922319224923 , -0.00109088832217 , -0.00413473929055 , -0.000727080969378 , -0.00788830392414 , -3.76749922834e-05 , 0.00203367377367 , 0.00256021940857 , -0.00432299327902 , 0.00525746421029 , -0.000598465489135 , 1.04550298378e-05 , -0.00112012550645 , -0.00256355393386 , 0.000650869761135 , -1.36184576855e-07 , -0.000595958157871 , -0.000447217515344 , 0.00156947444741 , -0.0047787144879 , 0.00287994527396 , -0.0058066386683 , -0.00153931752936 , 2.81021525896e-05 , -0.00321968717615 , 0.000236750899386 , -0.00135591316962 , -0.000178340484953 , -0.00011124609765 , 0.000468107067156 , 0.000775916060634 , -0.000992853450549 , 0.000833741829658 , 2.38229319716e-05 , -0.00288517533415 , 0.00010697155615 , -0.000178455085075 , 0.00197212458896 , -0.00333072953206 , 0.000719992646123 , 0.00473451666855 , -0.00410130390178 , -0.00507574257807 , 0.00290042137591 , 0.00458660037804 , -0.000644357148086 , -1.17154865618e-05 , -0.0001533970323 , -1.86479914726e-05 , -0.00494091167987 , 3.42870751006e-05 , -2.23585829173e-05 , -0.00148038312813 , 0.00408873585084 , 0.00125870540807 , -0.000284646373087 , 0.000688460848361 , 0.00154060502483 , 0.00481905087653 , 0.000398841971252 , 0.000623737534043 , -0.00223848902916 , -0.00328587257147 , 0.00121978787072 , -5.3952183092e-05 , -0.00476807627992 , 0.000257961789109 , -0.00307871251701 , 0.00482421243949 , 0.00444889897725 , 7.35269766166e-05 , 0.000122784104283 , 0.0025238735826 , -0.00418097685128 , -0.00337593277706 , 0.00375653846901 , 0.000735585394103 , 9.7284909855e-05 , 0.00328268295407 , -0.00141050489932 , -0.000391211809749 , 0.00486873728263 , 0.0032794349963 , -0.000379601584279 , -0.00223617875175 , -0.000766626867281 , 0.00232902754378 , 0.000274255895782 , 0.0011641771231 , 0.0011134929744 , 0.00379507125873 , -0.00323838952533 , -0.00138181028008 , 0.00332479391829 , -0.0017945218132 , -0.00555855178876 , 0.00289546242549 , 0.00164258286498 , 5.91072014677e-07 , 5.97876966765e-05 , -0.000706980474101 , 0.0010402297379 , 2.01097926099e-05 , -0.00395028286036 , -0.00589672017219 , -0.00267092401237 , 0.000167755719611 , 0.00175584744114 , -3.57799085889e-06 , -0.00118191435324 , -0.00269224463175 , -2.64745772273e-05 , 0.000406977866341 , 0.00415500486795 , 0.00157051458669 , -0.00204993063737 , 0.00015222247546 , -0.00439776095547 , -0.00395883500621 , -0.001260943673 , 0.000947069102209 , 0.00446723549849 , 4.13458876052e-05 , 0.00055375674722 , -0.00279045397358 , -0.000949003581024 , 3.52185482928e-07 , 0.000343166324653 , -0.00343997441093 , -1.53034702296e-05 , 0.0049492365146 , -0.00271452342181 , -0.000264325368104 , -1.48152648673e-05 , -0.000657197753944 , 0.000604436682728 , 0.00556085119806 , 0.00503497154187 , -0.00158905668522 , -4.457513714e-05 , 0.00309968448359 , 0.000227377880445 , -2.58967602307e-05 , 0.00283016185452 , -0.00245140642481 , -0.00762885490974 , 0.00202355503015 , -0.000554260888288 , 0.000292710618376 , -4.18498865075e-05 , 0.00190385327419 , -0.001845148313 , -0.00369464288035 , 0.00139815839242 , 0.0017060547105 , 0.00151916936441 , 0.00149381838493 , 0.00164950728218 , -0.00111684638282 , -0.00244925839625 , -0.00408195831075 , -0.00101132111306 , 0.00349503161527 , 0.0031712247941 , -0.00113521541719 , 0.00756248771167 , -0.00198516159106 , 0.00454596207555 , 0.00375633719362 , -0.00704103649794 , -0.00305762759374 , 0.00642197338323 , 0.0060112605585 , 0.000512142721856 , -0.00171701040676 , -0.000271501989351 , -0.00600338357697 , -0.00075527419657 , -0.00580274706756 , 0.00100065124609 , 0.000688423416395 , 0.0016132656411 , 0.000509454404174 , -0.00721469740035 , -0.00272385274002 , 0.00635896018589 , 4.25194086465e-05 , 0.000434521283812 , 0.00241054161636 , -0.000198120762898 , -0.000878425943634 , -0.000320457858656 , 0.00575225607256 , 0.00647949175448 , 0.00366126251852 , 0.00219260870847 , 0.000562103056432 , -1.59357275344e-05 , -6.21358640385e-06 , 0.00243910895564 , -0.000630089967276 , 0.00196795229303 , -0.00457003149673 , -0.00279132273127 , 8.78904636818e-05 , -0.000930298842452 , -0.00588407526156 , 0.00059207931688 , -0.0023332167532 , 0.0017886111637 , 0.00484280552898 , -0.00260394413782 , -0.00345526587978 , -0.00699165905666 , -0.00289037385341 , -0.000282298039185 , -0.0018359744626 , -0.00025696551251 , -0.000541793618735 , 0.00592307222327 , -0.00108962343523 , 0.00299142293118 , -0.00249851200384 , -0.000481863242909 , -0.00236441629868 , 0.00258690205162 , -0.00090376890025 , -0.00458720544244 , -0.0012870365814 , -0.00566563935837 , 0.00218083448538 , 0.00657680149973 , 0.00340836988739 , -0.00152918330659 , -0.00474984571472 , 0.00189365884961 , 0.00428191464426 , 4.58381855091e-05 , 0.00360748706252 , 0.000249644632505 , 0.00226852485653 , -0.000728032738047 , 5.96747064004e-05 , -0.00214162107421 , -0.000178363626369 , 0.00127698283072 , 0.00596179049968 , 0.00508698282873 , -0.000930839397219 , 0.00239024681856 , 0.00176707206879 , 0.00506662160488 , 0.00338115636779 , 0.00181296622148 , 0.00116429905023 , -0.000181617168002 , -0.00436129863766 , 0.00463045412672 , 3.41753852645e-05 , -0.00146817898208 , 0.00342265523689 , 0.000149435882773 , -0.00486720524121 , -0.00110528545345 , 0.00215975280963 , 0.000454089800899 , -0.000697895781633 , -3.84815755915e-07 , -0.00175230792992 , 0.000208617324063 , -0.00016770222798 , -3.02403216635e-05 , 0.00861231656216 , -0.00114094276988 , 0.000647850710233 , -0.007650806193 , 0.000214986932749 , 0.00554195670643 , -5.58017436719e-05 , -0.000214751999419 , -0.00408244565008 , -0.00129071626484 , -2.76613988479e-05 , 0.000429019224257 , 0.000338409020481 , 2.82590394756e-05 , -0.000958815548281 , 0.00521385518749 , 0.00139072268839 , -0.00207386253744 , -0.00236091297519 , -0.00504742166955 , 0.00152581731078 , -0.0020201356382 , 0.00232320952966 , -0.0032714841604 , 0.00145966656151 , -0.00563510995565 , 3.71273446001e-05 , 2.53857783159e-07 , 0.00279837018204 , 0.000244978629117 , -0.00115250609678 , -0.00168397662336 , 1.12046715211e-06 , -0.00114359868074 , 0.00248182864195 , -7.33436525205e-05 , -0.00283052475023 , 0.00259884513027 , -0.00287404514814 , 0.000689293314236 , -0.000775941984454 , 0.00141013266117 , -0.00101254980922 , 0.00109771610951 , 0.00179212638295 , 0.00222284772412 , 0.00539264696138 , -0.00363368775894 , -0.000536509540225 , -0.00101100267142 , -3.46722632757e-05 , 0.000812239473362 , 0.00149434004886 , 0.00152492838192 , -0.00677589284683 , 0.00483262053672 , 0.00294111065398 , -0.00236451488055 , 0.00488057201674 , -0.000553677084378 , -0.0038059566467 , 0.00101997899087 , -0.000407558990068 , -0.00170301480355 , -0.00139958573213 , -9.67603505033e-05 , -0.00404386354656 , 0.000153087551006 , -0.00100232856607 , 0.00262380642069 , -0.000501321635219 , 7.75106907315e-06 , -8.47349675928e-05 , -0.0016100233208 , 0.00269011673233 , -0.00505056772586 , 0.00145493035683 , 0.00244440622706 , 0.00753185586234 , -0.000283456497172 , 0.00194771668348 , -0.0030830449606 , 0.00253405687566 , -0.00476731213022 , 0.00463204828219 , -0.00198567109773 , -0.00571981834603 , -0.0062286150347 , 0.00106199201257 , 0.00589649559237 , 0.00364875236852 , -0.00198848965068 , -0.00237675351973 , -0.00084689726909 , 0.00048223860141 , -0.00376977358006 , 0.0013296222749 , -0.00239307823427 , 0.000893828947795 , -0.00469661364148 , 0.000332855559452 , 0.00134272953387 , 2.19738636557e-06 , -0.000440191705297 , 4.89160091263e-05 , 0.00172512852247 , 0.00151106235705 , 0.000627339786193 , -0.00635401482431 , 0.000527465938373 , 6.86786218176e-05 , 0.000913543582332 , -0.00243966246787 , 0.00148506298581 , 0.00041382062117 , -0.00137044254107 , 0.00253867472895 , 0.00246847094878 , 0.000115269220924 , -0.000554368667357 , 0.000530359252311 , -0.00332941429009 , -0.00169258402337 , 0.000722287354 , -0.000160805656704 , -0.00605586192584 , -0.00390955297732 , -0.000578811207986 , -0.000402605507785 , 0.00489925072988 , -0.00247538467107 , 0.00371008758919 , 0.00461220048936 , -6.3206046736e-05 , 0.00520019766046 , 0.00035651726538 , -0.00116130683144 , 0.00331227997443 , -0.00110211050504 , 0.00568002617136 , -0.00165309432092 , -0.000491134473954 , -0.00194886389883 , 0.00516016690181 , -0.00347892906574 , -0.00315306002176 , 0.00241882278234 , -8.60997512567e-05 , -0.0030298620893 , -6.17661769135e-06 , 0.00167339010973 , 0.000429129239901 , -0.000585052424717 , -0.00429448906443 , -0.0067261896121 , -5.71632235225e-06 , 0.00452272363339 , 0.000888722064406 , -0.0039955073427 , -0.00124083861607 , -0.00100354382258 , -0.0020071931537 , -0.000504527550937 , 0.00222351025458 , 0.00139028264739 , -0.000904828912086 , -0.000183247689172 , -0.00124093567451 , 0.00390675435325 , 0.00304942377333 , 0.00361382575697 , 0.00228326837384 , 0.00221903278307 , 0.00130336663291 , 0.00107418603668 , -0.00394610722547 , -0.00165237767612 , 0.00305880992349 , 0.00279361590004 , 0.000650292704702 , -0.00521917158412 , -0.0010342840639 , -0.00312402118934 , 0.000607058604322 , -0.00171267881197 , 0.00056976457929 , 0.00400779984674 , -0.00323957919321 , -0.00409536091984 , -1.52817783413e-05 , 0.00032951906078 , -0.00144432857727 , -0.00100627373226 , -0.00249671393525 , 1.3658005584e-05 , 0.0011252459295 , 6.30825894474e-05 , 0.00437956741139 , 0.00385355673251 , -0.000420890443928 , -0.00140853045281 , -0.00225454794715 , -0.000162158458912 , -0.0026685393522 , 0.00404588061617 , -0.000113703943086 , -0.00146685774855 , -0.00222414337532 , 0.00232855730906 , 0.000759733352285 , 9.60211149219e-05 , -2.17235167531e-06 , -1.36131194543e-08 , 0.00475270737809 , 0.00313973972793 , 0.00127366765736 , 0.000244169873385 , 5.70261038013e-05 , -1.99063032137e-07 , 0.00177029347473 , 0.00216296642158 , 2.90174284507e-05 , 0.000461892483812 , -0.000621385026483 , 0.000697831407789 , -0.000369909507809 , 0.00602742048465 , 0.00442001397287 , 5.45387075517e-06 , -0.00226605840914 , 0.00164550816042 , -0.00371560455084 , -0.000275539540129 , 0.00287757401821 , -0.00212052507601 , -0.00527961275264 , 0.00127792190422 , -0.000148646982071 , -0.00148429293919 , 0.000590414534855 , 0.00351205941929 , -0.00410207343633 , -0.00179706456916 , -0.0017135738886 , -0.000253107167422 , 0.00260925229873 , 3.58672397574e-05 , -0.00795292802189 , 0.00147291751565 , 0.00281834714695 , -0.00387283208274 , -0.000263094663047 , -0.000117246577531 , -0.00018121291595 , 0.00240355044868 , 0.00431161199303 , -0.000205055554544 , 0.00421676439137 , 0.00230216384385 , 0.00576414898869 , 0.000190246986577 , 0.00399317424615 , 0.00315605823108 , 0.00470676007642 , -0.000208741001014 , -0.00451778600311 , 0.00783050032582 , -0.00442426002628 , -0.00542671530936 , 0.00424583721902 , -0.00175588985422 , -0.00484591745748 , -0.000315892821262 , -0.00247463299107 , -0.000115078490517 , -0.00485754751496 , -0.00299160737666 , 0.00166963634143 , -0.00516062863466 , -0.00165920982151 , -0.000750647767296 , -0.000154097887799 , 5.12557495871e-05 , 8.90205740988e-05 , -0.00488933920863 , -0.00147731627512 , 0.00159960359038 , -0.000471919494938 , -0.00398070053975 , -5.32197281587e-05 , -0.0049260209284 , -0.00405879555859 , 0.000617908463609 , 0.00488969703546 , 2.16018572264e-06 , 0.00100733720224 , -0.00463501075654 , -0.00483121777033 , 0.000378931522588 , -0.000549243456281 , 0.000820288714655 , -0.00485786129862 , 0.000470912392078 , 0.00592617064569 , -0.0059545913548 , -0.00917664192334 , -0.00598309816198 , 0.000772549639594 , 8.46286747654e-06 , 0.00116221129368 , -0.00029180940524 , -0.000243897234989 , 0.0011439878997 , -0.00258035458694 , 1.77649526931e-05 , 0.00102831100916 , 0.000345759516493 , -0.00397667439928 , -0.00169274985137 , -0.00044342823804 , 2.13487992275e-05 , -0.00419857508862 , -0.000653911803922 , 0.000164305615663 , 0.00130990313235 , -8.80908655683e-06 , 0.000446475105485 , -0.000683585668955 , -0.00605949788807 , -0.000459943787933 , 0.000150170046513 , -0.00317287060833 , -4.87094188904e-05 , -1.83336358006e-06 , -0.000985834381258 , -0.000931787841907 , 0.0069842542102 , 0.00148134835185 , 0.00104234039326 , 0.00139470816243 , 0.00208323857171 , -0.00122630506769 , 0.00562643339785 , -0.00396361268108 , 0.00395526693896 , 0.000454121375483 , -0.00378505394284 , -0.00273928505755 , -0.00102178085586 , -0.00348915173227 , 0.00030464930329 , -0.00121968928709 , 0.00239012299711 , -0.000295762318734 , -0.00161457251452 , -0.000636963589798 , 0.00343991099209 , 0.000761335039748 , 0.00380269053532 , 0.000338021554624 , 0.00126653699615 , 0.00343600939391 , 0.00733641691708 , -0.000466833066078 , 0.00339192796441 , 0.00313240473365 , 0.000419531889933 , 0.00245653937326 , 0.0014647955081 , 0.0019178738273 , 0.000537873040554 , -0.000136907797724 , -0.0010182220794 , -0.00048347498223 , -0.00119286121727 , -0.00374948976061 , -0.00314282492632 , 0.00151348289545 , 0.00330683395715 , 0.00345919804794 , 0.00363269858278 , -0.00500831775812 , -0.0014652141198 , -0.00154359559818 , -0.00216781017348 , -0.00201328148868 , 0.0017731323515 , 0.00418677381886 , 0.000252494612352 , -0.000817857364052 , 0.00177743704857 , -0.0034481353991 , 0.000319155303294 , -5.28142593541e-07 , -0.000293252637389 , -3.48749214577e-05 , -0.00456219075667 , 0.000472529286001 , -0.00328072528763 , 0.000862006997032 , 0.000151404561148 , -0.000263189881814 , -0.00107833867483 , -2.66405693035e-06 , -0.00136632599364 , -0.000913097073176 , 0.00062966407921 , 0.000665835886316 , 0.00310191550097 , 0.000305475405663 , -0.000522604018279 , -0.000160045126724 , -0.000291076914101 , -0.000297754337769 , 2.69989792592e-05 , 0.00200336068447 , -3.76931496592e-05 , -0.00498767493831 , -3.39113391077e-06 , 0.00151426852458 , -3.23768677931e-05 , 0.00120308191839 , -0.00187448171603 , 0.000345969941893 , 0.00171340095194 , -9.92112405353e-07 , -0.00375127451661 , 0.00150608320312 , 0.000457834314806 , 0.000763905916294 , -0.00096237852437 , -0.000182019224968 , 0.00276654097767 , 0.00439428343983 , -0.00211217408572 , 4.75151154973e-05 , -0.00261136050898 , -0.000249168819434 , 0.00778731732978 , 6.58398017258e-05 , 0.00216335209483 , -0.000413154981873 , -0.0027683475881 , -2.4790894248e-05 , 0.00634998020095 , 0.00238064831232 , -2.1102543113e-06 , -0.000589620984316 , 5.39114712063e-06 , 0.00018358279773 , 0.000975981068219 , -0.00527156580968 , 0.00147420479187 , -0.00156288992664 , 0.00362933622414 , 0.000298728685808 , -0.00349886438315 , 0.00030820659697 , -0.000378790392074 , -0.00318917393551 , -0.000948667675959 , -0.0010775600928 , 0.00223613959278 , -7.85245342615e-05 , -5.12609618333e-05 , 0.000349442292598 , 4.58323788256e-05 , -0.00412836966855 , -0.00455312742074 , 0.000188284106843 , 6.3054649893e-05 , 7.6298825204e-05 , 0.00245346009779 , -1.27921429436e-05 , -0.00350242907279 , 0.000648669900736 , 5.99717585385e-05 , -0.00234494369405 , -0.00013162845417 , -5.12413413137e-05 , -0.00402852631513 , -0.00135063921239 , -0.00324242844059 , -0.00010445939074 , -0.00266205115741 , 0.000981226744154 , -0.0025198238362 , -0.0014771900144 , -0.000174752466698 , -0.000133552987977 , 0.00150497269203 , 0.00544302455545 , -0.000106578065677 , 0.000333869840982 , -0.000449009253076 , -0.00724495203502 , 0.000126806873096 , 0.00228143514529 , 0.00264122393787 , -0.0016376884762 , -0.00179105159277 , -0.00119415697554 , 0.00526316065218 , -0.00190868650715 , 1.72075432014e-05 , 0.00331260524784 , -0.00332190537829 , 0.000174357601116 , -0.000697856284457 , 0.00367504619392 , 0.00428937437563 , 6.31475752217e-06 , 0.0043302595521 , -0.00271037001193 , -0.000900763455043 , 0.000526586330652 , -1.0408475834e-05 , -0.00117489384813 , -6.53651467111e-05 , -0.00531810347066 , 0.00419979617773 , 0.00629801244975 , -0.000357788487935 , 0.00118124763247 , 0.00189013570196 , -0.00551057913677 , 0.000400936006677 , -1.27811477675e-07 , -0.00543608733314 , 0.00340612090129 , -0.00525127374238 , 4.83876035054e-06 , -0.00325074038715 , 0.00383472992114 , -0.000858480148372 , -0.000774093558558 , -0.000875324783736 , 1.11549124134e-06 , -0.00501556167035 , 0.00326085355907 , -0.0059112711669 , -0.00425347966183 , 0.00102475620339 , 0.00120654075917 , 0.00107938028885 , -0.00403788096576 , -0.00283308608478 , -1.71696851921e-05 , 0.000896373817416 , -0.00116543457539 , 0.000950407010835 , -0.00567875623478 , -0.00130935436068 , -0.00258275256366 , -0.00465153169223 , -0.00038681810028 , -0.00222990938635 , -0.00246205979123 , 0.00261074699306 , -0.00105858437948 , 0.00397691226024 , 0.00333469544742 , 0.000241991376997 , 6.25605890713e-05 , 0.00685526292304 , ])
Y_4_4_imag = flex.double( [ 0.0 , 0.0 , 0.00415786117878 , 0.00329990760694 , -0.00442207053881 , -0.00256034981417 , 0.00526015350311 , 0.00230803857166 , 0.00244162966409 , 0.00579975531358 , 0.00181551755288 , -0.000144442663717 , -0.000177767412411 , -0.000365261091016 , -0.000210655540355 , -0.0015127072527 , -0.00490223787836 , -0.000334224037112 , 0.0031906643223 , 3.06818955129e-05 , -0.00283077204106 , 0.0047523868142 , 0.00516187719101 , -0.00118925366784 , 0.00822959310387 , 0.00113425841634 , -0.000253878037117 , -0.00113710296699 , -0.000701974268894 , 7.1436412172e-06 , -9.34934610951e-05 , -0.00151925367958 , 0.00110394248996 , -0.00245273748637 , 0.00448508208454 , 0.00326670034792 , 0.00240650051144 , -2.18846549193e-05 , -0.000329761640276 , -0.00359948121079 , -0.00444739563587 , -0.00375391030134 , -0.00190547995367 , -0.00107542707887 , 0.000666149503236 , 0.00461715775877 , -0.00132428179958 , -0.00303355966788 , 0.00430230367548 , -0.000637778435063 , 4.94794863918e-05 , 0.000513521312602 , 0.00412934915996 , -0.00260826347259 , -0.00280637323179 , 1.86852525153e-05 , 0.000115861483467 , -0.000423283060879 , 0.000663674506829 , -0.0067261806078 , 0.00341534152854 , -0.0067922680659 , -3.59035203821e-05 , 0.00170582678466 , -0.000382166359796 , -0.00114748072027 , 0.0040224421115 , -0.00103612573518 , 0.00114191048011 , -0.00374528082772 , -0.0025991367281 , -0.0011869319362 , -0.00387981738266 , -0.000375550598488 , 7.54152446477e-06 , 0.00175242845722 , -0.000692636588577 , 0.00642686978357 , -5.7553110438e-08 , -5.50521581032e-05 , 8.17892522447e-05 , 0.00400508480042 , 0.00202406662775 , -0.0027300712123 , -0.00394282912904 , -0.00462340351783 , 2.26411856835e-05 , 0.00160232112514 , 5.75113027676e-05 , -0.00159663031439 , -0.00226105578723 , 0.000273362463827 , -0.00118607238088 , 0.000251823692702 , 0.000870390759358 , -0.00297260522539 , 0.000108710364523 , 0.00444557053462 , -0.00280407890607 , -0.00119749647791 , -0.000978958858752 , 0.000528831307512 , 0.00178062372362 , -0.00131805733826 , 0.0040535165485 , -0.000973469101494 , -0.00293308254344 , -0.00328113450462 , -0.00397517620858 , 4.54207797422e-06 , 4.93893900989e-05 , -0.000355433392436 , 0.00327045239925 , 4.19671048958e-05 , 6.35386839957e-05 , 0.000839338187155 , -0.00178974014432 , 0.00284020130277 , -0.00158139500019 , 0.00105107510692 , -0.000254242305474 , -0.000539016883652 , 0.000649469954623 , 0.000415320611701 , 0.0012207940356 , 0.00478803940871 , -0.00677553871633 , 2.80411182737e-05 , -0.00513409337383 , -0.000216229482061 , -0.0024681421958 , 0.00295224958662 , -0.000644291276267 , -5.61705376169e-05 , 1.57788864056e-05 , 0.00358530511694 , -0.00375050617425 , 0.00378152316307 , -0.00233889155192 , -0.00184948179407 , -0.000614379842019 , 0.00555497932877 , 0.00219478871922 , -0.000262654701001 , 0.00635285477494 , 0.000462873216404 , -0.00418269656399 , -0.00467918862926 , -0.00151865507228 , 0.00175706915202 , -0.000197452952414 , -0.00411233469802 , -0.000554997051635 , -0.00205682163477 , -0.00365499872701 , 0.00209610515702 , -0.00286793145753 , 0.000861129006995 , 0.00234992405163 , -0.00226062610625 , 0.00265655175627 , -1.84252896774e-05 , -1.80674542435e-05 , 0.00759078803261 , -0.00585448351203 , 0.00381462560019 , 0.00730980870398 , 0.000262165882251 , -0.00472967535712 , 0.000238720955092 , -0.00190514385765 , 2.56587860254e-06 , -0.00249127857615 , -0.000332833898554 , -0.000275626561877 , 0.000220447502522 , 0.00599788905345 , 0.00150385116172 , 0.00148084021275 , 9.105992968e-05 , -0.000680307150128 , -0.000129888403937 , -0.0063890194004 , 0.000364414469174 , -0.00194332182701 , -0.000136382561442 , -0.0006199403893 , 0.00207525251015 , 0.00757626197293 , -3.45826812228e-05 , -0.00248288064147 , 0.00103425322636 , 7.22369484804e-06 , 0.00174528011039 , 0.000911530609518 , -0.00137168166312 , 1.27523330947e-05 , -0.00057752664968 , 0.000995955683174 , 0.00387878326362 , 0.00238729824571 , -0.000212684511699 , 0.00305698876937 , 0.0043537424881 , -0.000218038644776 , 6.04390342393e-05 , -0.00101620665497 , -0.000119527740323 , -0.000433362870098 , 0.00121061036443 , 0.0012443602079 , 0.00012358123294 , -3.10382545068e-05 , 0.00355568250693 , 0.0030629709353 , 0.00465575809519 , 0.0042285166259 , -0.00113412288278 , -0.00143664992168 , -0.000302039065399 , 0.00589020179475 , -0.000699528171633 , -0.00106809080025 , -0.00448437763459 , 0.00442028452991 , 0.000652539768145 , -0.00230336461091 , 6.21175072834e-05 , 0.0027285031333 , 0.00107696952868 , 0.00188332076301 , -0.0033955750531 , 0.000659467947785 , -0.00286983702319 , 0.000618255649164 , 0.00259608274416 , 0.00033576930814 , -0.00209375845657 , -0.000524966220829 , -0.00256913868286 , 0.00411420276639 , -0.000584723385479 , -0.00426829876494 , -0.000820234172303 , -0.00195505185505 , 6.84554839561e-05 , -0.000194045038806 , -0.000176046428408 , -0.00249234636225 , 0.00582042862569 , -6.4848395556e-06 , -0.000188570410281 , 0.000147793389544 , 0.00534679788972 , 9.8152981965e-05 , -0.00139145743712 , -0.000937984957072 , -0.00266868081778 , 0.00309956453261 , -0.00179995041029 , -0.000721137279023 , -0.000371764780396 , 0.0015526899081 , 0.00474635277108 , -0.00245503410576 , 0.00244684548538 , 0.000994891844518 , 0.000475862413232 , -0.000954403528349 , 0.00127661823655 , 0.00449344732372 , 0.00218114595356 , 0.000803117993431 , -0.000661771906596 , 0.00214738318126 , 0.0016368931197 , -0.00324397165145 , -0.00539677981368 , 0.0025644870661 , 0.00328077253062 , 0.00450491295819 , 0.00156709156272 , -0.0037138350011 , -0.00144669693363 , -0.00619384843528 , -0.00246814833637 , 0.00193329791696 , -0.00404110139482 , 0.00409071546767 , 0.00339819047979 , 0.00220429524656 , 0.000346796378287 , -0.00300816039252 , -0.00587784416922 , 0.00151753196249 , 0.0048946161404 , -0.00141378839713 , 0.0043397585413 , -0.00310193591004 , 0.000569588011443 , -1.08834863293e-05 , -0.000345439601955 , -0.00141405726679 , -0.00769892243435 , -0.000111836964377 , -0.00215176675677 , 0.000134276775684 , 0.00054626747526 , -0.0043791826374 , 0.00252738164741 , -0.00388057520476 , -0.00456352742463 , -0.0051178271783 , 0.00439947636168 , 0.00646255074932 , 0.000488495575602 , 0.000909464033524 , 0.0027284387037 , -0.00119895261193 , 0.00218422875274 , -0.00210846923928 , -3.37365302386e-05 , 0.00338823033035 , -0.00356809829607 , 0.000369486627279 , -0.000888243102872 , 0.00562007169133 , 0.00174072491118 , -0.00113591255154 , 0.00251920156899 , -1.98203838847e-07 , 0.00197081755278 , 0.00155978678627 , 5.76875889766e-05 , 0.000297921766308 , -0.00280312207547 , 0.00419909631999 , 5.41956426048e-05 , -0.00273177693039 , -0.00101291063796 , 0.00100682512061 , -9.45125589855e-05 , 0.000894958449903 , -0.00385547598059 , -0.000229496520762 , -6.18608495003e-05 , -0.00435053370242 , -0.000221252883269 , -0.00541425602188 , -0.000506674302005 , 0.00188589722967 , 0.00455473252379 , 0.00192995856664 , -0.00140156151857 , 0.00331325178598 , -0.00606780025142 , 0.00274692076421 , -0.00582107964997 , -0.00058378965153 , 0.00222337057194 , 0.0056897046096 , 4.2638614366e-05 , -1.01501008434e-06 , -0.00400594549062 , -0.00553208562587 , -0.00225636851365 , 0.00492161571789 , -1.75040083351e-06 , -0.000951831199016 , -0.0027436457418 , 0.000473535929485 , -0.00284501948447 , 0.0024833372806 , -0.0061749137409 , -0.00442624182347 , -0.00556729109821 , -0.00328758790624 , -0.00289776163366 , 0.000310203216231 , 0.00180952444141 , 0.0032387205369 , 0.000775121429746 , -0.00152162405964 , 0.00465063548983 , -0.00209467475884 , 4.61609253563e-05 , -0.0014352729922 , 0.00158554036569 , -0.000306877116566 , 0.00388354368365 , -0.000606631016318 , 0.00257030479271 , -0.000529561459433 , 0.00540349628819 , -0.000544457558725 , 0.00492131231631 , 0.000297022180637 , -0.000473169951122 , 0.00413756601306 , 0.00539265319977 , 0.000719181234628 , -0.00573042444342 , -1.35591476027e-06 , -0.00242676417891 , 0.000642517236548 , -0.000765586697081 , 1.78146196989e-05 , 0.0002068323019 , -0.000929239368748 , 0.0030707571142 , 0.00055293061423 , 0.00523086755245 , -0.00366457727758 , 0.00130513894289 , 0.000146530919501 , 3.06768623168e-05 , -0.000307669224966 , -0.00612027170134 , 0.00155665825022 , -0.00228750412797 , 0.00254938809195 , 0.00037568084199 , -0.000138215876663 , 0.00346942634428 , 0.00111167467976 , 0.000389157452446 , 6.83611815689e-05 , -0.00220535839262 , 0.000701050499703 , 0.000683979503031 , 0.000266357375291 , -0.00472875556526 , 0.00333064533168 , 0.00636937356131 , 0.00216113434383 , -0.000146273858726 , 0.00545524096151 , 6.25424302726e-06 , -0.00728058708044 , 0.000101304340561 , -0.002861717335 , -0.00113830221076 , -0.00080386217733 , -0.000289160125684 , 0.00081588389484 , 7.83770799479e-05 , -0.00042002451829 , -0.00309202988387 , 0.00392940603803 , 6.87912467642e-05 , -0.000414028416321 , -0.00529801005971 , -0.00304899105441 , 7.20894422013e-05 , -0.000773330219031 , -0.000527629032838 , 0.000687201327123 , 0.00132437351406 , -0.00429566315358 , 0.00177025046678 , -0.000746485840571 , -0.00354097953454 , -0.000810124218319 , 0.000598865306995 , 0.000240987808652 , 0.00337499676921 , 0.000203637078938 , -0.00468059232114 , -0.000194854950744 , 0.00478002063336 , -0.000341939372032 , -0.00194523705351 , 0.000653472824197 , 0.00686608952374 , -0.00118437170438 , 0.000402520436019 , -0.00499416568983 , -0.00361106432726 , -0.006215555302 , -0.00414285483815 , 0.000439053346251 , -0.00114794057832 , -0.00036429288293 , 0.00136249742868 , 2.11350862017e-06 , 0.0014808755218 , 0.00154171033389 , -0.00557669536499 , -0.00318326249522 , 0.00261084965803 , -0.00549961261745 , 0.00503135625583 , -0.00123649283902 , 0.00204390078188 , -0.00191352420496 , 0.000761225657542 , -0.00148117694808 , 4.01431214705e-05 , -0.00271896408529 , 0.0050153750609 , -0.000117621243658 , 0.000463644906309 , 0.000232416243115 , 0.00376126366514 , 0.00127786715622 , -0.000491796760854 , 0.00124430582684 , 0.00275869119041 , -0.000922128454449 , 0.000506150354962 , 0.00143727178552 , 0.00752335177583 , 0.000450120852222 , 0.00227995252191 , 0.000877824540766 , 0.00559813948068 , 0.00225910072873 , -0.00381591505092 , 0.00155361431099 , -0.00752843078787 , 0.00227215596197 , -0.00814850418641 , 0.00129572650475 , 9.80587849591e-05 , -3.52130744409e-05 , -0.000516603902284 , 0.00110319122261 , -0.00273290950653 , 0.00719547122474 , 3.46737227505e-06 , -0.000180223495433 , 0.000415316059532 , 0.00166401036482 , 0.00261702901818 , -0.00408917673512 , -9.99505793817e-05 , -0.00156464632676 , -1.11717429587e-06 , 0.0035606762209 , -0.00424799071595 , 0.000912264576442 , -0.00288591934548 , 0.00457041994941 , 0.0055477560402 , 0.000188676032655 , 0.00611694748827 , -0.000114628550599 , -7.56104266435e-09 , -0.00228822855006 , -0.0068163494836 , 0.00286286540063 , -0.00140763195476 , 3.72686114049e-05 , -9.31474570585e-07 , -0.00103565650061 , 0.000118261092262 , 0.000102721816662 , 0.00215000396239 , 0.000132260447863 , -0.00172399428635 , -1.36452000856e-05 , 0.0030592079006 , 0.00158685004543 , -2.39769581214e-05 , -0.00643765478669 , 0.00248695534219 , 0.00110722597673 , -0.00177400482413 , -0.00183249952015 , 0.00434073303659 , -0.00347586635192 , -0.0021991687106 , -0.00537169813453 , -0.00509077200005 , -0.00352693076213 , 0.00379232190506 , -0.00232627349629 , 0.00220328586207 , -0.00272925940229 , -0.000134139179878 , -0.000585899386689 , 0.000409293051881 , 0.000602224597545 , 0.00572509653513 , -0.00387150616065 , -0.0042690806086 , -0.00223753290891 , 0.00246293480898 , -4.4613927937e-05 , -0.00118835775104 , -0.00247099183621 , 0.00121405355674 , 0.000173821856067 , 0.00523079691851 , -0.0040603550038 , 6.45591630973e-05 , 0.00360039297104 , 0.00254285964145 , -0.000351458480405 , 0.000126186579406 , -0.000306036458536 , -0.00379932997958 , -0.00242651561146 , 0.00190977046778 , -0.00111024889641 , -0.00440112545155 , -0.00025617480494 , -0.000104898683605 , 0.00105053181859 , 4.35297165137e-05 , -0.00327874200679 , -0.0043183789687 , -7.27697673337e-05 , -0.00218518104582 , -0.000486555565323 , -0.00517916586301 , -0.000138260228757 , -3.58769213749e-05 , -0.0041007656291 , 0.00489424398159 , -0.000634973461475 , 0.00413390328057 , 0.000172187022186 , -0.00106861560532 , -1.40984274818e-05 , 0.00100508696228 , 0.0012145670044 , -0.00137962986256 , 0.0021136282046 , 5.7794474589e-07 , -0.00278257921514 , 0.00383336464192 , 0.00184648770247 , 0.000242560021274 , 0.00286368092331 , 0.00573798876533 , 0.00254096248852 , 0.000611101930679 , -0.00211036261826 , -8.40966286697e-05 , 0.00190594084617 , 0.000232598411138 , -0.000572622531529 , -1.62766892034e-05 , 0.0027097672541 , -0.000187430476358 , -0.00407055373229 , -0.00229553571532 , 0.0035484935796 , 0.000115665858493 , -0.00215241408715 , -0.00300139316424 , -0.00252524316889 , 0.00486051558368 , 0.00269253389818 , 0.000201753755828 , 0.00207040198324 , 0.000450123312611 , 0.000226354934042 , -0.00062054930195 , -7.83335829167e-06 , 0.000360856298464 , -0.000535318630394 , -0.00229477314011 , 0.000709862372522 , -8.53749948307e-05 , -0.00583037400213 , -4.86147233483e-05 , -5.80364323333e-05 , 0.000176596300436 , -0.000209288405595 , 0.00161631282254 , -0.000268241648244 , -0.000345806666782 , 0.00340632629865 , 0.00513397298873 , -0.000691915932882 , 0.000232963987361 , -0.00269962427238 , 0.00105566576653 , -0.00628030286542 , -0.0018055277303 , -0.000141749698984 , -0.00358455643855 , -0.00476349622633 , -0.000913851725338 , -0.00233087167597 , 0.0037057709248 , 0.000540747385827 , 0.00406829360549 , 0.000763556058948 , 0.00263015516456 , 0.000675712929863 , 0.000160760252357 , -0.00146019031354 , 0.00514644046559 , -0.000583679474617 , 0.00423512885838 , -0.000332529395045 , -0.00421091768184 , -0.00414313165506 , 0.00567419856594 , 0.00495330603492 , 0.00448819568864 , -0.000685015576761 , -0.0025537031066 , 0.000389423985609 , 0.00146737197692 , -0.00566177054091 , 0.000789316675739 , 0.00306380955741 , -0.00334863126691 , 0.00665780816763 , -0.0027107632595 , -0.00542239803674 , 0.00680222775384 , -0.00514864977865 , 0.00548951443567 , -0.00314416469704 , -0.00101382676849 , -0.00144927739419 , -0.00287920606404 , -0.00055026089097 , -0.000258864328889 , 0.000538125653562 , 0.00194872486518 , 0.00480081124498 , -0.00553502704779 , 7.03324530175e-09 , -0.00269656262246 , 3.55031769397e-05 , -0.00231932583827 , 0.00141219089002 , -0.00186143910899 , 0.000569412858237 , -0.000584592719566 , 0.000388475743658 , -0.00393241344749 , 8.64547448269e-07 , 0.000687636696685 , 0.0037636199501 , -0.00431165264033 , -0.000331018498256 , -0.00366371721636 , -4.24011126019e-05 , 0.00157160474713 , 5.38577195436e-05 , 0.000349553024345 , -0.000628739149859 , 0.000125269724045 , 0.00129427514541 , 0.000770590777615 , 8.12147238368e-06 , 1.98270150668e-06 , -0.0027909964455 , 7.84852998326e-06 , -0.000186151592 , -0.00319262732545 , 0.00198348299968 , 0.00022889851064 , -2.123497012e-06 , -0.00542578946441 , 0.00136674113578 , -0.000732917503599 , 0.00319380627082 , 0.0040476829124 , 0.000292412717319 , -0.00150940496216 , -0.00682506097219 , -0.000194547414688 , -0.00221112674741 , 0.00237958072801 , 0.00253742631972 , -0.00133013466787 , -0.0004053368508 , 0.0014203780442 , -0.00135582851489 , -0.00785518721284 , 8.44141325238e-06 , -0.000250150474383 , 0.00310458559891 , -7.88613134878e-06 , 0.000383834629078 , -5.14564060213e-06 , 0.00230214239065 , 0.00175710284589 , -0.00211621627189 , -0.00214346418336 , -0.00162296271718 , -3.81949966489e-05 , 4.49429419348e-05 , -0.00229674461831 , 0.000594352539823 , 2.52185310962e-05 , 0.00430316832359 , 0.00102490409488 , 0.00128146269512 , -0.00510734446192 , -0.000304405534903 , -8.90905150555e-05 , 0.000858120395713 , -5.35306623344e-05 , 0.00631854439337 , 0.000592260395063 , 0.00155700900437 , -5.38026536184e-05 , 0.00221725941033 , -4.68955405126e-05 , 8.28359536559e-05 , 0.00172934594051 , -0.00419771456596 , 0.00216927244357 , -0.00925436800355 , -0.00096031896076 , -4.4741884688e-05 , -0.00127010022472 , 0.00512669089329 , 0.00421624225996 , 0.000436421496165 , -0.00589468952698 , -0.0047343577225 , 6.85063565483e-05 , 0.000248843858847 , -0.000120931326266 , -0.000296509630033 , 0.0007263817513 , -0.00379083081692 , -0.000666907403488 , -0.000332925540186 , -0.00300033266021 , -0.00540908274733 , 0.00114506715026 , -0.00489641808147 , -0.00262608318405 , 0.00143912626232 , -0.0059488739717 , -0.00325762808975 , 0.00134304876618 , 0.00597503589316 , 3.21510389631e-05 , 0.00278105419531 , 0.00432818632785 , 0.000396698396424 , -0.000725612812724 , 0.00236993970173 , -0.000221209620111 , 1.18450978781e-06 , 0.000505877520012 , 0.00416123022646 , 0.00100124718493 , -0.000472485302428 , 3.30045910955e-06 , 0.000698592872485 , 1.13447559058e-05 , -0.00180535581726 , -0.00310905454636 , 0.000308625427729 , 0.000155693835167 , -0.00634490448707 , -0.00176472978835 , 0.00115597510109 , 4.8707226904e-05 , 1.20819989677e-06 , -0.00381922339881 , 0.0016464719495 , 0.00293493649382 , -0.00117471912054 , -0.0011395173835 , 0.00188465351192 , 0.00761506845577 , -0.00449417164453 , 0.00120061329497 , 9.91285816475e-07 , -0.00285512949181 , -0.00434320215528 , 0.00437752749771 , 0.00238745684963 , -9.06274505164e-06 , 0.00493262848242 , 0.000379097520475 , 0.00277411098314 , 0.00424236641732 , 6.45108983147e-06 , -0.00526862823668 , -0.00129523843172 , 0.00179000099707 , -0.0022108566439 , -0.00257250543989 , -0.00121791477432 , 0.00138011904638 , 0.00311321799511 , 0.000106390287246 , -0.000551324570258 , 0.00630000393978 , 0.00646158394289 , 0.00464794544093 , 0.0014910710092 , 0.000180415811671 , -0.000220240659295 , -0.00240644838215 , ])
Y_5_m5_real = flex.double( [ 0.0 , 0.00816188103446 , -0.00413044165019 , -0.00766770778346 , 0.00203327428432 , -0.00209415165741 , -0.00271169511383 , -0.00452788196997 , 0.00192580778194 , -0.00695312625518 , -0.00213779442782 , -6.51162432766e-05 , -2.76904177762e-05 , 0.000243949205938 , -5.25798802383e-05 , -0.00347411339406 , -0.00537520891845 , -1.01642060964e-06 , -0.00391281223658 , -1.22506773814e-05 , -0.00611553473309 , -0.000836189437732 , 0.00467898902744 , -0.00278445901683 , -0.00212695314784 , 9.15615761489e-06 , 0.000932894421955 , -0.00142142323225 , -0.000671938506311 , -3.03848912477e-06 , -1.205273681e-05 , 0.00178016290882 , -0.00144424041419 , -0.00378782824557 , -0.00465807553995 , 0.00266676373753 , 0.00566193746365 , -8.26899869849e-06 , 0.000267448766563 , -0.00153020426943 , 0.00524978352339 , -0.00187850077633 , -0.000561211732929 , 0.00194398195913 , -0.00306474023023 , -0.00245087171193 , -0.0031089330066 , -0.00407694243516 , 0.0036792427072 , 0.000925713662384 , 6.40220840586e-05 , -0.001754705323 , -0.000846127243614 , 0.00337748633724 , -0.000335311906873 , -1.28683689077e-05 , 2.01715155109e-05 , 0.00546882664273 , -0.00024494690741 , 0.00503291841104 , 0.00592650773395 , 0.0036593319021 , -4.21538559571e-05 , 0.000905074576994 , 0.000265097131823 , -0.00405724134749 , 0.00233687636242 , -0.00652554753628 , -0.000917627006973 , 0.000974489991383 , 0.00184232653022 , 0.00418234685975 , -0.0047938555004 , -3.5873877318e-05 , -2.0857023492e-06 , -0.00149886480304 , 0.00114755100213 , 0.00167756325746 , 1.88361520043e-08 , 0.000234927879728 , -0.000204484042555 , -0.00028390481618 , -0.00141000195486 , -0.00224980842843 , 0.00732567870685 , 0.00338165606754 , -7.38803273638e-06 , -0.000751346230982 , 0.000113350980557 , 0.00161273330101 , 0.000879093482474 , -8.64961753448e-05 , -0.000833263319153 , -0.000209694285941 , -0.000114439772823 , 0.00285490288987 , -3.77728466399e-05 , 0.00244860081537 , 0.00251445833081 , -0.000464487130674 , 0.00159606608258 , 0.0018275377738 , 0.00161184085392 , -0.00485834867935 , 0.00593510266866 , 0.00410295822718 , -0.00349244055019 , 0.00411896558327 , 0.00296085383302 , 8.92083219418e-07 , -6.12481661971e-05 , -8.88836912611e-05 , 0.000337851555052 , 1.3383496278e-05 , -1.65555058191e-05 , 0.000200249322206 , -0.00370264419452 , -0.000367779770872 , 0.00109388816258 , 0.000289074820781 , -0.0012415994449 , 0.000701602663485 , -0.000399536760498 , -0.00039093839333 , 0.00213136950868 , 0.00545837397869 , -0.00119892963097 , -3.95632243933e-06 , -0.00174739096048 , -0.000148663166634 , 0.00347536432516 , -0.00425248778648 , -0.000841628332424 , 2.53234541595e-05 , 7.89049023085e-06 , 0.00150486038348 , 0.000743050487437 , 0.00505524169047 , 0.0031646438263 , 0.00169365622876 , -0.000337139758406 , 0.00647480165051 , 0.00208290993055 , 0.000251398378842 , 0.00345884016939 , 0.00291799969894 , 0.00201871038261 , 0.00430069515898 , -0.000890661918846 , -0.00184775119793 , 0.00011046670424 , -0.00444923739647 , 0.000446863014894 , -0.00258799043424 , 0.00484250580815 , -0.00100160880657 , 0.00282954993039 , 0.000356506150157 , 0.0017507065801 , 0.00268711818515 , -0.00269078048502 , 4.23725673273e-06 , 1.87893728186e-05 , -0.00698281717268 , 0.00614321578629 , 0.00321243695583 , 0.00461777355131 , -0.00405581191333 , 0.00265863276853 , 5.12325619133e-05 , -0.00112859611843 , 1.66371314892e-06 , -0.00144750383422 , -0.0020810306582 , 0.000123426547619 , -0.000210772033726 , -0.00672694129176 , -0.000987440342185 , 0.00241207919683 , -4.91534865148e-05 , 0.00386590745838 , 0.00254228380319 , -0.00515906725662 , 0.000595126903053 , 0.00445179251488 , -1.46612683505e-06 , 0.000258778803254 , -4.20719445731e-05 , -0.00665272113239 , 8.486576681e-06 , -0.00214984358999 , -0.00150961370548 , 5.03004007816e-06 , -0.00477251007299 , -0.00221875110523 , -0.000837017577215 , 6.83298913869e-06 , 6.86808533865e-05 , -0.000805386069388 , 0.00502560771167 , -0.0028942337484 , -0.000693455795259 , 0.00106439868513 , -0.00493549274291 , -8.74335317734e-05 , 1.54042615911e-05 , -0.00121086709104 , 0.00144005817511 , 0.00584302736701 , -0.00142180573907 , 0.00078351844109 , 7.78010872757e-05 , 2.42436072462e-05 , -0.000846095133305 , -0.00292540015424 , 0.00195193742682 , -2.81273490525e-05 , 0.00113457709798 , 0.00151518050688 , 0.00102510930319 , -0.000322872589984 , 0.000944195541589 , -0.00200912518249 , -0.00609860899518 , 0.00339173121936 , 0.000794649376693 , 0.00271205566319 , -0.000559786546612 , 0.00352548813461 , -0.000329543337435 , 0.00412992818404 , 0.00361778026199 , 0.0057874486205 , 0.00392107862282 , -0.00667680995011 , -0.00332823656733 , -0.000261365402684 , 0.000727173096876 , -0.00026329105908 , 0.00187542623709 , 0.0034197531556 , 0.00374601148408 , 0.00390171049625 , 0.000707651457305 , 0.00216350366243 , -4.88548082528e-05 , 0.00501659727829 , 0.00143326563692 , 0.00314637717497 , 0.00564613903788 , 0.000258200821474 , 0.000233473689893 , -0.000110545083703 , -0.00307425012025 , -0.00016982731352 , 0.00572762215101 , -0.00672587943498 , -0.00336433496805 , -0.001398286169 , -0.0015154648453 , -0.000423781315793 , 8.27292432759e-05 , 0.00177068080456 , 0.00393004329835 , -0.00126195134146 , -0.00480754225468 , -0.00225932878147 , -0.000310322862969 , -0.000191797762517 , -0.00517272363267 , 0.00107064157392 , -0.00311212652525 , 0.000836004891336 , 0.00477792317183 , 0.000211996045686 , 0.00382098517881 , 0.00193862670584 , -0.00516916690731 , -0.00109249760557 , -0.00194363572448 , -0.00366386393522 , 0.000839845302394 , 0.00543951328696 , 0.000505716224862 , 0.00706809248484 , 0.000561353727316 , -0.000935980101725 , -0.00242283006305 , -0.00406123111075 , 0.00234132148872 , 0.00503961467941 , -0.000443592892795 , 0.00661863918319 , 0.00620191650197 , 0.00189317501821 , -0.00221947191408 , -0.000223398999383 , -0.000936347181429 , 0.000934866493425 , 0.00439802995911 , 4.67372572356e-06 , 0.000449777692161 , 0.000199740196603 , -0.00817835568217 , 0.000383561032665 , -0.000579134554896 , -0.00116884164399 , -0.000225383173953 , 0.000165950734272 , -0.00324398795459 , -0.00452890592354 , -0.00382001411382 , -0.00086555211303 , -0.00484537870274 , -0.00774362025384 , -0.000577837201815 , -0.000851419788379 , 0.00282317835615 , 0.000729569226008 , -0.00460795821148 , 0.00245806765822 , -1.20085607362e-05 , -0.001883213026 , -0.00436820026999 , -1.79844324412e-05 , -0.00434765719058 , -0.00352875982268 , -0.00212425085594 , -6.17564595134e-05 , 0.00135653157813 , 7.70713245757e-09 , 0.000655091235022 , 0.0011506674751 , 7.01937683103e-05 , 0.000137963464992 , -0.00363310570554 , -0.00314528045277 , 4.07999656115e-05 , -0.00794298324877 , 8.97142012101e-05 , 0.00131482689262 , 1.97150325411e-05 , 0.000452430338905 , -0.00581231344442 , 0.000619548514303 , -2.64358793586e-05 , -0.00397590195638 , -0.000125680823701 , -0.00472407576676 , 0.000629175805634 , 0.00505474533784 , -0.00447768801663 , -0.000407149438274 , 0.00237907024985 , 0.000357160712152 , 0.000552934270953 , -0.00114648008136 , 0.00620764143888 , -0.00155989521807 , -0.00184323220559 , 0.00164442825739 , -7.41192819421e-06 , 1.4161686278e-07 , -0.00182043215557 , 0.00191160439781 , -0.00165775058651 , -0.00375669454134 , -4.6653432046e-07 , -9.46145401835e-05 , -0.00276257808035 , 0.000164507199343 , -0.000698650109602 , 0.00205507275177 , 0.00414024917607 , 0.000880081918878 , 0.00455107117178 , -0.00348875148713 , -0.00174305802556 , -0.000282277366597 , 0.00115028273108 , 0.00143632572463 , -0.000989934496001 , 0.0036979030759 , 0.00224267150295 , 0.00143319321583 , -7.17437333291e-06 , -0.00114208613665 , 0.00145006752412 , 0.000286601097434 , -0.00108994518174 , 0.000750842177545 , 0.00275971046171 , 0.00168578462549 , -0.00377058703295 , -7.8085396329e-05 , 0.00584732816331 , 0.000227806437633 , -0.000102907718522 , -0.00297228055367 , 0.00426483713718 , -0.00045720643329 , -0.00652509381687 , 6.62138406893e-05 , 0.00170504827806 , 0.000644839344196 , 0.00052375224875 , 6.06338547706e-07 , -8.39294922601e-05 , -0.0015893191081 , -0.00199365050896 , -0.00423118252834 , 0.0054236419561 , 0.00393793345686 , -0.00166353849472 , -2.86297677804e-05 , -0.00146590862432 , 0.00210244582703 , 0.000669705770338 , 0.00486305812626 , 0.00452014043098 , -0.00264528400278 , 0.00411677734238 , -0.00451923866984 , -0.00346615862916 , -0.0013059811231 , -0.00340190036593 , -0.00100178968694 , 0.00299888862291 , -5.60087479178e-05 , 0.000472457873345 , 0.00244448944143 , -0.000257655072637 , 0.00360982458046 , 0.00646765687263 , -0.00120092889683 , -9.14442425183e-05 , 0.000522581238577 , -3.83431367317e-08 , -0.00342816665455 , -7.42915019539e-06 , 0.00080337247238 , 0.00103462409139 , 0.00031307569381 , -0.00433995838484 , -0.000568528901299 , -3.57524602616e-05 , 0.000384099316948 , 0.00132770371277 , 0.000233563066781 , 0.000226728070274 , -0.000465386871894 , 0.000971965478558 , -0.0015858785839 , 3.84299164044e-05 , -0.000633667799822 , -0.00038149493582 , 0.00240491157976 , 7.4944446067e-05 , 0.00439253985148 , -0.000650053275547 , -0.00378021796875 , -0.000741213443303 , -0.000568018317738 , -0.00038511324918 , 0.000310785089282 , -0.00363203598748 , -0.00331693410321 , -0.00376798872313 , 6.39334427015e-05 , 0.00559159826965 , 0.000147840347438 , -0.00161244485661 , -0.0028450059231 , 0.0059589515731 , -0.00553350222698 , -0.00112456629236 , 0.00454882528986 , -0.0030959594949 , 0.00386069762519 , 0.00169427252007 , -0.0023108776328 , -0.00197124880622 , 0.000127637069724 , 0.00286934156029 , 6.17442644098e-07 , -0.00116555607755 , 6.03716673278e-05 , -0.00281703590485 , 6.5243253788e-05 , 0.00712582794267 , -0.00206365423064 , 0.00611418147274 , 0.000405168311857 , 0.00404441064281 , 0.000938673053029 , 0.000819425188844 , 2.12568299022e-05 , -0.000188298252979 , 0.00321222490389 , 0.00540684739719 , -0.000477389327059 , -0.000183588007271 , 0.000477104777081 , 0.00443589268804 , 0.00151097637173 , 0.00348104100158 , 0.00132505954157 , 0.00325236133219 , -0.000873453400337 , 0.000431566978484 , 0.0013033601036 , -0.00497135373948 , 0.00255266025035 , 0.00217325136669 , 0.000686202714784 , -0.0018783183043 , -0.00124125998527 , -0.00160432394209 , -8.79621733239e-05 , -0.00627889856956 , -0.00190241380686 , -0.00937167524048 , 0.000987401426961 , -0.00295378936063 , -9.24078767117e-06 , -0.000437076047666 , 0.00136751600602 , 0.00196966993154 , 0.00576644715504 , 3.41464407403e-06 , 0.000199447755911 , -5.54148750157e-05 , 0.00208537429418 , -0.00357967224182 , -0.00353395894635 , 0.000656340791433 , -0.00279870828259 , 5.02064471068e-05 , -0.00166428886087 , 0.00324768220099 , -0.00052932455708 , -0.0018323398907 , -0.00289144769505 , 0.00610205029106 , 0.000168457617716 , 0.00233859333222 , 4.12101124528e-05 , -9.70629940785e-11 , -0.00446836988036 , 0.00774473300165 , 0.000358191213221 , 0.000180698320295 , 1.79138419853e-05 , 6.78866504785e-08 , -0.00128278017999 , 0.000114746919655 , 2.62291677282e-06 , 0.00172255619921 , -0.000353613218453 , -0.000124284598862 , 0.000183713850596 , -0.00579114138074 , -0.00443397857476 , 6.65420929106e-07 , 0.00480902264457 , -0.000845127119776 , -0.00144926353635 , 0.0012095013074 , -0.00202021591067 , 0.00414794117378 , 0.000368959551933 , -0.000562841718243 , -0.0051289280054 , 0.00375374964114 , 0.000578941668101 , 0.00270692438521 , 0.000618112956995 , 0.00089020346506 , -0.00278969078754 , -2.34158181495e-05 , -0.000621177300068 , 0.000189730290329 , 0.00531902383343 , -0.000451060198365 , -0.00459456304287 , -0.00143645085138 , -0.00142180565394 , 0.00100530375668 , 3.85020926243e-05 , -0.00133687660165 , -0.00408180345928 , 0.000671271300175 , -0.00415907643706 , -0.00594660957896 , 0.00510029576219 , -7.93665528601e-05 , -0.00314633496761 , 0.00318684886984 , 0.0048247534566 , -1.20756995709e-05 , -0.00274619054545 , -0.0048233232349 , -0.000774040784372 , 0.00213689272258 , 0.00391358842097 , -0.00331316587339 , -0.00332311365121 , -0.000165871920032 , -0.00233951309607 , 1.5321639128e-05 , -0.00575306992001 , 0.00224342323075 , -0.00121585117466 , 0.00548894534724 , -0.000595921432819 , 0.00438423288993 , 1.28084147286e-05 , 1.52674086922e-05 , -0.00135206677879 , 0.0068017588603 , -0.000310989177094 , -0.000318228463158 , 8.51375847169e-05 , -0.00327440260532 , -8.50804088746e-06 , 0.00246671442812 , 0.00179239947149 , -0.00133946098936 , -0.00258225057807 , -1.09231085083e-07 , -0.00293135040777 , -0.00623346440952 , -0.00166834729247 , -0.000229211966368 , 0.00193758012761 , -0.00590836592496 , -0.00544392392436 , 0.000181844536465 , 0.00267184663632 , 0.00411750372895 , -0.00495412698091 , -0.00455606721043 , -0.000470506856695 , -9.09286430531e-07 , 0.00251848967421 , -0.00017722500747 , -0.00177127720392 , 0.00194426495882 , -0.00400901480455 , -8.80700705386e-06 , 0.00194305720549 , 0.00066893814668 , 0.000338700739344 , -0.00388598956871 , 0.00132124412425 , 8.20558283715e-05 , -0.00466616139278 , -1.7303328005e-05 , -0.000131255166603 , -0.00051840858861 , -3.21846890734e-07 , -0.000349984975237 , -0.000621297589585 , -0.00220788872472 , 0.000279656306347 , -6.01762035743e-05 , -0.00581212394666 , -4.63591667636e-06 , -7.65014745232e-06 , 0.000371299820555 , -0.00057307525103 , -0.00721648844544 , -0.000287669093834 , -0.00029848517506 , 0.000300814472677 , -0.00563206480033 , 0.000981547840565 , 0.000268383686734 , 0.00486761304406 , 0.00371460498104 , 0.00192358783158 , -0.000857668467664 , -0.00171508693057 , -0.00260305909033 , 0.00538049996866 , 0.000633383889036 , -0.00210157888287 , 0.00377980828148 , 0.000305375594448 , 0.0029427656423 , -0.000611487115236 , -0.00330801268106 , -0.000754237286108 , -0.000163795778789 , -0.000126692587845 , -0.000503984435935 , 0.000651385346482 , 0.00535833781792 , -3.87863912998e-06 , 0.00497542556064 , 0.00217685696081 , -0.00542674913542 , 0.00102078227414 , 7.66642005724e-06 , 0.00145327833871 , -0.000315771473285 , 0.000206148456723 , -0.000487681701879 , 0.00520946689191 , -5.2112595482e-05 , 0.000358055079611 , 0.00444873059444 , 0.000784599760371 , -0.00323218151043 , -0.00208435687712 , -0.00176747351498 , 0.0072933188814 , -0.00403623320064 , 0.00253720760486 , -0.00187326313177 , 1.16153274779e-05 , -0.00300370678958 , -0.000663264973116 , 0.000170015456082 , -0.00071626375326 , -0.00188144013371 , -0.00557955821157 , -0.00536816113342 , -3.96113361984e-08 , -0.00116432605756 , 1.49195396018e-05 , 0.00101836554796 , -1.31551107244e-05 , 0.000513858556967 , 0.000513486006341 , -2.80941497835e-05 , 0.00022654976584 , 0.00256081228499 , 1.42850530282e-07 , 0.000987167496384 , 0.00266933670448 , -0.00444016725016 , 0.000391477073803 , 0.00445300730105 , 2.45678755401e-05 , 0.000958394088099 , 3.76036413538e-05 , 0.000202876092275 , 0.000274650264227 , -7.48968835279e-06 , 0.00160340507588 , -0.000222976315773 , 0.00363732024839 , -6.24067501328e-07 , 0.00068733442651 , -8.66818672079e-06 , -0.000742442317906 , -0.00174303321603 , -0.00167738729687 , -0.000238000421035 , -1.69367824717e-07 , -0.00270650682978 , 0.00126635110284 , 0.000559339047225 , 0.00301844136791 , -0.00229891932967 , 9.10179828143e-05 , 0.00152203371768 , -0.00789410564646 , -0.00160695329064 , 0.00155202121974 , 0.000422289639212 , -0.00127154397686 , -0.00167090145597 , -0.00021527168603 , 0.00163897264867 , 0.00071866865272 , -0.00596165390346 , -2.63893818266e-06 , -0.00649621132911 , 0.00341134308026 , -1.03937869718e-06 , -2.61511038943e-05 , 8.3399784291e-07 , -0.00218251188226 , 0.000354712937567 , -0.00174672876373 , 0.000748652474859 , 0.000379559606933 , 0.00330265810816 , -0.000160573872529 , -0.00388660341081 , 8.01141857457e-05 , 0.000154746578998 , 0.00203660498378 , 0.00113492031389 , -0.00126684534801 , -0.000718236004004 , -0.000106079923967 , 3.11460018123e-05 , 0.000647611924708 , -1.21085988265e-05 , -0.00691365424691 , -0.00280740097576 , 0.000298684889066 , -2.26965863073e-05 , -0.000708719943136 , 0.00200350598556 , -3.18861318492e-05 , 0.00372266854542 , 0.000799073154259 , -0.00156796893364 , -0.00646844285687 , 0.000508572729748 , 2.2283656513e-05 , -0.00165404448294 , 0.00356309847559 , -0.0052209418574 , -0.000197652697189 , 0.00537971657259 , -0.000691812617413 , 0.00134313346528 , -0.000681734042487 , -9.00723426447e-05 , 0.000168693905379 , 0.00107510696541 , 0.00454882578577 , 0.000318700141554 , 0.000137019354583 , 0.00254428126085 , -0.00942613660256 , -0.000234962473905 , 0.000792319005455 , -0.00258789682778 , -0.00189998414229 , 0.0043441274532 , 0.00211054341823 , 0.00516646371674 , -0.00431118347094 , 1.07773096628e-05 , -0.00315465691902 , -0.00533538073551 , 0.000251007631005 , -0.000611081266033 , 0.00295032101157 , -0.00437715905783 , 2.79077535654e-07 , 0.000574829427572 , 0.00405923521079 , -0.000910762738196 , -0.000255927504949 , 2.34457048504e-06 , 0.00103140896638 , 3.09904702322e-05 , 0.00511993872837 , 0.00360066089574 , 0.00659299410494 , 5.68621203088e-05 , 0.00652727585528 , -0.00118218101884 , -0.00507381754788 , -0.000181513030449 , 1.56866612565e-07 , -0.000138223386911 , -0.00180401822912 , -0.00617370133746 , -0.000298107270173 , 0.00127104352587 , 0.00376779705548 , 0.00404657283492 , -0.00330662809462 , -0.000421530558166 , 1.12191090854e-07 , -0.00563955151067 , -0.00220554278662 , 0.0076827788883 , 0.000715178308312 , -0.000661241313213 , 0.00497747885756 , 0.00079099451675 , -0.000169219990403 , 0.00205061318221 , -1.39431782213e-06 , 0.0009912502072 , -0.00145359872504 , 0.000349289698636 , -0.00200319740266 , -0.00251133579507 , 0.000538523997353 , 0.00437566426726 , -0.00148411756899 , 0.00128684455298 , 0.00203981578551 , 0.00711765942901 , -0.00556652007067 , 0.00300778620703 , -0.00161706828135 , 0.000109414869525 , 0.00010525619401 , 0.00688794645764 , ])
Y_5_m5_imag = flex.double( [ -0.0 , -0.0 , 0.00517503224087 , 0.00167015791488 , 0.00505625018209 , -0.000386414493037 , 0.00616547178782 , 0.00286715088097 , 0.00119647385686 , -0.00320541692923 , 0.00197877914277 , 5.6530147089e-06 , -0.000109013843217 , -0.000129095344056 , 7.96325862173e-05 , -0.000791897058455 , 0.00247603625758 , -0.000155560270361 , -0.00356893732363 , 1.16342039528e-05 , -0.00360768116783 , -0.00499263928643 , -0.00278219232267 , -0.0013093898592 , -0.00830732125148 , 0.000738421768118 , 0.000228716521071 , 0.00376222191884 , 0.00138861655316 , 2.84690567417e-07 , -3.90210728843e-05 , -0.00384771838362 , -0.00763168132634 , 9.46533198174e-05 , 0.000861965568369 , -0.00376221745735 , -0.00306589878491 , -5.27822429036e-06 , -0.000898474707136 , 0.00332840573349 , -0.00226455837548 , -0.00419127439248 , 0.0015237991336 , 0.00115125695808 , 0.000790402227332 , -0.00378991054992 , -0.00153067787576 , -0.00371068175827 , 0.00275001359912 , 4.96887470078e-05 , 0.00411682583123 , 0.000529981957616 , 0.0058571947926 , -0.00697117586107 , 0.00494842725003 , -0.000160227816985 , 4.3434355075e-05 , 0.00469320531848 , 0.000470144313407 , 0.00559640122342 , -0.00435134893814 , -0.0061663698492 , -1.76897824365e-05 , -0.00144838942731 , -0.000695434927583 , -0.00194493839732 , 0.00329958358076 , -0.00467981782007 , 0.000425210508185 , 0.00417861833915 , 0.00281432161608 , 0.0020226196606 , -0.00488379605609 , 0.000421606265375 , -2.10361307482e-06 , -0.000756060456721 , -0.00234237989257 , 0.00614415065349 , -1.02855128515e-08 , -0.000296375590524 , 0.000127999303625 , 0.00382181554822 , -0.00482007973873 , -0.00313522200864 , 0.000291456317432 , -0.0033210157481 , -6.51987386503e-06 , -0.0035568772472 , -3.48003189054e-05 , -0.000495407705609 , -0.00164381754152 , 0.00010374268646 , 6.44390213987e-05 , -0.000506845690959 , 0.000996765309216 , 0.000145404513592 , 4.67098249652e-06 , -0.00496078817663 , 0.000903730916814 , 0.0007126564581 , 0.00103648325261 , 0.00273791380549 , 0.000141580340377 , -0.00171528515359 , 0.00113543593754 , 0.0025073030393 , 0.00229838371705 , -0.00419534314004 , 0.00199780639285 , 2.66446395426e-06 , 2.56095930972e-05 , 0.000180205606079 , 0.00619093333162 , 6.69055869453e-06 , -1.55831094311e-05 , 0.00141412219075 , -0.00209914171439 , 0.00284062129684 , 0.000773219990297 , -0.000838045982408 , -0.000257431463455 , -0.00500636464565 , -0.000121714666434 , 0.000352898917675 , -0.000346804616265 , 0.00247882634279 , 0.00698241330376 , -2.09952650513e-05 , -0.0070629417543 , -0.000176938549145 , -0.000206356961567 , 0.00348452327504 , 0.00463100475531 , 2.68935411732e-05 , 4.89684652997e-05 , -0.00383413676771 , 0.00574728739667 , 0.00138334906438 , 0.00264454823745 , -0.000136601532224 , -6.70774740916e-05 , 0.00182314302057 , 0.00104263043888 , 1.16527323637e-05 , -0.00764889261298 , -0.000516747414719 , -0.00364453368873 , -0.00307572093516 , -0.00131952512047 , 0.00193286018091 , -0.000111666958462 , -0.0002130800638 , -0.000685061993008 , 0.00361879441101 , -0.00134960651958 , 0.00207585221164 , 0.00349119669677 , 0.00154955491724 , 0.00596598205714 , -0.00246435491718 , -0.000830946923571 , 1.55928155372e-06 , 7.21937392783e-06 , 0.00389476847608 , 0.0010728235402 , -0.00130590131434 , -0.00738537988012 , -0.00453332599187 , 0.00448079123675 , -0.000130925466475 , -0.00189091510375 , 1.63816721697e-06 , -0.00200891917805 , -0.00152255845263 , 6.94287065852e-05 , 0.000150641140287 , -0.0025674356529 , 0.00139447098051 , -8.21972928612e-06 , -6.15515088108e-05 , 0.00260837172 , -0.00275977682765 , -0.00381132462808 , -0.000294223598697 , 0.00250715657345 , 5.92106733119e-05 , 0.000453398711533 , 0.00302207914714 , 0.00406476216608 , 3.38934838778e-06 , -0.000483050995131 , -0.00337750866213 , 3.09279361787e-06 , 0.00215292792304 , 0.000887328725685 , -0.000611127506075 , 7.06185904433e-07 , 0.000590422649487 , -0.000239583219821 , -0.00478925023609 , -0.00468441312985 , 0.000973237367768 , 0.00244278954414 , -0.00197521701584 , -0.000123708893479 , -1.93606422068e-05 , 0.00263392457926 , -0.00162707909013 , 0.00506781057682 , 0.00113553888102 , 0.000600968576999 , 0.000142628623348 , -2.97651788092e-07 , 0.00375199247068 , -0.00159953989761 , -0.00552522104824 , 0.00434878926497 , -0.00125927367959 , -0.00109073104922 , 0.000261075066648 , -0.00627739882901 , 8.13475248016e-05 , -0.000559001693497 , 0.00158993224005 , -0.00270842609111 , 0.00338281122421 , 0.00271112506622 , 0.000488074330927 , 0.00763022292204 , -0.00199068081263 , -0.0022078934199 , -0.00276196560685 , -0.00457254831895 , -0.000619757149336 , 0.000804883194342 , -0.0059557687169 , -0.000294777558505 , 0.00219777987538 , -0.000400576563501 , -0.00652342692416 , -0.00243955418571 , -0.00482804136381 , 0.000410600093278 , -0.000368512926619 , -0.0010981242421 , -0.000289885124574 , -0.00536569464616 , -0.00168541922577 , -0.00624151170267 , -0.00227853073029 , 4.81697010157e-06 , -0.0023849040785 , -1.7415634213e-06 , -0.00453004236752 , 7.45962952928e-05 , 0.00175090440904 , -0.00122185045004 , 0.00335141669497 , 0.00353272557702 , -2.17246823668e-05 , -0.000189410329313 , -0.000188489977073 , 0.00206588443495 , -0.00245122852361 , -0.00259951841025 , 0.000829856982924 , 0.000843759949088 , 5.1481832168e-05 , -0.00088965980389 , 0.00295028086158 , 0.00459460444149 , -0.000483914736469 , 0.00143489329187 , 0.000818990979474 , -0.00276204356566 , -0.000904235082994 , -0.00784113392311 , 0.00326586496264 , -0.00186567662635 , 0.00323988981994 , 0.00183319506001 , -0.000880073434681 , 0.0045821567068 , 0.00129930020328 , -0.00121118658826 , 0.00293933041585 , -0.00111568116122 , -0.00426745851222 , -0.00131062617176 , 0.0026823248339 , -0.0011558765067 , -0.000903508214421 , 0.00117211013118 , -0.000319083066004 , 0.00649886591626 , 0.00576257836864 , -0.00150500135143 , 0.00664479291823 , 0.0031054644602 , -0.000733719713516 , -1.55825745011e-05 , -0.00375123583901 , -0.0011345356805 , -0.000282403043726 , 0.000259528788979 , 0.00154778903508 , -0.00136779266557 , -0.000224572800923 , -0.00436160081814 , -0.00592111120712 , 0.00427193316774 , -0.00286927928021 , -0.00559547808353 , -0.000411467725513 , -0.00363074484212 , -0.00318715217151 , -0.00129614011902 , 0.000316000491337 , 0.000478637742215 , 0.000958177903198 , -0.00415593820656 , 8.16493454528e-06 , 0.00239183971331 , 0.00275721242428 , 0.00020451091716 , -0.00272431931118 , -0.0047849336137 , -0.00187374806749 , -0.000745296068361 , 0.00151424634818 , -3.98878600033e-08 , -0.00237044903193 , -0.000265177979087 , -2.73275211139e-05 , -7.88362994367e-05 , 0.00875545131821 , 0.00278282341053 , 0.000389664436631 , -0.00295999049386 , -0.000679500893446 , 0.00575421402216 , 3.51287032249e-05 , -0.000371191490781 , 0.000941673456956 , -0.000976353031585 , -3.45955448405e-05 , -0.0010996358835 , 0.000142201385032 , -0.00192076444374 , 0.000113012998085 , -0.00234171227867 , 9.97262073238e-05 , 0.00266790323021 , 0.000276552058262 , 0.00601586681561 , -0.00650812274304 , 0.00282546307507 , -0.000509963361468 , 0.00246248971697 , -0.000638516298473 , -0.00801439468495 , 1.34769927788e-05 , 1.22596354783e-08 , -0.00470053493641 , -0.00544937872724 , 0.00110469413896 , 0.00390529370453 , 1.54112341587e-07 , -0.00114743857442 , 0.00160557234558 , 0.000248492576465 , -0.00345467638585 , -0.00289417532475 , 0.00563603463694 , -0.00435075934144 , 0.00289021665269 , 0.000398708342407 , -0.00184167673859 , -0.000787301425586 , -0.00174422783607 , -0.00382554501391 , -0.0054884369813 , 0.00110224078117 , 0.00377320634881 , -0.00101454822669 , 1.83431639852e-05 , 0.000292868218482 , 0.000893128923603 , -0.00113074324527 , -0.00803342477509 , -0.00477106113531 , 0.00219999734818 , 0.000942937020749 , 0.0065016184255 , -0.000415292202905 , 0.0021692292438 , 0.000616015013513 , -0.000345735668761 , 0.00360117691153 , -0.00366660565574 , 0.000286564582697 , 0.00283550380588 , 7.33090672018e-07 , -0.00140290277356 , 0.00208317080081 , -0.00025520229159 , -5.01632617595e-06 , -6.95624270001e-05 , -0.000209527865313 , 0.00359298524689 , 0.00321050805614 , -0.000290939558911 , -0.00140462937177 , -0.00763709087684 , -0.000149663761914 , 2.88617237581e-05 , 0.00163531730407 , 0.00681233156077 , -0.00200400064379 , 0.00291891613772 , -0.000968405353394 , -0.00349161753263 , -0.00427527323842 , 7.41672595988e-05 , -0.00550497953362 , 0.000454504446639 , -0.00109177656396 , -0.000452056022597 , 0.000708198990602 , 0.000185935693255 , 0.00291860151986 , 0.00514127606662 , 0.0015232392911 , -0.00143557953184 , -0.00477642230185 , 0.00016061866449 , 0.00572513883566 , 1.29326269095e-06 , 0.00677928340575 , 4.33818047612e-05 , 0.00273782142252 , 0.00108036584318 , 0.000672590507346 , 0.00486371562561 , -0.000191365906509 , -1.98452023107e-05 , -0.000642680472816 , 0.00371682292591 , -0.0039555531989 , -4.73568042538e-05 , 0.00104590515357 , 0.00580622702637 , -0.00321695475238 , -3.2277810815e-05 , 0.000268402166361 , 0.00025669062484 , -0.0014122051906 , -0.00168145853698 , 0.000819599208261 , -0.00117330796939 , 0.0051619900584 , -0.00547500759112 , 0.000241917903068 , -0.000180480419876 , 0.00505228410918 , -0.00148053267373 , 0.000227700938548 , -0.00575306777341 , -6.40122717965e-05 , 0.00417749413782 , 0.000209231090984 , 0.000892082458543 , 0.00070673218097 , -0.00400406936524 , -0.0014540453511 , 0.000595272259976 , 0.00257576381212 , 0.00193876157787 , 0.00753654544719 , 0.00538238466885 , 0.00162356394727 , -0.00121915499499 , -0.000156933518893 , -0.000754567584174 , 1.57652685632e-06 , 0.0014856471141 , 0.00113041469204 , 0.00488195315555 , 0.00546235132576 , -0.00238179546575 , 0.00496385079854 , 0.00352160064366 , 0.000996158377913 , -0.000796047510998 , 0.0018994362723 , 2.11297152252e-05 , 0.00229307649418 , -0.000229944937405 , -0.00160817328833 , -0.000295948574175 , -0.000343568265495 , 0.000214627170595 , 0.000771297065505 , 0.00311860723922 , 0.00279213049296 , 0.000594215233976 , 0.00184156209618 , 0.0015873773946 , 0.000901361295297 , 0.0007032353628 , 0.00358409053846 , -0.00636665783023 , -0.000471455201221 , -0.00250212278113 , 0.000293594155055 , 0.00767137813662 , 0.00166222808641 , -0.00483212631537 , 0.0012040907772 , -0.00499812241031 , 0.000163211887911 , 0.00169256967073 , 0.00308459620239 , 0.00278209677414 , 7.26529189098e-06 , 0.000143407751218 , 4.09726799467e-05 , -0.00178802370039 , 0.00548748606958 , -1.09671680125e-06 , -0.000991447974498 , -0.000267490554784 , 0.00427465299554 , 0.00330629701742 , -0.00202767063343 , -0.000784242826882 , -7.5701652219e-05 , 4.93490922077e-05 , 0.00423849514207 , 0.00519635425063 , 0.000322858022454 , -0.00273496859654 , 0.00411971853065 , 0.000637210591515 , 0.000536442750435 , 0.00597480239374 , 1.82249217553e-05 , 6.35125905755e-10 , -0.00280692481788 , -0.00114566152111 , -0.00272812401198 , -0.00100436578839 , 2.02781499545e-05 , -8.82199807856e-08 , -0.000998998038675 , 0.00167801383331 , 5.39725774874e-05 , -0.000222011056048 , 0.000203994495477 , -0.00140752166998 , -0.000201479625 , 0.00385309107155 , 0.00203809973286 , -5.85694657098e-06 , 0.00511037639815 , 0.00240475026186 , -0.00321606793309 , 0.000801639913052 , 0.00235600259736 , 0.00289952290518 , -0.00639688428021 , -0.0020714983666 , -0.00233537376546 , -0.00405104619887 , -0.00308732552828 , -0.00450447972485 , -0.00436866682878 , -0.00266086449037 , 0.00144273648556 , 0.000131492925914 , 0.00219233330599 , -5.52646926058e-05 , 0.00643256076542 , -0.00577606798743 , 0.00190942330471 , -0.00546267373607 , -0.000850351301039 , 0.00206971220624 , -7.33004652574e-05 , 0.00206762359087 , -0.00310627833612 , -0.000461068852433 , 0.000214373112782 , -0.00075058849106 , -0.00529040695072 , 3.43950072946e-05 , 0.00410761243991 , 0.00281222417416 , 0.000450807327568 , -0.000113781967707 , 0.00325476108299 , 0.00761410640101 , 0.00484798364628 , 0.0056357772847 , 0.00129564214439 , 0.00281098559596 , -0.00291095046265 , -6.71437488207e-05 , 0.000681783737252 , 4.42452570025e-05 , -0.000248855717298 , 0.00501310294882 , -6.62634726787e-05 , 0.00160645688936 , 0.0013033725916 , 0.0028263656238 , 9.89709939349e-05 , -1.59552021267e-05 , 0.0035322928415 , 0.0013573855362 , 0.00108982117466 , 0.00461772830279 , 0.000234634338927 , -0.00161238416598 , 1.70994138009e-05 , 0.00417350574626 , 0.00399280143283 , 0.000180109871339 , -0.00461637832298 , -3.22284719691e-07 , 0.000121645880234 , -0.000489530024654 , -0.0048856457651 , 0.000197710410824 , -0.00141143649078 , 0.00129150838771 , 0.00100745395129 , -0.000398613794919 , -0.00586240144666 , -0.00426550061208 , -0.00846661323334 , 0.00413367066234 , -0.00048185725106 , -4.33755346874e-06 , 0.000287744509023 , -1.2731576814e-05 , 0.00350864042853 , -0.000364277458108 , -0.00165818214674 , -4.29602711868e-05 , -0.000322369404832 , -0.00262709951477 , -0.00432302728459 , -0.00368743054685 , 0.00194488303106 , -2.19094119118e-05 , 0.0010079183825 , -0.000543711440888 , -5.42838082763e-05 , 0.000839840682691 , -2.60028854994e-06 , -0.000307654473634 , 2.8004275071e-05 , 0.00638592142573 , -0.000565238007025 , 7.97870029368e-05 , 0.00360456682874 , -2.34553820868e-05 , 1.6585539347e-05 , 0.0005872218451 , -0.000319967846286 , 0.00210856441636 , 0.00126313568901 , 0.000705163540689 , -0.00322244673183 , -0.000503402761693 , 0.000141598011997 , 0.00518383184789 , 0.000184989806919 , -0.00125587630251 , -0.0061644612371 , 0.00367900905444 , 0.00195243497389 , 0.00285193195251 , -0.00219821736332 , -6.03543191099e-06 , 0.00136334866255 , 0.00126662584056 , 0.000188268065094 , -0.00345262332503 , -0.000195222596573 , -0.00311166080809 , -0.000589533498368 , -0.00309855694379 , 0.00116478079972 , -0.00551880865969 , -0.0030511439713 , 0.00698414446932 , 0.000330814773026 , -0.00243363089746 , 0.00492075511297 , 0.00168134243204 , -0.00552201989299 , -0.0046894910241 , 0.000664420731594 , 0.00235642295758 , 0.000194180571004 , 0.001092598737 , 0.00284041327051 , -0.000951703503249 , -0.00503643459609 , -0.00106967880253 , 0.00689582228928 , 0.00279203155502 , -0.00635096075508 , 0.0078876245915 , -0.00158212974627 , 0.00353104626034 , -0.00176436921721 , -0.000455603245818 , -0.00211724371301 , 0.000920221199207 , 0.00402423169478 , -0.000109810886282 , 4.15547734589e-05 , -0.00110648580351 , -0.00235583261476 , -0.00178313814084 , -4.09524602407e-08 , 0.00199584684347 , 3.1411363486e-06 , -0.00508940973778 , 0.00120444504647 , -0.00363900448921 , -0.000459258883439 , 0.0003693378103 , 0.000104936340743 , -0.00287740270016 , 3.44434481139e-07 , -0.00020275006024 , -0.00220406466993 , -0.000953043155598 , 0.000254642967441 , -0.0023494419845 , -0.000141087900023 , -0.000974990514821 , 9.42477081621e-05 , 6.50165623355e-05 , 0.000380479550177 , -5.84937587606e-05 , -0.0013977886431 , -0.000457159859114 , -0.00362254362051 , 7.78197009538e-08 , 0.00295298502856 , 4.6025755933e-06 , -0.000144241638902 , -0.00308368826725 , 0.000299758534961 , -0.00142047050065 , -2.31436202947e-07 , -0.00602898653038 , 0.000961947621807 , -0.000176250779164 , -0.000300516102412 , -0.00281695401687 , -0.000173927350642 , -0.00211262747613 , 0.00263659569662 , -0.00127465291224 , 0.00059455936715 , -0.00303302655059 , -0.00224649487919 , 0.0077832685145 , -4.1717343164e-05 , -0.00145562392273 , -0.000752461248854 , -0.00634120004623 , -6.70102579966e-06 , -0.000319981944756 , 0.00154400883816 , 1.18618480788e-06 , -0.000407646382939 , 1.17274974015e-06 , 0.00065897216865 , -0.00144278168454 , 0.00548664851886 , 0.00198663343824 , 0.0016980089933 , 4.34472129199e-05 , 3.0325624955e-05 , -0.000230742966856 , -0.000384768707315 , -0.00013095090125 , -0.00508639372992 , 0.000283287207452 , -0.000397615253145 , -0.00580229604972 , 0.000123849244531 , -1.80589807192e-05 , 5.88952844191e-05 , -2.257087208e-05 , -0.00337957250972 , -0.00390175253128 , 0.00120863865877 , 1.86488769848e-05 , -0.00194334522109 , 4.78721522932e-05 , 2.10836618951e-05 , -0.000801627582523 , -0.0039207371167 , 0.000586879189867 , 0.00763448665446 , 0.000320959194544 , -2.50254415017e-06 , 0.00387289910182 , 0.00410622595552 , -0.00195703472454 , 0.000161926338094 , -0.00407159845343 , 0.00500902038548 , 0.00143764780798 , -0.00104788206235 , -2.58711160009e-06 , -0.00012800148977 , -0.000677177960828 , -0.00478184464577 , 0.000213750393165 , 0.000204280196083 , 0.00166107521959 , 0.000153225477115 , -0.000901977773064 , 0.00516075102373 , 0.00174265979149 , -0.000220992500657 , -0.00458662793615 , 0.00231656666508 , -0.0016681234029 , -0.00436498934298 , 2.42781182e-06 , -0.00264534817366 , -0.00200724133688 , 3.15234805002e-05 , 0.000137111995048 , 0.00339143058447 , -0.000282311735886 , 1.18242747094e-06 , 0.00392633379201 , 0.00199324022825 , -0.000244552304939 , -0.000332034633823 , -9.95604842806e-07 , -0.000118978904535 , -1.98896516628e-05 , 0.00202312342799 , 0.00368202302679 , -0.000404032593336 , 0.000203598227429 , 0.00107090497325 , -0.00161486372971 , 0.0029519409522 , 2.7639916609e-05 , -9.07435310119e-08 , 0.00696649088832 , -0.00285940548652 , 0.000922552742817 , 0.000730307586971 , -0.00333675532919 , -0.00242035926138 , 0.00685874688896 , -0.00229100049969 , 0.00102362686567 , -1.43766207938e-07 , -0.000786204934562 , -0.00504258010475 , 8.73959749324e-05 , 0.00486173021837 , -7.30996955852e-06 , -0.000463401141695 , -0.000355324847441 , -0.00513454384014 , -0.00433206581939 , -3.99061051316e-06 , -0.00538469780605 , 0.000390157950554 , -0.00158105777679 , 0.00601832061165 , 0.00167998756464 , -0.00225319085204 , -0.00197962778431 , -0.00243582807226 , 0.0014501433508 , 0.00114107073789 , 0.000702488628628 , 0.00377306383046 , -0.00561207784492 , -0.00278801028688 , 0.000106094096647 , 4.9234967652e-06 , 0.00309248527821 , ])
Y_5_m4_real = flex.double( [ 0.0 , -0.00201282956196 , 0.000831136819933 , 1.29633577712e-05 , -0.00355009382785 , 0.000898950945858 , -4.0063542408e-05 , 0.00407054833609 , 0.00276487317209 , -0.00155380610051 , -0.0045076546633 , -0.000177111493035 , 0.000485734098134 , 0.000858732731472 , -9.72310608016e-05 , 0.00231695428792 , 0.00523543812394 , 0.000332459963879 , -0.00290010842632 , -0.000139591346037 , -0.0030445082177 , 0.000132395941794 , 9.39290475042e-05 , 0.00566789487256 , 0.000498647514826 , 0.000951744825801 , -0.00313125237477 , -0.00350613747459 , 0.00415900256539 , -3.74458553633e-05 , -0.000249056277768 , 0.00596340497968 , 1.17359747986e-05 , 0.00490887898739 , 0.000299494057777 , -0.00414709173186 , -0.00312385249168 , -9.28987513266e-06 , 0.00363457331294 , -8.89026179519e-05 , 9.94805811694e-05 , 0.00353970151641 , 0.000117497574515 , -0.00435322710956 , -0.00450952720249 , 0.000865010742408 , -0.0051591430584 , -0.00393241240343 , -0.00246822520469 , -0.00205196238435 , 0.00212237171395 , -0.00435588720908 , 0.00568190002122 , 2.10122008285e-05 , -0.00579640635492 , 0.000821248487236 , 1.1893833426e-05 , -0.00345445925491 , -0.00150108641728 , -0.000151976635722 , 0.00181720044315 , 1.77409066303e-05 , -0.000344687913763 , -0.00166097143132 , -0.00285601767063 , -0.000305720931652 , 0.000801678142833 , -0.00711199985018 , -6.70190951695e-05 , -0.00189002617782 , -0.0040475310748 , 0.00220693049083 , 0.000920195362167 , 0.00162948429202 , 3.38328782126e-05 , -0.00237215808525 , -0.00298035242763 , 0.000736036458956 , -4.47326130628e-07 , 0.00157754025996 , 0.00127941328855 , 0.00274673481667 , 0.00611140410377 , -0.00357816021161 , -0.00173286751632 , -0.00190981593735 , -8.99904918419e-05 , 0.00284702341491 , 0.000695557314479 , 0.00288046496498 , 0.000367437888145 , 0.000331980545303 , 0.00121202841794 , -0.00197498595183 , -0.00226966474419 , 0.00129880167834 , 7.46931527158e-05 , 0.000928677863876 , -0.000148744573961 , 0.000439427560714 , 0.00370470048685 , 0.00404168067141 , 0.00142242555227 , -0.000456562852466 , 0.000560935052192 , 0.00777105005504 , -0.00247325328389 , -0.00165932091018 , -0.00114055311154 , 3.79623978343e-05 , 0.000467872682597 , -5.21240595295e-05 , 0.00111101072895 , 0.000109706205924 , -7.02097910807e-05 , -0.0029445874829 , 0.00564491769752 , -0.00198978749716 , 0.000572816207138 , -0.00168947559532 , 0.00323356962556 , -0.00174761375231 , 0.0011278790864 , -0.00153552689964 , 0.00437934033936 , -0.00192391756425 , -0.000781172363244 , 0.000168598526103 , -0.00222004421748 , 0.000646765417376 , -0.00552062382105 , 0.00600843605133 , -0.0008516468056 , 0.000225503316242 , -0.000376341974228 , 0.00372230336457 , 0.00248910202764 , 0.00188058140082 , 0.00571458382752 , 0.00141728336749 , 0.000274235207694 , 0.00119342801212 , 0.00245482569846 , 0.00111666298492 , 4.59107994846e-05 , -0.00567445436566 , 0.000408744071891 , 0.00174020873629 , -0.00114804120274 , 0.00375515772128 , 0.000815403848907 , 0.000432532540795 , -0.00287747041307 , 0.00233110573055 , -0.00205419767732 , 0.00221595830272 , 0.00240933279687 , 0.00385659288017 , -0.00345087623081 , -0.00310310782279 , -0.00278287267585 , -1.90616274415e-06 , -0.000188700003391 , -1.58347576926e-05 , 2.87992426742e-05 , 3.32652268354e-05 , -0.000409456276965 , 0.00363425117803 , 0.00358259480491 , -0.000494185137415 , 0.00341186599443 , -1.02382230723e-05 , 0.00202534084397 , 0.00377387799869 , -7.66590835002e-05 , 0.0011414987426 , 0.00466782691465 , -0.00344977720714 , -0.00282720416245 , 0.000457376980859 , -0.000581199715519 , 0.00563487096154 , -0.00143705678587 , -0.00245505571201 , 0.000118548077717 , -0.000125902939415 , 0.00147092534107 , 0.00518037524823 , -0.000719309307843 , 1.13038970221e-06 , -0.000620730012337 , -0.00215613530542 , -4.78646325131e-05 , -0.00506381410373 , 0.00545337404984 , 0.000619661922737 , -4.62963854861e-05 , -0.00166053744634 , -0.00145543061878 , 0.00399388341493 , 0.00559549236364 , -0.00370765644615 , 8.2240088685e-05 , -0.00325971602175 , -0.000670190678005 , -8.0172101829e-05 , 0.00369698633076 , 0.00435933075035 , 0.00662428925822 , 0.00454529254758 , 0.00132853848833 , 0.000847613037246 , -0.0001243911335 , 0.00262857872476 , -0.00280193942327 , 0.00417964191647 , -0.00169232175825 , 0.00347730502057 , -0.0026432931633 , 0.00371427494266 , -0.00109436814493 , 0.00269632822637 , -0.0054264207549 , 0.00181663957905 , 0.00137093252615 , 0.0042055059049 , -0.00378889799003 , -0.00294559753771 , -0.00199580874218 , -0.00344869345996 , 0.00633555041454 , 0.0064189737838 , -0.00245793172892 , -0.004365491046 , -0.00235291567541 , 0.00227491745397 , 0.00134153301203 , -0.00329865802223 , -0.000570906561371 , 0.00265321041627 , 0.000722392952069 , 0.000847570539262 , -0.00173074298781 , -0.00160695057726 , 0.0021869892889 , -0.00141637094211 , -0.0057785123577 , 0.00573304869442 , -0.00461483136283 , 1.02407942644e-05 , 0.00118749149029 , 0.00261616290023 , -0.000594339026026 , 0.000781458483993 , -0.000902815283177 , 0.0050089254159 , 0.00202732907975 , -0.000432373267899 , 0.00217694576316 , -0.0011976621729 , 4.17343866714e-05 , 1.75031582237e-05 , 0.00357195413669 , -0.000807329867736 , 0.00315220482319 , -0.00668984246804 , -0.00583931284781 , 0.000228758551347 , 0.0023419068034 , -0.00649426564304 , -0.000240570890402 , -0.00263584581678 , -0.00349849891555 , -0.00522447407879 , -0.00537682331632 , -0.0023261600599 , -0.000932427556036 , -0.00292614115978 , 0.00056301405903 , 0.00174244788453 , 0.000426612912698 , 0.00128409871586 , -0.00477648139325 , 0.00245437916407 , 0.00108176096941 , 0.00483185763016 , -0.00114615624068 , -0.000284571599948 , 0.00464636651227 , -0.000781401328774 , 0.0037788909101 , -0.00296240620355 , 0.0008052451942 , 0.00237715541849 , -0.00638477462749 , -0.0018055608051 , -0.00363887835332 , -0.00165734065556 , 0.00329991536891 , 0.00251581814561 , 0.000143551964766 , 0.00130760273286 , 0.000533317161502 , -0.00176425673123 , 0.0019326277194 , 0.000134844628861 , -0.00426710996382 , -0.000502418023066 , -0.00173420915899 , -0.00214076345377 , -0.00629538125184 , 0.000643344801802 , -0.0023321852686 , -0.00122414324967 , 0.00198279619141 , -0.00479387807239 , -0.0041160014403 , 0.00157473142887 , -0.000438232365864 , 0.00566881700092 , -0.00653842222944 , -0.000108533597966 , -0.00301014702192 , 0.000996183963488 , -0.000431729905092 , -0.00241468677149 , 0.000524871387695 , 0.00163457313792 , 0.00122374741329 , -0.00155297444496 , 1.27116908174e-06 , 0.0026595161673 , 0.000483414315763 , 0.000508555128981 , 8.6512060874e-05 , 0.00184154325745 , 0.00148109369836 , -0.00175853731158 , 0.00256993475178 , -0.000553091798682 , 0.000761678901993 , 0.000173371610167 , 0.000566429533802 , 0.000276144335685 , -0.00231606258624 , -7.2511091214e-05 , 0.000621085913014 , 0.00100369937601 , -4.12299859555e-05 , -0.00263025950223 , -0.00495900698467 , 0.00204168598415 , -0.00287717690335 , 0.00434705352715 , -0.00514063431677 , -0.000487465477552 , -0.00350076232125 , -0.00246312290352 , 0.00594808389812 , 0.00346062783556 , -0.00422522008085 , 0.000118923003682 , 8.34857212427e-07 , -0.00167676994758 , 8.62875613983e-05 , 0.00252975646311 , -0.000647316033069 , 3.62053231965e-06 , 0.00256029643598 , -0.00466994256329 , 0.000195872590733 , -0.00513160160247 , 0.00290412274433 , -0.00194387033319 , 0.000749062894308 , -0.00104135291866 , -0.0016471605409 , 0.00206910363145 , 0.0026032392274 , 0.00370301961346 , 0.000939376695144 , -0.00389278946209 , 0.00430817860646 , 0.000797391413342 , -0.0023275957577 , 0.000108740822445 , -0.00197103810213 , 0.003304511277 , -0.00353579971682 , 0.00321154090705 , -0.00521988686914 , -0.00495266814603 , 0.00509630084075 , 0.00286829264682 , -0.00156981723527 , 0.00371026449478 , 0.00273266030129 , 0.00112824362804 , 0.000562949949775 , -0.00125874190853 , -0.00022632072721 , 0.00340751405792 , -0.000462546342917 , -0.00198653429149 , 0.00555554590589 , 0.00132131020819 , -2.49044268044e-05 , 0.0002488015573 , -0.00303923575103 , -0.0025080951256 , 0.00135241820106 , 0.00144955547494 , -0.00344956475312 , 0.00555892017751 , -0.000837017221643 , -0.00449863574575 , -0.00585755782468 , 0.00143683712861 , -3.58115850143e-05 , -0.0018058920277 , 0.00366180305777 , -0.00835097018396 , 0.0063188434367 , -0.00145215101731 , 0.00856379992906 , 0.0054751445777 , 0.00464384902375 , 0.00356573685445 , 0.0022124298144 , -0.00130465957712 , -0.00347929038709 , 0.000177128489966 , 0.00327539113878 , 0.00055816392026 , -0.0065161844547 , -0.000965613233477 , 0.000976268134771 , -7.16060130338e-06 , -0.000171737940365 , 0.000150525334559 , -0.00332225943005 , -0.00329257060478 , 0.00149860325499 , -0.00448074027068 , -0.00141412180138 , -0.000211238968534 , 0.00213370438584 , 0.00238802853282 , -0.00215312622517 , -0.00116690452722 , 0.0029411388821 , 0.00248544769052 , -0.00401176601313 , 0.000357842614115 , -0.00133155115824 , -0.0014253041607 , -0.00687996612719 , 0.00373388576003 , -0.000499023786075 , 0.000370398778009 , -0.000416206489999 , 0.000664376959348 , 0.00154824676015 , 0.00110451333006 , -0.00290276647775 , 0.0036869395935 , -0.00641913281084 , -0.000999645507852 , 0.000190138664998 , 0.00577938086973 , 0.00102775731669 , -0.00243150463682 , 0.0061617693191 , 0.000644152914572 , -0.00641793907654 , 0.00384397194743 , -0.000189478973115 , -0.00341754393226 , -0.000578394029797 , -0.00120684167695 , -0.00557813894299 , -0.00452898245624 , -0.000244737597957 , -0.0052689747994 , -1.98492977533e-05 , 0.00328725969237 , -0.00105081557765 , 0.000553760735075 , -0.00320524831574 , 0.00265908118014 , -6.87254766663e-06 , -0.00158432035804 , -0.00217916593932 , 0.00639812165827 , -0.0019100283468 , 0.00261018606014 , 0.00320476366043 , -0.00138646178426 , 0.00163350366359 , -0.000581569667639 , 0.00236726797547 , -0.000511473247768 , 0.00299876670315 , -0.00391138692384 , -0.00406864470229 , 0.00460622239954 , 0.00420252366458 , 0.00164676944401 , -0.002861431572 , -0.00266863797762 , -0.00654825860794 , 8.47323973906e-05 , 0.00607982727954 , -0.004463367178 , 0.0016363984173 , 0.00309404120196 , 0.00207591319047 , 0.00182444489414 , 0.00145708635196 , -0.000757401264956 , 0.00118914803422 , -0.00016245741669 , 0.00500131726458 , 0.00446506350048 , 4.84754087149e-05 , 0.000763194115261 , -0.00333552156659 , -0.00164003428495 , 0.000691369532186 , 4.39444480979e-05 , 0.00198903874895 , 0.000164152121571 , 0.00364817561375 , -0.000917335786554 , 0.000456518866556 , 0.0033790140312 , -0.00173444034008 , 0.000489582652511 , -0.00193845979615 , 0.00120740744286 , 0.000288805002088 , -0.00119082456148 , -0.00243103410868 , -0.00180647759884 , 0.00183611354408 , 1.99209138279e-06 , -6.67986606172e-06 , 4.51146585669e-08 , 0.00473479045285 , -0.00107417132222 , -0.00230982760169 , 0.000592971123949 , 0.000175047786115 , 6.56105883261e-07 , -0.00384429349803 , -0.0048226552216 , 8.42868643802e-05 , -0.00100796875984 , 0.0016287977493 , -0.00159559794149 , -0.000873341600989 , -0.00385999450925 , 0.00198779395305 , 1.76096131026e-05 , 0.00148251635508 , -0.0031625835605 , 0.00613000158753 , -0.000582375831365 , 0.00474929823158 , -0.00033943455885 , -0.00449425406578 , -0.00251637975649 , -6.23912601347e-06 , 0.000580017244402 , 0.00106998095992 , -0.00285874135598 , -0.00614783363738 , -0.00201825522268 , 0.0021000844062 , -0.000751947675449 , -0.00504585074857 , 0.000105711690865 , 0.00173589183404 , 0.00173956185828 , -0.00127443001885 , -0.00457782670693 , -0.000622188986695 , -0.000177499965231 , -0.000544594699323 , -0.00385133889683 , 0.00253738182475 , -0.000527806885915 , 0.00473789043763 , 5.35273424096e-05 , 0.00213446981046 , -0.000575359563706 , -0.00526586847391 , 0.000172583736545 , -0.0031901055502 , 0.000619207724247 , 0.00663267240062 , -0.00411085516936 , 0.0054798643333 , -0.000832090714448 , -0.0062631290796 , 0.00282688442467 , -0.00798052644527 , 0.000899587076773 , 0.00412890473737 , -0.000355659884778 , -0.00563425487311 , 0.000792706552262 , 0.00398319002772 , -0.00394849033066 , -0.00337195478118 , 0.000774576557527 , 0.000453907258129 , -0.000160080115464 , 0.000140676823109 , -0.00476141699131 , 0.00362845781064 , 0.000494794629663 , -0.00137839294764 , 0.00707429101566 , -0.000166574819395 , -0.00642554002586 , 0.0023245394846 , 0.00107146291277 , -0.00522102806603 , -7.08870855556e-06 , 0.00109012555337 , -0.00203894704627 , -0.00491826607858 , 0.000964117901902 , -0.00113115127594 , -0.000275996278478 , 0.00434964654086 , 0.00131306732004 , 0.00423810136427 , 0.00621413778433 , -0.00196014404021 , 0.00398665098059 , -0.00190730298149 , -2.73134349517e-05 , -0.00220783688485 , -0.000844499057385 , 0.000318951685763 , 0.00257124197404 , 0.00285298646545 , -5.50302092175e-05 , -0.0021030045933 , -0.000593733312248 , 0.00632095893557 , -0.00069063633755 , -0.000838525274207 , -6.49212080015e-05 , -0.00325494587331 , 0.00164187998533 , -0.000476803631408 , 0.00330437771737 , 2.85528194574e-05 , 0.000937718658526 , 0.00165607142811 , 0.00214702403963 , -0.00107288826591 , 0.000415433843537 , -0.00196662126726 , 0.00015242994111 , -5.80065952084e-06 , -0.00245228637699 , -0.00233440858207 , 0.000271255736086 , 0.00280864685773 , -0.00258245855318 , 0.00252154674553 , 0.00159245791875 , -0.00301365349065 , 0.00890190963123 , 0.00327501492562 , -0.00534368155388 , -0.000315398601665 , -0.00642952584182 , -0.00389687224779 , 0.000529404488147 , 0.00399453050323 , -0.00078716935115 , -0.00169548334832 , 0.00401920931829 , -0.000816011332922 , -0.000819182093397 , -0.00166499841894 , 4.98210631142e-05 , 0.00111791406179 , 0.00793460332502 , -0.000747408556065 , -0.000327407809092 , -0.00593801060645 , 0.00329237626808 , -0.00129272927802 , -0.00241597491942 , -0.0016212862678 , -0.000425708142005 , 0.0020322137346 , -0.00155968643989 , 0.00422077117827 , -0.00088392276538 , -0.000343447357777 , -0.00259839177683 , 0.000150248498558 , -0.00305514884545 , -0.00133289800521 , -0.00325645346708 , -0.00123634585141 , 0.00334366176953 , 0.00154576737072 , -0.000407685197619 , 0.0022652074031 , -0.00211877829405 , 0.00276793334809 , 0.00460398798645 , 0.00388056802003 , -0.00272886140891 , -0.00541301644182 , -0.000708217636527 , -0.00194046905282 , -0.00362172201126 , 0.00244020933624 , 0.000245277756369 , 1.7423618242e-06 , 0.000567375696543 , 0.000110622395062 , 0.00385788150384 , 0.000997632339721 , 0.0040277393504 , 0.00220669361727 , -0.000407323944871 , 0.000752229281696 , 0.00155380780385 , -8.76420322913e-06 , -0.00352586895836 , 0.00158427071283 , -0.000233960356442 , -0.00176860210018 , 9.65290393101e-06 , -0.000908432957394 , 0.0010692297133 , -0.000435047522857 , -0.000863793746186 , 0.000756213315153 , 8.04654404822e-05 , 0.0034964172166 , 9.72275748548e-05 , 0.0031807867251 , 1.11153101102e-05 , 0.00207781855539 , 0.000103058845902 , 0.00321480196708 , 0.00254665124109 , -0.000677765829441 , -0.00345153446649 , -3.2679950183e-06 , 0.00368051263079 , -0.00332903017905 , 0.00115774786304 , -0.00119998895115 , -0.00176475291124 , -0.000506780055196 , -0.0056520346262 , 0.00306793444515 , -0.0027124894306 , -0.000109930830047 , 0.00487624481771 , -0.000215691245599 , 0.00716367460811 , -0.000187945855306 , -0.00423135520712 , 0.000978641328894 , 0.000781176861677 , -7.93453497188e-05 , 0.00460094662857 , -0.00322870338525 , -6.87916140994e-06 , 0.00162856890153 , -1.75747663694e-05 , 0.000205654828252 , 0.00229635105305 , 0.00448931319014 , 0.00307121793235 , -0.00350756356031 , 0.00598419540005 , -0.000848823544561 , -0.00535932511318 , -0.000847092209043 , 0.0010812820179 , 0.00233489988198 , -0.00189366360546 , 0.00233881724311 , 0.000134906052919 , 0.000226354092467 , -0.000160251769865 , -0.00086123210176 , -0.000142589005499 , -0.00320996614564 , 0.000912867959343 , -0.000408121100801 , 0.000196827983768 , 0.000115882360176 , -0.00510544017241 , -3.82056206273e-05 , 0.00428385843716 , 0.000945739337605 , -0.000134744354993 , 0.00028022532584 , -0.000351983756475 , 0.000161336215813 , -0.00414752868225 , 0.000939901612422 , -0.00033846539431 , 0.000290951949323 , -0.00091847860919 , -0.000245011021823 , -0.00558254744736 , 0.00296750234335 , 0.000530111614862 , -0.000347232508633 , -0.00343808452546 , 0.00570815629658 , 0.000297112356459 , -0.000960614082375 , -0.000441895325531 , -0.00259247794477 , 0.000267631431277 , -0.00293725797177 , 0.00527129355051 , -0.00297606672911 , -0.00145524712295 , 0.00201309329903 , 0.00528954622325 , -0.00228507331913 , -5.46382857062e-05 , -0.0046135265288 , 0.000962238061811 , 0.000480406765161 , -0.00186343446832 , -0.00241920577756 , -0.0032410149707 , -2.06004682196e-05 , -0.00713564903365 , -0.00445994689051 , 0.00222422097108 , -0.00144104300461 , -3.3656283897e-05 , 0.00268703966782 , -0.000183943134731 , -0.0062732494194 , 0.00476369917687 , 0.00102550170845 , 0.00101608468453 , 0.00083198295724 , 0.00423076371731 , -0.00199485699021 , 0.00119834880277 , -4.1959378972e-07 , -3.30501680157e-05 , -0.00591284741764 , 0.00253447581575 , 1.23280584565e-05 , -0.0016424335262 , -0.000477821410402 , -0.00038509823499 , -0.00138879542965 , 0.0020432578168 , 3.67446758292e-06 , 0.00564266087327 , 0.00278668593731 , -0.00176750617377 , 0.00392250263376 , -0.00267932546247 , -0.0013803652194 , 0.00247428389336 , 0.000233359809654 , -0.0041761398846 , 5.55535166231e-05 , 0.00063659516058 , 0.00219233810352 , -0.00204215465271 , -0.00231432480865 , -0.000273093739403 , -0.00542872614475 , -0.00510025928535 , 0.000639516923206 , 0.0041465621112 , -0.00382867030607 , -5.53248557808e-05 , 0.000711684123917 , -0.00161744001908 , 0.00597924450289 , -0.000703466590881 , -0.000186446150535 , 0.00306751135063 , ])
Y_5_m4_imag = flex.double( [ -0.0 , 0.0 , -0.000725659197043 , 6.37020646276e-06 , 0.00480210366482 , 0.00529453426958 , -5.72010833438e-05 , -0.00197429502878 , 0.00508837033364 , 0.0020031618897 , 0.00306688493329 , -0.000439043085108 , -0.000528264231556 , 0.00101222982601 , 0.000631807010404 , -0.00111644036323 , 0.00675285598611 , 0.00100529612464 , 0.00227440491233 , 9.70807105608e-05 , -0.00138295936165 , -0.000721817472075 , 0.000813166520726 , 0.00207956078583 , -0.0043690566333 , -0.00303114862511 , -0.0006098072193 , -0.00104241683917 , 0.00156803350906 , -2.31431497361e-05 , 0.000294007717656 , 0.00215428003231 , -1.76921531369e-06 , -0.00371864243707 , -0.00176829068806 , 0.00396802758052 , 0.0013098236084 , 6.57631183249e-05 , 0.000856587839771 , 0.00290624777837 , -0.000140329155618 , 0.00464428904651 , 0.00368739952272 , -0.00198459126322 , 0.000923150690189 , 0.00592070979861 , -0.00197737274741 , -0.00263707918369 , -0.00539622895878 , 0.00136032975545 , -2.6403782488e-05 , 0.00104132758357 , 0.00522039176325 , 7.93142342152e-06 , 0.00374968995691 , -5.27247607412e-05 , 0.000353205833828 , 0.000210783273624 , 0.0017879272225 , 0.000408050577643 , -0.00100851119562 , -0.000154533418737 , 0.000110586169586 , -0.00307196194065 , 0.00100053676853 , 8.48442550312e-05 , 0.00443513729201 , 0.000934158488848 , -0.00203131580136 , -0.00348073466812 , -0.00410905668454 , -0.000605940400893 , 0.000679070711426 , -0.00102253816169 , -2.44046628956e-05 , -0.00371122459912 , 0.000805249739808 , -0.00726782954154 , 1.89044976989e-07 , -0.000145726666644 , 0.000233985147255 , -0.00700929274966 , 0.00258853905721 , -0.00339195063012 , 0.00117665329469 , 0.00573621072635 , 7.25030379451e-05 , 0.00141685993449 , -0.00016896411971 , -0.00339183790354 , -0.00465849110849 , 0.000815768118828 , 0.0030709927968 , 0.000640982034857 , -0.00198971481551 , 0.00463071962861 , -0.000340844689848 , 0.00143093658778 , -0.00389908810574 , -0.00294871371154 , 0.00183900620728 , 0.000641711448929 , -0.00351782021262 , -0.000127104002414 , 0.000554399179175 , -0.001490398104 , -0.00250110418187 , -0.00118703498101 , 0.00703631457662 , 1.47179692574e-05 , 0.000150641417836 , 0.000993492051584 , 0.000735392158275 , -0.000134279516063 , -0.000199522382317 , -0.00166950343654 , 0.00247091917482 , 0.00448984886015 , -0.00318236510859 , 0.0025793271269 , 0.000533628141714 , -0.000195472789712 , -0.00183662611225 , 0.00102244283282 , 0.00238833985626 , -0.00280345415605 , -0.00433916725878 , 8.76274311862e-05 , 0.00239046391824 , 0.000542133591557 , 0.00442577360654 , -0.00367695309261 , -0.000123335820866 , 0.000172272043413 , 4.83634041694e-05 , -0.00528774237813 , -0.00223282569004 , 0.00210651769359 , 0.00355800744414 , 0.00356347448744 , 0.00173186760238 , -0.00201952732885 , 0.00381978379033 , -0.000749713518649 , -5.99056027868e-05 , 0.000800916300073 , -0.0045038074019 , -0.00364137478947 , 0.00227422057604 , -0.00283297284768 , 0.000587057196773 , 0.00152787624859 , -0.00143421434363 , 0.00126339358939 , 0.00231846411215 , 0.00336144671452 , 0.002078264545 , 0.0018506456555 , -0.00145888666008 , -0.00242274480682 , 0.00450074419507 , -5.9420171927e-05 , -5.70239174033e-05 , -0.000170016419966 , 0.000162084090901 , -0.00631007929043 , -0.000757679174647 , 0.000161577391938 , -0.00634406306015 , 0.000703238901599 , 0.00370197056426 , -7.34211979446e-06 , -0.00426908112264 , -0.000466552894991 , 0.000798096960734 , -0.0006183150676 , -0.00673816489861 , 0.00330334497025 , -0.0020423313536 , -0.000273604246603 , 8.99080978077e-05 , -0.000184878731858 , 0.00728135909715 , 0.000944659499499 , 5.15703877833e-05 , -0.000415300441351 , 0.00164672671376 , 0.00385263001619 , -0.00574252391113 , 0.000110998063873 , -0.00449111238629 , -0.000648257698953 , -2.25935355903e-05 , 0.00178568431957 , 0.00183123023793 , -0.00321565388463 , -3.98499071119e-05 , 0.00145923296648 , 0.00239817409774 , -0.00278579800014 , -0.00265306546274 , 0.000496244789837 , 0.00564007300106 , 0.00457851894867 , -0.000642663511892 , -0.000187109289514 , 0.00132745132815 , -0.000212555922443 , -0.000376297758872 , -0.00271926297307 , 0.00298267560362 , -0.000357858777998 , 9.22555347736e-05 , -0.00490919731914 , -0.0046512570049 , 0.00526692357498 , 0.00511816882117 , 0.00231158541983 , -0.00249971267522 , 0.000750999012755 , 0.00390786344565 , -0.00168882451816 , 0.00236639388292 , -0.00199573275331 , 0.00599207487975 , -0.000785188848114 , -0.00275200091801 , -0.000161179256141 , 0.00072007659571 , -0.00187094984451 , -0.00262471913371 , 0.00580248953256 , -0.000230211445934 , 0.00409737531605 , 0.00022651968819 , -0.000982468467167 , -0.000879531411994 , 0.00402245268997 , 0.00110388384515 , -0.00113543727913 , 0.00393508886616 , -8.5406844272e-05 , -0.00738252031979 , -0.00191462949296 , 0.00265032450783 , 0.000190318029463 , 0.000155417697024 , -0.000370534989544 , -0.0018087482581 , -0.00140184950788 , 1.7722243018e-05 , 0.000204655629303 , -0.000443362815233 , 0.00475657692422 , -0.000276523136549 , 0.00121164747084 , 0.000293480453699 , -0.000315155288736 , -0.00307742272975 , -0.00383511972554 , -0.0018886004408 , -0.00104723059282 , -0.00227383738942 , -0.00608146860594 , 0.00393239733335 , -0.00358181576047 , -0.00208126586897 , -0.00123855981333 , -0.00240258722707 , -0.00140900610281 , 0.00182575643638 , -0.00246405072723 , 0.00157088778495 , -0.000713927113405 , -0.00443408128092 , -0.00110199201157 , 0.000432625294555 , 0.00546356296591 , 0.00511460255473 , 0.00311364633445 , 0.00747903490929 , 0.00371414537518 , -0.00299490924839 , -0.00325868799791 , 0.00223982487327 , -0.00477313751271 , -0.00459852770514 , 0.000486370648908 , -0.00734738423836 , -0.00293808578233 , 0.0018158749101 , -0.000798230413382 , -0.000427543397354 , 0.00640697366515 , 0.00147322365909 , 0.00259288966606 , 0.00336428207942 , -0.00151425092472 , 0.00540547521799 , -0.000334658668788 , 3.40839374141e-05 , 0.000125211195418 , 0.00302085808998 , -0.0059875366536 , -0.000296881178706 , 0.00486226421904 , -0.00026754208498 , -0.0015387365158 , -0.00594715798521 , 0.000907533779458 , -0.00480239489947 , -0.00315405821379 , -0.00499350990024 , 0.00304774739263 , -0.00252908585085 , 0.000692599801253 , 0.00206476834898 , -0.00369025309916 , 0.00289300755797 , 0.00283906104951 , -0.00297725919897 , -0.000107139889758 , -0.00694674938341 , 0.00103851602241 , 0.00106747070093 , 0.000440669493904 , 0.00266882624609 , -0.00131743881412 , 0.00306122278879 , -0.0056057878 , -6.5473044685e-07 , 0.00299115301308 , -0.00361438468932 , 0.000174936967779 , 0.000852299994337 , 0.000599382352078 , 0.00545097901711 , 0.000147109601241 , -0.000917614208284 , -0.00260589124879 , -0.00013837665882 , -0.000293643055827 , 0.00236054099111 , -0.000260791678485 , 0.00041180879167 , 0.000162160913313 , 0.00629821472767 , 0.000656221812769 , -0.00789940860992 , 0.00138992833374 , 0.00179371639564 , -0.00668669148282 , -0.00267753147188 , -0.00258063851012 , -0.0033744388613 , -0.00193853033804 , -0.0047602331888 , -0.00617164936094 , -0.00106142339559 , -0.00527124364763 , -0.00426615529419 , -0.000136576212165 , 3.33804415626e-06 , -0.00240034326174 , 0.00194853804115 , -0.00495273981327 , -0.0018918556936 , 5.6560183653e-06 , -0.00213096610511 , -0.00516259173242 , 0.0012646317183 , 0.00515787983991 , -0.00277504657528 , 0.00417642417299 , 0.00481004739596 , 0.00747158286357 , -0.00384019548161 , -0.00592145597647 , -0.000735648474103 , -0.00373896872526 , -0.00136868511569 , 0.00055953682026 , -0.00180407031526 , 0.00691204261646 , 0.00482249574631 , 0.000144772117936 , -0.0034829355718 , -0.0035061872447 , -0.000711545561559 , 0.00184066656399 , -0.000655243930789 , 0.00432825152472 , -0.00114137768095 , -0.0031756131489 , 0.00154367750386 , 0.00479757707454 , -0.000795762195977 , -0.00130987414177 , 0.0013677171651 , -0.00484997697881 , -0.00168215202994 , -0.00482867476213 , -4.09682831522e-06 , 0.0048096506694 , -0.00136044106563 , -0.00201782138859 , 5.72389289984e-05 , 0.000607307706305 , 0.00175412211381 , 0.0028629802036 , 0.000148061261069 , -0.00521154340052 , -0.00517147946682 , -0.000963263681184 , -0.000432690392878 , 7.08542626121e-05 , 0.000584548814286 , 0.00347025897568 , -1.16934653623e-05 , -0.000891826944878 , 0.00470136122806 , -0.000548496354315 , -0.000140218087044 , 0.00474403850095 , -0.00161454535063 , -0.000583951197679 , 0.000159648307037 , -0.00330860042178 , 0.00183142050819 , 0.00185045412494 , -0.000245832975296 , 0.000629951339195 , 0.00455863333241 , -0.00397744392296 , -0.00299840504047 , -0.000424340136995 , -0.00396638174991 , 2.03806401434e-05 , 0.00284047385446 , -0.000311735769691 , -0.0055111067254 , -0.0024803347003 , 0.0019202838749 , 0.000203910669971 , 0.00218736248003 , 0.000241069099623 , 0.000981023975394 , -0.0030265889992 , 0.00569706959953 , 0.000193979741888 , -0.000888556095598 , 0.00518692950975 , -0.00495522894141 , -0.000223794992632 , 0.00185748006605 , -0.00141796688289 , -0.0014200461226 , 0.00292160349904 , -0.00296784663158 , 0.00407758422872 , 5.13043816623e-05 , -0.000601742764434 , -0.00216697980105 , 0.00164293508582 , 0.000142783329752 , 0.00502685879967 , 0.000352329540339 , -0.00101446871156 , -0.000586169553642 , -0.00531240572169 , 0.000985732601466 , 0.00407287099955 , -0.00121564264799 , 0.00401303821913 , -0.00133823774986 , 0.000935988494267 , 0.00192674193456 , 0.00633239242003 , -0.000696690658841 , 0.00143715775337 , -0.000776737693502 , -0.00214939381999 , 0.00103549852142 , -0.00236940309637 , -6.79201206911e-06 , -0.00290907803502 , 0.003775210553 , -0.00527842428155 , 0.0023758697713 , 0.00103215365463 , 0.00661200463031 , 0.00176249552058 , -0.00303190748484 , 0.00327295753411 , 0.00294549623652 , 0.00197992410021 , -0.00236490546469 , -0.000110314895027 , 0.00199748923367 , 0.00209798346597 , -0.000307727792102 , -0.00129410617461 , 0.000561642400522 , 0.00376572371506 , 0.00170497373336 , 0.000626849607094 , -0.00229023655002 , -0.00204725608044 , -0.00202445528862 , 0.0012574470469 , -0.00238504095397 , 0.000385790513628 , -0.000894680318451 , 0.00364268590165 , -0.00220896017868 , 0.00331870181472 , 0.00453424466742 , -0.00222851456797 , -0.00372904723307 , 0.00332931251441 , -0.00474218632368 , -0.000330302158448 , 0.0020003645387 , 0.000106910895082 , -0.000111699576941 , 0.00119649848847 , -0.00254770152236 , 0.00445412132372 , 0.00199251083766 , -1.11562233622e-05 , 0.000318571706408 , -0.00108072628108 , -0.00138611909893 , 0.000622981453101 , -0.004435325998 , -0.000239777854632 , 0.00120369394251 , -3.37293014969e-06 , -0.00258651898674 , 0.00126772292468 , 0.00231712784758 , 0.00234284724777 , -0.0049955622966 , 0.00430390824888 , -0.000455989746875 , -0.000126904570836 , 0.000352476706949 , -2.50577290059e-08 , 0.00227960230472 , -0.00233201722816 , 0.0051918767695 , 0.00341846064278 , -0.000114400028814 , -3.07011271409e-06 , -0.00224898730539 , 0.000263680687974 , -0.000298375848314 , 0.0046918642402 , 0.000346686049101 , -0.00394192881509 , 3.22157734176e-05 , 0.00195913421488 , -0.000713647274439 , 7.74174847278e-05 , -0.004211686897 , 0.00477980253764 , 0.00182670058188 , 0.00374950736223 , 0.003024452777 , -0.000694825456221 , 0.00295882050751 , -0.0043304239533 , 0.000225465065625 , -0.0019893212919 , 0.00639169352996 , 0.00308686903349 , 0.00348641794746 , -0.00247447602856 , -0.00334486604245 , 0.000398509633382 , -0.00113302989533 , -0.00120631141025 , 0.000131448035021 , -0.00676151886423 , -0.00175065859954 , 0.00504620670522 , 0.00529151111301 , -0.00372864481134 , 0.000134077135413 , -0.00190416990516 , 0.00145417764503 , -0.00312493767135 , -0.000195303515509 , -0.00012162064767 , 0.00150355328989 , 0.000195244784589 , 0.00474790096079 , -0.000139052002941 , -0.000238208370684 , 0.000374318913319 , -0.000449299628339 , -0.00199457182003 , -0.00300546899921 , -0.000292829489364 , -0.00163775288359 , -0.00708556573758 , 0.000421882919668 , -0.000298726320415 , 0.00175280367562 , -0.000134532299564 , 0.00380300307357 , -0.00114427024427 , 0.000173604158206 , 0.00167192155084 , 0.000988810060989 , -0.00534426483341 , -0.000407256207335 , -0.000112049511761 , 0.00648032982099 , -0.00476619343825 , -0.00155956747694 , -0.00127871252295 , -0.000502927680676 , -0.00189908728386 , 4.41273019008e-05 , -0.00131104325367 , 0.000695602652971 , 0.00239229969832 , 0.00225684988197 , 1.89654149729e-06 , 0.00301126643584 , -0.00168630191481 , -0.00187975749869 , -0.000617147016956 , -0.00589766940915 , 0.00193061725328 , 0.00227513467743 , -0.00170396444835 , 0.00150922597851 , -8.77622000591e-05 , -0.000407111732356 , 0.000154984701695 , -0.00141371454425 , -5.25321107792e-05 , 0.00514770775804 , 0.000542425493377 , -0.00532318447547 , 0.00515947571269 , 0.00392341587726 , 0.00035829627594 , -0.00440191408207 , -0.00515394955095 , -0.0040138962284 , -0.00198307427327 , -0.00509159663639 , 0.000613528536551 , -0.00160507940175 , 0.00113019592776 , 0.000656866499074 , 0.00156540528476 , -2.53901994951e-05 , -0.00075789597216 , -0.00129687605956 , -0.0008130926338 , -0.00165586106362 , 0.000236183333947 , 0.0036138055799 , -0.000152133603435 , 0.000183624016224 , -0.000439287480756 , 0.000524330355233 , -6.27746515557e-05 , 0.000508588045151 , -0.000856755998477 , -0.00615842885555 , -0.00392448375889 , 0.00170038836283 , -0.000368585961333 , -0.00223061900771 , 0.0014262353896 , -0.00436182670256 , 0.00306698064952 , 0.000201651327444 , -0.00185722824586 , -0.00545345471856 , -0.00236125952665 , 0.00324013185615 , -0.00623159103126 , -0.00149192769712 , -0.00206412114806 , -0.001995906283 , -3.80931735604e-05 , -0.000992189964458 , -0.000335438506246 , -0.00322866609804 , 0.00133038734959 , -0.00100869774023 , -0.00190060596381 , 0.000920822700901 , -0.00299931826791 , -0.00214442354332 , 0.00575773281325 , -0.00409770617374 , 0.00477894553638 , 0.00150755172833 , -0.0041966712249 , -0.000976910308516 , -0.00374457336521 , -0.00175949646666 , -0.0020215930367 , -0.00108914703284 , 0.00346970071663 , 0.00543868287661 , 0.00274095270416 , 0.00242303731677 , 0.000763390494114 , -0.00232867804277 , -0.00793813264148 , -0.0056380300171 , -0.00215316189561 , -0.00279345910628 , -0.00443111553957 , -0.00071142396962 , -0.000726083940878 , -0.00127677052646 , 0.00397073963535 , 0.00339748387624 , 0.0042537880515 , 2.32029347072e-08 , -0.00521722194833 , 0.000112615206035 , -0.00196126920817 , -0.00298150261473 , -0.00228528477405 , -0.00145766765721 , -0.00157273077423 , 0.00111031179312 , -0.00566632250638 , -2.84418454108e-06 , -0.00177447907363 , 0.00653007553779 , -0.00160205389174 , -0.000879255719382 , 1.14011843033e-05 , -0.000126093843902 , 0.00321544885692 , -0.000146400380654 , -0.00103732622466 , -0.00159682280515 , -0.000373343133737 , -0.00225886728062 , 0.00198769997176 , 5.17930135099e-06 , 6.49881210317e-06 , 0.00382969341853 , 2.49826650087e-05 , 0.000497422906113 , -0.00433747007035 , 0.00388570461673 , 0.0004611011205 , 6.99474940457e-06 , -0.00532344049132 , 0.00302102996603 , 0.00185336407983 , 0.00501702127888 , -0.00742240191622 , -0.000814138907847 , -0.00308370965041 , 0.00476501799065 , 0.000249841056974 , -0.00511565627355 , 0.00444343787591 , -0.00219650534429 , 0.00122361161643 , -0.00115707184885 , 0.00277815342577 , -0.0032115546896 , -0.00221658960789 , -2.70174556807e-05 , 0.000181249223671 , 0.00421052785543 , 2.5707787994e-05 , 0.00106017451359 , -1.67744321162e-05 , -0.00257892734949 , -0.00413422462982 , -0.00180218894453 , 0.00446548924111 , 0.00364238375938 , 6.29774452229e-05 , 0.000127703260813 , 0.00351799891723 , 0.00163355168532 , 7.19879510217e-05 , 0.0031504920754 , -0.00204584137601 , 0.00278138274401 , 0.000308125523327 , -0.000877476565038 , 0.000278514335377 , 0.00211491524528 , -0.000166539117139 , -0.00491291120245 , 0.000118743775054 , 0.00337494353334 , 0.000167947452742 , -0.00336756500384 , -9.7585600294e-05 , -0.000247401786678 , 0.00211518150519 , 0.00612012949663 , 0.00487391437798 , -0.00110591495046 , 0.00256796053219 , -0.000140872314792 , 0.0013076188907 , 0.00356763300871 , -0.000440118301814 , 0.00121556984141 , 0.00203382501621 , -0.00118216286926 , -0.000151772509007 , 0.00049989827108 , -0.000366845183165 , 0.000770913359785 , 0.00165940675997 , 0.0039754835894 , -0.00185916707092 , -0.000957897129447 , 0.00295279655932 , 0.00193554459106 , -0.00241671411692 , -0.00630394559872 , 0.00524107598478 , -0.00261523229267 , 0.00483351890425 , -0.00549166433939 , -0.0013497818133 , -0.00715329366513 , 0.000102087650286 , 0.00387322555758 , 0.00125372193034 , -0.00109302142351 , 0.0019375506906 , 0.00156008156534 , -0.000167144116521 , 3.86419528445e-06 , 0.000833613873115 , -0.00684735505762 , 0.00247234162697 , -0.00129299148157 , -1.06721858755e-05 , 0.00159771605155 , -3.19251171162e-05 , 0.00212960266661 , 0.00352650461036 , -5.02532991056e-05 , 0.000442155426247 , 0.00446887871219 , 0.00395006281913 , -0.000418468722376 , -0.000145579958085 , -3.96641352285e-06 , 2.32200049935e-05 , 0.00285818903584 , 0.00141651833998 , 0.00299291656102 , 0.000575740087318 , 0.000234834738745 , -0.00341597814138 , 0.00806295953632 , 0.00280257402223 , -3.26533052261e-06 , -0.00321210834009 , 0.00371164793198 , -0.00130890745148 , 0.00220168109999 , -2.3695434579e-05 , 0.0056432646354 , -0.00086901243113 , 0.000160323203302 , -0.00625350415422 , 2.08728769445e-05 , 0.00374172379112 , -0.00243651649518 , 0.00384620359787 , 0.000901014265768 , 0.000536550800389 , 0.00255995323379 , -0.00151325744871 , 0.00514700731961 , 0.000197834915085 , 0.00085734717681 , 0.000133504629255 , 0.00434410973433 , 0.00189035424236 , -0.00267355093613 , 0.000524467018422 , -0.000656372066288 , 0.00107680884159 , ])
Y_5_m3_real = flex.double( [ -0.0 , -0.00578751663936 , 0.00414313275399 , 0.00250640583348 , 0.000159332825322 , 0.00563444958162 , -0.00500909931838 , 0.00161982368095 , -0.000138276932811 , -0.00328696559183 , -0.00352698081315 , 0.00155167109567 , 0.00261051507921 , -0.0021805710758 , 0.000681650369288 , 0.00067181836099 , 0.00185990494162 , -0.00247105899586 , -0.00115669321675 , -0.000904906856812 , 0.00413257300164 , -0.00187137535765 , 0.00379846016845 , -0.00460518997289 , -0.00232133044861 , -0.00442113863071 , 0.00554344335862 , -0.000218048197124 , 0.00173270746785 , -0.000136167754887 , 0.00211800909801 , -0.000641275282403 , -0.000648301047259 , -0.000926690085829 , -0.00271506997197 , 0.000691377393223 , -0.00357210600406 , 0.000250108170321 , -0.00141124402363 , -0.000489459150608 , -0.000297041539009 , -0.000774141565111 , 0.00153260120664 , 0.00413473207645 , -0.00161403503536 , 0.00038264584149 , -0.0025699446696 , 0.00152154176052 , -8.13324482644e-05 , 0.00108880613814 , 2.25449654088e-05 , -0.0050791088942 , 0.00154663938596 , 0.00154391485923 , -0.00190632068022 , 0.000114992920051 , -0.000545831090505 , -0.00295263707187 , -0.00455055509273 , 0.00555112373192 , -0.00476392402597 , 0.00161436240429 , -0.000879217802562 , -0.00298423741379 , 0.0058427963074 , 0.00183715050129 , 4.60721167451e-06 , 0.00137360472855 , 0.00156904994543 , -0.000705586884966 , 0.00280801762632 , -0.00153957007335 , 0.00443060530641 , -0.00457693776604 , 0.000157231987701 , -0.000190875020541 , 0.000195300274096 , -0.000112305256964 , 6.2448323904e-06 , 0.00277206557744 , -0.00242079849236 , -0.00371524490826 , -0.00131549638249 , -0.000741271645316 , -0.00169381353034 , -0.000160989256744 , 0.000389999145546 , 0.000951194375136 , 0.0024485122546 , 0.000774620505024 , -0.00183258172612 , 0.00330612736234 , 0.00558678137747 , 0.00099766096804 , 0.00452658781275 , -0.00222696038378 , 0.00159756411852 , 0.00380688590052 , -0.00128320776387 , 0.00155592213353 , 0.00370849613939 , 0.000455582600638 , -0.00318582374243 , 0.00373545820811 , -0.000885851936129 , 0.00250742774039 , -0.000755647896465 , 0.00177835471154 , -0.00560587135996 , 0.000305542978521 , -0.00111160093022 , 0.000964641578684 , -0.00418552334671 , -0.000731849611542 , 0.000160143531505 , 0.00342759378483 , -0.00204505673899 , -0.00187137873328 , -0.00353357442929 , 0.00422210895557 , -0.0040749031617 , 0.000283979887171 , 0.00437750693604 , -0.00313012054678 , 0.00210180614953 , -0.000193644935767 , -0.00183072066952 , -0.000903130013478 , -0.00448634166111 , -0.00144259207809 , 0.00164435949211 , -0.00117669893628 , -0.000367589947496 , 0.00112309873299 , -0.000162117364321 , 0.00224686113899 , 0.00308035986289 , -0.00045975308861 , 0.00317900919002 , -0.00303667796639 , 0.00442982841016 , 0.00317587527522 , 0.000126410025122 , 0.00137434628998 , -0.00483461600341 , 0.00437503103537 , 5.69079549877e-05 , 0.000122683828778 , 0.00124318272561 , -0.00260231617277 , -0.00167594858393 , -0.0024622476334 , -0.00235407588081 , -0.000863929394026 , -0.000392638774073 , 0.0024732115392 , -0.00172706022991 , 0.00511216274907 , -0.00290825474133 , 8.72110000968e-05 , 0.00264610273775 , -0.000423743903738 , 0.00110875060483 , -0.00564920277453 , 0.00402090952967 , -0.00393123814227 , 0.00643999027857 , 0.00236358231856 , -0.00219157595316 , 0.00227945474274 , -0.00425094693157 , 3.46491845166e-05 , 0.00352471427589 , -0.000908530473294 , -0.00246842685877 , -0.00343337762154 , 0.000130905480715 , -0.00562019919143 , 0.000376013848003 , 0.000822813917191 , -0.00213187533704 , 0.00163283794953 , 0.000329559311138 , 0.00550455269734 , -0.00362742998681 , 0.00106610079658 , 0.00418120129927 , 0.00569314186737 , -0.00310481406153 , -0.000734163606344 , 0.00344837804157 , 0.00163745271278 , 0.000263405330254 , 0.000598983948719 , -0.00334330786081 , 0.00523017708187 , 7.95976351192e-05 , -0.00432635341594 , 0.00344800361878 , -0.00281600035572 , 1.58115038066e-05 , -0.00471497105008 , -0.00191268814146 , -0.000274526834488 , -0.00275617548782 , -0.000976351751182 , 0.00025901284242 , 0.00264277918735 , -0.00160380008695 , -0.00720503813616 , -0.00044669749598 , -0.000881260697305 , 0.000172682178797 , -0.00133894285607 , -3.88649674815e-05 , -0.000231325387475 , -0.000439032636872 , -0.00207442535118 , -0.00152578230675 , 0.00722433954477 , -0.00175675981225 , 0.002025078461 , -0.00388680658407 , 0.000643149537906 , -0.00190674802796 , -7.59918170605e-05 , 0.000491512632257 , -0.00435890441824 , 0.00152673793465 , -0.002789660248 , 0.00238989650349 , -0.00336048556484 , -0.00328266239637 , 0.000529545153371 , 0.00450551499831 , -0.00136920201813 , 0.00151834442624 , -0.00520569368228 , 0.00156299891538 , -0.00383426692496 , 0.000830804329997 , -0.00340023441169 , -0.00490967183205 , -0.00248035004109 , -0.000670943697135 , 0.000392386914955 , -0.00199237640702 , 0.00536584846946 , 0.000861020931476 , 0.00400570898762 , 0.0030640270265 , 4.24686872099e-06 , -0.000864917158683 , -0.000414247730105 , -0.00145468676284 , -0.00179134925153 , 0.0047017374164 , -0.00159419053596 , 0.00045388879357 , 0.00425029411283 , 0.00394186246947 , -0.00112223886094 , -0.000784179663505 , -0.00133313528867 , -0.00241759395569 , -0.00137688748107 , -0.00388524459768 , 0.00239269325243 , 0.00658060228072 , 9.71299182994e-06 , 0.00145577240134 , -2.57936027829e-05 , -0.00125846283475 , -0.000192032687874 , -0.00809037001997 , -0.000841551119081 , -0.00532580545742 , -1.94092611177e-05 , 0.00173853714519 , -0.00080680650904 , 0.00480409791446 , -0.00659521527064 , -0.00240725256068 , -0.00605318598665 , 0.00359915452249 , -0.00682142604639 , 0.00168681993417 , -0.00361904556544 , 0.00505758849547 , 0.000217248287654 , -0.000793631885827 , -0.00401566397165 , -0.0020097675101 , 0.000114370596452 , 0.000213789112867 , 0.00273109374368 , 0.00827570778984 , -0.00443375143848 , 0.00356899687491 , -0.00244989167121 , -0.000136682671678 , 0.000181970779807 , -0.00200661525413 , -0.00267675816908 , 0.00284636614746 , 0.00293528054785 , -0.00348852775529 , 0.000726077623642 , -0.00113231784517 , -0.0013491787302 , 0.000640560805706 , -0.00220176491776 , 0.000673821191611 , -0.00179103305182 , -0.00355303198537 , 0.000204564800901 , 0.00239102863613 , -0.000968738129439 , -0.00499789906256 , -0.000670838042717 , -0.000874233600829 , 0.000520773119453 , 0.0089249521867 , -0.00205284999124 , -0.00232796420799 , 0.00189063466092 , -0.000902261438443 , -0.000576472078396 , -0.00508545625983 , -0.00158819472749 , 2.72659997668e-05 , -0.0020274032846 , -0.00514149949496 , 0.00114237715754 , -0.00250440708955 , -0.00159684037813 , 0.0013738826595 , -0.000278204805755 , 0.00292011615592 , -0.00295785773099 , 0.000583053866173 , -0.00169121688288 , -0.00543879911209 , 0.000945120426114 , 0.00158141960053 , 0.00039849112312 , 0.00242490758678 , 0.00184158602663 , 0.00322414560055 , 0.00317758247125 , -0.0011360290524 , 0.0025887448272 , 0.00136665541098 , 0.0017131185382 , -0.000705042964145 , 0.00245851063444 , 0.00453942332734 , 0.000323526306996 , -0.00420575602967 , 0.00723404352502 , 0.00340613844901 , -0.00101002749175 , -4.15490576175e-05 , 0.00206078182428 , 0.00161599813584 , 0.000299373154531 , -0.00356103186461 , 3.70998816077e-05 , 0.00471823770239 , 0.00390647471583 , -0.00083667760354 , 0.00620940978282 , 5.4428422439e-05 , 0.00339568934621 , 6.09560881622e-05 , -0.00218158370309 , 0.00026666149621 , 0.00728932923754 , 0.000942168968776 , 0.00526348468967 , -0.00197528296653 , -0.000267498611067 , 0.000232076857703 , -0.000997379934057 , -0.00046705607616 , 0.000973809258052 , 0.00513893185303 , -0.0039358625367 , -0.000857698157531 , 0.0046469785 , 1.71101561942e-05 , -0.00240015362088 , 0.00405659766874 , 0.00335963117785 , 0.00639146122022 , -0.000114138209339 , -0.00144801051745 , 0.00462541424103 , -0.00318503664746 , 0.00149912495453 , 0.00266331306789 , 0.000161883618952 , 0.00187734177079 , -0.000559741862169 , -0.00131134783579 , 0.000232409161035 , 0.000293975059739 , 0.000229552132554 , -0.00129589930067 , 0.000771157327556 , 0.00242683705379 , 0.000691724517241 , -0.00160947292957 , -0.000436011644995 , -0.00305811143483 , -0.00713917243407 , 0.00376609229048 , -0.00245681009666 , -0.00204468114481 , -0.00335230803548 , -0.000560221850301 , 0.0024933835732 , 0.000561724791961 , 0.0013467154601 , 0.00052754235787 , -0.00270061507472 , -0.00549925306318 , 0.000532171772231 , 0.00616802440183 , -0.003709701049 , -0.000693045594541 , -0.00213306755852 , 0.000139707663753 , 0.00306391337461 , -0.00229014542969 , 0.00105461124215 , 0.00138638714222 , -0.000128903338811 , -0.00171139903804 , -0.00106090343237 , 0.00468043230459 , 0.00500829078128 , 0.00327526464403 , 0.00220576117386 , 0.00428124969535 , 0.000874638751917 , -0.00121781944356 , 0.00069224885915 , 0.00161920614247 , 0.00340355984355 , -0.00343140717656 , -0.000689965955564 , -0.00320752237049 , 0.00189908784068 , -0.000295743063611 , 0.00271389801706 , 0.00501041751212 , -0.00643344823234 , 0.00184388428418 , 0.0020588381634 , 0.00365500457858 , -0.00392201232211 , -0.000463400505709 , -0.000265037574746 , 0.000102374386769 , -0.000244237403007 , -0.00493004896637 , 0.00410058854979 , -0.000381874963735 , -3.28185628413e-05 , 0.00380471952348 , -6.47361106942e-05 , -0.00577628285323 , 0.00383133826663 , -0.00021250411068 , -0.00363914659232 , 0.0032935720496 , 0.000123332163829 , -0.00494648233265 , 0.00380075031156 , -0.00289317956056 , -0.00447863389726 , -0.000691140492095 , 0.00203019920225 , 0.000132013071784 , -0.00400367142217 , -0.00406877074325 , -0.000377524824185 , 0.0022249905044 , -0.00240869534167 , 0.000321807925494 , 0.0028146411486 , 0.00525115127822 , 0.00183687420309 , -0.00188785033414 , 0.00211780562105 , -0.00230151996966 , -0.00273712267754 , 0.000968961087242 , 0.00290921202199 , -0.00339202229482 , 0.00385388550423 , 0.00434510315678 , 0.000434886001924 , -0.000377938803018 , 0.00101156954257 , -0.00158263787566 , 0.000968865471832 , 0.00218386634567 , -0.00184010138274 , 0.00411503590724 , -0.00137317784294 , 0.00669964072943 , 0.00305011120218 , -0.00353075829536 , -0.00427001603349 , 0.00558776011548 , -0.00280260331465 , -0.00436872198799 , -0.0049866639043 , 0.00506330614889 , -0.00525690100136 , 0.0025693112289 , 6.45781887185e-05 , 6.35599982908e-05 , 0.00154963429545 , 0.00194337419361 , -0.000391814746147 , 0.000793689324258 , 0.000333210550271 , -0.00019473047332 , 0.0011649909542 , 0.000439935865121 , 0.00313889488544 , -0.000121011307857 , 0.00440893642446 , 0.000369017270892 , 0.00139128935341 , -0.00201774306057 , -0.00350571543733 , 0.00456850738063 , -0.00120171919187 , -9.46581271858e-05 , 0.00189258497879 , -0.000613043811372 , 0.00188141569815 , -0.00149705446032 , -2.27111878451e-06 , 0.00076706935817 , 0.00402212800703 , 0.00321194429583 , -0.00312517082808 , -0.000396875555929 , -1.2263199032e-05 , -0.00559150007514 , -0.000287356852618 , -0.000575549327527 , -0.00563205067331 , -0.00220140237839 , -0.00414249589857 , 0.00106564114334 , 0.00335857634554 , 0.00298951128188 , -0.000336615407016 , 0.00350231282407 , -0.00427285691151 , -0.00361316192632 , -0.00465061129572 , 0.00155869766087 , 0.000191974585284 , -0.00195622366293 , -0.0038037756062 , -0.00390827587117 , 0.000653698550569 , -0.00278391266274 , -0.00155578392385 , 0.0031907349346 , -7.5014561521e-05 , -1.72419966678e-05 , -0.00286156354294 , 0.000874032731182 , -0.00383600295426 , -0.00447982402134 , 0.000383670471879 , -0.00204187420054 , 0.000681653303734 , 0.00856810055942 , -0.000662633306433 , 0.00181333628257 , 0.000889637738191 , 0.00261614978766 , -0.00650773375396 , -0.000115334453418 , -0.00340506414561 , 0.00218723591572 , -0.00240605663832 , -0.00165095645879 , 0.00153945382776 , -0.00234888640629 , -0.00245682057949 , -0.00223655949516 , -0.00177376042577 , -0.000995555830604 , -0.00380612681505 , 0.00293426900338 , 0.000511749302818 , -0.00361500760597 , -0.00148282671319 , -0.00144660040544 , 0.00157288919567 , -0.000164349656458 , 0.00387587044933 , -0.00687297221014 , -0.00109366946389 , -0.00342275584026 , 0.000532214754851 , -0.00208765782364 , -0.000448584633656 , 0.00151301367407 , -0.000246842974602 , -0.00652680318763 , 0.00199101972836 , 0.00429444020147 , -0.0033565530663 , -0.000757916507942 , 0.00135000085851 , -0.00207467441345 , 0.00153700327002 , -8.90156661359e-05 , 1.83318992335e-05 , -8.12527144796e-05 , 0.00105398400957 , 0.00056331209961 , -0.00214414597925 , -0.00695921356919 , -0.00362848398108 , 0.00062995629042 , 0.00462186683584 , 0.000743245849875 , -0.000381779550149 , 0.00570356333599 , 0.00208774306023 , -0.00398455097665 , -0.000320044823312 , -0.00421158801934 , -0.00113574976324 , 0.000472010418531 , -0.00631195293766 , -5.96961657652e-08 , 0.000851681266177 , -0.00428667267696 , -0.00179635439277 , 0.00418887546138 , -0.000493382880063 , -0.00133512004489 , -0.0023240643669 , 0.000817940339646 , -0.00373233008441 , 0.00172812284306 , 0.00239161778786 , 0.000320806215231 , 0.000738306114693 , -0.00107007808966 , 0.00398069933559 , -0.00320848632312 , 0.00048700057722 , -6.85066202506e-05 , 0.00111682151898 , 0.000392529572928 , 0.00382127741566 , -0.00273625473329 , 0.00551638188618 , 0.000372969017415 , 0.0012359234248 , 0.00363204205488 , -0.00180371514755 , 0.00251640373349 , -0.000162904765284 , -0.000564909786361 , 0.00169599485309 , 0.00131676218428 , -0.00467350534926 , -0.00114257911828 , -0.000422179403434 , 2.89534878504e-05 , -0.00431819191025 , 4.09598760269e-05 , -0.00357521739137 , -7.8633050297e-05 , 0.00271682246296 , -0.000744301552677 , -0.0015916076536 , 0.000351197910429 , 0.000310727169138 , 0.00251840283455 , -0.00213215688222 , -0.000579983823805 , 0.00213603618575 , -0.00407406083377 , 0.00157106162044 , -0.00247018241042 , -0.000663401116885 , -0.00132146891391 , -0.000166015999686 , 0.00609719787435 , 0.00148109437444 , -0.000283872359241 , 0.00944248662799 , 0.0038890521072 , -0.00722767565952 , 0.00328840253712 , -7.89080005495e-05 , 0.00132887452889 , -0.000282622324713 , 0.00309981082997 , 0.00411512875134 , -0.000872682270719 , 0.00344053987437 , -0.000267520787109 , -0.00289340111071 , 0.00461766543417 , 0.00193643912546 , 0.00012895470193 , -0.00162237082241 , -0.00135029059191 , 0.00365730985793 , 0.000207635670389 , -0.00208707539463 , -2.26631828205e-05 , 0.00165022568923 , 0.000181585976998 , -0.00155865400552 , -0.00236962674639 , 0.000682265478717 , 0.00501788270137 , 0.00218641059729 , 0.000221382812779 , -0.000471825324348 , 0.000115503947537 , 0.00357372150906 , -0.00507857160381 , -0.00266633352799 , 0.00435823901642 , 0.00227461177439 , -0.000350614594018 , -0.00394304647998 , 0.000995929040099 , 0.0006311621008 , -0.00361030376829 , 0.000750239060964 , 0.00297367474693 , 0.00148619510995 , -0.00187231867055 , -5.93784587544e-05 , 0.00102114130516 , -0.000385558455056 , -0.00772789807358 , 0.00161852509085 , 0.00361796735535 , 0.000392454885907 , 0.000123457634949 , -0.00114441159671 , -0.0033558124734 , -0.00304169533239 , -0.00250242577973 , 0.00147589888 , -0.00264635874972 , -0.00276343129794 , -0.00265734482394 , -0.000412638852949 , -0.00748263662047 , -0.00602735838369 , -0.000250748748409 , -0.000250218466605 , 0.00311250313545 , 0.00483743451907 , -0.000966433231434 , -0.00605028015036 , -0.000494535335536 , 0.00290286740916 , -0.00107383768106 , 5.20741857328e-05 , -0.00488745670397 , 0.000204798216308 , 4.61438148069e-05 , 0.00549425473042 , 0.00164040714292 , 0.00498510577425 , -0.00734261350125 , 0.00400365595477 , -0.0025507050008 , -0.00116237813529 , 0.0033073513314 , 0.00221640552582 , 0.00240141140718 , 0.000514775718576 , -0.000648773017433 , 0.00280727894565 , 0.000581899246379 , -1.86641764728e-06 , -0.00333373234472 , -0.000877580172041 , 0.000126818757337 , 0.00268568942573 , -0.00213953321625 , 0.000675687759101 , 0.000703504128472 , 0.00626386220089 , 0.000912662877318 , 0.000314375220928 , -0.00132847745798 , 0.00661097186946 , -0.00151385146962 , -0.00595273250961 , 0.000294236367515 , 0.00039163418625 , 0.000507203240994 , 0.000407415930303 , 0.00337471054721 , 0.000341812574096 , -0.00186777186875 , 0.00576077297758 , -0.00267579396876 , -0.000872916784016 , -0.000139558957989 , 0.00556051881061 , 0.000241221109874 , -0.00502748791657 , 0.00355949266659 , 0.00049515415485 , 0.00190767409148 , 0.00141317023052 , 0.00107582039983 , 0.00456032116259 , -0.000839978756198 , 0.000397366706221 , -0.00413884594674 , -0.000759950244117 , 0.000145371941024 , -0.000517942645761 , 0.00109381822246 , 0.000391187629411 , -0.00241889508154 , -0.00115912752095 , 0.000937612776994 , 0.0018361708645 , -2.97630350117e-05 , -0.000417953279393 , 0.000218880299301 , -0.000982047254581 , -0.00428296269294 , 0.000152802704203 , 0.00180861604616 , 0.000327727083958 , 0.000334397908217 , 0.000203203926534 , -0.00482492748692 , 0.00293625868036 , 0.00264546807155 , -0.00717825604329 , 0.00233005246727 , -0.00457684495456 , -4.96622903127e-05 , 0.00491976290098 , 0.00168538641732 , 0.00150944866819 , 0.0023839491636 , -0.00185706578192 , -0.00310833429429 , 0.00153358950248 , 0.0066827532071 , 0.00563634266606 , 6.74537091947e-05 , -6.59985353277e-05 , 0.00135816000551 , -0.00161888741454 , -0.00111137015806 , -0.00598067155936 , -0.000252067510047 , 0.00395250424417 , 0.00360883940141 , -0.00345841008233 , -0.000429408428209 , 0.00124621143218 , -0.000489540672949 , 0.00397460490441 , 0.00362623871785 , -8.6314455452e-05 , 0.0067781992037 , -3.53991499957e-05 , 0.0010335652072 , 0.00282164716342 , 0.00126995328085 , 0.00411913466272 , -0.00317394993571 , -0.00332351894495 , 0.0017165049399 , -0.00133982114529 , -0.00210929942222 , -0.00464015855953 , ])
Y_5_m3_imag = flex.double( [ 0.0 , 0.0 , -0.0024740162272 , 0.00528494244396 , 1.3536533955e-05 , -0.00321737931159 , 0.0003287966644 , -0.000570611572186 , 0.0071288396214 , -0.00403739574307 , 0.00169535382662 , -0.00125548696335 , 0.000434447417061 , 0.00286576826223 , 0.00238688173845 , -0.0013956586008 , -0.00228369057102 , -0.00337323206919 , -0.0021233820897 , 0.000443562109945 , 0.00136850589738 , 0.00320308379961 , 0.00120189431667 , -0.00124353565921 , 0.00448149411664 , 0.00618136141596 , 0.000805267723909 , 0.000990224926547 , -0.00625084647765 , -0.000350850489461 , 0.00028640937621 , 0.00241065008512 , -0.00575285606429 , 0.00300457763695 , -0.00154925706438 , -0.000445595780851 , 0.00109627166388 , -7.39410174319e-05 , 0.00804790365237 , -0.001262823082 , 0.00424802610044 , -0.000638494442254 , 0.00346359901977 , 0.00137390471406 , 0.000246317116186 , -0.00131143881419 , -0.000723731794508 , 0.000721972875737 , 0.00114429410562 , -0.00301708940579 , 0.00241631424553 , 0.000903234905759 , -0.000359002898743 , -0.00556343659821 , -0.000706149497094 , 0.00238962926315 , 0.00141797855216 , 0.00323568139512 , 0.00349027407798 , -0.000699230770135 , 0.00190274063566 , 0.00509275210013 , 0.00142584741592 , -6.25290203331e-05 , 0.00344441683048 , -0.00278966658726 , -1.74184507763e-05 , -0.00167298028904 , 0.00060490321275 , -0.000733819296831 , 0.00189932257583 , 0.00232733457235 , 0.00228871414914 , -0.00174941957848 , 0.000310551945507 , -0.00563638255222 , 0.000130053995961 , 0.000221969282324 , -1.93096003163e-06 , 0.00241326183783 , -0.0031861643644 , 0.00466250284118 , 0.0006930944971 , -0.000474104220942 , 0.00481869920543 , -0.00105342340998 , 0.000699450671141 , -0.000446718487149 , -0.000442336235058 , -0.00568861457 , -0.00528692602727 , 0.000341184591954 , -0.00446837533618 , 0.00416015138756 , -0.00113450527307 , 0.00151631835604 , 0.00098938799387 , -0.000148753029178 , 0.000575042177298 , 0.00537548404636 , 0.00133512505726 , -0.000358942189579 , -0.00258092554125 , 0.000771375665854 , -0.00435339640641 , -0.00334476016868 , 0.00112069096408 , -0.00353829397703 , 0.00156461073721 , -0.00017010891627 , -0.00180584239825 , 0.0026151231017 , 0.00151300594588 , -0.000934590842472 , -0.0011452549469 , -0.00144335768289 , -0.000653846117452 , 0.00219682005884 , 0.000936721774571 , -0.00387987362479 , -0.000502370589591 , -0.00339136743518 , 0.00455935250086 , 0.00147582551182 , 0.0048234336524 , -0.00331274818724 , -0.00315129049982 , 0.000409734300853 , -0.000763829854109 , -0.00083213858491 , -0.00574926924885 , 0.000514059799186 , 0.00339463151821 , 0.000598001429859 , -0.00168606703838 , -0.00196298446273 , 0.000744076729934 , -0.00296382825051 , 0.00141075989611 , 0.00243864899532 , -0.00248066166239 , 0.00322452948182 , 0.00353940486584 , -0.0038612519829 , 0.00397126470366 , -0.000461797113327 , 0.000168993810756 , 0.00210049086998 , -5.23503254015e-05 , 0.00137052373386 , 0.00331576487393 , 0.00168308916498 , 0.00651380836871 , 0.00221103594624 , 0.00257911867763 , -0.000109949673648 , -0.00102079178849 , -0.00246844868072 , 0.00153416220643 , -0.000160718681674 , 0.00276867955217 , 0.000187583159842 , 0.000248055735184 , -0.00189121212829 , -0.0023267547012 , -0.00164661219066 , 0.000135981024625 , -0.00221108530229 , 1.56603348077e-05 , -0.0019939263409 , -0.00303233160946 , 1.7452520342e-05 , -0.000213390253039 , 0.00109377297858 , 0.000820422394088 , 0.00134084762487 , 0.00014813904509 , 0.0036245207305 , 0.00114925087614 , 0.00192292022451 , 0.00268929512896 , 0.00155442038484 , -8.29425197539e-05 , -0.00155600692051 , -0.00115294538962 , 0.00151415675333 , 0.00305688062582 , -0.00179738362402 , -0.000957849222203 , 0.000310690831912 , -0.00186467680876 , -0.00104115102055 , 9.04485621061e-05 , -0.000155670606776 , -0.00554695845191 , -0.00133505410306 , 0.000308677262696 , -0.00108019997683 , 0.00356302463346 , 0.00138395304636 , 4.58530046716e-05 , -0.00385675338761 , 0.00476433809321 , -0.000316776842786 , -0.00177958022609 , -8.72138652627e-05 , -0.000979389485966 , 0.00245637223909 , 0.00174646892087 , 0.00308328701015 , 0.00568445748915 , -0.00285271665822 , -0.000545090933573 , 0.00140481188504 , -0.00278777743589 , 2.56435610766e-05 , 0.000599371417689 , 0.00440620589088 , 0.00239033371616 , 0.00108909770814 , 0.00258175673095 , -0.00528805546813 , 0.00752122561673 , -0.00395657136654 , -0.00043442002865 , -0.000545424442639 , 0.000250374455341 , -0.00473181597395 , 0.0057462287666 , 0.00122108114312 , -0.000725085376463 , 0.0054657641618 , -0.00377801028228 , -0.00236692313766 , -0.000324877719766 , -0.00433765713464 , 0.00326544911614 , -0.000640598317918 , -5.42991694239e-05 , -0.00200652442219 , 0.000217929766785 , -0.0029230567199 , 0.00311523432139 , 0.00323304848686 , 0.000863310368678 , 0.00390380103573 , -0.00191359407395 , 0.00486998312153 , -0.00299253496023 , 0.00168498965012 , 3.42947728814e-05 , -7.24495219409e-05 , -0.00275011908414 , 0.00149345962187 , -0.00230749912852 , -0.000322278210158 , 0.000508927171428 , 0.00311986822984 , -0.000395165237764 , -0.00303251366689 , -0.00155676056708 , -0.00280837761395 , -0.00173192456067 , -0.000403222095821 , -0.00192051298049 , -0.00311061350726 , -0.00665224522944 , 0.00140088597319 , 0.00124346947671 , 1.34579596449e-05 , -0.00272301509408 , -0.000114483174293 , -0.00384216524567 , -1.96278017044e-05 , 0.00222338262269 , -0.00172631817449 , -0.00263591665703 , -0.000811130948992 , -0.00541859973151 , -8.11015633379e-06 , 0.00175343942521 , -0.000949923619815 , -0.00107510938552 , -0.000555117705019 , -0.00322188891414 , -0.00138941010114 , -0.00793355465897 , -1.5707312085e-05 , 0.00537288775423 , -0.00108427085349 , -0.00164531797241 , 0.00267707355065 , 0.0045086075125 , -8.86098898441e-05 , 0.00124485952866 , -0.00240451568482 , 0.00190057107978 , 0.00103889890496 , 0.00344024843085 , 0.000243790189124 , 0.000773789524927 , -0.00253718526895 , -0.00347428754506 , 0.00186132389341 , -0.00358478048393 , 0.00668947488248 , 0.00317534519975 , -0.004616555461 , -0.00163572400721 , -0.00435038494325 , -0.00120454259731 , 0.000542985313744 , 0.000767643964848 , -0.00144581819854 , -0.00439896108252 , 0.00189359899882 , 0.00657634049417 , -0.000808037689894 , 0.00143687740175 , -0.0014354754636 , 0.00263394365046 , -0.000787628992041 , 0.000769698245027 , 0.00297090258362 , 0.00287322167907 , -0.0024869238789 , 0.00357742722848 , -0.00103354233784 , -0.00631552790183 , 0.00825767587522 , 1.2461226258e-05 , 0.000311354653287 , -0.00275840328501 , 0.00191916917945 , -0.000821134457366 , 0.00664023462899 , 0.000269527606915 , -0.0044387043657 , -0.00500461849105 , -0.00482919525835 , 0.00429958323102 , -1.23596221591e-05 , -0.00119380011208 , -0.00427079469451 , 0.00121076662854 , -3.08788326736e-05 , -0.00122087045123 , -0.00397051637275 , -0.00135029523715 , -0.0071003316885 , 0.000302573908568 , 0.0018284925737 , -0.000310341338197 , -0.00424474271099 , 0.000257152552574 , 0.00377332452914 , -0.000377083815294 , -0.000260287470822 , -0.00321689718771 , 0.00788462023652 , -0.000664729809127 , 0.000753244656581 , 2.70146342508e-05 , 0.00181029509553 , 0.00356216894476 , 0.00776728118024 , -0.000521615767284 , -3.97403697323e-05 , 0.00127941726551 , -0.00539633306638 , 0.00293780760712 , 0.00122276890845 , -3.50411118175e-05 , -0.000224391040824 , 0.000109342929344 , 0.000648249836165 , -0.000223057118651 , -0.00103151850884 , 0.00449626122785 , -0.00354459784136 , 0.00175698477697 , -0.00248881684414 , -0.000437233076053 , 0.00315091725535 , -0.00841542048625 , -8.83345085887e-05 , -0.00507290739102 , -0.00561638332308 , 0.00571600094389 , -0.00193776745772 , -0.000182156245997 , -0.00401621258241 , -0.00568038956119 , -0.0024349311202 , 0.00131323029554 , -0.0011260629647 , -0.00671044674351 , 0.000654560287692 , -0.000319088878149 , 0.00030739980254 , 0.000801717241968 , -0.00237003565366 , 1.24707378855e-05 , -0.00563936247313 , -0.00720169517872 , -0.00551476602931 , -0.000348671033536 , -0.00226321159812 , 0.00312762553565 , -0.000572402408751 , 0.00286019555079 , 0.000469348635518 , 0.00177366627404 , -0.00336951050391 , 0.00139351354337 , 8.43293160182e-05 , -0.00437449683249 , -0.00299429765955 , -0.00334479566428 , -0.00120106593871 , -0.00538825083396 , 0.00275159091679 , -0.000580737251561 , 0.000952276196188 , 0.00375007324161 , 0.000215668603402 , 0.00522284392722 , -0.0023316942101 , -0.0016858607652 , -0.00425090203676 , 0.000623338399376 , -0.00312946874003 , 0.00186983023509 , 0.00166296086223 , 0.0011402253991 , -0.003286233271 , -0.0021454287811 , 0.000170942924072 , -0.00472638909924 , 0.00118528149611 , 0.00454959570961 , 0.00263425041487 , 0.00265447740101 , 0.00206020268695 , 0.00461716494502 , 0.00117856418281 , 0.003635704716 , 7.52697212554e-05 , -0.00207043817701 , -0.000422649091619 , -0.00217699171279 , -0.000774348107206 , -0.00252903434834 , -0.000846180389477 , 0.00400201880458 , -0.00407870224394 , 0.00683251936095 , 0.00190186071855 , -0.001049962384 , -0.0061151657603 , 0.00303763354069 , -0.000932478890572 , 0.00637341595261 , -0.00517095576273 , 0.00277598919511 , -0.00297479704349 , 0.00020285913158 , 0.00277278615537 , -0.00240530849118 , -5.26393587358e-05 , 0.00245698115364 , 0.00590686569217 , 0.000849911113803 , 0.00107410664368 , -3.30253935381e-05 , -0.00524848724385 , -0.00108845561584 , 0.00572809103469 , -0.00382657362387 , 0.000501471073353 , -0.00356583328988 , -0.00154572817741 , -0.00311066626782 , 0.00401209934312 , -7.87974219862e-05 , 0.00241808107925 , 0.00599471791786 , -0.00116133322985 , 0.000705355927068 , -0.00432947946023 , 0.000778629311315 , 0.00386897167197 , 0.00451991595183 , 0.00399714238399 , -7.32255354161e-05 , 0.0068781660313 , -0.000733682453748 , 0.00242911488777 , -0.00123828226867 , 0.00197118040522 , 0.00412289165433 , 0.000427231650085 , -0.00327949631503 , 0.000671337929448 , -0.00123216875856 , 0.000102969598703 , -0.00402978155225 , 0.00122281373823 , -0.00438792679897 , -0.00536772094277 , -0.00237489070934 , 0.00585022293674 , -0.000737100662495 , -0.00171964371341 , -0.00419265700205 , 0.000733351839667 , 0.000395654677673 , -0.000343119865993 , 0.00549087565256 , 0.00114097435377 , 0.00329542784843 , 0.00475706589766 , -0.00140375247052 , 6.69397780127e-05 , 0.000740623393437 , -0.00165591843874 , 0.00636829080208 , -0.00304195509365 , -0.00554343520431 , -6.28620150216e-05 , 0.00162712511564 , -0.00210364667354 , 0.00157533755664 , -0.00150632672104 , 3.9535105553e-05 , 0.00396366743729 , -0.00107599444998 , -0.00140574164995 , 0.000181400043778 , -0.00243625954595 , 0.00141169973396 , 4.81080177155e-05 , -5.0237573196e-06 , 0.00156439905545 , -0.00332055160163 , -0.00439507346783 , 0.000595318422265 , -9.74031199177e-07 , 0.000268347998528 , -0.00350239767244 , -0.00376230609186 , -0.0054391176591 , -0.000855990758619 , -5.12663325899e-05 , -0.00234429235075 , -0.0070106348638 , 0.000842754538796 , -0.00346398862657 , -0.00303130244705 , -0.00511050473608 , 0.00100827563359 , -0.00123455097045 , -0.000790514035944 , -0.000536382694722 , -0.000489470901316 , 0.00389917576914 , 0.0023066917055 , 0.00132287462213 , -0.00344133650542 , -0.00369672902573 , -0.000711258305769 , -0.0037878183095 , 0.001524651376 , 0.00359391256755 , -0.00489510569671 , 0.00110555561402 , 0.00134335356562 , 9.07944704991e-06 , 0.000620342470349 , -0.00127754171281 , -0.00522763678664 , -0.00189221672026 , 0.00399870694193 , -0.000583619341717 , 0.00239412440363 , 0.000109919173791 , -0.00269663942215 , 0.00177646094935 , 0.00125218898532 , -0.00248037061845 , 0.00107631355039 , -0.00178151705468 , 3.56482166053e-06 , -0.00288937440402 , -0.00441174607666 , 0.000602496114369 , 0.00101286664924 , 0.00276086243376 , -0.000131438531571 , 0.000974454590623 , -0.00202042664218 , 0.00503353755375 , -0.000431699740536 , 0.00223831310097 , 0.000569867774349 , 0.00472044566763 , 0.00391337152372 , 0.00244625524687 , -0.00274972778838 , -0.000888457555086 , 0.000464466903145 , 0.000239404387961 , -0.000224602563232 , 0.00207538711337 , -0.00220094474283 , -0.000155780753476 , -0.000504116680071 , 0.000909926624308 , 0.00349090108132 , -0.00124340660205 , -0.00340573799383 , -0.00251516342202 , -0.0024760043849 , 0.00502724254252 , -0.000508760368936 , -0.000993522076437 , 0.00132198871483 , -0.00131713781884 , -0.00028176028354 , 9.22974542746e-05 , 6.21803551483e-05 , 0.00385119057276 , -0.000316276161034 , 0.000975695936519 , -0.00178126245537 , -0.00197846192596 , 0.00139580036315 , -0.00378116783558 , -0.00283289259583 , -0.000373776747913 , -0.00417439017626 , 0.00221311528762 , -0.00206625055454 , -0.000341962816786 , -0.00352277879307 , 0.00304330362332 , 0.00130190403423 , 0.00575697083414 , -7.55541905452e-07 , -0.00153339165409 , 0.0038128523041 , -0.00346128679508 , 0.00158183466044 , 0.00346716507879 , 0.00481885601525 , -0.00118571615476 , 0.00172932132343 , 0.00129197380235 , 0.00202203144058 , -0.00694124519721 , 7.85987694379e-05 , 0.00132051619751 , 0.0036237791201 , 0.00224699102153 , 0.000123561742087 , -0.00119250218656 , -0.00362110289932 , 0.000222996974493 , 0.00101499670569 , -0.00291979922366 , 0.00383528259294 , -0.000950128788949 , -0.00275930026422 , -0.00504495594799 , -0.00445334679019 , -0.00146398837083 , -0.00594982787427 , -0.00524717369679 , 0.00161260036575 , -0.000336061331241 , 0.0027480676264 , -0.00226667337649 , -0.00105723705966 , -0.00226303474698 , -0.000354712100823 , 0.00317522732722 , 0.00131542174551 , -0.00384950683129 , 0.00453835468401 , 0.000298266007638 , -0.00574940933498 , -0.00298694393581 , 0.000580063958562 , 0.00980264783556 , 0.00398750522167 , 0.00329968930447 , 0.00457137058828 , 0.0051574665201 , -0.00135549976674 , -0.00198494571295 , -0.00204945531231 , -0.000318866045687 , 0.00145309203045 , 0.0002280307201 , 0.0016042993435 , 0.00242446693924 , 0.00202689272448 , -0.000588749388441 , -0.00132692562649 , 0.00261360519954 , -0.000915670996598 , 0.000452678989707 , -0.00211797104639 , 0.000499385163246 , 0.00290057281218 , -0.0043246073049 , 0.0046379161138 , 0.000686964313575 , -0.00530143723285 , 0.00587969467679 , 0.00151719268195 , -0.0020207002433 , -0.00131152059838 , 0.00237962248961 , -0.00371146276472 , 0.005085192463 , 0.00278383976191 , 0.00097211341519 , 2.22149645827e-05 , 0.00512599024133 , 0.000945949199942 , -0.000719839476077 , 0.00321696726036 , 0.000287113428174 , -0.00234900585315 , 0.00331711774664 , 0.00410357189082 , -0.00242754397455 , -7.08236902406e-05 , 0.00767653002139 , -0.001104722823 , 0.0014616783979 , 0.00157126324143 , -0.00298476212475 , 0.00337738773574 , -0.000603716475214 , -0.000599617564657 , 0.00490092055038 , 0.000220451721234 , -0.0012184455414 , -0.00136449562471 , -0.00399631728374 , -0.00187689732837 , -0.000145033573166 , 0.00106254375876 , -0.00055515384562 , -0.000893693802251 , 8.86447762241e-06 , 0.00208216540633 , 0.0039270715357 , -8.023182778e-06 , -6.98822019656e-05 , -0.00544045604146 , 0.00320460077662 , -0.0015996678434 , -0.00667430125627 , 6.5871826985e-05 , 0.00702889357803 , 0.00285778781991 , 0.00047379912727 , 0.00324163685726 , 0.00141860868851 , 0.000758471239324 , 0.00196147196491 , -0.0017552070728 , -0.00225219593451 , -0.00560115449603 , 0.000843827998936 , 0.000295938615013 , 8.57470486605e-05 , -0.00130783238906 , 0.000261451653528 , 0.00179846117294 , 0.000131725282715 , 2.24256669925e-05 , -0.00563263878757 , 0.000894216812238 , 0.00442766560982 , -0.00135289661881 , 3.16002320822e-05 , 0.000286868075107 , 0.00318693328374 , -0.00353962894633 , 0.00244922092847 , -0.000206178682574 , 0.00304648550643 , -0.00489823594071 , 0.00331798544684 , 0.00282191749357 , -0.00168322423156 , -0.0027109697472 , -0.000663050686545 , 0.00306459826038 , -0.00220931240199 , 0.00408016852394 , -0.00115376385217 , -0.00158172039162 , 8.9791012471e-05 , 0.000260254076294 , 0.000665324536704 , -0.00238795066652 , 0.00290032093579 , -0.0072237765651 , 0.00177984123198 , -0.00116663031777 , 0.000243541993947 , -0.00250855701911 , 0.00410272107614 , 0.000742252206171 , 0.00457587782591 , -0.00307413698769 , -0.0055305649015 , 0.00207768380236 , 0.00253698425324 , -0.00184990353634 , -0.0019498119875 , -0.000491488791701 , 0.00141224278303 , 0.00237291226397 , -0.000143073418303 , -0.00607207959651 , -0.00274507886998 , 0.00122729936163 , -0.00685695806164 , -0.00336413112521 , 0.00226903642075 , 0.000537640540016 , 0.000144094062303 , -0.000896245978628 , -0.000493524725916 , 0.00189370726082 , 0.00396837306 , -0.00205100225218 , 0.00630803071739 , 0.00204672789856 , 7.09930935601e-05 , -0.000212637154794 , -0.00477964740677 , 0.00542999349415 , -0.00621310835582 , -0.00261692711859 , 0.000246398562727 , 0.00448816318945 , 0.000425326014944 , -0.000557925675286 , 0.000105259149905 , 0.000177267151264 , -0.00151957985047 , -0.00155268442238 , -0.00453371992948 , 0.0031936043005 , 0.000416116783529 , -1.61084667804e-05 , 0.00166352538335 , 0.00479958263008 , 0.00353895831688 , 0.00570544512616 , -0.00109440894945 , 0.00110863405039 , -0.00481234020794 , -0.00181194278642 , -0.000450603591644 , -4.08828290216e-05 , 0.000157297471169 , 0.00113260980878 , -0.00510061405967 , 0.000472230375646 , -3.96684717762e-05 , -0.000162500424961 , -0.0010232274983 , -0.00125197085915 , 0.000169234387493 , 0.000243498356016 , 0.00218115657768 , 0.00309598718586 , -0.0041920708404 , 0.00201386531115 , -0.00217881450816 , 0.00331548621972 , -5.53399748211e-05 , -0.00334139450045 , -0.0026267520799 , -0.00177820470628 , 0.00338132698237 , -0.000881528256846 , 0.00251233444074 , 0.00526146406916 , -0.00257052054591 , 0.00144389546206 , -0.00120064926126 , ])
Y_5_m2_real = flex.double( [ 0.0 , 0.00229594446483 , -0.00118624314004 , 3.77587408539e-06 , 0.00235939705398 , -0.00128842047382 , 3.72298166007e-05 , -0.00436573419529 , -0.00104192920135 , -0.00257118397718 , 0.00180150511811 , 0.00430130291976 , 0.00237884372602 , -0.00504364586509 , 0.00383289489549 , 0.000592278946276 , 0.00516597847748 , 0.00819144218868 , -0.00363297917782 , -0.00360766596801 , 0.00360638105575 , -0.000648267596749 , -0.000626004103967 , -0.00157884418299 , -0.00358933184321 , 0.00798949491754 , -0.00442210999009 , -0.00348819087004 , -0.00333419908447 , 0.000564128567748 , -0.00314367541205 , 0.0039855929192 , 1.36663172133e-05 , 0.00106828316789 , 0.00153656616137 , 0.0042450488302 , 0.00362229229501 , -0.000410755489103 , -0.00930880289288 , -0.00204296384635 , 9.11852839814e-05 , -0.00408911510946 , 9.88908522599e-05 , 0.000556959629961 , 0.00305108121991 , 0.00293023201599 , 0.00308382068865 , 0.00445882626599 , -0.00246687208034 , 0.000336728196787 , 0.0023205814786 , -0.000996271593933 , -0.00213494505081 , 2.55125597258e-05 , 0.00138263134434 , -0.0040288872702 , -0.00280582867305 , -0.000116136293322 , -0.00703287591836 , 0.000286660423944 , -0.00228608915802 , 0.000119531619603 , 0.00074578434661 , 0.000338242063128 , -0.00135160657078 , -4.93878620099e-05 , 0.00250748283384 , -0.00045423437212 , 0.000313815074057 , 0.00326068839501 , 0.00253086095255 , 0.000335870245602 , -0.00124738923961 , 0.00192533476654 , -0.00177218865316 , 0.000920444782119 , 0.000337590157289 , -0.00461136028662 , -5.57321482141e-05 , 0.00021136853731 , -0.000652926494267 , -0.00163892070622 , -0.000992301130887 , 0.00356181473576 , -0.000699116113327 , -0.00275427807795 , 0.00333609390025 , -0.000711717660959 , 0.00516053418388 , -0.000844495167918 , -0.000940502641397 , 0.00425916022504 , -0.00668534676707 , 0.0044190568666 , -0.000994253962437 , 0.00192012737107 , -0.004962998099 , -0.00092226711687 , -0.0018615630802 , -0.00327374842869 , -0.000257247827315 , -0.000256769599606 , -0.000362983923845 , 0.000541288886185 , 0.000344857435585 , 0.000396227168726 , -0.00321747926532 , -0.00218915007574 , 0.00108531717608 , 0.000354388320661 , -0.000877197520328 , 0.00308609526325 , -0.000439297660231 , -0.00467802814654 , 0.00230224305919 , -0.000123016514403 , -0.00404497453513 , 0.00195867023466 , 0.000395915889285 , -0.00444624670983 , 0.00126744631933 , -0.00197834126829 , -0.0093956227605 , -0.00296447489092 , -9.56861869543e-05 , -0.00171156716071 , 0.00360325161584 , 0.000771795497904 , 0.00144508541045 , 0.00152670514633 , -0.000470981135927 , -0.00525860599569 , -0.000984462440021 , 0.00335329834227 , 0.00468034504727 , -0.00336042564902 , -0.00128843146044 , 0.00125519219644 , -0.00349128733469 , -6.88904452755e-05 , -0.0064723104636 , 0.00229540614963 , 0.000603081297384 , -0.00213221775382 , -7.81507358869e-05 , 0.00166387583793 , 0.00269178275127 , 0.00219566080741 , 0.000752124264593 , -0.00196271867426 , -0.00793170298323 , 0.00142531856739 , 0.00755348852798 , 0.00275690454701 , -0.00135640546392 , -0.000859072016287 , -0.00309855653135 , 0.000490379040234 , 0.000797005402862 , -0.00329617355101 , -0.00156837333617 , 0.00166063697935 , -0.00409423923876 , 0.000132784730526 , 0.000145677233144 , 0.0017447466017 , 0.000508312530164 , -8.66350214646e-05 , -0.00258244607797 , -0.00570271577459 , 0.000241323681416 , -6.67998744142e-05 , -0.000792263632704 , 0.000152491134756 , -0.00336861119475 , 0.00584439383122 , 0.00621128196727 , -0.00288017305345 , -0.000721079588413 , -0.00483816938391 , -5.18960908584e-05 , -5.85526589002e-05 , 0.00398455494331 , -0.00639087982491 , -0.000146129545388 , -0.00391868475042 , 0.00599868247479 , -0.000204923980985 , 0.00393463768504 , -0.0025971049002 , -0.000604922831099 , 0.000350275594249 , -0.000898719225392 , 0.00482571780755 , -0.000170410614528 , 0.00240031884978 , 0.00036356256309 , -0.00159022694602 , 0.00346973386786 , -0.00483623526989 , 0.00521146380877 , -0.000275570910602 , 0.000474389056291 , -0.00447875943413 , -0.00648014967024 , -0.00162255959244 , 0.00282764123852 , -2.36965781311e-05 , 0.000185355571828 , 0.00409480278913 , -0.00243674614984 , -0.00563738366348 , 0.000401646410591 , -0.00320375655386 , -0.00144821606727 , -0.00248779822328 , 0.00349486301056 , -0.000986358772515 , -0.000938822304815 , 0.00682052413408 , 0.00342238850942 , -0.00127227847962 , 0.000853640086024 , 0.00121356806573 , -0.00264943017194 , 0.00342777385652 , 0.00360895744353 , 0.000200659373525 , -0.00238258814869 , 0.000271702714216 , -0.00443560436709 , 0.00258455631539 , -0.000130076533495 , -0.00138674969638 , 0.00265896887572 , 0.00272818259422 , -0.00411056892712 , -2.5523089881e-05 , -0.000256881653906 , -0.000644981614312 , -0.00242061776731 , -4.91800086948e-05 , -0.00173523501255 , 0.00251928218868 , 0.00214930001209 , 0.00613570805468 , 7.86235966135e-05 , 7.46047945001e-05 , -0.00505827789177 , 0.00113662829221 , 0.00442908255947 , 0.00230161113797 , 0.00215660542753 , 0.00304408041966 , 0.000675178065136 , -0.00503385654175 , -0.00231688099339 , -0.000585936411228 , -0.00310467120953 , 0.00151547565403 , 0.00352704264572 , -0.00354284687181 , 0.00242052042293 , 0.00303009999536 , -0.0020545599824 , -0.0011004062755 , 0.000391914663006 , -0.00246645453015 , 0.00258657217659 , -0.000614380208374 , 0.00155008588591 , -0.00112792485638 , 0.000288290850102 , 0.00463718664343 , -0.000723265982587 , -0.000596078116866 , 0.000254958086382 , -0.00292116518465 , -0.00052667598013 , -0.00171216962955 , -0.00196793355674 , 0.00286233416604 , 0.00547012686529 , 0.00149755934511 , 0.00237425989909 , 9.02081526141e-05 , 0.0037671373943 , 0.000322854007611 , 0.00149515614854 , -0.00182765323742 , 0.000933857880556 , -0.000398985551996 , 0.00025344421378 , 0.00490905598873 , -0.00610873043416 , 0.00306465709689 , -0.0023400574057 , 0.000916776536857 , -0.00151352780577 , -0.00273471642605 , -0.00261439474887 , 0.00147843904428 , 0.00113476491451 , -0.00510041349415 , -0.00044096186801 , 0.0029498256561 , -1.99995316008e-05 , 0.00458393590645 , 0.00341700054099 , -0.00256870198946 , -0.00585975301531 , -0.00213757526152 , 0.00435102857814 , -0.00285530002036 , 0.00324242557311 , -0.00308370956612 , 0.00395031069168 , 0.0023235270239 , -0.00275143633815 , 0.00107304686673 , -0.00451745534476 , 0.00343083467235 , -0.00113703661327 , 0.00150477454734 , -0.00583352379931 , -0.000243766743643 , 0.00191156512011 , 0.00203489866435 , 0.00909885475645 , 0.00259165543288 , 9.59775789294e-05 , -0.00089019878952 , -0.00287498354652 , -0.000941588243557 , 0.00319225110634 , 0.00219017213093 , -0.00252817935324 , 0.00622451369815 , 0.00052652561002 , -0.00483142149446 , 0.000887238107769 , 0.00260262607999 , 0.00423706511872 , 0.000161896261771 , 4.11204467255e-05 , -0.000259858354397 , 0.00286594072288 , -0.00927003642801 , -0.00336332999381 , 0.00275448592029 , 0.00492288229069 , 0.00332642681414 , 0.000956532977433 , 0.000168373210023 , 0.00160997875798 , 0.00178614397585 , 0.000766754560493 , -0.00490610942322 , -8.65830391346e-05 , -0.00698331955079 , 0.00238119339463 , 0.00508657245033 , -0.000363883607329 , 0.00279577172313 , -0.0015902521781 , -0.00187327191941 , 0.00130602536467 , -0.000247366539397 , 0.000882034651962 , -0.000372444270218 , -0.00258472855594 , 0.000476490384939 , -0.00320245196562 , 0.00261148669943 , -0.00324258029829 , 0.00347924123664 , -0.0028875844908 , 0.000938230152955 , -0.00337966366466 , 0.00150688997436 , -0.00164011605047 , -0.004079138001 , 0.000751085246697 , 0.00265920270941 , 0.00282693394071 , 0.00148570163948 , 0.00520640897127 , -0.00306824682808 , 0.0037792550846 , -0.00105387884411 , -0.00462418694098 , -0.00217119702817 , -0.000306353362147 , -0.0042228167332 , -0.00426529349862 , 0.00250194057493 , -0.00896605511969 , 0.00298974081561 , -0.000931344591238 , 0.00297823923044 , -0.00126292860354 , 0.00270663201285 , -0.00467856305484 , 0.000370368265594 , -0.00246476453189 , -0.00321484838442 , -0.00177978396563 , -0.00263877223591 , -4.36775737123e-05 , 0.00331588644008 , 8.44869943062e-05 , 0.00398681178379 , -0.00353079154035 , 0.00581426174027 , -0.00170900601907 , -0.00458874613066 , -7.81142156694e-06 , -0.00338878257624 , -6.83609881784e-06 , 0.00220131461683 , 0.000317138930423 , -0.000164530218053 , 6.42466570689e-05 , -0.0027193664858 , 0.00526503246317 , -0.00308079347679 , 8.9123466965e-05 , 0.000996272231405 , 0.00255002339158 , 0.00690982804305 , 0.000118178062162 , -0.000600339410044 , 0.00174361937924 , 0.00324258736714 , 0.00102036915807 , 0.00657123008545 , -0.00333758171914 , -0.00111433440778 , -0.00218906367464 , 0.00385034914577 , -0.000111949954156 , -0.00234211298008 , 0.00292203006859 , 0.000106607085544 , 0.00731917799653 , 0.00380523089234 , -0.00256338884994 , -0.00157134047063 , 0.00305185612162 , -0.00573992492231 , 0.000228507640561 , -0.00454711718092 , 0.00244532391607 , 0.00615774148779 , 0.00145377293807 , 0.00605939185774 , 0.000221680818154 , 0.00104713405021 , -0.00241245992705 , -0.00275292290094 , 2.96508843526e-05 , -0.000370382940482 , -0.00382937048856 , -0.00358245712036 , -0.00313367647419 , 0.00160970236361 , 0.00187161245557 , 0.00150403812819 , -0.00346388076817 , 0.00630899329239 , 0.00790232134619 , 0.000879311531497 , -0.000591708152444 , -0.00284912247778 , 0.00555273983658 , -0.000508111320812 , 0.00146023257923 , -0.000953317717787 , 0.000944284777025 , 0.000895188797697 , -9.19959650294e-05 , 0.000363550739485 , 0.00345613934523 , -0.000338112420763 , -0.000118090680132 , 0.000382960345449 , -0.00503243268309 , 0.00337390172176 , 0.00129044484399 , 0.000588797818152 , -0.00376326118062 , -0.00244309144039 , -0.00541306795166 , 0.000762033179266 , 0.00087271256453 , -0.00264708300591 , -0.000570180058821 , -0.000215442908023 , 0.00241454341195 , -0.00193629111625 , -0.000408525956788 , -0.00348297445942 , 0.000411397194028 , -0.00464874425993 , -0.003065470822 , -0.00349945905389 , 0.000588748337693 , 0.00244773383199 , 0.00215915240704 , 0.00517470034538 , 0.000464426274859 , 0.000285690526299 , 0.00085555370235 , 0.00247925654334 , -0.0048569969388 , -0.0019514804482 , 0.000484322170205 , -0.00133257677786 , 0.00457896254945 , 0.00237022871925 , -0.0013852346594 , -0.000360716475734 , -0.000525491631788 , 4.6771693222e-05 , -0.00157815923327 , -0.00129848895017 , 0.00137004789645 , -0.00113898986263 , 0.0013920228688 , 0.00160843071742 , 0.000478804947494 , 0.00210831525391 , 0.00383547036164 , 0.00121120516724 , -0.00262301480143 , 0.000165464536821 , -0.000645385668034 , -1.68899359453e-05 , 0.00150147046473 , -0.00182775976016 , 0.00327812998161 , 0.00138462537069 , 0.00257292482629 , -0.00396884065276 , -0.00274145906399 , -0.000104431841773 , -0.00320524642612 , 1.92682337719e-05 , -0.00474247325675 , -0.00244297425694 , 0.000808762535432 , 0.00402111248741 , -0.00253315901032 , -0.000360390683757 , -0.00248567972482 , 0.00361943913869 , 0.00159440452946 , 0.0022711041877 , -0.000468548348058 , -0.00330467321586 , -1.96196229618e-05 , 0.0044846555222 , -0.00231261253438 , 0.00252821090028 , -0.00273830884379 , -6.51633879179e-05 , -0.000364936014597 , -0.00104796382531 , 0.00213298418874 , -0.000470734353313 , 0.00153179037709 , -0.00044497010591 , 0.000181538774343 , 0.00139529698287 , -0.000849218352386 , 0.00388119632882 , 0.00101344325584 , 0.00117184351537 , 0.00150876803101 , -0.00168799068498 , 0.000179107374 , -0.00671149625757 , -7.52850598984e-05 , -0.00452082277309 , -0.00214398219033 , 0.00225922952613 , -0.00436869235574 , -0.00140878260715 , -0.000637619258195 , -0.00188902216077 , -0.00305112477095 , -0.00479308445869 , -0.00405487228254 , 0.000128490037612 , 0.00280140189411 , -0.00613843634579 , 0.00477221141019 , 0.000241213082245 , 0.00336956364237 , 0.00156994672085 , -0.000133048648689 , -0.00487774184428 , -0.00121064980642 , 0.000170779476514 , 0.00375752567835 , 0.00189500481845 , -8.41884098593e-05 , -0.000805721453649 , 0.000332888347465 , -0.000962547826876 , -0.00165618455906 , -0.000736192845946 , 0.0052664180652 , -0.000874240610988 , -0.000116720026425 , -0.00320604331811 , 0.00162851058267 , 0.0031544040462 , -0.00220720688956 , -0.00241670625311 , 0.00131346507486 , -0.00128305283715 , -0.00174301417542 , 0.00021510734695 , -0.000392595424437 , 0.000482359264464 , -0.000380938207905 , 0.000629124904094 , -0.00494425283591 , 0.000772889560044 , 0.00230592095573 , -0.000997677804875 , 0.000874029977894 , 0.00235994020256 , -0.00112696402798 , -0.00166593415371 , 0.0011399625233 , 0.00851781614421 , 0.00461974436257 , -3.95347386004e-05 , 0.000234315322854 , 8.19689235137e-05 , -0.00386666966323 , -0.00202768454652 , -0.000126814301226 , 0.00175652780998 , 0.00266751378887 , -0.00395395514146 , 0.00190635958945 , -0.00402322468805 , 0.00108152428172 , 0.00119627476709 , -0.000974166853628 , -0.00136142320775 , -0.000141418378607 , 0.00505951422604 , -0.000841558087906 , 0.00115157843876 , 0.00461845653797 , -0.00718812311465 , 0.000651359826268 , -0.000444925533731 , -0.00101996537103 , -0.000466216649086 , -0.00104215153283 , -0.00190623594785 , -0.00225139859867 , 0.00144732401247 , 0.00283930250789 , -0.00040018671966 , 0.000504868055656 , -0.000319333357867 , 9.55179784246e-05 , 0.00473039569578 , -0.000985426146584 , 0.00360129360229 , 0.00145644361216 , 0.0042251592546 , 0.00116927441569 , 0.00381261051554 , 0.00335810580484 , 0.000524351594006 , 6.39479176879e-05 , 0.00127621146086 , 0.00257516776627 , 0.00486890899462 , -0.00125473740551 , 0.00231540540077 , 0.00349853246722 , 0.00137144344917 , 0.0029000191472 , 6.8591741259e-05 , 0.000826787947277 , -0.00284363769431 , -0.00179766257824 , 0.00122995643176 , -0.00176449352317 , 0.0040819894908 , -0.00201101407084 , -0.00362353437343 , 0.00264042248832 , -0.00387579545285 , -0.00389270634959 , 0.00361853575134 , 0.00292373785032 , 0.00134287942733 , 0.00115707573639 , -0.00464121443935 , -0.00135471763477 , -0.00238242593589 , 0.000652088520564 , -0.00171069255033 , 0.00438331183973 , 0.00373759560171 , -0.00280251424139 , 0.000855082794933 , 0.00140413596444 , 0.00306614714595 , 0.000666886941035 , -0.000496778034335 , 3.38660471367e-05 , -0.0023669612631 , -0.00403626519273 , 0.00434156559527 , 0.000843622395582 , 0.00120669842665 , 0.00199423738753 , 0.0031717092646 , 2.49274409401e-06 , -0.000128247242202 , -0.00144114346891 , -0.00100247650314 , 0.00106829870263 , -0.000931256723236 , 0.00569582355402 , -0.00422428972254 , -0.00346178567769 , 0.00219980291955 , -0.000201368215261 , 0.00217779667458 , -0.00118189020176 , -0.00137828769472 , -0.00572232669274 , 1.5649629572e-05 , 0.00760959185072 , 0.00052334243494 , -0.000264879073848 , 0.00464943859988 , 0.00200248326217 , 0.00253509585478 , -0.00107926149061 , -0.00326703960079 , 2.76066657325e-06 , -0.000321994390296 , -0.00253768755689 , -0.00032465632009 , 0.0101120311061 , -0.00172194458294 , 0.00024990800403 , 0.000678401139652 , -0.000689079763717 , -0.00280473465369 , 0.00289674559811 , -0.00392151275674 , -0.0019714649724 , -0.000652305765671 , -0.00202870787676 , 0.00160571772622 , 0.00521207701618 , -9.34626330985e-05 , 0.00378206321206 , -0.000197495495027 , -0.00146148412107 , 0.00696791737216 , 0.00486199765787 , -0.000372277186391 , -0.00249707986459 , -0.00154505781949 , -0.000412515833212 , -0.00478296916009 , -0.0032880339615 , 0.0010467847081 , 0.00225143618755 , -0.00145844451152 , 0.0016294764169 , 0.00483030097391 , -0.000910138040759 , 0.00168038292038 , -0.00157518350886 , -0.0023731191512 , -0.00446603896092 , -0.000970412627853 , -0.00614453738673 , -0.000196089284257 , -0.00182790245641 , 0.000175215956337 , -0.000882427146845 , -0.000324867938026 , -0.00331741895109 , 0.00277357453888 , 0.0032082833798 , -0.00313979581412 , -0.00285003454637 , -6.81964409245e-05 , -0.00144289415919 , -0.00406940464628 , -0.00131317716666 , -0.00175969059984 , -0.00142569167276 , 0.000859242590911 , -0.00282805935972 , 0.00281003456556 , 0.000806959663517 , -0.00534198628646 , -0.0014981741747 , 0.000600938838376 , 0.00236097052547 , -0.000282683885858 , 0.00338419412267 , -0.00136712165415 , 0.00106882693575 , -5.35817917605e-05 , 4.602939018e-05 , -0.00204946839852 , 0.00115978621494 , -0.00346133084088 , 0.00596086391088 , 0.00538114393122 , -0.00735883242771 , 0.00181565217994 , -0.00114977182123 , 0.000755177256973 , 0.00436915104106 , -0.00107355537369 , -0.000229110396573 , -0.00303304675097 , -0.00117301980853 , -0.0049897102234 , -0.00358174474574 , 0.0024053542364 , -0.0037374661924 , 0.000794638472093 , -0.0039882609754 , 0.00326426813448 , -0.00292703857723 , 0.00333598306044 , 0.00141038935298 , -0.00285266235488 , -0.00156008930208 , -0.0023240836125 , -0.00681824107987 , 0.00023335916768 , -0.000777961661403 , 7.66042981592e-05 , -0.000885243432891 , -0.00477768310992 , -0.00117948574843 , 0.00117229860246 , 0.00365560521563 , 0.00418383326929 , -0.000237042736338 , 0.0106376023675 , -0.000295366820115 , 1.40600787711e-05 , -0.00181360998816 , 0.000808550661503 , 0.00460190738885 , 0.000321161677576 , 0.000597115850071 , -0.00254634679976 , 0.00105112946751 , 0.00174838176445 , 0.000765746869505 , 0.0014195048016 , -0.00411228939595 , -0.000782731078151 , -0.00109369441461 , -0.00706505536737 , -0.00385161784892 , 0.00247532209754 , -9.68606850266e-05 , 0.00207854701698 , 0.000470558127488 , -0.00302696836441 , 7.9256887494e-05 , -0.00192478029577 , 0.000513065603342 , -0.000360478713279 , -0.000518709212829 , -0.000666183641021 , 0.00134305532596 , -9.49128632084e-06 , -0.000217342648054 , -0.000138743964699 , -0.00300885943577 , 0.00252973691912 , 0.0012873904999 , 0.00541363847808 , 0.00464360292029 , -0.00356338434075 , ])
Y_5_m2_imag = flex.double( [ -0.0 , -0.0 , 0.000444981357554 , -1.62454085222e-05 , 0.00467839129276 , -0.00108810094174 , -7.15289891312e-05 , 0.00100286568966 , 0.00175196486901 , 0.00125961278308 , -0.000554736808363 , 0.00290294140241 , 0.0054189325156 , -0.00233530800583 , 0.00446787501669 , 0.00259357412419 , 0.00253156098538 , 0.00591878355218 , 0.00125466879277 , 0.00113116905664 , 0.000780708638999 , 0.000540176814533 , 0.000702476405194 , -0.000280498378783 , 0.00320297731221 , -0.00586546840761 , -0.000426592799203 , -0.000507561624404 , -0.000607655811392 , -0.00198579079855 , -0.00678303695354 , 0.00069782871851 , -1.02432163388e-06 , 0.00317937124373 , -0.00129820220996 , -0.00170374292721 , -0.000728677860391 , -0.000472858014322 , -0.001082115384 , -0.00210641409775 , 0.000176415716533 , -0.00202481845724 , 9.57899249667e-05 , 0.000120967245525 , -0.00030909023448 , -0.00338944418759 , 0.000570734061481 , 0.00135664352988 , 0.0038410195192 , 0.00111734028906 , -1.44342665333e-05 , 0.000117430890695 , 0.00547923547026 , 4.65479497545e-06 , 0.00468286918121 , 0.0001291957816 , 0.00290190235257 , -0.00381018058697 , 0.00327830768724 , 0.000412662534252 , 0.000591849286945 , 0.0001340393325 , 0.0047658011492 , -0.000567401108937 , -0.00794618422386 , -0.000362646463305 , -0.0030013596307 , -0.00694612109914 , -0.000324339511079 , 0.00193983646271 , 0.00105951718362 , 0.00249185580292 , -0.000410434073149 , 0.00669037148124 , 0.000572470239502 , -0.00168074249711 , 0.00254374841896 , 0.00416794034681 , 1.12929826585e-05 , 0.00458601318627 , 0.00719952057664 , 0.00111802218675 , 0.00488702601781 , 0.00141992774525 , -0.00227411350941 , -0.00381993217656 , -0.00117670618948 , 0.0030275469681 , -0.000617812426467 , -0.0018251051723 , -0.00101760567931 , -0.00633162360266 , -0.00454867586583 , -0.000699152757202 , 0.00264239586082 , 0.0014556744447 , 0.00399317164619 , 0.00169802414356 , -0.00179190122537 , -0.00379776587355 , -6.03362547521e-05 , 0.00325467271954 , 0.000244762589819 , 7.39396771577e-05 , -0.000839508270135 , 0.00416957050282 , -0.00134328826272 , -0.000702415501722 , 0.00127540776039 , -0.00189445789341 , 0.005586657681 , 0.00325225332009 , 0.00145957633815 , 0.00221885111691 , -0.00325075783737 , 0.000466388223852 , -0.000846519408764 , -0.00127436520168 , 0.000473542066559 , 0.00240282052849 , 0.000103879280168 , -0.000110296077744 , 0.00525596061768 , 0.000896664589367 , 0.00037530272192 , 0.00325043565648 , 0.00301249015465 , -0.00315851906775 , 0.00331422066594 , 0.000555230323233 , -0.00134046739974 , 0.00148135528597 , -7.09152204276e-05 , 0.00113430561814 , -0.000299502210011 , 0.001743977743 , -0.00336583445881 , -0.00280317496556 , -0.000998050426581 , -4.67397584471e-05 , -0.00552808240061 , -0.00130978848073 , -0.00110446086519 , -0.00700105679141 , 3.85684745644e-05 , -0.000116844145543 , 0.00294713882821 , 0.00348281244002 , 0.0012222005684 , 0.000657320243951 , -0.00255822721091 , 0.00107783293041 , 0.00177812282726 , 0.000699049190885 , -0.00301402113981 , 0.00159526881357 , -0.00115174888066 , -0.00215538666625 , -0.00393204998022 , -0.00113434785295 , 0.000874217239973 , 0.00160821901188 , -0.000605113169842 , -0.000145726526445 , 0.000122074857736 , -0.00173557295981 , -0.00085248509246 , 0.00389917101066 , -0.00442412198332 , 0.00296252851103 , 0.0001057710858 , -2.14762771647e-05 , -0.00125276836871 , 0.00247634714688 , -0.00370767800927 , -0.00148119568685 , -0.00325325092835 , 0.00115659066046 , 0.0022295911655 , 0.00133665147062 , -0.000674941924579 , -0.0035701829271 , 0.0048478116194 , 0.00118712130228 , -3.04080837217e-05 , -0.00290681087566 , 0.00268506411351 , 0.00061894295613 , -0.00445823821754 , -0.00257079099596 , -0.000527065180975 , -0.00238158329307 , -0.000201453422577 , -0.000825936841268 , 0.00104280779121 , 0.00290702475894 , -0.00097967183043 , -0.00421864413628 , -0.00195297310438 , 0.00152005320269 , -0.00117290860621 , -0.00413617537183 , -0.000481356735714 , 0.00230922084244 , -0.00260492669437 , 0.00246046226513 , 0.000492265187828 , -0.000972568365146 , 0.00653120371401 , -0.00113137127397 , 0.003752910248 , 0.00114126705658 , 0.00121579275311 , 0.00191868633134 , 0.00256310235327 , 0.00515018640218 , -0.00252537818183 , -0.000297935549756 , -0.00037361087046 , 0.000682623010034 , -0.00259563973394 , -0.00442811472769 , 0.00409302985697 , 0.00274571078598 , 0.00332405399744 , -0.000317250152431 , 0.0011723474973 , -0.00733970201665 , 0.000416667249659 , -0.00107060486608 , 0.000882435788401 , 0.000995025164655 , 0.00278369197485 , -0.00350383461605 , -0.00012769680726 , -0.000563938316287 , 0.00122734817219 , -5.3938285821e-05 , -0.000422057039382 , -0.00314650637896 , 0.00290543840495 , -0.000978588364291 , -0.00137547752157 , 0.00117457932429 , 0.00101301780824 , -0.000410384002136 , 0.0058475911273 , 0.00231103204223 , -0.000955877624584 , -0.00112835532082 , 3.30481977831e-05 , 8.98872238583e-05 , -0.00649774631702 , -0.00358500090077 , -0.00450983529711 , -0.000600184071581 , -0.000166828813674 , -0.000190880838873 , 0.00160672122561 , 0.00111438932639 , 0.00360584447423 , -0.00360255596748 , -0.000705060118927 , -0.00345893663842 , -0.000986241045732 , 0.00438655652489 , -0.00226691037957 , 0.00205262361459 , 0.00613331250928 , 0.0057293753126 , -0.00135923715191 , 0.00285823398794 , -6.17540027682e-05 , 0.000315371536818 , 0.00201384208336 , 0.00265053663078 , 0.00115527752135 , -0.00487823832415 , 0.000587833730548 , 0.00292019618835 , 0.00208338572024 , -0.00401817524073 , 0.00157309057356 , 0.00300274253894 , 0.00148997686191 , 0.000219678621615 , -0.00482132380603 , 0.000562955005118 , -0.000823522784165 , 0.00237726147092 , -0.00409950404071 , 0.00301425604276 , 0.00101779630251 , 0.00341466782323 , 0.00069562570554 , -0.00160041219821 , -0.00597809903148 , -0.00236256412831 , -0.000849298654901 , 0.000181090877541 , -0.000306116337714 , 7.06234021642e-05 , 0.000951976478397 , -0.00381435674205 , -0.00577479103744 , 0.00286915262836 , 0.000638583563375 , -0.00631881418436 , 0.00256290702689 , 0.000521990748294 , -0.00197988327037 , -0.00261759835664 , 0.00277006374162 , 0.00193016469069 , -0.00157806332674 , 0.000221610380532 , -0.000935283341285 , -0.0015347249667 , -0.0031996119074 , -0.0045388374006 , -0.000980095336632 , 0.00140812858465 , 0.00173189229707 , 0.000641714561072 , 0.00393324531442 , -0.00269354308352 , -0.00232412500234 , -0.000717963254708 , 0.00616161060036 , -0.00340723444078 , 0.000395948717649 , 0.00198268711739 , 0.00251606253759 , 0.00563195887466 , -0.00353268103561 , 0.000347456292728 , 0.00330677721869 , -0.000259900456131 , 0.00304043007433 , -0.00391359404297 , -7.99394530117e-05 , 0.00455903258917 , -0.00537405782823 , 0.000407218470887 , 0.00046616003456 , -0.000400851374746 , 0.00259722292445 , -0.00276147314668 , -0.00334582132043 , 0.01110805171 , -0.000862966086719 , -0.00246235619819 , -0.00243193552047 , 0.00061345785365 , -0.0053865051972 , 0.00139260368096 , -0.00151566214313 , -0.00332436617956 , -0.000978065778025 , 0.00376914935902 , -0.00570974373736 , -0.00231553637963 , -0.000284083152851 , 0.00145735978336 , -0.00152138915481 , -0.00306031783875 , -0.00182722880206 , -0.000135361519938 , 0.0024385200227 , -0.000165310421283 , 0.0030158837485 , 0.0011462075499 , 0.00128406758494 , 0.00409598622862 , -0.00277670028351 , 0.00399779131945 , -0.00190344133237 , 0.00132169977216 , 0.000468358157183 , -0.000628442537538 , 0.000863579819247 , 0.000291662222939 , 0.00373814356217 , -0.00298361188977 , 0.00450341513448 , -0.00297405938583 , 0.0030359177634 , 0.00132444816724 , 0.000376495335485 , 0.00395815428637 , -0.000289098933966 , 0.000815039098565 , -0.00276964812481 , 0.00187618482355 , -0.0104208412633 , -0.00509774794656 , 0.00127891519245 , 0.00652106972794 , 0.00139049027606 , -0.00384986920322 , 0.00144422529682 , 0.00522273478586 , -2.07188901119e-05 , 0.000553689835435 , 0.000297392086972 , -0.00594791969144 , 0.00116657409041 , 0.00393268047724 , -0.000163053720266 , -0.00150346308959 , -0.00154804981397 , -0.00302925164979 , -0.00188904119784 , -0.000500029144055 , 0.00702757375286 , 3.61345172817e-05 , -0.000156939810302 , -0.00226466855614 , 4.29593365356e-05 , 0.000513925514915 , -0.000648999743222 , 0.00501541044895 , 0.00579118636838 , 0.0020115144931 , -0.000491978459564 , 0.000163826341425 , -0.00518637728502 , 0.00253841518404 , -0.00707956732643 , -0.00358280976632 , -0.00334933368823 , -0.000454817500184 , -0.00339981792934 , -0.00281932030056 , -0.00465846406365 , 0.00138017381846 , 0.0026156971777 , 0.000789597554128 , -0.00232541414173 , -0.00241653104502 , -6.32314628007e-05 , -0.000783459432 , 0.00142615641953 , 0.0046876002297 , -0.00398371060854 , -0.00172505812522 , -0.000561060471267 , -0.00324137497629 , -0.00210913492184 , 0.000473835482441 , 0.00154649389386 , -0.00286332939645 , 0.00116652419369 , -0.00176697682451 , 0.00283087383365 , 0.00250072741511 , -0.00217067720013 , -0.00303751227199 , -0.00204068582431 , 0.00301432690494 , 0.000482905837555 , -0.000960670481417 , -0.00744232090124 , 0.00672518223297 , 7.70241845425e-05 , -0.00317688848745 , -5.132534817e-05 , 0.000629486997577 , -0.00476515285224 , -0.00245908967394 , 0.00317705888568 , 0.00154903913676 , 5.78112648966e-05 , 0.00334291993314 , 0.000572755870452 , 0.0042344528037 , 0.00161087827721 , -0.0015977910561 , 0.000443345336471 , 0.00192068327534 , 0.00132771170052 , 8.18909723664e-05 , 0.00436820824871 , 0.00157628417589 , 0.000709872540647 , -0.000145118952987 , 0.00382298558872 , 0.00374637458508 , 0.00390795491958 , -0.00314404204118 , -0.00376717476424 , 0.00108894527528 , -0.00277558411628 , -0.00316290728841 , 0.00160605571906 , 0.00786980922813 , -0.00173294362788 , 0.00542402481398 , 0.00114455901844 , 0.00147256084912 , -0.00631180432149 , 0.00512172934108 , -0.00443132406912 , 0.00187411113372 , 0.000616331942038 , -0.000237024060491 , -0.000150009470407 , -0.00117243025479 , 0.000686568514296 , -0.00115808359052 , -0.00263215957565 , -0.000355247166256 , -6.26125875737e-05 , -0.000883284357897 , 0.00244647728663 , 0.00448740711635 , -0.000754405363129 , -0.0028131493108 , -0.00312692121746 , 0.00297000400418 , 0.00108076203911 , -0.00022456978263 , 0.00272886424175 , -0.00390733812611 , -0.00240525637748 , -0.000711903403336 , -0.0040507842605 , -0.0016331291678 , -0.00195644999668 , -0.000200979257816 , 3.81007772356e-05 , -0.00181226358953 , -0.000704086404311 , -0.000372398159575 , -0.00290685395958 , 0.00466940491426 , -0.00206192006761 , -0.00490322502541 , -0.00300161338276 , -0.00078330222125 , -0.00371207817536 , 0.0022569984853 , -0.00411349339629 , 0.00263842764906 , 0.000335321019535 , 0.000102805383173 , -0.00326656530737 , 7.43740296752e-05 , -0.00108220221176 , -0.00156439982711 , -0.000525377818917 , 0.0033836515356 , 0.000754350641915 , -0.000445546647979 , -0.00067367846285 , -9.88733352375e-05 , -0.00120640265893 , -0.00183501372479 , 0.00445197296258 , -0.00222748151969 , -0.00106410357341 , -0.00107294601053 , 0.000402552584789 , 0.00201771575855 , -0.00386688694747 , 3.50202638638e-05 , 0.00250250644602 , -0.00122329969064 , 0.00062150300988 , 0.000753864161024 , 0.00511234214967 , -0.000256072893453 , 0.000186631854649 , 0.00186021511085 , -0.000718874438838 , -0.00169554445226 , 0.00384150500801 , -0.00246799086391 , 0.00272878096154 , -0.00678978491441 , 1.98617138654e-05 , 0.00614907409195 , 0.00199126285219 , 0.00350495254013 , -0.00109115152127 , 0.00509989226301 , -0.00491247034028 , 0.00147744225746 , -0.00525710070253 , -0.000441476911283 , -0.000812328863524 , 0.00567053113375 , 8.3538727955e-05 , -8.38333265523e-05 , 0.000887619983301 , 0.0010131480668 , -0.00183374332178 , -8.50833327017e-05 , 0.000125629466464 , -0.00563174064603 , -0.00393269543753 , -0.00112084815299 , -0.00472494842849 , -0.00099973156232 , 0.000483157145519 , 0.00279629259599 , -0.00318731512529 , -0.00498299391236 , -0.00163603730687 , 0.0052652935056 , -0.00541400613426 , -0.00140559883382 , 0.00011471186369 , -0.00430676167779 , -0.000812818036466 , -0.00370421331917 , 0.00425359531119 , 0.00099429052571 , -0.00215981223266 , 0.00583031099082 , 0.00638207989631 , 0.000879284275887 , 0.00986234041908 , 0.00163096342964 , -0.00301511276097 , -0.00477687926117 , 0.00260178546346 , 0.000407570648827 , 0.0010228694765 , -0.000101604204952 , 0.00161759249651 , 0.00277174142839 , -0.00473502353781 , -0.000690630167078 , 0.00136365253296 , 0.0014447134485 , -0.0046389368398 , -0.00418965247566 , 0.000798021194145 , -0.00559891531049 , -0.00228041879038 , -0.00421854426053 , -0.00127676738017 , -0.00123111613395 , 8.35958378784e-05 , 0.00598497796999 , 0.0028321284692 , -0.00244728158981 , -0.0037433378676 , 0.00345247962699 , 0.00068191561215 , 0.00106637600081 , -0.00335134548891 , 0.0019157603854 , 0.000166613255847 , -0.00455238304022 , 0.00360941171275 , -0.00370392124978 , -0.00235449060703 , -0.00161652826014 , 0.00171270613673 , 0.000157321860495 , -0.00295677563193 , -0.00254747377864 , 0.00191703250166 , -0.000503990762817 , -0.00378838933322 , 0.00349896292302 , 0.00293041206144 , 0.00450357963271 , 0.0045515196411 , 3.64685329824e-05 , 8.57841457261e-06 , 0.000764198621043 , 0.000661349482965 , -0.00242516866103 , 0.00554514262198 , -8.7434469097e-05 , 0.00379385171199 , -0.000500043174125 , 0.00312405268642 , 0.00231712729814 , 0.00247321531703 , 0.00169083276149 , 0.00507834046756 , 0.00350919424975 , -0.00207271503495 , -0.00126185137809 , -0.00590117052147 , -0.0020197805519 , -0.00619581634412 , -2.32180377161e-05 , -0.000313986678176 , 6.008112394e-05 , -0.00142905734927 , -0.000963963303486 , -0.000148802590444 , -0.00109364202192 , -0.00628947282123 , -0.00173409623297 , 0.00131384860935 , 0.00359981103337 , 0.00241458568387 , -0.00262540653089 , 0.000506473817174 , 0.0010894995082 , -0.00163328631142 , 0.00886973789803 , -0.00147533118952 , 0.0079177824628 , -0.00182859108393 , -0.00395167206308 , -0.00349870807505 , 0.00133615742729 , -0.00153637679727 , -0.000512727470359 , 0.0033247379258 , -0.00399187674898 , 0.00107032114557 , -0.00223489167267 , 0.000105012513188 , -0.00132213294826 , -0.000264104280246 , 0.00183009567294 , -0.00281696579612 , -0.000532619679382 , -0.00388765896995 , 0.00299409353775 , -0.000374388391192 , -0.000142950339295 , 0.00343577375189 , -0.00418399998176 , -0.000769056330314 , -0.00352840651802 , -0.00171139795896 , -0.00326961070609 , 0.00652679369704 , 0.00288423725311 , 0.00127286741266 , -0.00917162879204 , 0.00150291612052 , -0.00119162550248 , -0.00134395851302 , 7.25548919966e-06 , 0.000525600166455 , -0.000725544871319 , 0.00161761733916 , -0.00992200521433 , 0.00316400766932 , -0.00204692636356 , 0.000318304773432 , 0.00343075166718 , -0.00339084243764 , 0.00118867623702 , -0.0015102974962 , 0.0027173422961 , 0.000777684819498 , -0.00300780447468 , -0.000210090831637 , -4.51144484448e-05 , -0.00108252027496 , -0.0053489391041 , -0.00111843290427 , -0.00217409066685 , 0.00155553126816 , 0.000825582181597 , 0.00365245390701 , 0.000409539543712 , 0.00284317601793 , -0.00203371670658 , 0.00370166323384 , 0.000509951213713 , 0.00161202760093 , 0.000590809096255 , 0.00413597465233 , 0.000111290040599 , -0.00337136570018 , -0.00218271358228 , 0.00249127397659 , -9.41733781219e-05 , 0.0016221354652 , 0.00136372387897 , -0.0075852741008 , -0.000584299767383 , -0.00150470775334 , -0.00284242995515 , -0.00471023098571 , 0.000883737909805 , -0.00370368642165 , -1.24869621954e-05 , 0.00033407208076 , -0.00324670443023 , 0.00373524816731 , 0.00589716761423 , 0.0036298777919 , -0.000400937511709 , 0.00189495688077 , -0.000212404812877 , -0.00428178003756 , 0.00479578134612 , -0.00215762285912 , -0.00144514792172 , 0.00526658300193 , 0.00105296602516 , 0.00127892123496 , -0.00150019897811 , 0.00126876626784 , -1.68158646669e-05 , 0.00166275722969 , -0.00368100263798 , -0.00242460816175 , -0.0027334219352 , 0.00103693596138 , -0.00612414635689 , -0.00399363979654 , 0.00390462396893 , -0.00306353371853 , 0.000574002157423 , -0.00428980682303 , -0.00211746009436 , 0.000870020051627 , 0.00394245518257 , -0.000550330356676 , -0.00656317392399 , 0.00179439089788 , 0.000791621686747 , 0.00187119483607 , 0.00630938267968 , -0.00304202526433 , 0.00210758941336 , -0.00346188571505 , -0.000676164064 , 0.00278438486965 , -0.000442874590551 , 0.000607805821845 , -0.00408070306532 , -0.00167934577285 , 0.000626595411379 , 0.00490421958607 , -0.00144082622657 , 0.0013608693399 , -0.00161159520831 , 0.0026035595335 , 0.0076683406588 , 0.000861943259004 , 8.59637634848e-05 , -0.000131135484122 , 0.000166064790741 , 0.0028779821443 , 0.0052170192266 , -0.00261047939229 , -0.00150797617776 , 0.00283056977953 , -0.000889341256743 , -0.00536155088377 , -0.00157600138079 , 2.88822087615e-05 , -0.00563196063913 , 0.00303784399647 , 0.00164952515418 , 0.00228457925789 , -0.000643781560272 , 0.000328260801926 , 4.44701539943e-05 , 0.000415346874647 , -0.0031039825842 , 0.00458299081044 , 0.00188703755745 , -0.000138803358374 , 0.00284953740054 , 0.00124765855053 , -0.00343839707507 , -0.000291078949114 , 0.00536296777251 , -0.00205483799674 , 0.00237221737107 , 0.0041829989123 , -3.12403786569e-05 , 0.0030230461783 , -0.000422051486049 , 0.000312039480411 , -0.0038874895329 , -0.00259027992277 , -0.00255547380479 , 0.000177931839754 , 0.00115729714073 , 0.00273204860121 , -0.000587962056878 , -0.00231615218936 , 0.00458733466251 , -0.00152025770063 , 0.000398095474024 , -0.00196521867295 , 9.26894423736e-05 , 0.00354190365226 , -0.00116485385926 , -0.0002747150838 , -0.00179595948479 , 0.00350826827779 , -0.000607274446944 , ])
Y_5_m1_real = flex.double( [ -0.0 , 0.00522284897182 , -0.00434623889098 , 0.00424052223713 , -0.000641947370008 , 0.00171425722669 , -0.00241102460846 , -0.000681717296706 , 0.00465622831204 , -0.00103719728569 , 0.00441661485944 , -0.00208756321387 , -0.00359600940421 , 0.000657418337678 , 0.00647689863748 , 0.000762333625276 , 0.00106432737633 , -0.0119616088285 , -0.000264673139955 , -0.00806884222483 , -0.00359442510127 , 0.00320189582168 , 0.00149508234472 , 0.0051484525298 , 0.00381499146125 , -0.00300009891273 , -0.00165709557358 , -1.2442516473e-05 , 0.00033044916529 , 0.00540150615398 , -0.00801103226835 , -0.00032510940891 , -0.000200443639467 , -0.00342164094259 , -0.000931879649678 , -0.00208392442698 , 0.00297996422574 , -0.000320359359285 , 7.85921366157e-05 , 0.000642016372133 , -0.00336630281935 , 0.00225488468777 , -0.00318092754061 , -0.00429763260148 , 0.00257447855132 , -0.00244146639503 , 0.00365182215719 , -0.000595778919072 , 0.00216925237396 , 0.00178896895188 , 6.06823609214e-06 , 0.00418298876542 , 0.0018638562679 , 0.000481675766106 , -0.00209939827432 , -4.35660817415e-05 , -0.00526045073449 , -0.00259686891959 , -0.00279095774044 , 0.00239718492818 , 0.0045529856814 , -0.00451288910687 , 0.00575928944853 , -0.00152447199087 , -0.00100323685667 , 0.00232494066186 , 0.000928897446624 , 0.000377807685744 , 0.000692242979461 , 0.000101515165366 , -0.00417969013242 , -0.00172206905674 , -0.00450691808596 , 0.00182227469363 , -0.000925295782528 , -0.00345800592842 , 0.000621556425421 , 0.00180537838854 , 0.000300033965617 , -0.000824931348676 , 0.00414370616355 , 0.00616424235549 , -0.00186819010391 , 0.00195013442658 , -0.00367279296165 , 0.00215652982717 , -0.00154837897677 , 0.000200300134458 , 0.0051872460653 , 0.00341022283118 , 0.00398544367838 , -0.00414426647781 , -0.000297995187395 , -6.88449091883e-06 , 0.00130339018991 , -0.00110371251149 , -0.0040610979403 , 0.00173038961853 , -0.000823928613019 , -0.000891284188031 , -0.00376131021155 , 0.00102297449598 , -0.00103783367332 , -0.00351121204939 , -0.00339301133408 , 0.00408202203153 , -0.000108088380175 , 0.000537394525311 , -0.00259545576131 , -0.00405777632089 , 0.00611449040369 , 0.00250442384106 , -0.00241143168161 , 0.00290888856595 , 0.00691769914283 , 0.00193465332071 , 0.00339980539028 , 0.00347958765777 , -0.0012822512935 , -0.00107288064752 , 0.00301296319617 , 8.314124987e-05 , -0.00187393675061 , 0.000604008456309 , 0.003677582046 , -0.00220384090087 , 0.00251490289321 , 0.00370156680298 , -0.00209602198908 , 0.000121858702225 , 0.00508038747007 , 0.00283522720046 , -0.000112085887048 , 0.00525210522361 , 0.00022388810776 , -0.00406386061739 , 0.0013811394253 , -0.00199843009825 , -0.00459194077339 , -0.0010457108142 , -0.00196546403459 , 0.00101775455641 , 0.00332423701847 , -0.00446379255839 , 0.0056407490452 , -0.00484107540809 , 0.000796564600442 , -0.00104786565298 , 0.000829725844216 , 0.00354658697965 , 0.00144551145508 , -0.000829936833577 , 0.000101409478193 , -0.000221999566162 , -0.00161945281933 , 0.00156322314673 , 0.00127736734709 , 0.00239166197074 , -0.00156112310097 , -0.000120501437936 , 0.00109469123271 , 0.00256954466027 , 0.00861393855571 , -0.00222798956082 , 0.00146928548089 , -0.001913613509 , 0.00293379552526 , 0.00170531244678 , -0.00186299744004 , 0.00639952319604 , 0.00459062398047 , 5.39298595302e-05 , 0.00190343369458 , -0.00159619984635 , 0.00176910374598 , -0.00378029980696 , 0.000499595159394 , 0.00404274320349 , 0.00156018187909 , -0.000830664021599 , -0.00231619040416 , 0.0023630980933 , 0.000875935097702 , 0.000857288405686 , 0.00350447922788 , 0.00648628269941 , 0.00180872292654 , 0.00343131358163 , -0.00080322627624 , 0.00375496251316 , 0.00141141261396 , 0.000945348248746 , 0.00170525220405 , 0.000625024166446 , -0.00410572000593 , 0.000916268517464 , -0.00158124421989 , -6.84597963294e-05 , 0.000358201051231 , 0.00203114761179 , 0.000163590908655 , -0.00173376229262 , 0.00470011379032 , 0.000208766243614 , -0.00706482394813 , 0.00231779206176 , 0.000160752482864 , 0.00265934691606 , -0.000613391915924 , 0.00426066952471 , 0.00153094482194 , 0.000500730095748 , -0.00115547951673 , 0.00297741862877 , -0.00321928119711 , -0.000948399487288 , 0.00187007250074 , -0.000570271745207 , -0.000582819204774 , -0.000893134983519 , 0.00211195617454 , 0.00123422105611 , -0.00388043169865 , 0.00285221521332 , -0.00141031561756 , -7.02522864113e-05 , -0.00159846749614 , 0.000727782565872 , 0.000463286103616 , -0.00204631944106 , -0.00387655839652 , -0.00131534586445 , -0.00319079056728 , 0.00298073870676 , -0.00395731976105 , -0.000403849644332 , -0.000121661032241 , -0.00258036470191 , 0.000559377100001 , -0.00232631652772 , -2.79034854459e-05 , -0.00283831973065 , -0.00210697599888 , -0.000365930468258 , -0.000396848434818 , -0.000117309099057 , -0.0010236155073 , 0.00366828859728 , 0.000187461285875 , 0.00149927904097 , 0.00203221330181 , -1.04560850485e-05 , 0.00673589864578 , 0.000403862914913 , 0.00229075937292 , 0.000641246197212 , -0.00420927587789 , -0.000506052801652 , 0.000264214122423 , 0.00113532755164 , -0.000381274933887 , -0.00308564423002 , -0.000381088545035 , -0.00113372244439 , 0.00371375161078 , -0.00380896213954 , -0.00437464973233 , -0.000171532317162 , 0.000184812421151 , -0.00113196745999 , -0.00249544327241 , -0.000785547114481 , -0.000377059110275 , -0.00102925807679 , -0.00372869676989 , -0.00105594788673 , -0.00342309743073 , -0.000545106718036 , -0.00440042874949 , 8.54920471938e-06 , 0.00236983817033 , -0.00108090070023 , 0.00134899719887 , -0.00172618204954 , 0.00117258487668 , -0.00351713743186 , -0.00247123806876 , -0.00167057531003 , 0.00190859202551 , -0.000369342265877 , -0.00068495740941 , -0.00148471750595 , -0.00357406870337 , -0.000430601106074 , -1.43534722081e-05 , -0.00286108543743 , 0.0016136863426 , -0.00226718105525 , -0.00522403016456 , 0.00190540254121 , 0.000290017988432 , 5.32644059187e-05 , 0.00260455742517 , -0.00058606496577 , -0.00117910896348 , -0.00358367161382 , -0.00278687766563 , 0.00460308434421 , 0.00312209411605 , -0.000400405400569 , 0.000509868785536 , -0.000666642411089 , 0.000244350563769 , -0.000461131817771 , -0.00110278292809 , 0.000102872498312 , 0.000417165464935 , -0.00060657053546 , -0.000597268918251 , -0.00232825778802 , -0.000449246794221 , -0.00163245586906 , 0.00335414621454 , -0.000647476859995 , -0.00574692336984 , 0.00190695755743 , 0.00279103357357 , -0.000120399752899 , -0.00389385224697 , 0.00435179120044 , -0.0021020223129 , -0.0014911849386 , -0.000908117020987 , -0.00585956099157 , 0.001500372986 , -0.000488376353382 , 0.00116730473944 , 5.4040124588e-05 , 0.00392244167365 , -0.000503207671068 , 0.000179165183825 , 0.00454770145107 , 0.000711623706609 , 0.0033454049209 , 0.00139895484865 , -4.5773398524e-05 , 0.00141498133166 , -0.00152306639884 , 0.00190467447642 , -0.00435534883887 , -4.23755492493e-05 , 0.00140292610259 , 0.00124271392914 , 0.00362516367964 , 0.000404086353397 , -0.00378633770224 , 0.0026207513872 , -0.000330631526197 , -0.00363851621483 , 0.000924581380996 , 0.00117991872484 , -0.014232716726 , 0.000854290494347 , -0.00204136327766 , -0.00319598615566 , -0.00418905911721 , -0.00143360029622 , -0.000215779806846 , 0.00156955016638 , 0.00132287914829 , -0.00113487205672 , 0.00359206440403 , -0.000975273157789 , 0.00114714306958 , 0.000941011942062 , -0.00160789568856 , 0.00037511003063 , 0.00268787648255 , 0.00011111522027 , -0.00479687735457 , 0.00220126471581 , -5.80937331929e-05 , 0.00120803607083 , 0.00417408442709 , 0.00343663097719 , -0.00336578714805 , 0.000468372232084 , -0.000827467241624 , -0.000126257449124 , 0.00256812144365 , -3.2369131647e-05 , -0.00095811895051 , 0.00347255224225 , -0.00314258038233 , -0.00444899456406 , 0.000230994110251 , 0.000214206505046 , -0.00210257575853 , -0.00133586555641 , 0.000167495963255 , 0.00046809666222 , 0.000881148912106 , 0.00607444842255 , 0.00429677449183 , -0.000313243827372 , -0.00135766685654 , 0.00561720244025 , 0.00415582724626 , -0.00255664084135 , -8.10877486331e-05 , 0.00245271993648 , -0.000133469763182 , -0.000885300191354 , -9.17084148823e-05 , 0.00468355808853 , 0.0032438858423 , 0.00393180027572 , 0.00291986556642 , -0.00276065399241 , 0.00307422467246 , -0.00456417595424 , 0.00380684459719 , -0.000468228096232 , 0.000840353170048 , 0.000253947368768 , 0.00369010582111 , -0.00219638401579 , 0.00269334938465 , -0.000777482949204 , 0.000728132158444 , -8.95882088525e-05 , 0.00330202165397 , 0.00259796722648 , 0.000912349935108 , -0.00252570848306 , -0.000616292696602 , -0.00155467322003 , -0.00500503523928 , 0.00400966471181 , -0.00679819667757 , -0.00577745115001 , -0.00356519607067 , -0.00131650661729 , 0.00141419510229 , -0.00069549613319 , -0.00136649011606 , -0.000170145141415 , -0.000104287974317 , -0.00362424323651 , 0.00385279158987 , -0.00180290320744 , -0.000283219321431 , 0.00481124295045 , 0.0108470515899 , -0.00101463902317 , -0.000450330881927 , 0.00484659303655 , -0.0023498556466 , 0.000500608414452 , -0.00274045849832 , 0.0030092052837 , -0.00208914790145 , 0.00231726048404 , 0.00315932548909 , 2.63136280432e-05 , -0.00350749650532 , 0.00543312025375 , -0.00441402475123 , -0.00653803313277 , -0.000346964949543 , 0.0069942225291 , -0.00377911207751 , 0.00570309175503 , 0.00129489190397 , 0.00172588215551 , -0.00205190705082 , 0.00122330752855 , -0.00537453806801 , 0.00562500076049 , 0.00181679150465 , -0.00357213291709 , 0.00455102632262 , -0.00364882066643 , 0.00382128068846 , -0.00128598539163 , 0.00403559640134 , 0.00140066947136 , -3.90082326038e-06 , 0.000845059569364 , -0.0033059793299 , -0.00216683465831 , 0.000877158252754 , -0.0013275727628 , 0.00426453789533 , -0.00126412639725 , -0.00103120510764 , -0.00175526282741 , 0.00186010084107 , 0.000218839407871 , 0.000964473753039 , 0.000870925835572 , -0.00173312041096 , 0.000984330815872 , -8.74443999359e-05 , -0.000221047390875 , -0.002043922958 , -0.000536826089418 , 0.000215601093339 , 0.000463855896668 , -7.9245962394e-05 , 0.00357769867225 , 0.00501263298972 , -0.00575078942508 , -0.00427208580314 , -6.62254285636e-05 , -0.00183075341612 , 0.00223957416558 , -0.00117278547145 , 0.00200729087191 , -0.00188652610087 , 0.00146939155182 , -0.00180292864963 , 0.00242948158609 , -0.000670110351326 , 0.00566264133034 , 0.000250009870027 , 0.0024606004763 , 0.00327041558584 , -0.00447259754382 , 0.00457556739766 , -6.92995542461e-05 , 0.000406095996218 , 6.79340831462e-05 , -0.00311940650148 , 0.000368217245275 , 0.00124254850492 , 0.00053480665488 , -0.00447684921006 , -0.000686561778908 , 0.00373869116353 , -1.29561919567e-05 , -0.000297027384304 , 0.000577891965659 , 0.000406723783226 , -5.50237494916e-05 , -0.00409524433321 , 0.00273551755942 , 0.000901469889783 , 0.000403070004416 , 0.00132336504266 , -0.00484772129599 , 0.00144355379872 , 0.000578210806869 , -0.00344255327164 , 0.00389256512693 , -5.47635041748e-05 , -0.00170408812613 , -0.00139751526449 , 0.000666470386269 , 0.00308269079613 , 0.000380245920686 , -0.00260879234025 , -0.00261030297901 , -0.00927627203387 , 0.00117298577454 , 0.00515491024569 , -0.00331296590548 , -0.00145018940905 , 0.000630311647251 , -0.00296877102439 , -0.000510953228465 , 0.00452479525595 , -0.00151013347763 , -0.00283836356604 , 0.00541056608675 , 0.000936248380849 , 0.00288452830711 , -0.000434543982304 , -0.00130226245227 , 0.00477668266064 , 0.000265436391523 , 0.00339696290781 , -0.00378722585042 , -0.00217084634436 , -0.000621038626114 , 0.0012258900184 , 0.0013360163516 , 0.00234142368442 , -0.00433370469433 , 0.000372121001824 , -0.00217022062197 , 0.000278057068261 , 0.00121066881476 , -0.00117826004901 , 0.000658548512243 , -0.00812290887788 , 0.00340970568395 , 0.000493296168091 , 0.00164564689033 , 0.00386489457039 , -0.00296010319882 , -0.000488474571606 , -0.0015259994275 , -0.00261316252769 , -0.00418093034543 , -0.00513608878745 , -0.00452116792248 , 0.00285029320651 , -0.00279650246063 , -0.00558314267025 , -0.00165103552583 , 0.0018114688452 , 0.00224335533139 , -0.00107179645321 , -0.00215220054208 , -0.00029052735884 , 0.00264389705403 , 0.000921076984123 , -0.00443300861479 , 0.000242652028035 , -0.000876948227902 , -0.00273167567642 , -0.00609484066265 , -0.00480143751671 , 0.00376968260525 , 0.00208192392367 , -0.00126140983745 , 0.000629777763022 , 0.000104295705053 , -0.00025674305454 , 0.000192790817189 , 0.0027805274828 , -0.000368336055455 , -4.14834625698e-05 , -0.00238192452996 , -0.00127842350213 , 0.000318972718859 , 0.00546671319318 , 0.000164775185981 , 0.000640047385634 , 0.00430929480802 , 0.00154400606415 , 0.000714893186317 , -0.00687795235202 , -0.00148350517116 , 0.00433489102467 , -0.00233547933076 , -0.00127760902054 , -0.00095792055174 , 0.00830097465024 , -0.00126423360007 , 0.00405889657381 , 0.00335366901348 , 0.00268546802775 , 0.00430528007351 , 0.00336823588154 , 0.000859703576914 , -0.000153660323317 , -0.0010787508128 , 3.00539621649e-05 , -0.00345255887586 , 0.000187515459796 , -0.000789401794186 , 0.00257508839673 , -0.000685229758357 , -0.000136778720547 , 0.00236356035608 , -0.00394520758033 , 0.00810631105977 , 0.000389349658319 , -0.000276700417371 , -0.00517116349195 , 0.000117670502773 , 5.90995572716e-05 , -0.00564772775928 , -0.000401040800865 , 0.000949367342712 , -6.82189179813e-05 , -0.000651631779572 , -0.00289106616804 , -0.00193451445125 , -0.0036702393691 , -0.0016255786202 , 0.00168104810448 , 0.00162973737862 , 0.000207458176449 , -0.00179803525179 , -0.00149047034552 , -0.0031029400897 , 0.00105077267361 , 0.00105844358226 , -0.000509060188412 , 0.000172877566762 , 7.75261057918e-05 , -0.00265642422114 , 0.00335083382821 , -0.000213775503136 , 0.000617576620167 , 0.00212127293003 , 0.000370934272243 , 0.0025498649391 , 0.000220636884209 , 0.000891047357652 , -0.000841265071074 , -0.0038334284629 , -0.00318183798406 , 0.000129074454178 , -0.000184670095672 , 0.00147306452214 , 0.000287207842544 , 0.00172993058438 , 0.000539196155477 , -0.0011679342701 , 7.33226575384e-05 , -0.0034892053785 , -0.00530187730432 , -0.00332826056168 , 0.00225085864186 , 0.0048323733628 , -0.00360708667443 , 0.00261394598908 , 0.000923357782131 , 8.21308744454e-05 , 0.000590028655651 , -0.00110754097672 , 0.00103640412668 , 0.00158989901702 , -0.000497205775571 , 0.00190832436213 , -0.00445753670078 , -0.00693609958808 , -0.000453261347401 , 0.00273888192575 , 0.00108899507912 , 0.000324853914203 , 0.00181925115448 , -0.00486885125618 , 0.0032373250212 , -0.00486283227317 , -0.000773995808968 , -0.00249015410601 , -0.000928147416099 , 0.00164246818737 , 0.000748228756634 , 0.000294181254201 , -0.00144083446861 , -0.000450779265586 , -0.010145220095 , 1.03704651681e-05 , 0.00350708130982 , -0.00351896155811 , 0.00044432277264 , -0.00138097705988 , 0.00467143586144 , -0.0022936376286 , 0.0048183492288 , -0.00322288154954 , 0.00134168389735 , 0.00126160770143 , 0.000108248281783 , -0.00391817382028 , 0.000182363413866 , -0.000699746255227 , -2.418986041e-05 , -0.00123611166329 , -0.00617052936959 , 0.00123153473342 , -0.000748833046326 , -0.000653954102181 , -0.000888037905104 , -0.00138054725935 , -0.00339918280274 , 0.000269581319002 , -1.2879587812e-05 , -0.00167383394409 , -0.00467595587963 , 0.00180968014588 , -0.00251934755847 , 0.00419875358116 , -0.00187903322578 , -0.000637983285474 , 0.00599818982615 , 0.00249787129211 , 0.00600457286262 , 0.000236441280862 , -0.00291418599012 , 0.000487720748111 , -0.00486808548337 , -0.00227070809672 , -0.0047346270341 , -0.0032448692355 , -0.00358844917882 , 0.00343099042221 , -0.00322135961388 , 0.000805723227694 , 0.00218504253353 , -0.00270420705741 , -0.00385124792652 , 0.00406557768127 , -0.0088884636832 , -0.000213713039888 , -0.00591366179979 , 0.00150165680971 , 0.0021688159314 , 0.00281129755615 , -0.00138684810084 , -0.00214513914172 , -0.00472789881092 , -0.00106540643806 , 0.00142174666391 , 0.00366524958785 , 0.00148805985417 , 0.00610660372158 , 0.00108469708681 , -0.007089556185 , -0.00035695431706 , -0.00156320010916 , 0.00322798691805 , -0.00139177640056 , -0.00355572609181 , 0.00306369451741 , 0.00331346584019 , -0.00190820923765 , 0.0074720961599 , -0.000282560390716 , -0.00288681135828 , -0.000161683937031 , 0.00204918344239 , 0.00641214521038 , -7.34445172799e-05 , 0.00453574653943 , -0.00207957907988 , -0.0030343273073 , 0.00135344185808 , -0.00290459808292 , -0.00103776806473 , -0.0022086468226 , -0.000491697446856 , -0.00233368415878 , 0.00169618043101 , 0.000593374466963 , 0.00303391077281 , 0.000694993413284 , 0.00218022092924 , 0.000230773477775 , -0.00111092310214 , 0.000261482288678 , -0.000165078503487 , 0.00553806676488 , -0.000846290913333 , -0.00335634102552 , -0.00363510751082 , 0.00188250971228 , -0.000430820403934 , 0.00165120406963 , -0.00157572842017 , 0.00442585766147 , -0.00261704813607 , 0.000699637462757 , 0.00466760720395 , 0.00257668866223 , -0.012488821658 , 0.00092564477391 , 0.0028415344756 , 0.000626067842684 , 0.00253617937619 , 0.000153374281897 , -0.00114345876136 , 0.00301810967364 , -0.00390831927236 , 0.0030378978089 , 0.00122658160636 , 0.00512003703574 , -0.00132343139616 , -0.000691568473788 , -0.00387628841792 , -0.000105054354223 , -0.00130600962634 , -0.000534970522854 , -0.00195761358681 , 0.00209494532049 , -0.00249776355728 , 0.00536874059407 , -0.00156774106008 , -0.00251895367584 , -0.00376217919173 , 0.00228595535691 , 0.00173281412315 , 0.00344790557988 , 0.000882225355044 , -0.00375575058792 , 0.00263586760997 , 0.00209812795656 , 0.00143181091091 , -0.000975140151618 , 0.0035136626471 , 0.000604712739267 , 0.000823897222458 , 0.0021115725459 , 0.00405090189298 , ])
Y_5_m1_imag = flex.double( [ 0.0 , -0.0 , 0.000788355948109 , -0.0033679447481 , 0.00104270853414 , -0.00468672591677 , -0.00397295891778 , 7.72931025821e-05 , -0.00264828790659 , -0.00447476679746 , -0.000664605455952 , 0.00682484362195 , 0.00550585059545 , -0.00298451236418 , 0.002977288276 , 0.000607869352831 , -0.00459056167432 , -0.00386928836646 , -0.00157717436535 , 0.00123532648705 , -0.000384605804175 , -0.00115917004034 , 0.00333491551868 , 0.000453785616975 , -0.00145468517798 , 0.000983022943601 , -7.97433822348e-05 , 0.000171921599621 , -0.00365620616413 , -0.00408076249655 , 0.012542387555 , 0.00374191928014 , -0.00535606816962 , -0.00245994005795 , -0.00254692561295 , 0.000402582705299 , -0.000296759527789 , 0.000702634945973 , -0.001356716655 , 0.000271700720514 , -0.0020494241859 , 0.000527702719555 , -0.00128800294254 , -0.000461328177068 , -0.000130071095931 , 0.00111665757682 , 0.000335082914216 , -8.86300946357e-05 , -0.00118491693925 , 0.00132930787069 , 0.00195118642919 , -0.000245674821765 , 0.00272658384935 , -0.00532363427607 , 0.00280884703194 , -0.00271785876583 , 0.00223099622958 , -0.00251892104562 , 0.000618539300646 , -0.00458404600747 , -0.000579807064439 , -0.00202223633296 , 0.00492812789074 , -0.00268356868052 , 0.00118829198117 , 0.00202977442487 , -0.000434366117449 , 0.00035390830564 , 0.00163300751404 , 2.7913429163e-05 , -0.000839588755366 , -0.00150552871416 , -0.000722415265349 , -0.00242063901481 , -0.00587459370081 , 0.00204885071264 , -0.000709495270372 , -0.000694983541644 , -3.00921016794e-05 , 0.000863828013135 , -0.00378491784458 , -0.00190229551671 , -0.00228564485831 , 0.000374386819264 , -0.00271332863604 , 0.00110372639134 , -0.0090447249377 , 0.000252846978939 , -0.000309400487444 , 0.00217965097389 , 0.00174347310591 , -0.00778242398079 , 0.000967711765941 , -8.75693103597e-05 , 0.00188302982001 , 0.00328281281348 , -0.0115257689506 , 0.00290899799418 , 0.00204403588796 , -0.00040841950957 , -0.000435193675873 , 0.001106858196 , -0.00339544217125 , -0.00023870615541 , 0.00227433469653 , 0.00371250411947 , 0.000539449681926 , -0.00343379365159 , 0.00561661167656 , -0.00488723523766 , -0.00522932939017 , 0.00107602809168 , -0.00324406940044 , 0.0129205791139 , -0.00357761989067 , 0.00251111252694 , 0.000351938084096 , -0.00103232425394 , 0.00274342459985 , 0.000271355754765 , 0.00012326383918 , -0.00298486551926 , -0.00718827034048 , -8.93483460778e-05 , -0.00285760113069 , 0.00133023564892 , 0.000912796411191 , 0.00471496371731 , 0.00320052327916 , 2.14708096544e-05 , 0.00359982943811 , -0.000391720411243 , 0.00311603921338 , 0.000864250144323 , 0.00700459096597 , 0.000991721836568 , -0.0020075691848 , 0.0012947814943 , -0.000643458609476 , 0.00340383673435 , 0.00532747166066 , 0.00383717695113 , -0.001972360925 , -0.00330674414489 , -0.00131611950166 , 0.000169770981315 , 0.000351267420312 , -0.000578113413122 , -0.00148484872009 , -0.000578101914691 , -0.00919087109844 , 0.00247347745703 , -0.000873352699162 , 0.00177874722088 , -0.00104708449093 , 0.00261729218825 , 0.000229723620708 , 0.00299691479187 , -0.00190930102699 , 0.000720457769807 , 0.00421230871664 , -0.00634687663911 , 0.000633115148268 , -0.0050443147883 , -0.00404095460024 , -0.00463714799073 , 0.00516508758003 , 0.00174362338008 , 0.00324462936515 , -0.00156309008527 , 0.000961858936771 , 8.45613112721e-06 , -0.00345587820433 , -0.00150093087297 , -0.00399755024257 , 0.000471582439591 , 0.00203062359859 , -0.000781397052837 , -0.00113516392072 , -0.00612600988728 , -0.00214493579034 , -0.00240217178612 , -0.00185379870961 , -7.8946475468e-05 , 0.000360759418466 , 0.00214308403925 , 0.000386332348802 , 0.00475055547281 , -0.00178019788591 , -0.00913096284837 , -0.00376843485218 , 0.00109455700542 , 0.000188779081456 , -5.31013569567e-05 , 0.00348924251994 , -0.00194480588217 , 0.00109980771483 , 9.89681937409e-05 , 0.00136667343279 , -0.000311683618419 , 0.00147191496264 , 0.00185311714237 , -0.00196695309086 , 0.000860460098788 , -0.00136682820437 , 0.00430487523322 , -0.00186065852843 , -0.0027249310112 , -0.000596230823088 , -0.000577775785604 , -0.000831313661061 , 0.00499697251861 , -0.000835177946332 , -0.000823384247536 , 0.00187865232722 , -0.00151137643499 , -0.000604950087518 , 0.00386018164801 , 0.00304076463335 , -4.45827432221e-05 , -0.000710295202915 , 0.000929540239652 , -0.00315462634334 , 0.0018577472122 , -0.00292757634404 , -0.00152134549413 , -0.000253116145732 , -0.000708157718821 , 0.00533853316958 , -0.00263051310045 , 0.000381866766532 , 0.0070776164041 , 0.00304517277017 , 0.00202598563504 , 9.49702838335e-05 , -0.00394873589168 , -0.000832696530197 , 0.00407567305319 , -0.000995300879047 , 0.00285154375678 , -5.95659523471e-05 , 0.00298454460874 , 0.00604990347682 , 0.00165083652263 , 0.00177280685898 , -0.00351172787971 , 0.00103747101709 , -0.00378861929953 , -0.00200155859546 , 0.00363835943191 , 7.58171149963e-06 , 0.000535671560285 , -0.00486156620859 , -0.000186888470602 , -0.00197333442696 , 3.80928226569e-05 , -0.000151350160207 , 0.0031871553691 , -6.43164968555e-05 , -0.00346039186022 , 0.000906287448116 , -0.00129324585169 , -0.00267097969516 , -0.00250038090377 , 0.000845181686519 , 0.00297147130423 , 0.00368323472236 , -0.000474269425263 , -0.000278514925903 , 0.00101707241874 , 0.000939139544545 , 0.000534505572689 , -0.00356043822001 , -3.4959152373e-05 , -0.00530103309129 , 0.000844849303817 , 0.00426090880984 , -0.000308947875167 , 0.00196568419001 , 1.49229064335e-05 , 0.00549843064659 , -0.00209708183289 , 0.000190118565385 , 0.0027898508637 , -0.00407445664591 , 0.00524639238674 , 0.00120524298167 , 0.00288387806757 , 0.00742118647866 , 0.000181925910464 , 0.000546472724752 , -0.00169419413232 , -0.00279322293476 , 0.00137312960527 , -0.000252908494202 , 0.000702068913795 , -0.0023645685802 , -0.0033116548921 , -0.00136555211615 , -6.30181580765e-05 , -0.00497073386464 , -0.00223135880161 , 0.000947825520057 , 0.00176223491593 , -0.00109250503182 , -0.00145538633913 , -0.00287552514639 , -0.00234747748938 , 0.00104074891918 , -0.00398103974661 , -0.00310187138537 , 0.00140507392821 , 7.11816599934e-05 , -0.00150554748244 , -0.0047858558511 , 0.00286663436769 , 0.00357263403448 , -0.00201890044764 , 0.00130134162238 , 0.00184200460634 , 0.00418950991294 , 0.00827676864865 , 0.00621451175873 , 0.00316886870102 , 0.00175644946718 , 0.00174217049822 , -0.00131821643685 , -0.000703106996654 , -0.0011943830117 , -0.00215751163593 , 0.00267242358668 , -0.00230411322459 , -0.002416580796 , 0.0049612477125 , 0.00337798523764 , 0.00619540648434 , 0.00236183741417 , 0.00258960717029 , 0.00330155547867 , -0.000178237159998 , 0.00398511946429 , -0.00783272330201 , 0.00146726716253 , 0.00227007570252 , -0.00152779028091 , 8.42234224048e-05 , -0.00366853011915 , 0.010447649081 , -0.00461531514887 , -0.00340725217628 , 3.68604866726e-06 , 0.00425321584743 , 0.00182417017422 , 0.00276424565502 , 0.000542527841909 , -0.00130161543171 , 0.00426282734881 , 0.001077361492 , 0.00397484402886 , 0.00365963890079 , 0.00177048861329 , 0.00308713410386 , -0.00248251177545 , -0.000500118987507 , -0.00128258240956 , -0.00234735463156 , -0.00278682619398 , 0.000843831986781 , -0.00223679029354 , -0.00624128419281 , 0.000522008642147 , -0.00538334172273 , 0.000188240565528 , -0.00209185085739 , 0.000347850489745 , 0.00353087916612 , -0.00125061933641 , -0.00520428386617 , 0.00161127331517 , 0.000960181760844 , -0.000544114009899 , -0.00162705227759 , 0.000989455210034 , -0.00187110922246 , 0.00190034101885 , -0.00544378311471 , -0.00173304059632 , -0.00400482810901 , 0.00254101458884 , 0.00334136775042 , 0.00103651045818 , -0.00527860789661 , 0.0031096283725 , 0.000666698790387 , 0.0066282327099 , -0.00014394484851 , 0.00301866340394 , 0.00327699921851 , -0.0025025902573 , 0.000341338813666 , 0.00103116345701 , 0.000535799448528 , 1.34501994348e-05 , 0.00229527924119 , -0.00521111457559 , -0.000809473110397 , -0.00167686517699 , -0.00221616083238 , -0.00196192524479 , 1.75244704206e-05 , -0.00232250939898 , -0.000396274457421 , 0.00353135678751 , -0.00213667881599 , 0.00595903488342 , -1.27719456061e-05 , 0.00374096865125 , 0.000885847459339 , 0.00235608684473 , 0.000354097848326 , 0.00284964285958 , -0.00368400914778 , -0.000463062447988 , 0.00254917515473 , 0.00544720352274 , -9.80445091613e-05 , -0.00223445126699 , 0.0018362826085 , -0.00110642605584 , 0.00298610761594 , -9.28049935365e-05 , 0.00110957208948 , -0.00158732112906 , 0.00243981051057 , -0.00313880602683 , 0.005932560187 , 0.000536624861576 , 0.00159349536784 , 0.0017322285385 , 0.0019566044614 , -0.00151884349421 , -0.000580488093743 , -0.000304128697028 , -0.00144672290857 , -0.00273265051716 , -0.00632384119011 , 0.0015731302068 , 0.000166452460075 , 0.00113050259633 , -0.000158755537451 , 0.00208887225539 , -8.17435993364e-05 , 0.00108881172841 , -0.00152551002219 , -0.000619552130009 , 0.00227162443146 , -0.00437684215401 , -0.00329564243369 , -0.00136695330227 , 0.00120854877511 , -0.0031996405252 , 0.0030445054204 , 0.00141369519765 , -0.00189666684416 , 0.00214142739975 , 0.0021548339867 , -7.448240173e-05 , -0.000886449829359 , -0.00333027954471 , -0.00184556249691 , 0.00135334276152 , -0.0022003172066 , -0.000277940961984 , 0.00280500451893 , 8.87754271016e-05 , 0.0018204089536 , -0.00276001380428 , -0.00305177922691 , 0.00125477205356 , -0.00285119866033 , 0.00333318760243 , 0.000506224766141 , -0.0017658282215 , -0.00308853748054 , -0.00151758787713 , -0.000738985069261 , -0.00047168801763 , -1.73653419663e-06 , -0.00116898671997 , 0.0027443282716 , -0.000898192032999 , 0.00412251322177 , -0.000320520872643 , -0.00335911558318 , 0.00212561410964 , 0.000741121024943 , 0.00242535507412 , 0.00193545101771 , -0.000972562015976 , 0.00286148026137 , 0.000816378270124 , -0.00327448468621 , 0.00107994740913 , -0.000450775779902 , -0.00222086295701 , -6.913990984e-05 , -0.00428112152304 , 0.000949210669361 , -0.00298948399413 , -0.00071695349445 , 0.00426422265708 , -0.00240131167877 , 0.000210151022232 , 0.000738280191608 , -0.000278692096033 , -0.00279253438968 , 0.00409916575956 , 0.00185325462803 , -0.00061999238257 , 0.00391919554094 , 0.00427209657772 , 0.00630729258521 , 0.00294195719549 , 0.000662136990686 , 0.00305730633278 , -0.000976058082196 , -0.00176530720793 , 0.00170635396906 , 0.00230689725473 , -0.000284759667101 , 0.00174450053665 , -0.000150548559826 , 0.000746317800086 , 0.000468720484664 , -0.000828228949814 , -0.00128735921275 , 0.000392996555087 , -0.00446145455355 , -0.00111110002957 , 0.000767374094664 , -2.87266403492e-05 , 0.000530688145169 , 0.00104308831001 , 0.00134648087205 , -0.000903059750786 , 0.00167750901182 , -0.00651663527893 , -0.00116477686667 , 4.54054140917e-05 , -0.00452055357532 , 0.00143633026621 , 0.000526547277377 , 0.00396760413525 , -0.00164317682066 , 0.000518142660356 , -0.00401018417003 , 0.000572047266388 , -0.00395329886888 , -0.000600008567763 , 0.000941930194806 , -0.000387321407658 , 0.000307732156198 , 0.000225490200853 , -0.00324783942272 , -0.00226795203321 , -0.00129743444778 , -0.00383113099194 , 0.00315189918271 , -0.00441638919569 , 0.00164623190333 , 0.000686490791554 , 0.00120901793101 , 0.00357563518839 , -0.00141909899576 , 0.00198257507473 , -0.000195581005275 , -0.00374419786148 , -0.000687369360546 , -0.000768031257021 , -0.00610960124808 , -0.00480193462277 , 0.00873619643235 , -0.00393311793788 , 0.00074295252581 , 0.00258947788235 , -0.00188385635202 , -0.00297602869089 , -0.00100263435445 , 0.00489108711069 , -0.00322742001908 , -0.000283953106114 , 0.000599112571526 , -1.24698136144e-05 , -0.0039621881323 , -0.00425870215105 , 0.000665838358356 , -0.000632551533593 , 0.00288146113554 , 3.06671673895e-05 , 0.00508966559965 , 0.00306194120674 , 0.00430691861473 , 0.00196629425402 , -0.00309741044931 , -0.000267698094464 , -0.00272373054575 , -0.00440332456537 , 0.00242643727869 , 0.00228479346507 , -0.00669632259814 , -0.00122149557735 , -0.0029936625618 , 2.44292184621e-05 , -0.000876089041804 , 0.00248333158274 , 0.00063568914613 , -0.00384327164189 , -0.00598599360035 , -0.00180809364788 , -0.000162090915453 , 0.00107580802179 , 0.000846198060133 , -0.00726646262505 , -0.00420975738982 , -0.00429235207331 , 0.00230273952938 , -0.00145954687994 , -0.002130416538 , 0.00101894540779 , -0.00392282342103 , -0.000610535071952 , -0.00195432709671 , -0.000442549151435 , 5.94533338053