// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
// ------------------------------------------------------------------------------
// Changes to this file must follow the http://aka.ms/api-review process.
// ------------------------------------------------------------------------------
[assembly: System.Runtime.CompilerServices.CompilationRelaxations(8)]
[assembly: System.Runtime.CompilerServices.RuntimeCompatibility(WrapNonExceptionThrows = true)]
[assembly: System.Diagnostics.Debuggable(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly: System.Runtime.Versioning.TargetFramework(".NETCoreApp,Version=v8.0", FrameworkDisplayName = ".NET 8.0")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.ExpressionEvaluator.ExpressionCompiler, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.ExpressionEvaluator.ExpressionCompiler, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.ExpressionEvaluator.ExpressionCompiler, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("csc, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("csi, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("BuildValidator, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Rebuild, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Scripting, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Scripting, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Scripting, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("vbc, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("vbi, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.Build.Tasks.CodeAnalysis, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("VBCSCompiler, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.CommandLine.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Emit.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Emit2.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Emit3.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.EndToEnd.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.WinRT.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.IOperation.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Semantic.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Symbol.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Syntax.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Test.Utilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.CommandLine.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Emit.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Roslyn.Compilers.VisualBasic.IOperation.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Semantic.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Symbol.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Syntax.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Test.Utilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.ExpressionEvaluator.ExpressionCompiler.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.ExpressionEvaluator.ExpressionCompiler.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.ExpressionEvaluator.ExpressionCompiler.Utilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.ExternalAccess.RazorCompiler, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("InteractiveHost.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Scripting.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Scripting.Desktop.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Scripting.TestUtilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Scripting.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.CSharp.Scripting.Desktop.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Scripting.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.VisualBasic.Scripting.Desktop.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Test.Utilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Microsoft.CodeAnalysis.Rebuild.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Roslyn.Test.PdbUtilities, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("VBCSCompiler.UnitTests, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("DynamicProxyGenAssembly2, PublicKey=0024000004800000940000000602000000240000525341310004000001000100c547cac37abd99c8db225ef2f6c8a3602f3b3606cc9891605d02baa56104f4cfc0734aa39b93bf7852f7d9266654753cc297e7d2edfe0bac1cdcf9f717241550e0a7b191195b7667bb4f64bcb8e2121380fd1d9d46ad2d92d2d15605093924cceaf74c4861eff62abf69b9291ed0a340e113be11e6a7d3113e92484cf7045cc7")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("CompilerBenchmarks, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Reflection.AssemblyCompany("Microsoft Corporation")]
[assembly: System.Reflection.AssemblyConfiguration("Release")]
[assembly: System.Reflection.AssemblyCopyright("© Microsoft Corporation. All rights reserved.")]
[assembly: System.Reflection.AssemblyFileVersion("4.1200.24.57207")]
[assembly: System.Reflection.AssemblyInformationalVersion("4.12.0-3.24572.7+dfa7fc6bdea31a858a402168384192b633c811fa")]
[assembly: System.Reflection.AssemblyProduct("Microsoft.CodeAnalysis")]
[assembly: System.Reflection.AssemblyTitle("Microsoft.CodeAnalysis")]
[assembly: System.Reflection.AssemblyMetadata("RepositoryUrl", "https://github.com/dotnet/roslyn")]
[assembly: System.Resources.NeutralResourcesLanguage("en-US")]
[assembly: System.Reflection.AssemblyVersionAttribute("4.12.0.0")]
[assembly: System.Runtime.CompilerServices.ReferenceAssembly]
[assembly: System.Reflection.AssemblyFlagsAttribute((System.Reflection.AssemblyNameFlags)0x70)]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Collections.Generic.IReadOnlySet<>))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Diagnostics.CodeAnalysis.ExperimentalAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Diagnostics.CodeAnalysis.SetsRequiredMembersAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.CollectionBuilderAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.CompilerFeatureRequiredAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.InterpolatedStringHandlerArgumentAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.InterpolatedStringHandlerAttribute))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.IsExternalInit))]
[assembly: System.Runtime.CompilerServices.TypeForwardedTo(typeof(System.Runtime.CompilerServices.RequiredMemberAttribute))]
namespace Microsoft.CodeAnalysis
{
    public enum Accessibility
    {
        NotApplicable = 0,
        Private = 1,
        ProtectedAndFriend = 2,
        ProtectedAndInternal = 2,
        Protected = 3,
        Friend = 4,
        Internal = 4,
        ProtectedOrFriend = 5,
        ProtectedOrInternal = 5,
        Public = 6
    }

    public abstract partial class AdditionalText
    {
        public abstract string Path { get; }

        public abstract Text.SourceText? GetText(System.Threading.CancellationToken cancellationToken = default);
    }
    public sealed partial class AnalyzerConfig
    {
        internal AnalyzerConfig() { }
        public static AnalyzerConfig Parse(Text.SourceText text, string? pathToFile) { throw null; }
        public static AnalyzerConfig Parse(string text, string? pathToFile) { throw null; }
    }
    public readonly partial struct AnalyzerConfigOptionsResult
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Collections.Immutable.ImmutableDictionary<string, string> AnalyzerOptions { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Diagnostics { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> TreeOptions { get { throw null; } }
    }

    public sealed partial class AnalyzerConfigSet
    {
        internal AnalyzerConfigSet() { }
        public AnalyzerConfigOptionsResult GlobalConfigOptions { get { throw null; } }

        public static AnalyzerConfigSet Create<TList>(TList analyzerConfigs, out System.Collections.Immutable.ImmutableArray<Diagnostic> diagnostics) where TList : System.Collections.Generic.IReadOnlyCollection<AnalyzerConfig> { throw null; }
        public static AnalyzerConfigSet Create<TList>(TList analyzerConfigs) where TList : System.Collections.Generic.IReadOnlyCollection<AnalyzerConfig> { throw null; }
        public AnalyzerConfigOptionsResult GetOptionsForSourcePath(string sourcePath) { throw null; }
    }
    public static partial class AnnotationExtensions
    {
        public static TNode WithAdditionalAnnotations<TNode>(this TNode node, params SyntaxAnnotation[] annotations) where TNode : SyntaxNode { throw null; }
        public static TNode WithAdditionalAnnotations<TNode>(this TNode node, System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) where TNode : SyntaxNode { throw null; }
        public static TNode WithoutAnnotations<TNode>(this TNode node, params SyntaxAnnotation[] annotations) where TNode : SyntaxNode { throw null; }
        public static TNode WithoutAnnotations<TNode>(this TNode node, System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) where TNode : SyntaxNode { throw null; }
        public static TNode WithoutAnnotations<TNode>(this TNode node, string annotationKind) where TNode : SyntaxNode { throw null; }
    }
    public sealed partial class AssemblyIdentity : System.IEquatable<AssemblyIdentity>
    {
        public AssemblyIdentity(string? name, System.Version? version = null, string? cultureName = null, System.Collections.Immutable.ImmutableArray<byte> publicKeyOrToken = default, bool hasPublicKey = false, bool isRetargetable = false, System.Reflection.AssemblyContentType contentType = System.Reflection.AssemblyContentType.Default) { }
        public System.Reflection.AssemblyContentType ContentType { get { throw null; } }
        public string CultureName { get { throw null; } }
        public System.Reflection.AssemblyNameFlags Flags { get { throw null; } }
        public bool HasPublicKey { get { throw null; } }
        public bool IsRetargetable { get { throw null; } }
        public bool IsStrongName { get { throw null; } }
        public string Name { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<byte> PublicKey { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<byte> PublicKeyToken { get { throw null; } }
        public System.Version Version { get { throw null; } }

        public bool Equals(AssemblyIdentity? obj) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public static AssemblyIdentity FromAssemblyDefinition(System.Reflection.Assembly assembly) { throw null; }
        public string GetDisplayName(bool fullKey = false) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(AssemblyIdentity? left, AssemblyIdentity? right) { throw null; }
        public static bool operator !=(AssemblyIdentity? left, AssemblyIdentity? right) { throw null; }
        public override string ToString() { throw null; }
        public static bool TryParseDisplayName(string displayName, out AssemblyIdentity? identity, out AssemblyIdentityParts parts) { throw null; }
        public static bool TryParseDisplayName(string displayName, out AssemblyIdentity? identity) { throw null; }
    }

    public partial class AssemblyIdentityComparer
    {
        internal AssemblyIdentityComparer() { }
        public static System.StringComparer CultureComparer { get { throw null; } }
        public static AssemblyIdentityComparer Default { get { throw null; } }
        public static System.StringComparer SimpleNameComparer { get { throw null; } }

        public ComparisonResult Compare(AssemblyIdentity reference, AssemblyIdentity definition) { throw null; }
        public bool ReferenceMatchesDefinition(AssemblyIdentity reference, AssemblyIdentity definition) { throw null; }
        public bool ReferenceMatchesDefinition(string referenceDisplayName, AssemblyIdentity definition) { throw null; }
        public enum ComparisonResult
        {
            NotEquivalent = 0,
            Equivalent = 1,
            EquivalentIgnoringVersion = 2
        }
    }
    [System.Flags]
    public enum AssemblyIdentityParts
    {
        Name = 1,
        VersionMajor = 2,
        VersionMinor = 4,
        VersionBuild = 8,
        VersionRevision = 16,
        Version = 30,
        Culture = 32,
        PublicKey = 64,
        PublicKeyToken = 128,
        PublicKeyOrToken = 192,
        Retargetability = 256,
        ContentType = 512,
        Unknown = 1024
    }

    public sealed partial class AssemblyMetadata : Metadata
    {
        internal AssemblyMetadata() { }
        public override MetadataImageKind Kind { get { throw null; } }

        protected override Metadata CommonCopy() { throw null; }
        public static AssemblyMetadata Create(ModuleMetadata module) { throw null; }
        public static AssemblyMetadata Create(params ModuleMetadata[] modules) { throw null; }
        public static AssemblyMetadata Create(System.Collections.Generic.IEnumerable<ModuleMetadata> modules) { throw null; }
        public static AssemblyMetadata Create(System.Collections.Immutable.ImmutableArray<ModuleMetadata> modules) { throw null; }
        public static AssemblyMetadata CreateFromFile(string path) { throw null; }
        public static AssemblyMetadata CreateFromImage(System.Collections.Generic.IEnumerable<byte> peImage) { throw null; }
        public static AssemblyMetadata CreateFromImage(System.Collections.Immutable.ImmutableArray<byte> peImage) { throw null; }
        public static AssemblyMetadata CreateFromStream(System.IO.Stream peStream, bool leaveOpen = false) { throw null; }
        public static AssemblyMetadata CreateFromStream(System.IO.Stream peStream, System.Reflection.PortableExecutable.PEStreamOptions options) { throw null; }
        public override void Dispose() { }
        public System.Collections.Immutable.ImmutableArray<ModuleMetadata> GetModules() { throw null; }
        public PortableExecutableReference GetReference(DocumentationProvider? documentation = null, System.Collections.Immutable.ImmutableArray<string> aliases = default, bool embedInteropTypes = false, string? filePath = null, string? display = null) { throw null; }
    }

    public abstract partial class AttributeData
    {
        public SyntaxReference? ApplicationSyntaxReference { get { throw null; } }
        public INamedTypeSymbol? AttributeClass { get { throw null; } }
        public IMethodSymbol? AttributeConstructor { get { throw null; } }
        protected abstract SyntaxReference? CommonApplicationSyntaxReference { get; }
        protected abstract INamedTypeSymbol? CommonAttributeClass { get; }
        protected abstract IMethodSymbol? CommonAttributeConstructor { get; }
        protected internal abstract System.Collections.Immutable.ImmutableArray<TypedConstant> CommonConstructorArguments { get; }
        protected internal abstract System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, TypedConstant>> CommonNamedArguments { get; }
        public System.Collections.Immutable.ImmutableArray<TypedConstant> ConstructorArguments { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, TypedConstant>> NamedArguments { get { throw null; } }
    }
    public enum CandidateReason
    {
        None = 0,
        NotATypeOrNamespace = 1,
        NotAnEvent = 2,
        NotAWithEventsMember = 3,
        NotAnAttributeType = 4,
        WrongArity = 5,
        NotCreatable = 6,
        NotReferencable = 7,
        Inaccessible = 8,
        NotAValue = 9,
        NotAVariable = 10,
        NotInvocable = 11,
        StaticInstanceMismatch = 12,
        OverloadResolutionFailure = 13,
        LateBound = 14,
        Ambiguous = 15,
        MemberGroup = 16
    }

    public static partial class CaseInsensitiveComparison
    {
        public static System.StringComparer Comparer { get { throw null; } }

        public static int Compare(System.ReadOnlySpan<char> left, System.ReadOnlySpan<char> right) { throw null; }
        public static int Compare(string left, string right) { throw null; }
        public static bool EndsWith(string value, string possibleEnd) { throw null; }
        public static bool Equals(System.ReadOnlySpan<char> left, System.ReadOnlySpan<char> right) { throw null; }
        public static bool Equals(string left, string right) { throw null; }
        public static int GetHashCode(string value) { throw null; }
        public static bool StartsWith(string value, string possibleStart) { throw null; }
        public static char ToLower(char c) { throw null; }
        public static string? ToLower(string? value) { throw null; }
        public static void ToLower(System.Text.StringBuilder builder) { }
    }
    public readonly partial struct ChildSyntaxList : System.IEquatable<ChildSyntaxList>, System.Collections.Generic.IReadOnlyList<SyntaxNodeOrToken>, System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<SyntaxNodeOrToken>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public int Count { get { throw null; } }

        public SyntaxNodeOrToken this[int index] { get { throw null; } }

        public readonly bool Any() { throw null; }
        public readonly bool Equals(ChildSyntaxList other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly SyntaxNodeOrToken First() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly SyntaxNodeOrToken Last() { throw null; }
        public static bool operator ==(ChildSyntaxList list1, ChildSyntaxList list2) { throw null; }
        public static bool operator !=(ChildSyntaxList list1, ChildSyntaxList list2) { throw null; }
        public readonly Reversed Reverse() { throw null; }
        readonly System.Collections.Generic.IEnumerator<SyntaxNodeOrToken> System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public partial struct Enumerator
        {
            private object _dummy;
            private int _dummyPrimitive;
            public SyntaxNodeOrToken Current { get { throw null; } }

            [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "_node")]
            public bool MoveNext() { throw null; }
            public void Reset() { }
        }

        public readonly partial struct Reversed : System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>, System.Collections.IEnumerable, System.IEquatable<Reversed>
        {
            private readonly object _dummy;
            private readonly int _dummyPrimitive;
            public readonly bool Equals(Reversed other) { throw null; }
            public override readonly bool Equals(object? obj) { throw null; }
            public readonly Enumerator GetEnumerator() { throw null; }
            public override readonly int GetHashCode() { throw null; }
            readonly System.Collections.Generic.IEnumerator<SyntaxNodeOrToken> System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>.GetEnumerator() { throw null; }
            readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
            public partial struct Enumerator
            {
                private object _dummy;
                private int _dummyPrimitive;
                public SyntaxNodeOrToken Current { get { throw null; } }

                [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "_node")]
                public bool MoveNext() { throw null; }
                public void Reset() { }
            }
        }
    }

    public readonly partial struct CommandLineAnalyzerReference : System.IEquatable<CommandLineAnalyzerReference>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public CommandLineAnalyzerReference(string path) { }
        public string FilePath { get { throw null; } }

        public readonly bool Equals(CommandLineAnalyzerReference other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public abstract partial class CommandLineArguments
    {
        internal CommandLineArguments() { }
        public System.Collections.Immutable.ImmutableArray<CommandLineSourceFile> AdditionalFiles { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> AnalyzerConfigPaths { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<CommandLineAnalyzerReference> AnalyzerReferences { get { throw null; } }
        public string? AppConfigPath { get { throw null; } }
        public string? BaseDirectory { get { throw null; } }
        public Text.SourceHashAlgorithm ChecksumAlgorithm { get { throw null; } }
        public string? CompilationName { get { throw null; } }
        public CompilationOptions CompilationOptions { get { throw null; } }
        protected abstract CompilationOptions CompilationOptionsCore { get; }
        public bool DisplayHelp { get { throw null; } }
        public bool DisplayLangVersions { get { throw null; } }
        public bool DisplayLogo { get { throw null; } }
        public bool DisplayVersion { get { throw null; } }
        public string? DocumentationPath { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<CommandLineSourceFile> EmbeddedFiles { get { throw null; } }
        public Emit.EmitOptions EmitOptions { get { throw null; } }
        public bool EmitPdb { get { throw null; } }
        public bool EmitPdbFile { get { throw null; } }
        public System.Text.Encoding? Encoding { get { throw null; } }
        public ErrorLogOptions? ErrorLogOptions { get { throw null; } }
        public string? ErrorLogPath { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Errors { get { throw null; } }
        public string? GeneratedFilesOutputDirectory { get { throw null; } }
        public bool InteractiveMode { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> KeyFileSearchPaths { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ResourceDescription> ManifestResources { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<CommandLineReference> MetadataReferences { get { throw null; } }
        public bool NoWin32Manifest { get { throw null; } }
        public string OutputDirectory { get { throw null; } }
        public string? OutputFileName { get { throw null; } }
        public string? OutputRefFilePath { get { throw null; } }
        public ParseOptions ParseOptions { get { throw null; } }
        protected abstract ParseOptions ParseOptionsCore { get; }
        public System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, string>> PathMap { get { throw null; } }
        public string? PdbPath { get { throw null; } }
        public System.Globalization.CultureInfo? PreferredUILang { get { throw null; } }
        public bool PrintFullPaths { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> ReferencePaths { get { throw null; } }
        public bool ReportAnalyzer { get { throw null; } }
        public bool ReportInternalsVisibleToAttributes { get { throw null; } }
        public string? RuleSetPath { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> ScriptArguments { get { throw null; } }
        public bool SkipAnalyzers { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<CommandLineSourceFile> SourceFiles { get { throw null; } }
        public string? SourceLink { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> SourcePaths { get { throw null; } }
        public string? TouchedFilesPath { get { throw null; } }
        public bool Utf8Output { get { throw null; } }
        public string? Win32Icon { get { throw null; } }
        public string? Win32Manifest { get { throw null; } }
        public string? Win32ResourceFile { get { throw null; } }

        public string GetOutputFilePath(string outputFileName) { throw null; }
        public string GetPdbFilePath(string outputFileName) { throw null; }
        public System.Collections.Generic.IEnumerable<Diagnostics.AnalyzerReference> ResolveAnalyzerReferences(IAnalyzerAssemblyLoader analyzerLoader) { throw null; }
        public System.Collections.Generic.IEnumerable<MetadataReference> ResolveMetadataReferences(MetadataReferenceResolver metadataResolver) { throw null; }
    }
    public abstract partial class CommandLineParser
    {
        internal CommandLineParser() { }
        protected abstract string RegularFileExtension { get; }
        protected abstract string ScriptFileExtension { get; }

        public CommandLineArguments Parse(System.Collections.Generic.IEnumerable<string> args, string baseDirectory, string? sdkDirectory, string? additionalReferenceDirectories) { throw null; }
        protected System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, string>> ParsePathMap(string pathMap, System.Collections.Generic.IList<Diagnostic> errors) { throw null; }
        public static System.Collections.Generic.IEnumerable<string> SplitCommandLineIntoArguments(string commandLine, bool removeHashComments) { throw null; }
    }
    public readonly partial struct CommandLineReference : System.IEquatable<CommandLineReference>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public CommandLineReference(string reference, MetadataReferenceProperties properties) { }
        public MetadataReferenceProperties Properties { get { throw null; } }
        public string Reference { get { throw null; } }

        public readonly bool Equals(CommandLineReference other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public readonly partial struct CommandLineSourceFile
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public CommandLineSourceFile(string path, bool isScript, bool isInputRedirected) { }
        public CommandLineSourceFile(string path, bool isScript) { }
        public bool IsInputRedirected { get { throw null; } }
        public bool IsScript { get { throw null; } }
        public string Path { get { throw null; } }
    }

    public abstract partial class Compilation
    {
        internal Compilation() { }
        protected readonly System.Collections.Generic.IReadOnlyDictionary<string, string> _features;
        public IAssemblySymbol Assembly { get { throw null; } }
        public string? AssemblyName { get { throw null; } }
        protected abstract IAssemblySymbol CommonAssembly { get; }
        protected abstract ITypeSymbol CommonDynamicType { get; }
        protected abstract INamespaceSymbol CommonGlobalNamespace { get; }
        protected abstract INamedTypeSymbol CommonObjectType { get; }
        protected abstract CompilationOptions CommonOptions { get; }
        protected abstract INamedTypeSymbol? CommonScriptClass { get; }
        protected abstract ITypeSymbol? CommonScriptGlobalsType { get; }
        protected abstract IModuleSymbol CommonSourceModule { get; }
        protected internal abstract System.Collections.Immutable.ImmutableArray<SyntaxTree> CommonSyntaxTrees { get; }
        public abstract System.Collections.Immutable.ImmutableArray<MetadataReference> DirectiveReferences { get; }
        public ITypeSymbol DynamicType { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<MetadataReference> ExternalReferences { get { throw null; } }
        public INamespaceSymbol GlobalNamespace { get { throw null; } }
        public abstract bool IsCaseSensitive { get; }
        public abstract string Language { get; }
        public INamedTypeSymbol ObjectType { get { throw null; } }
        public CompilationOptions Options { get { throw null; } }
        public abstract System.Collections.Generic.IEnumerable<AssemblyIdentity> ReferencedAssemblyNames { get; }
        public System.Collections.Generic.IEnumerable<MetadataReference> References { get { throw null; } }
        public INamedTypeSymbol? ScriptClass { get { throw null; } }
        public ScriptCompilationInfo? ScriptCompilationInfo { get { throw null; } }
        public IModuleSymbol SourceModule { get { throw null; } }
        public System.Collections.Generic.IEnumerable<SyntaxTree> SyntaxTrees { get { throw null; } }

        public Compilation AddReferences(params MetadataReference[] references) { throw null; }
        public Compilation AddReferences(System.Collections.Generic.IEnumerable<MetadataReference> references) { throw null; }
        public Compilation AddSyntaxTrees(params SyntaxTree[] trees) { throw null; }
        public Compilation AddSyntaxTrees(System.Collections.Generic.IEnumerable<SyntaxTree> trees) { throw null; }
        protected abstract void AppendDefaultVersionResource(System.IO.Stream resourceStream);
        protected static void CheckTupleElementLocations(int cardinality, System.Collections.Immutable.ImmutableArray<Location?> elementLocations) { }
        protected static System.Collections.Immutable.ImmutableArray<string?> CheckTupleElementNames(int cardinality, System.Collections.Immutable.ImmutableArray<string?> elementNames) { throw null; }
        protected static void CheckTupleElementNullableAnnotations(int cardinality, System.Collections.Immutable.ImmutableArray<NullableAnnotation> elementNullableAnnotations) { }
        public abstract Operations.CommonConversion ClassifyCommonConversion(ITypeSymbol source, ITypeSymbol destination);
        public Compilation Clone() { throw null; }
        protected abstract Compilation CommonAddSyntaxTrees(System.Collections.Generic.IEnumerable<SyntaxTree> trees);
        protected INamedTypeSymbol? CommonBindScriptClass() { throw null; }
        protected abstract Compilation CommonClone();
        protected abstract bool CommonContainsSyntaxTree(SyntaxTree? syntaxTree);
        protected abstract INamedTypeSymbol CommonCreateAnonymousTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> memberTypes, System.Collections.Immutable.ImmutableArray<string> memberNames, System.Collections.Immutable.ImmutableArray<Location> memberLocations, System.Collections.Immutable.ImmutableArray<bool> memberIsReadOnly, System.Collections.Immutable.ImmutableArray<NullableAnnotation> memberNullableAnnotations);
        protected abstract IArrayTypeSymbol CommonCreateArrayTypeSymbol(ITypeSymbol elementType, int rank, NullableAnnotation elementNullableAnnotation);
        protected abstract IMethodSymbol CommonCreateBuiltinOperator(string name, ITypeSymbol returnType, ITypeSymbol leftType, ITypeSymbol rightType);
        protected abstract IMethodSymbol CommonCreateBuiltinOperator(string name, ITypeSymbol returnType, ITypeSymbol operandType);
        protected abstract INamespaceSymbol CommonCreateErrorNamespaceSymbol(INamespaceSymbol container, string name);
        protected abstract INamedTypeSymbol CommonCreateErrorTypeSymbol(INamespaceOrTypeSymbol? container, string name, int arity);
        protected abstract IFunctionPointerTypeSymbol CommonCreateFunctionPointerTypeSymbol(ITypeSymbol returnType, RefKind returnRefKind, System.Collections.Immutable.ImmutableArray<ITypeSymbol> parameterTypes, System.Collections.Immutable.ImmutableArray<RefKind> parameterRefKinds, System.Reflection.Metadata.SignatureCallingConvention callingConvention, System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> callingConventionTypes);
        protected abstract INamedTypeSymbol CommonCreateNativeIntegerTypeSymbol(bool signed);
        protected abstract IPointerTypeSymbol CommonCreatePointerTypeSymbol(ITypeSymbol elementType);
        protected abstract INamedTypeSymbol CommonCreateTupleTypeSymbol(INamedTypeSymbol underlyingType, System.Collections.Immutable.ImmutableArray<string?> elementNames, System.Collections.Immutable.ImmutableArray<Location?> elementLocations, System.Collections.Immutable.ImmutableArray<NullableAnnotation> elementNullableAnnotations);
        protected abstract INamedTypeSymbol CommonCreateTupleTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> elementTypes, System.Collections.Immutable.ImmutableArray<string?> elementNames, System.Collections.Immutable.ImmutableArray<Location?> elementLocations, System.Collections.Immutable.ImmutableArray<NullableAnnotation> elementNullableAnnotations);
        protected abstract ISymbol? CommonGetAssemblyOrModuleSymbol(MetadataReference reference);
        protected abstract INamespaceSymbol? CommonGetCompilationNamespace(INamespaceSymbol namespaceSymbol);
        protected abstract IMethodSymbol? CommonGetEntryPoint(System.Threading.CancellationToken cancellationToken);
        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL001", UrlFormat = "https://github.com/dotnet/roslyn/issues/70609")]
        protected abstract SemanticModel CommonGetSemanticModel(SyntaxTree syntaxTree, SemanticModelOptions options);
        protected abstract INamedTypeSymbol? CommonGetTypeByMetadataName(string metadataName);
        protected abstract Compilation CommonRemoveAllSyntaxTrees();
        protected abstract Compilation CommonRemoveSyntaxTrees(System.Collections.Generic.IEnumerable<SyntaxTree> trees);
        protected abstract Compilation CommonReplaceSyntaxTree(SyntaxTree oldTree, SyntaxTree newTree);
        protected abstract Compilation CommonWithAssemblyName(string? outputName);
        protected abstract Compilation CommonWithOptions(CompilationOptions options);
        protected abstract Compilation CommonWithReferences(System.Collections.Generic.IEnumerable<MetadataReference> newReferences);
        protected abstract Compilation CommonWithScriptCompilationInfo(ScriptCompilationInfo? info);
        public abstract bool ContainsSymbolsWithName(System.Func<string, bool> predicate, SymbolFilter filter = SymbolFilter.TypeAndMember, System.Threading.CancellationToken cancellationToken = default);
        public abstract bool ContainsSymbolsWithName(string name, SymbolFilter filter = SymbolFilter.TypeAndMember, System.Threading.CancellationToken cancellationToken = default);
        public bool ContainsSyntaxTree(SyntaxTree syntaxTree) { throw null; }
        public INamedTypeSymbol CreateAnonymousTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> memberTypes, System.Collections.Immutable.ImmutableArray<string> memberNames, System.Collections.Immutable.ImmutableArray<bool> memberIsReadOnly = default, System.Collections.Immutable.ImmutableArray<Location> memberLocations = default, System.Collections.Immutable.ImmutableArray<NullableAnnotation> memberNullableAnnotations = default) { throw null; }
        public INamedTypeSymbol CreateAnonymousTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> memberTypes, System.Collections.Immutable.ImmutableArray<string> memberNames, System.Collections.Immutable.ImmutableArray<bool> memberIsReadOnly, System.Collections.Immutable.ImmutableArray<Location> memberLocations) { throw null; }
        public IArrayTypeSymbol CreateArrayTypeSymbol(ITypeSymbol elementType, int rank = 1, NullableAnnotation elementNullableAnnotation = NullableAnnotation.None) { throw null; }
        public IArrayTypeSymbol CreateArrayTypeSymbol(ITypeSymbol elementType, int rank) { throw null; }
        public IMethodSymbol CreateBuiltinOperator(string name, ITypeSymbol returnType, ITypeSymbol leftType, ITypeSymbol rightType) { throw null; }
        public IMethodSymbol CreateBuiltinOperator(string name, ITypeSymbol returnType, ITypeSymbol operandType) { throw null; }
        public System.IO.Stream CreateDefaultWin32Resources(bool versionResource, bool noManifest, System.IO.Stream? manifestContents, System.IO.Stream? iconInIcoFormat) { throw null; }
        public INamespaceSymbol CreateErrorNamespaceSymbol(INamespaceSymbol container, string name) { throw null; }
        public INamedTypeSymbol CreateErrorTypeSymbol(INamespaceOrTypeSymbol? container, string name, int arity) { throw null; }
        public IFunctionPointerTypeSymbol CreateFunctionPointerTypeSymbol(ITypeSymbol returnType, RefKind returnRefKind, System.Collections.Immutable.ImmutableArray<ITypeSymbol> parameterTypes, System.Collections.Immutable.ImmutableArray<RefKind> parameterRefKinds, System.Reflection.Metadata.SignatureCallingConvention callingConvention = System.Reflection.Metadata.SignatureCallingConvention.Default, System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> callingConventionTypes = default) { throw null; }
        public INamedTypeSymbol CreateNativeIntegerTypeSymbol(bool signed) { throw null; }
        public IPointerTypeSymbol CreatePointerTypeSymbol(ITypeSymbol pointedAtType) { throw null; }
        public INamedTypeSymbol CreateTupleTypeSymbol(INamedTypeSymbol underlyingType, System.Collections.Immutable.ImmutableArray<string?> elementNames = default, System.Collections.Immutable.ImmutableArray<Location?> elementLocations = default, System.Collections.Immutable.ImmutableArray<NullableAnnotation> elementNullableAnnotations = default) { throw null; }
        public INamedTypeSymbol CreateTupleTypeSymbol(INamedTypeSymbol underlyingType, System.Collections.Immutable.ImmutableArray<string?> elementNames, System.Collections.Immutable.ImmutableArray<Location?> elementLocations) { throw null; }
        public INamedTypeSymbol CreateTupleTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> elementTypes, System.Collections.Immutable.ImmutableArray<string?> elementNames = default, System.Collections.Immutable.ImmutableArray<Location?> elementLocations = default, System.Collections.Immutable.ImmutableArray<NullableAnnotation> elementNullableAnnotations = default) { throw null; }
        public INamedTypeSymbol CreateTupleTypeSymbol(System.Collections.Immutable.ImmutableArray<ITypeSymbol> elementTypes, System.Collections.Immutable.ImmutableArray<string?> elementNames, System.Collections.Immutable.ImmutableArray<Location?> elementLocations) { throw null; }
        public Emit.EmitResult Emit(System.IO.Stream peStream, System.IO.Stream? pdbStream = null, System.IO.Stream? xmlDocumentationStream = null, System.IO.Stream? win32Resources = null, System.Collections.Generic.IEnumerable<ResourceDescription>? manifestResources = null, Emit.EmitOptions? options = null, IMethodSymbol? debugEntryPoint = null, System.IO.Stream? sourceLinkStream = null, System.Collections.Generic.IEnumerable<EmbeddedText>? embeddedTexts = null, System.IO.Stream? metadataPEStream = null, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public Emit.EmitResult Emit(System.IO.Stream peStream, System.IO.Stream? pdbStream, System.IO.Stream? xmlDocumentationStream, System.IO.Stream? win32Resources, System.Collections.Generic.IEnumerable<ResourceDescription>? manifestResources, Emit.EmitOptions options, IMethodSymbol? debugEntryPoint, System.IO.Stream? sourceLinkStream, System.Collections.Generic.IEnumerable<EmbeddedText>? embeddedTexts, System.Threading.CancellationToken cancellationToken) { throw null; }
        public Emit.EmitResult Emit(System.IO.Stream peStream, System.IO.Stream pdbStream, System.IO.Stream xmlDocumentationStream, System.IO.Stream win32Resources, System.Collections.Generic.IEnumerable<ResourceDescription> manifestResources, Emit.EmitOptions options, IMethodSymbol debugEntryPoint, System.Threading.CancellationToken cancellationToken) { throw null; }
        public Emit.EmitResult Emit(System.IO.Stream peStream, System.IO.Stream? pdbStream, System.IO.Stream? xmlDocumentationStream, System.IO.Stream? win32Resources, System.Collections.Generic.IEnumerable<ResourceDescription>? manifestResources, Emit.EmitOptions options, System.Threading.CancellationToken cancellationToken) { throw null; }
        [System.Obsolete("UpdatedMethods is now part of EmitDifferenceResult, so you should use an overload that doesn't take it.")]
        public Emit.EmitDifferenceResult EmitDifference(Emit.EmitBaseline baseline, System.Collections.Generic.IEnumerable<Emit.SemanticEdit> edits, System.Func<ISymbol, bool> isAddedSymbol, System.IO.Stream metadataStream, System.IO.Stream ilStream, System.IO.Stream pdbStream, System.Collections.Generic.ICollection<System.Reflection.Metadata.MethodDefinitionHandle> updatedMethods, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public Emit.EmitDifferenceResult EmitDifference(Emit.EmitBaseline baseline, System.Collections.Generic.IEnumerable<Emit.SemanticEdit> edits, System.Func<ISymbol, bool> isAddedSymbol, System.IO.Stream metadataStream, System.IO.Stream ilStream, System.IO.Stream pdbStream, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        [System.Obsolete("UpdatedMethods is now part of EmitDifferenceResult, so you should use an overload that doesn't take it.")]
        public Emit.EmitDifferenceResult EmitDifference(Emit.EmitBaseline baseline, System.Collections.Generic.IEnumerable<Emit.SemanticEdit> edits, System.IO.Stream metadataStream, System.IO.Stream ilStream, System.IO.Stream pdbStream, System.Collections.Generic.ICollection<System.Reflection.Metadata.MethodDefinitionHandle> updatedMethods, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public ISymbol? GetAssemblyOrModuleSymbol(MetadataReference reference) { throw null; }
        public INamespaceSymbol? GetCompilationNamespace(INamespaceSymbol namespaceSymbol) { throw null; }
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetDeclarationDiagnostics(System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetDiagnostics(System.Threading.CancellationToken cancellationToken = default);
        public IMethodSymbol? GetEntryPoint(System.Threading.CancellationToken cancellationToken) { throw null; }
        public MetadataReference? GetMetadataReference(IAssemblySymbol assemblySymbol) { throw null; }
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetMethodBodyDiagnostics(System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetParseDiagnostics(System.Threading.CancellationToken cancellationToken = default);
        public static string? GetRequiredLanguageVersion(Diagnostic diagnostic) { throw null; }
        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL001", UrlFormat = "https://github.com/dotnet/roslyn/issues/70609")]
        public SemanticModel GetSemanticModel(SyntaxTree syntaxTree, SemanticModelOptions options) { throw null; }
        public SemanticModel GetSemanticModel(SyntaxTree syntaxTree, bool ignoreAccessibility = false) { throw null; }
        public INamedTypeSymbol GetSpecialType(SpecialType specialType) { throw null; }
        public abstract System.Collections.Generic.IEnumerable<ISymbol> GetSymbolsWithName(System.Func<string, bool> predicate, SymbolFilter filter = SymbolFilter.TypeAndMember, System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Generic.IEnumerable<ISymbol> GetSymbolsWithName(string name, SymbolFilter filter = SymbolFilter.TypeAndMember, System.Threading.CancellationToken cancellationToken = default);
        public INamedTypeSymbol? GetTypeByMetadataName(string fullyQualifiedMetadataName) { throw null; }
        public System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> GetTypesByMetadataName(string fullyQualifiedMetadataName) { throw null; }
        public System.Collections.Immutable.ImmutableArray<AssemblyIdentity> GetUnreferencedAssemblyIdentities(Diagnostic diagnostic) { throw null; }
        public abstract System.Collections.Immutable.ImmutableArray<MetadataReference> GetUsedAssemblyReferences(System.Threading.CancellationToken cancellationToken = default);
        public bool HasImplicitConversion(ITypeSymbol? fromType, ITypeSymbol? toType) { throw null; }
        public bool IsSymbolAccessibleWithin(ISymbol symbol, ISymbol within, ITypeSymbol? throughType = null) { throw null; }
        public Compilation RemoveAllReferences() { throw null; }
        public Compilation RemoveAllSyntaxTrees() { throw null; }
        public Compilation RemoveReferences(params MetadataReference[] references) { throw null; }
        public Compilation RemoveReferences(System.Collections.Generic.IEnumerable<MetadataReference> references) { throw null; }
        public Compilation RemoveSyntaxTrees(params SyntaxTree[] trees) { throw null; }
        public Compilation RemoveSyntaxTrees(System.Collections.Generic.IEnumerable<SyntaxTree> trees) { throw null; }
        public Compilation ReplaceReference(MetadataReference oldReference, MetadataReference? newReference) { throw null; }
        public Compilation ReplaceSyntaxTree(SyntaxTree oldTree, SyntaxTree newTree) { throw null; }
        public bool SupportsRuntimeCapability(RuntimeCapability capability) { throw null; }
        protected static System.Collections.Generic.IReadOnlyDictionary<string, string> SyntaxTreeCommonFeatures(System.Collections.Generic.IEnumerable<SyntaxTree> trees) { throw null; }
        public abstract CompilationReference ToMetadataReference(System.Collections.Immutable.ImmutableArray<string> aliases = default, bool embedInteropTypes = false);
        public Compilation WithAssemblyName(string? assemblyName) { throw null; }
        public Compilation WithOptions(CompilationOptions options) { throw null; }
        public Compilation WithReferences(params MetadataReference[] newReferences) { throw null; }
        public Compilation WithReferences(System.Collections.Generic.IEnumerable<MetadataReference> newReferences) { throw null; }
        public Compilation WithScriptCompilationInfo(ScriptCompilationInfo? info) { throw null; }
    }
    public abstract partial class CompilationOptions
    {
        internal CompilationOptions() { }
        public AssemblyIdentityComparer AssemblyIdentityComparer { get { throw null; } protected set { } }
        public bool CheckOverflow { get { throw null; } protected set { } }
        public bool ConcurrentBuild { get { throw null; } protected set { } }
        public string? CryptoKeyContainer { get { throw null; } protected set { } }
        public string? CryptoKeyFile { get { throw null; } protected set { } }
        public System.Collections.Immutable.ImmutableArray<byte> CryptoPublicKey { get { throw null; } protected set { } }
        public bool? DelaySign { get { throw null; } protected set { } }
        public bool Deterministic { get { throw null; } protected set { } }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Errors { get { throw null; } }

        [System.Obsolete]
        protected internal System.Collections.Immutable.ImmutableArray<string> Features { get { throw null; } protected set { } }
        public ReportDiagnostic GeneralDiagnosticOption { get { throw null; } protected set { } }
        public abstract string Language { get; }
        public string? MainTypeName { get { throw null; } protected set { } }
        public MetadataImportOptions MetadataImportOptions { get { throw null; } protected set { } }
        public MetadataReferenceResolver? MetadataReferenceResolver { get { throw null; } protected set { } }
        public string? ModuleName { get { throw null; } protected set { } }
        public abstract NullableContextOptions NullableContextOptions { get; protected set; }
        public OptimizationLevel OptimizationLevel { get { throw null; } protected set { } }
        public OutputKind OutputKind { get { throw null; } protected set { } }
        public Platform Platform { get { throw null; } protected set { } }
        public bool PublicSign { get { throw null; } protected set { } }
        public bool ReportSuppressedDiagnostics { get { throw null; } protected set { } }
        public string? ScriptClassName { get { throw null; } protected set { } }
        public SourceReferenceResolver? SourceReferenceResolver { get { throw null; } protected set { } }
        public System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> SpecificDiagnosticOptions { get { throw null; } protected set { } }
        public StrongNameProvider? StrongNameProvider { get { throw null; } protected set { } }
        public SyntaxTreeOptionsProvider? SyntaxTreeOptionsProvider { get { throw null; } protected set { } }
        public int WarningLevel { get { throw null; } protected set { } }
        public XmlReferenceResolver? XmlReferenceResolver { get { throw null; } protected set { } }

        protected abstract CompilationOptions CommonWithAssemblyIdentityComparer(AssemblyIdentityComparer? comparer);
        protected abstract CompilationOptions CommonWithCheckOverflow(bool checkOverflow);
        protected abstract CompilationOptions CommonWithConcurrentBuild(bool concurrent);
        protected abstract CompilationOptions CommonWithCryptoKeyContainer(string? cryptoKeyContainer);
        protected abstract CompilationOptions CommonWithCryptoKeyFile(string? cryptoKeyFile);
        protected abstract CompilationOptions CommonWithCryptoPublicKey(System.Collections.Immutable.ImmutableArray<byte> cryptoPublicKey);
        protected abstract CompilationOptions CommonWithDelaySign(bool? delaySign);
        protected abstract CompilationOptions CommonWithDeterministic(bool deterministic);
        [System.Obsolete]
        protected abstract CompilationOptions CommonWithFeatures(System.Collections.Immutable.ImmutableArray<string> features);
        protected abstract CompilationOptions CommonWithGeneralDiagnosticOption(ReportDiagnostic generalDiagnosticOption);
        protected abstract CompilationOptions CommonWithMainTypeName(string? mainTypeName);
        protected abstract CompilationOptions CommonWithMetadataImportOptions(MetadataImportOptions value);
        protected abstract CompilationOptions CommonWithMetadataReferenceResolver(MetadataReferenceResolver? resolver);
        protected abstract CompilationOptions CommonWithModuleName(string? moduleName);
        protected abstract CompilationOptions CommonWithOptimizationLevel(OptimizationLevel value);
        protected abstract CompilationOptions CommonWithOutputKind(OutputKind kind);
        protected abstract CompilationOptions CommonWithPlatform(Platform platform);
        protected abstract CompilationOptions CommonWithPublicSign(bool publicSign);
        protected abstract CompilationOptions CommonWithReportSuppressedDiagnostics(bool reportSuppressedDiagnostics);
        protected abstract CompilationOptions CommonWithScriptClassName(string scriptClassName);
        protected abstract CompilationOptions CommonWithSourceReferenceResolver(SourceReferenceResolver? resolver);
        protected abstract CompilationOptions CommonWithSpecificDiagnosticOptions(System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, ReportDiagnostic>> specificDiagnosticOptions);
        protected abstract CompilationOptions CommonWithSpecificDiagnosticOptions(System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic>? specificDiagnosticOptions);
        protected abstract CompilationOptions CommonWithStrongNameProvider(StrongNameProvider? provider);
        protected abstract CompilationOptions CommonWithSyntaxTreeOptionsProvider(SyntaxTreeOptionsProvider? resolver);
        protected abstract CompilationOptions CommonWithXmlReferenceResolver(XmlReferenceResolver? resolver);
        protected abstract int ComputeHashCode();
        public abstract override bool Equals(object? obj);
        protected bool EqualsHelper(CompilationOptions? other) { throw null; }
        public sealed override int GetHashCode() { throw null; }
        protected int GetHashCodeHelper() { throw null; }
        public static bool operator ==(CompilationOptions? left, CompilationOptions? right) { throw null; }
        public static bool operator !=(CompilationOptions? left, CompilationOptions? right) { throw null; }
        public CompilationOptions WithAssemblyIdentityComparer(AssemblyIdentityComparer comparer) { throw null; }
        public CompilationOptions WithConcurrentBuild(bool concurrent) { throw null; }
        public CompilationOptions WithCryptoKeyContainer(string? cryptoKeyContainer) { throw null; }
        public CompilationOptions WithCryptoKeyFile(string? cryptoKeyFile) { throw null; }
        public CompilationOptions WithCryptoPublicKey(System.Collections.Immutable.ImmutableArray<byte> cryptoPublicKey) { throw null; }
        public CompilationOptions WithDelaySign(bool? delaySign) { throw null; }
        public CompilationOptions WithDeterministic(bool deterministic) { throw null; }
        public CompilationOptions WithGeneralDiagnosticOption(ReportDiagnostic value) { throw null; }
        public CompilationOptions WithMainTypeName(string? mainTypeName) { throw null; }
        public CompilationOptions WithMetadataImportOptions(MetadataImportOptions value) { throw null; }
        public CompilationOptions WithMetadataReferenceResolver(MetadataReferenceResolver? resolver) { throw null; }
        public CompilationOptions WithModuleName(string? moduleName) { throw null; }
        public CompilationOptions WithOptimizationLevel(OptimizationLevel value) { throw null; }
        public CompilationOptions WithOutputKind(OutputKind kind) { throw null; }
        public CompilationOptions WithOverflowChecks(bool checkOverflow) { throw null; }
        public CompilationOptions WithPlatform(Platform platform) { throw null; }
        public CompilationOptions WithPublicSign(bool publicSign) { throw null; }
        public CompilationOptions WithReportSuppressedDiagnostics(bool value) { throw null; }
        public CompilationOptions WithScriptClassName(string scriptClassName) { throw null; }
        public CompilationOptions WithSourceReferenceResolver(SourceReferenceResolver? resolver) { throw null; }
        public CompilationOptions WithSpecificDiagnosticOptions(System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, ReportDiagnostic>> value) { throw null; }
        public CompilationOptions WithSpecificDiagnosticOptions(System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic>? value) { throw null; }
        public CompilationOptions WithStrongNameProvider(StrongNameProvider? provider) { throw null; }
        public CompilationOptions WithSyntaxTreeOptionsProvider(SyntaxTreeOptionsProvider? provider) { throw null; }
        public CompilationOptions WithXmlReferenceResolver(XmlReferenceResolver? resolver) { throw null; }
    }
    public abstract partial class CompilationReference : MetadataReference, System.IEquatable<CompilationReference>
    {
        internal CompilationReference() : base(default) { }
        public Compilation Compilation { get { throw null; } }
        public override string? Display { get { throw null; } }

        public bool Equals(CompilationReference? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public new CompilationReference WithAliases(System.Collections.Generic.IEnumerable<string> aliases) { throw null; }
        public new CompilationReference WithAliases(System.Collections.Immutable.ImmutableArray<string> aliases) { throw null; }
        public new CompilationReference WithEmbedInteropTypes(bool value) { throw null; }
        public new CompilationReference WithProperties(MetadataReferenceProperties properties) { throw null; }
    }

    public abstract partial class ControlFlowAnalysis
    {
        public abstract bool EndPointIsReachable { get; }
        public abstract System.Collections.Immutable.ImmutableArray<SyntaxNode> EntryPoints { get; }
        public abstract System.Collections.Immutable.ImmutableArray<SyntaxNode> ExitPoints { get; }
        public abstract System.Collections.Immutable.ImmutableArray<SyntaxNode> ReturnStatements { get; }
        public abstract bool StartPointIsReachable { get; }
        public abstract bool Succeeded { get; }
    }
    public abstract partial class CustomModifier
    {
        public abstract bool IsOptional { get; }
        public abstract INamedTypeSymbol Modifier { get; }
    }
    public abstract partial class DataFlowAnalysis
    {
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> AlwaysAssigned { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> Captured { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> CapturedInside { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> CapturedOutside { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> DataFlowsIn { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> DataFlowsOut { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> DefinitelyAssignedOnEntry { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> DefinitelyAssignedOnExit { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> ReadInside { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> ReadOutside { get; }
        public abstract bool Succeeded { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> UnsafeAddressTaken { get; }
        public abstract System.Collections.Immutable.ImmutableArray<IMethodSymbol> UsedLocalFunctions { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> VariablesDeclared { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> WrittenInside { get; }
        public abstract System.Collections.Immutable.ImmutableArray<ISymbol> WrittenOutside { get; }
    }
    public sealed partial class DesktopAssemblyIdentityComparer : AssemblyIdentityComparer
    {
        internal DesktopAssemblyIdentityComparer() { }
        public new static DesktopAssemblyIdentityComparer Default { get { throw null; } }

        public static DesktopAssemblyIdentityComparer LoadFromXml(System.IO.Stream input) { throw null; }
    }

    public partial class DesktopStrongNameProvider : StrongNameProvider
    {
        public DesktopStrongNameProvider(System.Collections.Immutable.ImmutableArray<string> keyFileSearchPaths = default, string? tempPath = null) { }
        public DesktopStrongNameProvider(System.Collections.Immutable.ImmutableArray<string> keyFileSearchPaths) { }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
    }

    public abstract partial class Diagnostic : System.IEquatable<Diagnostic?>, System.IFormattable
    {
        public abstract System.Collections.Generic.IReadOnlyList<Location> AdditionalLocations { get; }
        public virtual DiagnosticSeverity DefaultSeverity { get { throw null; } }
        public abstract DiagnosticDescriptor Descriptor { get; }
        public abstract string Id { get; }
        public abstract bool IsSuppressed { get; }
        public bool IsWarningAsError { get { throw null; } }
        public abstract Location Location { get; }
        public virtual System.Collections.Immutable.ImmutableDictionary<string, string?> Properties { get { throw null; } }
        public abstract DiagnosticSeverity Severity { get; }
        public abstract int WarningLevel { get; }

        public static Diagnostic Create(DiagnosticDescriptor descriptor, Location? location, DiagnosticSeverity effectiveSeverity, System.Collections.Generic.IEnumerable<Location>? additionalLocations, System.Collections.Immutable.ImmutableDictionary<string, string?>? properties, params object?[]? messageArgs) { throw null; }
        public static Diagnostic Create(DiagnosticDescriptor descriptor, Location? location, System.Collections.Generic.IEnumerable<Location>? additionalLocations, System.Collections.Immutable.ImmutableDictionary<string, string?>? properties, params object?[]? messageArgs) { throw null; }
        public static Diagnostic Create(DiagnosticDescriptor descriptor, Location? location, System.Collections.Generic.IEnumerable<Location>? additionalLocations, params object?[]? messageArgs) { throw null; }
        public static Diagnostic Create(DiagnosticDescriptor descriptor, Location? location, System.Collections.Immutable.ImmutableDictionary<string, string?>? properties, params object?[]? messageArgs) { throw null; }
        public static Diagnostic Create(DiagnosticDescriptor descriptor, Location? location, params object?[]? messageArgs) { throw null; }
        public static Diagnostic Create(string id, string category, LocalizableString message, DiagnosticSeverity severity, DiagnosticSeverity defaultSeverity, bool isEnabledByDefault, int warningLevel, LocalizableString? title = null, LocalizableString? description = null, string? helpLink = null, Location? location = null, System.Collections.Generic.IEnumerable<Location>? additionalLocations = null, System.Collections.Generic.IEnumerable<string>? customTags = null, System.Collections.Immutable.ImmutableDictionary<string, string?>? properties = null) { throw null; }
        public static Diagnostic Create(string id, string category, LocalizableString message, DiagnosticSeverity severity, DiagnosticSeverity defaultSeverity, bool isEnabledByDefault, int warningLevel, bool isSuppressed, LocalizableString? title = null, LocalizableString? description = null, string? helpLink = null, Location? location = null, System.Collections.Generic.IEnumerable<Location>? additionalLocations = null, System.Collections.Generic.IEnumerable<string>? customTags = null, System.Collections.Immutable.ImmutableDictionary<string, string?>? properties = null) { throw null; }
        public abstract bool Equals(Diagnostic? obj);
        public sealed override bool Equals(object? obj) { throw null; }
        public abstract override int GetHashCode();
        public abstract string GetMessage(System.IFormatProvider? formatProvider = null);
        public Diagnostics.SuppressionInfo? GetSuppressionInfo(Compilation compilation) { throw null; }
        string System.IFormattable.ToString(string? ignored, System.IFormatProvider? formatProvider) { throw null; }
        public override string ToString() { throw null; }
    }

    public sealed partial class DiagnosticDescriptor : System.IEquatable<DiagnosticDescriptor?>
    {
        public DiagnosticDescriptor(string id, LocalizableString title, LocalizableString messageFormat, string category, DiagnosticSeverity defaultSeverity, bool isEnabledByDefault, LocalizableString? description = null, string? helpLinkUri = null, params string[] customTags) { }
        public DiagnosticDescriptor(string id, string title, string messageFormat, string category, DiagnosticSeverity defaultSeverity, bool isEnabledByDefault, string? description = null, string? helpLinkUri = null, params string[] customTags) { }
        public string Category { get { throw null; } }
        public System.Collections.Generic.IEnumerable<string> CustomTags { get { throw null; } }
        public DiagnosticSeverity DefaultSeverity { get { throw null; } }
        public LocalizableString Description { get { throw null; } }
        public string HelpLinkUri { get { throw null; } }
        public string Id { get { throw null; } }
        public bool IsEnabledByDefault { get { throw null; } }
        public LocalizableString MessageFormat { get { throw null; } }
        public LocalizableString Title { get { throw null; } }

        public bool Equals(DiagnosticDescriptor? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public ReportDiagnostic GetEffectiveSeverity(CompilationOptions compilationOptions) { throw null; }
        public override int GetHashCode() { throw null; }
    }

    public partial class DiagnosticFormatter
    {
        public virtual string Format(Diagnostic diagnostic, System.IFormatProvider? formatter = null) { throw null; }
    }
    public enum DiagnosticSeverity
    {
        Hidden = 0,
        Info = 1,
        Warning = 2,
        Error = 3
    }

    public sealed partial class DllImportData
    {
        internal DllImportData() { }
        public bool? BestFitMapping { get { throw null; } }
        public System.Runtime.InteropServices.CallingConvention CallingConvention { get { throw null; } }
        public System.Runtime.InteropServices.CharSet CharacterSet { get { throw null; } }
        public string? EntryPointName { get { throw null; } }
        public bool ExactSpelling { get { throw null; } }
        public string? ModuleName { get { throw null; } }
        public bool SetLastError { get { throw null; } }
        public bool? ThrowOnUnmappableCharacter { get { throw null; } }
    }
    public static partial class DocumentationCommentId
    {
        public static string? CreateDeclarationId(ISymbol symbol) { throw null; }
        public static string CreateReferenceId(ISymbol symbol) { throw null; }
        public static ISymbol? GetFirstSymbolForDeclarationId(string id, Compilation compilation) { throw null; }
        public static ISymbol? GetFirstSymbolForReferenceId(string id, Compilation compilation) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<ISymbol> GetSymbolsForDeclarationId(string id, Compilation compilation) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<ISymbol> GetSymbolsForReferenceId(string id, Compilation compilation) { throw null; }
    }
    public enum DocumentationMode : byte
    {
        None = 0,
        Parse = 1,
        Diagnose = 2
    }

    public abstract partial class DocumentationProvider
    {
        public static DocumentationProvider Default { get { throw null; } }

        public abstract override bool Equals(object? obj);
        protected internal abstract string? GetDocumentationForSymbol(string documentationMemberID, System.Globalization.CultureInfo preferredCulture, System.Threading.CancellationToken cancellationToken = default);
        public abstract override int GetHashCode();
    }
    public sealed partial class EmbeddedText
    {
        internal EmbeddedText() { }
        public System.Collections.Immutable.ImmutableArray<byte> Checksum { get { throw null; } }
        public Text.SourceHashAlgorithm ChecksumAlgorithm { get { throw null; } }
        public string FilePath { get { throw null; } }

        public static EmbeddedText FromBytes(string filePath, System.ArraySegment<byte> bytes, Text.SourceHashAlgorithm checksumAlgorithm = Text.SourceHashAlgorithm.Sha1) { throw null; }
        public static EmbeddedText FromSource(string filePath, Text.SourceText text) { throw null; }
        public static EmbeddedText FromStream(string filePath, System.IO.Stream stream, Text.SourceHashAlgorithm checksumAlgorithm = Text.SourceHashAlgorithm.Sha1) { throw null; }
    }
    public sealed partial class ErrorLogOptions
    {
        public ErrorLogOptions(string path, SarifVersion sarifVersion) { }
        public string Path { get { throw null; } }
        public SarifVersion SarifVersion { get { throw null; } }
    }
    [System.Runtime.Serialization.DataContract]
    public readonly partial struct FileLinePositionSpan : System.IEquatable<FileLinePositionSpan>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public FileLinePositionSpan(string path, Text.LinePosition start, Text.LinePosition end) { }
        public FileLinePositionSpan(string path, Text.LinePositionSpan span) { }
        public Text.LinePosition EndLinePosition { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 2)]
        public bool HasMappedPath { get { throw null; } }
        public bool IsValid { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 0)]
        public string Path { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 1)]
        public Text.LinePositionSpan Span { get { throw null; } }
        public Text.LinePosition StartLinePosition { get { throw null; } }

        public readonly bool Equals(FileLinePositionSpan other) { throw null; }
        public override readonly bool Equals(object? other) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(FileLinePositionSpan left, FileLinePositionSpan right) { throw null; }
        public static bool operator !=(FileLinePositionSpan left, FileLinePositionSpan right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public static partial class FileSystemExtensions
    {
        public static Emit.EmitResult Emit(this Compilation compilation, string outputPath, string? pdbPath = null, string? xmlDocPath = null, string? win32ResourcesPath = null, System.Collections.Generic.IEnumerable<ResourceDescription>? manifestResources = null, System.Threading.CancellationToken cancellationToken = default) { throw null; }
    }
    public enum GeneratedKind
    {
        Unknown = 0,
        NotGenerated = 1,
        MarkedGenerated = 2
    }

    public readonly partial struct GeneratedSourceResult
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public string HintName { get { throw null; } }
        public Text.SourceText SourceText { get { throw null; } }
        public SyntaxTree SyntaxTree { get { throw null; } }
    }

    [System.AttributeUsage(System.AttributeTargets.Class)]
    public sealed partial class GeneratorAttribute : System.Attribute
    {
        public GeneratorAttribute() { }
        public GeneratorAttribute(string firstLanguage, params string[] additionalLanguages) { }
        public string[] Languages { get { throw null; } }
    }

    public readonly partial struct GeneratorAttributeSyntaxContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Collections.Immutable.ImmutableArray<AttributeData> Attributes { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }
        public SyntaxNode TargetNode { get { throw null; } }
        public ISymbol TargetSymbol { get { throw null; } }
    }

    public abstract partial class GeneratorDriver
    {
        internal GeneratorDriver() { }
        public GeneratorDriver AddAdditionalTexts(System.Collections.Immutable.ImmutableArray<AdditionalText> additionalTexts) { throw null; }
        public GeneratorDriver AddGenerators(System.Collections.Immutable.ImmutableArray<ISourceGenerator> generators) { throw null; }
        public GeneratorDriverRunResult GetRunResult() { throw null; }
        public GeneratorDriverTimingInfo GetTimingInfo() { throw null; }
        public GeneratorDriver RemoveAdditionalTexts(System.Collections.Immutable.ImmutableArray<AdditionalText> additionalTexts) { throw null; }
        public GeneratorDriver RemoveGenerators(System.Collections.Immutable.ImmutableArray<ISourceGenerator> generators) { throw null; }
        public GeneratorDriver ReplaceAdditionalText(AdditionalText oldText, AdditionalText newText) { throw null; }
        public GeneratorDriver ReplaceAdditionalTexts(System.Collections.Immutable.ImmutableArray<AdditionalText> newTexts) { throw null; }
        public GeneratorDriver ReplaceGenerators(System.Collections.Immutable.ImmutableArray<ISourceGenerator> generators) { throw null; }
        public GeneratorDriver RunGenerators(Compilation compilation, System.Func<GeneratorFilterContext, bool>? generatorFilter, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public GeneratorDriver RunGenerators(Compilation compilation, System.Threading.CancellationToken cancellationToken) { throw null; }
        public GeneratorDriver RunGenerators(Compilation compilation) { throw null; }
        public GeneratorDriver RunGeneratorsAndUpdateCompilation(Compilation compilation, out Compilation outputCompilation, out System.Collections.Immutable.ImmutableArray<Diagnostic> diagnostics, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public GeneratorDriver WithUpdatedAnalyzerConfigOptions(Diagnostics.AnalyzerConfigOptionsProvider newOptions) { throw null; }
        public GeneratorDriver WithUpdatedParseOptions(ParseOptions newOptions) { throw null; }
    }
    public readonly partial struct GeneratorDriverOptions
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public readonly IncrementalGeneratorOutputKind DisabledOutputs;
        public readonly bool TrackIncrementalGeneratorSteps;
        public GeneratorDriverOptions(IncrementalGeneratorOutputKind disabledOutputs, bool trackIncrementalGeneratorSteps) { }
        public GeneratorDriverOptions(IncrementalGeneratorOutputKind disabledOutputs) { }
    }

    public partial class GeneratorDriverRunResult
    {
        internal GeneratorDriverRunResult() { }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Diagnostics { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<SyntaxTree> GeneratedTrees { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<GeneratorRunResult> Results { get { throw null; } }
    }
    public readonly partial struct GeneratorDriverTimingInfo
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.TimeSpan ElapsedTime { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<GeneratorTimingInfo> GeneratorTimes { get { throw null; } }
    }

    public readonly partial struct GeneratorExecutionContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Collections.Immutable.ImmutableArray<AdditionalText> AdditionalFiles { get { throw null; } }
        public Diagnostics.AnalyzerConfigOptionsProvider AnalyzerConfigOptions { get { throw null; } }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public ParseOptions ParseOptions { get { throw null; } }
        public ISyntaxContextReceiver? SyntaxContextReceiver { get { throw null; } }
        public ISyntaxReceiver? SyntaxReceiver { get { throw null; } }

        public readonly void AddSource(string hintName, Text.SourceText sourceText) { }
        public readonly void AddSource(string hintName, string source) { }
        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public static partial class GeneratorExtensions
    {
        public static IIncrementalGenerator AsIncrementalGenerator(this ISourceGenerator sourceGenerator) { throw null; }
        public static ISourceGenerator AsSourceGenerator(this IIncrementalGenerator incrementalGenerator) { throw null; }
        public static System.Type GetGeneratorType(this IIncrementalGenerator generator) { throw null; }
        public static System.Type GetGeneratorType(this ISourceGenerator generator) { throw null; }
    }
    public readonly partial struct GeneratorFilterContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public ISourceGenerator Generator { get { throw null; } }
    }

    public readonly partial struct GeneratorInitializationContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public readonly void RegisterForPostInitialization(System.Action<GeneratorPostInitializationContext> callback) { }
        public readonly void RegisterForSyntaxNotifications(SyntaxContextReceiverCreator receiverCreator) { }
        public readonly void RegisterForSyntaxNotifications(SyntaxReceiverCreator receiverCreator) { }
    }

    public readonly partial struct GeneratorPostInitializationContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public readonly void AddSource(string hintName, Text.SourceText sourceText) { }
        public readonly void AddSource(string hintName, string source) { }
    }

    public readonly partial struct GeneratorRunResult
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Diagnostics { get { throw null; } }
        public System.Exception? Exception { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<GeneratedSourceResult> GeneratedSources { get { throw null; } }
        public ISourceGenerator Generator { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL004", UrlFormat = "https://github.com/dotnet/roslyn/issues/74753")]
        public System.Collections.Immutable.ImmutableDictionary<string, object> HostOutputs { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<string, System.Collections.Immutable.ImmutableArray<IncrementalGeneratorRunStep>> TrackedOutputSteps { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<string, System.Collections.Immutable.ImmutableArray<IncrementalGeneratorRunStep>> TrackedSteps { get { throw null; } }
    }

    public readonly partial struct GeneratorSyntaxContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxNode Node { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }
    }

    public readonly partial struct GeneratorTimingInfo
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.TimeSpan ElapsedTime { get { throw null; } }
        public ISourceGenerator Generator { get { throw null; } }
    }

    [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL004", UrlFormat = "https://github.com/dotnet/roslyn/issues/74753")]
    public readonly partial struct HostOutputProductionContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public readonly void AddOutput(string name, object value) { }
    }

    public partial interface IAliasSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        INamespaceOrTypeSymbol Target { get; }
    }

    public partial interface IAnalyzerAssemblyLoader
    {
        void AddDependencyLocation(string fullPath);
        System.Reflection.Assembly LoadFromPath(string fullPath);
    }

    public partial interface IArrayTypeSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<CustomModifier> CustomModifiers { get; }

        NullableAnnotation ElementNullableAnnotation { get; }

        ITypeSymbol ElementType { get; }

        bool IsSZArray { get; }

        System.Collections.Immutable.ImmutableArray<int> LowerBounds { get; }

        int Rank { get; }

        System.Collections.Immutable.ImmutableArray<int> Sizes { get; }

        bool Equals(IArrayTypeSymbol? other);
    }

    public partial interface IAssemblySymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        INamespaceSymbol GlobalNamespace { get; }

        AssemblyIdentity Identity { get; }

        bool IsInteractive { get; }

        bool MightContainExtensionMethods { get; }

        System.Collections.Generic.IEnumerable<IModuleSymbol> Modules { get; }

        System.Collections.Generic.ICollection<string> NamespaceNames { get; }

        System.Collections.Generic.ICollection<string> TypeNames { get; }

        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> GetForwardedTypes();
        AssemblyMetadata? GetMetadata();
        INamedTypeSymbol? GetTypeByMetadataName(string fullyQualifiedMetadataName);
        bool GivesAccessTo(IAssemblySymbol toAssembly);
        INamedTypeSymbol? ResolveForwardedType(string fullyQualifiedMetadataName);
    }

    public partial interface ICompilationUnitSyntax
    {
        SyntaxToken EndOfFileToken { get; }
    }

    public partial interface IDiscardSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        NullableAnnotation NullableAnnotation { get; }

        ITypeSymbol Type { get; }
    }

    public partial interface IDynamicTypeSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
    }

    public partial interface IErrorTypeSymbol : INamedTypeSymbol, ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        CandidateReason CandidateReason { get; }

        System.Collections.Immutable.ImmutableArray<ISymbol> CandidateSymbols { get; }
    }

    public partial interface IEventSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        IMethodSymbol? AddMethod { get; }

        System.Collections.Immutable.ImmutableArray<IEventSymbol> ExplicitInterfaceImplementations { get; }

        bool IsWindowsRuntimeEvent { get; }

        NullableAnnotation NullableAnnotation { get; }

        IEventSymbol OriginalDefinition { get; }

        IEventSymbol? OverriddenEvent { get; }

        IMethodSymbol? RaiseMethod { get; }

        IMethodSymbol? RemoveMethod { get; }

        ITypeSymbol Type { get; }
    }

    public partial interface IFieldSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        ISymbol? AssociatedSymbol { get; }

        object? ConstantValue { get; }

        IFieldSymbol? CorrespondingTupleField { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> CustomModifiers { get; }

        int FixedSize { get; }

        [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "ConstantValue")]
        bool HasConstantValue { get; }

        bool IsConst { get; }

        bool IsExplicitlyNamedTupleElement { get; }

        bool IsFixedSizeBuffer { get; }

        bool IsReadOnly { get; }

        bool IsRequired { get; }

        bool IsVolatile { get; }

        NullableAnnotation NullableAnnotation { get; }

        IFieldSymbol OriginalDefinition { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> RefCustomModifiers { get; }

        RefKind RefKind { get; }

        ITypeSymbol Type { get; }
    }

    public partial interface IFunctionPointerTypeSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        IMethodSymbol Signature { get; }
    }

    public partial interface IImportScope
    {
        System.Collections.Immutable.ImmutableArray<IAliasSymbol> Aliases { get; }

        System.Collections.Immutable.ImmutableArray<IAliasSymbol> ExternAliases { get; }

        System.Collections.Immutable.ImmutableArray<ImportedNamespaceOrType> Imports { get; }

        System.Collections.Immutable.ImmutableArray<ImportedXmlNamespace> XmlNamespaces { get; }
    }

    public partial interface IIncrementalGenerator
    {
        void Initialize(IncrementalGeneratorInitializationContext context);
    }

    public partial interface ILabelSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        IMethodSymbol ContainingMethod { get; }
    }

    public partial interface ILocalSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        object? ConstantValue { get; }

        bool HasConstantValue { get; }

        bool IsConst { get; }

        bool IsFixed { get; }

        bool IsForEach { get; }

        bool IsFunctionValue { get; }

        bool IsRef { get; }

        bool IsUsing { get; }

        NullableAnnotation NullableAnnotation { get; }

        RefKind RefKind { get; }

        ScopedKind ScopedKind { get; }

        ITypeSymbol Type { get; }
    }

    public partial interface IMethodSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        int Arity { get; }

        INamedTypeSymbol? AssociatedAnonymousDelegate { get; }

        ISymbol? AssociatedSymbol { get; }

        System.Reflection.Metadata.SignatureCallingConvention CallingConvention { get; }

        IMethodSymbol ConstructedFrom { get; }

        System.Collections.Immutable.ImmutableArray<IMethodSymbol> ExplicitInterfaceImplementations { get; }

        bool HidesBaseMethodsByName { get; }

        bool IsAsync { get; }

        bool IsCheckedBuiltin { get; }

        bool IsConditional { get; }

        bool IsExtensionMethod { get; }

        bool IsGenericMethod { get; }

        bool IsInitOnly { get; }

        bool IsPartialDefinition { get; }

        bool IsReadOnly { get; }

        bool IsVararg { get; }

        System.Reflection.MethodImplAttributes MethodImplementationFlags { get; }

        MethodKind MethodKind { get; }

        IMethodSymbol OriginalDefinition { get; }

        IMethodSymbol? OverriddenMethod { get; }

        System.Collections.Immutable.ImmutableArray<IParameterSymbol> Parameters { get; }

        IMethodSymbol? PartialDefinitionPart { get; }

        IMethodSymbol? PartialImplementationPart { get; }

        NullableAnnotation ReceiverNullableAnnotation { get; }

        ITypeSymbol? ReceiverType { get; }

        IMethodSymbol? ReducedFrom { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> RefCustomModifiers { get; }

        RefKind RefKind { get; }

        NullableAnnotation ReturnNullableAnnotation { get; }

        bool ReturnsByRef { get; }

        bool ReturnsByRefReadonly { get; }

        bool ReturnsVoid { get; }

        ITypeSymbol ReturnType { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> ReturnTypeCustomModifiers { get; }

        System.Collections.Immutable.ImmutableArray<NullableAnnotation> TypeArgumentNullableAnnotations { get; }

        System.Collections.Immutable.ImmutableArray<ITypeSymbol> TypeArguments { get; }

        System.Collections.Immutable.ImmutableArray<ITypeParameterSymbol> TypeParameters { get; }

        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> UnmanagedCallingConventionTypes { get; }

        IMethodSymbol Construct(params ITypeSymbol[] typeArguments);
        IMethodSymbol Construct(System.Collections.Immutable.ImmutableArray<ITypeSymbol> typeArguments, System.Collections.Immutable.ImmutableArray<NullableAnnotation> typeArgumentNullableAnnotations);
        DllImportData? GetDllImportData();
        System.Collections.Immutable.ImmutableArray<AttributeData> GetReturnTypeAttributes();
        ITypeSymbol? GetTypeInferredDuringReduction(ITypeParameterSymbol reducedFromTypeParameter);
        IMethodSymbol? ReduceExtensionMethod(ITypeSymbol receiverType);
    }

    public partial interface IModuleSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        INamespaceSymbol GlobalNamespace { get; }

        System.Collections.Immutable.ImmutableArray<AssemblyIdentity> ReferencedAssemblies { get; }

        System.Collections.Immutable.ImmutableArray<IAssemblySymbol> ReferencedAssemblySymbols { get; }

        ModuleMetadata? GetMetadata();
        INamespaceSymbol? GetModuleNamespace(INamespaceSymbol namespaceSymbol);
    }

    public readonly partial struct ImportedNamespaceOrType
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxReference? DeclaringSyntaxReference { get { throw null; } }
        public INamespaceOrTypeSymbol NamespaceOrType { get { throw null; } }
    }

    public readonly partial struct ImportedXmlNamespace
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxReference? DeclaringSyntaxReference { get { throw null; } }
        public string XmlNamespace { get { throw null; } }
    }

    public partial interface INamedTypeSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        int Arity { get; }

        ISymbol? AssociatedSymbol { get; }

        INamedTypeSymbol ConstructedFrom { get; }

        System.Collections.Immutable.ImmutableArray<IMethodSymbol> Constructors { get; }

        IMethodSymbol? DelegateInvokeMethod { get; }

        INamedTypeSymbol? EnumUnderlyingType { get; }

        System.Collections.Immutable.ImmutableArray<IMethodSymbol> InstanceConstructors { get; }

        bool IsComImport { get; }

        bool IsFileLocal { get; }

        bool IsGenericType { get; }

        bool IsImplicitClass { get; }

        bool IsScriptClass { get; }

        bool IsSerializable { get; }

        bool IsUnboundGenericType { get; }

        System.Collections.Generic.IEnumerable<string> MemberNames { get; }

        bool MightContainExtensionMethods { get; }

        INamedTypeSymbol? NativeIntegerUnderlyingType { get; }

        INamedTypeSymbol OriginalDefinition { get; }

        System.Collections.Immutable.ImmutableArray<IMethodSymbol> StaticConstructors { get; }

        System.Collections.Immutable.ImmutableArray<IFieldSymbol> TupleElements { get; }

        INamedTypeSymbol? TupleUnderlyingType { get; }

        System.Collections.Immutable.ImmutableArray<NullableAnnotation> TypeArgumentNullableAnnotations { get; }

        System.Collections.Immutable.ImmutableArray<ITypeSymbol> TypeArguments { get; }

        System.Collections.Immutable.ImmutableArray<ITypeParameterSymbol> TypeParameters { get; }

        INamedTypeSymbol Construct(params ITypeSymbol[] typeArguments);
        INamedTypeSymbol Construct(System.Collections.Immutable.ImmutableArray<ITypeSymbol> typeArguments, System.Collections.Immutable.ImmutableArray<NullableAnnotation> typeArgumentNullableAnnotations);
        INamedTypeSymbol ConstructUnboundGenericType();
        System.Collections.Immutable.ImmutableArray<CustomModifier> GetTypeArgumentCustomModifiers(int ordinal);
    }

    public partial interface INamespaceOrTypeSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        bool IsNamespace { get; }

        bool IsType { get; }

        System.Collections.Immutable.ImmutableArray<ISymbol> GetMembers();
        System.Collections.Immutable.ImmutableArray<ISymbol> GetMembers(string name);
        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> GetTypeMembers();
        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> GetTypeMembers(string name, int arity);
        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> GetTypeMembers(string name);
    }

    public partial interface INamespaceSymbol : INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<INamespaceSymbol> ConstituentNamespaces { get; }

        Compilation? ContainingCompilation { get; }

        bool IsGlobalNamespace { get; }

        NamespaceKind NamespaceKind { get; }

        System.Collections.Generic.IEnumerable<INamespaceOrTypeSymbol> GetMembers();
        System.Collections.Generic.IEnumerable<INamespaceOrTypeSymbol> GetMembers(string name);
        System.Collections.Generic.IEnumerable<INamespaceSymbol> GetNamespaceMembers();
    }

    public readonly partial struct IncrementalGeneratorInitializationContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public IncrementalValuesProvider<AdditionalText> AdditionalTextsProvider { get { throw null; } }
        public IncrementalValueProvider<Diagnostics.AnalyzerConfigOptionsProvider> AnalyzerConfigOptionsProvider { get { throw null; } }
        public IncrementalValueProvider<Compilation> CompilationProvider { get { throw null; } }
        public IncrementalValuesProvider<MetadataReference> MetadataReferencesProvider { get { throw null; } }
        public IncrementalValueProvider<ParseOptions> ParseOptionsProvider { get { throw null; } }
        public SyntaxValueProvider SyntaxProvider { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL004", UrlFormat = "https://github.com/dotnet/roslyn/issues/74753")]
        public readonly void RegisterHostOutput<TSource>(IncrementalValueProvider<TSource> source, System.Action<HostOutputProductionContext, TSource> action) { }
        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL004", UrlFormat = "https://github.com/dotnet/roslyn/issues/74753")]
        public readonly void RegisterHostOutput<TSource>(IncrementalValuesProvider<TSource> source, System.Action<HostOutputProductionContext, TSource> action) { }
        public readonly void RegisterImplementationSourceOutput<TSource>(IncrementalValueProvider<TSource> source, System.Action<SourceProductionContext, TSource> action) { }
        public readonly void RegisterImplementationSourceOutput<TSource>(IncrementalValuesProvider<TSource> source, System.Action<SourceProductionContext, TSource> action) { }
        public readonly void RegisterPostInitializationOutput(System.Action<IncrementalGeneratorPostInitializationContext> callback) { }
        public readonly void RegisterSourceOutput<TSource>(IncrementalValueProvider<TSource> source, System.Action<SourceProductionContext, TSource> action) { }
        public readonly void RegisterSourceOutput<TSource>(IncrementalValuesProvider<TSource> source, System.Action<SourceProductionContext, TSource> action) { }
    }

    [System.Flags]
    public enum IncrementalGeneratorOutputKind
    {
        None = 0,
        Source = 1,
        PostInit = 2,
        Implementation = 4,
        Host = 8
    }

    public readonly partial struct IncrementalGeneratorPostInitializationContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public readonly void AddSource(string hintName, Text.SourceText sourceText) { }
        public readonly void AddSource(string hintName, string source) { }
    }

    public sealed partial class IncrementalGeneratorRunStep
    {
        internal IncrementalGeneratorRunStep() { }
        public System.TimeSpan ElapsedTime { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<(IncrementalGeneratorRunStep Source, int OutputIndex)> Inputs { get { throw null; } }
        public string? Name { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<(object Value, IncrementalStepRunReason Reason)> Outputs { get { throw null; } }
    }
    public enum IncrementalStepRunReason
    {
        New = 0,
        Modified = 1,
        Unchanged = 2,
        Cached = 3,
        Removed = 4
    }

    public static partial class IncrementalValueProviderExtensions
    {
        public static IncrementalValueProvider<System.Collections.Immutable.ImmutableArray<TSource>> Collect<TSource>(this IncrementalValuesProvider<TSource> source) { throw null; }
        public static IncrementalValueProvider<(TLeft Left, TRight Right)> Combine<TLeft, TRight>(this IncrementalValueProvider<TLeft> provider1, IncrementalValueProvider<TRight> provider2) { throw null; }
        public static IncrementalValuesProvider<(TLeft Left, TRight Right)> Combine<TLeft, TRight>(this IncrementalValuesProvider<TLeft> provider1, IncrementalValueProvider<TRight> provider2) { throw null; }
        public static IncrementalValueProvider<TResult> Select<TSource, TResult>(this IncrementalValueProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, TResult> selector) { throw null; }
        public static IncrementalValuesProvider<TResult> Select<TSource, TResult>(this IncrementalValuesProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, TResult> selector) { throw null; }
        public static IncrementalValuesProvider<TResult> SelectMany<TSource, TResult>(this IncrementalValueProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, System.Collections.Generic.IEnumerable<TResult>> selector) { throw null; }
        public static IncrementalValuesProvider<TResult> SelectMany<TSource, TResult>(this IncrementalValueProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, System.Collections.Immutable.ImmutableArray<TResult>> selector) { throw null; }
        public static IncrementalValuesProvider<TResult> SelectMany<TSource, TResult>(this IncrementalValuesProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, System.Collections.Generic.IEnumerable<TResult>> selector) { throw null; }
        public static IncrementalValuesProvider<TResult> SelectMany<TSource, TResult>(this IncrementalValuesProvider<TSource> source, System.Func<TSource, System.Threading.CancellationToken, System.Collections.Immutable.ImmutableArray<TResult>> selector) { throw null; }
        public static IncrementalValuesProvider<TSource> Where<TSource>(this IncrementalValuesProvider<TSource> source, System.Func<TSource, bool> predicate) { throw null; }
        public static IncrementalValueProvider<TSource> WithComparer<TSource>(this IncrementalValueProvider<TSource> source, System.Collections.Generic.IEqualityComparer<TSource> comparer) { throw null; }
        public static IncrementalValuesProvider<TSource> WithComparer<TSource>(this IncrementalValuesProvider<TSource> source, System.Collections.Generic.IEqualityComparer<TSource> comparer) { throw null; }
        public static IncrementalValueProvider<TSource> WithTrackingName<TSource>(this IncrementalValueProvider<TSource> source, string name) { throw null; }
        public static IncrementalValuesProvider<TSource> WithTrackingName<TSource>(this IncrementalValuesProvider<TSource> source, string name) { throw null; }
    }
    public readonly partial struct IncrementalValueProvider<TValue>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
    }

    public readonly partial struct IncrementalValuesProvider<TValues>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
    }

    public partial interface IOperation
    {
        OperationList ChildOperations { get; }

        [System.Obsolete("This API has performance penalties, please use ChildOperations instead.", false)]
        System.Collections.Generic.IEnumerable<IOperation> Children { get; }

        Optional<object?> ConstantValue { get; }

        bool IsImplicit { get; }

        OperationKind Kind { get; }

        string Language { get; }

        IOperation? Parent { get; }

        SemanticModel? SemanticModel { get; }

        SyntaxNode Syntax { get; }

        ITypeSymbol? Type { get; }

        void Accept(Operations.OperationVisitor visitor);
        TResult? Accept<TArgument, TResult>(Operations.OperationVisitor<TArgument, TResult> visitor, TArgument argument);
        public readonly partial struct OperationList : System.Collections.Generic.IReadOnlyCollection<IOperation>, System.Collections.Generic.IEnumerable<IOperation>, System.Collections.IEnumerable
        {
            private readonly object _dummy;
            private readonly int _dummyPrimitive;
            public int Count { get { throw null; } }

            public readonly bool Any() { throw null; }
            public readonly IOperation First() { throw null; }
            public readonly Enumerator GetEnumerator() { throw null; }
            public readonly IOperation Last() { throw null; }
            public readonly Reversed Reverse() { throw null; }
            readonly System.Collections.Generic.IEnumerator<IOperation> System.Collections.Generic.IEnumerable<IOperation>.GetEnumerator() { throw null; }
            readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
            public readonly System.Collections.Immutable.ImmutableArray<IOperation> ToImmutableArray() { throw null; }
            public partial struct Enumerator
            {
                private object _dummy;
                private int _dummyPrimitive;
                public IOperation Current { get { throw null; } }

                public bool MoveNext() { throw null; }
                public void Reset() { }
            }

            public readonly partial struct Reversed : System.Collections.Generic.IReadOnlyCollection<IOperation>, System.Collections.Generic.IEnumerable<IOperation>, System.Collections.IEnumerable
            {
                private readonly object _dummy;
                private readonly int _dummyPrimitive;
                public int Count { get { throw null; } }

                public readonly Enumerator GetEnumerator() { throw null; }
                readonly System.Collections.Generic.IEnumerator<IOperation> System.Collections.Generic.IEnumerable<IOperation>.GetEnumerator() { throw null; }
                readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
                public readonly System.Collections.Immutable.ImmutableArray<IOperation> ToImmutableArray() { throw null; }
                public partial struct Enumerator
                {
                    private object _dummy;
                    private int _dummyPrimitive;
                    public IOperation Current { get { throw null; } }

                    public bool MoveNext() { throw null; }
                    public void Reset() { }
                }
            }
        }
    }

    public partial interface IParameterSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<CustomModifier> CustomModifiers { get; }

        object? ExplicitDefaultValue { get; }

        bool HasExplicitDefaultValue { get; }

        bool IsDiscard { get; }

        bool IsOptional { get; }

        bool IsParams { get; }

        bool IsParamsArray { get; }

        bool IsParamsCollection { get; }

        bool IsThis { get; }

        NullableAnnotation NullableAnnotation { get; }

        int Ordinal { get; }

        IParameterSymbol OriginalDefinition { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> RefCustomModifiers { get; }

        RefKind RefKind { get; }

        ScopedKind ScopedKind { get; }

        ITypeSymbol Type { get; }
    }

    public partial interface IPointerTypeSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<CustomModifier> CustomModifiers { get; }

        ITypeSymbol PointedAtType { get; }
    }

    public partial interface IPreprocessingSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
    }

    public partial interface IPropertySymbol : ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<IPropertySymbol> ExplicitInterfaceImplementations { get; }

        IMethodSymbol? GetMethod { get; }

        bool IsIndexer { get; }

        bool IsPartialDefinition { get; }

        bool IsReadOnly { get; }

        bool IsRequired { get; }

        bool IsWithEvents { get; }

        bool IsWriteOnly { get; }

        NullableAnnotation NullableAnnotation { get; }

        IPropertySymbol OriginalDefinition { get; }

        IPropertySymbol? OverriddenProperty { get; }

        System.Collections.Immutable.ImmutableArray<IParameterSymbol> Parameters { get; }

        IPropertySymbol? PartialDefinitionPart { get; }

        IPropertySymbol? PartialImplementationPart { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> RefCustomModifiers { get; }

        RefKind RefKind { get; }

        bool ReturnsByRef { get; }

        bool ReturnsByRefReadonly { get; }

        IMethodSymbol? SetMethod { get; }

        ITypeSymbol Type { get; }

        System.Collections.Immutable.ImmutableArray<CustomModifier> TypeCustomModifiers { get; }
    }

    public partial interface IRangeVariableSymbol : ISymbol, System.IEquatable<ISymbol?>
    {
    }

    public partial interface ISkippedTokensTriviaSyntax
    {
        SyntaxTokenList Tokens { get; }
    }

    public partial interface ISourceAssemblySymbol : IAssemblySymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        Compilation Compilation { get; }
    }

    public partial interface ISourceGenerator
    {
        void Execute(GeneratorExecutionContext context);
        void Initialize(GeneratorInitializationContext context);
    }

    public partial interface IStructuredTriviaSyntax
    {
        SyntaxTrivia ParentTrivia { get; }
    }

    public partial interface ISymbol : System.IEquatable<ISymbol?>
    {
        bool CanBeReferencedByName { get; }

        IAssemblySymbol ContainingAssembly { get; }

        IModuleSymbol ContainingModule { get; }

        INamespaceSymbol ContainingNamespace { get; }

        ISymbol ContainingSymbol { get; }

        INamedTypeSymbol ContainingType { get; }

        Accessibility DeclaredAccessibility { get; }

        System.Collections.Immutable.ImmutableArray<SyntaxReference> DeclaringSyntaxReferences { get; }

        bool HasUnsupportedMetadata { get; }

        bool IsAbstract { get; }

        bool IsDefinition { get; }

        bool IsExtern { get; }

        bool IsImplicitlyDeclared { get; }

        bool IsOverride { get; }

        bool IsSealed { get; }

        bool IsStatic { get; }

        bool IsVirtual { get; }

        SymbolKind Kind { get; }

        string Language { get; }

        System.Collections.Immutable.ImmutableArray<Location> Locations { get; }

        string MetadataName { get; }

        int MetadataToken { get; }

        string Name { get; }

        ISymbol OriginalDefinition { get; }

        void Accept(SymbolVisitor visitor);
        TResult? Accept<TResult>(SymbolVisitor<TResult> visitor);
        TResult Accept<TArgument, TResult>(SymbolVisitor<TArgument, TResult> visitor, TArgument argument);
        bool Equals(ISymbol? other, SymbolEqualityComparer equalityComparer);
        System.Collections.Immutable.ImmutableArray<AttributeData> GetAttributes();
        string? GetDocumentationCommentId();
        string? GetDocumentationCommentXml(System.Globalization.CultureInfo? preferredCulture = null, bool expandIncludes = false, System.Threading.CancellationToken cancellationToken = default);
        System.Collections.Immutable.ImmutableArray<SymbolDisplayPart> ToDisplayParts(SymbolDisplayFormat? format = null);
        string ToDisplayString(SymbolDisplayFormat? format = null);
        System.Collections.Immutable.ImmutableArray<SymbolDisplayPart> ToMinimalDisplayParts(SemanticModel semanticModel, int position, SymbolDisplayFormat? format = null);
        string ToMinimalDisplayString(SemanticModel semanticModel, int position, SymbolDisplayFormat? format = null);
    }

    public static partial class ISymbolExtensions
    {
        public static IMethodSymbol? GetConstructedReducedFrom(this IMethodSymbol method) { throw null; }
    }
    public partial interface ISyntaxContextReceiver
    {
        void OnVisitSyntaxNode(GeneratorSyntaxContext context);
    }

    public partial interface ISyntaxReceiver
    {
        void OnVisitSyntaxNode(SyntaxNode syntaxNode);
    }

    public partial interface ITypeParameterSymbol : ITypeSymbol, INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        bool AllowsRefLikeType { get; }

        System.Collections.Immutable.ImmutableArray<NullableAnnotation> ConstraintNullableAnnotations { get; }

        System.Collections.Immutable.ImmutableArray<ITypeSymbol> ConstraintTypes { get; }

        IMethodSymbol? DeclaringMethod { get; }

        INamedTypeSymbol? DeclaringType { get; }

        bool HasConstructorConstraint { get; }

        bool HasNotNullConstraint { get; }

        bool HasReferenceTypeConstraint { get; }

        bool HasUnmanagedTypeConstraint { get; }

        bool HasValueTypeConstraint { get; }

        int Ordinal { get; }

        ITypeParameterSymbol OriginalDefinition { get; }

        ITypeParameterSymbol? ReducedFrom { get; }

        NullableAnnotation ReferenceTypeConstraintNullableAnnotation { get; }

        TypeParameterKind TypeParameterKind { get; }

        VarianceKind Variance { get; }
    }

    public partial interface ITypeSymbol : INamespaceOrTypeSymbol, ISymbol, System.IEquatable<ISymbol?>
    {
        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> AllInterfaces { get; }

        INamedTypeSymbol? BaseType { get; }

        System.Collections.Immutable.ImmutableArray<INamedTypeSymbol> Interfaces { get; }

        bool IsAnonymousType { get; }

        bool IsNativeIntegerType { get; }

        bool IsReadOnly { get; }

        bool IsRecord { get; }

        bool IsReferenceType { get; }

        bool IsRefLikeType { get; }

        bool IsTupleType { get; }

        bool IsUnmanagedType { get; }

        bool IsValueType { get; }

        NullableAnnotation NullableAnnotation { get; }

        ITypeSymbol OriginalDefinition { get; }

        SpecialType SpecialType { get; }

        TypeKind TypeKind { get; }

        ISymbol? FindImplementationForInterfaceMember(ISymbol interfaceMember);
        System.Collections.Immutable.ImmutableArray<SymbolDisplayPart> ToDisplayParts(NullableFlowState topLevelNullability, SymbolDisplayFormat? format = null);
        string ToDisplayString(NullableFlowState topLevelNullability, SymbolDisplayFormat? format = null);
        System.Collections.Immutable.ImmutableArray<SymbolDisplayPart> ToMinimalDisplayParts(SemanticModel semanticModel, NullableFlowState topLevelNullability, int position, SymbolDisplayFormat? format = null);
        string ToMinimalDisplayString(SemanticModel semanticModel, NullableFlowState topLevelNullability, int position, SymbolDisplayFormat? format = null);
        ITypeSymbol WithNullableAnnotation(NullableAnnotation nullableAnnotation);
    }

    public static partial class LanguageNames
    {
        public const string CSharp = "C#";
        public const string FSharp = "F#";
        public const string VisualBasic = "Visual Basic";
    }
    public readonly partial struct LineMapping : System.IEquatable<LineMapping>
    {
        private readonly int _dummyPrimitive;
        public LineMapping(Text.LinePositionSpan span, int? characterOffset, FileLinePositionSpan mappedSpan) { }
        public int? CharacterOffset { get { throw null; } }
        public bool IsHidden { get { throw null; } }
        public FileLinePositionSpan MappedSpan { get { throw null; } }
        public Text.LinePositionSpan Span { get { throw null; } }

        public readonly bool Equals(LineMapping other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(LineMapping left, LineMapping right) { throw null; }
        public static bool operator !=(LineMapping left, LineMapping right) { throw null; }
        public override readonly string? ToString() { throw null; }
    }

    public enum LineVisibility
    {
        BeforeFirstLineDirective = 0,
        Hidden = 1,
        Visible = 2
    }

    public sealed partial class LocalizableResourceString : LocalizableString
    {
        public LocalizableResourceString(string nameOfLocalizableResource, System.Resources.ResourceManager resourceManager, System.Type resourceSource, params string[] formatArguments) { }
        public LocalizableResourceString(string nameOfLocalizableResource, System.Resources.ResourceManager resourceManager, System.Type resourceSource) { }
        protected override bool AreEqual(object? other) { throw null; }
        protected override int GetHash() { throw null; }
        protected override string GetText(System.IFormatProvider? formatProvider) { throw null; }
    }

    public abstract partial class LocalizableString : System.IFormattable, System.IEquatable<LocalizableString?>
    {
        public event System.EventHandler<System.Exception>? OnException {
            add { }
            remove { }
        }

        protected abstract bool AreEqual(object? other);
        public bool Equals(LocalizableString? other) { throw null; }
        public sealed override bool Equals(object? other) { throw null; }
        protected abstract int GetHash();
        public sealed override int GetHashCode() { throw null; }
        protected abstract string GetText(System.IFormatProvider? formatProvider);
        public static explicit operator string?(LocalizableString localizableResource) { throw null; }
        public static implicit operator LocalizableString(string? fixedResource) { throw null; }
        string System.IFormattable.ToString(string? ignored, System.IFormatProvider? formatProvider) { throw null; }
        public sealed override string ToString() { throw null; }
        public string ToString(System.IFormatProvider? formatProvider) { throw null; }
    }

    public abstract partial class Location
    {
        internal Location() { }
        public bool IsInMetadata { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "SourceTree")]
        public bool IsInSource { get { throw null; } }
        public abstract LocationKind Kind { get; }
        public IModuleSymbol? MetadataModule { get { throw null; } }
        public static Location None { get { throw null; } }
        public virtual Text.TextSpan SourceSpan { get { throw null; } }
        public virtual SyntaxTree? SourceTree { get { throw null; } }

        public static Location Create(SyntaxTree syntaxTree, Text.TextSpan textSpan) { throw null; }
        public static Location Create(string filePath, Text.TextSpan textSpan, Text.LinePositionSpan lineSpan, string mappedFilePath, Text.LinePositionSpan mappedLineSpan) { throw null; }
        public static Location Create(string filePath, Text.TextSpan textSpan, Text.LinePositionSpan lineSpan) { throw null; }
        public abstract override bool Equals(object? obj);
        protected virtual string GetDebuggerDisplay() { throw null; }
        public abstract override int GetHashCode();
        public virtual FileLinePositionSpan GetLineSpan() { throw null; }
        public virtual FileLinePositionSpan GetMappedLineSpan() { throw null; }
        public static bool operator ==(Location? left, Location? right) { throw null; }
        public static bool operator !=(Location? left, Location? right) { throw null; }
        public override string ToString() { throw null; }
    }
    public enum LocationKind : byte
    {
        None = 0,
        SourceFile = 1,
        MetadataFile = 2,
        XmlFile = 3,
        ExternalFile = 4
    }

    public abstract partial class Metadata : System.IDisposable
    {
        internal Metadata() { }
        public MetadataId Id { get { throw null; } }
        public abstract MetadataImageKind Kind { get; }

        protected abstract Metadata CommonCopy();
        public Metadata Copy() { throw null; }
        public abstract void Dispose();
    }

    public sealed partial class MetadataId
    {
        internal MetadataId() { }
    }
    public enum MetadataImageKind : byte
    {
        Assembly = 0,
        Module = 1
    }

    public enum MetadataImportOptions : byte
    {
        Public = 0,
        Internal = 1,
        All = 2
    }

    public abstract partial class MetadataReference
    {
        protected MetadataReference(MetadataReferenceProperties properties) { }
        public virtual string? Display { get { throw null; } }
        public MetadataReferenceProperties Properties { get { throw null; } }

        [System.Obsolete("Use CreateFromFile(assembly.Location) instead", true)]
        public static MetadataReference CreateFromAssembly(System.Reflection.Assembly assembly, MetadataReferenceProperties properties, DocumentationProvider? documentation = null) { throw null; }
        [System.Obsolete("Use CreateFromFile(assembly.Location) instead", true)]
        public static MetadataReference CreateFromAssembly(System.Reflection.Assembly assembly) { throw null; }
        public static PortableExecutableReference CreateFromFile(string path, MetadataReferenceProperties properties = default, DocumentationProvider? documentation = null) { throw null; }
        public static PortableExecutableReference CreateFromImage(System.Collections.Generic.IEnumerable<byte> peImage, MetadataReferenceProperties properties = default, DocumentationProvider? documentation = null, string? filePath = null) { throw null; }
        public static PortableExecutableReference CreateFromImage(System.Collections.Immutable.ImmutableArray<byte> peImage, MetadataReferenceProperties properties = default, DocumentationProvider? documentation = null, string? filePath = null) { throw null; }
        public static PortableExecutableReference CreateFromStream(System.IO.Stream peStream, MetadataReferenceProperties properties = default, DocumentationProvider? documentation = null, string? filePath = null) { throw null; }
        public MetadataReference WithAliases(System.Collections.Generic.IEnumerable<string> aliases) { throw null; }
        public MetadataReference WithAliases(System.Collections.Immutable.ImmutableArray<string> aliases) { throw null; }
        public MetadataReference WithEmbedInteropTypes(bool value) { throw null; }
        public MetadataReference WithProperties(MetadataReferenceProperties properties) { throw null; }
    }
    public partial struct MetadataReferenceProperties : System.IEquatable<MetadataReferenceProperties>
    {
        private object _dummy;
        private int _dummyPrimitive;
        public MetadataReferenceProperties(MetadataImageKind kind = MetadataImageKind.Assembly, System.Collections.Immutable.ImmutableArray<string> aliases = default, bool embedInteropTypes = false) { }
        public System.Collections.Immutable.ImmutableArray<string> Aliases { get { throw null; } }
        public static MetadataReferenceProperties Assembly { get { throw null; } }
        public bool EmbedInteropTypes { get { throw null; } }
        public static string GlobalAlias { get { throw null; } }
        public MetadataImageKind Kind { get { throw null; } }
        public static MetadataReferenceProperties Module { get { throw null; } }

        public bool Equals(MetadataReferenceProperties other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(MetadataReferenceProperties left, MetadataReferenceProperties right) { throw null; }
        public static bool operator !=(MetadataReferenceProperties left, MetadataReferenceProperties right) { throw null; }
        public MetadataReferenceProperties WithAliases(System.Collections.Generic.IEnumerable<string> aliases) { throw null; }
        public MetadataReferenceProperties WithAliases(System.Collections.Immutable.ImmutableArray<string> aliases) { throw null; }
        public MetadataReferenceProperties WithEmbedInteropTypes(bool embedInteropTypes) { throw null; }
    }

    public abstract partial class MetadataReferenceResolver
    {
        public virtual bool ResolveMissingAssemblies { get { throw null; } }

        public abstract override bool Equals(object? other);
        public abstract override int GetHashCode();
        public virtual PortableExecutableReference? ResolveMissingAssembly(MetadataReference definition, AssemblyIdentity referenceIdentity) { throw null; }
        public abstract System.Collections.Immutable.ImmutableArray<PortableExecutableReference> ResolveReference(string reference, string? baseFilePath, MetadataReferenceProperties properties);
    }
    public enum MethodKind
    {
        AnonymousFunction = 0,
        LambdaMethod = 0,
        Constructor = 1,
        Conversion = 2,
        DelegateInvoke = 3,
        Destructor = 4,
        EventAdd = 5,
        EventRaise = 6,
        EventRemove = 7,
        ExplicitInterfaceImplementation = 8,
        UserDefinedOperator = 9,
        Ordinary = 10,
        PropertyGet = 11,
        PropertySet = 12,
        ReducedExtension = 13,
        SharedConstructor = 14,
        StaticConstructor = 14,
        BuiltinOperator = 15,
        DeclareMethod = 16,
        LocalFunction = 17,
        FunctionPointerSignature = 18
    }

    public static partial class ModelExtensions
    {
        public static ControlFlowAnalysis AnalyzeControlFlow(this SemanticModel semanticModel, SyntaxNode firstStatement, SyntaxNode lastStatement) { throw null; }
        public static ControlFlowAnalysis AnalyzeControlFlow(this SemanticModel semanticModel, SyntaxNode statement) { throw null; }
        public static DataFlowAnalysis AnalyzeDataFlow(this SemanticModel semanticModel, SyntaxNode firstStatement, SyntaxNode lastStatement) { throw null; }
        public static DataFlowAnalysis AnalyzeDataFlow(this SemanticModel semanticModel, SyntaxNode statementOrExpression) { throw null; }
        public static IAliasSymbol? GetAliasInfo(this SemanticModel semanticModel, SyntaxNode nameSyntax, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ISymbol? GetDeclaredSymbol(this SemanticModel semanticModel, SyntaxNode declaration, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<ISymbol> GetMemberGroup(this SemanticModel semanticModel, SyntaxNode node, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static IAliasSymbol? GetSpeculativeAliasInfo(this SemanticModel semanticModel, int position, SyntaxNode nameSyntax, SpeculativeBindingOption bindingOption) { throw null; }
        public static SymbolInfo GetSpeculativeSymbolInfo(this SemanticModel semanticModel, int position, SyntaxNode expression, SpeculativeBindingOption bindingOption) { throw null; }
        public static TypeInfo GetSpeculativeTypeInfo(this SemanticModel semanticModel, int position, SyntaxNode expression, SpeculativeBindingOption bindingOption) { throw null; }
        public static SymbolInfo GetSymbolInfo(this SemanticModel semanticModel, SyntaxNode node, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static TypeInfo GetTypeInfo(this SemanticModel semanticModel, SyntaxNode node, System.Threading.CancellationToken cancellationToken = default) { throw null; }
    }
    public sealed partial class ModuleMetadata : Metadata
    {
        internal ModuleMetadata() { }
        public bool IsDisposed { get { throw null; } }
        public override MetadataImageKind Kind { get { throw null; } }
        public string Name { get { throw null; } }

        protected override Metadata CommonCopy() { throw null; }
        public static ModuleMetadata CreateFromFile(string path) { throw null; }
        public static ModuleMetadata CreateFromImage(System.Collections.Generic.IEnumerable<byte> peImage) { throw null; }
        public static ModuleMetadata CreateFromImage(System.Collections.Immutable.ImmutableArray<byte> peImage) { throw null; }
        public static ModuleMetadata CreateFromImage(nint peImage, int size) { throw null; }
        public static ModuleMetadata CreateFromMetadata(nint metadata, int size, System.Action onDispose) { throw null; }
        public static ModuleMetadata CreateFromMetadata(nint metadata, int size) { throw null; }
        public static ModuleMetadata CreateFromStream(System.IO.Stream peStream, bool leaveOpen = false) { throw null; }
        public static ModuleMetadata CreateFromStream(System.IO.Stream peStream, System.Reflection.PortableExecutable.PEStreamOptions options) { throw null; }
        public override void Dispose() { }
        public System.Reflection.Metadata.MetadataReader GetMetadataReader() { throw null; }
        public System.Collections.Immutable.ImmutableArray<string> GetModuleNames() { throw null; }
        public System.Guid GetModuleVersionId() { throw null; }
        public PortableExecutableReference GetReference(DocumentationProvider? documentation = null, string? filePath = null, string? display = null) { throw null; }
    }

    public enum NamespaceKind
    {
        Module = 1,
        Assembly = 2,
        Compilation = 3
    }

    public readonly partial struct NullabilityInfo : System.IEquatable<NullabilityInfo>
    {
        private readonly int _dummyPrimitive;
        public NullableAnnotation Annotation { get { throw null; } }
        public NullableFlowState FlowState { get { throw null; } }

        public readonly bool Equals(NullabilityInfo other) { throw null; }
        public override readonly bool Equals(object? other) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public enum NullableAnnotation : byte
    {
        None = 0,
        NotAnnotated = 1,
        Annotated = 2
    }

    [System.Flags]
    public enum NullableContext
    {
        Disabled = 0,
        WarningsEnabled = 1,
        AnnotationsEnabled = 2,
        Enabled = 3,
        WarningsContextInherited = 4,
        AnnotationsContextInherited = 8,
        ContextInherited = 12
    }

    public static partial class NullableContextExtensions
    {
        public static bool AnnotationsEnabled(this NullableContext context) { throw null; }
        public static bool AnnotationsInherited(this NullableContext context) { throw null; }
        public static bool WarningsEnabled(this NullableContext context) { throw null; }
        public static bool WarningsInherited(this NullableContext context) { throw null; }
    }
    [System.Flags]
    public enum NullableContextOptions
    {
        Disable = 0,
        Warnings = 1,
        Annotations = 2,
        Enable = 3
    }

    public static partial class NullableContextOptionsExtensions
    {
        public static bool AnnotationsEnabled(this NullableContextOptions context) { throw null; }
        public static bool WarningsEnabled(this NullableContextOptions context) { throw null; }
    }
    public enum NullableFlowState : byte
    {
        None = 0,
        NotNull = 1,
        MaybeNull = 2
    }

    public enum OperationKind
    {
        None = 0,
        Invalid = 1,
        Block = 2,
        VariableDeclarationGroup = 3,
        Switch = 4,
        Loop = 5,
        Labeled = 6,
        Branch = 7,
        Empty = 8,
        Return = 9,
        YieldBreak = 10,
        Lock = 11,
        Try = 12,
        Using = 13,
        YieldReturn = 14,
        ExpressionStatement = 15,
        LocalFunction = 16,
        Stop = 17,
        End = 18,
        RaiseEvent = 19,
        Literal = 20,
        Conversion = 21,
        Invocation = 22,
        ArrayElementReference = 23,
        LocalReference = 24,
        ParameterReference = 25,
        FieldReference = 26,
        MethodReference = 27,
        PropertyReference = 28,
        EventReference = 30,
        Unary = 31,
        UnaryOperator = 31,
        Binary = 32,
        BinaryOperator = 32,
        Conditional = 33,
        Coalesce = 34,
        AnonymousFunction = 35,
        ObjectCreation = 36,
        TypeParameterObjectCreation = 37,
        ArrayCreation = 38,
        InstanceReference = 39,
        IsType = 40,
        Await = 41,
        SimpleAssignment = 42,
        CompoundAssignment = 43,
        Parenthesized = 44,
        EventAssignment = 45,
        ConditionalAccess = 46,
        ConditionalAccessInstance = 47,
        InterpolatedString = 48,
        AnonymousObjectCreation = 49,
        ObjectOrCollectionInitializer = 50,
        MemberInitializer = 51,
        CollectionElementInitializer = 52,
        NameOf = 53,
        Tuple = 54,
        DynamicObjectCreation = 55,
        DynamicMemberReference = 56,
        DynamicInvocation = 57,
        DynamicIndexerAccess = 58,
        TranslatedQuery = 59,
        DelegateCreation = 60,
        DefaultValue = 61,
        TypeOf = 62,
        SizeOf = 63,
        AddressOf = 64,
        IsPattern = 65,
        Increment = 66,
        Throw = 67,
        Decrement = 68,
        DeconstructionAssignment = 69,
        DeclarationExpression = 70,
        OmittedArgument = 71,
        FieldInitializer = 72,
        VariableInitializer = 73,
        PropertyInitializer = 74,
        ParameterInitializer = 75,
        ArrayInitializer = 76,
        VariableDeclarator = 77,
        VariableDeclaration = 78,
        Argument = 79,
        CatchClause = 80,
        SwitchCase = 81,
        CaseClause = 82,
        InterpolatedStringText = 83,
        Interpolation = 84,
        ConstantPattern = 85,
        DeclarationPattern = 86,
        TupleBinary = 87,
        TupleBinaryOperator = 87,
        MethodBody = 88,
        MethodBodyOperation = 88,
        ConstructorBody = 89,
        ConstructorBodyOperation = 89,
        Discard = 90,
        FlowCapture = 91,
        FlowCaptureReference = 92,
        IsNull = 93,
        CaughtException = 94,
        StaticLocalInitializationSemaphore = 95,
        FlowAnonymousFunction = 96,
        CoalesceAssignment = 97,
        Range = 99,
        ReDim = 101,
        ReDimClause = 102,
        RecursivePattern = 103,
        DiscardPattern = 104,
        SwitchExpression = 105,
        SwitchExpressionArm = 106,
        PropertySubpattern = 107,
        UsingDeclaration = 108,
        NegatedPattern = 109,
        BinaryPattern = 110,
        TypePattern = 111,
        RelationalPattern = 112,
        With = 113,
        InterpolatedStringHandlerCreation = 114,
        InterpolatedStringAddition = 115,
        InterpolatedStringAppendLiteral = 116,
        InterpolatedStringAppendFormatted = 117,
        InterpolatedStringAppendInvalid = 118,
        InterpolatedStringHandlerArgumentPlaceholder = 119,
        FunctionPointerInvocation = 120,
        ListPattern = 121,
        SlicePattern = 122,
        ImplicitIndexerReference = 123,
        Utf8String = 124,
        Attribute = 125,
        InlineArrayAccess = 126,
        CollectionExpression = 127,
        Spread = 128
    }

    public enum OptimizationLevel
    {
        Debug = 0,
        Release = 1
    }

    public readonly partial struct Optional<T>
    {
        private readonly T _value;
        private readonly int _dummyPrimitive;
        public Optional(T value) { }
        public bool HasValue { get { throw null; } }
        public T Value { get { throw null; } }

        public static implicit operator Optional<T>(T value) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public enum OutputKind
    {
        ConsoleApplication = 0,
        WindowsApplication = 1,
        DynamicallyLinkedLibrary = 2,
        NetModule = 3,
        WindowsRuntimeMetadata = 4,
        WindowsRuntimeApplication = 5
    }

    public abstract partial class ParseOptions
    {
        internal ParseOptions() { }
        public DocumentationMode DocumentationMode { get { throw null; } protected set { } }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Errors { get { throw null; } }
        public abstract System.Collections.Generic.IReadOnlyDictionary<string, string> Features { get; }
        public SourceCodeKind Kind { get { throw null; } protected set { } }
        public abstract string Language { get; }
        public abstract System.Collections.Generic.IEnumerable<string> PreprocessorSymbolNames { get; }
        public SourceCodeKind SpecifiedKind { get { throw null; } protected set { } }

        protected abstract ParseOptions CommonWithDocumentationMode(DocumentationMode documentationMode);
        protected abstract ParseOptions CommonWithFeatures(System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, string>> features);
        public abstract ParseOptions CommonWithKind(SourceCodeKind kind);
        public abstract override bool Equals(object? obj);
        protected bool EqualsHelper(ParseOptions? other) { throw null; }
        public abstract override int GetHashCode();
        protected int GetHashCodeHelper() { throw null; }
        public static bool operator ==(ParseOptions? left, ParseOptions? right) { throw null; }
        public static bool operator !=(ParseOptions? left, ParseOptions? right) { throw null; }
        public ParseOptions WithDocumentationMode(DocumentationMode documentationMode) { throw null; }
        public ParseOptions WithFeatures(System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, string>> features) { throw null; }
        public ParseOptions WithKind(SourceCodeKind kind) { throw null; }
    }
    public enum Platform
    {
        AnyCpu = 0,
        X86 = 1,
        X64 = 2,
        Itanium = 3,
        AnyCpu32BitPreferred = 4,
        Arm = 5,
        Arm64 = 6
    }

    public abstract partial class PortableExecutableReference : MetadataReference
    {
        protected PortableExecutableReference(MetadataReferenceProperties properties, string? fullPath = null, DocumentationProvider? initialDocumentation = null) : base(default) { }
        public override string? Display { get { throw null; } }
        public string? FilePath { get { throw null; } }

        protected abstract DocumentationProvider CreateDocumentationProvider();
        public Metadata GetMetadata() { throw null; }
        public MetadataId GetMetadataId() { throw null; }
        protected abstract Metadata GetMetadataImpl();
        public new PortableExecutableReference WithAliases(System.Collections.Generic.IEnumerable<string> aliases) { throw null; }
        public new PortableExecutableReference WithAliases(System.Collections.Immutable.ImmutableArray<string> aliases) { throw null; }
        public new PortableExecutableReference WithEmbedInteropTypes(bool value) { throw null; }
        public new PortableExecutableReference WithProperties(MetadataReferenceProperties properties) { throw null; }
        protected abstract PortableExecutableReference WithPropertiesImpl(MetadataReferenceProperties properties);
    }

    public readonly partial struct PreprocessingSymbolInfo : System.IEquatable<PreprocessingSymbolInfo>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public bool IsDefined { get { throw null; } }
        public IPreprocessingSymbol? Symbol { get { throw null; } }

        public readonly bool Equals(PreprocessingSymbolInfo other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public enum RefKind : byte
    {
        None = 0,
        Ref = 1,
        Out = 2,
        In = 3,
        RefReadOnly = 3,
        RefReadOnlyParameter = 4
    }

    public enum ReportDiagnostic
    {
        Default = 0,
        Error = 1,
        Warn = 2,
        Info = 3,
        Hidden = 4,
        Suppress = 5
    }

    public sealed partial class ResourceDescription
    {
        public ResourceDescription(string resourceName, System.Func<System.IO.Stream> dataProvider, bool isPublic) { }
        public ResourceDescription(string resourceName, string? fileName, System.Func<System.IO.Stream> dataProvider, bool isPublic) { }
    }
    public partial class RuleSet
    {
        public RuleSet(string filePath, ReportDiagnostic generalOption, System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> specificOptions, System.Collections.Immutable.ImmutableArray<RuleSetInclude> includes) { }
        public string FilePath { get { throw null; } }
        public ReportDiagnostic GeneralDiagnosticOption { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<RuleSetInclude> Includes { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> SpecificDiagnosticOptions { get { throw null; } }

        public static ReportDiagnostic GetDiagnosticOptionsFromRulesetFile(string? rulesetFileFullPath, out System.Collections.Generic.Dictionary<string, ReportDiagnostic> specificDiagnosticOptions) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<string> GetEffectiveIncludesFromFile(string filePath) { throw null; }
        public static RuleSet LoadEffectiveRuleSetFromFile(string filePath) { throw null; }
        public RuleSet? WithEffectiveAction(ReportDiagnostic action) { throw null; }
    }
    public partial class RuleSetInclude
    {
        public RuleSetInclude(string includePath, ReportDiagnostic action) { }
        public ReportDiagnostic Action { get { throw null; } }
        public string IncludePath { get { throw null; } }

        public RuleSet? LoadRuleSet(RuleSet parent) { throw null; }
    }
    public enum RuntimeCapability
    {
        ByRefFields = 1,
        CovariantReturnsOfClasses = 2,
        DefaultImplementationsOfInterfaces = 3,
        NumericIntPtr = 4,
        UnmanagedSignatureCallingConvention = 5,
        VirtualStaticsInInterfaces = 6,
        InlineArrayTypes = 7,
        ByRefLikeGenerics = 8
    }

    public enum SarifVersion
    {
        Default = 1,
        Sarif1 = 1,
        Sarif2 = 2,
        Latest = int.MaxValue
    }

    public static partial class SarifVersionFacts
    {
        public static bool TryParse(string version, out SarifVersion result) { throw null; }
    }
    public enum ScopedKind : byte
    {
        None = 0,
        ScopedRef = 1,
        ScopedValue = 2
    }

    public abstract partial class ScriptCompilationInfo
    {
        internal ScriptCompilationInfo() { }
        public System.Type? GlobalsType { get { throw null; } }
        public Compilation? PreviousScriptCompilation { get { throw null; } }
        public System.Type ReturnType { get { throw null; } }

        public ScriptCompilationInfo WithPreviousScriptCompilation(Compilation? compilation) { throw null; }
    }
    public abstract partial class SemanticModel
    {
        public Compilation Compilation { get { throw null; } }
        protected abstract Compilation CompilationCore { get; }
        public virtual bool IgnoresAccessibility { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "ParentModel")]
        public abstract bool IsSpeculativeSemanticModel { get; }
        public abstract string Language { get; }

        [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL001", UrlFormat = "https://github.com/dotnet/roslyn/issues/70609")]
        public abstract bool NullableAnalysisIsDisabled { get; }
        public abstract int OriginalPositionForSpeculation { get; }
        public SemanticModel? ParentModel { get { throw null; } }
        protected abstract SemanticModel? ParentModelCore { get; }
        protected abstract SyntaxNode RootCore { get; }
        public SyntaxTree SyntaxTree { get { throw null; } }
        protected abstract SyntaxTree SyntaxTreeCore { get; }

        protected abstract ControlFlowAnalysis AnalyzeControlFlowCore(SyntaxNode firstStatement, SyntaxNode lastStatement);
        protected abstract ControlFlowAnalysis AnalyzeControlFlowCore(SyntaxNode statement);
        protected abstract DataFlowAnalysis AnalyzeDataFlowCore(SyntaxNode firstStatement, SyntaxNode lastStatement);
        protected abstract DataFlowAnalysis AnalyzeDataFlowCore(SyntaxNode statementOrExpression);
        protected abstract IAliasSymbol? GetAliasInfoCore(SyntaxNode nameSyntax, System.Threading.CancellationToken cancellationToken = default);
        public Optional<object?> GetConstantValue(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        protected abstract Optional<object?> GetConstantValueCore(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetDeclarationDiagnostics(Text.TextSpan? span = null, System.Threading.CancellationToken cancellationToken = default);
        protected abstract ISymbol? GetDeclaredSymbolCore(SyntaxNode declaration, System.Threading.CancellationToken cancellationToken = default);
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> GetDeclaredSymbolsCore(SyntaxNode declaration, System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetDiagnostics(Text.TextSpan? span = null, System.Threading.CancellationToken cancellationToken = default);
        public ISymbol? GetEnclosingSymbol(int position, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        protected abstract ISymbol? GetEnclosingSymbolCore(int position, System.Threading.CancellationToken cancellationToken = default);
        public System.Collections.Immutable.ImmutableArray<IImportScope> GetImportScopes(int position, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> GetMemberGroupCore(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetMethodBodyDiagnostics(Text.TextSpan? span = null, System.Threading.CancellationToken cancellationToken = default);
        public abstract NullableContext GetNullableContext(int position);
        public IOperation? GetOperation(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        protected abstract IOperation? GetOperationCore(SyntaxNode node, System.Threading.CancellationToken cancellationToken);
        public PreprocessingSymbolInfo GetPreprocessingSymbolInfo(SyntaxNode nameSyntax) { throw null; }
        protected abstract PreprocessingSymbolInfo GetPreprocessingSymbolInfoCore(SyntaxNode nameSyntax);
        protected abstract IAliasSymbol? GetSpeculativeAliasInfoCore(int position, SyntaxNode nameSyntax, SpeculativeBindingOption bindingOption);
        protected abstract SymbolInfo GetSpeculativeSymbolInfoCore(int position, SyntaxNode expression, SpeculativeBindingOption bindingOption);
        protected abstract TypeInfo GetSpeculativeTypeInfoCore(int position, SyntaxNode expression, SpeculativeBindingOption bindingOption);
        protected abstract SymbolInfo GetSymbolInfoCore(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Immutable.ImmutableArray<Diagnostic> GetSyntaxDiagnostics(Text.TextSpan? span = null, System.Threading.CancellationToken cancellationToken = default);
        protected internal virtual SyntaxNode GetTopmostNodeForDiagnosticAnalysis(ISymbol symbol, SyntaxNode declaringSyntax) { throw null; }
        protected abstract TypeInfo GetTypeInfoCore(SyntaxNode node, System.Threading.CancellationToken cancellationToken = default);
        public bool IsAccessible(int position, ISymbol symbol) { throw null; }
        protected abstract bool IsAccessibleCore(int position, ISymbol symbol);
        public bool IsEventUsableAsField(int position, IEventSymbol eventSymbol) { throw null; }
        protected abstract bool IsEventUsableAsFieldCore(int position, IEventSymbol eventSymbol);
        public System.Collections.Immutable.ImmutableArray<ISymbol> LookupBaseMembers(int position, string? name = null) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> LookupBaseMembersCore(int position, string? name);
        public System.Collections.Immutable.ImmutableArray<ISymbol> LookupLabels(int position, string? name = null) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> LookupLabelsCore(int position, string? name);
        public System.Collections.Immutable.ImmutableArray<ISymbol> LookupNamespacesAndTypes(int position, INamespaceOrTypeSymbol? container = null, string? name = null) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> LookupNamespacesAndTypesCore(int position, INamespaceOrTypeSymbol? container, string? name);
        public System.Collections.Immutable.ImmutableArray<ISymbol> LookupStaticMembers(int position, INamespaceOrTypeSymbol? container = null, string? name = null) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> LookupStaticMembersCore(int position, INamespaceOrTypeSymbol? container, string? name);
        public System.Collections.Immutable.ImmutableArray<ISymbol> LookupSymbols(int position, INamespaceOrTypeSymbol? container = null, string? name = null, bool includeReducedExtensionMethods = false) { throw null; }
        protected abstract System.Collections.Immutable.ImmutableArray<ISymbol> LookupSymbolsCore(int position, INamespaceOrTypeSymbol? container, string? name, bool includeReducedExtensionMethods);
    }
    [System.Diagnostics.CodeAnalysis.Experimental("RSEXPERIMENTAL001", UrlFormat = "https://github.com/dotnet/roslyn/issues/70609")]
    [System.Flags]
    public enum SemanticModelOptions
    {
        None = 0,
        IgnoreAccessibility = 1,
        DisableNullableAnalysis = 2
    }

    public static partial class SeparatedSyntaxList
    {
        public static SeparatedSyntaxList<TNode> Create<TNode>(System.ReadOnlySpan<TNode> nodes) where TNode : SyntaxNode { throw null; }
    }
    [System.Runtime.CompilerServices.CollectionBuilder(typeof(SeparatedSyntaxList), "Create")]
    public readonly partial struct SeparatedSyntaxList<TNode> : System.IEquatable<SeparatedSyntaxList<TNode>>, System.Collections.Generic.IReadOnlyList<TNode>, System.Collections.Generic.IEnumerable<TNode>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<TNode> where TNode : SyntaxNode
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public int Count { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }

        public TNode this[int index] { get { throw null; } }

        public int SeparatorCount { get { throw null; } }
        public Text.TextSpan Span { get { throw null; } }

        public readonly SeparatedSyntaxList<TNode> Add(TNode node) { throw null; }
        public readonly SeparatedSyntaxList<TNode> AddRange(System.Collections.Generic.IEnumerable<TNode> nodes) { throw null; }
        public readonly bool Any() { throw null; }
        public readonly bool Contains(TNode node) { throw null; }
        public readonly bool Equals(SeparatedSyntaxList<TNode> other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly TNode First() { throw null; }
        public readonly TNode? FirstOrDefault() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly SyntaxToken GetSeparator(int index) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxToken> GetSeparators() { throw null; }
        public readonly SyntaxNodeOrTokenList GetWithSeparators() { throw null; }
        public readonly int IndexOf(TNode node) { throw null; }
        public readonly int IndexOf(System.Func<TNode, bool> predicate) { throw null; }
        public readonly SeparatedSyntaxList<TNode> Insert(int index, TNode node) { throw null; }
        public readonly SeparatedSyntaxList<TNode> InsertRange(int index, System.Collections.Generic.IEnumerable<TNode> nodes) { throw null; }
        public readonly TNode Last() { throw null; }
        public readonly int LastIndexOf(TNode node) { throw null; }
        public readonly int LastIndexOf(System.Func<TNode, bool> predicate) { throw null; }
        public readonly TNode? LastOrDefault() { throw null; }
        public static bool operator ==(SeparatedSyntaxList<TNode> left, SeparatedSyntaxList<TNode> right) { throw null; }
        public static explicit operator SeparatedSyntaxList<TNode>(SeparatedSyntaxList<SyntaxNode> nodes) { throw null; }
        public static implicit operator SeparatedSyntaxList<SyntaxNode>(SeparatedSyntaxList<TNode> nodes) { throw null; }
        [System.Obsolete("This method is preserved for binary compatibility only. Use explicit cast instead.", true)]
        public static SeparatedSyntaxList<TNode> op_Implicit(SeparatedSyntaxList<SyntaxNode> nodes) { throw null; }
        public static bool operator !=(SeparatedSyntaxList<TNode> left, SeparatedSyntaxList<TNode> right) { throw null; }
        public readonly SeparatedSyntaxList<TNode> Remove(TNode node) { throw null; }
        public readonly SeparatedSyntaxList<TNode> RemoveAt(int index) { throw null; }
        public readonly SeparatedSyntaxList<TNode> Replace(TNode nodeInList, TNode newNode) { throw null; }
        public readonly SeparatedSyntaxList<TNode> ReplaceRange(TNode nodeInList, System.Collections.Generic.IEnumerable<TNode> newNodes) { throw null; }
        public readonly SeparatedSyntaxList<TNode> ReplaceSeparator(SyntaxToken separatorToken, SyntaxToken newSeparator) { throw null; }
        readonly System.Collections.Generic.IEnumerator<TNode> System.Collections.Generic.IEnumerable<TNode>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public partial struct Enumerator
        {
            private SeparatedSyntaxList<TNode> _list;
            private object _dummy;
            private int _dummyPrimitive;
            public TNode Current { get { throw null; } }

            public override bool Equals(object? obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public bool MoveNext() { throw null; }
            public void Reset() { }
        }
    }

    public enum SourceCodeKind
    {
        Regular = 0,
        Script = 1,
        Interactive = 2
    }

    public partial class SourceFileResolver : SourceReferenceResolver, System.IEquatable<SourceFileResolver>
    {
        public SourceFileResolver(System.Collections.Generic.IEnumerable<string> searchPaths, string? baseDirectory) { }
        public SourceFileResolver(System.Collections.Immutable.ImmutableArray<string> searchPaths, string? baseDirectory, System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, string>> pathMap) { }
        public SourceFileResolver(System.Collections.Immutable.ImmutableArray<string> searchPaths, string? baseDirectory) { }
        public string? BaseDirectory { get { throw null; } }
        public static SourceFileResolver Default { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<System.Collections.Generic.KeyValuePair<string, string>> PathMap { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<string> SearchPaths { get { throw null; } }

        public bool Equals(SourceFileResolver? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        protected virtual bool FileExists(string? resolvedPath) { throw null; }
        public override int GetHashCode() { throw null; }
        public override string? NormalizePath(string path, string? baseFilePath) { throw null; }
        public override System.IO.Stream OpenRead(string resolvedPath) { throw null; }
        public override string? ResolveReference(string path, string? baseFilePath) { throw null; }
    }

    public readonly partial struct SourceProductionContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }

        public readonly void AddSource(string hintName, Text.SourceText sourceText) { }
        public readonly void AddSource(string hintName, string source) { }
        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public abstract partial class SourceReferenceResolver
    {
        public abstract override bool Equals(object? other);
        public abstract override int GetHashCode();
        public abstract string? NormalizePath(string path, string? baseFilePath);
        public abstract System.IO.Stream OpenRead(string resolvedPath);
        public virtual Text.SourceText ReadText(string resolvedPath) { throw null; }
        public abstract string? ResolveReference(string path, string? baseFilePath);
    }
    public enum SpecialType : sbyte
    {
        None = 0,
        System_Object = 1,
        System_Enum = 2,
        System_MulticastDelegate = 3,
        System_Delegate = 4,
        System_ValueType = 5,
        System_Void = 6,
        System_Boolean = 7,
        System_Char = 8,
        System_SByte = 9,
        System_Byte = 10,
        System_Int16 = 11,
        System_UInt16 = 12,
        System_Int32 = 13,
        System_UInt32 = 14,
        System_Int64 = 15,
        System_UInt64 = 16,
        System_Decimal = 17,
        System_Single = 18,
        System_Double = 19,
        System_String = 20,
        System_IntPtr = 21,
        System_UIntPtr = 22,
        System_Array = 23,
        System_Collections_IEnumerable = 24,
        System_Collections_Generic_IEnumerable_T = 25,
        System_Collections_Generic_IList_T = 26,
        System_Collections_Generic_ICollection_T = 27,
        System_Collections_IEnumerator = 28,
        System_Collections_Generic_IEnumerator_T = 29,
        System_Collections_Generic_IReadOnlyList_T = 30,
        System_Collections_Generic_IReadOnlyCollection_T = 31,
        System_Nullable_T = 32,
        System_DateTime = 33,
        System_Runtime_CompilerServices_IsVolatile = 34,
        System_IDisposable = 35,
        System_TypedReference = 36,
        System_ArgIterator = 37,
        System_RuntimeArgumentHandle = 38,
        System_RuntimeFieldHandle = 39,
        System_RuntimeMethodHandle = 40,
        System_RuntimeTypeHandle = 41,
        System_IAsyncResult = 42,
        System_AsyncCallback = 43,
        System_Runtime_CompilerServices_RuntimeFeature = 44,
        System_Runtime_CompilerServices_PreserveBaseOverridesAttribute = 45,
        Count = 46,
        System_Runtime_CompilerServices_InlineArrayAttribute = 46
    }

    public enum SpeculativeBindingOption
    {
        BindAsExpression = 0,
        BindAsTypeOrNamespace = 1
    }

    public abstract partial class StrongNameProvider
    {
        public abstract override bool Equals(object? other);
        public abstract override int GetHashCode();
    }
    public readonly partial struct SubsystemVersion : System.IEquatable<SubsystemVersion>
    {
        private readonly int _dummyPrimitive;
        public bool IsValid { get { throw null; } }
        public int Major { get { throw null; } }
        public int Minor { get { throw null; } }
        public static SubsystemVersion None { get { throw null; } }
        public static SubsystemVersion Windows2000 { get { throw null; } }
        public static SubsystemVersion Windows7 { get { throw null; } }
        public static SubsystemVersion Windows8 { get { throw null; } }
        public static SubsystemVersion WindowsVista { get { throw null; } }
        public static SubsystemVersion WindowsXP { get { throw null; } }

        public static SubsystemVersion Create(int major, int minor) { throw null; }
        public readonly bool Equals(SubsystemVersion other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public override readonly string ToString() { throw null; }
        public static bool TryParse(string str, out SubsystemVersion version) { throw null; }
    }

    public sealed partial class SuppressionDescriptor : System.IEquatable<SuppressionDescriptor?>
    {
        public SuppressionDescriptor(string id, string suppressedDiagnosticId, LocalizableString justification) { }
        public SuppressionDescriptor(string id, string suppressedDiagnosticId, string justification) { }
        public string Id { get { throw null; } }
        public LocalizableString Justification { get { throw null; } }
        public string SuppressedDiagnosticId { get { throw null; } }

        public bool Equals(SuppressionDescriptor? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
    }

    public enum SymbolDisplayDelegateStyle
    {
        NameOnly = 0,
        NameAndParameters = 1,
        NameAndSignature = 2
    }

    public enum SymbolDisplayExtensionMethodStyle
    {
        Default = 0,
        InstanceMethod = 1,
        StaticMethod = 2
    }

    public static partial class SymbolDisplayExtensions
    {
        public static string ToDisplayString(this System.Collections.Immutable.ImmutableArray<SymbolDisplayPart> parts) { throw null; }
    }
    public partial class SymbolDisplayFormat
    {
        public SymbolDisplayFormat(SymbolDisplayGlobalNamespaceStyle globalNamespaceStyle = SymbolDisplayGlobalNamespaceStyle.Omitted, SymbolDisplayTypeQualificationStyle typeQualificationStyle = SymbolDisplayTypeQualificationStyle.NameOnly, SymbolDisplayGenericsOptions genericsOptions = SymbolDisplayGenericsOptions.None, SymbolDisplayMemberOptions memberOptions = SymbolDisplayMemberOptions.None, SymbolDisplayDelegateStyle delegateStyle = SymbolDisplayDelegateStyle.NameOnly, SymbolDisplayExtensionMethodStyle extensionMethodStyle = SymbolDisplayExtensionMethodStyle.Default, SymbolDisplayParameterOptions parameterOptions = SymbolDisplayParameterOptions.None, SymbolDisplayPropertyStyle propertyStyle = SymbolDisplayPropertyStyle.NameOnly, SymbolDisplayLocalOptions localOptions = SymbolDisplayLocalOptions.None, SymbolDisplayKindOptions kindOptions = SymbolDisplayKindOptions.None, SymbolDisplayMiscellaneousOptions miscellaneousOptions = SymbolDisplayMiscellaneousOptions.None) { }
        public static SymbolDisplayFormat CSharpErrorMessageFormat { get { throw null; } }
        public static SymbolDisplayFormat CSharpShortErrorMessageFormat { get { throw null; } }
        public SymbolDisplayDelegateStyle DelegateStyle { get { throw null; } }
        public SymbolDisplayExtensionMethodStyle ExtensionMethodStyle { get { throw null; } }
        public static SymbolDisplayFormat FullyQualifiedFormat { get { throw null; } }
        public SymbolDisplayGenericsOptions GenericsOptions { get { throw null; } }
        public SymbolDisplayGlobalNamespaceStyle GlobalNamespaceStyle { get { throw null; } }
        public SymbolDisplayKindOptions KindOptions { get { throw null; } }
        public SymbolDisplayLocalOptions LocalOptions { get { throw null; } }
        public SymbolDisplayMemberOptions MemberOptions { get { throw null; } }
        public static SymbolDisplayFormat MinimallyQualifiedFormat { get { throw null; } }
        public SymbolDisplayMiscellaneousOptions MiscellaneousOptions { get { throw null; } }
        public SymbolDisplayParameterOptions ParameterOptions { get { throw null; } }
        public SymbolDisplayPropertyStyle PropertyStyle { get { throw null; } }
        public SymbolDisplayTypeQualificationStyle TypeQualificationStyle { get { throw null; } }
        public static SymbolDisplayFormat VisualBasicErrorMessageFormat { get { throw null; } }
        public static SymbolDisplayFormat VisualBasicShortErrorMessageFormat { get { throw null; } }

        public SymbolDisplayFormat AddGenericsOptions(SymbolDisplayGenericsOptions options) { throw null; }
        public SymbolDisplayFormat AddKindOptions(SymbolDisplayKindOptions options) { throw null; }
        public SymbolDisplayFormat AddLocalOptions(SymbolDisplayLocalOptions options) { throw null; }
        public SymbolDisplayFormat AddMemberOptions(SymbolDisplayMemberOptions options) { throw null; }
        public SymbolDisplayFormat AddMiscellaneousOptions(SymbolDisplayMiscellaneousOptions options) { throw null; }
        public SymbolDisplayFormat AddParameterOptions(SymbolDisplayParameterOptions options) { throw null; }
        public SymbolDisplayFormat RemoveGenericsOptions(SymbolDisplayGenericsOptions options) { throw null; }
        public SymbolDisplayFormat RemoveKindOptions(SymbolDisplayKindOptions options) { throw null; }
        public SymbolDisplayFormat RemoveLocalOptions(SymbolDisplayLocalOptions options) { throw null; }
        public SymbolDisplayFormat RemoveMemberOptions(SymbolDisplayMemberOptions options) { throw null; }
        public SymbolDisplayFormat RemoveMiscellaneousOptions(SymbolDisplayMiscellaneousOptions options) { throw null; }
        public SymbolDisplayFormat RemoveParameterOptions(SymbolDisplayParameterOptions options) { throw null; }
        public SymbolDisplayFormat WithGenericsOptions(SymbolDisplayGenericsOptions options) { throw null; }
        public SymbolDisplayFormat WithGlobalNamespaceStyle(SymbolDisplayGlobalNamespaceStyle style) { throw null; }
        public SymbolDisplayFormat WithKindOptions(SymbolDisplayKindOptions options) { throw null; }
        public SymbolDisplayFormat WithLocalOptions(SymbolDisplayLocalOptions options) { throw null; }
        public SymbolDisplayFormat WithMemberOptions(SymbolDisplayMemberOptions options) { throw null; }
        public SymbolDisplayFormat WithMiscellaneousOptions(SymbolDisplayMiscellaneousOptions options) { throw null; }
        public SymbolDisplayFormat WithParameterOptions(SymbolDisplayParameterOptions options) { throw null; }
    }
    [System.Flags]
    public enum SymbolDisplayGenericsOptions
    {
        None = 0,
        IncludeTypeParameters = 1,
        IncludeTypeConstraints = 2,
        IncludeVariance = 4
    }

    public enum SymbolDisplayGlobalNamespaceStyle
    {
        Omitted = 0,
        OmittedAsContaining = 1,
        Included = 2
    }

    [System.Flags]
    public enum SymbolDisplayKindOptions
    {
        None = 0,
        IncludeNamespaceKeyword = 1,
        IncludeTypeKeyword = 2,
        IncludeMemberKeyword = 4
    }

    [System.Flags]
    public enum SymbolDisplayLocalOptions
    {
        None = 0,
        IncludeType = 1,
        IncludeConstantValue = 2,
        IncludeModifiers = 4,
        IncludeRef = 4
    }

    [System.Flags]
    public enum SymbolDisplayMemberOptions
    {
        None = 0,
        IncludeType = 1,
        IncludeModifiers = 2,
        IncludeAccessibility = 4,
        IncludeExplicitInterface = 8,
        IncludeParameters = 16,
        IncludeContainingType = 32,
        IncludeConstantValue = 64,
        IncludeRef = 128
    }

    [System.Flags]
    public enum SymbolDisplayMiscellaneousOptions
    {
        None = 0,
        UseSpecialTypes = 1,
        EscapeKeywordIdentifiers = 2,
        UseAsterisksInMultiDimensionalArrays = 4,
        UseErrorTypeSymbolName = 8,
        RemoveAttributeSuffix = 16,
        ExpandNullable = 32,
        IncludeNullableReferenceTypeModifier = 64,
        AllowDefaultLiteral = 128,
        IncludeNotNullableReferenceTypeModifier = 256,
        CollapseTupleTypes = 512,
        ExpandValueTuple = 1024
    }

    [System.Flags]
    public enum SymbolDisplayParameterOptions
    {
        None = 0,
        IncludeExtensionThis = 1,
        IncludeModifiers = 2,
        IncludeParamsRefOut = 2,
        IncludeType = 4,
        IncludeName = 8,
        IncludeDefaultValue = 16,
        IncludeOptionalBrackets = 32
    }

    public readonly partial struct SymbolDisplayPart
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SymbolDisplayPart(SymbolDisplayPartKind kind, ISymbol? symbol, string text) { }
        public SymbolDisplayPartKind Kind { get { throw null; } }
        public ISymbol? Symbol { get { throw null; } }

        public override readonly string ToString() { throw null; }
    }

    public enum SymbolDisplayPartKind
    {
        AliasName = 0,
        AssemblyName = 1,
        ClassName = 2,
        DelegateName = 3,
        EnumName = 4,
        ErrorTypeName = 5,
        EventName = 6,
        FieldName = 7,
        InterfaceName = 8,
        Keyword = 9,
        LabelName = 10,
        LineBreak = 11,
        NumericLiteral = 12,
        StringLiteral = 13,
        LocalName = 14,
        MethodName = 15,
        ModuleName = 16,
        NamespaceName = 17,
        Operator = 18,
        ParameterName = 19,
        PropertyName = 20,
        Punctuation = 21,
        Space = 22,
        StructName = 23,
        AnonymousTypeIndicator = 24,
        Text = 25,
        TypeParameterName = 26,
        RangeVariableName = 27,
        EnumMemberName = 28,
        ExtensionMethodName = 29,
        ConstantName = 30,
        RecordClassName = 31,
        RecordStructName = 32
    }

    public enum SymbolDisplayPropertyStyle
    {
        NameOnly = 0,
        ShowReadWriteDescriptor = 1
    }

    public enum SymbolDisplayTypeQualificationStyle
    {
        NameOnly = 0,
        NameAndContainingTypes = 1,
        NameAndContainingTypesAndNamespaces = 2
    }

    public sealed partial class SymbolEqualityComparer : System.Collections.Generic.IEqualityComparer<ISymbol?>
    {
        internal SymbolEqualityComparer() { }
        public static readonly SymbolEqualityComparer Default;
        public static readonly SymbolEqualityComparer IncludeNullability;
        public bool Equals(ISymbol? x, ISymbol? y) { throw null; }
        public int GetHashCode(ISymbol? obj) { throw null; }
    }

    [System.Flags]
    public enum SymbolFilter
    {
        None = 0,
        Namespace = 1,
        Type = 2,
        Member = 4,
        TypeAndMember = 6,
        All = 7
    }

    public readonly partial struct SymbolInfo : System.IEquatable<SymbolInfo>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public CandidateReason CandidateReason { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ISymbol> CandidateSymbols { get { throw null; } }
        public ISymbol? Symbol { get { throw null; } }

        public readonly bool Equals(SymbolInfo other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public enum SymbolKind
    {
        Alias = 0,
        ArrayType = 1,
        Assembly = 2,
        DynamicType = 3,
        ErrorType = 4,
        Event = 5,
        Field = 6,
        Label = 7,
        Local = 8,
        Method = 9,
        NetModule = 10,
        NamedType = 11,
        Namespace = 12,
        Parameter = 13,
        PointerType = 14,
        Property = 15,
        RangeVariable = 16,
        TypeParameter = 17,
        Preprocessing = 18,
        Discard = 19,
        FunctionPointerType = 20
    }

    public abstract partial class SymbolVisitor
    {
        public virtual void DefaultVisit(ISymbol symbol) { }
        public virtual void Visit(ISymbol? symbol) { }
        public virtual void VisitAlias(IAliasSymbol symbol) { }
        public virtual void VisitArrayType(IArrayTypeSymbol symbol) { }
        public virtual void VisitAssembly(IAssemblySymbol symbol) { }
        public virtual void VisitDiscard(IDiscardSymbol symbol) { }
        public virtual void VisitDynamicType(IDynamicTypeSymbol symbol) { }
        public virtual void VisitEvent(IEventSymbol symbol) { }
        public virtual void VisitField(IFieldSymbol symbol) { }
        public virtual void VisitFunctionPointerType(IFunctionPointerTypeSymbol symbol) { }
        public virtual void VisitLabel(ILabelSymbol symbol) { }
        public virtual void VisitLocal(ILocalSymbol symbol) { }
        public virtual void VisitMethod(IMethodSymbol symbol) { }
        public virtual void VisitModule(IModuleSymbol symbol) { }
        public virtual void VisitNamedType(INamedTypeSymbol symbol) { }
        public virtual void VisitNamespace(INamespaceSymbol symbol) { }
        public virtual void VisitParameter(IParameterSymbol symbol) { }
        public virtual void VisitPointerType(IPointerTypeSymbol symbol) { }
        public virtual void VisitProperty(IPropertySymbol symbol) { }
        public virtual void VisitRangeVariable(IRangeVariableSymbol symbol) { }
        public virtual void VisitTypeParameter(ITypeParameterSymbol symbol) { }
    }
    public abstract partial class SymbolVisitor<TResult>
    {
        public virtual TResult? DefaultVisit(ISymbol symbol) { throw null; }
        public virtual TResult? Visit(ISymbol? symbol) { throw null; }
        public virtual TResult? VisitAlias(IAliasSymbol symbol) { throw null; }
        public virtual TResult? VisitArrayType(IArrayTypeSymbol symbol) { throw null; }
        public virtual TResult? VisitAssembly(IAssemblySymbol symbol) { throw null; }
        public virtual TResult? VisitDiscard(IDiscardSymbol symbol) { throw null; }
        public virtual TResult? VisitDynamicType(IDynamicTypeSymbol symbol) { throw null; }
        public virtual TResult? VisitEvent(IEventSymbol symbol) { throw null; }
        public virtual TResult? VisitField(IFieldSymbol symbol) { throw null; }
        public virtual TResult? VisitFunctionPointerType(IFunctionPointerTypeSymbol symbol) { throw null; }
        public virtual TResult? VisitLabel(ILabelSymbol symbol) { throw null; }
        public virtual TResult? VisitLocal(ILocalSymbol symbol) { throw null; }
        public virtual TResult? VisitMethod(IMethodSymbol symbol) { throw null; }
        public virtual TResult? VisitModule(IModuleSymbol symbol) { throw null; }
        public virtual TResult? VisitNamedType(INamedTypeSymbol symbol) { throw null; }
        public virtual TResult? VisitNamespace(INamespaceSymbol symbol) { throw null; }
        public virtual TResult? VisitParameter(IParameterSymbol symbol) { throw null; }
        public virtual TResult? VisitPointerType(IPointerTypeSymbol symbol) { throw null; }
        public virtual TResult? VisitProperty(IPropertySymbol symbol) { throw null; }
        public virtual TResult? VisitRangeVariable(IRangeVariableSymbol symbol) { throw null; }
        public virtual TResult? VisitTypeParameter(ITypeParameterSymbol symbol) { throw null; }
    }
    public abstract partial class SymbolVisitor<TArgument, TResult>
    {
        protected abstract TResult DefaultResult { get; }

        public virtual TResult DefaultVisit(ISymbol symbol, TArgument argument) { throw null; }
        public virtual TResult Visit(ISymbol? symbol, TArgument argument) { throw null; }
        public virtual TResult VisitAlias(IAliasSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitArrayType(IArrayTypeSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitAssembly(IAssemblySymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitDiscard(IDiscardSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitDynamicType(IDynamicTypeSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitEvent(IEventSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitField(IFieldSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitFunctionPointerType(IFunctionPointerTypeSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitLabel(ILabelSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitLocal(ILocalSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitMethod(IMethodSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitModule(IModuleSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitNamedType(INamedTypeSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitNamespace(INamespaceSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitParameter(IParameterSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitPointerType(IPointerTypeSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitProperty(IPropertySymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitRangeVariable(IRangeVariableSymbol symbol, TArgument argument) { throw null; }
        public virtual TResult VisitTypeParameter(ITypeParameterSymbol symbol, TArgument argument) { throw null; }
    }
    public sealed partial class SyntaxAnnotation : System.IEquatable<SyntaxAnnotation?>
    {
        public SyntaxAnnotation() { }
        public SyntaxAnnotation(string? kind, string? data) { }
        public SyntaxAnnotation(string? kind) { }
        public string? Data { get { throw null; } }
        public static SyntaxAnnotation ElasticAnnotation { get { throw null; } }
        public string? Kind { get { throw null; } }

        public bool Equals(SyntaxAnnotation? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(SyntaxAnnotation? left, SyntaxAnnotation? right) { throw null; }
        public static bool operator !=(SyntaxAnnotation? left, SyntaxAnnotation? right) { throw null; }
    }

    public delegate ISyntaxContextReceiver? SyntaxContextReceiverCreator();
    public static partial class SyntaxList
    {
        public static SyntaxList<TNode> Create<TNode>(System.ReadOnlySpan<TNode> nodes) where TNode : SyntaxNode { throw null; }
    }
    [System.Runtime.CompilerServices.CollectionBuilder(typeof(SyntaxList), "Create")]
    public readonly partial struct SyntaxList<TNode> : System.Collections.Generic.IReadOnlyList<TNode>, System.Collections.Generic.IEnumerable<TNode>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<TNode>, System.IEquatable<SyntaxList<TNode>> where TNode : SyntaxNode
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxList(TNode? node) { }
        public SyntaxList(System.Collections.Generic.IEnumerable<TNode>? nodes) { }
        public int Count { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }

        public TNode this[int index] { get { throw null; } }

        public Text.TextSpan Span { get { throw null; } }

        public readonly SyntaxList<TNode> Add(TNode node) { throw null; }
        public readonly SyntaxList<TNode> AddRange(System.Collections.Generic.IEnumerable<TNode> nodes) { throw null; }
        public readonly bool Any() { throw null; }
        public readonly bool Equals(SyntaxList<TNode> other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly TNode First() { throw null; }
        public readonly TNode? FirstOrDefault() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly int IndexOf(TNode node) { throw null; }
        public readonly int IndexOf(System.Func<TNode, bool> predicate) { throw null; }
        public readonly SyntaxList<TNode> Insert(int index, TNode node) { throw null; }
        public readonly SyntaxList<TNode> InsertRange(int index, System.Collections.Generic.IEnumerable<TNode> nodes) { throw null; }
        public readonly TNode Last() { throw null; }
        public readonly int LastIndexOf(TNode node) { throw null; }
        public readonly int LastIndexOf(System.Func<TNode, bool> predicate) { throw null; }
        public readonly TNode? LastOrDefault() { throw null; }
        public static bool operator ==(SyntaxList<TNode> left, SyntaxList<TNode> right) { throw null; }
        public static explicit operator SyntaxList<TNode>(SyntaxList<SyntaxNode> nodes) { throw null; }
        public static implicit operator SyntaxList<SyntaxNode>(SyntaxList<TNode> nodes) { throw null; }
        [System.Obsolete("This method is preserved for binary compatibility only. Use explicit cast instead.", true)]
        public static SyntaxList<TNode> op_Implicit(SyntaxList<SyntaxNode> nodes) { throw null; }
        public static bool operator !=(SyntaxList<TNode> left, SyntaxList<TNode> right) { throw null; }
        public readonly SyntaxList<TNode> Remove(TNode node) { throw null; }
        public readonly SyntaxList<TNode> RemoveAt(int index) { throw null; }
        public readonly SyntaxList<TNode> Replace(TNode nodeInList, TNode newNode) { throw null; }
        public readonly SyntaxList<TNode> ReplaceRange(TNode nodeInList, System.Collections.Generic.IEnumerable<TNode> newNodes) { throw null; }
        readonly System.Collections.Generic.IEnumerator<TNode> System.Collections.Generic.IEnumerable<TNode>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public partial struct Enumerator
        {
            private SyntaxList<TNode> _list;
            private object _dummy;
            private int _dummyPrimitive;
            public TNode Current { get { throw null; } }

            public override bool Equals(object? obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public bool MoveNext() { throw null; }
            public void Reset() { }
        }
    }

    public abstract partial class SyntaxNode
    {
        internal SyntaxNode() { }
        public bool ContainsAnnotations { get { throw null; } }
        public bool ContainsDiagnostics { get { throw null; } }
        public bool ContainsDirectives { get { throw null; } }
        public bool ContainsSkippedText { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }
        public bool HasLeadingTrivia { get { throw null; } }
        public bool HasStructuredTrivia { get { throw null; } }
        public bool HasTrailingTrivia { get { throw null; } }
        public bool IsMissing { get { throw null; } }
        public bool IsStructuredTrivia { get { throw null; } }
        protected string KindText { get { throw null; } }
        public abstract string Language { get; }
        public SyntaxNode? Parent { get { throw null; } }
        public virtual SyntaxTrivia ParentTrivia { get { throw null; } }
        public int RawKind { get { throw null; } }
        public Text.TextSpan Span { get { throw null; } }
        public int SpanStart { get { throw null; } }
        public SyntaxTree SyntaxTree { get { throw null; } }
        protected abstract SyntaxTree SyntaxTreeCore { get; }

        public System.Collections.Generic.IEnumerable<SyntaxNode> Ancestors(bool ascendOutOfTrivia = true) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> AncestorsAndSelf(bool ascendOutOfTrivia = true) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> ChildNodes() { throw null; }
        public ChildSyntaxList ChildNodesAndTokens() { throw null; }
        public virtual SyntaxNodeOrToken ChildThatContainsPosition(int position) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxToken> ChildTokens() { throw null; }
        public bool Contains(SyntaxNode? node) { throw null; }
        public bool ContainsDirective(int rawKind) { throw null; }
        public T? CopyAnnotationsTo<T>(T? node) where T : SyntaxNode { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> DescendantNodes(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> DescendantNodes(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> DescendantNodesAndSelf(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> DescendantNodesAndSelf(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> DescendantNodesAndTokens(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> DescendantNodesAndTokens(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> DescendantNodesAndTokensAndSelf(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> DescendantNodesAndTokensAndSelf(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxToken> DescendantTokens(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxToken> DescendantTokens(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxTrivia> DescendantTrivia(Text.TextSpan span, System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxTrivia> DescendantTrivia(System.Func<SyntaxNode, bool>? descendIntoChildren = null, bool descendIntoTrivia = false) { throw null; }
        protected virtual bool EquivalentToCore(SyntaxNode other) { throw null; }
        public SyntaxNode FindNode(Text.TextSpan span, bool findInsideTrivia = false, bool getInnermostNodeForTie = false) { throw null; }
        public SyntaxToken FindToken(int position, bool findInsideTrivia = false) { throw null; }
        protected virtual SyntaxToken FindTokenCore(int position, bool findInsideTrivia) { throw null; }
        protected virtual SyntaxToken FindTokenCore(int position, System.Func<SyntaxTrivia, bool> stepInto) { throw null; }
        public SyntaxTrivia FindTrivia(int position, bool findInsideTrivia = false) { throw null; }
        public SyntaxTrivia FindTrivia(int position, System.Func<SyntaxTrivia, bool>? stepInto) { throw null; }
        protected virtual SyntaxTrivia FindTriviaCore(int position, bool findInsideTrivia) { throw null; }
        public TNode? FirstAncestorOrSelf<TNode>(System.Func<TNode, bool>? predicate = null, bool ascendOutOfTrivia = true) where TNode : SyntaxNode { throw null; }
        public TNode? FirstAncestorOrSelf<TNode, TArg>(System.Func<TNode, TArg, bool> predicate, TArg argument, bool ascendOutOfTrivia = true) where TNode : SyntaxNode { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> GetAnnotatedNodes(SyntaxAnnotation syntaxAnnotation) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNode> GetAnnotatedNodes(string annotationKind) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> GetAnnotatedNodesAndTokens(SyntaxAnnotation annotation) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> GetAnnotatedNodesAndTokens(string annotationKind) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> GetAnnotatedNodesAndTokens(params string[] annotationKinds) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxToken> GetAnnotatedTokens(SyntaxAnnotation syntaxAnnotation) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxToken> GetAnnotatedTokens(string annotationKind) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxTrivia> GetAnnotatedTrivia(SyntaxAnnotation annotation) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxTrivia> GetAnnotatedTrivia(string annotationKind) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxTrivia> GetAnnotatedTrivia(params string[] annotationKinds) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(System.Collections.Generic.IEnumerable<string> annotationKinds) { throw null; }
        public System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(string annotationKind) { throw null; }
        public System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics() { throw null; }
        public SyntaxToken GetFirstToken(bool includeZeroWidth = false, bool includeSkipped = false, bool includeDirectives = false, bool includeDocumentationComments = false) { throw null; }
        public SyntaxToken GetLastToken(bool includeZeroWidth = false, bool includeSkipped = false, bool includeDirectives = false, bool includeDocumentationComments = false) { throw null; }
        public SyntaxTriviaList GetLeadingTrivia() { throw null; }
        public Location GetLocation() { throw null; }
        protected T? GetRed<T>(ref T? field, int slot) where T : SyntaxNode { throw null; }
        protected T? GetRedAtZero<T>(ref T? field) where T : SyntaxNode { throw null; }
        public SyntaxReference GetReference() { throw null; }
        public Text.SourceText GetText(System.Text.Encoding? encoding = null, Text.SourceHashAlgorithm checksumAlgorithm = Text.SourceHashAlgorithm.Sha1) { throw null; }
        public SyntaxTriviaList GetTrailingTrivia() { throw null; }
        public bool HasAnnotation(SyntaxAnnotation? annotation) { throw null; }
        public bool HasAnnotations(System.Collections.Generic.IEnumerable<string> annotationKinds) { throw null; }
        public bool HasAnnotations(string annotationKind) { throw null; }
        protected internal abstract SyntaxNode InsertNodesInListCore(SyntaxNode nodeInList, System.Collections.Generic.IEnumerable<SyntaxNode> nodesToInsert, bool insertBefore);
        protected internal abstract SyntaxNode InsertTokensInListCore(SyntaxToken originalToken, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens, bool insertBefore);
        protected internal abstract SyntaxNode InsertTriviaInListCore(SyntaxTrivia originalTrivia, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia, bool insertBefore);
        public bool IsEquivalentTo(SyntaxNode node, bool topLevel = false) { throw null; }
        public bool IsEquivalentTo(SyntaxNode? other) { throw null; }
        protected abstract bool IsEquivalentToCore(SyntaxNode node, bool topLevel = false);
        public bool IsIncrementallyIdenticalTo(SyntaxNode? other) { throw null; }
        public bool IsPartOfStructuredTrivia() { throw null; }
        protected internal abstract SyntaxNode NormalizeWhitespaceCore(string indentation, string eol, bool elasticTrivia);
        protected internal abstract SyntaxNode? RemoveNodesCore(System.Collections.Generic.IEnumerable<SyntaxNode> nodes, SyntaxRemoveOptions options);
        protected internal abstract SyntaxNode ReplaceCore<TNode>(System.Collections.Generic.IEnumerable<TNode>? nodes = null, System.Func<TNode, TNode, SyntaxNode>? computeReplacementNode = null, System.Collections.Generic.IEnumerable<SyntaxToken>? tokens = null, System.Func<SyntaxToken, SyntaxToken, SyntaxToken>? computeReplacementToken = null, System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia = null, System.Func<SyntaxTrivia, SyntaxTrivia, SyntaxTrivia>? computeReplacementTrivia = null)
            where TNode : SyntaxNode;
        protected internal abstract SyntaxNode ReplaceNodeInListCore(SyntaxNode originalNode, System.Collections.Generic.IEnumerable<SyntaxNode> replacementNodes);
        protected internal abstract SyntaxNode ReplaceTokenInListCore(SyntaxToken originalToken, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens);
        protected internal abstract SyntaxNode ReplaceTriviaInListCore(SyntaxTrivia originalTrivia, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia);
        [System.Obsolete("Syntax serialization support is no longer supported", true)]
        public virtual void SerializeTo(System.IO.Stream stream, System.Threading.CancellationToken cancellationToken = default) { }
        public virtual string ToFullString() { throw null; }
        public override string ToString() { throw null; }
        public virtual void WriteTo(System.IO.TextWriter writer) { }
    }
    public static partial class SyntaxNodeExtensions
    {
        public static TNode? GetCurrentNode<TNode>(this SyntaxNode root, TNode node) where TNode : SyntaxNode { throw null; }
        public static System.Collections.Generic.IEnumerable<TNode> GetCurrentNodes<TNode>(this SyntaxNode root, TNode node) where TNode : SyntaxNode { throw null; }
        public static System.Collections.Generic.IEnumerable<TNode> GetCurrentNodes<TNode>(this SyntaxNode root, System.Collections.Generic.IEnumerable<TNode> nodes) where TNode : SyntaxNode { throw null; }
        public static TRoot InsertNodesAfter<TRoot>(this TRoot root, SyntaxNode nodeInList, System.Collections.Generic.IEnumerable<SyntaxNode> newNodes) where TRoot : SyntaxNode { throw null; }
        public static TRoot InsertNodesBefore<TRoot>(this TRoot root, SyntaxNode nodeInList, System.Collections.Generic.IEnumerable<SyntaxNode> newNodes) where TRoot : SyntaxNode { throw null; }
        public static TRoot InsertTokensAfter<TRoot>(this TRoot root, SyntaxToken tokenInList, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens) where TRoot : SyntaxNode { throw null; }
        public static TRoot InsertTokensBefore<TRoot>(this TRoot root, SyntaxToken tokenInList, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens) where TRoot : SyntaxNode { throw null; }
        public static TRoot InsertTriviaAfter<TRoot>(this TRoot root, SyntaxTrivia trivia, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia) where TRoot : SyntaxNode { throw null; }
        public static TRoot InsertTriviaBefore<TRoot>(this TRoot root, SyntaxTrivia trivia, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia) where TRoot : SyntaxNode { throw null; }
        public static TNode NormalizeWhitespace<TNode>(this TNode node, string indentation, bool elasticTrivia) where TNode : SyntaxNode { throw null; }
        public static TNode NormalizeWhitespace<TNode>(this TNode node, string indentation = "    ", string eol = "\r\n", bool elasticTrivia = false) where TNode : SyntaxNode { throw null; }
        public static TRoot? RemoveNode<TRoot>(this TRoot root, SyntaxNode node, SyntaxRemoveOptions options) where TRoot : SyntaxNode { throw null; }
        public static TRoot? RemoveNodes<TRoot>(this TRoot root, System.Collections.Generic.IEnumerable<SyntaxNode> nodes, SyntaxRemoveOptions options) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceNode<TRoot>(this TRoot root, SyntaxNode oldNode, SyntaxNode newNode) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceNode<TRoot>(this TRoot root, SyntaxNode oldNode, System.Collections.Generic.IEnumerable<SyntaxNode> newNodes) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceNodes<TRoot, TNode>(this TRoot root, System.Collections.Generic.IEnumerable<TNode> nodes, System.Func<TNode, TNode, SyntaxNode> computeReplacementNode) where TRoot : SyntaxNode where TNode : SyntaxNode { throw null; }
        public static TRoot ReplaceSyntax<TRoot>(this TRoot root, System.Collections.Generic.IEnumerable<SyntaxNode>? nodes, System.Func<SyntaxNode, SyntaxNode, SyntaxNode>? computeReplacementNode, System.Collections.Generic.IEnumerable<SyntaxToken>? tokens, System.Func<SyntaxToken, SyntaxToken, SyntaxToken>? computeReplacementToken, System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia, System.Func<SyntaxTrivia, SyntaxTrivia, SyntaxTrivia>? computeReplacementTrivia) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceToken<TRoot>(this TRoot root, SyntaxToken oldToken, SyntaxToken newToken) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceToken<TRoot>(this TRoot root, SyntaxToken tokenInList, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceTokens<TRoot>(this TRoot root, System.Collections.Generic.IEnumerable<SyntaxToken> tokens, System.Func<SyntaxToken, SyntaxToken, SyntaxToken> computeReplacementToken) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceTrivia<TRoot>(this TRoot root, SyntaxTrivia trivia, SyntaxTrivia newTrivia) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceTrivia<TRoot>(this TRoot root, SyntaxTrivia oldTrivia, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia) where TRoot : SyntaxNode { throw null; }
        public static TRoot ReplaceTrivia<TRoot>(this TRoot root, System.Collections.Generic.IEnumerable<SyntaxTrivia> trivia, System.Func<SyntaxTrivia, SyntaxTrivia, SyntaxTrivia> computeReplacementTrivia) where TRoot : SyntaxNode { throw null; }
        public static TRoot TrackNodes<TRoot>(this TRoot root, params SyntaxNode[] nodes) where TRoot : SyntaxNode { throw null; }
        public static TRoot TrackNodes<TRoot>(this TRoot root, System.Collections.Generic.IEnumerable<SyntaxNode> nodes) where TRoot : SyntaxNode { throw null; }
        public static TSyntax WithLeadingTrivia<TSyntax>(this TSyntax node, params SyntaxTrivia[]? trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithLeadingTrivia<TSyntax>(this TSyntax node, SyntaxTriviaList trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithLeadingTrivia<TSyntax>(this TSyntax node, System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithoutLeadingTrivia<TSyntax>(this TSyntax node) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithoutTrailingTrivia<TSyntax>(this TSyntax node) where TSyntax : SyntaxNode { throw null; }
        public static SyntaxToken WithoutTrivia(this SyntaxToken token) { throw null; }
        public static TSyntax WithoutTrivia<TSyntax>(this TSyntax syntax) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithTrailingTrivia<TSyntax>(this TSyntax node, params SyntaxTrivia[]? trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithTrailingTrivia<TSyntax>(this TSyntax node, SyntaxTriviaList trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithTrailingTrivia<TSyntax>(this TSyntax node, System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia) where TSyntax : SyntaxNode { throw null; }
        public static TSyntax WithTriviaFrom<TSyntax>(this TSyntax syntax, SyntaxNode node) where TSyntax : SyntaxNode { throw null; }
    }
    public readonly partial struct SyntaxNodeOrToken : System.IEquatable<SyntaxNodeOrToken>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public bool ContainsAnnotations { get { throw null; } }
        public bool ContainsDiagnostics { get { throw null; } }
        public bool ContainsDirectives { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }
        public bool HasLeadingTrivia { get { throw null; } }
        public bool HasTrailingTrivia { get { throw null; } }
        public bool IsMissing { get { throw null; } }
        public bool IsNode { get { throw null; } }
        public bool IsToken { get { throw null; } }
        public string Language { get { throw null; } }
        public SyntaxNode? Parent { get { throw null; } }
        public int RawKind { get { throw null; } }
        public Text.TextSpan Span { get { throw null; } }
        public int SpanStart { get { throw null; } }
        public SyntaxTree? SyntaxTree { get { throw null; } }

        public readonly SyntaxNode? AsNode() { throw null; }
        public readonly SyntaxToken AsToken() { throw null; }
        public readonly ChildSyntaxList ChildNodesAndTokens() { throw null; }
        public readonly bool Equals(SyntaxNodeOrToken other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(System.Collections.Generic.IEnumerable<string> annotationKinds) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(string annotationKind) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics() { throw null; }
        public static int GetFirstChildIndexSpanningPosition(SyntaxNode node, int position) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly SyntaxTriviaList GetLeadingTrivia() { throw null; }
        public readonly Location? GetLocation() { throw null; }
        public readonly SyntaxNodeOrToken GetNextSibling() { throw null; }
        public readonly SyntaxNodeOrToken GetPreviousSibling() { throw null; }
        public readonly SyntaxTriviaList GetTrailingTrivia() { throw null; }
        public readonly bool HasAnnotation(SyntaxAnnotation? annotation) { throw null; }
        public readonly bool HasAnnotations(System.Collections.Generic.IEnumerable<string> annotationKinds) { throw null; }
        public readonly bool HasAnnotations(string annotationKind) { throw null; }
        public readonly bool IsEquivalentTo(SyntaxNodeOrToken other) { throw null; }
        public readonly bool IsIncrementallyIdenticalTo(SyntaxNodeOrToken other) { throw null; }
        public static bool operator ==(SyntaxNodeOrToken left, SyntaxNodeOrToken right) { throw null; }
        public static explicit operator SyntaxNode?(SyntaxNodeOrToken nodeOrToken) { throw null; }
        public static explicit operator SyntaxToken(SyntaxNodeOrToken nodeOrToken) { throw null; }
        public static implicit operator SyntaxNodeOrToken(SyntaxNode? node) { throw null; }
        public static implicit operator SyntaxNodeOrToken(SyntaxToken token) { throw null; }
        public static bool operator !=(SyntaxNodeOrToken left, SyntaxNodeOrToken right) { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public readonly SyntaxNodeOrToken WithAdditionalAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxNodeOrToken WithAdditionalAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxNodeOrToken WithLeadingTrivia(params SyntaxTrivia[] trivia) { throw null; }
        public readonly SyntaxNodeOrToken WithLeadingTrivia(System.Collections.Generic.IEnumerable<SyntaxTrivia> trivia) { throw null; }
        public readonly SyntaxNodeOrToken WithoutAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxNodeOrToken WithoutAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxNodeOrToken WithoutAnnotations(string annotationKind) { throw null; }
        public readonly SyntaxNodeOrToken WithTrailingTrivia(params SyntaxTrivia[] trivia) { throw null; }
        public readonly SyntaxNodeOrToken WithTrailingTrivia(System.Collections.Generic.IEnumerable<SyntaxTrivia> trivia) { throw null; }
        public readonly void WriteTo(System.IO.TextWriter writer) { }
    }

    [System.Runtime.CompilerServices.CollectionBuilder(typeof(SyntaxNodeOrTokenList), "Create")]
    public readonly partial struct SyntaxNodeOrTokenList : System.IEquatable<SyntaxNodeOrTokenList>, System.Collections.Generic.IReadOnlyCollection<SyntaxNodeOrToken>, System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>, System.Collections.IEnumerable
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxNodeOrTokenList(params SyntaxNodeOrToken[] nodesAndTokens) { }
        public SyntaxNodeOrTokenList(System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> nodesAndTokens) { }
        public int Count { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }

        public SyntaxNodeOrToken this[int index] { get { throw null; } }

        public Text.TextSpan Span { get { throw null; } }

        public readonly SyntaxNodeOrTokenList Add(SyntaxNodeOrToken nodeOrToken) { throw null; }
        public readonly SyntaxNodeOrTokenList AddRange(System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> nodesOrTokens) { throw null; }
        public readonly bool Any() { throw null; }
        public static SyntaxNodeOrTokenList Create(System.ReadOnlySpan<SyntaxNodeOrToken> nodesAndTokens) { throw null; }
        public readonly bool Equals(SyntaxNodeOrTokenList other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly SyntaxNodeOrToken First() { throw null; }
        public readonly SyntaxNodeOrToken FirstOrDefault() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly int IndexOf(SyntaxNodeOrToken nodeOrToken) { throw null; }
        public readonly SyntaxNodeOrTokenList Insert(int index, SyntaxNodeOrToken nodeOrToken) { throw null; }
        public readonly SyntaxNodeOrTokenList InsertRange(int index, System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> nodesAndTokens) { throw null; }
        public readonly SyntaxNodeOrToken Last() { throw null; }
        public readonly SyntaxNodeOrToken LastOrDefault() { throw null; }
        public static bool operator ==(SyntaxNodeOrTokenList left, SyntaxNodeOrTokenList right) { throw null; }
        public static bool operator !=(SyntaxNodeOrTokenList left, SyntaxNodeOrTokenList right) { throw null; }
        public readonly SyntaxNodeOrTokenList Remove(SyntaxNodeOrToken nodeOrTokenInList) { throw null; }
        public readonly SyntaxNodeOrTokenList RemoveAt(int index) { throw null; }
        public readonly SyntaxNodeOrTokenList Replace(SyntaxNodeOrToken nodeOrTokenInList, SyntaxNodeOrToken newNodeOrToken) { throw null; }
        public readonly SyntaxNodeOrTokenList ReplaceRange(SyntaxNodeOrToken nodeOrTokenInList, System.Collections.Generic.IEnumerable<SyntaxNodeOrToken> newNodesAndTokens) { throw null; }
        readonly System.Collections.Generic.IEnumerator<SyntaxNodeOrToken> System.Collections.Generic.IEnumerable<SyntaxNodeOrToken>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public partial struct Enumerator : System.Collections.Generic.IEnumerator<SyntaxNodeOrToken>, System.Collections.IEnumerator, System.IDisposable
        {
            private object _dummy;
            private int _dummyPrimitive;
            public SyntaxNodeOrToken Current { get { throw null; } }

            object System.Collections.IEnumerator.Current { get { throw null; } }

            public override bool Equals(object? obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public bool MoveNext() { throw null; }
            void System.Collections.IEnumerator.Reset() { }
            void System.IDisposable.Dispose() { }
        }
    }

    public delegate ISyntaxReceiver SyntaxReceiverCreator();
    public abstract partial class SyntaxReference
    {
        public abstract Text.TextSpan Span { get; }
        public abstract SyntaxTree SyntaxTree { get; }

        public abstract SyntaxNode GetSyntax(System.Threading.CancellationToken cancellationToken = default);
        public virtual System.Threading.Tasks.Task<SyntaxNode> GetSyntaxAsync(System.Threading.CancellationToken cancellationToken = default) { throw null; }
    }
    [System.Flags]
    public enum SyntaxRemoveOptions
    {
        KeepNoTrivia = 0,
        KeepLeadingTrivia = 1,
        KeepTrailingTrivia = 2,
        KeepExteriorTrivia = 3,
        KeepUnbalancedDirectives = 4,
        KeepDirectives = 8,
        KeepEndOfLine = 16,
        AddElasticMarker = 32
    }

    public readonly partial struct SyntaxToken : System.IEquatable<SyntaxToken>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public bool ContainsAnnotations { get { throw null; } }
        public bool ContainsDiagnostics { get { throw null; } }
        public bool ContainsDirectives { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }
        public bool HasLeadingTrivia { get { throw null; } }
        public bool HasStructuredTrivia { get { throw null; } }
        public bool HasTrailingTrivia { get { throw null; } }
        public bool IsMissing { get { throw null; } }
        public string Language { get { throw null; } }
        public SyntaxTriviaList LeadingTrivia { get { throw null; } }
        public SyntaxNode? Parent { get { throw null; } }
        public int RawKind { get { throw null; } }
        public Text.TextSpan Span { get { throw null; } }
        public int SpanStart { get { throw null; } }
        public SyntaxTree? SyntaxTree { get { throw null; } }
        public string Text { get { throw null; } }
        public SyntaxTriviaList TrailingTrivia { get { throw null; } }
        public object? Value { get { throw null; } }
        public string ValueText { get { throw null; } }

        public readonly SyntaxToken CopyAnnotationsTo(SyntaxToken token) { throw null; }
        public readonly bool Equals(SyntaxToken other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxTrivia> GetAllTrivia() { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(System.Collections.Generic.IEnumerable<string> annotationKinds) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(string annotationKind) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(params string[] annotationKinds) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly Location GetLocation() { throw null; }
        public readonly SyntaxToken GetNextToken(bool includeZeroWidth = false, bool includeSkipped = false, bool includeDirectives = false, bool includeDocumentationComments = false) { throw null; }
        public readonly SyntaxToken GetPreviousToken(bool includeZeroWidth = false, bool includeSkipped = false, bool includeDirectives = false, bool includeDocumentationComments = false) { throw null; }
        public readonly bool HasAnnotation(SyntaxAnnotation? annotation) { throw null; }
        public readonly bool HasAnnotations(string annotationKind) { throw null; }
        public readonly bool HasAnnotations(params string[] annotationKinds) { throw null; }
        public readonly bool IsEquivalentTo(SyntaxToken token) { throw null; }
        public readonly bool IsIncrementallyIdenticalTo(SyntaxToken token) { throw null; }
        public readonly bool IsPartOfStructuredTrivia() { throw null; }
        public static bool operator ==(SyntaxToken left, SyntaxToken right) { throw null; }
        public static bool operator !=(SyntaxToken left, SyntaxToken right) { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public readonly SyntaxToken WithAdditionalAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxToken WithAdditionalAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxToken WithLeadingTrivia(params SyntaxTrivia[]? trivia) { throw null; }
        public readonly SyntaxToken WithLeadingTrivia(SyntaxTriviaList trivia) { throw null; }
        public readonly SyntaxToken WithLeadingTrivia(System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia) { throw null; }
        public readonly SyntaxToken WithoutAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxToken WithoutAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxToken WithoutAnnotations(string annotationKind) { throw null; }
        public readonly SyntaxToken WithTrailingTrivia(params SyntaxTrivia[]? trivia) { throw null; }
        public readonly SyntaxToken WithTrailingTrivia(SyntaxTriviaList trivia) { throw null; }
        public readonly SyntaxToken WithTrailingTrivia(System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivia) { throw null; }
        public readonly SyntaxToken WithTriviaFrom(SyntaxToken token) { throw null; }
        public readonly void WriteTo(System.IO.TextWriter writer) { }
    }

    [System.Runtime.CompilerServices.CollectionBuilder(typeof(SyntaxTokenList), "Create")]
    public readonly partial struct SyntaxTokenList : System.IEquatable<SyntaxTokenList>, System.Collections.Generic.IReadOnlyList<SyntaxToken>, System.Collections.Generic.IEnumerable<SyntaxToken>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<SyntaxToken>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxTokenList(SyntaxToken token) { }
        public SyntaxTokenList(params SyntaxToken[] tokens) { }
        public SyntaxTokenList(System.Collections.Generic.IEnumerable<SyntaxToken> tokens) { }
        public int Count { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }

        public SyntaxToken this[int index] { get { throw null; } }

        public Text.TextSpan Span { get { throw null; } }

        public readonly SyntaxTokenList Add(SyntaxToken token) { throw null; }
        public readonly SyntaxTokenList AddRange(System.Collections.Generic.IEnumerable<SyntaxToken> tokens) { throw null; }
        public readonly bool Any() { throw null; }
        public static SyntaxTokenList Create(SyntaxToken token) { throw null; }
        public static SyntaxTokenList Create(System.ReadOnlySpan<SyntaxToken> tokens) { throw null; }
        public readonly bool Equals(SyntaxTokenList other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly SyntaxToken First() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly int IndexOf(SyntaxToken tokenInList) { throw null; }
        public readonly SyntaxTokenList Insert(int index, SyntaxToken token) { throw null; }
        public readonly SyntaxTokenList InsertRange(int index, System.Collections.Generic.IEnumerable<SyntaxToken> tokens) { throw null; }
        public readonly SyntaxToken Last() { throw null; }
        public static bool operator ==(SyntaxTokenList left, SyntaxTokenList right) { throw null; }
        public static bool operator !=(SyntaxTokenList left, SyntaxTokenList right) { throw null; }
        public readonly SyntaxTokenList Remove(SyntaxToken tokenInList) { throw null; }
        public readonly SyntaxTokenList RemoveAt(int index) { throw null; }
        public readonly SyntaxTokenList Replace(SyntaxToken tokenInList, SyntaxToken newToken) { throw null; }
        public readonly SyntaxTokenList ReplaceRange(SyntaxToken tokenInList, System.Collections.Generic.IEnumerable<SyntaxToken> newTokens) { throw null; }
        public readonly Reversed Reverse() { throw null; }
        readonly System.Collections.Generic.IEnumerator<SyntaxToken> System.Collections.Generic.IEnumerable<SyntaxToken>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public partial struct Enumerator
        {
            private object _dummy;
            private int _dummyPrimitive;
            public SyntaxToken Current { get { throw null; } }

            public override bool Equals(object? obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public bool MoveNext() { throw null; }
        }

        public readonly partial struct Reversed : System.Collections.Generic.IEnumerable<SyntaxToken>, System.Collections.IEnumerable, System.IEquatable<Reversed>
        {
            private readonly object _dummy;
            private readonly int _dummyPrimitive;
            public Reversed(SyntaxTokenList list) { }
            public readonly bool Equals(Reversed other) { throw null; }
            public override readonly bool Equals(object? obj) { throw null; }
            public readonly Enumerator GetEnumerator() { throw null; }
            public override readonly int GetHashCode() { throw null; }
            readonly System.Collections.Generic.IEnumerator<SyntaxToken> System.Collections.Generic.IEnumerable<SyntaxToken>.GetEnumerator() { throw null; }
            readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
            public partial struct Enumerator
            {
                private object _dummy;
                private int _dummyPrimitive;
                public SyntaxToken Current { get { throw null; } }

                public override bool Equals(object? obj) { throw null; }
                public override int GetHashCode() { throw null; }
                public bool MoveNext() { throw null; }
            }
        }
    }

    public abstract partial class SyntaxTree
    {
        protected internal static readonly System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> EmptyDiagnosticOptions;
        [System.Obsolete("Obsolete due to performance problems, use CompilationOptions.SyntaxTreeOptionsProvider instead", false)]
        public virtual System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> DiagnosticOptions { get { throw null; } }
        public abstract System.Text.Encoding? Encoding { get; }
        public abstract string FilePath { get; }
        public abstract bool HasCompilationUnitRoot { get; }
        public abstract int Length { get; }
        public ParseOptions Options { get { throw null; } }
        protected abstract ParseOptions OptionsCore { get; }

        public abstract System.Collections.Generic.IList<Text.TextSpan> GetChangedSpans(SyntaxTree syntaxTree);
        public abstract System.Collections.Generic.IList<Text.TextChange> GetChanges(SyntaxTree oldTree);
        public abstract System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics(SyntaxNode node);
        public abstract System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics(SyntaxNodeOrToken nodeOrToken);
        public abstract System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics(SyntaxToken token);
        public abstract System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics(SyntaxTrivia trivia);
        public abstract System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics(System.Threading.CancellationToken cancellationToken = default);
        public abstract System.Collections.Generic.IEnumerable<LineMapping> GetLineMappings(System.Threading.CancellationToken cancellationToken = default);
        public abstract FileLinePositionSpan GetLineSpan(Text.TextSpan span, System.Threading.CancellationToken cancellationToken = default);
        public virtual LineVisibility GetLineVisibility(int position, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public abstract Location GetLocation(Text.TextSpan span);
        public abstract FileLinePositionSpan GetMappedLineSpan(Text.TextSpan span, System.Threading.CancellationToken cancellationToken = default);
        public abstract SyntaxReference GetReference(SyntaxNode node);
        public SyntaxNode GetRoot(System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public System.Threading.Tasks.Task<SyntaxNode> GetRootAsync(System.Threading.CancellationToken cancellationToken = default) { throw null; }
        protected abstract System.Threading.Tasks.Task<SyntaxNode> GetRootAsyncCore(System.Threading.CancellationToken cancellationToken);
        protected abstract SyntaxNode GetRootCore(System.Threading.CancellationToken cancellationToken);
        public abstract Text.SourceText GetText(System.Threading.CancellationToken cancellationToken = default);
        public virtual System.Threading.Tasks.Task<Text.SourceText> GetTextAsync(System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public abstract bool HasHiddenRegions();
        public abstract bool IsEquivalentTo(SyntaxTree tree, bool topLevel = false);
        public override string ToString() { throw null; }
        public bool TryGetRoot(out SyntaxNode? root) { throw null; }
        protected abstract bool TryGetRootCore(out SyntaxNode? root);
        public abstract bool TryGetText(out Text.SourceText? text);
        public abstract SyntaxTree WithChangedText(Text.SourceText newText);
        [System.Obsolete("Obsolete due to performance problems, use CompilationOptions.SyntaxTreeOptionsProvider instead", false)]
        public virtual SyntaxTree WithDiagnosticOptions(System.Collections.Immutable.ImmutableDictionary<string, ReportDiagnostic> options) { throw null; }
        public abstract SyntaxTree WithFilePath(string path);
        public abstract SyntaxTree WithRootAndOptions(SyntaxNode root, ParseOptions options);
    }
    public abstract partial class SyntaxTreeOptionsProvider
    {
        public abstract GeneratedKind IsGenerated(SyntaxTree tree, System.Threading.CancellationToken cancellationToken);
        public abstract bool TryGetDiagnosticValue(SyntaxTree tree, string diagnosticId, System.Threading.CancellationToken cancellationToken, out ReportDiagnostic severity);
        public abstract bool TryGetGlobalDiagnosticValue(string diagnosticId, System.Threading.CancellationToken cancellationToken, out ReportDiagnostic severity);
    }
    public readonly partial struct SyntaxTrivia : System.IEquatable<SyntaxTrivia>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public bool ContainsDiagnostics { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }
        public bool HasStructure { get { throw null; } }
        public bool IsDirective { get { throw null; } }
        public string Language { get { throw null; } }
        public int RawKind { get { throw null; } }
        public Text.TextSpan Span { get { throw null; } }
        public int SpanStart { get { throw null; } }
        public SyntaxTree? SyntaxTree { get { throw null; } }
        public SyntaxToken Token { get { throw null; } }

        public readonly SyntaxTrivia CopyAnnotationsTo(SyntaxTrivia trivia) { throw null; }
        public readonly bool Equals(SyntaxTrivia other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(string annotationKind) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<SyntaxAnnotation> GetAnnotations(params string[] annotationKinds) { throw null; }
        public readonly System.Collections.Generic.IEnumerable<Diagnostic> GetDiagnostics() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly Location GetLocation() { throw null; }
        public readonly SyntaxNode? GetStructure() { throw null; }
        public readonly bool HasAnnotation(SyntaxAnnotation? annotation) { throw null; }
        public readonly bool HasAnnotations(string annotationKind) { throw null; }
        public readonly bool HasAnnotations(params string[] annotationKinds) { throw null; }
        public readonly bool IsEquivalentTo(SyntaxTrivia trivia) { throw null; }
        public readonly bool IsPartOfStructuredTrivia() { throw null; }
        public static bool operator ==(SyntaxTrivia left, SyntaxTrivia right) { throw null; }
        public static bool operator !=(SyntaxTrivia left, SyntaxTrivia right) { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public readonly SyntaxTrivia WithAdditionalAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxTrivia WithAdditionalAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxTrivia WithoutAnnotations(params SyntaxAnnotation[] annotations) { throw null; }
        public readonly SyntaxTrivia WithoutAnnotations(System.Collections.Generic.IEnumerable<SyntaxAnnotation> annotations) { throw null; }
        public readonly SyntaxTrivia WithoutAnnotations(string annotationKind) { throw null; }
        public readonly void WriteTo(System.IO.TextWriter writer) { }
    }

    [System.Runtime.CompilerServices.CollectionBuilder(typeof(SyntaxTriviaList), "Create")]
    public readonly partial struct SyntaxTriviaList : System.IEquatable<SyntaxTriviaList>, System.Collections.Generic.IReadOnlyList<SyntaxTrivia>, System.Collections.Generic.IEnumerable<SyntaxTrivia>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<SyntaxTrivia>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SyntaxTriviaList(SyntaxTrivia trivia) { }
        public SyntaxTriviaList(params SyntaxTrivia[] trivias) { }
        public SyntaxTriviaList(System.Collections.Generic.IEnumerable<SyntaxTrivia>? trivias) { }
        public int Count { get { throw null; } }
        public static SyntaxTriviaList Empty { get { throw null; } }
        public Text.TextSpan FullSpan { get { throw null; } }

        public SyntaxTrivia this[int index] { get { throw null; } }

        public Text.TextSpan Span { get { throw null; } }

        public readonly SyntaxTriviaList Add(SyntaxTrivia trivia) { throw null; }
        public readonly SyntaxTriviaList AddRange(System.Collections.Generic.IEnumerable<SyntaxTrivia> trivia) { throw null; }
        public readonly bool Any() { throw null; }
        public static SyntaxTriviaList Create(SyntaxTrivia trivia) { throw null; }
        public static SyntaxTriviaList Create(System.ReadOnlySpan<SyntaxTrivia> trivias) { throw null; }
        public readonly SyntaxTrivia ElementAt(int index) { throw null; }
        public readonly bool Equals(SyntaxTriviaList other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public readonly SyntaxTrivia First() { throw null; }
        public readonly Enumerator GetEnumerator() { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly int IndexOf(SyntaxTrivia triviaInList) { throw null; }
        public readonly SyntaxTriviaList Insert(int index, SyntaxTrivia trivia) { throw null; }
        public readonly SyntaxTriviaList InsertRange(int index, System.Collections.Generic.IEnumerable<SyntaxTrivia> trivia) { throw null; }
        public readonly SyntaxTrivia Last() { throw null; }
        public static bool operator ==(SyntaxTriviaList left, SyntaxTriviaList right) { throw null; }
        public static bool operator !=(SyntaxTriviaList left, SyntaxTriviaList right) { throw null; }
        public readonly SyntaxTriviaList Remove(SyntaxTrivia triviaInList) { throw null; }
        public readonly SyntaxTriviaList RemoveAt(int index) { throw null; }
        public readonly SyntaxTriviaList Replace(SyntaxTrivia triviaInList, SyntaxTrivia newTrivia) { throw null; }
        public readonly SyntaxTriviaList ReplaceRange(SyntaxTrivia triviaInList, System.Collections.Generic.IEnumerable<SyntaxTrivia> newTrivia) { throw null; }
        public readonly Reversed Reverse() { throw null; }
        readonly System.Collections.Generic.IEnumerator<SyntaxTrivia> System.Collections.Generic.IEnumerable<SyntaxTrivia>.GetEnumerator() { throw null; }
        readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public readonly string ToFullString() { throw null; }
        public override readonly string ToString() { throw null; }
        public partial struct Enumerator
        {
            private object _dummy;
            private int _dummyPrimitive;
            public SyntaxTrivia Current { get { throw null; } }

            public bool MoveNext() { throw null; }
        }

        public readonly partial struct Reversed : System.Collections.Generic.IEnumerable<SyntaxTrivia>, System.Collections.IEnumerable, System.IEquatable<Reversed>
        {
            private readonly object _dummy;
            private readonly int _dummyPrimitive;
            public Reversed(SyntaxTriviaList list) { }
            public readonly bool Equals(Reversed other) { throw null; }
            public override readonly bool Equals(object? obj) { throw null; }
            public readonly Enumerator GetEnumerator() { throw null; }
            public override readonly int GetHashCode() { throw null; }
            readonly System.Collections.Generic.IEnumerator<SyntaxTrivia> System.Collections.Generic.IEnumerable<SyntaxTrivia>.GetEnumerator() { throw null; }
            readonly System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
            public partial struct Enumerator
            {
                private object _dummy;
                private int _dummyPrimitive;
                public SyntaxTrivia Current { get { throw null; } }

                public bool MoveNext() { throw null; }
            }
        }
    }

    public readonly partial struct SyntaxValueProvider
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public readonly IncrementalValuesProvider<T> CreateSyntaxProvider<T>(System.Func<SyntaxNode, System.Threading.CancellationToken, bool> predicate, System.Func<GeneratorSyntaxContext, System.Threading.CancellationToken, T> transform) { throw null; }
        public readonly IncrementalValuesProvider<T> ForAttributeWithMetadataName<T>(string fullyQualifiedMetadataName, System.Func<SyntaxNode, System.Threading.CancellationToken, bool> predicate, System.Func<GeneratorAttributeSyntaxContext, System.Threading.CancellationToken, T> transform) { throw null; }
    }

    public abstract partial class SyntaxWalker
    {
        protected SyntaxWalker(SyntaxWalkerDepth depth = SyntaxWalkerDepth.Node) { }
        protected SyntaxWalkerDepth Depth { get { throw null; } }

        public virtual void Visit(SyntaxNode node) { }
        protected virtual void VisitToken(SyntaxToken token) { }
        protected virtual void VisitTrivia(SyntaxTrivia trivia) { }
    }
    public enum SyntaxWalkerDepth
    {
        Node = 0,
        Token = 1,
        Trivia = 2,
        StructuredTrivia = 3
    }

    public readonly partial struct TypedConstant : System.IEquatable<TypedConstant>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public bool IsNull { get { throw null; } }
        public TypedConstantKind Kind { get { throw null; } }
        public ITypeSymbol? Type { get { throw null; } }
        public object? Value { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<TypedConstant> Values { get { throw null; } }

        public readonly bool Equals(TypedConstant other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public enum TypedConstantKind
    {
        Error = 0,
        Primitive = 1,
        Enum = 2,
        Type = 3,
        Array = 4
    }

    public readonly partial struct TypeInfo : System.IEquatable<TypeInfo>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public NullabilityInfo ConvertedNullability { get { throw null; } }
        public ITypeSymbol? ConvertedType { get { throw null; } }
        public NullabilityInfo Nullability { get { throw null; } }
        public ITypeSymbol? Type { get { throw null; } }

        public readonly bool Equals(TypeInfo other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public enum TypeKind : byte
    {
        Unknown = 0,
        Array = 1,
        Class = 2,
        Delegate = 3,
        Dynamic = 4,
        Enum = 5,
        Error = 6,
        Interface = 7,
        Module = 8,
        Pointer = 9,
        Struct = 10,
        Structure = 10,
        TypeParameter = 11,
        Submission = 12,
        FunctionPointer = 13
    }

    public enum TypeParameterKind
    {
        Type = 0,
        Method = 1,
        Cref = 2
    }

    public sealed partial class UnresolvedMetadataReference : MetadataReference
    {
        internal UnresolvedMetadataReference() : base(default) { }
        public override string Display { get { throw null; } }
        public string Reference { get { throw null; } }
    }

    public enum VarianceKind : short
    {
        None = 0,
        Out = 1,
        In = 2
    }

    public static partial class WellKnownDiagnosticTags
    {
        public const string AnalyzerException = "AnalyzerException";
        public const string Build = "Build";
        public const string CompilationEnd = "CompilationEnd";
        public const string Compiler = "Compiler";
        public const string CustomObsolete = "CustomObsolete";
        public const string CustomSeverityConfigurable = "CustomSeverityConfigurable";
        public const string EditAndContinue = "EditAndContinue";
        public const string NotConfigurable = "NotConfigurable";
        public const string Telemetry = "Telemetry";
        public const string Unnecessary = "Unnecessary";
    }
    public static partial class WellKnownGeneratorInputs
    {
        public const string AdditionalTexts = "AdditionalTexts";
        public const string AnalyzerConfigOptions = "AnalyzerConfigOptions";
        public const string Compilation = "Compilation";
        public const string MetadataReferences = "MetadataReferences";
        public const string ParseOptions = "ParseOptions";
    }
    public static partial class WellKnownGeneratorOutputs
    {
        public const string ImplementationSourceOutput = "ImplementationSourceOutput";
        public const string SourceOutput = "SourceOutput";
    }
    public static partial class WellKnownMemberNames
    {
        public const string AdditionOperatorName = "op_Addition";
        public const string BitwiseAndOperatorName = "op_BitwiseAnd";
        public const string BitwiseOrOperatorName = "op_BitwiseOr";
        public const string CheckedAdditionOperatorName = "op_CheckedAddition";
        public const string CheckedDecrementOperatorName = "op_CheckedDecrement";
        public const string CheckedDivisionOperatorName = "op_CheckedDivision";
        public const string CheckedExplicitConversionName = "op_CheckedExplicit";
        public const string CheckedIncrementOperatorName = "op_CheckedIncrement";
        public const string CheckedMultiplyOperatorName = "op_CheckedMultiply";
        public const string CheckedSubtractionOperatorName = "op_CheckedSubtraction";
        public const string CheckedUnaryNegationOperatorName = "op_CheckedUnaryNegation";
        public const string CollectionInitializerAddMethodName = "Add";
        public const string ConcatenateOperatorName = "op_Concatenate";
        public const string CountPropertyName = "Count";
        public const string CurrentPropertyName = "Current";
        public const string DeconstructMethodName = "Deconstruct";
        public const string DecrementOperatorName = "op_Decrement";
        public const string DefaultScriptClassName = "Script";
        public const string DelegateBeginInvokeName = "BeginInvoke";
        public const string DelegateEndInvokeName = "EndInvoke";
        public const string DelegateInvokeName = "Invoke";
        public const string DestructorName = "Finalize";
        public const string DisposeAsyncMethodName = "DisposeAsync";
        public const string DisposeMethodName = "Dispose";
        public const string DivisionOperatorName = "op_Division";
        public const string EntryPointMethodName = "Main";
        public const string EnumBackingFieldName = "value__";
        public const string EqualityOperatorName = "op_Equality";
        public const string ExclusiveOrOperatorName = "op_ExclusiveOr";
        public const string ExplicitConversionName = "op_Explicit";
        public const string ExponentOperatorName = "op_Exponent";
        public const string FalseOperatorName = "op_False";
        public const string GetAsyncEnumeratorMethodName = "GetAsyncEnumerator";
        public const string GetAwaiter = "GetAwaiter";
        public const string GetEnumeratorMethodName = "GetEnumerator";
        public const string GetResult = "GetResult";
        public const string GreaterThanOperatorName = "op_GreaterThan";
        public const string GreaterThanOrEqualOperatorName = "op_GreaterThanOrEqual";
        public const string ImplicitConversionName = "op_Implicit";
        public const string IncrementOperatorName = "op_Increment";
        public const string Indexer = "this[]";
        public const string InequalityOperatorName = "op_Inequality";
        public const string InstanceConstructorName = ".ctor";
        public const string IntegerDivisionOperatorName = "op_IntegerDivision";
        public const string IsCompleted = "IsCompleted";
        public const string LeftShiftOperatorName = "op_LeftShift";
        public const string LengthPropertyName = "Length";
        public const string LessThanOperatorName = "op_LessThan";
        public const string LessThanOrEqualOperatorName = "op_LessThanOrEqual";
        public const string LikeOperatorName = "op_Like";
        public const string LogicalAndOperatorName = "op_LogicalAnd";
        public const string LogicalNotOperatorName = "op_LogicalNot";
        public const string LogicalOrOperatorName = "op_LogicalOr";
        public const string ModulusOperatorName = "op_Modulus";
        public const string MoveNextAsyncMethodName = "MoveNextAsync";
        public const string MoveNextMethodName = "MoveNext";
        public const string MultiplyOperatorName = "op_Multiply";
        public const string ObjectEquals = "Equals";
        public const string ObjectGetHashCode = "GetHashCode";
        public const string ObjectToString = "ToString";
        public const string OnCompleted = "OnCompleted";
        public const string OnesComplementOperatorName = "op_OnesComplement";
        public const string PrintMembersMethodName = "PrintMembers";
        public const string RightShiftOperatorName = "op_RightShift";
        public const string SliceMethodName = "Slice";
        public const string StaticConstructorName = ".cctor";
        public const string SubtractionOperatorName = "op_Subtraction";
        public const string TopLevelStatementsEntryPointMethodName = "<Main>$";
        public const string TopLevelStatementsEntryPointTypeName = "Program";
        public const string TrueOperatorName = "op_True";
        public const string UnaryNegationOperatorName = "op_UnaryNegation";
        public const string UnaryPlusOperatorName = "op_UnaryPlus";
        public const string UnsignedLeftShiftOperatorName = "op_UnsignedLeftShift";
        public const string UnsignedRightShiftOperatorName = "op_UnsignedRightShift";
        public const string ValuePropertyName = "Value";
    }
    public partial class XmlFileResolver : XmlReferenceResolver
    {
        public XmlFileResolver(string? baseDirectory) { }
        public string? BaseDirectory { get { throw null; } }
        public static XmlFileResolver Default { get { throw null; } }

        public override bool Equals(object? obj) { throw null; }
        protected virtual bool FileExists(string? resolvedPath) { throw null; }
        public override int GetHashCode() { throw null; }
        public override System.IO.Stream OpenRead(string resolvedPath) { throw null; }
        public override string? ResolveReference(string path, string? baseFilePath) { throw null; }
    }

    public abstract partial class XmlReferenceResolver
    {
        public abstract override bool Equals(object? other);
        public abstract override int GetHashCode();
        public abstract System.IO.Stream OpenRead(string resolvedPath);
        public abstract string? ResolveReference(string path, string? baseFilePath);
    }
}

namespace Microsoft.CodeAnalysis.Diagnostics
{
    public readonly partial struct AdditionalFileAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public AdditionalText AdditionalFile { get { throw null; } }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public sealed partial class AdditionalTextValueProvider<TValue>
    {
        public AdditionalTextValueProvider(System.Func<AdditionalText, TValue> computeValue, System.Collections.Generic.IEqualityComparer<AdditionalText>? additionalTextComparer = null) { }
    }
    public abstract partial class AnalysisContext
    {
        public virtual DiagnosticSeverity MinimumReportedSeverity { get { throw null; } }

        public virtual void ConfigureGeneratedCodeAnalysis(GeneratedCodeAnalysisFlags analysisMode) { }
        public virtual void EnableConcurrentExecution() { }
        public virtual void RegisterAdditionalFileAction(System.Action<AdditionalFileAnalysisContext> action) { }
        public abstract void RegisterCodeBlockAction(System.Action<CodeBlockAnalysisContext> action);
        public abstract void RegisterCodeBlockStartAction<TLanguageKindEnum>(System.Action<CodeBlockStartAnalysisContext<TLanguageKindEnum>> action)
            where TLanguageKindEnum : struct;
        public abstract void RegisterCompilationAction(System.Action<CompilationAnalysisContext> action);
        public abstract void RegisterCompilationStartAction(System.Action<CompilationStartAnalysisContext> action);
        public void RegisterOperationAction(System.Action<OperationAnalysisContext> action, params OperationKind[] operationKinds) { }
        public virtual void RegisterOperationAction(System.Action<OperationAnalysisContext> action, System.Collections.Immutable.ImmutableArray<OperationKind> operationKinds) { }
        public virtual void RegisterOperationBlockAction(System.Action<OperationBlockAnalysisContext> action) { }
        public virtual void RegisterOperationBlockStartAction(System.Action<OperationBlockStartAnalysisContext> action) { }
        public abstract void RegisterSemanticModelAction(System.Action<SemanticModelAnalysisContext> action);
        public void RegisterSymbolAction(System.Action<SymbolAnalysisContext> action, params SymbolKind[] symbolKinds) { }
        public abstract void RegisterSymbolAction(System.Action<SymbolAnalysisContext> action, System.Collections.Immutable.ImmutableArray<SymbolKind> symbolKinds);
        public virtual void RegisterSymbolStartAction(System.Action<SymbolStartAnalysisContext> action, SymbolKind symbolKind) { }
        public void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, params TLanguageKindEnum[] syntaxKinds) where TLanguageKindEnum : struct { }
        public abstract void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, System.Collections.Immutable.ImmutableArray<TLanguageKindEnum> syntaxKinds)
                                                                                                                                                                                                      where TLanguageKindEnum : struct;
        public abstract void RegisterSyntaxTreeAction(System.Action<SyntaxTreeAnalysisContext> action);
        public bool TryGetValue<TValue>(AdditionalText text, AdditionalTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
        public bool TryGetValue<TValue>(Text.SourceText text, SourceTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
    }
    public partial class AnalysisResult
    {
        internal AnalysisResult() { }
        public System.Collections.Immutable.ImmutableDictionary<AdditionalText, System.Collections.Immutable.ImmutableDictionary<DiagnosticAnalyzer, System.Collections.Immutable.ImmutableArray<Diagnostic>>> AdditionalFileDiagnostics { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> Analyzers { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<DiagnosticAnalyzer, Telemetry.AnalyzerTelemetryInfo> AnalyzerTelemetryInfo { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<DiagnosticAnalyzer, System.Collections.Immutable.ImmutableArray<Diagnostic>> CompilationDiagnostics { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<SyntaxTree, System.Collections.Immutable.ImmutableDictionary<DiagnosticAnalyzer, System.Collections.Immutable.ImmutableArray<Diagnostic>>> SemanticDiagnostics { get { throw null; } }
        public System.Collections.Immutable.ImmutableDictionary<SyntaxTree, System.Collections.Immutable.ImmutableDictionary<DiagnosticAnalyzer, System.Collections.Immutable.ImmutableArray<Diagnostic>>> SyntaxDiagnostics { get { throw null; } }

        public System.Collections.Immutable.ImmutableArray<Diagnostic> GetAllDiagnostics() { throw null; }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> GetAllDiagnostics(DiagnosticAnalyzer analyzer) { throw null; }
    }
    public abstract partial class AnalyzerConfigOptions
    {
        public static System.StringComparer KeyComparer { get { throw null; } }
        public virtual System.Collections.Generic.IEnumerable<string> Keys { get { throw null; } }

        public abstract bool TryGetValue(string key, out string? value);
    }
    public abstract partial class AnalyzerConfigOptionsProvider
    {
        public abstract AnalyzerConfigOptions GlobalOptions { get; }

        public abstract AnalyzerConfigOptions GetOptions(AdditionalText textFile);
        public abstract AnalyzerConfigOptions GetOptions(SyntaxTree tree);
    }
    public sealed partial class AnalyzerFileReference : AnalyzerReference, System.IEquatable<AnalyzerReference>
    {
        public AnalyzerFileReference(string fullPath, IAnalyzerAssemblyLoader assemblyLoader) { }
        public IAnalyzerAssemblyLoader AssemblyLoader { get { throw null; } }
        public override string Display { get { throw null; } }
        public override string FullPath { get { throw null; } }
        public override object Id { get { throw null; } }

        public event System.EventHandler<AnalyzerLoadFailureEventArgs>? AnalyzerLoadFailed {
            add { }
            remove { }
        }

        public bool Equals(AnalyzerFileReference? other) { throw null; }
        public bool Equals(AnalyzerReference? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzers(string language) { throw null; }
        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzersForAllLanguages() { throw null; }
        public System.Reflection.Assembly GetAssembly() { throw null; }
        [System.Obsolete("Use GetGenerators(string language) or GetGeneratorsForAllLanguages()")]
        public override System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGenerators() { throw null; }
        public override System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGenerators(string language) { throw null; }
        public override System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGeneratorsForAllLanguages() { throw null; }
        public override int GetHashCode() { throw null; }
    }

    public sealed partial class AnalyzerImageReference : AnalyzerReference
    {
        public AnalyzerImageReference(System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, string? fullPath = null, string? display = null) { }
        public override string Display { get { throw null; } }
        public override string? FullPath { get { throw null; } }
        public override object Id { get { throw null; } }

        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzers(string language) { throw null; }
        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzersForAllLanguages() { throw null; }
    }

    public sealed partial class AnalyzerLoadFailureEventArgs : System.EventArgs
    {
        public AnalyzerLoadFailureEventArgs(FailureErrorCode errorCode, string message, System.Exception? exceptionOpt = null, string? typeNameOpt = null) { }
        public FailureErrorCode ErrorCode { get { throw null; } }
        public System.Exception? Exception { get { throw null; } }
        public string Message { get { throw null; } }
        public System.Version? ReferencedCompilerVersion { get { throw null; } }
        public string? TypeName { get { throw null; } }

        public enum FailureErrorCode
        {
            None = 0,
            UnableToLoadAnalyzer = 1,
            UnableToCreateAnalyzer = 2,
            NoAnalyzers = 3,
            ReferencesFramework = 4,
            ReferencesNewerCompiler = 5
        }
    }

    public partial class AnalyzerOptions
    {
        public AnalyzerOptions(System.Collections.Immutable.ImmutableArray<AdditionalText> additionalFiles, AnalyzerConfigOptionsProvider optionsProvider) { }
        public AnalyzerOptions(System.Collections.Immutable.ImmutableArray<AdditionalText> additionalFiles) { }
        public System.Collections.Immutable.ImmutableArray<AdditionalText> AdditionalFiles { get { throw null; } }
        public AnalyzerConfigOptionsProvider AnalyzerConfigOptionsProvider { get { throw null; } }

        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public AnalyzerOptions WithAdditionalFiles(System.Collections.Immutable.ImmutableArray<AdditionalText> additionalFiles) { throw null; }
    }
    public abstract partial class AnalyzerReference
    {
        public virtual string Display { get { throw null; } }
        public abstract string? FullPath { get; }
        public abstract object Id { get; }

        public abstract System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzers(string language);
        public abstract System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzersForAllLanguages();
        [System.Obsolete("Use GetGenerators(string language) or GetGeneratorsForAllLanguages()")]
        public virtual System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGenerators() { throw null; }
        public virtual System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGenerators(string language) { throw null; }
        public virtual System.Collections.Immutable.ImmutableArray<ISourceGenerator> GetGeneratorsForAllLanguages() { throw null; }
    }
    public readonly partial struct CodeBlockAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public CodeBlockAnalysisContext(SyntaxNode codeBlock, ISymbol owningSymbol, SemanticModel semanticModel, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public SyntaxNode CodeBlock { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol OwningSymbol { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public abstract partial class CodeBlockStartAnalysisContext<TLanguageKindEnum> where TLanguageKindEnum : struct
    {
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        protected CodeBlockStartAnalysisContext(SyntaxNode codeBlock, ISymbol owningSymbol, SemanticModel semanticModel, AnalyzerOptions options, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public SyntaxNode CodeBlock { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol OwningSymbol { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }

        public abstract void RegisterCodeBlockEndAction(System.Action<CodeBlockAnalysisContext> action);
        public void RegisterSyntaxNodeAction(System.Action<SyntaxNodeAnalysisContext> action, params TLanguageKindEnum[] syntaxKinds) { }
        public abstract void RegisterSyntaxNodeAction(System.Action<SyntaxNodeAnalysisContext> action, System.Collections.Immutable.ImmutableArray<TLanguageKindEnum> syntaxKinds);
    }
    public readonly partial struct CompilationAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public CompilationAnalysisContext(Compilation compilation, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
        public readonly bool TryGetValue<TValue>(AdditionalText text, AdditionalTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
        public readonly bool TryGetValue<TValue>(SyntaxTree tree, SyntaxTreeValueProvider<TValue> valueProvider, out TValue value) { throw null; }
        public readonly bool TryGetValue<TValue>(Text.SourceText text, SourceTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
    }

    public abstract partial class CompilationStartAnalysisContext
    {
        protected CompilationStartAnalysisContext(Compilation compilation, AnalyzerOptions options, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }

        public virtual void RegisterAdditionalFileAction(System.Action<AdditionalFileAnalysisContext> action) { }
        public abstract void RegisterCodeBlockAction(System.Action<CodeBlockAnalysisContext> action);
        public abstract void RegisterCodeBlockStartAction<TLanguageKindEnum>(System.Action<CodeBlockStartAnalysisContext<TLanguageKindEnum>> action)
            where TLanguageKindEnum : struct;
        public abstract void RegisterCompilationEndAction(System.Action<CompilationAnalysisContext> action);
        public void RegisterOperationAction(System.Action<OperationAnalysisContext> action, params OperationKind[] operationKinds) { }
        public virtual void RegisterOperationAction(System.Action<OperationAnalysisContext> action, System.Collections.Immutable.ImmutableArray<OperationKind> operationKinds) { }
        public virtual void RegisterOperationBlockAction(System.Action<OperationBlockAnalysisContext> action) { }
        public virtual void RegisterOperationBlockStartAction(System.Action<OperationBlockStartAnalysisContext> action) { }
        public abstract void RegisterSemanticModelAction(System.Action<SemanticModelAnalysisContext> action);
        public void RegisterSymbolAction(System.Action<SymbolAnalysisContext> action, params SymbolKind[] symbolKinds) { }
        public abstract void RegisterSymbolAction(System.Action<SymbolAnalysisContext> action, System.Collections.Immutable.ImmutableArray<SymbolKind> symbolKinds);
        public virtual void RegisterSymbolStartAction(System.Action<SymbolStartAnalysisContext> action, SymbolKind symbolKind) { }
        public void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, params TLanguageKindEnum[] syntaxKinds) where TLanguageKindEnum : struct { }
        public abstract void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, System.Collections.Immutable.ImmutableArray<TLanguageKindEnum> syntaxKinds)
                                                                                                                                                                                                      where TLanguageKindEnum : struct;
        public abstract void RegisterSyntaxTreeAction(System.Action<SyntaxTreeAnalysisContext> action);
        public bool TryGetValue<TValue>(AdditionalText text, AdditionalTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
        public bool TryGetValue<TValue>(SyntaxTree tree, SyntaxTreeValueProvider<TValue> valueProvider, out TValue value) { throw null; }
        public bool TryGetValue<TValue>(Text.SourceText text, SourceTextValueProvider<TValue> valueProvider, out TValue value) { throw null; }
    }
    public partial class CompilationWithAnalyzers
    {
        [System.Obsolete("Use constructor without a cancellation token")]
        public CompilationWithAnalyzers(Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, AnalyzerOptions? options, System.Threading.CancellationToken cancellationToken) { }
        public CompilationWithAnalyzers(Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, AnalyzerOptions? options) { }
        public CompilationWithAnalyzers(Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, CompilationWithAnalyzersOptions analysisOptions) { }
        public CompilationWithAnalyzersOptions AnalysisOptions { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> Analyzers { get { throw null; } }

        [System.Obsolete("This CancellationToken is always 'None'", false)]
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }

        [System.Obsolete("This API is no longer required to be invoked. Analyzer state is automatically cleaned up when CompilationWithAnalyzers instance is released.")]
        public static void ClearAnalyzerState(System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers) { }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAllDiagnosticsAsync() { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAllDiagnosticsAsync(System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(AdditionalText file, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(AdditionalText file, Text.TextSpan? filterSpan, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(AdditionalText file, Text.TextSpan? filterSpan, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(AdditionalText file, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SemanticModel model, Text.TextSpan? filterSpan, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SemanticModel model, Text.TextSpan? filterSpan, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SyntaxTree tree, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SyntaxTree tree, Text.TextSpan? filterSpan, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SyntaxTree tree, Text.TextSpan? filterSpan, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(SyntaxTree tree, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<AnalysisResult> GetAnalysisResultAsync(System.Threading.CancellationToken cancellationToken) { throw null; }
        [System.Obsolete("This API was found to have performance issues and hence has been deprecated. Instead, invoke the API 'GetAnalysisResultAsync' and access the property 'CompilationDiagnostics' on the returned 'AnalysisResult' to fetch the compilation diagnostics.")]
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerCompilationDiagnosticsAsync(System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        [System.Obsolete("This API was found to have performance issues and hence has been deprecated. Instead, invoke the API 'GetAnalysisResultAsync' and access the property 'CompilationDiagnostics' on the returned 'AnalysisResult' to fetch the compilation diagnostics.")]
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerCompilationDiagnosticsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerDiagnosticsAsync() { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerDiagnosticsAsync(System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerDiagnosticsAsync(System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSemanticDiagnosticsAsync(SemanticModel model, Text.TextSpan? filterSpan, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSemanticDiagnosticsAsync(SemanticModel model, Text.TextSpan? filterSpan, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSyntaxDiagnosticsAsync(SyntaxTree tree, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSyntaxDiagnosticsAsync(SyntaxTree tree, Text.TextSpan? filterSpan, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSyntaxDiagnosticsAsync(SyntaxTree tree, Text.TextSpan? filterSpan, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Immutable.ImmutableArray<Diagnostic>> GetAnalyzerSyntaxDiagnosticsAsync(SyntaxTree tree, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<Telemetry.AnalyzerTelemetryInfo> GetAnalyzerTelemetryInfoAsync(DiagnosticAnalyzer analyzer, System.Threading.CancellationToken cancellationToken) { throw null; }
        public static System.Collections.Generic.IEnumerable<Diagnostic> GetEffectiveDiagnostics(System.Collections.Generic.IEnumerable<Diagnostic> diagnostics, Compilation compilation) { throw null; }
        public static System.Collections.Generic.IEnumerable<Diagnostic> GetEffectiveDiagnostics(System.Collections.Immutable.ImmutableArray<Diagnostic> diagnostics, Compilation compilation) { throw null; }
        [System.Obsolete("This API is no longer supported. See https://github.com/dotnet/roslyn/issues/67592 for details")]
        public static bool IsDiagnosticAnalyzerSuppressed(DiagnosticAnalyzer analyzer, CompilationOptions options, System.Action<System.Exception, DiagnosticAnalyzer, Diagnostic>? onAnalyzerException = null) { throw null; }
    }
    public sealed partial class CompilationWithAnalyzersOptions
    {
        public CompilationWithAnalyzersOptions(AnalyzerOptions? options, System.Action<System.Exception, DiagnosticAnalyzer, Diagnostic>? onAnalyzerException, bool concurrentAnalysis, bool logAnalyzerExecutionTime, bool reportSuppressedDiagnostics, System.Func<System.Exception, bool>? analyzerExceptionFilter) { }
        public CompilationWithAnalyzersOptions(AnalyzerOptions options, System.Action<System.Exception, DiagnosticAnalyzer, Diagnostic>? onAnalyzerException, bool concurrentAnalysis, bool logAnalyzerExecutionTime, bool reportSuppressedDiagnostics) { }
        public CompilationWithAnalyzersOptions(AnalyzerOptions options, System.Action<System.Exception, DiagnosticAnalyzer, Diagnostic>? onAnalyzerException, bool concurrentAnalysis, bool logAnalyzerExecutionTime) { }
        public System.Func<System.Exception, bool>? AnalyzerExceptionFilter { get { throw null; } }
        public bool ConcurrentAnalysis { get { throw null; } }
        public bool LogAnalyzerExecutionTime { get { throw null; } }
        public System.Action<System.Exception, DiagnosticAnalyzer, Diagnostic>? OnAnalyzerException { get { throw null; } }
        public AnalyzerOptions? Options { get { throw null; } }
        public bool ReportSuppressedDiagnostics { get { throw null; } }
    }
    public abstract partial class DiagnosticAnalyzer
    {
        public abstract System.Collections.Immutable.ImmutableArray<DiagnosticDescriptor> SupportedDiagnostics { get; }

        public sealed override bool Equals(object? obj) { throw null; }
        public sealed override int GetHashCode() { throw null; }
        public abstract void Initialize(AnalysisContext context);
        public sealed override string ToString() { throw null; }
    }
    [System.AttributeUsage(System.AttributeTargets.Class)]
    public sealed partial class DiagnosticAnalyzerAttribute : System.Attribute
    {
        public DiagnosticAnalyzerAttribute(string firstLanguage, params string[] additionalLanguages) { }
        public string[] Languages { get { throw null; } }
    }

    public static partial class DiagnosticAnalyzerExtensions
    {
        [System.Obsolete("Use WithAnalyzers overload without a cancellation token", false)]
        public static CompilationWithAnalyzers WithAnalyzers(this Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, AnalyzerOptions? options, System.Threading.CancellationToken cancellationToken) { throw null; }
        public static CompilationWithAnalyzers WithAnalyzers(this Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, AnalyzerOptions? options = null) { throw null; }
        public static CompilationWithAnalyzers WithAnalyzers(this Compilation compilation, System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> analyzers, CompilationWithAnalyzersOptions analysisOptions) { throw null; }
    }
    public abstract partial class DiagnosticSuppressor : DiagnosticAnalyzer
    {
        public sealed override System.Collections.Immutable.ImmutableArray<DiagnosticDescriptor> SupportedDiagnostics { get { throw null; } }
        public abstract System.Collections.Immutable.ImmutableArray<SuppressionDescriptor> SupportedSuppressions { get; }

        public sealed override void Initialize(AnalysisContext context) { }
        public abstract void ReportSuppressions(SuppressionAnalysisContext context);
    }

    [System.Flags]
    public enum GeneratedCodeAnalysisFlags
    {
        None = 0,
        Analyze = 1,
        ReportDiagnostics = 2
    }

    public readonly partial struct OperationAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public OperationAnalysisContext(IOperation operation, ISymbol containingSymbol, Compilation compilation, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public ISymbol ContainingSymbol { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public IOperation Operation { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }

        public readonly FlowAnalysis.ControlFlowGraph GetControlFlowGraph() { throw null; }
        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public readonly partial struct OperationBlockAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public OperationBlockAnalysisContext(System.Collections.Immutable.ImmutableArray<IOperation> operationBlocks, ISymbol owningSymbol, Compilation compilation, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<IOperation> OperationBlocks { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol OwningSymbol { get { throw null; } }

        public readonly FlowAnalysis.ControlFlowGraph GetControlFlowGraph(IOperation operationBlock) { throw null; }
        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public abstract partial class OperationBlockStartAnalysisContext
    {
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        protected OperationBlockStartAnalysisContext(System.Collections.Immutable.ImmutableArray<IOperation> operationBlocks, ISymbol owningSymbol, Compilation compilation, AnalyzerOptions options, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<IOperation> OperationBlocks { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol OwningSymbol { get { throw null; } }

        public FlowAnalysis.ControlFlowGraph GetControlFlowGraph(IOperation operationBlock) { throw null; }
        public void RegisterOperationAction(System.Action<OperationAnalysisContext> action, params OperationKind[] operationKinds) { }
        public abstract void RegisterOperationAction(System.Action<OperationAnalysisContext> action, System.Collections.Immutable.ImmutableArray<OperationKind> operationKinds);
        public abstract void RegisterOperationBlockEndAction(System.Action<OperationBlockAnalysisContext> action);
    }
    public readonly partial struct SemanticModelAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SemanticModelAnalysisContext(SemanticModel semanticModel, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public sealed partial class SourceTextValueProvider<TValue>
    {
        public SourceTextValueProvider(System.Func<Text.SourceText, TValue> computeValue, System.Collections.Generic.IEqualityComparer<Text.SourceText>? sourceTextComparer = null) { }
    }
    public readonly partial struct Suppression : System.IEquatable<Suppression>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public SuppressionDescriptor Descriptor { get { throw null; } }
        public Diagnostic SuppressedDiagnostic { get { throw null; } }

        public static Suppression Create(SuppressionDescriptor descriptor, Diagnostic suppressedDiagnostic) { throw null; }
        public readonly bool Equals(Suppression other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(Suppression left, Suppression right) { throw null; }
        public static bool operator !=(Suppression left, Suppression right) { throw null; }
    }

    public readonly partial struct SuppressionAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> ReportedDiagnostics { get { throw null; } }

        public readonly SemanticModel GetSemanticModel(SyntaxTree syntaxTree) { throw null; }
        public readonly void ReportSuppression(Suppression suppression) { }
    }

    public sealed partial class SuppressionInfo
    {
        internal SuppressionInfo() { }
        public AttributeData? Attribute { get { throw null; } }
        public string Id { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<Suppression> ProgrammaticSuppressions { get { throw null; } }
    }
    public readonly partial struct SymbolAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SymbolAnalysisContext(ISymbol symbol, Compilation compilation, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree? FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol Symbol { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public abstract partial class SymbolStartAnalysisContext
    {
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SymbolStartAnalysisContext(ISymbol symbol, Compilation compilation, AnalyzerOptions options, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree? FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public ISymbol Symbol { get { throw null; } }

        public abstract void RegisterCodeBlockAction(System.Action<CodeBlockAnalysisContext> action);
        public abstract void RegisterCodeBlockStartAction<TLanguageKindEnum>(System.Action<CodeBlockStartAnalysisContext<TLanguageKindEnum>> action)
            where TLanguageKindEnum : struct;
        public void RegisterOperationAction(System.Action<OperationAnalysisContext> action, params OperationKind[] operationKinds) { }
        public abstract void RegisterOperationAction(System.Action<OperationAnalysisContext> action, System.Collections.Immutable.ImmutableArray<OperationKind> operationKinds);
        public abstract void RegisterOperationBlockAction(System.Action<OperationBlockAnalysisContext> action);
        public abstract void RegisterOperationBlockStartAction(System.Action<OperationBlockStartAnalysisContext> action);
        public abstract void RegisterSymbolEndAction(System.Action<SymbolAnalysisContext> action);
        public void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, params TLanguageKindEnum[] syntaxKinds) where TLanguageKindEnum : struct { }
        public abstract void RegisterSyntaxNodeAction<TLanguageKindEnum>(System.Action<SyntaxNodeAnalysisContext> action, System.Collections.Immutable.ImmutableArray<TLanguageKindEnum> syntaxKinds)
                                                                                                                                                                                                      where TLanguageKindEnum : struct;
    }
    public readonly partial struct SyntaxNodeAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SyntaxNodeAnalysisContext(SyntaxNode node, ISymbol? containingSymbol, SemanticModel semanticModel, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SyntaxNodeAnalysisContext(SyntaxNode node, SemanticModel semanticModel, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Compilation Compilation { get { throw null; } }
        public ISymbol? ContainingSymbol { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public SyntaxTree FilterTree { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public SyntaxNode Node { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public SemanticModel SemanticModel { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public readonly partial struct SyntaxTreeAnalysisContext
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use CompilationWithAnalyzers instead. See https://github.com/dotnet/roslyn/issues/63440 for more details.")]
        public SyntaxTreeAnalysisContext(SyntaxTree tree, AnalyzerOptions options, System.Action<Diagnostic> reportDiagnostic, System.Func<Diagnostic, bool> isSupportedDiagnostic, System.Threading.CancellationToken cancellationToken) { }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public Text.TextSpan? FilterSpan { get { throw null; } }
        public bool IsGeneratedCode { get { throw null; } }
        public AnalyzerOptions Options { get { throw null; } }
        public SyntaxTree Tree { get { throw null; } }

        public readonly void ReportDiagnostic(Diagnostic diagnostic) { }
    }

    public sealed partial class SyntaxTreeValueProvider<TValue>
    {
        public SyntaxTreeValueProvider(System.Func<SyntaxTree, TValue> computeValue, System.Collections.Generic.IEqualityComparer<SyntaxTree>? syntaxTreeComparer = null) { }
    }
    public sealed partial class UnresolvedAnalyzerReference : AnalyzerReference
    {
        public UnresolvedAnalyzerReference(string unresolvedPath) { }
        public override string Display { get { throw null; } }
        public override string FullPath { get { throw null; } }
        public override object Id { get { throw null; } }

        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzers(string language) { throw null; }
        public override System.Collections.Immutable.ImmutableArray<DiagnosticAnalyzer> GetAnalyzersForAllLanguages() { throw null; }
    }
}

namespace Microsoft.CodeAnalysis.Diagnostics.Telemetry
{
    [System.Runtime.Serialization.DataContract]
    public sealed partial class AnalyzerTelemetryInfo
    {
        [System.Runtime.Serialization.DataMember(Order = 4)]
        public int AdditionalFileActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 12)]
        public int CodeBlockActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 11)]
        public int CodeBlockEndActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 10)]
        public int CodeBlockStartActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 2)]
        public int CompilationActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 1)]
        public int CompilationEndActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 0)]
        public int CompilationStartActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 19)]
        public bool Concurrent { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 18)]
        public System.TimeSpan ExecutionTime { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 13)]
        public int OperationActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 16)]
        public int OperationBlockActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 15)]
        public int OperationBlockEndActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 14)]
        public int OperationBlockStartActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 5)]
        public int SemanticModelActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 17)]
        public int SuppressionActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 6)]
        public int SymbolActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 8)]
        public int SymbolEndActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 7)]
        public int SymbolStartActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 9)]
        public int SyntaxNodeActionsCount { get { throw null; } set { } }

        [System.Runtime.Serialization.DataMember(Order = 3)]
        public int SyntaxTreeActionsCount { get { throw null; } set { } }
    }
}

namespace Microsoft.CodeAnalysis.Emit
{
    public enum DebugInformationFormat
    {
        Pdb = 1,
        PortablePdb = 2,
        Embedded = 3
    }

    public readonly partial struct EditAndContinueMethodDebugInformation
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public static EditAndContinueMethodDebugInformation Create(System.Collections.Immutable.ImmutableArray<byte> compressedSlotMap, System.Collections.Immutable.ImmutableArray<byte> compressedLambdaMap, System.Collections.Immutable.ImmutableArray<byte> compressedStateMachineStateMap) { throw null; }
        public static EditAndContinueMethodDebugInformation Create(System.Collections.Immutable.ImmutableArray<byte> compressedSlotMap, System.Collections.Immutable.ImmutableArray<byte> compressedLambdaMap) { throw null; }
    }

    public sealed partial class EmitBaseline
    {
        internal EmitBaseline() { }
        public ModuleMetadata OriginalMetadata { get { throw null; } }

        public static EmitBaseline CreateInitialBaseline(Compilation compilation, ModuleMetadata module, System.Func<System.Reflection.Metadata.MethodDefinitionHandle, EditAndContinueMethodDebugInformation> debugInformationProvider, System.Func<System.Reflection.Metadata.MethodDefinitionHandle, System.Reflection.Metadata.StandaloneSignatureHandle> localSignatureProvider, bool hasPortableDebugInformation) { throw null; }
        [System.Obsolete("This overload is no longer supported", true)]
        public static EmitBaseline CreateInitialBaseline(ModuleMetadata module, System.Func<System.Reflection.Metadata.MethodDefinitionHandle, EditAndContinueMethodDebugInformation> debugInformationProvider, System.Func<System.Reflection.Metadata.MethodDefinitionHandle, System.Reflection.Metadata.StandaloneSignatureHandle> localSignatureProvider, bool hasPortableDebugInformation) { throw null; }
        [System.Obsolete("This overload is no longer supported", true)]
        public static EmitBaseline CreateInitialBaseline(ModuleMetadata module, System.Func<System.Reflection.Metadata.MethodDefinitionHandle, EditAndContinueMethodDebugInformation> debugInformationProvider) { throw null; }
    }
    public sealed partial class EmitDifferenceResult : EmitResult
    {
        internal EmitDifferenceResult() { }
        public EmitBaseline? Baseline { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<System.Reflection.Metadata.TypeDefinitionHandle> ChangedTypes { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<System.Reflection.Metadata.MethodDefinitionHandle> UpdatedMethods { get { throw null; } }
    }

    public sealed partial class EmitOptions : System.IEquatable<EmitOptions>
    {
        public EmitOptions(bool metadataOnly = false, DebugInformationFormat debugInformationFormat = 0, string? pdbFilePath = null, string? outputNameOverride = null, int fileAlignment = 0, ulong baseAddress = 0, bool highEntropyVirtualAddressSpace = false, SubsystemVersion subsystemVersion = default, string? runtimeMetadataVersion = null, bool tolerateErrors = false, bool includePrivateMembers = true, System.Collections.Immutable.ImmutableArray<InstrumentationKind> instrumentationKinds = default, System.Security.Cryptography.HashAlgorithmName? pdbChecksumAlgorithm = null, System.Text.Encoding? defaultSourceFileEncoding = null, System.Text.Encoding? fallbackSourceFileEncoding = null) { }
        public EmitOptions(bool metadataOnly, DebugInformationFormat debugInformationFormat, string? pdbFilePath, string? outputNameOverride, int fileAlignment, ulong baseAddress, bool highEntropyVirtualAddressSpace, SubsystemVersion subsystemVersion, string? runtimeMetadataVersion, bool tolerateErrors, bool includePrivateMembers, System.Collections.Immutable.ImmutableArray<InstrumentationKind> instrumentationKinds, System.Security.Cryptography.HashAlgorithmName? pdbChecksumAlgorithm) { }
        public EmitOptions(bool metadataOnly, DebugInformationFormat debugInformationFormat, string pdbFilePath, string outputNameOverride, int fileAlignment, ulong baseAddress, bool highEntropyVirtualAddressSpace, SubsystemVersion subsystemVersion, string runtimeMetadataVersion, bool tolerateErrors, bool includePrivateMembers, System.Collections.Immutable.ImmutableArray<InstrumentationKind> instrumentationKinds) { }
        public EmitOptions(bool metadataOnly, DebugInformationFormat debugInformationFormat, string pdbFilePath, string outputNameOverride, int fileAlignment, ulong baseAddress, bool highEntropyVirtualAddressSpace, SubsystemVersion subsystemVersion, string runtimeMetadataVersion, bool tolerateErrors, bool includePrivateMembers) { }
        public ulong BaseAddress { get { throw null; } }
        public DebugInformationFormat DebugInformationFormat { get { throw null; } }
        public System.Text.Encoding? DefaultSourceFileEncoding { get { throw null; } }
        public bool EmitMetadataOnly { get { throw null; } }
        public System.Text.Encoding? FallbackSourceFileEncoding { get { throw null; } }
        public int FileAlignment { get { throw null; } }
        public bool HighEntropyVirtualAddressSpace { get { throw null; } }
        public bool IncludePrivateMembers { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<InstrumentationKind> InstrumentationKinds { get { throw null; } }
        public string? OutputNameOverride { get { throw null; } }
        public System.Security.Cryptography.HashAlgorithmName PdbChecksumAlgorithm { get { throw null; } }
        public string? PdbFilePath { get { throw null; } }
        public string? RuntimeMetadataVersion { get { throw null; } }
        public SubsystemVersion SubsystemVersion { get { throw null; } }
        public bool TolerateErrors { get { throw null; } }

        public bool Equals(EmitOptions? other) { throw null; }
        public override bool Equals(object? obj) { throw null; }
        public override int GetHashCode() { throw null; }
        public static bool operator ==(EmitOptions? left, EmitOptions? right) { throw null; }
        public static bool operator !=(EmitOptions? left, EmitOptions? right) { throw null; }
        public EmitOptions WithBaseAddress(ulong value) { throw null; }
        public EmitOptions WithDebugInformationFormat(DebugInformationFormat format) { throw null; }
        public EmitOptions WithDefaultSourceFileEncoding(System.Text.Encoding? defaultSourceFileEncoding) { throw null; }
        public EmitOptions WithEmitMetadataOnly(bool value) { throw null; }
        public EmitOptions WithFallbackSourceFileEncoding(System.Text.Encoding? fallbackSourceFileEncoding) { throw null; }
        public EmitOptions WithFileAlignment(int value) { throw null; }
        public EmitOptions WithHighEntropyVirtualAddressSpace(bool value) { throw null; }
        public EmitOptions WithIncludePrivateMembers(bool value) { throw null; }
        public EmitOptions WithInstrumentationKinds(System.Collections.Immutable.ImmutableArray<InstrumentationKind> instrumentationKinds) { throw null; }
        public EmitOptions WithOutputNameOverride(string outputName) { throw null; }
        public EmitOptions WithPdbChecksumAlgorithm(System.Security.Cryptography.HashAlgorithmName name) { throw null; }
        public EmitOptions WithPdbFilePath(string path) { throw null; }
        public EmitOptions WithRuntimeMetadataVersion(string version) { throw null; }
        public EmitOptions WithSubsystemVersion(SubsystemVersion subsystemVersion) { throw null; }
        public EmitOptions WithTolerateErrors(bool value) { throw null; }
    }

    public partial class EmitResult
    {
        internal EmitResult() { }
        public System.Collections.Immutable.ImmutableArray<Diagnostic> Diagnostics { get { throw null; } }
        public bool Success { get { throw null; } }

        protected virtual string GetDebuggerDisplay() { throw null; }
    }
    public enum InstrumentationKind
    {
        None = 0,
        TestCoverage = 1,
        StackOverflowProbing = 2,
        ModuleCancellation = 3
    }

    public readonly partial struct MethodInstrumentation
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public System.Collections.Immutable.ImmutableArray<InstrumentationKind> Kinds { get { throw null; } init { } }
    }

    public readonly partial struct RuntimeRudeEdit
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public RuntimeRudeEdit(string message) { }
        public string Message { get { throw null; } }
    }

    public readonly partial struct SemanticEdit : System.IEquatable<SemanticEdit>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        [System.Obsolete("Use other overload")]
        public SemanticEdit(SemanticEditKind kind, ISymbol? oldSymbol, ISymbol? newSymbol, System.Func<SyntaxNode, SyntaxNode?>? syntaxMap, bool preserveLocalVariables, MethodInstrumentation instrumentation) { }
        [System.Obsolete("Use other overload")]
        public SemanticEdit(SemanticEditKind kind, ISymbol? oldSymbol, ISymbol? newSymbol, System.Func<SyntaxNode, SyntaxNode?>? syntaxMap, bool preserveLocalVariables) { }
        public SemanticEdit(SemanticEditKind kind, ISymbol? oldSymbol, ISymbol? newSymbol, System.Func<SyntaxNode, SyntaxNode?>? syntaxMap = null, System.Func<SyntaxNode, RuntimeRudeEdit?>? runtimeRudeEdit = null, MethodInstrumentation instrumentation = default) { }
        public MethodInstrumentation Instrumentation { get { throw null; } }
        public SemanticEditKind Kind { get { throw null; } }
        public ISymbol? NewSymbol { get { throw null; } }
        public ISymbol? OldSymbol { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "SyntaxMap")]
        public bool PreserveLocalVariables { get { throw null; } }
        public System.Func<SyntaxNode, RuntimeRudeEdit?>? RuntimeRudeEdit { get { throw null; } }
        public System.Func<SyntaxNode, SyntaxNode?>? SyntaxMap { get { throw null; } }

        public readonly bool Equals(SemanticEdit other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(SemanticEdit left, SemanticEdit right) { throw null; }
        public static bool operator !=(SemanticEdit left, SemanticEdit right) { throw null; }
    }

    public enum SemanticEditKind
    {
        None = 0,
        Update = 1,
        Insert = 2,
        Delete = 3,
        Replace = 4
    }
}

namespace Microsoft.CodeAnalysis.FlowAnalysis
{
    public sealed partial class BasicBlock
    {
        internal BasicBlock() { }
        public IOperation? BranchValue { get { throw null; } }
        public ControlFlowBranch? ConditionalSuccessor { get { throw null; } }
        public ControlFlowConditionKind ConditionKind { get { throw null; } }
        public ControlFlowRegion EnclosingRegion { get { throw null; } }
        public ControlFlowBranch? FallThroughSuccessor { get { throw null; } }
        public bool IsReachable { get { throw null; } }
        public BasicBlockKind Kind { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<IOperation> Operations { get { throw null; } }
        public int Ordinal { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ControlFlowBranch> Predecessors { get { throw null; } }
    }
    public enum BasicBlockKind
    {
        Entry = 0,
        Exit = 1,
        Block = 2
    }

    public readonly partial struct CaptureId : System.IEquatable<CaptureId>
    {
        private readonly int _dummyPrimitive;
        public readonly bool Equals(CaptureId other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
    }

    public sealed partial class ControlFlowBranch
    {
        internal ControlFlowBranch() { }
        public BasicBlock? Destination { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ControlFlowRegion> EnteringRegions { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ControlFlowRegion> FinallyRegions { get { throw null; } }
        public bool IsConditionalSuccessor { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ControlFlowRegion> LeavingRegions { get { throw null; } }
        public ControlFlowBranchSemantics Semantics { get { throw null; } }
        public BasicBlock Source { get { throw null; } }
    }
    public enum ControlFlowBranchSemantics
    {
        None = 0,
        Regular = 1,
        Return = 2,
        StructuredExceptionHandling = 3,
        ProgramTermination = 4,
        Throw = 5,
        Rethrow = 6,
        Error = 7
    }

    public enum ControlFlowConditionKind
    {
        None = 0,
        WhenFalse = 1,
        WhenTrue = 2
    }

    public sealed partial class ControlFlowGraph
    {
        internal ControlFlowGraph() { }
        public System.Collections.Immutable.ImmutableArray<BasicBlock> Blocks { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<IMethodSymbol> LocalFunctions { get { throw null; } }
        public IOperation OriginalOperation { get { throw null; } }
        public ControlFlowGraph? Parent { get { throw null; } }
        public ControlFlowRegion Root { get { throw null; } }

        public static ControlFlowGraph Create(Operations.IAttributeOperation attribute, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IBlockOperation body, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IConstructorBodyOperation constructorBody, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IFieldInitializerOperation initializer, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IMethodBodyOperation methodBody, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IParameterInitializerOperation initializer, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph Create(Operations.IPropertyInitializerOperation initializer, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph? Create(SyntaxNode node, SemanticModel semanticModel, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public ControlFlowGraph GetAnonymousFunctionControlFlowGraph(IFlowAnonymousFunctionOperation anonymousFunction, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public ControlFlowGraph GetLocalFunctionControlFlowGraph(IMethodSymbol localFunction, System.Threading.CancellationToken cancellationToken = default) { throw null; }
    }
    public static partial class ControlFlowGraphExtensions
    {
        public static ControlFlowGraph GetAnonymousFunctionControlFlowGraphInScope(this ControlFlowGraph controlFlowGraph, IFlowAnonymousFunctionOperation anonymousFunction, System.Threading.CancellationToken cancellationToken = default) { throw null; }
        public static ControlFlowGraph GetLocalFunctionControlFlowGraphInScope(this ControlFlowGraph controlFlowGraph, IMethodSymbol localFunction, System.Threading.CancellationToken cancellationToken = default) { throw null; }
    }
    public sealed partial class ControlFlowRegion
    {
        internal ControlFlowRegion() { }
        public System.Collections.Immutable.ImmutableArray<CaptureId> CaptureIds { get { throw null; } }
        public ControlFlowRegion? EnclosingRegion { get { throw null; } }
        public ITypeSymbol? ExceptionType { get { throw null; } }
        public int FirstBlockOrdinal { get { throw null; } }
        public ControlFlowRegionKind Kind { get { throw null; } }
        public int LastBlockOrdinal { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<IMethodSymbol> LocalFunctions { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get { throw null; } }
        public System.Collections.Immutable.ImmutableArray<ControlFlowRegion> NestedRegions { get { throw null; } }
    }
    public enum ControlFlowRegionKind
    {
        Root = 0,
        LocalLifetime = 1,
        Try = 2,
        Filter = 3,
        Catch = 4,
        FilterAndHandler = 5,
        TryAndCatch = 6,
        Finally = 7,
        TryAndFinally = 8,
        StaticLocalInitializer = 9,
        ErroneousBody = 10
    }

    public partial interface ICaughtExceptionOperation : IOperation
    {
    }

    public partial interface IFlowAnonymousFunctionOperation : IOperation
    {
        IMethodSymbol Symbol { get; }
    }

    public partial interface IFlowCaptureOperation : IOperation
    {
        CaptureId Id { get; }

        IOperation Value { get; }
    }

    public partial interface IFlowCaptureReferenceOperation : IOperation
    {
        CaptureId Id { get; }

        bool IsInitialization { get; }
    }

    public partial interface IIsNullOperation : IOperation
    {
        IOperation Operand { get; }
    }

    public partial interface IStaticLocalInitializationSemaphoreOperation : IOperation
    {
        ILocalSymbol Local { get; }
    }
}

namespace Microsoft.CodeAnalysis.Operations
{
    public enum ArgumentKind
    {
        None = 0,
        Explicit = 1,
        ParamArray = 2,
        DefaultValue = 3,
        ParamCollection = 4
    }

    public enum BinaryOperatorKind
    {
        None = 0,
        Add = 1,
        Subtract = 2,
        Multiply = 3,
        Divide = 4,
        IntegerDivide = 5,
        Remainder = 6,
        Power = 7,
        LeftShift = 8,
        RightShift = 9,
        And = 10,
        Or = 11,
        ExclusiveOr = 12,
        ConditionalAnd = 13,
        ConditionalOr = 14,
        Concatenate = 15,
        Equals = 16,
        ObjectValueEquals = 17,
        NotEquals = 18,
        ObjectValueNotEquals = 19,
        LessThan = 20,
        LessThanOrEqual = 21,
        GreaterThanOrEqual = 22,
        GreaterThan = 23,
        Like = 24,
        UnsignedRightShift = 25
    }

    public enum BranchKind
    {
        None = 0,
        Continue = 1,
        Break = 2,
        GoTo = 3
    }

    public enum CaseKind
    {
        None = 0,
        SingleValue = 1,
        Relational = 2,
        Range = 3,
        Default = 4,
        Pattern = 5
    }

    public readonly partial struct CommonConversion
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public ITypeSymbol? ConstrainedToType { get { throw null; } }
        public bool Exists { get { throw null; } }
        public bool IsIdentity { get { throw null; } }
        public bool IsImplicit { get { throw null; } }
        public bool IsNullable { get { throw null; } }
        public bool IsNumeric { get { throw null; } }
        public bool IsReference { get { throw null; } }

        [System.Diagnostics.CodeAnalysis.MemberNotNullWhen(true, "MethodSymbol")]
        public bool IsUserDefined { get { throw null; } }
        public IMethodSymbol? MethodSymbol { get { throw null; } }
    }

    public partial interface IAddressOfOperation : IOperation
    {
        IOperation Reference { get; }
    }

    public partial interface IAnonymousFunctionOperation : IOperation
    {
        IBlockOperation Body { get; }

        IMethodSymbol Symbol { get; }
    }

    public partial interface IAnonymousObjectCreationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Initializers { get; }
    }

    public partial interface IArgumentOperation : IOperation
    {
        ArgumentKind ArgumentKind { get; }

        CommonConversion InConversion { get; }

        CommonConversion OutConversion { get; }

        IParameterSymbol? Parameter { get; }

        IOperation Value { get; }
    }

    public partial interface IArrayCreationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> DimensionSizes { get; }

        IArrayInitializerOperation? Initializer { get; }
    }

    public partial interface IArrayElementReferenceOperation : IOperation
    {
        IOperation ArrayReference { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> Indices { get; }
    }

    public partial interface IArrayInitializerOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> ElementValues { get; }
    }

    public partial interface IAssignmentOperation : IOperation
    {
        IOperation Target { get; }

        IOperation Value { get; }
    }

    public partial interface IAttributeOperation : IOperation
    {
        IOperation Operation { get; }
    }

    public partial interface IAwaitOperation : IOperation
    {
        IOperation Operation { get; }
    }

    public partial interface IBinaryOperation : IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        bool IsChecked { get; }

        bool IsCompareText { get; }

        bool IsLifted { get; }

        IOperation LeftOperand { get; }

        BinaryOperatorKind OperatorKind { get; }

        IMethodSymbol? OperatorMethod { get; }

        IOperation RightOperand { get; }
    }

    public partial interface IBinaryPatternOperation : IPatternOperation, IOperation
    {
        IPatternOperation LeftPattern { get; }

        BinaryOperatorKind OperatorKind { get; }

        IPatternOperation RightPattern { get; }
    }

    public partial interface IBlockOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> Operations { get; }
    }

    public partial interface IBranchOperation : IOperation
    {
        BranchKind BranchKind { get; }

        ILabelSymbol Target { get; }
    }

    public partial interface ICaseClauseOperation : IOperation
    {
        CaseKind CaseKind { get; }

        ILabelSymbol? Label { get; }
    }

    public partial interface ICatchClauseOperation : IOperation
    {
        IOperation? ExceptionDeclarationOrExpression { get; }

        ITypeSymbol ExceptionType { get; }

        IOperation? Filter { get; }

        IBlockOperation Handler { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }
    }

    public partial interface ICoalesceAssignmentOperation : IAssignmentOperation, IOperation
    {
    }

    public partial interface ICoalesceOperation : IOperation
    {
        IOperation Value { get; }

        CommonConversion ValueConversion { get; }

        IOperation WhenNull { get; }
    }

    [System.Obsolete("ICollectionElementInitializerOperation has been replaced with IInvocationOperation and IDynamicInvocationOperation", true)]
    public partial interface ICollectionElementInitializerOperation : IOperation
    {
        IMethodSymbol AddMethod { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> Arguments { get; }

        bool IsDynamic { get; }
    }

    public partial interface ICollectionExpressionOperation : IOperation
    {
        IMethodSymbol? ConstructMethod { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> Elements { get; }
    }

    public partial interface ICompoundAssignmentOperation : IAssignmentOperation, IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        CommonConversion InConversion { get; }

        bool IsChecked { get; }

        bool IsLifted { get; }

        BinaryOperatorKind OperatorKind { get; }

        IMethodSymbol? OperatorMethod { get; }

        CommonConversion OutConversion { get; }
    }

    public partial interface IConditionalAccessInstanceOperation : IOperation
    {
    }

    public partial interface IConditionalAccessOperation : IOperation
    {
        IOperation Operation { get; }

        IOperation WhenNotNull { get; }
    }

    public partial interface IConditionalOperation : IOperation
    {
        IOperation Condition { get; }

        bool IsRef { get; }

        IOperation? WhenFalse { get; }

        IOperation WhenTrue { get; }
    }

    public partial interface IConstantPatternOperation : IPatternOperation, IOperation
    {
        IOperation Value { get; }
    }

    public partial interface IConstructorBodyOperation : IMethodBodyBaseOperation, IOperation
    {
        IOperation? Initializer { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }
    }

    public partial interface IConversionOperation : IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        CommonConversion Conversion { get; }

        bool IsChecked { get; }

        bool IsTryCast { get; }

        IOperation Operand { get; }

        IMethodSymbol? OperatorMethod { get; }
    }

    public partial interface IDeclarationExpressionOperation : IOperation
    {
        IOperation Expression { get; }
    }

    public partial interface IDeclarationPatternOperation : IPatternOperation, IOperation
    {
        ISymbol? DeclaredSymbol { get; }

        ITypeSymbol? MatchedType { get; }

        bool MatchesNull { get; }
    }

    public partial interface IDeconstructionAssignmentOperation : IAssignmentOperation, IOperation
    {
    }

    public partial interface IDefaultCaseClauseOperation : ICaseClauseOperation, IOperation
    {
    }

    public partial interface IDefaultValueOperation : IOperation
    {
    }

    public partial interface IDelegateCreationOperation : IOperation
    {
        IOperation Target { get; }
    }

    public partial interface IDiscardOperation : IOperation
    {
        IDiscardSymbol DiscardSymbol { get; }
    }

    public partial interface IDiscardPatternOperation : IPatternOperation, IOperation
    {
    }

    public partial interface IDynamicIndexerAccessOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Arguments { get; }

        IOperation Operation { get; }
    }

    public partial interface IDynamicInvocationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Arguments { get; }

        IOperation Operation { get; }
    }

    public partial interface IDynamicMemberReferenceOperation : IOperation
    {
        ITypeSymbol? ContainingType { get; }

        IOperation? Instance { get; }

        string MemberName { get; }

        System.Collections.Immutable.ImmutableArray<ITypeSymbol> TypeArguments { get; }
    }

    public partial interface IDynamicObjectCreationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Arguments { get; }

        IObjectOrCollectionInitializerOperation? Initializer { get; }
    }

    public partial interface IEmptyOperation : IOperation
    {
    }

    public partial interface IEndOperation : IOperation
    {
    }

    public partial interface IEventAssignmentOperation : IOperation
    {
        bool Adds { get; }

        IOperation EventReference { get; }

        IOperation HandlerValue { get; }
    }

    public partial interface IEventReferenceOperation : IMemberReferenceOperation, IOperation
    {
        IEventSymbol Event { get; }
    }

    public partial interface IExpressionStatementOperation : IOperation
    {
        IOperation Operation { get; }
    }

    public partial interface IFieldInitializerOperation : ISymbolInitializerOperation, IOperation
    {
        System.Collections.Immutable.ImmutableArray<IFieldSymbol> InitializedFields { get; }
    }

    public partial interface IFieldReferenceOperation : IMemberReferenceOperation, IOperation
    {
        IFieldSymbol Field { get; }

        bool IsDeclaration { get; }
    }

    public partial interface IForEachLoopOperation : ILoopOperation, IOperation
    {
        IOperation Collection { get; }

        bool IsAsynchronous { get; }

        IOperation LoopControlVariable { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> NextVariables { get; }
    }

    public partial interface IForLoopOperation : ILoopOperation, IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> AtLoopBottom { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> Before { get; }

        IOperation? Condition { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> ConditionLocals { get; }
    }

    public partial interface IForToLoopOperation : ILoopOperation, IOperation
    {
        IOperation InitialValue { get; }

        bool IsChecked { get; }

        IOperation LimitValue { get; }

        IOperation LoopControlVariable { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> NextVariables { get; }

        IOperation StepValue { get; }
    }

    public partial interface IFunctionPointerInvocationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IArgumentOperation> Arguments { get; }

        IOperation Target { get; }
    }

    public partial interface IImplicitIndexerReferenceOperation : IOperation
    {
        IOperation Argument { get; }

        ISymbol IndexerSymbol { get; }

        IOperation Instance { get; }

        ISymbol LengthSymbol { get; }
    }

    public partial interface IIncrementOrDecrementOperation : IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        bool IsChecked { get; }

        bool IsLifted { get; }

        bool IsPostfix { get; }

        IMethodSymbol? OperatorMethod { get; }

        IOperation Target { get; }
    }

    public partial interface IInlineArrayAccessOperation : IOperation
    {
        IOperation Argument { get; }

        IOperation Instance { get; }
    }

    public partial interface IInstanceReferenceOperation : IOperation
    {
        InstanceReferenceKind ReferenceKind { get; }
    }

    public partial interface IInterpolatedStringAdditionOperation : IOperation
    {
        IOperation Left { get; }

        IOperation Right { get; }
    }

    public partial interface IInterpolatedStringAppendOperation : IInterpolatedStringContentOperation, IOperation
    {
        IOperation AppendCall { get; }
    }

    public partial interface IInterpolatedStringContentOperation : IOperation
    {
    }

    public partial interface IInterpolatedStringHandlerArgumentPlaceholderOperation : IOperation
    {
        int ArgumentIndex { get; }

        InterpolatedStringArgumentPlaceholderKind PlaceholderKind { get; }
    }

    public partial interface IInterpolatedStringHandlerCreationOperation : IOperation
    {
        IOperation Content { get; }

        bool HandlerAppendCallsReturnBool { get; }

        IOperation HandlerCreation { get; }

        bool HandlerCreationHasSuccessParameter { get; }
    }

    public partial interface IInterpolatedStringOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IInterpolatedStringContentOperation> Parts { get; }
    }

    public partial interface IInterpolatedStringTextOperation : IInterpolatedStringContentOperation, IOperation
    {
        IOperation Text { get; }
    }

    public partial interface IInterpolationOperation : IInterpolatedStringContentOperation, IOperation
    {
        IOperation? Alignment { get; }

        IOperation Expression { get; }

        IOperation? FormatString { get; }
    }

    public partial interface IInvalidOperation : IOperation
    {
    }

    public partial interface IInvocationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IArgumentOperation> Arguments { get; }

        ITypeSymbol? ConstrainedToType { get; }

        IOperation? Instance { get; }

        bool IsVirtual { get; }

        IMethodSymbol TargetMethod { get; }
    }

    public partial interface IIsPatternOperation : IOperation
    {
        IPatternOperation Pattern { get; }

        IOperation Value { get; }
    }

    public partial interface IIsTypeOperation : IOperation
    {
        bool IsNegated { get; }

        ITypeSymbol TypeOperand { get; }

        IOperation ValueOperand { get; }
    }

    public partial interface ILabeledOperation : IOperation
    {
        ILabelSymbol Label { get; }

        IOperation? Operation { get; }
    }

    public partial interface IListPatternOperation : IPatternOperation, IOperation
    {
        ISymbol? DeclaredSymbol { get; }

        ISymbol? IndexerSymbol { get; }

        ISymbol? LengthSymbol { get; }

        System.Collections.Immutable.ImmutableArray<IPatternOperation> Patterns { get; }
    }

    public partial interface ILiteralOperation : IOperation
    {
    }

    public partial interface ILocalFunctionOperation : IOperation
    {
        IBlockOperation? Body { get; }

        IBlockOperation? IgnoredBody { get; }

        IMethodSymbol Symbol { get; }
    }

    public partial interface ILocalReferenceOperation : IOperation
    {
        bool IsDeclaration { get; }

        ILocalSymbol Local { get; }
    }

    public partial interface ILockOperation : IOperation
    {
        IOperation Body { get; }

        IOperation LockedValue { get; }
    }

    public partial interface ILoopOperation : IOperation
    {
        IOperation Body { get; }

        ILabelSymbol ContinueLabel { get; }

        ILabelSymbol ExitLabel { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        LoopKind LoopKind { get; }
    }

    public partial interface IMemberInitializerOperation : IOperation
    {
        IOperation InitializedMember { get; }

        IObjectOrCollectionInitializerOperation Initializer { get; }
    }

    public partial interface IMemberReferenceOperation : IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        IOperation? Instance { get; }

        ISymbol Member { get; }
    }

    public partial interface IMethodBodyBaseOperation : IOperation
    {
        IBlockOperation? BlockBody { get; }

        IBlockOperation? ExpressionBody { get; }
    }

    public partial interface IMethodBodyOperation : IMethodBodyBaseOperation, IOperation
    {
    }

    public partial interface IMethodReferenceOperation : IMemberReferenceOperation, IOperation
    {
        bool IsVirtual { get; }

        IMethodSymbol Method { get; }
    }

    public partial interface INameOfOperation : IOperation
    {
        IOperation Argument { get; }
    }

    public partial interface INegatedPatternOperation : IPatternOperation, IOperation
    {
        IPatternOperation Pattern { get; }
    }

    public enum InstanceReferenceKind
    {
        ContainingTypeInstance = 0,
        ImplicitReceiver = 1,
        PatternInput = 2,
        InterpolatedStringHandler = 3
    }

    public enum InterpolatedStringArgumentPlaceholderKind
    {
        CallsiteArgument = 0,
        CallsiteReceiver = 1,
        TrailingValidityArgument = 2
    }

    public partial interface IObjectCreationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IArgumentOperation> Arguments { get; }

        IMethodSymbol? Constructor { get; }

        IObjectOrCollectionInitializerOperation? Initializer { get; }
    }

    public partial interface IObjectOrCollectionInitializerOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Initializers { get; }
    }

    public partial interface IOmittedArgumentOperation : IOperation
    {
    }

    public partial interface IParameterInitializerOperation : ISymbolInitializerOperation, IOperation
    {
        IParameterSymbol Parameter { get; }
    }

    public partial interface IParameterReferenceOperation : IOperation
    {
        IParameterSymbol Parameter { get; }
    }

    public partial interface IParenthesizedOperation : IOperation
    {
        IOperation Operand { get; }
    }

    public partial interface IPatternCaseClauseOperation : ICaseClauseOperation, IOperation
    {
        IOperation? Guard { get; }

        ILabelSymbol Label { get; }

        IPatternOperation Pattern { get; }
    }

    public partial interface IPatternOperation : IOperation
    {
        ITypeSymbol InputType { get; }

        ITypeSymbol NarrowedType { get; }
    }

    public partial interface IPropertyInitializerOperation : ISymbolInitializerOperation, IOperation
    {
        System.Collections.Immutable.ImmutableArray<IPropertySymbol> InitializedProperties { get; }
    }

    public partial interface IPropertyReferenceOperation : IMemberReferenceOperation, IOperation
    {
        System.Collections.Immutable.ImmutableArray<IArgumentOperation> Arguments { get; }

        IPropertySymbol Property { get; }
    }

    public partial interface IPropertySubpatternOperation : IOperation
    {
        IOperation Member { get; }

        IPatternOperation Pattern { get; }
    }

    public partial interface IRaiseEventOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IArgumentOperation> Arguments { get; }

        IEventReferenceOperation EventReference { get; }
    }

    public partial interface IRangeCaseClauseOperation : ICaseClauseOperation, IOperation
    {
        IOperation MaximumValue { get; }

        IOperation MinimumValue { get; }
    }

    public partial interface IRangeOperation : IOperation
    {
        bool IsLifted { get; }

        IOperation? LeftOperand { get; }

        IMethodSymbol? Method { get; }

        IOperation? RightOperand { get; }
    }

    public partial interface IRecursivePatternOperation : IPatternOperation, IOperation
    {
        ISymbol? DeclaredSymbol { get; }

        System.Collections.Immutable.ImmutableArray<IPatternOperation> DeconstructionSubpatterns { get; }

        ISymbol? DeconstructSymbol { get; }

        ITypeSymbol MatchedType { get; }

        System.Collections.Immutable.ImmutableArray<IPropertySubpatternOperation> PropertySubpatterns { get; }
    }

    public partial interface IReDimClauseOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> DimensionSizes { get; }

        IOperation Operand { get; }
    }

    public partial interface IReDimOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IReDimClauseOperation> Clauses { get; }

        bool Preserve { get; }
    }

    public partial interface IRelationalCaseClauseOperation : ICaseClauseOperation, IOperation
    {
        BinaryOperatorKind Relation { get; }

        IOperation Value { get; }
    }

    public partial interface IRelationalPatternOperation : IPatternOperation, IOperation
    {
        BinaryOperatorKind OperatorKind { get; }

        IOperation Value { get; }
    }

    public partial interface IReturnOperation : IOperation
    {
        IOperation? ReturnedValue { get; }
    }

    public partial interface ISimpleAssignmentOperation : IAssignmentOperation, IOperation
    {
        bool IsRef { get; }
    }

    public partial interface ISingleValueCaseClauseOperation : ICaseClauseOperation, IOperation
    {
        IOperation Value { get; }
    }

    public partial interface ISizeOfOperation : IOperation
    {
        ITypeSymbol TypeOperand { get; }
    }

    public partial interface ISlicePatternOperation : IPatternOperation, IOperation
    {
        IPatternOperation? Pattern { get; }

        ISymbol? SliceSymbol { get; }
    }

    public partial interface ISpreadOperation : IOperation
    {
        CommonConversion ElementConversion { get; }

        ITypeSymbol? ElementType { get; }

        IOperation Operand { get; }
    }

    public partial interface IStopOperation : IOperation
    {
    }

    public partial interface ISwitchCaseOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Body { get; }

        System.Collections.Immutable.ImmutableArray<ICaseClauseOperation> Clauses { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }
    }

    public partial interface ISwitchExpressionArmOperation : IOperation
    {
        IOperation? Guard { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        IPatternOperation Pattern { get; }

        IOperation Value { get; }
    }

    public partial interface ISwitchExpressionOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<ISwitchExpressionArmOperation> Arms { get; }

        bool IsExhaustive { get; }

        IOperation Value { get; }
    }

    public partial interface ISwitchOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<ISwitchCaseOperation> Cases { get; }

        ILabelSymbol ExitLabel { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        IOperation Value { get; }
    }

    public partial interface ISymbolInitializerOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        IOperation Value { get; }
    }

    public partial interface IThrowOperation : IOperation
    {
        IOperation? Exception { get; }
    }

    public partial interface ITranslatedQueryOperation : IOperation
    {
        IOperation Operation { get; }
    }

    public partial interface ITryOperation : IOperation
    {
        IBlockOperation Body { get; }

        System.Collections.Immutable.ImmutableArray<ICatchClauseOperation> Catches { get; }

        ILabelSymbol? ExitLabel { get; }

        IBlockOperation? Finally { get; }
    }

    public partial interface ITupleBinaryOperation : IOperation
    {
        IOperation LeftOperand { get; }

        BinaryOperatorKind OperatorKind { get; }

        IOperation RightOperand { get; }
    }

    public partial interface ITupleOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> Elements { get; }

        ITypeSymbol? NaturalType { get; }
    }

    public partial interface ITypeOfOperation : IOperation
    {
        ITypeSymbol TypeOperand { get; }
    }

    public partial interface ITypeParameterObjectCreationOperation : IOperation
    {
        IObjectOrCollectionInitializerOperation? Initializer { get; }
    }

    public partial interface ITypePatternOperation : IPatternOperation, IOperation
    {
        ITypeSymbol MatchedType { get; }
    }

    public partial interface IUnaryOperation : IOperation
    {
        ITypeSymbol? ConstrainedToType { get; }

        bool IsChecked { get; }

        bool IsLifted { get; }

        IOperation Operand { get; }

        UnaryOperatorKind OperatorKind { get; }

        IMethodSymbol? OperatorMethod { get; }
    }

    public partial interface IUsingDeclarationOperation : IOperation
    {
        IVariableDeclarationGroupOperation DeclarationGroup { get; }

        bool IsAsynchronous { get; }
    }

    public partial interface IUsingOperation : IOperation
    {
        IOperation Body { get; }

        bool IsAsynchronous { get; }

        System.Collections.Immutable.ImmutableArray<ILocalSymbol> Locals { get; }

        IOperation Resources { get; }
    }

    public partial interface IUtf8StringOperation : IOperation
    {
        string Value { get; }
    }

    public partial interface IVariableDeclarationGroupOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IVariableDeclarationOperation> Declarations { get; }
    }

    public partial interface IVariableDeclarationOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IVariableDeclaratorOperation> Declarators { get; }

        System.Collections.Immutable.ImmutableArray<IOperation> IgnoredDimensions { get; }

        IVariableInitializerOperation? Initializer { get; }
    }

    public partial interface IVariableDeclaratorOperation : IOperation
    {
        System.Collections.Immutable.ImmutableArray<IOperation> IgnoredArguments { get; }

        IVariableInitializerOperation? Initializer { get; }

        ILocalSymbol Symbol { get; }
    }

    public partial interface IVariableInitializerOperation : ISymbolInitializerOperation, IOperation
    {
    }

    public partial interface IWhileLoopOperation : ILoopOperation, IOperation
    {
        IOperation? Condition { get; }

        bool ConditionIsTop { get; }

        bool ConditionIsUntil { get; }

        IOperation? IgnoredCondition { get; }
    }

    public partial interface IWithOperation : IOperation
    {
        IMethodSymbol? CloneMethod { get; }

        IObjectOrCollectionInitializerOperation Initializer { get; }

        IOperation Operand { get; }
    }

    public enum LoopKind
    {
        None = 0,
        While = 1,
        For = 2,
        ForTo = 3,
        ForEach = 4
    }

    public static partial class OperationExtensions
    {
        public static System.Collections.Generic.IEnumerable<IOperation> Descendants(this IOperation? operation) { throw null; }
        public static System.Collections.Generic.IEnumerable<IOperation> DescendantsAndSelf(this IOperation? operation) { throw null; }
        public static string? GetArgumentName(this IDynamicIndexerAccessOperation dynamicOperation, int index) { throw null; }
        public static string? GetArgumentName(this IDynamicInvocationOperation dynamicOperation, int index) { throw null; }
        public static string? GetArgumentName(this IDynamicObjectCreationOperation dynamicOperation, int index) { throw null; }
        public static RefKind? GetArgumentRefKind(this IDynamicIndexerAccessOperation dynamicOperation, int index) { throw null; }
        public static RefKind? GetArgumentRefKind(this IDynamicInvocationOperation dynamicOperation, int index) { throw null; }
        public static RefKind? GetArgumentRefKind(this IDynamicObjectCreationOperation dynamicOperation, int index) { throw null; }
        public static IOperation? GetCorrespondingOperation(this IBranchOperation operation) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<ILocalSymbol> GetDeclaredVariables(this IVariableDeclarationGroupOperation declarationGroup) { throw null; }
        public static System.Collections.Immutable.ImmutableArray<ILocalSymbol> GetDeclaredVariables(this IVariableDeclarationOperation declaration) { throw null; }
        public static IMethodSymbol GetFunctionPointerSignature(this IFunctionPointerInvocationOperation functionPointer) { throw null; }
        public static IVariableInitializerOperation? GetVariableInitializer(this IVariableDeclaratorOperation declarationOperation) { throw null; }
    }
    public abstract partial class OperationVisitor
    {
        public virtual void DefaultVisit(IOperation operation) { }
        public virtual void Visit(IOperation? operation) { }
        public virtual void VisitAddressOf(IAddressOfOperation operation) { }
        public virtual void VisitAnonymousFunction(IAnonymousFunctionOperation operation) { }
        public virtual void VisitAnonymousObjectCreation(IAnonymousObjectCreationOperation operation) { }
        public virtual void VisitArgument(IArgumentOperation operation) { }
        public virtual void VisitArrayCreation(IArrayCreationOperation operation) { }
        public virtual void VisitArrayElementReference(IArrayElementReferenceOperation operation) { }
        public virtual void VisitArrayInitializer(IArrayInitializerOperation operation) { }
        public virtual void VisitAttribute(IAttributeOperation operation) { }
        public virtual void VisitAwait(IAwaitOperation operation) { }
        public virtual void VisitBinaryOperator(IBinaryOperation operation) { }
        public virtual void VisitBinaryPattern(IBinaryPatternOperation operation) { }
        public virtual void VisitBlock(IBlockOperation operation) { }
        public virtual void VisitBranch(IBranchOperation operation) { }
        public virtual void VisitCatchClause(ICatchClauseOperation operation) { }
        public virtual void VisitCaughtException(FlowAnalysis.ICaughtExceptionOperation operation) { }
        public virtual void VisitCoalesce(ICoalesceOperation operation) { }
        public virtual void VisitCoalesceAssignment(ICoalesceAssignmentOperation operation) { }
        [System.Obsolete("ICollectionElementInitializerOperation has been replaced with IInvocationOperation and IDynamicInvocationOperation", true)]
        public virtual void VisitCollectionElementInitializer(ICollectionElementInitializerOperation operation) { }
        public virtual void VisitCollectionExpression(ICollectionExpressionOperation operation) { }
        public virtual void VisitCompoundAssignment(ICompoundAssignmentOperation operation) { }
        public virtual void VisitConditional(IConditionalOperation operation) { }
        public virtual void VisitConditionalAccess(IConditionalAccessOperation operation) { }
        public virtual void VisitConditionalAccessInstance(IConditionalAccessInstanceOperation operation) { }
        public virtual void VisitConstantPattern(IConstantPatternOperation operation) { }
        public virtual void VisitConstructorBodyOperation(IConstructorBodyOperation operation) { }
        public virtual void VisitConversion(IConversionOperation operation) { }
        public virtual void VisitDeclarationExpression(IDeclarationExpressionOperation operation) { }
        public virtual void VisitDeclarationPattern(IDeclarationPatternOperation operation) { }
        public virtual void VisitDeconstructionAssignment(IDeconstructionAssignmentOperation operation) { }
        public virtual void VisitDefaultCaseClause(IDefaultCaseClauseOperation operation) { }
        public virtual void VisitDefaultValue(IDefaultValueOperation operation) { }
        public virtual void VisitDelegateCreation(IDelegateCreationOperation operation) { }
        public virtual void VisitDiscardOperation(IDiscardOperation operation) { }
        public virtual void VisitDiscardPattern(IDiscardPatternOperation operation) { }
        public virtual void VisitDynamicIndexerAccess(IDynamicIndexerAccessOperation operation) { }
        public virtual void VisitDynamicInvocation(IDynamicInvocationOperation operation) { }
        public virtual void VisitDynamicMemberReference(IDynamicMemberReferenceOperation operation) { }
        public virtual void VisitDynamicObjectCreation(IDynamicObjectCreationOperation operation) { }
        public virtual void VisitEmpty(IEmptyOperation operation) { }
        public virtual void VisitEnd(IEndOperation operation) { }
        public virtual void VisitEventAssignment(IEventAssignmentOperation operation) { }
        public virtual void VisitEventReference(IEventReferenceOperation operation) { }
        public virtual void VisitExpressionStatement(IExpressionStatementOperation operation) { }
        public virtual void VisitFieldInitializer(IFieldInitializerOperation operation) { }
        public virtual void VisitFieldReference(IFieldReferenceOperation operation) { }
        public virtual void VisitFlowAnonymousFunction(FlowAnalysis.IFlowAnonymousFunctionOperation operation) { }
        public virtual void VisitFlowCapture(FlowAnalysis.IFlowCaptureOperation operation) { }
        public virtual void VisitFlowCaptureReference(FlowAnalysis.IFlowCaptureReferenceOperation operation) { }
        public virtual void VisitForEachLoop(IForEachLoopOperation operation) { }
        public virtual void VisitForLoop(IForLoopOperation operation) { }
        public virtual void VisitForToLoop(IForToLoopOperation operation) { }
        public virtual void VisitFunctionPointerInvocation(IFunctionPointerInvocationOperation operation) { }
        public virtual void VisitImplicitIndexerReference(IImplicitIndexerReferenceOperation operation) { }
        public virtual void VisitIncrementOrDecrement(IIncrementOrDecrementOperation operation) { }
        public virtual void VisitInlineArrayAccess(IInlineArrayAccessOperation operation) { }
        public virtual void VisitInstanceReference(IInstanceReferenceOperation operation) { }
        public virtual void VisitInterpolatedString(IInterpolatedStringOperation operation) { }
        public virtual void VisitInterpolatedStringAddition(IInterpolatedStringAdditionOperation operation) { }
        public virtual void VisitInterpolatedStringAppend(IInterpolatedStringAppendOperation operation) { }
        public virtual void VisitInterpolatedStringHandlerArgumentPlaceholder(IInterpolatedStringHandlerArgumentPlaceholderOperation operation) { }
        public virtual void VisitInterpolatedStringHandlerCreation(IInterpolatedStringHandlerCreationOperation operation) { }
        public virtual void VisitInterpolatedStringText(IInterpolatedStringTextOperation operation) { }
        public virtual void VisitInterpolation(IInterpolationOperation operation) { }
        public virtual void VisitInvalid(IInvalidOperation operation) { }
        public virtual void VisitInvocation(IInvocationOperation operation) { }
        public virtual void VisitIsNull(FlowAnalysis.IIsNullOperation operation) { }
        public virtual void VisitIsPattern(IIsPatternOperation operation) { }
        public virtual void VisitIsType(IIsTypeOperation operation) { }
        public virtual void VisitLabeled(ILabeledOperation operation) { }
        public virtual void VisitListPattern(IListPatternOperation operation) { }
        public virtual void VisitLiteral(ILiteralOperation operation) { }
        public virtual void VisitLocalFunction(ILocalFunctionOperation operation) { }
        public virtual void VisitLocalReference(ILocalReferenceOperation operation) { }
        public virtual void VisitLock(ILockOperation operation) { }
        public virtual void VisitMemberInitializer(IMemberInitializerOperation operation) { }
        public virtual void VisitMethodBodyOperation(IMethodBodyOperation operation) { }
        public virtual void VisitMethodReference(IMethodReferenceOperation operation) { }
        public virtual void VisitNameOf(INameOfOperation operation) { }
        public virtual void VisitNegatedPattern(INegatedPatternOperation operation) { }
        public virtual void VisitObjectCreation(IObjectCreationOperation operation) { }
        public virtual void VisitObjectOrCollectionInitializer(IObjectOrCollectionInitializerOperation operation) { }
        public virtual void VisitOmittedArgument(IOmittedArgumentOperation operation) { }
        public virtual void VisitParameterInitializer(IParameterInitializerOperation operation) { }
        public virtual void VisitParameterReference(IParameterReferenceOperation operation) { }
        public virtual void VisitParenthesized(IParenthesizedOperation operation) { }
        public virtual void VisitPatternCaseClause(IPatternCaseClauseOperation operation) { }
        public virtual void VisitPropertyInitializer(IPropertyInitializerOperation operation) { }
        public virtual void VisitPropertyReference(IPropertyReferenceOperation operation) { }
        public virtual void VisitPropertySubpattern(IPropertySubpatternOperation operation) { }
        public virtual void VisitRaiseEvent(IRaiseEventOperation operation) { }
        public virtual void VisitRangeCaseClause(IRangeCaseClauseOperation operation) { }
        public virtual void VisitRangeOperation(IRangeOperation operation) { }
        public virtual void VisitRecursivePattern(IRecursivePatternOperation operation) { }
        public virtual void VisitReDim(IReDimOperation operation) { }
        public virtual void VisitReDimClause(IReDimClauseOperation operation) { }
        public virtual void VisitRelationalCaseClause(IRelationalCaseClauseOperation operation) { }
        public virtual void VisitRelationalPattern(IRelationalPatternOperation operation) { }
        public virtual void VisitReturn(IReturnOperation operation) { }
        public virtual void VisitSimpleAssignment(ISimpleAssignmentOperation operation) { }
        public virtual void VisitSingleValueCaseClause(ISingleValueCaseClauseOperation operation) { }
        public virtual void VisitSizeOf(ISizeOfOperation operation) { }
        public virtual void VisitSlicePattern(ISlicePatternOperation operation) { }
        public virtual void VisitSpread(ISpreadOperation operation) { }
        public virtual void VisitStaticLocalInitializationSemaphore(FlowAnalysis.IStaticLocalInitializationSemaphoreOperation operation) { }
        public virtual void VisitStop(IStopOperation operation) { }
        public virtual void VisitSwitch(ISwitchOperation operation) { }
        public virtual void VisitSwitchCase(ISwitchCaseOperation operation) { }
        public virtual void VisitSwitchExpression(ISwitchExpressionOperation operation) { }
        public virtual void VisitSwitchExpressionArm(ISwitchExpressionArmOperation operation) { }
        public virtual void VisitThrow(IThrowOperation operation) { }
        public virtual void VisitTranslatedQuery(ITranslatedQueryOperation operation) { }
        public virtual void VisitTry(ITryOperation operation) { }
        public virtual void VisitTuple(ITupleOperation operation) { }
        public virtual void VisitTupleBinaryOperator(ITupleBinaryOperation operation) { }
        public virtual void VisitTypeOf(ITypeOfOperation operation) { }
        public virtual void VisitTypeParameterObjectCreation(ITypeParameterObjectCreationOperation operation) { }
        public virtual void VisitTypePattern(ITypePatternOperation operation) { }
        public virtual void VisitUnaryOperator(IUnaryOperation operation) { }
        public virtual void VisitUsing(IUsingOperation operation) { }
        public virtual void VisitUsingDeclaration(IUsingDeclarationOperation operation) { }
        public virtual void VisitUtf8String(IUtf8StringOperation operation) { }
        public virtual void VisitVariableDeclaration(IVariableDeclarationOperation operation) { }
        public virtual void VisitVariableDeclarationGroup(IVariableDeclarationGroupOperation operation) { }
        public virtual void VisitVariableDeclarator(IVariableDeclaratorOperation operation) { }
        public virtual void VisitVariableInitializer(IVariableInitializerOperation operation) { }
        public virtual void VisitWhileLoop(IWhileLoopOperation operation) { }
        public virtual void VisitWith(IWithOperation operation) { }
    }
    public abstract partial class OperationVisitor<TArgument, TResult>
    {
        public virtual TResult? DefaultVisit(IOperation operation, TArgument argument) { throw null; }
        public virtual TResult? Visit(IOperation? operation, TArgument argument) { throw null; }
        public virtual TResult? VisitAddressOf(IAddressOfOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitAnonymousFunction(IAnonymousFunctionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitAnonymousObjectCreation(IAnonymousObjectCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitArgument(IArgumentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitArrayCreation(IArrayCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitArrayElementReference(IArrayElementReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitArrayInitializer(IArrayInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitAttribute(IAttributeOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitAwait(IAwaitOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitBinaryOperator(IBinaryOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitBinaryPattern(IBinaryPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitBlock(IBlockOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitBranch(IBranchOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCatchClause(ICatchClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCaughtException(FlowAnalysis.ICaughtExceptionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCoalesce(ICoalesceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCoalesceAssignment(ICoalesceAssignmentOperation operation, TArgument argument) { throw null; }
        [System.Obsolete("ICollectionElementInitializerOperation has been replaced with IInvocationOperation and IDynamicInvocationOperation", true)]
        public virtual TResult? VisitCollectionElementInitializer(ICollectionElementInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCollectionExpression(ICollectionExpressionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitCompoundAssignment(ICompoundAssignmentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConditional(IConditionalOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConditionalAccess(IConditionalAccessOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConditionalAccessInstance(IConditionalAccessInstanceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConstantPattern(IConstantPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConstructorBodyOperation(IConstructorBodyOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitConversion(IConversionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDeclarationExpression(IDeclarationExpressionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDeclarationPattern(IDeclarationPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDeconstructionAssignment(IDeconstructionAssignmentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDefaultCaseClause(IDefaultCaseClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDefaultValue(IDefaultValueOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDelegateCreation(IDelegateCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDiscardOperation(IDiscardOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDiscardPattern(IDiscardPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDynamicIndexerAccess(IDynamicIndexerAccessOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDynamicInvocation(IDynamicInvocationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDynamicMemberReference(IDynamicMemberReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitDynamicObjectCreation(IDynamicObjectCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitEmpty(IEmptyOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitEnd(IEndOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitEventAssignment(IEventAssignmentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitEventReference(IEventReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitExpressionStatement(IExpressionStatementOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFieldInitializer(IFieldInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFieldReference(IFieldReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFlowAnonymousFunction(FlowAnalysis.IFlowAnonymousFunctionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFlowCapture(FlowAnalysis.IFlowCaptureOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFlowCaptureReference(FlowAnalysis.IFlowCaptureReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitForEachLoop(IForEachLoopOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitForLoop(IForLoopOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitForToLoop(IForToLoopOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitFunctionPointerInvocation(IFunctionPointerInvocationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitImplicitIndexerReference(IImplicitIndexerReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitIncrementOrDecrement(IIncrementOrDecrementOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInlineArrayAccess(IInlineArrayAccessOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInstanceReference(IInstanceReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedString(IInterpolatedStringOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedStringAddition(IInterpolatedStringAdditionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedStringAppend(IInterpolatedStringAppendOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedStringHandlerArgumentPlaceholder(IInterpolatedStringHandlerArgumentPlaceholderOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedStringHandlerCreation(IInterpolatedStringHandlerCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolatedStringText(IInterpolatedStringTextOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInterpolation(IInterpolationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInvalid(IInvalidOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitInvocation(IInvocationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitIsNull(FlowAnalysis.IIsNullOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitIsPattern(IIsPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitIsType(IIsTypeOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitLabeled(ILabeledOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitListPattern(IListPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitLiteral(ILiteralOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitLocalFunction(ILocalFunctionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitLocalReference(ILocalReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitLock(ILockOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitMemberInitializer(IMemberInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitMethodBodyOperation(IMethodBodyOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitMethodReference(IMethodReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitNameOf(INameOfOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitNegatedPattern(INegatedPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitObjectCreation(IObjectCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitObjectOrCollectionInitializer(IObjectOrCollectionInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitOmittedArgument(IOmittedArgumentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitParameterInitializer(IParameterInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitParameterReference(IParameterReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitParenthesized(IParenthesizedOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitPatternCaseClause(IPatternCaseClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitPropertyInitializer(IPropertyInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitPropertyReference(IPropertyReferenceOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitPropertySubpattern(IPropertySubpatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRaiseEvent(IRaiseEventOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRangeCaseClause(IRangeCaseClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRangeOperation(IRangeOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRecursivePattern(IRecursivePatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitReDim(IReDimOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitReDimClause(IReDimClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRelationalCaseClause(IRelationalCaseClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitRelationalPattern(IRelationalPatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitReturn(IReturnOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSimpleAssignment(ISimpleAssignmentOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSingleValueCaseClause(ISingleValueCaseClauseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSizeOf(ISizeOfOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSlicePattern(ISlicePatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSpread(ISpreadOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitStaticLocalInitializationSemaphore(FlowAnalysis.IStaticLocalInitializationSemaphoreOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitStop(IStopOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSwitch(ISwitchOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSwitchCase(ISwitchCaseOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSwitchExpression(ISwitchExpressionOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitSwitchExpressionArm(ISwitchExpressionArmOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitThrow(IThrowOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTranslatedQuery(ITranslatedQueryOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTry(ITryOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTuple(ITupleOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTupleBinaryOperator(ITupleBinaryOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTypeOf(ITypeOfOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTypeParameterObjectCreation(ITypeParameterObjectCreationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitTypePattern(ITypePatternOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitUnaryOperator(IUnaryOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitUsing(IUsingOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitUsingDeclaration(IUsingDeclarationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitUtf8String(IUtf8StringOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitVariableDeclaration(IVariableDeclarationOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitVariableDeclarationGroup(IVariableDeclarationGroupOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitVariableDeclarator(IVariableDeclaratorOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitVariableInitializer(IVariableInitializerOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitWhileLoop(IWhileLoopOperation operation, TArgument argument) { throw null; }
        public virtual TResult? VisitWith(IWithOperation operation, TArgument argument) { throw null; }
    }
    public abstract partial class OperationWalker : OperationVisitor
    {
        public override void DefaultVisit(IOperation operation) { }
        public override void Visit(IOperation? operation) { }
    }

    public abstract partial class OperationWalker<TArgument> : OperationVisitor<TArgument, object?>
    {
        public override object? DefaultVisit(IOperation operation, TArgument argument) { throw null; }
        public override object? Visit(IOperation? operation, TArgument argument) { throw null; }
    }

    public enum UnaryOperatorKind
    {
        None = 0,
        BitwiseNegation = 1,
        Not = 2,
        Plus = 3,
        Minus = 4,
        True = 5,
        False = 6,
        Hat = 7
    }
}

namespace Microsoft.CodeAnalysis.Text
{
    [System.Runtime.Serialization.DataContract]
    public readonly partial struct LinePosition : System.IEquatable<LinePosition>, System.IComparable<LinePosition>
    {
        private readonly int _dummyPrimitive;
        public LinePosition(int line, int character) { }
        public int Character { get { throw null; } }
        public int Line { get { throw null; } }
        public static LinePosition Zero { get { throw null; } }

        public readonly int CompareTo(LinePosition other) { throw null; }
        public readonly bool Equals(LinePosition other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(LinePosition left, LinePosition right) { throw null; }
        public static bool operator >(LinePosition left, LinePosition right) { throw null; }
        public static bool operator >=(LinePosition left, LinePosition right) { throw null; }
        public static bool operator !=(LinePosition left, LinePosition right) { throw null; }
        public static bool operator <(LinePosition left, LinePosition right) { throw null; }
        public static bool operator <=(LinePosition left, LinePosition right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    [System.Runtime.Serialization.DataContract]
    public readonly partial struct LinePositionSpan : System.IEquatable<LinePositionSpan>
    {
        private readonly int _dummyPrimitive;
        public LinePositionSpan(LinePosition start, LinePosition end) { }
        public LinePosition End { get { throw null; } }
        public LinePosition Start { get { throw null; } }

        public readonly bool Equals(LinePositionSpan other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(LinePositionSpan left, LinePositionSpan right) { throw null; }
        public static bool operator !=(LinePositionSpan left, LinePositionSpan right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public enum SourceHashAlgorithm
    {
        None = 0,
        Sha1 = 1,
        Sha256 = 2
    }

    public abstract partial class SourceText
    {
        protected SourceText(System.Collections.Immutable.ImmutableArray<byte> checksum = default, SourceHashAlgorithm checksumAlgorithm = SourceHashAlgorithm.Sha1, SourceTextContainer? container = null) { }
        public bool CanBeEmbedded { get { throw null; } }
        public SourceHashAlgorithm ChecksumAlgorithm { get { throw null; } }
        public virtual SourceTextContainer Container { get { throw null; } }
        public abstract System.Text.Encoding? Encoding { get; }

        public abstract char this[int position] { get; }

        public abstract int Length { get; }
        public TextLineCollection Lines { get { throw null; } }

        public bool ContentEquals(SourceText other) { throw null; }
        protected virtual bool ContentEqualsImpl(SourceText other) { throw null; }
        public abstract void CopyTo(int sourceIndex, char[] destination, int destinationIndex, int count);
        public static SourceText From(byte[] buffer, int length, System.Text.Encoding? encoding = null, SourceHashAlgorithm checksumAlgorithm = SourceHashAlgorithm.Sha1, bool throwIfBinaryDetected = false, bool canBeEmbedded = false) { throw null; }
        public static SourceText From(byte[] buffer, int length, System.Text.Encoding? encoding, SourceHashAlgorithm checksumAlgorithm, bool throwIfBinaryDetected) { throw null; }
        public static SourceText From(System.IO.Stream stream, System.Text.Encoding? encoding = null, SourceHashAlgorithm checksumAlgorithm = SourceHashAlgorithm.Sha1, bool throwIfBinaryDetected = false, bool canBeEmbedded = false) { throw null; }
        public static SourceText From(System.IO.Stream stream, System.Text.Encoding? encoding, SourceHashAlgorithm checksumAlgorithm, bool throwIfBinaryDetected) { throw null; }
        public static SourceText From(System.IO.TextReader reader, int length, System.Text.Encoding? encoding = null, SourceHashAlgorithm checksumAlgorithm = SourceHashAlgorithm.Sha1) { throw null; }
        public static SourceText From(string text, System.Text.Encoding? encoding = null, SourceHashAlgorithm checksumAlgorithm = SourceHashAlgorithm.Sha1) { throw null; }
        public virtual System.Collections.Generic.IReadOnlyList<TextChangeRange> GetChangeRanges(SourceText oldText) { throw null; }
        public System.Collections.Immutable.ImmutableArray<byte> GetChecksum() { throw null; }
        public System.Collections.Immutable.ImmutableArray<byte> GetContentHash() { throw null; }
        protected virtual TextLineCollection GetLinesCore() { throw null; }
        public virtual SourceText GetSubText(TextSpan span) { throw null; }
        public SourceText GetSubText(int start) { throw null; }
        public virtual System.Collections.Generic.IReadOnlyList<TextChange> GetTextChanges(SourceText oldText) { throw null; }
        public SourceText Replace(TextSpan span, string newText) { throw null; }
        public SourceText Replace(int start, int length, string newText) { throw null; }
        public override string ToString() { throw null; }
        public virtual string ToString(TextSpan span) { throw null; }
        public SourceText WithChanges(params TextChange[] changes) { throw null; }
        public virtual SourceText WithChanges(System.Collections.Generic.IEnumerable<TextChange> changes) { throw null; }
        public virtual void Write(System.IO.TextWriter writer, TextSpan span, System.Threading.CancellationToken cancellationToken = default) { }
        public void Write(System.IO.TextWriter textWriter, System.Threading.CancellationToken cancellationToken = default) { }
    }
    public abstract partial class SourceTextContainer
    {
        public abstract SourceText CurrentText { get; }

        public abstract event System.EventHandler<TextChangeEventArgs> TextChanged;
    }
    [System.Runtime.Serialization.DataContract]
    public readonly partial struct TextChange : System.IEquatable<TextChange>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public TextChange(TextSpan span, string newText) { }
        [System.Runtime.Serialization.DataMember(Order = 1)]
        public string? NewText { get { throw null; } }
        public static System.Collections.Generic.IReadOnlyList<TextChange> NoChanges { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 0)]
        public TextSpan Span { get { throw null; } }

        public readonly bool Equals(TextChange other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(TextChange left, TextChange right) { throw null; }
        public static implicit operator TextChangeRange(TextChange change) { throw null; }
        public static bool operator !=(TextChange left, TextChange right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public partial class TextChangeEventArgs : System.EventArgs
    {
        public TextChangeEventArgs(SourceText oldText, SourceText newText, params TextChangeRange[] changes) { }
        public TextChangeEventArgs(SourceText oldText, SourceText newText, System.Collections.Generic.IEnumerable<TextChangeRange> changes) { }
        public System.Collections.Generic.IReadOnlyList<TextChangeRange> Changes { get { throw null; } }
        public SourceText NewText { get { throw null; } }
        public SourceText OldText { get { throw null; } }
    }

    public readonly partial struct TextChangeRange : System.IEquatable<TextChangeRange>
    {
        private readonly int _dummyPrimitive;
        public TextChangeRange(TextSpan span, int newLength) { }
        public int NewLength { get { throw null; } }
        public static System.Collections.Generic.IReadOnlyList<TextChangeRange> NoChanges { get { throw null; } }
        public TextSpan Span { get { throw null; } }

        public static TextChangeRange Collapse(System.Collections.Generic.IEnumerable<TextChangeRange> changes) { throw null; }
        public readonly bool Equals(TextChangeRange other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(TextChangeRange left, TextChangeRange right) { throw null; }
        public static bool operator !=(TextChangeRange left, TextChangeRange right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public readonly partial struct TextLine : System.IEquatable<TextLine>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public int End { get { throw null; } }
        public int EndIncludingLineBreak { get { throw null; } }
        public int LineNumber { get { throw null; } }
        public TextSpan Span { get { throw null; } }
        public TextSpan SpanIncludingLineBreak { get { throw null; } }
        public int Start { get { throw null; } }
        public SourceText? Text { get { throw null; } }

        public readonly bool Equals(TextLine other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public static TextLine FromSpan(SourceText text, TextSpan span) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(TextLine left, TextLine right) { throw null; }
        public static bool operator !=(TextLine left, TextLine right) { throw null; }
        public override readonly string ToString() { throw null; }
    }

    public abstract partial class TextLineCollection : System.Collections.Generic.IReadOnlyList<TextLine>, System.Collections.Generic.IEnumerable<TextLine>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<TextLine>
    {
        public abstract int Count { get; }

        public abstract TextLine this[int index] { get; }

        public Enumerator GetEnumerator() { throw null; }
        public virtual TextLine GetLineFromPosition(int position) { throw null; }
        public virtual LinePosition GetLinePosition(int position) { throw null; }
        public LinePositionSpan GetLinePositionSpan(TextSpan span) { throw null; }
        public int GetPosition(LinePosition position) { throw null; }
        public TextSpan GetTextSpan(LinePositionSpan span) { throw null; }
        public abstract int IndexOf(int position);
        System.Collections.Generic.IEnumerator<TextLine> System.Collections.Generic.IEnumerable<TextLine>.GetEnumerator() { throw null; }
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator() { throw null; }
        public partial struct Enumerator : System.Collections.Generic.IEnumerator<TextLine>, System.Collections.IEnumerator, System.IDisposable
        {
            private object _dummy;
            private int _dummyPrimitive;
            public TextLine Current { get { throw null; } }

            object System.Collections.IEnumerator.Current { get { throw null; } }

            public override bool Equals(object? obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public bool MoveNext() { throw null; }
            bool System.Collections.IEnumerator.MoveNext() { throw null; }
            void System.Collections.IEnumerator.Reset() { }
            void System.IDisposable.Dispose() { }
        }
    }

    [System.Runtime.Serialization.DataContract]
    public readonly partial struct TextSpan : System.IEquatable<TextSpan>, System.IComparable<TextSpan>
    {
        private readonly int _dummyPrimitive;
        public TextSpan(int start, int length) { }
        public int End { get { throw null; } }
        public bool IsEmpty { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 1)]
        public int Length { get { throw null; } }

        [System.Runtime.Serialization.DataMember(Order = 0)]
        public int Start { get { throw null; } }

        public readonly int CompareTo(TextSpan other) { throw null; }
        public readonly bool Contains(TextSpan span) { throw null; }
        public readonly bool Contains(int position) { throw null; }
        public readonly bool Equals(TextSpan other) { throw null; }
        public override readonly bool Equals(object? obj) { throw null; }
        public static TextSpan FromBounds(int start, int end) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public readonly TextSpan? Intersection(TextSpan span) { throw null; }
        public readonly bool IntersectsWith(TextSpan span) { throw null; }
        public readonly bool IntersectsWith(int position) { throw null; }
        public static bool operator ==(TextSpan left, TextSpan right) { throw null; }
        public static bool operator !=(TextSpan left, TextSpan right) { throw null; }
        public readonly TextSpan? Overlap(TextSpan span) { throw null; }
        public readonly bool OverlapsWith(TextSpan span) { throw null; }
        public override readonly string ToString() { throw null; }
    }
}