#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Adjust speech rate (speed)"

    def run(self):
        try:
            # Get current rate
            current_rate = float(
                self.env["runtime"]["SettingsManager"].get_setting(
                    "speech", "rate"
                )
            )
        except Exception as e:
            current_rate = 0.5

        # Present current rate
        rate_percent = int(current_rate * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Current speech rate: {rate_percent} percent", interrupt=True
        )

        # Increase by 10%, wrap around if at max
        new_rate = current_rate + 0.1
        if new_rate > 1.0:
            new_rate = 0.1  # Wrap to minimum

        # Apply the new rate
        self.env["runtime"]["SettingsManager"].set_setting(
            "speech", "rate", str(new_rate)
        )

        new_percent = int(new_rate * 100)
        self.env["runtime"]["OutputManager"].present_text(
            f"Speech rate set to {new_percent} percent",
            interrupt=False,
            flush=False,
        )

    def set_callback(self, callback):
        pass
