/**
 * \file pappsomspp/core/processing/cbor/mzcbor/precursor.h
 * \date 24/11/2025
 * \author Olivier Langella
 * \brief PSI precursor object for mzML/mzCBOR
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include "pappsomspp/core/processing/cbor/cborstreamreader.h"
#include "pappsomspp/core/processing/cbor/mzcbor/cvparam.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{

struct SelectedIon
{
  void fromCbor(CborStreamReader &reader);

  int getChargeState() const;
  qint64 getIntensity() const;
  double getMz() const;

  std::map<QString, pappso::cbor::mzcbor::CvParam> cvParamMap;
};
/**
 * @todo write docs
 */
struct Precursor
{
  void fromCbor(CborStreamReader &reader);

  QString spectrumRef;

  std::map<QString, pappso::cbor::mzcbor::CvParam> selectedIonListCvParamMap;

  std::vector<SelectedIon> selectedIonList;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
