# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    AnalyzeTextInputKind,
    AnalyzeTextOperationActionKind,
    AnalyzeTextOperationResultsKind,
    AnalyzeTextResultsKind,
    MetadataKind,
    PolicyKind,
    RedactionPolicyKind,
)

if TYPE_CHECKING:
    from .. import models as _models


class AbstractiveSummarizationActionContent(_Model):
    """Supported parameters for the pre-built Abstractive Summarization task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar sentence_count: Controls the approximate number of sentences in the output summaries.
    :vartype sentence_count: int
    :ivar string_index_type: String index type. Known values are: "TextElements_v8",
     "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    :ivar summary_length: (NOTE: Recommended to use summaryLength over sentenceCount) Controls the
     approximate length of the output summaries. Known values are: "short", "medium", and "long".
    :vartype summary_length: str or ~azure.ai.textanalytics.models.SummaryLengthBucket
    :ivar instruction: (Optional) If provided, the query will be used to generate the summary.
    :vartype instruction: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    sentence_count: Optional[int] = rest_field(
        name="sentenceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Controls the approximate number of sentences in the output summaries."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """String index type. Known values are: \"TextElements_v8\", \"UnicodeCodePoint\", and
     \"Utf16CodeUnit\"."""
    summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = rest_field(
        name="summaryLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """(NOTE: Recommended to use summaryLength over sentenceCount) Controls the approximate length of
     the output summaries. Known values are: \"short\", \"medium\", and \"long\"."""
    instruction: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) If provided, the query will be used to generate the summary."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        sentence_count: Optional[int] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        summary_length: Optional[Union[str, "_models.SummaryLengthBucket"]] = None,
        instruction: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextOperationAction(_Model):
    """The long running task to be performed by the service on the input documents.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbstractiveSummarizationOperationAction, CustomEntitiesLROTask,
    CustomMultiLabelClassificationOperationAction, CustomSingleLabelClassificationOperationAction,
    EntityLinkingLROTask, EntitiesLROTask, ExtractiveSummarizationOperationAction,
    HealthcareLROTask, KeyPhraseLROTask, PiiLROTask, SentimentAnalysisOperationAction

    :ivar name: task name.
    :vartype name: str
    :ivar kind: The kind of task to perform. Required. Known values are: "SentimentAnalysis",
     "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction", "EntityLinking",
     "Healthcare", "CustomEntityRecognition", "CustomSingleLabelClassification",
     "CustomMultiLabelClassification", "ExtractiveSummarization", and "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.models.AnalyzeTextOperationActionKind
    """

    __mapping__: dict[str, _Model] = {}
    name: Optional[str] = rest_field(name="taskName", visibility=["read", "create", "update", "delete", "query"])
    """task name."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of task to perform. Required. Known values are: \"SentimentAnalysis\",
     \"EntityRecognition\", \"PiiEntityRecognition\", \"KeyPhraseExtraction\", \"EntityLinking\",
     \"Healthcare\", \"CustomEntityRecognition\", \"CustomSingleLabelClassification\",
     \"CustomMultiLabelClassification\", \"ExtractiveSummarization\", and
     \"AbstractiveSummarization\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AbstractiveSummarizationOperationAction(AnalyzeTextOperationAction, discriminator="AbstractiveSummarization"):
    """An object representing the task definition for an Abstractive Summarization task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: The Abstractive Summarization kind of the long running task. Required. Abstractive
     summarization task
    :vartype kind: str or ~azure.ai.textanalytics.models.ABSTRACTIVE_SUMMARIZATION
    :ivar action_content: Parameters for the Abstractive Summarization task.
    :vartype action_content: ~azure.ai.textanalytics.models.AbstractiveSummarizationActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.ABSTRACTIVE_SUMMARIZATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Abstractive Summarization kind of the long running task. Required. Abstractive
     summarization task"""
    action_content: Optional["_models.AbstractiveSummarizationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for the Abstractive Summarization task."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models.AbstractiveSummarizationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.ABSTRACTIVE_SUMMARIZATION, **kwargs)


class AnalyzeTextLROResult(_Model):
    """Contains the AnalyzeText long running operation result object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbstractiveSummarizationOperationResult, CustomEntityRecognitionOperationResult,
    CustomMultiLabelClassificationOperationResult, CustomSingleLabelClassificationOperationResult,
    EntityLinkingOperationResult, EntityRecognitionOperationResult,
    ExtractiveSummarizationOperationResult, HealthcareLROResult,
    KeyPhraseExtractionOperationResult, PiiEntityRecognitionOperationResult, SentimentLROResult

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Known values are: "SentimentAnalysisLROResults",
     "EntityRecognitionLROResults", "PiiEntityRecognitionLROResults",
     "KeyPhraseExtractionLROResults", "EntityLinkingLROResults", "HealthcareLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", "ExtractiveSummarizationLROResults", and
     "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.models.AnalyzeTextOperationResultsKind
    """

    __mapping__: dict[str, _Model] = {}
    last_update_date_time: datetime.datetime = rest_field(
        name="lastUpdateDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The last updated time in UTC for the task. Required."""
    status: Union[str, "_models.TextActionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the task at the mentioned last update time. Required. Known values are:
     \"notStarted\", \"running\", \"succeeded\", \"partiallyCompleted\", \"failed\", \"cancelled\",
     and \"cancelling\"."""
    task_name: Optional[str] = rest_field(name="taskName", visibility=["read", "create", "update", "delete", "query"])
    """task name."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Kind of the task. Required. Known values are: \"SentimentAnalysisLROResults\",
     \"EntityRecognitionLROResults\", \"PiiEntityRecognitionLROResults\",
     \"KeyPhraseExtractionLROResults\", \"EntityLinkingLROResults\", \"HealthcareLROResults\",
     \"CustomEntityRecognitionLROResults\", \"CustomSingleLabelClassificationLROResults\",
     \"CustomMultiLabelClassificationLROResults\", \"ExtractiveSummarizationLROResults\", and
     \"AbstractiveSummarizationLROResults\"."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        kind: str,
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AbstractiveSummarizationOperationResult(AnalyzeTextLROResult, discriminator="AbstractiveSummarizationLROResults"):
    """An object representing the results for an Abstractive Summarization task.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Abstractive summarization LRO results
    :vartype kind: str or
     ~azure.ai.textanalytics.models.ABSTRACTIVE_SUMMARIZATION_OPERATION_RESULTS
    :ivar results: Results of the task. Required.
    :vartype results: ~azure.ai.textanalytics.models.AbstractiveSummarizationResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.ABSTRACTIVE_SUMMARIZATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Abstractive summarization LRO results"""
    results: "_models.AbstractiveSummarizationResult" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Results of the task. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.AbstractiveSummarizationResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeTextOperationResultsKind.ABSTRACTIVE_SUMMARIZATION_OPERATION_RESULTS, **kwargs
        )


class AbstractiveSummarizationResult(_Model):
    """An object representing the pre-built Abstractive Summarization results of each document.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.AbstractiveSummaryActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.AbstractiveSummaryActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.AbstractiveSummaryActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AbstractiveSummary(_Model):
    """An object representing a single summary with context for given document.

    :ivar text: The text of the summary. Required.
    :vartype text: str
    :ivar contexts: The context list of the summary.
    :vartype contexts: list[~azure.ai.textanalytics.models.SummaryContext]
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text of the summary. Required."""
    contexts: Optional[list["_models.SummaryContext"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The context list of the summary."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        contexts: Optional[list["_models.SummaryContext"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AbstractiveSummaryActionResult(_Model):
    """An object representing the Abstractive Summarization result of a single document with detected
    language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar summaries: A list of abstractive summaries. Required.
    :vartype summaries: list[~azure.ai.textanalytics.models.AbstractiveSummary]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    summaries: list["_models.AbstractiveSummary"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of abstractive summaries. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        summaries: list["_models.AbstractiveSummary"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseMetadata(_Model):
    """The abstract base class for entity Metadata.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgeMetadata, AreaMetadata, CurrencyMetadata, DateMetadata, DateTimeMetadata,
    InformationMetadata, LengthMetadata, NumberMetadata, NumericRangeMetadata, OrdinalMetadata,
    SpeedMetadata, TemperatureMetadata, TemporalSetMetadata, TemporalSpanMetadata, TimeMetadata,
    VolumeMetadata, WeightMetadata

    :ivar metadata_kind: The entity Metadata object kind. Required. Known values are:
     "DateMetadata", "DateTimeMetadata", "TimeMetadata", "TemporalSetMetadata", "NumberMetadata",
     "OrdinalMetadata", "SpeedMetadata", "WeightMetadata", "LengthMetadata", "VolumeMetadata",
     "AreaMetadata", "AgeMetadata", "InformationMetadata", "TemperatureMetadata",
     "CurrencyMetadata", "NumericRangeMetadata", and "TemporalSpanMetadata".
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.MetadataKind
    """

    __mapping__: dict[str, _Model] = {}
    metadata_kind: str = rest_discriminator(
        name="metadataKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """The entity Metadata object kind. Required. Known values are: \"DateMetadata\",
     \"DateTimeMetadata\", \"TimeMetadata\", \"TemporalSetMetadata\", \"NumberMetadata\",
     \"OrdinalMetadata\", \"SpeedMetadata\", \"WeightMetadata\", \"LengthMetadata\",
     \"VolumeMetadata\", \"AreaMetadata\", \"AgeMetadata\", \"InformationMetadata\",
     \"TemperatureMetadata\", \"CurrencyMetadata\", \"NumericRangeMetadata\", and
     \"TemporalSpanMetadata\"."""

    @overload
    def __init__(
        self,
        *,
        metadata_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgeMetadata(BaseMetadata, discriminator="AgeMetadata"):
    """Represents the Age entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for age-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.AGE_METADATA
    :ivar unit: Unit of measure for age. Required. Known values are: "Unspecified", "Year",
     "Month", "Week", and "Day".
    :vartype unit: str or ~azure.ai.textanalytics.models.AgeUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.AGE_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for age-related values."""
    unit: Union[str, "_models.AgeUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for age. Required. Known values are: \"Unspecified\", \"Year\", \"Month\",
     \"Week\", and \"Day\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.AgeUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.AGE_METADATA, **kwargs)


class EntityOverlapPolicy(_Model):
    """The abstract base class for entity OverlapPolicy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AllowOverlapEntityPolicyType, MatchLongestEntityPolicyType

    :ivar policy_kind: The entity OverlapPolicy object kind. Required. Known values are:
     "matchLongest" and "allowOverlap".
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.PolicyKind
    """

    __mapping__: dict[str, _Model] = {}
    policy_kind: str = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])
    """The entity OverlapPolicy object kind. Required. Known values are: \"matchLongest\" and
     \"allowOverlap\"."""

    @overload
    def __init__(
        self,
        *,
        policy_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AllowOverlapEntityPolicyType(EntityOverlapPolicy, discriminator="allowOverlap"):
    """Represents the allow overlap policy. Will apply no post processing logic for the entities.
    Whatever the model predicts is what will be returned to the user. This allows the user to get a
    full view of every single model's possible values and apply their own custom logic on entity
    selection.

    :ivar policy_kind: The entity OverlapPolicy object kind. Required. Represents
     AllowOverlapEntityPolicyType
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.ALLOW_OVERLAP
    """

    policy_kind: Literal[PolicyKind.ALLOW_OVERLAP] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity OverlapPolicy object kind. Required. Represents AllowOverlapEntityPolicyType"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=PolicyKind.ALLOW_OVERLAP, **kwargs)


class AnalyzeTextResult(_Model):
    """The result object for the analyze task.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AnalyzeTextEntityLinkingResult, AnalyzeTextEntitiesResult, AnalyzeTextKeyPhraseResult,
    AnalyzeTextLanguageDetectionResult, AnalyzeTextPiiResult, AnalyzeTextSentimentResult

    :ivar kind: The kind of task result. Required. Known values are: "SentimentAnalysisResults",
     "EntityRecognitionResults", "PiiEntityRecognitionResults", "KeyPhraseExtractionResults",
     "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.models.AnalyzeTextResultsKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of task result. Required. Known values are: \"SentimentAnalysisResults\",
     \"EntityRecognitionResults\", \"PiiEntityRecognitionResults\", \"KeyPhraseExtractionResults\",
     \"LanguageDetectionResults\", and \"EntityLinkingResults\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextEntitiesResult(AnalyzeTextResult, discriminator="EntityRecognitionResults"):
    """Contains the entity task.

    :ivar kind: kind of the task. Required. Entity recognition results
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_RECOGNITION_RESULTS
    :ivar results: Results for entity recognition. Required.
    :vartype results: ~azure.ai.textanalytics.models.EntitiesWithMetadataAutoResult
    """

    kind: Literal[AnalyzeTextResultsKind.ENTITY_RECOGNITION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """kind of the task. Required. Entity recognition results"""
    results: "_models.EntitiesWithMetadataAutoResult" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Results for entity recognition. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.EntitiesWithMetadataAutoResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.ENTITY_RECOGNITION_RESULTS, **kwargs)


class AnalyzeTextEntityLinkingResult(AnalyzeTextResult, discriminator="EntityLinkingResults"):
    """Contains the analyze text Entity linking task result.

    :ivar kind: Kind of task result. Required. Entity linking results
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_LINKING_RESULTS
    :ivar results: Entity linking result. Required.
    :vartype results: ~azure.ai.textanalytics.models.EntityLinkingResult
    """

    kind: Literal[AnalyzeTextResultsKind.ENTITY_LINKING_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of task result. Required. Entity linking results"""
    results: "_models.EntityLinkingResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity linking result. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.EntityLinkingResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.ENTITY_LINKING_RESULTS, **kwargs)


class AnalyzeTextError(_Model):
    """The error response object returned when the service encounters some errors during processing
    the request.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", and "Warning".
    :vartype code: str or ~azure.ai.textanalytics.models.AnalyzeTextErrorCode
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.models.AnalyzeTextError]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.models.InnerErrorModel
    """

    code: Union[str, "_models.AnalyzeTextErrorCode"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidArgument\", \"Unauthorized\", \"Forbidden\", \"NotFound\", \"ProjectNotFound\",
     \"OperationNotFound\", \"AzureCognitiveSearchNotFound\", \"AzureCognitiveSearchIndexNotFound\",
     \"TooManyRequests\", \"AzureCognitiveSearchThrottling\",
     \"AzureCognitiveSearchIndexLimitReached\", \"InternalServerError\", \"ServiceUnavailable\",
     \"Timeout\", \"QuotaExceeded\", \"Conflict\", and \"Warning\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable representation of the error. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the error."""
    details: Optional[list["_models.AnalyzeTextError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An array of details about specific errors that led to this reported error."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.AnalyzeTextErrorCode"],
        message: str,
        target: Optional[str] = None,
        details: Optional[list["_models.AnalyzeTextError"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextInput(_Model):
    """Collection of documents to analyze and a single task to execute.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TextEntityLinkingInput, TextEntityRecognitionInput, TextKeyPhraseExtractionInput,
    TextLanguageDetectionInput, TextPiiEntitiesRecognitionInput, TextSentimentAnalysisInput

    :ivar kind: The kind of task to perform. Required. Known values are: "SentimentAnalysis",
     "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction", "LanguageDetection", and
     "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.models.AnalyzeTextInputKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of task to perform. Required. Known values are: \"SentimentAnalysis\",
     \"EntityRecognition\", \"PiiEntityRecognition\", \"KeyPhraseExtraction\",
     \"LanguageDetection\", and \"EntityLinking\"."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextKeyPhraseResult(AnalyzeTextResult, discriminator="KeyPhraseExtractionResults"):
    """Contains the analyze text KeyPhraseExtraction task result.

    :ivar kind: Kind of the task results. Required. Key phrase extraction results
    :vartype kind: str or ~azure.ai.textanalytics.models.KEY_PHRASE_EXTRACTION_RESULTS
    :ivar results: The list of Key phrase extraction results. Required.
    :vartype results: ~azure.ai.textanalytics.models.KeyPhraseResult
    """

    kind: Literal[AnalyzeTextResultsKind.KEY_PHRASE_EXTRACTION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task results. Required. Key phrase extraction results"""
    results: "_models.KeyPhraseResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of Key phrase extraction results. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.KeyPhraseResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.KEY_PHRASE_EXTRACTION_RESULTS, **kwargs)


class AnalyzeTextLanguageDetectionResult(AnalyzeTextResult, discriminator="LanguageDetectionResults"):
    """Contains the language detection task result for the request.

    :ivar kind: Kind of the task result. Required. Language detection results
    :vartype kind: str or ~azure.ai.textanalytics.models.LANGUAGE_DETECTION_RESULTS
    :ivar results: Contains the language detection results. Required.
    :vartype results: ~azure.ai.textanalytics.models.LanguageDetectionResult
    """

    kind: Literal[AnalyzeTextResultsKind.LANGUAGE_DETECTION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task result. Required. Language detection results"""
    results: "_models.LanguageDetectionResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Contains the language detection results. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.LanguageDetectionResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.LANGUAGE_DETECTION_RESULTS, **kwargs)


class AnalyzeTextOperationState(_Model):
    """The object containing the analyze job LRO job state.

    :ivar display_name: display name.
    :vartype display_name: str
    :ivar created_at: Date and time job created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar expires_on: Date and time job expires.
    :vartype expires_on: ~datetime.datetime
    :ivar job_id: job ID. Required.
    :vartype job_id: str
    :ivar last_updated_at: last updated date and time. Required.
    :vartype last_updated_at: ~datetime.datetime
    :ivar status: status. Required. Known values are: "notStarted", "running", "succeeded",
     "partiallyCompleted", "failed", "cancelled", and "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar errors: errors.
    :vartype errors: list[~azure.ai.textanalytics.models.AnalyzeTextError]
    :ivar next_link: next link.
    :vartype next_link: str
    :ivar actions: List of tasks. Required.
    :vartype actions: ~azure.ai.textanalytics.models.TextActions
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    """

    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """display name."""
    created_at: datetime.datetime = rest_field(
        name="createdDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time job created. Required."""
    expires_on: Optional[datetime.datetime] = rest_field(
        name="expirationDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Date and time job expires."""
    job_id: str = rest_field(name="jobId", visibility=["read"])
    """job ID. Required."""
    last_updated_at: datetime.datetime = rest_field(
        name="lastUpdatedDateTime", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """last updated date and time. Required."""
    status: Union[str, "_models.TextActionState"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """status. Required. Known values are: \"notStarted\", \"running\", \"succeeded\",
     \"partiallyCompleted\", \"failed\", \"cancelled\", and \"cancelling\"."""
    errors: Optional[list["_models.AnalyzeTextError"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """errors."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """next link."""
    actions: "_models.TextActions" = rest_field(
        name="tasks", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of tasks. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""

    @overload
    def __init__(
        self,
        *,
        created_at: datetime.datetime,
        last_updated_at: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        actions: "_models.TextActions",
        display_name: Optional[str] = None,
        expires_on: Optional[datetime.datetime] = None,
        errors: Optional[list["_models.AnalyzeTextError"]] = None,
        next_link: Optional[str] = None,
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnalyzeTextPiiResult(AnalyzeTextResult, discriminator="PiiEntityRecognitionResults"):
    """Contains the analyze text PIIEntityRecognition LRO task.

    :ivar kind: The kind of the task. Required. PII entity recognition results
    :vartype kind: str or ~azure.ai.textanalytics.models.PII_ENTITY_RECOGNITION_RESULTS
    :ivar results: The list of pii results. Required.
    :vartype results: ~azure.ai.textanalytics.models.PiiResult
    """

    kind: Literal[AnalyzeTextResultsKind.PII_ENTITY_RECOGNITION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of the task. Required. PII entity recognition results"""
    results: "_models.PiiResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of pii results. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.PiiResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.PII_ENTITY_RECOGNITION_RESULTS, **kwargs)


class AnalyzeTextSentimentResult(AnalyzeTextResult, discriminator="SentimentAnalysisResults"):
    """Contains the analyze text SentimentAnalysis LRO task result.

    :ivar kind: Kind of the task. Required. Sentiment analysis results
    :vartype kind: str or ~azure.ai.textanalytics.models.SENTIMENT_ANALYSIS_RESULTS
    :ivar results: The sentiment analysis results. Required.
    :vartype results: ~azure.ai.textanalytics.models.SentimentResult
    """

    kind: Literal[AnalyzeTextResultsKind.SENTIMENT_ANALYSIS_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Sentiment analysis results"""
    results: "_models.SentimentResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sentiment analysis results. Required."""

    @overload
    def __init__(
        self,
        *,
        results: "_models.SentimentResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextResultsKind.SENTIMENT_ANALYSIS_RESULTS, **kwargs)


class AreaMetadata(BaseMetadata, discriminator="AreaMetadata"):
    """Represents the Area entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for area-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.AREA_METADATA
    :ivar unit: Unit of measure for area. Required. Known values are: "Unspecified",
     "SquareKilometer", "SquareHectometer", "SquareDecameter", "SquareDecimeter", "SquareMeter",
     "SquareCentimeter", "SquareMillimeter", "SquareInch", "SquareFoot", "SquareMile", "SquareYard",
     and "Acre".
    :vartype unit: str or ~azure.ai.textanalytics.models.AreaUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.AREA_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for area-related values."""
    unit: Union[str, "_models.AreaUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for area. Required. Known values are: \"Unspecified\", \"SquareKilometer\",
     \"SquareHectometer\", \"SquareDecameter\", \"SquareDecimeter\", \"SquareMeter\",
     \"SquareCentimeter\", \"SquareMillimeter\", \"SquareInch\", \"SquareFoot\", \"SquareMile\",
     \"SquareYard\", and \"Acre\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.AreaUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.AREA_METADATA, **kwargs)


class BaseRedactionPolicy(_Model):
    """The abstract base class for RedactionPolicy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CharacterMaskPolicyType, EntityMaskPolicyType, NoMaskPolicyType

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. Known values are:
     "noMask", "characterMask", and "entityMask".
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.RedactionPolicyKind
    """

    __mapping__: dict[str, _Model] = {}
    policy_kind: str = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])
    """The entity RedactionPolicy object kind. Required. Known values are: \"noMask\",
     \"characterMask\", and \"entityMask\"."""

    @overload
    def __init__(
        self,
        *,
        policy_kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CharacterMaskPolicyType(BaseRedactionPolicy, discriminator="characterMask"):
    """Represents the policy of redacting with a redaction character.

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. React detected entities
     with redaction character.
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.CHARACTER_MASK
    :ivar redaction_character: Optional parameter to use a Custom Character to be used for
     redaction in PII responses. Default character will bce * as before. We allow specific ascii
     characters for redaction. Known values are: "!", "#", "$", "%", "&", "*", "+", "-", "=", "?",
     "@", "^", "_", and "~".
    :vartype redaction_character: str or ~azure.ai.textanalytics.models.RedactionCharacter
    """

    policy_kind: Literal[RedactionPolicyKind.CHARACTER_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity RedactionPolicy object kind. Required. React detected entities with redaction
     character."""
    redaction_character: Optional[Union[str, "_models.RedactionCharacter"]] = rest_field(
        name="redactionCharacter", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter to use a Custom Character to be used for redaction in PII responses. Default
     character will bce * as before. We allow specific ascii characters for redaction. Known values
     are: \"!\", \"#\", \"$\", \"%\", \"&\", \"*\", \"+\", \"-\", \"=\", \"?\", \"@\", \"^\", \"_\",
     and \"~\"."""

    @overload
    def __init__(
        self,
        *,
        redaction_character: Optional[Union[str, "_models.RedactionCharacter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.CHARACTER_MASK, **kwargs)


class ClassificationActionResult(_Model):
    """Contains the classification doc result for the task with detected language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar class_property: Contains the classification doc results for all docs. Required.
    :vartype class_property: list[~azure.ai.textanalytics.models.ClassificationResult]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    class_property: list["_models.ClassificationResult"] = rest_field(
        name="class", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the classification doc results for all docs. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        class_property: list["_models.ClassificationResult"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClassificationResult(_Model):
    """Contains the classification result.

    :ivar category: Classification type. Required.
    :vartype category: str
    :ivar confidence_score: Confidence score between 0 and 1 of the recognized class. Required.
    :vartype confidence_score: float
    """

    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Classification type. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the recognized class. Required."""

    @overload
    def __init__(
        self,
        *,
        category: str,
        confidence_score: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CurrencyMetadata(BaseMetadata, discriminator="CurrencyMetadata"):
    """Represents the Currency ) entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for currency-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.CURRENCY_METADATA
    :ivar unit: Currency unit. Required.
    :vartype unit: str
    :ivar iso4217: The alphabetic code based on another ISO standard, ISO 3166, which lists the
     codes for country names. The first two letters of the ISO 4217 three-letter code are the same
     as the code for the country name, and, where possible, the third letter corresponds to the
     first letter of the currency name.
    :vartype iso4217: str
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.CURRENCY_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for currency-related values."""
    unit: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Currency unit. Required."""
    iso4217: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The alphabetic code based on another ISO standard, ISO 3166, which lists the codes for country
     names. The first two letters of the ISO 4217 three-letter code are the same as the code for the
     country name, and, where possible, the third letter corresponds to the first letter of the
     currency name."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: str,
        iso4217: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.CURRENCY_METADATA, **kwargs)


class CustomEntitiesActionContent(_Model):
    """Supported parameters for a Custom Entities task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar string_index_type: Optional parameter to provide the string index type used to interpret
     string offsets. Defaults to TextElements (Graphemes). Known values are: "TextElements_v8",
     "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter to provide the string index type used to interpret string offsets. Defaults
     to TextElements (Graphemes). Known values are: \"TextElements_v8\", \"UnicodeCodePoint\", and
     \"Utf16CodeUnit\"."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntitiesLROTask(AnalyzeTextOperationAction, discriminator="CustomEntityRecognition"):
    """Contains the custom text LRO task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of the task. Required. Custom entity recognition task
    :vartype kind: str or ~azure.ai.textanalytics.models.CUSTOM_ENTITY_RECOGNITION
    :ivar parameters: task parameters.
    :vartype parameters: ~azure.ai.textanalytics.models.CustomEntitiesActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.CUSTOM_ENTITY_RECOGNITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom entity recognition task"""
    parameters: Optional["_models.CustomEntitiesActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.CustomEntitiesActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.CUSTOM_ENTITY_RECOGNITION, **kwargs)


class CustomEntitiesResult(_Model):
    """Contains the list of detected custom entities result for the documents.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar documents: Enumeration of the document results. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.CustomEntityActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""
    documents: list["_models.CustomEntityActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of the document results. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: list["_models.CustomEntityActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityActionResult(_Model):
    """Contains the entity recognition task result for the document with detected language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.NamedEntity]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    entities: list["_models.NamedEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Recognized entities in the document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        entities: list["_models.NamedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomEntityRecognitionOperationResult(AnalyzeTextLROResult, discriminator="CustomEntityRecognitionLROResults"):
    """Contains the custom entity recognition job result.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Custom entity recognition LRO results
    :vartype kind: str or
     ~azure.ai.textanalytics.models.CUSTOM_ENTITY_RECOGNITION_OPERATION_RESULTS
    :ivar results: List of results. Required.
    :vartype results: ~azure.ai.textanalytics.models.CustomEntitiesResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.CUSTOM_ENTITY_RECOGNITION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom entity recognition LRO results"""
    results: "_models.CustomEntitiesResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.CustomEntitiesResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeTextOperationResultsKind.CUSTOM_ENTITY_RECOGNITION_OPERATION_RESULTS, **kwargs
        )


class CustomLabelClassificationResult(_Model):
    """Contains the custom label classification results.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.ClassificationActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""
    documents: list["_models.ClassificationActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: list["_models.ClassificationActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomMultiLabelClassificationActionContent(_Model):  # pylint: disable=name-too-long
    """Supported parameters for a Custom Multi Classification task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomMultiLabelClassificationOperationAction(
    AnalyzeTextOperationAction, discriminator="CustomMultiLabelClassification"
):  # pylint: disable=name-too-long
    """Use custom models to classify text into multi label taxonomy.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of the task. Required. Custom multi label classification task
    :vartype kind: str or ~azure.ai.textanalytics.models.CUSTOM_MULTI_LABEL_CLASSIFICATION
    :ivar action_content: Task parameters.
    :vartype action_content:
     ~azure.ai.textanalytics.models.CustomMultiLabelClassificationActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.CUSTOM_MULTI_LABEL_CLASSIFICATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom multi label classification task"""
    action_content: Optional["_models.CustomMultiLabelClassificationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models.CustomMultiLabelClassificationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.CUSTOM_MULTI_LABEL_CLASSIFICATION, **kwargs)


class CustomMultiLabelClassificationOperationResult(
    AnalyzeTextLROResult, discriminator="CustomMultiLabelClassificationLROResults"
):  # pylint: disable=name-too-long
    """Contains the custom multi label classification job result.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Custom multi label classification LRO results
    :vartype kind: str or
     ~azure.ai.textanalytics.models.CUSTOM_MULTI_LABEL_CLASSIFICATION_OPERATION_RESULTS
    :ivar results: List of results. Required.
    :vartype results: ~azure.ai.textanalytics.models.CustomLabelClassificationResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.CUSTOM_MULTI_LABEL_CLASSIFICATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom multi label classification LRO results"""
    results: "_models.CustomLabelClassificationResult" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeTextOperationResultsKind.CUSTOM_MULTI_LABEL_CLASSIFICATION_OPERATION_RESULTS, **kwargs
        )


class CustomSingleLabelClassificationActionContent(_Model):  # pylint: disable=name-too-long
    """Supported parameters for a Custom Single Classification task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    project_name: str = rest_field(name="projectName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the project name for the model. Required."""
    deployment_name: str = rest_field(name="deploymentName", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates the deployment name for the model. Required."""

    @overload
    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CustomSingleLabelClassificationOperationAction(
    AnalyzeTextOperationAction, discriminator="CustomSingleLabelClassification"
):  # pylint: disable=name-too-long
    """Use custom models to classify text into single label taxonomy.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of the task. Required. Custom single label classification task
    :vartype kind: str or ~azure.ai.textanalytics.models.CUSTOM_SINGLE_LABEL_CLASSIFICATION
    :ivar action_content: Task parameters.
    :vartype action_content:
     ~azure.ai.textanalytics.models.CustomSingleLabelClassificationActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom single label classification task"""
    action_content: Optional["_models.CustomSingleLabelClassificationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models.CustomSingleLabelClassificationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION, **kwargs)


class CustomSingleLabelClassificationOperationResult(
    AnalyzeTextLROResult, discriminator="CustomSingleLabelClassificationLROResults"
):  # pylint: disable=name-too-long
    """Contains the custom single label classification job result.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Custom single label classification LRO results
    :vartype kind: str or
     ~azure.ai.textanalytics.models.CUSTOM_SINGLE_LABEL_CLASSIFICATION_OPERATION_RESULTS
    :ivar results: List of results. Required.
    :vartype results: ~azure.ai.textanalytics.models.CustomLabelClassificationResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Custom single label classification LRO results"""
    results: "_models.CustomLabelClassificationResult" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeTextOperationResultsKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION_OPERATION_RESULTS, **kwargs
        )


class DateMetadata(BaseMetadata, discriminator="DateMetadata"):
    """A Metadata for date entity instances.

    :ivar dates: List of date values.
    :vartype dates: list[~azure.ai.textanalytics.models.DateValue]
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for date-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.DATE_METADATA
    """

    dates: Optional[list["_models.DateValue"]] = rest_field(
        name="dateValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of date values."""
    metadata_kind: Literal[MetadataKind.DATE_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for date-related values."""

    @overload
    def __init__(
        self,
        *,
        dates: Optional[list["_models.DateValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.DATE_METADATA, **kwargs)


class DateTimeMetadata(BaseMetadata, discriminator="DateTimeMetadata"):
    """A Metadata for datetime entity instances.

    :ivar dates: List of date values.
    :vartype dates: list[~azure.ai.textanalytics.models.DateValue]
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for date and time-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.DATE_TIME_METADATA
    """

    dates: Optional[list["_models.DateValue"]] = rest_field(
        name="dateValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of date values."""
    metadata_kind: Literal[MetadataKind.DATE_TIME_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for date and time-related values."""

    @overload
    def __init__(
        self,
        *,
        dates: Optional[list["_models.DateValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.DATE_TIME_METADATA, **kwargs)


class DateValue(_Model):
    """Represents the date value.

    :ivar timex: An extended ISO 8601 date/time representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
     Required.
    :vartype timex: str
    :ivar value: The actual time that the extracted text denote. Required.
    :vartype value: str
    :ivar modifier: Modifier for datetime to indicate point of reference like before, after etc.
     Known values are: "AfterApprox", "Before", "BeforeStart", "Approx", "ReferenceUndefined",
     "SinceEnd", "AfterMid", "Start", "After", "BeforeEnd", "Until", "End", "Less", "Since",
     "AfterStart", "BeforeApprox", "Mid", and "More".
    :vartype modifier: str or ~azure.ai.textanalytics.models.TemporalModifier
    """

    timex: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An extended ISO 8601 date/time representation as described in
     (`https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml
     <https://github.com/Microsoft/Recognizers-Text/blob/master/Patterns/English/English-DateTime.yaml>`_).
     Required."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The actual time that the extracted text denote. Required."""
    modifier: Optional[Union[str, "_models.TemporalModifier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Modifier for datetime to indicate point of reference like before, after etc. Known values are:
     \"AfterApprox\", \"Before\", \"BeforeStart\", \"Approx\", \"ReferenceUndefined\", \"SinceEnd\",
     \"AfterMid\", \"Start\", \"After\", \"BeforeEnd\", \"Until\", \"End\", \"Less\", \"Since\",
     \"AfterStart\", \"BeforeApprox\", \"Mid\", and \"More\"."""

    @overload
    def __init__(
        self,
        *,
        timex: str,
        value: str,
        modifier: Optional[Union[str, "_models.TemporalModifier"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DetectedLanguage(_Model):
    """Contains the details of the detected language for the text.

    :ivar name: Long name of a detected language (e.g. English, French). Required.
    :vartype name: str
    :ivar iso6391_name: A two letter representation of the detected language according to the ISO
     639-1 standard (e.g. en, fr). Required.
    :vartype iso6391_name: str
    :ivar confidence_score: A confidence score between 0 and 1. Scores close to 1 indicate 100%
     certainty that the identified language is true. Required.
    :vartype confidence_score: float
    :ivar script_name: Identifies the script name of the input document according to the ISO 15924
     standard. Known values are: "Arabic", "Armenian", "Bangla",
     "UnifiedCanadianAboriginalSyllabics", "Cyrillic", "Devanagari", "Ethiopic", "Georgian",
     "Greek", "Gujarati", "Gurmukhi", "Hangul", "HanLiteral", "HanSimplified", "HanTraditional",
     "Hebrew", "Japanese", "Khmer", "Kannada", "Lao", "Latin", "Malayalam", "Meitei", "Mongolian",
     "Myanmar", "Odia", "Santali", "Sharada", "Sinhala", "Tamil", "Telugu", "Thaana", "Thai", and
     "Tibetan".
    :vartype script_name: str or ~azure.ai.textanalytics.models.ScriptKind
    :ivar script_iso15924_code: Identifies the script code of the input document according to the
     ISO 15924 standard. Known values are: "Arab", "Armn", "Beng", "Cans", "Cyrl", "Deva", "Ethi",
     "Geor", "Grek", "Gujr", "Guru", "Hang", "Hani", "Hans", "Hant", "Hebr", "Jpan", "Khmr", "Knda",
     "Laoo", "Latn", "Mlym", "Mong", "Mtei", "Mymr", "Olck", "Orya", "Sinh", "Shrd", "Taml", "Telu",
     "Thaa", "Thai", and "Tibt".
    :vartype script_iso15924_code: str or ~azure.ai.textanalytics.models.ScriptCode
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Long name of a detected language (e.g. English, French). Required."""
    iso6391_name: str = rest_field(name="iso6391Name", visibility=["read", "create", "update", "delete", "query"])
    """A two letter representation of the detected language according to the ISO 639-1 standard (e.g.
     en, fr). Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the
     identified language is true. Required."""
    script_name: Optional[Union[str, "_models.ScriptKind"]] = rest_field(
        name="scriptName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifies the script name of the input document according to the ISO 15924 standard. Known
     values are: \"Arabic\", \"Armenian\", \"Bangla\", \"UnifiedCanadianAboriginalSyllabics\",
     \"Cyrillic\", \"Devanagari\", \"Ethiopic\", \"Georgian\", \"Greek\", \"Gujarati\",
     \"Gurmukhi\", \"Hangul\", \"HanLiteral\", \"HanSimplified\", \"HanTraditional\", \"Hebrew\",
     \"Japanese\", \"Khmer\", \"Kannada\", \"Lao\", \"Latin\", \"Malayalam\", \"Meitei\",
     \"Mongolian\", \"Myanmar\", \"Odia\", \"Santali\", \"Sharada\", \"Sinhala\", \"Tamil\",
     \"Telugu\", \"Thaana\", \"Thai\", and \"Tibetan\"."""
    script_iso15924_code: Optional[Union[str, "_models.ScriptCode"]] = rest_field(
        name="scriptIso15924Code", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identifies the script code of the input document according to the ISO 15924 standard. Known
     values are: \"Arab\", \"Armn\", \"Beng\", \"Cans\", \"Cyrl\", \"Deva\", \"Ethi\", \"Geor\",
     \"Grek\", \"Gujr\", \"Guru\", \"Hang\", \"Hani\", \"Hans\", \"Hant\", \"Hebr\", \"Jpan\",
     \"Khmr\", \"Knda\", \"Laoo\", \"Latn\", \"Mlym\", \"Mong\", \"Mtei\", \"Mymr\", \"Olck\",
     \"Orya\", \"Sinh\", \"Shrd\", \"Taml\", \"Telu\", \"Thaa\", \"Thai\", and \"Tibt\"."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        script_name: Optional[Union[str, "_models.ScriptKind"]] = None,
        script_iso15924_code: Optional[Union[str, "_models.ScriptCode"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentError(_Model):
    """Contains details of errors encountered during a job execution.

    :ivar id: The ID of the input document. Required.
    :vartype id: str
    :ivar error: Error encountered. Required.
    :vartype error: ~azure.ai.textanalytics.models.AnalyzeTextError
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the input document. Required."""
    error: "_models.AnalyzeTextError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error encountered. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        error: "_models.AnalyzeTextError",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentStatistics(_Model):
    """if showStats=true was specified in the request this field will contain information about the
    document payload.

    :ivar characters_count: Number of text elements recognized in the document. Required.
    :vartype characters_count: int
    :ivar transactions_count: Number of transactions for the document. Required.
    :vartype transactions_count: int
    """

    characters_count: int = rest_field(
        name="charactersCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of text elements recognized in the document. Required."""
    transactions_count: int = rest_field(
        name="transactionsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of transactions for the document. Required."""

    @overload
    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DocumentWarning(_Model):
    """Contains the warnings object with warnings encountered for the processed document.

    :ivar code: Warning code. Required. Known values are: "LongWordsInDocument" and
     "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.models.WarningCode
    :ivar message: Warning message. Required.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    code: Union[str, "_models.WarningCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warning code. Required. Known values are: \"LongWordsInDocument\" and \"DocumentTruncated\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warning message. Required."""
    target_ref: Optional[str] = rest_field(name="targetRef", visibility=["read", "create", "update", "delete", "query"])
    """A JSON pointer reference indicating the target object."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.WarningCode"],
        message: str,
        target_ref: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntitiesActionContent(_Model):
    """Supported parameters for an Entity Recognition task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar string_index_type: (Optional) parameter to provide the string index type used to
     interpret string offsets. Defaults to TextElements (Graphemes). Known values are:
     "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    :ivar inclusions: (Optional) request parameter that limits the output to the requested entity
     types included in this list. We will apply inclusionList before exclusionList.
    :vartype inclusions: list[str or ~azure.ai.textanalytics.models.EntityCategory]
    :ivar exclusions: (Optional) request parameter that filters out any entities that are included
     the excludeList. When a user specifies an excludeList, they cannot get a prediction returned
     with an entity in that list. We will apply inclusionList before exclusionList.
    :vartype exclusions: list[str or ~azure.ai.textanalytics.models.EntityCategory]
    :ivar overlap_policy: (Optional) describes the type of overlap policy to apply to the ner
     output.
    :vartype overlap_policy: ~azure.ai.textanalytics.models.EntityOverlapPolicy
    :ivar inference_options: (Optional) request parameter that allows the user to provide settings
     for running the inference.
    :vartype inference_options: ~azure.ai.textanalytics.models.EntityInferenceConfig
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) parameter to provide the string index type used to interpret string offsets.
     Defaults to TextElements (Graphemes). Known values are: \"TextElements_v8\",
     \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""
    inclusions: Optional[list[Union[str, "_models.EntityCategory"]]] = rest_field(
        name="inclusionList", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) request parameter that limits the output to the requested entity types included in
     this list. We will apply inclusionList before exclusionList."""
    exclusions: Optional[list[Union[str, "_models.EntityCategory"]]] = rest_field(
        name="exclusionList", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) request parameter that filters out any entities that are included the excludeList.
     When a user specifies an excludeList, they cannot get a prediction returned with an entity in
     that list. We will apply inclusionList before exclusionList."""
    overlap_policy: Optional["_models.EntityOverlapPolicy"] = rest_field(
        name="overlapPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) describes the type of overlap policy to apply to the ner output."""
    inference_options: Optional["_models.EntityInferenceConfig"] = rest_field(
        name="inferenceOptions", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) request parameter that allows the user to provide settings for running the
     inference."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        inclusions: Optional[list[Union[str, "_models.EntityCategory"]]] = None,
        exclusions: Optional[list[Union[str, "_models.EntityCategory"]]] = None,
        overlap_policy: Optional["_models.EntityOverlapPolicy"] = None,
        inference_options: Optional["_models.EntityInferenceConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntitiesLROTask(AnalyzeTextOperationAction, discriminator="EntityRecognition"):
    """An object representing the task definition for an Entities Recognition task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: The kind of task. Required. Entity recognition task
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_RECOGNITION
    :ivar parameters: Task parameters.
    :vartype parameters: ~azure.ai.textanalytics.models.EntitiesActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.ENTITY_RECOGNITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of task. Required. Entity recognition task"""
    parameters: Optional["_models.EntitiesActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.EntitiesActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.ENTITY_RECOGNITION, **kwargs)


class EntitiesResult(_Model):
    """Contains the entity recognition task result.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.EntityActionResultWithMetadata]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.EntityActionResultWithMetadata"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.EntityActionResultWithMetadata"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntitiesWithMetadataAutoResult(_Model):
    """Contains the entity recognition task result.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.EntityActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.EntityActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.EntityActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityActionResult(_Model):
    """Contains the entity recognition task result for the document with metadata and detected
    language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.NamedEntityWithMetadata]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    entities: list["_models.NamedEntityWithMetadata"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Recognized entities in the document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        entities: list["_models.NamedEntityWithMetadata"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityActionResultWithMetadata(_Model):
    """Entity documents result with metadata.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.NamedEntityWithMetadata]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    entities: list["_models.NamedEntityWithMetadata"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Recognized entities in the document. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        entities: list["_models.NamedEntityWithMetadata"],
        statistics: Optional["_models.DocumentStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityInferenceConfig(_Model):
    """The class that houses the inference options allowed for named entity recognition.

    :ivar exclude_normalized_values: Option to include/exclude the detected entity values to be
     normalized and included in the metadata. The numeric and temporal entity types support value
     normalization.
    :vartype exclude_normalized_values: bool
    """

    exclude_normalized_values: Optional[bool] = rest_field(
        name="excludeNormalizedValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """Option to include/exclude the detected entity values to be normalized and included in the
     metadata. The numeric and temporal entity types support value normalization."""

    @overload
    def __init__(
        self,
        *,
        exclude_normalized_values: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityLinkingActionContent(_Model):
    """Supported parameters for an Entity Linking task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar string_index_type: Optional parameter to provide the string index type used to interpret
     string offsets. Defaults to TextElements (Graphemes). Known values are: "TextElements_v8",
     "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional parameter to provide the string index type used to interpret string offsets. Defaults
     to TextElements (Graphemes). Known values are: \"TextElements_v8\", \"UnicodeCodePoint\", and
     \"Utf16CodeUnit\"."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityLinkingActionResult(_Model):
    """Entity linking document result with auto language detection.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar entities: Recognized well known entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.LinkedEntity]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    entities: list["_models.LinkedEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Recognized well known entities in the document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        entities: list["_models.LinkedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityLinkingLROTask(AnalyzeTextOperationAction, discriminator="EntityLinking"):
    """Contains the analyze text Entity linking LRO task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of task result. Required. Entity linking task
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_LINKING
    :ivar parameters: Task parameters.
    :vartype parameters: ~azure.ai.textanalytics.models.EntityLinkingActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.ENTITY_LINKING] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of task result. Required. Entity linking task"""
    parameters: Optional["_models.EntityLinkingActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.EntityLinkingActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.ENTITY_LINKING, **kwargs)


class EntityLinkingMatch(_Model):
    """The Match object containing the detected entity text with the offset and the length.

    :ivar confidence_score: If a well known item is recognized, a decimal number denoting the
     confidence level between 0 and 1 will be returned. Required.
    :vartype confidence_score: float
    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar offset: Start position for the entity match text. Required.
    :vartype offset: int
    :ivar length: Length for the entity match text. Required.
    :vartype length: int
    """

    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """If a well known item is recognized, a decimal number denoting the confidence level between 0
     and 1 will be returned. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity match text. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity match text. Required."""

    @overload
    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityLinkingOperationResult(AnalyzeTextLROResult, discriminator="EntityLinkingLROResults"):
    """Contains the analyze text Entity linking task LRO result.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Entity linking LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_LINKING_OPERATION_RESULTS
    :ivar results: Entity linking result. Required.
    :vartype results: ~azure.ai.textanalytics.models.EntityLinkingResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.ENTITY_LINKING_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Entity linking LRO results"""
    results: "_models.EntityLinkingResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity linking result. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.EntityLinkingResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.ENTITY_LINKING_OPERATION_RESULTS, **kwargs)


class EntityLinkingResult(_Model):
    """Entity linking result.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.EntityLinkingActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.EntityLinkingActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.EntityLinkingActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityMaskPolicyType(BaseRedactionPolicy, discriminator="entityMask"):
    """Represents the policy of redacting PII with the entity type.

    :ivar policy_kind: The entity OverlapPolicy object kind. Required. Redact detected entities
     with entity type.
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.ENTITY_MASK
    """

    policy_kind: Literal[RedactionPolicyKind.ENTITY_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity OverlapPolicy object kind. Required. Redact detected entities with entity type."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.ENTITY_MASK, **kwargs)


class EntityRecognitionOperationResult(AnalyzeTextLROResult, discriminator="EntityRecognitionLROResults"):
    """Contains the entity recognition job task result.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Entity recognition LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_RECOGNITION_OPERATION_RESULTS
    :ivar results: Results for the task. Required.
    :vartype results: ~azure.ai.textanalytics.models.EntitiesResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.ENTITY_RECOGNITION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Entity recognition LRO results"""
    results: "_models.EntitiesResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Results for the task. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.EntitiesResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.ENTITY_RECOGNITION_OPERATION_RESULTS, **kwargs)


class EntitySynonym(_Model):
    """The entity synonyms used to enhance pii entity detection.

    :ivar synonym: The synonym to be used for context. Required.
    :vartype synonym: str
    :ivar language: The 2 letter ISO 639-1 language the synonym.
    :vartype language: str
    """

    synonym: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The synonym to be used for context. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The 2 letter ISO 639-1 language the synonym."""

    @overload
    def __init__(
        self,
        *,
        synonym: str,
        language: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntitySynonyms(_Model):
    """Object that allows the user to provide synonyms for context words that to enhance pii entity
    detection.

    :ivar entity_type: The entity name. Required. Known values are: "Address", "Numeric", "Age",
     "Currency", "Number", "NumberRange", "Percentage", "Ordinal", "Temperature", "Dimension",
     "Length", "Weight", "Height", "Speed", "Area", "Volume", "Information", "Temporal", "Date",
     "Time", "DateTime", "DateRange", "TimeRange", "DateTimeRange", "Duration", "SetTemporal",
     "Event", "SportsEvent", "CulturalEvent", "NaturalEvent", "Location", "GPE", "City", "State",
     "CountryRegion", "Continent", "Structural", "Airport", "Geological", "Organization",
     "OrganizationMedical", "OrganizationStockExchange", "OrganizationSports", "Person",
     "PersonType", "Email", "URL", "IP", "PhoneNumber", "Product", "ComputingProduct", and "Skill".
    :vartype entity_type: str or ~azure.ai.textanalytics.models.EntityCategory
    :ivar synonyms: The entity synonyms. Required.
    :vartype synonyms: list[~azure.ai.textanalytics.models.EntitySynonym]
    """

    entity_type: Union[str, "_models.EntityCategory"] = rest_field(
        name="entityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The entity name. Required. Known values are: \"Address\", \"Numeric\", \"Age\", \"Currency\",
     \"Number\", \"NumberRange\", \"Percentage\", \"Ordinal\", \"Temperature\", \"Dimension\",
     \"Length\", \"Weight\", \"Height\", \"Speed\", \"Area\", \"Volume\", \"Information\",
     \"Temporal\", \"Date\", \"Time\", \"DateTime\", \"DateRange\", \"TimeRange\",
     \"DateTimeRange\", \"Duration\", \"SetTemporal\", \"Event\", \"SportsEvent\",
     \"CulturalEvent\", \"NaturalEvent\", \"Location\", \"GPE\", \"City\", \"State\",
     \"CountryRegion\", \"Continent\", \"Structural\", \"Airport\", \"Geological\",
     \"Organization\", \"OrganizationMedical\", \"OrganizationStockExchange\",
     \"OrganizationSports\", \"Person\", \"PersonType\", \"Email\", \"URL\", \"IP\",
     \"PhoneNumber\", \"Product\", \"ComputingProduct\", and \"Skill\"."""
    synonyms: list["_models.EntitySynonym"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity synonyms. Required."""

    @overload
    def __init__(
        self,
        *,
        entity_type: Union[str, "_models.EntityCategory"],
        synonyms: list["_models.EntitySynonym"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntityTag(_Model):
    """Entity tag object which contains the name of the tags abd any associated confidence score.
    Entity Tags are used to express some similarities/affinity between entities.

    :ivar name: Name of the tag. Entity Tag names will be unique globally. Required.
    :vartype name: str
    :ivar confidence_score: Detection score between 0 and 1 of the extracted entity.
    :vartype confidence_score: float
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the tag. Entity Tag names will be unique globally. Required."""
    confidence_score: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Detection score between 0 and 1 of the extracted entity."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        confidence_score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorResponse(_Model):
    """Error response.

    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.textanalytics.models.AnalyzeTextError
    """

    error: "_models.AnalyzeTextError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object. Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.AnalyzeTextError",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtractedSummaryActionResult(_Model):
    """A ranked list of sentences representing the extracted summary.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar sentences: Specifies the the extracted sentences from the input document. Required.
    :vartype sentences: list[~azure.ai.textanalytics.models.ExtractedSummarySentence]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    sentences: list["_models.ExtractedSummarySentence"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the the extracted sentences from the input document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        sentences: list["_models.ExtractedSummarySentence"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtractedSummarySentence(_Model):
    """Represents an extracted sentences from the input document.

    :ivar text: The extracted sentence text. Required.
    :vartype text: str
    :ivar rank_score: A double value representing the relevance of the sentence within the summary.
     Higher values indicate higher importance. Required.
    :vartype rank_score: float
    :ivar offset: The sentence offset from the start of the document, based on the value of the
     parameter StringIndexType. Required.
    :vartype offset: int
    :ivar length: The length of the sentence. Required.
    :vartype length: int
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The extracted sentence text. Required."""
    rank_score: float = rest_field(name="rankScore", visibility=["read", "create", "update", "delete", "query"])
    """A double value representing the relevance of the sentence within the summary. Higher values
     indicate higher importance. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sentence offset from the start of the document, based on the value of the parameter
     StringIndexType. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the sentence. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        rank_score: float,
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtractiveSummarizationActionContent(_Model):
    """Supported parameters for an Extractive Summarization task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar sentence_count: Specifies the number of sentences in the extracted summary.
    :vartype sentence_count: int
    :ivar sort_by: Specifies how to sort the extracted summaries. Known values are: "Offset" and
     "Rank".
    :vartype sort_by: str or ~azure.ai.textanalytics.models.ExtractiveSummarizationSortingCriteria
    :ivar string_index_type: Specifies the method used to interpret string offsets. Known values
     are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    :ivar query: (Optional) If provided, the query will be used to extract most relevant sentences
     from the document.
    :vartype query: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    sentence_count: Optional[int] = rest_field(
        name="sentenceCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the number of sentences in the extracted summary."""
    sort_by: Optional[Union[str, "_models.ExtractiveSummarizationSortingCriteria"]] = rest_field(
        name="sortBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies how to sort the extracted summaries. Known values are: \"Offset\" and \"Rank\"."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets. Known values are: \"TextElements_v8\",
     \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""
    query: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) If provided, the query will be used to extract most relevant sentences from the
     document."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        sentence_count: Optional[int] = None,
        sort_by: Optional[Union[str, "_models.ExtractiveSummarizationSortingCriteria"]] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        query: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ExtractiveSummarizationOperationAction(AnalyzeTextOperationAction, discriminator="ExtractiveSummarization"):
    """An object representing the task definition for an Extractive Summarization task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: The Extractive Summarization kind of the long running task. Required. Extractive
     summarization task
    :vartype kind: str or ~azure.ai.textanalytics.models.EXTRACTIVE_SUMMARIZATION
    :ivar action_content: Parameters for the Extractive Summarization task.
    :vartype action_content: ~azure.ai.textanalytics.models.ExtractiveSummarizationActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.EXTRACTIVE_SUMMARIZATION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Extractive Summarization kind of the long running task. Required. Extractive summarization
     task"""
    action_content: Optional["_models.ExtractiveSummarizationActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for the Extractive Summarization task."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        action_content: Optional["_models.ExtractiveSummarizationActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.EXTRACTIVE_SUMMARIZATION, **kwargs)


class ExtractiveSummarizationOperationResult(AnalyzeTextLROResult, discriminator="ExtractiveSummarizationLROResults"):
    """An object representing the results for an Extractive Summarization task.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Extractive summarization LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.EXTRACTIVE_SUMMARIZATION_OPERATION_RESULTS
    :ivar results: Results of the task. Required.
    :vartype results: ~azure.ai.textanalytics.models.ExtractiveSummarizationResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.EXTRACTIVE_SUMMARIZATION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Extractive summarization LRO results"""
    results: "_models.ExtractiveSummarizationResult" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Results of the task. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.ExtractiveSummarizationResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(
            *args, kind=AnalyzeTextOperationResultsKind.EXTRACTIVE_SUMMARIZATION_OPERATION_RESULTS, **kwargs
        )


class ExtractiveSummarizationResult(_Model):
    """An object representing the pre-built Extractive Summarization results of each document.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.ExtractedSummaryActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.ExtractedSummaryActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.ExtractedSummaryActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FhirBundle(_Model):
    """JSON bundle containing a FHIR compatible object for consumption in other Healthcare tools. For
    additional information see `https://www.hl7.org/fhir/overview.html
    <https://www.hl7.org/fhir/overview.html>`_.

    """


class HealthcareActionResult(_Model):
    """Result object for the processed Healthcare document with detected language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar entities: Healthcare entities. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.HealthcareEntity]
    :ivar relations: Healthcare entity relations. Required.
    :vartype relations: list[~azure.ai.textanalytics.models.HealthcareRelation]
    :ivar fhir_bundle: JSON bundle containing a FHIR compatible object for consumption in other
     Healthcare tools. For additional information see `https://www.hl7.org/fhir/overview.html
     <https://www.hl7.org/fhir/overview.html>`_.
    :vartype fhir_bundle: ~azure.ai.textanalytics.models.FhirBundle
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    entities: list["_models.HealthcareEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Healthcare entities. Required."""
    relations: list["_models.HealthcareRelation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Healthcare entity relations. Required."""
    fhir_bundle: Optional["_models.FhirBundle"] = rest_field(
        name="fhirBundle", visibility=["read", "create", "update", "delete", "query"]
    )
    """JSON bundle containing a FHIR compatible object for consumption in other Healthcare tools. For
     additional information see `https://www.hl7.org/fhir/overview.html
     <https://www.hl7.org/fhir/overview.html>`_."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        entities: list["_models.HealthcareEntity"],
        relations: list["_models.HealthcareRelation"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        fhir_bundle: Optional["_models.FhirBundle"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareAssertion(_Model):
    """Assertion of the entity.

    :ivar conditionality: Describes any conditionality on the entity. Known values are:
     "hypothetical" and "conditional".
    :vartype conditionality: str or
     ~azure.ai.textanalytics.models.HealthcareAssertionConditionality
    :ivar certainty: Describes the entities certainty and polarity. Known values are: "positive",
     "positivePossible", "neutralPossible", "negativePossible", and "negative".
    :vartype certainty: str or ~azure.ai.textanalytics.models.HealthcareAssertionCertainty
    :ivar association: Describes if the entity is the subject of the text or if it describes
     someone else. Known values are: "subject" and "other".
    :vartype association: str or ~azure.ai.textanalytics.models.HealthcareAssertionAssociation
    :ivar temporality: Describes temporal information regarding the entity. Known values are:
     "current", "past", and "future".
    :vartype temporality: str or ~azure.ai.textanalytics.models.HealthcareAssertionTemporality
    """

    conditionality: Optional[Union[str, "_models.HealthcareAssertionConditionality"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes any conditionality on the entity. Known values are: \"hypothetical\" and
     \"conditional\"."""
    certainty: Optional[Union[str, "_models.HealthcareAssertionCertainty"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes the entities certainty and polarity. Known values are: \"positive\",
     \"positivePossible\", \"neutralPossible\", \"negativePossible\", and \"negative\"."""
    association: Optional[Union[str, "_models.HealthcareAssertionAssociation"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes if the entity is the subject of the text or if it describes someone else. Known
     values are: \"subject\" and \"other\"."""
    temporality: Optional[Union[str, "_models.HealthcareAssertionTemporality"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Describes temporal information regarding the entity. Known values are: \"current\", \"past\",
     and \"future\"."""

    @overload
    def __init__(
        self,
        *,
        conditionality: Optional[Union[str, "_models.HealthcareAssertionConditionality"]] = None,
        certainty: Optional[Union[str, "_models.HealthcareAssertionCertainty"]] = None,
        association: Optional[Union[str, "_models.HealthcareAssertionAssociation"]] = None,
        temporality: Optional[Union[str, "_models.HealthcareAssertionTemporality"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareEntity(_Model):
    """Healthcare entity extracted from the document.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Healthcare Entity Category. Required. Known values are: "BodyStructure", "Age",
     "Gender", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
     "MeasurementUnit", "RelationalOperator", "Time", "GeneOrProtein", "Variant",
     "AdministrativeEvent", "CareEnvironment", "HealthcareProfession", "Diagnosis", "SymptomOrSign",
     "ConditionQualifier", "MedicationClass", "MedicationName", "Dosage", "MedicationForm",
     "MedicationRoute", "FamilyRelation", "TreatmentName", "Ethnicity", "Course", "Expression",
     "MutationType", "ConditionScale", "Allergen", "Employment", "LivingStatus", "SubstanceUse", and
     "SubstanceUseAmount".
    :vartype category: str or ~azure.ai.textanalytics.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    :ivar assertion: Assertion of the entity.
    :vartype assertion: ~azure.ai.textanalytics.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.models.HealthcareEntityLink]
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    category: Union[str, "_models.HealthcareEntityCategory"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Healthcare Entity Category. Required. Known values are: \"BodyStructure\", \"Age\", \"Gender\",
     \"ExaminationName\", \"Date\", \"Direction\", \"Frequency\", \"MeasurementValue\",
     \"MeasurementUnit\", \"RelationalOperator\", \"Time\", \"GeneOrProtein\", \"Variant\",
     \"AdministrativeEvent\", \"CareEnvironment\", \"HealthcareProfession\", \"Diagnosis\",
     \"SymptomOrSign\", \"ConditionQualifier\", \"MedicationClass\", \"MedicationName\", \"Dosage\",
     \"MedicationForm\", \"MedicationRoute\", \"FamilyRelation\", \"TreatmentName\", \"Ethnicity\",
     \"Course\", \"Expression\", \"MutationType\", \"ConditionScale\", \"Allergen\", \"Employment\",
     \"LivingStatus\", \"SubstanceUse\", and \"SubstanceUseAmount\"."""
    subcategory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) Entity sub type."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text. Use of different 'stringIndexType' values can affect the
     offset returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted entity. Required."""
    assertion: Optional["_models.HealthcareAssertion"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Assertion of the entity."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Preferred name for the entity. Example: 'histologically' would have a 'name' of 'histologic'."""
    links: Optional[list["_models.HealthcareEntityLink"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Entity references in known data sources."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        category: Union[str, "_models.HealthcareEntityCategory"],
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        assertion: Optional["_models.HealthcareAssertion"] = None,
        name: Optional[str] = None,
        links: Optional[list["_models.HealthcareEntityLink"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareEntityLink(_Model):
    """Reference to an entity in known data sources.

    :ivar data_source: Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required.
    :vartype data_source: str
    :ivar id: Entity id in the given source catalog. Required.
    :vartype id: str
    """

    data_source: str = rest_field(name="dataSource", visibility=["read", "create", "update", "delete", "query"])
    """Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity id in the given source catalog. Required."""

    @overload
    def __init__(
        self,
        *,
        data_source: str,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareLROResult(AnalyzeTextLROResult, discriminator="HealthcareLROResults"):
    """Healthcare Analyze Text long tunning operation result object.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Healthcare LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.HEALTHCARE_OPERATION_RESULTS
    :ivar results: Results of the task. Required.
    :vartype results: ~azure.ai.textanalytics.models.HealthcareResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.HEALTHCARE_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Healthcare LRO results"""
    results: "_models.HealthcareResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Results of the task. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.HealthcareResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.HEALTHCARE_OPERATION_RESULTS, **kwargs)


class HealthcareLROTask(AnalyzeTextOperationAction, discriminator="Healthcare"):
    """The long running task to be performed by the service on the Healthcare input documents.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Healthcare kind of the long running task. Required. Healthcare task
    :vartype kind: str or ~azure.ai.textanalytics.models.HEALTHCARE
    :ivar parameters: Parameters for the Healthcare task.
    :vartype parameters: ~azure.ai.textanalytics.models.HealthcareTaskParameters
    """

    kind: Literal[AnalyzeTextOperationActionKind.HEALTHCARE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Healthcare kind of the long running task. Required. Healthcare task"""
    parameters: Optional["_models.HealthcareTaskParameters"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for the Healthcare task."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.HealthcareTaskParameters"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.HEALTHCARE, **kwargs)


class HealthcareRelation(_Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected
    and have specific roles within the relation context.

    :ivar relation_type: Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Required. Known values are: "Abbreviation",
     "DirectionOfBodyStructure", "DirectionOfCondition", "DirectionOfExamination",
     "DirectionOfTreatment", "DosageOfMedication", "FormOfMedication", "FrequencyOfMedication",
     "FrequencyOfTreatment", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
     "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication", "TimeOfTreatment",
     "UnitOfCondition", "UnitOfExamination", "ValueOfCondition", "ValueOfExamination",
     "BodySiteOfCondition", "BodySiteOfTreatment", "CourseOfCondition", "CourseOfExamination",
     "CourseOfMedication", "CourseOfTreatment", "ExaminationFindsCondition", "ExpressionOfGene",
     "ExpressionOfVariant", "FrequencyOfCondition", "MutationTypeOfGene", "MutationTypeOfVariant",
     "ScaleOfCondition", and "VariantOfGene".
    :vartype relation_type: str or ~azure.ai.textanalytics.models.RelationType
    :ivar entities: The entities in the relation. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.HealthcareRelationEntity]
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted relation.
    :vartype confidence_score: float
    """

    relation_type: Union[str, "_models.RelationType"] = rest_field(
        name="relationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of relation. Examples include: ``DosageOfMedication`` or 'FrequencyOfMedication', etc.
     Required. Known values are: \"Abbreviation\", \"DirectionOfBodyStructure\",
     \"DirectionOfCondition\", \"DirectionOfExamination\", \"DirectionOfTreatment\",
     \"DosageOfMedication\", \"FormOfMedication\", \"FrequencyOfMedication\",
     \"FrequencyOfTreatment\", \"QualifierOfCondition\", \"RelationOfExamination\",
     \"RouteOfMedication\", \"TimeOfCondition\", \"TimeOfEvent\", \"TimeOfExamination\",
     \"TimeOfMedication\", \"TimeOfTreatment\", \"UnitOfCondition\", \"UnitOfExamination\",
     \"ValueOfCondition\", \"ValueOfExamination\", \"BodySiteOfCondition\", \"BodySiteOfTreatment\",
     \"CourseOfCondition\", \"CourseOfExamination\", \"CourseOfMedication\", \"CourseOfTreatment\",
     \"ExaminationFindsCondition\", \"ExpressionOfGene\", \"ExpressionOfVariant\",
     \"FrequencyOfCondition\", \"MutationTypeOfGene\", \"MutationTypeOfVariant\",
     \"ScaleOfCondition\", and \"VariantOfGene\"."""
    entities: list["_models.HealthcareRelationEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The entities in the relation. Required."""
    confidence_score: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted relation."""

    @overload
    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.RelationType"],
        entities: list["_models.HealthcareRelationEntity"],
        confidence_score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareRelationEntity(_Model):
    """Entity in the relation.

    :ivar ref: Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier
     Representation), pointing to the entity . Required.
    :vartype ref: str
    :ivar role: Role of entity in the relationship. For example: 'CD20-positive diffuse large
     B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis). Required.
    :vartype role: str
    """

    ref: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier Representation),
     pointing to the entity . Required."""
    role: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Role of entity in the relationship. For example: 'CD20-positive diffuse large B-cell lymphoma'
     has the following entities with their roles in parenthesis:  CD20 (GeneOrProtein), Positive
     (Expression), diffuse large B-cell lymphoma (Diagnosis). Required."""

    @overload
    def __init__(
        self,
        *,
        ref: str,
        role: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareResult(_Model):
    """Result object for the processed Healthcare task.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: List of result objects for the processed Healthcare documents. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.HealthcareActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.HealthcareActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of result objects for the processed Healthcare documents. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.HealthcareActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class HealthcareTaskParameters(_Model):
    """Supported parameters for a Healthcare task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets. Known values
     are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    :ivar fhir_version: The FHIR Spec version that the result will use to format the fhirBundle.
     For additional information see `https://www.hl7.org/fhir/overview.html
     <https://www.hl7.org/fhir/overview.html>`_. "4.0.1"
    :vartype fhir_version: str or ~azure.ai.textanalytics.models.FhirVersion
    :ivar document_type: Document type that can be provided as input for Fhir Documents. Expect to
     have fhirVersion provided when used. Behavior of using None enum is the same as not using the
     documentType parameter. Known values are: "None", "ClinicalTrial", "DischargeSummary",
     "ProgressNote", "HistoryAndPhysical", "Consult", "Imaging", "Pathology", and "ProcedureNote".
    :vartype document_type: str or ~azure.ai.textanalytics.models.HealthcareDocumentType
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets. Known values are: \"TextElements_v8\",
     \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""
    fhir_version: Optional[Union[str, "_models.FhirVersion"]] = rest_field(
        name="fhirVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The FHIR Spec version that the result will use to format the fhirBundle. For additional
     information see `https://www.hl7.org/fhir/overview.html
     <https://www.hl7.org/fhir/overview.html>`_. \"4.0.1\""""
    document_type: Optional[Union[str, "_models.HealthcareDocumentType"]] = rest_field(
        name="documentType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Document type that can be provided as input for Fhir Documents. Expect to have fhirVersion
     provided when used. Behavior of using None enum is the same as not using the documentType
     parameter. Known values are: \"None\", \"ClinicalTrial\", \"DischargeSummary\",
     \"ProgressNote\", \"HistoryAndPhysical\", \"Consult\", \"Imaging\", \"Pathology\", and
     \"ProcedureNote\"."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        fhir_version: Optional[Union[str, "_models.FhirVersion"]] = None,
        document_type: Optional[Union[str, "_models.HealthcareDocumentType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InformationMetadata(BaseMetadata, discriminator="InformationMetadata"):
    """Represents the Information (data) entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for information-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.INFORMATION_METADATA
    :ivar unit: Unit of measure for information. Required. Known values are: "Unspecified", "Bit",
     "Kilobit", "Megabit", "Gigabit", "Terabit", "Petabit", "Byte", "Kilobyte", "Megabyte",
     "Gigabyte", "Terabyte", and "Petabyte".
    :vartype unit: str or ~azure.ai.textanalytics.models.InformationUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.INFORMATION_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for information-related values."""
    unit: Union[str, "_models.InformationUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for information. Required. Known values are: \"Unspecified\", \"Bit\",
     \"Kilobit\", \"Megabit\", \"Gigabit\", \"Terabit\", \"Petabit\", \"Byte\", \"Kilobyte\",
     \"Megabyte\", \"Gigabyte\", \"Terabyte\", and \"Petabyte\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.InformationUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.INFORMATION_METADATA, **kwargs)


class InnerErrorModel(_Model):
    """An object containing more specific information about the error. As per Microsoft One API
    guidelines -
    `https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses
    <https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses>`_.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.models.InnerErrorCode
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.models.InnerErrorModel
    """

    code: Union[str, "_models.InnerErrorCode"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """One of a server-defined set of error codes. Required. Known values are: \"InvalidRequest\",
     \"InvalidParameterValue\", \"KnowledgeBaseNotFound\", \"AzureCognitiveSearchNotFound\",
     \"AzureCognitiveSearchThrottling\", \"ExtractionFailure\", \"InvalidRequestBodyFormat\",
     \"EmptyRequest\", \"MissingInputDocuments\", \"InvalidDocument\", \"ModelVersionIncorrect\",
     \"InvalidDocumentBatch\", \"UnsupportedLanguageCode\", and \"InvalidCountryHint\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message. Required."""
    details: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error details."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error target."""
    innererror: Optional["_models.InnerErrorModel"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """An object containing more specific information than the current object about the error."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyPhraseActionContent(_Model):
    """Supported parameters for a Key Phrase Extraction task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyPhraseExtractionOperationResult(AnalyzeTextLROResult, discriminator="KeyPhraseExtractionLROResults"):
    """Contains the analyze text KeyPhraseExtraction LRO task.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Key phrase extraction LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.KEY_PHRASE_EXTRACTION_OPERATION_RESULTS
    :ivar results: The list of Key phrase extraction results. Required.
    :vartype results: ~azure.ai.textanalytics.models.KeyPhraseResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.KEY_PHRASE_EXTRACTION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Key phrase extraction LRO results"""
    results: "_models.KeyPhraseResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of Key phrase extraction results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.KeyPhraseResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.KEY_PHRASE_EXTRACTION_OPERATION_RESULTS, **kwargs)


class KeyPhraseLROTask(AnalyzeTextOperationAction, discriminator="KeyPhraseExtraction"):
    """An object representing the task definition for a Key Phrase Extraction task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of the task. Required. Key phrase extraction task
    :vartype kind: str or ~azure.ai.textanalytics.models.KEY_PHRASE_EXTRACTION
    :ivar parameters: Key phrase extraction task parameters.
    :vartype parameters: ~azure.ai.textanalytics.models.KeyPhraseActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.KEY_PHRASE_EXTRACTION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Key phrase extraction task"""
    parameters: Optional["_models.KeyPhraseActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Key phrase extraction task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.KeyPhraseActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.KEY_PHRASE_EXTRACTION, **kwargs)


class KeyPhraseResult(_Model):
    """Contains the KeyPhraseResult.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.KeyPhrasesActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.KeyPhrasesActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.KeyPhrasesActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class KeyPhrasesActionResult(_Model):
    """A ranked list of sentences representing the extracted summary.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar key_phrases: A list of representative words or phrases. The number of key phrases
     returned is proportional to the number of words in the input document. Required.
    :vartype key_phrases: list[str]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    key_phrases: list[str] = rest_field(name="keyPhrases", visibility=["read", "create", "update", "delete", "query"])
    """A list of representative words or phrases. The number of key phrases returned is proportional
     to the number of words in the input document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        key_phrases: list[str],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageDetectionActionContent(_Model):
    """Supported parameters for a Language Detection task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageDetectionDocumentResult(_Model):
    """Contains the language detection for a document.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar detected_language: Detected Language. Required.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    detected_language: "_models.DetectedLanguage" = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """Detected Language. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        detected_language: "_models.DetectedLanguage",
        statistics: Optional["_models.DocumentStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageDetectionResult(_Model):
    """Contains the language detection result for the request.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Enumeration of language detection results for each input document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.LanguageDetectionDocumentResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.LanguageDetectionDocumentResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of language detection results for each input document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.LanguageDetectionDocumentResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageDetectionTextInput(_Model):
    """Contains the language detection document analysis input.

    :ivar language_inputs: List of documents to be analyzed.
    :vartype language_inputs: list[~azure.ai.textanalytics.models.LanguageInput]
    """

    language_inputs: Optional[list["_models.LanguageInput"]] = rest_field(
        name="documents", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of documents to be analyzed."""

    @overload
    def __init__(
        self,
        *,
        language_inputs: Optional[list["_models.LanguageInput"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LanguageInput(_Model):
    """Contains the language detection input.

    :ivar id: A unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: The input text to process. Required.
    :vartype text: str
    :ivar country_hint: The country hint to help with language detection of the text.
    :vartype country_hint: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A unique, non-empty document identifier. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The input text to process. Required."""
    country_hint: Optional[str] = rest_field(
        name="countryHint", visibility=["read", "create", "update", "delete", "query"]
    )
    """The country hint to help with language detection of the text."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        country_hint: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class LengthMetadata(BaseMetadata, discriminator="LengthMetadata"):
    """Represents the Length entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for length-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.LENGTH_METADATA
    :ivar unit: Unit of measure for length. Required. Known values are: "Unspecified", "Kilometer",
     "Hectometer", "Decameter", "Meter", "Decimeter", "Centimeter", "Millimeter", "Micrometer",
     "Nanometer", "Picometer", "Mile", "Yard", "Inch", "Foot", "LightYear", and "Point".
    :vartype unit: str or ~azure.ai.textanalytics.models.LengthUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.LENGTH_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for length-related values."""
    unit: Union[str, "_models.LengthUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for length. Required. Known values are: \"Unspecified\", \"Kilometer\",
     \"Hectometer\", \"Decameter\", \"Meter\", \"Decimeter\", \"Centimeter\", \"Millimeter\",
     \"Micrometer\", \"Nanometer\", \"Picometer\", \"Mile\", \"Yard\", \"Inch\", \"Foot\",
     \"LightYear\", and \"Point\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.LengthUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.LENGTH_METADATA, **kwargs)


class LinkedEntity(_Model):
    """The LinkedEntity object containing the detected entity with the associated sources/links.

    :ivar name: Entity Linking formal name. Required.
    :vartype name: str
    :ivar matches: List of instances this entity appears in the text. Required.
    :vartype matches: list[~azure.ai.textanalytics.models.EntityLinkingMatch]
    :ivar language: Language used in the data source. Required.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: URL for the entity's page from the data source. Required.
    :vartype url: str
    :ivar data_source: Data source used to extract entity linking, such as Wiki/Bing etc. Required.
    :vartype data_source: str
    :ivar bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :vartype bing_id: str
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity Linking formal name. Required."""
    matches: list["_models.EntityLinkingMatch"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of instances this entity appears in the text. Required."""
    language: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Language used in the data source. Required."""
    id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier of the recognized entity from the data source."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL for the entity's page from the data source. Required."""
    data_source: str = rest_field(name="dataSource", visibility=["read", "create", "update", "delete", "query"])
    """Data source used to extract entity linking, such as Wiki/Bing etc. Required."""
    bing_id: Optional[str] = rest_field(name="bingId", visibility=["read", "create", "update", "delete", "query"])
    """Bing Entity Search API unique identifier of the recognized entity."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        matches: list["_models.EntityLinkingMatch"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        bing_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MatchLongestEntityPolicyType(EntityOverlapPolicy, discriminator="matchLongest"):
    """Represents the Match longest overlap policy. No overlapping entities as far as it is possible.
    1. If there are overlapping entities, the longest one will be returned. 2. If the set of
    characters predicted for 2 or more entities are exactly the same, select the entity that has
    the higher confidence score.3. If the entity scores are identical, return all entities that are
    still present after applying the previous rules. 3. If there is partial overlap (as in Hello
    Text Analytics) follow the above steps starting from 1.

    :ivar policy_kind: The entity OverlapPolicy object kind. Required. Represents
     MatchLongestEntityPolicyType
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.MATCH_LONGEST
    """

    policy_kind: Literal[PolicyKind.MATCH_LONGEST] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity OverlapPolicy object kind. Required. Represents MatchLongestEntityPolicyType"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=PolicyKind.MATCH_LONGEST, **kwargs)


class MultiLanguageInput(_Model):
    """Contains an input document to be analyzed by the service.

    :ivar id: A unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: The input text to process. Required.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use \\"en\\" for English; \\"es\\" for Spanish etc. If not set, use \\"en\\" for
     English as default. (Following only applies to 2023-04-15-preview and above) For Auto Language
     Detection, use \\"auto\\". If not set, use \\"en\\" for English as default.
    :vartype language: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A unique, non-empty document identifier. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The input text to process. Required."""
    language: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) This is the 2 letter ISO 639-1 representation of a language. For example, use
     \\"en\\" for English; \\"es\\" for Spanish etc. If not set, use \\"en\\" for English as
     default. (Following only applies to 2023-04-15-preview and above) For Auto Language Detection,
     use \\"auto\\". If not set, use \\"en\\" for English as default."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        language: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MultiLanguageTextInput(_Model):
    """Collection of input documents to be analyzed by the service.

    :ivar multi_language_inputs: The input documents to be analyzed.
    :vartype multi_language_inputs: list[~azure.ai.textanalytics.models.MultiLanguageInput]
    """

    multi_language_inputs: Optional[list["_models.MultiLanguageInput"]] = rest_field(
        name="documents", visibility=["read", "create", "update", "delete", "query"]
    )
    """The input documents to be analyzed."""

    @overload
    def __init__(
        self,
        *,
        multi_language_inputs: Optional[list["_models.MultiLanguageInput"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NamedEntity(_Model):
    """Defines the detected entity object containing the entity category and entity text detected,
    etc.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity type. Required."""
    subcategory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) Entity sub type."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text. Use of different 'stringIndexType' values can affect the
     offset returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted entity. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NamedEntityWithMetadata(_Model):
    """Entity object with tags and metadata.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    :ivar type: An entity type is the lowest (or finest) granularity at which the entity has been
     detected. The type maps to the specific metadata attributes associated with the entity
     detected.
    :vartype type: str
    :ivar tags: List of entity tags. Tags are to express some similarities/affinity between
     entities.
    :vartype tags: list[~azure.ai.textanalytics.models.EntityTag]
    :ivar metadata: The entity metadata object.
    :vartype metadata: ~azure.ai.textanalytics.models.BaseMetadata
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity type. Required."""
    subcategory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) Entity sub type."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text. Use of different 'stringIndexType' values can affect the
     offset returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted entity. Required."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An entity type is the lowest (or finest) granularity at which the entity has been detected. The
     type maps to the specific metadata attributes associated with the entity detected."""
    tags: Optional[list["_models.EntityTag"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of entity tags. Tags are to express some similarities/affinity between entities."""
    metadata: Optional["_models.BaseMetadata"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The entity metadata object."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        type: Optional[str] = None,
        tags: Optional[list["_models.EntityTag"]] = None,
        metadata: Optional["_models.BaseMetadata"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class NoMaskPolicyType(BaseRedactionPolicy, discriminator="noMask"):
    """Represents the policy of not redacting found PII.

    :ivar policy_kind: The entity RedactionPolicy object kind. Required. Do not redact detected
     entities.
    :vartype policy_kind: str or ~azure.ai.textanalytics.models.NO_MASK
    """

    policy_kind: Literal[RedactionPolicyKind.NO_MASK] = rest_discriminator(name="policyKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The entity RedactionPolicy object kind. Required. Do not redact detected entities."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, policy_kind=RedactionPolicyKind.NO_MASK, **kwargs)


class NumberMetadata(BaseMetadata, discriminator="NumberMetadata"):
    """A metadata for numeric entity instances.

    :ivar metadata_kind: Kind of the metadata. Required. Metadata for numeric values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.NUMBER_METADATA
    :ivar number_kind: Kind of the number type. Required. Known values are: "Integer", "Decimal",
     "Power", "Fraction", "Percent", and "Unspecified".
    :vartype number_kind: str or ~azure.ai.textanalytics.models.NumberKind
    :ivar value: A numeric representation of what the extracted text denotes. Required.
    :vartype value: float
    """

    metadata_kind: Literal[MetadataKind.NUMBER_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for numeric values."""
    number_kind: Union[str, "_models.NumberKind"] = rest_field(
        name="numberKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kind of the number type. Required. Known values are: \"Integer\", \"Decimal\", \"Power\",
     \"Fraction\", \"Percent\", and \"Unspecified\"."""
    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A numeric representation of what the extracted text denotes. Required."""

    @overload
    def __init__(
        self,
        *,
        number_kind: Union[str, "_models.NumberKind"],
        value: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.NUMBER_METADATA, **kwargs)


class NumericRangeMetadata(BaseMetadata, discriminator="NumericRangeMetadata"):
    """represents the Metadata of numeric intervals.

    :ivar metadata_kind: Kind of the metadata. Required. Metadata for numeric range values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.NUMERIC_RANGE_METADATA
    :ivar range_kind: Kind of numeric ranges supported - like Number, Speed, etc. Required. Known
     values are: "Number", "Speed", "Weight", "Length", "Volume", "Area", "Age", "Information",
     "Temperature", and "Currency".
    :vartype range_kind: str or ~azure.ai.textanalytics.models.RangeKind
    :ivar minimum: The beginning value of  the interval. Required.
    :vartype minimum: float
    :ivar maximum: The ending value of the interval. Required.
    :vartype maximum: float
    :ivar range_inclusivity: The inclusiveness of this range. Known values are: "NoneInclusive",
     "LeftInclusive", "RightInclusive", and "LeftRightInclusive".
    :vartype range_inclusivity: str or ~azure.ai.textanalytics.models.RangeInclusivity
    """

    metadata_kind: Literal[MetadataKind.NUMERIC_RANGE_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for numeric range values."""
    range_kind: Union[str, "_models.RangeKind"] = rest_field(
        name="rangeKind", visibility=["read", "create", "update", "delete", "query"]
    )
    """Kind of numeric ranges supported - like Number, Speed, etc. Required. Known values are:
     \"Number\", \"Speed\", \"Weight\", \"Length\", \"Volume\", \"Area\", \"Age\", \"Information\",
     \"Temperature\", and \"Currency\"."""
    minimum: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The beginning value of  the interval. Required."""
    maximum: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ending value of the interval. Required."""
    range_inclusivity: Optional[Union[str, "_models.RangeInclusivity"]] = rest_field(
        name="rangeInclusivity", visibility=["read", "create", "update", "delete", "query"]
    )
    """The inclusiveness of this range. Known values are: \"NoneInclusive\", \"LeftInclusive\",
     \"RightInclusive\", and \"LeftRightInclusive\"."""

    @overload
    def __init__(
        self,
        *,
        range_kind: Union[str, "_models.RangeKind"],
        minimum: float,
        maximum: float,
        range_inclusivity: Optional[Union[str, "_models.RangeInclusivity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.NUMERIC_RANGE_METADATA, **kwargs)


class OrdinalMetadata(BaseMetadata, discriminator="OrdinalMetadata"):
    """A metadata for numeric entity instances.

    :ivar metadata_kind: Kind of the metadata. Required. Metadata for ordinal numbers.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.ORDINAL_METADATA
    :ivar offset: The offset with respect to the reference (e.g., offset = -1 indicates the second
     to last). Required.
    :vartype offset: str
    :ivar relative_to: The reference point that the ordinal number denotes. Required. Known values
     are: "Current", "End", and "Start".
    :vartype relative_to: str or ~azure.ai.textanalytics.models.RelativeTo
    :ivar value: A simple arithmetic expression that the ordinal denotes. Required.
    :vartype value: str
    """

    metadata_kind: Literal[MetadataKind.ORDINAL_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for ordinal numbers."""
    offset: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offset with respect to the reference (e.g., offset = -1 indicates the second to last).
     Required."""
    relative_to: Union[str, "_models.RelativeTo"] = rest_field(
        name="relativeTo", visibility=["read", "create", "update", "delete", "query"]
    )
    """The reference point that the ordinal number denotes. Required. Known values are: \"Current\",
     \"End\", and \"Start\"."""
    value: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A simple arithmetic expression that the ordinal denotes. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: str,
        relative_to: Union[str, "_models.RelativeTo"],
        value: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.ORDINAL_METADATA, **kwargs)


class PiiActionContent(_Model):
    """Supported parameters for a PII Entities Recognition task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar domain: Domain for PII task. Known values are: "phi" and "none".
    :vartype domain: str or ~azure.ai.textanalytics.models.PiiDomain
    :ivar pii_categories: Enumeration of PII categories to be returned in the response.
    :vartype pii_categories: list[str or ~azure.ai.textanalytics.models.PiiCategory]
    :ivar string_index_type: StringIndexType to be used for analysis. Known values are:
     "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    :ivar exclude_pii_categories: Enumeration of PII categories to be excluded in the response.
    :vartype exclude_pii_categories: list[str or
     ~azure.ai.textanalytics.models.PiiCategoriesExclude]
    :ivar redaction_policy: RedactionPolicy to be used on the input.
    :vartype redaction_policy: ~azure.ai.textanalytics.models.BaseRedactionPolicy
    :ivar value_exclusion_policy: Policy for specific words and terms that should be excluded from
     detection by the PII detection service.
    :vartype value_exclusion_policy: ~azure.ai.textanalytics.models.ValueExclusionPolicy
    :ivar entity_synonyms: (Optional) request parameter that allows the user to provide synonyms
     for context words that to enhance pii entity detection.
    :vartype entity_synonyms: list[~azure.ai.textanalytics.models.EntitySynonyms]
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    domain: Optional[Union[str, "_models.PiiDomain"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Domain for PII task. Known values are: \"phi\" and \"none\"."""
    pii_categories: Optional[list[Union[str, "_models.PiiCategory"]]] = rest_field(
        name="piiCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of PII categories to be returned in the response."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """StringIndexType to be used for analysis. Known values are: \"TextElements_v8\",
     \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""
    exclude_pii_categories: Optional[list[Union[str, "_models.PiiCategoriesExclude"]]] = rest_field(
        name="excludePiiCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumeration of PII categories to be excluded in the response."""
    redaction_policy: Optional["_models.BaseRedactionPolicy"] = rest_field(
        name="redactionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """RedactionPolicy to be used on the input."""
    value_exclusion_policy: Optional["_models.ValueExclusionPolicy"] = rest_field(
        name="valueExclusionPolicy", visibility=["read", "create", "update", "delete", "query"]
    )
    """Policy for specific words and terms that should be excluded from detection by the PII detection
     service."""
    entity_synonyms: Optional[list["_models.EntitySynonyms"]] = rest_field(
        name="entitySynonyms", visibility=["read", "create", "update", "delete", "query"]
    )
    """(Optional) request parameter that allows the user to provide synonyms for context words that to
     enhance pii entity detection."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        domain: Optional[Union[str, "_models.PiiDomain"]] = None,
        pii_categories: Optional[list[Union[str, "_models.PiiCategory"]]] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        exclude_pii_categories: Optional[list[Union[str, "_models.PiiCategoriesExclude"]]] = None,
        redaction_policy: Optional["_models.BaseRedactionPolicy"] = None,
        value_exclusion_policy: Optional["_models.ValueExclusionPolicy"] = None,
        entity_synonyms: Optional[list["_models.EntitySynonyms"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PiiEntity(_Model):
    """Entity object with tags.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    :ivar type: An entity type is the lowest (or finest) granularity at which the entity has been
     detected. The type maps to the specific metadata attributes associated with the entity
     detected.
    :vartype type: str
    :ivar tags: List of entity tags. Tags are to express some similarities/affinity between
     entities.
    :vartype tags: list[~azure.ai.textanalytics.models.EntityTag]
    :ivar mask: Optional field which will be returned only when using the redaction policy kind
     “MaskWithEntityType”.  This field will contain the exact mask text used to mask the PII entity
     in the original text.
    :vartype mask: str
    :ivar mask_offset: Start position of masked text in the redacted text when using the redaction
     policy kind “MaskWithEntityType”.
    :vartype mask_offset: int
    :ivar mask_length: The length of the masked text. Will be present when using the redaction
     policy kind “MaskWithEntityType”.
    :vartype mask_length: int
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity text as appears in the request. Required."""
    category: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Entity type. Required."""
    subcategory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Optional) Entity sub type."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the entity text. Use of different 'stringIndexType' values can affect the
     offset returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length for the entity text. Use of different 'stringIndexType' values can affect the length
     returned. Required."""
    confidence_score: float = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score between 0 and 1 of the extracted entity. Required."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An entity type is the lowest (or finest) granularity at which the entity has been detected. The
     type maps to the specific metadata attributes associated with the entity detected."""
    tags: Optional[list["_models.EntityTag"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of entity tags. Tags are to express some similarities/affinity between entities."""
    mask: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional field which will be returned only when using the redaction policy kind
     “MaskWithEntityType”.  This field will contain the exact mask text used to mask the PII entity
     in the original text."""
    mask_offset: Optional[int] = rest_field(
        name="maskOffset", visibility=["read", "create", "update", "delete", "query"]
    )
    """Start position of masked text in the redacted text when using the redaction policy kind
     “MaskWithEntityType”."""
    mask_length: Optional[int] = rest_field(
        name="maskLength", visibility=["read", "create", "update", "delete", "query"]
    )
    """The length of the masked text. Will be present when using the redaction policy kind
     “MaskWithEntityType”."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        type: Optional[str] = None,
        tags: Optional[list["_models.EntityTag"]] = None,
        mask: Optional[str] = None,
        mask_offset: Optional[int] = None,
        mask_length: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PiiEntityRecognitionOperationResult(AnalyzeTextLROResult, discriminator="PiiEntityRecognitionLROResults"):
    """Contains the PII LRO results.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: The kind of the task. Required. PII entity recognition LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.PII_ENTITY_RECOGNITION_OPERATION_RESULTS
    :ivar results: The list of pii results. Required.
    :vartype results: ~azure.ai.textanalytics.models.PiiResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.PII_ENTITY_RECOGNITION_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of the task. Required. PII entity recognition LRO results"""
    results: "_models.PiiResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The list of pii results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.PiiResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.PII_ENTITY_RECOGNITION_OPERATION_RESULTS, **kwargs)


class PiiLROTask(AnalyzeTextOperationAction, discriminator="PiiEntityRecognition"):
    """Contains the analyze text PIIEntityRecognition LRO task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: Kind of the task. Required. PII entity recognition task
    :vartype kind: str or ~azure.ai.textanalytics.models.PII_ENTITY_RECOGNITION
    :ivar parameters: Pii task parameters.
    :vartype parameters: ~azure.ai.textanalytics.models.PiiActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.PII_ENTITY_RECOGNITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. PII entity recognition task"""
    parameters: Optional["_models.PiiActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Pii task parameters."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.PiiActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.PII_ENTITY_RECOGNITION, **kwargs)


class PiiResult(_Model):
    """Contains the PiiResult.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.PiiResultWithDetectedLanguage]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.PiiResultWithDetectedLanguage"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Response by document. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.PiiResultWithDetectedLanguage"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PiiResultWithDetectedLanguage(_Model):
    """Contains the PII results with detected language.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar redacted_text: Returns redacted text. Required.
    :vartype redacted_text: str
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.models.PiiEntity]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    redacted_text: str = rest_field(name="redactedText", visibility=["read", "create", "update", "delete", "query"])
    """Returns redacted text. Required."""
    entities: list["_models.PiiEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Recognized entities in the document. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        redacted_text: str,
        entities: list["_models.PiiEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RequestStatistics(_Model):
    """if showStats=true was specified in the request this field will contain information about the
    request payload.

    :ivar documents_count: Number of documents submitted in the request. Required.
    :vartype documents_count: int
    :ivar valid_documents_count: Number of valid documents. This excludes empty, over-size limit or
     non-supported languages documents. Required.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Number of invalid documents. This includes empty, over-size
     limit or non-supported languages documents. Required.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Number of transactions for the request. Required.
    :vartype transactions_count: int
    """

    documents_count: int = rest_field(name="documentsCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents submitted in the request. Required."""
    valid_documents_count: int = rest_field(
        name="validDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of valid documents. This excludes empty, over-size limit or non-supported languages
     documents. Required."""
    erroneous_documents_count: int = rest_field(
        name="erroneousDocumentsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of invalid documents. This includes empty, over-size limit or non-supported languages
     documents. Required."""
    transactions_count: int = rest_field(
        name="transactionsCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Number of transactions for the request. Required."""

    @overload
    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentenceAssessment(_Model):
    """Represents a sentence assessment and the assessments or target objects related to it.

    :ivar sentiment: The sentiment of the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.models.TokenSentiment
    :ivar confidence_scores: Represents the confidence scores across all sentiment classes:
     positive and negative. Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.models.TargetConfidenceScoreLabel
    :ivar offset: The target offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the target. Required.
    :vartype length: int
    :ivar text: The target text detected. Required.
    :vartype text: str
    :ivar is_negated: The indicator representing if the assessment is negated. Required.
    :vartype is_negated: bool
    """

    sentiment: Union[str, "_models.TokenSentiment"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment of the sentence. Required. Known values are: \"positive\", \"mixed\", and
     \"negative\"."""
    confidence_scores: "_models.TargetConfidenceScoreLabel" = rest_field(
        name="confidenceScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the confidence scores across all sentiment classes: positive and negative. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target offset from the start of the sentence. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the target. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target text detected. Required."""
    is_negated: bool = rest_field(name="isNegated", visibility=["read", "create", "update", "delete", "query"])
    """The indicator representing if the assessment is negated. Required."""

    @overload
    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentiment"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        is_negated: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentenceSentiment(_Model):
    """A document's sentence sentiment.

    :ivar text: The sentence text. Required.
    :vartype text: str
    :ivar sentiment: The predicted Sentiment for the sentence. Required. Known values are:
     "positive", "neutral", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.models.SentenceSentimentValue
    :ivar confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
     all classes. Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.models.SentimentConfidenceScores
    :ivar offset: The target offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the target. Required.
    :vartype length: int
    :ivar targets: The array of sentence targets for the sentence.
    :vartype targets: list[~azure.ai.textanalytics.models.SentenceTarget]
    :ivar assessments: The array of assessments for the sentence.
    :vartype assessments: list[~azure.ai.textanalytics.models.SentenceAssessment]
    """

    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sentence text. Required."""
    sentiment: Union[str, "_models.SentenceSentimentValue"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The predicted Sentiment for the sentence. Required. Known values are: \"positive\",
     \"neutral\", and \"negative\"."""
    confidence_scores: "_models.SentimentConfidenceScores" = rest_field(
        name="confidenceScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment confidence score between 0 and 1 for the sentence for all classes. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target offset from the start of the sentence. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the target. Required."""
    targets: Optional[list["_models.SentenceTarget"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The array of sentence targets for the sentence."""
    assessments: Optional[list["_models.SentenceAssessment"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The array of assessments for the sentence."""

    @overload
    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "_models.SentenceSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScores",
        offset: int,
        length: int,
        targets: Optional[list["_models.SentenceTarget"]] = None,
        assessments: Optional[list["_models.SentenceAssessment"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentenceTarget(_Model):
    """Represents a sentence target and the assessments or target objects related to it.

    :ivar sentiment: The sentiment of the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.models.TokenSentiment
    :ivar confidence_scores: Represents the confidence scores across all sentiment classes:
     positive and negative. Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.models.TargetConfidenceScoreLabel
    :ivar offset: The target offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the target. Required.
    :vartype length: int
    :ivar text: The target text detected. Required.
    :vartype text: str
    :ivar relations: The array of either assessment or target objects which is related to the
     target. Required.
    :vartype relations: list[~azure.ai.textanalytics.models.TargetRelation]
    """

    sentiment: Union[str, "_models.TokenSentiment"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment of the sentence. Required. Known values are: \"positive\", \"mixed\", and
     \"negative\"."""
    confidence_scores: "_models.TargetConfidenceScoreLabel" = rest_field(
        name="confidenceScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """Represents the confidence scores across all sentiment classes: positive and negative. Required."""
    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target offset from the start of the sentence. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the target. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target text detected. Required."""
    relations: list["_models.TargetRelation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The array of either assessment or target objects which is related to the target. Required."""

    @overload
    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentiment"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        relations: list["_models.TargetRelation"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentActionResult(_Model):
    """Sentiment analysis per document.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.models.DocumentStatistics
    :ivar sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     Required. Known values are: "positive", "neutral", "negative", and "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.models.DocumentSentiment
    :ivar confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
     all classes. Required.
    :vartype confidence_scores: ~azure.ai.textanalytics.models.SentimentConfidenceScores
    :ivar sentences: The document's sentences sentiment. Required.
    :vartype sentences: list[~azure.ai.textanalytics.models.SentenceSentiment]
    :ivar detected_language: If 'language' is set to 'auto' for the document in the request this
     field will contain a 2 letter ISO 639-1 representation of the language detected for this
     document.
    :vartype detected_language: ~azure.ai.textanalytics.models.DetectedLanguage
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique, non-empty document identifier. Required."""
    warnings: list["_models.DocumentWarning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Warnings encountered while processing document. Required."""
    statistics: Optional["_models.DocumentStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     document payload."""
    sentiment: Union[str, "_models.DocumentSentiment"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Predicted sentiment for document (Negative, Neutral, Positive, or Mixed). Required. Known
     values are: \"positive\", \"neutral\", \"negative\", and \"mixed\"."""
    confidence_scores: "_models.SentimentConfidenceScores" = rest_field(
        name="confidenceScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment confidence score between 0 and 1 for the sentence for all classes. Required."""
    sentences: list["_models.SentenceSentiment"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The document's sentences sentiment. Required."""
    detected_language: Optional["_models.DetectedLanguage"] = rest_field(
        name="detectedLanguage", visibility=["read", "create", "update", "delete", "query"]
    )
    """If 'language' is set to 'auto' for the document in the request this field will contain a 2
     letter ISO 639-1 representation of the language detected for this document."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: list["_models.DocumentWarning"],
        sentiment: Union[str, "_models.DocumentSentiment"],
        confidence_scores: "_models.SentimentConfidenceScores",
        sentences: list["_models.SentenceSentiment"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        detected_language: Optional["_models.DetectedLanguage"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentAnalysisActionContent(_Model):
    """Supported parameters for a Sentiment Analysis task.

    :ivar logging_opt_out: logging opt out.
    :vartype logging_opt_out: bool
    :ivar model_version: model version.
    :vartype model_version: str
    :ivar opinion_mining: Whether to use opinion mining in the request or not.
    :vartype opinion_mining: bool
    :ivar string_index_type: Specifies the method used to interpret string offsets. Known values
     are: "TextElements_v8", "UnicodeCodePoint", and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.models.StringIndexType
    """

    logging_opt_out: Optional[bool] = rest_field(
        name="loggingOptOut", visibility=["read", "create", "update", "delete", "query"]
    )
    """logging opt out."""
    model_version: Optional[str] = rest_field(
        name="modelVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """model version."""
    opinion_mining: Optional[bool] = rest_field(
        name="opinionMining", visibility=["read", "create", "update", "delete", "query"]
    )
    """Whether to use opinion mining in the request or not."""
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = rest_field(
        name="stringIndexType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the method used to interpret string offsets. Known values are: \"TextElements_v8\",
     \"UnicodeCodePoint\", and \"Utf16CodeUnit\"."""

    @overload
    def __init__(
        self,
        *,
        logging_opt_out: Optional[bool] = None,
        model_version: Optional[str] = None,
        opinion_mining: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentAnalysisOperationAction(AnalyzeTextOperationAction, discriminator="SentimentAnalysis"):
    """An object representing the task definition for a Sentiment Analysis task.

    :ivar name: task name.
    :vartype name: str
    :ivar kind: The Sentiment Analysis kind of the long running task. Required. Sentiment analysis
     task
    :vartype kind: str or ~azure.ai.textanalytics.models.SENTIMENT_ANALYSIS
    :ivar parameters: Parameters for the Sentiment Analysis task.
    :vartype parameters: ~azure.ai.textanalytics.models.SentimentAnalysisActionContent
    """

    kind: Literal[AnalyzeTextOperationActionKind.SENTIMENT_ANALYSIS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The Sentiment Analysis kind of the long running task. Required. Sentiment analysis task"""
    parameters: Optional["_models.SentimentAnalysisActionContent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Parameters for the Sentiment Analysis task."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        parameters: Optional["_models.SentimentAnalysisActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationActionKind.SENTIMENT_ANALYSIS, **kwargs)


class SentimentConfidenceScores(_Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive,
    neutral, negative.

    :ivar positive: Confidence score for positive sentiment. Required.
    :vartype positive: float
    :ivar neutral: Confidence score for neutral sentiment. Required.
    :vartype neutral: float
    :ivar negative: Confidence score for negative sentiment. Required.
    :vartype negative: float
    """

    positive: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence score for positive sentiment. Required."""
    neutral: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence score for neutral sentiment. Required."""
    negative: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence score for negative sentiment. Required."""

    @overload
    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SentimentLROResult(AnalyzeTextLROResult, discriminator="SentimentAnalysisLROResults"):
    """Contains the Sentiment Analysis LRO results.

    :ivar last_update_date_time: The last updated time in UTC for the task. Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: The status of the task at the mentioned last update time. Required. Known values
     are: "notStarted", "running", "succeeded", "partiallyCompleted", "failed", "cancelled", and
     "cancelling".
    :vartype status: str or ~azure.ai.textanalytics.models.TextActionState
    :ivar task_name: task name.
    :vartype task_name: str
    :ivar kind: Kind of the task. Required. Sentiment analysis LRO results
    :vartype kind: str or ~azure.ai.textanalytics.models.SENTIMENT_ANALYSIS_OPERATION_RESULTS
    :ivar results: The sentiment analysis results. Required.
    :vartype results: ~azure.ai.textanalytics.models.SentimentResult
    """

    kind: Literal[AnalyzeTextOperationResultsKind.SENTIMENT_ANALYSIS_OPERATION_RESULTS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Sentiment analysis LRO results"""
    results: "_models.SentimentResult" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sentiment analysis results. Required."""

    @overload
    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.TextActionState"],
        results: "_models.SentimentResult",
        task_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextOperationResultsKind.SENTIMENT_ANALYSIS_OPERATION_RESULTS, **kwargs)


class SentimentResult(_Model):
    """Sentiment analysis results for the input documents.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: The sentiment analysis results for each document in the input. Required.
    :vartype documents: list[~azure.ai.textanalytics.models.SentimentActionResult]
    """

    errors: list["_models.DocumentError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Errors by document id. Required."""
    statistics: Optional["_models.RequestStatistics"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """if showStats=true was specified in the request this field will contain information about the
     request payload."""
    model_version: str = rest_field(name="modelVersion", visibility=["read", "create", "update", "delete", "query"])
    """This field indicates which model is used for scoring. Required."""
    documents: list["_models.SentimentActionResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sentiment analysis results for each document in the input. Required."""

    @overload
    def __init__(
        self,
        *,
        errors: list["_models.DocumentError"],
        model_version: str,
        documents: list["_models.SentimentActionResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SpeedMetadata(BaseMetadata, discriminator="SpeedMetadata"):
    """Represents the Speed entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for speed-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.SPEED_METADATA
    :ivar unit: Unit of measure for speed. Required. Known values are: "Unspecified",
     "MetersPerSecond", "KilometersPerHour", "KilometersPerMinute", "KilometersPerSecond",
     "MilesPerHour", "Knots", "FeetPerSecond", "FeetPerMinute", "YardsPerMinute", "YardsPerSecond",
     "MetersPerMillisecond", "CentimetersPerMillisecond", and "KilometersPerMillisecond".
    :vartype unit: str or ~azure.ai.textanalytics.models.SpeedUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.SPEED_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for speed-related values."""
    unit: Union[str, "_models.SpeedUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for speed. Required. Known values are: \"Unspecified\", \"MetersPerSecond\",
     \"KilometersPerHour\", \"KilometersPerMinute\", \"KilometersPerSecond\", \"MilesPerHour\",
     \"Knots\", \"FeetPerSecond\", \"FeetPerMinute\", \"YardsPerMinute\", \"YardsPerSecond\",
     \"MetersPerMillisecond\", \"CentimetersPerMillisecond\", and \"KilometersPerMillisecond\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.SpeedUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.SPEED_METADATA, **kwargs)


class SummaryContext(_Model):
    """The context of the summary.

    :ivar offset: Start position for the context. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: The length of the context. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    """

    offset: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start position for the context. Use of different 'stringIndexType' values can affect the offset
     returned. Required."""
    length: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The length of the context. Use of different 'stringIndexType' values can affect the length
     returned. Required."""

    @overload
    def __init__(
        self,
        *,
        offset: int,
        length: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetConfidenceScoreLabel(_Model):
    """Represents the confidence scores across all sentiment classes: positive and negative.

    :ivar positive: Confidence score for positive sentiment. Required.
    :vartype positive: float
    :ivar negative: Confidence score for negative sentiment. Required.
    :vartype negative: float
    """

    positive: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence score for positive sentiment. Required."""
    negative: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Confidence score for negative sentiment. Required."""

    @overload
    def __init__(
        self,
        *,
        positive: float,
        negative: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetRelation(_Model):
    """Represents the relation between assessments and/or targets.

    :ivar ref: The JSON pointer indicating the linked object. Required.
    :vartype ref: str
    :ivar relation_type: The type related to the target. Required. Known values are: "assessment"
     and "target".
    :vartype relation_type: str or ~azure.ai.textanalytics.models.TargetRelationType
    """

    ref: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON pointer indicating the linked object. Required."""
    relation_type: Union[str, "_models.TargetRelationType"] = rest_field(
        name="relationType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type related to the target. Required. Known values are: \"assessment\" and \"target\"."""

    @overload
    def __init__(
        self,
        *,
        ref: str,
        relation_type: Union[str, "_models.TargetRelationType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TemperatureMetadata(BaseMetadata, discriminator="TemperatureMetadata"):
    """Represents the Information entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for temperature-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.TEMPERATURE_METADATA
    :ivar unit: Unit of measure for temperature. Required. Known values are: "Unspecified",
     "Fahrenheit", "Kelvin", "Rankine", and "Celsius".
    :vartype unit: str or ~azure.ai.textanalytics.models.TemperatureUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.TEMPERATURE_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for temperature-related values."""
    unit: Union[str, "_models.TemperatureUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for temperature. Required. Known values are: \"Unspecified\", \"Fahrenheit\",
     \"Kelvin\", \"Rankine\", and \"Celsius\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.TemperatureUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.TEMPERATURE_METADATA, **kwargs)


class TemporalSetMetadata(BaseMetadata, discriminator="TemporalSetMetadata"):
    """A Metadata for temporal set entity instances.

    :ivar dates: List of date values.
    :vartype dates: list[~azure.ai.textanalytics.models.DateValue]
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for set of time-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.TEMPORAL_SET_METADATA
    """

    dates: Optional[list["_models.DateValue"]] = rest_field(
        name="dateValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of date values."""
    metadata_kind: Literal[MetadataKind.TEMPORAL_SET_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for set of time-related values."""

    @overload
    def __init__(
        self,
        *,
        dates: Optional[list["_models.DateValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.TEMPORAL_SET_METADATA, **kwargs)


class TemporalSpanMetadata(BaseMetadata, discriminator="TemporalSpanMetadata"):
    """represents the Metadata of a date and/or time span.

    :ivar metadata_kind: Kind of the metadata. Required. Metadata for temporal span values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.TEMPORAL_SPAN_METADATA
    :ivar span_values: List of temporal spans detected.
    :vartype span_values: list[~azure.ai.textanalytics.models.TemporalSpanValues]
    """

    metadata_kind: Literal[MetadataKind.TEMPORAL_SPAN_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for temporal span values."""
    span_values: Optional[list["_models.TemporalSpanValues"]] = rest_field(
        name="spanValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of temporal spans detected."""

    @overload
    def __init__(
        self,
        *,
        span_values: Optional[list["_models.TemporalSpanValues"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.TEMPORAL_SPAN_METADATA, **kwargs)


class TemporalSpanValues(_Model):
    """Temporal span object.

    :ivar begin: Start value for the span.
    :vartype begin: str
    :ivar end: End value for the span.
    :vartype end: str
    :ivar duration: An optional duration value formatted based on the ISO 8601
     (`https://en.wikipedia.org/wiki/ISO_8601#Durations
     <https://en.wikipedia.org/wiki/ISO_8601#Durations>`_).
    :vartype duration: str
    :ivar modifier: Modifier for datetime to indicate point of reference like before, after etc.
     Known values are: "AfterApprox", "Before", "BeforeStart", "Approx", "ReferenceUndefined",
     "SinceEnd", "AfterMid", "Start", "After", "BeforeEnd", "Until", "End", "Less", "Since",
     "AfterStart", "BeforeApprox", "Mid", and "More".
    :vartype modifier: str or ~azure.ai.textanalytics.models.TemporalModifier
    :ivar timex: An optional triplet containing the beginning, the end, and the duration all stated
     as ISO 8601 formatted strings.
    :vartype timex: str
    """

    begin: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Start value for the span."""
    end: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """End value for the span."""
    duration: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional duration value formatted based on the ISO 8601
     (`https://en.wikipedia.org/wiki/ISO_8601#Durations
     <https://en.wikipedia.org/wiki/ISO_8601#Durations>`_)."""
    modifier: Optional[Union[str, "_models.TemporalModifier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Modifier for datetime to indicate point of reference like before, after etc. Known values are:
     \"AfterApprox\", \"Before\", \"BeforeStart\", \"Approx\", \"ReferenceUndefined\", \"SinceEnd\",
     \"AfterMid\", \"Start\", \"After\", \"BeforeEnd\", \"Until\", \"End\", \"Less\", \"Since\",
     \"AfterStart\", \"BeforeApprox\", \"Mid\", and \"More\"."""
    timex: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional triplet containing the beginning, the end, and the duration all stated as ISO 8601
     formatted strings."""

    @overload
    def __init__(
        self,
        *,
        begin: Optional[str] = None,
        end: Optional[str] = None,
        duration: Optional[str] = None,
        modifier: Optional[Union[str, "_models.TemporalModifier"]] = None,
        timex: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextActions(_Model):
    """Container for the tasks status for the LRO job.

    :ivar completed: Count of completed tasks. Required.
    :vartype completed: int
    :ivar failed: Count of failed tasks. Required.
    :vartype failed: int
    :ivar in_progress: Count of inprogress tasks. Required.
    :vartype in_progress: int
    :ivar total: Count of total tasks. Required.
    :vartype total: int
    :ivar items_property: Enumerable of Analyze text job results.
    :vartype items_property: list[~azure.ai.textanalytics.models.AnalyzeTextLROResult]
    """

    completed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of completed tasks. Required."""
    failed: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of failed tasks. Required."""
    in_progress: int = rest_field(name="inProgress", visibility=["read", "create", "update", "delete", "query"])
    """Count of inprogress tasks. Required."""
    total: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Count of total tasks. Required."""
    items_property: Optional[list["_models.AnalyzeTextLROResult"]] = rest_field(
        name="items", visibility=["read", "create", "update", "delete", "query"]
    )
    """Enumerable of Analyze text job results."""

    @overload
    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        items_property: Optional[list["_models.AnalyzeTextLROResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TextEntityLinkingInput(AnalyzeTextInput, discriminator="EntityLinking"):
    """Contains the analyze text Entity linking input.

    :ivar kind: Kind for Entity linking input. Required. Entity linking task
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_LINKING
    :ivar text_input: Contains the analysis input to be handled by the service.
    :vartype text_input: ~azure.ai.textanalytics.models.MultiLanguageTextInput
    :ivar action_content: Task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.EntityLinkingActionContent
    """

    kind: Literal[AnalyzeTextInputKind.ENTITY_LINKING] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind for Entity linking input. Required. Entity linking task"""
    text_input: Optional["_models.MultiLanguageTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the analysis input to be handled by the service."""
    action_content: Optional["_models.EntityLinkingActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.MultiLanguageTextInput"] = None,
        action_content: Optional["_models.EntityLinkingActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.ENTITY_LINKING, **kwargs)


class TextEntityRecognitionInput(AnalyzeTextInput, discriminator="EntityRecognition"):
    """The entity recognition analyze text input task request.

    :ivar kind: The kind of task. Required. Entity recognition task
    :vartype kind: str or ~azure.ai.textanalytics.models.ENTITY_RECOGNITION
    :ivar text_input: The input to be analyzed.
    :vartype text_input: ~azure.ai.textanalytics.models.MultiLanguageTextInput
    :ivar action_content: Task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.EntitiesActionContent
    """

    kind: Literal[AnalyzeTextInputKind.ENTITY_RECOGNITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of task. Required. Entity recognition task"""
    text_input: Optional["_models.MultiLanguageTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """The input to be analyzed."""
    action_content: Optional["_models.EntitiesActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.MultiLanguageTextInput"] = None,
        action_content: Optional["_models.EntitiesActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.ENTITY_RECOGNITION, **kwargs)


class TextKeyPhraseExtractionInput(AnalyzeTextInput, discriminator="KeyPhraseExtraction"):
    """Contains the analyze text KeyPhraseExtraction task input.

    :ivar kind: Kind of the task. Required. Key phrase extraction task
    :vartype kind: str or ~azure.ai.textanalytics.models.KEY_PHRASE_EXTRACTION
    :ivar text_input: Contains the input documents.
    :vartype text_input: ~azure.ai.textanalytics.models.MultiLanguageTextInput
    :ivar action_content: Key phrase extraction task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.KeyPhraseActionContent
    """

    kind: Literal[AnalyzeTextInputKind.KEY_PHRASE_EXTRACTION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Key phrase extraction task"""
    text_input: Optional["_models.MultiLanguageTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the input documents."""
    action_content: Optional["_models.KeyPhraseActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key phrase extraction task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.MultiLanguageTextInput"] = None,
        action_content: Optional["_models.KeyPhraseActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.KEY_PHRASE_EXTRACTION, **kwargs)


class TextLanguageDetectionInput(AnalyzeTextInput, discriminator="LanguageDetection"):
    """Contains the language detection document analysis task input.

    :ivar kind: Kind of the task. Required. Language detection task
    :vartype kind: str or ~azure.ai.textanalytics.models.LANGUAGE_DETECTION
    :ivar text_input: Documents to be analyzed.
    :vartype text_input: ~azure.ai.textanalytics.models.LanguageDetectionTextInput
    :ivar action_content: task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.LanguageDetectionActionContent
    """

    kind: Literal[AnalyzeTextInputKind.LANGUAGE_DETECTION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Language detection task"""
    text_input: Optional["_models.LanguageDetectionTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Documents to be analyzed."""
    action_content: Optional["_models.LanguageDetectionActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.LanguageDetectionTextInput"] = None,
        action_content: Optional["_models.LanguageDetectionActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.LANGUAGE_DETECTION, **kwargs)


class TextPiiEntitiesRecognitionInput(AnalyzeTextInput, discriminator="PiiEntityRecognition"):
    """Contains the analyze text PIIEntityRecognition task input.

    :ivar kind: Kind of the task. Required. PII entity recognition task
    :vartype kind: str or ~azure.ai.textanalytics.models.PII_ENTITY_RECOGNITION
    :ivar text_input: Contains the input documents.
    :vartype text_input: ~azure.ai.textanalytics.models.MultiLanguageTextInput
    :ivar action_content: Pii task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.PiiActionContent
    """

    kind: Literal[AnalyzeTextInputKind.PII_ENTITY_RECOGNITION] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. PII entity recognition task"""
    text_input: Optional["_models.MultiLanguageTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the input documents."""
    action_content: Optional["_models.PiiActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Pii task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.MultiLanguageTextInput"] = None,
        action_content: Optional["_models.PiiActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.PII_ENTITY_RECOGNITION, **kwargs)


class TextSentimentAnalysisInput(AnalyzeTextInput, discriminator="SentimentAnalysis"):
    """Contains the analyze text SentimentAnalysis task input.

    :ivar kind: Kind of the task. Required. Sentiment analysis task
    :vartype kind: str or ~azure.ai.textanalytics.models.SENTIMENT_ANALYSIS
    :ivar text_input: Contains the input documents.
    :vartype text_input: ~azure.ai.textanalytics.models.MultiLanguageTextInput
    :ivar action_content: Sentiment Analysis task parameters.
    :vartype action_content: ~azure.ai.textanalytics.models.SentimentAnalysisActionContent
    """

    kind: Literal[AnalyzeTextInputKind.SENTIMENT_ANALYSIS] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the task. Required. Sentiment analysis task"""
    text_input: Optional["_models.MultiLanguageTextInput"] = rest_field(
        name="analysisInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Contains the input documents."""
    action_content: Optional["_models.SentimentAnalysisActionContent"] = rest_field(
        name="parameters", visibility=["read", "create", "update", "delete", "query"]
    )
    """Sentiment Analysis task parameters."""

    @overload
    def __init__(
        self,
        *,
        text_input: Optional["_models.MultiLanguageTextInput"] = None,
        action_content: Optional["_models.SentimentAnalysisActionContent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, kind=AnalyzeTextInputKind.SENTIMENT_ANALYSIS, **kwargs)


class TimeMetadata(BaseMetadata, discriminator="TimeMetadata"):
    """A Metadata for time entity instances.

    :ivar dates: List of date values.
    :vartype dates: list[~azure.ai.textanalytics.models.DateValue]
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for time-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.TIME_METADATA
    """

    dates: Optional[list["_models.DateValue"]] = rest_field(
        name="dateValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of date values."""
    metadata_kind: Literal[MetadataKind.TIME_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for time-related values."""

    @overload
    def __init__(
        self,
        *,
        dates: Optional[list["_models.DateValue"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.TIME_METADATA, **kwargs)


class ValueExclusionPolicy(_Model):
    """Policy for specific words and terms that should be excluded from detection by the PII detection
    service.

    :ivar case_sensitive: Option to make the values excluded values case sensitive. Required.
    :vartype case_sensitive: bool
    :ivar excluded_values: List of words and terms that should be excluded from detection by the
     PII detection service. Required.
    :vartype excluded_values: list[str]
    """

    case_sensitive: bool = rest_field(name="caseSensitive", visibility=["read", "create", "update", "delete", "query"])
    """Option to make the values excluded values case sensitive. Required."""
    excluded_values: list[str] = rest_field(
        name="excludedValues", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of words and terms that should be excluded from detection by the PII detection service.
     Required."""

    @overload
    def __init__(
        self,
        *,
        case_sensitive: bool,
        excluded_values: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class VolumeMetadata(BaseMetadata, discriminator="VolumeMetadata"):
    """Represents the Volume entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for volume-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.VOLUME_METADATA
    :ivar unit: Unit of measure for volume. Required. Known values are: "Unspecified",
     "CubicMeter", "CubicCentimeter", "CubicMillimeter", "Hectoliter", "Decaliter", "Liter",
     "Centiliter", "Milliliter", "CubicYard", "CubicInch", "CubicFoot", "CubicMile", "FluidOunce",
     "Teaspoon", "Tablespoon", "Pint", "Quart", "Cup", "Gill", "Pinch", "FluidDram", "Barrel",
     "Minim", "Cord", "Peck", "Bushel", and "Hogshead".
    :vartype unit: str or ~azure.ai.textanalytics.models.VolumeUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.VOLUME_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for volume-related values."""
    unit: Union[str, "_models.VolumeUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for volume. Required. Known values are: \"Unspecified\", \"CubicMeter\",
     \"CubicCentimeter\", \"CubicMillimeter\", \"Hectoliter\", \"Decaliter\", \"Liter\",
     \"Centiliter\", \"Milliliter\", \"CubicYard\", \"CubicInch\", \"CubicFoot\", \"CubicMile\",
     \"FluidOunce\", \"Teaspoon\", \"Tablespoon\", \"Pint\", \"Quart\", \"Cup\", \"Gill\",
     \"Pinch\", \"FluidDram\", \"Barrel\", \"Minim\", \"Cord\", \"Peck\", \"Bushel\", and
     \"Hogshead\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.VolumeUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.VOLUME_METADATA, **kwargs)


class WeightMetadata(BaseMetadata, discriminator="WeightMetadata"):
    """Represents the Weight ) entity Metadata model.

    :ivar value: The numeric value that the extracted text denotes. Required.
    :vartype value: float
    :ivar metadata_kind: Kind of the metadata. Required. Metadata for weight-related values.
    :vartype metadata_kind: str or ~azure.ai.textanalytics.models.WEIGHT_METADATA
    :ivar unit: Unit of measure for weight. Required. Known values are: "Unspecified", "Kilogram",
     "Gram", "Milligram", "Gallon", "MetricTon", "Ton", "Pound", "Ounce", "Grain", "PennyWeight",
     "LongTonBritish", "ShortTonUS", "ShortHundredWeightUS", "Stone", and "Dram".
    :vartype unit: str or ~azure.ai.textanalytics.models.WeightUnit
    """

    value: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The numeric value that the extracted text denotes. Required."""
    metadata_kind: Literal[MetadataKind.WEIGHT_METADATA] = rest_discriminator(name="metadataKind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Kind of the metadata. Required. Metadata for weight-related values."""
    unit: Union[str, "_models.WeightUnit"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unit of measure for weight. Required. Known values are: \"Unspecified\", \"Kilogram\",
     \"Gram\", \"Milligram\", \"Gallon\", \"MetricTon\", \"Ton\", \"Pound\", \"Ounce\", \"Grain\",
     \"PennyWeight\", \"LongTonBritish\", \"ShortTonUS\", \"ShortHundredWeightUS\", \"Stone\", and
     \"Dram\"."""

    @overload
    def __init__(
        self,
        *,
        value: float,
        unit: Union[str, "_models.WeightUnit"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, metadata_kind=MetadataKind.WEIGHT_METADATA, **kwargs)
