/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;

public class PolygonFiller {
    MyGraphics G;
    ConstructionObject O;
    double C;
    double R;
    double C1;
    double R1;
    boolean HaveToFinish;
    public static int step = 5;
    public boolean Started;
    boolean Solid;
    double[] x;
    double[] y;
    int nx;

    public PolygonFiller(MyGraphics myGraphics, ConstructionObject constructionObject) {
        this.G = myGraphics;
        this.O = constructionObject;
        this.Started = false;
    }

    public void startPolygon(double d2, double d3) {
        this.C = d2;
        this.R = d3;
        this.HaveToFinish = false;
        this.nx = 0;
        this.Started = true;
        this.drawTo(d2, d3, false);
    }

    public void start() {
        this.nx = 0;
        this.Started = false;
    }

    public void drawTo(double d2, double d3) {
        this.drawTo(d2, d3, true);
    }

    public void drawTo(double d2, double d3, boolean bl) {
        if (!this.Started) {
            this.startPolygon(d2, d3);
            return;
        }
        if (!bl || (d2 - this.C) * (d2 - this.C) + (d3 - this.R) * (d3 - this.R) > (double)step) {
            if (this.x == null) {
                this.x = new double[1000];
                this.y = new double[1000];
                this.nx = 0;
            }
            if (this.nx >= this.x.length) {
                double[] dArray = new double[2 * this.x.length];
                double[] dArray2 = new double[2 * this.x.length];
                for (int i = 0; i < this.nx; ++i) {
                    dArray[i] = this.x[i];
                    dArray2[i] = this.y[i];
                }
                this.x = dArray;
                this.y = dArray2;
            }
            this.x[this.nx] = d2;
            this.y[this.nx++] = d3;
            this.C = d2;
            this.R = d3;
            this.HaveToFinish = false;
        } else {
            this.C1 = d2;
            this.R1 = d3;
            this.HaveToFinish = true;
        }
    }

    public void finishPolygon() {
        if (this.HaveToFinish) {
            this.drawTo(this.C1, this.R1, false);
            this.HaveToFinish = false;
        }
        this.G.fillPolygon(this.x, this.y, this.nx, false, true, this.O);
        this.Started = false;
    }

    public int length() {
        return this.nx;
    }

    public double x(int n) {
        return this.x[n];
    }

    public double y(int n) {
        return this.y[n];
    }

    public void setGraphics(MyGraphics myGraphics) {
        this.G = myGraphics;
    }
}

